#ifndef __FUSION_P_H__
#define __FUSION_P_H__
#include "monty.h"
#include "mosektask_p.h"
#include "list"
#include "vector"
#include "unordered_map"
#include "fusion.h"
namespace mosek
{
namespace fusion
{
// mosek.fusion.BaseModel from file 'src\fusion\cxx\BaseModel_p.h'
// namespace mosek::fusion
struct p_BaseModel
{
  p_BaseModel(BaseModel * _pubthis);

  void _initialize( monty::rc_ptr<BaseModel> m);
  void _initialize( const std::string & name,
                    const std::string & licpath);

  virtual ~p_BaseModel() { /* std::cout << "~p_BaseModel()" << std::endl;*/  }

  static p_BaseModel * _get_impl(Model * _inst) { return _inst->_impl; }

  //----------------------

  bool synched;
  std::string taskname;

  monty::rc_ptr<SolutionStruct> sol_itr;
  monty::rc_ptr<SolutionStruct> sol_itg;
  monty::rc_ptr<SolutionStruct> sol_bas;

  //---------------------

  std::unique_ptr<Task> task;

  //---------------------
  void task_setLogHandler (const msghandler_t & handler);
  void task_setDataCallbackHandler (const datacbhandler_t & handler);
  void task_setCallbackHandler (const cbhandler_t & handler);

  int alloc_rangedvar(const std::string & name, double lb, double ub);
  int alloc_linearvar(const std::string & name, mosek::fusion::RelationKey relkey, double bound);
  int task_append_barvar(int size, int num);

  void task_var_name   (int index, const std::string & name);
  void task_con_name   (int index, const std::string & name);
  void task_cone_name  (int index, const std::string & name);
  void task_barvar_name(int index, const std::string & name);
  void task_objectivename(         const std::string & name);

  void task_break_solve();

  //--------------------------

  int task_numvar();
  int task_numcon();
  int task_numcone();
  int task_numbarvar();

  //--------------------------

  void task_put_param(const std::string & name, const std::string & value);
  void task_put_param(const std::string & name, int    value);
  void task_put_param(const std::string & name, double value);
  
  double    task_get_dinf (const std::string & name);
  int       task_get_iinf (const std::string & name);
  long long task_get_liinf(const std::string & name);
  
  //--------------------------
  void task_con_putboundslice_fr(int first, int last); 
  void task_con_putboundslice_lo(int first, int last, const std::shared_ptr<monty::ndarray<double,1>> & rhs);
  void task_con_putboundslice_up(int first, int last, const std::shared_ptr<monty::ndarray<double,1>> & rhs);
  void task_con_putboundslice_ra(int first, int last, const std::shared_ptr<monty::ndarray<double,1>> & lb , 
                                                      const std::shared_ptr<monty::ndarray<double,1>> & ub );
  void task_con_putboundslice_fx(int first, int last, const std::shared_ptr<monty::ndarray<double,1>> & rhs);

  void task_con_putboundlist_lo(const std::shared_ptr<monty::ndarray<int,1>> idxs, const std::shared_ptr<monty::ndarray<double,1>> & rhs);
  void task_con_putboundlist_up(const std::shared_ptr<monty::ndarray<int,1>> idxs, const std::shared_ptr<monty::ndarray<double,1>> & rhs);
  void task_con_putboundlist_fx(const std::shared_ptr<monty::ndarray<int,1>> idxs, const std::shared_ptr<monty::ndarray<double,1>> & rhs);
  void task_con_putboundlist_ra(const std::shared_ptr<monty::ndarray<int,1>> idxs, const std::shared_ptr<monty::ndarray<double,1>> & lb , 
                                                            const std::shared_ptr<monty::ndarray<double,1>> & ub );
  void task_var_putboundslice_fr(int first, int last);
  void task_var_putboundslice_lo(int first, int last, const std::shared_ptr<monty::ndarray<double,1>> & rhs);
  void task_var_putboundslice_up(int first, int last, const std::shared_ptr<monty::ndarray<double,1>> & rhs);
  void task_var_putboundslice_ra(int first, int last, const std::shared_ptr<monty::ndarray<double,1>> & lb, 
                                                      const std::shared_ptr<monty::ndarray<double,1>> & ub);
  void task_var_putboundslice_fx(int first, int last, const std::shared_ptr<monty::ndarray<double,1>> & rhs);
  void task_var_putintlist(const std::shared_ptr<monty::ndarray<int,1>> & idxs);
  void task_var_putcontlist(const std::shared_ptr<monty::ndarray<int,1>> & idxs); 
 
  //--------------------------

  int  task_append_barmatrix
    ( int dim, 
      const std::shared_ptr<monty::ndarray<int,1>>    & subi, 
      const std::shared_ptr<monty::ndarray<int,1>>    & subj, 
      const std::shared_ptr<monty::ndarray<double,1>> & cof);
  int  task_barvar_dim(int j);
  void task_putbaraij (int i, int j, int k);
  void task_putbaraij (int i, int j, const std::shared_ptr<monty::ndarray<int,1>> & k);
  void task_putbarcj  (int j, int k);
  void task_putbarcj  (int j,        const std::shared_ptr<monty::ndarray<int,1>> & k);
  int  task_barvardim (int index);

  int task_append_var(int num);
  int task_append_con(int num);
  int task_append_quadcone (int conesize, int first, int num, int d0, int  d1);
  int task_append_rquadcone(int conesize, int first, int num, int d0, int  d1);

  void task_putarowslice(
    int first, 
    int last, 
    const std::shared_ptr<monty::ndarray<long long,1>> & ptrb, 
    const std::shared_ptr<monty::ndarray<int,1>>       & subj, 
    const std::shared_ptr<monty::ndarray<double,1>>    & cof);
  void task_putaijlist(
    const std::shared_ptr<monty::ndarray<int,1>>       & subi, 
    const std::shared_ptr<monty::ndarray<int,1>>       & subj, 
    const std::shared_ptr<monty::ndarray<double,1>>    & cof, 
    long long                           num);

  void task_setnumvar(int num);
  void task_cleanup(int oldnum, int oldnumcon, int oldnumcone, int oldnumbarvar);
  void task_solve();

  void task_putobjective( 
    bool                             maximize,
    const std::shared_ptr<monty::ndarray<int,1>>    & subj    ,
    const std::shared_ptr<monty::ndarray<double,1>> & cof     ,
    double                           cfix    );

  void task_putobjectivename(const std::string & name);

  void task_write(const std::string & filename);
  void task_dump (const std::string & filename);

  MSKtask_t task_get();
  void dispose();

  void task_putxx_slice(SolutionType which, int first, int last, std::shared_ptr<monty::ndarray<double,1>> & xx);

  static void env_syeig (int n, std::shared_ptr<monty::ndarray<double,1>> & a, std::shared_ptr<monty::ndarray<double,1>> & w);
  static void env_potrf (int n, std::shared_ptr<monty::ndarray<double,1>> & a);                        
  static void env_syevd (int n, std::shared_ptr<monty::ndarray<double,1>> & a, std::shared_ptr<monty::ndarray<double,1>> & w);

  static void env_putlicensecode(std::shared_ptr<monty::ndarray<int,1>> code);
  static void env_putlicensepath(const std::string &licfile);
  static void env_putlicensewait(int wait);

  void convertSolutionStatus(MSKsoltypee soltype, p_SolutionStruct * sol, MSKsolstae status, MSKprostae prosta);


};


// End of file 'src\fusion\cxx\BaseModel_p.h'
struct p_Model : public ::mosek::fusion::p_BaseModel
{
Model * _pubthis;
static mosek::fusion::p_Model* _get_impl(mosek::fusion::Model * _inst){ return static_cast< mosek::fusion::p_Model* >(mosek::fusion::p_BaseModel::_get_impl(_inst)); }
static mosek::fusion::p_Model * _get_impl(mosek::fusion::Model::t _inst) { return _get_impl(_inst.get()); }
p_Model(Model * _pubthis);
virtual ~p_Model() { /* std::cout << "~p_Model" << std::endl;*/ };
int task_vars_used{};int task_vars_allocated{};monty::rc_ptr< ::mosek::fusion::Utils::StringIntMap > con_map{};int cons_used{};std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::ModelConstraint >,1 > > cons{};int vars_used{};std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::ModelVariable >,1 > > vars{};std::shared_ptr< monty::ndarray< bool,1 > > initsol_xx_flag{};std::shared_ptr< monty::ndarray< double,1 > > initsol_xx{};int natbarvarmap_num{};std::shared_ptr< monty::ndarray< int,1 > > natbarvarmap_Var{};monty::rc_ptr< ::mosek::fusion::Utils::StringIntMap > var_map{};int natvarmap_num{};std::shared_ptr< monty::ndarray< long long,1 > > natvarmap_idx{};std::shared_ptr< monty::ndarray< int,1 > > natvarmap_Var{};mosek::fusion::SolutionType solutionptr{};mosek::fusion::AccSolutionStatus acceptable_sol{};std::string model_name{};virtual void destroy();
static Model::t _new_Model(monty::rc_ptr< ::mosek::fusion::Model > _436);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _436);
static Model::t _new_Model();
void _initialize();
static Model::t _new_Model(const std::string &  _443);
void _initialize(const std::string &  _443);
static  void putlicensewait(bool _444);
static  void putlicensepath(const std::string &  _445);
static  void putlicensecode(std::shared_ptr< monty::ndarray< int,1 > > _446);
static  void inst(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _447,int _448,int _449,std::shared_ptr< monty::ndarray< long long,1 > > _450,int _451,std::shared_ptr< monty::ndarray< int,1 > > _452,std::shared_ptr< monty::ndarray< int,1 > > _453,std::shared_ptr< monty::ndarray< int,1 > > _454);
static  void inst(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _475,std::shared_ptr< monty::ndarray< long long,1 > > _476,std::shared_ptr< monty::ndarray< int,1 > > _477,std::shared_ptr< monty::ndarray< int,1 > > _478,std::shared_ptr< monty::ndarray< int,1 > > _479);
virtual void dispose();
virtual void varname(int _482,const std::string &  _483);
virtual void nativeVarToStr(int _484,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _485);
virtual int append_linearvar(monty::rc_ptr< ::mosek::fusion::ModelVariable > _486,long long _487,mosek::fusion::RelationKey _488,double _489);
virtual int append_rangedvar(monty::rc_ptr< ::mosek::fusion::ModelVariable > _491,long long _492,double _493,double _494);
virtual MSKtask_t getTask();
virtual void flushNames();
virtual void writeTask(const std::string &  _498);
virtual long long getSolverLIntInfo(const std::string &  _499);
virtual int getSolverIntInfo(const std::string &  _500);
virtual double getSolverDoubleInfo(const std::string &  _501);
virtual void setCallbackHandler(mosek::cbhandler_t  _502);
virtual void setDataCallbackHandler(mosek::datacbhandler_t  _503);
virtual void setLogHandler(mosek::msghandler_t  _504);
virtual void setSolverParam(const std::string &  _505,double _506);
virtual void setSolverParam(const std::string &  _507,int _508);
virtual void setSolverParam(const std::string &  _509,const std::string &  _510);
virtual void breakSolver();
virtual void solve();
virtual void flushSolutions();
virtual void flush_initsol(mosek::fusion::SolutionType _511);
virtual mosek::fusion::SolutionStatus getDualSolutionStatus();
virtual mosek::fusion::SolutionStatus getPrimalSolutionStatus();
virtual double dualObjValue();
virtual double primalObjValue();
virtual monty::rc_ptr< ::mosek::fusion::SolutionStruct > get_sol_cache(mosek::fusion::SolutionType _519,bool _520,bool _521);
virtual monty::rc_ptr< ::mosek::fusion::SolutionStruct > get_sol_cache(mosek::fusion::SolutionType _526,bool _527);
virtual void setSolution_xx(std::shared_ptr< monty::ndarray< int,1 > > _528,std::shared_ptr< monty::ndarray< double,1 > > _529);
virtual void ensure_initsol_xx();
virtual std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< double,1 > >,1 > > getSolution_bars(mosek::fusion::SolutionType _535);
virtual std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< double,1 > >,1 > > getSolution_barx(mosek::fusion::SolutionType _536);
virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_y(mosek::fusion::SolutionType _537);
virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_xc(mosek::fusion::SolutionType _538);
virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_snx(mosek::fusion::SolutionType _539);
virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_suc(mosek::fusion::SolutionType _540);
virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_slc(mosek::fusion::SolutionType _541);
virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_sux(mosek::fusion::SolutionType _542);
virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_slx(mosek::fusion::SolutionType _543);
virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_xx(mosek::fusion::SolutionType _544);
virtual void selectedSolution(mosek::fusion::SolutionType _545);
virtual mosek::fusion::AccSolutionStatus getAcceptedSolutionStatus();
virtual void acceptedSolutionStatus(mosek::fusion::AccSolutionStatus _546);
virtual mosek::fusion::ProblemStatus getProblemStatus(mosek::fusion::SolutionType _547);
virtual mosek::fusion::SolutionStatus getDualSolutionStatus(mosek::fusion::SolutionType _549);
virtual mosek::fusion::SolutionStatus getPrimalSolutionStatus(mosek::fusion::SolutionType _550);
virtual mosek::fusion::SolutionStatus getSolutionStatus(mosek::fusion::SolutionType _551,bool _552);
virtual void objective_(const std::string &  _555,mosek::fusion::ObjectiveSense _556,monty::rc_ptr< ::mosek::fusion::Expression > _557);
virtual void objective(double _595);
virtual void objective(mosek::fusion::ObjectiveSense _596,double _597);
virtual void objective(mosek::fusion::ObjectiveSense _598,monty::rc_ptr< ::mosek::fusion::Variable > _599);
virtual void objective(mosek::fusion::ObjectiveSense _600,monty::rc_ptr< ::mosek::fusion::Expression > _601);
virtual void objective(const std::string &  _602,double _603);
virtual void objective(const std::string &  _604,mosek::fusion::ObjectiveSense _605,double _606);
virtual void objective(const std::string &  _607,mosek::fusion::ObjectiveSense _608,monty::rc_ptr< ::mosek::fusion::Variable > _609);
virtual void objective(const std::string &  _610,mosek::fusion::ObjectiveSense _611,monty::rc_ptr< ::mosek::fusion::Expression > _612);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(monty::rc_ptr< ::mosek::fusion::Variable > _613,monty::rc_ptr< ::mosek::fusion::QConeDomain > _614);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(const std::string &  _615,monty::rc_ptr< ::mosek::fusion::Variable > _616,monty::rc_ptr< ::mosek::fusion::QConeDomain > _617);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(monty::rc_ptr< ::mosek::fusion::Set > _618,monty::rc_ptr< ::mosek::fusion::Variable > _619,monty::rc_ptr< ::mosek::fusion::QConeDomain > _620);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(const std::string &  _621,monty::rc_ptr< ::mosek::fusion::Set > _622,monty::rc_ptr< ::mosek::fusion::Variable > _623,monty::rc_ptr< ::mosek::fusion::QConeDomain > _624);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(monty::rc_ptr< ::mosek::fusion::Variable > _625,monty::rc_ptr< ::mosek::fusion::RangeDomain > _626);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(const std::string &  _627,monty::rc_ptr< ::mosek::fusion::Variable > _628,monty::rc_ptr< ::mosek::fusion::RangeDomain > _629);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(monty::rc_ptr< ::mosek::fusion::Set > _630,monty::rc_ptr< ::mosek::fusion::Variable > _631,monty::rc_ptr< ::mosek::fusion::RangeDomain > _632);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(const std::string &  _633,monty::rc_ptr< ::mosek::fusion::Set > _634,monty::rc_ptr< ::mosek::fusion::Variable > _635,monty::rc_ptr< ::mosek::fusion::RangeDomain > _636);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(monty::rc_ptr< ::mosek::fusion::Variable > _637,monty::rc_ptr< ::mosek::fusion::LinearDomain > _638);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(const std::string &  _639,monty::rc_ptr< ::mosek::fusion::Variable > _640,monty::rc_ptr< ::mosek::fusion::LinearDomain > _641);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(monty::rc_ptr< ::mosek::fusion::Set > _642,monty::rc_ptr< ::mosek::fusion::Variable > _643,monty::rc_ptr< ::mosek::fusion::LinearDomain > _644);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(const std::string &  _645,monty::rc_ptr< ::mosek::fusion::Set > _646,monty::rc_ptr< ::mosek::fusion::Variable > _647,monty::rc_ptr< ::mosek::fusion::LinearDomain > _648);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(monty::rc_ptr< ::mosek::fusion::Variable > _649,monty::rc_ptr< ::mosek::fusion::LinPSDDomain > _650);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(const std::string &  _651,monty::rc_ptr< ::mosek::fusion::Variable > _652,monty::rc_ptr< ::mosek::fusion::LinPSDDomain > _653);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(monty::rc_ptr< ::mosek::fusion::Variable > _654,monty::rc_ptr< ::mosek::fusion::PSDDomain > _655);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(const std::string &  _656,monty::rc_ptr< ::mosek::fusion::Variable > _657,monty::rc_ptr< ::mosek::fusion::PSDDomain > _658);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(monty::rc_ptr< ::mosek::fusion::Expression > _659,monty::rc_ptr< ::mosek::fusion::QConeDomain > _660);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(const std::string &  _661,monty::rc_ptr< ::mosek::fusion::Expression > _662,monty::rc_ptr< ::mosek::fusion::QConeDomain > _663);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(monty::rc_ptr< ::mosek::fusion::Set > _664,monty::rc_ptr< ::mosek::fusion::Expression > _665,monty::rc_ptr< ::mosek::fusion::QConeDomain > _666);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(const std::string &  _667,monty::rc_ptr< ::mosek::fusion::Set > _668,monty::rc_ptr< ::mosek::fusion::Expression > _669,monty::rc_ptr< ::mosek::fusion::QConeDomain > _670);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(monty::rc_ptr< ::mosek::fusion::Expression > _671,monty::rc_ptr< ::mosek::fusion::RangeDomain > _672);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(const std::string &  _673,monty::rc_ptr< ::mosek::fusion::Expression > _674,monty::rc_ptr< ::mosek::fusion::RangeDomain > _675);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(monty::rc_ptr< ::mosek::fusion::Set > _676,monty::rc_ptr< ::mosek::fusion::Expression > _677,monty::rc_ptr< ::mosek::fusion::RangeDomain > _678);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(const std::string &  _679,monty::rc_ptr< ::mosek::fusion::Set > _680,monty::rc_ptr< ::mosek::fusion::Expression > _681,monty::rc_ptr< ::mosek::fusion::RangeDomain > _682);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(monty::rc_ptr< ::mosek::fusion::Expression > _683,monty::rc_ptr< ::mosek::fusion::LinearDomain > _684);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(const std::string &  _685,monty::rc_ptr< ::mosek::fusion::Expression > _686,monty::rc_ptr< ::mosek::fusion::LinearDomain > _687);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(monty::rc_ptr< ::mosek::fusion::Set > _688,monty::rc_ptr< ::mosek::fusion::Expression > _689,monty::rc_ptr< ::mosek::fusion::LinearDomain > _690);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(const std::string &  _691,monty::rc_ptr< ::mosek::fusion::Set > _692,monty::rc_ptr< ::mosek::fusion::Expression > _693,monty::rc_ptr< ::mosek::fusion::LinearDomain > _694);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(monty::rc_ptr< ::mosek::fusion::Expression > _695,monty::rc_ptr< ::mosek::fusion::LinPSDDomain > _696);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(const std::string &  _697,monty::rc_ptr< ::mosek::fusion::Expression > _698,monty::rc_ptr< ::mosek::fusion::LinPSDDomain > _699);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(monty::rc_ptr< ::mosek::fusion::Expression > _700,monty::rc_ptr< ::mosek::fusion::PSDDomain > _701);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint(const std::string &  _702,monty::rc_ptr< ::mosek::fusion::Expression > _703,monty::rc_ptr< ::mosek::fusion::PSDDomain > _704);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(monty::rc_ptr< ::mosek::fusion::LinPSDDomain > _705);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(int _706,int _707,monty::rc_ptr< ::mosek::fusion::LinPSDDomain > _708);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(int _709,monty::rc_ptr< ::mosek::fusion::LinPSDDomain > _710);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _711,monty::rc_ptr< ::mosek::fusion::LinPSDDomain > _712);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _713,int _714,int _715,monty::rc_ptr< ::mosek::fusion::LinPSDDomain > _716);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _717,int _718,monty::rc_ptr< ::mosek::fusion::LinPSDDomain > _719);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _720,monty::rc_ptr< ::mosek::fusion::Set > _721,monty::rc_ptr< ::mosek::fusion::LinPSDDomain > _722);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(monty::rc_ptr< ::mosek::fusion::PSDDomain > _723);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(int _724,int _725,monty::rc_ptr< ::mosek::fusion::PSDDomain > _726);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(int _727,monty::rc_ptr< ::mosek::fusion::PSDDomain > _728);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _729,monty::rc_ptr< ::mosek::fusion::PSDDomain > _730);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _731,int _732,int _733,monty::rc_ptr< ::mosek::fusion::PSDDomain > _734);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _735,int _736,monty::rc_ptr< ::mosek::fusion::PSDDomain > _737);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _738,monty::rc_ptr< ::mosek::fusion::Set > _739,monty::rc_ptr< ::mosek::fusion::PSDDomain > _740);
virtual monty::rc_ptr< ::mosek::fusion::SymmetricVariable > variable(int _741,monty::rc_ptr< ::mosek::fusion::SymmetricLinearDomain > _742);
virtual monty::rc_ptr< ::mosek::fusion::SymmetricVariable > variable(const std::string &  _743,int _744,monty::rc_ptr< ::mosek::fusion::SymmetricLinearDomain > _745);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(monty::rc_ptr< ::mosek::fusion::QConeDomain > _746);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(monty::rc_ptr< ::mosek::fusion::RangeDomain > _747);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(monty::rc_ptr< ::mosek::fusion::LinearDomain > _748);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(std::shared_ptr< monty::ndarray< int,1 > > _749,monty::rc_ptr< ::mosek::fusion::RangeDomain > _750);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(std::shared_ptr< monty::ndarray< int,1 > > _751,monty::rc_ptr< ::mosek::fusion::LinearDomain > _752);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(monty::rc_ptr< ::mosek::fusion::Set > _753,monty::rc_ptr< ::mosek::fusion::QConeDomain > _754);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(monty::rc_ptr< ::mosek::fusion::Set > _755,monty::rc_ptr< ::mosek::fusion::RangeDomain > _756);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(monty::rc_ptr< ::mosek::fusion::Set > _757,monty::rc_ptr< ::mosek::fusion::LinearDomain > _758);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(int _759,monty::rc_ptr< ::mosek::fusion::QConeDomain > _760);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(int _761,monty::rc_ptr< ::mosek::fusion::RangeDomain > _762);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(int _763,monty::rc_ptr< ::mosek::fusion::LinearDomain > _764);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(std::shared_ptr< monty::ndarray< int,1 > > _765);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(int _766);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable();
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _767,monty::rc_ptr< ::mosek::fusion::QConeDomain > _768);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _769,monty::rc_ptr< ::mosek::fusion::RangeDomain > _770);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _771,monty::rc_ptr< ::mosek::fusion::LinearDomain > _772);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _773,std::shared_ptr< monty::ndarray< int,1 > > _774,monty::rc_ptr< ::mosek::fusion::RangeDomain > _775);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _776,std::shared_ptr< monty::ndarray< int,1 > > _777,monty::rc_ptr< ::mosek::fusion::LinearDomain > _778);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _779,monty::rc_ptr< ::mosek::fusion::Set > _780,monty::rc_ptr< ::mosek::fusion::QConeDomain > _781);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _782,monty::rc_ptr< ::mosek::fusion::Set > _783,monty::rc_ptr< ::mosek::fusion::RangeDomain > _784);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _785,monty::rc_ptr< ::mosek::fusion::Set > _786,monty::rc_ptr< ::mosek::fusion::LinearDomain > _787);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _788,int _789,monty::rc_ptr< ::mosek::fusion::QConeDomain > _790);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _791,int _792,monty::rc_ptr< ::mosek::fusion::RangeDomain > _793);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _794,int _795,monty::rc_ptr< ::mosek::fusion::LinearDomain > _796);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _797,std::shared_ptr< monty::ndarray< int,1 > > _798);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _799,int _800);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable(const std::string &  _801);
virtual monty::rc_ptr< ::mosek::fusion::Variable > ranged_variable(const std::string &  _802,int _803,monty::rc_ptr< ::mosek::fusion::SymmetricRangeDomain > _804);
virtual monty::rc_ptr< ::mosek::fusion::Variable > ranged_variable(const std::string &  _823,monty::rc_ptr< ::mosek::fusion::Set > _824,monty::rc_ptr< ::mosek::fusion::RangeDomain > _825);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable_(const std::string &  _842,monty::rc_ptr< ::mosek::fusion::Set > _843,monty::rc_ptr< ::mosek::fusion::QConeDomain > _844);
virtual monty::rc_ptr< ::mosek::fusion::SymmetricVariable > variable_(const std::string &  _868,int _869,monty::rc_ptr< ::mosek::fusion::SymmetricLinearDomain > _870);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable_(const std::string &  _888,monty::rc_ptr< ::mosek::fusion::Set > _889,monty::rc_ptr< ::mosek::fusion::LinearDomain > _890);
virtual monty::rc_ptr< ::mosek::fusion::Variable > variable_(const std::string &  _907,monty::rc_ptr< ::mosek::fusion::Set > _908,monty::rc_ptr< ::mosek::fusion::LinPSDDomain > _909);
virtual monty::rc_ptr< ::mosek::fusion::SymmetricVariable > variable_(const std::string &  _917,monty::rc_ptr< ::mosek::fusion::Set > _918,monty::rc_ptr< ::mosek::fusion::PSDDomain > _919);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint_(const std::string &  _924,monty::rc_ptr< ::mosek::fusion::Set > _925,monty::rc_ptr< ::mosek::fusion::Expression > _926,monty::rc_ptr< ::mosek::fusion::RangeDomain > _927);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint_(const std::string &  _950,monty::rc_ptr< ::mosek::fusion::Set > _951,monty::rc_ptr< ::mosek::fusion::Expression > _952,monty::rc_ptr< ::mosek::fusion::QConeDomain > _953);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint_(const std::string &  _988,monty::rc_ptr< ::mosek::fusion::Set > _989,monty::rc_ptr< ::mosek::fusion::Expression > _990,monty::rc_ptr< ::mosek::fusion::LinearDomain > _991);
virtual monty::rc_ptr< ::mosek::fusion::ConNZStruct > build_conA(std::shared_ptr< monty::ndarray< long long,1 > > _1012,long long _1013,std::shared_ptr< monty::ndarray< long long,1 > > _1014,std::shared_ptr< monty::ndarray< long long,1 > > _1015,std::shared_ptr< monty::ndarray< double,1 > > _1016,std::shared_ptr< monty::ndarray< double,1 > > _1017,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _1018);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint_(const std::string &  _1075,monty::rc_ptr< ::mosek::fusion::Expression > _1076,monty::rc_ptr< ::mosek::fusion::LinPSDDomain > _1077);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > constraint_(const std::string &  _1112,monty::rc_ptr< ::mosek::fusion::Expression > _1113,monty::rc_ptr< ::mosek::fusion::PSDDomain > _1114);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > nonsym_psdconstraint(const std::string &  _1127,monty::rc_ptr< ::mosek::fusion::Expression > _1128,monty::rc_ptr< ::mosek::fusion::PSDDomain > _1129);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > sdptrilcon(const std::string &  _1191,int _1192,int _1193,std::shared_ptr< monty::ndarray< long long,1 > > _1194,std::shared_ptr< monty::ndarray< long long,1 > > _1195,std::shared_ptr< monty::ndarray< long long,1 > > _1196,std::shared_ptr< monty::ndarray< long long,1 > > _1197,std::shared_ptr< monty::ndarray< double,1 > > _1198,std::shared_ptr< monty::ndarray< double,1 > > _1199,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _1200);
virtual void addConstraint(const std::string &  _1271,monty::rc_ptr< ::mosek::fusion::ModelConstraint > _1272);
virtual void addVariable(const std::string &  _1276,monty::rc_ptr< ::mosek::fusion::ModelVariable > _1277);
virtual long long numConstraints();
virtual long long numVariables();
virtual bool hasConstraint(const std::string &  _1281);
virtual bool hasVariable(const std::string &  _1282);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > getConstraint(int _1283);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > getConstraint(const std::string &  _1284);
virtual monty::rc_ptr< ::mosek::fusion::Variable > getVariable(int _1285);
virtual monty::rc_ptr< ::mosek::fusion::Variable > getVariable(const std::string &  _1286);
virtual std::string getName();
virtual monty::rc_ptr< ::mosek::fusion::Model > clone();
virtual void natbarvarmap_ensure(int _1287);
virtual void natvarmap_ensure(int _1292);
virtual int task_alloc_vars(int _1297);
}; // struct Model;

// mosek.fusion.Debug from file 'src\fusion\cxx\Debug_p.h'
// namespace mosek::fusion
struct p_Debug
{
  Debug * _pubthis;

  p_Debug(Debug * _pubthis) : _pubthis(_pubthis) {}

  static Debug::t o ()                 { return monty::rc_ptr<Debug>(new Debug()); }
  Debug::t p (const std::string & val) { std::cout << val; return Debug::t(_pubthis); }
  Debug::t p (      int val)           { std::cout << val; return Debug::t(_pubthis); }
  Debug::t p (long long val)           { std::cout << val; return Debug::t(_pubthis); }
  Debug::t p (   double val)           { std::cout << val; return Debug::t(_pubthis); }
  Debug::t p (     bool val)           { std::cout << val; return Debug::t(_pubthis); }
  Debug::t lf()                        { std::cout << std::endl; return Debug::t(_pubthis); }

  static p_Debug * _get_impl(Debug * _inst) { return _inst->ptr.get(); }

  template<typename T>
  Debug::t p(const std::shared_ptr<monty::ndarray<T,1>> & val)
  {
    if (val->size() > 0)
    {
      std::cout << (*val)[0];
      for (int i = 1; i < val->size(); ++i)
        std::cout << "," << (*val)[i];
    }
    return Debug::t(_pubthis);
  }
};
// End of file 'src\fusion\cxx\Debug_p.h'
struct p_Sort
{
Sort * _pubthis;
static mosek::fusion::p_Sort* _get_impl(mosek::fusion::Sort * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_Sort * _get_impl(mosek::fusion::Sort::t _inst) { return _get_impl(_inst.get()); }
p_Sort(Sort * _pubthis);
virtual ~p_Sort() { /* std::cout << "~p_Sort" << std::endl;*/ };
virtual void destroy();
static  void argTransposeSort(std::shared_ptr< monty::ndarray< long long,1 > > _143,std::shared_ptr< monty::ndarray< long long,1 > > _144,int _145,int _146,int _147,std::shared_ptr< monty::ndarray< long long,1 > > _148);
static  void argsort(std::shared_ptr< monty::ndarray< long long,1 > > _156,std::shared_ptr< monty::ndarray< long long,1 > > _157);
static  void argsort(std::shared_ptr< monty::ndarray< long long,1 > > _158,std::shared_ptr< monty::ndarray< int,1 > > _159);
static  void argsort(std::shared_ptr< monty::ndarray< long long,1 > > _160,std::shared_ptr< monty::ndarray< long long,1 > > _161,std::shared_ptr< monty::ndarray< long long,1 > > _162);
static  void argsort(std::shared_ptr< monty::ndarray< long long,1 > > _163,std::shared_ptr< monty::ndarray< int,1 > > _164,std::shared_ptr< monty::ndarray< int,1 > > _165);
static  void argsort(std::shared_ptr< monty::ndarray< long long,1 > > _166,std::shared_ptr< monty::ndarray< long long,1 > > _167,long long _168,long long _169);
static  void argsort(std::shared_ptr< monty::ndarray< long long,1 > > _170,std::shared_ptr< monty::ndarray< int,1 > > _171,long long _172,long long _173);
static  void argsort(std::shared_ptr< monty::ndarray< long long,1 > > _174,std::shared_ptr< monty::ndarray< long long,1 > > _175,std::shared_ptr< monty::ndarray< long long,1 > > _176,long long _177,long long _178);
static  void argsort(std::shared_ptr< monty::ndarray< long long,1 > > _179,std::shared_ptr< monty::ndarray< int,1 > > _180,std::shared_ptr< monty::ndarray< int,1 > > _181,long long _182,long long _183);
static  void argsort(std::shared_ptr< monty::ndarray< long long,1 > > _184,std::shared_ptr< monty::ndarray< long long,1 > > _185,long long _186,long long _187,bool _188);
static  void argsort(std::shared_ptr< monty::ndarray< long long,1 > > _191,std::shared_ptr< monty::ndarray< int,1 > > _192,long long _193,long long _194,bool _195);
static  void argsort(std::shared_ptr< monty::ndarray< long long,1 > > _198,std::shared_ptr< monty::ndarray< long long,1 > > _199,std::shared_ptr< monty::ndarray< long long,1 > > _200,long long _201,long long _202,bool _203);
static  void argsort(std::shared_ptr< monty::ndarray< long long,1 > > _206,std::shared_ptr< monty::ndarray< int,1 > > _207,std::shared_ptr< monty::ndarray< int,1 > > _208,long long _209,long long _210,bool _211);
static  void argbucketsort(std::shared_ptr< monty::ndarray< long long,1 > > _214,std::shared_ptr< monty::ndarray< long long,1 > > _215,long long _216,long long _217,long long _218,long long _219);
static  void argbucketsort(std::shared_ptr< monty::ndarray< long long,1 > > _220,std::shared_ptr< monty::ndarray< int,1 > > _221,long long _222,long long _223,int _224,int _225);
static  void getminmax(std::shared_ptr< monty::ndarray< long long,1 > > _226,std::shared_ptr< monty::ndarray< long long,1 > > _227,std::shared_ptr< monty::ndarray< long long,1 > > _228,long long _229,long long _230,std::shared_ptr< monty::ndarray< long long,1 > > _231);
static  void getminmax(std::shared_ptr< monty::ndarray< long long,1 > > _234,std::shared_ptr< monty::ndarray< int,1 > > _235,std::shared_ptr< monty::ndarray< int,1 > > _236,long long _237,long long _238,std::shared_ptr< monty::ndarray< int,1 > > _239);
static  bool issorted(std::shared_ptr< monty::ndarray< long long,1 > > _242,std::shared_ptr< monty::ndarray< long long,1 > > _243,long long _244,long long _245,bool _246);
static  bool issorted(std::shared_ptr< monty::ndarray< long long,1 > > _248,std::shared_ptr< monty::ndarray< int,1 > > _249,long long _250,long long _251,bool _252);
static  bool issorted(std::shared_ptr< monty::ndarray< long long,1 > > _254,std::shared_ptr< monty::ndarray< long long,1 > > _255,std::shared_ptr< monty::ndarray< long long,1 > > _256,long long _257,long long _258,bool _259);
static  bool issorted(std::shared_ptr< monty::ndarray< long long,1 > > _261,std::shared_ptr< monty::ndarray< int,1 > > _262,std::shared_ptr< monty::ndarray< int,1 > > _263,long long _264,long long _265,bool _266);
}; // struct Sort;

struct p_IndexCounter
{
IndexCounter * _pubthis;
static mosek::fusion::p_IndexCounter* _get_impl(mosek::fusion::IndexCounter * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_IndexCounter * _get_impl(mosek::fusion::IndexCounter::t _inst) { return _get_impl(_inst.get()); }
p_IndexCounter(IndexCounter * _pubthis);
virtual ~p_IndexCounter() { /* std::cout << "~p_IndexCounter" << std::endl;*/ };
long long start{};std::shared_ptr< monty::ndarray< int,1 > > dims{};std::shared_ptr< monty::ndarray< long long,1 > > strides{};std::shared_ptr< monty::ndarray< long long,1 > > st{};std::shared_ptr< monty::ndarray< int,1 > > ii{};int n{};virtual void destroy();
static IndexCounter::t _new_IndexCounter(monty::rc_ptr< ::mosek::fusion::Set > _268);
void _initialize(monty::rc_ptr< ::mosek::fusion::Set > _268);
static IndexCounter::t _new_IndexCounter(long long _271,std::shared_ptr< monty::ndarray< int,1 > > _272,monty::rc_ptr< ::mosek::fusion::Set > _273);
void _initialize(long long _271,std::shared_ptr< monty::ndarray< int,1 > > _272,monty::rc_ptr< ::mosek::fusion::Set > _273);
static IndexCounter::t _new_IndexCounter(long long _276,std::shared_ptr< monty::ndarray< int,1 > > _277,std::shared_ptr< monty::ndarray< long long,1 > > _278);
void _initialize(long long _276,std::shared_ptr< monty::ndarray< int,1 > > _277,std::shared_ptr< monty::ndarray< long long,1 > > _278);
virtual bool atEnd();
virtual std::shared_ptr< monty::ndarray< int,1 > > getIndex();
virtual long long next();
virtual long long get();
virtual void inc();
virtual void reset();
}; // struct IndexCounter;

struct p_CommonTools
{
CommonTools * _pubthis;
static mosek::fusion::p_CommonTools* _get_impl(mosek::fusion::CommonTools * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_CommonTools * _get_impl(mosek::fusion::CommonTools::t _inst) { return _get_impl(_inst.get()); }
p_CommonTools(CommonTools * _pubthis);
virtual ~p_CommonTools() { /* std::cout << "~p_CommonTools" << std::endl;*/ };
virtual void destroy();
static  void ndIncr(std::shared_ptr< monty::ndarray< int,1 > > _284,std::shared_ptr< monty::ndarray< int,1 > > _285,std::shared_ptr< monty::ndarray< int,1 > > _286);
static  void transposeTriplets(std::shared_ptr< monty::ndarray< int,1 > > _288,std::shared_ptr< monty::ndarray< int,1 > > _289,std::shared_ptr< monty::ndarray< double,1 > > _290,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< long long,1 > >,1 > > _291,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< long long,1 > >,1 > > _292,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< double,1 > >,1 > > _293,long long _294,int _295,int _296);
static  void transposeTriplets(std::shared_ptr< monty::ndarray< int,1 > > _309,std::shared_ptr< monty::ndarray< int,1 > > _310,std::shared_ptr< monty::ndarray< double,1 > > _311,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< int,1 > >,1 > > _312,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< int,1 > >,1 > > _313,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< double,1 > >,1 > > _314,long long _315,int _316,int _317);
static  void tripletSort(std::shared_ptr< monty::ndarray< int,1 > > _330,std::shared_ptr< monty::ndarray< int,1 > > _331,std::shared_ptr< monty::ndarray< double,1 > > _332,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< int,1 > >,1 > > _333,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< int,1 > >,1 > > _334,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< double,1 > >,1 > > _335,long long _336,int _337,int _338);
static  void argMSort(std::shared_ptr< monty::ndarray< int,1 > > _364,std::shared_ptr< monty::ndarray< int,1 > > _365);
static  void mergeInto(std::shared_ptr< monty::ndarray< int,1 > > _370,std::shared_ptr< monty::ndarray< int,1 > > _371,std::shared_ptr< monty::ndarray< int,1 > > _372,int _373,int _374,int _375);
static  void argQsort(std::shared_ptr< monty::ndarray< long long,1 > > _381,std::shared_ptr< monty::ndarray< long long,1 > > _382,std::shared_ptr< monty::ndarray< long long,1 > > _383,long long _384,long long _385);
static  void argQsort(std::shared_ptr< monty::ndarray< long long,1 > > _386,std::shared_ptr< monty::ndarray< int,1 > > _387,std::shared_ptr< monty::ndarray< int,1 > > _388,long long _389,long long _390);
}; // struct CommonTools;

struct p_SolutionStruct
{
SolutionStruct * _pubthis;
static mosek::fusion::p_SolutionStruct* _get_impl(mosek::fusion::SolutionStruct * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_SolutionStruct * _get_impl(mosek::fusion::SolutionStruct::t _inst) { return _get_impl(_inst.get()); }
p_SolutionStruct(SolutionStruct * _pubthis);
virtual ~p_SolutionStruct() { /* std::cout << "~p_SolutionStruct" << std::endl;*/ };
std::shared_ptr< monty::ndarray< double,1 > > snx{};std::shared_ptr< monty::ndarray< double,1 > > sux{};std::shared_ptr< monty::ndarray< double,1 > > slx{};std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< double,1 > >,1 > > bars{};std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< double,1 > >,1 > > barx{};std::shared_ptr< monty::ndarray< double,1 > > y{};std::shared_ptr< monty::ndarray< double,1 > > suc{};std::shared_ptr< monty::ndarray< double,1 > > slc{};std::shared_ptr< monty::ndarray< double,1 > > xx{};std::shared_ptr< monty::ndarray< double,1 > > xc{};double dobj{};double pobj{};mosek::fusion::ProblemStatus probstatus{};mosek::fusion::SolutionStatus dstatus{};mosek::fusion::SolutionStatus pstatus{};int sol_numbarvar{};int sol_numcone{};int sol_numvar{};int sol_numcon{};virtual void destroy();
static SolutionStruct::t _new_SolutionStruct(int _391,int _392,int _393,int _394);
void _initialize(int _391,int _392,int _393,int _394);
static SolutionStruct::t _new_SolutionStruct(monty::rc_ptr< ::mosek::fusion::SolutionStruct > _395);
void _initialize(monty::rc_ptr< ::mosek::fusion::SolutionStruct > _395);
virtual monty::rc_ptr< ::mosek::fusion::SolutionStruct > clone();
virtual void resize(int _398,int _399,int _400,int _401);
virtual bool isDualAcceptable(mosek::fusion::AccSolutionStatus _425);
virtual bool isPrimalAcceptable(mosek::fusion::AccSolutionStatus _426);
virtual bool isAcceptable(mosek::fusion::SolutionStatus _427,mosek::fusion::AccSolutionStatus _428);
}; // struct SolutionStruct;

struct p_ConNZStruct
{
ConNZStruct * _pubthis;
static mosek::fusion::p_ConNZStruct* _get_impl(mosek::fusion::ConNZStruct * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_ConNZStruct * _get_impl(mosek::fusion::ConNZStruct::t _inst) { return _get_impl(_inst.get()); }
p_ConNZStruct(ConNZStruct * _pubthis);
virtual ~p_ConNZStruct() { /* std::cout << "~p_ConNZStruct" << std::endl;*/ };
std::shared_ptr< monty::ndarray< int,1 > > barmidx{};std::shared_ptr< monty::ndarray< int,1 > > barsubj{};std::shared_ptr< monty::ndarray< int,1 > > barsubi{};std::shared_ptr< monty::ndarray< double,1 > > bfix{};std::shared_ptr< monty::ndarray< double,1 > > cof{};std::shared_ptr< monty::ndarray< int,1 > > subj{};std::shared_ptr< monty::ndarray< long long,1 > > ptrb{};virtual void destroy();
static ConNZStruct::t _new_ConNZStruct(std::shared_ptr< monty::ndarray< long long,1 > > _429,std::shared_ptr< monty::ndarray< int,1 > > _430,std::shared_ptr< monty::ndarray< double,1 > > _431,std::shared_ptr< monty::ndarray< double,1 > > _432,std::shared_ptr< monty::ndarray< int,1 > > _433,std::shared_ptr< monty::ndarray< int,1 > > _434,std::shared_ptr< monty::ndarray< int,1 > > _435);
void _initialize(std::shared_ptr< monty::ndarray< long long,1 > > _429,std::shared_ptr< monty::ndarray< int,1 > > _430,std::shared_ptr< monty::ndarray< double,1 > > _431,std::shared_ptr< monty::ndarray< double,1 > > _432,std::shared_ptr< monty::ndarray< int,1 > > _433,std::shared_ptr< monty::ndarray< int,1 > > _434,std::shared_ptr< monty::ndarray< int,1 > > _435);
}; // struct ConNZStruct;

struct p_BaseVariable : public /*implements*/ ::mosek::fusion::Variable
{
BaseVariable * _pubthis;
static mosek::fusion::p_BaseVariable* _get_impl(mosek::fusion::BaseVariable * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_BaseVariable * _get_impl(mosek::fusion::BaseVariable::t _inst) { return _get_impl(_inst.get()); }
p_BaseVariable(BaseVariable * _pubthis);
virtual ~p_BaseVariable() { /* std::cout << "~p_BaseVariable" << std::endl;*/ };
monty::rc_ptr< ::mosek::fusion::Model > model{};monty::rc_ptr< ::mosek::fusion::Set > shape_p{};virtual void destroy();
static BaseVariable::t _new_BaseVariable(monty::rc_ptr< ::mosek::fusion::BaseVariable > _2662,monty::rc_ptr< ::mosek::fusion::Model > _2663);
void _initialize(monty::rc_ptr< ::mosek::fusion::BaseVariable > _2662,monty::rc_ptr< ::mosek::fusion::Model > _2663);
static BaseVariable::t _new_BaseVariable(monty::rc_ptr< ::mosek::fusion::Model > _2664,monty::rc_ptr< ::mosek::fusion::Set > _2665);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2664,monty::rc_ptr< ::mosek::fusion::Set > _2665);
virtual monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > elementDesc(long long _2666,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2667);
virtual void elementName(long long _2668,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2669) { throw monty::AbstractClassError("Call to abstract method"); }
virtual std::string toString();
virtual void inst(std::shared_ptr< monty::ndarray< long long,1 > > _2675,int _2676,int _2677,long long _2678,long long _2679,std::shared_ptr< monty::ndarray< int,1 > > _2680,std::shared_ptr< monty::ndarray< int,1 > > _2681,std::shared_ptr< monty::ndarray< int,1 > > _2682);
virtual void inst(long long _2684,long long _2685,std::shared_ptr< monty::ndarray< int,1 > > _2686,std::shared_ptr< monty::ndarray< int,1 > > _2687,std::shared_ptr< monty::ndarray< int,1 > > _2688) { throw monty::AbstractClassError("Call to abstract method"); }
virtual void set_values(std::shared_ptr< monty::ndarray< long long,1 > > _2689,std::shared_ptr< monty::ndarray< double,1 > > _2690,bool _2691) { throw monty::AbstractClassError("Call to abstract method"); }
virtual void set_values(long long _2692,std::shared_ptr< monty::ndarray< int,1 > > _2693,std::shared_ptr< monty::ndarray< long long,1 > > _2694,int _2695,std::shared_ptr< monty::ndarray< double,1 > > _2696,bool _2697) { throw monty::AbstractClassError("Call to abstract method"); }
virtual void values(int _2698,std::shared_ptr< monty::ndarray< double,1 > > _2699,bool _2700);
virtual void values(std::shared_ptr< monty::ndarray< long long,1 > > _2705,int _2706,std::shared_ptr< monty::ndarray< double,1 > > _2707,bool _2708) { throw monty::AbstractClassError("Call to abstract method"); }
virtual void values(long long _2709,std::shared_ptr< monty::ndarray< int,1 > > _2710,std::shared_ptr< monty::ndarray< long long,1 > > _2711,int _2712,std::shared_ptr< monty::ndarray< double,1 > > _2713,bool _2714) { throw monty::AbstractClassError("Call to abstract method"); }
virtual void setLevel(std::shared_ptr< monty::ndarray< double,1 > > _2715);
virtual monty::rc_ptr< ::mosek::fusion::Model > getModel();
virtual monty::rc_ptr< ::mosek::fusion::Set > shape();
virtual monty::rc_ptr< ::mosek::fusion::Set > getShape();
virtual long long size();
virtual std::shared_ptr< monty::ndarray< double,1 > > dual();
virtual std::shared_ptr< monty::ndarray< double,1 > > level();
virtual void make_continuous(std::shared_ptr< monty::ndarray< long long,1 > > _2720) { throw monty::AbstractClassError("Call to abstract method"); }
virtual void make_integer(std::shared_ptr< monty::ndarray< long long,1 > > _2721) { throw monty::AbstractClassError("Call to abstract method"); }
virtual void makeContinuous();
virtual void makeInteger();
virtual monty::rc_ptr< ::mosek::fusion::Variable > transpose();
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(int _2724,int _2725,int _2726);
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(int _2727,int _2728);
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(std::shared_ptr< monty::ndarray< int,1 > > _2729);
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(int _2730);
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,1 > > _2731,std::shared_ptr< monty::ndarray< int,1 > > _2732,std::shared_ptr< monty::ndarray< int,1 > > _2733);
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,1 > > _2735,std::shared_ptr< monty::ndarray< int,1 > > _2736);
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,2 > > _2738);
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,1 > > _2741);
virtual monty::rc_ptr< ::mosek::fusion::Variable > antidiag(int _2743);
virtual monty::rc_ptr< ::mosek::fusion::Variable > antidiag();
virtual monty::rc_ptr< ::mosek::fusion::Variable > diag(int _2744);
virtual monty::rc_ptr< ::mosek::fusion::Variable > diag();
virtual monty::rc_ptr< ::mosek::fusion::Variable > general_diag(std::shared_ptr< monty::ndarray< int,1 > > _2745,std::shared_ptr< monty::ndarray< int,1 > > _2746);
virtual monty::rc_ptr< ::mosek::fusion::Expression > asExpr();
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(std::shared_ptr< monty::ndarray< int,1 > > _2759,std::shared_ptr< monty::ndarray< int,1 > > _2760);
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(int _2763,int _2764);
}; // struct BaseVariable;

struct p_CompoundVariable : public ::mosek::fusion::p_BaseVariable
{
CompoundVariable * _pubthis;
static mosek::fusion::p_CompoundVariable* _get_impl(mosek::fusion::CompoundVariable * _inst){ return static_cast< mosek::fusion::p_CompoundVariable* >(mosek::fusion::p_BaseVariable::_get_impl(_inst)); }
static mosek::fusion::p_CompoundVariable * _get_impl(mosek::fusion::CompoundVariable::t _inst) { return _get_impl(_inst.get()); }
p_CompoundVariable(CompoundVariable * _pubthis);
virtual ~p_CompoundVariable() { /* std::cout << "~p_CompoundVariable" << std::endl;*/ };
int stackdim{};std::shared_ptr< monty::ndarray< int,1 > > varsb{};std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > vars{};virtual void destroy();
static CompoundVariable::t _new_CompoundVariable(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _1300,int _1301);
void _initialize(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _1300,int _1301);
virtual monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > elementDesc(long long _1307,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _1308);
virtual void elementName(long long _1311,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _1312);
virtual void inst(long long _1315,long long _1316,std::shared_ptr< monty::ndarray< int,1 > > _1317,std::shared_ptr< monty::ndarray< int,1 > > _1318,std::shared_ptr< monty::ndarray< int,1 > > _1319);
virtual void set_values(long long _1322,std::shared_ptr< monty::ndarray< int,1 > > _1323,std::shared_ptr< monty::ndarray< long long,1 > > _1324,int _1325,std::shared_ptr< monty::ndarray< double,1 > > _1326,bool _1327);
virtual void set_values(std::shared_ptr< monty::ndarray< long long,1 > > _1345,std::shared_ptr< monty::ndarray< double,1 > > _1346,bool _1347);
virtual void values(long long _1355,std::shared_ptr< monty::ndarray< int,1 > > _1356,std::shared_ptr< monty::ndarray< long long,1 > > _1357,int _1358,std::shared_ptr< monty::ndarray< double,1 > > _1359,bool _1360);
virtual void values(std::shared_ptr< monty::ndarray< long long,1 > > _1375,int _1376,std::shared_ptr< monty::ndarray< double,1 > > _1377,bool _1378);
virtual void make_continuous(std::shared_ptr< monty::ndarray< long long,1 > > _1385);
virtual void make_integer(std::shared_ptr< monty::ndarray< long long,1 > > _1392);
virtual monty::rc_ptr< ::mosek::fusion::Expression > asExpr();
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(std::shared_ptr< monty::ndarray< int,1 > > _1419,std::shared_ptr< monty::ndarray< int,1 > > _1420);
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(int _1438,int _1439);
static  monty::rc_ptr< ::mosek::fusion::Set > compute_shape(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _1447,int _1448);
static  monty::rc_ptr< ::mosek::fusion::Model > model_from_var(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _1456);
}; // struct CompoundVariable;

struct p_RepeatVariable : public ::mosek::fusion::p_BaseVariable
{
RepeatVariable * _pubthis;
static mosek::fusion::p_RepeatVariable* _get_impl(mosek::fusion::RepeatVariable * _inst){ return static_cast< mosek::fusion::p_RepeatVariable* >(mosek::fusion::p_BaseVariable::_get_impl(_inst)); }
static mosek::fusion::p_RepeatVariable * _get_impl(mosek::fusion::RepeatVariable::t _inst) { return _get_impl(_inst.get()); }
p_RepeatVariable(RepeatVariable * _pubthis);
virtual ~p_RepeatVariable() { /* std::cout << "~p_RepeatVariable" << std::endl;*/ };
long long d2{};long long d1{};long long d0{};int dim{};int count{};long long xsize{};std::shared_ptr< monty::ndarray< int,1 > > xdims{};monty::rc_ptr< ::mosek::fusion::Variable > x{};virtual void destroy();
static RepeatVariable::t _new_RepeatVariable(monty::rc_ptr< ::mosek::fusion::Variable > _1457,int _1458,int _1459);
void _initialize(monty::rc_ptr< ::mosek::fusion::Variable > _1457,int _1458,int _1459);
virtual monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > elementDesc(long long _1466,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _1467);
virtual void elementName(long long _1472,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _1473);
virtual void inst(long long _1478,long long _1479,std::shared_ptr< monty::ndarray< int,1 > > _1480,std::shared_ptr< monty::ndarray< int,1 > > _1481,std::shared_ptr< monty::ndarray< int,1 > > _1482);
virtual void set_values(long long _1487,std::shared_ptr< monty::ndarray< int,1 > > _1488,std::shared_ptr< monty::ndarray< long long,1 > > _1489,int _1490,std::shared_ptr< monty::ndarray< double,1 > > _1491,bool _1492);
virtual void set_values(std::shared_ptr< monty::ndarray< long long,1 > > _1507,std::shared_ptr< monty::ndarray< double,1 > > _1508,bool _1509);
virtual void values(long long _1518,std::shared_ptr< monty::ndarray< int,1 > > _1519,std::shared_ptr< monty::ndarray< long long,1 > > _1520,int _1521,std::shared_ptr< monty::ndarray< double,1 > > _1522,bool _1523);
virtual void values(std::shared_ptr< monty::ndarray< long long,1 > > _1537,int _1538,std::shared_ptr< monty::ndarray< double,1 > > _1539,bool _1540);
virtual void make_continuous(std::shared_ptr< monty::ndarray< long long,1 > > _1549);
virtual void make_integer(std::shared_ptr< monty::ndarray< long long,1 > > _1558);
static  monty::rc_ptr< ::mosek::fusion::Set > compute_shape(monty::rc_ptr< ::mosek::fusion::Variable > _1567,int _1568,int _1569);
}; // struct RepeatVariable;

struct p_PickVariable : public ::mosek::fusion::p_BaseVariable
{
PickVariable * _pubthis;
static mosek::fusion::p_PickVariable* _get_impl(mosek::fusion::PickVariable * _inst){ return static_cast< mosek::fusion::p_PickVariable* >(mosek::fusion::p_BaseVariable::_get_impl(_inst)); }
static mosek::fusion::p_PickVariable * _get_impl(mosek::fusion::PickVariable::t _inst) { return _get_impl(_inst.get()); }
p_PickVariable(PickVariable * _pubthis);
virtual ~p_PickVariable() { /* std::cout << "~p_PickVariable" << std::endl;*/ };
std::shared_ptr< monty::ndarray< long long,1 > > indexes{};monty::rc_ptr< ::mosek::fusion::Variable > origin{};virtual void destroy();
static PickVariable::t _new_PickVariable(monty::rc_ptr< ::mosek::fusion::Variable > _1578,std::shared_ptr< monty::ndarray< long long,1 > > _1579);
void _initialize(monty::rc_ptr< ::mosek::fusion::Variable > _1578,std::shared_ptr< monty::ndarray< long long,1 > > _1579);
virtual void inst(long long _1582,long long _1583,std::shared_ptr< monty::ndarray< int,1 > > _1584,std::shared_ptr< monty::ndarray< int,1 > > _1585,std::shared_ptr< monty::ndarray< int,1 > > _1586);
virtual void set_values(long long _1587,std::shared_ptr< monty::ndarray< int,1 > > _1588,std::shared_ptr< monty::ndarray< long long,1 > > _1589,int _1590,std::shared_ptr< monty::ndarray< double,1 > > _1591,bool _1592);
virtual void set_values(std::shared_ptr< monty::ndarray< long long,1 > > _1595,std::shared_ptr< monty::ndarray< double,1 > > _1596,bool _1597);
virtual monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > elementDesc(long long _1599,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _1600);
virtual void elementName(long long _1601,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _1602);
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(int _1603,int _1604);
virtual void values(long long _1606,std::shared_ptr< monty::ndarray< int,1 > > _1607,std::shared_ptr< monty::ndarray< long long,1 > > _1608,int _1609,std::shared_ptr< monty::ndarray< double,1 > > _1610,bool _1611);
virtual void values(std::shared_ptr< monty::ndarray< long long,1 > > _1614,int _1615,std::shared_ptr< monty::ndarray< double,1 > > _1616,bool _1617);
virtual void make_continuous(std::shared_ptr< monty::ndarray< long long,1 > > _1620);
virtual void make_integer(std::shared_ptr< monty::ndarray< long long,1 > > _1622);
}; // struct PickVariable;

struct p_SliceVariable : public ::mosek::fusion::p_BaseVariable
{
SliceVariable * _pubthis;
static mosek::fusion::p_SliceVariable* _get_impl(mosek::fusion::SliceVariable * _inst){ return static_cast< mosek::fusion::p_SliceVariable* >(mosek::fusion::p_BaseVariable::_get_impl(_inst)); }
static mosek::fusion::p_SliceVariable * _get_impl(mosek::fusion::SliceVariable::t _inst) { return _get_impl(_inst.get()); }
p_SliceVariable(SliceVariable * _pubthis);
virtual ~p_SliceVariable() { /* std::cout << "~p_SliceVariable" << std::endl;*/ };
std::shared_ptr< monty::ndarray< long long,1 > > strides{};long long first{};monty::rc_ptr< ::mosek::fusion::Variable > origin{};virtual void destroy();
static SliceVariable::t _new_SliceVariable(monty::rc_ptr< ::mosek::fusion::Variable > _1624,monty::rc_ptr< ::mosek::fusion::Set > _1625,long long _1626,std::shared_ptr< monty::ndarray< long long,1 > > _1627);
void _initialize(monty::rc_ptr< ::mosek::fusion::Variable > _1624,monty::rc_ptr< ::mosek::fusion::Set > _1625,long long _1626,std::shared_ptr< monty::ndarray< long long,1 > > _1627);
virtual void inst(long long _1628,long long _1629,std::shared_ptr< monty::ndarray< int,1 > > _1630,std::shared_ptr< monty::ndarray< int,1 > > _1631,std::shared_ptr< monty::ndarray< int,1 > > _1632);
virtual void set_values(long long _1637,std::shared_ptr< monty::ndarray< int,1 > > _1638,std::shared_ptr< monty::ndarray< long long,1 > > _1639,int _1640,std::shared_ptr< monty::ndarray< double,1 > > _1641,bool _1642);
virtual void set_values(std::shared_ptr< monty::ndarray< long long,1 > > _1661,std::shared_ptr< monty::ndarray< double,1 > > _1662,bool _1663);
virtual monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > elementDesc(long long _1669,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _1670);
virtual void elementName(long long _1675,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _1676);
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(std::shared_ptr< monty::ndarray< int,1 > > _1681,std::shared_ptr< monty::ndarray< int,1 > > _1682);
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(int _1686,int _1687);
virtual void values(long long _1688,std::shared_ptr< monty::ndarray< int,1 > > _1689,std::shared_ptr< monty::ndarray< long long,1 > > _1690,int _1691,std::shared_ptr< monty::ndarray< double,1 > > _1692,bool _1693);
virtual void values(std::shared_ptr< monty::ndarray< long long,1 > > _1711,int _1712,std::shared_ptr< monty::ndarray< double,1 > > _1713,bool _1714);
virtual void make_continuous(std::shared_ptr< monty::ndarray< long long,1 > > _1720);
virtual void make_integer(std::shared_ptr< monty::ndarray< long long,1 > > _1726);
}; // struct SliceVariable;

struct p_BoundInterfaceVariable : public ::mosek::fusion::p_SliceVariable
{
BoundInterfaceVariable * _pubthis;
static mosek::fusion::p_BoundInterfaceVariable* _get_impl(mosek::fusion::BoundInterfaceVariable * _inst){ return static_cast< mosek::fusion::p_BoundInterfaceVariable* >(mosek::fusion::p_SliceVariable::_get_impl(_inst)); }
static mosek::fusion::p_BoundInterfaceVariable * _get_impl(mosek::fusion::BoundInterfaceVariable::t _inst) { return _get_impl(_inst.get()); }
p_BoundInterfaceVariable(BoundInterfaceVariable * _pubthis);
virtual ~p_BoundInterfaceVariable() { /* std::cout << "~p_BoundInterfaceVariable" << std::endl;*/ };
monty::rc_ptr< ::mosek::fusion::RangedVariable > originvar{};bool islower{};virtual void destroy();
static BoundInterfaceVariable::t _new_BoundInterfaceVariable(monty::rc_ptr< ::mosek::fusion::RangedVariable > _2500,monty::rc_ptr< ::mosek::fusion::Set > _2501,long long _2502,std::shared_ptr< monty::ndarray< long long,1 > > _2503,bool _2504);
void _initialize(monty::rc_ptr< ::mosek::fusion::RangedVariable > _2500,monty::rc_ptr< ::mosek::fusion::Set > _2501,long long _2502,std::shared_ptr< monty::ndarray< long long,1 > > _2503,bool _2504);
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice_(monty::rc_ptr< ::mosek::fusion::Set > _2505,long long _2506,std::shared_ptr< monty::ndarray< long long,1 > > _2507);
virtual void dual_values(long long _2508,std::shared_ptr< monty::ndarray< int,1 > > _2509,std::shared_ptr< monty::ndarray< long long,1 > > _2510,int _2511,std::shared_ptr< monty::ndarray< double,1 > > _2512);
virtual void dual_values(std::shared_ptr< monty::ndarray< long long,1 > > _2513,int _2514,std::shared_ptr< monty::ndarray< double,1 > > _2515);
}; // struct BoundInterfaceVariable;

struct p_ModelVariable : public ::mosek::fusion::p_BaseVariable
{
ModelVariable * _pubthis;
static mosek::fusion::p_ModelVariable* _get_impl(mosek::fusion::ModelVariable * _inst){ return static_cast< mosek::fusion::p_ModelVariable* >(mosek::fusion::p_BaseVariable::_get_impl(_inst)); }
static mosek::fusion::p_ModelVariable * _get_impl(mosek::fusion::ModelVariable::t _inst) { return _get_impl(_inst.get()); }
p_ModelVariable(ModelVariable * _pubthis);
virtual ~p_ModelVariable() { /* std::cout << "~p_ModelVariable" << std::endl;*/ };
long long varid{};std::string name{};virtual void destroy();
static ModelVariable::t _new_ModelVariable(monty::rc_ptr< ::mosek::fusion::ModelVariable > _2596,monty::rc_ptr< ::mosek::fusion::Model > _2597);
void _initialize(monty::rc_ptr< ::mosek::fusion::ModelVariable > _2596,monty::rc_ptr< ::mosek::fusion::Model > _2597);
static ModelVariable::t _new_ModelVariable(monty::rc_ptr< ::mosek::fusion::Model > _2598,const std::string &  _2599,monty::rc_ptr< ::mosek::fusion::Set > _2600,long long _2601);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2598,const std::string &  _2599,monty::rc_ptr< ::mosek::fusion::Set > _2600,long long _2601);
virtual void flushNames() { throw monty::AbstractClassError("Call to abstract method"); }
virtual void elementName(long long _2602,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2603);
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(std::shared_ptr< monty::ndarray< int,1 > > _2604,std::shared_ptr< monty::ndarray< int,1 > > _2605);
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(int _2611,int _2612);
virtual monty::rc_ptr< ::mosek::fusion::ModelVariable > clone(monty::rc_ptr< ::mosek::fusion::Model > _2614) { throw monty::AbstractClassError("Call to abstract method"); }
}; // struct ModelVariable;

struct p_SymRangedVariable : public ::mosek::fusion::p_ModelVariable, public /*implements*/ ::mosek::fusion::SymmetricVariable
{
SymRangedVariable * _pubthis;
static mosek::fusion::p_SymRangedVariable* _get_impl(mosek::fusion::SymRangedVariable * _inst){ return static_cast< mosek::fusion::p_SymRangedVariable* >(mosek::fusion::p_ModelVariable::_get_impl(_inst)); }
static mosek::fusion::p_SymRangedVariable * _get_impl(mosek::fusion::SymRangedVariable::t _inst) { return _get_impl(_inst.get()); }
p_SymRangedVariable(SymRangedVariable * _pubthis);
virtual ~p_SymRangedVariable() { /* std::cout << "~p_SymRangedVariable" << std::endl;*/ };
int dim{};bool names_flushed{};std::shared_ptr< monty::ndarray< int,1 > > nativeidxs{};monty::rc_ptr< ::mosek::fusion::RangeDomain > dom{};monty::rc_ptr< ::mosek::fusion::Utils::IntMap > idxmap{};virtual void destroy();
static SymRangedVariable::t _new_SymRangedVariable(monty::rc_ptr< ::mosek::fusion::SymRangedVariable > _1732,monty::rc_ptr< ::mosek::fusion::Model > _1733);
void _initialize(monty::rc_ptr< ::mosek::fusion::SymRangedVariable > _1732,monty::rc_ptr< ::mosek::fusion::Model > _1733);
static SymRangedVariable::t _new_SymRangedVariable(monty::rc_ptr< ::mosek::fusion::Model > _1735,const std::string &  _1736,monty::rc_ptr< ::mosek::fusion::RangeDomain > _1737,int _1738,std::shared_ptr< monty::ndarray< int,1 > > _1739,long long _1740);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _1735,const std::string &  _1736,monty::rc_ptr< ::mosek::fusion::RangeDomain > _1737,int _1738,std::shared_ptr< monty::ndarray< int,1 > > _1739,long long _1740);
virtual std::string toString();
virtual void flushNames();
virtual void inst(std::shared_ptr< monty::ndarray< long long,1 > > _1747,int _1748,int _1749,long long _1750,long long _1751,std::shared_ptr< monty::ndarray< int,1 > > _1752,std::shared_ptr< monty::ndarray< int,1 > > _1753,std::shared_ptr< monty::ndarray< int,1 > > _1754);
virtual void inst(long long _1760,long long _1761,std::shared_ptr< monty::ndarray< int,1 > > _1762,std::shared_ptr< monty::ndarray< int,1 > > _1763,std::shared_ptr< monty::ndarray< int,1 > > _1764);
virtual void dual_u(long long _1769,std::shared_ptr< monty::ndarray< int,1 > > _1770,std::shared_ptr< monty::ndarray< long long,1 > > _1771,int _1772,std::shared_ptr< monty::ndarray< double,1 > > _1773);
virtual void dual_u(std::shared_ptr< monty::ndarray< long long,1 > > _1785,int _1786,std::shared_ptr< monty::ndarray< double,1 > > _1787);
virtual void dual_l(long long _1795,std::shared_ptr< monty::ndarray< int,1 > > _1796,std::shared_ptr< monty::ndarray< long long,1 > > _1797,int _1798,std::shared_ptr< monty::ndarray< double,1 > > _1799);
virtual void dual_l(std::shared_ptr< monty::ndarray< long long,1 > > _1811,int _1812,std::shared_ptr< monty::ndarray< double,1 > > _1813);
virtual void dual_values(long long _1820,std::shared_ptr< monty::ndarray< int,1 > > _1821,std::shared_ptr< monty::ndarray< long long,1 > > _1822,int _1823,std::shared_ptr< monty::ndarray< double,1 > > _1824);
virtual void dual_values(std::shared_ptr< monty::ndarray< long long,1 > > _1836,int _1837,std::shared_ptr< monty::ndarray< double,1 > > _1838);
virtual void set_values(long long _1846,std::shared_ptr< monty::ndarray< int,1 > > _1847,std::shared_ptr< monty::ndarray< long long,1 > > _1848,int _1849,std::shared_ptr< monty::ndarray< double,1 > > _1850,bool _1851);
virtual void set_values(std::shared_ptr< monty::ndarray< long long,1 > > _1865,std::shared_ptr< monty::ndarray< double,1 > > _1866,bool _1867);
virtual void values(long long _1877,std::shared_ptr< monty::ndarray< int,1 > > _1878,std::shared_ptr< monty::ndarray< long long,1 > > _1879,int _1880,std::shared_ptr< monty::ndarray< double,1 > > _1881,bool _1882);
virtual void values(std::shared_ptr< monty::ndarray< long long,1 > > _1891,int _1892,std::shared_ptr< monty::ndarray< double,1 > > _1893,bool _1894);
virtual long long tril_idx(long long _1901);
virtual long long tril_lin_idx(long long _1904);
virtual void make_continuous(std::shared_ptr< monty::ndarray< long long,1 > > _1907);
virtual void make_integer(std::shared_ptr< monty::ndarray< long long,1 > > _1910);
virtual monty::rc_ptr< ::mosek::fusion::ModelVariable > clone(monty::rc_ptr< ::mosek::fusion::Model > _1913);
virtual monty::rc_ptr< ::mosek::fusion::Expression > asExpr() /*override*/
{ return mosek::fusion::p_BaseVariable::asExpr(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(int _2611,int _2612) /*override*/
{ return mosek::fusion::p_ModelVariable::slice(_2611,_2612); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,2 > > _2738) /*override*/
{ return mosek::fusion::p_BaseVariable::pick(_2738); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,1 > > _2741) /*override*/
{ return mosek::fusion::p_BaseVariable::pick(_2741); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > antidiag() /*override*/
{ return mosek::fusion::p_BaseVariable::antidiag(); }
virtual void makeContinuous() /*override*/
{ mosek::fusion::p_BaseVariable::makeContinuous(); }
virtual monty::rc_ptr< ::mosek::fusion::Set > shape() /*override*/
{ return mosek::fusion::p_BaseVariable::shape(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,1 > > _2731,std::shared_ptr< monty::ndarray< int,1 > > _2732,std::shared_ptr< monty::ndarray< int,1 > > _2733) /*override*/
{ return mosek::fusion::p_BaseVariable::pick(_2731,_2732,_2733); }
virtual void elementName(long long _2602,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2603) /*override*/
{ mosek::fusion::p_ModelVariable::elementName(_2602,_2603); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(int _2730) /*override*/
{ return mosek::fusion::p_BaseVariable::index(_2730); }
virtual void makeInteger() /*override*/
{ mosek::fusion::p_BaseVariable::makeInteger(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(int _2724,int _2725,int _2726) /*override*/
{ return mosek::fusion::p_BaseVariable::index(_2724,_2725,_2726); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > diag() /*override*/
{ return mosek::fusion::p_BaseVariable::diag(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(int _2727,int _2728) /*override*/
{ return mosek::fusion::p_BaseVariable::index(_2727,_2728); }
virtual monty::rc_ptr< ::mosek::fusion::Set > getShape() /*override*/
{ return mosek::fusion::p_BaseVariable::getShape(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > transpose() /*override*/
{ return mosek::fusion::p_BaseVariable::transpose(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(std::shared_ptr< monty::ndarray< int,1 > > _2729) /*override*/
{ return mosek::fusion::p_BaseVariable::index(_2729); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,1 > > _2735,std::shared_ptr< monty::ndarray< int,1 > > _2736) /*override*/
{ return mosek::fusion::p_BaseVariable::pick(_2735,_2736); }
virtual std::shared_ptr< monty::ndarray< double,1 > > level() /*override*/
{ return mosek::fusion::p_BaseVariable::level(); }
virtual monty::rc_ptr< ::mosek::fusion::Model > getModel() /*override*/
{ return mosek::fusion::p_BaseVariable::getModel(); }
virtual void setLevel(std::shared_ptr< monty::ndarray< double,1 > > _2715) /*override*/
{ mosek::fusion::p_BaseVariable::setLevel(_2715); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > diag(int _2744) /*override*/
{ return mosek::fusion::p_BaseVariable::diag(_2744); }
virtual std::shared_ptr< monty::ndarray< double,1 > > dual() /*override*/
{ return mosek::fusion::p_BaseVariable::dual(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(std::shared_ptr< monty::ndarray< int,1 > > _2604,std::shared_ptr< monty::ndarray< int,1 > > _2605) /*override*/
{ return mosek::fusion::p_ModelVariable::slice(_2604,_2605); }
virtual monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > elementDesc(long long _2666,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2667) /*override*/
{ return mosek::fusion::p_BaseVariable::elementDesc(_2666,_2667); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > antidiag(int _2743) /*override*/
{ return mosek::fusion::p_BaseVariable::antidiag(_2743); }
virtual long long size() /*override*/
{ return mosek::fusion::p_BaseVariable::size(); }
virtual void values(int _2698,std::shared_ptr< monty::ndarray< double,1 > > _2699,bool _2700) /*override*/
{ mosek::fusion::p_BaseVariable::values(_2698,_2699,_2700); }
}; // struct SymRangedVariable;

struct p_RangedVariable : public ::mosek::fusion::p_ModelVariable
{
RangedVariable * _pubthis;
static mosek::fusion::p_RangedVariable* _get_impl(mosek::fusion::RangedVariable * _inst){ return static_cast< mosek::fusion::p_RangedVariable* >(mosek::fusion::p_ModelVariable::_get_impl(_inst)); }
static mosek::fusion::p_RangedVariable * _get_impl(mosek::fusion::RangedVariable::t _inst) { return _get_impl(_inst.get()); }
p_RangedVariable(RangedVariable * _pubthis);
virtual ~p_RangedVariable() { /* std::cout << "~p_RangedVariable" << std::endl;*/ };
bool names_flushed{};std::shared_ptr< monty::ndarray< int,1 > > nativeidxs{};monty::rc_ptr< ::mosek::fusion::RangeDomain > dom{};monty::rc_ptr< ::mosek::fusion::Utils::IntMap > idxmap{};virtual void destroy();
static RangedVariable::t _new_RangedVariable(monty::rc_ptr< ::mosek::fusion::RangedVariable > _1914,monty::rc_ptr< ::mosek::fusion::Model > _1915);
void _initialize(monty::rc_ptr< ::mosek::fusion::RangedVariable > _1914,monty::rc_ptr< ::mosek::fusion::Model > _1915);
static RangedVariable::t _new_RangedVariable(monty::rc_ptr< ::mosek::fusion::Model > _1917,const std::string &  _1918,monty::rc_ptr< ::mosek::fusion::Set > _1919,monty::rc_ptr< ::mosek::fusion::RangeDomain > _1920,std::shared_ptr< monty::ndarray< int,1 > > _1921,long long _1922);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _1917,const std::string &  _1918,monty::rc_ptr< ::mosek::fusion::Set > _1919,monty::rc_ptr< ::mosek::fusion::RangeDomain > _1920,std::shared_ptr< monty::ndarray< int,1 > > _1921,long long _1922);
virtual monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > elementDesc(long long _1923,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _1924);
virtual void flushNames();
virtual void inst(std::shared_ptr< monty::ndarray< long long,1 > > _1929,int _1930,int _1931,long long _1932,long long _1933,std::shared_ptr< monty::ndarray< int,1 > > _1934,std::shared_ptr< monty::ndarray< int,1 > > _1935,std::shared_ptr< monty::ndarray< int,1 > > _1936);
virtual void inst(long long _1940,long long _1941,std::shared_ptr< monty::ndarray< int,1 > > _1942,std::shared_ptr< monty::ndarray< int,1 > > _1943,std::shared_ptr< monty::ndarray< int,1 > > _1944);
virtual monty::rc_ptr< ::mosek::fusion::Variable > upperBoundVar();
virtual monty::rc_ptr< ::mosek::fusion::Variable > lowerBoundVar();
virtual void dual_u(long long _1951,std::shared_ptr< monty::ndarray< int,1 > > _1952,std::shared_ptr< monty::ndarray< long long,1 > > _1953,int _1954,std::shared_ptr< monty::ndarray< double,1 > > _1955);
virtual void dual_u(std::shared_ptr< monty::ndarray< long long,1 > > _1966,int _1967,std::shared_ptr< monty::ndarray< double,1 > > _1968);
virtual void dual_l(long long _1975,std::shared_ptr< monty::ndarray< int,1 > > _1976,std::shared_ptr< monty::ndarray< long long,1 > > _1977,int _1978,std::shared_ptr< monty::ndarray< double,1 > > _1979);
virtual void dual_l(std::shared_ptr< monty::ndarray< long long,1 > > _1990,int _1991,std::shared_ptr< monty::ndarray< double,1 > > _1992);
virtual void dual_values(long long _1999,std::shared_ptr< monty::ndarray< int,1 > > _2000,std::shared_ptr< monty::ndarray< long long,1 > > _2001,int _2002,std::shared_ptr< monty::ndarray< double,1 > > _2003);
virtual void dual_values(std::shared_ptr< monty::ndarray< long long,1 > > _2015,int _2016,std::shared_ptr< monty::ndarray< double,1 > > _2017);
virtual void set_values(long long _2025,std::shared_ptr< monty::ndarray< int,1 > > _2026,std::shared_ptr< monty::ndarray< long long,1 > > _2027,int _2028,std::shared_ptr< monty::ndarray< double,1 > > _2029,bool _2030);
virtual void set_values(std::shared_ptr< monty::ndarray< long long,1 > > _2044,std::shared_ptr< monty::ndarray< double,1 > > _2045,bool _2046);
virtual void values(long long _2056,std::shared_ptr< monty::ndarray< int,1 > > _2057,std::shared_ptr< monty::ndarray< long long,1 > > _2058,int _2059,std::shared_ptr< monty::ndarray< double,1 > > _2060,bool _2061);
virtual void values(std::shared_ptr< monty::ndarray< long long,1 > > _2070,int _2071,std::shared_ptr< monty::ndarray< double,1 > > _2072,bool _2073);
virtual void make_continuous(std::shared_ptr< monty::ndarray< long long,1 > > _2078);
virtual void make_integer(std::shared_ptr< monty::ndarray< long long,1 > > _2081);
virtual monty::rc_ptr< ::mosek::fusion::ModelVariable > clone(monty::rc_ptr< ::mosek::fusion::Model > _2084);
}; // struct RangedVariable;

struct p_LinearPSDVariable : public ::mosek::fusion::p_ModelVariable
{
LinearPSDVariable * _pubthis;
static mosek::fusion::p_LinearPSDVariable* _get_impl(mosek::fusion::LinearPSDVariable * _inst){ return static_cast< mosek::fusion::p_LinearPSDVariable* >(mosek::fusion::p_ModelVariable::_get_impl(_inst)); }
static mosek::fusion::p_LinearPSDVariable * _get_impl(mosek::fusion::LinearPSDVariable::t _inst) { return _get_impl(_inst.get()); }
p_LinearPSDVariable(LinearPSDVariable * _pubthis);
virtual ~p_LinearPSDVariable() { /* std::cout << "~p_LinearPSDVariable" << std::endl;*/ };
int numcones{};int coneidx{};int conesize{};int sdpvardim{};int blocksize{};virtual void destroy();
static LinearPSDVariable::t _new_LinearPSDVariable(monty::rc_ptr< ::mosek::fusion::LinearPSDVariable > _2085,monty::rc_ptr< ::mosek::fusion::Model > _2086);
void _initialize(monty::rc_ptr< ::mosek::fusion::LinearPSDVariable > _2085,monty::rc_ptr< ::mosek::fusion::Model > _2086);
static LinearPSDVariable::t _new_LinearPSDVariable(monty::rc_ptr< ::mosek::fusion::Model > _2087,const std::string &  _2088,int _2089,monty::rc_ptr< ::mosek::fusion::Set > _2090,int _2091,long long _2092);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2087,const std::string &  _2088,int _2089,monty::rc_ptr< ::mosek::fusion::Set > _2090,int _2091,long long _2092);
virtual void flushNames();
virtual std::string toString();
virtual void inst(std::shared_ptr< monty::ndarray< long long,1 > > _2096,int _2097,int _2098,long long _2099,long long _2100,std::shared_ptr< monty::ndarray< int,1 > > _2101,std::shared_ptr< monty::ndarray< int,1 > > _2102,std::shared_ptr< monty::ndarray< int,1 > > _2103);
virtual void inst(long long _2113,long long _2114,std::shared_ptr< monty::ndarray< int,1 > > _2115,std::shared_ptr< monty::ndarray< int,1 > > _2116,std::shared_ptr< monty::ndarray< int,1 > > _2117);
virtual void set_values(long long _2123,std::shared_ptr< monty::ndarray< int,1 > > _2124,std::shared_ptr< monty::ndarray< long long,1 > > _2125,int _2126,std::shared_ptr< monty::ndarray< double,1 > > _2127,bool _2128);
virtual void set_values(std::shared_ptr< monty::ndarray< long long,1 > > _2129,std::shared_ptr< monty::ndarray< double,1 > > _2130,bool _2131);
virtual void values(long long _2132,std::shared_ptr< monty::ndarray< int,1 > > _2133,std::shared_ptr< monty::ndarray< long long,1 > > _2134,int _2135,std::shared_ptr< monty::ndarray< double,1 > > _2136,bool _2137);
virtual void values(std::shared_ptr< monty::ndarray< long long,1 > > _2146,int _2147,std::shared_ptr< monty::ndarray< double,1 > > _2148,bool _2149);
virtual void make_continuous(std::shared_ptr< monty::ndarray< long long,1 > > _2155);
virtual void make_integer(std::shared_ptr< monty::ndarray< long long,1 > > _2156);
virtual monty::rc_ptr< ::mosek::fusion::ModelVariable > clone(monty::rc_ptr< ::mosek::fusion::Model > _2157);
}; // struct LinearPSDVariable;

struct p_PSDVariable : public ::mosek::fusion::p_ModelVariable, public /*implements*/ ::mosek::fusion::SymmetricVariable
{
PSDVariable * _pubthis;
static mosek::fusion::p_PSDVariable* _get_impl(mosek::fusion::PSDVariable * _inst){ return static_cast< mosek::fusion::p_PSDVariable* >(mosek::fusion::p_ModelVariable::_get_impl(_inst)); }
static mosek::fusion::p_PSDVariable * _get_impl(mosek::fusion::PSDVariable::t _inst) { return _get_impl(_inst.get()); }
p_PSDVariable(PSDVariable * _pubthis);
virtual ~p_PSDVariable() { /* std::cout << "~p_PSDVariable" << std::endl;*/ };
int numcones{};int coneidx{};int conesize{};virtual void destroy();
static PSDVariable::t _new_PSDVariable(monty::rc_ptr< ::mosek::fusion::PSDVariable > _2158,monty::rc_ptr< ::mosek::fusion::Model > _2159);
void _initialize(monty::rc_ptr< ::mosek::fusion::PSDVariable > _2158,monty::rc_ptr< ::mosek::fusion::Model > _2159);
static PSDVariable::t _new_PSDVariable(monty::rc_ptr< ::mosek::fusion::Model > _2160,const std::string &  _2161,int _2162,int _2163,int _2164,long long _2165);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2160,const std::string &  _2161,int _2162,int _2163,int _2164,long long _2165);
virtual void flushNames();
virtual std::string toString();
virtual monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > elementDesc(long long _2168,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2169);
virtual void elementName(long long _2175,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2176);
virtual void inst(std::shared_ptr< monty::ndarray< long long,1 > > _2182,int _2183,int _2184,long long _2185,long long _2186,std::shared_ptr< monty::ndarray< int,1 > > _2187,std::shared_ptr< monty::ndarray< int,1 > > _2188,std::shared_ptr< monty::ndarray< int,1 > > _2189);
virtual void inst(long long _2198,long long _2199,std::shared_ptr< monty::ndarray< int,1 > > _2200,std::shared_ptr< monty::ndarray< int,1 > > _2201,std::shared_ptr< monty::ndarray< int,1 > > _2202);
virtual void set_values(long long _2207,std::shared_ptr< monty::ndarray< int,1 > > _2208,std::shared_ptr< monty::ndarray< long long,1 > > _2209,int _2210,std::shared_ptr< monty::ndarray< double,1 > > _2211,bool _2212);
virtual void set_values(std::shared_ptr< monty::ndarray< long long,1 > > _2213,std::shared_ptr< monty::ndarray< double,1 > > _2214,bool _2215);
virtual void values(long long _2216,std::shared_ptr< monty::ndarray< int,1 > > _2217,std::shared_ptr< monty::ndarray< long long,1 > > _2218,int _2219,std::shared_ptr< monty::ndarray< double,1 > > _2220,bool _2221);
virtual void values(std::shared_ptr< monty::ndarray< long long,1 > > _2233,int _2234,std::shared_ptr< monty::ndarray< double,1 > > _2235,bool _2236);
virtual void make_continuous(std::shared_ptr< monty::ndarray< long long,1 > > _2244);
virtual void make_integer(std::shared_ptr< monty::ndarray< long long,1 > > _2245);
virtual monty::rc_ptr< ::mosek::fusion::ModelVariable > clone(monty::rc_ptr< ::mosek::fusion::Model > _2246);
virtual monty::rc_ptr< ::mosek::fusion::Expression > asExpr() /*override*/
{ return mosek::fusion::p_BaseVariable::asExpr(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(int _2611,int _2612) /*override*/
{ return mosek::fusion::p_ModelVariable::slice(_2611,_2612); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,2 > > _2738) /*override*/
{ return mosek::fusion::p_BaseVariable::pick(_2738); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,1 > > _2741) /*override*/
{ return mosek::fusion::p_BaseVariable::pick(_2741); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > antidiag() /*override*/
{ return mosek::fusion::p_BaseVariable::antidiag(); }
virtual void makeContinuous() /*override*/
{ mosek::fusion::p_BaseVariable::makeContinuous(); }
virtual monty::rc_ptr< ::mosek::fusion::Set > shape() /*override*/
{ return mosek::fusion::p_BaseVariable::shape(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,1 > > _2731,std::shared_ptr< monty::ndarray< int,1 > > _2732,std::shared_ptr< monty::ndarray< int,1 > > _2733) /*override*/
{ return mosek::fusion::p_BaseVariable::pick(_2731,_2732,_2733); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(int _2730) /*override*/
{ return mosek::fusion::p_BaseVariable::index(_2730); }
virtual void makeInteger() /*override*/
{ mosek::fusion::p_BaseVariable::makeInteger(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(int _2724,int _2725,int _2726) /*override*/
{ return mosek::fusion::p_BaseVariable::index(_2724,_2725,_2726); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > diag() /*override*/
{ return mosek::fusion::p_BaseVariable::diag(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(int _2727,int _2728) /*override*/
{ return mosek::fusion::p_BaseVariable::index(_2727,_2728); }
virtual monty::rc_ptr< ::mosek::fusion::Set > getShape() /*override*/
{ return mosek::fusion::p_BaseVariable::getShape(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > transpose() /*override*/
{ return mosek::fusion::p_BaseVariable::transpose(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(std::shared_ptr< monty::ndarray< int,1 > > _2729) /*override*/
{ return mosek::fusion::p_BaseVariable::index(_2729); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,1 > > _2735,std::shared_ptr< monty::ndarray< int,1 > > _2736) /*override*/
{ return mosek::fusion::p_BaseVariable::pick(_2735,_2736); }
virtual std::shared_ptr< monty::ndarray< double,1 > > level() /*override*/
{ return mosek::fusion::p_BaseVariable::level(); }
virtual monty::rc_ptr< ::mosek::fusion::Model > getModel() /*override*/
{ return mosek::fusion::p_BaseVariable::getModel(); }
virtual void setLevel(std::shared_ptr< monty::ndarray< double,1 > > _2715) /*override*/
{ mosek::fusion::p_BaseVariable::setLevel(_2715); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > diag(int _2744) /*override*/
{ return mosek::fusion::p_BaseVariable::diag(_2744); }
virtual std::shared_ptr< monty::ndarray< double,1 > > dual() /*override*/
{ return mosek::fusion::p_BaseVariable::dual(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(std::shared_ptr< monty::ndarray< int,1 > > _2604,std::shared_ptr< monty::ndarray< int,1 > > _2605) /*override*/
{ return mosek::fusion::p_ModelVariable::slice(_2604,_2605); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > antidiag(int _2743) /*override*/
{ return mosek::fusion::p_BaseVariable::antidiag(_2743); }
virtual long long size() /*override*/
{ return mosek::fusion::p_BaseVariable::size(); }
virtual void values(int _2698,std::shared_ptr< monty::ndarray< double,1 > > _2699,bool _2700) /*override*/
{ mosek::fusion::p_BaseVariable::values(_2698,_2699,_2700); }
}; // struct PSDVariable;

struct p_SymLinearVariable : public ::mosek::fusion::p_ModelVariable, public /*implements*/ ::mosek::fusion::SymmetricVariable
{
SymLinearVariable * _pubthis;
static mosek::fusion::p_SymLinearVariable* _get_impl(mosek::fusion::SymLinearVariable * _inst){ return static_cast< mosek::fusion::p_SymLinearVariable* >(mosek::fusion::p_ModelVariable::_get_impl(_inst)); }
static mosek::fusion::p_SymLinearVariable * _get_impl(mosek::fusion::SymLinearVariable::t _inst) { return _get_impl(_inst.get()); }
p_SymLinearVariable(SymLinearVariable * _pubthis);
virtual ~p_SymLinearVariable() { /* std::cout << "~p_SymLinearVariable" << std::endl;*/ };
int dim{};bool names_flushed{};monty::rc_ptr< ::mosek::fusion::SymmetricLinearDomain > dom{};std::shared_ptr< monty::ndarray< int,1 > > nativeidxs{};monty::rc_ptr< ::mosek::fusion::Utils::IntMap > idxmap{};virtual void destroy();
static SymLinearVariable::t _new_SymLinearVariable(monty::rc_ptr< ::mosek::fusion::SymLinearVariable > _2247,monty::rc_ptr< ::mosek::fusion::Model > _2248);
void _initialize(monty::rc_ptr< ::mosek::fusion::SymLinearVariable > _2247,monty::rc_ptr< ::mosek::fusion::Model > _2248);
static SymLinearVariable::t _new_SymLinearVariable(monty::rc_ptr< ::mosek::fusion::Model > _2250,const std::string &  _2251,monty::rc_ptr< ::mosek::fusion::SymmetricLinearDomain > _2252,int _2253,std::shared_ptr< monty::ndarray< int,1 > > _2254,long long _2255);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2250,const std::string &  _2251,monty::rc_ptr< ::mosek::fusion::SymmetricLinearDomain > _2252,int _2253,std::shared_ptr< monty::ndarray< int,1 > > _2254,long long _2255);
virtual std::string toString();
virtual void flushNames();
virtual void inst(std::shared_ptr< monty::ndarray< long long,1 > > _2265,int _2266,int _2267,long long _2268,long long _2269,std::shared_ptr< monty::ndarray< int,1 > > _2270,std::shared_ptr< monty::ndarray< int,1 > > _2271,std::shared_ptr< monty::ndarray< int,1 > > _2272);
virtual void inst(long long _2278,long long _2279,std::shared_ptr< monty::ndarray< int,1 > > _2280,std::shared_ptr< monty::ndarray< int,1 > > _2281,std::shared_ptr< monty::ndarray< int,1 > > _2282);
virtual void dual_values(long long _2286,std::shared_ptr< monty::ndarray< int,1 > > _2287,std::shared_ptr< monty::ndarray< long long,1 > > _2288,int _2289,std::shared_ptr< monty::ndarray< double,1 > > _2290);
virtual void dual_values(std::shared_ptr< monty::ndarray< long long,1 > > _2302,int _2303,std::shared_ptr< monty::ndarray< double,1 > > _2304);
virtual void set_values(long long _2312,std::shared_ptr< monty::ndarray< int,1 > > _2313,std::shared_ptr< monty::ndarray< long long,1 > > _2314,int _2315,std::shared_ptr< monty::ndarray< double,1 > > _2316,bool _2317);
virtual void set_values(std::shared_ptr< monty::ndarray< long long,1 > > _2331,std::shared_ptr< monty::ndarray< double,1 > > _2332,bool _2333);
virtual void values(long long _2341,std::shared_ptr< monty::ndarray< int,1 > > _2342,std::shared_ptr< monty::ndarray< long long,1 > > _2343,int _2344,std::shared_ptr< monty::ndarray< double,1 > > _2345,bool _2346);
virtual void values(std::shared_ptr< monty::ndarray< long long,1 > > _2356,int _2357,std::shared_ptr< monty::ndarray< double,1 > > _2358,bool _2359);
virtual void make_continuous(std::shared_ptr< monty::ndarray< long long,1 > > _2367);
virtual void make_integer(std::shared_ptr< monty::ndarray< long long,1 > > _2370);
virtual long long tril_idx(long long _2373);
virtual long long tril_lin_idx(long long _2376);
virtual monty::rc_ptr< ::mosek::fusion::ModelVariable > clone(monty::rc_ptr< ::mosek::fusion::Model > _2379);
virtual monty::rc_ptr< ::mosek::fusion::Expression > asExpr() /*override*/
{ return mosek::fusion::p_BaseVariable::asExpr(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(int _2611,int _2612) /*override*/
{ return mosek::fusion::p_ModelVariable::slice(_2611,_2612); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,2 > > _2738) /*override*/
{ return mosek::fusion::p_BaseVariable::pick(_2738); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,1 > > _2741) /*override*/
{ return mosek::fusion::p_BaseVariable::pick(_2741); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > antidiag() /*override*/
{ return mosek::fusion::p_BaseVariable::antidiag(); }
virtual void makeContinuous() /*override*/
{ mosek::fusion::p_BaseVariable::makeContinuous(); }
virtual monty::rc_ptr< ::mosek::fusion::Set > shape() /*override*/
{ return mosek::fusion::p_BaseVariable::shape(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,1 > > _2731,std::shared_ptr< monty::ndarray< int,1 > > _2732,std::shared_ptr< monty::ndarray< int,1 > > _2733) /*override*/
{ return mosek::fusion::p_BaseVariable::pick(_2731,_2732,_2733); }
virtual void elementName(long long _2602,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2603) /*override*/
{ mosek::fusion::p_ModelVariable::elementName(_2602,_2603); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(int _2730) /*override*/
{ return mosek::fusion::p_BaseVariable::index(_2730); }
virtual void makeInteger() /*override*/
{ mosek::fusion::p_BaseVariable::makeInteger(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(int _2724,int _2725,int _2726) /*override*/
{ return mosek::fusion::p_BaseVariable::index(_2724,_2725,_2726); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > diag() /*override*/
{ return mosek::fusion::p_BaseVariable::diag(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(int _2727,int _2728) /*override*/
{ return mosek::fusion::p_BaseVariable::index(_2727,_2728); }
virtual monty::rc_ptr< ::mosek::fusion::Set > getShape() /*override*/
{ return mosek::fusion::p_BaseVariable::getShape(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > transpose() /*override*/
{ return mosek::fusion::p_BaseVariable::transpose(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(std::shared_ptr< monty::ndarray< int,1 > > _2729) /*override*/
{ return mosek::fusion::p_BaseVariable::index(_2729); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,1 > > _2735,std::shared_ptr< monty::ndarray< int,1 > > _2736) /*override*/
{ return mosek::fusion::p_BaseVariable::pick(_2735,_2736); }
virtual std::shared_ptr< monty::ndarray< double,1 > > level() /*override*/
{ return mosek::fusion::p_BaseVariable::level(); }
virtual monty::rc_ptr< ::mosek::fusion::Model > getModel() /*override*/
{ return mosek::fusion::p_BaseVariable::getModel(); }
virtual void setLevel(std::shared_ptr< monty::ndarray< double,1 > > _2715) /*override*/
{ mosek::fusion::p_BaseVariable::setLevel(_2715); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > diag(int _2744) /*override*/
{ return mosek::fusion::p_BaseVariable::diag(_2744); }
virtual std::shared_ptr< monty::ndarray< double,1 > > dual() /*override*/
{ return mosek::fusion::p_BaseVariable::dual(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(std::shared_ptr< monty::ndarray< int,1 > > _2604,std::shared_ptr< monty::ndarray< int,1 > > _2605) /*override*/
{ return mosek::fusion::p_ModelVariable::slice(_2604,_2605); }
virtual monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > elementDesc(long long _2666,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2667) /*override*/
{ return mosek::fusion::p_BaseVariable::elementDesc(_2666,_2667); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > antidiag(int _2743) /*override*/
{ return mosek::fusion::p_BaseVariable::antidiag(_2743); }
virtual long long size() /*override*/
{ return mosek::fusion::p_BaseVariable::size(); }
virtual void values(int _2698,std::shared_ptr< monty::ndarray< double,1 > > _2699,bool _2700) /*override*/
{ mosek::fusion::p_BaseVariable::values(_2698,_2699,_2700); }
}; // struct SymLinearVariable;

struct p_LinearVariable : public ::mosek::fusion::p_ModelVariable
{
LinearVariable * _pubthis;
static mosek::fusion::p_LinearVariable* _get_impl(mosek::fusion::LinearVariable * _inst){ return static_cast< mosek::fusion::p_LinearVariable* >(mosek::fusion::p_ModelVariable::_get_impl(_inst)); }
static mosek::fusion::p_LinearVariable * _get_impl(mosek::fusion::LinearVariable::t _inst) { return _get_impl(_inst.get()); }
p_LinearVariable(LinearVariable * _pubthis);
virtual ~p_LinearVariable() { /* std::cout << "~p_LinearVariable" << std::endl;*/ };
bool names_flushed{};monty::rc_ptr< ::mosek::fusion::LinearDomain > dom{};std::shared_ptr< monty::ndarray< int,1 > > nativeidxs{};monty::rc_ptr< ::mosek::fusion::Utils::IntMap > idxmap{};virtual void destroy();
static LinearVariable::t _new_LinearVariable(monty::rc_ptr< ::mosek::fusion::LinearVariable > _2380,monty::rc_ptr< ::mosek::fusion::Model > _2381);
void _initialize(monty::rc_ptr< ::mosek::fusion::LinearVariable > _2380,monty::rc_ptr< ::mosek::fusion::Model > _2381);
static LinearVariable::t _new_LinearVariable(monty::rc_ptr< ::mosek::fusion::Model > _2383,const std::string &  _2384,monty::rc_ptr< ::mosek::fusion::LinearDomain > _2385,monty::rc_ptr< ::mosek::fusion::Set > _2386,std::shared_ptr< monty::ndarray< int,1 > > _2387,long long _2388);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2383,const std::string &  _2384,monty::rc_ptr< ::mosek::fusion::LinearDomain > _2385,monty::rc_ptr< ::mosek::fusion::Set > _2386,std::shared_ptr< monty::ndarray< int,1 > > _2387,long long _2388);
virtual monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > elementDesc(long long _2389,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2390);
virtual void elementName(long long _2391,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2392);
virtual void flushNames();
virtual void inst(std::shared_ptr< monty::ndarray< long long,1 > > _2397,int _2398,int _2399,long long _2400,long long _2401,std::shared_ptr< monty::ndarray< int,1 > > _2402,std::shared_ptr< monty::ndarray< int,1 > > _2403,std::shared_ptr< monty::ndarray< int,1 > > _2404);
virtual void inst(long long _2408,long long _2409,std::shared_ptr< monty::ndarray< int,1 > > _2410,std::shared_ptr< monty::ndarray< int,1 > > _2411,std::shared_ptr< monty::ndarray< int,1 > > _2412);
virtual void dual_values(long long _2414,std::shared_ptr< monty::ndarray< int,1 > > _2415,std::shared_ptr< monty::ndarray< long long,1 > > _2416,int _2417,std::shared_ptr< monty::ndarray< double,1 > > _2418);
virtual void dual_values(std::shared_ptr< monty::ndarray< long long,1 > > _2430,int _2431,std::shared_ptr< monty::ndarray< double,1 > > _2432);
virtual void set_values(long long _2440,std::shared_ptr< monty::ndarray< int,1 > > _2441,std::shared_ptr< monty::ndarray< long long,1 > > _2442,int _2443,std::shared_ptr< monty::ndarray< double,1 > > _2444,bool _2445);
virtual void set_values(std::shared_ptr< monty::ndarray< long long,1 > > _2459,std::shared_ptr< monty::ndarray< double,1 > > _2460,bool _2461);
virtual void values(long long _2471,std::shared_ptr< monty::ndarray< int,1 > > _2472,std::shared_ptr< monty::ndarray< long long,1 > > _2473,int _2474,std::shared_ptr< monty::ndarray< double,1 > > _2475,bool _2476);
virtual void make_continuous(std::shared_ptr< monty::ndarray< long long,1 > > _2485);
virtual void make_integer(std::shared_ptr< monty::ndarray< long long,1 > > _2488);
virtual void values(std::shared_ptr< monty::ndarray< long long,1 > > _2491,int _2492,std::shared_ptr< monty::ndarray< double,1 > > _2493,bool _2494);
virtual monty::rc_ptr< ::mosek::fusion::ModelVariable > clone(monty::rc_ptr< ::mosek::fusion::Model > _2499);
}; // struct LinearVariable;

struct p_ConicVariable : public ::mosek::fusion::p_ModelVariable
{
ConicVariable * _pubthis;
static mosek::fusion::p_ConicVariable* _get_impl(mosek::fusion::ConicVariable * _inst){ return static_cast< mosek::fusion::p_ConicVariable* >(mosek::fusion::p_ModelVariable::_get_impl(_inst)); }
static mosek::fusion::p_ConicVariable * _get_impl(mosek::fusion::ConicVariable::t _inst) { return _get_impl(_inst.get()); }
p_ConicVariable(ConicVariable * _pubthis);
virtual ~p_ConicVariable() { /* std::cout << "~p_ConicVariable" << std::endl;*/ };
bool names_flushed{};std::shared_ptr< monty::ndarray< int,1 > > nativeidxs{};monty::rc_ptr< ::mosek::fusion::QConeDomain > dom{};int numcone{};int conesize{};int coneidx{};virtual void destroy();
static ConicVariable::t _new_ConicVariable(monty::rc_ptr< ::mosek::fusion::ConicVariable > _2516,monty::rc_ptr< ::mosek::fusion::Model > _2517);
void _initialize(monty::rc_ptr< ::mosek::fusion::ConicVariable > _2516,monty::rc_ptr< ::mosek::fusion::Model > _2517);
static ConicVariable::t _new_ConicVariable(monty::rc_ptr< ::mosek::fusion::Model > _2519,const std::string &  _2520,monty::rc_ptr< ::mosek::fusion::QConeDomain > _2521,monty::rc_ptr< ::mosek::fusion::Set > _2522,std::shared_ptr< monty::ndarray< int,1 > > _2523,int _2524,int _2525,int _2526,long long _2527);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2519,const std::string &  _2520,monty::rc_ptr< ::mosek::fusion::QConeDomain > _2521,monty::rc_ptr< ::mosek::fusion::Set > _2522,std::shared_ptr< monty::ndarray< int,1 > > _2523,int _2524,int _2525,int _2526,long long _2527);
virtual std::string toString();
virtual monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > elementDesc(long long _2530,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2531);
virtual void elementName(long long _2532,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2533);
virtual void flushNames();
virtual void inst(std::shared_ptr< monty::ndarray< long long,1 > > _2535,int _2536,int _2537,long long _2538,long long _2539,std::shared_ptr< monty::ndarray< int,1 > > _2540,std::shared_ptr< monty::ndarray< int,1 > > _2541,std::shared_ptr< monty::ndarray< int,1 > > _2542);
virtual void inst(long long _2544,long long _2545,std::shared_ptr< monty::ndarray< int,1 > > _2546,std::shared_ptr< monty::ndarray< int,1 > > _2547,std::shared_ptr< monty::ndarray< int,1 > > _2548);
virtual void set_values(long long _2549,std::shared_ptr< monty::ndarray< int,1 > > _2550,std::shared_ptr< monty::ndarray< long long,1 > > _2551,int _2552,std::shared_ptr< monty::ndarray< double,1 > > _2553,bool _2554);
virtual void set_values(std::shared_ptr< monty::ndarray< long long,1 > > _2564,std::shared_ptr< monty::ndarray< double,1 > > _2565,bool _2566);
virtual void values(long long _2572,std::shared_ptr< monty::ndarray< int,1 > > _2573,std::shared_ptr< monty::ndarray< long long,1 > > _2574,int _2575,std::shared_ptr< monty::ndarray< double,1 > > _2576,bool _2577);
virtual void values(std::shared_ptr< monty::ndarray< long long,1 > > _2584,int _2585,std::shared_ptr< monty::ndarray< double,1 > > _2586,bool _2587);
virtual void make_continuous(std::shared_ptr< monty::ndarray< long long,1 > > _2590);
virtual void make_integer(std::shared_ptr< monty::ndarray< long long,1 > > _2592);
virtual int get_variable_index(int _2594);
virtual monty::rc_ptr< ::mosek::fusion::ModelVariable > clone(monty::rc_ptr< ::mosek::fusion::Model > _2595);
}; // struct ConicVariable;

struct p_NilVariable : public ::mosek::fusion::p_BaseVariable, public /*implements*/ ::mosek::fusion::SymmetricVariable
{
NilVariable * _pubthis;
static mosek::fusion::p_NilVariable* _get_impl(mosek::fusion::NilVariable * _inst){ return static_cast< mosek::fusion::p_NilVariable* >(mosek::fusion::p_BaseVariable::_get_impl(_inst)); }
static mosek::fusion::p_NilVariable * _get_impl(mosek::fusion::NilVariable::t _inst) { return _get_impl(_inst.get()); }
p_NilVariable(NilVariable * _pubthis);
virtual ~p_NilVariable() { /* std::cout << "~p_NilVariable" << std::endl;*/ };
virtual void destroy();
static NilVariable::t _new_NilVariable();
void _initialize();
virtual monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > elementDesc(long long _2615,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2616);
virtual void elementName(long long _2617,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2618);
virtual void inst(std::shared_ptr< monty::ndarray< long long,1 > > _2619,int _2620,int _2621,long long _2622,long long _2623,std::shared_ptr< monty::ndarray< int,1 > > _2624,std::shared_ptr< monty::ndarray< int,1 > > _2625,std::shared_ptr< monty::ndarray< int,1 > > _2626);
virtual void inst(long long _2627,long long _2628,std::shared_ptr< monty::ndarray< int,1 > > _2629,std::shared_ptr< monty::ndarray< int,1 > > _2630,std::shared_ptr< monty::ndarray< int,1 > > _2631);
virtual void set_values(std::shared_ptr< monty::ndarray< long long,1 > > _2632,std::shared_ptr< monty::ndarray< double,1 > > _2633,bool _2634);
virtual void set_values(long long _2635,std::shared_ptr< monty::ndarray< int,1 > > _2636,std::shared_ptr< monty::ndarray< long long,1 > > _2637,int _2638,std::shared_ptr< monty::ndarray< double,1 > > _2639,bool _2640);
virtual void values(std::shared_ptr< monty::ndarray< long long,1 > > _2641,int _2642,std::shared_ptr< monty::ndarray< double,1 > > _2643,bool _2644);
virtual void values(long long _2645,std::shared_ptr< monty::ndarray< int,1 > > _2646,std::shared_ptr< monty::ndarray< long long,1 > > _2647,int _2648,std::shared_ptr< monty::ndarray< double,1 > > _2649,bool _2650);
virtual void make_continuous(std::shared_ptr< monty::ndarray< long long,1 > > _2651);
virtual void make_integer(std::shared_ptr< monty::ndarray< long long,1 > > _2652);
virtual void makeContinuous();
virtual void makeInteger();
virtual std::string toString();
virtual long long size();
virtual std::shared_ptr< monty::ndarray< double,1 > > dual();
virtual std::shared_ptr< monty::ndarray< double,1 > > level();
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(std::shared_ptr< monty::ndarray< int,1 > > _2655);
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(int _2656);
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(std::shared_ptr< monty::ndarray< int,1 > > _2657,std::shared_ptr< monty::ndarray< int,1 > > _2658);
virtual monty::rc_ptr< ::mosek::fusion::Variable > slice(int _2660,int _2661);
virtual monty::rc_ptr< ::mosek::fusion::Expression > asExpr() /*override*/
{ return mosek::fusion::p_BaseVariable::asExpr(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,2 > > _2738) /*override*/
{ return mosek::fusion::p_BaseVariable::pick(_2738); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,1 > > _2741) /*override*/
{ return mosek::fusion::p_BaseVariable::pick(_2741); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > antidiag() /*override*/
{ return mosek::fusion::p_BaseVariable::antidiag(); }
virtual monty::rc_ptr< ::mosek::fusion::Set > shape() /*override*/
{ return mosek::fusion::p_BaseVariable::shape(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,1 > > _2731,std::shared_ptr< monty::ndarray< int,1 > > _2732,std::shared_ptr< monty::ndarray< int,1 > > _2733) /*override*/
{ return mosek::fusion::p_BaseVariable::pick(_2731,_2732,_2733); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(int _2724,int _2725,int _2726) /*override*/
{ return mosek::fusion::p_BaseVariable::index(_2724,_2725,_2726); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > diag() /*override*/
{ return mosek::fusion::p_BaseVariable::diag(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > index(int _2727,int _2728) /*override*/
{ return mosek::fusion::p_BaseVariable::index(_2727,_2728); }
virtual monty::rc_ptr< ::mosek::fusion::Set > getShape() /*override*/
{ return mosek::fusion::p_BaseVariable::getShape(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > transpose() /*override*/
{ return mosek::fusion::p_BaseVariable::transpose(); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > pick(std::shared_ptr< monty::ndarray< int,1 > > _2735,std::shared_ptr< monty::ndarray< int,1 > > _2736) /*override*/
{ return mosek::fusion::p_BaseVariable::pick(_2735,_2736); }
virtual monty::rc_ptr< ::mosek::fusion::Model > getModel() /*override*/
{ return mosek::fusion::p_BaseVariable::getModel(); }
virtual void setLevel(std::shared_ptr< monty::ndarray< double,1 > > _2715) /*override*/
{ mosek::fusion::p_BaseVariable::setLevel(_2715); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > diag(int _2744) /*override*/
{ return mosek::fusion::p_BaseVariable::diag(_2744); }
virtual monty::rc_ptr< ::mosek::fusion::Variable > antidiag(int _2743) /*override*/
{ return mosek::fusion::p_BaseVariable::antidiag(_2743); }
virtual void values(int _2698,std::shared_ptr< monty::ndarray< double,1 > > _2699,bool _2700) /*override*/
{ mosek::fusion::p_BaseVariable::values(_2698,_2699,_2700); }
}; // struct NilVariable;

struct p_Var
{
Var * _pubthis;
static mosek::fusion::p_Var* _get_impl(mosek::fusion::Var * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_Var * _get_impl(mosek::fusion::Var::t _inst) { return _get_impl(_inst.get()); }
p_Var(Var * _pubthis);
virtual ~p_Var() { /* std::cout << "~p_Var" << std::endl;*/ };
virtual void destroy();
static  monty::rc_ptr< ::mosek::fusion::Variable > compress(monty::rc_ptr< ::mosek::fusion::Variable > _2827);
static  monty::rc_ptr< ::mosek::fusion::Variable > reshape(monty::rc_ptr< ::mosek::fusion::Variable > _2832,int _2833);
static  monty::rc_ptr< ::mosek::fusion::Variable > reshape(monty::rc_ptr< ::mosek::fusion::Variable > _2834,int _2835,int _2836);
static  monty::rc_ptr< ::mosek::fusion::Variable > flatten(monty::rc_ptr< ::mosek::fusion::Variable > _2837);
static  monty::rc_ptr< ::mosek::fusion::Variable > reshape(monty::rc_ptr< ::mosek::fusion::Variable > _2838,std::shared_ptr< monty::ndarray< int,1 > > _2839);
static  monty::rc_ptr< ::mosek::fusion::Variable > reshape(monty::rc_ptr< ::mosek::fusion::Variable > _2841,monty::rc_ptr< ::mosek::fusion::Set > _2842);
static  monty::rc_ptr< ::mosek::fusion::Variable > reshape_(monty::rc_ptr< ::mosek::fusion::Variable > _2844,monty::rc_ptr< ::mosek::fusion::Set > _2845);
static  monty::rc_ptr< ::mosek::fusion::Variable > index_flip_(monty::rc_ptr< ::mosek::fusion::Variable > _2848,std::shared_ptr< monty::ndarray< int,1 > > _2849);
static  monty::rc_ptr< ::mosek::fusion::Variable > index_permute_(monty::rc_ptr< ::mosek::fusion::Variable > _2856,std::shared_ptr< monty::ndarray< int,1 > > _2857);
static  monty::rc_ptr< ::mosek::fusion::Variable > hrepeat(monty::rc_ptr< ::mosek::fusion::Variable > _2862,int _2863);
static  monty::rc_ptr< ::mosek::fusion::Variable > vrepeat(monty::rc_ptr< ::mosek::fusion::Variable > _2864,int _2865);
static  monty::rc_ptr< ::mosek::fusion::Variable > repeat(monty::rc_ptr< ::mosek::fusion::Variable > _2866,int _2867);
static  monty::rc_ptr< ::mosek::fusion::Variable > repeat(monty::rc_ptr< ::mosek::fusion::Variable > _2868,int _2869,int _2870);
static  monty::rc_ptr< ::mosek::fusion::Variable > drepeat(monty::rc_ptr< ::mosek::fusion::Variable > _2871,int _2872,int _2873);
static  monty::rc_ptr< ::mosek::fusion::Variable > stack(std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > >,1 > > _2874);
static  monty::rc_ptr< ::mosek::fusion::Variable > vstack(monty::rc_ptr< ::mosek::fusion::Variable > _2890,monty::rc_ptr< ::mosek::fusion::Variable > _2891,monty::rc_ptr< ::mosek::fusion::Variable > _2892);
static  monty::rc_ptr< ::mosek::fusion::Variable > vstack(monty::rc_ptr< ::mosek::fusion::Variable > _2893,monty::rc_ptr< ::mosek::fusion::Variable > _2894);
static  monty::rc_ptr< ::mosek::fusion::Variable > vstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _2895);
static  monty::rc_ptr< ::mosek::fusion::Variable > hstack(monty::rc_ptr< ::mosek::fusion::Variable > _2896,monty::rc_ptr< ::mosek::fusion::Variable > _2897,monty::rc_ptr< ::mosek::fusion::Variable > _2898);
static  monty::rc_ptr< ::mosek::fusion::Variable > hstack(monty::rc_ptr< ::mosek::fusion::Variable > _2899,monty::rc_ptr< ::mosek::fusion::Variable > _2900);
static  monty::rc_ptr< ::mosek::fusion::Variable > hstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _2901);
static  monty::rc_ptr< ::mosek::fusion::Variable > stack(monty::rc_ptr< ::mosek::fusion::Variable > _2902,monty::rc_ptr< ::mosek::fusion::Variable > _2903,monty::rc_ptr< ::mosek::fusion::Variable > _2904,int _2905);
static  monty::rc_ptr< ::mosek::fusion::Variable > stack(monty::rc_ptr< ::mosek::fusion::Variable > _2906,monty::rc_ptr< ::mosek::fusion::Variable > _2907,int _2908);
static  monty::rc_ptr< ::mosek::fusion::Variable > stack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _2909,int _2910);
static  monty::rc_ptr< ::mosek::fusion::Variable > dstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _2911,int _2912);
}; // struct Var;

struct p_ConstraintCache
{
ConstraintCache * _pubthis;
static mosek::fusion::p_ConstraintCache* _get_impl(mosek::fusion::ConstraintCache * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_ConstraintCache * _get_impl(mosek::fusion::ConstraintCache::t _inst) { return _get_impl(_inst.get()); }
p_ConstraintCache(ConstraintCache * _pubthis);
virtual ~p_ConstraintCache() { /* std::cout << "~p_ConstraintCache" << std::endl;*/ };
std::shared_ptr< monty::ndarray< int,1 > > barmatidx{};std::shared_ptr< monty::ndarray< int,1 > > barsubj{};std::shared_ptr< monty::ndarray< int,1 > > barsubi{};long long nbarnz{};long long nunordered{};std::shared_ptr< monty::ndarray< int,1 > > buffer_subi{};std::shared_ptr< monty::ndarray< int,1 > > buffer_subj{};std::shared_ptr< monty::ndarray< double,1 > > buffer_cof{};std::shared_ptr< monty::ndarray< double,1 > > bfix{};std::shared_ptr< monty::ndarray< double,1 > > cof{};std::shared_ptr< monty::ndarray< int,1 > > subi{};std::shared_ptr< monty::ndarray< int,1 > > subj{};long long nnz{};int nrows{};virtual void destroy();
static ConstraintCache::t _new_ConstraintCache(monty::rc_ptr< ::mosek::fusion::ConstraintCache > _3177);
void _initialize(monty::rc_ptr< ::mosek::fusion::ConstraintCache > _3177);
static ConstraintCache::t _new_ConstraintCache(std::shared_ptr< monty::ndarray< long long,1 > > _3178,std::shared_ptr< monty::ndarray< double,1 > > _3179,std::shared_ptr< monty::ndarray< int,1 > > _3180,std::shared_ptr< monty::ndarray< double,1 > > _3181,std::shared_ptr< monty::ndarray< int,1 > > _3182,std::shared_ptr< monty::ndarray< int,1 > > _3183,std::shared_ptr< monty::ndarray< int,1 > > _3184);
void _initialize(std::shared_ptr< monty::ndarray< long long,1 > > _3178,std::shared_ptr< monty::ndarray< double,1 > > _3179,std::shared_ptr< monty::ndarray< int,1 > > _3180,std::shared_ptr< monty::ndarray< double,1 > > _3181,std::shared_ptr< monty::ndarray< int,1 > > _3182,std::shared_ptr< monty::ndarray< int,1 > > _3183,std::shared_ptr< monty::ndarray< int,1 > > _3184);
virtual void unchecked_add_fx(std::shared_ptr< monty::ndarray< double,1 > > _3187);
virtual long long order_barentries();
virtual void add_bar(std::shared_ptr< monty::ndarray< int,1 > > _3197,std::shared_ptr< monty::ndarray< int,1 > > _3198,std::shared_ptr< monty::ndarray< int,1 > > _3199);
virtual void unchecked_add_l(std::shared_ptr< monty::ndarray< long long,1 > > _3205,std::shared_ptr< monty::ndarray< int,1 > > _3206,std::shared_ptr< monty::ndarray< double,1 > > _3207,std::shared_ptr< monty::ndarray< double,1 > > _3208);
virtual void add(std::shared_ptr< monty::ndarray< long long,1 > > _3217,std::shared_ptr< monty::ndarray< int,1 > > _3218,std::shared_ptr< monty::ndarray< double,1 > > _3219,std::shared_ptr< monty::ndarray< double,1 > > _3220);
virtual long long flush(std::shared_ptr< monty::ndarray< int,1 > > _3221,std::shared_ptr< monty::ndarray< int,1 > > _3222,std::shared_ptr< monty::ndarray< double,1 > > _3223,std::shared_ptr< monty::ndarray< double,1 > > _3224);
virtual long long numUnsorted();
virtual monty::rc_ptr< ::mosek::fusion::ConstraintCache > clone();
}; // struct ConstraintCache;

struct p_Constraint
{
Constraint * _pubthis;
static mosek::fusion::p_Constraint* _get_impl(mosek::fusion::Constraint * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_Constraint * _get_impl(mosek::fusion::Constraint::t _inst) { return _get_impl(_inst.get()); }
p_Constraint(Constraint * _pubthis);
virtual ~p_Constraint() { /* std::cout << "~p_Constraint" << std::endl;*/ };
monty::rc_ptr< ::mosek::fusion::Set > shape_p{};monty::rc_ptr< ::mosek::fusion::Model > model{};virtual void destroy();
static Constraint::t _new_Constraint(monty::rc_ptr< ::mosek::fusion::Constraint > _3897,monty::rc_ptr< ::mosek::fusion::Model > _3898);
void _initialize(monty::rc_ptr< ::mosek::fusion::Constraint > _3897,monty::rc_ptr< ::mosek::fusion::Model > _3898);
static Constraint::t _new_Constraint(monty::rc_ptr< ::mosek::fusion::Model > _3899,monty::rc_ptr< ::mosek::fusion::Set > _3900);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _3899,monty::rc_ptr< ::mosek::fusion::Set > _3900);
virtual std::string toString();
virtual void toStringArray(std::shared_ptr< monty::ndarray< long long,1 > > _3906,long long _3907,std::shared_ptr< monty::ndarray< std::string,1 > > _3908) { throw monty::AbstractClassError("Call to abstract method"); }
virtual monty::rc_ptr< ::mosek::fusion::Constraint > add(double _3909);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > add(std::shared_ptr< monty::ndarray< double,1 > > _3914);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > add(monty::rc_ptr< ::mosek::fusion::Variable > _3918);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > add(monty::rc_ptr< ::mosek::fusion::Expression > _3927);
static  void inst(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _3934,std::shared_ptr< monty::ndarray< long long,1 > > _3935,std::shared_ptr< monty::ndarray< int,1 > > _3936,std::shared_ptr< monty::ndarray< int,1 > > _3937,std::shared_ptr< monty::ndarray< int,1 > > _3938);
virtual void add_l(std::shared_ptr< monty::ndarray< long long,1 > > _3946,std::shared_ptr< monty::ndarray< long long,1 > > _3947,std::shared_ptr< monty::ndarray< int,1 > > _3948,std::shared_ptr< monty::ndarray< int,1 > > _3949,std::shared_ptr< monty::ndarray< int,1 > > _3950,std::shared_ptr< monty::ndarray< double,1 > > _3951,std::shared_ptr< monty::ndarray< double,1 > > _3952,long long _3953,int _3954,int _3955) { throw monty::AbstractClassError("Call to abstract method"); }
virtual std::shared_ptr< monty::ndarray< double,1 > > dual(std::shared_ptr< monty::ndarray< int,1 > > _3956,std::shared_ptr< monty::ndarray< int,1 > > _3957);
virtual std::shared_ptr< monty::ndarray< double,1 > > dual(int _3965,int _3966);
virtual std::shared_ptr< monty::ndarray< double,1 > > dual();
virtual void dual_values(int _3970,std::shared_ptr< monty::ndarray< double,1 > > _3971);
virtual void dual_values(std::shared_ptr< monty::ndarray< long long,1 > > _3976,int _3977,std::shared_ptr< monty::ndarray< double,1 > > _3978) { throw monty::AbstractClassError("Call to abstract method"); }
virtual void dual_values(long long _3979,std::shared_ptr< monty::ndarray< int,1 > > _3980,std::shared_ptr< monty::ndarray< long long,1 > > _3981,int _3982,std::shared_ptr< monty::ndarray< double,1 > > _3983) { throw monty::AbstractClassError("Call to abstract method"); }
virtual std::shared_ptr< monty::ndarray< double,1 > > level();
virtual double level(int _3985);
virtual std::shared_ptr< monty::ndarray< double,1 > > level(std::shared_ptr< monty::ndarray< int,1 > > _3988,std::shared_ptr< monty::ndarray< int,1 > > _3989);
virtual std::shared_ptr< monty::ndarray< double,1 > > level(int _3999,int _4000);
virtual void level_values(int _4005,std::shared_ptr< monty::ndarray< double,1 > > _4006);
virtual void level_values(std::shared_ptr< monty::ndarray< long long,1 > > _4011,int _4012,std::shared_ptr< monty::ndarray< double,1 > > _4013) { throw monty::AbstractClassError("Call to abstract method"); }
virtual void level_values(long long _4014,std::shared_ptr< monty::ndarray< int,1 > > _4015,std::shared_ptr< monty::ndarray< long long,1 > > _4016,int _4017,std::shared_ptr< monty::ndarray< double,1 > > _4018) { throw monty::AbstractClassError("Call to abstract method"); }
virtual monty::rc_ptr< ::mosek::fusion::Model > get_model();
virtual int get_nd();
virtual long long size();
static  monty::rc_ptr< ::mosek::fusion::Constraint > stack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Constraint >,1 > > _4019);
static  monty::rc_ptr< ::mosek::fusion::Constraint > stack(monty::rc_ptr< ::mosek::fusion::Constraint > _4020,monty::rc_ptr< ::mosek::fusion::Constraint > _4021,monty::rc_ptr< ::mosek::fusion::Constraint > _4022);
static  monty::rc_ptr< ::mosek::fusion::Constraint > stack(monty::rc_ptr< ::mosek::fusion::Constraint > _4024,monty::rc_ptr< ::mosek::fusion::Constraint > _4025);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > index(std::shared_ptr< monty::ndarray< int,1 > > _4027);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > index(int _4029);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > slice(std::shared_ptr< monty::ndarray< int,1 > > _4030,std::shared_ptr< monty::ndarray< int,1 > > _4031) { throw monty::AbstractClassError("Call to abstract method"); }
virtual monty::rc_ptr< ::mosek::fusion::Constraint > slice(int _4032,int _4033) { throw monty::AbstractClassError("Call to abstract method"); }
virtual monty::rc_ptr< ::mosek::fusion::Constraint > reduceDims();
virtual monty::rc_ptr< ::mosek::fusion::Set > shape();
}; // struct Constraint;

struct p_CompoundConstraint : public ::mosek::fusion::p_Constraint
{
CompoundConstraint * _pubthis;
static mosek::fusion::p_CompoundConstraint* _get_impl(mosek::fusion::CompoundConstraint * _inst){ return static_cast< mosek::fusion::p_CompoundConstraint* >(mosek::fusion::p_Constraint::_get_impl(_inst)); }
static mosek::fusion::p_CompoundConstraint * _get_impl(mosek::fusion::CompoundConstraint::t _inst) { return _get_impl(_inst.get()); }
p_CompoundConstraint(CompoundConstraint * _pubthis);
virtual ~p_CompoundConstraint() { /* std::cout << "~p_CompoundConstraint" << std::endl;*/ };
int stackdim{};std::shared_ptr< monty::ndarray< int,1 > > consb{};std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Constraint >,1 > > cons{};virtual void destroy();
static CompoundConstraint::t _new_CompoundConstraint(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Constraint >,1 > > _3247);
void _initialize(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Constraint >,1 > > _3247);
virtual void toStringArray(std::shared_ptr< monty::ndarray< long long,1 > > _3254,long long _3255,std::shared_ptr< monty::ndarray< std::string,1 > > _3256);
virtual void add_l(std::shared_ptr< monty::ndarray< long long,1 > > _3257,std::shared_ptr< monty::ndarray< long long,1 > > _3258,std::shared_ptr< monty::ndarray< int,1 > > _3259,std::shared_ptr< monty::ndarray< int,1 > > _3260,std::shared_ptr< monty::ndarray< int,1 > > _3261,std::shared_ptr< monty::ndarray< double,1 > > _3262,std::shared_ptr< monty::ndarray< double,1 > > _3263,long long _3264,int _3265,int _3266);
virtual void dual_values(long long _3291,std::shared_ptr< monty::ndarray< int,1 > > _3292,std::shared_ptr< monty::ndarray< long long,1 > > _3293,int _3294,std::shared_ptr< monty::ndarray< double,1 > > _3295);
virtual void dual_values(std::shared_ptr< monty::ndarray< long long,1 > > _3312,int _3313,std::shared_ptr< monty::ndarray< double,1 > > _3314);
virtual void level_values(long long _3321,std::shared_ptr< monty::ndarray< int,1 > > _3322,std::shared_ptr< monty::ndarray< long long,1 > > _3323,int _3324,std::shared_ptr< monty::ndarray< double,1 > > _3325);
virtual void level_values(std::shared_ptr< monty::ndarray< long long,1 > > _3342,int _3343,std::shared_ptr< monty::ndarray< double,1 > > _3344);
virtual void add(std::shared_ptr< monty::ndarray< long long,1 > > _3351,std::shared_ptr< monty::ndarray< int,1 > > _3352,std::shared_ptr< monty::ndarray< double,1 > > _3353,std::shared_ptr< monty::ndarray< double,1 > > _3354,int _3355,std::shared_ptr< monty::ndarray< int,1 > > _3356,int _3357);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > slice(std::shared_ptr< monty::ndarray< int,1 > > _3358,std::shared_ptr< monty::ndarray< int,1 > > _3359);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > slice(int _3360,int _3361);
static  monty::rc_ptr< ::mosek::fusion::Set > compute_shape(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Constraint >,1 > > _3362,int _3363);
static  int count_numcon(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Constraint >,1 > > _3370);
static  monty::rc_ptr< ::mosek::fusion::Model > model_from_con(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Constraint >,1 > > _3376);
}; // struct CompoundConstraint;

struct p_SliceConstraint : public ::mosek::fusion::p_Constraint
{
SliceConstraint * _pubthis;
static mosek::fusion::p_SliceConstraint* _get_impl(mosek::fusion::SliceConstraint * _inst){ return static_cast< mosek::fusion::p_SliceConstraint* >(mosek::fusion::p_Constraint::_get_impl(_inst)); }
static mosek::fusion::p_SliceConstraint * _get_impl(mosek::fusion::SliceConstraint::t _inst) { return _get_impl(_inst.get()); }
p_SliceConstraint(SliceConstraint * _pubthis);
virtual ~p_SliceConstraint() { /* std::cout << "~p_SliceConstraint" << std::endl;*/ };
std::shared_ptr< monty::ndarray< long long,1 > > strides{};long long first{};monty::rc_ptr< ::mosek::fusion::ModelConstraint > origin{};virtual void destroy();
static SliceConstraint::t _new_SliceConstraint(monty::rc_ptr< ::mosek::fusion::ModelConstraint > _3393,monty::rc_ptr< ::mosek::fusion::Set > _3394,long long _3395,std::shared_ptr< monty::ndarray< long long,1 > > _3396);
void _initialize(monty::rc_ptr< ::mosek::fusion::ModelConstraint > _3393,monty::rc_ptr< ::mosek::fusion::Set > _3394,long long _3395,std::shared_ptr< monty::ndarray< long long,1 > > _3396);
virtual void add_l(std::shared_ptr< monty::ndarray< long long,1 > > _3397,std::shared_ptr< monty::ndarray< long long,1 > > _3398,std::shared_ptr< monty::ndarray< int,1 > > _3399,std::shared_ptr< monty::ndarray< int,1 > > _3400,std::shared_ptr< monty::ndarray< int,1 > > _3401,std::shared_ptr< monty::ndarray< double,1 > > _3402,std::shared_ptr< monty::ndarray< double,1 > > _3403,long long _3404,int _3405,int _3406);
virtual void add_fx(std::shared_ptr< monty::ndarray< long long,1 > > _3417,std::shared_ptr< monty::ndarray< double,1 > > _3418,long long _3419,int _3420,int _3421);
virtual void dual_values(long long _3428,std::shared_ptr< monty::ndarray< int,1 > > _3429,std::shared_ptr< monty::ndarray< long long,1 > > _3430,int _3431,std::shared_ptr< monty::ndarray< double,1 > > _3432);
virtual void dual_values(std::shared_ptr< monty::ndarray< long long,1 > > _3455,int _3456,std::shared_ptr< monty::ndarray< double,1 > > _3457);
virtual void level_values(long long _3463,std::shared_ptr< monty::ndarray< int,1 > > _3464,std::shared_ptr< monty::ndarray< long long,1 > > _3465,int _3466,std::shared_ptr< monty::ndarray< double,1 > > _3467);
virtual void level_values(std::shared_ptr< monty::ndarray< long long,1 > > _3489,int _3490,std::shared_ptr< monty::ndarray< double,1 > > _3491);
virtual void toStringArray(std::shared_ptr< monty::ndarray< long long,1 > > _3497,long long _3498,std::shared_ptr< monty::ndarray< std::string,1 > > _3499);
virtual long long size();
virtual monty::rc_ptr< ::mosek::fusion::Constraint > slice(std::shared_ptr< monty::ndarray< int,1 > > _3505,std::shared_ptr< monty::ndarray< int,1 > > _3506);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > slice(int _3510,int _3511);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > slice_(monty::rc_ptr< ::mosek::fusion::Set > _3513,long long _3514,std::shared_ptr< monty::ndarray< long long,1 > > _3515);
}; // struct SliceConstraint;

struct p_BoundInterfaceConstraint : public ::mosek::fusion::p_SliceConstraint
{
BoundInterfaceConstraint * _pubthis;
static mosek::fusion::p_BoundInterfaceConstraint* _get_impl(mosek::fusion::BoundInterfaceConstraint * _inst){ return static_cast< mosek::fusion::p_BoundInterfaceConstraint* >(mosek::fusion::p_SliceConstraint::_get_impl(_inst)); }
static mosek::fusion::p_BoundInterfaceConstraint * _get_impl(mosek::fusion::BoundInterfaceConstraint::t _inst) { return _get_impl(_inst.get()); }
p_BoundInterfaceConstraint(BoundInterfaceConstraint * _pubthis);
virtual ~p_BoundInterfaceConstraint() { /* std::cout << "~p_BoundInterfaceConstraint" << std::endl;*/ };
monty::rc_ptr< ::mosek::fusion::RangedConstraint > origincon{};bool islower{};virtual void destroy();
static BoundInterfaceConstraint::t _new_BoundInterfaceConstraint(monty::rc_ptr< ::mosek::fusion::RangedConstraint > _3377,monty::rc_ptr< ::mosek::fusion::Set > _3378,long long _3379,std::shared_ptr< monty::ndarray< long long,1 > > _3380,bool _3381);
void _initialize(monty::rc_ptr< ::mosek::fusion::RangedConstraint > _3377,monty::rc_ptr< ::mosek::fusion::Set > _3378,long long _3379,std::shared_ptr< monty::ndarray< long long,1 > > _3380,bool _3381);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > slice_(monty::rc_ptr< ::mosek::fusion::Set > _3382,long long _3383,std::shared_ptr< monty::ndarray< long long,1 > > _3384);
virtual void dual_values(long long _3385,std::shared_ptr< monty::ndarray< int,1 > > _3386,std::shared_ptr< monty::ndarray< long long,1 > > _3387,int _3388,std::shared_ptr< monty::ndarray< double,1 > > _3389);
virtual void dual_values(std::shared_ptr< monty::ndarray< long long,1 > > _3390,int _3391,std::shared_ptr< monty::ndarray< double,1 > > _3392);
}; // struct BoundInterfaceConstraint;

struct p_ModelConstraint : public ::mosek::fusion::p_Constraint
{
ModelConstraint * _pubthis;
static mosek::fusion::p_ModelConstraint* _get_impl(mosek::fusion::ModelConstraint * _inst){ return static_cast< mosek::fusion::p_ModelConstraint* >(mosek::fusion::p_Constraint::_get_impl(_inst)); }
static mosek::fusion::p_ModelConstraint * _get_impl(mosek::fusion::ModelConstraint::t _inst) { return _get_impl(_inst.get()); }
p_ModelConstraint(ModelConstraint * _pubthis);
virtual ~p_ModelConstraint() { /* std::cout << "~p_ModelConstraint" << std::endl;*/ };
bool names_flushed{};std::shared_ptr< monty::ndarray< int,1 > > nativeindexes{};std::string name{};std::shared_ptr< monty::ndarray< double,1 > > cache_bfix{};monty::rc_ptr< ::mosek::fusion::ConstraintCache > cache{};virtual void destroy();
static ModelConstraint::t _new_ModelConstraint(monty::rc_ptr< ::mosek::fusion::ModelConstraint > _3783,monty::rc_ptr< ::mosek::fusion::Model > _3784);
void _initialize(monty::rc_ptr< ::mosek::fusion::ModelConstraint > _3783,monty::rc_ptr< ::mosek::fusion::Model > _3784);
static ModelConstraint::t _new_ModelConstraint(monty::rc_ptr< ::mosek::fusion::Model > _3787,const std::string &  _3788,monty::rc_ptr< ::mosek::fusion::Set > _3789,std::shared_ptr< monty::ndarray< int,1 > > _3790,std::shared_ptr< monty::ndarray< long long,1 > > _3791,std::shared_ptr< monty::ndarray< int,1 > > _3792,std::shared_ptr< monty::ndarray< double,1 > > _3793,std::shared_ptr< monty::ndarray< double,1 > > _3794,std::shared_ptr< monty::ndarray< int,1 > > _3795,std::shared_ptr< monty::ndarray< int,1 > > _3796,std::shared_ptr< monty::ndarray< int,1 > > _3797);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _3787,const std::string &  _3788,monty::rc_ptr< ::mosek::fusion::Set > _3789,std::shared_ptr< monty::ndarray< int,1 > > _3790,std::shared_ptr< monty::ndarray< long long,1 > > _3791,std::shared_ptr< monty::ndarray< int,1 > > _3792,std::shared_ptr< monty::ndarray< double,1 > > _3793,std::shared_ptr< monty::ndarray< double,1 > > _3794,std::shared_ptr< monty::ndarray< int,1 > > _3795,std::shared_ptr< monty::ndarray< int,1 > > _3796,std::shared_ptr< monty::ndarray< int,1 > > _3797);
virtual void flushNames();
virtual std::string toString();
virtual void toStringArray(std::shared_ptr< monty::ndarray< long long,1 > > _3804,long long _3805,std::shared_ptr< monty::ndarray< std::string,1 > > _3806);
virtual void domainToString(long long _3822,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _3823) { throw monty::AbstractClassError("Call to abstract method"); }
virtual void add_l(std::shared_ptr< monty::ndarray< long long,1 > > _3824,std::shared_ptr< monty::ndarray< long long,1 > > _3825,std::shared_ptr< monty::ndarray< int,1 > > _3826,std::shared_ptr< monty::ndarray< int,1 > > _3827,std::shared_ptr< monty::ndarray< int,1 > > _3828,std::shared_ptr< monty::ndarray< double,1 > > _3829,std::shared_ptr< monty::ndarray< double,1 > > _3830,long long _3831,int _3832,int _3833);
virtual void add_fx(std::shared_ptr< monty::ndarray< long long,1 > > _3881,std::shared_ptr< monty::ndarray< double,1 > > _3882,long long _3883,int _3884,int _3885) { throw monty::AbstractClassError("Call to abstract method"); }
virtual monty::rc_ptr< ::mosek::fusion::Constraint > slice(std::shared_ptr< monty::ndarray< int,1 > > _3886,std::shared_ptr< monty::ndarray< int,1 > > _3887);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > slice(int _3893,int _3894);
virtual monty::rc_ptr< ::mosek::fusion::ModelConstraint > clone(monty::rc_ptr< ::mosek::fusion::Model > _3896) { throw monty::AbstractClassError("Call to abstract method"); }
}; // struct ModelConstraint;

struct p_LinearPSDConstraint : public ::mosek::fusion::p_ModelConstraint
{
LinearPSDConstraint * _pubthis;
static mosek::fusion::p_LinearPSDConstraint* _get_impl(mosek::fusion::LinearPSDConstraint * _inst){ return static_cast< mosek::fusion::p_LinearPSDConstraint* >(mosek::fusion::p_ModelConstraint::_get_impl(_inst)); }
static mosek::fusion::p_LinearPSDConstraint * _get_impl(mosek::fusion::LinearPSDConstraint::t _inst) { return _get_impl(_inst.get()); }
p_LinearPSDConstraint(LinearPSDConstraint * _pubthis);
virtual ~p_LinearPSDConstraint() { /* std::cout << "~p_LinearPSDConstraint" << std::endl;*/ };
int psdvardim{};bool names_flushed{};int numcones{};int conesize{};int coneidx{};virtual void destroy();
static LinearPSDConstraint::t _new_LinearPSDConstraint(monty::rc_ptr< ::mosek::fusion::LinearPSDConstraint > _2926,monty::rc_ptr< ::mosek::fusion::Model > _2927);
void _initialize(monty::rc_ptr< ::mosek::fusion::LinearPSDConstraint > _2926,monty::rc_ptr< ::mosek::fusion::Model > _2927);
static LinearPSDConstraint::t _new_LinearPSDConstraint(monty::rc_ptr< ::mosek::fusion::Model > _2928,const std::string &  _2929,monty::rc_ptr< ::mosek::fusion::Set > _2930,std::shared_ptr< monty::ndarray< int,1 > > _2931,int _2932,int _2933,int _2934,std::shared_ptr< monty::ndarray< long long,1 > > _2935,std::shared_ptr< monty::ndarray< int,1 > > _2936,std::shared_ptr< monty::ndarray< double,1 > > _2937,std::shared_ptr< monty::ndarray< double,1 > > _2938,std::shared_ptr< monty::ndarray< int,1 > > _2939,std::shared_ptr< monty::ndarray< int,1 > > _2940,std::shared_ptr< monty::ndarray< int,1 > > _2941);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2928,const std::string &  _2929,monty::rc_ptr< ::mosek::fusion::Set > _2930,std::shared_ptr< monty::ndarray< int,1 > > _2931,int _2932,int _2933,int _2934,std::shared_ptr< monty::ndarray< long long,1 > > _2935,std::shared_ptr< monty::ndarray< int,1 > > _2936,std::shared_ptr< monty::ndarray< double,1 > > _2937,std::shared_ptr< monty::ndarray< double,1 > > _2938,std::shared_ptr< monty::ndarray< int,1 > > _2939,std::shared_ptr< monty::ndarray< int,1 > > _2940,std::shared_ptr< monty::ndarray< int,1 > > _2941);
virtual void domainToString(long long _2944,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2945);
virtual std::string toString();
virtual void toStringArray(std::shared_ptr< monty::ndarray< long long,1 > > _2955,long long _2956,std::shared_ptr< monty::ndarray< std::string,1 > > _2957);
virtual void toStringArray(std::shared_ptr< monty::ndarray< long long,1 > > _2958,long long _2959,std::shared_ptr< monty::ndarray< std::string,1 > > _2960,bool _2961);
virtual void flushNames();
virtual void add_fx(std::shared_ptr< monty::ndarray< long long,1 > > _2989,std::shared_ptr< monty::ndarray< double,1 > > _2990,long long _2991,int _2992,int _2993);
virtual void dual_values(long long _2998,std::shared_ptr< monty::ndarray< int,1 > > _2999,std::shared_ptr< monty::ndarray< long long,1 > > _3000,int _3001,std::shared_ptr< monty::ndarray< double,1 > > _3002);
virtual void dual_values(std::shared_ptr< monty::ndarray< long long,1 > > _3011,int _3012,std::shared_ptr< monty::ndarray< double,1 > > _3013);
virtual void level_values(long long _3019,std::shared_ptr< monty::ndarray< int,1 > > _3020,std::shared_ptr< monty::ndarray< long long,1 > > _3021,int _3022,std::shared_ptr< monty::ndarray< double,1 > > _3023);
virtual void level_values(std::shared_ptr< monty::ndarray< long long,1 > > _3032,int _3033,std::shared_ptr< monty::ndarray< double,1 > > _3034);
virtual monty::rc_ptr< ::mosek::fusion::ModelConstraint > clone(monty::rc_ptr< ::mosek::fusion::Model > _3040);
}; // struct LinearPSDConstraint;

struct p_PSDConstraint : public ::mosek::fusion::p_ModelConstraint
{
PSDConstraint * _pubthis;
static mosek::fusion::p_PSDConstraint* _get_impl(mosek::fusion::PSDConstraint * _inst){ return static_cast< mosek::fusion::p_PSDConstraint* >(mosek::fusion::p_ModelConstraint::_get_impl(_inst)); }
static mosek::fusion::p_PSDConstraint * _get_impl(mosek::fusion::PSDConstraint::t _inst) { return _get_impl(_inst.get()); }
p_PSDConstraint(PSDConstraint * _pubthis);
virtual ~p_PSDConstraint() { /* std::cout << "~p_PSDConstraint" << std::endl;*/ };
bool names_flushed{};int numcones{};int conesize{};int coneidx{};virtual void destroy();
static PSDConstraint::t _new_PSDConstraint(monty::rc_ptr< ::mosek::fusion::PSDConstraint > _3041,monty::rc_ptr< ::mosek::fusion::Model > _3042);
void _initialize(monty::rc_ptr< ::mosek::fusion::PSDConstraint > _3041,monty::rc_ptr< ::mosek::fusion::Model > _3042);
static PSDConstraint::t _new_PSDConstraint(monty::rc_ptr< ::mosek::fusion::Model > _3043,const std::string &  _3044,monty::rc_ptr< ::mosek::fusion::Set > _3045,std::shared_ptr< monty::ndarray< int,1 > > _3046,int _3047,int _3048,int _3049,std::shared_ptr< monty::ndarray< long long,1 > > _3050,std::shared_ptr< monty::ndarray< int,1 > > _3051,std::shared_ptr< monty::ndarray< double,1 > > _3052,std::shared_ptr< monty::ndarray< double,1 > > _3053,std::shared_ptr< monty::ndarray< int,1 > > _3054,std::shared_ptr< monty::ndarray< int,1 > > _3055,std::shared_ptr< monty::ndarray< int,1 > > _3056);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _3043,const std::string &  _3044,monty::rc_ptr< ::mosek::fusion::Set > _3045,std::shared_ptr< monty::ndarray< int,1 > > _3046,int _3047,int _3048,int _3049,std::shared_ptr< monty::ndarray< long long,1 > > _3050,std::shared_ptr< monty::ndarray< int,1 > > _3051,std::shared_ptr< monty::ndarray< double,1 > > _3052,std::shared_ptr< monty::ndarray< double,1 > > _3053,std::shared_ptr< monty::ndarray< int,1 > > _3054,std::shared_ptr< monty::ndarray< int,1 > > _3055,std::shared_ptr< monty::ndarray< int,1 > > _3056);
virtual void domainToString(long long _3057,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _3058);
virtual std::string toString();
virtual void toStringArray(std::shared_ptr< monty::ndarray< long long,1 > > _3068,long long _3069,std::shared_ptr< monty::ndarray< std::string,1 > > _3070);
virtual void toStringArray(std::shared_ptr< monty::ndarray< long long,1 > > _3071,long long _3072,std::shared_ptr< monty::ndarray< std::string,1 > > _3073,bool _3074);
virtual void flushNames();
virtual void add_fx(std::shared_ptr< monty::ndarray< long long,1 > > _3107,std::shared_ptr< monty::ndarray< double,1 > > _3108,long long _3109,int _3110,int _3111);
virtual void dual_values(long long _3116,std::shared_ptr< monty::ndarray< int,1 > > _3117,std::shared_ptr< monty::ndarray< long long,1 > > _3118,int _3119,std::shared_ptr< monty::ndarray< double,1 > > _3120);
virtual void dual_values(std::shared_ptr< monty::ndarray< long long,1 > > _3136,int _3137,std::shared_ptr< monty::ndarray< double,1 > > _3138);
virtual void level_values(long long _3146,std::shared_ptr< monty::ndarray< int,1 > > _3147,std::shared_ptr< monty::ndarray< long long,1 > > _3148,int _3149,std::shared_ptr< monty::ndarray< double,1 > > _3150);
virtual void level_values(std::shared_ptr< monty::ndarray< long long,1 > > _3166,int _3167,std::shared_ptr< monty::ndarray< double,1 > > _3168);
virtual monty::rc_ptr< ::mosek::fusion::ModelConstraint > clone(monty::rc_ptr< ::mosek::fusion::Model > _3176);
}; // struct PSDConstraint;

struct p_RangedConstraint : public ::mosek::fusion::p_ModelConstraint
{
RangedConstraint * _pubthis;
static mosek::fusion::p_RangedConstraint* _get_impl(mosek::fusion::RangedConstraint * _inst){ return static_cast< mosek::fusion::p_RangedConstraint* >(mosek::fusion::p_ModelConstraint::_get_impl(_inst)); }
static mosek::fusion::p_RangedConstraint * _get_impl(mosek::fusion::RangedConstraint::t _inst) { return _get_impl(_inst.get()); }
p_RangedConstraint(RangedConstraint * _pubthis);
virtual ~p_RangedConstraint() { /* std::cout << "~p_RangedConstraint" << std::endl;*/ };
monty::rc_ptr< ::mosek::fusion::Utils::IntMap > idxmap{};monty::rc_ptr< ::mosek::fusion::RangeDomain > dom{};virtual void destroy();
static RangedConstraint::t _new_RangedConstraint(monty::rc_ptr< ::mosek::fusion::RangedConstraint > _3516,monty::rc_ptr< ::mosek::fusion::Model > _3517);
void _initialize(monty::rc_ptr< ::mosek::fusion::RangedConstraint > _3516,monty::rc_ptr< ::mosek::fusion::Model > _3517);
static RangedConstraint::t _new_RangedConstraint(monty::rc_ptr< ::mosek::fusion::Model > _3518,const std::string &  _3519,monty::rc_ptr< ::mosek::fusion::Set > _3520,monty::rc_ptr< ::mosek::fusion::RangeDomain > _3521,std::shared_ptr< monty::ndarray< int,1 > > _3522,std::shared_ptr< monty::ndarray< long long,1 > > _3523,std::shared_ptr< monty::ndarray< int,1 > > _3524,std::shared_ptr< monty::ndarray< double,1 > > _3525,std::shared_ptr< monty::ndarray< double,1 > > _3526,std::shared_ptr< monty::ndarray< int,1 > > _3527,std::shared_ptr< monty::ndarray< int,1 > > _3528,std::shared_ptr< monty::ndarray< int,1 > > _3529);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _3518,const std::string &  _3519,monty::rc_ptr< ::mosek::fusion::Set > _3520,monty::rc_ptr< ::mosek::fusion::RangeDomain > _3521,std::shared_ptr< monty::ndarray< int,1 > > _3522,std::shared_ptr< monty::ndarray< long long,1 > > _3523,std::shared_ptr< monty::ndarray< int,1 > > _3524,std::shared_ptr< monty::ndarray< double,1 > > _3525,std::shared_ptr< monty::ndarray< double,1 > > _3526,std::shared_ptr< monty::ndarray< int,1 > > _3527,std::shared_ptr< monty::ndarray< int,1 > > _3528,std::shared_ptr< monty::ndarray< int,1 > > _3529);
virtual void add_fx(std::shared_ptr< monty::ndarray< long long,1 > > _3530,std::shared_ptr< monty::ndarray< double,1 > > _3531,long long _3532,int _3533,int _3534);
virtual void dual_u(long long _3540,std::shared_ptr< monty::ndarray< int,1 > > _3541,std::shared_ptr< monty::ndarray< long long,1 > > _3542,int _3543,std::shared_ptr< monty::ndarray< double,1 > > _3544);
virtual void dual_u(std::shared_ptr< monty::ndarray< long long,1 > > _3552,int _3553,std::shared_ptr< monty::ndarray< double,1 > > _3554);
virtual void dual_l(long long _3558,std::shared_ptr< monty::ndarray< int,1 > > _3559,std::shared_ptr< monty::ndarray< long long,1 > > _3560,int _3561,std::shared_ptr< monty::ndarray< double,1 > > _3562);
virtual void dual_l(std::shared_ptr< monty::ndarray< long long,1 > > _3570,int _3571,std::shared_ptr< monty::ndarray< double,1 > > _3572);
virtual void dual_values(long long _3576,std::shared_ptr< monty::ndarray< int,1 > > _3577,std::shared_ptr< monty::ndarray< long long,1 > > _3578,int _3579,std::shared_ptr< monty::ndarray< double,1 > > _3580);
virtual void dual_values(std::shared_ptr< monty::ndarray< long long,1 > > _3588,int _3589,std::shared_ptr< monty::ndarray< double,1 > > _3590);
virtual void level_values(long long _3594,std::shared_ptr< monty::ndarray< int,1 > > _3595,std::shared_ptr< monty::ndarray< long long,1 > > _3596,int _3597,std::shared_ptr< monty::ndarray< double,1 > > _3598);
virtual void level_values(std::shared_ptr< monty::ndarray< long long,1 > > _3606,int _3607,std::shared_ptr< monty::ndarray< double,1 > > _3608);
virtual void add_l(std::shared_ptr< monty::ndarray< long long,1 > > _3612,std::shared_ptr< monty::ndarray< long long,1 > > _3613,std::shared_ptr< monty::ndarray< int,1 > > _3614,std::shared_ptr< monty::ndarray< int,1 > > _3615,std::shared_ptr< monty::ndarray< int,1 > > _3616,std::shared_ptr< monty::ndarray< double,1 > > _3617,std::shared_ptr< monty::ndarray< double,1 > > _3618,int _3619,int _3620,int _3621);
virtual void domainToString(long long _3627,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _3628);
virtual monty::rc_ptr< ::mosek::fusion::Constraint > upperBoundCon();
virtual monty::rc_ptr< ::mosek::fusion::Constraint > lowerBoundCon();
virtual monty::rc_ptr< ::mosek::fusion::ModelConstraint > clone(monty::rc_ptr< ::mosek::fusion::Model > _3633);
}; // struct RangedConstraint;

struct p_ConicConstraint : public ::mosek::fusion::p_ModelConstraint
{
ConicConstraint * _pubthis;
static mosek::fusion::p_ConicConstraint* _get_impl(mosek::fusion::ConicConstraint * _inst){ return static_cast< mosek::fusion::p_ConicConstraint* >(mosek::fusion::p_ModelConstraint::_get_impl(_inst)); }
static mosek::fusion::p_ConicConstraint * _get_impl(mosek::fusion::ConicConstraint::t _inst) { return _get_impl(_inst.get()); }
p_ConicConstraint(ConicConstraint * _pubthis);
virtual ~p_ConicConstraint() { /* std::cout << "~p_ConicConstraint" << std::endl;*/ };
bool names_flushed{};monty::rc_ptr< ::mosek::fusion::QConeDomain > dom{};int conesize{};int last{};int first{};int last_slack{};int first_slack{};int coneidx{};virtual void destroy();
static ConicConstraint::t _new_ConicConstraint(monty::rc_ptr< ::mosek::fusion::ConicConstraint > _3634,monty::rc_ptr< ::mosek::fusion::Model > _3635);
void _initialize(monty::rc_ptr< ::mosek::fusion::ConicConstraint > _3634,monty::rc_ptr< ::mosek::fusion::Model > _3635);
static ConicConstraint::t _new_ConicConstraint(monty::rc_ptr< ::mosek::fusion::Model > _3636,const std::string &  _3637,monty::rc_ptr< ::mosek::fusion::QConeDomain > _3638,monty::rc_ptr< ::mosek::fusion::Set > _3639,std::shared_ptr< monty::ndarray< int,1 > > _3640,int _3641,int _3642,int _3643,int _3644,int _3645,std::shared_ptr< monty::ndarray< long long,1 > > _3646,std::shared_ptr< monty::ndarray< int,1 > > _3647,std::shared_ptr< monty::ndarray< double,1 > > _3648,std::shared_ptr< monty::ndarray< double,1 > > _3649,std::shared_ptr< monty::ndarray< int,1 > > _3650,std::shared_ptr< monty::ndarray< int,1 > > _3651,std::shared_ptr< monty::ndarray< int,1 > > _3652);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _3636,const std::string &  _3637,monty::rc_ptr< ::mosek::fusion::QConeDomain > _3638,monty::rc_ptr< ::mosek::fusion::Set > _3639,std::shared_ptr< monty::ndarray< int,1 > > _3640,int _3641,int _3642,int _3643,int _3644,int _3645,std::shared_ptr< monty::ndarray< long long,1 > > _3646,std::shared_ptr< monty::ndarray< int,1 > > _3647,std::shared_ptr< monty::ndarray< double,1 > > _3648,std::shared_ptr< monty::ndarray< double,1 > > _3649,std::shared_ptr< monty::ndarray< int,1 > > _3650,std::shared_ptr< monty::ndarray< int,1 > > _3651,std::shared_ptr< monty::ndarray< int,1 > > _3652);
virtual void flushNames();
virtual std::string toString();
virtual void dual_values(long long _3660,std::shared_ptr< monty::ndarray< int,1 > > _3661,std::shared_ptr< monty::ndarray< long long,1 > > _3662,int _3663,std::shared_ptr< monty::ndarray< double,1 > > _3664);
virtual void dual_values(std::shared_ptr< monty::ndarray< long long,1 > > _3671,int _3672,std::shared_ptr< monty::ndarray< double,1 > > _3673);
virtual void level_values(long long _3676,std::shared_ptr< monty::ndarray< int,1 > > _3677,std::shared_ptr< monty::ndarray< long long,1 > > _3678,int _3679,std::shared_ptr< monty::ndarray< double,1 > > _3680);
virtual void level_values(std::shared_ptr< monty::ndarray< long long,1 > > _3688,int _3689,std::shared_ptr< monty::ndarray< double,1 > > _3690);
virtual void add_fx(std::shared_ptr< monty::ndarray< long long,1 > > _3694,std::shared_ptr< monty::ndarray< double,1 > > _3695,long long _3696,int _3697,int _3698);
virtual void dual(std::shared_ptr< monty::ndarray< int,1 > > _3703,int _3704,int _3705,int _3706,std::shared_ptr< monty::ndarray< double,1 > > _3707);
virtual void dual_values(std::shared_ptr< monty::ndarray< int,1 > > _3710,std::shared_ptr< monty::ndarray< int,1 > > _3711,int _3712,std::shared_ptr< monty::ndarray< double,1 > > _3713);
virtual void domainToString(long long _3718,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _3719);
virtual monty::rc_ptr< ::mosek::fusion::ModelConstraint > clone(monty::rc_ptr< ::mosek::fusion::Model > _3720);
}; // struct ConicConstraint;

struct p_LinearConstraint : public ::mosek::fusion::p_ModelConstraint
{
LinearConstraint * _pubthis;
static mosek::fusion::p_LinearConstraint* _get_impl(mosek::fusion::LinearConstraint * _inst){ return static_cast< mosek::fusion::p_LinearConstraint* >(mosek::fusion::p_ModelConstraint::_get_impl(_inst)); }
static mosek::fusion::p_LinearConstraint * _get_impl(mosek::fusion::LinearConstraint::t _inst) { return _get_impl(_inst.get()); }
p_LinearConstraint(LinearConstraint * _pubthis);
virtual ~p_LinearConstraint() { /* std::cout << "~p_LinearConstraint" << std::endl;*/ };
monty::rc_ptr< ::mosek::fusion::LinearDomain > dom{};monty::rc_ptr< ::mosek::fusion::Utils::IntMap > idxmap{};virtual void destroy();
static LinearConstraint::t _new_LinearConstraint(monty::rc_ptr< ::mosek::fusion::LinearConstraint > _3721,monty::rc_ptr< ::mosek::fusion::Model > _3722);
void _initialize(monty::rc_ptr< ::mosek::fusion::LinearConstraint > _3721,monty::rc_ptr< ::mosek::fusion::Model > _3722);
static LinearConstraint::t _new_LinearConstraint(monty::rc_ptr< ::mosek::fusion::Model > _3723,const std::string &  _3724,monty::rc_ptr< ::mosek::fusion::LinearDomain > _3725,monty::rc_ptr< ::mosek::fusion::Set > _3726,std::shared_ptr< monty::ndarray< int,1 > > _3727,std::shared_ptr< monty::ndarray< long long,1 > > _3728,std::shared_ptr< monty::ndarray< int,1 > > _3729,std::shared_ptr< monty::ndarray< double,1 > > _3730,std::shared_ptr< monty::ndarray< double,1 > > _3731,std::shared_ptr< monty::ndarray< int,1 > > _3732,std::shared_ptr< monty::ndarray< int,1 > > _3733,std::shared_ptr< monty::ndarray< int,1 > > _3734);
void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _3723,const std::string &  _3724,monty::rc_ptr< ::mosek::fusion::LinearDomain > _3725,monty::rc_ptr< ::mosek::fusion::Set > _3726,std::shared_ptr< monty::ndarray< int,1 > > _3727,std::shared_ptr< monty::ndarray< long long,1 > > _3728,std::shared_ptr< monty::ndarray< int,1 > > _3729,std::shared_ptr< monty::ndarray< double,1 > > _3730,std::shared_ptr< monty::ndarray< double,1 > > _3731,std::shared_ptr< monty::ndarray< int,1 > > _3732,std::shared_ptr< monty::ndarray< int,1 > > _3733,std::shared_ptr< monty::ndarray< int,1 > > _3734);
virtual void add_fx(std::shared_ptr< monty::ndarray< long long,1 > > _3735,std::shared_ptr< monty::ndarray< double,1 > > _3736,long long _3737,int _3738,int _3739);
virtual void dual_values(long long _3744,std::shared_ptr< monty::ndarray< int,1 > > _3745,std::shared_ptr< monty::ndarray< long long,1 > > _3746,int _3747,std::shared_ptr< monty::ndarray< double,1 > > _3748);
virtual void dual_values(std::shared_ptr< monty::ndarray< long long,1 > > _3756,int _3757,std::shared_ptr< monty::ndarray< double,1 > > _3758);
virtual void level_values(long long _3762,std::shared_ptr< monty::ndarray< int,1 > > _3763,std::shared_ptr< monty::ndarray< long long,1 > > _3764,int _3765,std::shared_ptr< monty::ndarray< double,1 > > _3766);
virtual void level_values(std::shared_ptr< monty::ndarray< long long,1 > > _3774,int _3775,std::shared_ptr< monty::ndarray< double,1 > > _3776);
virtual void domainToString(long long _3780,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _3781);
virtual monty::rc_ptr< ::mosek::fusion::ModelConstraint > clone(monty::rc_ptr< ::mosek::fusion::Model > _3782);
}; // struct LinearConstraint;

struct p_Set
{
Set * _pubthis;
static mosek::fusion::p_Set* _get_impl(mosek::fusion::Set * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_Set * _get_impl(mosek::fusion::Set::t _inst) { return _get_impl(_inst.get()); }
p_Set(Set * _pubthis);
virtual ~p_Set() { /* std::cout << "~p_Set" << std::endl;*/ };
long long size{};int nd_p{};int nd{};virtual void destroy();
static Set::t _new_Set(int _4125,long long _4126);
void _initialize(int _4125,long long _4126);
virtual std::string toString();
virtual std::string indexToString(long long _4129) { throw monty::AbstractClassError("Call to abstract method"); }
virtual monty::rc_ptr< ::mosek::fusion::Set > slice(std::shared_ptr< monty::ndarray< int,1 > > _4130,std::shared_ptr< monty::ndarray< int,1 > > _4131) { throw monty::AbstractClassError("Call to abstract method"); }
virtual monty::rc_ptr< ::mosek::fusion::Set > slice(int _4132,int _4133) { throw monty::AbstractClassError("Call to abstract method"); }
virtual long long linearidx(int _4134,int _4135,int _4136);
virtual long long linearidx(int _4137,int _4138);
virtual long long linearidx(std::shared_ptr< monty::ndarray< int,1 > > _4139);
virtual std::shared_ptr< monty::ndarray< int,1 > > idxtokey(long long _4142);
virtual std::string getname(std::shared_ptr< monty::ndarray< int,1 > > _4146) { throw monty::AbstractClassError("Call to abstract method"); }
virtual std::string getname(long long _4147) { throw monty::AbstractClassError("Call to abstract method"); }
virtual long long stride(int _4148) { throw monty::AbstractClassError("Call to abstract method"); }
virtual int dim(int _4149) { throw monty::AbstractClassError("Call to abstract method"); }
static  monty::rc_ptr< ::mosek::fusion::Set > make(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Set >,1 > > _4150);
static  monty::rc_ptr< ::mosek::fusion::Set > make(monty::rc_ptr< ::mosek::fusion::Set > _4151,monty::rc_ptr< ::mosek::fusion::Set > _4152);
static  monty::rc_ptr< ::mosek::fusion::Set > make(std::shared_ptr< monty::ndarray< int,1 > > _4153);
static  monty::rc_ptr< ::mosek::fusion::Set > make(int _4154,int _4155,int _4156);
static  monty::rc_ptr< ::mosek::fusion::Set > make(int _4157,int _4158);
static  monty::rc_ptr< ::mosek::fusion::Set > make(int _4159);
static  monty::rc_ptr< ::mosek::fusion::Set > scalar();
static  monty::rc_ptr< ::mosek::fusion::Set > make(std::shared_ptr< monty::ndarray< std::string,1 > > _4160);
virtual int realnd();
virtual long long getSize();
virtual bool compare(monty::rc_ptr< ::mosek::fusion::Set > _4163);
}; // struct Set;

struct p_BaseSet : public ::mosek::fusion::p_Set
{
BaseSet * _pubthis;
static mosek::fusion::p_BaseSet* _get_impl(mosek::fusion::BaseSet * _inst){ return static_cast< mosek::fusion::p_BaseSet* >(mosek::fusion::p_Set::_get_impl(_inst)); }
static mosek::fusion::p_BaseSet * _get_impl(mosek::fusion::BaseSet::t _inst) { return _get_impl(_inst.get()); }
p_BaseSet(BaseSet * _pubthis);
virtual ~p_BaseSet() { /* std::cout << "~p_BaseSet" << std::endl;*/ };
virtual void destroy();
static BaseSet::t _new_BaseSet(long long _4084);
void _initialize(long long _4084);
virtual int dim(int _4085);
}; // struct BaseSet;

struct p_IntSet : public ::mosek::fusion::p_BaseSet
{
IntSet * _pubthis;
static mosek::fusion::p_IntSet* _get_impl(mosek::fusion::IntSet * _inst){ return static_cast< mosek::fusion::p_IntSet* >(mosek::fusion::p_BaseSet::_get_impl(_inst)); }
static mosek::fusion::p_IntSet * _get_impl(mosek::fusion::IntSet::t _inst) { return _get_impl(_inst.get()); }
p_IntSet(IntSet * _pubthis);
virtual ~p_IntSet() { /* std::cout << "~p_IntSet" << std::endl;*/ };
int last{};int first{};virtual void destroy();
static IntSet::t _new_IntSet(int _4056);
void _initialize(int _4056);
static IntSet::t _new_IntSet(int _4057,int _4058);
void _initialize(int _4057,int _4058);
virtual std::string indexToString(long long _4059);
virtual std::string getname(std::shared_ptr< monty::ndarray< int,1 > > _4060);
virtual std::string getname(long long _4061);
virtual monty::rc_ptr< ::mosek::fusion::Set > slice(std::shared_ptr< monty::ndarray< int,1 > > _4062,std::shared_ptr< monty::ndarray< int,1 > > _4063);
virtual monty::rc_ptr< ::mosek::fusion::Set > slice(int _4064,int _4065);
virtual int getidx(int _4066);
virtual long long stride(int _4067);
}; // struct IntSet;

struct p_StringSet : public ::mosek::fusion::p_BaseSet
{
StringSet * _pubthis;
static mosek::fusion::p_StringSet* _get_impl(mosek::fusion::StringSet * _inst){ return static_cast< mosek::fusion::p_StringSet* >(mosek::fusion::p_BaseSet::_get_impl(_inst)); }
static mosek::fusion::p_StringSet * _get_impl(mosek::fusion::StringSet::t _inst) { return _get_impl(_inst.get()); }
p_StringSet(StringSet * _pubthis);
virtual ~p_StringSet() { /* std::cout << "~p_StringSet" << std::endl;*/ };
std::shared_ptr< monty::ndarray< std::string,1 > > keys{};virtual void destroy();
static StringSet::t _new_StringSet(std::shared_ptr< monty::ndarray< std::string,1 > > _4068);
void _initialize(std::shared_ptr< monty::ndarray< std::string,1 > > _4068);
virtual std::string indexToString(long long _4069);
virtual std::string getname(std::shared_ptr< monty::ndarray< int,1 > > _4070);
virtual std::string getname(long long _4071);
virtual monty::rc_ptr< ::mosek::fusion::BaseSet > slice_(std::shared_ptr< monty::ndarray< int,1 > > _4072,std::shared_ptr< monty::ndarray< int,1 > > _4073);
virtual monty::rc_ptr< ::mosek::fusion::BaseSet > slice_(int _4074,int _4075);
virtual monty::rc_ptr< ::mosek::fusion::Set > slice(std::shared_ptr< monty::ndarray< int,1 > > _4077,std::shared_ptr< monty::ndarray< int,1 > > _4078);
virtual monty::rc_ptr< ::mosek::fusion::Set > slice(int _4079,int _4080);
virtual std::string toString();
virtual long long stride(int _4083);
}; // struct StringSet;

struct p_NDSet : public ::mosek::fusion::p_Set
{
NDSet * _pubthis;
static mosek::fusion::p_NDSet* _get_impl(mosek::fusion::NDSet * _inst){ return static_cast< mosek::fusion::p_NDSet* >(mosek::fusion::p_Set::_get_impl(_inst)); }
static mosek::fusion::p_NDSet * _get_impl(mosek::fusion::NDSet::t _inst) { return _get_impl(_inst.get()); }
p_NDSet(NDSet * _pubthis);
virtual ~p_NDSet() { /* std::cout << "~p_NDSet" << std::endl;*/ };
std::shared_ptr< monty::ndarray< long long,1 > > strides{};std::shared_ptr< monty::ndarray< int,1 > > dimdef{};virtual void destroy();
static NDSet::t _new_NDSet(int _4086,int _4087,int _4088);
void _initialize(int _4086,int _4087,int _4088);
static NDSet::t _new_NDSet(int _4089,int _4090);
void _initialize(int _4089,int _4090);
static NDSet::t _new_NDSet(std::shared_ptr< monty::ndarray< int,1 > > _4091);
void _initialize(std::shared_ptr< monty::ndarray< int,1 > > _4091);
virtual std::string indexToString(long long _4095);
virtual std::string getname(std::shared_ptr< monty::ndarray< int,1 > > _4099);
virtual std::string getname(long long _4103);
virtual int dim(int _4108);
virtual monty::rc_ptr< ::mosek::fusion::Set > slice(std::shared_ptr< monty::ndarray< int,1 > > _4109,std::shared_ptr< monty::ndarray< int,1 > > _4110);
virtual monty::rc_ptr< ::mosek::fusion::Set > slice(int _4114,int _4115);
virtual std::shared_ptr< monty::ndarray< int,1 > > selectidxs(std::shared_ptr< monty::ndarray< std::string,1 > > _4116);
virtual int linear_index_in_dim(int _4117,std::shared_ptr< monty::ndarray< int,1 > > _4118);
virtual int linear_index_in_dim(int _4119,int _4120);
static  long long sumdims(std::shared_ptr< monty::ndarray< int,1 > > _4121);
virtual long long stride(int _4124);
}; // struct NDSet;

struct p_ProductSet : public ::mosek::fusion::p_NDSet
{
ProductSet * _pubthis;
static mosek::fusion::p_ProductSet* _get_impl(mosek::fusion::ProductSet * _inst){ return static_cast< mosek::fusion::p_ProductSet* >(mosek::fusion::p_NDSet::_get_impl(_inst)); }
static mosek::fusion::p_ProductSet * _get_impl(mosek::fusion::ProductSet::t _inst) { return _get_impl(_inst.get()); }
p_ProductSet(ProductSet * _pubthis);
virtual ~p_ProductSet() { /* std::cout << "~p_ProductSet" << std::endl;*/ };
std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Set >,1 > > sets{};virtual void destroy();
static ProductSet::t _new_ProductSet(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Set >,1 > > _4038);
void _initialize(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Set >,1 > > _4038);
virtual std::string indexToString(long long _4040);
static  std::shared_ptr< monty::ndarray< int,1 > > computedims(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Set >,1 > > _4050);
}; // struct ProductSet;

struct p_QConeDomain
{
QConeDomain * _pubthis;
static mosek::fusion::p_QConeDomain* _get_impl(mosek::fusion::QConeDomain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_QConeDomain * _get_impl(mosek::fusion::QConeDomain::t _inst) { return _get_impl(_inst.get()); }
p_QConeDomain(QConeDomain * _pubthis);
virtual ~p_QConeDomain() { /* std::cout << "~p_QConeDomain" << std::endl;*/ };
monty::rc_ptr< ::mosek::fusion::Set > shape{};bool int_flag{};int axisidx{};mosek::fusion::QConeKey key{};virtual void destroy();
static QConeDomain::t _new_QConeDomain(mosek::fusion::QConeKey _4166,std::shared_ptr< monty::ndarray< int,1 > > _4167,int _4168);
void _initialize(mosek::fusion::QConeKey _4166,std::shared_ptr< monty::ndarray< int,1 > > _4167,int _4168);
virtual std::string domainToString(long long _4169,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _4170);
virtual bool match_shape(monty::rc_ptr< ::mosek::fusion::Set > _4177);
virtual monty::rc_ptr< ::mosek::fusion::QConeDomain > integral();
virtual int getAxis();
virtual monty::rc_ptr< ::mosek::fusion::QConeDomain > axis(int _4178);
}; // struct QConeDomain;

struct p_LinPSDDomain
{
LinPSDDomain * _pubthis;
static mosek::fusion::p_LinPSDDomain* _get_impl(mosek::fusion::LinPSDDomain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_LinPSDDomain * _get_impl(mosek::fusion::LinPSDDomain::t _inst) { return _get_impl(_inst.get()); }
p_LinPSDDomain(LinPSDDomain * _pubthis);
virtual ~p_LinPSDDomain() { /* std::cout << "~p_LinPSDDomain" << std::endl;*/ };
monty::rc_ptr< ::mosek::fusion::Set > shape{};virtual void destroy();
static LinPSDDomain::t _new_LinPSDDomain(monty::rc_ptr< ::mosek::fusion::Set > _4179);
void _initialize(monty::rc_ptr< ::mosek::fusion::Set > _4179);
}; // struct LinPSDDomain;

struct p_PSDDomain
{
PSDDomain * _pubthis;
static mosek::fusion::p_PSDDomain* _get_impl(mosek::fusion::PSDDomain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_PSDDomain * _get_impl(mosek::fusion::PSDDomain::t _inst) { return _get_impl(_inst.get()); }
p_PSDDomain(PSDDomain * _pubthis);
virtual ~p_PSDDomain() { /* std::cout << "~p_PSDDomain" << std::endl;*/ };
mosek::fusion::PSDKey key{};monty::rc_ptr< ::mosek::fusion::Set > shape{};virtual void destroy();
static PSDDomain::t _new_PSDDomain(mosek::fusion::PSDKey _4180,monty::rc_ptr< ::mosek::fusion::Set > _4181);
void _initialize(mosek::fusion::PSDKey _4180,monty::rc_ptr< ::mosek::fusion::Set > _4181);
virtual std::string domainToString(long long _4182,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _4183);
}; // struct PSDDomain;

struct p_RangeDomain
{
RangeDomain * _pubthis;
static mosek::fusion::p_RangeDomain* _get_impl(mosek::fusion::RangeDomain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_RangeDomain * _get_impl(mosek::fusion::RangeDomain::t _inst) { return _get_impl(_inst.get()); }
p_RangeDomain(RangeDomain * _pubthis);
virtual ~p_RangeDomain() { /* std::cout << "~p_RangeDomain" << std::endl;*/ };
bool sparse_flag{};bool cardinal_flag{};std::shared_ptr< monty::ndarray< double,1 > > ub{};std::shared_ptr< monty::ndarray< double,1 > > lb{};monty::rc_ptr< ::mosek::fusion::Utils::IntMap > idxmap{};monty::rc_ptr< ::mosek::fusion::Set > shape{};virtual void destroy();
static RangeDomain::t _new_RangeDomain(std::shared_ptr< monty::ndarray< double,1 > > _4188,std::shared_ptr< monty::ndarray< double,1 > > _4189,std::shared_ptr< monty::ndarray< int,1 > > _4190,std::shared_ptr< monty::ndarray< long long,1 > > _4191);
void _initialize(std::shared_ptr< monty::ndarray< double,1 > > _4188,std::shared_ptr< monty::ndarray< double,1 > > _4189,std::shared_ptr< monty::ndarray< int,1 > > _4190,std::shared_ptr< monty::ndarray< long long,1 > > _4191);
static RangeDomain::t _new_RangeDomain(monty::rc_ptr< ::mosek::fusion::RangeDomain > _4193);
void _initialize(monty::rc_ptr< ::mosek::fusion::RangeDomain > _4193);
virtual monty::rc_ptr< ::mosek::fusion::SymmetricRangeDomain > symmetric();
virtual monty::rc_ptr< ::mosek::fusion::RangeDomain > sparse();
virtual monty::rc_ptr< ::mosek::fusion::RangeDomain > integral();
virtual std::string domainToString(long long _4194,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _4195);
virtual bool match_shape(monty::rc_ptr< ::mosek::fusion::Set > _4196);
virtual double get_ub_item(long long _4197);
virtual double get_lb_item(long long _4198);
}; // struct RangeDomain;

struct p_SymmetricRangeDomain : public ::mosek::fusion::p_RangeDomain
{
SymmetricRangeDomain * _pubthis;
static mosek::fusion::p_SymmetricRangeDomain* _get_impl(mosek::fusion::SymmetricRangeDomain * _inst){ return static_cast< mosek::fusion::p_SymmetricRangeDomain* >(mosek::fusion::p_RangeDomain::_get_impl(_inst)); }
static mosek::fusion::p_SymmetricRangeDomain * _get_impl(mosek::fusion::SymmetricRangeDomain::t _inst) { return _get_impl(_inst.get()); }
p_SymmetricRangeDomain(SymmetricRangeDomain * _pubthis);
virtual ~p_SymmetricRangeDomain() { /* std::cout << "~p_SymmetricRangeDomain" << std::endl;*/ };
int dim{};virtual void destroy();
static SymmetricRangeDomain::t _new_SymmetricRangeDomain(monty::rc_ptr< ::mosek::fusion::RangeDomain > _4187);
void _initialize(monty::rc_ptr< ::mosek::fusion::RangeDomain > _4187);
}; // struct SymmetricRangeDomain;

struct p_SymmetricLinearDomain
{
SymmetricLinearDomain * _pubthis;
static mosek::fusion::p_SymmetricLinearDomain* _get_impl(mosek::fusion::SymmetricLinearDomain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_SymmetricLinearDomain * _get_impl(mosek::fusion::SymmetricLinearDomain::t _inst) { return _get_impl(_inst.get()); }
p_SymmetricLinearDomain(SymmetricLinearDomain * _pubthis);
virtual ~p_SymmetricLinearDomain() { /* std::cout << "~p_SymmetricLinearDomain" << std::endl;*/ };
bool sparse_flag{};bool cardinal_flag{};mosek::fusion::RelationKey key{};monty::rc_ptr< ::mosek::fusion::Set > shape{};monty::rc_ptr< ::mosek::fusion::LinearDomain > dom{};int dim{};virtual void destroy();
static SymmetricLinearDomain::t _new_SymmetricLinearDomain(monty::rc_ptr< ::mosek::fusion::LinearDomain > _4199);
void _initialize(monty::rc_ptr< ::mosek::fusion::LinearDomain > _4199);
virtual monty::rc_ptr< ::mosek::fusion::SymmetricLinearDomain > sparse();
virtual monty::rc_ptr< ::mosek::fusion::SymmetricLinearDomain > integral();
virtual std::string domainToString(long long _4200,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _4201);
virtual bool match_shape(monty::rc_ptr< ::mosek::fusion::Set > _4202);
virtual double get_rhs_item(long long _4203);
}; // struct SymmetricLinearDomain;

struct p_LinearDomain
{
LinearDomain * _pubthis;
static mosek::fusion::p_LinearDomain* _get_impl(mosek::fusion::LinearDomain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_LinearDomain * _get_impl(mosek::fusion::LinearDomain::t _inst) { return _get_impl(_inst.get()); }
p_LinearDomain(LinearDomain * _pubthis);
virtual ~p_LinearDomain() { /* std::cout << "~p_LinearDomain" << std::endl;*/ };
bool sparse_flag{};bool cardinal_flag{};mosek::fusion::RelationKey key{};std::shared_ptr< monty::ndarray< double,1 > > bnd{};monty::rc_ptr< ::mosek::fusion::Utils::IntMap > inst{};monty::rc_ptr< ::mosek::fusion::Set > shape{};virtual void destroy();
static LinearDomain::t _new_LinearDomain(mosek::fusion::RelationKey _4204,std::shared_ptr< monty::ndarray< double,1 > > _4205,std::shared_ptr< monty::ndarray< long long,1 > > _4206,std::shared_ptr< monty::ndarray< int,1 > > _4207);
void _initialize(mosek::fusion::RelationKey _4204,std::shared_ptr< monty::ndarray< double,1 > > _4205,std::shared_ptr< monty::ndarray< long long,1 > > _4206,std::shared_ptr< monty::ndarray< int,1 > > _4207);
static LinearDomain::t _new_LinearDomain(monty::rc_ptr< ::mosek::fusion::LinearDomain > _4209);
void _initialize(monty::rc_ptr< ::mosek::fusion::LinearDomain > _4209);
virtual monty::rc_ptr< ::mosek::fusion::SymmetricLinearDomain > symmetric();
virtual monty::rc_ptr< ::mosek::fusion::LinearDomain > sparse();
virtual monty::rc_ptr< ::mosek::fusion::LinearDomain > integral();
virtual std::string domainToString(long long _4210,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _4211);
virtual bool match_shape(monty::rc_ptr< ::mosek::fusion::Set > _4212);
virtual double get_rhs_item(long long _4213);
virtual bool scalable();
}; // struct LinearDomain;

struct p_Domain
{
Domain * _pubthis;
static mosek::fusion::p_Domain* _get_impl(mosek::fusion::Domain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_Domain * _get_impl(mosek::fusion::Domain::t _inst) { return _get_impl(_inst.get()); }
p_Domain(Domain * _pubthis);
virtual ~p_Domain() { /* std::cout << "~p_Domain" << std::endl;*/ };
virtual void destroy();
static  long long dimsize(std::shared_ptr< monty::ndarray< int,1 > > _4214);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > mkLinearDomain(mosek::fusion::RelationKey _4217,monty::rc_ptr< ::mosek::fusion::Matrix > _4218);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > mkLinearDomain(mosek::fusion::RelationKey _4224,std::shared_ptr< monty::ndarray< double,2 > > _4225);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > mkLinearDomain(mosek::fusion::RelationKey _4228,std::shared_ptr< monty::ndarray< double,1 > > _4229,std::shared_ptr< monty::ndarray< int,1 > > _4230);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > mkLinearDomain(mosek::fusion::RelationKey _4233,std::shared_ptr< monty::ndarray< double,1 > > _4234);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > mkLinearDomain(mosek::fusion::RelationKey _4236,double _4237,std::shared_ptr< monty::ndarray< int,1 > > _4238);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > mkLinearDomain(mosek::fusion::RelationKey _4241,double _4242);
static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(std::shared_ptr< monty::ndarray< double,1 > > _4243,std::shared_ptr< monty::ndarray< double,1 > > _4244,std::shared_ptr< monty::ndarray< int,1 > > _4245);
static  monty::rc_ptr< ::mosek::fusion::SymmetricRangeDomain > symmetric(monty::rc_ptr< ::mosek::fusion::RangeDomain > _4247);
static  monty::rc_ptr< ::mosek::fusion::SymmetricLinearDomain > symmetric(monty::rc_ptr< ::mosek::fusion::LinearDomain > _4248);
static  monty::rc_ptr< ::mosek::fusion::RangeDomain > sparse(monty::rc_ptr< ::mosek::fusion::RangeDomain > _4249);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > sparse(monty::rc_ptr< ::mosek::fusion::LinearDomain > _4250);
static  monty::rc_ptr< ::mosek::fusion::RangeDomain > integral(monty::rc_ptr< ::mosek::fusion::RangeDomain > _4251);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > integral(monty::rc_ptr< ::mosek::fusion::LinearDomain > _4252);
static  monty::rc_ptr< ::mosek::fusion::QConeDomain > integral(monty::rc_ptr< ::mosek::fusion::QConeDomain > _4253);
static  monty::rc_ptr< ::mosek::fusion::QConeDomain > axis(monty::rc_ptr< ::mosek::fusion::QConeDomain > _4254,int _4255);
static  monty::rc_ptr< ::mosek::fusion::QConeDomain > inRotatedQCone(std::shared_ptr< monty::ndarray< int,1 > > _4256);
static  monty::rc_ptr< ::mosek::fusion::QConeDomain > inRotatedQCone(int _4258,int _4259);
static  monty::rc_ptr< ::mosek::fusion::QConeDomain > inRotatedQCone(int _4260);
static  monty::rc_ptr< ::mosek::fusion::QConeDomain > inRotatedQCone();
static  monty::rc_ptr< ::mosek::fusion::QConeDomain > inQCone(std::shared_ptr< monty::ndarray< int,1 > > _4261);
static  monty::rc_ptr< ::mosek::fusion::QConeDomain > inQCone(int _4263,int _4264);
static  monty::rc_ptr< ::mosek::fusion::QConeDomain > inQCone(int _4265);
static  monty::rc_ptr< ::mosek::fusion::QConeDomain > inQCone();
static  monty::rc_ptr< ::mosek::fusion::LinPSDDomain > isLinPSD(int _4266,int _4267);
static  monty::rc_ptr< ::mosek::fusion::LinPSDDomain > isLinPSD(int _4268);
static  monty::rc_ptr< ::mosek::fusion::LinPSDDomain > isLinPSD();
static  monty::rc_ptr< ::mosek::fusion::PSDDomain > isTrilPSD(int _4269,int _4270);
static  monty::rc_ptr< ::mosek::fusion::PSDDomain > isTrilPSD(int _4271);
static  monty::rc_ptr< ::mosek::fusion::PSDDomain > isTrilPSD();
static  monty::rc_ptr< ::mosek::fusion::PSDDomain > inPSDCone(int _4272,int _4273);
static  monty::rc_ptr< ::mosek::fusion::PSDDomain > inPSDCone(int _4274);
static  monty::rc_ptr< ::mosek::fusion::PSDDomain > inPSDCone();
static  monty::rc_ptr< ::mosek::fusion::RangeDomain > binary();
static  monty::rc_ptr< ::mosek::fusion::RangeDomain > binary(std::shared_ptr< monty::ndarray< int,1 > > _4275);
static  monty::rc_ptr< ::mosek::fusion::RangeDomain > binary(int _4278,int _4279);
static  monty::rc_ptr< ::mosek::fusion::RangeDomain > binary(int _4282);
static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(monty::rc_ptr< ::mosek::fusion::Matrix > _4285,monty::rc_ptr< ::mosek::fusion::Matrix > _4286);
static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(monty::rc_ptr< ::mosek::fusion::Matrix > _4287,double _4288);
static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(double _4290,monty::rc_ptr< ::mosek::fusion::Matrix > _4291);
static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(std::shared_ptr< monty::ndarray< double,1 > > _4293,std::shared_ptr< monty::ndarray< double,1 > > _4294);
static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(std::shared_ptr< monty::ndarray< double,1 > > _4295,double _4296);
static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(double _4298,std::shared_ptr< monty::ndarray< double,1 > > _4299);
static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(double _4301,double _4302);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > greaterThan(monty::rc_ptr< ::mosek::fusion::Matrix > _4303);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > greaterThan(std::shared_ptr< monty::ndarray< double,1 > > _4304,std::shared_ptr< monty::ndarray< int,1 > > _4305);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > greaterThan(std::shared_ptr< monty::ndarray< double,2 > > _4306);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > greaterThan(std::shared_ptr< monty::ndarray< double,1 > > _4307);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > greaterThan(double _4308,std::shared_ptr< monty::ndarray< int,1 > > _4309);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > greaterThan(double _4310,int _4311,int _4312);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > greaterThan(double _4313,int _4314);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > greaterThan(double _4315);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > lessThan(monty::rc_ptr< ::mosek::fusion::Matrix > _4316);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > lessThan(std::shared_ptr< monty::ndarray< double,1 > > _4317,std::shared_ptr< monty::ndarray< int,1 > > _4318);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > lessThan(std::shared_ptr< monty::ndarray< double,2 > > _4319);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > lessThan(std::shared_ptr< monty::ndarray< double,1 > > _4320);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > lessThan(double _4321,std::shared_ptr< monty::ndarray< int,1 > > _4322);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > lessThan(double _4323,int _4324,int _4325);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > lessThan(double _4326,int _4327);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > lessThan(double _4328);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > equalsTo(monty::rc_ptr< ::mosek::fusion::Matrix > _4329);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > equalsTo(std::shared_ptr< monty::ndarray< double,1 > > _4330,std::shared_ptr< monty::ndarray< int,1 > > _4331);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > equalsTo(std::shared_ptr< monty::ndarray< double,2 > > _4332);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > equalsTo(std::shared_ptr< monty::ndarray< double,1 > > _4333);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > equalsTo(double _4334,std::shared_ptr< monty::ndarray< int,1 > > _4335);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > equalsTo(double _4336,int _4337,int _4338);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > equalsTo(double _4339,int _4340);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > equalsTo(double _4341);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > unbounded(std::shared_ptr< monty::ndarray< int,1 > > _4342);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > unbounded(int _4344,int _4345);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > unbounded(int _4346);
static  monty::rc_ptr< ::mosek::fusion::LinearDomain > unbounded();
}; // struct Domain;

struct p_SymmetricExpr
{
SymmetricExpr * _pubthis;
static mosek::fusion::p_SymmetricExpr* _get_impl(mosek::fusion::SymmetricExpr * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_SymmetricExpr * _get_impl(mosek::fusion::SymmetricExpr::t _inst) { return _get_impl(_inst.get()); }
p_SymmetricExpr(SymmetricExpr * _pubthis);
virtual ~p_SymmetricExpr() { /* std::cout << "~p_SymmetricExpr" << std::endl;*/ };
std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > xs{};monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > b{};std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::SymmetricMatrix >,1 > > Ms{};int n{};virtual void destroy();
static SymmetricExpr::t _new_SymmetricExpr(int _4355,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::SymmetricMatrix >,1 > > _4356,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _4357,monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > _4358);
void _initialize(int _4355,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::SymmetricMatrix >,1 > > _4356,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _4357,monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > _4358);
static  monty::rc_ptr< ::mosek::fusion::SymmetricExpr > add(monty::rc_ptr< ::mosek::fusion::SymmetricExpr > _4359,monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > _4360);
static  monty::rc_ptr< ::mosek::fusion::SymmetricExpr > mul(monty::rc_ptr< ::mosek::fusion::SymmetricExpr > _4361,double _4362);
static  monty::rc_ptr< ::mosek::fusion::SymmetricExpr > add(monty::rc_ptr< ::mosek::fusion::SymmetricExpr > _4364,monty::rc_ptr< ::mosek::fusion::SymmetricExpr > _4365);
virtual std::string toString();
}; // struct SymmetricExpr;

struct p_Expr : public /*implements*/ ::mosek::fusion::Expression
{
Expr * _pubthis;
static mosek::fusion::p_Expr* _get_impl(mosek::fusion::Expr * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_Expr * _get_impl(mosek::fusion::Expr::t _inst) { return _get_impl(_inst.get()); }
p_Expr(Expr * _pubthis);
virtual ~p_Expr() { /* std::cout << "~p_Expr" << std::endl;*/ };
std::shared_ptr< monty::ndarray< long long,1 > > varsb{};std::shared_ptr< monty::ndarray< long long,1 > > inst{};std::shared_ptr< monty::ndarray< double,1 > > cof_v{};std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > x{};std::shared_ptr< monty::ndarray< long long,1 > > subj{};std::shared_ptr< monty::ndarray< long long,1 > > ptrb{};std::shared_ptr< monty::ndarray< double,1 > > bfix{};monty::rc_ptr< ::mosek::fusion::Set > shape_p{};monty::rc_ptr< ::mosek::fusion::Model > model{};virtual void destroy();
static Expr::t _new_Expr(std::shared_ptr< monty::ndarray< long long,1 > > _4376,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _4377,std::shared_ptr< monty::ndarray< long long,1 > > _4378,std::shared_ptr< monty::ndarray< double,1 > > _4379,std::shared_ptr< monty::ndarray< double,1 > > _4380,monty::rc_ptr< ::mosek::fusion::Set > _4381,std::shared_ptr< monty::ndarray< long long,1 > > _4382);
void _initialize(std::shared_ptr< monty::ndarray< long long,1 > > _4376,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _4377,std::shared_ptr< monty::ndarray< long long,1 > > _4378,std::shared_ptr< monty::ndarray< double,1 > > _4379,std::shared_ptr< monty::ndarray< double,1 > > _4380,monty::rc_ptr< ::mosek::fusion::Set > _4381,std::shared_ptr< monty::ndarray< long long,1 > > _4382);
static Expr::t _new_Expr(std::shared_ptr< monty::ndarray< long long,1 > > _4386,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _4387,std::shared_ptr< monty::ndarray< long long,1 > > _4388,std::shared_ptr< monty::ndarray< double,1 > > _4389,std::shared_ptr< monty::ndarray< double,1 > > _4390,monty::rc_ptr< ::mosek::fusion::Set > _4391,std::shared_ptr< monty::ndarray< long long,1 > > _4392,int _4393);
void _initialize(std::shared_ptr< monty::ndarray< long long,1 > > _4386,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _4387,std::shared_ptr< monty::ndarray< long long,1 > > _4388,std::shared_ptr< monty::ndarray< double,1 > > _4389,std::shared_ptr< monty::ndarray< double,1 > > _4390,monty::rc_ptr< ::mosek::fusion::Set > _4391,std::shared_ptr< monty::ndarray< long long,1 > > _4392,int _4393);
static Expr::t _new_Expr(monty::rc_ptr< ::mosek::fusion::Expression > _4395);
void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _4395);
virtual std::string toString();
virtual void tostr(monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _4404,int _4405);
static  std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > varstack(std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > >,1 > > _4411);
static  std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > varstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _4414,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _4415);
static  monty::rc_ptr< ::mosek::fusion::Expression > flatten(monty::rc_ptr< ::mosek::fusion::Expression > _4419);
static  monty::rc_ptr< ::mosek::fusion::Expression > reshape(monty::rc_ptr< ::mosek::fusion::Expression > _4420,int _4421,int _4422);
static  monty::rc_ptr< ::mosek::fusion::Expression > reshape(monty::rc_ptr< ::mosek::fusion::Expression > _4423,int _4424);
static  monty::rc_ptr< ::mosek::fusion::Expression > reshape(monty::rc_ptr< ::mosek::fusion::Expression > _4425,monty::rc_ptr< ::mosek::fusion::Set > _4426);
virtual long long size();
virtual monty::rc_ptr< ::mosek::fusion::FlatExpr > eval();
static  monty::rc_ptr< ::mosek::fusion::Expression > zeros(int _4432);
static  monty::rc_ptr< ::mosek::fusion::Expression > ones(int _4438);
static  monty::rc_ptr< ::mosek::fusion::Expression > constTerm(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _4443);
static  monty::rc_ptr< ::mosek::fusion::Expression > constTerm(monty::rc_ptr< ::mosek::fusion::Matrix > _4451);
static  monty::rc_ptr< ::mosek::fusion::Expression > constTerm(double _4463);
static  monty::rc_ptr< ::mosek::fusion::Expression > constTerm(monty::rc_ptr< ::mosek::fusion::Set > _4469,double _4470);
static  monty::rc_ptr< ::mosek::fusion::Expression > constTerm(int _4476,double _4477);
static  monty::rc_ptr< ::mosek::fusion::Expression > constTerm(std::shared_ptr< monty::ndarray< double,2 > > _4483);
static  monty::rc_ptr< ::mosek::fusion::Expression > constTerm(std::shared_ptr< monty::ndarray< double,1 > > _4493);
virtual long long numNonzeros();
static  monty::rc_ptr< ::mosek::fusion::Expression > sum_expr(monty::rc_ptr< ::mosek::fusion::Expression > _4499,int _4500,int _4501);
static  monty::rc_ptr< ::mosek::fusion::Expression > sum_var(monty::rc_ptr< ::mosek::fusion::Variable > _4547,int _4548,int _4549);
static  monty::rc_ptr< ::mosek::fusion::Expression > sum(monty::rc_ptr< ::mosek::fusion::Expression > _4579,int _4580,int _4581);
static  monty::rc_ptr< ::mosek::fusion::Expression > sum(monty::rc_ptr< ::mosek::fusion::Expression > _4582,int _4583);
static  monty::rc_ptr< ::mosek::fusion::Expression > sum(monty::rc_ptr< ::mosek::fusion::Variable > _4584,int _4585,int _4586);
static  monty::rc_ptr< ::mosek::fusion::Expression > sum(monty::rc_ptr< ::mosek::fusion::Variable > _4587,int _4588);
static  monty::rc_ptr< ::mosek::fusion::Expression > sum(monty::rc_ptr< ::mosek::fusion::Variable > _4589);
static  monty::rc_ptr< ::mosek::fusion::Expression > sum(monty::rc_ptr< ::mosek::fusion::Expression > _4590);
static  monty::rc_ptr< ::mosek::fusion::Expression > neg(monty::rc_ptr< ::mosek::fusion::Variable > _4598);
static  monty::rc_ptr< ::mosek::fusion::Expression > neg(monty::rc_ptr< ::mosek::fusion::Expression > _4603);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul__(monty::rc_ptr< ::mosek::fusion::Matrix > _4609,monty::rc_ptr< ::mosek::fusion::Expression > _4610);
static  void sparseMatrixVector(std::shared_ptr< monty::ndarray< long long,1 > > _4722,std::shared_ptr< monty::ndarray< int,1 > > _4723,std::shared_ptr< monty::ndarray< double,1 > > _4724,std::shared_ptr< monty::ndarray< double,1 > > _4725,std::shared_ptr< monty::ndarray< double,1 > > _4726,int _4727);
static  void sparseMatmul(std::shared_ptr< monty::ndarray< long long,1 > > _4732,std::shared_ptr< monty::ndarray< int,1 > > _4733,std::shared_ptr< monty::ndarray< double,1 > > _4734,std::shared_ptr< monty::ndarray< long long,1 > > _4735,std::shared_ptr< monty::ndarray< int,1 > > _4736,std::shared_ptr< monty::ndarray< double,1 > > _4737,std::shared_ptr< monty::ndarray< long long,1 > > _4738,std::shared_ptr< monty::ndarray< int,1 > > _4739,std::shared_ptr< monty::ndarray< double,1 > > _4740,int _4741,int _4742,std::shared_ptr< monty::ndarray< int,1 > > _4743);
static  long long computeNz(std::shared_ptr< monty::ndarray< long long,1 > > _4755,std::shared_ptr< monty::ndarray< int,1 > > _4756,std::shared_ptr< monty::ndarray< long long,1 > > _4757,std::shared_ptr< monty::ndarray< int,1 > > _4758,int _4759,int _4760,std::shared_ptr< monty::ndarray< int,1 > > _4761,std::shared_ptr< monty::ndarray< long long,1 > > _4762);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(monty::rc_ptr< ::mosek::fusion::Variable > _4771,monty::rc_ptr< ::mosek::fusion::Matrix > _4772);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(monty::rc_ptr< ::mosek::fusion::Matrix > _4797,monty::rc_ptr< ::mosek::fusion::Variable > _4798);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(monty::rc_ptr< ::mosek::fusion::Expression > _4817,monty::rc_ptr< ::mosek::fusion::Matrix > _4818);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(monty::rc_ptr< ::mosek::fusion::Matrix > _4901,monty::rc_ptr< ::mosek::fusion::Expression > _4902);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(monty::rc_ptr< ::mosek::fusion::Variable > _4967,std::shared_ptr< monty::ndarray< double,2 > > _4968);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(std::shared_ptr< monty::ndarray< double,2 > > _4969,monty::rc_ptr< ::mosek::fusion::Variable > _4970);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(monty::rc_ptr< ::mosek::fusion::Expression > _4971,std::shared_ptr< monty::ndarray< double,2 > > _4972);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(std::shared_ptr< monty::ndarray< double,2 > > _4973,monty::rc_ptr< ::mosek::fusion::Expression > _4974);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm_(monty::rc_ptr< ::mosek::fusion::Matrix > _4975,monty::rc_ptr< ::mosek::fusion::Expression > _4976);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm_(monty::rc_ptr< ::mosek::fusion::Matrix > _4984,monty::rc_ptr< ::mosek::fusion::Variable > _4985);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm_(std::shared_ptr< monty::ndarray< double,1 > > _4992,monty::rc_ptr< ::mosek::fusion::Variable > _4993);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm_(std::shared_ptr< monty::ndarray< double,1 > > _4994,monty::rc_ptr< ::mosek::fusion::Expression > _4995);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm_(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _4997,monty::rc_ptr< ::mosek::fusion::Expression > _4998);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm_(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _5003,monty::rc_ptr< ::mosek::fusion::Variable > _5004);
static  monty::rc_ptr< ::mosek::fusion::Expression > dotmul_(std::shared_ptr< monty::ndarray< long long,1 > > _5006,std::shared_ptr< monty::ndarray< double,1 > > _5007,monty::rc_ptr< ::mosek::fusion::Variable > _5008,monty::rc_ptr< ::mosek::fusion::Set > _5009);
static  monty::rc_ptr< ::mosek::fusion::Expression > dotmul_(std::shared_ptr< monty::ndarray< long long,1 > > _5015,std::shared_ptr< monty::ndarray< double,1 > > _5016,std::shared_ptr< monty::ndarray< long long,1 > > _5017,std::shared_ptr< monty::ndarray< long long,1 > > _5018,std::shared_ptr< monty::ndarray< double,1 > > _5019,std::shared_ptr< monty::ndarray< double,1 > > _5020,std::shared_ptr< monty::ndarray< long long,1 > > _5021,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _5022,monty::rc_ptr< ::mosek::fusion::Set > _5023);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Matrix > _5044,monty::rc_ptr< ::mosek::fusion::Expression > _5045);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Expression > _5058,monty::rc_ptr< ::mosek::fusion::Matrix > _5059);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Expression > _5072,std::shared_ptr< monty::ndarray< double,1 > > _5073);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul(std::shared_ptr< monty::ndarray< double,1 > > _5081,monty::rc_ptr< ::mosek::fusion::Expression > _5082);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul(double _5090,monty::rc_ptr< ::mosek::fusion::Expression > _5091);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Expression > _5095,double _5096);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul_SMatrix_2DSExpr(std::shared_ptr< monty::ndarray< long long,1 > > _5097,std::shared_ptr< monty::ndarray< long long,1 > > _5098,std::shared_ptr< monty::ndarray< double,1 > > _5099,std::shared_ptr< monty::ndarray< double,1 > > _5100,std::shared_ptr< monty::ndarray< long long,1 > > _5101,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _5102,monty::rc_ptr< ::mosek::fusion::Set > _5103,int _5104,int _5105,std::shared_ptr< monty::ndarray< int,1 > > _5106,std::shared_ptr< monty::ndarray< int,1 > > _5107,std::shared_ptr< monty::ndarray< double,1 > > _5108,int _5109,int _5110);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul_2DSExpr_SMatrix(std::shared_ptr< monty::ndarray< long long,1 > > _5162,std::shared_ptr< monty::ndarray< long long,1 > > _5163,std::shared_ptr< monty::ndarray< double,1 > > _5164,std::shared_ptr< monty::ndarray< double,1 > > _5165,std::shared_ptr< monty::ndarray< long long,1 > > _5166,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _5167,monty::rc_ptr< ::mosek::fusion::Set > _5168,int _5169,int _5170,std::shared_ptr< monty::ndarray< int,1 > > _5171,std::shared_ptr< monty::ndarray< int,1 > > _5172,std::shared_ptr< monty::ndarray< double,1 > > _5173,int _5174,int _5175);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul_DMatrix_2DDExpr(std::shared_ptr< monty::ndarray< long long,1 > > _5223,std::shared_ptr< monty::ndarray< long long,1 > > _5224,std::shared_ptr< monty::ndarray< double,1 > > _5225,std::shared_ptr< monty::ndarray< double,1 > > _5226,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _5227,monty::rc_ptr< ::mosek::fusion::Set > _5228,int _5229,int _5230,std::shared_ptr< monty::ndarray< double,1 > > _5231,int _5232,int _5233);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul_2DDExpr_DMatrix(std::shared_ptr< monty::ndarray< long long,1 > > _5253,std::shared_ptr< monty::ndarray< long long,1 > > _5254,std::shared_ptr< monty::ndarray< double,1 > > _5255,std::shared_ptr< monty::ndarray< double,1 > > _5256,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _5257,monty::rc_ptr< ::mosek::fusion::Set > _5258,int _5259,int _5260,std::shared_ptr< monty::ndarray< double,1 > > _5261,int _5262,int _5263);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul_0DExpr_Matrix(std::shared_ptr< monty::ndarray< long long,1 > > _5285,std::shared_ptr< monty::ndarray< double,1 > > _5286,std::shared_ptr< monty::ndarray< double,1 > > _5287,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _5288,monty::rc_ptr< ::mosek::fusion::Matrix > _5289);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Variable > _5307,std::shared_ptr< monty::ndarray< double,2 > > _5308);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul(std::shared_ptr< monty::ndarray< double,2 > > _5312,monty::rc_ptr< ::mosek::fusion::Variable > _5313);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Variable > _5314,double _5315);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul(double _5316,monty::rc_ptr< ::mosek::fusion::Variable > _5317);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul(std::shared_ptr< monty::ndarray< double,1 > > _5324,monty::rc_ptr< ::mosek::fusion::Variable > _5325);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Variable > _5337,std::shared_ptr< monty::ndarray< double,1 > > _5338);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Variable > _5356,monty::rc_ptr< ::mosek::fusion::Matrix > _5357);
static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Matrix > _5400,monty::rc_ptr< ::mosek::fusion::Variable > _5401);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot_(monty::rc_ptr< ::mosek::fusion::Matrix > _5447,monty::rc_ptr< ::mosek::fusion::Expression > _5448);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot_(monty::rc_ptr< ::mosek::fusion::Matrix > _5456,monty::rc_ptr< ::mosek::fusion::Variable > _5457);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot_(std::shared_ptr< monty::ndarray< double,1 > > _5464,monty::rc_ptr< ::mosek::fusion::Variable > _5465);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot_(std::shared_ptr< monty::ndarray< double,1 > > _5466,monty::rc_ptr< ::mosek::fusion::Expression > _5467);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot_(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _5469,monty::rc_ptr< ::mosek::fusion::Expression > _5470);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot_(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _5475,monty::rc_ptr< ::mosek::fusion::Variable > _5476);
static  monty::rc_ptr< ::mosek::fusion::Expression > inner_(std::shared_ptr< monty::ndarray< long long,1 > > _5478,std::shared_ptr< monty::ndarray< double,1 > > _5479,monty::rc_ptr< ::mosek::fusion::Variable > _5480);
static  monty::rc_ptr< ::mosek::fusion::Expression > inner_(std::shared_ptr< monty::ndarray< long long,1 > > _5486,std::shared_ptr< monty::ndarray< double,1 > > _5487,std::shared_ptr< monty::ndarray< long long,1 > > _5488,std::shared_ptr< monty::ndarray< long long,1 > > _5489,std::shared_ptr< monty::ndarray< double,1 > > _5490,std::shared_ptr< monty::ndarray< double,1 > > _5491,std::shared_ptr< monty::ndarray< long long,1 > > _5492,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _5493);
static  monty::rc_ptr< ::mosek::fusion::Expression > outer(std::shared_ptr< monty::ndarray< double,1 > > _5510,monty::rc_ptr< ::mosek::fusion::Expression > _5511);
static  monty::rc_ptr< ::mosek::fusion::Expression > outer(monty::rc_ptr< ::mosek::fusion::Expression > _5514,std::shared_ptr< monty::ndarray< double,1 > > _5515);
static  monty::rc_ptr< ::mosek::fusion::Expression > outer(monty::rc_ptr< ::mosek::fusion::Matrix > _5518,monty::rc_ptr< ::mosek::fusion::Variable > _5519);
static  monty::rc_ptr< ::mosek::fusion::Expression > outer(monty::rc_ptr< ::mosek::fusion::Variable > _5525,monty::rc_ptr< ::mosek::fusion::Matrix > _5526);
static  monty::rc_ptr< ::mosek::fusion::Expression > outer(std::shared_ptr< monty::ndarray< double,1 > > _5532,monty::rc_ptr< ::mosek::fusion::Variable > _5533);
static  monty::rc_ptr< ::mosek::fusion::Expression > outer(monty::rc_ptr< ::mosek::fusion::Variable > _5534,std::shared_ptr< monty::ndarray< double,1 > > _5535);
static  monty::rc_ptr< ::mosek::fusion::Expression > outer_(int _5536,std::shared_ptr< monty::ndarray< long long,1 > > _5537,std::shared_ptr< monty::ndarray< long long,1 > > _5538,std::shared_ptr< monty::ndarray< double,1 > > _5539,std::shared_ptr< monty::ndarray< double,1 > > _5540,std::shared_ptr< monty::ndarray< long long,1 > > _5541,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _5542,std::shared_ptr< monty::ndarray< double,1 > > _5543,std::shared_ptr< monty::ndarray< int,1 > > _5544,int _5545,bool _5546);
static  monty::rc_ptr< ::mosek::fusion::Expression > outer_(monty::rc_ptr< ::mosek::fusion::Variable > _5576,int _5577,std::shared_ptr< monty::ndarray< double,1 > > _5578,std::shared_ptr< monty::ndarray< int,1 > > _5579,int _5580,bool _5581);
virtual monty::rc_ptr< ::mosek::fusion::Expression > pick(std::shared_ptr< monty::ndarray< int,2 > > _5598);
virtual monty::rc_ptr< ::mosek::fusion::Expression > pick(std::shared_ptr< monty::ndarray< int,1 > > _5604);
virtual monty::rc_ptr< ::mosek::fusion::Expression > pick_(std::shared_ptr< monty::ndarray< long long,1 > > _5607);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > >,1 > > _5645);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(double _5651,double _5652,double _5653);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(double _5654,double _5655,monty::rc_ptr< ::mosek::fusion::Variable > _5656);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(double _5657,double _5658,monty::rc_ptr< ::mosek::fusion::Expression > _5659);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(double _5660,monty::rc_ptr< ::mosek::fusion::Variable > _5661,double _5662);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(double _5663,monty::rc_ptr< ::mosek::fusion::Variable > _5664,monty::rc_ptr< ::mosek::fusion::Variable > _5665);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(double _5666,monty::rc_ptr< ::mosek::fusion::Variable > _5667,monty::rc_ptr< ::mosek::fusion::Expression > _5668);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(double _5669,monty::rc_ptr< ::mosek::fusion::Expression > _5670,double _5671);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(double _5672,monty::rc_ptr< ::mosek::fusion::Expression > _5673,monty::rc_ptr< ::mosek::fusion::Variable > _5674);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(double _5675,monty::rc_ptr< ::mosek::fusion::Expression > _5676,monty::rc_ptr< ::mosek::fusion::Expression > _5677);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Variable > _5678,double _5679,double _5680);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Variable > _5681,double _5682,monty::rc_ptr< ::mosek::fusion::Variable > _5683);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Variable > _5684,double _5685,monty::rc_ptr< ::mosek::fusion::Expression > _5686);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Variable > _5687,monty::rc_ptr< ::mosek::fusion::Variable > _5688,double _5689);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Variable > _5690,monty::rc_ptr< ::mosek::fusion::Variable > _5691,monty::rc_ptr< ::mosek::fusion::Variable > _5692);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Variable > _5693,monty::rc_ptr< ::mosek::fusion::Variable > _5694,monty::rc_ptr< ::mosek::fusion::Expression > _5695);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Variable > _5696,monty::rc_ptr< ::mosek::fusion::Expression > _5697,double _5698);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Variable > _5699,monty::rc_ptr< ::mosek::fusion::Expression > _5700,monty::rc_ptr< ::mosek::fusion::Variable > _5701);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Variable > _5702,monty::rc_ptr< ::mosek::fusion::Expression > _5703,monty::rc_ptr< ::mosek::fusion::Expression > _5704);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _5705,double _5706,double _5707);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _5708,double _5709,monty::rc_ptr< ::mosek::fusion::Variable > _5710);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _5711,double _5712,monty::rc_ptr< ::mosek::fusion::Expression > _5713);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _5714,monty::rc_ptr< ::mosek::fusion::Variable > _5715,double _5716);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _5717,monty::rc_ptr< ::mosek::fusion::Variable > _5718,monty::rc_ptr< ::mosek::fusion::Variable > _5719);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _5720,monty::rc_ptr< ::mosek::fusion::Variable > _5721,monty::rc_ptr< ::mosek::fusion::Expression > _5722);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _5723,monty::rc_ptr< ::mosek::fusion::Expression > _5724,double _5725);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _5726,monty::rc_ptr< ::mosek::fusion::Expression > _5727,monty::rc_ptr< ::mosek::fusion::Variable > _5728);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _5729,monty::rc_ptr< ::mosek::fusion::Expression > _5730,monty::rc_ptr< ::mosek::fusion::Expression > _5731);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(double _5732,monty::rc_ptr< ::mosek::fusion::Variable > _5733);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(double _5734,monty::rc_ptr< ::mosek::fusion::Expression > _5735);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Variable > _5736,double _5737);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Variable > _5738,monty::rc_ptr< ::mosek::fusion::Variable > _5739);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Variable > _5740,monty::rc_ptr< ::mosek::fusion::Expression > _5741);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _5742,double _5743);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _5744,monty::rc_ptr< ::mosek::fusion::Variable > _5745);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _5746,monty::rc_ptr< ::mosek::fusion::Expression > _5747);
static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _5748);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _5750,monty::rc_ptr< ::mosek::fusion::Expression > _5751,monty::rc_ptr< ::mosek::fusion::Expression > _5752);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _5753,monty::rc_ptr< ::mosek::fusion::Expression > _5754,monty::rc_ptr< ::mosek::fusion::Variable > _5755);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _5756,monty::rc_ptr< ::mosek::fusion::Expression > _5757,double _5758);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _5759,monty::rc_ptr< ::mosek::fusion::Variable > _5760,monty::rc_ptr< ::mosek::fusion::Expression > _5761);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _5762,monty::rc_ptr< ::mosek::fusion::Variable > _5763,monty::rc_ptr< ::mosek::fusion::Variable > _5764);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _5765,monty::rc_ptr< ::mosek::fusion::Variable > _5766,double _5767);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _5768,double _5769,monty::rc_ptr< ::mosek::fusion::Expression > _5770);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _5771,double _5772,monty::rc_ptr< ::mosek::fusion::Variable > _5773);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _5774,double _5775,double _5776);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Variable > _5777,monty::rc_ptr< ::mosek::fusion::Expression > _5778,monty::rc_ptr< ::mosek::fusion::Expression > _5779);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Variable > _5780,monty::rc_ptr< ::mosek::fusion::Expression > _5781,monty::rc_ptr< ::mosek::fusion::Variable > _5782);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Variable > _5783,monty::rc_ptr< ::mosek::fusion::Expression > _5784,double _5785);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Variable > _5786,monty::rc_ptr< ::mosek::fusion::Variable > _5787,monty::rc_ptr< ::mosek::fusion::Expression > _5788);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Variable > _5789,monty::rc_ptr< ::mosek::fusion::Variable > _5790,monty::rc_ptr< ::mosek::fusion::Variable > _5791);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Variable > _5792,monty::rc_ptr< ::mosek::fusion::Variable > _5793,double _5794);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Variable > _5795,double _5796,monty::rc_ptr< ::mosek::fusion::Expression > _5797);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Variable > _5798,double _5799,monty::rc_ptr< ::mosek::fusion::Variable > _5800);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Variable > _5801,double _5802,double _5803);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(double _5804,monty::rc_ptr< ::mosek::fusion::Expression > _5805,monty::rc_ptr< ::mosek::fusion::Expression > _5806);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(double _5807,monty::rc_ptr< ::mosek::fusion::Expression > _5808,monty::rc_ptr< ::mosek::fusion::Variable > _5809);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(double _5810,monty::rc_ptr< ::mosek::fusion::Expression > _5811,double _5812);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(double _5813,monty::rc_ptr< ::mosek::fusion::Variable > _5814,monty::rc_ptr< ::mosek::fusion::Expression > _5815);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(double _5816,monty::rc_ptr< ::mosek::fusion::Variable > _5817,monty::rc_ptr< ::mosek::fusion::Variable > _5818);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(double _5819,monty::rc_ptr< ::mosek::fusion::Variable > _5820,double _5821);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(double _5822,double _5823,monty::rc_ptr< ::mosek::fusion::Expression > _5824);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(double _5825,double _5826,monty::rc_ptr< ::mosek::fusion::Variable > _5827);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Variable > _5828,monty::rc_ptr< ::mosek::fusion::Expression > _5829);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Variable > _5830,monty::rc_ptr< ::mosek::fusion::Variable > _5831);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Variable > _5832,double _5833);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(double _5834,monty::rc_ptr< ::mosek::fusion::Expression > _5835);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(double _5836,monty::rc_ptr< ::mosek::fusion::Variable > _5837);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _5838,monty::rc_ptr< ::mosek::fusion::Variable > _5839);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _5840,double _5841);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _5842,monty::rc_ptr< ::mosek::fusion::Expression > _5843);
static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _5844);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5846,monty::rc_ptr< ::mosek::fusion::Expression > _5847,monty::rc_ptr< ::mosek::fusion::Expression > _5848,monty::rc_ptr< ::mosek::fusion::Expression > _5849);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5850,monty::rc_ptr< ::mosek::fusion::Expression > _5851,monty::rc_ptr< ::mosek::fusion::Expression > _5852,monty::rc_ptr< ::mosek::fusion::Variable > _5853);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5854,monty::rc_ptr< ::mosek::fusion::Expression > _5855,monty::rc_ptr< ::mosek::fusion::Expression > _5856,double _5857);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5858,monty::rc_ptr< ::mosek::fusion::Expression > _5859,monty::rc_ptr< ::mosek::fusion::Variable > _5860,monty::rc_ptr< ::mosek::fusion::Expression > _5861);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5862,monty::rc_ptr< ::mosek::fusion::Expression > _5863,monty::rc_ptr< ::mosek::fusion::Variable > _5864,monty::rc_ptr< ::mosek::fusion::Variable > _5865);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5866,monty::rc_ptr< ::mosek::fusion::Expression > _5867,monty::rc_ptr< ::mosek::fusion::Variable > _5868,double _5869);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5870,monty::rc_ptr< ::mosek::fusion::Expression > _5871,double _5872,monty::rc_ptr< ::mosek::fusion::Expression > _5873);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5874,monty::rc_ptr< ::mosek::fusion::Expression > _5875,double _5876,monty::rc_ptr< ::mosek::fusion::Variable > _5877);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5878,monty::rc_ptr< ::mosek::fusion::Expression > _5879,double _5880,double _5881);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5882,monty::rc_ptr< ::mosek::fusion::Variable > _5883,monty::rc_ptr< ::mosek::fusion::Expression > _5884,monty::rc_ptr< ::mosek::fusion::Expression > _5885);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5886,monty::rc_ptr< ::mosek::fusion::Variable > _5887,monty::rc_ptr< ::mosek::fusion::Expression > _5888,monty::rc_ptr< ::mosek::fusion::Variable > _5889);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5890,monty::rc_ptr< ::mosek::fusion::Variable > _5891,monty::rc_ptr< ::mosek::fusion::Expression > _5892,double _5893);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5894,monty::rc_ptr< ::mosek::fusion::Variable > _5895,monty::rc_ptr< ::mosek::fusion::Variable > _5896,monty::rc_ptr< ::mosek::fusion::Expression > _5897);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5898,monty::rc_ptr< ::mosek::fusion::Variable > _5899,monty::rc_ptr< ::mosek::fusion::Variable > _5900,monty::rc_ptr< ::mosek::fusion::Variable > _5901);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5902,monty::rc_ptr< ::mosek::fusion::Variable > _5903,monty::rc_ptr< ::mosek::fusion::Variable > _5904,double _5905);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5906,monty::rc_ptr< ::mosek::fusion::Variable > _5907,double _5908,monty::rc_ptr< ::mosek::fusion::Expression > _5909);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5910,monty::rc_ptr< ::mosek::fusion::Variable > _5911,double _5912,monty::rc_ptr< ::mosek::fusion::Variable > _5913);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5914,monty::rc_ptr< ::mosek::fusion::Variable > _5915,double _5916,double _5917);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5918,double _5919,monty::rc_ptr< ::mosek::fusion::Expression > _5920,monty::rc_ptr< ::mosek::fusion::Expression > _5921);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5922,double _5923,monty::rc_ptr< ::mosek::fusion::Expression > _5924,monty::rc_ptr< ::mosek::fusion::Variable > _5925);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5926,double _5927,monty::rc_ptr< ::mosek::fusion::Expression > _5928,double _5929);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5930,double _5931,monty::rc_ptr< ::mosek::fusion::Variable > _5932,monty::rc_ptr< ::mosek::fusion::Expression > _5933);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5934,double _5935,monty::rc_ptr< ::mosek::fusion::Variable > _5936,monty::rc_ptr< ::mosek::fusion::Variable > _5937);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5938,double _5939,monty::rc_ptr< ::mosek::fusion::Variable > _5940,double _5941);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5942,double _5943,double _5944,monty::rc_ptr< ::mosek::fusion::Expression > _5945);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5946,double _5947,double _5948,monty::rc_ptr< ::mosek::fusion::Variable > _5949);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5950,monty::rc_ptr< ::mosek::fusion::Variable > _5951,monty::rc_ptr< ::mosek::fusion::Expression > _5952);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5953,monty::rc_ptr< ::mosek::fusion::Variable > _5954,monty::rc_ptr< ::mosek::fusion::Variable > _5955);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5956,monty::rc_ptr< ::mosek::fusion::Variable > _5957,double _5958);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5959,double _5960,monty::rc_ptr< ::mosek::fusion::Expression > _5961);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5962,double _5963,monty::rc_ptr< ::mosek::fusion::Variable > _5964);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5965,monty::rc_ptr< ::mosek::fusion::Expression > _5966,monty::rc_ptr< ::mosek::fusion::Variable > _5967);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5968,monty::rc_ptr< ::mosek::fusion::Expression > _5969,double _5970);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5971,monty::rc_ptr< ::mosek::fusion::Expression > _5972,monty::rc_ptr< ::mosek::fusion::Expression > _5973);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int _5974,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _5975);
static  monty::rc_ptr< ::mosek::fusion::Expression > stack_(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _5976,int _5977);
static  monty::rc_ptr< ::mosek::fusion::Expression > repeat(monty::rc_ptr< ::mosek::fusion::Expression > _6065,int _6066,int _6067);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _6069);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _6139);
static  monty::rc_ptr< ::mosek::fusion::Expression > add_(monty::rc_ptr< ::mosek::fusion::Expression > _6152,double _6153,monty::rc_ptr< ::mosek::fusion::Expression > _6154,double _6155);
virtual monty::rc_ptr< ::mosek::fusion::Expression > transpose();
virtual monty::rc_ptr< ::mosek::fusion::Expression > slice(std::shared_ptr< monty::ndarray< int,1 > > _6255,std::shared_ptr< monty::ndarray< int,1 > > _6256);
virtual monty::rc_ptr< ::mosek::fusion::Expression > index(std::shared_ptr< monty::ndarray< int,1 > > _6297);
virtual monty::rc_ptr< ::mosek::fusion::Expression > index(int _6300);
virtual monty::rc_ptr< ::mosek::fusion::Expression > slice(int _6301,int _6302);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Matrix > _6303,monty::rc_ptr< ::mosek::fusion::Expression > _6304);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Matrix > _6305,monty::rc_ptr< ::mosek::fusion::Variable > _6306);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _6307,monty::rc_ptr< ::mosek::fusion::Variable > _6308);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _6309,monty::rc_ptr< ::mosek::fusion::Expression > _6310);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(std::shared_ptr< monty::ndarray< double,2 > > _6311,monty::rc_ptr< ::mosek::fusion::Variable > _6312);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(std::shared_ptr< monty::ndarray< double,2 > > _6313,monty::rc_ptr< ::mosek::fusion::Expression > _6314);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(std::shared_ptr< monty::ndarray< double,1 > > _6315,monty::rc_ptr< ::mosek::fusion::Variable > _6316);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(std::shared_ptr< monty::ndarray< double,1 > > _6317,monty::rc_ptr< ::mosek::fusion::Expression > _6318);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Expression > _6319,monty::rc_ptr< ::mosek::fusion::Matrix > _6320);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Expression > _6321,std::shared_ptr< monty::ndarray< double,2 > > _6322);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Expression > _6323,std::shared_ptr< monty::ndarray< double,1 > > _6324);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Expression > _6325,monty::rc_ptr< ::mosek::fusion::NDSparseArray > _6326);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Variable > _6327,monty::rc_ptr< ::mosek::fusion::Matrix > _6328);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Variable > _6329,monty::rc_ptr< ::mosek::fusion::NDSparseArray > _6330);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Variable > _6331,std::shared_ptr< monty::ndarray< double,2 > > _6332);
static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Variable > _6333,std::shared_ptr< monty::ndarray< double,1 > > _6334);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Matrix > _6335,monty::rc_ptr< ::mosek::fusion::Expression > _6336);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Matrix > _6337,monty::rc_ptr< ::mosek::fusion::Variable > _6338);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _6339,monty::rc_ptr< ::mosek::fusion::Variable > _6340);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _6341,monty::rc_ptr< ::mosek::fusion::Expression > _6342);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot(std::shared_ptr< monty::ndarray< double,2 > > _6343,monty::rc_ptr< ::mosek::fusion::Variable > _6344);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot(std::shared_ptr< monty::ndarray< double,2 > > _6345,monty::rc_ptr< ::mosek::fusion::Expression > _6346);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot(std::shared_ptr< monty::ndarray< double,1 > > _6347,monty::rc_ptr< ::mosek::fusion::Variable > _6348);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot(std::shared_ptr< monty::ndarray< double,1 > > _6349,monty::rc_ptr< ::mosek::fusion::Expression > _6350);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Expression > _6351,monty::rc_ptr< ::mosek::fusion::Matrix > _6352);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Expression > _6353,std::shared_ptr< monty::ndarray< double,2 > > _6354);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Expression > _6355,std::shared_ptr< monty::ndarray< double,1 > > _6356);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Expression > _6357,monty::rc_ptr< ::mosek::fusion::NDSparseArray > _6358);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Variable > _6359,monty::rc_ptr< ::mosek::fusion::NDSparseArray > _6360);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Variable > _6361,monty::rc_ptr< ::mosek::fusion::Matrix > _6362);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Variable > _6363,std::shared_ptr< monty::ndarray< double,2 > > _6364);
static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Variable > _6365,std::shared_ptr< monty::ndarray< double,1 > > _6366);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _6367,monty::rc_ptr< ::mosek::fusion::Variable > _6368);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Variable > _6369,monty::rc_ptr< ::mosek::fusion::NDSparseArray > _6370);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Matrix > _6371,monty::rc_ptr< ::mosek::fusion::Variable > _6372);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Variable > _6373,monty::rc_ptr< ::mosek::fusion::Matrix > _6374);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(double _6375,monty::rc_ptr< ::mosek::fusion::Variable > _6376);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Variable > _6377,double _6378);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(std::shared_ptr< monty::ndarray< double,2 > > _6379,monty::rc_ptr< ::mosek::fusion::Variable > _6380);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(std::shared_ptr< monty::ndarray< double,1 > > _6381,monty::rc_ptr< ::mosek::fusion::Variable > _6382);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Variable > _6383,std::shared_ptr< monty::ndarray< double,2 > > _6384);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Variable > _6385,std::shared_ptr< monty::ndarray< double,1 > > _6386);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Variable > _6387,monty::rc_ptr< ::mosek::fusion::Variable > _6388);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _6389,monty::rc_ptr< ::mosek::fusion::Expression > _6390);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Expression > _6391,monty::rc_ptr< ::mosek::fusion::NDSparseArray > _6392);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Matrix > _6393,monty::rc_ptr< ::mosek::fusion::Expression > _6394);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Expression > _6395,monty::rc_ptr< ::mosek::fusion::Matrix > _6396);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(double _6397,monty::rc_ptr< ::mosek::fusion::Expression > _6398);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Expression > _6399,double _6400);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(std::shared_ptr< monty::ndarray< double,2 > > _6401,monty::rc_ptr< ::mosek::fusion::Expression > _6402);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(std::shared_ptr< monty::ndarray< double,1 > > _6403,monty::rc_ptr< ::mosek::fusion::Expression > _6404);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Expression > _6405,std::shared_ptr< monty::ndarray< double,2 > > _6406);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Expression > _6407,std::shared_ptr< monty::ndarray< double,1 > > _6408);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Variable > _6409,monty::rc_ptr< ::mosek::fusion::Expression > _6410);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Expression > _6411,monty::rc_ptr< ::mosek::fusion::Variable > _6412);
static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Expression > _6413,monty::rc_ptr< ::mosek::fusion::Expression > _6414);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _6415,monty::rc_ptr< ::mosek::fusion::Variable > _6416);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Variable > _6417,monty::rc_ptr< ::mosek::fusion::NDSparseArray > _6418);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Matrix > _6419,monty::rc_ptr< ::mosek::fusion::Variable > _6420);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Variable > _6421,monty::rc_ptr< ::mosek::fusion::Matrix > _6422);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(double _6423,monty::rc_ptr< ::mosek::fusion::Variable > _6424);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Variable > _6425,double _6426);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(std::shared_ptr< monty::ndarray< double,2 > > _6427,monty::rc_ptr< ::mosek::fusion::Variable > _6428);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(std::shared_ptr< monty::ndarray< double,1 > > _6429,monty::rc_ptr< ::mosek::fusion::Variable > _6430);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Variable > _6431,std::shared_ptr< monty::ndarray< double,2 > > _6432);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Variable > _6433,std::shared_ptr< monty::ndarray< double,1 > > _6434);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Variable > _6435,monty::rc_ptr< ::mosek::fusion::Variable > _6436);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _6437,monty::rc_ptr< ::mosek::fusion::Expression > _6438);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Expression > _6439,monty::rc_ptr< ::mosek::fusion::NDSparseArray > _6440);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Matrix > _6441,monty::rc_ptr< ::mosek::fusion::Expression > _6442);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Expression > _6443,monty::rc_ptr< ::mosek::fusion::Matrix > _6444);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(double _6445,monty::rc_ptr< ::mosek::fusion::Expression > _6446);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Expression > _6447,double _6448);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(std::shared_ptr< monty::ndarray< double,2 > > _6449,monty::rc_ptr< ::mosek::fusion::Expression > _6450);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(std::shared_ptr< monty::ndarray< double,1 > > _6451,monty::rc_ptr< ::mosek::fusion::Expression > _6452);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Expression > _6453,std::shared_ptr< monty::ndarray< double,2 > > _6454);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Expression > _6455,std::shared_ptr< monty::ndarray< double,1 > > _6456);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Variable > _6457,monty::rc_ptr< ::mosek::fusion::Expression > _6458);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Expression > _6459,monty::rc_ptr< ::mosek::fusion::Variable > _6460);
static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Expression > _6461,monty::rc_ptr< ::mosek::fusion::Expression > _6462);
virtual monty::rc_ptr< ::mosek::fusion::Set > shape();
virtual monty::rc_ptr< ::mosek::fusion::Set > getShape();
virtual monty::rc_ptr< ::mosek::fusion::Model > getModel();
static  void validateData(std::shared_ptr< monty::ndarray< long long,1 > > _6463,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _6464,std::shared_ptr< monty::ndarray< long long,1 > > _6465,std::shared_ptr< monty::ndarray< double,1 > > _6466,std::shared_ptr< monty::ndarray< double,1 > > _6467,monty::rc_ptr< ::mosek::fusion::Set > _6468,std::shared_ptr< monty::ndarray< long long,1 > > _6469);
static  monty::rc_ptr< ::mosek::fusion::Model > extractModel(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _6484);
}; // struct Expr;

struct p_FlatExpr
{
FlatExpr * _pubthis;
static mosek::fusion::p_FlatExpr* _get_impl(mosek::fusion::FlatExpr * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_FlatExpr * _get_impl(mosek::fusion::FlatExpr::t _inst) { return _get_impl(_inst.get()); }
p_FlatExpr(FlatExpr * _pubthis);
virtual ~p_FlatExpr() { /* std::cout << "~p_FlatExpr" << std::endl;*/ };
std::shared_ptr< monty::ndarray< long long,1 > > inst{};monty::rc_ptr< ::mosek::fusion::Set > shape{};long long nnz{};std::shared_ptr< monty::ndarray< double,1 > > cof{};std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > x{};std::shared_ptr< monty::ndarray< long long,1 > > subj{};std::shared_ptr< monty::ndarray< long long,1 > > ptrb{};std::shared_ptr< monty::ndarray< double,1 > > bfix{};virtual void destroy();
static FlatExpr::t _new_FlatExpr(monty::rc_ptr< ::mosek::fusion::FlatExpr > _6485);
void _initialize(monty::rc_ptr< ::mosek::fusion::FlatExpr > _6485);
static FlatExpr::t _new_FlatExpr(std::shared_ptr< monty::ndarray< double,1 > > _6486,std::shared_ptr< monty::ndarray< long long,1 > > _6487,std::shared_ptr< monty::ndarray< long long,1 > > _6488,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _6489,std::shared_ptr< monty::ndarray< double,1 > > _6490,monty::rc_ptr< ::mosek::fusion::Set > _6491,std::shared_ptr< monty::ndarray< long long,1 > > _6492);
void _initialize(std::shared_ptr< monty::ndarray< double,1 > > _6486,std::shared_ptr< monty::ndarray< long long,1 > > _6487,std::shared_ptr< monty::ndarray< long long,1 > > _6488,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _6489,std::shared_ptr< monty::ndarray< double,1 > > _6490,monty::rc_ptr< ::mosek::fusion::Set > _6491,std::shared_ptr< monty::ndarray< long long,1 > > _6492);
virtual std::string toString();
virtual int size();
}; // struct FlatExpr;

struct p_SymmetricMatrix
{
SymmetricMatrix * _pubthis;
static mosek::fusion::p_SymmetricMatrix* _get_impl(mosek::fusion::SymmetricMatrix * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_SymmetricMatrix * _get_impl(mosek::fusion::SymmetricMatrix::t _inst) { return _get_impl(_inst.get()); }
p_SymmetricMatrix(SymmetricMatrix * _pubthis);
virtual ~p_SymmetricMatrix() { /* std::cout << "~p_SymmetricMatrix" << std::endl;*/ };
int nnz{};double scale{};std::shared_ptr< monty::ndarray< double,1 > > vval{};std::shared_ptr< monty::ndarray< int,1 > > vsubj{};std::shared_ptr< monty::ndarray< int,1 > > vsubi{};std::shared_ptr< monty::ndarray< double,1 > > uval{};std::shared_ptr< monty::ndarray< int,1 > > usubj{};std::shared_ptr< monty::ndarray< int,1 > > usubi{};int d1{};int d0{};virtual void destroy();
static SymmetricMatrix::t _new_SymmetricMatrix(int _6494,int _6495,std::shared_ptr< monty::ndarray< int,1 > > _6496,std::shared_ptr< monty::ndarray< int,1 > > _6497,std::shared_ptr< monty::ndarray< double,1 > > _6498,std::shared_ptr< monty::ndarray< int,1 > > _6499,std::shared_ptr< monty::ndarray< int,1 > > _6500,std::shared_ptr< monty::ndarray< double,1 > > _6501,double _6502);
void _initialize(int _6494,int _6495,std::shared_ptr< monty::ndarray< int,1 > > _6496,std::shared_ptr< monty::ndarray< int,1 > > _6497,std::shared_ptr< monty::ndarray< double,1 > > _6498,std::shared_ptr< monty::ndarray< int,1 > > _6499,std::shared_ptr< monty::ndarray< int,1 > > _6500,std::shared_ptr< monty::ndarray< double,1 > > _6501,double _6502);
static  monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > rankOne(int _6503,std::shared_ptr< monty::ndarray< int,1 > > _6504,std::shared_ptr< monty::ndarray< double,1 > > _6505);
static  monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > rankOne(std::shared_ptr< monty::ndarray< double,1 > > _6513);
static  monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > antiDiag(std::shared_ptr< monty::ndarray< double,1 > > _6521);
static  monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > diag(std::shared_ptr< monty::ndarray< double,1 > > _6528);
virtual monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > add(monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > _6534);
virtual monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > sub(monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > _6554);
virtual monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > mul(double _6555);
virtual int getdim();
}; // struct SymmetricMatrix;

struct p_NDSparseArray
{
NDSparseArray * _pubthis;
static mosek::fusion::p_NDSparseArray* _get_impl(mosek::fusion::NDSparseArray * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_NDSparseArray * _get_impl(mosek::fusion::NDSparseArray::t _inst) { return _get_impl(_inst.get()); }
p_NDSparseArray(NDSparseArray * _pubthis);
virtual ~p_NDSparseArray() { /* std::cout << "~p_NDSparseArray" << std::endl;*/ };
std::shared_ptr< monty::ndarray< double,1 > > cof{};std::shared_ptr< monty::ndarray< long long,1 > > inst{};std::shared_ptr< monty::ndarray< int,1 > > dims{};long long size{};virtual void destroy();
static NDSparseArray::t _new_NDSparseArray(std::shared_ptr< monty::ndarray< int,1 > > _6556,std::shared_ptr< monty::ndarray< int,2 > > _6557,std::shared_ptr< monty::ndarray< double,1 > > _6558);
void _initialize(std::shared_ptr< monty::ndarray< int,1 > > _6556,std::shared_ptr< monty::ndarray< int,2 > > _6557,std::shared_ptr< monty::ndarray< double,1 > > _6558);
static NDSparseArray::t _new_NDSparseArray(std::shared_ptr< monty::ndarray< int,1 > > _6578,std::shared_ptr< monty::ndarray< long long,1 > > _6579,std::shared_ptr< monty::ndarray< double,1 > > _6580);
void _initialize(std::shared_ptr< monty::ndarray< int,1 > > _6578,std::shared_ptr< monty::ndarray< long long,1 > > _6579,std::shared_ptr< monty::ndarray< double,1 > > _6580);
static NDSparseArray::t _new_NDSparseArray(monty::rc_ptr< ::mosek::fusion::Matrix > _6594);
void _initialize(monty::rc_ptr< ::mosek::fusion::Matrix > _6594);
static  monty::rc_ptr< ::mosek::fusion::NDSparseArray > make(monty::rc_ptr< ::mosek::fusion::Matrix > _6602);
static  monty::rc_ptr< ::mosek::fusion::NDSparseArray > make(std::shared_ptr< monty::ndarray< int,1 > > _6603,std::shared_ptr< monty::ndarray< long long,1 > > _6604,std::shared_ptr< monty::ndarray< double,1 > > _6605);
static  monty::rc_ptr< ::mosek::fusion::NDSparseArray > make(std::shared_ptr< monty::ndarray< int,1 > > _6606,std::shared_ptr< monty::ndarray< int,2 > > _6607,std::shared_ptr< monty::ndarray< double,1 > > _6608);
}; // struct NDSparseArray;

struct p_Matrix
{
Matrix * _pubthis;
static mosek::fusion::p_Matrix* _get_impl(mosek::fusion::Matrix * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_Matrix * _get_impl(mosek::fusion::Matrix::t _inst) { return _get_impl(_inst.get()); }
p_Matrix(Matrix * _pubthis);
virtual ~p_Matrix() { /* std::cout << "~p_Matrix" << std::endl;*/ };
int dimj{};int dimi{};virtual void destroy();
static Matrix::t _new_Matrix(int _6677,int _6678);
void _initialize(int _6677,int _6678);
virtual std::string toString();
virtual void switchDims();
static  monty::rc_ptr< ::mosek::fusion::Matrix > diag(int _6680,monty::rc_ptr< ::mosek::fusion::Matrix > _6681);
static  monty::rc_ptr< ::mosek::fusion::Matrix > diag(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Matrix >,1 > > _6683);
static  monty::rc_ptr< ::mosek::fusion::Matrix > antidiag(int _6701,double _6702,int _6703);
static  monty::rc_ptr< ::mosek::fusion::Matrix > antidiag(int _6704,double _6705);
static  monty::rc_ptr< ::mosek::fusion::Matrix > diag(int _6706,double _6707,int _6708);
static  monty::rc_ptr< ::mosek::fusion::Matrix > diag(int _6709,double _6710);
static  monty::rc_ptr< ::mosek::fusion::Matrix > antidiag(std::shared_ptr< monty::ndarray< double,1 > > _6711,int _6712);
static  monty::rc_ptr< ::mosek::fusion::Matrix > antidiag(std::shared_ptr< monty::ndarray< double,1 > > _6722);
static  monty::rc_ptr< ::mosek::fusion::Matrix > diag(std::shared_ptr< monty::ndarray< double,1 > > _6723,int _6724);
static  monty::rc_ptr< ::mosek::fusion::Matrix > diag(std::shared_ptr< monty::ndarray< double,1 > > _6732);
static  monty::rc_ptr< ::mosek::fusion::Matrix > ones(int _6733,int _6734);
static  monty::rc_ptr< ::mosek::fusion::Matrix > eye(int _6735);
static  monty::rc_ptr< ::mosek::fusion::Matrix > dense(monty::rc_ptr< ::mosek::fusion::Matrix > _6737);
static  monty::rc_ptr< ::mosek::fusion::Matrix > dense(int _6738,int _6739,double _6740);
static  monty::rc_ptr< ::mosek::fusion::Matrix > dense(int _6741,int _6742,std::shared_ptr< monty::ndarray< double,1 > > _6743);
static  monty::rc_ptr< ::mosek::fusion::Matrix > dense(std::shared_ptr< monty::ndarray< double,2 > > _6744);
static  monty::rc_ptr< ::mosek::fusion::Matrix > sparse(monty::rc_ptr< ::mosek::fusion::Matrix > _6745);
static  monty::rc_ptr< ::mosek::fusion::Matrix > sparse(std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Matrix >,1 > >,1 > > _6749);
static  monty::rc_ptr< ::mosek::fusion::Matrix > sparse(std::shared_ptr< monty::ndarray< double,2 > > _6780);
static  monty::rc_ptr< ::mosek::fusion::Matrix > sparse(int _6793,int _6794);
static  monty::rc_ptr< ::mosek::fusion::Matrix > sparse(int _6795,int _6796,std::shared_ptr< monty::ndarray< int,1 > > _6797,std::shared_ptr< monty::ndarray< int,1 > > _6798,double _6799);
static  monty::rc_ptr< ::mosek::fusion::Matrix > sparse(std::shared_ptr< monty::ndarray< int,1 > > _6801,std::shared_ptr< monty::ndarray< int,1 > > _6802,double _6803);
static  monty::rc_ptr< ::mosek::fusion::Matrix > sparse(std::shared_ptr< monty::ndarray< int,1 > > _6808,std::shared_ptr< monty::ndarray< int,1 > > _6809,std::shared_ptr< monty::ndarray< double,1 > > _6810);
static  monty::rc_ptr< ::mosek::fusion::Matrix > sparse(int _6815,int _6816,std::shared_ptr< monty::ndarray< int,1 > > _6817,std::shared_ptr< monty::ndarray< int,1 > > _6818,std::shared_ptr< monty::ndarray< double,1 > > _6819);
virtual double get(int _6824,int _6825) { throw monty::AbstractClassError("Call to abstract method"); }
virtual bool isSparse() { throw monty::AbstractClassError("Call to abstract method"); }
virtual std::shared_ptr< monty::ndarray< double,1 > > getDataAsArray() { throw monty::AbstractClassError("Call to abstract method"); }
virtual void getDataAsTriplets(std::shared_ptr< monty::ndarray< int,1 > > _6826,std::shared_ptr< monty::ndarray< int,1 > > _6827,std::shared_ptr< monty::ndarray< double,1 > > _6828) { throw monty::AbstractClassError("Call to abstract method"); }
virtual monty::rc_ptr< ::mosek::fusion::Matrix > transpose() { throw monty::AbstractClassError("Call to abstract method"); }
virtual long long numNonzeros() { throw monty::AbstractClassError("Call to abstract method"); }
virtual int numColumns();
virtual int numRows();
}; // struct Matrix;

struct p_DenseMatrix : public ::mosek::fusion::p_Matrix
{
DenseMatrix * _pubthis;
static mosek::fusion::p_DenseMatrix* _get_impl(mosek::fusion::DenseMatrix * _inst){ return static_cast< mosek::fusion::p_DenseMatrix* >(mosek::fusion::p_Matrix::_get_impl(_inst)); }
static mosek::fusion::p_DenseMatrix * _get_impl(mosek::fusion::DenseMatrix::t _inst) { return _get_impl(_inst.get()); }
p_DenseMatrix(DenseMatrix * _pubthis);
virtual ~p_DenseMatrix() { /* std::cout << "~p_DenseMatrix" << std::endl;*/ };
long long nnz{};std::shared_ptr< monty::ndarray< double,1 > > data{};virtual void destroy();
static DenseMatrix::t _new_DenseMatrix(int _6609,int _6610,std::shared_ptr< monty::ndarray< double,1 > > _6611);
void _initialize(int _6609,int _6610,std::shared_ptr< monty::ndarray< double,1 > > _6611);
static DenseMatrix::t _new_DenseMatrix(monty::rc_ptr< ::mosek::fusion::Matrix > _6612);
void _initialize(monty::rc_ptr< ::mosek::fusion::Matrix > _6612);
static DenseMatrix::t _new_DenseMatrix(std::shared_ptr< monty::ndarray< double,2 > > _6617);
void _initialize(std::shared_ptr< monty::ndarray< double,2 > > _6617);
static DenseMatrix::t _new_DenseMatrix(int _6620,int _6621,double _6622);
void _initialize(int _6620,int _6621,double _6622);
virtual std::string toString();
virtual monty::rc_ptr< ::mosek::fusion::Matrix > transpose();
virtual bool isSparse();
virtual std::shared_ptr< monty::ndarray< double,1 > > getDataAsArray();
virtual void getDataAsTriplets(std::shared_ptr< monty::ndarray< int,1 > > _6635,std::shared_ptr< monty::ndarray< int,1 > > _6636,std::shared_ptr< monty::ndarray< double,1 > > _6637);
virtual double get(int _6641,int _6642);
virtual long long numNonzeros();
}; // struct DenseMatrix;

struct p_SparseMatrix : public ::mosek::fusion::p_Matrix
{
SparseMatrix * _pubthis;
static mosek::fusion::p_SparseMatrix* _get_impl(mosek::fusion::SparseMatrix * _inst){ return static_cast< mosek::fusion::p_SparseMatrix* >(mosek::fusion::p_Matrix::_get_impl(_inst)); }
static mosek::fusion::p_SparseMatrix * _get_impl(mosek::fusion::SparseMatrix::t _inst) { return _get_impl(_inst.get()); }
p_SparseMatrix(SparseMatrix * _pubthis);
virtual ~p_SparseMatrix() { /* std::cout << "~p_SparseMatrix" << std::endl;*/ };
long long nnz{};std::shared_ptr< monty::ndarray< double,1 > > val{};std::shared_ptr< monty::ndarray< int,1 > > subj{};std::shared_ptr< monty::ndarray< int,1 > > subi{};virtual void destroy();
static SparseMatrix::t _new_SparseMatrix(int _6643,int _6644,std::shared_ptr< monty::ndarray< int,1 > > _6645,std::shared_ptr< monty::ndarray< int,1 > > _6646,std::shared_ptr< monty::ndarray< double,1 > > _6647,long long _6648);
void _initialize(int _6643,int _6644,std::shared_ptr< monty::ndarray< int,1 > > _6645,std::shared_ptr< monty::ndarray< int,1 > > _6646,std::shared_ptr< monty::ndarray< double,1 > > _6647,long long _6648);
static SparseMatrix::t _new_SparseMatrix(int _6653,int _6654,std::shared_ptr< monty::ndarray< int,1 > > _6655,std::shared_ptr< monty::ndarray< int,1 > > _6656,std::shared_ptr< monty::ndarray< double,1 > > _6657);
void _initialize(int _6653,int _6654,std::shared_ptr< monty::ndarray< int,1 > > _6655,std::shared_ptr< monty::ndarray< int,1 > > _6656,std::shared_ptr< monty::ndarray< double,1 > > _6657);
virtual std::shared_ptr< monty::ndarray< long long,1 > > formPtrb();
virtual std::string toString();
virtual long long numNonzeros();
virtual monty::rc_ptr< ::mosek::fusion::Matrix > transpose();
virtual bool isSparse();
virtual std::shared_ptr< monty::ndarray< double,1 > > getDataAsArray();
virtual void getDataAsTriplets(std::shared_ptr< monty::ndarray< int,1 > > _6669,std::shared_ptr< monty::ndarray< int,1 > > _6670,std::shared_ptr< monty::ndarray< double,1 > > _6671);
virtual double get(int _6672,int _6673);
}; // struct SparseMatrix;

struct p_Parameters
{
Parameters * _pubthis;
static mosek::fusion::p_Parameters* _get_impl(mosek::fusion::Parameters * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
static mosek::fusion::p_Parameters * _get_impl(mosek::fusion::Parameters::t _inst) { return _get_impl(_inst.get()); }
p_Parameters(Parameters * _pubthis);
virtual ~p_Parameters() { /* std::cout << "~p_Parameters" << std::endl;*/ };
virtual void destroy();
static  void setParameter(monty::rc_ptr< ::mosek::fusion::Model > _6852,const std::string &  _6853,double _6854);
static  void setParameter(monty::rc_ptr< ::mosek::fusion::Model > _6953,const std::string &  _6954,int _6955);
static  void setParameter(monty::rc_ptr< ::mosek::fusion::Model > _7054,const std::string &  _7055,const std::string &  _7056);
static  int string_to_miocontsoltype_value(const std::string &  _7302);
static  int string_to_internal_dinf_value(const std::string &  _7303);
static  int string_to_presolvemode_value(const std::string &  _7304);
static  int string_to_optimizertype_value(const std::string &  _7305);
static  int string_to_stakey_value(const std::string &  _7306);
static  int string_to_iinfitem_value(const std::string &  _7307);
static  int string_to_simreform_value(const std::string &  _7308);
static  int string_to_value_value(const std::string &  _7309);
static  int string_to_scalingmethod_value(const std::string &  _7310);
static  int string_to_soltype_value(const std::string &  _7311);
static  int string_to_startpointtype_value(const std::string &  _7312);
static  int string_to_language_value(const std::string &  _7313);
static  int string_to_checkconvexitytype_value(const std::string &  _7314);
static  int string_to_variabletype_value(const std::string &  _7315);
static  int string_to_mpsformat_value(const std::string &  _7316);
static  int string_to_nametype_value(const std::string &  _7317);
static  int string_to_compresstype_value(const std::string &  _7318);
static  int string_to_simdupvec_value(const std::string &  _7319);
static  int string_to_dparam_value(const std::string &  _7320);
static  int string_to_inftype_value(const std::string &  _7321);
static  int string_to_problemtype_value(const std::string &  _7322);
static  int string_to_orderingtype_value(const std::string &  _7323);
static  int string_to_dataformat_value(const std::string &  _7324);
static  int string_to_simdegen_value(const std::string &  _7325);
static  int string_to_onoffkey_value(const std::string &  _7326);
static  int string_to_transpose_value(const std::string &  _7327);
static  int string_to_mionodeseltype_value(const std::string &  _7328);
static  int string_to_rescode_value(const std::string &  _7329);
static  int string_to_scalingtype_value(const std::string &  _7330);
static  int string_to_prosta_value(const std::string &  _7331);
static  int string_to_rescodetype_value(const std::string &  _7332);
static  int string_to_parametertype_value(const std::string &  _7333);
static  int string_to_dinfitem_value(const std::string &  _7334);
static  int string_to_miomode_value(const std::string &  _7335);
static  int string_to_xmlwriteroutputtype_value(const std::string &  _7336);
static  int string_to_simseltype_value(const std::string &  _7337);
static  int string_to_internal_liinf_value(const std::string &  _7338);
static  int string_to_iomode_value(const std::string &  _7339);
static  int string_to_streamtype_value(const std::string &  _7340);
static  int string_to_conetype_value(const std::string &  _7341);
static  int string_to_mark_value(const std::string &  _7342);
static  int string_to_feature_value(const std::string &  _7343);
static  int string_to_symmattype_value(const std::string &  _7344);
static  int string_to_callbackcode_value(const std::string &  _7345);
static  int string_to_simhotstart_value(const std::string &  _7346);
static  int string_to_liinfitem_value(const std::string &  _7347);
static  int string_to_branchdir_value(const std::string &  _7348);
static  int string_to_basindtype_value(const std::string &  _7349);
static  int string_to_internal_iinf_value(const std::string &  _7350);
static  int string_to_boundkey_value(const std::string &  _7351);
static  int string_to_solitem_value(const std::string &  _7352);
static  int string_to_objsense_value(const std::string &  _7353);
static  int string_to_solsta_value(const std::string &  _7354);
static  int string_to_iparam_value(const std::string &  _7355);
static  int string_to_sparam_value(const std::string &  _7356);
static  int string_to_intpnthotstart_value(const std::string &  _7357);
static  int string_to_uplo_value(const std::string &  _7358);
static  int string_to_sensitivitytype_value(const std::string &  _7359);
static  int string_to_accmode_value(const std::string &  _7360);
static  int string_to_problemitem_value(const std::string &  _7361);
static  int string_to_solveform_value(const std::string &  _7362);
}; // struct Parameters;

}
}
namespace mosek
{
namespace fusion
{
namespace Utils
{
// mosek.fusion.Utils.IntMap from file 'src\fusion\cxx\IntMap_p.h'
struct p_IntMap 
{
  IntMap * _pubself;

  static p_IntMap * _get_impl(IntMap * _inst) { return _inst->_impl.get(); }

  p_IntMap(IntMap * _pubself) : _pubself(_pubself) {}

  static IntMap::t _new_IntMap() { return new IntMap(); }

  ::std::unordered_map<long long,int> m;

  bool hasItem (long long key) { return m.find(key) != m.end(); }
  int  getItem (long long key) { return m.find(key)->second; } // will probably throw something or crash of no such key
  void setItem (long long key, int val) { m[key] = val; }

  std::shared_ptr<monty::ndarray<long long,1>> keys()
  { 
    size_t size = m.size();
    auto res = std::shared_ptr<monty::ndarray<long long,1>>(new monty::ndarray<long long,1>(monty::shape((int)size)));

    ptrdiff_t i = 0;
    for (auto it = m.begin(); it != m.end(); ++it)
      (*res)[i++] = it->first;

    return res;    
  }

  std::shared_ptr<monty::ndarray<int,1>> values()
  {
    size_t size = m.size();
    auto res = std::shared_ptr<monty::ndarray<int,1>>(new monty::ndarray<int,1>(monty::shape((int)size)));

    ptrdiff_t i = 0;
    for (auto it = m.begin(); it != m.end(); ++it)
      (*res)[i++] = it->second;

    return res;
  }

  IntMap::t clone();
};



struct p_StringIntMap
{
  StringIntMap * _pubself;

  static p_StringIntMap * _get_impl(StringIntMap * _inst) { return _inst->_impl.get(); }

  p_StringIntMap(StringIntMap * _pubself) : _pubself(_pubself) {}

  static StringIntMap::t _new_StringIntMap() { return new StringIntMap(); }

  ::std::unordered_map<std::string,int> m;

  bool hasItem (const std::string & key) { return m.find(key) != m.end(); }
  int  getItem (const std::string & key) { return m.find(key)->second; } // will probably throw something or crash of no such key
  void setItem (const std::string & key, int val) { m[key] = val; }

  std::shared_ptr<monty::ndarray<std::string,1>> keys()
  {
    size_t size = m.size();
    auto res = std::shared_ptr<monty::ndarray<std::string,1>>(new monty::ndarray<std::string,1>(monty::shape((int)size)));

    ptrdiff_t i = 0;
    for (auto it = m.begin(); it != m.end(); ++it)
      (*res)[i++] = it->first;

    return res;
  }

  std::shared_ptr<monty::ndarray<int,1>> values()
  {
    size_t size = m.size();
    auto res = std::shared_ptr<monty::ndarray<int,1>>(new monty::ndarray<int,1>(monty::shape((int)size)));

    ptrdiff_t i = 0;
    for (auto it = m.begin(); it != m.end(); ++it)
      (*res)[i++] = it->second;

    return res;
  }

  StringIntMap::t clone();
};
// End of file 'src\fusion\cxx\IntMap_p.h'
// mosek.fusion.Utils.StringBuffer from file 'src\fusion\cxx\StringBuffer_p.h'
// namespace mosek::fusion::Utils
struct p_StringBuffer
{
  StringBuffer * _pubthis; 
  std::stringstream ss;

  p_StringBuffer(StringBuffer * _pubthis) : _pubthis(_pubthis) {}

  static p_StringBuffer * _get_impl(StringBuffer::t ptr) { return ptr->_impl.get(); }
  static p_StringBuffer * _get_impl(StringBuffer * ptr) { return ptr->_impl.get(); }

  static StringBuffer::t _new_StringBuffer() { return new StringBuffer(); }

  StringBuffer::t clear ();

  template<typename T> StringBuffer::t a (const monty::ndarray<T,1> & val);

  template<typename T> StringBuffer::t a (const T & val);

  StringBuffer::t lf ();
  std::string toString () const;
};

template<typename T> 
StringBuffer::t p_StringBuffer::a(const monty::ndarray<T,1> & val)
{
  if (val.size() > 0)
  {
    ss << val[0];
    for (int i = 1; i < val.size(); ++i)
      ss << "," << val[i];
  }
  return StringBuffer::t(_pubthis);
}
  
template<typename T>
StringBuffer::t p_StringBuffer::a (const T & val)
{
  ss << val;
  return _pubthis;
}


// End of file 'src\fusion\cxx\StringBuffer_p.h'
}
}
}
#endif
