import numpy
import types
import io
import sys
import mosek

def _():
  import types

  class Enum:
    @staticmethod
    def __inst(c,name):
      o = types.InstanceType(c)
      o.name  = name
      o.value = len(c.__members__)
      c.__members__.append(o)
      setattr(c, name, o)

    @classmethod
    def fromInt(c,value):
      return c.members[value]

    @staticmethod
    def new(name,membernames):
      members = []
      c = types.ClassType(name, (Enum,),{ '__members__' : members })
      for n in membernames:
        Enum.__inst(c,n)
      return c
    @classmethod
    def members(c):
      return iter(c.__members__)

    def __str__(self):
      return self.__class__.__name__ + "." + self.name
    def __repr__(self):
      return self.__class__.__name__ + "." + self.name
  return Enum

class _monty:
  Enum = _()
  @staticmethod
  def deduceShape(l,dim):
    def _deduceShape(l,dim):
      if dim > 1:
        shplst = [ _deduceShape(i,dim-1) for i in l ]
        if all([shplst[0] == i for i in shplst ]):
          shplst[0].append(len(l))
          return shplst[0]
        else:
          raise TypeError("Irregular array shape")
      else:
        return [len(dim)]
    return tuple(reversed(_deduceShape(l,dim)))
  @staticmethod
  def checkShape(l,dim):
    def _checkShape(l,dim):
      if dim > 1:
        shplst = [ _checkShape(i,dim-1) for i in l ]
        if all([shplst[0] == i for i in shplst ]):
          pass
        else:
          raise TypeError("Irregular array shape")
        return len(l)
      else:
        try:
          return len(l)
        except TypeError:
          raise TypeError("Wrong or irregular array shape")
    _checkShape(l,dim)
    return dim
  @staticmethod
  def initJaggedArray(data, nd):
    dims = []
    d = data
    for i in range(nd):
      dims.append(len(d))
      d = d[0]

    res = numpy.zeros(dims,dtype=object)
    key = tuple([ slice(d) for d in dims ])
    try:
      res.__setitem__(key, data)
    except ValueError: # weird numpypy bug
      if   len(key) == 1:
        for i in range(0,dims[0]): res[i] = data[i]
      elif len(key) == 2:
        for i in range(0,dims[0]):
          for j in range(0,dims[1]):
            res[i,j] = data[i][j]
      elif len(key) == 3:
        for i in range(0,dims[0]):
          for j in range(0,dims[1]):
            for k in range(0,dims[2]):
              res[i,j,k] = data[i][j][k]
      else:
        assert 0 # Because hopefully we will get a real fix in numpypy before this case is hi
    return res

  @staticmethod
  def makeJaggedArray(src,ndims,dtype):
    if src is None:
      return None
    elif len(ndims) == 1:
      if ndims[0] == 1:
        r = numpy.zeros((len(src),),dtype=dtype)
        r[:] = src
      else:
        d = _monty.deduceDims(src,ndims[0])
        r = numpy.zeros(d,dtype=dtype)
        r.__setitem__(tuple([slice(None)]*ndims[0]),src) # basically: r[:,...,:] = src
      return r
    elif ndims[0] == 1:
      r = numpy.zeros((len(src),),dtype=numpy.dtype(object))
      # Note: This is a bit tricky to do reliably with numpy as it
      # tends to think we are dealing with multidimensional arrays and
      # explode
      for i,s in enumerate(src):
        r[i] = _monty.makeJaggedArray(s,ndims[1:],dtype)

      #r[:] = [ _monty.makeJaggedArray(s,ndims[1:],dtype) for s in src ]
      return r
    else:
      d = _monty.deduceDims(src,ndims[0])
      def _(src,nd):
        if nd == 0:
          return _monty.makeJaggedArray(src)
        else:
          return [ _(s,nd-1) for s in src ]

      r = numpy.zeros(d,dtype=numpy.dtype(object))
      r.__setitem__(tuple([slice(None)]*ndims[0]),_(src,ndims[0])) # basically: r[:,...,:] = convert(src)
      return r
     
  @staticmethod
  def copyArray(src,dst,dim):
    if dim == 1:
      src[:] = dst[:]
    else:
      for i in range(len(src)):
        _monty.copyArray(src[i],dst[i],dim-1)
  @staticmethod
  def arg_match_sloppy_array(v,elmmatch,dim,l=None):
    if dim == 0:
      elmmatch(v)
    elif dim == 1:
      if l is not None:
        if l != len(v): return False
      elif len(v) == 0: return True
      for e in v:
        if not elmmatch(e): return False
      return True
    elif isinstance(v,list) or isinstance(v,numpy.ndarray):
      if l is not None:
        if l != len(v): return False
      elif len(v) == 0: return True
      elif not (isinstance(v[0],list) or isinstance(v[0],numpy.ndarray)): return False
      
      top_len = len(v[0])
      for e in v:
        if not _monty.arg_match_sloppy_array(e,elmmatch,dim-1,top_len): return False
      return True
    else:
      return False
    
del _

mosek_fusion_RelationKey=_monty.Enum.new('RelationKey',['EqualsTo','LessThan','GreaterThan','IsFree','InRange'])
mosek_fusion_PSDKey=_monty.Enum.new('PSDKey',['IsSymPSD','IsTrilPSD'])
mosek_fusion_QConeKey=_monty.Enum.new('QConeKey',['InQCone','InRotatedQCone'])
mosek_fusion_ObjectiveSense=_monty.Enum.new('ObjectiveSense',['Undefined','Minimize','Maximize'])
mosek_fusion_SolutionStatus=_monty.Enum.new('SolutionStatus',['Undefined','Unknown','Optimal','NearOptimal','Feasible','NearFeasible','Certificate','NearCertificate','IllposedCert'])
mosek_fusion_AccSolutionStatus=_monty.Enum.new('AccSolutionStatus',['Anything','Optimal','NearOptimal','Feasible','Certificate'])
mosek_fusion_ProblemStatus=_monty.Enum.new('ProblemStatus',['Unknown','PrimalAndDualFeasible','PrimalFeasible','DualFeasible','PrimalInfeasible','DualInfeasible','PrimalAndDualInfeasible','IllPosed','PrimalInfeasibleOrUnbounded'])
mosek_fusion_SolutionType=_monty.Enum.new('SolutionType',['Default','Basic','Interior','Integer'])
mosek_fusion_StatusKey=_monty.Enum.new('StatusKey',['Unknown','Basic','SuperBasic','OnBound','Infinity'])
#BEFORE CLASS
def __mk_mosek_fusion_Variable():
 class Variable:
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_make_1integer__3J(*args): # []int64
      return self._make_1integer__3J(*args)
    elif mosek_fusion_Variable._match_alt_make_1integer__3J(*args): # []int64
      return self._make_1integer_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.make_integer(array(int64,ndim=1))')
  def asExpr(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_asExpr_(*args): # 
      return self._asExpr_(*args)
    elif mosek_fusion_Variable._match_alt_asExpr_(*args): # 
      return self._asExpr_alt_(*args)
    else:
      raise ValueError('Invalid argument list asExpr('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.asExpr()')
  def getModel(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_getModel_(*args): # 
      return self._getModel_(*args)
    elif mosek_fusion_Variable._match_alt_getModel_(*args): # 
      return self._getModel_alt_(*args)
    else:
      raise ValueError('Invalid argument list getModel('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.getModel()')
  def makeInteger(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_makeInteger_(*args): # 
      return self._makeInteger_(*args)
    elif mosek_fusion_Variable._match_alt_makeInteger_(*args): # 
      return self._makeInteger_alt_(*args)
    else:
      raise ValueError('Invalid argument list makeInteger('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.makeInteger()')
  def elementName(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_Variable._match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.elementName(int64,mosek.fusion.Utils.StringBuffer)')
  def diag(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_diag_(*args): # 
      return self._diag_(*args)
    elif mosek_fusion_Variable._match_alt_diag_(*args): # 
      return self._diag_alt_(*args)
    elif mosek_fusion_Variable._match_diag_I(*args): # int32
      return self._diag_I(*args)
    elif mosek_fusion_Variable._match_alt_diag_I(*args): # int32
      return self._diag_alt_I(*args)
    else:
      raise ValueError('Invalid argument list diag('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.diag()\n\tmosek.fusion.Variable.diag(int32)')
  def pick(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_pick__3I(*args): # []int32
      return self._pick__3I(*args)
    elif mosek_fusion_Variable._match_alt_pick__3I(*args): # []int32
      return self._pick_alt__3I(*args)
    elif mosek_fusion_Variable._match_pick__3_5I(*args): # [,]int32
      return self._pick__3_5I(*args)
    elif mosek_fusion_Variable._match_alt_pick__3_5I(*args): # [,]int32
      return self._pick_alt__3_5I(*args)
    elif mosek_fusion_Variable._match_pick__3I_3I(*args): # []int32,[]int32
      return self._pick__3I_3I(*args)
    elif mosek_fusion_Variable._match_alt_pick__3I_3I(*args): # []int32,[]int32
      return self._pick_alt__3I_3I(*args)
    elif mosek_fusion_Variable._match_pick__3I_3I_3I(*args): # []int32,[]int32,[]int32
      return self._pick__3I_3I_3I(*args)
    elif mosek_fusion_Variable._match_alt_pick__3I_3I_3I(*args): # []int32,[]int32,[]int32
      return self._pick_alt__3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list pick('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.pick(array(int32,ndim=1))\n\tmosek.fusion.Variable.pick(array(int32,ndim=2))\n\tmosek.fusion.Variable.pick(array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Variable.pick(array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def getShape(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_getShape_(*args): # 
      return self._getShape_(*args)
    elif mosek_fusion_Variable._match_alt_getShape_(*args): # 
      return self._getShape_alt_(*args)
    else:
      raise ValueError('Invalid argument list getShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.getShape()')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_slice_II(*args): # int32,int32
      return self._slice_II(*args)
    elif mosek_fusion_Variable._match_alt_slice_II(*args): # int32,int32
      return self._slice_alt_II(*args)
    elif mosek_fusion_Variable._match_slice__3I_3I(*args): # []int32,[]int32
      return self._slice__3I_3I(*args)
    elif mosek_fusion_Variable._match_alt_slice__3I_3I(*args): # []int32,[]int32
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.slice(int32,int32)\n\tmosek.fusion.Variable.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def antidiag(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_antidiag_(*args): # 
      return self._antidiag_(*args)
    elif mosek_fusion_Variable._match_alt_antidiag_(*args): # 
      return self._antidiag_alt_(*args)
    elif mosek_fusion_Variable._match_antidiag_I(*args): # int32
      return self._antidiag_I(*args)
    elif mosek_fusion_Variable._match_alt_antidiag_I(*args): # int32
      return self._antidiag_alt_I(*args)
    else:
      raise ValueError('Invalid argument list antidiag('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.antidiag()\n\tmosek.fusion.Variable.antidiag(int32)')
  def index(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_index_I(*args): # int32
      return self._index_I(*args)
    elif mosek_fusion_Variable._match_alt_index_I(*args): # int32
      return self._index_alt_I(*args)
    elif mosek_fusion_Variable._match_index__3I(*args): # []int32
      return self._index__3I(*args)
    elif mosek_fusion_Variable._match_alt_index__3I(*args): # []int32
      return self._index_alt__3I(*args)
    elif mosek_fusion_Variable._match_index_II(*args): # int32,int32
      return self._index_II(*args)
    elif mosek_fusion_Variable._match_alt_index_II(*args): # int32,int32
      return self._index_alt_II(*args)
    elif mosek_fusion_Variable._match_index_III(*args): # int32,int32,int32
      return self._index_III(*args)
    elif mosek_fusion_Variable._match_alt_index_III(*args): # int32,int32,int32
      return self._index_alt_III(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.index(int32)\n\tmosek.fusion.Variable.index(array(int32,ndim=1))\n\tmosek.fusion.Variable.index(int32,int32)\n\tmosek.fusion.Variable.index(int32,int32,int32)')
  def shape(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_shape_(*args): # 
      return self._shape_(*args)
    elif mosek_fusion_Variable._match_alt_shape_(*args): # 
      return self._shape_alt_(*args)
    else:
      raise ValueError('Invalid argument list shape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.shape()')
  def elementDesc(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_Variable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values__3J_3DZ(*args)
    elif mosek_fusion_Variable._match_alt_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values_alt__3J_3DZ(*args)
    elif mosek_fusion_Variable._match_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_Variable._match_alt_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.set_values(array(int64,ndim=1),array(double,ndim=1),bool)\n\tmosek.fusion.Variable.set_values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def size(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_size_(*args): # 
      return self._size_(*args)
    elif mosek_fusion_Variable._match_alt_size_(*args): # 
      return self._size_alt_(*args)
    else:
      raise ValueError('Invalid argument list size('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.size()')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_toString_(*args): # 
      return self._toString_(*args)
    elif mosek_fusion_Variable._match_alt_toString_(*args): # 
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.toString()')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_make_1continuous__3J(*args): # []int64
      return self._make_1continuous__3J(*args)
    elif mosek_fusion_Variable._match_alt_make_1continuous__3J(*args): # []int64
      return self._make_1continuous_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.make_continuous(array(int64,ndim=1))')
  def level(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_level_(*args): # 
      return self._level_(*args)
    elif mosek_fusion_Variable._match_alt_level_(*args): # 
      return self._level_alt_(*args)
    else:
      raise ValueError('Invalid argument list level('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.level()')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_JJ_3I_3I_3I(*args)
    elif mosek_fusion_Variable._match_alt_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt_JJ_3I_3I_3I(*args)
    elif mosek_fusion_Variable._match_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst__3JIIJJ_3I_3I_3I(*args)
    elif mosek_fusion_Variable._match_alt_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt__3JIIJJ_3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.inst(int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Variable.inst(array(int64,ndim=1),int32,int32,int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def setLevel(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_setLevel__3D(*args): # []double
      return self._setLevel__3D(*args)
    elif mosek_fusion_Variable._match_alt_setLevel__3D(*args): # []double
      return self._setLevel_alt__3D(*args)
    else:
      raise ValueError('Invalid argument list setLevel('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.setLevel(array(double,ndim=1))')
  def makeContinuous(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_makeContinuous_(*args): # 
      return self._makeContinuous_(*args)
    elif mosek_fusion_Variable._match_alt_makeContinuous_(*args): # 
      return self._makeContinuous_alt_(*args)
    else:
      raise ValueError('Invalid argument list makeContinuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.makeContinuous()')
  def dual(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_dual_(*args): # 
      return self._dual_(*args)
    elif mosek_fusion_Variable._match_alt_dual_(*args): # 
      return self._dual_alt_(*args)
    else:
      raise ValueError('Invalid argument list dual('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.dual()')
  def transpose(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_transpose_(*args): # 
      return self._transpose_(*args)
    elif mosek_fusion_Variable._match_alt_transpose_(*args): # 
      return self._transpose_alt_(*args)
    else:
      raise ValueError('Invalid argument list transpose('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.transpose()')
  def values(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_I_3DZ(*args)
    elif mosek_fusion_Variable._match_alt_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_alt_I_3DZ(*args)
    elif mosek_fusion_Variable._match_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values__3JI_3DZ(*args)
    elif mosek_fusion_Variable._match_alt_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values_alt__3JI_3DZ(*args)
    elif mosek_fusion_Variable._match_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_Variable._match_alt_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.values(int32,array(double,ndim=1),bool)\n\tmosek.fusion.Variable.values(array(int64,ndim=1),int32,array(double,ndim=1),bool)\n\tmosek.fusion.Variable.values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def __str__(self): return self._toString_()
  def __repr__(self): return 'mosek.fusion.Variable: '+self._toString_()
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   pass
  @staticmethod
  def _match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   pass
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   pass
  @staticmethod
  def _match_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match__3I__(_5) and __arg_match__3I__(_6) and __arg_match__3I__(_7))
  @staticmethod
  def _match_alt_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match__3I__(_5) and __arg_alt_match__3I__(_6) and __arg_alt_match__3I__(_7))
  def _inst_alt__3JIIJJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int32))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.int32))
   _7=numpy.array(_t__7,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst__3JIIJJ_3I_3I_3I(_0,_1,_2,_3,_4,_5,_6,_7)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__7[:] = _7
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst__3JIIJJ_3I_3I_3I(self,_0,_1,_2,_3,_4,_5,_6,_7):
   pass
  @staticmethod
  def _match_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match_J__(_0) and __arg_match_J__(_1) and __arg_match__3I__(_2) and __arg_match__3I__(_3) and __arg_match__3I__(_4))
  @staticmethod
  def _match_alt_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_J__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match__3I__(_3) and __arg_alt_match__3I__(_4))
  def _inst_alt_JJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst_JJ_3I_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst_JJ_3I_3I_3I(self,_0,_1,_2,_3,_4):
   pass
  @staticmethod
  def _match_shape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_shape_(*args):
    if len(args) != 0: return False
    return True
  def _shape_alt_(self,):
    return self._shape_()
  def _shape_(self,):
   pass
  @staticmethod
  def _match_getShape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getShape_(*args):
    if len(args) != 0: return False
    return True
  def _getShape_alt_(self,):
    return self._getShape_()
  def _getShape_(self,):
   pass
  @staticmethod
  def _match_getModel_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getModel_(*args):
    if len(args) != 0: return False
    return True
  def _getModel_alt_(self,):
    return self._getModel_()
  def _getModel_(self,):
   pass
  @staticmethod
  def _match_size_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_size_(*args):
    if len(args) != 0: return False
    return True
  def _size_alt_(self,):
    return self._size_()
  def _size_(self,):
   pass
  @staticmethod
  def _match_setLevel__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3D__(_0))
  @staticmethod
  def _match_alt_setLevel__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3D__(_0))
  def _setLevel_alt__3D(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1 = self._setLevel__3D(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _setLevel__3D(self,_0):
   pass
  @staticmethod
  def _match_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _set_1values_alt__3J_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1 = self._set_1values__3J_3DZ(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values__3J_3DZ(self,_0,_1,_2):
   pass
  @staticmethod
  def _match_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _set_1values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._set_1values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   pass
  @staticmethod
  def _match_dual_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dual_(*args):
    if len(args) != 0: return False
    return True
  def _dual_alt_(self,):
    return self._dual_()
  def _dual_(self,):
   pass
  @staticmethod
  def _match_level_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_level_(*args):
    if len(args) != 0: return False
    return True
  def _level_alt_(self,):
    return self._level_()
  def _level_(self,):
   pass
  @staticmethod
  def _match_values_I_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_values_I_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _values_alt_I_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1 = self._values_I_3DZ(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values_I_3DZ(self,_0,_1,_2):
   pass
  @staticmethod
  def _match_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match__3D__(_2) and __arg_match_Z__(_3))
  @staticmethod
  def _match_alt_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_Z__(_3))
  def _values_alt__3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_t__3
   _1 = self._values__3JI_3DZ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values__3JI_3DZ(self,_0,_1,_2,_3):
   pass
  @staticmethod
  def _match_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   pass
  @staticmethod
  def _match_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1continuous_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1continuous__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1continuous__3J(self,_0):
   pass
  @staticmethod
  def _match_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1integer_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1integer__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1integer__3J(self,_0):
   pass
  @staticmethod
  def _match_makeContinuous_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_makeContinuous_(*args):
    if len(args) != 0: return False
    return True
  def _makeContinuous_alt_(self,):
    return self._makeContinuous_()
  def _makeContinuous_(self,):
   pass
  @staticmethod
  def _match_makeInteger_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_makeInteger_(*args):
    if len(args) != 0: return False
    return True
  def _makeInteger_alt_(self,):
    return self._makeInteger_()
  def _makeInteger_(self,):
   pass
  @staticmethod
  def _match_transpose_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_transpose_(*args):
    if len(args) != 0: return False
    return True
  def _transpose_alt_(self,):
    return self._transpose_()
  def _transpose_(self,):
   pass
  @staticmethod
  def _match_pick__3I_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2))
  @staticmethod
  def _match_alt_pick__3I_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2))
  def _pick_alt__3I_3I_3I(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _1 = self._pick__3I_3I_3I(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _pick__3I_3I_3I(self,_0,_1,_2):
   pass
  @staticmethod
  def _match_pick__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_pick__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _pick_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self._pick__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _pick__3I_3I(self,_0,_1):
   pass
  @staticmethod
  def _match_pick__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3_5I__(_0))
  @staticmethod
  def _match_alt_pick__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3_5I__(_0))
  def _pick_alt__3_5I(self,_t__0):
   _0=numpy.array(_t__0,ndmin=_monty.checkShape(_t__0,2),dtype=numpy.dtype(numpy.int32))
   _1 = self._pick__3_5I(_0)
   return _1
  def _pick__3_5I(self,_0):
   pass
  @staticmethod
  def _match_pick__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_pick__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _pick_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1 = self._pick__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _pick__3I(self,_0):
   pass
  @staticmethod
  def _match_antidiag_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_antidiag_(*args):
    if len(args) != 0: return False
    return True
  def _antidiag_alt_(self,):
    return self._antidiag_()
  def _antidiag_(self,):
   pass
  @staticmethod
  def _match_antidiag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_antidiag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _antidiag_alt_I(self,_t__0):
    return self._antidiag_I(numpy.int32(__0))
  def _antidiag_I(self,_0):
   pass
  @staticmethod
  def _match_diag_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_diag_(*args):
    if len(args) != 0: return False
    return True
  def _diag_alt_(self,):
    return self._diag_()
  def _diag_(self,):
   pass
  @staticmethod
  def _match_diag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_diag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _diag_alt_I(self,_t__0):
    return self._diag_I(numpy.int32(__0))
  def _diag_I(self,_0):
   pass
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _index_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1 = self._index__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _index__3I(self,_0):
   pass
  @staticmethod
  def _match_index_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_index_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2))
  def _index_alt_III(self,_t__0,_t__1,_t__2):
    return self._index_III(numpy.int32(__0),numpy.int32(__1),numpy.int32(__2))
  def _index_III(self,_0,_1,_2):
   pass
  @staticmethod
  def _match_index_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_index_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _index_alt_II(self,_t__0,_t__1):
    return self._index_II(numpy.int32(__0),numpy.int32(__1))
  def _index_II(self,_0,_1):
   pass
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _index_alt_I(self,_t__0):
    return self._index_I(numpy.int32(__0))
  def _index_I(self,_0):
   pass
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _slice__3I_3I(self,_0,_1):
   pass
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   pass
  @staticmethod
  def _match_asExpr_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_asExpr_(*args):
    if len(args) != 0: return False
    return True
  def _asExpr_alt_(self,):
    return self._asExpr_()
  def _asExpr_(self,):
   pass
 return Variable
mosek_fusion_Variable=__mk_mosek_fusion_Variable()
del __mk_mosek_fusion_Variable
#BEFORE CLASS
def __mk_mosek_fusion_SymmetricVariable():
 class SymmetricVariable(mosek_fusion_Variable):
  def __repr__(self): return 'mosek.fusion.SymmetricVariable'
 return SymmetricVariable
mosek_fusion_SymmetricVariable=__mk_mosek_fusion_SymmetricVariable()
del __mk_mosek_fusion_SymmetricVariable
#BEFORE CLASS
def __mk_mosek_fusion_Expression():
 class Expression:
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_toString_(*args): # 
      return self._toString_(*args)
    elif mosek_fusion_Expression._match_alt_toString_(*args): # 
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.toString()')
  def transpose(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_transpose_(*args): # 
      return self._transpose_(*args)
    elif mosek_fusion_Expression._match_alt_transpose_(*args): # 
      return self._transpose_alt_(*args)
    else:
      raise ValueError('Invalid argument list transpose('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.transpose()')
  def pick(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_pick__3I(*args): # []int32
      return self._pick__3I(*args)
    elif mosek_fusion_Expression._match_alt_pick__3I(*args): # []int32
      return self._pick_alt__3I(*args)
    elif mosek_fusion_Expression._match_pick__3_5I(*args): # [,]int32
      return self._pick__3_5I(*args)
    elif mosek_fusion_Expression._match_alt_pick__3_5I(*args): # [,]int32
      return self._pick_alt__3_5I(*args)
    else:
      raise ValueError('Invalid argument list pick('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.pick(array(int32,ndim=1))\n\tmosek.fusion.Expression.pick(array(int32,ndim=2))')
  def index(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_index_I(*args): # int32
      return self._index_I(*args)
    elif mosek_fusion_Expression._match_alt_index_I(*args): # int32
      return self._index_alt_I(*args)
    elif mosek_fusion_Expression._match_index__3I(*args): # []int32
      return self._index__3I(*args)
    elif mosek_fusion_Expression._match_alt_index__3I(*args): # []int32
      return self._index_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.index(int32)\n\tmosek.fusion.Expression.index(array(int32,ndim=1))')
  def eval(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_eval_(*args): # 
      return self._eval_(*args)
    elif mosek_fusion_Expression._match_alt_eval_(*args): # 
      return self._eval_alt_(*args)
    else:
      raise ValueError('Invalid argument list eval('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.eval()')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_slice_II(*args): # int32,int32
      return self._slice_II(*args)
    elif mosek_fusion_Expression._match_alt_slice_II(*args): # int32,int32
      return self._slice_alt_II(*args)
    elif mosek_fusion_Expression._match_slice__3I_3I(*args): # []int32,[]int32
      return self._slice__3I_3I(*args)
    elif mosek_fusion_Expression._match_alt_slice__3I_3I(*args): # []int32,[]int32
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.slice(int32,int32)\n\tmosek.fusion.Expression.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def shape(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_shape_(*args): # 
      return self._shape_(*args)
    elif mosek_fusion_Expression._match_alt_shape_(*args): # 
      return self._shape_alt_(*args)
    else:
      raise ValueError('Invalid argument list shape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.shape()')
  def getShape(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_getShape_(*args): # 
      return self._getShape_(*args)
    elif mosek_fusion_Expression._match_alt_getShape_(*args): # 
      return self._getShape_alt_(*args)
    else:
      raise ValueError('Invalid argument list getShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.getShape()')
  def getModel(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_getModel_(*args): # 
      return self._getModel_(*args)
    elif mosek_fusion_Expression._match_alt_getModel_(*args): # 
      return self._getModel_alt_(*args)
    else:
      raise ValueError('Invalid argument list getModel('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.getModel()')
  def __str__(self): return self._toString_()
  def __repr__(self): return 'mosek.fusion.Expression: '+self._toString_()
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   pass
  @staticmethod
  def _match_transpose_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_transpose_(*args):
    if len(args) != 0: return False
    return True
  def _transpose_alt_(self,):
    return self._transpose_()
  def _transpose_(self,):
   pass
  @staticmethod
  def _match_pick__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3_5I__(_0))
  @staticmethod
  def _match_alt_pick__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3_5I__(_0))
  def _pick_alt__3_5I(self,_t__0):
   _0=numpy.array(_t__0,ndmin=_monty.checkShape(_t__0,2),dtype=numpy.dtype(numpy.int32))
   _1 = self._pick__3_5I(_0)
   return _1
  def _pick__3_5I(self,_0):
   pass
  @staticmethod
  def _match_pick__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_pick__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _pick_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1 = self._pick__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _pick__3I(self,_0):
   pass
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _index_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1 = self._index__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _index__3I(self,_0):
   pass
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _index_alt_I(self,_t__0):
    return self._index_I(numpy.int32(__0))
  def _index_I(self,_0):
   pass
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _slice__3I_3I(self,_0,_1):
   pass
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   pass
  @staticmethod
  def _match_eval_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_eval_(*args):
    if len(args) != 0: return False
    return True
  def _eval_alt_(self,):
    return self._eval_()
  def _eval_(self,):
   pass
  @staticmethod
  def _match_getModel_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getModel_(*args):
    if len(args) != 0: return False
    return True
  def _getModel_alt_(self,):
    return self._getModel_()
  def _getModel_(self,):
   pass
  @staticmethod
  def _match_shape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_shape_(*args):
    if len(args) != 0: return False
    return True
  def _shape_alt_(self,):
    return self._shape_()
  def _shape_(self,):
   pass
  @staticmethod
  def _match_getShape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getShape_(*args):
    if len(args) != 0: return False
    return True
  def _getShape_alt_(self,):
    return self._getShape_()
  def _getShape_(self,):
   pass
 return Expression
mosek_fusion_Expression=__mk_mosek_fusion_Expression()
del __mk_mosek_fusion_Expression
#BEFORE CLASS
def __mk_mosek_fusion_FusionException():
 class FusionException(Exception):
  __slots__ = ['_FusionException__msg']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.FusionException.ctor(string)')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_FusionException._match_toString_(*args): # 
      return self._toString_(*args)
    elif mosek_fusion_FusionException._match_alt_toString_(*args): # 
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.FusionException.toString()')
  def __str__(self): return self._toString_()
  def __repr__(self): return 'mosek.fusion.FusionException: '+self._toString_()
  @staticmethod
  def _ctor_S(msg_):
    o = FusionException.__new__(FusionException)
    o._ctor_init_S(msg_)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg_, = args
    return (__arg_match_S__(msg_))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg_, = args
    return (__arg_alt_match_S__(msg_))
  def _ctor_alt_init_S(self,msg_):
    self._ctor_init_S(msg_)
  def _ctor_init_S(self,msg_):
   Exception.__init__(self,msg_)
   self.__msg = msg_
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   return (self.__msg)
 return FusionException
mosek_fusion_FusionException=__mk_mosek_fusion_FusionException()
del __mk_mosek_fusion_FusionException
#BEFORE CLASS
def __mk_mosek_fusion_SolutionError():
 class SolutionError(mosek_fusion_FusionException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_(*args): # 
      self._ctor_init_(*args)
    elif self.__match_alt_ctor_(*args):# 
      self._ctor_alt_init_(*args)
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.SolutionError.ctor()\n\tmosek.fusion.SolutionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.SolutionError'
  @staticmethod
  def _ctor_():
    o = SolutionError.__new__(SolutionError)
    o._ctor_init_()
    return o
  @staticmethod
  def __match_ctor_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def __match_alt_ctor_(*args):
    if len(args) != 0: return False
    return True
  def _ctor_alt_init_(self,):
    self._ctor_init_()
  def _ctor_init_(self,):
   mosek_fusion_FusionException._ctor_init_S(self,"Solution is invalid or undefined")
  @staticmethod
  def _ctor_S(msg):
    o = SolutionError.__new__(SolutionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionException._ctor_init_S(self,msg)
 return SolutionError
mosek_fusion_SolutionError=__mk_mosek_fusion_SolutionError()
del __mk_mosek_fusion_SolutionError
#BEFORE CLASS
def __mk_mosek_fusion_UnimplementedError():
 class UnimplementedError(Exception):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.UnimplementedError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.UnimplementedError'
  @staticmethod
  def _ctor_S(msg):
    o = UnimplementedError.__new__(UnimplementedError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   Exception.__init__(self,msg)
 return UnimplementedError
mosek_fusion_UnimplementedError=__mk_mosek_fusion_UnimplementedError()
del __mk_mosek_fusion_UnimplementedError
#BEFORE CLASS
def __mk_mosek_fusion_FatalError():
 class FatalError(Exception):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.FatalError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.FatalError'
  @staticmethod
  def _ctor_S(msg):
    o = FatalError.__new__(FatalError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   Exception.__init__(self,msg)
 return FatalError
mosek_fusion_FatalError=__mk_mosek_fusion_FatalError()
del __mk_mosek_fusion_FatalError
#BEFORE CLASS
def __mk_mosek_fusion_UnexpectedError():
 class UnexpectedError(Exception):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_Lmosek_4fusion_4FusionException_2(*args): # mosek.fusion.FusionException
      self._ctor_init_Lmosek_4fusion_4FusionException_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4FusionException_2(*args):# mosek.fusion.FusionException
      self._ctor_alt_init_Lmosek_4fusion_4FusionException_2(*args)
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.UnexpectedError.ctor(mosek.fusion.FusionException)\n\tmosek.fusion.UnexpectedError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.UnexpectedError'
  @staticmethod
  def _ctor_Lmosek_4fusion_4FusionException_2(e):
    o = UnexpectedError.__new__(UnexpectedError)
    o._ctor_init_Lmosek_4fusion_4FusionException_2(e)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4FusionException_2(*args):
    if len(args) != 1: return False
    e, = args
    return (__arg_match_Lmosek_4fusion_4FusionException_2__(e))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4FusionException_2(*args):
    if len(args) != 1: return False
    e, = args
    return (__arg_alt_match_Lmosek_4fusion_4FusionException_2__(e))
  def _ctor_alt_init_Lmosek_4fusion_4FusionException_2(self,e):
    self._ctor_init_Lmosek_4fusion_4FusionException_2(e)
  def _ctor_init_Lmosek_4fusion_4FusionException_2(self,e):
   Exception.__init__(self,e.toString())
  @staticmethod
  def _ctor_S(msg):
    o = UnexpectedError.__new__(UnexpectedError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   Exception.__init__(self,msg)
 return UnexpectedError
mosek_fusion_UnexpectedError=__mk_mosek_fusion_UnexpectedError()
del __mk_mosek_fusion_UnexpectedError
#BEFORE CLASS
def __mk_mosek_fusion_FusionRuntimeException():
 class FusionRuntimeException(Exception):
  __slots__ = ['_FusionRuntimeException__msg']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.FusionRuntimeException.ctor(string)')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_FusionRuntimeException._match_toString_(*args): # 
      return self._toString_(*args)
    elif mosek_fusion_FusionRuntimeException._match_alt_toString_(*args): # 
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.FusionRuntimeException.toString()')
  def __str__(self): return self._toString_()
  def __repr__(self): return 'mosek.fusion.FusionRuntimeException: '+self._toString_()
  @staticmethod
  def _ctor_S(msg_):
    o = FusionRuntimeException.__new__(FusionRuntimeException)
    o._ctor_init_S(msg_)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg_, = args
    return (__arg_match_S__(msg_))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg_, = args
    return (__arg_alt_match_S__(msg_))
  def _ctor_alt_init_S(self,msg_):
    self._ctor_init_S(msg_)
  def _ctor_init_S(self,msg_):
   Exception.__init__(self,msg_)
   self.__msg = msg_
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   return (self.__msg)
 return FusionRuntimeException
mosek_fusion_FusionRuntimeException=__mk_mosek_fusion_FusionRuntimeException()
del __mk_mosek_fusion_FusionRuntimeException
#BEFORE CLASS
def __mk_mosek_fusion_SparseFormatError():
 class SparseFormatError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.SparseFormatError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.SparseFormatError'
  @staticmethod
  def _ctor_S(msg):
    o = SparseFormatError.__new__(SparseFormatError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return SparseFormatError
mosek_fusion_SparseFormatError=__mk_mosek_fusion_SparseFormatError()
del __mk_mosek_fusion_SparseFormatError
#BEFORE CLASS
def __mk_mosek_fusion_SliceError():
 class SliceError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_(*args): # 
      self._ctor_init_(*args)
    elif self.__match_alt_ctor_(*args):# 
      self._ctor_alt_init_(*args)
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.SliceError.ctor()\n\tmosek.fusion.SliceError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.SliceError'
  @staticmethod
  def _ctor_():
    o = SliceError.__new__(SliceError)
    o._ctor_init_()
    return o
  @staticmethod
  def __match_ctor_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def __match_alt_ctor_(*args):
    if len(args) != 0: return False
    return True
  def _ctor_alt_init_(self,):
    self._ctor_init_()
  def _ctor_init_(self,):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,"Invalid slice range")
  @staticmethod
  def _ctor_S(msg):
    o = SliceError.__new__(SliceError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return SliceError
mosek_fusion_SliceError=__mk_mosek_fusion_SliceError()
del __mk_mosek_fusion_SliceError
#BEFORE CLASS
def __mk_mosek_fusion_SetDefinitionError():
 class SetDefinitionError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.SetDefinitionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.SetDefinitionError'
  @staticmethod
  def _ctor_S(msg):
    o = SetDefinitionError.__new__(SetDefinitionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return SetDefinitionError
mosek_fusion_SetDefinitionError=__mk_mosek_fusion_SetDefinitionError()
del __mk_mosek_fusion_SetDefinitionError
#BEFORE CLASS
def __mk_mosek_fusion_OptimizeError():
 class OptimizeError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.OptimizeError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.OptimizeError'
  @staticmethod
  def _ctor_S(msg):
    o = OptimizeError.__new__(OptimizeError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return OptimizeError
mosek_fusion_OptimizeError=__mk_mosek_fusion_OptimizeError()
del __mk_mosek_fusion_OptimizeError
#BEFORE CLASS
def __mk_mosek_fusion_NameError():
 class NameError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.NameError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.NameError'
  @staticmethod
  def _ctor_S(msg):
    o = NameError.__new__(NameError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return NameError
mosek_fusion_NameError=__mk_mosek_fusion_NameError()
del __mk_mosek_fusion_NameError
#BEFORE CLASS
def __mk_mosek_fusion_ModelError():
 class ModelError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.ModelError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.ModelError'
  @staticmethod
  def _ctor_S(msg):
    o = ModelError.__new__(ModelError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return ModelError
mosek_fusion_ModelError=__mk_mosek_fusion_ModelError()
del __mk_mosek_fusion_ModelError
#BEFORE CLASS
def __mk_mosek_fusion_MatrixError():
 class MatrixError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.MatrixError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.MatrixError'
  @staticmethod
  def _ctor_S(msg):
    o = MatrixError.__new__(MatrixError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return MatrixError
mosek_fusion_MatrixError=__mk_mosek_fusion_MatrixError()
del __mk_mosek_fusion_MatrixError
#BEFORE CLASS
def __mk_mosek_fusion_DimensionError():
 class DimensionError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.DimensionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.DimensionError'
  @staticmethod
  def _ctor_S(msg):
    o = DimensionError.__new__(DimensionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return DimensionError
mosek_fusion_DimensionError=__mk_mosek_fusion_DimensionError()
del __mk_mosek_fusion_DimensionError
#BEFORE CLASS
def __mk_mosek_fusion_LengthError():
 class LengthError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.LengthError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.LengthError'
  @staticmethod
  def _ctor_S(msg):
    o = LengthError.__new__(LengthError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return LengthError
mosek_fusion_LengthError=__mk_mosek_fusion_LengthError()
del __mk_mosek_fusion_LengthError
#BEFORE CLASS
def __mk_mosek_fusion_RangeError():
 class RangeError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.RangeError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.RangeError'
  @staticmethod
  def _ctor_S(msg):
    o = RangeError.__new__(RangeError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return RangeError
mosek_fusion_RangeError=__mk_mosek_fusion_RangeError()
del __mk_mosek_fusion_RangeError
#BEFORE CLASS
def __mk_mosek_fusion_IndexError():
 class IndexError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.IndexError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.IndexError'
  @staticmethod
  def _ctor_S(msg):
    o = IndexError.__new__(IndexError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return IndexError
mosek_fusion_IndexError=__mk_mosek_fusion_IndexError()
del __mk_mosek_fusion_IndexError
#BEFORE CLASS
def __mk_mosek_fusion_DomainError():
 class DomainError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.DomainError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.DomainError'
  @staticmethod
  def _ctor_S(msg):
    o = DomainError.__new__(DomainError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return DomainError
mosek_fusion_DomainError=__mk_mosek_fusion_DomainError()
del __mk_mosek_fusion_DomainError
#BEFORE CLASS
def __mk_mosek_fusion_ValueConversionError():
 class ValueConversionError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.ValueConversionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.ValueConversionError'
  @staticmethod
  def _ctor_S(msg):
    o = ValueConversionError.__new__(ValueConversionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return ValueConversionError
mosek_fusion_ValueConversionError=__mk_mosek_fusion_ValueConversionError()
del __mk_mosek_fusion_ValueConversionError
#BEFORE CLASS
def __mk_mosek_fusion_ParameterError():
 class ParameterError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.ParameterError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.ParameterError'
  @staticmethod
  def _ctor_S(msg):
    o = ParameterError.__new__(ParameterError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return ParameterError
mosek_fusion_ParameterError=__mk_mosek_fusion_ParameterError()
del __mk_mosek_fusion_ParameterError
#BEFORE CLASS
def __mk_mosek_fusion_ExpressionError():
 class ExpressionError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.ExpressionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.ExpressionError'
  @staticmethod
  def _ctor_S(msg):
    o = ExpressionError.__new__(ExpressionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return ExpressionError
mosek_fusion_ExpressionError=__mk_mosek_fusion_ExpressionError()
del __mk_mosek_fusion_ExpressionError
#BEFORE CLASS
def __mk_mosek_fusion_IOError():
 class IOError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.IOError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.IOError'
  @staticmethod
  def _ctor_S(msg):
    o = IOError.__new__(IOError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return IOError
mosek_fusion_IOError=__mk_mosek_fusion_IOError()
del __mk_mosek_fusion_IOError
def __mk_mosek_fusion_BaseModel():
  import threading
  import mosek
  import mosek.fusion
  import numpy
  
  class BaseModel(object):
    _lock = threading.Lock()
    _global_env = None
    _global_env_counter = 0
  
    @classmethod
    def _globalEnv(self):
      self._lock.acquire()
      try:
        if BaseModel._global_env is None:
          try:
            env = mosek.Env()
            BaseModel._global_env = env
            BaseModel._global_env_counter += 1
          except mosek.Exception,e:
            raise UnexpectedError(e)
        return BaseModel._global_env
      finally:
        self._lock.release()
  
    @classmethod
    def _env_1putlicensecode(self,code):
      self._globalEnv().putlicensecode(code)
  
    @classmethod
    def _env_1putlicensepath(self,path):
      self._globalEnv().putlicensepath(path)
  
    @classmethod
    def _env_1putlicensewait(self,yn):
      if yn:
        self._globalEnv().putlicensewait(1)
      else:
        self._globalEnv().putlicensewait(0)
  
        
    def __callback(self,callbackkey, dinf, iinf, liinf):
      if self.__user_cb is not None:
        try:
          if self.__user_cb(callbackkey,dinf,iinf,liinf):
            self.__break = True
        except:
          self.__break = True
  
      if self.__user_pgs is not None:
        try:
          if self.__user_pgs(callbackkey):
            self.__break = True
        except:
          self.__break = True
          
      return 1 if self.__break else 0
  
    def _ctor_init_SS(self,name,licfile):
      env = self._globalEnv()
      self.__modelname = name
      self.__break = False
      task = mosek.Task(self._global_env, 0, 0);
      self.__user_cb = None
      self.__user_pgs = None
      finished = False
      try:
        task.putintparam(mosek.iparam.log_expand,0);
        #task.putintparam(mosek.iparam.remove_unused_solutions,1);
        self.__task = task
        if name is not None:
          task.puttaskname(name)
  
        self._synched = mosek_fusion_SolutionStatus.Optimal;
  
        self._sol_itr = None
        self._sol_bas = None
        self._sol_itg = None
  
        self.__objname = None
        self.__objexpr = None
  
        # handler for log output.
        def loghandler(text):
          if self.__logwriter is not None:
            self.__logwriter.write(text)
            self.__logwriter.flush()
        self.__loghandler = loghandler
        self.__logwriter = None
        
        task.set_Stream(mosek.streamtype.log,loghandler)
        task.set_InfoCallback(self.__callback)
        finished = True
      finally:
        if not finished:
          self.__task.__del__()
          self.__task = None
          BaseModel._global_env_counter -= 1
  
    def _ctor_init_Lmosek_4fusion_4BaseModel_2(self,m):
      env = self._globalEnv()
      self.__modelname = m.__modelname
      self.__break = False
      self.__user_cb = None
      self.__user_pgs = None
      task = mosek.Task(m.__task)
      finished = False
      try:
        self.__task = task
        #self.__task.putintparam(mosek.iparam.remove_unused_solutions,1);
        self._synched = m._synched;
  
        self._sol_itr = m._sol_itr._clone_() if m._sol_itr is not None else None
        self._sol_bas = m._sol_bas._clone_() if m._sol_bas is not None else None
        self._sol_itg = m._sol_itg._clone_() if m._sol_itg is not None else None
  
        self.__objname = m.__objname
  
        # handler for log output.
        def loghandler(text):
          if self.__logwriter is not None:
            self.__logwriter.write(text)
            self.__logwriter.flush()
        self.__loghandler = loghandler
        self.__logwriter = None
        
        task.set_Stream(mosek.streamtype.log,loghandler)
        task.set_InfoCallback(self.__callback)
        finished = True
      finally:
        if not finished:
          self.__task.__del__()
          self.__task = None
          BaseModel._global_env_counter -= 1
  
    def __del__(self):
      if hasattr(self,'_BaseModel__task') and self.__task is not None:
        self._lock.acquire()
        try:
          task = self.__task
          self.__task = None
          BaseModel._global_env_counter -= 1
          task.__del__()
          
          ignore_attrs = frozenset(['__del__','_lock','_BaseModel__task'] + dir(self.__class__))
          for a in set(dir(self)) - ignore_attrs:
            setattr(self,a,None)
        except Exception,e:
          import traceback
          traceback.print_exc()
          print e
  
        finally:
          self._lock.release()
    def __enter__(self):
      return self
    def __exit__(self,exc_type,exc_val,exc_tb):
      self.__del__()
    def _dispose_(self):
      self.__del__()
  
    def _task_1setDataCallbackHandler_LSystem_4DataCallbackHandler_2(self,handler):
      self.__user_cb = handler
    def _task_1setCallbackHandler_LSystem_4CallbackHandler_2(self,handler):
      self.__user_pgs = handler
  
    def _task_1setLogHandler_LSystem_4StreamWriter_2(self,handler):
      """
      Set the object to handle log output from the solver.
  
      The handler object must have a write method accepting a string.
      """
      self.__logwriter = handler
  
    def _task_1put_1param_SS(self,name,value):
      self.__task.putnastrparam(name,value)
    def _task_1put_1param_SD(self,name,value):
      self.__task.putnadouparam(name,value)
    def _task_1put_1param_SI(self,name,value):
      self.__task.putnaintparam(name,value)
  
    def _task_1get_1dinf_S(self,name):
      key = mosek_fusion_SolverInfo._getdouinf(name)
      if key is None:
        raise NameError("Invalid double info name '%s'" % name)
      else:
        return self.__task.getdouinf(key)
  
    def _task_1get_1iinf_S(self,name):
      key = mosek_fusion_SolverInfo._getintinf(name)
      if key is None:
        raise NameError("Invalid integer info name '%s'" % name)
      else:
        return self.__task.getintinf(key)
  
    def _task_1get_1liinf_S(self,name):
      key = mosek_fusion_SolverInfo._getlintinf(name)
      if key is None:
        raise NameError("Invalid long integer info name '%s'" % name)
      else:
        return self.__task.getlintinf(key)
  
    def _numVariables_ (self):
      return len(self.__vars)
    def _numConstraints_ (self):
      return len(self.__cons)
    
    def _alloc_1rangedvar_SDD(self,name,lb,ub):
      n = self.__task.getnumvar()
      self.__task.appendvars(1)
      if name is not None:
          self.__task.putvarname(n,name)
      self.__task.putbound(mosek.accmode.var, n, mosek.boundkey.ra, lb, ub)
      return n
    
    def _alloc_1linearvar_SEmosek_4fusion_4RelationKey_2D(self,name,relkey,bnd):
      task = self.__task
      n = task.getnumvar();
      task.appendvars(1)
      if name is not None:
          task.putvarname(n,name)
  
      if   relkey is mosek_fusion_RelationKey.IsFree:
        task.putbound(mosek.accmode.var, n, mosek.boundkey.fr, 0.0, 0.0)
      elif relkey is mosek_fusion_RelationKey.LessThan:
        task.putbound(mosek.accmode.var, n, mosek.boundkey.up, 0.0, bnd)
      elif relkey is mosek_fusion_RelationKey.GreaterThan:
        task.putbound(mosek.accmode.var, n, mosek.boundkey.lo, bnd, 0.0)
      else:
        task.putbound(mosek.accmode.var, n, mosek.boundkey.fx, bnd, bnd)
      return n
  
    def _task_1con_1name_IS(self,idx,name):
      self.__task.putconname(idx,name)
    def _task_1var_1name_IS(self,idx, name):
      self.__task.putvarname(idx,name)
    
    def _task_1cone_1name_IS(self,idx,name):
      self.__task.putconename(idx,name)
  
    def _task_1numcon_(self):
      return self.__task.getnumcon()
    def _task_1numvar_(self):
      return self.__task.getnumvar()
    def _task_1numcone_(self):
      return self.__task.getnumcone()
    
    def __task_putboundslice(self,acc,first,last,bl,bu,bk):  
      num = int(last-first)
      if bl is None: bl = numpy.zeros((num,),float)
      if bu is None: bu = numpy.zeros((num,),float)
      
      bka = [bk] * num
      self.__task.putboundslice(acc,first,last,bka,bl,bu)
    
  
    def __task_putboundlist(self,acc,idxs,bl,bu,bk):
      num = len(idxs)
      if bl is None: bl = numpy.zeros((num,),float)
      if bu is None: bu = numpy.zeros((num,),float)
  
      bka = [bk] * num
      self.__task.putboundlist(acc,idxs,bka,bl,bu)
    
    def _task_1con_1putboundslice_1fx_II_3D(self,first, last, rhs):
      self.__task_putboundslice(mosek.accmode.con, first, last, rhs, rhs, mosek.boundkey.fx);
    
    def _task_1con_1putboundslice_1lo_II_3D(self,first, last, rhs):
      self.__task_putboundslice(mosek.accmode.con, first, last, rhs, rhs, mosek.boundkey.lo);
    
    def _task_1con_1putboundslice_1up_II_3D(self,first, last, rhs):
      self.__task_putboundslice(mosek.accmode.con, first, last, rhs, rhs, mosek.boundkey.up);
    
    def _task_1con_1putboundslice_1ra_II_3D_3D(self,first, last, lb, ub):
      self.__task_putboundslice(mosek.accmode.con, first, last, lb, ub, mosek.boundkey.ra);
    
    def _task_1con_1putboundslice_1fr_II(self,first, last):
      self.__task_putboundslice(mosek.accmode.con, first, last, None, None, mosek.boundkey.fr);
    
    def _task_1var_1putboundslice_1fx_II_3D(self,first, last, rhs):
      self.__task_putboundslice(mosek.accmode.var, first, last, rhs, rhs, mosek.boundkey.fx);
    
    def _task_1var_1putboundslice_1lo_II_3D(self,first, last, rhs):
      self.__task_putboundslice(mosek.accmode.var, first, last, rhs, rhs, mosek.boundkey.lo);
    
    def _task_1var_1putboundslice_1up_II_3D(self,first, last, rhs):
      self.__task_putboundslice(mosek.accmode.var, first, last, rhs, rhs, mosek.boundkey.up);
    
    def _task_1var_1putboundslice_1ra_II_3D_3D(self,first, last, lb, ub):
      self.__task_putboundslice(mosek.accmode.var, first, last, lb, ub, mosek.boundkey.ra);
  
    def _task_1var_1putboundslice_1fr_II(self,first, last):
      self.__task_putboundslice(mosek.accmode.var, first, last, None, None, mosek.boundkey.fr);
                                                                    
    def _task_1con_1putboundlist_1fx__3I_3D(self,idxs, rhs):
      self.__task_putboundlist(mosek.accmode.con, idxs, rhs, rhs, mosek.boundkey.fx);
    
    def _task_1con_1putboundlist_1lo__3I_3D(self,idxs, rhs):
      self.__task_putboundlist(mosek.accmode.con, idxs, rhs, rhs, mosek.boundkey.lo);
    
    def _task_1con_1putboundlist_1up__3I_3D(self,idxs, rhs):
      self.__task_putboundlist(mosek.accmode.con, idxs, rhs, rhs, mosek.boundkey.up);
    
    def _task_1con_1putboundlist_1ra__3I_3D_3D(self,idxs, lb, ub):
      self.__task_putboundlist(mosek.accmode.con, idxs, lb, ub, mosek.boundkey.ra);
  
    def _task_1var_1putintlist__3I(self,idxs):
      self.__task.putvartypelist(idxs,[mosek.variabletype.type_int] * len(idxs))
    def _task_1var_1putcontlist__3I(self,idxs):
      self.__task.putvartypelist(idxs,[mosek.variabletype.type_cont] * len(idxs))
    
    
    def _task_1task_1optimize_ (self):
      try:
        self.__task.optimize()
        self.__task.solutionsummary(streamtype.log)
      except mosek.Error, e:
        raise OptimizeError("Error occurred while optimizeing")
      except mosek.Warning,e:
        pass
    
    def __task_appendvars(self,num):
      idx = self.__task.getnumvar()
      self.__task.appendvars(num)
      return idx
  
    def __task_appendcons(self,num):
      idx = self.__task.getnumcon()
      self.__task.appendcons(num)
      return idx
  
    def __task_appendcones(self,ct,conesize,first,num,d0,d1):
      idx = self.__task.getnumcone()
  
      for k0 in range(d0):
        subj = numpy.arange(0,conesize*d1,d1)+k0*d1*conesize+first
        for k1 in range(d1):
          self.__task.appendcone(ct, 0.0, subj)
          subj += d1
  
      return idx
    
    def _task_1append_1var_I(self,num):
      return self.__task_appendvars(num)
  
    def _task_1append_1con_I(self,num):
      return self.__task_appendcons(num)
  
    def _task_1append_1quadcone_IIIII(self,conesize,first,num,d0,d1):
      return self.__task_appendcones(mosek.conetype.quad, conesize, first,num,d0,d1);
  
    def _task_1append_1rquadcone_IIIII(self,conesize,first,num,d0,d1):
      return self.__task_appendcones(mosek.conetype.rquad, conesize, first,num,d0,d1)
    
    def _task_1putarowslice_II_3J_3I_3D(self,first, last, ptrb, subj, cof):
      num   = last-first
      sub   = numpy.arange(first,last)
      self.__task.putarowlist(sub, ptrb[:-1], ptrb[1:], subj, cof);
  
    def _task_1putaijlist__3I_3I_3DJ(self,subi,subj,cof,num):
      self.__task.putaijlist(subi[:num],subj[:num],cof[:num])
    
    def _task_1putobjectivename_S(self,name):
      self.__task.putobjname("" if name is None else name)
      
    # note: subj must not contain duplicates
    def _task_1putobjective_Z_3I_3DD(self,maximize,subj,cof,cfix):
      c = numpy.zeros((self.__task.getnumvar(),),numpy.float64)
      idxs = numpy.arange(0,len(c),dtype=numpy.int32)
      for i in xrange(len(subj)):
        c[subj[i]] += cof[i]
      self.__task.putclist(idxs,c)
      self.__task.putcfix(cfix)
      self.__task.putobjsense(mosek.objsense.maximize if maximize else mosek.objsense.minimize)
  
  
    def _task_1putbaraij_III(self,i,j,k):
      self.__task.putbaraij(i,j,[k], [1.0])
    def _task_1putbarcj_II(self,j,k):
      self.__task.putbarcj(j,[k],[1.0])
    
    def _task_1putbaraij_II_3I(self,i,j,k):
      self.__task.putbaraij(i,j,k, [1.0]*len(k))
    def _task_1putbarcj_I_3I(self,j,k):
      self.__task.putbarcj(j,k,[1.0]*len(k))
  
    def _task_1append_1barmatrix_I_3I_3I_3D(self,dim,subi, subj, cof):
      return self.__task.appendsparsesymmat(dim,subi,subj,cof)
  
    def _task_1barvardim_I(self,index):
      return self.__task.getdimbarvarj(index)
  
    def _task_1numbarvar_(self):
      return self.__task.getnumbarvar()
  
    def _task_1barvar_1name_IS(self, idx, name):
      self.__task.putbarvarname(idx,name)
  
    def _task_1append_1barvar_II(self,size, num):
      res = self.__task.getnumbarvar()
      self.__task.appendbarvars([size] * num)
      return res
  
    def _task_1setnumvar_I(self,num):
      numvar = self.__task.getnumvar()
      if numvar > num:
        self.__task.removevars(range(num,numvar))
  
  
    def _task_1putxx_1slice_Emosek_4fusion_4SolutionType_2II_3D(self,whichsol,first,last,xx):
      if   whichsol == mosek_fusion_SolutionType.Interior:
        self.__task.putxxslice(mosek.soltype.itr, first,last,xx)
      elif whichsol == mosek_fusion_SolutionType.Integer:
        self.__task.putxxslice(mosek.soltype.itg, first,last,xx)
      elif whichsol == mosek_fusion_SolutionType.Basic:
        self.__task.putxxslice(mosek.soltype.bas, first,last,xx)
      
    def _task_1cleanup_IIII(self,inumvar,inumcon,inumcone,inumbarvar):
      numvar  = self.__task.getnumvar()
      numcon  = self.__task.getnumcon()
      numcone = self.__task.getnumcone()
      numbarvar = self.__task.getnumbarvar()
  
      if inumcone < numcone:
        self.__task.removecones(range(inumcone,numcone))
  
      if inumvar < numvar:
        n    = numvar-inumvar
        vals = numpy.zeros((n,), numpy.float64)
        bk   = [ mosek.boundkey.fx for i in range(n) ]
        self.__task.putvarboundslice(inumvar,numvar,bk, vals, vals)
  
      if (inumcon < numcon):
        idxs = numpy.arange(inumcon,numcon,numpy.int32)
        self.__task.removecons(idxs)
  
      if (inumbarvar < numbarvar):
        self.__task.removebarvars(range(inumbarvar,numbarvar))
      
    @staticmethod
    def __convertSolutionStatus(soltype,sol,status,prosta):
      pd = { 
          mosek.solsta.optimal :                    mosek_fusion_SolutionStatus.Optimal,
          mosek.solsta.near_optimal :               mosek_fusion_SolutionStatus.NearOptimal,
          mosek.solsta.integer_optimal :            mosek_fusion_SolutionStatus.Optimal,
          mosek.solsta.near_integer_optimal :       mosek_fusion_SolutionStatus.NearOptimal,
          mosek.solsta.prim_and_dual_feas :         mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.near_prim_and_dual_feas :    mosek_fusion_SolutionStatus.NearFeasible,
          mosek.solsta.prim_feas :                  mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.near_prim_feas :             mosek_fusion_SolutionStatus.NearFeasible,
          mosek.solsta.dual_feas :                  mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.near_dual_feas :             mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.prim_infeas_cer :            mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.dual_infeas_cer :            mosek_fusion_SolutionStatus.Certificate,
          mosek.solsta.near_prim_infeas_cer :       mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.near_dual_infeas_cer :       mosek_fusion_SolutionStatus.NearCertificate,
          mosek.solsta.prim_illposed_cer :          mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.dual_illposed_cer :          mosek_fusion_SolutionStatus.IllposedCert,
      }
  
      dd = {
          mosek.solsta.optimal :                    mosek_fusion_SolutionStatus.Optimal,
          mosek.solsta.near_optimal :               mosek_fusion_SolutionStatus.NearOptimal,
          mosek.solsta.integer_optimal :            mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.near_integer_optimal :       mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.prim_and_dual_feas :         mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.near_prim_and_dual_feas :    mosek_fusion_SolutionStatus.NearFeasible,
          mosek.solsta.prim_feas :                  mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.near_prim_feas :             mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.dual_feas :                  mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.near_dual_feas :             mosek_fusion_SolutionStatus.NearFeasible,
          mosek.solsta.prim_infeas_cer :            mosek_fusion_SolutionStatus.Certificate,
          mosek.solsta.dual_infeas_cer :            mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.near_prim_infeas_cer :       mosek_fusion_SolutionStatus.NearCertificate,
          mosek.solsta.near_dual_infeas_cer :       mosek_fusion_SolutionStatus.Unknown,
  
          mosek.solsta.prim_illposed_cer :          mosek_fusion_SolutionStatus.IllposedCert,
          mosek.solsta.dual_illposed_cer :          mosek_fusion_SolutionStatus.Unknown,
      }
  
      psd = {
          mosek.prosta.unknown  :                   mosek_fusion_ProblemStatus.Unknown,
          mosek.prosta.prim_and_dual_feas :         mosek_fusion_ProblemStatus.PrimalAndDualFeasible,
          mosek.prosta.prim_feas :                  mosek_fusion_ProblemStatus.PrimalFeasible,
          mosek.prosta.dual_feas :                  mosek_fusion_ProblemStatus.DualFeasible,
          mosek.prosta.prim_infeas :                mosek_fusion_ProblemStatus.PrimalInfeasible,
          mosek.prosta.dual_infeas :                mosek_fusion_ProblemStatus.DualInfeasible,
          mosek.prosta.prim_and_dual_infeas :       mosek_fusion_ProblemStatus.PrimalAndDualInfeasible,
          mosek.prosta.ill_posed :                  mosek_fusion_ProblemStatus.IllPosed,
          mosek.prosta.near_prim_and_dual_feas :    mosek_fusion_ProblemStatus.PrimalAndDualInfeasible,
          mosek.prosta.near_prim_feas :             mosek_fusion_ProblemStatus.PrimalInfeasible,
          mosek.prosta.near_dual_feas :             mosek_fusion_ProblemStatus.DualInfeasible,
          mosek.prosta.prim_infeas_or_unbounded :   mosek_fusion_ProblemStatus.PrimalInfeasibleOrUnbounded,
        }
  
      try: sol.pstatus = pd[status]
      except KeyError: sol.pstatus = mosek_fusion_SolutionStatus.Unknown
      
      try: sol.dstatus = dd[status]
      except KeyError: sol.dstatus = mosek_fusion_SolutionStatus.Unknown
  
      try: sol.probstatus = psd[prosta]
      except KeyError: sol.probstatus = mosek_fusion_SolutionStatus.Unknown
  
  
    @staticmethod
    def _matchargs_task_1write_S(self,*args):
        return True
    def _task_1write_S(self,filename):
        self.__task.putintparam(mosek.iparam.opf_write_solutions, 1)
        self.__task.putintparam(mosek.iparam.write_ignore_incompatible_items, 1)
        self.__task.writedata(filename)
    
    def _task_1write(self,filename):
      return self._writeProblem_S(filename)
   
    def _task_1get_(self):
      return self.__task
        
    def _task_1break_1solve_(self):
      self.__break = True
  
    @staticmethod
    def _matchargs_task_1solve_(self,*args):
      return True
    def _task_1solve_(self):
      task = self.__task
      ok = False
      try:
        trmcode = mosek.rescode.ok
        try:
          self.__break = False
          trmcode = task.optimize()        
        except mosek.Error,e:
          raise mosek_fusion_OptimizeError(e.msg)
        except mosek.Warning,e:
          pass
        
        numcon  = task.getnumcon()
        numvar  = task.getnumvar()
        numcone = task.getnumcone()
        numbarvar = task.getnumbarvar()
        
        sol_bas_def = 0 != task.solutiondef(mosek.soltype.bas)
        sol_itr_def = 0 != task.solutiondef(mosek.soltype.itr)
        sol_itg_def = 0 != task.solutiondef(mosek.soltype.itg)
  
        self._sol_itr = None
        self._sol_bas = None
        self._sol_itg = None 
  
        if sol_itr_def:
          self._sol_itr = mosek_fusion_SolutionStruct(numvar,numcon,numcone,numbarvar)
          sol_itr = self._sol_itr
          prosta,solsta = task.getsolution(
            mosek.soltype.itr,
            #sol_itr.skc,sol_itr.skx,sol_itr.skn,
            None,None,None,
            sol_itr.xc,sol_itr.xx,sol_itr.y,
            sol_itr.slc,sol_itr.suc,
            sol_itr.slx,sol_itr.sux,
            sol_itr.snx)
          for j in xrange(numbarvar):
            barxjdim = task.getdimbarvarj(j)
            self._sol_itr.barx[j] = numpy.zeros(barxjdim * (barxjdim + 1) / 2, numpy.float64)
            self._sol_itr.bars[j] = numpy.zeros(barxjdim * (barxjdim + 1) / 2, numpy.float64)
            task.getbarxj(mosek.soltype.itr, j, self._sol_itr.barx[j])
            task.getbarsj(mosek.soltype.itr, j, self._sol_itr.bars[j])
  
          sol_itr.pobj = task.getprimalobj(mosek.soltype.itr)
          sol_itr.dobj = task.getdualobj  (mosek.soltype.itr)
          self.__convertSolutionStatus(mosek.soltype.itr, sol_itr, solsta,prosta);
          #print "got itr sol, stat = %s/%s" % (sol_itr.pstatus,sol_itr.dstatus)
  
        if sol_bas_def:
          self._sol_bas = mosek_fusion_SolutionStruct(numvar,numcon,numcone,numbarvar);
          sol_bas = self._sol_bas
          prosta,solsta = task.getsolution(
            mosek.soltype.bas,
            #sol_bas.skc,sol_bas.skx,sol_bas.skn,
            None,None,None,
            sol_bas.xc,sol_bas.xx,sol_bas.y,
            sol_bas.slc,sol_bas.suc,
            sol_bas.slx,sol_bas.sux,
            sol_bas.snx)
          
          # NOTE: this probably never happens:
          for j in xrange(numbarvar):
            barxjdim = task.getdimbarvarj(j)
            self._sol_bas.barx[j] = numpy.zeros(barxjdim * (barxjdim + 1) / 2,numpy.float64)
            self._sol_bas.bars[j] = numpy.zeros(barxjdim * (barxjdim + 1) / 2,numpy.float64)
            task.getbarxj(mosek.soltype.bas, j, self._sol_bas.barx[j])
            task.getbarsj(mosek.soltype.bas, j, self._sol_bas.bars[j])
  
          sol_bas.pobj = task.getprimalobj(mosek.soltype.bas)
          sol_bas.dobj = task.getdualobj  (mosek.soltype.bas)
          self.__convertSolutionStatus(mosek.soltype.bas, sol_bas, solsta,prosta);
  
          #print "got bas sol, stat = %s/%s" % (sol_bas.pstatus,sol_bas.dstatus)
  
        if sol_itg_def:
          self._sol_itg = mosek_fusion_SolutionStruct(numvar,numcon,numcone,numbarvar);
          sol_itg = self._sol_itg
          prosta,solsta = task.getsolution(
            mosek.soltype.itg,
            #sol_itg.skc,sol_itg.skx,sol_itg.skn,
            None,None,None,
            sol_itg.xc,sol_itg.xx,sol_itg.y,
            sol_itg.slc,sol_itg.suc,
            sol_itg.slx,sol_itg.sux,
            sol_itg.snx)
  
          # NOTE: this probably wont happen for a long time:
          for j in xrange(numbarvar):
            barxjdim = task.getdimbarvarj(j)
            self._sol_itg.barx[j] = numpy.zeros(barxjdim * (barxjdim + 1) / 2,numpy.float64)
            self._sol_itg.bars[j] = numpy.zeros(barxjdim * (barxjdim + 1) / 2,numpy.float64)
            task.getbarxj(mosek.soltype.itg, j, self._sol_itg.barx[j])
            task.getbarsj(mosek.soltype.itg, j, self._sol_itg.bars[j])
  
          sol_itg.pobj = task.getprimalobj(mosek.soltype.itg)
          self.__convertSolutionStatus(mosek.soltype.itg, sol_itg, solsta,prosta);
        ok = True
      
      finally:
        if not ok: # means exception
          self._sol_itr = None
          self._sol_bas = None
          self._sol_itg = None
  
    @staticmethod
    def _env_1syeig_I_3D_3D(n,a,w): BaseModel._globalEnv().syeig(n,a,w)
    @staticmethod
    def _env_1syevd_I_3D_3D(n,a,w): BaseModel._globalEnv().syevd(n,a,w)
    #@staticmethod
    #def _env_1potrf_I_3D(n,a):      BaseModel._globalEnv().potrf(n,a)
  
  return BaseModel
mosek_fusion_BaseModel=__mk_mosek_fusion_BaseModel()
#BEFORE CLASS
def __mk_mosek_fusion_Model():
 class Model(mosek_fusion_BaseModel):
  __slots__ = ['_Model__task_vars_used','_Model__task_vars_allocated','_Model__con_map','_Model__cons_used','_Model__cons','_vars_used','_vars','_Model__initsol_xx_flag','_Model__initsol_xx','_natbarvarmap_num','_natbarvarmap_Var','_Model__var_map','_Model__natvarmap_num','_Model__natvarmap_idx','_Model__natvarmap_Var','_Model__solutionptr','_Model__acceptable_sol','_Model__model_name']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_(*args): # 
      self._ctor_init_(*args)
    elif self.__match_alt_ctor_(*args):# 
      self._ctor_alt_init_(*args)
    elif self.__match_ctor_S(*args): # string
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):# string
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.Model.ctor()\n\tmosek.fusion.Model.ctor(string)')
  def acceptedSolutionStatus(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(*args): # mosek.fusion.AccSolutionStatus
      return self._acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(*args)
    elif mosek_fusion_Model._match_alt_acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(*args): # mosek.fusion.AccSolutionStatus
      return self._acceptedSolutionStatus_alt_Emosek_4fusion_4AccSolutionStatus_2(*args)
    else:
      raise ValueError('Invalid argument list acceptedSolutionStatus('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.acceptedSolutionStatus(mosek.fusion.AccSolutionStatus)')
  def dualObjValue(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_dualObjValue_(*args): # 
      return self._dualObjValue_(*args)
    elif mosek_fusion_Model._match_alt_dualObjValue_(*args): # 
      return self._dualObjValue_alt_(*args)
    else:
      raise ValueError('Invalid argument list dualObjValue('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.dualObjValue()')
  def dispose(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_dispose_(*args): # 
      return self._dispose_(*args)
    elif mosek_fusion_Model._match_alt_dispose_(*args): # 
      return self._dispose_alt_(*args)
    else:
      raise ValueError('Invalid argument list dispose('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.dispose()')
  def objective(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_objective_D(*args): # double
      return self._objective_D(*args)
    elif mosek_fusion_Model._match_alt_objective_D(*args): # double
      return self._objective_alt_D(*args)
    elif mosek_fusion_Model._match_objective_SD(*args): # string,double
      return self._objective_SD(*args)
    elif mosek_fusion_Model._match_alt_objective_SD(*args): # string,double
      return self._objective_alt_SD(*args)
    elif mosek_fusion_Model._match_objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.ObjectiveSense,mosek.fusion.Variable
      return self._objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Model._match_alt_objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.ObjectiveSense,mosek.fusion.Variable
      return self._objective_alt_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Model._match_objective_Emosek_4fusion_4ObjectiveSense_2D(*args): # mosek.fusion.ObjectiveSense,double
      return self._objective_Emosek_4fusion_4ObjectiveSense_2D(*args)
    elif mosek_fusion_Model._match_alt_objective_Emosek_4fusion_4ObjectiveSense_2D(*args): # mosek.fusion.ObjectiveSense,double
      return self._objective_alt_Emosek_4fusion_4ObjectiveSense_2D(*args)
    elif mosek_fusion_Model._match_objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args): # mosek.fusion.ObjectiveSense,mosek.fusion.Expression
      return self._objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_Model._match_alt_objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args): # mosek.fusion.ObjectiveSense,mosek.fusion.Expression
      return self._objective_alt_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_Model._match_objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args): # string,mosek.fusion.ObjectiveSense,mosek.fusion.Expression
      return self._objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_Model._match_alt_objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args): # string,mosek.fusion.ObjectiveSense,mosek.fusion.Expression
      return self._objective_alt_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_Model._match_objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(*args): # string,mosek.fusion.ObjectiveSense,mosek.fusion.Variable
      return self._objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Model._match_alt_objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(*args): # string,mosek.fusion.ObjectiveSense,mosek.fusion.Variable
      return self._objective_alt_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Model._match_objective_SEmosek_4fusion_4ObjectiveSense_2D(*args): # string,mosek.fusion.ObjectiveSense,double
      return self._objective_SEmosek_4fusion_4ObjectiveSense_2D(*args)
    elif mosek_fusion_Model._match_alt_objective_SEmosek_4fusion_4ObjectiveSense_2D(*args): # string,mosek.fusion.ObjectiveSense,double
      return self._objective_alt_SEmosek_4fusion_4ObjectiveSense_2D(*args)
    else:
      raise ValueError('Invalid argument list objective('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.objective(double)\n\tmosek.fusion.Model.objective(string,double)\n\tmosek.fusion.Model.objective(mosek.fusion.ObjectiveSense,mosek.fusion.Variable)\n\tmosek.fusion.Model.objective(mosek.fusion.ObjectiveSense,double)\n\tmosek.fusion.Model.objective(mosek.fusion.ObjectiveSense,mosek.fusion.Expression)\n\tmosek.fusion.Model.objective(string,mosek.fusion.ObjectiveSense,mosek.fusion.Expression)\n\tmosek.fusion.Model.objective(string,mosek.fusion.ObjectiveSense,mosek.fusion.Variable)\n\tmosek.fusion.Model.objective(string,mosek.fusion.ObjectiveSense,double)')
  def getConstraint(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getConstraint_S(*args): # string
      return self._getConstraint_S(*args)
    elif mosek_fusion_Model._match_alt_getConstraint_S(*args): # string
      return self._getConstraint_alt_S(*args)
    elif mosek_fusion_Model._match_getConstraint_I(*args): # int32
      return self._getConstraint_I(*args)
    elif mosek_fusion_Model._match_alt_getConstraint_I(*args): # int32
      return self._getConstraint_alt_I(*args)
    else:
      raise ValueError('Invalid argument list getConstraint('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getConstraint(string)\n\tmosek.fusion.Model.getConstraint(int32)')
  def getName(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getName_(*args): # 
      return self._getName_(*args)
    elif mosek_fusion_Model._match_alt_getName_(*args): # 
      return self._getName_alt_(*args)
    else:
      raise ValueError('Invalid argument list getName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getName()')
  def setCallbackHandler(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_setCallbackHandler_LSystem_4CallbackHandler_2(*args): # System.CallbackHandler
      return self._setCallbackHandler_LSystem_4CallbackHandler_2(*args)
    elif mosek_fusion_Model._match_alt_setCallbackHandler_LSystem_4CallbackHandler_2(*args): # System.CallbackHandler
      return self._setCallbackHandler_alt_LSystem_4CallbackHandler_2(*args)
    else:
      raise ValueError('Invalid argument list setCallbackHandler('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.setCallbackHandler(System.CallbackHandler)')
  @staticmethod
  def putlicensecode(*args):
    if False: pass
    elif mosek_fusion_Model._match_putlicensecode__3I(*args): # []int32
      return mosek_fusion_Model._putlicensecode__3I(*args)
    elif mosek_fusion_Model._match_alt_putlicensecode__3I(*args): # []int32
      return mosek_fusion_Model._putlicensecode_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list putlicensecode('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.putlicensecode(array(int32,ndim=1))')
  def breakSolver(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_breakSolver_(*args): # 
      return self._breakSolver_(*args)
    elif mosek_fusion_Model._match_alt_breakSolver_(*args): # 
      return self._breakSolver_alt_(*args)
    else:
      raise ValueError('Invalid argument list breakSolver('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.breakSolver()')
  def flushNames(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_flushNames_(*args): # 
      return self._flushNames_(*args)
    elif mosek_fusion_Model._match_alt_flushNames_(*args): # 
      return self._flushNames_alt_(*args)
    else:
      raise ValueError('Invalid argument list flushNames('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.flushNames()')
  def clone(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_clone_(*args): # 
      return self._clone_(*args)
    elif mosek_fusion_Model._match_alt_clone_(*args): # 
      return self._clone_alt_(*args)
    else:
      raise ValueError('Invalid argument list clone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.clone()')
  def writeTask(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_writeTask_S(*args): # string
      return self._writeTask_S(*args)
    elif mosek_fusion_Model._match_alt_writeTask_S(*args): # string
      return self._writeTask_alt_S(*args)
    else:
      raise ValueError('Invalid argument list writeTask('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.writeTask(string)')
  @staticmethod
  def putlicensepath(*args):
    if False: pass
    elif mosek_fusion_Model._match_putlicensepath_S(*args): # string
      return mosek_fusion_Model._putlicensepath_S(*args)
    elif mosek_fusion_Model._match_alt_putlicensepath_S(*args): # string
      return mosek_fusion_Model._putlicensepath_alt_S(*args)
    else:
      raise ValueError('Invalid argument list putlicensepath('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.putlicensepath(string)')
  def getSolverDoubleInfo(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getSolverDoubleInfo_S(*args): # string
      return self._getSolverDoubleInfo_S(*args)
    elif mosek_fusion_Model._match_alt_getSolverDoubleInfo_S(*args): # string
      return self._getSolverDoubleInfo_alt_S(*args)
    else:
      raise ValueError('Invalid argument list getSolverDoubleInfo('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getSolverDoubleInfo(string)')
  def numVariables(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_numVariables_(*args): # 
      return self._numVariables_(*args)
    elif mosek_fusion_Model._match_alt_numVariables_(*args): # 
      return self._numVariables_alt_(*args)
    else:
      raise ValueError('Invalid argument list numVariables('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.numVariables()')
  def variable(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_variable_(*args): # 
      return self._variable_(*args)
    elif mosek_fusion_Model._match_alt_variable_(*args): # 
      return self._variable_alt_(*args)
    elif mosek_fusion_Model._match_variable_S(*args): # string
      return self._variable_S(*args)
    elif mosek_fusion_Model._match_alt_variable_S(*args): # string
      return self._variable_alt_S(*args)
    elif mosek_fusion_Model._match_variable_Lmosek_4fusion_4LinPSDDomain_2(*args): # mosek.fusion.LinPSDDomain
      return self._variable_Lmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_Lmosek_4fusion_4LinPSDDomain_2(*args): # mosek.fusion.LinPSDDomain
      return self._variable_alt_Lmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_Lmosek_4fusion_4LinearDomain_2(*args): # mosek.fusion.LinearDomain
      return self._variable_Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_Lmosek_4fusion_4LinearDomain_2(*args): # mosek.fusion.LinearDomain
      return self._variable_alt_Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_I(*args): # int32
      return self._variable_I(*args)
    elif mosek_fusion_Model._match_alt_variable_I(*args): # int32
      return self._variable_alt_I(*args)
    elif mosek_fusion_Model._match_variable__3I(*args): # []int32
      return self._variable__3I(*args)
    elif mosek_fusion_Model._match_alt_variable__3I(*args): # []int32
      return self._variable_alt__3I(*args)
    elif mosek_fusion_Model._match_variable_Lmosek_4fusion_4PSDDomain_2(*args): # mosek.fusion.PSDDomain
      return self._variable_Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_Lmosek_4fusion_4PSDDomain_2(*args): # mosek.fusion.PSDDomain
      return self._variable_alt_Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_Lmosek_4fusion_4QConeDomain_2(*args): # mosek.fusion.QConeDomain
      return self._variable_Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_Lmosek_4fusion_4QConeDomain_2(*args): # mosek.fusion.QConeDomain
      return self._variable_alt_Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_Lmosek_4fusion_4RangeDomain_2(*args): # mosek.fusion.RangeDomain
      return self._variable_Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_Lmosek_4fusion_4RangeDomain_2(*args): # mosek.fusion.RangeDomain
      return self._variable_alt_Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_ILmosek_4fusion_4LinearDomain_2(*args): # int32,mosek.fusion.LinearDomain
      return self._variable_ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_ILmosek_4fusion_4LinearDomain_2(*args): # int32,mosek.fusion.LinearDomain
      return self._variable_alt_ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4LinearDomain_2(*args): # string,mosek.fusion.LinearDomain
      return self._variable_SLmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4LinearDomain_2(*args): # string,mosek.fusion.LinearDomain
      return self._variable_alt_SLmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4QConeDomain_2(*args): # string,mosek.fusion.QConeDomain
      return self._variable_SLmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4QConeDomain_2(*args): # string,mosek.fusion.QConeDomain
      return self._variable_alt_SLmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable__3ILmosek_4fusion_4RangeDomain_2(*args): # []int32,mosek.fusion.RangeDomain
      return self._variable__3ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable__3ILmosek_4fusion_4RangeDomain_2(*args): # []int32,mosek.fusion.RangeDomain
      return self._variable_alt__3ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_ILmosek_4fusion_4SymmetricLinearDomain_2(*args): # int32,mosek.fusion.SymmetricLinearDomain
      return self._variable_ILmosek_4fusion_4SymmetricLinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_ILmosek_4fusion_4SymmetricLinearDomain_2(*args): # int32,mosek.fusion.SymmetricLinearDomain
      return self._variable_alt_ILmosek_4fusion_4SymmetricLinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SI(*args): # string,int32
      return self._variable_SI(*args)
    elif mosek_fusion_Model._match_alt_variable_SI(*args): # string,int32
      return self._variable_alt_SI(*args)
    elif mosek_fusion_Model._match_variable__3ILmosek_4fusion_4LinearDomain_2(*args): # []int32,mosek.fusion.LinearDomain
      return self._variable__3ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable__3ILmosek_4fusion_4LinearDomain_2(*args): # []int32,mosek.fusion.LinearDomain
      return self._variable_alt__3ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(*args): # mosek.fusion.Set,mosek.fusion.QConeDomain
      return self._variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(*args): # mosek.fusion.Set,mosek.fusion.QConeDomain
      return self._variable_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_ILmosek_4fusion_4LinPSDDomain_2(*args): # int32,mosek.fusion.LinPSDDomain
      return self._variable_ILmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_ILmosek_4fusion_4LinPSDDomain_2(*args): # int32,mosek.fusion.LinPSDDomain
      return self._variable_alt_ILmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_S_3I(*args): # string,[]int32
      return self._variable_S_3I(*args)
    elif mosek_fusion_Model._match_alt_variable_S_3I(*args): # string,[]int32
      return self._variable_alt_S_3I(*args)
    elif mosek_fusion_Model._match_variable_ILmosek_4fusion_4RangeDomain_2(*args): # int32,mosek.fusion.RangeDomain
      return self._variable_ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_ILmosek_4fusion_4RangeDomain_2(*args): # int32,mosek.fusion.RangeDomain
      return self._variable_alt_ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(*args): # mosek.fusion.Set,mosek.fusion.LinearDomain
      return self._variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(*args): # mosek.fusion.Set,mosek.fusion.LinearDomain
      return self._variable_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_ILmosek_4fusion_4PSDDomain_2(*args): # int32,mosek.fusion.PSDDomain
      return self._variable_ILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_ILmosek_4fusion_4PSDDomain_2(*args): # int32,mosek.fusion.PSDDomain
      return self._variable_alt_ILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4RangeDomain_2(*args): # string,mosek.fusion.RangeDomain
      return self._variable_SLmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4RangeDomain_2(*args): # string,mosek.fusion.RangeDomain
      return self._variable_alt_SLmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4LinPSDDomain_2(*args): # string,mosek.fusion.LinPSDDomain
      return self._variable_SLmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4LinPSDDomain_2(*args): # string,mosek.fusion.LinPSDDomain
      return self._variable_alt_SLmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(*args): # mosek.fusion.Set,mosek.fusion.RangeDomain
      return self._variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(*args): # mosek.fusion.Set,mosek.fusion.RangeDomain
      return self._variable_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_ILmosek_4fusion_4QConeDomain_2(*args): # int32,mosek.fusion.QConeDomain
      return self._variable_ILmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_ILmosek_4fusion_4QConeDomain_2(*args): # int32,mosek.fusion.QConeDomain
      return self._variable_alt_ILmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4PSDDomain_2(*args): # string,mosek.fusion.PSDDomain
      return self._variable_SLmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4PSDDomain_2(*args): # string,mosek.fusion.PSDDomain
      return self._variable_alt_SLmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_S_3ILmosek_4fusion_4LinearDomain_2(*args): # string,[]int32,mosek.fusion.LinearDomain
      return self._variable_S_3ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_S_3ILmosek_4fusion_4LinearDomain_2(*args): # string,[]int32,mosek.fusion.LinearDomain
      return self._variable_alt_S_3ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SILmosek_4fusion_4QConeDomain_2(*args): # string,int32,mosek.fusion.QConeDomain
      return self._variable_SILmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SILmosek_4fusion_4QConeDomain_2(*args): # string,int32,mosek.fusion.QConeDomain
      return self._variable_alt_SILmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.QConeDomain
      return self._variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.QConeDomain
      return self._variable_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.RangeDomain
      return self._variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.RangeDomain
      return self._variable_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SILmosek_4fusion_4LinPSDDomain_2(*args): # string,int32,mosek.fusion.LinPSDDomain
      return self._variable_SILmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SILmosek_4fusion_4LinPSDDomain_2(*args): # string,int32,mosek.fusion.LinPSDDomain
      return self._variable_alt_SILmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_S_3ILmosek_4fusion_4RangeDomain_2(*args): # string,[]int32,mosek.fusion.RangeDomain
      return self._variable_S_3ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_S_3ILmosek_4fusion_4RangeDomain_2(*args): # string,[]int32,mosek.fusion.RangeDomain
      return self._variable_alt_S_3ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_IILmosek_4fusion_4PSDDomain_2(*args): # int32,int32,mosek.fusion.PSDDomain
      return self._variable_IILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_IILmosek_4fusion_4PSDDomain_2(*args): # int32,int32,mosek.fusion.PSDDomain
      return self._variable_alt_IILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SILmosek_4fusion_4RangeDomain_2(*args): # string,int32,mosek.fusion.RangeDomain
      return self._variable_SILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SILmosek_4fusion_4RangeDomain_2(*args): # string,int32,mosek.fusion.RangeDomain
      return self._variable_alt_SILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SILmosek_4fusion_4PSDDomain_2(*args): # string,int32,mosek.fusion.PSDDomain
      return self._variable_SILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SILmosek_4fusion_4PSDDomain_2(*args): # string,int32,mosek.fusion.PSDDomain
      return self._variable_alt_SILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.PSDDomain
      return self._variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.PSDDomain
      return self._variable_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.LinearDomain
      return self._variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.LinearDomain
      return self._variable_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SILmosek_4fusion_4LinearDomain_2(*args): # string,int32,mosek.fusion.LinearDomain
      return self._variable_SILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SILmosek_4fusion_4LinearDomain_2(*args): # string,int32,mosek.fusion.LinearDomain
      return self._variable_alt_SILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SILmosek_4fusion_4SymmetricLinearDomain_2(*args): # string,int32,mosek.fusion.SymmetricLinearDomain
      return self._variable_SILmosek_4fusion_4SymmetricLinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SILmosek_4fusion_4SymmetricLinearDomain_2(*args): # string,int32,mosek.fusion.SymmetricLinearDomain
      return self._variable_alt_SILmosek_4fusion_4SymmetricLinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_IILmosek_4fusion_4LinPSDDomain_2(*args): # int32,int32,mosek.fusion.LinPSDDomain
      return self._variable_IILmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_IILmosek_4fusion_4LinPSDDomain_2(*args): # int32,int32,mosek.fusion.LinPSDDomain
      return self._variable_alt_IILmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.LinPSDDomain
      return self._variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.LinPSDDomain
      return self._variable_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SIILmosek_4fusion_4LinPSDDomain_2(*args): # string,int32,int32,mosek.fusion.LinPSDDomain
      return self._variable_SIILmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SIILmosek_4fusion_4LinPSDDomain_2(*args): # string,int32,int32,mosek.fusion.LinPSDDomain
      return self._variable_alt_SIILmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SIILmosek_4fusion_4PSDDomain_2(*args): # string,int32,int32,mosek.fusion.PSDDomain
      return self._variable_SIILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SIILmosek_4fusion_4PSDDomain_2(*args): # string,int32,int32,mosek.fusion.PSDDomain
      return self._variable_alt_SIILmosek_4fusion_4PSDDomain_2(*args)
    else:
      raise ValueError('Invalid argument list variable('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.variable()\n\tmosek.fusion.Model.variable(string)\n\tmosek.fusion.Model.variable(mosek.fusion.LinPSDDomain)\n\tmosek.fusion.Model.variable(mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(int32)\n\tmosek.fusion.Model.variable(array(int32,ndim=1))\n\tmosek.fusion.Model.variable(mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(mosek.fusion.QConeDomain)\n\tmosek.fusion.Model.variable(mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(int32,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.QConeDomain)\n\tmosek.fusion.Model.variable(array(int32,ndim=1),mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(int32,mosek.fusion.SymmetricLinearDomain)\n\tmosek.fusion.Model.variable(string,int32)\n\tmosek.fusion.Model.variable(array(int32,ndim=1),mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(mosek.fusion.Set,mosek.fusion.QConeDomain)\n\tmosek.fusion.Model.variable(int32,mosek.fusion.LinPSDDomain)\n\tmosek.fusion.Model.variable(string,array(int32,ndim=1))\n\tmosek.fusion.Model.variable(int32,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(mosek.fusion.Set,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(int32,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.LinPSDDomain)\n\tmosek.fusion.Model.variable(mosek.fusion.Set,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(int32,mosek.fusion.QConeDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(string,array(int32,ndim=1),mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(string,int32,mosek.fusion.QConeDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.Set,mosek.fusion.QConeDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.Set,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(string,int32,mosek.fusion.LinPSDDomain)\n\tmosek.fusion.Model.variable(string,array(int32,ndim=1),mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(int32,int32,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(string,int32,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(string,int32,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.Set,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.Set,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(string,int32,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(string,int32,mosek.fusion.SymmetricLinearDomain)\n\tmosek.fusion.Model.variable(int32,int32,mosek.fusion.LinPSDDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.Set,mosek.fusion.LinPSDDomain)\n\tmosek.fusion.Model.variable(string,int32,int32,mosek.fusion.LinPSDDomain)\n\tmosek.fusion.Model.variable(string,int32,int32,mosek.fusion.PSDDomain)')
  def setLogHandler(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_setLogHandler_LSystem_4StreamWriter_2(*args): # System.StreamWriter
      return self._setLogHandler_LSystem_4StreamWriter_2(*args)
    elif mosek_fusion_Model._match_alt_setLogHandler_LSystem_4StreamWriter_2(*args): # System.StreamWriter
      return self._setLogHandler_alt_LSystem_4StreamWriter_2(*args)
    else:
      raise ValueError('Invalid argument list setLogHandler('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.setLogHandler(System.StreamWriter)')
  @staticmethod
  def putlicensewait(*args):
    if False: pass
    elif mosek_fusion_Model._match_putlicensewait_Z(*args): # bool
      return mosek_fusion_Model._putlicensewait_Z(*args)
    elif mosek_fusion_Model._match_alt_putlicensewait_Z(*args): # bool
      return mosek_fusion_Model._putlicensewait_alt_Z(*args)
    else:
      raise ValueError('Invalid argument list putlicensewait('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.putlicensewait(bool)')
  def constraint(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args): # mosek.fusion.Expression,mosek.fusion.LinearDomain
      return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args): # mosek.fusion.Expression,mosek.fusion.LinearDomain
      return self._constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(*args): # mosek.fusion.Expression,mosek.fusion.LinPSDDomain
      return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(*args): # mosek.fusion.Expression,mosek.fusion.LinPSDDomain
      return self._constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args): # mosek.fusion.Variable,mosek.fusion.LinearDomain
      return self._constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args): # mosek.fusion.Variable,mosek.fusion.LinearDomain
      return self._constraint_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args): # mosek.fusion.Expression,mosek.fusion.PSDDomain
      return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args): # mosek.fusion.Expression,mosek.fusion.PSDDomain
      return self._constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args): # mosek.fusion.Variable,mosek.fusion.QConeDomain
      return self._constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args): # mosek.fusion.Variable,mosek.fusion.QConeDomain
      return self._constraint_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(*args): # mosek.fusion.Variable,mosek.fusion.LinPSDDomain
      return self._constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(*args): # mosek.fusion.Variable,mosek.fusion.LinPSDDomain
      return self._constraint_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args): # mosek.fusion.Expression,mosek.fusion.RangeDomain
      return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args): # mosek.fusion.Expression,mosek.fusion.RangeDomain
      return self._constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args): # mosek.fusion.Variable,mosek.fusion.RangeDomain
      return self._constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args): # mosek.fusion.Variable,mosek.fusion.RangeDomain
      return self._constraint_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(*args): # mosek.fusion.Variable,mosek.fusion.PSDDomain
      return self._constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(*args): # mosek.fusion.Variable,mosek.fusion.PSDDomain
      return self._constraint_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args): # mosek.fusion.Expression,mosek.fusion.QConeDomain
      return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args): # mosek.fusion.Expression,mosek.fusion.QConeDomain
      return self._constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(*args): # string,mosek.fusion.Variable,mosek.fusion.LinPSDDomain
      return self._constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(*args): # string,mosek.fusion.Variable,mosek.fusion.LinPSDDomain
      return self._constraint_alt_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args): # mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.LinearDomain
      return self._constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args): # mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.LinearDomain
      return self._constraint_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(*args): # string,mosek.fusion.Expression,mosek.fusion.LinPSDDomain
      return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(*args): # string,mosek.fusion.Expression,mosek.fusion.LinPSDDomain
      return self._constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args): # string,mosek.fusion.Expression,mosek.fusion.PSDDomain
      return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args): # string,mosek.fusion.Expression,mosek.fusion.PSDDomain
      return self._constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args): # mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.QConeDomain
      return self._constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args): # mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.QConeDomain
      return self._constraint_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args): # string,mosek.fusion.Expression,mosek.fusion.QConeDomain
      return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args): # string,mosek.fusion.Expression,mosek.fusion.QConeDomain
      return self._constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args): # mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.RangeDomain
      return self._constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args): # mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.RangeDomain
      return self._constraint_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(*args): # string,mosek.fusion.Variable,mosek.fusion.PSDDomain
      return self._constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(*args): # string,mosek.fusion.Variable,mosek.fusion.PSDDomain
      return self._constraint_alt_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args): # string,mosek.fusion.Expression,mosek.fusion.LinearDomain
      return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args): # string,mosek.fusion.Expression,mosek.fusion.LinearDomain
      return self._constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args): # mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.LinearDomain
      return self._constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args): # mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.LinearDomain
      return self._constraint_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args): # mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.QConeDomain
      return self._constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args): # mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.QConeDomain
      return self._constraint_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args): # string,mosek.fusion.Expression,mosek.fusion.RangeDomain
      return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args): # string,mosek.fusion.Expression,mosek.fusion.RangeDomain
      return self._constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args): # string,mosek.fusion.Variable,mosek.fusion.LinearDomain
      return self._constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args): # string,mosek.fusion.Variable,mosek.fusion.LinearDomain
      return self._constraint_alt_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args): # string,mosek.fusion.Variable,mosek.fusion.QConeDomain
      return self._constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args): # string,mosek.fusion.Variable,mosek.fusion.QConeDomain
      return self._constraint_alt_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args): # string,mosek.fusion.Variable,mosek.fusion.RangeDomain
      return self._constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args): # string,mosek.fusion.Variable,mosek.fusion.RangeDomain
      return self._constraint_alt_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args): # mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.RangeDomain
      return self._constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args): # mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.RangeDomain
      return self._constraint_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.QConeDomain
      return self._constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.QConeDomain
      return self._constraint_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.RangeDomain
      return self._constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.RangeDomain
      return self._constraint_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.LinearDomain
      return self._constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.LinearDomain
      return self._constraint_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.RangeDomain
      return self._constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.RangeDomain
      return self._constraint_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.LinearDomain
      return self._constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.LinearDomain
      return self._constraint_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.QConeDomain
      return self._constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args): # string,mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.QConeDomain
      return self._constraint_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args)
    else:
      raise ValueError('Invalid argument list constraint('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.LinPSDDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Variable,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Variable,mosek.fusion.QConeDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Variable,mosek.fusion.LinPSDDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Variable,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Variable,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.QConeDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Variable,mosek.fusion.LinPSDDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.LinPSDDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.QConeDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.QConeDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Variable,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.QConeDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Variable,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Variable,mosek.fusion.QConeDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Variable,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.QConeDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Set,mosek.fusion.Variable,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Set,mosek.fusion.Expression,mosek.fusion.QConeDomain)')
  def getTask(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getTask_(*args): # 
      return self._getTask_(*args)
    elif mosek_fusion_Model._match_alt_getTask_(*args): # 
      return self._getTask_alt_(*args)
    else:
      raise ValueError('Invalid argument list getTask('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getTask()')
  def hasConstraint(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_hasConstraint_S(*args): # string
      return self._hasConstraint_S(*args)
    elif mosek_fusion_Model._match_alt_hasConstraint_S(*args): # string
      return self._hasConstraint_alt_S(*args)
    else:
      raise ValueError('Invalid argument list hasConstraint('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.hasConstraint(string)')
  def setDataCallbackHandler(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_setDataCallbackHandler_LSystem_4DataCallbackHandler_2(*args): # System.DataCallbackHandler
      return self._setDataCallbackHandler_LSystem_4DataCallbackHandler_2(*args)
    elif mosek_fusion_Model._match_alt_setDataCallbackHandler_LSystem_4DataCallbackHandler_2(*args): # System.DataCallbackHandler
      return self._setDataCallbackHandler_alt_LSystem_4DataCallbackHandler_2(*args)
    else:
      raise ValueError('Invalid argument list setDataCallbackHandler('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.setDataCallbackHandler(System.DataCallbackHandler)')
  def hasVariable(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_hasVariable_S(*args): # string
      return self._hasVariable_S(*args)
    elif mosek_fusion_Model._match_alt_hasVariable_S(*args): # string
      return self._hasVariable_alt_S(*args)
    else:
      raise ValueError('Invalid argument list hasVariable('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.hasVariable(string)')
  def numConstraints(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_numConstraints_(*args): # 
      return self._numConstraints_(*args)
    elif mosek_fusion_Model._match_alt_numConstraints_(*args): # 
      return self._numConstraints_alt_(*args)
    else:
      raise ValueError('Invalid argument list numConstraints('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.numConstraints()')
  def getVariable(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getVariable_S(*args): # string
      return self._getVariable_S(*args)
    elif mosek_fusion_Model._match_alt_getVariable_S(*args): # string
      return self._getVariable_alt_S(*args)
    elif mosek_fusion_Model._match_getVariable_I(*args): # int32
      return self._getVariable_I(*args)
    elif mosek_fusion_Model._match_alt_getVariable_I(*args): # int32
      return self._getVariable_alt_I(*args)
    else:
      raise ValueError('Invalid argument list getVariable('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getVariable(string)\n\tmosek.fusion.Model.getVariable(int32)')
  def getAcceptedSolutionStatus(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getAcceptedSolutionStatus_(*args): # 
      return self._getAcceptedSolutionStatus_(*args)
    elif mosek_fusion_Model._match_alt_getAcceptedSolutionStatus_(*args): # 
      return self._getAcceptedSolutionStatus_alt_(*args)
    else:
      raise ValueError('Invalid argument list getAcceptedSolutionStatus('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getAcceptedSolutionStatus()')
  def selectedSolution(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_selectedSolution_Emosek_4fusion_4SolutionType_2(*args): # mosek.fusion.SolutionType
      return self._selectedSolution_Emosek_4fusion_4SolutionType_2(*args)
    elif mosek_fusion_Model._match_alt_selectedSolution_Emosek_4fusion_4SolutionType_2(*args): # mosek.fusion.SolutionType
      return self._selectedSolution_alt_Emosek_4fusion_4SolutionType_2(*args)
    else:
      raise ValueError('Invalid argument list selectedSolution('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.selectedSolution(mosek.fusion.SolutionType)')
  def flushSolutions(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_flushSolutions_(*args): # 
      return self._flushSolutions_(*args)
    elif mosek_fusion_Model._match_alt_flushSolutions_(*args): # 
      return self._flushSolutions_alt_(*args)
    else:
      raise ValueError('Invalid argument list flushSolutions('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.flushSolutions()')
  def getDualSolutionStatus(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getDualSolutionStatus_(*args): # 
      return self._getDualSolutionStatus_(*args)
    elif mosek_fusion_Model._match_alt_getDualSolutionStatus_(*args): # 
      return self._getDualSolutionStatus_alt_(*args)
    elif mosek_fusion_Model._match_getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(*args): # mosek.fusion.SolutionType
      return self._getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(*args)
    elif mosek_fusion_Model._match_alt_getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(*args): # mosek.fusion.SolutionType
      return self._getDualSolutionStatus_alt_Emosek_4fusion_4SolutionType_2(*args)
    else:
      raise ValueError('Invalid argument list getDualSolutionStatus('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getDualSolutionStatus()\n\tmosek.fusion.Model.getDualSolutionStatus(mosek.fusion.SolutionType)')
  def getProblemStatus(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getProblemStatus_Emosek_4fusion_4SolutionType_2(*args): # mosek.fusion.SolutionType
      return self._getProblemStatus_Emosek_4fusion_4SolutionType_2(*args)
    elif mosek_fusion_Model._match_alt_getProblemStatus_Emosek_4fusion_4SolutionType_2(*args): # mosek.fusion.SolutionType
      return self._getProblemStatus_alt_Emosek_4fusion_4SolutionType_2(*args)
    else:
      raise ValueError('Invalid argument list getProblemStatus('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getProblemStatus(mosek.fusion.SolutionType)')
  def primalObjValue(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_primalObjValue_(*args): # 
      return self._primalObjValue_(*args)
    elif mosek_fusion_Model._match_alt_primalObjValue_(*args): # 
      return self._primalObjValue_alt_(*args)
    else:
      raise ValueError('Invalid argument list primalObjValue('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.primalObjValue()')
  def solve(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_solve_(*args): # 
      return self._solve_(*args)
    elif mosek_fusion_Model._match_alt_solve_(*args): # 
      return self._solve_alt_(*args)
    else:
      raise ValueError('Invalid argument list solve('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.solve()')
  def getSolverIntInfo(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getSolverIntInfo_S(*args): # string
      return self._getSolverIntInfo_S(*args)
    elif mosek_fusion_Model._match_alt_getSolverIntInfo_S(*args): # string
      return self._getSolverIntInfo_alt_S(*args)
    else:
      raise ValueError('Invalid argument list getSolverIntInfo('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getSolverIntInfo(string)')
  def getSolverLIntInfo(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getSolverLIntInfo_S(*args): # string
      return self._getSolverLIntInfo_S(*args)
    elif mosek_fusion_Model._match_alt_getSolverLIntInfo_S(*args): # string
      return self._getSolverLIntInfo_alt_S(*args)
    else:
      raise ValueError('Invalid argument list getSolverLIntInfo('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getSolverLIntInfo(string)')
  def getPrimalSolutionStatus(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getPrimalSolutionStatus_(*args): # 
      return self._getPrimalSolutionStatus_(*args)
    elif mosek_fusion_Model._match_alt_getPrimalSolutionStatus_(*args): # 
      return self._getPrimalSolutionStatus_alt_(*args)
    elif mosek_fusion_Model._match_getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(*args): # mosek.fusion.SolutionType
      return self._getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(*args)
    elif mosek_fusion_Model._match_alt_getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(*args): # mosek.fusion.SolutionType
      return self._getPrimalSolutionStatus_alt_Emosek_4fusion_4SolutionType_2(*args)
    else:
      raise ValueError('Invalid argument list getPrimalSolutionStatus('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getPrimalSolutionStatus()\n\tmosek.fusion.Model.getPrimalSolutionStatus(mosek.fusion.SolutionType)')
  def setSolverParam(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_setSolverParam_SS(*args): # string,string
      return self._setSolverParam_SS(*args)
    elif mosek_fusion_Model._match_alt_setSolverParam_SS(*args): # string,string
      return self._setSolverParam_alt_SS(*args)
    elif mosek_fusion_Model._match_setSolverParam_SI(*args): # string,int32
      return self._setSolverParam_SI(*args)
    elif mosek_fusion_Model._match_alt_setSolverParam_SI(*args): # string,int32
      return self._setSolverParam_alt_SI(*args)
    elif mosek_fusion_Model._match_setSolverParam_SD(*args): # string,double
      return self._setSolverParam_SD(*args)
    elif mosek_fusion_Model._match_alt_setSolverParam_SD(*args): # string,double
      return self._setSolverParam_alt_SD(*args)
    else:
      raise ValueError('Invalid argument list setSolverParam('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.setSolverParam(string,string)\n\tmosek.fusion.Model.setSolverParam(string,int32)\n\tmosek.fusion.Model.setSolverParam(string,double)')
  def __repr__(self): return 'mosek.fusion.Model'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2(m):
    o = Model.__new__(Model)
    o._ctor_init_Lmosek_4fusion_4Model_2(m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2(*args):
    if len(args) != 1: return False
    m, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2(*args):
    if len(args) != 1: return False
    m, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2(self,m):
    self._ctor_init_Lmosek_4fusion_4Model_2(m)
  def _ctor_init_Lmosek_4fusion_4Model_2(self,m):
   mosek_fusion_BaseModel._ctor_init_Lmosek_4fusion_4BaseModel_2(self,m)
   self.__model_name = mosek.fusion.Utils.StringBuffer()._a_S((m.__model_name))._a_S("(clone)")._toString_()
   self.__acceptable_sol = (m.__acceptable_sol)
   self.__solutionptr = (m.__solutionptr)
   _0=self
   self._vars = numpy.array([(m._vars)[_1]._clone_Lmosek_4fusion_4Model_2(_0) for _1 in range(0,(m._vars_used))], dtype=numpy.dtype(object))
   self._vars_used = (m._vars_used)
   self.__var_map = (m.__var_map)._clone_()
   self.__task_vars_allocated = (m.__task_vars_allocated)
   self.__task_vars_used = (m.__task_vars_used)
   self.__cons = numpy.array([(m.__cons)[_2]._clone_Lmosek_4fusion_4Model_2(_0) for _2 in range(0,(m.__cons_used))], dtype=numpy.dtype(object))
   self.__cons_used = (m.__cons_used)
   self.__con_map = (m.__con_map)._clone_()
   self.__natvarmap_Var = numpy.array([(m.__natvarmap_Var)[_3] for _3 in range(0,(m.__natvarmap_num))], dtype=numpy.dtype(numpy.int32))
   self.__natvarmap_idx = numpy.array([(m.__natvarmap_idx)[_4] for _4 in range(0,(m.__natvarmap_num))], dtype=numpy.dtype(numpy.int64))
   self.__natvarmap_num = (m.__natvarmap_num)
   self._natbarvarmap_Var = numpy.array([(m.__natvarmap_Var)[_5] for _5 in range(0,(m.__natvarmap_num))], dtype=numpy.dtype(numpy.int32))
   self._natbarvarmap_num = (m._natbarvarmap_num)
   self.__initsol_xx = None
   self.__initsol_xx_flag = None
  @staticmethod
  def _ctor_():
    o = Model.__new__(Model)
    o._ctor_init_()
    return o
  @staticmethod
  def __match_ctor_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def __match_alt_ctor_(*args):
    if len(args) != 0: return False
    return True
  def _ctor_alt_init_(self,):
    self._ctor_init_()
  def _ctor_init_(self,):
   mosek_fusion_BaseModel._ctor_init_SS(self,"","")
   self.__model_name = ""
   self.__acceptable_sol = mosek.fusion.AccSolutionStatus.Optimal
   self.__solutionptr = mosek.fusion.SolutionType.Default
   self.__natvarmap_Var = numpy.zeros((1024,), dtype=numpy.dtype(numpy.int32))
   self.__natvarmap_idx = numpy.zeros((1024,), dtype=numpy.dtype(numpy.int64))
   self.__natvarmap_num = 0
   self._natbarvarmap_Var = numpy.zeros((0,), dtype=numpy.dtype(numpy.int32))
   self._natbarvarmap_num = 0
   self.__task_vars_allocated = 0
   self.__task_vars_used = 0
   self.__initsol_xx = None
   self.__initsol_xx_flag = None
   self._vars = numpy.zeros((1024,), dtype=numpy.dtype(object))
   self._vars_used = 0
   self.__var_map = mosek.fusion.Utils.StringIntMap()
   self.__cons = numpy.zeros((1024,), dtype=numpy.dtype(object))
   self.__cons_used = 0
   self.__con_map = mosek.fusion.Utils.StringIntMap()
  @staticmethod
  def _ctor_S(name):
    o = Model.__new__(Model)
    o._ctor_init_S(name)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    name, = args
    return (__arg_match_S__(name))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    name, = args
    return (__arg_alt_match_S__(name))
  def _ctor_alt_init_S(self,name):
    self._ctor_init_S(name)
  def _ctor_init_S(self,name):
   mosek_fusion_BaseModel._ctor_init_SS(self,name,"")
   self.__model_name = name
   self.__acceptable_sol = mosek.fusion.AccSolutionStatus.NearOptimal
   self.__solutionptr = mosek.fusion.SolutionType.Default
   self.__natvarmap_Var = numpy.zeros((1024,), dtype=numpy.dtype(numpy.int32))
   self.__natvarmap_idx = numpy.zeros((1024,), dtype=numpy.dtype(numpy.int64))
   self.__natvarmap_num = 0
   self._natbarvarmap_Var = numpy.zeros((0,), dtype=numpy.dtype(numpy.int32))
   self._natbarvarmap_num = 0
   self.__initsol_xx = None
   self.__initsol_xx_flag = None
   self._vars = numpy.zeros((1024,), dtype=numpy.dtype(object))
   self._vars_used = 0
   self.__var_map = mosek.fusion.Utils.StringIntMap()
   self.__task_vars_allocated = 0
   self.__task_vars_used = 0
   self.__cons = numpy.zeros((1024,), dtype=numpy.dtype(object))
   self.__cons_used = 0
   self.__con_map = mosek.fusion.Utils.StringIntMap()
  @staticmethod
  def _match_putlicensewait_Z(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Z__(_0))
  @staticmethod
  def _match_alt_putlicensewait_Z(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Z__(_0))
  @staticmethod
  def _putlicensewait_alt_Z(_t__0):
    return mosek_fusion_Model._putlicensewait_Z(_0)
  @staticmethod
  def _putlicensewait_Z(_0):
   mosek.fusion.BaseModel._env_1putlicensewait_Z(_0)
  @staticmethod
  def _match_putlicensepath_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_putlicensepath_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  @staticmethod
  def _putlicensepath_alt_S(_t__0):
    return mosek_fusion_Model._putlicensepath_S(_0)
  @staticmethod
  def _putlicensepath_S(_0):
   mosek.fusion.BaseModel._env_1putlicensepath_S(_0)
  @staticmethod
  def _match_putlicensecode__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_putlicensecode__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  @staticmethod
  def _putlicensecode_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1 = mosek_fusion_Model._putlicensecode__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _putlicensecode__3I(_0):
   mosek.fusion.BaseModel._env_1putlicensecode__3I(_0)
  @staticmethod
  def __inst_alt__3Lmosek_4fusion_4Variable_2II_3JI_3I_3I_3I(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1=numpy.int32(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int64))
   _4=numpy.int32(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int32))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.int32))
   _7=numpy.array(_t__7,dtype=numpy.dtype(numpy.int32))
   _1 = mosek_fusion_Model.__inst__3Lmosek_4fusion_4Variable_2II_3JI_3I_3I_3I(_0,_1,_2,_3,_4,_5,_6,_7)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__7[:] = _7
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def __inst__3Lmosek_4fusion_4Variable_2II_3JI_3I_3I_3I(_0,_1,_2,_3,_4,_5,_6,_7):
   _8=numpy.zeros(((int((_0).shape[0]) + 1),), dtype=numpy.dtype(numpy.int64))
   for _9 in range(0,int((_0).shape[0])):
    _8[(_9 + 1)] = (_8[_9] + _0[_9].size())
   if (int((_0).shape[0])==1):
    _0[0].inst(_3,_1,_2,0,_4,_5,_6,_7)
   elif (int((_0).shape[0])==2):
    for _10 in range(_1,_2):
     if (_3[_10] < _8[1]):
      _0[0].inst(_3[_10],((_4 + _10) - _1),_5,_6,_7)
     else:
      _0[1].inst((_3[_10] - _8[1]),((_4 + _10) - _1),_5,_6,_7)
   elif (int((_0).shape[0])==3):
    for _11 in range(_1,_2):
     if (_3[_11] < _8[1]):
      _0[0].inst(_3[_11],((_4 + _11) - _1),_5,_6,_7)
     elif (_3[_11] < _8[2]):
      _0[1].inst((_3[_11] - _8[1]),((_4 + _11) - _1),_5,_6,_7)
     else:
      _0[2].inst((_3[_11] - _8[2]),((_4 + _11) - _1),_5,_6,_7)
   else:
    _12=4
    _13=_8[int((_0).shape[0])]
    _14=0
    _15=int((_0).shape[0])
    while (_15 > 0):
     _15 /= 2
     _14 += 1
    if (False and (((_2 - _1) + _13) < ((_12 * (_2 - _1)) * _14))):
     _16=numpy.zeros(((_13 + 1),), dtype=numpy.dtype(numpy.int32))
     for _17 in range(_1,_2):
      _16[_3[_17]] += 1
     for _18 in range(0,_13):
      _16[(_18 + 1)] += _16[_18]
     _19=numpy.zeros(((_2 - _1),), dtype=numpy.dtype(numpy.int64))
     for _20 in range(_1,_2):
      _19[(_16[_3[_20]] - _1)] = _20
      _16[_3[_20]] += 1
     _21=0
     _22=0
     while ((_22 < int((_19).shape[0])) and (_21 < int((_0).shape[0]))):
      if (_8[(_21 + 1)] < _3[_19[_22]]):
       _21 += 1
      else:
       _0[_21].inst((_3[_19[_22]] - _8[_21]),((_4 + _19[_22]) - _1),_5,_6,_7)
       _22 += 1
    else:
     for _23 in range(_1,_2):
      _24=(int((_8).shape[0]) // 2)
      _25=0
      _26=(int((_8).shape[0]) - 1)
      _27=0
      while (_25 < _26):
       _27 = ((_25 + _26) // 2)
       if (_3[_23] < _8[_27]):
        _26 = _27
       elif (_3[_23] >= _8[(_27 + 1)]):
        _25 = _27
       else:
        _25 = _27
        _26 = _27
      _24 = _27
      _0[_24].inst((_3[_23] - _8[_24]),((_4 + _23) - _1),_5,_6,_7)
  @staticmethod
  def __inst_alt__3Lmosek_4fusion_4Variable_2_3J_3I_3I_3I(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1 = mosek_fusion_Model.__inst__3Lmosek_4fusion_4Variable_2_3J_3I_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def __inst__3Lmosek_4fusion_4Variable_2_3J_3I_3I_3I(_0,_1,_2,_3,_4):
   mosek.fusion.Model.__inst__3Lmosek_4fusion_4Variable_2II_3JI_3I_3I_3I(_0,0,int((_1).shape[0]),_1,0,_2,_3,_4)
  @staticmethod
  def _match_dispose_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dispose_(*args):
    if len(args) != 0: return False
    return True
  def _dispose_alt_(self,):
    return self._dispose_()
  def _dispose_(self,):
   for _0 in range(0,self._vars_used):
    self._vars[_0] = None
   self._vars_used = 0
   for _1 in range(0,self.__cons_used):
    self.__cons[_1] = None
   self.__cons_used = 0
   mosek_fusion_BaseModel._dispose_(self)
  def _varname_alt_IS(self,_t__0,_t__1):
    return self._varname_IS(numpy.int32(__0),_1)
  def _varname_IS(self,_0,_1):
   self._task_1var_1name_IS(_0,_1)
  def _nativeVarToStr_alt_ILmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._nativeVarToStr_ILmosek_4fusion_4Utils_4StringBuffer_2(numpy.int32(__0),_1)
  def _nativeVarToStr_ILmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   if ((_0 < 0) or (_0 >= self.__natvarmap_num)):
    raise mosek_fusion_IndexError._ctor_S("Native variable index out of bounds")
   self._vars[self.__natvarmap_Var[_0]].elementName(self.__natvarmap_idx[_0],_1)
  def _append_1linearvar_alt_Lmosek_4fusion_4ModelVariable_2JEmosek_4fusion_4RelationKey_2D(self,_t__0,_t__1,_t__2,_t__3):
    return self._append_1linearvar_Lmosek_4fusion_4ModelVariable_2JEmosek_4fusion_4RelationKey_2D(_0,numpy.int64(__1),__2,numpy.float64(__3))
  def _append_1linearvar_Lmosek_4fusion_4ModelVariable_2JEmosek_4fusion_4RelationKey_2D(self,_0,_1,_2,_3):
   _4=self._alloc_1linearvar_SEmosek_4fusion_4RelationKey_2D("",_2,_3)
   self.__natvarmap_1ensure_I(1)
   self.__natvarmap_idx[_4] = _1
   self.__natvarmap_Var[_4] = self._vars_used
   self.__natvarmap_num = (self.__natvarmap_num + 1)
   return numpy.int32(_4)
  def _append_1rangedvar_alt_Lmosek_4fusion_4ModelVariable_2JDD(self,_t__0,_t__1,_t__2,_t__3):
    return self._append_1rangedvar_Lmosek_4fusion_4ModelVariable_2JDD(_0,numpy.int64(__1),numpy.float64(__2),numpy.float64(__3))
  def _append_1rangedvar_Lmosek_4fusion_4ModelVariable_2JDD(self,_0,_1,_2,_3):
   _4=self._alloc_1rangedvar_SDD("",_2,_3)
   self.__natvarmap_1ensure_I(1)
   self.__natvarmap_idx[_4] = _1
   self.__natvarmap_Var[_4] = self._vars_used
   self.__natvarmap_num = (self.__natvarmap_num + 1)
   return numpy.int32(_4)
  @staticmethod
  def _match_getTask_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getTask_(*args):
    if len(args) != 0: return False
    return True
  def _getTask_alt_(self,):
    return self._getTask_()
  def _getTask_(self,):
   return (self._task_1get_())
  @staticmethod
  def _match_flushNames_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_flushNames_(*args):
    if len(args) != 0: return False
    return True
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   for _0 in range(0,self._vars_used):
    self._vars[_0]._flushNames_()
   for _1 in range(0,self.__cons_used):
    self.__cons[_1]._flushNames_()
  @staticmethod
  def _match_writeTask_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_writeTask_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _writeTask_alt_S(self,_t__0):
    return self._writeTask_S(_0)
  def _writeTask_S(self,_0):
   self.flushNames()
   self._task_1setnumvar_I(self.__task_vars_used)
   self.__task_vars_allocated = self.__task_vars_used
   self._task_1write_S(_0)
  @staticmethod
  def _match_getSolverLIntInfo_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_getSolverLIntInfo_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _getSolverLIntInfo_alt_S(self,_t__0):
    return self._getSolverLIntInfo_S(_0)
  def _getSolverLIntInfo_S(self,_0):
   return numpy.int64(self._task_1get_1liinf_S(_0))
  @staticmethod
  def _match_getSolverIntInfo_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_getSolverIntInfo_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _getSolverIntInfo_alt_S(self,_t__0):
    return self._getSolverIntInfo_S(_0)
  def _getSolverIntInfo_S(self,_0):
   return numpy.int32(self._task_1get_1iinf_S(_0))
  @staticmethod
  def _match_getSolverDoubleInfo_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_getSolverDoubleInfo_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _getSolverDoubleInfo_alt_S(self,_t__0):
    return self._getSolverDoubleInfo_S(_0)
  def _getSolverDoubleInfo_S(self,_0):
   return numpy.float64(self._task_1get_1dinf_S(_0))
  @staticmethod
  def _match_setCallbackHandler_LSystem_4CallbackHandler_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_LSystem_4CallbackHandler_2__(_0))
  @staticmethod
  def _match_alt_setCallbackHandler_LSystem_4CallbackHandler_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_LSystem_4CallbackHandler_2__(_0))
  def _setCallbackHandler_alt_LSystem_4CallbackHandler_2(self,_t__0):
    return self._setCallbackHandler_LSystem_4CallbackHandler_2(_0)
  def _setCallbackHandler_LSystem_4CallbackHandler_2(self,_0):
   self._task_1setCallbackHandler_LSystem_4CallbackHandler_2(_0)
  @staticmethod
  def _match_setDataCallbackHandler_LSystem_4DataCallbackHandler_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_LSystem_4DataCallbackHandler_2__(_0))
  @staticmethod
  def _match_alt_setDataCallbackHandler_LSystem_4DataCallbackHandler_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_LSystem_4DataCallbackHandler_2__(_0))
  def _setDataCallbackHandler_alt_LSystem_4DataCallbackHandler_2(self,_t__0):
    return self._setDataCallbackHandler_LSystem_4DataCallbackHandler_2(_0)
  def _setDataCallbackHandler_LSystem_4DataCallbackHandler_2(self,_0):
   self._task_1setDataCallbackHandler_LSystem_4DataCallbackHandler_2(_0)
  @staticmethod
  def _match_setLogHandler_LSystem_4StreamWriter_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_LSystem_4StreamWriter_2__(_0))
  @staticmethod
  def _match_alt_setLogHandler_LSystem_4StreamWriter_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_LSystem_4StreamWriter_2__(_0))
  def _setLogHandler_alt_LSystem_4StreamWriter_2(self,_t__0):
    return self._setLogHandler_LSystem_4StreamWriter_2(_0)
  def _setLogHandler_LSystem_4StreamWriter_2(self,_0):
   self._task_1setLogHandler_LSystem_4StreamWriter_2(_0)
  @staticmethod
  def _match_setSolverParam_SD(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_D__(_1))
  @staticmethod
  def _match_alt_setSolverParam_SD(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_D__(_1))
  def _setSolverParam_alt_SD(self,_t__0,_t__1):
    return self._setSolverParam_SD(_0,numpy.float64(__1))
  def _setSolverParam_SD(self,_0,_1):
   mosek.fusion.Parameters._setParameter_Lmosek_4fusion_4Model_2SD(self,_0,_1)
  @staticmethod
  def _match_setSolverParam_SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_setSolverParam_SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1))
  def _setSolverParam_alt_SI(self,_t__0,_t__1):
    return self._setSolverParam_SI(_0,numpy.int32(__1))
  def _setSolverParam_SI(self,_0,_1):
   mosek.fusion.Parameters._setParameter_Lmosek_4fusion_4Model_2SI(self,_0,_1)
  @staticmethod
  def _match_setSolverParam_SS(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_S__(_1))
  @staticmethod
  def _match_alt_setSolverParam_SS(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_S__(_1))
  def _setSolverParam_alt_SS(self,_t__0,_t__1):
    return self._setSolverParam_SS(_0,_1)
  def _setSolverParam_SS(self,_0,_1):
   mosek.fusion.Parameters._setParameter_Lmosek_4fusion_4Model_2SS(self,_0,_1)
  @staticmethod
  def _match_breakSolver_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_breakSolver_(*args):
    if len(args) != 0: return False
    return True
  def _breakSolver_alt_(self,):
    return self._breakSolver_()
  def _breakSolver_(self,):
   self._task_1break_1solve_()
  @staticmethod
  def _match_solve_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_solve_(*args):
    if len(args) != 0: return False
    return True
  def _solve_alt_(self,):
    return self._solve_()
  def _solve_(self,):
   self.__flush_1initsol_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Interior)
   self.__flush_1initsol_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Integer)
   self.__flush_1initsol_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Basic)
   self._task_1solve_()
  @staticmethod
  def _match_flushSolutions_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_flushSolutions_(*args):
    if len(args) != 0: return False
    return True
  def _flushSolutions_alt_(self,):
    return self._flushSolutions_()
  def _flushSolutions_(self,):
   self.__flush_1initsol_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Interior)
   self.__flush_1initsol_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Integer)
   self.__flush_1initsol_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Basic)
  def __flush_1initsol_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self.__flush_1initsol_Emosek_4fusion_4SolutionType_2(__0)
  def __flush_1initsol_Emosek_4fusion_4SolutionType_2(self,_0):
   if (self.__initsol_xx is not None):
    try:
     _1=self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,True)
     if ((_1.xx) is not None):
      for _2 in range(0,int((self.__initsol_xx).shape[0])):
       if (not self.__initsol_xx_flag[_2]):
        self.__initsol_xx[_2] = (_1.xx)[_2]
     else:
      for _3 in range(0,int((self.__initsol_xx).shape[0])):
       if (not self.__initsol_xx_flag[_3]):
        self.__initsol_xx[_3] = 0.0
    except mosek_fusion_SolutionError, _4:
     for _5 in range(0,int((self.__initsol_xx).shape[0])):
      if (not self.__initsol_xx_flag[_5]):
       self.__initsol_xx[_5] = 0.0
    self._task_1putxx_1slice_Emosek_4fusion_4SolutionType_2II_3D(_0,0,int((self.__initsol_xx).shape[0]),self.__initsol_xx)
  @staticmethod
  def _match_getDualSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getDualSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  def _getDualSolutionStatus_alt_(self,):
    return self._getDualSolutionStatus_()
  def _getDualSolutionStatus_(self,):
   _0=None
   if (self.__solutionptr==mosek.fusion.SolutionType.Default):
    if (self._sol_itg is not None):
     _0 = self._sol_itg
    elif (self._sol_bas is not None):
     _0 = self._sol_bas
    else:
     _0 = self._sol_itr
   elif (self.__solutionptr==mosek.fusion.SolutionType.Interior):
    _0 = self._sol_itr
   elif (self.__solutionptr==mosek.fusion.SolutionType.Basic):
    _0 = self._sol_bas
   elif (self.__solutionptr==mosek.fusion.SolutionType.Integer):
    _0 = self._sol_itg
   if (_0 is None):
    return (mosek.fusion.SolutionStatus.Undefined)
   elif (not self._synched):
    return (mosek.fusion.SolutionStatus.Unknown)
   else:
    return ((_0.dstatus))
  @staticmethod
  def _match_getPrimalSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getPrimalSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  def _getPrimalSolutionStatus_alt_(self,):
    return self._getPrimalSolutionStatus_()
  def _getPrimalSolutionStatus_(self,):
   _0=None
   if (self.__solutionptr==mosek.fusion.SolutionType.Default):
    if (self._sol_itg is not None):
     _0 = self._sol_itg
    elif (self._sol_bas is not None):
     _0 = self._sol_bas
    else:
     _0 = self._sol_itr
   elif (self.__solutionptr==mosek.fusion.SolutionType.Basic):
    _0 = self._sol_bas
   elif (self.__solutionptr==mosek.fusion.SolutionType.Integer):
    _0 = self._sol_itg
   else:
    _0 = self._sol_itr
   if (_0 is None):
    return (mosek.fusion.SolutionStatus.Undefined)
   elif (not self._synched):
    return (mosek.fusion.SolutionStatus.Unknown)
   else:
    return ((_0.pstatus))
  @staticmethod
  def _match_dualObjValue_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dualObjValue_(*args):
    if len(args) != 0: return False
    return True
  def _dualObjValue_alt_(self,):
    return self._dualObjValue_()
  def _dualObjValue_(self,):
   return numpy.float64((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(mosek.fusion.SolutionType.Default,False).dobj))
  @staticmethod
  def _match_primalObjValue_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_primalObjValue_(*args):
    if len(args) != 0: return False
    return True
  def _primalObjValue_alt_(self,):
    return self._primalObjValue_()
  def _primalObjValue_(self,):
   return numpy.float64((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(mosek.fusion.SolutionType.Default,True).pobj))
  def _get_1sol_1cache_alt_Emosek_4fusion_4SolutionType_2ZZ(self,_t__0,_t__1,_t__2):
    return self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2ZZ(__0,_1,_2)
  def _get_1sol_1cache_Emosek_4fusion_4SolutionType_2ZZ(self,_0,_1,_2):
   _3=None
   _4=_0
   if (_4==mosek.fusion.SolutionType.Default):
    _4 = self.__solutionptr
   if (_4==mosek.fusion.SolutionType.Default):
    if (self._sol_itg is not None):
     _3 = self._sol_itg
    elif (self._sol_bas is not None):
     _3 = self._sol_bas
    else:
     _3 = self._sol_itr
   elif (_4==mosek.fusion.SolutionType.Interior):
    _3 = self._sol_itr
   elif (_4==mosek.fusion.SolutionType.Basic):
    _3 = self._sol_bas
   elif (_4==mosek.fusion.SolutionType.Integer):
    _3 = self._sol_itg
   if (_3 is None):
    raise mosek_fusion_SolutionError._ctor_S("Solution not available")
   else:
    if ((_1 and _3.isPrimalAcceptable(self.__acceptable_sol)) or ((not _1) and _3.isDualAcceptable(self.__acceptable_sol))):
     return (_3)
    else:
     _5=mosek.fusion.Utils.StringBuffer()
     _6=(_3.pstatus)
     if (not _1):
      _6 = (_3.dstatus)
     _5._a_S("Solution status is ")
     if (_6==mosek.fusion.SolutionStatus.Undefined):
      _5._a_S("Undefined")
     elif (_6==mosek.fusion.SolutionStatus.Unknown):
      _5._a_S("Unknown")
     elif (_6==mosek.fusion.SolutionStatus.Optimal):
      _5._a_S("Optimal")
     elif (_6==mosek.fusion.SolutionStatus.NearOptimal):
      _5._a_S("NearOptimal")
     elif (_6==mosek.fusion.SolutionStatus.Feasible):
      _5._a_S("Feasible")
     elif (_6==mosek.fusion.SolutionStatus.NearFeasible):
      _5._a_S("NearFeasible")
     elif (_6==mosek.fusion.SolutionStatus.Certificate):
      _5._a_S("Certificate")
     elif (_6==mosek.fusion.SolutionStatus.NearCertificate):
      _5._a_S("NearCertificate")
     _5._a_S(" but at least ")
     if (self.__acceptable_sol==mosek.fusion.AccSolutionStatus.Anything):
      _5._a_S("Anything")
     elif (self.__acceptable_sol==mosek.fusion.AccSolutionStatus.Optimal):
      _5._a_S("Optimal")
     elif (self.__acceptable_sol==mosek.fusion.AccSolutionStatus.NearOptimal):
      _5._a_S("NearOptimal")
     elif (self.__acceptable_sol==mosek.fusion.AccSolutionStatus.Feasible):
      _5._a_S("Feasible")
     elif (self.__acceptable_sol==mosek.fusion.AccSolutionStatus.Certificate):
      _5._a_S("Certificate")
     _5._a_S(" is expected")
     raise mosek_fusion_SolutionError._ctor_S(_5._toString_())
  def _get_1sol_1cache_alt_Emosek_4fusion_4SolutionType_2Z(self,_t__0,_t__1):
    return self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(__0,_1)
  def _get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(self,_0,_1):
   return (self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2ZZ(_0,_1,False))
  def _setSolution_1xx_alt__3I_3D(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _1 = self._setSolution_1xx__3I_3D(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _setSolution_1xx__3I_3D(self,_0,_1):
   self._ensure_1initsol_1xx_()
   for _2 in range(0,int((_0).shape[0])):
    self.__initsol_xx[_0[_2]] = _1[_2]
    self.__initsol_xx_flag[_0[_2]] = True
  def _ensure_1initsol_1xx_alt_(self,):
    return self._ensure_1initsol_1xx_()
  def _ensure_1initsol_1xx_(self,):
   if (self.__initsol_xx is None):
    self.__initsol_xx = numpy.zeros((self.__natvarmap_num,), dtype=numpy.dtype(numpy.float64))
    self.__initsol_xx_flag = numpy.array([False for _0 in range(0,self.__natvarmap_num)], dtype=numpy.dtype(numpy.bool))
   elif (int((self.__initsol_xx).shape[0]) < self.__natvarmap_num):
    _1=self.__initsol_xx
    _2=self.__initsol_xx_flag
    self.__initsol_xx = numpy.zeros((self.__natvarmap_num,), dtype=numpy.dtype(numpy.float64))
    self.__initsol_xx_flag = numpy.zeros((self.__natvarmap_num,), dtype=numpy.dtype(numpy.bool))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_1,0,self.__initsol_xx,0,self.__natvarmap_num)
    for _3 in range(0,self.__natvarmap_num):
     self.__initsol_xx_flag[_3] = _2[_3]
  def _getSolution_1bars_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1bars_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1bars_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,False).bars))
  def _getSolution_1barx_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1barx_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1barx_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,False).barx))
  def _getSolution_1y_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1y_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1y_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,False).y))
  def _getSolution_1xc_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1xc_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1xc_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,True).xc))
  def _getSolution_1snx_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1snx_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1snx_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,False).snx))
  def _getSolution_1suc_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1suc_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1suc_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,False).suc))
  def _getSolution_1slc_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1slc_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1slc_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,False).slc))
  def _getSolution_1sux_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1sux_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1sux_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,False).sux))
  def _getSolution_1slx_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1slx_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1slx_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,False).slx))
  def _getSolution_1xx_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1xx_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1xx_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,True).xx))
  @staticmethod
  def _match_selectedSolution_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Emosek_4fusion_4SolutionType_2__(_0))
  @staticmethod
  def _match_alt_selectedSolution_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Emosek_4fusion_4SolutionType_2__(_0))
  def _selectedSolution_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._selectedSolution_Emosek_4fusion_4SolutionType_2(__0)
  def _selectedSolution_Emosek_4fusion_4SolutionType_2(self,_0):
   self.__solutionptr = _0
  @staticmethod
  def _match_getAcceptedSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getAcceptedSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  def _getAcceptedSolutionStatus_alt_(self,):
    return self._getAcceptedSolutionStatus_()
  def _getAcceptedSolutionStatus_(self,):
   return (self.__acceptable_sol)
  @staticmethod
  def _match_acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Emosek_4fusion_4AccSolutionStatus_2__(_0))
  @staticmethod
  def _match_alt_acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Emosek_4fusion_4AccSolutionStatus_2__(_0))
  def _acceptedSolutionStatus_alt_Emosek_4fusion_4AccSolutionStatus_2(self,_t__0):
    return self._acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(__0)
  def _acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(self,_0):
   self.__acceptable_sol = _0
  @staticmethod
  def _match_getProblemStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Emosek_4fusion_4SolutionType_2__(_0))
  @staticmethod
  def _match_alt_getProblemStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Emosek_4fusion_4SolutionType_2__(_0))
  def _getProblemStatus_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getProblemStatus_Emosek_4fusion_4SolutionType_2(__0)
  def _getProblemStatus_Emosek_4fusion_4SolutionType_2(self,_0):
   _1=None
   if (_0==mosek.fusion.SolutionType.Default):
    if (self._sol_itg is not None):
     _1 = self._sol_itg
    elif (self._sol_bas is not None):
     _1 = self._sol_bas
    else:
     _1 = self._sol_itr
   elif (_0==mosek.fusion.SolutionType.Interior):
    _1 = self._sol_itr
   elif (_0==mosek.fusion.SolutionType.Basic):
    _1 = self._sol_bas
   elif (_0==mosek.fusion.SolutionType.Integer):
    _1 = self._sol_itg
   if (_1 is None):
    return (mosek.fusion.ProblemStatus.Unknown)
   else:
    return ((_1.probstatus))
  @staticmethod
  def _match_getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Emosek_4fusion_4SolutionType_2__(_0))
  @staticmethod
  def _match_alt_getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Emosek_4fusion_4SolutionType_2__(_0))
  def _getDualSolutionStatus_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(__0)
  def _getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(self,_0):
   return (self._getSolutionStatus_Emosek_4fusion_4SolutionType_2Z(_0,False))
  @staticmethod
  def _match_getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Emosek_4fusion_4SolutionType_2__(_0))
  @staticmethod
  def _match_alt_getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Emosek_4fusion_4SolutionType_2__(_0))
  def _getPrimalSolutionStatus_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(__0)
  def _getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(self,_0):
   return (self._getSolutionStatus_Emosek_4fusion_4SolutionType_2Z(_0,True))
  def _getSolutionStatus_alt_Emosek_4fusion_4SolutionType_2Z(self,_t__0,_t__1):
    return self._getSolutionStatus_Emosek_4fusion_4SolutionType_2Z(__0,_1)
  def _getSolutionStatus_Emosek_4fusion_4SolutionType_2Z(self,_0,_1):
   try:
    _2=self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2ZZ(_0,_1,True)
    if _1:
     return ((_2.pstatus))
    else:
     return ((_2.dstatus))
   except mosek_fusion_SolutionError, _3:
    return (mosek.fusion.SolutionStatus.Undefined)
  def __objective_1_alt_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_t__0,_t__1,_t__2):
    return self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(_0,__1,_2)
  def __objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_0,_1,_2):
   self._task_1putobjectivename_S(_0)
   if ((_2.getShape()._size)!=1):
    raise mosek_fusion_LengthError._ctor_S("Objective expression must be of size 1.")
   if ((_1!=mosek.fusion.ObjectiveSense.Minimize) and (_1!=mosek.fusion.ObjectiveSense.Maximize)):
    raise mosek_fusion_LengthError._ctor_S("Objective sense required.")
   _3=_2.eval()
   for _4 in range(0,int(((_3.x)).shape[0])):
    if (((_3.x)[_4].getModel() is not None) and ((_3.x)[_4].getModel() is not self)):
     raise mosek_fusion_ModelError._ctor_S("Expression belong to different models")
   _5=None
   _6=None
   _7=0
   _8=0
   _9=None
   _10=None
   _11=None
   _12=int(((_3.subj)).shape[0])
   _9 = numpy.zeros((_12,), dtype=numpy.dtype(numpy.int32))
   _10 = numpy.zeros((_12,), dtype=numpy.dtype(numpy.int32))
   _11 = numpy.zeros((_12,), dtype=numpy.dtype(numpy.int32))
   mosek.fusion.Model.__inst__3Lmosek_4fusion_4Variable_2_3J_3I_3I_3I((_3.x),(_3.subj),_9,_10,_11)
   _8 = 0
   _13=0
   while (_13 < _12):
    if (_9[_13] >= 0):
     _8 += 1
    _13 += 1
   _7 = (_12 - _8)
   if (_8 > 0):
    _5 = numpy.zeros((_8,), dtype=numpy.dtype(numpy.int32))
   if (_7==0):
    _5 = _9
    _6 = (_3.cof)
   else:
    _14=0
    _6 = numpy.zeros((_8,), dtype=numpy.dtype(numpy.float64))
    _5 = numpy.zeros((_8,), dtype=numpy.dtype(numpy.int32))
    _15=(_3.ptrb)[0]
    while (_15 < (_3.ptrb)[1]):
     if (_9[_15] >= 0):
      _5[_14] = _9[_15]
      _6[_14] = (_3.cof)[_15]
      _14 += 1
     _15 += 1
   _16=0.0
   if ((_3.bfix) is not None):
    _16 = (_3.bfix)[0]
   self._task_1putobjective_Z_3I_3DD((_1==mosek.fusion.ObjectiveSense.Maximize),_5,_6,_16)
   if (_7 > 0):
    _17=0
    _18=(_3.ptrb)[0]
    while (_18 < (_3.ptrb)[1]):
     if (_9[_18] < 0):
      _17 += 1
     _18 += 1
    if (_17 > 0):
     _19=numpy.zeros((_17,), dtype=numpy.dtype(numpy.int64))
     _20=(_3.ptrb)
     _21=0
     _22=_20[0]
     while (_22 < _20[1]):
      if (_9[_22] < 0):
       _19[_21] = numpy.int64(_22)
       _21 += 1
      _22 += 1
     mosek.fusion.Sort._argsort__3J_3IJJ(_19,_9,0,_17)
     _23=0
     while (_23 < _17):
      _24=_23
      _23 += 1
      while ((_23 < _17) and (_9[_19[_23]]==_9[_19[(_23 - 1)]])):
       _23 += 1
      _25=(_23 - _24)
      mosek.fusion.Sort._argsort__3J_3I_3IJJ(_19,_10,_11,numpy.int64(_24),numpy.int64(_23))
      _26=1
      for _27 in range((_24 + 1),_23):
       _28=_19[_27]
       _29=_19[(_27 - 1)]
       if ((_10[_28]!=_10[_29]) or (_11[_28]!=_11[_29])):
        _26 += 1
      _30=0
      _31=numpy.zeros((_26,), dtype=numpy.dtype(numpy.int32))
      _32=numpy.zeros((_26,), dtype=numpy.dtype(numpy.int32))
      _33=numpy.zeros((_26,), dtype=numpy.dtype(numpy.float64))
      _31[0] = _10[_19[_24]]
      _32[0] = _11[_19[_24]]
      if (_31[0]==_32[0]):
       _33[0] = (_3.cof)[_19[_24]]
      else:
       _33[0] = (0.5 * (_3.cof)[_19[_24]])
      for _34 in range((_24 + 1),_23):
       _35=_19[_34]
       _36=_19[(_34 - 1)]
       if ((_10[_35]!=_10[_36]) or (_11[_35]!=_11[_36])):
        _30 += 1
        _31[_30] = _10[_35]
        _32[_30] = _11[_35]
       if (_31[_30]==_32[_30]):
        _33[_30] = (_33[_30] + (_3.cof)[_35])
       else:
        _33[_30] = (_33[_30] + (0.5 * (_3.cof)[_35]))
      _37=(- (_9[_19[_24]] + 1))
      _38=self._task_1barvardim_I(_37)
      _39=self._task_1append_1barmatrix_I_3I_3I_3D(_38,_31,_32,_33)
      self._task_1putbarcj_II(_37,_39)
  @staticmethod
  def _match_objective_D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_D__(_0))
  @staticmethod
  def _match_alt_objective_D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_D__(_0))
  def _objective_alt_D(self,_t__0):
    return self._objective_D(numpy.float64(__0))
  def _objective_D(self,_0):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2("",mosek.fusion.ObjectiveSense.Minimize,mosek.fusion.Expr._constTerm_D(_0))
  @staticmethod
  def _match_objective_Emosek_4fusion_4ObjectiveSense_2D(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Emosek_4fusion_4ObjectiveSense_2__(_0) and __arg_match_D__(_1))
  @staticmethod
  def _match_alt_objective_Emosek_4fusion_4ObjectiveSense_2D(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Emosek_4fusion_4ObjectiveSense_2__(_0) and __arg_alt_match_D__(_1))
  def _objective_alt_Emosek_4fusion_4ObjectiveSense_2D(self,_t__0,_t__1):
    return self._objective_Emosek_4fusion_4ObjectiveSense_2D(__0,numpy.float64(__1))
  def _objective_Emosek_4fusion_4ObjectiveSense_2D(self,_0,_1):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2("",_0,mosek.fusion.Expr._constTerm_D(_1))
  @staticmethod
  def _match_objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Emosek_4fusion_4ObjectiveSense_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1))
  @staticmethod
  def _match_alt_objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Emosek_4fusion_4ObjectiveSense_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1))
  def _objective_alt_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(self,_t__0,_t__1):
    return self._objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(__0,_1)
  def _objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(self,_0,_1):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2("",_0,_1.asExpr())
  @staticmethod
  def _match_objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Emosek_4fusion_4ObjectiveSense_2__(_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_1))
  @staticmethod
  def _match_alt_objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Emosek_4fusion_4ObjectiveSense_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_1))
  def _objective_alt_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_t__0,_t__1):
    return self._objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(__0,_1)
  def _objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_0,_1):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2("",_0,_1)
  @staticmethod
  def _match_objective_SD(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_D__(_1))
  @staticmethod
  def _match_alt_objective_SD(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_D__(_1))
  def _objective_alt_SD(self,_t__0,_t__1):
    return self._objective_SD(_0,numpy.float64(__1))
  def _objective_SD(self,_0,_1):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(_0,mosek.fusion.ObjectiveSense.Minimize,mosek.fusion.Expr._constTerm_D(_1))
  @staticmethod
  def _match_objective_SEmosek_4fusion_4ObjectiveSense_2D(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Emosek_4fusion_4ObjectiveSense_2__(_1) and __arg_match_D__(_2))
  @staticmethod
  def _match_alt_objective_SEmosek_4fusion_4ObjectiveSense_2D(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Emosek_4fusion_4ObjectiveSense_2__(_1) and __arg_alt_match_D__(_2))
  def _objective_alt_SEmosek_4fusion_4ObjectiveSense_2D(self,_t__0,_t__1,_t__2):
    return self._objective_SEmosek_4fusion_4ObjectiveSense_2D(_0,__1,numpy.float64(__2))
  def _objective_SEmosek_4fusion_4ObjectiveSense_2D(self,_0,_1,_2):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(_0,_1,mosek.fusion.Expr._constTerm_D(_2))
  @staticmethod
  def _match_objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Emosek_4fusion_4ObjectiveSense_2__(_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_2))
  @staticmethod
  def _match_alt_objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Emosek_4fusion_4ObjectiveSense_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_2))
  def _objective_alt_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(self,_t__0,_t__1,_t__2):
    return self._objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(_0,__1,_2)
  def _objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Variable_2(self,_0,_1,_2):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(_0,_1,_2.asExpr())
  @staticmethod
  def _match_objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Emosek_4fusion_4ObjectiveSense_2__(_1) and __arg_match_Lmosek_4fusion_4Expression_2__(_2))
  @staticmethod
  def _match_alt_objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Emosek_4fusion_4ObjectiveSense_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_2))
  def _objective_alt_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_t__0,_t__1,_t__2):
    return self._objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(_0,__1,_2)
  def _objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_0,_1,_2):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(_0,_1,_2)
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4QConeDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4QConeDomain_2__(_1))
  def _constraint_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(self,_t__0,_t__1):
    return self._constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(_0,_1)
  def _constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2("",None,_0.asExpr(),_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Lmosek_4fusion_4QConeDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Lmosek_4fusion_4QConeDomain_2__(_2))
  def _constraint_alt_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(_0,_1,_2)
  def _constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(_0,None,_1.asExpr(),_2))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Set_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Lmosek_4fusion_4QConeDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Set_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Lmosek_4fusion_4QConeDomain_2__(_2))
  def _constraint_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(_0,_1,_2)
  def _constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2("",_0,_1.asExpr(),_2))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Set_2__(_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_2) and __arg_match_Lmosek_4fusion_4QConeDomain_2__(_3))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Set_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_2) and __arg_alt_match_Lmosek_4fusion_4QConeDomain_2__(_3))
  def _constraint_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(self,_t__0,_t__1,_t__2,_t__3):
    return self._constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(_0,_1,_2,_3)
  def _constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4QConeDomain_2(self,_0,_1,_2,_3):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(_0,_1,_2.asExpr(),_3))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  def _constraint_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1):
    return self._constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(_0,_1)
  def _constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2("",None,_0.asExpr(),_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  def _constraint_alt_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(_0,_1,_2)
  def _constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0,None,_1.asExpr(),_2))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Set_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Set_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  def _constraint_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(_0,_1,_2)
  def _constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2("",_0,_1.asExpr(),_2))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Set_2__(_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_2) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_3))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Set_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_2) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_3))
  def _constraint_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1,_t__2,_t__3):
    return self._constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(_0,_1,_2,_3)
  def _constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(self,_0,_1,_2,_3):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0,_1,_2.asExpr(),_3))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  def _constraint_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1):
    return self._constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(_0,_1)
  def _constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2("",None,_0.asExpr(),_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  def _constraint_alt_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(_0,_1,_2)
  def _constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0,None,_1.asExpr(),_2))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Set_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Set_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  def _constraint_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(_0,_1,_2)
  def _constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2("",_0,_1.asExpr(),_2))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Set_2__(_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_2) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_3))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Set_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_2) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_3))
  def _constraint_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1,_t__2,_t__3):
    return self._constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(_0,_1,_2,_3)
  def _constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(self,_0,_1,_2,_3):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0,_1,_2.asExpr(),_3))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4LinPSDDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4LinPSDDomain_2__(_1))
  def _constraint_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(self,_t__0,_t__1):
    return self._constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(_0,_1)
  def _constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2("",_0.asExpr(),_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Lmosek_4fusion_4LinPSDDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Lmosek_4fusion_4LinPSDDomain_2__(_2))
  def _constraint_alt_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(_0,_1,_2)
  def _constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4LinPSDDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(_0,_1.asExpr(),_2))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_1))
  def _constraint_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1):
    return self._constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(_0,_1)
  def _constraint_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2("",_0.asExpr(),_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  def _constraint_alt_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(_0,_1,_2)
  def _constraint_SLmosek_4fusion_4Variable_2Lmosek_4fusion_4PSDDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_0,_1.asExpr(),_2))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_match_Lmosek_4fusion_4QConeDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_alt_match_Lmosek_4fusion_4QConeDomain_2__(_1))
  def _constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(self,_t__0,_t__1):
    return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(_0,_1)
  def _constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2("",None,_0,_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_match_Lmosek_4fusion_4QConeDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_alt_match_Lmosek_4fusion_4QConeDomain_2__(_2))
  def _constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(_0,_1,_2)
  def _constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(_0,None,_1,_2))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Set_2__(_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_match_Lmosek_4fusion_4QConeDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Set_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_alt_match_Lmosek_4fusion_4QConeDomain_2__(_2))
  def _constraint_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(_0,_1,_2)
  def _constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2("",_0,_1,_2))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Set_2__(_1) and __arg_match_Lmosek_4fusion_4Expression_2__(_2) and __arg_match_Lmosek_4fusion_4QConeDomain_2__(_3))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Set_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_2) and __arg_alt_match_Lmosek_4fusion_4QConeDomain_2__(_3))
  def _constraint_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(self,_t__0,_t__1,_t__2,_t__3):
    return self._constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(_0,_1,_2,_3)
  def _constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(self,_0,_1,_2,_3):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(_0,_1,_2,_3))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  def _constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1):
    return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0,_1)
  def _constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2("",None,_0,_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  def _constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0,_1,_2)
  def _constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0,None,_1,_2))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Set_2__(_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Set_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  def _constraint_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0,_1,_2)
  def _constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2("",_0,_1,_2))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Set_2__(_1) and __arg_match_Lmosek_4fusion_4Expression_2__(_2) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_3))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Set_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_2) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_3))
  def _constraint_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1,_t__2,_t__3):
    return self._constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0,_1,_2,_3)
  def _constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_0,_1,_2,_3):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0,_1,_2,_3))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  def _constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1):
    return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0,_1)
  def _constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2("",None,_0,_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  def _constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0,_1,_2)
  def _constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0,None,_1,_2))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Set_2__(_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Set_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  def _constraint_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0,_1,_2)
  def _constraint_Lmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2("",_0,_1,_2))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Set_2__(_1) and __arg_match_Lmosek_4fusion_4Expression_2__(_2) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_3))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Set_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_2) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_3))
  def _constraint_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1,_t__2,_t__3):
    return self._constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0,_1,_2,_3)
  def _constraint_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_0,_1,_2,_3):
   return (self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0,_1,_2,_3))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_match_Lmosek_4fusion_4LinPSDDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_alt_match_Lmosek_4fusion_4LinPSDDomain_2__(_1))
  def _constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(self,_t__0,_t__1):
    return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(_0,_1)
  def _constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2("",_0,_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_match_Lmosek_4fusion_4LinPSDDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_alt_match_Lmosek_4fusion_4LinPSDDomain_2__(_2))
  def _constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(_0,_1,_2)
  def _constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(_0,_1,_2))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_1))
  def _constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1):
    return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_0,_1)
  def _constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2("",_0,_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  def _constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_0,_1,_2)
  def _constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_0,_1,_2))
  @staticmethod
  def _match_variable_Lmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4LinPSDDomain_2__(_0))
  @staticmethod
  def _match_alt_variable_Lmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinPSDDomain_2__(_0))
  def _variable_alt_Lmosek_4fusion_4LinPSDDomain_2(self,_t__0):
    return self._variable_Lmosek_4fusion_4LinPSDDomain_2(_0)
  def _variable_Lmosek_4fusion_4LinPSDDomain_2(self,_0):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2("",(_0._shape),_0))
  @staticmethod
  def _match_variable_IILmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1) and __arg_match_Lmosek_4fusion_4LinPSDDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_IILmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_Lmosek_4fusion_4LinPSDDomain_2__(_2))
  def _variable_alt_IILmosek_4fusion_4LinPSDDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_IILmosek_4fusion_4LinPSDDomain_2(numpy.int32(__0),numpy.int32(__1),_2)
  def _variable_IILmosek_4fusion_4LinPSDDomain_2(self,_0,_1,_2):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2("",mosek.fusion.Set._make_III(_0,_0,_1),_2))
  @staticmethod
  def _match_variable_ILmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_Lmosek_4fusion_4LinPSDDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_ILmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_Lmosek_4fusion_4LinPSDDomain_2__(_1))
  def _variable_alt_ILmosek_4fusion_4LinPSDDomain_2(self,_t__0,_t__1):
    return self._variable_ILmosek_4fusion_4LinPSDDomain_2(numpy.int32(__0),_1)
  def _variable_ILmosek_4fusion_4LinPSDDomain_2(self,_0,_1):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2("",mosek.fusion.Set._make_II(_0,_0),_1))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4LinPSDDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4LinPSDDomain_2__(_1))
  def _variable_alt_SLmosek_4fusion_4LinPSDDomain_2(self,_t__0,_t__1):
    return self._variable_SLmosek_4fusion_4LinPSDDomain_2(_0,_1)
  def _variable_SLmosek_4fusion_4LinPSDDomain_2(self,_0,_1):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2(_0,None,_1))
  @staticmethod
  def _match_variable_SIILmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2) and __arg_match_Lmosek_4fusion_4LinPSDDomain_2__(_3))
  @staticmethod
  def _match_alt_variable_SIILmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_Lmosek_4fusion_4LinPSDDomain_2__(_3))
  def _variable_alt_SIILmosek_4fusion_4LinPSDDomain_2(self,_t__0,_t__1,_t__2,_t__3):
    return self._variable_SIILmosek_4fusion_4LinPSDDomain_2(_0,numpy.int32(__1),numpy.int32(__2),_3)
  def _variable_SIILmosek_4fusion_4LinPSDDomain_2(self,_0,_1,_2,_3):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2(_0,mosek.fusion.Set._make_III(_1,_1,_2),_3))
  @staticmethod
  def _match_variable_SILmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1) and __arg_match_Lmosek_4fusion_4LinPSDDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_SILmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_Lmosek_4fusion_4LinPSDDomain_2__(_2))
  def _variable_alt_SILmosek_4fusion_4LinPSDDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_SILmosek_4fusion_4LinPSDDomain_2(_0,numpy.int32(__1),_2)
  def _variable_SILmosek_4fusion_4LinPSDDomain_2(self,_0,_1,_2):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2(_0,mosek.fusion.Set._make_II(_1,_1),_2))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Set_2__(_1) and __arg_match_Lmosek_4fusion_4LinPSDDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Set_2__(_1) and __arg_alt_match_Lmosek_4fusion_4LinPSDDomain_2__(_2))
  def _variable_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2(_0,_1,_2)
  def _variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2(self,_0,_1,_2):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2(_0,_1,_2))
  @staticmethod
  def _match_variable_Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4PSDDomain_2__(_0))
  @staticmethod
  def _match_alt_variable_Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_0))
  def _variable_alt_Lmosek_4fusion_4PSDDomain_2(self,_t__0):
    return self._variable_Lmosek_4fusion_4PSDDomain_2(_0)
  def _variable_Lmosek_4fusion_4PSDDomain_2(self,_0):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2("",(_0._shape),_0))
  @staticmethod
  def _match_variable_IILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_IILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  def _variable_alt_IILmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_IILmosek_4fusion_4PSDDomain_2(numpy.int32(__0),numpy.int32(__1),_2)
  def _variable_IILmosek_4fusion_4PSDDomain_2(self,_0,_1,_2):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2("",mosek.fusion.Set._make_III(_0,_0,_1),_2))
  @staticmethod
  def _match_variable_ILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_ILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_1))
  def _variable_alt_ILmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1):
    return self._variable_ILmosek_4fusion_4PSDDomain_2(numpy.int32(__0),_1)
  def _variable_ILmosek_4fusion_4PSDDomain_2(self,_0,_1):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2("",mosek.fusion.Set._make_II(_0,_0),_1))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_1))
  def _variable_alt_SLmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1):
    return self._variable_SLmosek_4fusion_4PSDDomain_2(_0,_1)
  def _variable_SLmosek_4fusion_4PSDDomain_2(self,_0,_1):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2(_0,None,_1))
  @staticmethod
  def _match_variable_SIILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_3))
  @staticmethod
  def _match_alt_variable_SIILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_3))
  def _variable_alt_SIILmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1,_t__2,_t__3):
    return self._variable_SIILmosek_4fusion_4PSDDomain_2(_0,numpy.int32(__1),numpy.int32(__2),_3)
  def _variable_SIILmosek_4fusion_4PSDDomain_2(self,_0,_1,_2,_3):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2(_0,mosek.fusion.Set._make_III(_1,_1,_2),_3))
  @staticmethod
  def _match_variable_SILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_SILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  def _variable_alt_SILmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_SILmosek_4fusion_4PSDDomain_2(_0,numpy.int32(__1),_2)
  def _variable_SILmosek_4fusion_4PSDDomain_2(self,_0,_1,_2):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2(_0,mosek.fusion.Set._make_II(_1,_1),_2))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Set_2__(_1) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Set_2__(_1) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  def _variable_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2(_0,_1,_2)
  def _variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2(self,_0,_1,_2):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2(_0,_1,_2))
  @staticmethod
  def _match_variable_ILmosek_4fusion_4SymmetricLinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_Lmosek_4fusion_4SymmetricLinearDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_ILmosek_4fusion_4SymmetricLinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_Lmosek_4fusion_4SymmetricLinearDomain_2__(_1))
  def _variable_alt_ILmosek_4fusion_4SymmetricLinearDomain_2(self,_t__0,_t__1):
    return self._variable_ILmosek_4fusion_4SymmetricLinearDomain_2(numpy.int32(__0),_1)
  def _variable_ILmosek_4fusion_4SymmetricLinearDomain_2(self,_0,_1):
   return (self.__variable_1_SILmosek_4fusion_4SymmetricLinearDomain_2("",_0,_1))
  @staticmethod
  def _match_variable_SILmosek_4fusion_4SymmetricLinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1) and __arg_match_Lmosek_4fusion_4SymmetricLinearDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_SILmosek_4fusion_4SymmetricLinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_Lmosek_4fusion_4SymmetricLinearDomain_2__(_2))
  def _variable_alt_SILmosek_4fusion_4SymmetricLinearDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_SILmosek_4fusion_4SymmetricLinearDomain_2(_0,numpy.int32(__1),_2)
  def _variable_SILmosek_4fusion_4SymmetricLinearDomain_2(self,_0,_1,_2):
   return (self.__variable_1_SILmosek_4fusion_4SymmetricLinearDomain_2(_0,_1,_2))
  @staticmethod
  def _match_variable_Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4QConeDomain_2__(_0))
  @staticmethod
  def _match_alt_variable_Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4QConeDomain_2__(_0))
  def _variable_alt_Lmosek_4fusion_4QConeDomain_2(self,_t__0):
    return self._variable_Lmosek_4fusion_4QConeDomain_2(_0)
  def _variable_Lmosek_4fusion_4QConeDomain_2(self,_0):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2("",None,_0))
  @staticmethod
  def _match_variable_Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4RangeDomain_2__(_0))
  @staticmethod
  def _match_alt_variable_Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_0))
  def _variable_alt_Lmosek_4fusion_4RangeDomain_2(self,_t__0):
    return self._variable_Lmosek_4fusion_4RangeDomain_2(_0)
  def _variable_Lmosek_4fusion_4RangeDomain_2(self,_0):
   return (self.__ranged_1variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2("",None,_0))
  @staticmethod
  def _match_variable_Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4LinearDomain_2__(_0))
  @staticmethod
  def _match_alt_variable_Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_0))
  def _variable_alt_Lmosek_4fusion_4LinearDomain_2(self,_t__0):
    return self._variable_Lmosek_4fusion_4LinearDomain_2(_0)
  def _variable_Lmosek_4fusion_4LinearDomain_2(self,_0):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2("",None,_0))
  @staticmethod
  def _match_variable__3ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  @staticmethod
  def _match_alt_variable__3ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  def _variable_alt__3ILmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=_t__1
   _1 = self._variable__3ILmosek_4fusion_4RangeDomain_2(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _variable__3ILmosek_4fusion_4RangeDomain_2(self,_0,_1):
   return (self.__ranged_1variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2("",mosek.fusion.Set._make__3I(_0),_1))
  @staticmethod
  def _match_variable__3ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  @staticmethod
  def _match_alt_variable__3ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  def _variable_alt__3ILmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=_t__1
   _1 = self._variable__3ILmosek_4fusion_4LinearDomain_2(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _variable__3ILmosek_4fusion_4LinearDomain_2(self,_0,_1):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2("",mosek.fusion.Set._make__3I(_0),_1))
  @staticmethod
  def _match_variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Set_2__(_0) and __arg_match_Lmosek_4fusion_4QConeDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Set_2__(_0) and __arg_alt_match_Lmosek_4fusion_4QConeDomain_2__(_1))
  def _variable_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(self,_t__0,_t__1):
    return self._variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(_0,_1)
  def _variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(self,_0,_1):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2("",_0,_1))
  @staticmethod
  def _match_variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Set_2__(_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Set_2__(_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  def _variable_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1):
    return self._variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(_0,_1)
  def _variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(self,_0,_1):
   return (self.__ranged_1variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2("",_0,_1))
  @staticmethod
  def _match_variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Set_2__(_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Set_2__(_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  def _variable_alt_Lmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1):
    return self._variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(_0,_1)
  def _variable_Lmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(self,_0,_1):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2("",_0,_1))
  @staticmethod
  def _match_variable_ILmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_Lmosek_4fusion_4QConeDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_ILmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_Lmosek_4fusion_4QConeDomain_2__(_1))
  def _variable_alt_ILmosek_4fusion_4QConeDomain_2(self,_t__0,_t__1):
    return self._variable_ILmosek_4fusion_4QConeDomain_2(numpy.int32(__0),_1)
  def _variable_ILmosek_4fusion_4QConeDomain_2(self,_0,_1):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2("",mosek.fusion.Set._make_I(_0),_1))
  @staticmethod
  def _match_variable_ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  def _variable_alt_ILmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1):
    return self._variable_ILmosek_4fusion_4RangeDomain_2(numpy.int32(__0),_1)
  def _variable_ILmosek_4fusion_4RangeDomain_2(self,_0,_1):
   return (self.__ranged_1variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2("",mosek.fusion.Set._make_I(_0),_1))
  @staticmethod
  def _match_variable_ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  def _variable_alt_ILmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1):
    return self._variable_ILmosek_4fusion_4LinearDomain_2(numpy.int32(__0),_1)
  def _variable_ILmosek_4fusion_4LinearDomain_2(self,_0,_1):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2("",mosek.fusion.Set._make_I(_0),_1))
  @staticmethod
  def _match_variable__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_variable__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _variable_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1 = self._variable__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _variable__3I(self,_0):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2("",mosek.fusion.Set._make__3I(_0),mosek.fusion.Domain._unbounded_()))
  @staticmethod
  def _match_variable_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_variable_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _variable_alt_I(self,_t__0):
    return self._variable_I(numpy.int32(__0))
  def _variable_I(self,_0):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2("",mosek.fusion.Set._make_I(_0),mosek.fusion.Domain._unbounded_()))
  @staticmethod
  def _match_variable_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_variable_(*args):
    if len(args) != 0: return False
    return True
  def _variable_alt_(self,):
    return self._variable_()
  def _variable_(self,):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2("",mosek.fusion.Set._make_I(1),mosek.fusion.Domain._unbounded_()))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4QConeDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4QConeDomain_2__(_1))
  def _variable_alt_SLmosek_4fusion_4QConeDomain_2(self,_t__0,_t__1):
    return self._variable_SLmosek_4fusion_4QConeDomain_2(_0,_1)
  def _variable_SLmosek_4fusion_4QConeDomain_2(self,_0,_1):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(_0,None,_1))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  def _variable_alt_SLmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1):
    return self._variable_SLmosek_4fusion_4RangeDomain_2(_0,_1)
  def _variable_SLmosek_4fusion_4RangeDomain_2(self,_0,_1):
   return (self.__ranged_1variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(_0,None,_1))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  def _variable_alt_SLmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1):
    return self._variable_SLmosek_4fusion_4LinearDomain_2(_0,_1)
  def _variable_SLmosek_4fusion_4LinearDomain_2(self,_0,_1):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(_0,None,_1))
  @staticmethod
  def _match_variable_S_3ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match__3I__(_1) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_S_3ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  def _variable_alt_S_3ILmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=_t__2
   _1 = self._variable_S_3ILmosek_4fusion_4RangeDomain_2(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _variable_S_3ILmosek_4fusion_4RangeDomain_2(self,_0,_1,_2):
   return (self.__ranged_1variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(_0,mosek.fusion.Set._make__3I(_1),_2))
  @staticmethod
  def _match_variable_S_3ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match__3I__(_1) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_S_3ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  def _variable_alt_S_3ILmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=_t__2
   _1 = self._variable_S_3ILmosek_4fusion_4LinearDomain_2(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _variable_S_3ILmosek_4fusion_4LinearDomain_2(self,_0,_1,_2):
   return (self.variable(_0,mosek.fusion.Set._make__3I(_1),_2))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Set_2__(_1) and __arg_match_Lmosek_4fusion_4QConeDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Set_2__(_1) and __arg_alt_match_Lmosek_4fusion_4QConeDomain_2__(_2))
  def _variable_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(_0,_1,_2)
  def _variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(self,_0,_1,_2):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(_0,_1,_2))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Set_2__(_1) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Set_2__(_1) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  def _variable_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(_0,_1,_2)
  def _variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(self,_0,_1,_2):
   return (self.__ranged_1variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(_0,_1,_2))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Set_2__(_1) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Set_2__(_1) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  def _variable_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(_0,_1,_2)
  def _variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(self,_0,_1,_2):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(_0,_1,_2))
  @staticmethod
  def _match_variable_SILmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1) and __arg_match_Lmosek_4fusion_4QConeDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_SILmosek_4fusion_4QConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_Lmosek_4fusion_4QConeDomain_2__(_2))
  def _variable_alt_SILmosek_4fusion_4QConeDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_SILmosek_4fusion_4QConeDomain_2(_0,numpy.int32(__1),_2)
  def _variable_SILmosek_4fusion_4QConeDomain_2(self,_0,_1,_2):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(_0,mosek.fusion.Set._make_I(_1),_2))
  @staticmethod
  def _match_variable_SILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_SILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  def _variable_alt_SILmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_SILmosek_4fusion_4RangeDomain_2(_0,numpy.int32(__1),_2)
  def _variable_SILmosek_4fusion_4RangeDomain_2(self,_0,_1,_2):
   return (self.__ranged_1variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(_0,mosek.fusion.Set._make_I(_1),_2))
  @staticmethod
  def _match_variable_SILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_SILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  def _variable_alt_SILmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_SILmosek_4fusion_4LinearDomain_2(_0,numpy.int32(__1),_2)
  def _variable_SILmosek_4fusion_4LinearDomain_2(self,_0,_1,_2):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(_0,mosek.fusion.Set._make_I(_1),_2))
  @staticmethod
  def _match_variable_S_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_variable_S_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match__3I__(_1))
  def _variable_alt_S_3I(self,_t__0,_t__1):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self._variable_S_3I(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _variable_S_3I(self,_0,_1):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(_0,mosek.fusion.Set._make__3I(_1),mosek.fusion.Domain._unbounded_()))
  @staticmethod
  def _match_variable_SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_variable_SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1))
  def _variable_alt_SI(self,_t__0,_t__1):
    return self._variable_SI(_0,numpy.int32(__1))
  def _variable_SI(self,_0,_1):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(_0,mosek.fusion.Set._make_I(_1),mosek.fusion.Domain._unbounded_()))
  @staticmethod
  def _match_variable_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_variable_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _variable_alt_S(self,_t__0):
    return self._variable_S(_0)
  def _variable_S(self,_0):
   return (self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(_0,mosek.fusion.Set._make_I(1),mosek.fusion.Domain._unbounded_()))
  def __ranged_1variable_alt_SILmosek_4fusion_4SymmetricRangeDomain_2(self,_t__0,_t__1,_t__2):
    return self.__ranged_1variable_SILmosek_4fusion_4SymmetricRangeDomain_2(_0,numpy.int32(__1),_2)
  def __ranged_1variable_SILmosek_4fusion_4SymmetricRangeDomain_2(self,_0,_1,_2):
   _3=None
   if ((int(len(_0)) > 0) and self._hasVariable_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate variable name '")._a_S(_0)._a_S("'")._toString_())
   _4=_1
   if (_4 > 0):
    if (((_2._dim) > 0) and ((_2._dim)!=_4)):
     raise mosek_fusion_DimensionError._ctor_S("Mismatching shape and domain")
   else:
    _4 = ((_2._dim) if (((_2._dim) > 0) ) else 1)
   _5=self.__task_vars_used
   _6=self._task_1numcon_()
   _7=self._task_1numcone_()
   _8=self._task_1numbarvar_()
   try:
    _9=None
    _10=((_4 * (_4 + 1)) // 2)
    _11=0
    if (_2._sparse_flag):
     _11 = self.__task_1alloc_1vars_I(_10)
     self.__natvarmap_1ensure_I(_10)
     self.__natvarmap_num = (self.__natvarmap_num + _10)
     _12=numpy.array([_2._get_1lb_1item_J((((_13 * (_13 + 1)) // 2) + _14)) for _13 in range(0,_4) for _14 in range(0,_13)], dtype=numpy.dtype(numpy.float64))
     _15=numpy.array([_2._get_1ub_1item_J((((_16 * (_16 + 1)) // 2) + _17)) for _16 in range(0,_4) for _17 in range(0,_16)], dtype=numpy.dtype(numpy.float64))
     self._task_1var_1putboundslice_1ra_II_3D_3D(_11,(_11 + _10),_12,_15)
     _9 = numpy.zeros((_10,), dtype=numpy.dtype(numpy.int32))
     for _18 in range(0,_10):
      _9[_18] = (_11 + _18)
     for _19 in range(0,_10):
      self.__natvarmap_idx[(_19 + _11)] = numpy.int64(_19)
     for _20 in range(0,_10):
      self.__natvarmap_Var[(_20 + _11)] = self._vars_used
    _3 = mosek_fusion_SymRangedVariable._ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4RangeDomain_2I_3IJ(self,_0,_2,_4,_9,self._numVariables_())
    if (_2._cardinal_flag):
     _3.makeInteger()
   finally:
    if (_3 is None):
     self._task_1cleanup_IIII(_5,_6,_7,_8)
   self.__addVariable_SLmosek_4fusion_4ModelVariable_2(_0,_3)
   return (_3)
  def __ranged_1variable_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1,_t__2):
    return self.__ranged_1variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(_0,_1,_2)
  def __ranged_1variable_SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2(self,_0,_1,_2):
   _3=None
   if ((int(len(_0)) > 0) and self._hasVariable_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate variable name '")._a_S(_0)._a_S("'")._toString_())
   if (_1 is not None):
    if (not _2._match_1shape_Lmosek_4fusion_4Set_2(_1)):
     raise mosek_fusion_DimensionError._ctor_S("Mismatching shape and domain")
    _4 = _1
   else:
    _4 = (_2._shape)
    if (_4 is None):
     _4 = mosek_fusion_IntSet._ctor_I(1)
   _5=self.__task_vars_used
   _6=self._task_1numcon_()
   _7=self._task_1numcone_()
   _8=self._task_1numbarvar_()
   try:
    _9=None
    _10=numpy.int32((_4._size))
    _11=0
    if (not (_2._sparse_flag)):
     _11 = self.__task_1alloc_1vars_I(_10)
     self.__natvarmap_1ensure_I(_10)
     self.__natvarmap_num = (self.__natvarmap_num + _10)
     _12=numpy.array([_2._get_1lb_1item_J(_13) for _13 in range(0,_10)], dtype=numpy.dtype(numpy.float64))
     _14=numpy.array([_2._get_1ub_1item_J(_15) for _15 in range(0,_10)], dtype=numpy.dtype(numpy.float64))
     self._task_1var_1putboundslice_1ra_II_3D_3D(_11,(_11 + _10),_12,_14)
     _9 = numpy.zeros((_10,), dtype=numpy.dtype(numpy.int32))
     for _16 in range(0,_10):
      _9[_16] = (_11 + _16)
     for _17 in range(0,_10):
      self.__natvarmap_idx[(_17 + _11)] = numpy.int64(_17)
     for _18 in range(0,_10):
      self.__natvarmap_Var[(_18 + _11)] = self._vars_used
    _3 = mosek_fusion_RangedVariable._ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2_3IJ(self,_0,_4,_2,_9,self._numVariables_())
    if (_2._cardinal_flag):
     _3.makeInteger()
   finally:
    if (_3 is None):
     self._task_1cleanup_IIII(_5,_6,_7,_8)
   self.__addVariable_SLmosek_4fusion_4ModelVariable_2(_0,_3)
   return (_3)
  def __variable_1_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(self,_t__0,_t__1,_t__2):
    return self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(_0,_1,_2)
  def __variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4QConeDomain_2(self,_0,_1,_2):
   _3=None
   _4=None
   if ((int(len(_0)) > 0) and self._hasVariable_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate variable name '")._a_S(_0)._a_S("'")._toString_())
   _5=(_1 if ((_1 is not None) ) else ((_2._shape) if (((_2._shape) is not None) ) else mosek_fusion_IntSet._ctor_I(1)))
   if ((not _2._match_1shape_Lmosek_4fusion_4Set_2(_5)) or (_2.getAxis() >= (_5.nd))):
    raise mosek_fusion_DimensionError._ctor_S("Mismatching shape and domain")
   _6=(_2.getAxis() if (((_2._shape) is not None) ) else ((_5.nd) - 1))
   _7=_5.dim(_6)
   _8=1
   for _9 in range(0,(_5.nd)):
    if (_6!=_9):
     _8 *= _5.dim(_9)
   _10=1
   for _11 in range(0,_6):
    _10 *= _5.dim(_11)
   _12=1
   for _13 in range((_6 + 1),(_5.nd)):
    _12 *= _5.dim(_13)
   if ((((_2._key)==mosek.fusion.QConeKey.InQCone) and (_7 < 2)) or (((_2._key)==mosek.fusion.QConeKey.InRotatedQCone) and (_7 < 3))):
    raise mosek_fusion_DimensionError._ctor_S("Invalid size for cone")
   _14=self.__task_vars_used
   _15=self._task_1numcon_()
   _16=self._task_1numcone_()
   _17=self._task_1numbarvar_()
   try:
    _18=numpy.int32((_5._size))
    _19=self.__task_1alloc_1vars_I(_18)
    self.__natvarmap_1ensure_I(_18)
    self.__natvarmap_num = (self.__natvarmap_num + _18)
    _20=(_19 + _18)
    for _21 in range(0,(_20 - _19)):
     self.__natvarmap_idx[(_21 + _19)] = numpy.int64(_21)
    self._task_1var_1putboundslice_1fr_II(_19,_20)
    if (_2._int_flag):
     self._task_1var_1putintlist__3I(mosek.fusion.Utils.Tools._range_II(_19,_20))
    _23=numpy.array([(_24 + _19) for _24 in range(0,(_8 * _7))], dtype=numpy.dtype(numpy.int32))
    if ((_2._key)==mosek.fusion.QConeKey.InQCone):
     _22 = self._task_1append_1quadcone_IIIII(_7,_19,_8,_10,_12)
    else:
     _22 = self._task_1append_1rquadcone_IIIII(_7,_19,_8,_10,_12)
    _4 = mosek_fusion_ConicVariable._ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4QConeDomain_2Lmosek_4fusion_4Set_2_3IIIIJ(self,_0,_2,_5,_23,_7,_22,_8,self._numVariables_())
    if (_2._int_flag):
     pass
    for _25 in range(0,_18):
     self.__natvarmap_Var[(_25 + _19)] = self._vars_used
    _3 = _4
   finally:
    if (_3 is None):
     self.__natvarmap_num = _14
     self._natbarvarmap_num = _17
     self._task_1cleanup_IIII(_14,_15,_16,_17)
   self.__addVariable_SLmosek_4fusion_4ModelVariable_2(_0,_3)
   return (_3)
  def __variable_1_alt_SILmosek_4fusion_4SymmetricLinearDomain_2(self,_t__0,_t__1,_t__2):
    return self.__variable_1_SILmosek_4fusion_4SymmetricLinearDomain_2(_0,numpy.int32(__1),_2)
  def __variable_1_SILmosek_4fusion_4SymmetricLinearDomain_2(self,_0,_1,_2):
   _3=None
   if ((int(len(_0)) > 0) and self._hasVariable_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate variable name '")._a_S(_0)._a_S("'")._toString_())
   _4=_1
   if (_4 > 0):
    if (((_2._dim) > 0) and ((_2._dim)!=_4)):
     raise mosek_fusion_DimensionError._ctor_S("Mismatching shape and domain")
   else:
    _4 = ((_2._dim) if (((_2._dim) > 0) ) else 1)
   _5=self.__task_vars_used
   _6=self._task_1numcon_()
   _7=self._task_1numcone_()
   _8=self._task_1numbarvar_()
   try:
    _9=None
    _10=(_2._key)
    _11=((_4 * (_4 + 1)) // 2)
    _12=0
    if (not (_2._sparse_flag)):
     _12 = self.__task_1alloc_1vars_I(_11)
     self.__natvarmap_1ensure_I(_11)
     self.__natvarmap_num = (self.__natvarmap_num + _11)
     if (_10==mosek.fusion.RelationKey.IsFree):
      self._task_1var_1putboundslice_1fr_II(_12,(_12 + _11))
     else:
      _13=numpy.zeros((_11,), dtype=numpy.dtype(numpy.float64))
      _14=0
      for _15 in range(0,_4):
       for _16 in range(0,_15):
        _13[_14] = _2._get_1rhs_1item_J(((_15 * _4) + _16))
        _14 += 1
      if (_10==mosek.fusion.RelationKey.LessThan):
       self._task_1var_1putboundslice_1up_II_3D(_12,(_12 + _11),_13)
      elif (_10==mosek.fusion.RelationKey.GreaterThan):
       self._task_1var_1putboundslice_1lo_II_3D(_12,(_12 + _11),_13)
      elif (_10==mosek.fusion.RelationKey.EqualsTo):
       self._task_1var_1putboundslice_1fx_II_3D(_12,(_12 + _11),_13)
     _9 = numpy.array([(_12 + _17) for _17 in range(0,_11)], dtype=numpy.dtype(numpy.int32))
     for _18 in range(0,_11):
      self.__natvarmap_idx[(_18 + _12)] = numpy.int64(_18)
    _3 = mosek_fusion_SymLinearVariable._ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4SymmetricLinearDomain_2I_3IJ(self,_0,_2,_4,_9,self._numVariables_())
    if (_2._cardinal_flag):
     _3.makeInteger()
    if (not (_2._sparse_flag)):
     for _19 in range(0,_11):
      self.__natvarmap_Var[(_19 + _12)] = self._vars_used
   finally:
    if (_3 is None):
     self._task_1cleanup_IIII(_5,_6,_7,_8)
   self.__addVariable_SLmosek_4fusion_4ModelVariable_2(_0,_3)
   return (_3)
  def __variable_1_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1,_t__2):
    return self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(_0,_1,_2)
  def __variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinearDomain_2(self,_0,_1,_2):
   _3=None
   _4=None
   if ((int(len(_0)) > 0) and self._hasVariable_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate variable name '")._a_S(_0)._a_S("'")._toString_())
   if (_1 is not None):
    if (not _2._match_1shape_Lmosek_4fusion_4Set_2(_1)):
     raise mosek_fusion_DimensionError._ctor_S("Mismatching shape and domain")
    _5 = _1
   else:
    _5 = (_2._shape)
    if (_5 is None):
     _5 = mosek_fusion_IntSet._ctor_I(1)
   _6=self.__task_vars_used
   _7=self._task_1numcon_()
   _8=self._task_1numcone_()
   _9=self._task_1numbarvar_()
   try:
    _10=None
    _11=(_2._key)
    _12=numpy.int32((_5._size))
    _13=0
    if (not (_2._sparse_flag)):
     _13 = self.__task_1alloc_1vars_I(_12)
     self.__natvarmap_1ensure_I(_12)
     self.__natvarmap_num = (self.__natvarmap_num + _12)
     if (_11==mosek.fusion.RelationKey.IsFree):
      self._task_1var_1putboundslice_1fr_II(_13,(_13 + _12))
     else:
      _14=numpy.zeros((_12,), dtype=numpy.dtype(numpy.float64))
      for _15 in range(0,_12):
       _14[_15] = _2._get_1rhs_1item_J(numpy.int64(_15))
      if (_11==mosek.fusion.RelationKey.LessThan):
       self._task_1var_1putboundslice_1up_II_3D(_13,(_13 + _12),_14)
      elif (_11==mosek.fusion.RelationKey.GreaterThan):
       self._task_1var_1putboundslice_1lo_II_3D(_13,(_13 + _12),_14)
      elif (_11==mosek.fusion.RelationKey.EqualsTo):
       self._task_1var_1putboundslice_1fx_II_3D(_13,(_13 + _12),_14)
     _10 = numpy.array([(_13 + _16) for _16 in range(0,_12)], dtype=numpy.dtype(numpy.int32))
     for _17 in range(0,_12):
      self.__natvarmap_idx[(_17 + _13)] = numpy.int64(_17)
    _4 = mosek_fusion_LinearVariable._ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4LinearDomain_2Lmosek_4fusion_4Set_2_3IJ(self,_0,_2,_5,_10,self._numVariables_())
    if (_2._cardinal_flag):
     pass
    _3 = _4
    if (_2._cardinal_flag):
     _4.makeInteger()
    if (not (_2._sparse_flag)):
     for _18 in range(0,_12):
      self.__natvarmap_Var[(_18 + _13)] = self._vars_used
   finally:
    if (_3 is None):
     self._task_1cleanup_IIII(_6,_7,_8,_9)
   self.__addVariable_SLmosek_4fusion_4ModelVariable_2(_0,_3)
   return (_3)
  def __variable_1_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2(self,_t__0,_t__1,_t__2):
    return self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2(_0,_1,_2)
  def __variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4LinPSDDomain_2(self,_0,_1,_2):
   _3=None
   if (_1 is None):
    if ((_2._shape) is None):
     raise mosek_fusion_DimensionError._ctor_S("Missing shape for variable")
    else:
     _3 = (_2._shape)
   elif ((_2._shape) is None):
    _3 = _1
   else:
    if (((_1.nd)!=((_2._shape).nd)) or ((_1.dim(0)!=(_2._shape).dim(0)) or (_1.dim(1)!=(_2._shape).dim(1)))):
     raise mosek_fusion_DimensionError._ctor_S("Ambiguous dimensions for variable")
    else:
     _3 = _1
   _4=_3.dim(0)
   _5=numpy.int32(((mosek.fusion.Utils.Tools._sqrt_D((1 + (8 * _4))) - 1) / 2))
   if (((_5 * (_5 + 1)) // 2)!=_4):
    raise mosek_fusion_DimensionError._ctor_S("Invalid size for semidefinite variable")
   _6=1
   for _7 in range(1,(_3.nd)):
    _6 *= _3.dim(_7)
   _8=self._task_1append_1barvar_II(_5,_6)
   _9=mosek_fusion_LinearPSDVariable._ctor_Lmosek_4fusion_4Model_2SILmosek_4fusion_4Set_2IJ(self,_0,_5,_3,_8,self._numVariables_())
   self.__natbarvarmap_1ensure_I(1)
   self._natbarvarmap_Var[self._natbarvarmap_num] = self._vars_used
   self._natbarvarmap_num += 1
   self.__addVariable_SLmosek_4fusion_4ModelVariable_2(_0,_9)
   return (_9)
  def __variable_1_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1,_t__2):
    return self.__variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2(_0,_1,_2)
  def __variable_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4PSDDomain_2(self,_0,_1,_2):
   if (_1 is not None):
    if (((_1.nd)!=2) and ((_1.nd)!=3)):
     raise mosek_fusion_DimensionError._ctor_S("Invalid shape for semidefinite variables")
    elif (_1.dim(0)!=_1.dim(1)):
     raise mosek_fusion_DimensionError._ctor_S("Invalid shape for semidefinite variables")
    _3 = _1.dim(0)
    if ((_1.nd) > 2):
     _4 = _1.dim(2)
    else:
     _4 = 1
    if (((_2._shape) is not None) and (((_2._shape).dim(0)!=_3) or ((((_2._shape).nd)==3) and ((_2._shape).dim(2)!=_4)))):
     raise mosek_fusion_DomainError._ctor_S("Domain and shape do not match")
   else:
    if ((_2._shape) is None):
     raise mosek_fusion_DomainError._ctor_S("Either domain size of shape must be defined")
    else:
     _3 = (_2._shape).dim(0)
     _4 = (_2._shape).dim(2)
   _5=self._task_1append_1barvar_II(_3,_4)
   _6=mosek_fusion_PSDVariable._ctor_Lmosek_4fusion_4Model_2SIIIJ(self,_0,_3,_5,_4,self._numVariables_())
   self.__natbarvarmap_1ensure_I(1)
   self._natbarvarmap_Var[self._natbarvarmap_num] = self._vars_used
   self._natbarvarmap_num += 1
   self.__addVariable_SLmosek_4fusion_4ModelVariable_2(_0,_6)
   return (_6)
  def __constraint_1_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1,_t__2,_t__3):
    return self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0,_1,_2,_3)
  def __constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_0,_1,_2,_3):
   _4=None
   if ((int(len(_0)) > 0) and self._hasConstraint_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate constraint name '")._a_S(_0)._a_S("'")._toString_())
   _5 = (_1 if ((_1 is not None) ) else _2.getShape())
   if (not _3._match_1shape_Lmosek_4fusion_4Set_2(_5)):
    raise mosek_fusion_DimensionError._ctor_S("Mismatching shape and domain")
   _6=_2.eval()
   for _7 in range(0,int(((_6.x)).shape[0])):
    if (((_6.x)[_7].getModel() is not None) and ((_6.x)[_7].getModel() is not self)):
     raise mosek_fusion_ModelError._ctor_S("Expression belong to different models")
   _8=self.__build_1conA__3JJ_3J_3J_3D_3D_3Lmosek_4fusion_4Variable_2((_6.ptrb),(_5._size),(_6.inst),(_6.subj),(_6.cof),(_6.bfix),(_6.x))
   _9=(int(((_8.ptrb)).shape[0]) - 1)
   _10=self.__task_vars_used
   _11=self._task_1numcone_()
   _12=self._task_1numcon_()
   _13=self._task_1numbarvar_()
   try:
    _14=_9
    _15=self._task_1append_1con_I(_14)
    _16=(_15 + _14)
    if (int(len(_0)) > 0):
     _17=mosek.fusion.Utils.StringBuffer()
     _18=0
     while (_18 < _14):
      _17._clear_()._a_S(_0)._a_S("[")._a_I(_18)._a_S("]")
      self._task_1con_1name_IS((_18 + _15),_17._toString_())
      _18 += 1
    if (((_8.subj) is not None) and (int(((_8.subj)).shape[0]) > 0)):
     self._task_1putarowslice_II_3J_3I_3D(_15,_16,(_8.ptrb),(_8.subj),(_8.cof))
    if ((_8.barsubi) is not None):
     for _19 in range(0,int(((_8.barsubi)).shape[0])):
      self._task_1putbaraij_III(((_8.barsubi)[_19] + _15),(_8.barsubj)[_19],(_8.barmidx)[_19])
    _20=numpy.zeros((_9,), dtype=numpy.dtype(numpy.float64))
    _21=numpy.zeros((_9,), dtype=numpy.dtype(numpy.float64))
    if ((_8.bfix) is not None):
     for _22 in range(0,_9):
      _20[_22] = (_3._get_1lb_1item_J(numpy.int64(_22)) - (_8.bfix)[_22])
      _21[_22] = (_3._get_1ub_1item_J(numpy.int64(_22)) - (_8.bfix)[_22])
    else:
     _23=(int(((_8.ptrb)).shape[0]) - 1)
     for _24 in range(0,_9):
      _20[_24] = _3._get_1lb_1item_J(numpy.int64(_24))
      _21[_24] = _3._get_1ub_1item_J(numpy.int64(_24))
    _25=mosek.fusion.Utils.Tools._range_II(_15,_16)
    self._task_1con_1putboundslice_1ra_II_3D_3D(_15,_16,_20,_21)
    _4 = mosek_fusion_RangedConstraint._ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2_3I_3J_3I_3D_3D_3I_3I_3I(self,_0,_5,_3,_25,(_8.ptrb),(_8.subj),(_8.cof),(_8.bfix),(_8.barsubi),(_8.barsubj),(_8.barmidx))
    self.__addConstraint_SLmosek_4fusion_4ModelConstraint_2(_0,_4)
   finally:
    if (_4 is None):
     self.__natvarmap_num = _10
     self._natbarvarmap_num = _13
     self._task_1cleanup_IIII(_10,_12,_11,_13)
   return (_4)
  def __constraint_1_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(self,_t__0,_t__1,_t__2,_t__3):
    return self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(_0,_1,_2,_3)
  def __constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4QConeDomain_2(self,_0,_1,_2,_3):
   _4=None
   _5=numpy.int32((_2.getShape()._size))
   if ((int(len(_0)) > 0) and self._hasConstraint_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate constraint name '")._a_S(_0)._a_S("'")._toString_())
   _6=(_1 if ((_1 is not None) ) else ((_3._shape) if (((_3._shape) is not None) ) else _2.getShape()))
   if ((((_3._shape) is not None) and (not _3._match_1shape_Lmosek_4fusion_4Set_2(_6))) or ((_2.getShape() is not None) and (not _6.compare(_2.getShape())))):
    raise mosek_fusion_DimensionError._ctor_S("Mismatching shape and domain")
   _7=(_3.getAxis() if (((_3._shape) is not None) ) else ((_6.nd) - 1))
   _8=_6.dim(_7)
   _9=1
   for _10 in range(0,(_6.nd)):
    if (_7!=_10):
     _9 *= _6.dim(_10)
   _11=1
   for _12 in range(0,_7):
    _11 *= _6.dim(_12)
   _13=1
   for _14 in range((_7 + 1),(_6.nd)):
    _13 *= _6.dim(_14)
   _15=_2.eval()
   for _16 in range(0,int(((_15.x)).shape[0])):
    if (((_15.x)[_16].getModel() is not None) and ((_15.x)[_16].getModel() is not self)):
     raise mosek_fusion_ModelError._ctor_S("Expression belong to different models")
   _17=self.__build_1conA__3JJ_3J_3J_3D_3D_3Lmosek_4fusion_4Variable_2((_15.ptrb),(_6._size),(_15.inst),(_15.subj),(_15.cof),(_15.bfix),(_15.x))
   _18=(int(((_17.ptrb)).shape[0]) - 1)
   _19=self.__task_vars_used
   _20=self._task_1numcon_()
   _21=self._task_1numcone_()
   _22=self._task_1numbarvar_()
   try:
    _23=self._task_1append_1con_I(_18)
    _24=(_23 + _18)
    if (((_17.subj) is not None) and (int(((_17.subj)).shape[0]) > 0)):
     self._task_1putarowslice_II_3J_3I_3D(_23,_24,(_17.ptrb),(_17.subj),(_17.cof))
    if ((_17.barsubi) is not None):
     for _25 in range(0,int(((_17.barsubi)).shape[0])):
      self._task_1putbaraij_III(((_17.barsubi)[_25] + _23),(_17.barsubj)[_25],(_17.barmidx)[_25])
    _26=mosek.fusion.Utils.Tools._range_II(_23,_24)
    _27=numpy.zeros(((_24 - _23),), dtype=numpy.dtype(numpy.float64))
    _28=(_8 * _9)
    _29=numpy.zeros((_28,), dtype=numpy.dtype(numpy.float64))
    _30=(_17.bfix)
    _31=(_15.bfix)
    if ((_17.bfix) is None):
     for _32 in range(0,(_24 - _23)):
      _27[_32] = (- (_17.bfix)[_32])
    if ((_15.bfix) is not None):
     for _33 in range(0,_28):
      _29[_33] = (- (_17.bfix)[_33])
    self._task_1con_1putboundslice_1fx_II_3D(_23,_24,_29)
    _34=self.__task_1alloc_1vars_I(_28)
    self.__natvarmap_1ensure_I(_28)
    self.__natvarmap_num = (self.__natvarmap_num + _28)
    _35=(_34 + _28)
    self._task_1putaijlist__3I_3I_3DJ(mosek.fusion.Utils.Tools._range_II(_23,_24),mosek.fusion.Utils.Tools._range_II(_34,_35),numpy.array([(- 1.0) for _36 in range(0,_28)], dtype=numpy.dtype(numpy.float64)),_28)
    self._task_1var_1putboundslice_1fr_II(_34,_35)
    if ((_3._key)==mosek.fusion.QConeKey.InQCone):
     _37 = self._task_1append_1quadcone_IIIII(_8,_34,_9,_11,_13)
    else:
     _37 = self._task_1append_1rquadcone_IIIII(_8,_34,_9,_11,_13)
    _4 = mosek_fusion_ConicConstraint._ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4QConeDomain_2Lmosek_4fusion_4Set_2_3IIIIII_3J_3I_3D_3D_3I_3I_3I(self,_0,_3,_6,mosek.fusion.Utils.Tools._range_II(_23,_24),_34,_35,_8,_37,_9,(_17.ptrb),(_17.subj),(_17.cof),(_17.bfix),(_17.barsubi),(_17.barsubj),(_17.barmidx))
    self.__addConstraint_SLmosek_4fusion_4ModelConstraint_2(_0,_4)
    return (_4)
   finally:
    if (_4 is None):
     self.__natvarmap_num = _19
     self._natbarvarmap_num = _22
     self._task_1cleanup_IIII(_19,_20,_21,_22)
  def __constraint_1_alt_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1,_t__2,_t__3):
    return self.__constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0,_1,_2,_3)
  def __constraint_1_SLmosek_4fusion_4Set_2Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_0,_1,_2,_3):
   _4=None
   _5=numpy.int32((_2.getShape()._size))
   if ((int(len(_0)) > 0) and self._hasConstraint_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate constraint name '")._a_S(_0)._a_S("'")._toString_())
   _6 = (_1 if ((_1 is not None) ) else ((_3._shape) if (((_3._shape) is not None) ) else _2.getShape()))
   if ((((_3._shape) is not None) and (not _3._match_1shape_Lmosek_4fusion_4Set_2(_6))) or ((_2.getShape() is not None) and (not _6.compare(_2.getShape())))):
    raise mosek_fusion_DimensionError._ctor_S("Mismatching shape and domain")
   _7=_2.eval()
   for _8 in range(0,int(((_7.x)).shape[0])):
    if (((_7.x)[_8].getModel() is not None) and ((_7.x)[_8].getModel() is not self)):
     raise mosek_fusion_ModelError._ctor_S("Expression belong to different models")
   _9=self.__build_1conA__3JJ_3J_3J_3D_3D_3Lmosek_4fusion_4Variable_2((_7.ptrb),(_6._size),(_7.inst),(_7.subj),(_7.cof),(_7.bfix),(_7.x))
   _10=(int(((_9.ptrb)).shape[0]) - 1)
   _11=self.__task_vars_used
   _12=self._task_1numcon_()
   _13=self._task_1numcone_()
   _14=self._task_1numbarvar_()
   try:
    _15=_10
    _16=self._task_1append_1con_I(_15)
    _17=(_16 + _15)
    if (((_9.subj) is not None) and (int(((_9.subj)).shape[0]) > 0)):
     self._task_1putarowslice_II_3J_3I_3D(_16,_17,(_9.ptrb),(_9.subj),(_9.cof))
    if ((_9.barsubi) is not None):
     for _18 in range(0,int(((_9.barsubi)).shape[0])):
      self._task_1putbaraij_III(((_9.barsubi)[_18] + _16),(_9.barsubj)[_18],(_9.barmidx)[_18])
    _19=mosek.fusion.Utils.Tools._range_II(_16,_17)
    _20=(numpy.array([_3._get_1rhs_1item_J(_21) for _21 in range(0,(_17 - _16))], dtype=numpy.dtype(numpy.float64)) if (((_9.bfix) is None) ) else numpy.array([(_3._get_1rhs_1item_J(_22) - (_9.bfix)[_22]) for _22 in range(0,(_17 - _16))], dtype=numpy.dtype(numpy.float64)))
    _23=(_3._key)
    if (_23==mosek.fusion.RelationKey.IsFree):
     self._task_1con_1putboundslice_1fr_II(_16,_17)
    elif (_23==mosek.fusion.RelationKey.LessThan):
     self._task_1con_1putboundslice_1up_II_3D(_16,_17,_20)
    elif (_23==mosek.fusion.RelationKey.GreaterThan):
     self._task_1con_1putboundslice_1lo_II_3D(_16,_17,_20)
    else:
     self._task_1con_1putboundslice_1fx_II_3D(_16,_17,_20)
    _4 = mosek_fusion_LinearConstraint._ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4LinearDomain_2Lmosek_4fusion_4Set_2_3I_3J_3I_3D_3D_3I_3I_3I(self,_0,_3,_6,_19,(_9.ptrb),(_9.subj),(_9.cof),(_9.bfix),(_9.barsubi),(_9.barsubj),(_9.barmidx))
    self.__addConstraint_SLmosek_4fusion_4ModelConstraint_2(_0,_4)
    return (_4)
   finally:
    if (_4 is None):
     self.__natvarmap_num = _11
     self._natbarvarmap_num = _14
     self._task_1cleanup_IIII(_11,_12,_13,_14)
  def __build_1conA_alt__3JJ_3J_3J_3D_3D_3Lmosek_4fusion_4Variable_2(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int64))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.float64))
   _6=numpy.array(_t__6,dtype=numpy.dtype(object))
   _1 = self.__build_1conA__3JJ_3J_3J_3D_3D_3Lmosek_4fusion_4Variable_2(_0,_1,_2,_3,_4,_5,_6)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def __build_1conA__3JJ_3J_3J_3D_3D_3Lmosek_4fusion_4Variable_2(self,_0,_1,_2,_3,_4,_5,_6):
   _7=None
   _8=numpy.zeros(((_1 + 1),), dtype=numpy.dtype(numpy.int64))
   _9=None
   _10=(_2 if ((_2 is not None) ) else numpy.array([_11 for _11 in range(0,(int((_0).shape[0]) - 1))], dtype=numpy.dtype(numpy.int64)))
   _12=_5
   _13=0
   _14=0
   _19=int((_3).shape[0])
   _15 = numpy.zeros((_19,), dtype=numpy.dtype(numpy.int32))
   _16 = numpy.zeros((_19,), dtype=numpy.dtype(numpy.int32))
   _17 = numpy.zeros((_19,), dtype=numpy.dtype(numpy.int32))
   _20=numpy.zeros((_19,), dtype=numpy.dtype(numpy.int32))
   mosek.fusion.Model.__inst__3Lmosek_4fusion_4Variable_2_3J_3I_3I_3I(_6,_3,_15,_16,_17)
   _18 = mosek.fusion.Utils.Tools._range_J(long((_3).shape[0]))
   if (_19 > (3 * int((_0).shape[0]))):
    for _21 in range(0,(int((_0).shape[0]) - 1)):
     mosek.fusion.Sort._argsort__3J_3IJJZ(_18,_15,_0[_21],_0[(_21 + 1)],True)
     for _22 in range(_0[_21],_0[(_21 + 1)]):
      _20[_22] = _21
   else:
    for _23 in range(0,(int((_0).shape[0]) - 1)):
     for _24 in range(_0[_23],_0[(_23 + 1)]):
      _20[_24] = _23
    mosek.fusion.Sort._argsort__3J_3I_3IJJZ(_18,_20,_15,0,int((_18).shape[0]),True)
   _14 = 0
   _13 = 0
   if (int((_18).shape[0]) > 0):
    if (_15[_18[0]] >= 0):
     _14 += 1
    else:
     _13 += 1
    for _25 in range(1,_19):
     if (_15[_18[_25]] < 0):
      _13 += 1
     elif ((_20[_18[_25]]!=_20[_18[(_25 - 1)]]) or (_15[_18[_25]]!=_15[_18[(_25 - 1)]])):
      _14 += 1
   if (_14==_19):
    _7 = _15
    _9 = _4
    if (int((_10).shape[0])==_1):
     _8 = _0
    else:
     _26=0
     for _27 in range(0,(int((_8).shape[0]) - 1)):
      if ((_26 < int((_10).shape[0])) and (_27==_10[_26])):
       _26 += 1
       _8[(_27 + 1)] = _0[_26]
      else:
       _8[(_27 + 1)] = _8[_27]
   else:
    _28=0
    _29=0
    _7 = numpy.zeros((_14,), dtype=numpy.dtype(numpy.int32))
    _9 = numpy.zeros((_14,), dtype=numpy.dtype(numpy.float64))
    _30=0
    for _31 in range(0,(int((_8).shape[0]) - 1)):
     if ((_30 >= int((_10).shape[0])) or (_31!=_10[_30])):
      _8[(_31 + 1)] = _8[_31]
     else:
      _32=_0[_30]
      while ((_32 < _0[(_30 + 1)]) and (_15[_18[_32]] < 0)):
       _32 += 1
      _33=_32
      while (_33 < _0[(_30 + 1)]):
       _33 += 1
      if (_33 > _32):
       _34=0
       _7[_8[_31]] = _15[_18[_32]]
       _9[_8[_31]] = _4[_18[_32]]
       for _35 in range((_32 + 1),_33):
        if (_15[_18[(_35 - 1)]]!=_15[_18[_35]]):
         _34 += 1
         _7[(_34 + _8[_31])] = _15[_18[_35]]
         _9[(_34 + _8[_31])] = _4[_18[_35]]
        else:
         _9[(_34 + _8[_31])] += _4[_18[_35]]
       _8[(_31 + 1)] = ((_8[_31] + _34) + 1)
      else:
       _8[(_31 + 1)] = _8[_31]
      _30 += 1
   _36=_8
   _37=None
   _38=None
   _39=None
   _40=0
   if (_13 > 0):
    for _41 in range(0,(int((_0).shape[0]) - 1)):
     _42=_0[_41]
     while ((_42 < _0[(_41 + 1)]) and (_15[_18[_42]] < 0)):
      _42 += 1
     if (_42 > _0[_41]):
      _40 += 1
      for _43 in range((_0[_41] + 1),_42):
       if (_15[_18[(_43 - 1)]]!=_15[_18[_43]]):
        _40 += 1
    if (_40 > 0):
     _44=0
     _37 = numpy.zeros((_40,), dtype=numpy.dtype(numpy.int32))
     _38 = numpy.zeros((_40,), dtype=numpy.dtype(numpy.int32))
     _39 = numpy.zeros((_40,), dtype=numpy.dtype(numpy.int32))
     for _45 in range(0,(int((_0).shape[0]) - 1)):
      _46=_0[_45]
      while ((_46 < _0[(_45 + 1)]) and (_15[_18[_46]] < 0)):
       _47=_46
       _48=_15[_18[_46]]
       _46 += 1
       while ((_46 < _0[(_45 + 1)]) and (_15[_18[_46]]==_48)):
        _46 += 1
       _49=(- (_48 + 1))
       _50=self._task_1barvardim_I(_49)
       for _51 in range(_47,_46):
        _52=_18[_51]
        if (_16[_52] < _17[_52]):
         _53=_16[_52]
         _16[_52] = _17[_52]
         _17[_52] = _53
         _4[_52] *= 0.5
        elif (_16[_52] > _17[_52]):
         _4[_52] *= 0.5
       if ((_46 - _47) > 1):
        if ((_46 - _47) < (2 * _50)):
         mosek.fusion.Sort._argsort__3J_3I_3IJJZ(_18,_16,_17,_47,_46,True)
        else:
         mosek.fusion.Sort._argbucketsort__3J_3IJJII(_18,_17,_47,_46,0,_50)
         mosek.fusion.Sort._argbucketsort__3J_3IJJII(_18,_16,_47,_46,0,_50)
       _54=1
       for _55 in range((_47 + 1),_46):
        if ((_17[_18[_55]]!=_17[_18[(_55 - 1)]]) or (_16[_18[_55]]!=_16[_18[(_55 - 1)]])):
         _54 += 1
       _56=numpy.zeros((_54,), dtype=numpy.dtype(numpy.int32))
       _57=numpy.zeros((_54,), dtype=numpy.dtype(numpy.int32))
       _58=numpy.zeros((_54,), dtype=numpy.dtype(numpy.float64))
       _59=0
       _56[0] = _16[_18[_47]]
       _57[0] = _17[_18[_47]]
       _58[0] = _4[_18[_47]]
       for _60 in range((_47 + 1),_46):
        if ((_17[_18[_60]]!=_17[_18[(_60 - 1)]]) or (_16[_18[_60]]!=_16[_18[(_60 - 1)]])):
         _59 += 1
         _56[_59] = _16[_18[_60]]
         _57[_59] = _17[_18[_60]]
         _58[_59] = _4[_18[_60]]
        else:
         _58[_59] += _4[_18[_60]]
       _37[_44] = numpy.int32(_10[_45])
       _38[_44] = _49
       _39[_44] = self._task_1append_1barmatrix_I_3I_3I_3D(_50,_56,_57,_58)
       _44 += 1
   _61=numpy.zeros((_1,), dtype=numpy.dtype(numpy.float64))
   if (_5 is not None):
    for _62 in range(0,int((_10).shape[0])):
     _61[_10[_62]] = _5[_62]
   return (mosek_fusion_ConNZStruct._ctor__3J_3I_3D_3D_3I_3I_3I(_8,_7,_9,_61,_37,_38,_39))
  def __constraint_1_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(self,_t__0,_t__1,_t__2):
    return self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(_0,_1,_2)
  def __constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinPSDDomain_2(self,_0,_1,_2):
   _3=None
   _4=numpy.int32((_1.getShape()._size))
   if ((int(len(_0)) > 0) and self._hasConstraint_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate constraint name '")._a_S(_0)._a_S("'")._toString_())
   _5=((_2._shape) if (((_2._shape) is not None) ) else _1.getShape())
   if ((((_2._shape) is not None) and (not (_2._shape).compare(_5))) or ((_1.getShape() is not None) and (not _5.compare(_1.getShape())))):
    raise mosek_fusion_DimensionError._ctor_S("Mismatching shape and domain")
   _6=numpy.int32(((mosek.fusion.Utils.Tools._sqrt_D((1 + (8 * _5.dim(0)))) - 1) / 2))
   if (((_6 * (_6 + 1)) // 2)!=_5.dim(0)):
    raise mosek_fusion_DimensionError._ctor_S("Invalid size for semidefinite variable")
   _7=0
   _8=_5.dim(0)
   _9=1
   for _10 in range(1,(_5.nd)):
    _9 *= _5.dim(_10)
   _11=_1.eval()
   for _12 in range(0,int(((_11.x)).shape[0])):
    if (((_11.x)[_12].getModel() is not None) and ((_11.x)[_12].getModel() is not self)):
     raise mosek_fusion_ModelError._ctor_S("Expression belong to different models")
   _13=self.__build_1conA__3JJ_3J_3J_3D_3D_3Lmosek_4fusion_4Variable_2((_11.ptrb),(_5._size),(_11.inst),(_11.subj),(_11.cof),(_11.bfix),(_11.x))
   _14=(int(((_13.ptrb)).shape[0]) - 1)
   _15=self.__task_vars_used
   _16=self._task_1numcon_()
   _17=self._task_1numcone_()
   _18=self._task_1numbarvar_()
   try:
    _19=self._task_1append_1con_I(_14)
    _20=(_19 + _14)
    if (((_13.subj) is not None) and (int(((_13.subj)).shape[0]) > 0)):
     self._task_1putarowslice_II_3J_3I_3D(_19,_20,(_13.ptrb),(_13.subj),(_13.cof))
    if ((_13.barsubi) is not None):
     for _21 in range(0,int(((_13.barsubi)).shape[0])):
      self._task_1putbaraij_III(((_13.barsubi)[_21] + _19),(_13.barsubj)[_21],(_13.barmidx)[_21])
    _22=mosek.fusion.Utils.Tools._range_II(_19,_20)
    _23=(numpy.zeros(((_20 - _19),), dtype=numpy.dtype(numpy.float64)) if (((_13.bfix) is None) ) else numpy.array([(- (_13.bfix)[_24]) for _24 in range(0,(_20 - _19))], dtype=numpy.dtype(numpy.float64)))
    _25=(_8 * _9)
    _26=(numpy.array([(- (_13.bfix)[_27]) for _27 in range(0,_25)], dtype=numpy.dtype(numpy.float64)) if (((_11.bfix) is not None) ) else numpy.zeros((_25,), dtype=numpy.dtype(numpy.float64)))
    self._task_1con_1putboundslice_1fx_II_3D(_19,_20,_26)
    _28=self._task_1append_1barvar_II(_6,_9)
    _29=numpy.zeros((1,), dtype=numpy.dtype(numpy.int32))
    _30=numpy.zeros((1,), dtype=numpy.dtype(numpy.int32))
    _31=numpy.zeros((1,), dtype=numpy.dtype(numpy.float64))
    _32=0
    for _33 in range(0,_6):
     _30[0] = _33
     for _34 in range(_33,_6):
      _29[0] = _34
      _31[0] = (- (1.0 if ((_34==_33) ) else 0.5))
      _35=self._task_1append_1barmatrix_I_3I_3I_3D(_6,_29,_30,_31)
      for _36 in range(0,_9):
       self._task_1putbaraij_III(((_19 + _32) + (_36 * _8)),(_28 + _36),_35)
      _32 += 1
    _3 = mosek_fusion_LinearPSDConstraint._ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3IIII_3J_3I_3D_3D_3I_3I_3I(self,_0,_5,mosek.fusion.Utils.Tools._range_II(_19,_20),_8,_28,_9,(_13.ptrb),(_13.subj),(_13.cof),(_13.bfix),(_13.barsubi),(_13.barsubj),(_13.barmidx))
    self.__addConstraint_SLmosek_4fusion_4ModelConstraint_2(_0,_3)
   finally:
    if (_3 is None):
     self.__natvarmap_num = _15
     self._natbarvarmap_num = _18
     self._task_1cleanup_IIII(_15,_16,_17,_18)
   return (_3)
  def __constraint_1_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1,_t__2):
    return self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_0,_1,_2)
  def __constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_0,_1,_2):
   if ((_2._key)==mosek.fusion.PSDKey.IsSymPSD):
    return (self.__nonsym_1psdconstraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_0,_1,_2))
   elif ((_2._key)==mosek.fusion.PSDKey.IsTrilPSD):
    _4=_1.eval()
    for _5 in range(0,int(((_4.x)).shape[0])):
     if (((_4.x)[_5].getModel() is not None) and ((_4.x)[_5].getModel() is not self)):
      raise mosek_fusion_ModelError._ctor_S("Expression belong to different models")
    if ((not ((((_4.shape).nd)==2) or (((_4.shape).nd)==3))) or ((_4.shape).dim(0)!=(_4.shape).dim(1))):
     raise mosek_fusion_DomainError._ctor_S("Invalid expression shape for semidefinite constraint")
    _6=(_4.shape).dim(0)
    _7=1
    if (((_4.shape).nd) > 2):
     _7 = (_4.shape).dim(2)
    _8=(((_7 * _6) * (_6 + 1)) // 2)
    if (((_2._shape) is not None) and (((_2._shape).dim(0)!=_6) or ((_2._shape).dim(2)!=_7))):
     raise mosek_fusion_DomainError._ctor_S("Expression shape does not match domain")
    _9=numpy.zeros((_8,), dtype=numpy.dtype(numpy.int64))
    _10=0
    for _11 in range(0,_7):
     for _12 in range(0,_6):
      for _13 in range(0,(_12 + 1)):
       _9[_10] = numpy.int64(((((_11 * _6) * _6) + (_12 * _6)) + _13))
       _10 += 1
    _14=(_4.bfix)
    if (_14 is None):
     _14 = numpy.zeros(((int(((_4.ptrb)).shape[0]) - 1),), dtype=numpy.dtype(numpy.float64))
    return (self.__sdptrilcon_SII_3J_3J_3J_3J_3D_3D_3Lmosek_4fusion_4Variable_2(_0,_6,_7,(_4.ptrb),(_4.inst),_9,(_4.subj),(_4.cof),_14,(_4.x)))
   else:
    raise mosek_fusion_UnexpectedError._ctor_S("Invalid domain")
  def __nonsym_1psdconstraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1,_t__2):
    return self.__nonsym_1psdconstraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_0,_1,_2)
  def __nonsym_1psdconstraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_0,_1,_2):
   _3=_1.eval()
   if ((not ((((_3.shape).nd)==2) or (((_3.shape).nd)==3))) or ((_3.shape).dim(0)!=(_3.shape).dim(1))):
    raise mosek_fusion_DomainError._ctor_S("Invalid expression shape for semidefinite constraint")
   _4=(_3.shape).dim(0)
   _5=1
   if (((_3.shape).nd) > 2):
    _5 = (_3.shape).dim(2)
   _6=(((_5 * _4) * (_4 + 1)) // 2)
   if (((_2._shape) is not None) and (((_2._shape).dim(0)!=_4) or (((_2._shape).dim(1)!=_4) or ((_2._shape).dim(2)!=_5)))):
    raise mosek_fusion_DomainError._ctor_S("Expression shape does not match domain")
   if (((_3.inst) is None) or (int(((_3.inst)).shape[0])==_6)):
    _7=_6
    _8=numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
    _9=numpy.zeros(((_7 + 1),), dtype=numpy.dtype(numpy.int64))
    _10=numpy.zeros((int(((_3.subj)).shape[0]),), dtype=numpy.dtype(numpy.float64))
    _11=numpy.zeros((int(((_3.subj)).shape[0]),), dtype=numpy.dtype(numpy.int64))
    _12=numpy.array([_13 for _13 in range(0,_7)], dtype=numpy.dtype(numpy.int64))
    _14=None
    _15=0
    for _16 in range(0,_5):
     for _17 in range(0,_4):
      for _18 in range(0,(_17 + 1)):
       _19=numpy.int64(((((_16 * _4) * _4) + (_17 * _4)) + _18))
       _20=numpy.int64(((((_16 * _4) * _4) + (_18 * _4)) + _17))
       if (_17==_18):
        _9[(_15 + 1)] = ((_3.ptrb)[(_19 + 1)] - (_3.ptrb)[_19])
       else:
        _9[(_15 + 1)] = ((((_3.ptrb)[(_19 + 1)] - (_3.ptrb)[_19]) + (_3.ptrb)[(_20 + 1)]) - (_3.ptrb)[_20])
       _8[_15] = _19
       _15 += 1
    for _21 in range(0,_6):
     _9[(_21 + 1)] = (_9[(_21 + 1)] + _9[_21])
    if ((_3.bfix) is not None):
     _14 = numpy.zeros((int((_8).shape[0]),), dtype=numpy.dtype(numpy.float64))
     _22=0
     for _23 in range(0,_5):
      for _24 in range(0,_4):
       for _25 in range(0,(_24 + 1)):
        _26=numpy.int64(((((_23 * _4) * _4) + (_24 * _4)) + _25))
        _27=numpy.int64(((((_23 * _4) * _4) + (_25 * _4)) + _24))
        if (_24==_25):
         _14[_22] = (_3.bfix)[_26]
        else:
         _14[_22] = (0.5 * ((_3.bfix)[_26] + (_3.bfix)[_27]))
        _22 += 1
    _28=0
    for _29 in range(0,_5):
     for _30 in range(0,_4):
      for _31 in range(0,(_30 + 1)):
       _32=((((_29 * _4) * _4) + (_30 * _4)) + _31)
       _33=((((_29 * _4) * _4) + (_31 * _4)) + _30)
       if (_30==_31):
        mosek.fusion.Utils.Tools._arraycopy__3JJ_3JJJ((_3.subj),(_3.ptrb)[_32],_11,_9[_28],((_3.ptrb)[(_32 + 1)] - (_3.ptrb)[_32]))
        mosek.fusion.Utils.Tools._arraycopy__3DJ_3DJJ((_3.cof),(_3.ptrb)[_32],_10,_9[_28],((_3.ptrb)[(_32 + 1)] - (_3.ptrb)[_32]))
       else:
        _34=((_3.ptrb)[(_32 + 1)] - (_3.ptrb)[_32])
        _35=((_3.ptrb)[(_33 + 1)] - (_3.ptrb)[_33])
        mosek.fusion.Utils.Tools._arraycopy__3JJ_3JJJ((_3.subj),(_3.ptrb)[_32],_11,_9[_28],_34)
        mosek.fusion.Utils.Tools._arraycopy__3JJ_3JJJ((_3.subj),(_3.ptrb)[_33],_11,(_9[_28] + _34),_35)
        for _36 in range(0,_34):
         _10[(_9[_28] + _36)] = (0.5 * (_3.cof)[((_3.ptrb)[_32] + _36)])
        for _37 in range(0,_35):
         _10[((_9[_28] + _34) + _37)] = (0.5 * (_3.cof)[((_3.ptrb)[_33] + _37)])
       _28 += 1
    return (self.__sdptrilcon_SII_3J_3J_3J_3J_3D_3D_3Lmosek_4fusion_4Variable_2(_0,_4,_5,_9,_8,_12,_11,_10,_14,(_3.x)))
   else:
    _38=(_4 * _4)
    _39=mosek.fusion.Utils.Tools._arraycopy__3J((_3.inst))
    for _40 in range(0,int((_39).shape[0])):
     _41=((_3.inst)[_40] // _38)
     _42=(((_3.inst)[_40] // _4) % _4)
     _43=((_3.inst)[_40] % _4)
     if (_43 > _42):
      _39[_40] = (((_41 * _38) + (_43 * _4)) + _42)
     else:
      _39[_40] = (_3.inst)[_40]
     if (_42!=_43):
      for _44 in range((_3.ptrb)[_40],(_3.ptrb)[(_40 + 1)]):
       (_3.cof)[_44] /= 2
      if ((_3.bfix) is not None):
       (_3.bfix)[_40] /= 2
    _45=numpy.array([_46 for _46 in range(0,int((_39).shape[0]))], dtype=numpy.dtype(numpy.int64))
    _47=numpy.zeros((((_5 * _4) + 1),), dtype=numpy.dtype(numpy.int64))
    mosek.fusion.Sort._argTransposeSort__3J_3JIII_3J(_45,_47,_5,_4,_4,_39)
    mosek.fusion.Sort._argTransposeSort__3J_3JIII_3J(_45,_47,(_5 * _4),_4,1,_39)
    _48=0
    if (int((_45).shape[0]) > 0):
     _48 += 1
     for _49 in range(1,int((_45).shape[0])):
      if (_39[_45[_49]] > _39[_45[(_49 - 1)]]):
       _48 += 1
    if (int((_39).shape[0])==_48):
     return (self.__sdptrilcon_SII_3J_3J_3J_3J_3D_3D_3Lmosek_4fusion_4Variable_2(_0,_4,_5,(_3.ptrb),_39,_45,(_3.subj),(_3.cof),(_3.bfix),(_3.x)))
    else:
     _50=numpy.zeros(((_48 + 1),), dtype=numpy.dtype(numpy.int64))
     _51=numpy.zeros((_48,), dtype=numpy.dtype(numpy.int64))
     _52=numpy.zeros((int(((_3.subj)).shape[0]),), dtype=numpy.dtype(numpy.int64))
     _53=numpy.zeros((int(((_3.subj)).shape[0]),), dtype=numpy.dtype(numpy.float64))
     _54=numpy.zeros((_48,), dtype=numpy.dtype(numpy.float64))
     _55=0
     _56=0
     for _57 in range(0,int((_45).shape[0])):
      if ((_57 > 0) and (_39[_45[_57]]!=_39[_45[(_57 - 1)]])):
       _55 += 1
      _58=((_3.ptrb)[(_45[_57] + 1)] - (_3.ptrb)[_45[_57]])
      mosek.fusion.Utils.Tools._arraycopy__3JJ_3JJJ((_3.subj),(_3.ptrb)[_45[_57]],_52,_56,_58)
      mosek.fusion.Utils.Tools._arraycopy__3DJ_3DJJ((_3.cof),(_3.ptrb)[_45[_57]],_53,_56,_58)
      _56 += _58
      _50[(_55 + 1)] = _56
      _51[_55] = _39[_45[_57]]
     if ((_3.bfix) is not None):
      _59=0
      for _60 in range(0,int((_45).shape[0])):
       if ((_60 > 0) and (_39[_45[_60]]!=_39[_45[(_60 - 1)]])):
        _59 += 1
       _61=(((_3.inst)[_45[_60]] // _4) % _4)
       _62=((_3.inst)[_45[_60]] % _4)
       _54[_59] += (_3.bfix)[_45[_60]]
     return (self.__sdptrilcon_SII_3J_3J_3J_3J_3D_3D_3Lmosek_4fusion_4Variable_2(_0,_4,_5,_50,_51,mosek.fusion.Utils.Tools._range_J(long((_51).shape[0])),_52,_53,_54,(_3.x)))
  def __sdptrilcon_alt_SII_3J_3J_3J_3J_3D_3D_3Lmosek_4fusion_4Variable_2(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7,_t__8,_t__9):
   _0=_t__0
   _1=numpy.int32(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int64))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int64))
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int64))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.int64))
   _7=numpy.array(_t__7,dtype=numpy.dtype(numpy.float64))
   _8=numpy.array(_t__8,dtype=numpy.dtype(numpy.float64))
   _9=numpy.array(_t__9,dtype=numpy.dtype(object))
   _1 = self.__sdptrilcon_SII_3J_3J_3J_3J_3D_3D_3Lmosek_4fusion_4Variable_2(_0,_1,_2,_3,_4,_5,_6,_7,_8,_9)
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__7[:] = _7
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__8[:] = _8
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__9[:] = _9
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def __sdptrilcon_SII_3J_3J_3J_3J_3D_3D_3Lmosek_4fusion_4Variable_2(self,_0,_1,_2,_3,_4,_5,_6,_7,_8,_9):
   _10=None
   _11=0
   for _12 in range(0,int((_5).shape[0])):
    _11 = (_11 + (_3[(_5[_12] + 1)] - _3[_5[_12]]))
   _13=numpy.zeros((_11,), dtype=numpy.dtype(numpy.int32))
   _14=numpy.zeros((_11,), dtype=numpy.dtype(numpy.int32))
   _15=numpy.zeros((_11,), dtype=numpy.dtype(numpy.int32))
   _16=numpy.zeros(((int((_5).shape[0]) + 1),), dtype=numpy.dtype(numpy.int64))
   _17=0
   for _18 in range(0,int((_5).shape[0])):
    mosek.fusion.Model.__inst__3Lmosek_4fusion_4Variable_2II_3JI_3I_3I_3I(_9,numpy.int32(_3[_5[_18]]),numpy.int32(_3[(_5[_18] + 1)]),_6,_17,_13,_14,_15)
    _17 = (_17 + numpy.int32((_3[(_5[_18] + 1)] - _3[_5[_18]])))
    _16[(_18 + 1)] = _17
   _19=(_2 * ((_1 * (_1 + 1)) // 2))
   _20=0
   for _21 in range(0,_11):
    if (_13[_21] < 0):
     _20 += 1
   _22=(_11 - _20)
   _23=mosek.fusion.Utils.Tools._range_J(_11)
   for _24 in range(0,int((_5).shape[0])):
    mosek.fusion.CommonTools._argQsort__3J_3I_3IJJ(_23,_13,None,_16[_24],_16[(_24 + 1)])
   _25=0
   for _26 in range(0,int((_5).shape[0])):
    _27=_16[_26]
    _28=_16[(_26 + 1)]
    while ((_27 < _28) and (_13[_23[_27]] < 0)):
     _27 += 1
    if (_27 < _28):
     _25 += 1
     _27 += 1
    while (_27 < _28):
     if (_13[_23[(_27 - 1)]] < _13[_23[_27]]):
      _25 += 1
     _27 += 1
   _29=numpy.zeros((int((_5).shape[0]),), dtype=numpy.dtype(numpy.int64))
   for _30 in range(0,int((_5).shape[0])):
    _31=(_4[_5[_30]] // (_1 * _1))
    _32=((_4[_5[_30]] % (_1 * _1)) // _1)
    _33=(_4[_5[_30]] % _1)
    _29[_30] = (((_31 * ((_1 * (_1 + 1)) // 2)) + ((_32 * (_32 + 1)) // 2)) + _33)
   _34=self.__task_vars_used
   _35=self._task_1numcon_()
   _36=self._task_1numcone_()
   _37=self._task_1numbarvar_()
   try:
    _38=self._task_1append_1con_I(_19)
    _39=(_38 + _19)
    _40=self.__task_1alloc_1vars_I(_19)
    _41=(_40 + _19)
    _42=numpy.zeros(((_19 + 1),), dtype=numpy.dtype(numpy.int64))
    _43=numpy.zeros((_25,), dtype=numpy.dtype(numpy.int32))
    _44=numpy.zeros((_25,), dtype=numpy.dtype(numpy.float64))
    if (_22 > 0):
     _45=0
     for _46 in range(0,_19):
      _47=_42[_46]
      if ((_45 < int((_5).shape[0])) and (_46==_29[_45])):
       _48=_16[(_45 + 1)]
       _49=_16[_45]
       while ((_49 < _48) and (_13[_23[_49]] < 0)):
        _49 += 1
       if (_49 < _48):
        _43[_47] = _13[_23[_49]]
        _44[_47] = _7[_23[_49]]
        _49 += 1
        while (_49 < _48):
         if (_13[_23[_49]]==_43[_47]):
          _44[_47] = (_44[_47] + _7[_23[_49]])
         else:
          _47 += 1
          _43[_47] = _13[_23[_49]]
          _44[_47] = _7[_23[_49]]
         _49 += 1
        _47 += 1
       _45 += 1
      _42[(_46 + 1)] = _47
     self._task_1putarowslice_II_3J_3I_3D(_38,_39,_42,_43,_44)
    _50=numpy.zeros((_19,), dtype=numpy.dtype(numpy.float64))
    if (_8 is not None):
     for _51 in range(0,int((_5).shape[0])):
      _50[_29[_51]] = (- _8[_5[_51]])
    self._task_1con_1putboundslice_1fx_II_3D(_38,_39,_50)
    if (_20 > 0):
     for _52 in range(0,int((_5).shape[0])):
      _53=_3[_5[_52]]
      _54=_3[(_5[_52] + 1)]
      _55=_53
      while ((_55 < _54) and (_13[_23[_55]] < 0)):
       _55 += 1
      if (_53 < _55):
       _56=_13[_23[_53]]
       while (_53 < _55):
        _57=_53
        while ((_53 < _55) and (_13[_23[_53]]==_56)):
         _53 += 1
        _58=(- (_56 + 1))
        mosek.fusion.CommonTools._argQsort__3J_3I_3IJJ(_23,_14,_15,_57,_53)
        _59=1
        for _60 in range((_57 + 1),_53):
         if ((_14[_23[_60]]!=_14[_23[(_60 - 1)]]) or (_15[_23[_60]]!=_15[_23[(_60 - 1)]])):
          _59 += 1
        _61=numpy.zeros((_59,), dtype=numpy.dtype(numpy.int32))
        _62=numpy.zeros((_59,), dtype=numpy.dtype(numpy.int32))
        _63=numpy.zeros((_59,), dtype=numpy.dtype(numpy.float64))
        _64=(- 1)
        _65=(- 1)
        _66=0
        for _67 in range(_57,_53):
         if ((_14[_23[_67]]==_65) and (_15[_23[_67]]==_66)):
          _63[_64] = (_63[_64] + _7[_23[_67]])
         else:
          _64 += 1
          _61[_64] = _14[_23[_67]]
          _62[_64] = _15[_23[_67]]
          _63[_64] = _7[_23[_67]]
          _65 = _61[_64]
          _66 = _62[_64]
        _68=self._task_1barvardim_I(_58)
        _69=self._task_1append_1barmatrix_I_3I_3I_3D(_68,_61,_62,_63)
        self._task_1putbaraij_III(numpy.int32((_29[_52] + _38)),_58,_69)
    _70=self._task_1append_1barvar_II(_1,_2)
    _71=numpy.zeros((1,), dtype=numpy.dtype(numpy.int32))
    _72=numpy.zeros((1,), dtype=numpy.dtype(numpy.int32))
    _73=numpy.zeros((1,), dtype=numpy.dtype(numpy.float64))
    for _74 in range(0,_1):
     for _75 in range(0,(_74 + 1)):
      _71[0] = _74
      _72[0] = _75
      _73[0] = (- (1.0 if ((_74==_75) ) else 0.5))
      _76=self._task_1append_1barmatrix_I_3I_3I_3D(_1,_71,_72,_73)
      for _77 in range(0,_2):
       _78=(((((_77 * _1) * (_1 + 1)) // 2) + ((_74 * (_74 + 1)) // 2)) + _75)
       self._task_1putbaraij_III((_38 + _78),(_70 + _77),_76)
    _79=None
    if (_2==1):
     _79 = mosek_fusion_NDSet._ctor_II(_1,_1)
    else:
     _79 = mosek_fusion_NDSet._ctor_III(_1,_1,_2)
    _10 = mosek_fusion_PSDConstraint._ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3IIII_3J_3I_3D_3D_3I_3I_3I(self,_0,_79,mosek.fusion.Utils.Tools._range_II(_38,_39),_1,_70,_2,_42,_43,_44,_50,None,None,None)
    self.__natbarvarmap_1ensure_I(_2)
    self._natbarvarmap_num += _2
    self.__addConstraint_SLmosek_4fusion_4ModelConstraint_2(_0,_10)
    return (_10)
   finally:
    if (_10 is None):
     self._natbarvarmap_num = _37
     self.__natvarmap_num = _34
     self._task_1cleanup_IIII(_34,_35,_36,_37)
  def __addConstraint_alt_SLmosek_4fusion_4ModelConstraint_2(self,_t__0,_t__1):
    return self.__addConstraint_SLmosek_4fusion_4ModelConstraint_2(_0,_1)
  def __addConstraint_SLmosek_4fusion_4ModelConstraint_2(self,_0,_1):
   if (self.__cons_used >= int((self.__cons).shape[0])):
    _2=((int((self.__cons).shape[0]) * 2) if ((int((self.__cons).shape[0]) > 100) ) else 100)
    _3=self.__cons
    self.__cons = numpy.zeros((_2,), dtype=numpy.dtype(object))
    for _4 in range(0,self.__cons_used):
     self.__cons[_4] = _3[_4]
   self.__cons[self.__cons_used] = _1
   if (int(len(_0)) > 0):
    self.__con_map._setItem_SI(_0,self.__cons_used)
   self.__cons_used += 1
  def __addVariable_alt_SLmosek_4fusion_4ModelVariable_2(self,_t__0,_t__1):
    return self.__addVariable_SLmosek_4fusion_4ModelVariable_2(_0,_1)
  def __addVariable_SLmosek_4fusion_4ModelVariable_2(self,_0,_1):
   if (self._vars_used >= int((self._vars).shape[0])):
    _2=((int((self._vars).shape[0]) * 2) if ((int((self._vars).shape[0]) > 100) ) else 100)
    _3=self._vars
    self._vars = numpy.zeros((_2,), dtype=numpy.dtype(object))
    for _4 in range(0,self._vars_used):
     self._vars[_4] = _3[_4]
   self._vars[self._vars_used] = _1
   if (int(len(_0)) > 0):
    self.__var_map._setItem_SI(_0,self._vars_used)
   self._vars_used += 1
  @staticmethod
  def _match_numConstraints_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_numConstraints_(*args):
    if len(args) != 0: return False
    return True
  def _numConstraints_alt_(self,):
    return self._numConstraints_()
  def _numConstraints_(self,):
   return numpy.int32(self.__cons_used)
  @staticmethod
  def _match_numVariables_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_numVariables_(*args):
    if len(args) != 0: return False
    return True
  def _numVariables_alt_(self,):
    return self._numVariables_()
  def _numVariables_(self,):
   return numpy.int32(self._vars_used)
  @staticmethod
  def _match_hasConstraint_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_hasConstraint_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _hasConstraint_alt_S(self,_t__0):
    return self._hasConstraint_S(_0)
  def _hasConstraint_S(self,_0):
   return (self.__con_map._hasItem_S(_0))
  @staticmethod
  def _match_hasVariable_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_hasVariable_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _hasVariable_alt_S(self,_t__0):
    return self._hasVariable_S(_0)
  def _hasVariable_S(self,_0):
   return (self.__var_map._hasItem_S(_0))
  @staticmethod
  def _match_getConstraint_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_getConstraint_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _getConstraint_alt_I(self,_t__0):
    return self._getConstraint_I(numpy.int32(__0))
  def _getConstraint_I(self,_0):
   return ((self.__cons[_0] if (((_0 >= 0) and (_0 < self.__cons_used)) ) else None))
  @staticmethod
  def _match_getConstraint_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_getConstraint_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _getConstraint_alt_S(self,_t__0):
    return self._getConstraint_S(_0)
  def _getConstraint_S(self,_0):
   return ((self.__cons[self.__con_map._getItem_S(_0)] if (self.__con_map._hasItem_S(_0) ) else None))
  @staticmethod
  def _match_getVariable_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_getVariable_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _getVariable_alt_I(self,_t__0):
    return self._getVariable_I(numpy.int32(__0))
  def _getVariable_I(self,_0):
   return ((self._vars[_0] if (((_0 >= 0) and (_0 < self._vars_used)) ) else None))
  @staticmethod
  def _match_getVariable_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_getVariable_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _getVariable_alt_S(self,_t__0):
    return self._getVariable_S(_0)
  def _getVariable_S(self,_0):
   return ((self._vars[self.__var_map._getItem_S(_0)] if (self.__var_map._hasItem_S(_0) ) else None))
  @staticmethod
  def _match_getName_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getName_(*args):
    if len(args) != 0: return False
    return True
  def _getName_alt_(self,):
    return self._getName_()
  def _getName_(self,):
   return (self.__model_name)
  @staticmethod
  def _match_clone_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_clone_(*args):
    if len(args) != 0: return False
    return True
  def _clone_alt_(self,):
    return self._clone_()
  def _clone_(self,):
   return (mosek_fusion_Model._ctor_Lmosek_4fusion_4Model_2(self))
  def __natbarvarmap_1ensure_alt_I(self,_t__0):
    return self.__natbarvarmap_1ensure_I(numpy.int32(__0))
  def __natbarvarmap_1ensure_I(self,_0):
   if ((self._natbarvarmap_num + _0) > int((self._natbarvarmap_Var).shape[0])):
    _1=(2 * int((self._natbarvarmap_Var).shape[0]))
    if (_1 < (self._natbarvarmap_num + _0)):
     _1 = (self._natbarvarmap_num + _0)
    _2=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int32))
    _3=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int32))
    for _4 in range(0,self._natbarvarmap_num):
     _2[_4] = self._natbarvarmap_Var[_4]
    self._natbarvarmap_Var = _2
  def __natvarmap_1ensure_alt_I(self,_t__0):
    return self.__natvarmap_1ensure_I(numpy.int32(__0))
  def __natvarmap_1ensure_I(self,_0):
   if ((self.__natvarmap_num + _0) > int((self.__natvarmap_idx).shape[0])):
    _1=(2 * int((self.__natvarmap_idx).shape[0]))
    if (_1 < (self.__natvarmap_num + _0)):
     _1 = (self.__natvarmap_num + _0)
    _2=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int64))
    mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(self.__natvarmap_idx,0,_2,0,self.__natvarmap_num)
    _3=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int32))
    for _4 in range(0,self.__natvarmap_num):
     _3[_4] = self.__natvarmap_Var[_4]
    self.__natvarmap_idx = _2
    self.__natvarmap_Var = _3
  def __task_1alloc_1vars_alt_I(self,_t__0):
    return self.__task_1alloc_1vars_I(numpy.int32(__0))
  def __task_1alloc_1vars_I(self,_0):
   if ((self.__task_vars_allocated - self.__task_vars_used) < _0):
    _1=(1000 if ((((_0 + self.__task_vars_used) - self.__task_vars_allocated) < 1000) ) else _0)
    self._task_1append_1var_I(_1)
    self.__task_vars_allocated += _1
   _2=self.__task_vars_used
   self.__task_vars_used += _0
   return numpy.int32(_2)
 return Model
mosek_fusion_Model=__mk_mosek_fusion_Model()
del __mk_mosek_fusion_Model
def __mk_mosek_fusion_Debug():
  class Debug:
    @staticmethod 
    def _o_(): return Debug()
    def p(self,v): 
      sys.stdout.write(str(v))
      return self
    _p_S = p
    _p_I = p
    _p_J = p
    _p_D = p
    _p_Z = p
  
    def p_array (self,v):
      if v is None:
          sys.stdout.write('None')
      else:
          sys.stdout.write('[ %s ]' % ','.join([str(i) for i in v]))
      return self
  
    _p__3I = p_array
    _p__3J = p_array
    _p__3D = p_array
  
    def _lf_(self): 
      sys.stdout.write("\n")
      return self
  
  return Debug
mosek_fusion_Debug=__mk_mosek_fusion_Debug()
#BEFORE CLASS
def __mk_mosek_fusion_Sort():
 class Sort(object):
  @staticmethod
  def argbucketsort(*args):
    if False: pass
    elif mosek_fusion_Sort._match_argbucketsort__3J_3IJJII(*args): # []int64,[]int32,int64,int64,int32,int32
      return mosek_fusion_Sort._argbucketsort__3J_3IJJII(*args)
    elif mosek_fusion_Sort._match_alt_argbucketsort__3J_3IJJII(*args): # []int64,[]int32,int64,int64,int32,int32
      return mosek_fusion_Sort._argbucketsort_alt__3J_3IJJII(*args)
    elif mosek_fusion_Sort._match_argbucketsort__3J_3JJJJJ(*args): # []int64,[]int64,int64,int64,int64,int64
      return mosek_fusion_Sort._argbucketsort__3J_3JJJJJ(*args)
    elif mosek_fusion_Sort._match_alt_argbucketsort__3J_3JJJJJ(*args): # []int64,[]int64,int64,int64,int64,int64
      return mosek_fusion_Sort._argbucketsort_alt__3J_3JJJJJ(*args)
    else:
      raise ValueError('Invalid argument list argbucketsort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Sort.argbucketsort(array(int64,ndim=1),array(int32,ndim=1),int64,int64,int32,int32)\n\tmosek.fusion.Sort.argbucketsort(array(int64,ndim=1),array(int64,ndim=1),int64,int64,int64,int64)')
  @staticmethod
  def argsort(*args):
    if False: pass
    elif mosek_fusion_Sort._match_argsort__3J_3J(*args): # []int64,[]int64
      return mosek_fusion_Sort._argsort__3J_3J(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3J(*args): # []int64,[]int64
      return mosek_fusion_Sort._argsort_alt__3J_3J(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3I(*args): # []int64,[]int32
      return mosek_fusion_Sort._argsort__3J_3I(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3I(*args): # []int64,[]int32
      return mosek_fusion_Sort._argsort_alt__3J_3I(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3I_3I(*args): # []int64,[]int32,[]int32
      return mosek_fusion_Sort._argsort__3J_3I_3I(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3I_3I(*args): # []int64,[]int32,[]int32
      return mosek_fusion_Sort._argsort_alt__3J_3I_3I(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3J_3J(*args): # []int64,[]int64,[]int64
      return mosek_fusion_Sort._argsort__3J_3J_3J(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3J_3J(*args): # []int64,[]int64,[]int64
      return mosek_fusion_Sort._argsort_alt__3J_3J_3J(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3JJJ(*args): # []int64,[]int64,int64,int64
      return mosek_fusion_Sort._argsort__3J_3JJJ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3JJJ(*args): # []int64,[]int64,int64,int64
      return mosek_fusion_Sort._argsort_alt__3J_3JJJ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3IJJ(*args): # []int64,[]int32,int64,int64
      return mosek_fusion_Sort._argsort__3J_3IJJ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3IJJ(*args): # []int64,[]int32,int64,int64
      return mosek_fusion_Sort._argsort_alt__3J_3IJJ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3I_3IJJ(*args): # []int64,[]int32,[]int32,int64,int64
      return mosek_fusion_Sort._argsort__3J_3I_3IJJ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3I_3IJJ(*args): # []int64,[]int32,[]int32,int64,int64
      return mosek_fusion_Sort._argsort_alt__3J_3I_3IJJ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3IJJZ(*args): # []int64,[]int32,int64,int64,bool
      return mosek_fusion_Sort._argsort__3J_3IJJZ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3IJJZ(*args): # []int64,[]int32,int64,int64,bool
      return mosek_fusion_Sort._argsort_alt__3J_3IJJZ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3JJJZ(*args): # []int64,[]int64,int64,int64,bool
      return mosek_fusion_Sort._argsort__3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3JJJZ(*args): # []int64,[]int64,int64,int64,bool
      return mosek_fusion_Sort._argsort_alt__3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3J_3JJJ(*args): # []int64,[]int64,[]int64,int64,int64
      return mosek_fusion_Sort._argsort__3J_3J_3JJJ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3J_3JJJ(*args): # []int64,[]int64,[]int64,int64,int64
      return mosek_fusion_Sort._argsort_alt__3J_3J_3JJJ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3I_3IJJZ(*args): # []int64,[]int32,[]int32,int64,int64,bool
      return mosek_fusion_Sort._argsort__3J_3I_3IJJZ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3I_3IJJZ(*args): # []int64,[]int32,[]int32,int64,int64,bool
      return mosek_fusion_Sort._argsort_alt__3J_3I_3IJJZ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3J_3JJJZ(*args): # []int64,[]int64,[]int64,int64,int64,bool
      return mosek_fusion_Sort._argsort__3J_3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3J_3JJJZ(*args): # []int64,[]int64,[]int64,int64,int64,bool
      return mosek_fusion_Sort._argsort_alt__3J_3J_3JJJZ(*args)
    else:
      raise ValueError('Invalid argument list argsort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1))\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1))\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),int64,int64)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),int64,int64)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64,bool)')
  @staticmethod
  def issorted(*args):
    if False: pass
    elif mosek_fusion_Sort._match_issorted__3J_3IJJZ(*args): # []int64,[]int32,int64,int64,bool
      return mosek_fusion_Sort._issorted__3J_3IJJZ(*args)
    elif mosek_fusion_Sort._match_alt_issorted__3J_3IJJZ(*args): # []int64,[]int32,int64,int64,bool
      return mosek_fusion_Sort._issorted_alt__3J_3IJJZ(*args)
    elif mosek_fusion_Sort._match_issorted__3J_3JJJZ(*args): # []int64,[]int64,int64,int64,bool
      return mosek_fusion_Sort._issorted__3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_alt_issorted__3J_3JJJZ(*args): # []int64,[]int64,int64,int64,bool
      return mosek_fusion_Sort._issorted_alt__3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_issorted__3J_3I_3IJJZ(*args): # []int64,[]int32,[]int32,int64,int64,bool
      return mosek_fusion_Sort._issorted__3J_3I_3IJJZ(*args)
    elif mosek_fusion_Sort._match_alt_issorted__3J_3I_3IJJZ(*args): # []int64,[]int32,[]int32,int64,int64,bool
      return mosek_fusion_Sort._issorted_alt__3J_3I_3IJJZ(*args)
    elif mosek_fusion_Sort._match_issorted__3J_3J_3JJJZ(*args): # []int64,[]int64,[]int64,int64,int64,bool
      return mosek_fusion_Sort._issorted__3J_3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_alt_issorted__3J_3J_3JJJZ(*args): # []int64,[]int64,[]int64,int64,int64,bool
      return mosek_fusion_Sort._issorted_alt__3J_3J_3JJJZ(*args)
    else:
      raise ValueError('Invalid argument list issorted('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Sort.issorted(array(int64,ndim=1),array(int32,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.issorted(array(int64,ndim=1),array(int64,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.issorted(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.issorted(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64,bool)')
  @staticmethod
  def getminmax(*args):
    if False: pass
    elif mosek_fusion_Sort._match_getminmax__3J_3I_3IJJ_3I(*args): # []int64,[]int32,[]int32,int64,int64,[]int32
      return mosek_fusion_Sort._getminmax__3J_3I_3IJJ_3I(*args)
    elif mosek_fusion_Sort._match_alt_getminmax__3J_3I_3IJJ_3I(*args): # []int64,[]int32,[]int32,int64,int64,[]int32
      return mosek_fusion_Sort._getminmax_alt__3J_3I_3IJJ_3I(*args)
    elif mosek_fusion_Sort._match_getminmax__3J_3J_3JJJ_3J(*args): # []int64,[]int64,[]int64,int64,int64,[]int64
      return mosek_fusion_Sort._getminmax__3J_3J_3JJJ_3J(*args)
    elif mosek_fusion_Sort._match_alt_getminmax__3J_3J_3JJJ_3J(*args): # []int64,[]int64,[]int64,int64,int64,[]int64
      return mosek_fusion_Sort._getminmax_alt__3J_3J_3JJJ_3J(*args)
    else:
      raise ValueError('Invalid argument list getminmax('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Sort.getminmax(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64,array(int32,ndim=1))\n\tmosek.fusion.Sort.getminmax(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64,array(int64,ndim=1))')
  @staticmethod
  def argTransposeSort(*args):
    if False: pass
    elif mosek_fusion_Sort._match_argTransposeSort__3J_3JIII_3J(*args): # []int64,[]int64,int32,int32,int32,[]int64
      return mosek_fusion_Sort._argTransposeSort__3J_3JIII_3J(*args)
    elif mosek_fusion_Sort._match_alt_argTransposeSort__3J_3JIII_3J(*args): # []int64,[]int64,int32,int32,int32,[]int64
      return mosek_fusion_Sort._argTransposeSort_alt__3J_3JIII_3J(*args)
    else:
      raise ValueError('Invalid argument list argTransposeSort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Sort.argTransposeSort(array(int64,ndim=1),array(int64,ndim=1),int32,int32,int32,array(int64,ndim=1))')
  def __repr__(self): return 'mosek.fusion.Sort'
  @staticmethod
  def _match_argTransposeSort__3J_3JIII_3J(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match_I__(_2) and __arg_match_I__(_3) and __arg_match_I__(_4) and __arg_match__3J__(_5))
  @staticmethod
  def _match_alt_argTransposeSort__3J_3JIII_3J(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match_I__(_4) and __arg_alt_match__3J__(_5))
  @staticmethod
  def _argTransposeSort_alt__3J_3JIII_3J(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.int32(_t__2)
   _3=numpy.int32(_t__3)
   _4=numpy.int32(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int64))
   _1 = mosek_fusion_Sort._argTransposeSort__3J_3JIII_3J(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argTransposeSort__3J_3JIII_3J(_0,_1,_2,_3,_4,_5):
   for _6 in range(0,((_2 * _4) + 1)):
    _1[_6] = 0
   for _7 in range(0,int((_5).shape[0])):
    _1[((((_5[_0[_7]] // (_3 * _4)) * _4) + (_5[_0[_7]] % _4)) + 1)] += 1
   for _8 in range(0,(_2 * _4)):
    _1[(_8 + 1)] = (_1[(_8 + 1)] + _1[_8])
   _9=numpy.array([_0[_10] for _10 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64))
   for _11 in range(0,long((_5).shape[0])):
    _12=(((_5[_9[_11]] // (_3 * _4)) * _4) + (_5[_9[_11]] % _4))
    _0[_1[_12]] = _9[_11]
    _1[_12] += 1
  @staticmethod
  def _match_argsort__3J_3J(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1))
  @staticmethod
  def _match_alt_argsort__3J_3J(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1))
  @staticmethod
  def _argsort_alt__3J_3J(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _1 = mosek_fusion_Sort._argsort__3J_3J(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argsort__3J_3J(_0,_1):
   mosek.fusion.Sort._argsort__3J_3JJJZ(_0,_1,0,int((_0).shape[0]),False)
  @staticmethod
  def _match_argsort__3J_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_argsort__3J_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1))
  @staticmethod
  def _argsort_alt__3J_3I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = mosek_fusion_Sort._argsort__3J_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argsort__3J_3I(_0,_1):
   mosek.fusion.Sort._argsort__3J_3IJJZ(_0,_1,0,int((_0).shape[0]),False)
  @staticmethod
  def _match_argsort__3J_3J_3J(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match__3J__(_2))
  @staticmethod
  def _match_alt_argsort__3J_3J_3J(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match__3J__(_2))
  @staticmethod
  def _argsort_alt__3J_3J_3J(_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _1 = mosek_fusion_Sort._argsort__3J_3J_3J(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argsort__3J_3J_3J(_0,_1,_2):
   mosek.fusion.Sort._argsort__3J_3J_3JJJZ(_0,_1,_2,0,int((_0).shape[0]),False)
  @staticmethod
  def _match_argsort__3J_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2))
  @staticmethod
  def _match_alt_argsort__3J_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2))
  @staticmethod
  def _argsort_alt__3J_3I_3I(_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _1 = mosek_fusion_Sort._argsort__3J_3I_3I(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argsort__3J_3I_3I(_0,_1,_2):
   mosek.fusion.Sort._argsort__3J_3I_3IJJZ(_0,_1,_2,0,int((_0).shape[0]),False)
  @staticmethod
  def _match_argsort__3J_3JJJ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match_J__(_2) and __arg_match_J__(_3))
  @staticmethod
  def _match_alt_argsort__3J_3JJJ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match_J__(_2) and __arg_alt_match_J__(_3))
  @staticmethod
  def _argsort_alt__3J_3JJJ(_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.int64(_t__2)
   _3=numpy.int64(_t__3)
   _1 = mosek_fusion_Sort._argsort__3J_3JJJ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argsort__3J_3JJJ(_0,_1,_2,_3):
   mosek.fusion.Sort._argsort__3J_3JJJZ(_0,_1,_2,_3,False)
  @staticmethod
  def _match_argsort__3J_3IJJ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match_J__(_2) and __arg_match_J__(_3))
  @staticmethod
  def _match_alt_argsort__3J_3IJJ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match_J__(_2) and __arg_alt_match_J__(_3))
  @staticmethod
  def _argsort_alt__3J_3IJJ(_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.int64(_t__2)
   _3=numpy.int64(_t__3)
   _1 = mosek_fusion_Sort._argsort__3J_3IJJ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argsort__3J_3IJJ(_0,_1,_2,_3):
   mosek.fusion.Sort._argsort__3J_3IJJZ(_0,_1,_2,_3,False)
  @staticmethod
  def _match_argsort__3J_3J_3JJJ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match__3J__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4))
  @staticmethod
  def _match_alt_argsort__3J_3J_3JJJ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4))
  @staticmethod
  def _argsort_alt__3J_3J_3JJJ(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _1 = mosek_fusion_Sort._argsort__3J_3J_3JJJ(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argsort__3J_3J_3JJJ(_0,_1,_2,_3,_4):
   mosek.fusion.Sort._argsort__3J_3J_3JJJZ(_0,_1,_2,_3,_4,False)
  @staticmethod
  def _match_argsort__3J_3I_3IJJ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4))
  @staticmethod
  def _match_alt_argsort__3J_3I_3IJJ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4))
  @staticmethod
  def _argsort_alt__3J_3I_3IJJ(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _1 = mosek_fusion_Sort._argsort__3J_3I_3IJJ(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argsort__3J_3I_3IJJ(_0,_1,_2,_3,_4):
   mosek.fusion.Sort._argsort__3J_3I_3IJJZ(_0,_1,_2,_3,_4,False)
  @staticmethod
  def _match_argsort__3J_3JJJZ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match_J__(_2) and __arg_match_J__(_3) and __arg_match_Z__(_4))
  @staticmethod
  def _match_alt_argsort__3J_3JJJZ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match_J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_Z__(_4))
  @staticmethod
  def _argsort_alt__3J_3JJJZ(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.int64(_t__2)
   _3=numpy.int64(_t__3)
   _4=_t__4
   _1 = mosek_fusion_Sort._argsort__3J_3JJJZ(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argsort__3J_3JJJZ(_0,_1,_2,_3,_4):
   if ((not _4) or ((_3 - _2) < 16)):
    mosek.fusion.Utils.Tools._argsort__3J_3JJJ(_0,_1,_2,_3)
   elif (not mosek.fusion.Sort._issorted__3J_3JJJZ(_0,_1,_2,_3,_4)):
    _5=numpy.zeros((4,), dtype=numpy.dtype(numpy.int64))
    _6=2
    mosek.fusion.Sort._getminmax__3J_3J_3JJJ_3J(_0,_1,None,_2,_3,_5)
    if ((_5[1] - _5[0]) < (_6 * (_3 - _2))):
     mosek.fusion.Sort._argbucketsort__3J_3JJJJJ(_0,_1,_2,_3,_5[0],_5[1])
    else:
     mosek.fusion.Utils.Tools._argsort__3J_3JJJ(_0,_1,_2,_3)
  @staticmethod
  def _match_argsort__3J_3IJJZ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match_J__(_2) and __arg_match_J__(_3) and __arg_match_Z__(_4))
  @staticmethod
  def _match_alt_argsort__3J_3IJJZ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match_J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_Z__(_4))
  @staticmethod
  def _argsort_alt__3J_3IJJZ(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.int64(_t__2)
   _3=numpy.int64(_t__3)
   _4=_t__4
   _1 = mosek_fusion_Sort._argsort__3J_3IJJZ(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argsort__3J_3IJJZ(_0,_1,_2,_3,_4):
   if ((not _4) or ((_3 - _2) < 16)):
    mosek.fusion.Utils.Tools._argsort__3J_3IJJ(_0,_1,_2,_3)
   elif (not mosek.fusion.Sort._issorted__3J_3IJJZ(_0,_1,_2,_3,_4)):
    _5=numpy.zeros((4,), dtype=numpy.dtype(numpy.int32))
    _6=2
    mosek.fusion.Sort._getminmax__3J_3I_3IJJ_3I(_0,_1,None,_2,_3,_5)
    if ((_5[1] - _5[0]) < (_6 * (_3 - _2))):
     mosek.fusion.Sort._argbucketsort__3J_3IJJII(_0,_1,_2,_3,_5[0],_5[1])
    else:
     mosek.fusion.Utils.Tools._argsort__3J_3IJJ(_0,_1,_2,_3)
  @staticmethod
  def _match_argsort__3J_3J_3JJJZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match__3J__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_argsort__3J_3J_3JJJZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match_Z__(_5))
  @staticmethod
  def _argsort_alt__3J_3J_3JJJZ(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=_t__5
   _1 = mosek_fusion_Sort._argsort__3J_3J_3JJJZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argsort__3J_3J_3JJJZ(_0,_1,_2,_3,_4,_5):
   if ((not _5) or ((_4 - _3) < 16)):
    mosek.fusion.Utils.Tools._argsort__3J_3J_3JJJ(_0,_1,_2,_3,_4)
   elif (not mosek.fusion.Sort._issorted__3J_3J_3JJJZ(_0,_1,_2,_3,_4,_5)):
    _6=numpy.zeros((4,), dtype=numpy.dtype(numpy.int64))
    _7=2
    mosek.fusion.Sort._getminmax__3J_3J_3JJJ_3J(_0,_1,_2,_3,_4,_6)
    if (((_6[1] - _6[0]) < (_7 * (_4 - _3))) and ((_6[3] - _6[2]) < (_7 * (_4 - _3)))):
     mosek.fusion.Sort._argbucketsort__3J_3JJJJJ(_0,_2,_3,_4,_6[2],_6[3])
     mosek.fusion.Sort._argbucketsort__3J_3JJJJJ(_0,_1,_3,_4,_6[0],_6[1])
    else:
     mosek.fusion.Utils.Tools._argsort__3J_3J_3JJJ(_0,_1,_2,_3,_4)
  @staticmethod
  def _match_argsort__3J_3I_3IJJZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_argsort__3J_3I_3IJJZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match_Z__(_5))
  @staticmethod
  def _argsort_alt__3J_3I_3IJJZ(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=_t__5
   _1 = mosek_fusion_Sort._argsort__3J_3I_3IJJZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argsort__3J_3I_3IJJZ(_0,_1,_2,_3,_4,_5):
   if ((not _5) or ((_4 - _3) < 16)):
    mosek.fusion.Utils.Tools._argsort__3J_3I_3IJJ(_0,_1,_2,_3,_4)
   elif (not mosek.fusion.Sort._issorted__3J_3I_3IJJZ(_0,_1,_2,_3,_4,_5)):
    _6=numpy.zeros((4,), dtype=numpy.dtype(numpy.int32))
    _7=2
    mosek.fusion.Sort._getminmax__3J_3I_3IJJ_3I(_0,_1,_2,_3,_4,_6)
    if (((_6[1] - _6[0]) < (_7 * (_4 - _3))) and ((_6[3] - _6[2]) < (_7 * (_4 - _3)))):
     mosek.fusion.Sort._argbucketsort__3J_3IJJII(_0,_2,_3,_4,_6[2],_6[3])
     mosek.fusion.Sort._argbucketsort__3J_3IJJII(_0,_1,_3,_4,_6[0],_6[1])
    else:
     mosek.fusion.Utils.Tools._argsort__3J_3I_3IJJ(_0,_1,_2,_3,_4)
  @staticmethod
  def _match_argbucketsort__3J_3JJJJJ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match_J__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match_J__(_5))
  @staticmethod
  def _match_alt_argbucketsort__3J_3JJJJJ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match_J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match_J__(_5))
  @staticmethod
  def _argbucketsort_alt__3J_3JJJJJ(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.int64(_t__2)
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=numpy.int64(_t__5)
   _1 = mosek_fusion_Sort._argbucketsort__3J_3JJJJJ(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argbucketsort__3J_3JJJJJ(_0,_1,_2,_3,_4,_5):
   mosek.fusion.Utils.Tools._bucketsort__3JJJ_3JJJ(_0,_2,_3,_1,_4,_5)
  @staticmethod
  def _match_argbucketsort__3J_3IJJII(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match_J__(_2) and __arg_match_J__(_3) and __arg_match_I__(_4) and __arg_match_I__(_5))
  @staticmethod
  def _match_alt_argbucketsort__3J_3IJJII(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match_J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_I__(_4) and __arg_alt_match_I__(_5))
  @staticmethod
  def _argbucketsort_alt__3J_3IJJII(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.int64(_t__2)
   _3=numpy.int64(_t__3)
   _4=numpy.int32(_t__4)
   _5=numpy.int32(_t__5)
   _1 = mosek_fusion_Sort._argbucketsort__3J_3IJJII(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argbucketsort__3J_3IJJII(_0,_1,_2,_3,_4,_5):
   mosek.fusion.Utils.Tools._bucketsort__3JJJ_3III(_0,_2,_3,_1,_4,_5)
  @staticmethod
  def _match_getminmax__3J_3J_3JJJ_3J(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match__3J__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match__3J__(_5))
  @staticmethod
  def _match_alt_getminmax__3J_3J_3JJJ_3J(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match__3J__(_5))
  @staticmethod
  def _getminmax_alt__3J_3J_3JJJ_3J(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int64))
   _1 = mosek_fusion_Sort._getminmax__3J_3J_3JJJ_3J(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _getminmax__3J_3J_3JJJ_3J(_0,_1,_2,_3,_4,_5):
   _5[0] = _1[_0[_3]]
   _5[1] = _1[_0[_3]]
   for _6 in range((_3 + 1),_4):
    if (_5[0] > _1[_0[_6]]):
     _5[0] = _1[_0[_6]]
    if (_5[1] < _1[_0[_6]]):
     _5[1] = _1[_0[_6]]
   if (_2 is not None):
    _5[2] = _2[_0[_3]]
    _5[3] = _2[_0[_3]]
    for _7 in range((_3 + 1),_4):
     if (_5[2] > _2[_0[_7]]):
      _5[2] = _2[_0[_7]]
     if (_5[3] < _2[_0[_7]]):
      _5[3] = _2[_0[_7]]
  @staticmethod
  def _match_getminmax__3J_3I_3IJJ_3I(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match__3I__(_5))
  @staticmethod
  def _match_alt_getminmax__3J_3I_3IJJ_3I(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match__3I__(_5))
  @staticmethod
  def _getminmax_alt__3J_3I_3IJJ_3I(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int32))
   _1 = mosek_fusion_Sort._getminmax__3J_3I_3IJJ_3I(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _getminmax__3J_3I_3IJJ_3I(_0,_1,_2,_3,_4,_5):
   _5[0] = _1[_0[_3]]
   _5[1] = _1[_0[_3]]
   for _6 in range((_3 + 1),_4):
    if (_5[0] > _1[_0[_6]]):
     _5[0] = _1[_0[_6]]
    if (_5[1] < _1[_0[_6]]):
     _5[1] = _1[_0[_6]]
   if (_2 is not None):
    _5[2] = _2[_0[_3]]
    _5[3] = _2[_0[_3]]
    for _7 in range((_3 + 1),_4):
     if (_5[2] > _2[_0[_7]]):
      _5[2] = _2[_0[_7]]
     if (_5[3] < _2[_0[_7]]):
      _5[3] = _2[_0[_7]]
  @staticmethod
  def _match_issorted__3J_3JJJZ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match_J__(_2) and __arg_match_J__(_3) and __arg_match_Z__(_4))
  @staticmethod
  def _match_alt_issorted__3J_3JJJZ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match_J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_Z__(_4))
  @staticmethod
  def _issorted_alt__3J_3JJJZ(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.int64(_t__2)
   _3=numpy.int64(_t__3)
   _4=_t__4
   _1 = mosek_fusion_Sort._issorted__3J_3JJJZ(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _issorted__3J_3JJJZ(_0,_1,_2,_3,_4):
   for _5 in range(_2,(_3 - 1)):
    if (_1[_0[_5]] > _1[_0[(_5 + 1)]]):
     return (False)
   return (True)
  @staticmethod
  def _match_issorted__3J_3IJJZ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match_J__(_2) and __arg_match_J__(_3) and __arg_match_Z__(_4))
  @staticmethod
  def _match_alt_issorted__3J_3IJJZ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match_J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_Z__(_4))
  @staticmethod
  def _issorted_alt__3J_3IJJZ(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.int64(_t__2)
   _3=numpy.int64(_t__3)
   _4=_t__4
   _1 = mosek_fusion_Sort._issorted__3J_3IJJZ(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _issorted__3J_3IJJZ(_0,_1,_2,_3,_4):
   for _5 in range(_2,(_3 - 1)):
    if (_1[_0[_5]] > _1[_0[(_5 + 1)]]):
     return (False)
   return (True)
  @staticmethod
  def _match_issorted__3J_3J_3JJJZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match__3J__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_issorted__3J_3J_3JJJZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match_Z__(_5))
  @staticmethod
  def _issorted_alt__3J_3J_3JJJZ(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=_t__5
   _1 = mosek_fusion_Sort._issorted__3J_3J_3JJJZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _issorted__3J_3J_3JJJZ(_0,_1,_2,_3,_4,_5):
   for _6 in range(_3,(_4 - 1)):
    if ((_1[_0[_6]] > _1[_0[(_6 + 1)]]) or ((_1[_0[(_6 + 1)]]==_1[_0[_6]]) and (_2[_0[_6]] > _2[_0[(_6 + 1)]]))):
     return (False)
   return (True)
  @staticmethod
  def _match_issorted__3J_3I_3IJJZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_issorted__3J_3I_3IJJZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match_Z__(_5))
  @staticmethod
  def _issorted_alt__3J_3I_3IJJZ(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=_t__5
   _1 = mosek_fusion_Sort._issorted__3J_3I_3IJJZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _issorted__3J_3I_3IJJZ(_0,_1,_2,_3,_4,_5):
   for _6 in range(_3,(_4 - 1)):
    if ((_1[_0[_6]] > _1[_0[(_6 + 1)]]) or ((_1[_0[_6]]==_1[_0[(_6 + 1)]]) and (_2[_0[_6]] > _2[_0[(_6 + 1)]]))):
     return (False)
   return (True)
 return Sort
mosek_fusion_Sort=__mk_mosek_fusion_Sort()
del __mk_mosek_fusion_Sort
#BEFORE CLASS
def __mk_mosek_fusion_IndexCounter():
 class IndexCounter(object):
  __slots__ = ['_IndexCounter__start','_IndexCounter__dims','_IndexCounter__strides','_IndexCounter__st','_IndexCounter__ii','_IndexCounter__n']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_Lmosek_4fusion_4Set_2(*args): # mosek.fusion.Set
      self._ctor_init_Lmosek_4fusion_4Set_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4Set_2(*args):# mosek.fusion.Set
      self._ctor_alt_init_Lmosek_4fusion_4Set_2(*args)
    elif self.__match_ctor_J_3ILmosek_4fusion_4Set_2(*args): # int64,[]int32,mosek.fusion.Set
      self._ctor_init_J_3ILmosek_4fusion_4Set_2(*args)
    elif self.__match_alt_ctor_J_3ILmosek_4fusion_4Set_2(*args):# int64,[]int32,mosek.fusion.Set
      self._ctor_alt_init_J_3ILmosek_4fusion_4Set_2(*args)
    elif self.__match_ctor_J_3I_3J(*args): # int64,[]int32,[]int64
      self._ctor_init_J_3I_3J(*args)
    elif self.__match_alt_ctor_J_3I_3J(*args):# int64,[]int32,[]int64
      self._ctor_alt_init_J_3I_3J(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.IndexCounter.ctor(mosek.fusion.Set)\n\tmosek.fusion.IndexCounter.ctor(int64,array(int32,ndim=1),mosek.fusion.Set)\n\tmosek.fusion.IndexCounter.ctor(int64,array(int32,ndim=1),array(int64,ndim=1))')
  def next(self,*args):
    if False: pass
    elif mosek_fusion_IndexCounter._match_next_(*args): # 
      return self._next_(*args)
    elif mosek_fusion_IndexCounter._match_alt_next_(*args): # 
      return self._next_alt_(*args)
    else:
      raise ValueError('Invalid argument list next('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.next()')
  def inc(self,*args):
    if False: pass
    elif mosek_fusion_IndexCounter._match_inc_(*args): # 
      return self._inc_(*args)
    elif mosek_fusion_IndexCounter._match_alt_inc_(*args): # 
      return self._inc_alt_(*args)
    else:
      raise ValueError('Invalid argument list inc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.inc()')
  def getIndex(self,*args):
    if False: pass
    elif mosek_fusion_IndexCounter._match_getIndex_(*args): # 
      return self._getIndex_(*args)
    elif mosek_fusion_IndexCounter._match_alt_getIndex_(*args): # 
      return self._getIndex_alt_(*args)
    else:
      raise ValueError('Invalid argument list getIndex('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.getIndex()')
  def atEnd(self,*args):
    if False: pass
    elif mosek_fusion_IndexCounter._match_atEnd_(*args): # 
      return self._atEnd_(*args)
    elif mosek_fusion_IndexCounter._match_alt_atEnd_(*args): # 
      return self._atEnd_alt_(*args)
    else:
      raise ValueError('Invalid argument list atEnd('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.atEnd()')
  def get(self,*args):
    if False: pass
    elif mosek_fusion_IndexCounter._match_get_(*args): # 
      return self._get_(*args)
    elif mosek_fusion_IndexCounter._match_alt_get_(*args): # 
      return self._get_alt_(*args)
    else:
      raise ValueError('Invalid argument list get('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.get()')
  def reset(self,*args):
    if False: pass
    elif mosek_fusion_IndexCounter._match_reset_(*args): # 
      return self._reset_(*args)
    elif mosek_fusion_IndexCounter._match_alt_reset_(*args): # 
      return self._reset_alt_(*args)
    else:
      raise ValueError('Invalid argument list reset('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.reset()')
  def __repr__(self): return 'mosek.fusion.IndexCounter'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Set_2(shape):
    o = IndexCounter.__new__(IndexCounter)
    o._ctor_init_Lmosek_4fusion_4Set_2(shape)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Set_2(*args):
    if len(args) != 1: return False
    shape, = args
    return (__arg_match_Lmosek_4fusion_4Set_2__(shape))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Set_2(*args):
    if len(args) != 1: return False
    shape, = args
    return (__arg_alt_match_Lmosek_4fusion_4Set_2__(shape))
  def _ctor_alt_init_Lmosek_4fusion_4Set_2(self,shape):
    self._ctor_init_Lmosek_4fusion_4Set_2(shape)
  def _ctor_init_Lmosek_4fusion_4Set_2(self,shape):
   object.__init__(self)
   self.__n = (shape.nd)
   self.__ii = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int32))
   self.__st = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int64))
   self.__start = 0
   self.__strides = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int64))
   for _0 in range(0,self.__n):
    self.__strides[_0] = shape.stride(_0)
   self.__dims = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int32))
   for _1 in range(0,self.__n):
    self.__dims[_1] = shape.dim(_1)
  @staticmethod
  def _ctor_J_3ILmosek_4fusion_4Set_2(start_,dims_,shape):
    o = IndexCounter.__new__(IndexCounter)
    o._ctor_init_J_3ILmosek_4fusion_4Set_2(start_,dims_,shape)
    return o
  @staticmethod
  def __match_ctor_J_3ILmosek_4fusion_4Set_2(*args):
    if len(args) != 3: return False
    start_,dims_,shape, = args
    return (__arg_match_J__(start_) and __arg_match__3I__(dims_) and __arg_match_Lmosek_4fusion_4Set_2__(shape))
  @staticmethod
  def __match_alt_ctor_J_3ILmosek_4fusion_4Set_2(*args):
    if len(args) != 3: return False
    start_,dims_,shape, = args
    return (__arg_alt_match_J__(start_) and __arg_alt_match__3I__(dims_) and __arg_alt_match_Lmosek_4fusion_4Set_2__(shape))
  def _ctor_alt_init_J_3ILmosek_4fusion_4Set_2(self,start_,dims_,shape):
    self._ctor_init_J_3ILmosek_4fusion_4Set_2(numpy.int64(start_),numpy.array(dims_,dtype=numpy.dtype(numpy.int32)),shape)
  def _ctor_init_J_3ILmosek_4fusion_4Set_2(self,start_,dims_,shape):
   object.__init__(self)
   self.__n = int((dims_).shape[0])
   self.__ii = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int32))
   self.__st = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int64))
   for _0 in range(0,self.__n):
    self.__st[_0] = start_
   self.__strides = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int64))
   for _1 in range(0,self.__n):
    self.__strides[_1] = shape.stride(_1)
   self.__dims = dims_
   self.__start = start_
  @staticmethod
  def _ctor_J_3I_3J(start_,dims_,strides_):
    o = IndexCounter.__new__(IndexCounter)
    o._ctor_init_J_3I_3J(start_,dims_,strides_)
    return o
  @staticmethod
  def __match_ctor_J_3I_3J(*args):
    if len(args) != 3: return False
    start_,dims_,strides_, = args
    return (__arg_match_J__(start_) and __arg_match__3I__(dims_) and __arg_match__3J__(strides_))
  @staticmethod
  def __match_alt_ctor_J_3I_3J(*args):
    if len(args) != 3: return False
    start_,dims_,strides_, = args
    return (__arg_alt_match_J__(start_) and __arg_alt_match__3I__(dims_) and __arg_alt_match__3J__(strides_))
  def _ctor_alt_init_J_3I_3J(self,start_,dims_,strides_):
    self._ctor_init_J_3I_3J(numpy.int64(start_),numpy.array(dims_,dtype=numpy.dtype(numpy.int32)),numpy.array(strides_,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_J_3I_3J(self,start_,dims_,strides_):
   object.__init__(self)
   self.__n = int((dims_).shape[0])
   self.__ii = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int32))
   self.__st = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int64))
   for _0 in range(0,self.__n):
    self.__st[_0] = start_
   self.__strides = strides_
   self.__dims = dims_
   self.__start = start_
  @staticmethod
  def _match_atEnd_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_atEnd_(*args):
    if len(args) != 0: return False
    return True
  def _atEnd_alt_(self,):
    return self._atEnd_()
  def _atEnd_(self,):
   return ((self.__ii[(self.__n - 1)] >= self.__dims[(self.__n - 1)]))
  @staticmethod
  def _match_getIndex_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getIndex_(*args):
    if len(args) != 0: return False
    return True
  def _getIndex_alt_(self,):
    return self._getIndex_()
  def _getIndex_(self,):
   return (self.__ii)
  @staticmethod
  def _match_next_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_next_(*args):
    if len(args) != 0: return False
    return True
  def _next_alt_(self,):
    return self._next_()
  def _next_(self,):
   _0=self.get()
   self.inc()
   return numpy.int64(_0)
  @staticmethod
  def _match_get_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_get_(*args):
    if len(args) != 0: return False
    return True
  def _get_alt_(self,):
    return self._get_()
  def _get_(self,):
   return numpy.int64(self.__st[0])
  @staticmethod
  def _match_inc_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_inc_(*args):
    if len(args) != 0: return False
    return True
  def _inc_alt_(self,):
    return self._inc_()
  def _inc_(self,):
   self.__ii[0] += 1
   self.__st[0] = (self.__st[0] + self.__strides[(self.__n - 1)])
   _0 = 0
   while ((_0 < (self.__n - 1)) and (self.__ii[_0]==self.__dims[((self.__n - _0) - 1)])):
    self.__ii[_0] = 0
    self.__ii[(_0 + 1)] += 1
    self.__st[(_0 + 1)] = (self.__st[(_0 + 1)] + self.__strides[((self.__n - _0) - 2)])
    _0 += 1
   for _1 in range(0,_0):
    self.__st[_1] = self.__st[_0]
  @staticmethod
  def _match_reset_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_reset_(*args):
    if len(args) != 0: return False
    return True
  def _reset_alt_(self,):
    return self._reset_()
  def _reset_(self,):
   self.__st = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int64))
   for _0 in range(0,self.__n):
    self.__st[_0] = self.__start
 return IndexCounter
mosek_fusion_IndexCounter=__mk_mosek_fusion_IndexCounter()
del __mk_mosek_fusion_IndexCounter
#BEFORE CLASS
def __mk_mosek_fusion_CommonTools():
 class CommonTools(object):
  @staticmethod
  def tripletSort(*args):
    if False: pass
    elif mosek_fusion_CommonTools._match_tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(*args): # []int32,[]int32,[]double,[][]int32,[][]int32,[][]double,int64,int32,int32
      return mosek_fusion_CommonTools._tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(*args)
    elif mosek_fusion_CommonTools._match_alt_tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(*args): # []int32,[]int32,[]double,[][]int32,[][]int32,[][]double,int64,int32,int32
      return mosek_fusion_CommonTools._tripletSort_alt__3I_3I_3D_3_3I_3_3I_3_3DJII(*args)
    else:
      raise ValueError('Invalid argument list tripletSort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.tripletSort(array(int32,ndim=1),array(int32,ndim=1),array(double,ndim=1),array(array(int32,ndim=1),ndim=1),array(array(int32,ndim=1),ndim=1),array(array(double,ndim=1),ndim=1),int64,int32,int32)')
  @staticmethod
  def argQsort(*args):
    if False: pass
    elif mosek_fusion_CommonTools._match_argQsort__3J_3I_3IJJ(*args): # []int64,[]int32,[]int32,int64,int64
      return mosek_fusion_CommonTools._argQsort__3J_3I_3IJJ(*args)
    elif mosek_fusion_CommonTools._match_alt_argQsort__3J_3I_3IJJ(*args): # []int64,[]int32,[]int32,int64,int64
      return mosek_fusion_CommonTools._argQsort_alt__3J_3I_3IJJ(*args)
    elif mosek_fusion_CommonTools._match_argQsort__3J_3J_3JJJ(*args): # []int64,[]int64,[]int64,int64,int64
      return mosek_fusion_CommonTools._argQsort__3J_3J_3JJJ(*args)
    elif mosek_fusion_CommonTools._match_alt_argQsort__3J_3J_3JJJ(*args): # []int64,[]int64,[]int64,int64,int64
      return mosek_fusion_CommonTools._argQsort_alt__3J_3J_3JJJ(*args)
    else:
      raise ValueError('Invalid argument list argQsort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.argQsort(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64)\n\tmosek.fusion.CommonTools.argQsort(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64)')
  @staticmethod
  def transposeTriplets(*args):
    if False: pass
    elif mosek_fusion_CommonTools._match_transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(*args): # []int32,[]int32,[]double,[][]int32,[][]int32,[][]double,int64,int32,int32
      return mosek_fusion_CommonTools._transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(*args)
    elif mosek_fusion_CommonTools._match_alt_transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(*args): # []int32,[]int32,[]double,[][]int32,[][]int32,[][]double,int64,int32,int32
      return mosek_fusion_CommonTools._transposeTriplets_alt__3I_3I_3D_3_3I_3_3I_3_3DJII(*args)
    elif mosek_fusion_CommonTools._match_transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(*args): # []int32,[]int32,[]double,[][]int64,[][]int64,[][]double,int64,int32,int32
      return mosek_fusion_CommonTools._transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(*args)
    elif mosek_fusion_CommonTools._match_alt_transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(*args): # []int32,[]int32,[]double,[][]int64,[][]int64,[][]double,int64,int32,int32
      return mosek_fusion_CommonTools._transposeTriplets_alt__3I_3I_3D_3_3J_3_3J_3_3DJII(*args)
    else:
      raise ValueError('Invalid argument list transposeTriplets('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.transposeTriplets(array(int32,ndim=1),array(int32,ndim=1),array(double,ndim=1),array(array(int32,ndim=1),ndim=1),array(array(int32,ndim=1),ndim=1),array(array(double,ndim=1),ndim=1),int64,int32,int32)\n\tmosek.fusion.CommonTools.transposeTriplets(array(int32,ndim=1),array(int32,ndim=1),array(double,ndim=1),array(array(int64,ndim=1),ndim=1),array(array(int64,ndim=1),ndim=1),array(array(double,ndim=1),ndim=1),int64,int32,int32)')
  @staticmethod
  def argMSort(*args):
    if False: pass
    elif mosek_fusion_CommonTools._match_argMSort__3I_3I(*args): # []int32,[]int32
      return mosek_fusion_CommonTools._argMSort__3I_3I(*args)
    elif mosek_fusion_CommonTools._match_alt_argMSort__3I_3I(*args): # []int32,[]int32
      return mosek_fusion_CommonTools._argMSort_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list argMSort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.argMSort(array(int32,ndim=1),array(int32,ndim=1))')
  @staticmethod
  def ndIncr(*args):
    if False: pass
    elif mosek_fusion_CommonTools._match_ndIncr__3I_3I_3I(*args): # []int32,[]int32,[]int32
      return mosek_fusion_CommonTools._ndIncr__3I_3I_3I(*args)
    elif mosek_fusion_CommonTools._match_alt_ndIncr__3I_3I_3I(*args): # []int32,[]int32,[]int32
      return mosek_fusion_CommonTools._ndIncr_alt__3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list ndIncr('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.ndIncr(array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def __repr__(self): return 'mosek.fusion.CommonTools'
  @staticmethod
  def _match_ndIncr__3I_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2))
  @staticmethod
  def _match_alt_ndIncr__3I_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2))
  @staticmethod
  def _ndIncr_alt__3I_3I_3I(_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _1 = mosek_fusion_CommonTools._ndIncr__3I_3I_3I(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _ndIncr__3I_3I_3I(_0,_1,_2):
   _3=(int((_0).shape[0]) - 1)
   _0[_3] += 1
   while ((_3 > 0) and (_0[_3] >= _2[_3])):
    _0[_3] = _1[_3]
    _0[(_3 - 1)] += 1
  @staticmethod
  def _match_transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(*args):
    if len(args) != 9: return False
    _0,_1,_2,_3,_4,_5,_6,_7,_8, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1) and __arg_match__3D__(_2) and __arg_match__3_3J__(_3) and __arg_match__3_3J__(_4) and __arg_match__3_3D__(_5) and __arg_match_J__(_6) and __arg_match_I__(_7) and __arg_match_I__(_8))
  @staticmethod
  def _match_alt_transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(*args):
    if len(args) != 9: return False
    _0,_1,_2,_3,_4,_5,_6,_7,_8, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match__3_3J__(_3) and __arg_alt_match__3_3J__(_4) and __arg_alt_match__3_3D__(_5) and __arg_alt_match_J__(_6) and __arg_alt_match_I__(_7) and __arg_alt_match_I__(_8))
  @staticmethod
  def _transposeTriplets_alt__3I_3I_3D_3_3J_3_3J_3_3DJII(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7,_t__8):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_monty.makeJaggedArray(_t__3,(1,1),numpy.dtype(numpy.int64))
   _4=_monty.makeJaggedArray(_t__4,(1,1),numpy.dtype(numpy.int64))
   _5=_monty.makeJaggedArray(_t__5,(1,1),numpy.dtype(numpy.float64))
   _6=numpy.int64(_t__6)
   _7=numpy.int32(_t__7)
   _8=numpy.int32(_t__8)
   _1 = mosek_fusion_CommonTools._transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(_0,_1,_2,_3,_4,_5,_6,_7,_8)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(_0,_1,_2,_3,_4,_5,_6,_7,_8):
   _9=numpy.zeros(((_7 + 2),), dtype=numpy.dtype(numpy.int64))
   _10=numpy.zeros(((_8 + 2),), dtype=numpy.dtype(numpy.int64))
   _11=0
   while (_11 < _6):
    _10[(_1[_11] + 2)] = (_10[(_1[_11] + 2)] + 1)
    _9[(_0[_11] + 2)] = (_9[(_0[_11] + 2)] + 1)
    _11 += 1
   _12=1
   while (_12 < _7):
    _9[(_12 + 1)] = (_9[(_12 + 1)] + _9[_12])
    _12 += 1
   _13=1
   while (_13 < _8):
    _10[(_13 + 1)] = (_10[(_13 + 1)] + _10[_13])
    _13 += 1
   _14=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int64))
   _15=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int64))
   _16=numpy.zeros((_6,), dtype=numpy.dtype(numpy.float64))
   for _17 in range(0,_7):
    _18=_9[_17]
    while (_18 < _9[(_17 + 1)]):
     _19=_1[_18]
     _20=_10[_19]
     _14[_20] = _17
     _15[_20] = _19
     _16[_20] = _2[_18]
     _10[_19] = (_20 + 1)
     _18 += 1
   _3[0] = _15
   _4[0] = _14
   _5[0] = _16
  @staticmethod
  def _match_transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
    if len(args) != 9: return False
    _0,_1,_2,_3,_4,_5,_6,_7,_8, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1) and __arg_match__3D__(_2) and __arg_match__3_3I__(_3) and __arg_match__3_3I__(_4) and __arg_match__3_3D__(_5) and __arg_match_J__(_6) and __arg_match_I__(_7) and __arg_match_I__(_8))
  @staticmethod
  def _match_alt_transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
    if len(args) != 9: return False
    _0,_1,_2,_3,_4,_5,_6,_7,_8, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match__3_3I__(_3) and __arg_alt_match__3_3I__(_4) and __arg_alt_match__3_3D__(_5) and __arg_alt_match_J__(_6) and __arg_alt_match_I__(_7) and __arg_alt_match_I__(_8))
  @staticmethod
  def _transposeTriplets_alt__3I_3I_3D_3_3I_3_3I_3_3DJII(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7,_t__8):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_monty.makeJaggedArray(_t__3,(1,1),numpy.dtype(numpy.int32))
   _4=_monty.makeJaggedArray(_t__4,(1,1),numpy.dtype(numpy.int32))
   _5=_monty.makeJaggedArray(_t__5,(1,1),numpy.dtype(numpy.float64))
   _6=numpy.int64(_t__6)
   _7=numpy.int32(_t__7)
   _8=numpy.int32(_t__8)
   _1 = mosek_fusion_CommonTools._transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(_0,_1,_2,_3,_4,_5,_6,_7,_8)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(_0,_1,_2,_3,_4,_5,_6,_7,_8):
   _9=numpy.zeros(((_7 + 2),), dtype=numpy.dtype(numpy.int64))
   _10=numpy.zeros(((_8 + 2),), dtype=numpy.dtype(numpy.int64))
   _11=0
   while (_11 < _6):
    _10[(_1[_11] + 2)] = (_10[(_1[_11] + 2)] + 1)
    _9[(_0[_11] + 2)] = (_9[(_0[_11] + 2)] + 1)
    _11 += 1
   _12=1
   while (_12 < _7):
    _9[(_12 + 1)] = (_9[(_12 + 1)] + _9[_12])
    _12 += 1
   _13=1
   while (_13 < _8):
    _10[(_13 + 1)] = (_10[(_13 + 1)] + _10[_13])
    _13 += 1
   _14=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int32))
   _15=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int32))
   _16=numpy.zeros((_6,), dtype=numpy.dtype(numpy.float64))
   _17=0
   while (_17 < _7):
    for _18 in range(_9[_17],_9[(_17 + 1)]):
     _19=_1[_18]
     _20=_10[_19]
     _14[_20] = _17
     _15[_20] = _19
     _16[_20] = _2[_18]
     _10[_19] = (_20 + 1)
    _17 += 1
   _3[0] = _15
   _4[0] = _14
   _5[0] = _16
  @staticmethod
  def _match_tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
    if len(args) != 9: return False
    _0,_1,_2,_3,_4,_5,_6,_7,_8, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1) and __arg_match__3D__(_2) and __arg_match__3_3I__(_3) and __arg_match__3_3I__(_4) and __arg_match__3_3D__(_5) and __arg_match_J__(_6) and __arg_match_I__(_7) and __arg_match_I__(_8))
  @staticmethod
  def _match_alt_tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
    if len(args) != 9: return False
    _0,_1,_2,_3,_4,_5,_6,_7,_8, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match__3_3I__(_3) and __arg_alt_match__3_3I__(_4) and __arg_alt_match__3_3D__(_5) and __arg_alt_match_J__(_6) and __arg_alt_match_I__(_7) and __arg_alt_match_I__(_8))
  @staticmethod
  def _tripletSort_alt__3I_3I_3D_3_3I_3_3I_3_3DJII(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7,_t__8):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_monty.makeJaggedArray(_t__3,(1,1),numpy.dtype(numpy.int32))
   _4=_monty.makeJaggedArray(_t__4,(1,1),numpy.dtype(numpy.int32))
   _5=_monty.makeJaggedArray(_t__5,(1,1),numpy.dtype(numpy.float64))
   _6=numpy.int64(_t__6)
   _7=numpy.int32(_t__7)
   _8=numpy.int32(_t__8)
   _1 = mosek_fusion_CommonTools._tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(_0,_1,_2,_3,_4,_5,_6,_7,_8)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(_0,_1,_2,_3,_4,_5,_6,_7,_8):
   _9=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int32))
   _10=numpy.zeros(((_8 + 2),), dtype=numpy.dtype(numpy.int64))
   for _11 in range(0,_6):
    _10[(_1[_11] + 2)] = (_10[(_1[_11] + 2)] + 1)
   for _12 in range(1,_8):
    _10[(_12 + 1)] = (_10[(_12 + 1)] + _10[_12])
   for _13 in range(0,numpy.int32(_6)):
    _14=_1[_13]
    _9[_10[(_14 + 1)]] = _13
    _10[(_14 + 1)] = (_10[(_14 + 1)] + 1)
   _15=numpy.zeros(((_7 + 2),), dtype=numpy.dtype(numpy.int64))
   _16=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int32))
   _17=0
   while (_17 < _6):
    _15[(_0[_17] + 2)] = (_15[(_0[_17] + 2)] + 1)
    _17 += 1
   _18=1
   while (_18 < _7):
    _15[(_18 + 1)] = (_15[(_18 + 1)] + _15[_18])
    _18 += 1
   _19=0
   while (_19 < _8):
    _20=_10[_19]
    while (_20 < _10[(_19 + 1)]):
     _21=_0[_9[_20]]
     _16[_15[(_21 + 1)]] = _9[_20]
     _15[(_21 + 1)] = (_15[(_21 + 1)] + 1)
     _20 += 1
    _19 += 1
   _22=1
   _23=_0[_16[0]]
   _24=_1[_16[0]]
   _25=1
   while (_25 < _6):
    _26=_16[_25]
    if ((_23!=_0[_26]) or (_24!=_1[_26])):
     _23 = _0[_26]
     _24 = _1[_26]
     _22 += 1
    _25 += 1
   _27=numpy.zeros((_22,), dtype=numpy.dtype(numpy.int32))
   _28=numpy.zeros((_22,), dtype=numpy.dtype(numpy.int32))
   _29=numpy.zeros((_22,), dtype=numpy.dtype(numpy.float64))
   _30=_16[0]
   _27[0] = _0[_30]
   _28[0] = _1[_30]
   _29[0] = _2[_30]
   _31=1
   for _32 in range(1,_6):
    _33=_16[_32]
    if ((_27[(_31 - 1)]==_0[_33]) and (_28[(_31 - 1)]==_1[_33])):
     _29[(_31 - 1)] = (_29[(_31 - 1)] + _2[_33])
    else:
     _27[_31] = _0[_33]
     _28[_31] = _1[_33]
     _29[_31] = _2[_33]
     _31 += 1
   _3[0] = _27
   _4[0] = _28
   _5[0] = _29
  @staticmethod
  def _match_argMSort__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_argMSort__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  @staticmethod
  def _argMSort_alt__3I_3I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = mosek_fusion_CommonTools._argMSort__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argMSort__3I_3I(_0,_1):
   _2=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
   _3=False
   _4=1
   while (_4 < int((_0).shape[0])):
    _3 = (not _3)
    for _5 in range(0,int((_0).shape[0]),(_4 * 2)):
     if _3:
      mosek.fusion.CommonTools.__mergeInto__3I_3I_3IIII(_0,_2,_1,_5,(_5 + _4),(_5 + (2 * _4)))
     else:
      mosek.fusion.CommonTools.__mergeInto__3I_3I_3IIII(_2,_0,_1,_5,(_5 + _4),(_5 + (2 * _4)))
    _4 *= 2
   if _3:
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(_2,0,_0,0,int((_0).shape[0]))
  @staticmethod
  def __mergeInto_alt__3I_3I_3IIII(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.int32(_t__3)
   _4=numpy.int32(_t__4)
   _5=numpy.int32(_t__5)
   _1 = mosek_fusion_CommonTools.__mergeInto__3I_3I_3IIII(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def __mergeInto__3I_3I_3IIII(_0,_1,_2,_3,_4,_5):
   _6=(int((_0).shape[0]) if ((_5 > int((_0).shape[0])) ) else _5)
   _7=(_6 if ((_4 > _6) ) else _4)
   if (_7==_6):
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(_0,_3,_1,_3,(_7 - _3))
   else:
    _8=_3
    _9=_7
    _10 = _3
    while ((_8 < _7) and (_9 < _6)):
     if (_2[_0[_8]] < _2[_0[_9]]):
      _1[_10] = _0[_8]
      _8 += 1
     else:
      _1[_10] = _0[_9]
      _9 += 1
     _10 += 1
    while (_8 < _7):
     _1[_10] = _0[_8]
     _8 += 1
     _10 += 1
    while (_9 < _6):
     _1[_10] = _0[_9]
     _9 += 1
     _10 += 1
  @staticmethod
  def _match_argQsort__3J_3J_3JJJ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match__3J__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4))
  @staticmethod
  def _match_alt_argQsort__3J_3J_3JJJ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4))
  @staticmethod
  def _argQsort_alt__3J_3J_3JJJ(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _1 = mosek_fusion_CommonTools._argQsort__3J_3J_3JJJ(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argQsort__3J_3J_3JJJ(_0,_1,_2,_3,_4):
   if (_2 is None):
    mosek.fusion.Utils.Tools._argsort__3J_3JJJ(_0,_1,_3,_4)
   else:
    mosek.fusion.Utils.Tools._argsort__3J_3J_3JJJ(_0,_1,_2,_3,_4)
  @staticmethod
  def _match_argQsort__3J_3I_3IJJ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4))
  @staticmethod
  def _match_alt_argQsort__3J_3I_3IJJ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4))
  @staticmethod
  def _argQsort_alt__3J_3I_3IJJ(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _1 = mosek_fusion_CommonTools._argQsort__3J_3I_3IJJ(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _argQsort__3J_3I_3IJJ(_0,_1,_2,_3,_4):
   if (_2 is None):
    mosek.fusion.Utils.Tools._argsort__3J_3IJJ(_0,_1,_3,_4)
   else:
    mosek.fusion.Utils.Tools._argsort__3J_3I_3IJJ(_0,_1,_2,_3,_4)
 return CommonTools
mosek_fusion_CommonTools=__mk_mosek_fusion_CommonTools()
del __mk_mosek_fusion_CommonTools
#BEFORE CLASS
def __mk_mosek_fusion_SolutionStruct():
 class SolutionStruct(object):
  __slots__ = ['snx','sux','slx','bars','barx','y','suc','slc','xx','xc','dobj','pobj','probstatus','dstatus','pstatus','sol_numbarvar','sol_numcone','sol_numvar','sol_numcon']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_Lmosek_4fusion_4SolutionStruct_2(*args): # mosek.fusion.SolutionStruct
      self._ctor_init_Lmosek_4fusion_4SolutionStruct_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4SolutionStruct_2(*args):# mosek.fusion.SolutionStruct
      self._ctor_alt_init_Lmosek_4fusion_4SolutionStruct_2(*args)
    elif self.__match_ctor_IIII(*args): # int32,int32,int32,int32
      self._ctor_init_IIII(*args)
    elif self.__match_alt_ctor_IIII(*args):# int32,int32,int32,int32
      self._ctor_alt_init_IIII(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.SolutionStruct.ctor(mosek.fusion.SolutionStruct)\n\tmosek.fusion.SolutionStruct.ctor(int32,int32,int32,int32)')
  def resize(self,*args):
    if False: pass
    elif mosek_fusion_SolutionStruct._match_resize_IIII(*args): # int32,int32,int32,int32
      return self._resize_IIII(*args)
    elif mosek_fusion_SolutionStruct._match_alt_resize_IIII(*args): # int32,int32,int32,int32
      return self._resize_alt_IIII(*args)
    else:
      raise ValueError('Invalid argument list resize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SolutionStruct.resize(int32,int32,int32,int32)')
  def clone(self,*args):
    if False: pass
    elif mosek_fusion_SolutionStruct._match_clone_(*args): # 
      return self._clone_(*args)
    elif mosek_fusion_SolutionStruct._match_alt_clone_(*args): # 
      return self._clone_alt_(*args)
    else:
      raise ValueError('Invalid argument list clone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SolutionStruct.clone()')
  def isDualAcceptable(self,*args):
    if False: pass
    elif mosek_fusion_SolutionStruct._match_isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args): # mosek.fusion.AccSolutionStatus
      return self._isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args)
    elif mosek_fusion_SolutionStruct._match_alt_isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args): # mosek.fusion.AccSolutionStatus
      return self._isDualAcceptable_alt_Emosek_4fusion_4AccSolutionStatus_2(*args)
    else:
      raise ValueError('Invalid argument list isDualAcceptable('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SolutionStruct.isDualAcceptable(mosek.fusion.AccSolutionStatus)')
  def isPrimalAcceptable(self,*args):
    if False: pass
    elif mosek_fusion_SolutionStruct._match_isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args): # mosek.fusion.AccSolutionStatus
      return self._isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args)
    elif mosek_fusion_SolutionStruct._match_alt_isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args): # mosek.fusion.AccSolutionStatus
      return self._isPrimalAcceptable_alt_Emosek_4fusion_4AccSolutionStatus_2(*args)
    else:
      raise ValueError('Invalid argument list isPrimalAcceptable('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SolutionStruct.isPrimalAcceptable(mosek.fusion.AccSolutionStatus)')
  def __repr__(self): return 'mosek.fusion.SolutionStruct'
  @staticmethod
  def _ctor_IIII(numvar,numcon,numcone,numbarvar):
    o = SolutionStruct.__new__(SolutionStruct)
    o._ctor_init_IIII(numvar,numcon,numcone,numbarvar)
    return o
  @staticmethod
  def __match_ctor_IIII(*args):
    if len(args) != 4: return False
    numvar,numcon,numcone,numbarvar, = args
    return (__arg_match_I__(numvar) and __arg_match_I__(numcon) and __arg_match_I__(numcone) and __arg_match_I__(numbarvar))
  @staticmethod
  def __match_alt_ctor_IIII(*args):
    if len(args) != 4: return False
    numvar,numcon,numcone,numbarvar, = args
    return (__arg_alt_match_I__(numvar) and __arg_alt_match_I__(numcon) and __arg_alt_match_I__(numcone) and __arg_alt_match_I__(numbarvar))
  def _ctor_alt_init_IIII(self,numvar,numcon,numcone,numbarvar):
    self._ctor_init_IIII(numpy.int32(numvar),numpy.int32(numcon),numpy.int32(numcone),numpy.int32(numbarvar))
  def _ctor_init_IIII(self,numvar,numcon,numcone,numbarvar):
   object.__init__(self)
   self.pobj = 0.0
   self.dobj = 0.0
   self.pstatus = mosek.fusion.SolutionStatus.Unknown
   self.dstatus = mosek.fusion.SolutionStatus.Unknown
   self.probstatus = mosek.fusion.ProblemStatus.Unknown
   self.sol_numvar = numvar
   self.sol_numcon = numcon
   self.sol_numcone = numcone
   self.sol_numbarvar = numbarvar
   self.slx = None
   self.sux = None
   self.xx = None
   self.slc = None
   self.suc = None
   self.y = None
   self.xc = None
   self.snx = None
   self.barx = None
   self.bars = None
   if (numvar > 0):
    self.slx = numpy.zeros((numvar,), dtype=numpy.dtype(numpy.float64))
    self.sux = numpy.zeros((numvar,), dtype=numpy.dtype(numpy.float64))
    self.xx = numpy.zeros((numvar,), dtype=numpy.dtype(numpy.float64))
   if (numbarvar > 0):
    self.barx = numpy.zeros((numbarvar,), dtype=numpy.dtype(object))
    self.bars = numpy.zeros((numbarvar,), dtype=numpy.dtype(object))
   if (numcon > 0):
    self.slc = numpy.zeros((numcon,), dtype=numpy.dtype(numpy.float64))
    self.suc = numpy.zeros((numcon,), dtype=numpy.dtype(numpy.float64))
    self.y = numpy.zeros((numcon,), dtype=numpy.dtype(numpy.float64))
    self.xc = numpy.zeros((numcon,), dtype=numpy.dtype(numpy.float64))
   if (numcone > 0):
    self.snx = numpy.zeros((numvar,), dtype=numpy.dtype(numpy.float64))
  @staticmethod
  def _ctor_Lmosek_4fusion_4SolutionStruct_2(that):
    o = SolutionStruct.__new__(SolutionStruct)
    o._ctor_init_Lmosek_4fusion_4SolutionStruct_2(that)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4SolutionStruct_2(*args):
    if len(args) != 1: return False
    that, = args
    return (__arg_match_Lmosek_4fusion_4SolutionStruct_2__(that))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4SolutionStruct_2(*args):
    if len(args) != 1: return False
    that, = args
    return (__arg_alt_match_Lmosek_4fusion_4SolutionStruct_2__(that))
  def _ctor_alt_init_Lmosek_4fusion_4SolutionStruct_2(self,that):
    self._ctor_init_Lmosek_4fusion_4SolutionStruct_2(that)
  def _ctor_init_Lmosek_4fusion_4SolutionStruct_2(self,that):
   object.__init__(self)
   self.sol_numcon = (that.sol_numcon)
   self.sol_numvar = (that.sol_numvar)
   self.sol_numcone = (that.sol_numcone)
   self.sol_numbarvar = (that.sol_numbarvar)
   self.pstatus = (that.pstatus)
   self.dstatus = (that.dstatus)
   self.probstatus = (that.probstatus)
   self.pobj = (that.pobj)
   self.dobj = (that.dobj)
   self.xc = (mosek.fusion.Utils.Tools._arraycopy__3D((that.xc)) if (((that.xc) is not None) ) else None)
   self.xx = (mosek.fusion.Utils.Tools._arraycopy__3D((that.xx)) if (((that.xx) is not None) ) else None)
   self.slc = (mosek.fusion.Utils.Tools._arraycopy__3D((that.slx)) if (((that.slc) is not None) ) else None)
   self.suc = (mosek.fusion.Utils.Tools._arraycopy__3D((that.sux)) if (((that.suc) is not None) ) else None)
   self.y = (mosek.fusion.Utils.Tools._arraycopy__3D((that.y)) if (((that.y) is not None) ) else None)
   if ((that.barx) is not None):
    self.barx = _monty.initJaggedArray([mosek.fusion.Utils.Tools._arraycopy__3D((that.barx)[_0]) for _0 in range(0,int(((that.barx)).shape[0]))], 1)
   else:
    self.barx = None
   if ((that.bars) is not None):
    self.bars = _monty.initJaggedArray([mosek.fusion.Utils.Tools._arraycopy__3D((that.bars)[_1]) for _1 in range(0,int(((that.bars)).shape[0]))], 1)
   else:
    self.bars = None
   self.slx = (mosek.fusion.Utils.Tools._arraycopy__3D((that.slx)) if (((that.slx) is not None) ) else None)
   self.sux = (mosek.fusion.Utils.Tools._arraycopy__3D((that.sux)) if (((that.sux) is not None) ) else None)
   self.snx = (mosek.fusion.Utils.Tools._arraycopy__3D((that.snx)) if (((that.snx) is not None) ) else None)
  @staticmethod
  def _match_clone_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_clone_(*args):
    if len(args) != 0: return False
    return True
  def _clone_alt_(self,):
    return self._clone_()
  def _clone_(self,):
   return (mosek_fusion_SolutionStruct._ctor_Lmosek_4fusion_4SolutionStruct_2(self))
  @staticmethod
  def _match_resize_IIII(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2) and __arg_match_I__(_3))
  @staticmethod
  def _match_alt_resize_IIII(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_I__(_3))
  def _resize_alt_IIII(self,_t__0,_t__1,_t__2,_t__3):
    return self._resize_IIII(numpy.int32(__0),numpy.int32(__1),numpy.int32(__2),numpy.int32(__3))
  def _resize_IIII(self,_0,_1,_2,_3):
   if (_3 < 0):
    pass
   elif (_3 <= self.sol_numbarvar):
    self.sol_numbarvar = _3
   elif (_0 <= int((self.barx).shape[0])):
    for _4 in range(self.sol_numvar,_0):
     self.barx[_4] = None
     self.bars[_4] = None
   else:
    if ((self.sol_numbarvar * 2) > (_3 + 100)):
     _5 = (self.sol_numbarvar * 2)
    else:
     _5 = (_3 + 100)
    _6=numpy.zeros((_5,), dtype=numpy.dtype(object))
    for _7 in range(0,int((self.barx).shape[0])):
     _6[_7] = self.barx[_7]
    self.barx = _6
    _8=numpy.zeros((_5,), dtype=numpy.dtype(object))
    for _9 in range(0,int((self.bars).shape[0])):
     _8[_9] = self.bars[_9]
    self.bars = _8
    self.sol_numbarvar = _3
   if (_0 < 0):
    pass
   elif (_0 <= self.sol_numvar):
    self.sol_numvar = _0
   elif (_0 <= int((self.xx).shape[0])):
    for _10 in range(self.sol_numvar,_0):
     self.slx[_10] = 0.0
     self.sux[_10] = 0.0
     self.xx[_10] = 0.0
    self.sol_numvar = _0
   else:
    if ((self.sol_numvar * 2) > (_0 + 100)):
     _11 = (self.sol_numvar * 2)
    else:
     _11 = (_0 + 100)
    _12=numpy.zeros((_11,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.slx,0,_12,0,int((self.slx).shape[0]))
    self.slx = _12
    _13=numpy.zeros((_11,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.sux,0,_13,0,int((self.sux).shape[0]))
    self.sux = _13
    _14=numpy.zeros((_11,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.xx,0,_14,0,int((self.xx).shape[0]))
    self.xx = _14
    _15=self.sol_numvar
    while (_15 < _0):
     self.slx[_15] = 0.0
     self.sux[_15] = 0.0
     self.xx[_15] = 0.0
     _15 += 1
    self.sol_numvar = _0
   if (_1 < 0):
    pass
   elif (_1 <= self.sol_numcon):
    self.sol_numcon = _1
   elif (_1 <= int((self.xx).shape[0])):
    for _16 in range(self.sol_numcon,_1):
     self.slc[_16] = 0.0
     self.suc[_16] = 0.0
     self.xc[_16] = 0.0
     self.y[_16] = 0.0
    self.sol_numcon = _1
   else:
    if ((self.sol_numcon * 2) > (_1 + 100)):
     _17 = (self.sol_numcon * 2)
    else:
     _17 = (_1 + 100)
    _18=numpy.zeros((_17,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.slc,0,_18,0,int((self.slc).shape[0]))
    self.slc = _18
    _19=numpy.zeros((_17,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.suc,0,_19,0,int((self.suc).shape[0]))
    self.suc = _19
    _20=numpy.zeros((_17,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.xc,0,_20,0,int((self.xc).shape[0]))
    self.xc = _20
    _21=numpy.zeros((_17,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.y,0,_21,0,int((self.y).shape[0]))
    self.y = _21
    for _22 in range(self.sol_numcon,_1):
     self.slc[_22] = 0.0
     self.suc[_22] = 0.0
     self.xc[_22] = 0.0
     self.y[_22] = 0.0
    self.sol_numcon = _1
   if (_2 < 0):
    pass
   elif (_2 <= self.sol_numcone):
    self.sol_numcone = _2
   elif (_2 <= int((self.xx).shape[0])):
    for _23 in range(self.sol_numcone,_2):
     self.snx[_23] = 0.0
    self.sol_numcone = _2
   else:
    if ((self.sol_numcone * 2) > (_2 + 100)):
     _24 = (self.sol_numcone * 2)
    else:
     _24 = (_2 + 100)
    _25=numpy.zeros((_24,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.snx,0,_25,0,int((self.snx).shape[0]))
    self.snx = _25
    _26=self.sol_numcone
    while (_26 < _2):
     self.snx[_26] = 0.0
     _26 += 1
    self.sol_numcone = _2
  @staticmethod
  def _match_isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Emosek_4fusion_4AccSolutionStatus_2__(_0))
  @staticmethod
  def _match_alt_isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Emosek_4fusion_4AccSolutionStatus_2__(_0))
  def _isDualAcceptable_alt_Emosek_4fusion_4AccSolutionStatus_2(self,_t__0):
    return self._isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(__0)
  def _isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(self,_0):
   return (self.__isAcceptable_Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4AccSolutionStatus_2(self.dstatus,_0))
  @staticmethod
  def _match_isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Emosek_4fusion_4AccSolutionStatus_2__(_0))
  @staticmethod
  def _match_alt_isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Emosek_4fusion_4AccSolutionStatus_2__(_0))
  def _isPrimalAcceptable_alt_Emosek_4fusion_4AccSolutionStatus_2(self,_t__0):
    return self._isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(__0)
  def _isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(self,_0):
   return (self.__isAcceptable_Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4AccSolutionStatus_2(self.pstatus,_0))
  def __isAcceptable_alt_Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4AccSolutionStatus_2(self,_t__0,_t__1):
    return self.__isAcceptable_Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4AccSolutionStatus_2(__0,__1)
  def __isAcceptable_Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4AccSolutionStatus_2(self,_0,_1):
   if (_1==mosek.fusion.AccSolutionStatus.Anything):
    return (True)
   elif (_1==mosek.fusion.AccSolutionStatus.Optimal):
    return ((_0==mosek.fusion.SolutionStatus.Optimal))
   elif (_1==mosek.fusion.AccSolutionStatus.NearOptimal):
    return (((_0==mosek.fusion.SolutionStatus.Optimal) or (_0==mosek.fusion.SolutionStatus.NearOptimal)))
   elif (_1==mosek.fusion.AccSolutionStatus.Feasible):
    return (((_0==mosek.fusion.SolutionStatus.Optimal) or ((_0==mosek.fusion.SolutionStatus.NearOptimal) or (_0==mosek.fusion.SolutionStatus.Feasible))))
   elif (_1==mosek.fusion.AccSolutionStatus.Certificate):
    return ((_0==mosek.fusion.SolutionStatus.Certificate))
   return (False)
 return SolutionStruct
mosek_fusion_SolutionStruct=__mk_mosek_fusion_SolutionStruct()
del __mk_mosek_fusion_SolutionStruct
#BEFORE CLASS
def __mk_mosek_fusion_ConNZStruct():
 class ConNZStruct(object):
  __slots__ = ['barmidx','barsubj','barsubi','bfix','cof','subj','ptrb']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor__3J_3I_3D_3D_3I_3I_3I(*args): # []int64,[]int32,[]double,[]double,[]int32,[]int32,[]int32
      self._ctor_init__3J_3I_3D_3D_3I_3I_3I(*args)
    elif self.__match_alt_ctor__3J_3I_3D_3D_3I_3I_3I(*args):# []int64,[]int32,[]double,[]double,[]int32,[]int32,[]int32
      self._ctor_alt_init__3J_3I_3D_3D_3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.ConNZStruct.ctor(array(int64,ndim=1),array(int32,ndim=1),array(double,ndim=1),array(double,ndim=1),array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def __repr__(self): return 'mosek.fusion.ConNZStruct'
  @staticmethod
  def _ctor__3J_3I_3D_3D_3I_3I_3I(ptrb_,subj_,cof_,bfix_,barsubi_,barsubj_,barmidx_):
    o = ConNZStruct.__new__(ConNZStruct)
    o._ctor_init__3J_3I_3D_3D_3I_3I_3I(ptrb_,subj_,cof_,bfix_,barsubi_,barsubj_,barmidx_)
    return o
  @staticmethod
  def __match_ctor__3J_3I_3D_3D_3I_3I_3I(*args):
    if len(args) != 7: return False
    ptrb_,subj_,cof_,bfix_,barsubi_,barsubj_,barmidx_, = args
    return (__arg_match__3J__(ptrb_) and __arg_match__3I__(subj_) and __arg_match__3D__(cof_) and __arg_match__3D__(bfix_) and __arg_match__3I__(barsubi_) and __arg_match__3I__(barsubj_) and __arg_match__3I__(barmidx_))
  @staticmethod
  def __match_alt_ctor__3J_3I_3D_3D_3I_3I_3I(*args):
    if len(args) != 7: return False
    ptrb_,subj_,cof_,bfix_,barsubi_,barsubj_,barmidx_, = args
    return (__arg_alt_match__3J__(ptrb_) and __arg_alt_match__3I__(subj_) and __arg_alt_match__3D__(cof_) and __arg_alt_match__3D__(bfix_) and __arg_alt_match__3I__(barsubi_) and __arg_alt_match__3I__(barsubj_) and __arg_alt_match__3I__(barmidx_))
  def _ctor_alt_init__3J_3I_3D_3D_3I_3I_3I(self,ptrb_,subj_,cof_,bfix_,barsubi_,barsubj_,barmidx_):
    self._ctor_init__3J_3I_3D_3D_3I_3I_3I(numpy.array(ptrb_,dtype=numpy.dtype(numpy.int64)),numpy.array(subj_,dtype=numpy.dtype(numpy.int32)),numpy.array(cof_,dtype=numpy.dtype(numpy.float64)),numpy.array(bfix_,dtype=numpy.dtype(numpy.float64)),numpy.array(barsubi_,dtype=numpy.dtype(numpy.int32)),numpy.array(barsubj_,dtype=numpy.dtype(numpy.int32)),numpy.array(barmidx_,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init__3J_3I_3D_3D_3I_3I_3I(self,ptrb_,subj_,cof_,bfix_,barsubi_,barsubj_,barmidx_):
   object.__init__(self)
   self.ptrb = ptrb_
   self.subj = subj_
   self.cof = cof_
   self.bfix = bfix_
   self.barsubi = barsubi_
   self.barsubj = barsubj_
   self.barmidx = barmidx_
 return ConNZStruct
mosek_fusion_ConNZStruct=__mk_mosek_fusion_ConNZStruct()
del __mk_mosek_fusion_ConNZStruct
#BEFORE CLASS
def __mk_mosek_fusion_BaseVariable():
 class BaseVariable(mosek_fusion_Variable,object):
  __slots__ = ['_model','_shape_p']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(*args): # mosek.fusion.Model,mosek.fusion.Set
      self._ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(*args):# mosek.fusion.Model,mosek.fusion.Set
      self._ctor_alt_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.BaseVariable.ctor(mosek.fusion.Model,mosek.fusion.Set)')
  def getShape(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_getShape_(*args): # 
      return self._getShape_(*args)
    elif mosek_fusion_BaseVariable._match_alt_getShape_(*args): # 
      return self._getShape_alt_(*args)
    else:
      raise ValueError('Invalid argument list getShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.getShape()')
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_make_1integer__3J(*args): # []int64
      return self._make_1integer__3J(*args)
    elif mosek_fusion_BaseVariable._match_alt_make_1integer__3J(*args): # []int64
      return self._make_1integer_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.make_integer(array(int64,ndim=1))')
  def dual(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_dual_(*args): # 
      return self._dual_(*args)
    elif mosek_fusion_BaseVariable._match_alt_dual_(*args): # 
      return self._dual_alt_(*args)
    else:
      raise ValueError('Invalid argument list dual('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.dual()')
  def elementName(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_BaseVariable._match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.elementName(int64,mosek.fusion.Utils.StringBuffer)')
  def asExpr(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_asExpr_(*args): # 
      return self._asExpr_(*args)
    elif mosek_fusion_BaseVariable._match_alt_asExpr_(*args): # 
      return self._asExpr_alt_(*args)
    else:
      raise ValueError('Invalid argument list asExpr('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.asExpr()')
  def size(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_size_(*args): # 
      return self._size_(*args)
    elif mosek_fusion_BaseVariable._match_alt_size_(*args): # 
      return self._size_alt_(*args)
    else:
      raise ValueError('Invalid argument list size('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.size()')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_toString_(*args): # 
      return self._toString_(*args)
    elif mosek_fusion_BaseVariable._match_alt_toString_(*args): # 
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.toString()')
  def getModel(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_getModel_(*args): # 
      return self._getModel_(*args)
    elif mosek_fusion_BaseVariable._match_alt_getModel_(*args): # 
      return self._getModel_alt_(*args)
    else:
      raise ValueError('Invalid argument list getModel('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.getModel()')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_JJ_3I_3I_3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt_JJ_3I_3I_3I(*args)
    elif mosek_fusion_BaseVariable._match_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst__3JIIJJ_3I_3I_3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt__3JIIJJ_3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.inst(int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.BaseVariable.inst(array(int64,ndim=1),int32,int32,int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def makeInteger(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_makeInteger_(*args): # 
      return self._makeInteger_(*args)
    elif mosek_fusion_BaseVariable._match_alt_makeInteger_(*args): # 
      return self._makeInteger_alt_(*args)
    else:
      raise ValueError('Invalid argument list makeInteger('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.makeInteger()')
  def values(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_I_3DZ(*args)
    elif mosek_fusion_BaseVariable._match_alt_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_alt_I_3DZ(*args)
    elif mosek_fusion_BaseVariable._match_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values__3JI_3DZ(*args)
    elif mosek_fusion_BaseVariable._match_alt_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values_alt__3JI_3DZ(*args)
    elif mosek_fusion_BaseVariable._match_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_BaseVariable._match_alt_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.values(int32,array(double,ndim=1),bool)\n\tmosek.fusion.BaseVariable.values(array(int64,ndim=1),int32,array(double,ndim=1),bool)\n\tmosek.fusion.BaseVariable.values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def level(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_level_(*args): # 
      return self._level_(*args)
    elif mosek_fusion_BaseVariable._match_alt_level_(*args): # 
      return self._level_alt_(*args)
    else:
      raise ValueError('Invalid argument list level('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.level()')
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values__3J_3DZ(*args)
    elif mosek_fusion_BaseVariable._match_alt_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values_alt__3J_3DZ(*args)
    elif mosek_fusion_BaseVariable._match_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_BaseVariable._match_alt_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.set_values(array(int64,ndim=1),array(double,ndim=1),bool)\n\tmosek.fusion.BaseVariable.set_values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def index(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_index_I(*args): # int32
      return self._index_I(*args)
    elif mosek_fusion_BaseVariable._match_alt_index_I(*args): # int32
      return self._index_alt_I(*args)
    elif mosek_fusion_BaseVariable._match_index__3I(*args): # []int32
      return self._index__3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_index__3I(*args): # []int32
      return self._index_alt__3I(*args)
    elif mosek_fusion_BaseVariable._match_index_II(*args): # int32,int32
      return self._index_II(*args)
    elif mosek_fusion_BaseVariable._match_alt_index_II(*args): # int32,int32
      return self._index_alt_II(*args)
    elif mosek_fusion_BaseVariable._match_index_III(*args): # int32,int32,int32
      return self._index_III(*args)
    elif mosek_fusion_BaseVariable._match_alt_index_III(*args): # int32,int32,int32
      return self._index_alt_III(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.index(int32)\n\tmosek.fusion.BaseVariable.index(array(int32,ndim=1))\n\tmosek.fusion.BaseVariable.index(int32,int32)\n\tmosek.fusion.BaseVariable.index(int32,int32,int32)')
  def antidiag(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_antidiag_(*args): # 
      return self._antidiag_(*args)
    elif mosek_fusion_BaseVariable._match_alt_antidiag_(*args): # 
      return self._antidiag_alt_(*args)
    elif mosek_fusion_BaseVariable._match_antidiag_I(*args): # int32
      return self._antidiag_I(*args)
    elif mosek_fusion_BaseVariable._match_alt_antidiag_I(*args): # int32
      return self._antidiag_alt_I(*args)
    else:
      raise ValueError('Invalid argument list antidiag('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.antidiag()\n\tmosek.fusion.BaseVariable.antidiag(int32)')
  def pick(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_pick__3I(*args): # []int32
      return self._pick__3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_pick__3I(*args): # []int32
      return self._pick_alt__3I(*args)
    elif mosek_fusion_BaseVariable._match_pick__3_5I(*args): # [,]int32
      return self._pick__3_5I(*args)
    elif mosek_fusion_BaseVariable._match_alt_pick__3_5I(*args): # [,]int32
      return self._pick_alt__3_5I(*args)
    elif mosek_fusion_BaseVariable._match_pick__3I_3I(*args): # []int32,[]int32
      return self._pick__3I_3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_pick__3I_3I(*args): # []int32,[]int32
      return self._pick_alt__3I_3I(*args)
    elif mosek_fusion_BaseVariable._match_pick__3I_3I_3I(*args): # []int32,[]int32,[]int32
      return self._pick__3I_3I_3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_pick__3I_3I_3I(*args): # []int32,[]int32,[]int32
      return self._pick_alt__3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list pick('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.pick(array(int32,ndim=1))\n\tmosek.fusion.BaseVariable.pick(array(int32,ndim=2))\n\tmosek.fusion.BaseVariable.pick(array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.BaseVariable.pick(array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def shape(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_shape_(*args): # 
      return self._shape_(*args)
    elif mosek_fusion_BaseVariable._match_alt_shape_(*args): # 
      return self._shape_alt_(*args)
    else:
      raise ValueError('Invalid argument list shape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.shape()')
  def setLevel(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_setLevel__3D(*args): # []double
      return self._setLevel__3D(*args)
    elif mosek_fusion_BaseVariable._match_alt_setLevel__3D(*args): # []double
      return self._setLevel_alt__3D(*args)
    else:
      raise ValueError('Invalid argument list setLevel('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.setLevel(array(double,ndim=1))')
  def transpose(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_transpose_(*args): # 
      return self._transpose_(*args)
    elif mosek_fusion_BaseVariable._match_alt_transpose_(*args): # 
      return self._transpose_alt_(*args)
    else:
      raise ValueError('Invalid argument list transpose('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.transpose()')
  def makeContinuous(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_makeContinuous_(*args): # 
      return self._makeContinuous_(*args)
    elif mosek_fusion_BaseVariable._match_alt_makeContinuous_(*args): # 
      return self._makeContinuous_alt_(*args)
    else:
      raise ValueError('Invalid argument list makeContinuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.makeContinuous()')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_make_1continuous__3J(*args): # []int64
      return self._make_1continuous__3J(*args)
    elif mosek_fusion_BaseVariable._match_alt_make_1continuous__3J(*args): # []int64
      return self._make_1continuous_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.make_continuous(array(int64,ndim=1))')
  def elementDesc(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_BaseVariable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def diag(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_diag_(*args): # 
      return self._diag_(*args)
    elif mosek_fusion_BaseVariable._match_alt_diag_(*args): # 
      return self._diag_alt_(*args)
    elif mosek_fusion_BaseVariable._match_diag_I(*args): # int32
      return self._diag_I(*args)
    elif mosek_fusion_BaseVariable._match_alt_diag_I(*args): # int32
      return self._diag_alt_I(*args)
    else:
      raise ValueError('Invalid argument list diag('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.diag()\n\tmosek.fusion.BaseVariable.diag(int32)')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_slice_II(*args): # int32,int32
      return self._slice_II(*args)
    elif mosek_fusion_BaseVariable._match_alt_slice_II(*args): # int32,int32
      return self._slice_alt_II(*args)
    elif mosek_fusion_BaseVariable._match_slice__3I_3I(*args): # []int32,[]int32
      return self._slice__3I_3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_slice__3I_3I(*args): # []int32,[]int32
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.slice(int32,int32)\n\tmosek.fusion.BaseVariable.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def __str__(self): return self._toString_()
  def __repr__(self): return 'mosek.fusion.BaseVariable: '+self._toString_()
  @staticmethod
  def _ctor_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = BaseVariable.__new__(BaseVariable)
    o._ctor_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4BaseVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4BaseVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   object.__init__(self)
   self._model = m
   self._shape_p = (v._shape_p)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(m,shape):
    o = BaseVariable.__new__(BaseVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(m,shape)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(*args):
    if len(args) != 2: return False
    m,shape, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(m) and __arg_match_Lmosek_4fusion_4Set_2__(shape))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(*args):
    if len(args) != 2: return False
    m,shape, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(m) and __arg_alt_match_Lmosek_4fusion_4Set_2__(shape))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(self,m,shape):
    self._ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(m,shape)
  def _ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(self,m,shape):
   object.__init__(self)
   self._model = m
   self._shape_p = shape
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   self.elementName(_0,_1)
   return (_1)
  @staticmethod
  def _match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   pass
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=mosek.fusion.Utils.StringBuffer()
   _0._a_S("Variable( (")._a_I(self._shape_p.dim(0))
   for _1 in range(1,(self._shape_p.nd)):
    _0._a_S(",")._a_I(self._shape_p.dim(_1))
   _0._a_S(" )")
   if ((self._shape_p._size) < 51):
    for _2 in range(0,(self._shape_p._size)):
     _0._a_S(",\n  ")
     self.elementDesc(_2,_0)
   else:
    for _3 in range(0,25):
     _0._a_S(",\n  ")
     self.elementDesc(_3,_0)
    _0._a_S("... (")._a_J(((self._shape_p._size) - 50))._a_S(" elements left out)")
    for _4 in range(((self._shape_p._size) - 25),(self._shape_p._size)):
     _0._a_S(",\n  ")
     self.elementDesc(_4,_0)
   _0._a_S(" )")
   return (_0._toString_())
  @staticmethod
  def _match_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match__3I__(_5) and __arg_match__3I__(_6) and __arg_match__3I__(_7))
  @staticmethod
  def _match_alt_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match__3I__(_5) and __arg_alt_match__3I__(_6) and __arg_alt_match__3I__(_7))
  def _inst_alt__3JIIJJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int32))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.int32))
   _7=numpy.array(_t__7,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst__3JIIJJ_3I_3I_3I(_0,_1,_2,_3,_4,_5,_6,_7)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__7[:] = _7
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst__3JIIJJ_3I_3I_3I(self,_0,_1,_2,_3,_4,_5,_6,_7):
   for _8 in range(_1,_2):
    self.inst((_0[_8] - _3),((_4 + _8) - _1),_5,_6,_7)
  @staticmethod
  def _match_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match_J__(_0) and __arg_match_J__(_1) and __arg_match__3I__(_2) and __arg_match__3I__(_3) and __arg_match__3I__(_4))
  @staticmethod
  def _match_alt_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_J__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match__3I__(_3) and __arg_alt_match__3I__(_4))
  def _inst_alt_JJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst_JJ_3I_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst_JJ_3I_3I_3I(self,_0,_1,_2,_3,_4):
   pass
  @staticmethod
  def _match_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _set_1values_alt__3J_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1 = self._set_1values__3J_3DZ(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values__3J_3DZ(self,_0,_1,_2):
   pass
  @staticmethod
  def _match_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _set_1values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._set_1values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   pass
  @staticmethod
  def _match_values_I_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_values_I_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _values_alt_I_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1 = self._values_I_3DZ(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values_I_3DZ(self,_0,_1,_2):
   _3=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int64))
   _4=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int32))
   for _5 in range(0,(self._shape_p.nd)):
    _3[_5] = self._shape_p.stride(_5)
   for _6 in range(0,(self._shape_p.nd)):
    _4[_6] = self._shape_p.dim(_6)
   self.values(0,_4,_3,_0,_1,_2)
  @staticmethod
  def _match_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match__3D__(_2) and __arg_match_Z__(_3))
  @staticmethod
  def _match_alt_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_Z__(_3))
  def _values_alt__3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_t__3
   _1 = self._values__3JI_3DZ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values__3JI_3DZ(self,_0,_1,_2,_3):
   pass
  @staticmethod
  def _match_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   pass
  @staticmethod
  def _match_setLevel__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3D__(_0))
  @staticmethod
  def _match_alt_setLevel__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3D__(_0))
  def _setLevel_alt__3D(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1 = self._setLevel__3D(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _setLevel__3D(self,_0):
   if ((self._shape_p._size) > int((_0).shape[0])):
    raise mosek_fusion_LengthError._ctor_S("Invalid length of solution values vector")
   self.set_values(0,numpy.array([self._shape_p.dim(_1) for _1 in range(0,(self._shape_p.nd))], dtype=numpy.dtype(numpy.int32)),numpy.array([self._shape_p.stride(_2) for _2 in range(0,(self._shape_p.nd))], dtype=numpy.dtype(numpy.int64)),0,_0,True)
  @staticmethod
  def _match_getModel_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getModel_(*args):
    if len(args) != 0: return False
    return True
  def _getModel_alt_(self,):
    return self._getModel_()
  def _getModel_(self,):
   return (self._model)
  @staticmethod
  def _match_shape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_shape_(*args):
    if len(args) != 0: return False
    return True
  def _shape_alt_(self,):
    return self._shape_()
  def _shape_(self,):
   return (self._shape_p)
  @staticmethod
  def _match_getShape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getShape_(*args):
    if len(args) != 0: return False
    return True
  def _getShape_alt_(self,):
    return self._getShape_()
  def _getShape_(self,):
   return (self._shape_p)
  @staticmethod
  def _match_size_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_size_(*args):
    if len(args) != 0: return False
    return True
  def _size_alt_(self,):
    return self._size_()
  def _size_(self,):
   return numpy.int64((self._shape_p._size))
  @staticmethod
  def _match_dual_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dual_(*args):
    if len(args) != 0: return False
    return True
  def _dual_alt_(self,):
    return self._dual_()
  def _dual_(self,):
   _0=numpy.zeros(((self._shape_p._size),), dtype=numpy.dtype(numpy.float64))
   if ((self._shape_p._size) > 0):
    self.values(0,_0,False)
   return (_0)
  @staticmethod
  def _match_level_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_level_(*args):
    if len(args) != 0: return False
    return True
  def _level_alt_(self,):
    return self._level_()
  def _level_(self,):
   _0=numpy.zeros(((self._shape_p._size),), dtype=numpy.dtype(numpy.float64))
   if ((self._shape_p._size) > 0):
    self.values(0,_0,True)
   return (_0)
  @staticmethod
  def _match_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1continuous_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1continuous__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1continuous__3J(self,_0):
   pass
  @staticmethod
  def _match_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1integer_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1integer__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1integer__3J(self,_0):
   pass
  @staticmethod
  def _match_makeContinuous_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_makeContinuous_(*args):
    if len(args) != 0: return False
    return True
  def _makeContinuous_alt_(self,):
    return self._makeContinuous_()
  def _makeContinuous_(self,):
   self.make_continuous(numpy.array([_0 for _0 in range(0,self.size())], dtype=numpy.dtype(numpy.int64)))
  @staticmethod
  def _match_makeInteger_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_makeInteger_(*args):
    if len(args) != 0: return False
    return True
  def _makeInteger_alt_(self,):
    return self._makeInteger_()
  def _makeInteger_(self,):
   self.make_integer(numpy.array([_0 for _0 in range(0,self.size())], dtype=numpy.dtype(numpy.int64)))
  @staticmethod
  def _match_transpose_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_transpose_(*args):
    if len(args) != 0: return False
    return True
  def _transpose_alt_(self,):
    return self._transpose_()
  def _transpose_(self,):
   if ((self._shape_p.nd) > 2):
    raise mosek_fusion_DimensionError._ctor_S("Invalid shape for operation")
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(self,mosek.fusion.Set._make_II(self._shape_p.dim(1),self._shape_p.dim(0)),0,numpy.array([self._shape_p.stride(1),self._shape_p.stride(0)], dtype=numpy.dtype(numpy.int64))))
  @staticmethod
  def _match_index_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_index_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2))
  def _index_alt_III(self,_t__0,_t__1,_t__2):
    return self._index_III(numpy.int32(__0),numpy.int32(__1),numpy.int32(__2))
  def _index_III(self,_0,_1,_2):
   return (self.index(numpy.array([_0,_1,_2], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_index_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_index_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _index_alt_II(self,_t__0,_t__1):
    return self._index_II(numpy.int32(__0),numpy.int32(__1))
  def _index_II(self,_0,_1):
   return (self.index(numpy.array([_0,_1], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _index_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1 = self._index__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _index__3I(self,_0):
   if ((self._shape_p.nd)!=int((_0).shape[0])):
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   return (mosek_fusion_PickVariable._ctor_Lmosek_4fusion_4Variable_2_3J(self,numpy.array([self._shape_p._linearidx__3I(_0)], dtype=numpy.dtype(numpy.int64))))
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _index_alt_I(self,_t__0):
    return self._index_I(numpy.int32(__0))
  def _index_I(self,_0):
   return (self.pick(numpy.array([_0], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_pick__3I_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2))
  @staticmethod
  def _match_alt_pick__3I_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2))
  def _pick_alt__3I_3I_3I(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _1 = self._pick__3I_3I_3I(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _pick__3I_3I_3I(self,_0,_1,_2):
   if ((self._shape_p.nd)!=3):
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   if ((int((_0).shape[0])!=int((_1).shape[0])) or (int((_0).shape[0])!=int((_2).shape[0]))):
    raise mosek_fusion_LengthError._ctor_S("Mismatching argument lengths")
   return (mosek_fusion_PickVariable._ctor_Lmosek_4fusion_4Variable_2_3J(self,numpy.array([self._shape_p._linearidx__3I(numpy.array([_0[_3],_1[_3],_2[_3]], dtype=numpy.dtype(numpy.int32))) for _3 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64))))
  @staticmethod
  def _match_pick__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_pick__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _pick_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self._pick__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _pick__3I_3I(self,_0,_1):
   if ((self._shape_p.nd)!=2):
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   if (int((_0).shape[0])!=int((_1).shape[0])):
    raise mosek_fusion_LengthError._ctor_S("Mismatching argument lengths")
   return (mosek_fusion_PickVariable._ctor_Lmosek_4fusion_4Variable_2_3J(self,numpy.array([self._shape_p._linearidx__3I(numpy.array([_0[_2],_1[_2]], dtype=numpy.dtype(numpy.int32))) for _2 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64))))
  @staticmethod
  def _match_pick__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3_5I__(_0))
  @staticmethod
  def _match_alt_pick__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3_5I__(_0))
  def _pick_alt__3_5I(self,_t__0):
   _0=numpy.array(_t__0,ndmin=_monty.checkShape(_t__0,2),dtype=numpy.dtype(numpy.int32))
   _1 = self._pick__3_5I(_0)
   return _1
  def _pick__3_5I(self,_0):
   if ((self._shape_p.nd)!=int((_0).shape[1])):
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   return (mosek_fusion_PickVariable._ctor_Lmosek_4fusion_4Variable_2_3J(self,numpy.array([self._shape_p._linearidx__3I(numpy.array([_0[_1,_2] for _2 in range(0,int((_0).shape[1]))], dtype=numpy.dtype(numpy.int32))) for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64))))
  @staticmethod
  def _match_pick__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_pick__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _pick_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1 = self._pick__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _pick__3I(self,_0):
   if ((self._shape_p.nd)!=1):
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   return (mosek_fusion_PickVariable._ctor_Lmosek_4fusion_4Variable_2_3J(self,numpy.array([_0[_1] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64))))
  @staticmethod
  def _match_antidiag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_antidiag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _antidiag_alt_I(self,_t__0):
    return self._antidiag_I(numpy.int32(__0))
  def _antidiag_I(self,_0):
   if ((self._shape_p.nd)!=2):
    raise mosek_fusion_DimensionError._ctor_S("antidiag() only works on two-dimensional objects")
   if (_0 >= 0):
    return (self.__general_1diag__3I_3I(numpy.array([0,((self._shape_p.dim(1) - 1) - _0)], dtype=numpy.dtype(numpy.int32)),numpy.array([1,(- 1)], dtype=numpy.dtype(numpy.int32))))
   else:
    return (self.__general_1diag__3I_3I(numpy.array([(- _0),(self._shape_p.dim(1) - 1)], dtype=numpy.dtype(numpy.int32)),numpy.array([1,(- 1)], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_antidiag_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_antidiag_(*args):
    if len(args) != 0: return False
    return True
  def _antidiag_alt_(self,):
    return self._antidiag_()
  def _antidiag_(self,):
   if ((self._shape_p.nd)!=2):
    raise mosek_fusion_DimensionError._ctor_S("antidiag() only works on two-dimensional objects")
   return (self.__general_1diag__3I_3I(numpy.array([0,(self._shape_p.dim(1) - 1)], dtype=numpy.dtype(numpy.int32)),numpy.array([1,(- 1)], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_diag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_diag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _diag_alt_I(self,_t__0):
    return self._diag_I(numpy.int32(__0))
  def _diag_I(self,_0):
   if ((self._shape_p.nd)!=2):
    raise mosek_fusion_DimensionError._ctor_S("diag() only works on two-dimensional objects")
   if (_0 >= 0):
    return (self.__general_1diag__3I_3I(numpy.array([0,_0], dtype=numpy.dtype(numpy.int32)),numpy.array([1,1], dtype=numpy.dtype(numpy.int32))))
   else:
    return (self.__general_1diag__3I_3I(numpy.array([(- _0),0], dtype=numpy.dtype(numpy.int32)),numpy.array([1,1], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_diag_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_diag_(*args):
    if len(args) != 0: return False
    return True
  def _diag_alt_(self,):
    return self._diag_()
  def _diag_(self,):
   if ((self._shape_p.nd)!=2):
    raise mosek_fusion_DimensionError._ctor_S("diag() only works on two-dimensional objects")
   return (self.__general_1diag__3I_3I(numpy.array([0,0], dtype=numpy.dtype(numpy.int32)),numpy.array([1,1], dtype=numpy.dtype(numpy.int32))))
  def __general_1diag_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self.__general_1diag__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def __general_1diag__3I_3I(self,_0,_1):
   if (((self._shape_p.nd)!=int((_0).shape[0])) or ((self._shape_p.nd)!=int((_1).shape[0]))):
    raise mosek_fusion_DimensionError._ctor_S("Invalid start or step definition")
   for _2 in range(0,(self._shape_p.nd)):
    if ((_0[_2] < 0) or (_0[_2] >= self._shape_p.dim(_2))):
     raise mosek_fusion_LengthError._ctor_S("Start element is out of bounds")
   _3=0
   for _4 in range(0,(self._shape_p.nd)):
    _3 += (self._shape_p.stride(_4) * _0[_4])
   _5=numpy.array([(((((self._shape_p.dim(_6) - _0[_6]) - 1) // _1[_6]) + 1) if ((_1[_6] > 0) ) else (((_0[_6] // (- _1[_6])) + 1) if ((_1[_6] < 0) ) else 0)) for _6 in range(0,(self._shape_p.nd))], dtype=numpy.dtype(numpy.int32))
   _7=_5[0]
   for _8 in range(1,(self._shape_p.nd)):
    _7 = (_7 if ((_7 < _5[_8]) ) else _5[_8])
   _9=0
   for _10 in range(0,(self._shape_p.nd)):
    _9 += (_1[_10] * self._shape_p.stride(_10))
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(self,mosek.fusion.Set._make_I(_7),_3,numpy.array([_9], dtype=numpy.dtype(numpy.int64))))
  @staticmethod
  def _match_asExpr_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_asExpr_(*args):
    if len(args) != 0: return False
    return True
  def _asExpr_alt_(self,):
    return self._asExpr_()
  def _asExpr_(self,):
   return (mosek_fusion_Expr._ctor__3J_3Lmosek_4fusion_4Variable_2_3J_3D_3DLmosek_4fusion_4Set_2_3JI(numpy.array([_0 for _0 in range(0,((self._shape_p._size) + 1))], dtype=numpy.dtype(numpy.int64)),numpy.array([self], dtype=numpy.dtype(object)),numpy.array([_1 for _1 in range(0,(self._shape_p._size))], dtype=numpy.dtype(numpy.int64)),numpy.array([1.0 for _2 in range(0,(self._shape_p._size))], dtype=numpy.dtype(numpy.float64)),None,self._shape_p,None,1))
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _slice__3I_3I(self,_0,_1):
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(self,mosek.fusion.Set._make__3I(numpy.array([(_1[_2] - _0[_2]) for _2 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32))),self._shape_p._linearidx__3I(_0),numpy.array([self._shape_p.stride(_3) for _3 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64))))
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(self,mosek.fusion.Set._make_I((_1 - _0)),_0,numpy.array([1], dtype=numpy.dtype(numpy.int64))))
 return BaseVariable
mosek_fusion_BaseVariable=__mk_mosek_fusion_BaseVariable()
del __mk_mosek_fusion_BaseVariable
#BEFORE CLASS
def __mk_mosek_fusion_CompoundVariable():
 class CompoundVariable(mosek_fusion_BaseVariable):
  __slots__ = ['_CompoundVariable__stackdim','_CompoundVariable__varsb','_CompoundVariable__vars']
  def asExpr(self,*args):
    if False: pass
    elif mosek_fusion_CompoundVariable._match_asExpr_(*args): # 
      return self._asExpr_(*args)
    elif mosek_fusion_CompoundVariable._match_alt_asExpr_(*args): # 
      return self._asExpr_alt_(*args)
    else:
      raise ValueError('Invalid argument list asExpr('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CompoundVariable.asExpr()')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_CompoundVariable._match_slice_II(*args): # int32,int32
      return self._slice_II(*args)
    elif mosek_fusion_CompoundVariable._match_alt_slice_II(*args): # int32,int32
      return self._slice_alt_II(*args)
    elif mosek_fusion_CompoundVariable._match_slice__3I_3I(*args): # []int32,[]int32
      return self._slice__3I_3I(*args)
    elif mosek_fusion_CompoundVariable._match_alt_slice__3I_3I(*args): # []int32,[]int32
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CompoundVariable.slice(int32,int32)\n\tmosek.fusion.CompoundVariable.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_CompoundVariable._match_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values__3J_3DZ(*args)
    elif mosek_fusion_CompoundVariable._match_alt_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values_alt__3J_3DZ(*args)
    elif mosek_fusion_CompoundVariable._match_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_CompoundVariable._match_alt_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CompoundVariable.set_values(array(int64,ndim=1),array(double,ndim=1),bool)\n\tmosek.fusion.CompoundVariable.set_values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_CompoundVariable._match_make_1continuous__3J(*args): # []int64
      return self._make_1continuous__3J(*args)
    elif mosek_fusion_CompoundVariable._match_alt_make_1continuous__3J(*args): # []int64
      return self._make_1continuous_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CompoundVariable.make_continuous(array(int64,ndim=1))')
  def elementName(self,*args):
    if False: pass
    elif mosek_fusion_CompoundVariable._match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_CompoundVariable._match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CompoundVariable.elementName(int64,mosek.fusion.Utils.StringBuffer)')
  def elementDesc(self,*args):
    if False: pass
    elif mosek_fusion_CompoundVariable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_CompoundVariable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CompoundVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_CompoundVariable._match_make_1integer__3J(*args): # []int64
      return self._make_1integer__3J(*args)
    elif mosek_fusion_CompoundVariable._match_alt_make_1integer__3J(*args): # []int64
      return self._make_1integer_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CompoundVariable.make_integer(array(int64,ndim=1))')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_CompoundVariable._match_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_JJ_3I_3I_3I(*args)
    elif mosek_fusion_CompoundVariable._match_alt_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt_JJ_3I_3I_3I(*args)
    elif mosek_fusion_CompoundVariable._match_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst__3JIIJJ_3I_3I_3I(*args)
    elif mosek_fusion_CompoundVariable._match_alt_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt__3JIIJJ_3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CompoundVariable.inst(int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.CompoundVariable.inst(array(int64,ndim=1),int32,int32,int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def values(self,*args):
    if False: pass
    elif mosek_fusion_CompoundVariable._match_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_I_3DZ(*args)
    elif mosek_fusion_CompoundVariable._match_alt_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_alt_I_3DZ(*args)
    elif mosek_fusion_CompoundVariable._match_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values__3JI_3DZ(*args)
    elif mosek_fusion_CompoundVariable._match_alt_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values_alt__3JI_3DZ(*args)
    elif mosek_fusion_CompoundVariable._match_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_CompoundVariable._match_alt_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CompoundVariable.values(int32,array(double,ndim=1),bool)\n\tmosek.fusion.CompoundVariable.values(array(int64,ndim=1),int32,array(double,ndim=1),bool)\n\tmosek.fusion.CompoundVariable.values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def __repr__(self): return 'mosek.fusion.CompoundVariable'
  @staticmethod
  def _ctor__3Lmosek_4fusion_4Variable_2I(v,dim):
    o = CompoundVariable.__new__(CompoundVariable)
    o._ctor_init__3Lmosek_4fusion_4Variable_2I(v,dim)
    return o
  @staticmethod
  def __match_ctor__3Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    v,dim, = args
    return (__arg_match__3Lmosek_4fusion_4Variable_2__(v) and __arg_match_I__(dim))
  @staticmethod
  def __match_alt_ctor__3Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    v,dim, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Variable_2__(v) and __arg_alt_match_I__(dim))
  def _ctor_alt_init__3Lmosek_4fusion_4Variable_2I(self,v,dim):
    self._ctor_init__3Lmosek_4fusion_4Variable_2I(numpy.array(v,dtype=numpy.dtype(object)),numpy.int32(dim))
  def _ctor_init__3Lmosek_4fusion_4Variable_2I(self,v,dim):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(self,mosek.fusion.CompoundVariable.__model_1from_1var__3Lmosek_4fusion_4Variable_2(v),mosek.fusion.CompoundVariable.__compute_1shape__3Lmosek_4fusion_4Variable_2I(v,dim))
   _0=0
   _1=0
   for _2 in range(0,int((v).shape[0])):
    if ((v[_2].getShape()._size)==1):
     _0 += 1
     _1 += 1
    elif ((v[_2].getShape()._size) > 1):
     _0 += 1
     _1 += v[_2].getShape().dim(dim)
   self.__vars = numpy.zeros((_0,), dtype=numpy.dtype(object))
   self.__varsb = numpy.zeros(((_0 + 1),), dtype=numpy.dtype(numpy.int32))
   self.__varsb[0] = 0
   self.__stackdim = dim
   _3=0
   for _4 in range(0,int((v).shape[0])):
    if ((v[_4].getShape()._size) > 0):
     self.__vars[_3] = v[_4]
     if ((v[_4].getShape()._size)==1):
      self.__varsb[(_3 + 1)] = (self.__varsb[_3] + 1)
     else:
      self.__varsb[(_3 + 1)] = (self.__varsb[_3] + v[_4].getShape().dim(dim))
     _3 += 1
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   if ((_0 < 0) or (_0 >= (self._shape_p._size))):
    raise mosek_fusion_IndexError._ctor_S("Index out of bounds")
   _2=self._shape_p._idxtokey_J(_0)
   _3=0
   while (_2[self.__stackdim] >= self.__varsb[(_3 + 1)]):
    _3 += 1
   _2[self.__stackdim] = (_2[self.__stackdim] - self.__varsb[_3])
   self.__vars[_3].elementDesc(self.__vars[_3].getShape()._linearidx__3I(_2),_1)
   return (_1)
  @staticmethod
  def _match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   if ((_0 < 0) or (_0 >= (self._shape_p._size))):
    raise mosek_fusion_IndexError._ctor_S("Index out of bounds")
   _2=self._shape_p._idxtokey_J(_0)
   _3=0
   while (_2[self.__stackdim] >= self.__varsb[(_3 + 1)]):
    _3 += 1
   _2[self.__stackdim] = (_2[self.__stackdim] - self.__varsb[_3])
   self.__vars[_3].elementName(self.__vars[_3].getShape()._linearidx__3I(_2),_1)
  @staticmethod
  def _match_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match_J__(_0) and __arg_match_J__(_1) and __arg_match__3I__(_2) and __arg_match__3I__(_3) and __arg_match__3I__(_4))
  @staticmethod
  def _match_alt_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_J__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match__3I__(_3) and __arg_alt_match__3I__(_4))
  def _inst_alt_JJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst_JJ_3I_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst_JJ_3I_3I_3I(self,_0,_1,_2,_3,_4):
   if ((_0 < 0) or (_0 >= (self._shape_p._size))):
    raise mosek_fusion_IndexError._ctor_S("Index out of bounds")
   _5=self._shape_p._idxtokey_J(_0)
   _6=0
   while (_5[self.__stackdim] >= self.__varsb[(_6 + 1)]):
    _6 += 1
   _5[self.__stackdim] = (_5[self.__stackdim] - self.__varsb[_6])
   self.__vars[_6].inst(self.__vars[_6].getShape()._linearidx__3I(_5),_1,_2,_3,_4)
  @staticmethod
  def _match_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _set_1values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._set_1values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   _6=int((_2).shape[0])
   _7=_1[0]
   for _8 in range(1,int((_1).shape[0])):
    _7 = (_7 * _1[_8])
   _9=numpy.array([_0 for _10 in range(0,int((_1).shape[0]))], dtype=numpy.dtype(numpy.int64))
   _11=numpy.zeros((int((_1).shape[0]),), dtype=numpy.dtype(numpy.int32))
   _12=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int32))
   _13=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int64))
   _13[((self._shape_p.nd) - 1)] = 1
   for _14 in range(1,(self._shape_p.nd)):
    _13[(((self._shape_p.nd) - _14) - 1)] = (_13[((self._shape_p.nd) - _14)] * self._shape_p.dim(((self._shape_p.nd) - _14)))
   _15=numpy.zeros((1,), dtype=numpy.dtype(numpy.int64))
   _16=numpy.zeros((1,), dtype=numpy.dtype(numpy.float64))
   for _17 in range(0,_7):
    _18=_9[0]
    for _19 in range(0,(self._shape_p.nd)):
     _12[_19] = numpy.int32((_18 // _13[_19]))
     _18 = (_18 - (numpy.int64(_12[_19]) * _13[_19]))
    _20=0
    while (_12[self.__stackdim] >= self.__varsb[(_20 + 1)]):
     _20 += 1
    _12[self.__stackdim] = (_12[self.__stackdim] - self.__varsb[_20])
    _15[0] = self.__vars[_20].getShape()._linearidx__3I(_12)
    _16[0] = _4[(_3 + _17)]
    self.__vars[_20].set_values(_15,_16,_5)
    _11[0] += 1
    _9[0] = (_9[0] + _2[(_6 - 1)])
    _21=0
    _21 = 0
    while ((_21 < (_6 - 1)) and (_11[_21]==_1[_21])):
     _11[_21] = 0
     _11[(_21 + 1)] += 1
     _21 += 1
    for _22 in range(0,_21):
     _9[_22] = _9[_21]
  @staticmethod
  def _match_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _set_1values_alt__3J_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1 = self._set_1values__3J_3DZ(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values__3J_3DZ(self,_0,_1,_2):
   _3=numpy.zeros((1,), dtype=numpy.dtype(numpy.int64))
   _4=numpy.zeros((1,), dtype=numpy.dtype(numpy.float64))
   _5=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int32))
   for _6 in range(0,int((_0).shape[0])):
    _7=numpy.int64(_0[_6])
    for _8 in range(0,(self._shape_p.nd)):
     _5[_8] = numpy.int32((_7 // self._shape_p.stride(_8)))
     _7 = (_7 - (numpy.int64(_5[_8]) * self._shape_p.stride(_8)))
    _9=0
    while (_5[self.__stackdim] >= self.__varsb[(_9 + 1)]):
     _9 += 1
    _5[self.__stackdim] = (_5[self.__stackdim] - self.__varsb[_9])
    _3[0] = self.__vars[_9].getShape()._linearidx__3I(_5)
    _4[0] = _1[_6]
    self.__vars[_9].set_values(_3,_4,_2)
  @staticmethod
  def _match_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   _6=int((_2).shape[0])
   _7=_1[0]
   for _8 in range(1,int((_1).shape[0])):
    _7 *= _1[_8]
   _9=numpy.array([_0 for _10 in range(0,int((_1).shape[0]))], dtype=numpy.dtype(numpy.int64))
   _11=numpy.zeros((int((_1).shape[0]),), dtype=numpy.dtype(numpy.int32))
   _12=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int32))
   _13=numpy.zeros((1,), dtype=numpy.dtype(numpy.int64))
   for _14 in range(0,_7):
    _15=_9[0]
    for _16 in range(0,(self._shape_p.nd)):
     _12[(((self._shape_p.nd) - _16) - 1)] = numpy.int32((_15 % self._shape_p.dim((((self._shape_p.nd) - _16) - 1))))
     _15 /= self._shape_p.dim((((self._shape_p.nd) - _16) - 1))
    _17=0
    while (_12[self.__stackdim] >= self.__varsb[(_17 + 1)]):
     _17 += 1
    _12[self.__stackdim] = (_12[self.__stackdim] - self.__varsb[_17])
    _13[0] = self.__vars[_17].getShape()._linearidx__3I(_12)
    self.__vars[_17].values(_13,(_3 + _14),_4,_5)
    _11[0] += 1
    _18=0
    _18 = 0
    while ((_18 < (_6 - 1)) and (_11[_18]==_1[((_6 - 1) - _18)])):
     _11[_18] = 0
     _11[(_18 + 1)] += 1
     _18 += 1
    _9[_18] += _2[((_6 - _18) - 1)]
    for _19 in range(0,_18):
     _9[_19] = _9[_18]
  @staticmethod
  def _match_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match__3D__(_2) and __arg_match_Z__(_3))
  @staticmethod
  def _match_alt_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_Z__(_3))
  def _values_alt__3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_t__3
   _1 = self._values__3JI_3DZ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values__3JI_3DZ(self,_0,_1,_2,_3):
   _4=numpy.zeros((1,), dtype=numpy.dtype(numpy.int64))
   _5=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int32))
   for _6 in range(0,int((_0).shape[0])):
    _7=numpy.int64(_0[_6])
    for _8 in range(0,(self._shape_p.nd)):
     _5[_8] = numpy.int32((_7 // self._shape_p.stride(_8)))
     _7 = (_7 - (numpy.int64(_5[_8]) * self._shape_p.stride(_8)))
    _9=0
    while (_5[self.__stackdim] >= self.__varsb[(_9 + 1)]):
     _9 += 1
    _5[self.__stackdim] = (_5[self.__stackdim] - self.__varsb[_9])
    _4[0] = self.__vars[_9].getShape()._linearidx__3I(_5)
    self.__vars[_9].values(_4,(_1 + _6),_2,_3)
  @staticmethod
  def _match_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1continuous_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1continuous__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1continuous__3J(self,_0):
   _1=numpy.zeros((1,), dtype=numpy.dtype(numpy.int64))
   _2=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int32))
   for _3 in range(0,int((_0).shape[0])):
    _4=numpy.int64(_0[_3])
    for _5 in range(0,(self._shape_p.nd)):
     _2[_5] = numpy.int32((_4 // self._shape_p.stride(_5)))
     _4 = (_4 - (numpy.int64(_2[_5]) * self._shape_p.stride(_5)))
    _6=0
    while (_2[self.__stackdim] >= self.__varsb[(_6 + 1)]):
     _6 += 1
    _2[self.__stackdim] = (_2[self.__stackdim] - self.__varsb[_6])
    _1[0] = self.__vars[_6].getShape()._linearidx__3I(_2)
    self.__vars[_6].make_continuous(_1)
  @staticmethod
  def _match_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1integer_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1integer__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1integer__3J(self,_0):
   _1=numpy.zeros((1,), dtype=numpy.dtype(numpy.int64))
   _2=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int32))
   for _3 in range(0,int((_0).shape[0])):
    _4=numpy.int64(_0[_3])
    for _5 in range(0,(self._shape_p.nd)):
     _2[_5] = numpy.int32((_4 // self._shape_p.stride(_5)))
     _4 = (_4 - (numpy.int64(_2[_5]) * self._shape_p.stride(_5)))
    _6=0
    while (_2[self.__stackdim] >= self.__varsb[(_6 + 1)]):
     _6 += 1
    _2[self.__stackdim] = (_2[self.__stackdim] - self.__varsb[_6])
    _1[0] = self.__vars[_6].getShape()._linearidx__3I(_2)
    self.__vars[_6].make_integer(_1)
  @staticmethod
  def _match_asExpr_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_asExpr_(*args):
    if len(args) != 0: return False
    return True
  def _asExpr_alt_(self,):
    return self._asExpr_()
  def _asExpr_(self,):
   _0=mosek.fusion.Utils.Tools._range_JJ(0,((self._shape_p._size) + 1))
   _1=mosek.fusion.Utils.Tools._ones_I(numpy.int32((self._shape_p._size)))
   _2=numpy.zeros(((self._shape_p._size),), dtype=numpy.dtype(numpy.int64))
   if (self.__stackdim < 1):
    for _3 in range(0,numpy.int32((self._shape_p._size))):
     _2[_3] = _3
   elif (self.__stackdim >= (self._shape_p.nd)):
    _4=0
    _5=(self.__vars[0].getShape()._size)
    for _6 in range(0,_5):
     for _7 in range(0,int((self.__vars).shape[0])):
      _2[_4] = ((_7 * _5) + _6)
      _4 += 1
   else:
    _8=1
    for _9 in range(0,self.__stackdim):
     _8 *= self._shape_p.dim(_9)
    _10=numpy.zeros((int((self.__vars).shape[0]),), dtype=numpy.dtype(numpy.int64))
    _11=numpy.zeros(((int((self.__vars).shape[0]) + 1),), dtype=numpy.dtype(numpy.int64))
    for _12 in range(1,(int((self.__vars).shape[0]) + 1)):
     _11[_12] = (_11[(_12 - 1)] + (self.__vars[(_12 - 1)].getShape()._size))
    _13=0
    for _14 in range(0,_8):
     _15=0
     for _16 in range(0,int((self.__vars).shape[0])):
      for _17 in range(0,self.__vars[_16].getShape().stride((self.__stackdim - 1))):
       _2[_13] = ((_11[_16] + _10[_16]) + _17)
       _13 += 1
      _10[_16] += self.__vars[_16].getShape().stride((self.__stackdim - 1))
   _18=numpy.array([self.__vars[_19] for _19 in range(0,int((self.__vars).shape[0]))], dtype=numpy.dtype(object))
   return (mosek_fusion_Expr._ctor__3J_3Lmosek_4fusion_4Variable_2_3J_3D_3DLmosek_4fusion_4Set_2_3JI(_0,_18,_2,_1,None,self._shape_p,None,1))
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _slice__3I_3I(self,_0,_1):
   if (int((_0).shape[0])!=int((_1).shape[0])):
    raise mosek_fusion_LengthError._ctor_S("Mismatching array lengths")
   elif (int((_0).shape[0])!=(self._shape_p.nd)):
    raise mosek_fusion_SliceError._ctor_S("Slice has wrong number of dimensions")
   else:
    for _2 in range(0,int((_0).shape[0])):
     if ((_0[_2] < 0) or ((_0[_2] > _1[_2]) or (_1[_2] > self._shape_p.dim(_2)))):
      raise mosek_fusion_SliceError._ctor_S("Slice index is out of bounds")
   _3=False
   _4=0
   while (_4 < int((_0).shape[0])):
    if (_0[_4] >= _1[_4]):
     _3 = True
    _4 += 1
   if _3:
    _5=int((_0).shape[0])
    _6=numpy.zeros((_5,), dtype=numpy.dtype(numpy.int32))
    _7=0
    while (_7 < _5):
     if (_0[_7] < _1[_7]):
      _6[_7] = (_1[_7] - _0[_7])
     else:
      _6[_7] = 0
     _7 += 1
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(self,mosek_fusion_NDSet._ctor__3I(_6),0,numpy.zeros((_5,), dtype=numpy.dtype(numpy.int64))))
   elif (int((_0).shape[0])==1):
    return (self.slice(_0[0],_1[0]))
   else:
    _8=(self._shape_p.nd)
    _9=numpy.zeros((_8,), dtype=numpy.dtype(numpy.int32))
    _10=numpy.zeros((_8,), dtype=numpy.dtype(numpy.int32))
    _15=0
    while (_0[self.__stackdim] >= self.__varsb[(_15 + 1)]):
     _15 += 1
    _11 = _15
    _12 = (_0[self.__stackdim] - numpy.int32(self.__varsb[_15]))
    while (_1[self.__stackdim] > numpy.int32(self.__varsb[(_15 + 1)])):
     _15 += 1
    _13 = _15
    _14 = (_1[self.__stackdim] - numpy.int32(self.__varsb[_15]))
    _16=0
    while (_16 < _8):
     _9[_16] = _0[_16]
     _10[_16] = _1[_16]
     _16 += 1
    if (_11==_13):
     _9[self.__stackdim] = _12
     _10[self.__stackdim] = _14
     return (self.__vars[_11].slice(_9,_10))
    else:
     _17=numpy.zeros((((_13 - _11) + 1),), dtype=numpy.dtype(object))
     _9[self.__stackdim] = _12
     _10[self.__stackdim] = self.__vars[_11].getShape().dim(self.__stackdim)
     _17[0] = self.__vars[_11].slice(_9,_10)
     _9[self.__stackdim] = 0
     _10[self.__stackdim] = _14
     _17[(int((_17).shape[0]) - 1)] = self.__vars[_13].slice(_9,_10)
     for _18 in range(1,(int((_17).shape[0]) - 1)):
      _9[self.__stackdim] = 0
      _10[self.__stackdim] = self.__vars[(_18 + _11)].getShape().dim(self.__stackdim)
      _17[_18] = self.__vars[(_18 + _11)].slice(_9,_10)
     return (mosek_fusion_CompoundVariable._ctor__3Lmosek_4fusion_4Variable_2I(_17,self.__stackdim))
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   if ((self._shape_p.nd)!=1):
    raise mosek_fusion_SliceError._ctor_S("Slice has wrong number of dimensions")
   elif (_0 > _1):
    raise mosek_fusion_SliceError._ctor_S("Invalid slice range")
   elif ((_0 < 0) or (_1 > self._shape_p.dim(0))):
    raise mosek_fusion_SliceError._ctor_S("Slice index is out of bounds")
   if (_0==_1):
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(self,mosek_fusion_IntSet._ctor_I(0),0,numpy.array([0], dtype=numpy.dtype(numpy.int64))))
   _6=0
   while (_0 >= self.__varsb[(_6 + 1)]):
    _6 += 1
   _2 = _6
   _3 = (_0 - self.__varsb[_6])
   while (_1 > self.__varsb[(_6 + 1)]):
    _6 += 1
   _4 = _6
   _5 = (_1 - self.__varsb[_6])
   if (_2==_4):
    return (self.__vars[_2].slice(_3,_5))
   else:
    _7=numpy.zeros((((_4 - _2) + 1),), dtype=numpy.dtype(object))
    if (_3 > 0):
     _7[0] = self.__vars[_2].slice(_3,self.__vars[_2].getShape().dim(0))
    else:
     _7[0] = self.__vars[_2]
    if (_5 < self.__vars[_4].getShape().dim(0)):
     _7[(int((_7).shape[0]) - 1)] = self.__vars[_4].slice(0,_5)
    else:
     _7[(int((_7).shape[0]) - 1)] = self.__vars[_4]
    _8=1
    while (_8 < (int((_7).shape[0]) - 1)):
     _7[_8] = self.__vars[(_2 + _8)]
     _8 += 1
    return (mosek_fusion_CompoundVariable._ctor__3Lmosek_4fusion_4Variable_2I(_7,0))
  @staticmethod
  def __compute_1shape_alt__3Lmosek_4fusion_4Variable_2I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1=numpy.int32(_t__1)
   _1 = mosek_fusion_CompoundVariable.__compute_1shape__3Lmosek_4fusion_4Variable_2I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def __compute_1shape__3Lmosek_4fusion_4Variable_2I(_0,_1):
   _2=_0[0].getShape()
   _3=0
   for _4 in range(0,int((_0).shape[0])):
    _5=_0[_4]
    if ((_5.getShape()._size) > 0):
     if ((_5.getShape().nd)!=(_2.nd)):
      raise mosek_fusion_DimensionError._ctor_S("Mismatching variable shape")
     for _6 in range(0,(_2.nd)):
      if ((_6!=_1) and (_2.dim(_6)!=_5.getShape().dim(_6))):
       raise mosek_fusion_DimensionError._ctor_S("Mismatching variable shape")
     _3 = (_3 + _5.getShape().dim(_1))
   if ((_2.nd)==1):
    return (mosek_fusion_IntSet._ctor_I(_3))
   else:
    _7=numpy.array([_2.dim(_8) for _8 in range(0,(_2.nd))], dtype=numpy.dtype(numpy.int32))
    _7[_1] = _3
    return (mosek_fusion_NDSet._ctor__3I(_7))
  @staticmethod
  def __model_1from_1var_alt__3Lmosek_4fusion_4Variable_2(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1 = mosek_fusion_CompoundVariable.__model_1from_1var__3Lmosek_4fusion_4Variable_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def __model_1from_1var__3Lmosek_4fusion_4Variable_2(_0):
   return ((None if (((_0 is None) or (int((_0).shape[0])==0)) ) else _0[0].getModel()))
 return CompoundVariable
mosek_fusion_CompoundVariable=__mk_mosek_fusion_CompoundVariable()
del __mk_mosek_fusion_CompoundVariable
#BEFORE CLASS
def __mk_mosek_fusion_RepeatVariable():
 class RepeatVariable(mosek_fusion_BaseVariable):
  __slots__ = ['_RepeatVariable__d2','_RepeatVariable__d1','_RepeatVariable__d0','_RepeatVariable__dim','_RepeatVariable__count','_RepeatVariable__xsize','_RepeatVariable__xdims','_RepeatVariable__x']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_Lmosek_4fusion_4Variable_2II(*args): # mosek.fusion.Variable,int32,int32
      self._ctor_init_Lmosek_4fusion_4Variable_2II(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4Variable_2II(*args):# mosek.fusion.Variable,int32,int32
      self._ctor_alt_init_Lmosek_4fusion_4Variable_2II(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.RepeatVariable.ctor(mosek.fusion.Variable,int32,int32)')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_RepeatVariable._match_make_1continuous__3J(*args): # []int64
      return self._make_1continuous__3J(*args)
    elif mosek_fusion_RepeatVariable._match_alt_make_1continuous__3J(*args): # []int64
      return self._make_1continuous_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RepeatVariable.make_continuous(array(int64,ndim=1))')
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_RepeatVariable._match_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values__3J_3DZ(*args)
    elif mosek_fusion_RepeatVariable._match_alt_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values_alt__3J_3DZ(*args)
    elif mosek_fusion_RepeatVariable._match_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_RepeatVariable._match_alt_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RepeatVariable.set_values(array(int64,ndim=1),array(double,ndim=1),bool)\n\tmosek.fusion.RepeatVariable.set_values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def elementName(self,*args):
    if False: pass
    elif mosek_fusion_RepeatVariable._match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_RepeatVariable._match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RepeatVariable.elementName(int64,mosek.fusion.Utils.StringBuffer)')
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_RepeatVariable._match_make_1integer__3J(*args): # []int64
      return self._make_1integer__3J(*args)
    elif mosek_fusion_RepeatVariable._match_alt_make_1integer__3J(*args): # []int64
      return self._make_1integer_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RepeatVariable.make_integer(array(int64,ndim=1))')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_RepeatVariable._match_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_JJ_3I_3I_3I(*args)
    elif mosek_fusion_RepeatVariable._match_alt_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt_JJ_3I_3I_3I(*args)
    elif mosek_fusion_RepeatVariable._match_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst__3JIIJJ_3I_3I_3I(*args)
    elif mosek_fusion_RepeatVariable._match_alt_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt__3JIIJJ_3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RepeatVariable.inst(int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.RepeatVariable.inst(array(int64,ndim=1),int32,int32,int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def elementDesc(self,*args):
    if False: pass
    elif mosek_fusion_RepeatVariable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_RepeatVariable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RepeatVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def values(self,*args):
    if False: pass
    elif mosek_fusion_RepeatVariable._match_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_I_3DZ(*args)
    elif mosek_fusion_RepeatVariable._match_alt_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_alt_I_3DZ(*args)
    elif mosek_fusion_RepeatVariable._match_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values__3JI_3DZ(*args)
    elif mosek_fusion_RepeatVariable._match_alt_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values_alt__3JI_3DZ(*args)
    elif mosek_fusion_RepeatVariable._match_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_RepeatVariable._match_alt_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RepeatVariable.values(int32,array(double,ndim=1),bool)\n\tmosek.fusion.RepeatVariable.values(array(int64,ndim=1),int32,array(double,ndim=1),bool)\n\tmosek.fusion.RepeatVariable.values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def __repr__(self): return 'mosek.fusion.RepeatVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Variable_2II(x,dim,count):
    o = RepeatVariable.__new__(RepeatVariable)
    o._ctor_init_Lmosek_4fusion_4Variable_2II(x,dim,count)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Variable_2II(*args):
    if len(args) != 3: return False
    x,dim,count, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(x) and __arg_match_I__(dim) and __arg_match_I__(count))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Variable_2II(*args):
    if len(args) != 3: return False
    x,dim,count, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(x) and __arg_alt_match_I__(dim) and __arg_alt_match_I__(count))
  def _ctor_alt_init_Lmosek_4fusion_4Variable_2II(self,x,dim,count):
    self._ctor_init_Lmosek_4fusion_4Variable_2II(x,numpy.int32(dim),numpy.int32(count))
  def _ctor_init_Lmosek_4fusion_4Variable_2II(self,x,dim,count):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(self,x.getModel(),mosek.fusion.RepeatVariable.__compute_1shape_Lmosek_4fusion_4Variable_2II(x,dim,count))
   _0=x.getShape()
   (self.__x) = x
   (self.__count) = count
   self.__xsize = _0.getSize()
   if (dim >= 0):
    _1=(_0.nd)
    if (_1 <= dim):
     _1 = (dim + 1)
    (self.__dim) = dim
    (self.__xdims) = numpy.array([_0.dim(_2) for _2 in range(0,_1)], dtype=numpy.dtype(numpy.int32))
   else:
    (self.__dim) = 0
    self.__xdims = numpy.zeros((((_0.nd) + 1),), dtype=numpy.dtype(numpy.int32))
    self.__xdims[0] = 1
    for _3 in range(0,(_0.nd)):
     self.__xdims[(_3 + 1)] = _0.dim(_3)
   (self.__d0) = 1
   (self.__d1) = 1
   (self.__d2) = 1
   for _4 in range(0,dim):
    self.__d0 *= self.__xdims[_4]
   self.__d1 = (self.__xdims[(self.__dim)] * count)
   for _5 in range((dim + 1),int((self.__xdims).shape[0])):
    self.__d2 *= self.__xdims[_5]
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   if (self.__dim==0):
    return (self.__x.elementDesc((_0 % self.__xsize),_1))
   elif (self.__dim >= (self.__x.getShape().nd)):
    return (self.__x.elementDesc((_0 // self.__xsize),_1))
   else:
    _2=self.__d0
    _3=(self.__xdims[self.__dim] * self.__d2)
    _4=(_0 % _3)
    _5=(_0 // (_3 * self.__count))
    return (self.__x.elementDesc(((_5 * _3) + _4),_1))
  @staticmethod
  def _match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   if (self.__dim==0):
    self.__x.elementName((_0 % self.__xsize),_1)
   elif (self.__dim >= (self.__x.getShape().nd)):
    self.__x.elementName((_0 // self.__xsize),_1)
   else:
    _2=self.__d0
    _3=(self.__x.getShape().dim(self.__dim) * self.__d2)
    _4=(_0 % _3)
    _5=(_0 // (_3 * self.__count))
    self.__x.elementName(((_5 * _3) + _4),_1)
  @staticmethod
  def _match_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match_J__(_0) and __arg_match_J__(_1) and __arg_match__3I__(_2) and __arg_match__3I__(_3) and __arg_match__3I__(_4))
  @staticmethod
  def _match_alt_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_J__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match__3I__(_3) and __arg_alt_match__3I__(_4))
  def _inst_alt_JJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst_JJ_3I_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst_JJ_3I_3I_3I(self,_0,_1,_2,_3,_4):
   if (self.__dim==0):
    self.__x.inst((_0 % self.__xsize),_1,_2,_4,_3)
   elif ((self.__d1 * self.__d2)==1):
    self.__x.inst((_0 // self.__count),_1,_2,_4,_3)
   else:
    _5=self.__d0
    _6=(self.__x.getShape().dim(self.__dim) * self.__d2)
    _7=(_0 % _6)
    _8=(_0 // (_6 * self.__count))
    self.__x.inst(((_8 * _6) + _7),_1,_2,_4,_3)
  @staticmethod
  def _match_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _set_1values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._set_1values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   if ((int((_1).shape[0])!=(self._shape_p.nd)) or (int((_2).shape[0])!=(self._shape_p.nd))):
    raise mosek_fusion_IndexError._ctor_S("Lengths of nsize and strides are not correct")
   _6=int((_2).shape[0])
   _7=_1[0]
   for _8 in range(1,int((_1).shape[0])):
    _7 = (_7 * _1[_8])
   _9=numpy.array([_0 for _10 in range(0,int((_1).shape[0]))], dtype=numpy.dtype(numpy.int64))
   _11=self._shape_p._idxtokey_J(_0)
   _12=numpy.zeros((_7,), dtype=numpy.dtype(numpy.float64))
   _13=numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
   for _14 in range(0,_7):
    _12[_14] = _4[(_14 + _3)]
    _15=(_9[0] % self.__d2)
    _16=((_9[0] // self.__d2) % self.__xdims[self.__dim])
    _17=(_9[0] // (self.__d1 * self.__d2))
    _13[_14] = ((((_15 * self.__d2) + _16) * self.__xdims[self.__dim]) + _17)
    _11[0] += 1
    _9[0] = (_9[0] + _2[(_6 - 1)])
    _18=0
    while ((_18 < (_6 - 1)) and (_11[_18]==_1[_18])):
     _11[_18] = 0
     _11[(_18 + 1)] += 1
     _18 += 1
    for _19 in range(0,_18):
     _9[_19] = _9[_18]
   self.set_values(_13,_12,_5)
  @staticmethod
  def _match_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _set_1values_alt__3J_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1 = self._set_1values__3J_3DZ(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values__3J_3DZ(self,_0,_1,_2):
   if (self.__dim==0):
    self.__x.set_values(numpy.array([(_0[_3] % self.__xsize) for _3 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64)),_1,_2)
   elif ((self.__d1 * self.__d2)==1):
    self.__x.set_values(numpy.array([(_0[_4] // self.__count) for _4 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64)),_1,_2)
   else:
    _5=self.__d0
    _6=(self.__x.getShape().dim(self.__dim) * self.__d2)
    _7=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
    for _8 in range(0,int((_0).shape[0])):
     _9=(_0[_8] % _6)
     _10=(_0[_8] // (_6 * self.__count))
     _7[_8] = ((_10 * _6) + _9)
    self.__x.set_values(_7,_1,_2)
  @staticmethod
  def _match_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   if ((int((_1).shape[0])!=(self._shape_p.nd)) or (int((_2).shape[0])!=(self._shape_p.nd))):
    raise mosek_fusion_IndexError._ctor_S("Lengths of nsize and strides are not correct")
   _6=int((_2).shape[0])
   _7=_1[0]
   for _8 in range(1,int((_1).shape[0])):
    _7 = (_7 * _1[_8])
   _9=numpy.array([_0 for _10 in range(0,int((_1).shape[0]))], dtype=numpy.dtype(numpy.int64))
   _11=self._shape_p._idxtokey_J(_0)
   _12=numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
   for _13 in range(0,_7):
    _14=(_9[0] % self.__d2)
    _15=((_9[0] // self.__d2) % self.__xdims[self.__dim])
    _16=(_9[0] // (self.__d1 * self.__d2))
    _12[_13] = ((((_14 * self.__d2) + _15) * self.__xdims[self.__dim]) + _16)
    _11[0] += 1
    _9[0] = (_9[0] + _2[(_6 - 1)])
    _17=0
    while ((_17 < (_6 - 1)) and (_11[_17]==_1[_17])):
     _11[_17] = 0
     _11[(_17 + 1)] += 1
     _17 += 1
    for _18 in range(0,_17):
     _9[_18] = _9[_17]
   self.values(_12,_3,_4,_5)
  @staticmethod
  def _match_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match__3D__(_2) and __arg_match_Z__(_3))
  @staticmethod
  def _match_alt_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_Z__(_3))
  def _values_alt__3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_t__3
   _1 = self._values__3JI_3DZ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values__3JI_3DZ(self,_0,_1,_2,_3):
   if (self.__d0==1):
    self.__x.values(numpy.array([(_0[_4] % self.__xsize) for _4 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64)),_1,_2,_3)
   elif ((self.__d1 * self.__d2)==1):
    self.__x.values(numpy.array([(_0[_5] // self.__count) for _5 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64)),_1,_2,_3)
   else:
    _6=self.__d0
    _7=(self.__x.getShape().dim(self.__dim) * self.__d2)
    _8=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
    for _9 in range(0,int((_0).shape[0])):
     _10=(_0[_9] % _7)
     _11=(_0[_9] // (_7 * self.__count))
     _8[_9] = ((_11 * _7) + _10)
    self.__x.values(_8,_1,_2,_3)
  @staticmethod
  def _match_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1continuous_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1continuous__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1continuous__3J(self,_0):
   if (self.__d0==1):
    self.__x.make_continuous(numpy.array([(_0[_1] % self.__xsize) for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64)))
   elif ((self.__d1 * self.__d2)==1):
    self.__x.make_continuous(numpy.array([(_0[_2] // self.__count) for _2 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64)))
   else:
    _3=self.__d0
    _4=(self.__x.getShape().dim(self.__dim) * self.__d2)
    _5=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
    for _6 in range(0,int((_0).shape[0])):
     _7=(_0[_6] % _4)
     _8=(_0[_6] // (_4 * self.__count))
     _5[_6] = ((_8 * _4) + _7)
    self.__x.make_continuous(_5)
  @staticmethod
  def _match_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1integer_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1integer__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1integer__3J(self,_0):
   if (self.__dim==0):
    self.__x.make_integer(numpy.array([(_0[_1] % self.__xsize) for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64)))
   elif ((self.__d1 * self.__d2)==1):
    self.__x.make_integer(numpy.array([(_0[_2] // self.__count) for _2 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64)))
   else:
    _3=self.__d0
    _4=(self.__x.getShape().dim(self.__dim) * self.__d2)
    _5=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
    for _6 in range(0,int((_0).shape[0])):
     _7=(_0[_6] % _4)
     _8=(_0[_6] // (_4 * self.__count))
     _5[_6] = ((_8 * _4) + _7)
    self.__x.make_integer(_5)
  @staticmethod
  def __compute_1shape_alt_Lmosek_4fusion_4Variable_2II(_t__0,_t__1,_t__2):
    return mosek_fusion_RepeatVariable.__compute_1shape_Lmosek_4fusion_4Variable_2II(_0,numpy.int32(__1),numpy.int32(__2))
  @staticmethod
  def __compute_1shape_Lmosek_4fusion_4Variable_2II(_0,_1,_2):
   _3=_0.getShape()
   if (_1 >= 0):
    if (((_3.nd)==1) and (_1==0)):
     return (mosek.fusion.Set._make_I((_3.dim(0) * _2)))
    elif (_1 < (_3.nd)):
     _4=numpy.array([_3.dim(_5) for _5 in range(0,(_3.nd))], dtype=numpy.dtype(numpy.int32))
     _4[_1] *= _2
     return (mosek.fusion.Set._make__3I(_4))
    else:
     _6=numpy.zeros(((_1 + 1),), dtype=numpy.dtype(numpy.int32))
     for _7 in range(0,(_3.nd)):
      _6[_7] = _3.dim(_7)
     for _8 in range((_3.nd),_1):
      _6[_8] = 1
     _6[_1] = _2
     return (mosek.fusion.Set._make__3I(_6))
   else:
    _9=numpy.zeros((((_3.nd) + 1),), dtype=numpy.dtype(numpy.int32))
    _9[0] = _2
    for _10 in range(0,(_3.nd)):
     _9[(_10 + 1)] = _3.dim(_10)
    return (mosek.fusion.Set._make__3I(_9))
 return RepeatVariable
mosek_fusion_RepeatVariable=__mk_mosek_fusion_RepeatVariable()
del __mk_mosek_fusion_RepeatVariable
#BEFORE CLASS
def __mk_mosek_fusion_PickVariable():
 class PickVariable(mosek_fusion_BaseVariable):
  __slots__ = ['_PickVariable__indexes','_PickVariable__origin']
  def values(self,*args):
    if False: pass
    elif mosek_fusion_PickVariable._match_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_I_3DZ(*args)
    elif mosek_fusion_PickVariable._match_alt_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_alt_I_3DZ(*args)
    elif mosek_fusion_PickVariable._match_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values__3JI_3DZ(*args)
    elif mosek_fusion_PickVariable._match_alt_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values_alt__3JI_3DZ(*args)
    elif mosek_fusion_PickVariable._match_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_PickVariable._match_alt_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PickVariable.values(int32,array(double,ndim=1),bool)\n\tmosek.fusion.PickVariable.values(array(int64,ndim=1),int32,array(double,ndim=1),bool)\n\tmosek.fusion.PickVariable.values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_PickVariable._match_slice_II(*args): # int32,int32
      return self._slice_II(*args)
    elif mosek_fusion_PickVariable._match_alt_slice_II(*args): # int32,int32
      return self._slice_alt_II(*args)
    elif mosek_fusion_PickVariable._match_slice__3I_3I(*args): # []int32,[]int32
      return self._slice__3I_3I(*args)
    elif mosek_fusion_PickVariable._match_alt_slice__3I_3I(*args): # []int32,[]int32
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PickVariable.slice(int32,int32)\n\tmosek.fusion.PickVariable.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_PickVariable._match_make_1continuous__3J(*args): # []int64
      return self._make_1continuous__3J(*args)
    elif mosek_fusion_PickVariable._match_alt_make_1continuous__3J(*args): # []int64
      return self._make_1continuous_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PickVariable.make_continuous(array(int64,ndim=1))')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_PickVariable._match_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_JJ_3I_3I_3I(*args)
    elif mosek_fusion_PickVariable._match_alt_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt_JJ_3I_3I_3I(*args)
    elif mosek_fusion_PickVariable._match_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst__3JIIJJ_3I_3I_3I(*args)
    elif mosek_fusion_PickVariable._match_alt_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt__3JIIJJ_3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PickVariable.inst(int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.PickVariable.inst(array(int64,ndim=1),int32,int32,int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_PickVariable._match_make_1integer__3J(*args): # []int64
      return self._make_1integer__3J(*args)
    elif mosek_fusion_PickVariable._match_alt_make_1integer__3J(*args): # []int64
      return self._make_1integer_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PickVariable.make_integer(array(int64,ndim=1))')
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_PickVariable._match_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values__3J_3DZ(*args)
    elif mosek_fusion_PickVariable._match_alt_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values_alt__3J_3DZ(*args)
    elif mosek_fusion_PickVariable._match_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_PickVariable._match_alt_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PickVariable.set_values(array(int64,ndim=1),array(double,ndim=1),bool)\n\tmosek.fusion.PickVariable.set_values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def elementName(self,*args):
    if False: pass
    elif mosek_fusion_PickVariable._match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_PickVariable._match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PickVariable.elementName(int64,mosek.fusion.Utils.StringBuffer)')
  def elementDesc(self,*args):
    if False: pass
    elif mosek_fusion_PickVariable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_PickVariable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PickVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def __repr__(self): return 'mosek.fusion.PickVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Variable_2_3J(origin,idxs):
    o = PickVariable.__new__(PickVariable)
    o._ctor_init_Lmosek_4fusion_4Variable_2_3J(origin,idxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Variable_2_3J(*args):
    if len(args) != 2: return False
    origin,idxs, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(origin) and __arg_match__3J__(idxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Variable_2_3J(*args):
    if len(args) != 2: return False
    origin,idxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(origin) and __arg_alt_match__3J__(idxs))
  def _ctor_alt_init_Lmosek_4fusion_4Variable_2_3J(self,origin,idxs):
    self._ctor_init_Lmosek_4fusion_4Variable_2_3J(origin,numpy.array(idxs,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_Lmosek_4fusion_4Variable_2_3J(self,origin,idxs):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(self,origin.getModel(),mosek.fusion.Set._make_I(int((idxs).shape[0])))
   (self.__origin) = origin
   _0=origin.getShape().getSize()
   for _1 in range(0,int((idxs).shape[0])):
    if ((idxs[_1] < 0) or (idxs[_1] >= _0)):
     raise mosek_fusion_IndexError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Index (")._a_J(idxs[_1])._a_S(") is out of bounds")._toString_())
   (self.__indexes) = idxs
  @staticmethod
  def _match_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match_J__(_0) and __arg_match_J__(_1) and __arg_match__3I__(_2) and __arg_match__3I__(_3) and __arg_match__3I__(_4))
  @staticmethod
  def _match_alt_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_J__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match__3I__(_3) and __arg_alt_match__3I__(_4))
  def _inst_alt_JJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst_JJ_3I_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst_JJ_3I_3I_3I(self,_0,_1,_2,_3,_4):
   self.__origin.inst(self.__indexes[_0],_1,_2,_3,_4)
  @staticmethod
  def _match_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _set_1values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._set_1values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   self.set_values(numpy.array([(_0 + (_2[0] * _6)) for _6 in range(0,_1[0])], dtype=numpy.dtype(numpy.int64)),(_4 if ((_3==0) ) else numpy.array([_4[(_7 + _3)] for _7 in range(0,_1[0])], dtype=numpy.dtype(numpy.float64))),_5)
  @staticmethod
  def _match_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _set_1values_alt__3J_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1 = self._set_1values__3J_3DZ(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values__3J_3DZ(self,_0,_1,_2):
   self.__origin.set_values(numpy.array([self.__indexes[_0[_3]] for _3 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64)),_1,_2)
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   return (self.__origin.elementDesc(self.__indexes[_0],_1))
  @staticmethod
  def _match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   self.__origin.elementName(self.__indexes[_0],_1)
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   return (mosek_fusion_PickVariable._ctor_Lmosek_4fusion_4Variable_2_3J(self.__origin,numpy.array([self.__indexes[_2] for _2 in range(_0,_1)], dtype=numpy.dtype(numpy.int64))))
  @staticmethod
  def _match_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   _6=numpy.array([(_0 + (_7 * _2[0])) for _7 in range(0,_1[0])], dtype=numpy.dtype(numpy.int64))
   self.values(_6,_3,_4,_5)
  @staticmethod
  def _match_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match__3D__(_2) and __arg_match_Z__(_3))
  @staticmethod
  def _match_alt_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_Z__(_3))
  def _values_alt__3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_t__3
   _1 = self._values__3JI_3DZ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values__3JI_3DZ(self,_0,_1,_2,_3):
   _4=numpy.array([self.__indexes[_0[_5]] for _5 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64))
   self.__origin.values(_4,_1,_2,_3)
  @staticmethod
  def _match_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1continuous_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1continuous__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1continuous__3J(self,_0):
   self.__origin.make_continuous(numpy.array([self.__indexes[_0[_1]] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64)))
  @staticmethod
  def _match_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1integer_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1integer__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1integer__3J(self,_0):
   self.__origin.make_integer(numpy.array([self.__indexes[_0[_1]] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64)))
 return PickVariable
mosek_fusion_PickVariable=__mk_mosek_fusion_PickVariable()
del __mk_mosek_fusion_PickVariable
#BEFORE CLASS
def __mk_mosek_fusion_SliceVariable():
 class SliceVariable(mosek_fusion_BaseVariable):
  __slots__ = ['_SliceVariable__strides','_SliceVariable__first','_SliceVariable__origin']
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_SliceVariable._match_slice_II(*args): # int32,int32
      return self._slice_II(*args)
    elif mosek_fusion_SliceVariable._match_alt_slice_II(*args): # int32,int32
      return self._slice_alt_II(*args)
    elif mosek_fusion_SliceVariable._match_slice__3I_3I(*args): # []int32,[]int32
      return self._slice__3I_3I(*args)
    elif mosek_fusion_SliceVariable._match_alt_slice__3I_3I(*args): # []int32,[]int32
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SliceVariable.slice(int32,int32)\n\tmosek.fusion.SliceVariable.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_SliceVariable._match_make_1integer__3J(*args): # []int64
      return self._make_1integer__3J(*args)
    elif mosek_fusion_SliceVariable._match_alt_make_1integer__3J(*args): # []int64
      return self._make_1integer_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SliceVariable.make_integer(array(int64,ndim=1))')
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_SliceVariable._match_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values__3J_3DZ(*args)
    elif mosek_fusion_SliceVariable._match_alt_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values_alt__3J_3DZ(*args)
    elif mosek_fusion_SliceVariable._match_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_SliceVariable._match_alt_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SliceVariable.set_values(array(int64,ndim=1),array(double,ndim=1),bool)\n\tmosek.fusion.SliceVariable.set_values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def elementName(self,*args):
    if False: pass
    elif mosek_fusion_SliceVariable._match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_SliceVariable._match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SliceVariable.elementName(int64,mosek.fusion.Utils.StringBuffer)')
  def values(self,*args):
    if False: pass
    elif mosek_fusion_SliceVariable._match_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_I_3DZ(*args)
    elif mosek_fusion_SliceVariable._match_alt_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_alt_I_3DZ(*args)
    elif mosek_fusion_SliceVariable._match_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values__3JI_3DZ(*args)
    elif mosek_fusion_SliceVariable._match_alt_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values_alt__3JI_3DZ(*args)
    elif mosek_fusion_SliceVariable._match_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_SliceVariable._match_alt_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SliceVariable.values(int32,array(double,ndim=1),bool)\n\tmosek.fusion.SliceVariable.values(array(int64,ndim=1),int32,array(double,ndim=1),bool)\n\tmosek.fusion.SliceVariable.values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_SliceVariable._match_make_1continuous__3J(*args): # []int64
      return self._make_1continuous__3J(*args)
    elif mosek_fusion_SliceVariable._match_alt_make_1continuous__3J(*args): # []int64
      return self._make_1continuous_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SliceVariable.make_continuous(array(int64,ndim=1))')
  def elementDesc(self,*args):
    if False: pass
    elif mosek_fusion_SliceVariable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_SliceVariable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SliceVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_SliceVariable._match_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_JJ_3I_3I_3I(*args)
    elif mosek_fusion_SliceVariable._match_alt_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt_JJ_3I_3I_3I(*args)
    elif mosek_fusion_SliceVariable._match_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst__3JIIJJ_3I_3I_3I(*args)
    elif mosek_fusion_SliceVariable._match_alt_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt__3JIIJJ_3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SliceVariable.inst(int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.SliceVariable.inst(array(int64,ndim=1),int32,int32,int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def __repr__(self): return 'mosek.fusion.SliceVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(origin,shape,first,strides):
    o = SliceVariable.__new__(SliceVariable)
    o._ctor_init_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(origin,shape,first,strides)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(*args):
    if len(args) != 4: return False
    origin,shape,first,strides, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(origin) and __arg_match_Lmosek_4fusion_4Set_2__(shape) and __arg_match_J__(first) and __arg_match__3J__(strides))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(*args):
    if len(args) != 4: return False
    origin,shape,first,strides, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(origin) and __arg_alt_match_Lmosek_4fusion_4Set_2__(shape) and __arg_alt_match_J__(first) and __arg_alt_match__3J__(strides))
  def _ctor_alt_init_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(self,origin,shape,first,strides):
    self._ctor_init_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(origin,shape,numpy.int64(first),numpy.array(strides,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(self,origin,shape,first,strides):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(self,origin.getModel(),shape)
   (self.__origin) = origin
   (self.__first) = first
   (self.__strides) = strides
  @staticmethod
  def _match_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match_J__(_0) and __arg_match_J__(_1) and __arg_match__3I__(_2) and __arg_match__3I__(_3) and __arg_match__3I__(_4))
  @staticmethod
  def _match_alt_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_J__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match__3I__(_3) and __arg_alt_match__3I__(_4))
  def _inst_alt_JJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst_JJ_3I_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst_JJ_3I_3I_3I(self,_0,_1,_2,_3,_4):
   if ((_0 < 0) or (_0 >= (self._shape_p._size))):
    raise mosek_fusion_IndexError._ctor_S("Index out of bounds")
   _5=self.__first
   _6=_0
   for _7 in range(0,(self._shape_p.nd)):
    _8=(_6 // self._shape_p.stride(_7))
    _6 = (_6 - (_8 * self._shape_p.stride(_7)))
    _5 = (_5 + (self.__strides[_7] * _8))
   self.__origin.inst(_5,_1,_2,_3,_4)
  @staticmethod
  def _match_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _set_1values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._set_1values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   if ((_0==0) and ((int((_1).shape[0])==1) and ((_1[0]==(self._shape_p._size)) and (_2[0]==1)))):
    _6=numpy.array([self._shape_p.dim(_7) for _7 in range(0,(self._shape_p.nd))], dtype=numpy.dtype(numpy.int32))
    self.__origin.set_values(self.__first,_6,self.__strides,_3,_4,_5)
   else:
    _8=int((_1).shape[0])
    _9=(_8==(self._shape_p.nd))
    _10=0
    while ((_10 < _8) and _9):
     _9 = (_2[_10]==self._shape_p.stride(_10))
     _10 += 1
    if _9:
     _11=self.__first
     _12=_0
     for _13 in range(0,((self._shape_p.nd) - 1)):
      _14=(_12 // _2[_13])
      _12 = (_12 - (_2[_13] * _14))
      _11 = (_11 + (self._shape_p.stride(_13) * _14))
     self.__origin.set_values(_11,_1,self.__strides,_3,_4,_5)
    else:
     _15=1
     for _16 in range(0,int((_1).shape[0])):
      _15 = (_15 * _1[_16])
     _17=numpy.zeros((_15,), dtype=numpy.dtype(numpy.int64))
     _18=numpy.zeros((int((_1).shape[0]),), dtype=numpy.dtype(numpy.int32))
     _19=numpy.zeros((int((_1).shape[0]),), dtype=numpy.dtype(numpy.int64))
     for _20 in range(0,_15):
      _17[_20] = (self.__origin.getShape()._linearidx__3I(self._shape_p._idxtokey_J((_0 + _19[0]))) + self.__first)
      _21=0
      _18[0] += 1
      _19[0] = (_19[0] + _2[(_8 - 1)])
      while ((_21 < (_8 - 1)) and (_18[_21] >= _1[((_8 - _21) - 1)])):
       _19[(_21 + 1)] = (_19[(_21 + 1)] + _2[((_8 - _21) - 2)])
       _18[_21] = 0
       _18[(_21 + 1)] += 1
       _21 += 1
      for _22 in range(0,_21):
       _19[_22] = _19[_21]
     self.__origin.set_values(_17,(_4 if ((_3==0) ) else numpy.array([_4[(_23 + _3)] for _23 in range(0,_15)], dtype=numpy.dtype(numpy.float64))),_5)
  @staticmethod
  def _match_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _set_1values_alt__3J_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1 = self._set_1values__3J_3DZ(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values__3J_3DZ(self,_0,_1,_2):
   _3=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
   for _4 in range(0,int((_0).shape[0])):
    _5=self._shape_p._idxtokey_J(_0[_4])
    _6=self.__first
    for _7 in range(0,(self._shape_p.nd)):
     _6 = (_6 + (numpy.int64(_5[_7]) * self.__strides[_7]))
    _3[_4] = _6
   self.__origin.set_values(_3,_1,_2)
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   if ((_0 < 0) or (_0 >= (self._shape_p._size))):
    raise mosek_fusion_IndexError._ctor_S("Index out of bounds")
   _2=self.__first
   _3=_0
   for _4 in range(0,(self._shape_p.nd)):
    _5=(_3 // self._shape_p.stride(_4))
    _3 = (_3 - (_5 * self._shape_p.stride(_4)))
    _2 = (_2 + (self.__strides[_4] * _5))
   self.__origin.elementDesc(_2,_1)
   return (_1)
  @staticmethod
  def _match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   if ((_0 < 0) or (_0 >= (self._shape_p._size))):
    raise mosek_fusion_IndexError._ctor_S("Index out of bounds")
   _2=self.__first
   _3=_0
   for _4 in range(0,(self._shape_p.nd)):
    _5=(_3 // self._shape_p.stride(_4))
    _3 = (_3 - (_5 * self._shape_p.stride(_4)))
    _2 = (_2 + (self.__strides[_4] * _5))
   self.__origin.elementName(_2,_1)
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _slice__3I_3I(self,_0,_1):
   _2=self._shape_p.slice(_0,_1)
   _3=self.__first
   _4=0
   while (_4 < int((_0).shape[0])):
    _3 = (_3 + (self.__strides[_4] * _0[_4]))
    _4 += 1
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(self.__origin,_2,_3,self.__strides))
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(self.__origin,self._shape_p.slice(_0,_1),(self.__first + numpy.int64(_0)),self.__strides))
  @staticmethod
  def _match_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   if ((_0==0) and ((int((_1).shape[0])==1) and ((_1[0]==(self._shape_p._size)) and (_2[0]==1)))):
    _6=numpy.array([self._shape_p.dim(_7) for _7 in range(0,(self._shape_p.nd))], dtype=numpy.dtype(numpy.int32))
    self.__origin.values(self.__first,_6,self.__strides,_3,_4,_5)
   else:
    _8=int((_1).shape[0])
    _9=(_8==(self._shape_p.nd))
    _10=0
    while ((_10 < _8) and _9):
     _9 = (_2[_10]==self._shape_p.stride(_10))
     _10 += 1
    if _9:
     _11=self.__first
     _12=_0
     for _13 in range(0,((self._shape_p.nd) - 1)):
      _14=(_12 // _2[_13])
      _12 = (_12 - (_2[_13] * _14))
      _11 = (_11 + (self._shape_p.stride(_13) * _14))
     self.__origin.values(_11,_1,self.__strides,_3,_4,_5)
    else:
     _15=1
     for _16 in range(0,int((_1).shape[0])):
      _15 = (_15 * _1[_16])
     _17=numpy.zeros((_15,), dtype=numpy.dtype(numpy.int64))
     _18=numpy.zeros((int((_1).shape[0]),), dtype=numpy.dtype(numpy.int32))
     _19=numpy.zeros((int((_1).shape[0]),), dtype=numpy.dtype(numpy.int64))
     for _20 in range(0,_15):
      _17[_20] = (self.__origin.getShape()._linearidx__3I(self._shape_p._idxtokey_J((_0 + _19[0]))) + self.__first)
      _21=0
      _18[0] += 1
      _19[0] = (_19[0] + _2[(_8 - 1)])
      while ((_21 < (_8 - 1)) and (_18[_21] >= _1[((_8 - _21) - 1)])):
       _19[(_21 + 1)] = (_19[(_21 + 1)] + _2[((_8 - _21) - 2)])
       _18[_21] = 0
       _18[(_21 + 1)] += 1
       _21 += 1
      for _22 in range(0,_21):
       _19[_22] = _19[_21]
     self.__origin.values(_17,_3,_4,_5)
  @staticmethod
  def _match_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match__3D__(_2) and __arg_match_Z__(_3))
  @staticmethod
  def _match_alt_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_Z__(_3))
  def _values_alt__3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_t__3
   _1 = self._values__3JI_3DZ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values__3JI_3DZ(self,_0,_1,_2,_3):
   _4=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
   for _5 in range(0,int((_0).shape[0])):
    _6=self._shape_p._idxtokey_J(_0[_5])
    _7=self.__first
    for _8 in range(0,(self._shape_p.nd)):
     _7 = (_7 + (numpy.int64(_6[_8]) * self.__strides[_8]))
    _4[_5] = _7
   self.__origin.values(_4,_1,_2,_3)
  @staticmethod
  def _match_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1continuous_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1continuous__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1continuous__3J(self,_0):
   _1=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
   for _2 in range(0,int((_0).shape[0])):
    _3=self._shape_p._idxtokey_J(_0[_2])
    _4=self.__first
    for _5 in range(0,(self._shape_p.nd)):
     _4 = (_4 + (numpy.int64(_3[_5]) * self.__strides[_5]))
    _1[_2] = _4
   self.__origin.make_continuous(_1)
  @staticmethod
  def _match_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1integer_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1integer__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1integer__3J(self,_0):
   _1=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
   for _2 in range(0,int((_0).shape[0])):
    _3=self._shape_p._idxtokey_J(_0[_2])
    _4=self.__first
    for _5 in range(0,(self._shape_p.nd)):
     _4 = (_4 + (numpy.int64(_3[_5]) * self.__strides[_5]))
    _1[_2] = _4
   self.__origin.make_integer(_1)
 return SliceVariable
mosek_fusion_SliceVariable=__mk_mosek_fusion_SliceVariable()
del __mk_mosek_fusion_SliceVariable
#BEFORE CLASS
def __mk_mosek_fusion_BoundInterfaceVariable():
 class BoundInterfaceVariable(mosek_fusion_SliceVariable):
  __slots__ = ['_BoundInterfaceVariable__originvar','_BoundInterfaceVariable__islower']
  def __repr__(self): return 'mosek.fusion.BoundInterfaceVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Set_2J_3JZ(origin_,shape_,first_,strides_,islower_):
    o = BoundInterfaceVariable.__new__(BoundInterfaceVariable)
    o._ctor_init_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Set_2J_3JZ(origin_,shape_,first_,strides_,islower_)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Set_2J_3JZ(*args):
    if len(args) != 5: return False
    origin_,shape_,first_,strides_,islower_, = args
    return (__arg_match_Lmosek_4fusion_4RangedVariable_2__(origin_) and __arg_match_Lmosek_4fusion_4Set_2__(shape_) and __arg_match_J__(first_) and __arg_match__3J__(strides_) and __arg_match_Z__(islower_))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Set_2J_3JZ(*args):
    if len(args) != 5: return False
    origin_,shape_,first_,strides_,islower_, = args
    return (__arg_alt_match_Lmosek_4fusion_4RangedVariable_2__(origin_) and __arg_alt_match_Lmosek_4fusion_4Set_2__(shape_) and __arg_alt_match_J__(first_) and __arg_alt_match__3J__(strides_) and __arg_alt_match_Z__(islower_))
  def _ctor_alt_init_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Set_2J_3JZ(self,origin_,shape_,first_,strides_,islower_):
    self._ctor_init_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Set_2J_3JZ(origin_,shape_,numpy.int64(first_),numpy.array(strides_,dtype=numpy.dtype(numpy.int64)),islower_)
  def _ctor_init_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Set_2J_3JZ(self,origin_,shape_,first_,strides_,islower_):
   mosek_fusion_SliceVariable._ctor_init_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(self,origin_,shape_,first_,strides_)
   self.__originvar = origin_
   self.__islower = islower_
  def _slice_1_alt_Lmosek_4fusion_4Set_2J_3J(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _1 = self._slice_1_Lmosek_4fusion_4Set_2J_3J(_0,_1,_2)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _slice_1_Lmosek_4fusion_4Set_2J_3J(self,_0,_1,_2):
   return (mosek_fusion_BoundInterfaceVariable._ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Set_2J_3JZ(self.__originvar,_0,_1,_2,self.__islower))
  def _dual_1values_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1values_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   if self.__islower:
    self.__originvar._dual_1l_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   else:
    self.__originvar._dual_1u_J_3I_3JI_3D(_0,_1,_2,_3,_4)
  def _dual_1values_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1values__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1values__3JI_3D(self,_0,_1,_2):
   if self.__islower:
    self.__originvar._dual_1l__3JI_3D(_0,_1,_2)
   else:
    self.__originvar._dual_1u__3JI_3D(_0,_1,_2)
 return BoundInterfaceVariable
mosek_fusion_BoundInterfaceVariable=__mk_mosek_fusion_BoundInterfaceVariable()
del __mk_mosek_fusion_BoundInterfaceVariable
#BEFORE CLASS
def __mk_mosek_fusion_ModelVariable():
 class ModelVariable(mosek_fusion_BaseVariable):
  __slots__ = ['_varid','_name']
  def elementName(self,*args):
    if False: pass
    elif mosek_fusion_ModelVariable._match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_ModelVariable._match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ModelVariable.elementName(int64,mosek.fusion.Utils.StringBuffer)')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_ModelVariable._match_slice_II(*args): # int32,int32
      return self._slice_II(*args)
    elif mosek_fusion_ModelVariable._match_alt_slice_II(*args): # int32,int32
      return self._slice_alt_II(*args)
    elif mosek_fusion_ModelVariable._match_slice__3I_3I(*args): # []int32,[]int32
      return self._slice__3I_3I(*args)
    elif mosek_fusion_ModelVariable._match_alt_slice__3I_3I(*args): # []int32,[]int32
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ModelVariable.slice(int32,int32)\n\tmosek.fusion.ModelVariable.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def __repr__(self): return 'mosek.fusion.ModelVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = ModelVariable.__new__(ModelVariable)
    o._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4ModelVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4ModelVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self._name = (v._name)
   self._varid = (v._varid)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2J(model_,name_,shape_p,varid_):
    o = ModelVariable.__new__(ModelVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2J(model_,name_,shape_p,varid_)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2J(*args):
    if len(args) != 4: return False
    model_,name_,shape_p,varid_, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model_) and __arg_match_S__(name_) and __arg_match_Lmosek_4fusion_4Set_2__(shape_p) and __arg_match_J__(varid_))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2J(*args):
    if len(args) != 4: return False
    model_,name_,shape_p,varid_, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model_) and __arg_alt_match_S__(name_) and __arg_alt_match_Lmosek_4fusion_4Set_2__(shape_p) and __arg_alt_match_J__(varid_))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2J(self,model_,name_,shape_p,varid_):
    self._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2J(model_,name_,shape_p,numpy.int64(varid_))
  def _ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2J(self,model_,name_,shape_p,varid_):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(self,model_,shape_p)
   self._name = name_
   self._varid = varid_
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   pass
  @staticmethod
  def _match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   _1._a_S(("_" if ((int(len(self._name))==0) ) else self._name))._a_S("[")._a_S(self._shape_p.indexToString(_0))._a_S("]")
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _slice__3I_3I(self,_0,_1):
   if (int((_0).shape[0])!=int((_1).shape[0])):
    raise mosek_fusion_LengthError._ctor_S("Mismatching array lengths")
   _2=self._shape_p.slice(_0,_1)
   _3=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int64))
   _3[((self._shape_p.nd) - 1)] = 1
   _4=((self._shape_p.nd) - 1)
   while (_4 > 0):
    _3[(_4 - 1)] = (_3[_4] * self._shape_p.dim(_4))
    _4 = (_4 - 1)
   _5=0
   _6=0
   while (_6 < int((_3).shape[0])):
    _5 = (_5 + (_3[_6] * _0[_6]))
    _6 += 1
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(self,_2,_5,_3))
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   if ((self._shape_p.nd)!=1):
    raise mosek_fusion_DimensionError._ctor_S("Wrong size of slice")
   _2=numpy.array([1], dtype=numpy.dtype(numpy.int64))
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(self,self._shape_p.slice(_0,_1),numpy.int64(_0),_2))
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   pass
 return ModelVariable
mosek_fusion_ModelVariable=__mk_mosek_fusion_ModelVariable()
del __mk_mosek_fusion_ModelVariable
#BEFORE CLASS
def __mk_mosek_fusion_SymRangedVariable():
 class SymRangedVariable(mosek_fusion_SymmetricVariable,mosek_fusion_ModelVariable):
  __slots__ = ['_dim','_SymRangedVariable__names_flushed','_SymRangedVariable__nativeidxs','_SymRangedVariable__dom','_SymRangedVariable__idxmap']
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_SymRangedVariable._match_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values__3J_3DZ(*args)
    elif mosek_fusion_SymRangedVariable._match_alt_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values_alt__3J_3DZ(*args)
    elif mosek_fusion_SymRangedVariable._match_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_SymRangedVariable._match_alt_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SymRangedVariable.set_values(array(int64,ndim=1),array(double,ndim=1),bool)\n\tmosek.fusion.SymRangedVariable.set_values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_SymRangedVariable._match_make_1continuous__3J(*args): # []int64
      return self._make_1continuous__3J(*args)
    elif mosek_fusion_SymRangedVariable._match_alt_make_1continuous__3J(*args): # []int64
      return self._make_1continuous_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SymRangedVariable.make_continuous(array(int64,ndim=1))')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_SymRangedVariable._match_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_JJ_3I_3I_3I(*args)
    elif mosek_fusion_SymRangedVariable._match_alt_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt_JJ_3I_3I_3I(*args)
    elif mosek_fusion_SymRangedVariable._match_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst__3JIIJJ_3I_3I_3I(*args)
    elif mosek_fusion_SymRangedVariable._match_alt_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt__3JIIJJ_3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SymRangedVariable.inst(int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.SymRangedVariable.inst(array(int64,ndim=1),int32,int32,int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_SymRangedVariable._match_toString_(*args): # 
      return self._toString_(*args)
    elif mosek_fusion_SymRangedVariable._match_alt_toString_(*args): # 
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SymRangedVariable.toString()')
  def values(self,*args):
    if False: pass
    elif mosek_fusion_SymRangedVariable._match_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_I_3DZ(*args)
    elif mosek_fusion_SymRangedVariable._match_alt_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_alt_I_3DZ(*args)
    elif mosek_fusion_SymRangedVariable._match_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values__3JI_3DZ(*args)
    elif mosek_fusion_SymRangedVariable._match_alt_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values_alt__3JI_3DZ(*args)
    elif mosek_fusion_SymRangedVariable._match_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_SymRangedVariable._match_alt_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SymRangedVariable.values(int32,array(double,ndim=1),bool)\n\tmosek.fusion.SymRangedVariable.values(array(int64,ndim=1),int32,array(double,ndim=1),bool)\n\tmosek.fusion.SymRangedVariable.values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_SymRangedVariable._match_make_1integer__3J(*args): # []int64
      return self._make_1integer__3J(*args)
    elif mosek_fusion_SymRangedVariable._match_alt_make_1integer__3J(*args): # []int64
      return self._make_1integer_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SymRangedVariable.make_integer(array(int64,ndim=1))')
  def __str__(self): return self._toString_()
  def __repr__(self): return 'mosek.fusion.SymRangedVariable: '+self._toString_()
  @staticmethod
  def _ctor_Lmosek_4fusion_4SymRangedVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = SymRangedVariable.__new__(SymRangedVariable)
    o._ctor_init_Lmosek_4fusion_4SymRangedVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4SymRangedVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4SymRangedVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4SymRangedVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4SymRangedVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4SymRangedVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4SymRangedVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4SymRangedVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__nativeidxs = (numpy.array([(v.__nativeidxs)[_0] for _0 in range(0,int(((v.__nativeidxs)).shape[0]))], dtype=numpy.dtype(numpy.int32)) if (((v.__nativeidxs) is not None) ) else None)
   self.__idxmap = ((v.__idxmap)._clone_() if (((v.__idxmap) is not None) ) else None)
   self.__dom = (v.__dom)
   (self._dim) = (v._dim)
   self.__names_flushed = (v.__names_flushed)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4RangeDomain_2I_3IJ(model_,name_,dom_,dim,nativeidxs_,varid_):
    o = SymRangedVariable.__new__(SymRangedVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4RangeDomain_2I_3IJ(model_,name_,dom_,dim,nativeidxs_,varid_)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4RangeDomain_2I_3IJ(*args):
    if len(args) != 6: return False
    model_,name_,dom_,dim,nativeidxs_,varid_, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model_) and __arg_match_S__(name_) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(dom_) and __arg_match_I__(dim) and __arg_match__3I__(nativeidxs_) and __arg_match_J__(varid_))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4RangeDomain_2I_3IJ(*args):
    if len(args) != 6: return False
    model_,name_,dom_,dim,nativeidxs_,varid_, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model_) and __arg_alt_match_S__(name_) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(dom_) and __arg_alt_match_I__(dim) and __arg_alt_match__3I__(nativeidxs_) and __arg_alt_match_J__(varid_))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4RangeDomain_2I_3IJ(self,model_,name_,dom_,dim,nativeidxs_,varid_):
    self._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4RangeDomain_2I_3IJ(model_,name_,dom_,numpy.int32(dim),numpy.array(nativeidxs_,dtype=numpy.dtype(numpy.int32)),numpy.int64(varid_))
  def _ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4RangeDomain_2I_3IJ(self,model_,name_,dom_,dim,nativeidxs_,varid_):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2J(self,model_,name_,mosek.fusion.Set._make_II(dim,dim),varid_)
   (self._dim) = dim
   self.__nativeidxs = nativeidxs_
   if (nativeidxs_ is None):
    self.__idxmap = mosek.fusion.Utils.IntMap()
   else:
    self.__idxmap = None
   self.__dom = dom_
   self.__names_flushed = False
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=mosek.fusion.Utils.StringBuffer()
   _0._a_S("RangedVariable(")
   if (int(len(self._name)) > 0):
    _0._a_S("'")._a_S(self._name)._a_S("',")
   _0._a_I(self._shape_p.dim(0))
   for _1 in range(1,(self._shape_p.nd)):
    _0._a_S(",")._a_I(self._shape_p.dim(_1))
   _0._a_S(") )")
   return (_0._toString_())
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   if ((not self.__names_flushed) and (int(len(self._name)) > 0)):
    if (self.__nativeidxs is not None):
     for _0 in range(0,int((self.__nativeidxs).shape[0])):
      self._model._varname_IS(self.__nativeidxs[_0],mosek.fusion.Utils.StringBuffer()._a_S(self._name)._a_S("[")._a_S(self._shape_p.getname(_0))._a_S("]")._toString_())
    else:
     _1=self.__idxmap._keys_()
     _2=self.__idxmap._values_()
     for _3 in range(0,int((_1).shape[0])):
      self._model._varname_IS(_2[_3],mosek.fusion.Utils.StringBuffer()._a_S(self._name)._a_S("[")._a_S(self._shape_p.getname(_3))._a_S("]")._toString_())
    self.__names_flushed = True
  @staticmethod
  def _match_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match__3I__(_5) and __arg_match__3I__(_6) and __arg_match__3I__(_7))
  @staticmethod
  def _match_alt_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match__3I__(_5) and __arg_alt_match__3I__(_6) and __arg_alt_match__3I__(_7))
  def _inst_alt__3JIIJJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int32))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.int32))
   _7=numpy.array(_t__7,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst__3JIIJJ_3I_3I_3I(_0,_1,_2,_3,_4,_5,_6,_7)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__7[:] = _7
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst__3JIIJJ_3I_3I_3I(self,_0,_1,_2,_3,_4,_5,_6,_7):
   if (self.__nativeidxs is not None):
    for _8 in range(_1,_2):
     _5[((_4 + _8) - _1)] = self.__nativeidxs[self.__tril_1lin_1idx_J((_0[_8] - _3))]
   else:
    for _9 in range(_1,_2):
     _10=self.__tril_1lin_1idx_J((_0[_9] - _3))
     _11=self.__tril_1idx_J((_0[_9] - _3))
     if (not self.__idxmap._hasItem_J(_10)):
      _12=self._model._append_1rangedvar_Lmosek_4fusion_4ModelVariable_2JDD(self,_11,self.__dom._get_1lb_1item_J(_11),self.__dom._get_1ub_1item_J(_11))
      self.__idxmap._setItem_JI(_11,_12)
      _5[((_4 + _9) - _1)] = _12
      self.__names_flushed = False
     else:
      _5[((_4 + _9) - _1)] = self.__idxmap._getItem_J(_11)
  @staticmethod
  def _match_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match_J__(_0) and __arg_match_J__(_1) and __arg_match__3I__(_2) and __arg_match__3I__(_3) and __arg_match__3I__(_4))
  @staticmethod
  def _match_alt_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_J__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match__3I__(_3) and __arg_alt_match__3I__(_4))
  def _inst_alt_JJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst_JJ_3I_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst_JJ_3I_3I_3I(self,_0,_1,_2,_3,_4):
   if ((_0 < 0) or (_0 >= (self._shape_p._size))):
    raise mosek_fusion_IndexError._ctor_S("Index out of bounds")
   _5=self.__tril_1lin_1idx_J(_0)
   _6=self.__tril_1idx_J(_0)
   if (self.__nativeidxs is not None):
    _2[_1] = self.__nativeidxs[_5]
   else:
    if (not self.__idxmap._hasItem_J(_6)):
     _7=self
     _8=self._model._append_1rangedvar_Lmosek_4fusion_4ModelVariable_2JDD(_7,_5,self.__dom._get_1lb_1item_J(_6),self.__dom._get_1ub_1item_J(_6))
     self.__idxmap._setItem_JI(_6,_8)
     _2[_1] = _8
     self.__names_flushed = False
    else:
     _2[_1] = self.__idxmap._getItem_J(_6)
  def _dual_1u_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1u_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1u_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   _5=1
   _6=int((_2).shape[0])
   _7=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
   _8=self._model._getSolution_1sux_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   for _9 in range(0,_6):
    _5 = (_5 * _1[_9])
   if (self.__nativeidxs is not None):
    for _10 in range(0,_5):
     _11=self.__nativeidxs[self.__tril_1lin_1idx_J(_7.get())]
     _4[(_10 + _3)] = _8[_11]
     _7.inc()
   else:
    _12=self._model.getPrimalSolutionStatus()
    for _13 in range(0,numpy.int32(_5)):
     _14=self.__tril_1idx_J(_7.get())
     if self.__idxmap._hasItem_J(_14):
      _15=self.__idxmap._getItem_J(_14)
      _4[_13] = _8[_15]
     else:
      if ((_12==mosek.fusion.SolutionStatus.Optimal) or ((_12==mosek.fusion.SolutionStatus.NearOptimal) or ((_12==mosek.fusion.SolutionStatus.Feasible) or (_12==mosek.fusion.SolutionStatus.NearFeasible)))):
       _4[(_3 + _13)] = self.__dom._get_1ub_1item_J(_14)
      else:
       _4[(_3 + _13)] = 0.0
     _7.inc()
  def _dual_1u_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1u__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1u__3JI_3D(self,_0,_1,_2):
   _3=self._model._getSolution_1sux_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   if (self.__nativeidxs is not None):
    for _4 in range(0,int((_0).shape[0])):
     _5=self.__nativeidxs[self.__tril_1lin_1idx_J(_0[_4])]
     _2[(_1 + _4)] = _3[_5]
   else:
    _6=self._model.getPrimalSolutionStatus()
    for _7 in range(0,int((_0).shape[0])):
     _8=self.__tril_1idx_J(_0[_7])
     if self.__idxmap._hasItem_J(_8):
      _9=self.__idxmap._getItem_J(_8)
      _2[(_1 + _7)] = _3[_9]
     else:
      if ((_6==mosek.fusion.SolutionStatus.Optimal) or ((_6==mosek.fusion.SolutionStatus.NearOptimal) or ((_6==mosek.fusion.SolutionStatus.Feasible) or (_6==mosek.fusion.SolutionStatus.NearFeasible)))):
       _2[(_1 + _7)] = self.__dom._get_1ub_1item_J(_8)
      else:
       _2[(_1 + _7)] = 0.0
  def _dual_1l_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1l_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1l_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   _5=1
   _6=int((_2).shape[0])
   _7=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
   _8=self._model._getSolution_1slx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   for _9 in range(0,_6):
    _5 = (_5 * _1[_9])
   if (self.__nativeidxs is not None):
    for _10 in range(0,_5):
     _11=self.__nativeidxs[self.__tril_1lin_1idx_J(_7.get())]
     _4[(_10 + _3)] = _8[_11]
     _7.inc()
   else:
    _12=self._model.getPrimalSolutionStatus()
    for _13 in range(0,numpy.int32(_5)):
     _14=self.__tril_1idx_J(_7.get())
     if self.__idxmap._hasItem_J(_14):
      _15=self.__idxmap._getItem_J(_14)
      _4[_13] = _8[_15]
     else:
      if ((_12==mosek.fusion.SolutionStatus.Optimal) or ((_12==mosek.fusion.SolutionStatus.NearOptimal) or ((_12==mosek.fusion.SolutionStatus.Feasible) or (_12==mosek.fusion.SolutionStatus.NearFeasible)))):
       _4[(_3 + _13)] = self.__dom._get_1ub_1item_J(_14)
      else:
       _4[(_3 + _13)] = 0.0
     _7.inc()
  def _dual_1l_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1l__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1l__3JI_3D(self,_0,_1,_2):
   _3=self._model._getSolution_1slx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   if (self.__nativeidxs is not None):
    for _4 in range(0,int((_0).shape[0])):
     _5=self.__nativeidxs[self.__tril_1lin_1idx_J(_0[_4])]
     _2[(_1 + _4)] = _3[_5]
   else:
    _6=self._model.getPrimalSolutionStatus()
    for _7 in range(0,int((_0).shape[0])):
     if self.__idxmap._hasItem_J(_0[_7]):
      _8=self.__nativeidxs[self.__tril_1lin_1idx_J(_0[_7])]
      _2[(_1 + _7)] = _3[_8]
     else:
      if ((_6==mosek.fusion.SolutionStatus.Optimal) or ((_6==mosek.fusion.SolutionStatus.NearOptimal) or ((_6==mosek.fusion.SolutionStatus.Feasible) or (_6==mosek.fusion.SolutionStatus.NearFeasible)))):
       _2[(_1 + _7)] = self.__dom._get_1ub_1item_J(self.__tril_1idx_J(_0[_7]))
      else:
       _2[(_1 + _7)] = 0.0
  def __dual_1values_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self.__dual_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def __dual_1values_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   _5=1
   _6=int((_2).shape[0])
   _7=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
   _8=self._model._getSolution_1slx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   _9=self._model._getSolution_1sux_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   for _10 in range(0,_6):
    _5 = (_5 * _1[_10])
   if (self.__nativeidxs is not None):
    for _11 in range(0,_5):
     _12=self.__nativeidxs[self.__tril_1lin_1idx_J(_7.get())]
     _4[(_11 + _3)] = (_8[_12] - _9[_12])
     _7.inc()
   else:
    _13=self._model.getPrimalSolutionStatus()
    for _14 in range(0,numpy.int32(_5)):
     if self.__idxmap._hasItem_J(_7.get()):
      _15=self.__idxmap._getItem_J(self.__tril_1idx_J(_7.get()))
      _4[_14] = (_8[_15] - _9[_15])
     else:
      if ((_13==mosek.fusion.SolutionStatus.Optimal) or ((_13==mosek.fusion.SolutionStatus.NearOptimal) or ((_13==mosek.fusion.SolutionStatus.Feasible) or (_13==mosek.fusion.SolutionStatus.NearFeasible)))):
       _4[(_3 + _14)] = self.__dom._get_1ub_1item_J(self.__tril_1idx_J(_7.get()))
      else:
       _4[(_3 + _14)] = 0.0
     _7.inc()
  def __dual_1values_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self.__dual_1values__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def __dual_1values__3JI_3D(self,_0,_1,_2):
   _3=self._model._getSolution_1slx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   _4=self._model._getSolution_1sux_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   if (self.__nativeidxs is not None):
    for _5 in range(0,int((_0).shape[0])):
     _6=self.__nativeidxs[self.__tril_1lin_1idx_J(_0[_5])]
     _2[(_1 + _5)] = (_3[_6] - _4[_6])
   else:
    _7=self._model.getPrimalSolutionStatus()
    for _8 in range(0,int((_0).shape[0])):
     if self.__idxmap._hasItem_J(self.__tril_1idx_J(_0[_8])):
      _9=self.__idxmap._getItem_J(self.__tril_1idx_J(_0[_8]))
      _2[(_1 + _8)] = (_3[_9] - _4[_9])
     else:
      if ((_7==mosek.fusion.SolutionStatus.Optimal) or ((_7==mosek.fusion.SolutionStatus.NearOptimal) or ((_7==mosek.fusion.SolutionStatus.Feasible) or (_7==mosek.fusion.SolutionStatus.NearFeasible)))):
       _2[(_1 + _8)] = self.__dom._get_1ub_1item_J(self.__tril_1idx_J(_0[_8]))
      else:
       _2[(_1 + _8)] = 0.0
  @staticmethod
  def _match_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _set_1values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._set_1values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   if _5:
    _6=1
    _7=int((_2).shape[0])
    _8=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
    for _9 in range(0,_7):
     _6 = (_6 * _1[_9])
    if (self.__nativeidxs is not None):
     _10=int((self.__nativeidxs).shape[0])
     _11=numpy.array([self.__nativeidxs[self.__tril_1lin_1idx_J(_8.next())] for _12 in range(0,_6)], dtype=numpy.dtype(numpy.int32))
     _13=(numpy.array([_4[(_3 + _14)] for _14 in range(0,_10)], dtype=numpy.dtype(numpy.float64)) if ((_3 > 0) ) else _4)
     self._model._setSolution_1xx__3I_3D(_11,_13)
    else:
     _15=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int32))
     for _16 in range(0,_6):
      self.inst(_8.next(),_16,_15,None,None)
     _17=numpy.array([_4[(_3 + _18)] for _18 in range(0,_6)], dtype=numpy.dtype(numpy.float64))
     self._model._setSolution_1xx__3I_3D(_15,_17)
   else:
    pass
  @staticmethod
  def _match_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _set_1values_alt__3J_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1 = self._set_1values__3J_3DZ(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values__3J_3DZ(self,_0,_1,_2):
   if _2:
    if (self.__nativeidxs is not None):
     _3=int((self.__nativeidxs).shape[0])
     _4=numpy.array([self.__nativeidxs[self.__tril_1lin_1idx_J(_0[_5])] for _5 in range(0,_3)], dtype=numpy.dtype(numpy.int32))
     _6=numpy.array([_1[_7] for _7 in range(0,_3)], dtype=numpy.dtype(numpy.float64))
     self._model._setSolution_1xx__3I_3D(_4,_6)
    else:
     _8=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
     for _9 in range(0,int((_0).shape[0])):
      self.inst(_0[_9],_9,_8,None,None)
     _10=numpy.array([_1[_11] for _11 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.float64))
     self._model._setSolution_1xx__3I_3D(_8,_10)
   else:
    pass
  @staticmethod
  def _match_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   if _5:
    _6=1
    _7=int((_2).shape[0])
    _8=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
    _9=self._model._getSolution_1xx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    for _10 in range(0,_7):
     _6 = (_6 * _1[_10])
    if (self.__nativeidxs is not None):
     for _11 in range(0,_6):
      _4[(_11 + _3)] = _9[self.__nativeidxs[self.__tril_1lin_1idx_J(_8.get())]]
      _8.inc()
    else:
     _12=self._model.getPrimalSolutionStatus()
     for _13 in range(0,numpy.int32(_6)):
      if self.__idxmap._hasItem_J(_8.get()):
       _4[_13] = _9[self.__idxmap._getItem_J(self.__tril_1idx_J(_8.get()))]
      else:
       if ((_12==mosek.fusion.SolutionStatus.Optimal) or ((_12==mosek.fusion.SolutionStatus.NearOptimal) or ((_12==mosek.fusion.SolutionStatus.Feasible) or (_12==mosek.fusion.SolutionStatus.NearFeasible)))):
        _4[(_3 + _13)] = self.__dom._get_1lb_1item_J(self.__tril_1idx_J(_8.get()))
       else:
        _4[(_3 + _13)] = 0.0
      _8.inc()
   else:
    self.__dual_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
  @staticmethod
  def _match_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match__3D__(_2) and __arg_match_Z__(_3))
  @staticmethod
  def _match_alt_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_Z__(_3))
  def _values_alt__3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_t__3
   _1 = self._values__3JI_3DZ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values__3JI_3DZ(self,_0,_1,_2,_3):
   if _3:
    _4=self._model._getSolution_1xx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    if (self.__nativeidxs is not None):
     for _5 in range(0,int((_0).shape[0])):
      _2[(_1 + _5)] = _4[self.__nativeidxs[self.__tril_1lin_1idx_J(_0[_5])]]
    else:
     _6=self._model.getPrimalSolutionStatus()
     if ((_6==mosek.fusion.SolutionStatus.Optimal) or ((_6==mosek.fusion.SolutionStatus.NearOptimal) or ((_6==mosek.fusion.SolutionStatus.Feasible) or (_6==mosek.fusion.SolutionStatus.NearFeasible)))):
      for _7 in range(0,int((_0).shape[0])):
       _8=_0[_7]
       if self.__idxmap._hasItem_J(_8):
        _2[(_1 + _7)] = _4[self.__idxmap._getItem_J(_8)]
       else:
        _2[(_1 + _7)] = self.__dom._get_1lb_1item_J(_8)
     else:
      for _9 in range(0,int((_0).shape[0])):
       if self.__idxmap._hasItem_J(_0[_9]):
        _2[(_1 + _9)] = _4[self.__idxmap._getItem_J(_0[_9])]
       else:
        _2[(_1 + _9)] = 0.0
   else:
    self.__dual_1values__3JI_3D(_0,_1,_2)
  def __tril_1idx_alt_J(self,_t__0):
    return self.__tril_1idx_J(numpy.int64(__0))
  def __tril_1idx_J(self,_0):
   _1=(_0 // self._dim)
   _2=(_0 % self._dim)
   if (_2 > _1):
    return numpy.int64(((_2 * self._dim) + _1))
   else:
    return numpy.int64(_0)
  def __tril_1lin_1idx_alt_J(self,_t__0):
    return self.__tril_1lin_1idx_J(numpy.int64(__0))
  def __tril_1lin_1idx_J(self,_0):
   _1=(_0 // self._dim)
   _2=(_0 % self._dim)
   if (_2 > _1):
    return numpy.int64((((_2 * (_2 + 1)) // 2) + _1))
   else:
    return numpy.int64((((_1 * (_1 + 1)) // 2) + _2))
  @staticmethod
  def _match_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1continuous_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1continuous__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1continuous__3J(self,_0):
   if (self.__nativeidxs is not None):
    self.getModel()._task_1var_1putcontlist__3I(numpy.array([self.__nativeidxs[_0[_1]] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32)))
   else:
    _2=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
    self.inst(_0,0,int((_0).shape[0]),0,0,_2,None,None)
    self.getModel()._task_1var_1putcontlist__3I(_2)
  @staticmethod
  def _match_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1integer_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1integer__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1integer__3J(self,_0):
   if (self.__nativeidxs is not None):
    self.getModel()._task_1var_1putintlist__3I(numpy.array([self.__nativeidxs[_0[_1]] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32)))
   else:
    _2=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
    self.inst(_0,0,int((_0).shape[0]),0,0,_2,None,None)
    self.getModel()._task_1var_1putintlist__3I(_2)
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_SymRangedVariable._ctor_Lmosek_4fusion_4SymRangedVariable_2Lmosek_4fusion_4Model_2(self,_0))
 return SymRangedVariable
mosek_fusion_SymRangedVariable=__mk_mosek_fusion_SymRangedVariable()
del __mk_mosek_fusion_SymRangedVariable
#BEFORE CLASS
def __mk_mosek_fusion_RangedVariable():
 class RangedVariable(mosek_fusion_ModelVariable):
  __slots__ = ['_RangedVariable__names_flushed','_RangedVariable__nativeidxs','_RangedVariable__dom','_RangedVariable__idxmap']
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_RangedVariable._match_make_1integer__3J(*args): # []int64
      return self._make_1integer__3J(*args)
    elif mosek_fusion_RangedVariable._match_alt_make_1integer__3J(*args): # []int64
      return self._make_1integer_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedVariable.make_integer(array(int64,ndim=1))')
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_RangedVariable._match_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values__3J_3DZ(*args)
    elif mosek_fusion_RangedVariable._match_alt_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values_alt__3J_3DZ(*args)
    elif mosek_fusion_RangedVariable._match_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_RangedVariable._match_alt_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedVariable.set_values(array(int64,ndim=1),array(double,ndim=1),bool)\n\tmosek.fusion.RangedVariable.set_values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_RangedVariable._match_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_JJ_3I_3I_3I(*args)
    elif mosek_fusion_RangedVariable._match_alt_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt_JJ_3I_3I_3I(*args)
    elif mosek_fusion_RangedVariable._match_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst__3JIIJJ_3I_3I_3I(*args)
    elif mosek_fusion_RangedVariable._match_alt_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt__3JIIJJ_3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedVariable.inst(int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.RangedVariable.inst(array(int64,ndim=1),int32,int32,int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def elementDesc(self,*args):
    if False: pass
    elif mosek_fusion_RangedVariable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_RangedVariable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def values(self,*args):
    if False: pass
    elif mosek_fusion_RangedVariable._match_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_I_3DZ(*args)
    elif mosek_fusion_RangedVariable._match_alt_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_alt_I_3DZ(*args)
    elif mosek_fusion_RangedVariable._match_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values__3JI_3DZ(*args)
    elif mosek_fusion_RangedVariable._match_alt_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values_alt__3JI_3DZ(*args)
    elif mosek_fusion_RangedVariable._match_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_RangedVariable._match_alt_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedVariable.values(int32,array(double,ndim=1),bool)\n\tmosek.fusion.RangedVariable.values(array(int64,ndim=1),int32,array(double,ndim=1),bool)\n\tmosek.fusion.RangedVariable.values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def upperBoundVar(self,*args):
    if False: pass
    elif mosek_fusion_RangedVariable._match_upperBoundVar_(*args): # 
      return self._upperBoundVar_(*args)
    elif mosek_fusion_RangedVariable._match_alt_upperBoundVar_(*args): # 
      return self._upperBoundVar_alt_(*args)
    else:
      raise ValueError('Invalid argument list upperBoundVar('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedVariable.upperBoundVar()')
  def lowerBoundVar(self,*args):
    if False: pass
    elif mosek_fusion_RangedVariable._match_lowerBoundVar_(*args): # 
      return self._lowerBoundVar_(*args)
    elif mosek_fusion_RangedVariable._match_alt_lowerBoundVar_(*args): # 
      return self._lowerBoundVar_alt_(*args)
    else:
      raise ValueError('Invalid argument list lowerBoundVar('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedVariable.lowerBoundVar()')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_RangedVariable._match_make_1continuous__3J(*args): # []int64
      return self._make_1continuous__3J(*args)
    elif mosek_fusion_RangedVariable._match_alt_make_1continuous__3J(*args): # []int64
      return self._make_1continuous_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedVariable.make_continuous(array(int64,ndim=1))')
  def __repr__(self): return 'mosek.fusion.RangedVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = RangedVariable.__new__(RangedVariable)
    o._ctor_init_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4RangedVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4RangedVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__dom = (v.__dom)
   self.__idxmap = ((v.__idxmap)._clone_() if (((v.__idxmap) is not None) ) else None)
   self.__nativeidxs = (numpy.array([(v.__nativeidxs)[_0] for _0 in range(0,int(((v.__nativeidxs)).shape[0]))], dtype=numpy.dtype(numpy.int32)) if (((v.__nativeidxs) is not None) ) else None)
   self.__names_flushed = (v.__names_flushed)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2_3IJ(model_,name_,shape_p,dom_,nativeidxs_,varid_):
    o = RangedVariable.__new__(RangedVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2_3IJ(model_,name_,shape_p,dom_,nativeidxs_,varid_)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2_3IJ(*args):
    if len(args) != 6: return False
    model_,name_,shape_p,dom_,nativeidxs_,varid_, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model_) and __arg_match_S__(name_) and __arg_match_Lmosek_4fusion_4Set_2__(shape_p) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(dom_) and __arg_match__3I__(nativeidxs_) and __arg_match_J__(varid_))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2_3IJ(*args):
    if len(args) != 6: return False
    model_,name_,shape_p,dom_,nativeidxs_,varid_, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model_) and __arg_alt_match_S__(name_) and __arg_alt_match_Lmosek_4fusion_4Set_2__(shape_p) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(dom_) and __arg_alt_match__3I__(nativeidxs_) and __arg_alt_match_J__(varid_))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2_3IJ(self,model_,name_,shape_p,dom_,nativeidxs_,varid_):
    self._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2_3IJ(model_,name_,shape_p,dom_,numpy.array(nativeidxs_,dtype=numpy.dtype(numpy.int32)),numpy.int64(varid_))
  def _ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2Lmosek_4fusion_4RangeDomain_2_3IJ(self,model_,name_,shape_p,dom_,nativeidxs_,varid_):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2J(self,model_,name_,shape_p,varid_)
   self.__nativeidxs = nativeidxs_
   if (nativeidxs_ is None):
    self.__idxmap = mosek.fusion.Utils.IntMap()
   else:
    self.__idxmap = None
   self.__dom = dom_
   self.__names_flushed = False
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   self.elementName(_0,_1)
   self.__dom._domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(_0,_1)
   return (_1)
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   if ((not self.__names_flushed) and (int(len(self._name)) > 0)):
    if (self.__nativeidxs is not None):
     for _0 in range(0,int((self.__nativeidxs).shape[0])):
      self._model._varname_IS(self.__nativeidxs[_0],mosek.fusion.Utils.StringBuffer()._a_S(self._name)._a_S("[")._a_S(self._shape_p.getname(_0))._a_S("]")._toString_())
    else:
     _1=self.__idxmap._keys_()
     _2=self.__idxmap._values_()
     for _3 in range(0,int((_1).shape[0])):
      self._model._varname_IS(_2[_3],mosek.fusion.Utils.StringBuffer()._a_S(self._name)._a_S("[")._a_S(self._shape_p.getname(_3))._a_S("]")._toString_())
    self.__names_flushed = True
  @staticmethod
  def _match_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match__3I__(_5) and __arg_match__3I__(_6) and __arg_match__3I__(_7))
  @staticmethod
  def _match_alt_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match__3I__(_5) and __arg_alt_match__3I__(_6) and __arg_alt_match__3I__(_7))
  def _inst_alt__3JIIJJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int32))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.int32))
   _7=numpy.array(_t__7,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst__3JIIJJ_3I_3I_3I(_0,_1,_2,_3,_4,_5,_6,_7)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__7[:] = _7
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst__3JIIJJ_3I_3I_3I(self,_0,_1,_2,_3,_4,_5,_6,_7):
   if (self.__nativeidxs is not None):
    for _8 in range(_1,_2):
     _5[((_4 + _8) - _1)] = self.__nativeidxs[_0[(_8 - _3)]]
   else:
    for _9 in range(_1,_2):
     if (not self.__idxmap._hasItem_J(_0[(numpy.int64(_9) - _3)])):
      _10=self._model._append_1rangedvar_Lmosek_4fusion_4ModelVariable_2JDD(self,_0[(_9 - _3)],self.__dom._get_1lb_1item_J(_0[(_9 - _3)]),self.__dom._get_1ub_1item_J(_0[(_9 - _3)]))
      self.__idxmap._setItem_JI(_0[(_9 - _3)],_10)
      _5[((_4 + _9) - _1)] = _10
      self.__names_flushed = False
     else:
      _5[((_4 + _9) - _1)] = self.__idxmap._getItem_J(_0[(numpy.int64(_9) - _3)])
  @staticmethod
  def _match_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match_J__(_0) and __arg_match_J__(_1) and __arg_match__3I__(_2) and __arg_match__3I__(_3) and __arg_match__3I__(_4))
  @staticmethod
  def _match_alt_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_J__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match__3I__(_3) and __arg_alt_match__3I__(_4))
  def _inst_alt_JJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst_JJ_3I_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst_JJ_3I_3I_3I(self,_0,_1,_2,_3,_4):
   if ((_0 < 0) or (_0 >= (self._shape_p._size))):
    raise mosek_fusion_IndexError._ctor_S("Index out of bounds")
   if (self.__nativeidxs is not None):
    _2[_1] = self.__nativeidxs[_0]
   else:
    if (not self.__idxmap._hasItem_J(_0)):
     _5=self
     _6=self._model._append_1rangedvar_Lmosek_4fusion_4ModelVariable_2JDD(_5,_0,self.__dom._get_1lb_1item_J(_0),self.__dom._get_1ub_1item_J(_0))
     self.__idxmap._setItem_JI(_0,_6)
     _2[_1] = _6
     self.__names_flushed = False
    else:
     _2[_1] = self.__idxmap._getItem_J(_0)
  @staticmethod
  def _match_upperBoundVar_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_upperBoundVar_(*args):
    if len(args) != 0: return False
    return True
  def _upperBoundVar_alt_(self,):
    return self._upperBoundVar_()
  def _upperBoundVar_(self,):
   _0=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int64))
   _0[((self._shape_p.nd) - 1)] = 1
   _1=((self._shape_p.nd) - 1)
   while (_1 > 0):
    _0[(_1 - 1)] = (_0[_1] * numpy.int64(self._shape_p.dim(_1)))
    _1 -= 1
   return (mosek_fusion_BoundInterfaceVariable._ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Set_2J_3JZ(self,self._shape_p,0,_0,False))
  @staticmethod
  def _match_lowerBoundVar_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_lowerBoundVar_(*args):
    if len(args) != 0: return False
    return True
  def _lowerBoundVar_alt_(self,):
    return self._lowerBoundVar_()
  def _lowerBoundVar_(self,):
   _0=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int64))
   _0[((self._shape_p.nd) - 1)] = 1
   _1=((self._shape_p.nd) - 1)
   while (_1 > 0):
    _0[(_1 - 1)] = (_0[_1] * self._shape_p.dim(_1))
    _1 -= 1
   return (mosek_fusion_BoundInterfaceVariable._ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Set_2J_3JZ(self,self._shape_p,0,_0,True))
  def _dual_1u_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1u_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1u_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   _5=1
   _6=int((_2).shape[0])
   _7=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
   _8=self._model._getSolution_1sux_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   for _9 in range(0,_6):
    _5 = (_5 * _1[_9])
   if (self.__nativeidxs is not None):
    for _10 in range(0,_5):
     _11=self.__nativeidxs[_7.get()]
     _4[(_10 + _3)] = _8[_11]
     _7.inc()
   else:
    _12=self._model.getPrimalSolutionStatus()
    for _13 in range(0,numpy.int32(_5)):
     if self.__idxmap._hasItem_J(_7.get()):
      _14=self.__idxmap._getItem_J(_7.get())
      _4[_13] = _8[_14]
     else:
      if ((_12==mosek.fusion.SolutionStatus.Optimal) or ((_12==mosek.fusion.SolutionStatus.NearOptimal) or ((_12==mosek.fusion.SolutionStatus.Feasible) or (_12==mosek.fusion.SolutionStatus.NearFeasible)))):
       _4[(_3 + _13)] = self.__dom._get_1ub_1item_J(_7.get())
      else:
       _4[(_3 + _13)] = 0.0
     _7.inc()
  def _dual_1u_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1u__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1u__3JI_3D(self,_0,_1,_2):
   _3=self._model._getSolution_1sux_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   if (self.__nativeidxs is not None):
    for _4 in range(0,int((_0).shape[0])):
     _5=self.__nativeidxs[_0[_4]]
     _2[(_1 + _4)] = _3[_5]
   else:
    _6=self._model.getPrimalSolutionStatus()
    for _7 in range(0,int((_0).shape[0])):
     if self.__idxmap._hasItem_J(_0[_7]):
      _8=self.__idxmap._getItem_J(_0[_7])
      _2[(_1 + _7)] = _3[_8]
     else:
      if ((_6==mosek.fusion.SolutionStatus.Optimal) or ((_6==mosek.fusion.SolutionStatus.NearOptimal) or ((_6==mosek.fusion.SolutionStatus.Feasible) or (_6==mosek.fusion.SolutionStatus.NearFeasible)))):
       _2[(_1 + _7)] = self.__dom._get_1ub_1item_J(_0[_7])
      else:
       _2[(_1 + _7)] = 0.0
  def _dual_1l_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1l_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1l_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   _5=1
   _6=int((_2).shape[0])
   _7=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
   _8=self._model._getSolution_1slx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   for _9 in range(0,_6):
    _5 = (_5 * _1[_9])
   if (self.__nativeidxs is not None):
    for _10 in range(0,_5):
     _11=self.__nativeidxs[_7.get()]
     _4[(_10 + _3)] = _8[_11]
     _7.inc()
   else:
    _12=self._model.getPrimalSolutionStatus()
    for _13 in range(0,numpy.int32(_5)):
     if self.__idxmap._hasItem_J(_7.get()):
      _14=self.__idxmap._getItem_J(_7.get())
      _4[_13] = _8[_14]
     else:
      if ((_12==mosek.fusion.SolutionStatus.Optimal) or ((_12==mosek.fusion.SolutionStatus.NearOptimal) or ((_12==mosek.fusion.SolutionStatus.Feasible) or (_12==mosek.fusion.SolutionStatus.NearFeasible)))):
       _4[(_3 + _13)] = self.__dom._get_1ub_1item_J(_7.get())
      else:
       _4[(_3 + _13)] = 0.0
     _7.inc()
  def _dual_1l_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1l__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1l__3JI_3D(self,_0,_1,_2):
   _3=self._model._getSolution_1slx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   if (self.__nativeidxs is not None):
    for _4 in range(0,int((_0).shape[0])):
     _5=self.__nativeidxs[_0[_4]]
     _2[(_1 + _4)] = _3[_5]
   else:
    _6=self._model.getPrimalSolutionStatus()
    for _7 in range(0,int((_0).shape[0])):
     if self.__idxmap._hasItem_J(_0[_7]):
      _8=self.__idxmap._getItem_J(_0[_7])
      _2[(_1 + _7)] = _3[_8]
     else:
      if ((_6==mosek.fusion.SolutionStatus.Optimal) or ((_6==mosek.fusion.SolutionStatus.NearOptimal) or ((_6==mosek.fusion.SolutionStatus.Feasible) or (_6==mosek.fusion.SolutionStatus.NearFeasible)))):
       _2[(_1 + _7)] = self.__dom._get_1ub_1item_J(_0[_7])
      else:
       _2[(_1 + _7)] = 0.0
  def __dual_1values_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self.__dual_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def __dual_1values_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   _5=1
   _6=int((_2).shape[0])
   _7=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
   _8=self._model._getSolution_1slx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   _9=self._model._getSolution_1sux_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   for _10 in range(0,_6):
    _5 = (_5 * _1[_10])
   if (self.__nativeidxs is not None):
    for _11 in range(0,_5):
     _12=self.__nativeidxs[_7.get()]
     _4[(_11 + _3)] = (_8[_12] - _9[_12])
     _7.inc()
   else:
    _13=self._model.getPrimalSolutionStatus()
    for _14 in range(0,numpy.int32(_5)):
     if self.__idxmap._hasItem_J(_7.get()):
      _15=self.__idxmap._getItem_J(_7.get())
      _4[_14] = (_8[_15] - _9[_15])
     else:
      if ((_13==mosek.fusion.SolutionStatus.Optimal) or ((_13==mosek.fusion.SolutionStatus.NearOptimal) or ((_13==mosek.fusion.SolutionStatus.Feasible) or (_13==mosek.fusion.SolutionStatus.NearFeasible)))):
       _4[(_3 + _14)] = self.__dom._get_1ub_1item_J(_7.get())
      else:
       _4[(_3 + _14)] = 0.0
     _7.inc()
  def __dual_1values_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self.__dual_1values__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def __dual_1values__3JI_3D(self,_0,_1,_2):
   _3=self._model._getSolution_1slx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   _4=self._model._getSolution_1sux_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   if (self.__nativeidxs is not None):
    for _5 in range(0,int((_0).shape[0])):
     _6=self.__nativeidxs[_0[_5]]
     _2[(_1 + _5)] = (_3[_6] - _4[_6])
   else:
    _7=self._model.getPrimalSolutionStatus()
    for _8 in range(0,int((_0).shape[0])):
     if self.__idxmap._hasItem_J(_0[_8]):
      _9=self.__idxmap._getItem_J(_0[_8])
      _2[(_1 + _8)] = (_3[_9] - _4[_9])
     else:
      if ((_7==mosek.fusion.SolutionStatus.Optimal) or ((_7==mosek.fusion.SolutionStatus.NearOptimal) or ((_7==mosek.fusion.SolutionStatus.Feasible) or (_7==mosek.fusion.SolutionStatus.NearFeasible)))):
       _2[(_1 + _8)] = self.__dom._get_1ub_1item_J(_0[_8])
      else:
       _2[(_1 + _8)] = 0.0
  @staticmethod
  def _match_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _set_1values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._set_1values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   if _5:
    _6=1
    _7=int((_2).shape[0])
    _8=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
    for _9 in range(0,_7):
     _6 = (_6 * _1[_9])
    if (self.__nativeidxs is not None):
     _10=int((self.__nativeidxs).shape[0])
     _11=numpy.array([self.__nativeidxs[_8.next()] for _12 in range(0,_6)], dtype=numpy.dtype(numpy.int32))
     _13=(numpy.array([_4[(_3 + _14)] for _14 in range(0,_10)], dtype=numpy.dtype(numpy.float64)) if ((_3 > 0) ) else _4)
     self._model._setSolution_1xx__3I_3D(_11,_13)
    else:
     _15=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int32))
     for _16 in range(0,_6):
      self.inst(_8.next(),_16,_15,None,None)
     _17=numpy.array([_4[(_3 + _18)] for _18 in range(0,_6)], dtype=numpy.dtype(numpy.float64))
     self._model._setSolution_1xx__3I_3D(_15,_17)
   else:
    pass
  @staticmethod
  def _match_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _set_1values_alt__3J_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1 = self._set_1values__3J_3DZ(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values__3J_3DZ(self,_0,_1,_2):
   if _2:
    if (self.__nativeidxs is not None):
     _3=int((self.__nativeidxs).shape[0])
     _4=numpy.array([self.__nativeidxs[_0[_5]] for _5 in range(0,_3)], dtype=numpy.dtype(numpy.int32))
     _6=numpy.array([_1[_7] for _7 in range(0,_3)], dtype=numpy.dtype(numpy.float64))
     self._model._setSolution_1xx__3I_3D(_4,_6)
    else:
     _8=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
     for _9 in range(0,int((_0).shape[0])):
      self.inst(_0[_9],_9,_8,None,None)
     _10=numpy.array([_1[_11] for _11 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.float64))
     self._model._setSolution_1xx__3I_3D(_8,_10)
   else:
    pass
  @staticmethod
  def _match_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   if _5:
    _6=1
    _7=int((_2).shape[0])
    _8=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
    _9=self._model._getSolution_1xx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    for _10 in range(0,_7):
     _6 = (_6 * _1[_10])
    if (self.__nativeidxs is not None):
     for _11 in range(0,_6):
      _4[(_11 + _3)] = _9[self.__nativeidxs[_8.get()]]
      _8.inc()
    else:
     _12=self._model.getPrimalSolutionStatus()
     for _13 in range(0,numpy.int32(_6)):
      if self.__idxmap._hasItem_J(_8.get()):
       _4[_13] = _9[self.__idxmap._getItem_J(_8.get())]
      else:
       if ((_12==mosek.fusion.SolutionStatus.Optimal) or ((_12==mosek.fusion.SolutionStatus.NearOptimal) or ((_12==mosek.fusion.SolutionStatus.Feasible) or (_12==mosek.fusion.SolutionStatus.NearFeasible)))):
        _4[(_3 + _13)] = self.__dom._get_1ub_1item_J(_8.get())
       else:
        _4[(_3 + _13)] = 0.0
      _8.inc()
   else:
    self.__dual_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
  @staticmethod
  def _match_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match__3D__(_2) and __arg_match_Z__(_3))
  @staticmethod
  def _match_alt_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_Z__(_3))
  def _values_alt__3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_t__3
   _1 = self._values__3JI_3DZ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values__3JI_3DZ(self,_0,_1,_2,_3):
   if _3:
    _4=self._model._getSolution_1xx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    if (self.__nativeidxs is not None):
     for _5 in range(0,int((_0).shape[0])):
      _2[(_1 + _5)] = _4[self.__nativeidxs[_0[_5]]]
    else:
     _6=self._model.getPrimalSolutionStatus()
     for _7 in range(0,int((_0).shape[0])):
      if self.__idxmap._hasItem_J(_0[_7]):
       _2[(_1 + _7)] = _4[self.__idxmap._getItem_J(_0[_7])]
      else:
       if ((_6==mosek.fusion.SolutionStatus.Optimal) or ((_6==mosek.fusion.SolutionStatus.NearOptimal) or ((_6==mosek.fusion.SolutionStatus.Feasible) or (_6==mosek.fusion.SolutionStatus.NearFeasible)))):
        _2[(_1 + _7)] = self.__dom._get_1ub_1item_J(_0[_7])
       else:
        _2[(_1 + _7)] = 0.0
   else:
    self.__dual_1values__3JI_3D(_0,_1,_2)
  @staticmethod
  def _match_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1continuous_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1continuous__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1continuous__3J(self,_0):
   if (self.__nativeidxs is not None):
    self.getModel()._task_1var_1putcontlist__3I(numpy.array([self.__nativeidxs[_0[_1]] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32)))
   else:
    _2=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
    self.inst(_0,0,int((_0).shape[0]),0,0,_2,None,None)
    self.getModel()._task_1var_1putcontlist__3I(_2)
  @staticmethod
  def _match_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1integer_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1integer__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1integer__3J(self,_0):
   if (self.__nativeidxs is not None):
    self.getModel()._task_1var_1putintlist__3I(numpy.array([self.__nativeidxs[_0[_1]] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32)))
   else:
    _2=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
    self.inst(_0,0,int((_0).shape[0]),0,0,_2,None,None)
    self.getModel()._task_1var_1putintlist__3I(_2)
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_RangedVariable._ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(self,_0))
 return RangedVariable
mosek_fusion_RangedVariable=__mk_mosek_fusion_RangedVariable()
del __mk_mosek_fusion_RangedVariable
#BEFORE CLASS
def __mk_mosek_fusion_LinearPSDVariable():
 class LinearPSDVariable(mosek_fusion_ModelVariable):
  __slots__ = ['_LinearPSDVariable__numcones','_LinearPSDVariable__coneidx','_LinearPSDVariable__conesize','_LinearPSDVariable__sdpvardim','_LinearPSDVariable__blocksize']
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_LinearPSDVariable._match_make_1integer__3J(*args): # []int64
      return self._make_1integer__3J(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_make_1integer__3J(*args): # []int64
      return self._make_1integer_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearPSDVariable.make_integer(array(int64,ndim=1))')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_LinearPSDVariable._match_make_1continuous__3J(*args): # []int64
      return self._make_1continuous__3J(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_make_1continuous__3J(*args): # []int64
      return self._make_1continuous_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearPSDVariable.make_continuous(array(int64,ndim=1))')
  def values(self,*args):
    if False: pass
    elif mosek_fusion_LinearPSDVariable._match_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_I_3DZ(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_alt_I_3DZ(*args)
    elif mosek_fusion_LinearPSDVariable._match_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values__3JI_3DZ(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values_alt__3JI_3DZ(*args)
    elif mosek_fusion_LinearPSDVariable._match_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearPSDVariable.values(int32,array(double,ndim=1),bool)\n\tmosek.fusion.LinearPSDVariable.values(array(int64,ndim=1),int32,array(double,ndim=1),bool)\n\tmosek.fusion.LinearPSDVariable.values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_LinearPSDVariable._match_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values__3J_3DZ(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values_alt__3J_3DZ(*args)
    elif mosek_fusion_LinearPSDVariable._match_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearPSDVariable.set_values(array(int64,ndim=1),array(double,ndim=1),bool)\n\tmosek.fusion.LinearPSDVariable.set_values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_LinearPSDVariable._match_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_JJ_3I_3I_3I(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt_JJ_3I_3I_3I(*args)
    elif mosek_fusion_LinearPSDVariable._match_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst__3JIIJJ_3I_3I_3I(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt__3JIIJJ_3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearPSDVariable.inst(int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.LinearPSDVariable.inst(array(int64,ndim=1),int32,int32,int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_LinearPSDVariable._match_toString_(*args): # 
      return self._toString_(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_toString_(*args): # 
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearPSDVariable.toString()')
  def __str__(self): return self._toString_()
  def __repr__(self): return 'mosek.fusion.LinearPSDVariable: '+self._toString_()
  @staticmethod
  def _ctor_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = LinearPSDVariable.__new__(LinearPSDVariable)
    o._ctor_init_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4LinearPSDVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearPSDVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__blocksize = (v.__blocksize)
   self.__conesize = (v.__conesize)
   self.__coneidx = (v.__coneidx)
   self.__sdpvardim = (v.__sdpvardim)
   self.__numcones = (v.__numcones)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SILmosek_4fusion_4Set_2IJ(model_,name_,n,shp_,coneidx_,varid_):
    o = LinearPSDVariable.__new__(LinearPSDVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SILmosek_4fusion_4Set_2IJ(model_,name_,n,shp_,coneidx_,varid_)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SILmosek_4fusion_4Set_2IJ(*args):
    if len(args) != 6: return False
    model_,name_,n,shp_,coneidx_,varid_, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model_) and __arg_match_S__(name_) and __arg_match_I__(n) and __arg_match_Lmosek_4fusion_4Set_2__(shp_) and __arg_match_I__(coneidx_) and __arg_match_J__(varid_))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SILmosek_4fusion_4Set_2IJ(*args):
    if len(args) != 6: return False
    model_,name_,n,shp_,coneidx_,varid_, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model_) and __arg_alt_match_S__(name_) and __arg_alt_match_I__(n) and __arg_alt_match_Lmosek_4fusion_4Set_2__(shp_) and __arg_alt_match_I__(coneidx_) and __arg_alt_match_J__(varid_))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SILmosek_4fusion_4Set_2IJ(self,model_,name_,n,shp_,coneidx_,varid_):
    self._ctor_init_Lmosek_4fusion_4Model_2SILmosek_4fusion_4Set_2IJ(model_,name_,numpy.int32(n),shp_,numpy.int32(coneidx_),numpy.int64(varid_))
  def _ctor_init_Lmosek_4fusion_4Model_2SILmosek_4fusion_4Set_2IJ(self,model_,name_,n,shp_,coneidx_,varid_):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2J(self,model_,name_,shp_,varid_)
   self.__blocksize = shp_.dim(0)
   self.__conesize = shp_.dim(0)
   self.__coneidx = coneidx_
   self.__sdpvardim = n
   self.__numcones = 1
   for _0 in range(1,(shp_.nd)):
    self.__numcones *= shp_.dim(_0)
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   pass
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=mosek.fusion.Utils.StringBuffer()
   _0._a_S("PSDVariable(")
   if (int(len(self._name)) > 0):
    _0._a_S("'")._a_S(self._name)._a_S("',")
   _0._a_I(self._shape_p.dim(0))
   for _1 in range(1,(self._shape_p.nd)):
    _0._a_S(",")._a_I(self._shape_p.dim(_1))
   _0._a_S(")")
   return (_0._toString_())
  @staticmethod
  def _match_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match__3I__(_5) and __arg_match__3I__(_6) and __arg_match__3I__(_7))
  @staticmethod
  def _match_alt_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match__3I__(_5) and __arg_alt_match__3I__(_6) and __arg_alt_match__3I__(_7))
  def _inst_alt__3JIIJJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int32))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.int32))
   _7=numpy.array(_t__7,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst__3JIIJJ_3I_3I_3I(_0,_1,_2,_3,_4,_5,_6,_7)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__7[:] = _7
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst__3JIIJJ_3I_3I_3I(self,_0,_1,_2,_3,_4,_5,_6,_7):
   for _8 in range(_1,_2):
    if ((_0[_8] < _3) or (_0[_8] >= ((self._shape_p._size) + _3))):
     raise mosek_fusion_IndexError._ctor_S("Index out of bounds")
   _9=_4
   _10=self.__sdpvardim
   for _11 in range(_1,_2):
    _12=(_0[_11] - _3)
    _13=numpy.int32((_12 // self.__blocksize))
    _14=(_12 % self.__blocksize)
    _5[_9] = (- ((1 + self.__coneidx) + _13))
    _15=numpy.int32(((_10 + 0.5) - mosek.fusion.Utils.Tools._sqrt_D((((_10 + 0.5) * (_10 + 0.5)) - (_14 * 2)))))
    _16=numpy.int32((_14 - ((_15 * (((2 * _10) - _15) - 1)) // 2)))
    if (_16 >= _15):
     _6[_9] = _16
     _7[_9] = _15
    else:
     _6[_9] = _15
     _7[_9] = _16
    _9 += 1
  @staticmethod
  def _match_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match_J__(_0) and __arg_match_J__(_1) and __arg_match__3I__(_2) and __arg_match__3I__(_3) and __arg_match__3I__(_4))
  @staticmethod
  def _match_alt_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_J__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match__3I__(_3) and __arg_alt_match__3I__(_4))
  def _inst_alt_JJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst_JJ_3I_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst_JJ_3I_3I_3I(self,_0,_1,_2,_3,_4):
   if ((_0 < 0) or (_0 >= (self._shape_p._size))):
    raise mosek_fusion_IndexError._ctor_S("Index out of bounds")
   _5=self.__sdpvardim
   _6=numpy.int32((_0 // self.__blocksize))
   _7=(_0 % self.__blocksize)
   _2[_1] = (- ((1 + self.__coneidx) + _6))
   _8=numpy.int32(((_5 + 0.5) - mosek.fusion.Utils.Tools._sqrt_D((((_5 + 0.5) * (_5 + 0.5)) - (_7 * 2)))))
   _9=numpy.int32((_7 - ((_8 * (((2 * _5) + 1) + _8)) // 2)))
   if (_9 >= _8):
    _3[_1] = _9
    _4[_1] = _8
   else:
    _3[_1] = _8
    _4[_1] = _9
  @staticmethod
  def _match_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _set_1values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._set_1values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   raise mosek_fusion_UnimplementedError._ctor_S("Cannot make PSDVariable elements integer")
  @staticmethod
  def _match_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _set_1values_alt__3J_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1 = self._set_1values__3J_3DZ(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values__3J_3DZ(self,_0,_1,_2):
   raise mosek_fusion_UnimplementedError._ctor_S("Cannot make PSDVariable elements integer")
  @staticmethod
  def _match_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   _6=1
   _7=int((_2).shape[0])
   _8=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
   _9=(self._model._getSolution_1barx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default) if (_5 ) else self._model._getSolution_1bars_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default))
   for _10 in range(0,_7):
    _6 = (_6 * _1[_10])
   for _11 in range(0,_6):
    _12=(_8.get() // self.__blocksize)
    _13=(_8.get() % self.__blocksize)
    _4[_11] = _9[(numpy.int64(self.__coneidx) + _12)][_13]
    _8.inc()
  @staticmethod
  def _match_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match__3D__(_2) and __arg_match_Z__(_3))
  @staticmethod
  def _match_alt_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_Z__(_3))
  def _values_alt__3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_t__3
   _1 = self._values__3JI_3DZ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values__3JI_3DZ(self,_0,_1,_2,_3):
   _4=(self._model._getSolution_1barx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default) if (_3 ) else self._model._getSolution_1bars_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default))
   for _5 in range(0,int((_0).shape[0])):
    if ((_0[_5] < 0) or (_0[_5] >= (self._shape_p._size))):
     raise mosek_fusion_IndexError._ctor_S("Index out of bounds")
   for _6 in range(0,int((_0).shape[0])):
    _7=(_0[_6] // self.__blocksize)
    _8=(_0[_6] % self.__blocksize)
    _2[_6] = _4[(numpy.int64(self.__coneidx) + _7)][_8]
  @staticmethod
  def _match_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1continuous_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1continuous__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1continuous__3J(self,_0):
   pass
  @staticmethod
  def _match_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1integer_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1integer__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1integer__3J(self,_0):
   raise mosek_fusion_UnimplementedError._ctor_S("Cannot make PSDVariable elements integer")
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_LinearPSDVariable._ctor_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(self,_0))
 return LinearPSDVariable
mosek_fusion_LinearPSDVariable=__mk_mosek_fusion_LinearPSDVariable()
del __mk_mosek_fusion_LinearPSDVariable
#BEFORE CLASS
def __mk_mosek_fusion_PSDVariable():
 class PSDVariable(mosek_fusion_SymmetricVariable,mosek_fusion_ModelVariable):
  __slots__ = ['_PSDVariable__numcones','_PSDVariable__coneidx','_PSDVariable__conesize']
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_PSDVariable._match_make_1integer__3J(*args): # []int64
      return self._make_1integer__3J(*args)
    elif mosek_fusion_PSDVariable._match_alt_make_1integer__3J(*args): # []int64
      return self._make_1integer_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDVariable.make_integer(array(int64,ndim=1))')
  def elementDesc(self,*args):
    if False: pass
    elif mosek_fusion_PSDVariable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_PSDVariable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_PSDVariable._match_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values__3J_3DZ(*args)
    elif mosek_fusion_PSDVariable._match_alt_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values_alt__3J_3DZ(*args)
    elif mosek_fusion_PSDVariable._match_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_PSDVariable._match_alt_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDVariable.set_values(array(int64,ndim=1),array(double,ndim=1),bool)\n\tmosek.fusion.PSDVariable.set_values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def values(self,*args):
    if False: pass
    elif mosek_fusion_PSDVariable._match_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_I_3DZ(*args)
    elif mosek_fusion_PSDVariable._match_alt_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_alt_I_3DZ(*args)
    elif mosek_fusion_PSDVariable._match_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values__3JI_3DZ(*args)
    elif mosek_fusion_PSDVariable._match_alt_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values_alt__3JI_3DZ(*args)
    elif mosek_fusion_PSDVariable._match_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_PSDVariable._match_alt_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDVariable.values(int32,array(double,ndim=1),bool)\n\tmosek.fusion.PSDVariable.values(array(int64,ndim=1),int32,array(double,ndim=1),bool)\n\tmosek.fusion.PSDVariable.values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_PSDVariable._match_toString_(*args): # 
      return self._toString_(*args)
    elif mosek_fusion_PSDVariable._match_alt_toString_(*args): # 
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDVariable.toString()')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_PSDVariable._match_make_1continuous__3J(*args): # []int64
      return self._make_1continuous__3J(*args)
    elif mosek_fusion_PSDVariable._match_alt_make_1continuous__3J(*args): # []int64
      return self._make_1continuous_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDVariable.make_continuous(array(int64,ndim=1))')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_PSDVariable._match_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_JJ_3I_3I_3I(*args)
    elif mosek_fusion_PSDVariable._match_alt_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt_JJ_3I_3I_3I(*args)
    elif mosek_fusion_PSDVariable._match_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst__3JIIJJ_3I_3I_3I(*args)
    elif mosek_fusion_PSDVariable._match_alt_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt__3JIIJJ_3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDVariable.inst(int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.PSDVariable.inst(array(int64,ndim=1),int32,int32,int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def elementName(self,*args):
    if False: pass
    elif mosek_fusion_PSDVariable._match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_PSDVariable._match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDVariable.elementName(int64,mosek.fusion.Utils.StringBuffer)')
  def __str__(self): return self._toString_()
  def __repr__(self): return 'mosek.fusion.PSDVariable: '+self._toString_()
  @staticmethod
  def _ctor_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = PSDVariable.__new__(PSDVariable)
    o._ctor_init_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4PSDVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4PSDVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__conesize = (v.__conesize)
   self.__coneidx = (v.__coneidx)
   self.__numcones = (v.__numcones)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SIIIJ(model_,name_,conesize_,coneidx_,num_,varid_):
    o = PSDVariable.__new__(PSDVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SIIIJ(model_,name_,conesize_,coneidx_,num_,varid_)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SIIIJ(*args):
    if len(args) != 6: return False
    model_,name_,conesize_,coneidx_,num_,varid_, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model_) and __arg_match_S__(name_) and __arg_match_I__(conesize_) and __arg_match_I__(coneidx_) and __arg_match_I__(num_) and __arg_match_J__(varid_))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SIIIJ(*args):
    if len(args) != 6: return False
    model_,name_,conesize_,coneidx_,num_,varid_, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model_) and __arg_alt_match_S__(name_) and __arg_alt_match_I__(conesize_) and __arg_alt_match_I__(coneidx_) and __arg_alt_match_I__(num_) and __arg_alt_match_J__(varid_))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SIIIJ(self,model_,name_,conesize_,coneidx_,num_,varid_):
    self._ctor_init_Lmosek_4fusion_4Model_2SIIIJ(model_,name_,numpy.int32(conesize_),numpy.int32(coneidx_),numpy.int32(num_),numpy.int64(varid_))
  def _ctor_init_Lmosek_4fusion_4Model_2SIIIJ(self,model_,name_,conesize_,coneidx_,num_,varid_):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2J(self,model_,name_,mosek_fusion_NDSet._ctor_II(conesize_,conesize_),varid_)
   self.__conesize = conesize_
   self.__coneidx = coneidx_
   self.__numcones = num_
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   pass
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=mosek.fusion.Utils.StringBuffer()
   _0._a_S("PSDVariable(")
   if (int(len(self._name)) > 0):
    _0._a_S("'")._a_S(self._name)._a_S("',")
   _0._a_I(self._shape_p.dim(0))
   for _1 in range(1,(self._shape_p.nd)):
    _0._a_S(",")._a_I(self._shape_p.dim(_1))
   _0._a_S(")")
   return (_0._toString_())
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   _2=(numpy.int64(self.__conesize) * numpy.int64(self.__conesize))
   _3=(_0 // _2)
   _4=(_0 % _2)
   _5=(_4 // self.__conesize)
   _6=(_4 % self.__conesize)
   _1._a_S(("_" if ((int(len(self._name))==0) ) else self._name))._a_S("[")._a_J(_3)._a_S(",")._a_J(_5)._a_S(",")._a_J(_6)._a_S("] ")
   if (self.__numcones > 1):
    _1._a_S(" : element (")._a_J(_3)._a_S(",")._a_J(_5)._a_S(",")._a_J(_6)
   else:
    _1._a_S(" : element (")._a_J(_5)._a_S(",")._a_J(_6)
   _1._a_S(") in a semidefinite cone of size (")._a_I(self.__numcones)._a_S(",")._a_I(self.__conesize)._a_S(",")._a_I(self.__conesize)._a_S(")")
   return (_1)
  @staticmethod
  def _match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   _2=(numpy.int64(self.__conesize) * numpy.int64(self.__conesize))
   _3=(_0 // _2)
   _4=(_0 % _2)
   _5=(_4 // self.__conesize)
   _6=(_4 % self.__conesize)
   _1._a_S(("_" if ((int(len(self._name))==0) ) else self._name))._a_S("[")._a_J(_3)._a_S(",")._a_J(_5)._a_S(",")._a_J(_6)._a_S("] ")
  @staticmethod
  def _match_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match__3I__(_5) and __arg_match__3I__(_6) and __arg_match__3I__(_7))
  @staticmethod
  def _match_alt_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match__3I__(_5) and __arg_alt_match__3I__(_6) and __arg_alt_match__3I__(_7))
  def _inst_alt__3JIIJJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int32))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.int32))
   _7=numpy.array(_t__7,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst__3JIIJJ_3I_3I_3I(_0,_1,_2,_3,_4,_5,_6,_7)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__7[:] = _7
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst__3JIIJJ_3I_3I_3I(self,_0,_1,_2,_3,_4,_5,_6,_7):
   for _8 in range(_1,_2):
    if ((_0[_8] < _3) or (_0[_8] >= ((self._shape_p._size) + _3))):
     raise mosek_fusion_IndexError._ctor_S("Index out of bounds")
   _9=_4
   for _10 in range(_1,_2):
    _11=(_0[_10] - _3)
    _12=numpy.int32((_11 // (self.__conesize * self.__conesize)))
    _13=(_11 - ((self.__conesize * self.__conesize) * _12))
    _5[_9] = (- ((1 + self.__coneidx) + _12))
    _14=(numpy.int32(_13) // self._shape_p.dim(1))
    _15=(numpy.int32(_13) - numpy.int32((_14 * self._shape_p.dim(1))))
    if (_14 >= _15):
     _6[_9] = _14
     _7[_9] = _15
    else:
     _6[_9] = _15
     _7[_9] = _14
    _9 += 1
  @staticmethod
  def _match_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match_J__(_0) and __arg_match_J__(_1) and __arg_match__3I__(_2) and __arg_match__3I__(_3) and __arg_match__3I__(_4))
  @staticmethod
  def _match_alt_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_J__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match__3I__(_3) and __arg_alt_match__3I__(_4))
  def _inst_alt_JJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst_JJ_3I_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst_JJ_3I_3I_3I(self,_0,_1,_2,_3,_4):
   if ((_0 < 0) or (_0 >= (self._shape_p._size))):
    raise mosek_fusion_IndexError._ctor_S("Index out of bounds")
   _5=numpy.int32((_0 // (self.__conesize * self.__conesize)))
   _6=(_0 - ((self.__conesize * self.__conesize) * _5))
   _2[_1] = (- ((1 + self.__coneidx) + _5))
   _7=(numpy.int32(_6) // self._shape_p.dim(1))
   _8=(numpy.int32(_6) - numpy.int32((_7 * self._shape_p.dim(1))))
   if (_7 >= _8):
    _3[_1] = _7
    _4[_1] = _8
   else:
    _3[_1] = _8
    _4[_1] = _7
  @staticmethod
  def _match_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _set_1values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._set_1values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   pass
  @staticmethod
  def _match_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _set_1values_alt__3J_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1 = self._set_1values__3J_3DZ(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values__3J_3DZ(self,_0,_1,_2):
   pass
  @staticmethod
  def _match_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   _6=1
   _7=int((_2).shape[0])
   _8=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
   _9=(self._model._getSolution_1barx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default) if (_5 ) else self._model._getSolution_1bars_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default))
   _10=(self.__conesize * self.__conesize)
   for _11 in range(0,_7):
    _6 = (_6 * _1[_11])
   for _12 in range(0,_6):
    _13=(_8.get() // _10)
    _14=(_8.get() - (_13 * _10))
    _15=(_14 // self.__conesize)
    _16=(_14 - (_15 * self.__conesize))
    if (_16 > _15):
     _4[_12] = _9[(numpy.int64(self.__coneidx) + _13)][(((_15 * self.__conesize) + _16) - ((_15 * (_15 + 1)) // 2))]
    else:
     _4[_12] = _9[(numpy.int64(self.__coneidx) + _13)][(((_16 * self.__conesize) + _15) - ((_16 * (_16 + 1)) // 2))]
    _8.inc()
  @staticmethod
  def _match_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match__3D__(_2) and __arg_match_Z__(_3))
  @staticmethod
  def _match_alt_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_Z__(_3))
  def _values_alt__3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_t__3
   _1 = self._values__3JI_3DZ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values__3JI_3DZ(self,_0,_1,_2,_3):
   _4=(self._model._getSolution_1barx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default) if (_3 ) else self._model._getSolution_1bars_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default))
   _5=(self.__conesize * self.__conesize)
   for _6 in range(0,int((_0).shape[0])):
    _7=(_0[_6] // _5)
    _8=(_0[_6] - (_7 * _5))
    _9=(_8 // self.__conesize)
    _10=(_8 - (_9 * self.__conesize))
    if (_10 > _9):
     _2[_6] = _4[(numpy.int64(self.__coneidx) + _7)][(((_9 * self.__conesize) + _10) - ((_9 * (_9 + 1)) // 2))]
    else:
     _2[_6] = _4[(numpy.int64(self.__coneidx) + _7)][(((_10 * self.__conesize) + _9) - ((_10 * (_10 + 1)) // 2))]
  @staticmethod
  def _match_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1continuous_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1continuous__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1continuous__3J(self,_0):
   pass
  @staticmethod
  def _match_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1integer_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1integer__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1integer__3J(self,_0):
   raise mosek_fusion_UnimplementedError._ctor_S("Cannot make PSDVariable elements integer")
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_PSDVariable._ctor_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(self,_0))
 return PSDVariable
mosek_fusion_PSDVariable=__mk_mosek_fusion_PSDVariable()
del __mk_mosek_fusion_PSDVariable
#BEFORE CLASS
def __mk_mosek_fusion_SymLinearVariable():
 class SymLinearVariable(mosek_fusion_SymmetricVariable,mosek_fusion_ModelVariable):
  __slots__ = ['_SymLinearVariable__dim','_SymLinearVariable__names_flushed','_SymLinearVariable__dom','_SymLinearVariable__nativeidxs','_SymLinearVariable__idxmap']
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_SymLinearVariable._match_make_1integer__3J(*args): # []int64
      return self._make_1integer__3J(*args)
    elif mosek_fusion_SymLinearVariable._match_alt_make_1integer__3J(*args): # []int64
      return self._make_1integer_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SymLinearVariable.make_integer(array(int64,ndim=1))')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_SymLinearVariable._match_toString_(*args): # 
      return self._toString_(*args)
    elif mosek_fusion_SymLinearVariable._match_alt_toString_(*args): # 
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SymLinearVariable.toString()')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_SymLinearVariable._match_make_1continuous__3J(*args): # []int64
      return self._make_1continuous__3J(*args)
    elif mosek_fusion_SymLinearVariable._match_alt_make_1continuous__3J(*args): # []int64
      return self._make_1continuous_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SymLinearVariable.make_continuous(array(int64,ndim=1))')
  def values(self,*args):
    if False: pass
    elif mosek_fusion_SymLinearVariable._match_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_I_3DZ(*args)
    elif mosek_fusion_SymLinearVariable._match_alt_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_alt_I_3DZ(*args)
    elif mosek_fusion_SymLinearVariable._match_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values__3JI_3DZ(*args)
    elif mosek_fusion_SymLinearVariable._match_alt_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values_alt__3JI_3DZ(*args)
    elif mosek_fusion_SymLinearVariable._match_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_SymLinearVariable._match_alt_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SymLinearVariable.values(int32,array(double,ndim=1),bool)\n\tmosek.fusion.SymLinearVariable.values(array(int64,ndim=1),int32,array(double,ndim=1),bool)\n\tmosek.fusion.SymLinearVariable.values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_SymLinearVariable._match_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values__3J_3DZ(*args)
    elif mosek_fusion_SymLinearVariable._match_alt_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values_alt__3J_3DZ(*args)
    elif mosek_fusion_SymLinearVariable._match_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_SymLinearVariable._match_alt_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SymLinearVariable.set_values(array(int64,ndim=1),array(double,ndim=1),bool)\n\tmosek.fusion.SymLinearVariable.set_values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_SymLinearVariable._match_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_JJ_3I_3I_3I(*args)
    elif mosek_fusion_SymLinearVariable._match_alt_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt_JJ_3I_3I_3I(*args)
    elif mosek_fusion_SymLinearVariable._match_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst__3JIIJJ_3I_3I_3I(*args)
    elif mosek_fusion_SymLinearVariable._match_alt_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt__3JIIJJ_3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SymLinearVariable.inst(int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.SymLinearVariable.inst(array(int64,ndim=1),int32,int32,int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def __str__(self): return self._toString_()
  def __repr__(self): return 'mosek.fusion.SymLinearVariable: '+self._toString_()
  @staticmethod
  def _ctor_Lmosek_4fusion_4SymLinearVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = SymLinearVariable.__new__(SymLinearVariable)
    o._ctor_init_Lmosek_4fusion_4SymLinearVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4SymLinearVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4SymLinearVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4SymLinearVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4SymLinearVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4SymLinearVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4SymLinearVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4SymLinearVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__nativeidxs = (numpy.array([(v.__nativeidxs)[_0] for _0 in range(0,int(((v.__nativeidxs)).shape[0]))], dtype=numpy.dtype(numpy.int32)) if (((v.__nativeidxs) is not None) ) else None)
   self.__idxmap = ((v.__idxmap)._clone_() if (((v.__idxmap) is not None) ) else None)
   self.__dom = (v.__dom)
   (self.__dim) = (v.__dim)
   self.__names_flushed = (v.__names_flushed)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4SymmetricLinearDomain_2I_3IJ(model,name,dom,dim,nativeidxs,varid):
    o = SymLinearVariable.__new__(SymLinearVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4SymmetricLinearDomain_2I_3IJ(model,name,dom,dim,nativeidxs,varid)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4SymmetricLinearDomain_2I_3IJ(*args):
    if len(args) != 6: return False
    model,name,dom,dim,nativeidxs,varid, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_Lmosek_4fusion_4SymmetricLinearDomain_2__(dom) and __arg_match_I__(dim) and __arg_match__3I__(nativeidxs) and __arg_match_J__(varid))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4SymmetricLinearDomain_2I_3IJ(*args):
    if len(args) != 6: return False
    model,name,dom,dim,nativeidxs,varid, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_Lmosek_4fusion_4SymmetricLinearDomain_2__(dom) and __arg_alt_match_I__(dim) and __arg_alt_match__3I__(nativeidxs) and __arg_alt_match_J__(varid))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4SymmetricLinearDomain_2I_3IJ(self,model,name,dom,dim,nativeidxs,varid):
    self._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4SymmetricLinearDomain_2I_3IJ(model,name,dom,numpy.int32(dim),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)),numpy.int64(varid))
  def _ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4SymmetricLinearDomain_2I_3IJ(self,model,name,dom,dim,nativeidxs,varid):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2J(self,model,name,mosek.fusion.Set._make_II(dim,dim),varid)
   (self.__nativeidxs) = nativeidxs
   self.__idxmap = (mosek.fusion.Utils.IntMap() if (((self.__nativeidxs) is None) ) else None)
   (self.__dom) = dom
   (self.__dim) = dim
   self.__names_flushed = False
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=mosek.fusion.Utils.StringBuffer()
   _0._a_S("SymLinearVariable( (")
   if (int(len(self._name)) > 0):
    _0._a_S("'")._a_S(self._name)._a_S("',")
   _0._a_I(self._shape_p.dim(0))
   for _1 in range(1,(self._shape_p.nd)):
    _0._a_S(",")._a_I(self._shape_p.dim(_1))
   _0._a_S(") )")
   return (_0._toString_())
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   if ((not self.__names_flushed) and (int(len(self._name)) > 0)):
    if (self.__nativeidxs is not None):
     for _0 in range(0,self.__dim):
      for _1 in range(0,(_0 + 1)):
       _2=(((_0 * self.__dim) - ((_0 * (_0 + 1)) // 2)) + _1)
       _3=((_0 * self.__dim) + _1)
       self._model._varname_IS(self.__nativeidxs[_2],("" if ((int(len(self._name))==0) ) else mosek.fusion.Utils.StringBuffer()._a_S(self._name)._a_S("[")._a_S(self._shape_p.getname(_3))._a_S("]")._toString_()))
    else:
     for _4 in range(0,self.__dim):
      for _5 in range(0,(_4 + 1)):
       _6=((_4 * self.__dim) + _5)
       if self.__idxmap._hasItem_J(_6):
        self._model._varname_IS(self.__nativeidxs[self.__idxmap._getItem_J(_6)],("" if ((int(len(self._name))==0) ) else mosek.fusion.Utils.StringBuffer()._a_S(self._name)._a_S("[")._a_S(self._shape_p.getname(_6))._a_S("]")._toString_()))
    self.__names_flushed = True
  @staticmethod
  def _match_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match__3I__(_5) and __arg_match__3I__(_6) and __arg_match__3I__(_7))
  @staticmethod
  def _match_alt_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match__3I__(_5) and __arg_alt_match__3I__(_6) and __arg_alt_match__3I__(_7))
  def _inst_alt__3JIIJJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int32))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.int32))
   _7=numpy.array(_t__7,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst__3JIIJJ_3I_3I_3I(_0,_1,_2,_3,_4,_5,_6,_7)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__7[:] = _7
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst__3JIIJJ_3I_3I_3I(self,_0,_1,_2,_3,_4,_5,_6,_7):
   if (self.__nativeidxs is not None):
    for _8 in range(_1,_2):
     _5[((_4 + _8) - _1)] = self.__nativeidxs[self.__tril_1lin_1idx_J((_0[_8] - _3))]
   else:
    for _9 in range(_1,_2):
     _10=self.__tril_1lin_1idx_J((_0[_9] - _3))
     _11=self.__tril_1idx_J((_0[_9] - _3))
     if (not self.__idxmap._hasItem_J(_11)):
      _12=self._model._append_1linearvar_Lmosek_4fusion_4ModelVariable_2JEmosek_4fusion_4RelationKey_2D(self,_11,(self.__dom._key),self.__dom._get_1rhs_1item_J(_10))
      self.__idxmap._setItem_JI(_11,_12)
      _5[((_4 + _9) - _1)] = _12
      self.__names_flushed = False
     else:
      _5[((_4 + _9) - _1)] = self.__idxmap._getItem_J(_11)
  @staticmethod
  def _match_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match_J__(_0) and __arg_match_J__(_1) and __arg_match__3I__(_2) and __arg_match__3I__(_3) and __arg_match__3I__(_4))
  @staticmethod
  def _match_alt_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_J__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match__3I__(_3) and __arg_alt_match__3I__(_4))
  def _inst_alt_JJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst_JJ_3I_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst_JJ_3I_3I_3I(self,_0,_1,_2,_3,_4):
   _5=self.__tril_1lin_1idx_J(_0)
   _6=self.__tril_1idx_J(_0)
   if (self.__nativeidxs is not None):
    _2[_1] = self.__nativeidxs[_5]
   else:
    if (not self.__idxmap._hasItem_J(_6)):
     _7=self._model._append_1linearvar_Lmosek_4fusion_4ModelVariable_2JEmosek_4fusion_4RelationKey_2D(self,_6,(self.__dom._key),self.__dom._get_1rhs_1item_J(_6))
     self.__idxmap._setItem_JI(_5,_7)
     _2[_1] = _7
    else:
     _2[_1] = self.__idxmap._getItem_J(_5)
  def __dual_1values_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self.__dual_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def __dual_1values_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   _5=1
   _6=int((_2).shape[0])
   _7=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
   _8=self._model._getSolution_1slx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   _9=self._model._getSolution_1sux_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   for _10 in range(0,_6):
    _5 = (_5 * _1[_10])
   if (self.__nativeidxs is not None):
    for _11 in range(0,_5):
     _12=self.__nativeidxs[self.__tril_1lin_1idx_J(_7.get())]
     _4[(_11 + _3)] = (_8[_12] - _9[_12])
     _7.inc()
   else:
    _13=self._model.getPrimalSolutionStatus()
    for _14 in range(0,numpy.int32(_5)):
     if self.__idxmap._hasItem_J(self.__tril_1lin_1idx_J(_7.get())):
      _15=self.__idxmap._getItem_J(_7.get())
      _4[(_3 + _14)] = (_8[_15] - _9[_15])
     else:
      _4[(_3 + _14)] = 0.0
     _7.inc()
  def __dual_1values_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self.__dual_1values__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def __dual_1values__3JI_3D(self,_0,_1,_2):
   _3=self._model._getSolution_1slx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   _4=self._model._getSolution_1sux_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   if (self.__nativeidxs is not None):
    for _5 in range(0,int((_0).shape[0])):
     _6=self.__nativeidxs[self.__tril_1lin_1idx_J(_0[_5])]
     _2[(_1 + _5)] = (_3[_6] - _4[_6])
   else:
    _7=self._model.getPrimalSolutionStatus()
    for _8 in range(0,int((_0).shape[0])):
     if self.__idxmap._hasItem_J(_0[_8]):
      _9=self.__idxmap._getItem_J(_0[_8])
      _2[(_1 + _8)] = (_3[_9] - _4[_9])
     else:
      _2[(_1 + _8)] = 0.0
  @staticmethod
  def _match_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _set_1values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._set_1values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   if _5:
    _6=1
    _7=int((_2).shape[0])
    _8=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
    for _9 in range(0,_7):
     _6 = (_6 * _1[_9])
    if (self.__nativeidxs is not None):
     _10=int((self.__nativeidxs).shape[0])
     _11=numpy.array([self.__nativeidxs[self.__tril_1lin_1idx_J(_8.next())] for _12 in range(0,_6)], dtype=numpy.dtype(numpy.int32))
     _13=(numpy.array([_4[(_3 + _14)] for _14 in range(0,_10)], dtype=numpy.dtype(numpy.float64)) if ((_3 > 0) ) else _4)
     self._model._setSolution_1xx__3I_3D(_11,_13)
    else:
     _15=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int32))
     for _16 in range(0,_6):
      self.inst(_8.next(),_16,_15,None,None)
     _17=numpy.array([_4[(_3 + _18)] for _18 in range(0,_6)], dtype=numpy.dtype(numpy.float64))
     self._model._setSolution_1xx__3I_3D(_15,_17)
   else:
    pass
  @staticmethod
  def _match_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _set_1values_alt__3J_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1 = self._set_1values__3J_3DZ(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values__3J_3DZ(self,_0,_1,_2):
   if _2:
    if (self.__nativeidxs is not None):
     _3=int((self.__nativeidxs).shape[0])
     _4=numpy.array([self.__nativeidxs[self.__tril_1lin_1idx_J(_0[_5])] for _5 in range(0,_3)], dtype=numpy.dtype(numpy.int32))
     _6=numpy.array([_1[_7] for _7 in range(0,_3)], dtype=numpy.dtype(numpy.float64))
     self._model._setSolution_1xx__3I_3D(_4,_6)
    else:
     _8=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
     for _9 in range(0,int((_0).shape[0])):
      self.inst(_0[_9],_9,_8,None,None)
     self._model._setSolution_1xx__3I_3D(_8,_1)
   else:
    pass
  @staticmethod
  def _match_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   if _5:
    _6=1
    _7=int((_2).shape[0])
    _8=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
    _9=self._model._getSolution_1xx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    for _10 in range(0,_7):
     _6 *= _1[_10]
    if (self.__nativeidxs is not None):
     for _11 in range(0,_6):
      _4[(_11 + _3)] = _9[self.__nativeidxs[self.__tril_1lin_1idx_J(_8.get())]]
      _8.inc()
    else:
     _12=self._model.getPrimalSolutionStatus()
     if ((_12==mosek.fusion.SolutionStatus.Optimal) or ((_12==mosek.fusion.SolutionStatus.NearOptimal) or ((_12==mosek.fusion.SolutionStatus.Feasible) or (_12==mosek.fusion.SolutionStatus.NearFeasible)))):
      for _13 in range(0,numpy.int32(_6)):
       if self.__idxmap._hasItem_J(_8.get()):
        _4[(_3 + _13)] = _9[self.__idxmap._getItem_J(_8.get())]
       else:
        _4[(_3 + _13)] = self.__dom._get_1rhs_1item_J(self.__tril_1idx_J(_8.get()))
       _8.inc()
     else:
      for _14 in range(0,numpy.int32(_6)):
       if self.__idxmap._hasItem_J(_8.get()):
        _4[(_3 + _14)] = _9[self.__idxmap._getItem_J(_8.get())]
       else:
        _4[(_3 + _14)] = 0.0
       _8.inc()
   else:
    self.__dual_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
  @staticmethod
  def _match_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match__3D__(_2) and __arg_match_Z__(_3))
  @staticmethod
  def _match_alt_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_Z__(_3))
  def _values_alt__3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_t__3
   _1 = self._values__3JI_3DZ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values__3JI_3DZ(self,_0,_1,_2,_3):
   if _3:
    _4=self._model._getSolution_1xx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    if (self.__nativeidxs is not None):
     for _5 in range(0,int((_0).shape[0])):
      _2[(_1 + _5)] = _4[self.__nativeidxs[self.__tril_1lin_1idx_J(_0[_5])]]
    else:
     _6=self._model.getPrimalSolutionStatus()
     if ((_6==mosek.fusion.SolutionStatus.Optimal) or ((_6==mosek.fusion.SolutionStatus.NearOptimal) or ((_6==mosek.fusion.SolutionStatus.Feasible) or (_6==mosek.fusion.SolutionStatus.NearFeasible)))):
      for _7 in range(0,int((_0).shape[0])):
       _8=_0[_7]
       if self.__idxmap._hasItem_J(_8):
        _2[(_1 + _7)] = _4[self.__idxmap._getItem_J(_8)]
       else:
        _2[(_1 + _7)] = self.__dom._get_1rhs_1item_J(self.__tril_1idx_J(_8))
     else:
      for _9 in range(0,int((_0).shape[0])):
       _10=_0[_9]
       if self.__idxmap._hasItem_J(_10):
        _2[(_1 + _9)] = _4[self.__idxmap._getItem_J(self.__tril_1idx_J(_10))]
       else:
        _2[(_1 + _9)] = 0.0
   else:
    self.__dual_1values__3JI_3D(_0,_1,_2)
  @staticmethod
  def _match_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1continuous_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1continuous__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1continuous__3J(self,_0):
   if (self.__nativeidxs is not None):
    self.getModel()._task_1var_1putcontlist__3I(numpy.array([self.__nativeidxs[_0[_1]] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32)))
   else:
    _2=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
    self.inst(_0,0,int((_0).shape[0]),0,0,_2,None,None)
    self.getModel()._task_1var_1putcontlist__3I(_2)
  @staticmethod
  def _match_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1integer_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1integer__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1integer__3J(self,_0):
   if (self.__nativeidxs is not None):
    self.getModel()._task_1var_1putintlist__3I(numpy.array([self.__nativeidxs[_0[_1]] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32)))
   else:
    _2=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
    self.inst(_0,0,int((_0).shape[0]),0,0,_2,None,None)
    self.getModel()._task_1var_1putintlist__3I(_2)
  def __tril_1idx_alt_J(self,_t__0):
    return self.__tril_1idx_J(numpy.int64(__0))
  def __tril_1idx_J(self,_0):
   _1=(_0 // self.__dim)
   _2=(_0 % self.__dim)
   if (_2 > _1):
    return numpy.int64(((_2 * self.__dim) + _1))
   else:
    return numpy.int64(_0)
  def __tril_1lin_1idx_alt_J(self,_t__0):
    return self.__tril_1lin_1idx_J(numpy.int64(__0))
  def __tril_1lin_1idx_J(self,_0):
   _1=(_0 // self.__dim)
   _2=(_0 % self.__dim)
   if (_2 > _1):
    return numpy.int64((((_2 * (_2 + 1)) // 2) + _1))
   else:
    return numpy.int64((((_1 * (_1 + 1)) // 2) + _2))
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_SymLinearVariable._ctor_Lmosek_4fusion_4SymLinearVariable_2Lmosek_4fusion_4Model_2(self,_0))
 return SymLinearVariable
mosek_fusion_SymLinearVariable=__mk_mosek_fusion_SymLinearVariable()
del __mk_mosek_fusion_SymLinearVariable
#BEFORE CLASS
def __mk_mosek_fusion_LinearVariable():
 class LinearVariable(mosek_fusion_ModelVariable):
  __slots__ = ['_LinearVariable__names_flushed','_LinearVariable__dom','_LinearVariable__nativeidxs','_LinearVariable__idxmap']
  def values(self,*args):
    if False: pass
    elif mosek_fusion_LinearVariable._match_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_I_3DZ(*args)
    elif mosek_fusion_LinearVariable._match_alt_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_alt_I_3DZ(*args)
    elif mosek_fusion_LinearVariable._match_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values__3JI_3DZ(*args)
    elif mosek_fusion_LinearVariable._match_alt_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values_alt__3JI_3DZ(*args)
    elif mosek_fusion_LinearVariable._match_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_LinearVariable._match_alt_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearVariable.values(int32,array(double,ndim=1),bool)\n\tmosek.fusion.LinearVariable.values(array(int64,ndim=1),int32,array(double,ndim=1),bool)\n\tmosek.fusion.LinearVariable.values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_LinearVariable._match_make_1continuous__3J(*args): # []int64
      return self._make_1continuous__3J(*args)
    elif mosek_fusion_LinearVariable._match_alt_make_1continuous__3J(*args): # []int64
      return self._make_1continuous_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearVariable.make_continuous(array(int64,ndim=1))')
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_LinearVariable._match_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values__3J_3DZ(*args)
    elif mosek_fusion_LinearVariable._match_alt_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values_alt__3J_3DZ(*args)
    elif mosek_fusion_LinearVariable._match_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_LinearVariable._match_alt_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearVariable.set_values(array(int64,ndim=1),array(double,ndim=1),bool)\n\tmosek.fusion.LinearVariable.set_values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_LinearVariable._match_make_1integer__3J(*args): # []int64
      return self._make_1integer__3J(*args)
    elif mosek_fusion_LinearVariable._match_alt_make_1integer__3J(*args): # []int64
      return self._make_1integer_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearVariable.make_integer(array(int64,ndim=1))')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_LinearVariable._match_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_JJ_3I_3I_3I(*args)
    elif mosek_fusion_LinearVariable._match_alt_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt_JJ_3I_3I_3I(*args)
    elif mosek_fusion_LinearVariable._match_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst__3JIIJJ_3I_3I_3I(*args)
    elif mosek_fusion_LinearVariable._match_alt_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt__3JIIJJ_3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearVariable.inst(int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.LinearVariable.inst(array(int64,ndim=1),int32,int32,int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def elementDesc(self,*args):
    if False: pass
    elif mosek_fusion_LinearVariable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_LinearVariable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def elementName(self,*args):
    if False: pass
    elif mosek_fusion_LinearVariable._match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_LinearVariable._match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearVariable.elementName(int64,mosek.fusion.Utils.StringBuffer)')
  def __repr__(self): return 'mosek.fusion.LinearVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = LinearVariable.__new__(LinearVariable)
    o._ctor_init_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4LinearVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__nativeidxs = (numpy.array([(v.__nativeidxs)[_0] for _0 in range(0,int(((v.__nativeidxs)).shape[0]))], dtype=numpy.dtype(numpy.int32)) if (((v.__nativeidxs) is not None) ) else None)
   self.__idxmap = ((v.__idxmap)._clone_() if (((v.__idxmap) is not None) ) else None)
   self.__dom = (v.__dom)
   self.__names_flushed = (v.__names_flushed)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4LinearDomain_2Lmosek_4fusion_4Set_2_3IJ(model_,name_,dom_,shape_p,nativeidxs_,varid_):
    o = LinearVariable.__new__(LinearVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4LinearDomain_2Lmosek_4fusion_4Set_2_3IJ(model_,name_,dom_,shape_p,nativeidxs_,varid_)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4LinearDomain_2Lmosek_4fusion_4Set_2_3IJ(*args):
    if len(args) != 6: return False
    model_,name_,dom_,shape_p,nativeidxs_,varid_, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model_) and __arg_match_S__(name_) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(dom_) and __arg_match_Lmosek_4fusion_4Set_2__(shape_p) and __arg_match__3I__(nativeidxs_) and __arg_match_J__(varid_))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4LinearDomain_2Lmosek_4fusion_4Set_2_3IJ(*args):
    if len(args) != 6: return False
    model_,name_,dom_,shape_p,nativeidxs_,varid_, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model_) and __arg_alt_match_S__(name_) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(dom_) and __arg_alt_match_Lmosek_4fusion_4Set_2__(shape_p) and __arg_alt_match__3I__(nativeidxs_) and __arg_alt_match_J__(varid_))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4LinearDomain_2Lmosek_4fusion_4Set_2_3IJ(self,model_,name_,dom_,shape_p,nativeidxs_,varid_):
    self._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4LinearDomain_2Lmosek_4fusion_4Set_2_3IJ(model_,name_,dom_,shape_p,numpy.array(nativeidxs_,dtype=numpy.dtype(numpy.int32)),numpy.int64(varid_))
  def _ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4LinearDomain_2Lmosek_4fusion_4Set_2_3IJ(self,model_,name_,dom_,shape_p,nativeidxs_,varid_):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2J(self,model_,name_,shape_p,varid_)
   self.__nativeidxs = nativeidxs_
   if (nativeidxs_ is None):
    self.__idxmap = mosek.fusion.Utils.IntMap()
   else:
    self.__idxmap = None
   self.__dom = dom_
   self.__names_flushed = False
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   self.elementName(_0,_1)
   self.__dom._domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(_0,_1)
   return (_1)
  @staticmethod
  def _match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   _1._a_S(("_" if ((int(len(self._name))==0) ) else self._name))._a_S("[")._a_S(self._shape_p.indexToString(_0))._a_S("] ")
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   if ((not self.__names_flushed) and (int(len(self._name)) > 0)):
    if (self.__nativeidxs is not None):
     for _0 in range(0,int((self.__nativeidxs).shape[0])):
      self._model._varname_IS(self.__nativeidxs[_0],("" if ((int(len(self._name))==0) ) else mosek.fusion.Utils.StringBuffer()._a_S(self._name)._a_S("[")._a_S(self._shape_p.getname(_0))._a_S("]")._toString_()))
    else:
     _1=self.__idxmap._keys_()
     _2=self.__idxmap._values_()
     for _3 in range(0,int((_1).shape[0])):
      self._model._varname_IS(_2[_3],mosek.fusion.Utils.StringBuffer()._a_S(self._name)._a_S("[")._a_S(self._shape_p.getname(_1[_3]))._a_S("]")._toString_())
    self.__names_flushed = True
  @staticmethod
  def _match_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match__3I__(_5) and __arg_match__3I__(_6) and __arg_match__3I__(_7))
  @staticmethod
  def _match_alt_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match__3I__(_5) and __arg_alt_match__3I__(_6) and __arg_alt_match__3I__(_7))
  def _inst_alt__3JIIJJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int32))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.int32))
   _7=numpy.array(_t__7,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst__3JIIJJ_3I_3I_3I(_0,_1,_2,_3,_4,_5,_6,_7)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__7[:] = _7
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst__3JIIJJ_3I_3I_3I(self,_0,_1,_2,_3,_4,_5,_6,_7):
   if (self.__nativeidxs is not None):
    for _8 in range(_1,_2):
     _5[(_4 + numpy.int64((_8 - _1)))] = self.__nativeidxs[_0[(numpy.int64(_8) - _3)]]
   else:
    for _9 in range(_1,_2):
     if (not self.__idxmap._hasItem_J(_0[(numpy.int64(_9) - _3)])):
      _10=self._model._append_1linearvar_Lmosek_4fusion_4ModelVariable_2JEmosek_4fusion_4RelationKey_2D(self,_0[(numpy.int64(_9) - _3)],(self.__dom._key),self.__dom._get_1rhs_1item_J(_0[(numpy.int64(_9) - _3)]))
      self.__idxmap._setItem_JI(_0[(_9 - _3)],_10)
      _5[((_4 + _9) - _1)] = _10
      self.__names_flushed = False
     else:
      _5[((_4 + _9) - _1)] = self.__idxmap._getItem_J(_0[(numpy.int64(_9) - _3)])
  @staticmethod
  def _match_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match_J__(_0) and __arg_match_J__(_1) and __arg_match__3I__(_2) and __arg_match__3I__(_3) and __arg_match__3I__(_4))
  @staticmethod
  def _match_alt_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_J__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match__3I__(_3) and __arg_alt_match__3I__(_4))
  def _inst_alt_JJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst_JJ_3I_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst_JJ_3I_3I_3I(self,_0,_1,_2,_3,_4):
   if (self.__nativeidxs is not None):
    _2[_1] = self.__nativeidxs[_0]
   else:
    if (not self.__idxmap._hasItem_J(_0)):
     _5=self._model._append_1linearvar_Lmosek_4fusion_4ModelVariable_2JEmosek_4fusion_4RelationKey_2D(self,_0,(self.__dom._key),self.__dom._get_1rhs_1item_J(_0))
     self.__idxmap._setItem_JI(_0,_5)
     _2[_1] = _5
    else:
     _2[_1] = self.__idxmap._getItem_J(_0)
  def __dual_1values_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self.__dual_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def __dual_1values_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   _5=1
   _6=int((_2).shape[0])
   _7=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
   _8=self._model._getSolution_1slx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   _9=self._model._getSolution_1sux_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   for _10 in range(0,_6):
    _5 = (_5 * _1[_10])
   if (self.__nativeidxs is not None):
    for _11 in range(0,_5):
     _12=self.__nativeidxs[_7.get()]
     _4[(_11 + _3)] = (_8[_12] - _9[_12])
     _7.inc()
   else:
    _13=self._model.getPrimalSolutionStatus()
    for _14 in range(0,numpy.int32(_5)):
     if self.__idxmap._hasItem_J(_7.get()):
      _15=self.__idxmap._getItem_J(_7.get())
      _4[(_3 + _14)] = (_8[_15] - _9[_15])
     else:
      if ((_13==mosek.fusion.SolutionStatus.Optimal) or ((_13==mosek.fusion.SolutionStatus.NearOptimal) or ((_13==mosek.fusion.SolutionStatus.Feasible) or (_13==mosek.fusion.SolutionStatus.NearFeasible)))):
       _4[(_3 + _14)] = self.__dom._get_1rhs_1item_J(_7.get())
      else:
       _4[(_3 + _14)] = 0.0
     _7.inc()
  def __dual_1values_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self.__dual_1values__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def __dual_1values__3JI_3D(self,_0,_1,_2):
   _3=self._model._getSolution_1slx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   _4=self._model._getSolution_1sux_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   if (self.__nativeidxs is not None):
    for _5 in range(0,int((_0).shape[0])):
     _6=self.__nativeidxs[_0[_5]]
     _2[(_1 + _5)] = (_3[_6] - _4[_6])
   else:
    _7=self._model.getPrimalSolutionStatus()
    for _8 in range(0,int((_0).shape[0])):
     if self.__idxmap._hasItem_J(_0[_8]):
      _9=self.__idxmap._getItem_J(_0[_8])
      _2[(_1 + _8)] = (_3[_9] - _4[_9])
     else:
      if ((_7==mosek.fusion.SolutionStatus.Optimal) or ((_7==mosek.fusion.SolutionStatus.NearOptimal) or ((_7==mosek.fusion.SolutionStatus.Feasible) or (_7==mosek.fusion.SolutionStatus.NearFeasible)))):
       _2[(_1 + _8)] = self.__dom._get_1rhs_1item_J(_0[_8])
      else:
       _2[(_1 + _8)] = 0.0
  @staticmethod
  def _match_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _set_1values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._set_1values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   if _5:
    _6=1
    _7=int((_2).shape[0])
    _8=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
    for _9 in range(0,_7):
     _6 = (_6 * _1[_9])
    if (self.__nativeidxs is not None):
     _10=int((self.__nativeidxs).shape[0])
     _11=numpy.array([self.__nativeidxs[_8.next()] for _12 in range(0,_6)], dtype=numpy.dtype(numpy.int32))
     _13=(numpy.array([_4[_14] for _14 in range(0,_10)], dtype=numpy.dtype(numpy.float64)) if ((_3 > 0) ) else _4)
     self._model._setSolution_1xx__3I_3D(_11,_13)
    else:
     _15=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int32))
     for _16 in range(0,_6):
      self.inst(_8.next(),_16,_15,None,None)
     _17=numpy.array([_4[(_3 + _18)] for _18 in range(0,_6)], dtype=numpy.dtype(numpy.float64))
     self._model._setSolution_1xx__3I_3D(_15,_17)
   else:
    pass
  @staticmethod
  def _match_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _set_1values_alt__3J_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1 = self._set_1values__3J_3DZ(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values__3J_3DZ(self,_0,_1,_2):
   if _2:
    if (self.__nativeidxs is not None):
     _3=int((self.__nativeidxs).shape[0])
     _4=numpy.array([self.__nativeidxs[_0[_5]] for _5 in range(0,_3)], dtype=numpy.dtype(numpy.int32))
     _6=numpy.array([_1[_7] for _7 in range(0,_3)], dtype=numpy.dtype(numpy.float64))
     self._model._setSolution_1xx__3I_3D(_4,_6)
    else:
     _8=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
     for _9 in range(0,int((_0).shape[0])):
      self.inst(_0[_9],_9,_8,None,None)
     _10=numpy.array([_1[_11] for _11 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.float64))
     self._model._setSolution_1xx__3I_3D(_8,_10)
   else:
    pass
  @staticmethod
  def _match_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   if (not _5):
    self.__dual_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   else:
    _6=1
    _7=int((_2).shape[0])
    _8=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
    _9=self._model._getSolution_1xx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    for _10 in range(0,_7):
     _6 = (_6 * _1[_10])
    if (self.__nativeidxs is not None):
     for _11 in range(0,_6):
      _4[(_11 + _3)] = _9[self.__nativeidxs[_8.get()]]
      _8.inc()
    else:
     _12=self._model.getPrimalSolutionStatus()
     for _13 in range(0,numpy.int32(_6)):
      if self.__idxmap._hasItem_J(_8.get()):
       _4[(_3 + _13)] = _9[self.__idxmap._getItem_J(_8.get())]
      else:
       if ((_12==mosek.fusion.SolutionStatus.Optimal) or ((_12==mosek.fusion.SolutionStatus.NearOptimal) or ((_12==mosek.fusion.SolutionStatus.Feasible) or (_12==mosek.fusion.SolutionStatus.NearFeasible)))):
        _4[(_3 + _13)] = self.__dom._get_1rhs_1item_J(_8.get())
       else:
        _4[(_3 + _13)] = 0.0
      _8.inc()
  @staticmethod
  def _match_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1continuous_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1continuous__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1continuous__3J(self,_0):
   if (self.__nativeidxs is not None):
    self.getModel()._task_1var_1putcontlist__3I(numpy.array([self.__nativeidxs[_0[_1]] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32)))
   else:
    _2=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
    self.inst(_0,0,int((_0).shape[0]),0,0,_2,None,None)
    self.getModel()._task_1var_1putcontlist__3I(_2)
  @staticmethod
  def _match_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1integer_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1integer__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1integer__3J(self,_0):
   if (self.__nativeidxs is not None):
    self.getModel()._task_1var_1putintlist__3I(numpy.array([self.__nativeidxs[_0[_1]] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32)))
   else:
    _2=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
    self.inst(_0,0,int((_0).shape[0]),0,0,_2,None,None)
    self.getModel()._task_1var_1putintlist__3I(_2)
  @staticmethod
  def _match_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match__3D__(_2) and __arg_match_Z__(_3))
  @staticmethod
  def _match_alt_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_Z__(_3))
  def _values_alt__3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_t__3
   _1 = self._values__3JI_3DZ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values__3JI_3DZ(self,_0,_1,_2,_3):
   if (not _3):
    self.__dual_1values__3JI_3D(_0,_1,_2)
   else:
    _4=self._model._getSolution_1xx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    if (self.__nativeidxs is not None):
     for _5 in range(0,int((_0).shape[0])):
      _2[(_1 + _5)] = _4[self.__nativeidxs[_0[_5]]]
    else:
     _6=self._model.getPrimalSolutionStatus()
     for _7 in range(0,int((_0).shape[0])):
      if self.__idxmap._hasItem_J(_0[_7]):
       _2[(_1 + _7)] = _4[self.__idxmap._getItem_J(_0[_7])]
      else:
       if ((_6==mosek.fusion.SolutionStatus.Optimal) or ((_6==mosek.fusion.SolutionStatus.NearOptimal) or ((_6==mosek.fusion.SolutionStatus.Feasible) or (_6==mosek.fusion.SolutionStatus.NearFeasible)))):
        _2[(_1 + _7)] = self.__dom._get_1rhs_1item_J(_0[_7])
       else:
        _2[(_1 + _7)] = 0.0
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_LinearVariable._ctor_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(self,_0))
 return LinearVariable
mosek_fusion_LinearVariable=__mk_mosek_fusion_LinearVariable()
del __mk_mosek_fusion_LinearVariable
#BEFORE CLASS
def __mk_mosek_fusion_ConicVariable():
 class ConicVariable(mosek_fusion_ModelVariable):
  __slots__ = ['_ConicVariable__names_flushed','_ConicVariable__nativeidxs','_ConicVariable__dom','_ConicVariable__numcone','_ConicVariable__conesize','_ConicVariable__coneidx']
  def values(self,*args):
    if False: pass
    elif mosek_fusion_ConicVariable._match_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_I_3DZ(*args)
    elif mosek_fusion_ConicVariable._match_alt_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_alt_I_3DZ(*args)
    elif mosek_fusion_ConicVariable._match_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values__3JI_3DZ(*args)
    elif mosek_fusion_ConicVariable._match_alt_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values_alt__3JI_3DZ(*args)
    elif mosek_fusion_ConicVariable._match_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_ConicVariable._match_alt_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConicVariable.values(int32,array(double,ndim=1),bool)\n\tmosek.fusion.ConicVariable.values(array(int64,ndim=1),int32,array(double,ndim=1),bool)\n\tmosek.fusion.ConicVariable.values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_ConicVariable._match_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values__3J_3DZ(*args)
    elif mosek_fusion_ConicVariable._match_alt_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values_alt__3J_3DZ(*args)
    elif mosek_fusion_ConicVariable._match_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_ConicVariable._match_alt_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConicVariable.set_values(array(int64,ndim=1),array(double,ndim=1),bool)\n\tmosek.fusion.ConicVariable.set_values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def elementName(self,*args):
    if False: pass
    elif mosek_fusion_ConicVariable._match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_ConicVariable._match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConicVariable.elementName(int64,mosek.fusion.Utils.StringBuffer)')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_ConicVariable._match_toString_(*args): # 
      return self._toString_(*args)
    elif mosek_fusion_ConicVariable._match_alt_toString_(*args): # 
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConicVariable.toString()')
  def elementDesc(self,*args):
    if False: pass
    elif mosek_fusion_ConicVariable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_ConicVariable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConicVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_ConicVariable._match_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_JJ_3I_3I_3I(*args)
    elif mosek_fusion_ConicVariable._match_alt_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt_JJ_3I_3I_3I(*args)
    elif mosek_fusion_ConicVariable._match_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst__3JIIJJ_3I_3I_3I(*args)
    elif mosek_fusion_ConicVariable._match_alt_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt__3JIIJJ_3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConicVariable.inst(int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.ConicVariable.inst(array(int64,ndim=1),int32,int32,int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_ConicVariable._match_make_1continuous__3J(*args): # []int64
      return self._make_1continuous__3J(*args)
    elif mosek_fusion_ConicVariable._match_alt_make_1continuous__3J(*args): # []int64
      return self._make_1continuous_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConicVariable.make_continuous(array(int64,ndim=1))')
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_ConicVariable._match_make_1integer__3J(*args): # []int64
      return self._make_1integer__3J(*args)
    elif mosek_fusion_ConicVariable._match_alt_make_1integer__3J(*args): # []int64
      return self._make_1integer_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConicVariable.make_integer(array(int64,ndim=1))')
  def __str__(self): return self._toString_()
  def __repr__(self): return 'mosek.fusion.ConicVariable: '+self._toString_()
  @staticmethod
  def _ctor_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = ConicVariable.__new__(ConicVariable)
    o._ctor_init_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4ConicVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4ConicVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__dom = (v.__dom)
   self.__coneidx = (v.__coneidx)
   self.__conesize = (v.__conesize)
   self.__numcone = (v.__numcone)
   self.__nativeidxs = (numpy.array([(v.__nativeidxs)[_0] for _0 in range(0,int(((v.__nativeidxs)).shape[0]))], dtype=numpy.dtype(numpy.int32)) if (((v.__nativeidxs) is not None) ) else None)
   self.__names_flushed = (v.__names_flushed)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4QConeDomain_2Lmosek_4fusion_4Set_2_3IIIIJ(model_,name_,dom_,shape_p,nativeidxs_,conesize_,firstcone_,numcone_,varid_):
    o = ConicVariable.__new__(ConicVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4QConeDomain_2Lmosek_4fusion_4Set_2_3IIIIJ(model_,name_,dom_,shape_p,nativeidxs_,conesize_,firstcone_,numcone_,varid_)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4QConeDomain_2Lmosek_4fusion_4Set_2_3IIIIJ(*args):
    if len(args) != 9: return False
    model_,name_,dom_,shape_p,nativeidxs_,conesize_,firstcone_,numcone_,varid_, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model_) and __arg_match_S__(name_) and __arg_match_Lmosek_4fusion_4QConeDomain_2__(dom_) and __arg_match_Lmosek_4fusion_4Set_2__(shape_p) and __arg_match__3I__(nativeidxs_) and __arg_match_I__(conesize_) and __arg_match_I__(firstcone_) and __arg_match_I__(numcone_) and __arg_match_J__(varid_))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4QConeDomain_2Lmosek_4fusion_4Set_2_3IIIIJ(*args):
    if len(args) != 9: return False
    model_,name_,dom_,shape_p,nativeidxs_,conesize_,firstcone_,numcone_,varid_, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model_) and __arg_alt_match_S__(name_) and __arg_alt_match_Lmosek_4fusion_4QConeDomain_2__(dom_) and __arg_alt_match_Lmosek_4fusion_4Set_2__(shape_p) and __arg_alt_match__3I__(nativeidxs_) and __arg_alt_match_I__(conesize_) and __arg_alt_match_I__(firstcone_) and __arg_alt_match_I__(numcone_) and __arg_alt_match_J__(varid_))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4QConeDomain_2Lmosek_4fusion_4Set_2_3IIIIJ(self,model_,name_,dom_,shape_p,nativeidxs_,conesize_,firstcone_,numcone_,varid_):
    self._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4QConeDomain_2Lmosek_4fusion_4Set_2_3IIIIJ(model_,name_,dom_,shape_p,numpy.array(nativeidxs_,dtype=numpy.dtype(numpy.int32)),numpy.int32(conesize_),numpy.int32(firstcone_),numpy.int32(numcone_),numpy.int64(varid_))
  def _ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4QConeDomain_2Lmosek_4fusion_4Set_2_3IIIIJ(self,model_,name_,dom_,shape_p,nativeidxs_,conesize_,firstcone_,numcone_,varid_):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2J(self,model_,name_,shape_p,varid_)
   self.__dom = dom_
   self.__conesize = conesize_
   self.__coneidx = firstcone_
   self.__numcone = numcone_
   self.__nativeidxs = nativeidxs_
   self.__names_flushed = False
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=mosek.fusion.Utils.StringBuffer()
   _0._a_S("ConicVariable( ")
   if (int(len(self._name)) > 0):
    _0._a_S("'")._a_S(self._name)._a_S("',")
   _0._a_S("(")
   _0._a_I(self._shape_p.dim(0))
   for _1 in range(1,(self._shape_p.nd)):
    _0._a_S(",")._a_I(self._shape_p.dim(_1))
   _0._a_S(") )")
   return (_0._toString_())
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   self.elementName(_0,_1)
   self.__dom._domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(_0,_1)
   return (_1)
  @staticmethod
  def _match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   _1._a_S(("_" if ((int(len(self._name))==0) ) else self._name))._a_S("[")._a_S(self._shape_p.indexToString(_0))._a_S("] ")
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   if ((not self.__names_flushed) and (int(len(self._name)) > 0)):
    for _0 in range(0,int((self.__nativeidxs).shape[0])):
     self._model._varname_IS(self.__nativeidxs[_0],mosek.fusion.Utils.StringBuffer()._a_S(self._name)._a_S("[")._a_S(self._shape_p.getname(_0))._a_S("]")._toString_())
    self.__names_flushed = True
  @staticmethod
  def _match_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match__3I__(_5) and __arg_match__3I__(_6) and __arg_match__3I__(_7))
  @staticmethod
  def _match_alt_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match__3I__(_5) and __arg_alt_match__3I__(_6) and __arg_alt_match__3I__(_7))
  def _inst_alt__3JIIJJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int32))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.int32))
   _7=numpy.array(_t__7,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst__3JIIJJ_3I_3I_3I(_0,_1,_2,_3,_4,_5,_6,_7)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__7[:] = _7
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst__3JIIJJ_3I_3I_3I(self,_0,_1,_2,_3,_4,_5,_6,_7):
   if (self.__nativeidxs is not None):
    for _8 in range(_1,_2):
     _5[(_4 + numpy.int64((_8 - _1)))] = self.__nativeidxs[_0[(numpy.int64(_8) - _3)]]
  @staticmethod
  def _match_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match_J__(_0) and __arg_match_J__(_1) and __arg_match__3I__(_2) and __arg_match__3I__(_3) and __arg_match__3I__(_4))
  @staticmethod
  def _match_alt_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_J__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match__3I__(_3) and __arg_alt_match__3I__(_4))
  def _inst_alt_JJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst_JJ_3I_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst_JJ_3I_3I_3I(self,_0,_1,_2,_3,_4):
   if ((_0 < 0) or (_0 >= long((self.__nativeidxs).shape[0]))):
    raise mosek_fusion_IndexError._ctor_S("Index out of bounds")
   _2[_1] = self.__nativeidxs[_0]
  @staticmethod
  def _match_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _set_1values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._set_1values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   if _5:
    _6=1
    _7=int((_2).shape[0])
    _8=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
    for _9 in range(0,_7):
     _6 = (_6 * _1[_9])
    _10=int((self.__nativeidxs).shape[0])
    _11=numpy.array([self.__nativeidxs[_8.next()] for _12 in range(0,_6)], dtype=numpy.dtype(numpy.int32))
    _13=(numpy.array([_4[(_3 + _14)] for _14 in range(0,_10)], dtype=numpy.dtype(numpy.float64)) if ((_3 > 0) ) else _4)
    self._model._setSolution_1xx__3I_3D(_11,_13)
   else:
    pass
  @staticmethod
  def _match_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _set_1values_alt__3J_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1 = self._set_1values__3J_3DZ(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values__3J_3DZ(self,_0,_1,_2):
   if _2:
    _3=int((self.__nativeidxs).shape[0])
    _4=numpy.array([self.__nativeidxs[_0[_5]] for _5 in range(0,_3)], dtype=numpy.dtype(numpy.int32))
    _6=numpy.array([_1[_7] for _7 in range(0,_3)], dtype=numpy.dtype(numpy.float64))
    self._model._setSolution_1xx__3I_3D(_4,_6)
   else:
    pass
  @staticmethod
  def _match_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   _6=1
   _7=int((_2).shape[0])
   _8=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
   _9=(self._model._getSolution_1xx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default) if (_5 ) else self._model._getSolution_1snx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default))
   for _10 in range(0,_7):
    _6 = (_6 * _1[_10])
   for _11 in range(0,_6):
    _4[(_11 + _3)] = _9[self.__nativeidxs[_8.get()]]
    _8.inc()
  @staticmethod
  def _match_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match__3D__(_2) and __arg_match_Z__(_3))
  @staticmethod
  def _match_alt_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_Z__(_3))
  def _values_alt__3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_t__3
   _1 = self._values__3JI_3DZ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values__3JI_3DZ(self,_0,_1,_2,_3):
   _4=(self._model._getSolution_1xx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default) if (_3 ) else self._model._getSolution_1snx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default))
   for _5 in range(0,int((_0).shape[0])):
    _2[(_1 + _5)] = _4[self.__nativeidxs[_0[_5]]]
  @staticmethod
  def _match_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1continuous_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1continuous__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1continuous__3J(self,_0):
   self.getModel()._task_1var_1putcontlist__3I(numpy.array([self.__nativeidxs[_0[_1]] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32)))
  @staticmethod
  def _match_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1integer_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1integer__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1integer__3J(self,_0):
   self.getModel()._task_1var_1putintlist__3I(numpy.array([self.__nativeidxs[_0[_1]] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32)))
  def _get_1variable_1index_alt_I(self,_t__0):
    return self._get_1variable_1index_I(numpy.int32(__0))
  def _get_1variable_1index_I(self,_0):
   if (_0 >= int((self.__nativeidxs).shape[0])):
    raise mosek_fusion_IndexError._ctor_S("Variable index out of range")
   else:
    return numpy.int32(self.__nativeidxs[_0])
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_ConicVariable._ctor_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(self,_0))
 return ConicVariable
mosek_fusion_ConicVariable=__mk_mosek_fusion_ConicVariable()
del __mk_mosek_fusion_ConicVariable
#BEFORE CLASS
def __mk_mosek_fusion_NilVariable():
 class NilVariable(mosek_fusion_SymmetricVariable,mosek_fusion_BaseVariable):
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_toString_(*args): # 
      return self._toString_(*args)
    elif mosek_fusion_NilVariable._match_alt_toString_(*args): # 
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.toString()')
  def elementDesc(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_NilVariable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def size(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_size_(*args): # 
      return self._size_(*args)
    elif mosek_fusion_NilVariable._match_alt_size_(*args): # 
      return self._size_alt_(*args)
    else:
      raise ValueError('Invalid argument list size('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.size()')
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values__3J_3DZ(*args)
    elif mosek_fusion_NilVariable._match_alt_set_1values__3J_3DZ(*args): # []int64,[]double,bool
      return self._set_1values_alt__3J_3DZ(*args)
    elif mosek_fusion_NilVariable._match_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_NilVariable._match_alt_set_1values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._set_1values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.set_values(array(int64,ndim=1),array(double,ndim=1),bool)\n\tmosek.fusion.NilVariable.set_values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_slice_II(*args): # int32,int32
      return self._slice_II(*args)
    elif mosek_fusion_NilVariable._match_alt_slice_II(*args): # int32,int32
      return self._slice_alt_II(*args)
    elif mosek_fusion_NilVariable._match_slice__3I_3I(*args): # []int32,[]int32
      return self._slice__3I_3I(*args)
    elif mosek_fusion_NilVariable._match_alt_slice__3I_3I(*args): # []int32,[]int32
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.slice(int32,int32)\n\tmosek.fusion.NilVariable.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def values(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_I_3DZ(*args)
    elif mosek_fusion_NilVariable._match_alt_values_I_3DZ(*args): # int32,[]double,bool
      return self._values_alt_I_3DZ(*args)
    elif mosek_fusion_NilVariable._match_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values__3JI_3DZ(*args)
    elif mosek_fusion_NilVariable._match_alt_values__3JI_3DZ(*args): # []int64,int32,[]double,bool
      return self._values_alt__3JI_3DZ(*args)
    elif mosek_fusion_NilVariable._match_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_J_3I_3JI_3DZ(*args)
    elif mosek_fusion_NilVariable._match_alt_values_J_3I_3JI_3DZ(*args): # int64,[]int32,[]int64,int32,[]double,bool
      return self._values_alt_J_3I_3JI_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.values(int32,array(double,ndim=1),bool)\n\tmosek.fusion.NilVariable.values(array(int64,ndim=1),int32,array(double,ndim=1),bool)\n\tmosek.fusion.NilVariable.values(int64,array(int32,ndim=1),array(int64,ndim=1),int32,array(double,ndim=1),bool)')
  def index(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_index_I(*args): # int32
      return self._index_I(*args)
    elif mosek_fusion_NilVariable._match_alt_index_I(*args): # int32
      return self._index_alt_I(*args)
    elif mosek_fusion_NilVariable._match_index__3I(*args): # []int32
      return self._index__3I(*args)
    elif mosek_fusion_NilVariable._match_alt_index__3I(*args): # []int32
      return self._index_alt__3I(*args)
    elif mosek_fusion_NilVariable._match_index_II(*args): # int32,int32
      return self._index_II(*args)
    elif mosek_fusion_NilVariable._match_alt_index_II(*args): # int32,int32
      return self._index_alt_II(*args)
    elif mosek_fusion_NilVariable._match_index_III(*args): # int32,int32,int32
      return self._index_III(*args)
    elif mosek_fusion_NilVariable._match_alt_index_III(*args): # int32,int32,int32
      return self._index_alt_III(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.index(int32)\n\tmosek.fusion.NilVariable.index(array(int32,ndim=1))\n\tmosek.fusion.NilVariable.index(int32,int32)\n\tmosek.fusion.NilVariable.index(int32,int32,int32)')
  def level(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_level_(*args): # 
      return self._level_(*args)
    elif mosek_fusion_NilVariable._match_alt_level_(*args): # 
      return self._level_alt_(*args)
    else:
      raise ValueError('Invalid argument list level('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.level()')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_JJ_3I_3I_3I(*args)
    elif mosek_fusion_NilVariable._match_alt_inst_JJ_3I_3I_3I(*args): # int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt_JJ_3I_3I_3I(*args)
    elif mosek_fusion_NilVariable._match_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst__3JIIJJ_3I_3I_3I(*args)
    elif mosek_fusion_NilVariable._match_alt_inst__3JIIJJ_3I_3I_3I(*args): # []int64,int32,int32,int64,int64,[]int32,[]int32,[]int32
      return self._inst_alt__3JIIJJ_3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.inst(int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.NilVariable.inst(array(int64,ndim=1),int32,int32,int64,int64,array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def makeInteger(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_makeInteger_(*args): # 
      return self._makeInteger_(*args)
    elif mosek_fusion_NilVariable._match_alt_makeInteger_(*args): # 
      return self._makeInteger_alt_(*args)
    else:
      raise ValueError('Invalid argument list makeInteger('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.makeInteger()')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_make_1continuous__3J(*args): # []int64
      return self._make_1continuous__3J(*args)
    elif mosek_fusion_NilVariable._match_alt_make_1continuous__3J(*args): # []int64
      return self._make_1continuous_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.make_continuous(array(int64,ndim=1))')
  def dual(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_dual_(*args): # 
      return self._dual_(*args)
    elif mosek_fusion_NilVariable._match_alt_dual_(*args): # 
      return self._dual_alt_(*args)
    else:
      raise ValueError('Invalid argument list dual('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.dual()')
  def elementName(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_NilVariable._match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args): # int64,mosek.fusion.Utils.StringBuffer
      return self._elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.elementName(int64,mosek.fusion.Utils.StringBuffer)')
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_make_1integer__3J(*args): # []int64
      return self._make_1integer__3J(*args)
    elif mosek_fusion_NilVariable._match_alt_make_1integer__3J(*args): # []int64
      return self._make_1integer_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.make_integer(array(int64,ndim=1))')
  def makeContinuous(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_makeContinuous_(*args): # 
      return self._makeContinuous_(*args)
    elif mosek_fusion_NilVariable._match_alt_makeContinuous_(*args): # 
      return self._makeContinuous_alt_(*args)
    else:
      raise ValueError('Invalid argument list makeContinuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.makeContinuous()')
  def __str__(self): return self._toString_()
  def __repr__(self): return 'mosek.fusion.NilVariable: '+self._toString_()
  @staticmethod
  def _ctor_():
    o = NilVariable.__new__(NilVariable)
    o._ctor_init_()
    return o
  @staticmethod
  def __match_ctor_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def __match_alt_ctor_(*args):
    if len(args) != 0: return False
    return True
  def _ctor_alt_init_(self,):
    self._ctor_init_()
  def _ctor_init_(self,):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(self,None,mosek.fusion.Set._make_I(0))
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   return (_1)
  @staticmethod
  def _match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   pass
  @staticmethod
  def _match_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match__3I__(_5) and __arg_match__3I__(_6) and __arg_match__3I__(_7))
  @staticmethod
  def _match_alt_inst__3JIIJJ_3I_3I_3I(*args):
    if len(args) != 8: return False
    _0,_1,_2,_3,_4,_5,_6,_7, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match__3I__(_5) and __arg_alt_match__3I__(_6) and __arg_alt_match__3I__(_7))
  def _inst_alt__3JIIJJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int32))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.int32))
   _7=numpy.array(_t__7,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst__3JIIJJ_3I_3I_3I(_0,_1,_2,_3,_4,_5,_6,_7)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__7[:] = _7
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst__3JIIJJ_3I_3I_3I(self,_0,_1,_2,_3,_4,_5,_6,_7):
   pass
  @staticmethod
  def _match_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match_J__(_0) and __arg_match_J__(_1) and __arg_match__3I__(_2) and __arg_match__3I__(_3) and __arg_match__3I__(_4))
  @staticmethod
  def _match_alt_inst_JJ_3I_3I_3I(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_J__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match__3I__(_3) and __arg_alt_match__3I__(_4))
  def _inst_alt_JJ_3I_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1 = self._inst_JJ_3I_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _inst_JJ_3I_3I_3I(self,_0,_1,_2,_3,_4):
   pass
  @staticmethod
  def _match_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_set_1values__3J_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _set_1values_alt__3J_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1 = self._set_1values__3J_3DZ(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values__3J_3DZ(self,_0,_1,_2):
   pass
  @staticmethod
  def _match_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_set_1values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _set_1values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._set_1values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _set_1values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   pass
  @staticmethod
  def _match_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1) and __arg_match__3D__(_2) and __arg_match_Z__(_3))
  @staticmethod
  def _match_alt_values__3JI_3DZ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_Z__(_3))
  def _values_alt__3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_t__3
   _1 = self._values__3JI_3DZ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values__3JI_3DZ(self,_0,_1,_2,_3):
   pass
  @staticmethod
  def _match_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match_J__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2) and __arg_match_I__(_3) and __arg_match__3D__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_values_J_3I_3JI_3DZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match__3D__(_4) and __arg_alt_match_Z__(_5))
  def _values_alt_J_3I_3JI_3DZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _5=_t__5
   _1 = self._values_J_3I_3JI_3DZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _values_J_3I_3JI_3DZ(self,_0,_1,_2,_3,_4,_5):
   pass
  @staticmethod
  def _match_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1continuous_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1continuous__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1continuous__3J(self,_0):
   pass
  @staticmethod
  def _match_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1integer_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1 = self._make_1integer__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _make_1integer__3J(self,_0):
   pass
  @staticmethod
  def _match_makeContinuous_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_makeContinuous_(*args):
    if len(args) != 0: return False
    return True
  def _makeContinuous_alt_(self,):
    return self._makeContinuous_()
  def _makeContinuous_(self,):
   self.make_continuous(numpy.array([_0 for _0 in range(0,self.size())], dtype=numpy.dtype(numpy.int64)))
  @staticmethod
  def _match_makeInteger_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_makeInteger_(*args):
    if len(args) != 0: return False
    return True
  def _makeInteger_alt_(self,):
    return self._makeInteger_()
  def _makeInteger_(self,):
   self.make_integer(numpy.array([_0 for _0 in range(0,self.size())], dtype=numpy.dtype(numpy.int64)))
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   return ("NilVariable")
  @staticmethod
  def _match_size_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_size_(*args):
    if len(args) != 0: return False
    return True
  def _size_alt_(self,):
    return self._size_()
  def _size_(self,):
   return numpy.int32(0)
  @staticmethod
  def _match_dual_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dual_(*args):
    if len(args) != 0: return False
    return True
  def _dual_alt_(self,):
    return self._dual_()
  def _dual_(self,):
   return (numpy.zeros((0,), dtype=numpy.dtype(numpy.float64)))
  @staticmethod
  def _match_level_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_level_(*args):
    if len(args) != 0: return False
    return True
  def _level_alt_(self,):
    return self._level_()
  def _level_(self,):
   return (numpy.zeros((0,), dtype=numpy.dtype(numpy.float64)))
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _index_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1 = self._index__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _index__3I(self,_0):
   raise mosek_fusion_SliceError._ctor_S("Slice is out of bounds")
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _index_alt_I(self,_t__0):
    return self._index_I(numpy.int32(__0))
  def _index_I(self,_0):
   raise mosek_fusion_SliceError._ctor_S("Slice is out of bounds")
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _slice__3I_3I(self,_0,_1):
   for _2 in range(0,int((_0).shape[0])):
    if (_1[_2] > _0[_2]):
     raise mosek_fusion_SliceError._ctor_S("Slice is out of bounds")
   return (self)
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   if (_1 > _0):
    raise mosek_fusion_SliceError._ctor_S("Slice is out of bounds")
   else:
    return (self)
 return NilVariable
mosek_fusion_NilVariable=__mk_mosek_fusion_NilVariable()
del __mk_mosek_fusion_NilVariable
#BEFORE CLASS
def __mk_mosek_fusion_Var():
 class Var(object):
  @staticmethod
  def repeat(*args):
    if False: pass
    elif mosek_fusion_Var._match_repeat_Lmosek_4fusion_4Variable_2I(*args): # mosek.fusion.Variable,int32
      return mosek_fusion_Var._repeat_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_repeat_Lmosek_4fusion_4Variable_2I(*args): # mosek.fusion.Variable,int32
      return mosek_fusion_Var._repeat_alt_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_repeat_Lmosek_4fusion_4Variable_2II(*args): # mosek.fusion.Variable,int32,int32
      return mosek_fusion_Var._repeat_Lmosek_4fusion_4Variable_2II(*args)
    elif mosek_fusion_Var._match_alt_repeat_Lmosek_4fusion_4Variable_2II(*args): # mosek.fusion.Variable,int32,int32
      return mosek_fusion_Var._repeat_alt_Lmosek_4fusion_4Variable_2II(*args)
    else:
      raise ValueError('Invalid argument list repeat('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.repeat(mosek.fusion.Variable,int32)\n\tmosek.fusion.Var.repeat(mosek.fusion.Variable,int32,int32)')
  @staticmethod
  def flatten(*args):
    if False: pass
    elif mosek_fusion_Var._match_flatten_Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.Variable
      return mosek_fusion_Var._flatten_Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_flatten_Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.Variable
      return mosek_fusion_Var._flatten_alt_Lmosek_4fusion_4Variable_2(*args)
    else:
      raise ValueError('Invalid argument list flatten('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.flatten(mosek.fusion.Variable)')
  @staticmethod
  def vrepeat(*args):
    if False: pass
    elif mosek_fusion_Var._match_vrepeat_Lmosek_4fusion_4Variable_2I(*args): # mosek.fusion.Variable,int32
      return mosek_fusion_Var._vrepeat_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_vrepeat_Lmosek_4fusion_4Variable_2I(*args): # mosek.fusion.Variable,int32
      return mosek_fusion_Var._vrepeat_alt_Lmosek_4fusion_4Variable_2I(*args)
    else:
      raise ValueError('Invalid argument list vrepeat('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.vrepeat(mosek.fusion.Variable,int32)')
  @staticmethod
  def reshape(*args):
    if False: pass
    elif mosek_fusion_Var._match_reshape_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(*args): # mosek.fusion.Variable,mosek.fusion.Set
      return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(*args)
    elif mosek_fusion_Var._match_alt_reshape_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(*args): # mosek.fusion.Variable,mosek.fusion.Set
      return mosek_fusion_Var._reshape_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(*args)
    elif mosek_fusion_Var._match_reshape_Lmosek_4fusion_4Variable_2_3I(*args): # mosek.fusion.Variable,[]int32
      return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2_3I(*args)
    elif mosek_fusion_Var._match_alt_reshape_Lmosek_4fusion_4Variable_2_3I(*args): # mosek.fusion.Variable,[]int32
      return mosek_fusion_Var._reshape_alt_Lmosek_4fusion_4Variable_2_3I(*args)
    elif mosek_fusion_Var._match_reshape_Lmosek_4fusion_4Variable_2I(*args): # mosek.fusion.Variable,int32
      return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_reshape_Lmosek_4fusion_4Variable_2I(*args): # mosek.fusion.Variable,int32
      return mosek_fusion_Var._reshape_alt_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_reshape_Lmosek_4fusion_4Variable_2II(*args): # mosek.fusion.Variable,int32,int32
      return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2II(*args)
    elif mosek_fusion_Var._match_alt_reshape_Lmosek_4fusion_4Variable_2II(*args): # mosek.fusion.Variable,int32,int32
      return mosek_fusion_Var._reshape_alt_Lmosek_4fusion_4Variable_2II(*args)
    else:
      raise ValueError('Invalid argument list reshape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.reshape(mosek.fusion.Variable,mosek.fusion.Set)\n\tmosek.fusion.Var.reshape(mosek.fusion.Variable,array(int32,ndim=1))\n\tmosek.fusion.Var.reshape(mosek.fusion.Variable,int32)\n\tmosek.fusion.Var.reshape(mosek.fusion.Variable,int32,int32)')
  @staticmethod
  def hstack(*args):
    if False: pass
    elif mosek_fusion_Var._match_hstack__3Lmosek_4fusion_4Variable_2(*args): # []mosek.fusion.Variable
      return mosek_fusion_Var._hstack__3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_hstack__3Lmosek_4fusion_4Variable_2(*args): # []mosek.fusion.Variable
      return mosek_fusion_Var._hstack_alt__3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.Variable,mosek.fusion.Variable
      return mosek_fusion_Var._hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.Variable,mosek.fusion.Variable
      return mosek_fusion_Var._hstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable
      return mosek_fusion_Var._hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable
      return mosek_fusion_Var._hstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    else:
      raise ValueError('Invalid argument list hstack('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.hstack(array(mosek.fusion.Variable,ndim=1))\n\tmosek.fusion.Var.hstack(mosek.fusion.Variable,mosek.fusion.Variable)\n\tmosek.fusion.Var.hstack(mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable)')
  @staticmethod
  def vstack(*args):
    if False: pass
    elif mosek_fusion_Var._match_vstack__3Lmosek_4fusion_4Variable_2(*args): # []mosek.fusion.Variable
      return mosek_fusion_Var._vstack__3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_vstack__3Lmosek_4fusion_4Variable_2(*args): # []mosek.fusion.Variable
      return mosek_fusion_Var._vstack_alt__3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.Variable,mosek.fusion.Variable
      return mosek_fusion_Var._vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.Variable,mosek.fusion.Variable
      return mosek_fusion_Var._vstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable
      return mosek_fusion_Var._vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable
      return mosek_fusion_Var._vstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    else:
      raise ValueError('Invalid argument list vstack('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.vstack(array(mosek.fusion.Variable,ndim=1))\n\tmosek.fusion.Var.vstack(mosek.fusion.Variable,mosek.fusion.Variable)\n\tmosek.fusion.Var.vstack(mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable)')
  @staticmethod
  def stack(*args):
    if False: pass
    elif mosek_fusion_Var._match_stack__3_3Lmosek_4fusion_4Variable_2(*args): # [][]mosek.fusion.Variable
      return mosek_fusion_Var._stack__3_3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_stack__3_3Lmosek_4fusion_4Variable_2(*args): # [][]mosek.fusion.Variable
      return mosek_fusion_Var._stack_alt__3_3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_stack__3Lmosek_4fusion_4Variable_2I(*args): # []mosek.fusion.Variable,int32
      return mosek_fusion_Var._stack__3Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_stack__3Lmosek_4fusion_4Variable_2I(*args): # []mosek.fusion.Variable,int32
      return mosek_fusion_Var._stack_alt__3Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args): # mosek.fusion.Variable,mosek.fusion.Variable,int32
      return mosek_fusion_Var._stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args): # mosek.fusion.Variable,mosek.fusion.Variable,int32
      return mosek_fusion_Var._stack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args): # mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable,int32
      return mosek_fusion_Var._stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args): # mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable,int32
      return mosek_fusion_Var._stack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args)
    else:
      raise ValueError('Invalid argument list stack('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.stack(array(array(mosek.fusion.Variable,ndim=1),ndim=1))\n\tmosek.fusion.Var.stack(array(mosek.fusion.Variable,ndim=1),int32)\n\tmosek.fusion.Var.stack(mosek.fusion.Variable,mosek.fusion.Variable,int32)\n\tmosek.fusion.Var.stack(mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable,int32)')
  @staticmethod
  def hrepeat(*args):
    if False: pass
    elif mosek_fusion_Var._match_hrepeat_Lmosek_4fusion_4Variable_2I(*args): # mosek.fusion.Variable,int32
      return mosek_fusion_Var._hrepeat_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_hrepeat_Lmosek_4fusion_4Variable_2I(*args): # mosek.fusion.Variable,int32
      return mosek_fusion_Var._hrepeat_alt_Lmosek_4fusion_4Variable_2I(*args)
    else:
      raise ValueError('Invalid argument list hrepeat('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.hrepeat(mosek.fusion.Variable,int32)')
  @staticmethod
  def compress(*args):
    if False: pass
    elif mosek_fusion_Var._match_compress_Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.Variable
      return mosek_fusion_Var._compress_Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_compress_Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.Variable
      return mosek_fusion_Var._compress_alt_Lmosek_4fusion_4Variable_2(*args)
    else:
      raise ValueError('Invalid argument list compress('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.compress(mosek.fusion.Variable)')
  def __repr__(self): return 'mosek.fusion.Var'
  @staticmethod
  def _match_compress_Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _match_alt_compress_Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _compress_alt_Lmosek_4fusion_4Variable_2(_t__0):
    return mosek_fusion_Var._compress_Lmosek_4fusion_4Variable_2(_0)
  @staticmethod
  def _compress_Lmosek_4fusion_4Variable_2(_0):
   _1=_0.getShape().realnd()
   if (_1==(_0.getShape().nd)):
    return (_0)
   elif (_1==1):
    return (mosek.fusion.Var._reshape_Lmosek_4fusion_4Variable_2I(_0,numpy.int32((_0.getShape()._size))))
   else:
    _2=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int32))
    _3=0
    for _4 in range(0,(_0.getShape().nd)):
     if (_0.getShape().dim(_4) > 1):
      _2[_3] = _0.getShape().dim(_4)
      _3 += 1
    return (mosek.fusion.Var._reshape_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(_0,mosek_fusion_NDSet._ctor__3I(_2)))
  @staticmethod
  def _match_reshape_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_reshape_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _reshape_alt_Lmosek_4fusion_4Variable_2I(_t__0,_t__1):
    return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2I(_0,numpy.int32(__1))
  @staticmethod
  def _reshape_Lmosek_4fusion_4Variable_2I(_0,_1):
   if (_1!=(_0.getShape()._size)):
    raise mosek_fusion_DimensionError._ctor_S("New shape has wrong number of elements")
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(_0,mosek_fusion_IntSet._ctor_I(_1),0,numpy.array([1], dtype=numpy.dtype(numpy.int64))))
  @staticmethod
  def _match_reshape_Lmosek_4fusion_4Variable_2II(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_reshape_Lmosek_4fusion_4Variable_2II(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2))
  @staticmethod
  def _reshape_alt_Lmosek_4fusion_4Variable_2II(_t__0,_t__1,_t__2):
    return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2II(_0,numpy.int32(__1),numpy.int32(__2))
  @staticmethod
  def _reshape_Lmosek_4fusion_4Variable_2II(_0,_1,_2):
   if ((_1 * _2)!=(_0.getShape()._size)):
    raise mosek_fusion_DimensionError._ctor_S("New shape has wrong number of elements")
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(_0,mosek_fusion_NDSet._ctor_II(_1,_2),0,numpy.array([numpy.int64(_2),1], dtype=numpy.dtype(numpy.int64))))
  @staticmethod
  def _match_flatten_Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _match_alt_flatten_Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _flatten_alt_Lmosek_4fusion_4Variable_2(_t__0):
    return mosek_fusion_Var._flatten_Lmosek_4fusion_4Variable_2(_0)
  @staticmethod
  def _flatten_Lmosek_4fusion_4Variable_2(_0):
   if ((_0.getShape().nd)==1):
    return (_0)
   else:
    return (mosek.fusion.Var._reshape_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(_0,mosek.fusion.Set._make_I(numpy.int32((_0.getShape()._size)))))
  @staticmethod
  def _match_reshape_Lmosek_4fusion_4Variable_2_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_reshape_Lmosek_4fusion_4Variable_2_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match__3I__(_1))
  @staticmethod
  def _reshape_alt_Lmosek_4fusion_4Variable_2_3I(_t__0,_t__1):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2_3I(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _reshape_Lmosek_4fusion_4Variable_2_3I(_0,_1):
   _2=mosek.fusion.Set._make__3I(_1)
   return (mosek.fusion.Var._reshape_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(_0,_2))
  @staticmethod
  def _match_reshape_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4Set_2__(_1))
  @staticmethod
  def _match_alt_reshape_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Set_2__(_1))
  @staticmethod
  def _reshape_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(_t__0,_t__1):
    return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(_0,_1)
  @staticmethod
  def _reshape_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(_0,_1):
   if ((_1._size)!=(_0.getShape()._size)):
    raise mosek_fusion_DimensionError._ctor_S("New shape has wrong number of elements")
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(_0,_1,0,numpy.array([_1.stride(_2) for _2 in range(0,(_1.nd))], dtype=numpy.dtype(numpy.int64))))
  @staticmethod
  def _reshape_1_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(_t__0,_t__1):
    return mosek_fusion_Var._reshape_1_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(_0,_1)
  @staticmethod
  def _reshape_1_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(_0,_1):
   _2=numpy.array([_1.stride(_3) for _3 in range(0,(_1.nd))], dtype=numpy.dtype(numpy.int64))
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(_0,_1,0,_2))
  @staticmethod
  def _index_1flip_1_alt_Lmosek_4fusion_4Variable_2_3I(_t__0,_t__1):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = mosek_fusion_Var._index_1flip_1_Lmosek_4fusion_4Variable_2_3I(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _index_1flip_1_Lmosek_4fusion_4Variable_2_3I(_0,_1):
   _2=numpy.array([_0.getShape().stride(_3) for _3 in range(0,(_0.getShape().nd))], dtype=numpy.dtype(numpy.int64))
   _4=numpy.array([_0.getShape().dim(_5) for _5 in range(0,(_0.getShape().nd))], dtype=numpy.dtype(numpy.int32))
   _6=0
   for _7 in range(0,int((_1).shape[0])):
    _6 = (_6 + (_2[_1[_7]] * (_4[_7] - 1)))
    _2[_4[_7]] = (- _2[_4[_7]])
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(_0,_0.getShape(),0,_2))
  @staticmethod
  def _index_1permute_1_alt_Lmosek_4fusion_4Variable_2_3I(_t__0,_t__1):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = mosek_fusion_Var._index_1permute_1_Lmosek_4fusion_4Variable_2_3I(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _index_1permute_1_Lmosek_4fusion_4Variable_2_3I(_0,_1):
   _2=numpy.array([_0.getShape().stride(_1[_3]) for _3 in range(0,(_0.getShape().nd))], dtype=numpy.dtype(numpy.int64))
   _4=numpy.array([_0.getShape().dim(_1[_5]) for _5 in range(0,(_0.getShape().nd))], dtype=numpy.dtype(numpy.int32))
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2J_3J(_0,mosek_fusion_NDSet._ctor__3I(_4),0,_2))
  @staticmethod
  def _match_hrepeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_hrepeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _hrepeat_alt_Lmosek_4fusion_4Variable_2I(_t__0,_t__1):
    return mosek_fusion_Var._hrepeat_Lmosek_4fusion_4Variable_2I(_0,numpy.int32(__1))
  @staticmethod
  def _hrepeat_Lmosek_4fusion_4Variable_2I(_0,_1):
   return (mosek.fusion.Var.__drepeat_Lmosek_4fusion_4Variable_2II(_0,1,_1))
  @staticmethod
  def _match_vrepeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_vrepeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _vrepeat_alt_Lmosek_4fusion_4Variable_2I(_t__0,_t__1):
    return mosek_fusion_Var._vrepeat_Lmosek_4fusion_4Variable_2I(_0,numpy.int32(__1))
  @staticmethod
  def _vrepeat_Lmosek_4fusion_4Variable_2I(_0,_1):
   return (mosek.fusion.Var.__drepeat_Lmosek_4fusion_4Variable_2II(_0,0,_1))
  @staticmethod
  def _match_repeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_repeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _repeat_alt_Lmosek_4fusion_4Variable_2I(_t__0,_t__1):
    return mosek_fusion_Var._repeat_Lmosek_4fusion_4Variable_2I(_0,numpy.int32(__1))
  @staticmethod
  def _repeat_Lmosek_4fusion_4Variable_2I(_0,_1):
   return (mosek.fusion.Var.__drepeat_Lmosek_4fusion_4Variable_2II(_0,0,_1))
  @staticmethod
  def _match_repeat_Lmosek_4fusion_4Variable_2II(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_repeat_Lmosek_4fusion_4Variable_2II(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2))
  @staticmethod
  def _repeat_alt_Lmosek_4fusion_4Variable_2II(_t__0,_t__1,_t__2):
    return mosek_fusion_Var._repeat_Lmosek_4fusion_4Variable_2II(_0,numpy.int32(__1),numpy.int32(__2))
  @staticmethod
  def _repeat_Lmosek_4fusion_4Variable_2II(_0,_1,_2):
   return (mosek.fusion.Var.__drepeat_Lmosek_4fusion_4Variable_2II(_0,_1,_2))
  @staticmethod
  def __drepeat_alt_Lmosek_4fusion_4Variable_2II(_t__0,_t__1,_t__2):
    return mosek_fusion_Var.__drepeat_Lmosek_4fusion_4Variable_2II(_0,numpy.int32(__1),numpy.int32(__2))
  @staticmethod
  def __drepeat_Lmosek_4fusion_4Variable_2II(_0,_1,_2):
   if (_2 < 0):
    raise mosek_fusion_LengthError._ctor_S("Cannot repeat less than 0 times")
   elif (_2==0):
    return (mosek_fusion_NilVariable._ctor_())
   elif (_2==1):
    return (_0)
   else:
    return (mosek_fusion_RepeatVariable._ctor_Lmosek_4fusion_4Variable_2II(_0,_1,_2))
  @staticmethod
  def _match_stack__3_3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3_3Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _match_alt_stack__3_3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3_3Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _stack_alt__3_3Lmosek_4fusion_4Variable_2(_t__0):
   _0=_monty.makeJaggedArray(_t__0,(1,1),numpy.dtype(object))
   _1 = mosek_fusion_Var._stack__3_3Lmosek_4fusion_4Variable_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _stack__3_3Lmosek_4fusion_4Variable_2(_0):
   _1=None
   for _2 in range(0,int((_0).shape[0])):
    for _3 in range(0,int((_0[_2]).shape[0])):
     if (_1 is None):
      _1 = _0[_2][_3].getModel()
     elif ((_0[_2][_3].getModel() is not None) and (_0[_2][_3].getModel() is not _1)):
      raise mosek_fusion_ModelError._ctor_S("Variables belong to different models")
   _4=0
   for _5 in range(0,int((_0).shape[0])):
    if (int((_0[_5]).shape[0]) > 0):
     _4 += 1
   _6=numpy.zeros((_4,), dtype=numpy.dtype(object))
   if (_4==0):
    return (mosek_fusion_NilVariable._ctor_())
   _7=0
   for _8 in range(0,int((_0).shape[0])):
    if (int((_0[_8]).shape[0])==0):
     pass
    elif (int((_0[_8]).shape[0])==1):
     _9=_0[_8][0]
     _6[_7] = (mosek.fusion.Var._reshape_Lmosek_4fusion_4Variable_2II(_9,_9.getShape().dim(0),1) if (((_9.getShape().nd)==1) ) else _9)
     _7 += 1
    else:
     _10=0
     for _11 in range(0,int((_0[_8]).shape[0])):
      if ((_0[_8][_11].getShape()._size) > 0):
       _10 += 1
     _12=numpy.zeros((_10,), dtype=numpy.dtype(object))
     _13=0
     for _14 in range(0,int((_0[_8]).shape[0])):
      _15=_0[_8][_14]
      if ((_15.getShape()._size) > 0):
       if ((_15.getShape().nd)==1):
        _12[_13] = mosek.fusion.Var._reshape_Lmosek_4fusion_4Variable_2II(_15,_15.getShape().dim(0),1)
       else:
        _12[_13] = _15
       _13 += 1
     _6[_7] = mosek_fusion_CompoundVariable._ctor__3Lmosek_4fusion_4Variable_2I(_12,1)
     _7 += 1
   return ((_6[0] if ((int((_6).shape[0])==1) ) else mosek_fusion_CompoundVariable._ctor__3Lmosek_4fusion_4Variable_2I(_6,0)))
  @staticmethod
  def _match_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_2))
  @staticmethod
  def _match_alt_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_2))
  @staticmethod
  def _vstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_t__0,_t__1,_t__2):
    return mosek_fusion_Var._vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1,_2)
  @staticmethod
  def _vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1,_2):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_0,_1,_2], dtype=numpy.dtype(object)),0))
  @staticmethod
  def _match_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1))
  @staticmethod
  def _match_alt_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1))
  @staticmethod
  def _vstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_t__0,_t__1):
    return mosek_fusion_Var._vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1)
  @staticmethod
  def _vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_0,_1], dtype=numpy.dtype(object)),0))
  @staticmethod
  def _match_vstack__3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _match_alt_vstack__3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _vstack_alt__3Lmosek_4fusion_4Variable_2(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1 = mosek_fusion_Var._vstack__3Lmosek_4fusion_4Variable_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _vstack__3Lmosek_4fusion_4Variable_2(_0):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(_0,0))
  @staticmethod
  def _match_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_2))
  @staticmethod
  def _match_alt_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_2))
  @staticmethod
  def _hstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_t__0,_t__1,_t__2):
    return mosek_fusion_Var._hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1,_2)
  @staticmethod
  def _hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1,_2):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_0,_1,_2], dtype=numpy.dtype(object)),1))
  @staticmethod
  def _match_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1))
  @staticmethod
  def _match_alt_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1))
  @staticmethod
  def _hstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_t__0,_t__1):
    return mosek_fusion_Var._hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1)
  @staticmethod
  def _hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_0,_1], dtype=numpy.dtype(object)),1))
  @staticmethod
  def _match_hstack__3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _match_alt_hstack__3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _hstack_alt__3Lmosek_4fusion_4Variable_2(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1 = mosek_fusion_Var._hstack__3Lmosek_4fusion_4Variable_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _hstack__3Lmosek_4fusion_4Variable_2(_0):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(_0,1))
  @staticmethod
  def _match_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_2) and __arg_match_I__(_3))
  @staticmethod
  def _match_alt_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_2) and __arg_alt_match_I__(_3))
  @staticmethod
  def _stack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_t__0,_t__1,_t__2,_t__3):
    return mosek_fusion_Var._stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_0,_1,_2,numpy.int32(__3))
  @staticmethod
  def _stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_0,_1,_2,_3):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_0,_1,_2], dtype=numpy.dtype(object)),_3))
  @staticmethod
  def _match_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_I__(_2))
  @staticmethod
  def _stack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_t__0,_t__1,_t__2):
    return mosek_fusion_Var._stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_0,_1,numpy.int32(__2))
  @staticmethod
  def _stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_0,_1,_2):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_0,_1], dtype=numpy.dtype(object)),_2))
  @staticmethod
  def _match_stack__3Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3Lmosek_4fusion_4Variable_2__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_stack__3Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _stack_alt__3Lmosek_4fusion_4Variable_2I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1=numpy.int32(_t__1)
   _1 = mosek_fusion_Var._stack__3Lmosek_4fusion_4Variable_2I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _stack__3Lmosek_4fusion_4Variable_2I(_0,_1):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(_0,_1))
  @staticmethod
  def _dstack_alt__3Lmosek_4fusion_4Variable_2I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1=numpy.int32(_t__1)
   _1 = mosek_fusion_Var._dstack__3Lmosek_4fusion_4Variable_2I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _dstack__3Lmosek_4fusion_4Variable_2I(_0,_1):
   _2=None
   for _3 in range(0,int((_0).shape[0])):
    if (_2 is None):
     _2 = _0[_3].getModel()
    elif ((_0[_3].getModel() is not None) and (_0[_3].getModel() is not _2)):
     _4=mosek.fusion.Utils.StringBuffer()
     _5=(_2._getName_() if ((int(len(_2._getName_())) > 0) ) else "?")
     _6=(_0[_3].getModel()._getName_() if ((int(len(_0[_3].getModel()._getName_())) > 0) ) else "?")
     _4._a_S("Variables belong to different models: '")._a_S(_5)._a_S("' and '")._a_S(_6)._a_S("'")
     raise mosek_fusion_ModelError._ctor_S(_4._toString_())
   if (int((_0).shape[0])==0):
    return (mosek_fusion_NilVariable._ctor_())
   elif (int((_0).shape[0])==1):
    return (_0[1])
   else:
    _7=int((_0).shape[0])
    _8=(_1 + 1)
    for _9 in range(0,_7):
     if ((_0[_9].getShape().nd) > _8):
      _8 = (_0[_9].getShape().nd)
    _10=numpy.array([_0[0].getShape().dim(_11) for _11 in range(0,_8)], dtype=numpy.dtype(numpy.int32))
    _12=numpy.zeros((_7,), dtype=numpy.dtype(object))
    _12[0] = mosek.fusion.Var._reshape_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(_0[0],mosek_fusion_NDSet._ctor__3I(_10))
    for _13 in range(1,_7):
     for _14 in range(0,_8):
      if ((_14!=_1) and (_0[_13].getShape().dim(_14)!=_10[_14])):
       raise mosek_fusion_DimensionError._ctor_S("Variable dimensions do not match")
     _10[_1] = _0[_13].getShape().dim(_1)
     _12[_13] = mosek.fusion.Var._reshape_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Set_2(_0[_13],mosek_fusion_NDSet._ctor__3I(_10))
    return (mosek_fusion_CompoundVariable._ctor__3Lmosek_4fusion_4Variable_2I(_12,_1))
 return Var
mosek_fusion_Var=__mk_mosek_fusion_Var()
del __mk_mosek_fusion_Var
#BEFORE CLASS
def __mk_mosek_fusion_ConstraintCache():
 class ConstraintCache(object):
  __slots__ = ['barmatidx','barsubj','barsubi','nbarnz','nunordered','buffer_subi','buffer_subj','buffer_cof','bfix','cof','subi','subj','nnz','nrows']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor__3J_3D_3I_3D_3I_3I_3I(*args): # []int64,[]double,[]int32,[]double,[]int32,[]int32,[]int32
      self._ctor_init__3J_3D_3I_3D_3I_3I_3I(*args)
    elif self.__match_alt_ctor__3J_3D_3I_3D_3I_3I_3I(*args):# []int64,[]double,[]int32,[]double,[]int32,[]int32,[]int32
      self._ctor_alt_init__3J_3D_3I_3D_3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.ConstraintCache.ctor(array(int64,ndim=1),array(double,ndim=1),array(int32,ndim=1),array(double,ndim=1),array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def flush(self,*args):
    if False: pass
    elif mosek_fusion_ConstraintCache._match_flush__3I_3I_3D_3D(*args): # []int32,[]int32,[]double,[]double
      return self._flush__3I_3I_3D_3D(*args)
    elif mosek_fusion_ConstraintCache._match_alt_flush__3I_3I_3D_3D(*args): # []int32,[]int32,[]double,[]double
      return self._flush_alt__3I_3I_3D_3D(*args)
    else:
      raise ValueError('Invalid argument list flush('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConstraintCache.flush(array(int32,ndim=1),array(int32,ndim=1),array(double,ndim=1),array(double,ndim=1))')
  def numUnsorted(self,*args):
    if False: pass
    elif mosek_fusion_ConstraintCache._match_numUnsorted_(*args): # 
      return self._numUnsorted_(*args)
    elif mosek_fusion_ConstraintCache._match_alt_numUnsorted_(*args): # 
      return self._numUnsorted_alt_(*args)
    else:
      raise ValueError('Invalid argument list numUnsorted('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConstraintCache.numUnsorted()')
  def add(self,*args):
    if False: pass
    elif mosek_fusion_ConstraintCache._match_add__3J_3I_3D_3D(*args): # []int64,[]int32,[]double,[]double
      return self._add__3J_3I_3D_3D(*args)
    elif mosek_fusion_ConstraintCache._match_alt_add__3J_3I_3D_3D(*args): # []int64,[]int32,[]double,[]double
      return self._add_alt__3J_3I_3D_3D(*args)
    else:
      raise ValueError('Invalid argument list add('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConstraintCache.add(array(int64,ndim=1),array(int32,ndim=1),array(double,ndim=1),array(double,ndim=1))')
  def __repr__(self): return 'mosek.fusion.ConstraintCache'
  @staticmethod
  def _ctor_Lmosek_4fusion_4ConstraintCache_2(cc):
    o = ConstraintCache.__new__(ConstraintCache)
    o._ctor_init_Lmosek_4fusion_4ConstraintCache_2(cc)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ConstraintCache_2(*args):
    if len(args) != 1: return False
    cc, = args
    return (__arg_match_Lmosek_4fusion_4ConstraintCache_2__(cc))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ConstraintCache_2(*args):
    if len(args) != 1: return False
    cc, = args
    return (__arg_alt_match_Lmosek_4fusion_4ConstraintCache_2__(cc))
  def _ctor_alt_init_Lmosek_4fusion_4ConstraintCache_2(self,cc):
    self._ctor_init_Lmosek_4fusion_4ConstraintCache_2(cc)
  def _ctor_init_Lmosek_4fusion_4ConstraintCache_2(self,cc):
   object.__init__(self)
   self.nrows = (cc.nrows)
   self.nnz = (cc.nnz)
   self.subj = (mosek.fusion.Utils.Tools._arraycopy__3I((cc.subj)) if (((cc.subj) is not None) ) else None)
   self.subi = (mosek.fusion.Utils.Tools._arraycopy__3I((cc.subi)) if (((cc.subi) is not None) ) else None)
   self.cof = (mosek.fusion.Utils.Tools._arraycopy__3D((cc.cof)) if (((cc.cof) is not None) ) else None)
   self.bfix = (mosek.fusion.Utils.Tools._arraycopy__3D((cc.bfix)) if (((cc.bfix) is not None) ) else None)
   self.buffer_cof = (mosek.fusion.Utils.Tools._arraycopy__3D((cc.buffer_cof)) if (((cc.buffer_cof) is not None) ) else None)
   self.buffer_subj = (mosek.fusion.Utils.Tools._arraycopy__3I((cc.buffer_subj)) if (((cc.buffer_subj) is not None) ) else None)
   self.buffer_subi = (mosek.fusion.Utils.Tools._arraycopy__3I((cc.buffer_subi)) if (((cc.buffer_subi) is not None) ) else None)
   self.nunordered = (cc.nunordered)
   self.nbarnz = (cc.nbarnz)
   self.barsubi = (mosek.fusion.Utils.Tools._arraycopy__3I((cc.barsubi)) if (((cc.barsubi) is not None) ) else None)
   self.barsubj = (mosek.fusion.Utils.Tools._arraycopy__3I((cc.barsubj)) if (((cc.barsubj) is not None) ) else None)
   self.barmatidx = (mosek.fusion.Utils.Tools._arraycopy__3I((cc.barmatidx)) if (((cc.barmatidx) is not None) ) else None)
  @staticmethod
  def _ctor__3J_3D_3I_3D_3I_3I_3I(ptrb_,cof_,subj_,bfix_,barsubi_,barsubj_,barmatidx_):
    o = ConstraintCache.__new__(ConstraintCache)
    o._ctor_init__3J_3D_3I_3D_3I_3I_3I(ptrb_,cof_,subj_,bfix_,barsubi_,barsubj_,barmatidx_)
    return o
  @staticmethod
  def __match_ctor__3J_3D_3I_3D_3I_3I_3I(*args):
    if len(args) != 7: return False
    ptrb_,cof_,subj_,bfix_,barsubi_,barsubj_,barmatidx_, = args
    return (__arg_match__3J__(ptrb_) and __arg_match__3D__(cof_) and __arg_match__3I__(subj_) and __arg_match__3D__(bfix_) and __arg_match__3I__(barsubi_) and __arg_match__3I__(barsubj_) and __arg_match__3I__(barmatidx_))
  @staticmethod
  def __match_alt_ctor__3J_3D_3I_3D_3I_3I_3I(*args):
    if len(args) != 7: return False
    ptrb_,cof_,subj_,bfix_,barsubi_,barsubj_,barmatidx_, = args
    return (__arg_alt_match__3J__(ptrb_) and __arg_alt_match__3D__(cof_) and __arg_alt_match__3I__(subj_) and __arg_alt_match__3D__(bfix_) and __arg_alt_match__3I__(barsubi_) and __arg_alt_match__3I__(barsubj_) and __arg_alt_match__3I__(barmatidx_))
  def _ctor_alt_init__3J_3D_3I_3D_3I_3I_3I(self,ptrb_,cof_,subj_,bfix_,barsubi_,barsubj_,barmatidx_):
    self._ctor_init__3J_3D_3I_3D_3I_3I_3I(numpy.array(ptrb_,dtype=numpy.dtype(numpy.int64)),numpy.array(cof_,dtype=numpy.dtype(numpy.float64)),numpy.array(subj_,dtype=numpy.dtype(numpy.int32)),numpy.array(bfix_,dtype=numpy.dtype(numpy.float64)),numpy.array(barsubi_,dtype=numpy.dtype(numpy.int32)),numpy.array(barsubj_,dtype=numpy.dtype(numpy.int32)),numpy.array(barmatidx_,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init__3J_3D_3I_3D_3I_3I_3I(self,ptrb_,cof_,subj_,bfix_,barsubi_,barsubj_,barmatidx_):
   object.__init__(self)
   self.nrows = (int((ptrb_).shape[0]) - 1)
   self.nnz = ptrb_[(int((ptrb_).shape[0]) - 1)]
   self.subj = numpy.zeros((self.nnz,), dtype=numpy.dtype(numpy.int32))
   self.subi = numpy.zeros((self.nnz,), dtype=numpy.dtype(numpy.int32))
   self.cof = numpy.zeros((self.nnz,), dtype=numpy.dtype(numpy.float64))
   if (bfix_ is not None):
    self.bfix = bfix_
   else:
    self.bfix = numpy.zeros((self.nrows,), dtype=numpy.dtype(numpy.float64))
   if ((barsubi_ is not None) and ((barsubj_ is not None) and (barmatidx_ is not None))):
    self.nbarnz = int((barsubi_).shape[0])
    if (self.nbarnz > int((barsubj_).shape[0])):
     self.nbarnz = int((barsubj_).shape[0])
    if (self.nbarnz > int((barmatidx_).shape[0])):
     self.nbarnz = int((barmatidx_).shape[0])
    self.barsubi = numpy.zeros((self.nbarnz,), dtype=numpy.dtype(numpy.int32))
    self.barsubj = numpy.zeros((self.nbarnz,), dtype=numpy.dtype(numpy.int32))
    self.barmatidx = numpy.zeros((self.nbarnz,), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3IJ_3IJJ(barsubi_,0,self.barsubi,0,self.nbarnz)
    mosek.fusion.Utils.Tools._arraycopy__3IJ_3IJJ(barsubj_,0,self.barsubj,0,self.nbarnz)
    mosek.fusion.Utils.Tools._arraycopy__3IJ_3IJJ(barmatidx_,0,self.barmatidx,0,self.nbarnz)
   else:
    self.nbarnz = 0
    self.barsubi = None
    self.barsubj = None
    self.barmatidx = None
   mosek.fusion.Utils.Tools._arraycopy__3IJ_3IJJ(subj_,0,self.subj,0,self.nnz)
   mosek.fusion.Utils.Tools._arraycopy__3DJ_3DJJ(cof_,0,self.cof,0,self.nnz)
   for _0 in range(0,self.nrows):
    for _1 in range(ptrb_[_0],ptrb_[(_0 + 1)]):
     self.subi[_1] = _0
   self.buffer_cof = None
   self.buffer_subj = None
   self.buffer_subi = None
   self.nunordered = 0
  def _unchecked_1add_1fx_alt__3D(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1 = self._unchecked_1add_1fx__3D(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _unchecked_1add_1fx__3D(self,_0):
   for _1 in range(0,self.nrows):
    self.bfix[_1] = (self.bfix[_1] + _0[_1])
  def _order_1barentries_alt_(self,):
    return self._order_1barentries_()
  def _order_1barentries_(self,):
   _0=numpy.array([_1 for _1 in range(0,self.nbarnz)], dtype=numpy.dtype(numpy.int64))
   if (not mosek.fusion.Sort._issorted__3J_3I_3IJJZ(_0,self.barsubi,self.barsubj,0,self.nbarnz,False)):
    mosek.fusion.Sort._argsort__3J_3I_3IJJZ(_0,self.barsubi,self.barsubj,0,self.nbarnz,False)
    _2=self.barsubi
    _3=self.barsubj
    _4=self.barmatidx
    self.barsubi = numpy.array([_2[_0[_5]] for _5 in range(0,self.nbarnz)], dtype=numpy.dtype(numpy.int32))
    self.barsubj = numpy.array([_3[_0[_6]] for _6 in range(0,self.nbarnz)], dtype=numpy.dtype(numpy.int32))
    self.barmatidx = numpy.array([_4[_0[_7]] for _7 in range(0,self.nbarnz)], dtype=numpy.dtype(numpy.int32))
   return numpy.int64(self.nbarnz)
  def _add_1bar_alt__3I_3I_3I(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _1 = self._add_1bar__3I_3I_3I(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _add_1bar__3I_3I_3I(self,_0,_1,_2):
   if (_0 is not None):
    _3=int((_0).shape[0])
    if (int((_0).shape[0]) <= (self.nbarnz + _3)):
     _4=self.barsubi
     _5=self.barsubj
     _6=self.barmatidx
     _7=((2 * self.nbarnz) if (((2 * self.nbarnz) > (self.nbarnz + _3)) ) else (self.nbarnz + (_3 * 2)))
     self.barsubi = numpy.zeros((_7,), dtype=numpy.dtype(numpy.int32))
     self.barsubj = numpy.zeros((_7,), dtype=numpy.dtype(numpy.int32))
     self.barmatidx = numpy.zeros((_7,), dtype=numpy.dtype(numpy.int32))
     if (self.nbarnz > 0):
      mosek.fusion.Utils.Tools._arraycopy__3IJ_3IJJ(_4,0,self.barsubi,0,self.nbarnz)
      mosek.fusion.Utils.Tools._arraycopy__3IJ_3IJJ(_5,0,self.barsubj,0,self.nbarnz)
      mosek.fusion.Utils.Tools._arraycopy__3IJ_3IJJ(_6,0,self.barmatidx,0,self.nbarnz)
    mosek.fusion.Utils.Tools._arraycopy__3IJ_3IJJ(_0,0,self.barsubi,self.nbarnz,_3)
    mosek.fusion.Utils.Tools._arraycopy__3IJ_3IJJ(_1,0,self.barsubj,self.nbarnz,_3)
    mosek.fusion.Utils.Tools._arraycopy__3IJ_3IJJ(_2,0,self.barmatidx,self.nbarnz,_3)
    self.nbarnz += _3
  def _unchecked_1add_1l_alt__3J_3I_3D_3D(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.float64))
   _1 = self._unchecked_1add_1l__3J_3I_3D_3D(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _unchecked_1add_1l__3J_3I_3D_3D(self,_0,_1,_2,_3):
   _4=(self.nunordered + _0[self.nrows])
   _5=_0[self.nrows]
   if ((self.buffer_cof is None) or (int((self.buffer_cof).shape[0]) < _4)):
    _6 = numpy.zeros((_4,), dtype=numpy.dtype(numpy.int32))
    _7 = numpy.zeros((_4,), dtype=numpy.dtype(numpy.int32))
    _8 = numpy.zeros((_4,), dtype=numpy.dtype(numpy.float64))
    if (self.buffer_cof is not None):
     mosek.fusion.Utils.Tools._arraycopy__3IJ_3IJJ(self.buffer_subi,0,_6,0,self.nunordered)
     mosek.fusion.Utils.Tools._arraycopy__3IJ_3IJJ(self.buffer_subj,0,_7,0,self.nunordered)
     mosek.fusion.Utils.Tools._arraycopy__3DJ_3DJJ(self.buffer_cof,0,_8,0,self.nunordered)
   else:
    _6 = self.buffer_subi
    _7 = self.buffer_subj
    _8 = self.buffer_cof
   for _9 in range(0,self.nrows):
    for _10 in range(_0[_9],_0[(_9 + 1)]):
     _6[(self.nunordered + _10)] = _9
   mosek.fusion.Utils.Tools._arraycopy__3IJ_3IJJ(_1,0,_7,self.nunordered,_5)
   mosek.fusion.Utils.Tools._arraycopy__3DJ_3DJJ(_2,0,_8,self.nunordered,_5)
   self.buffer_subi = _6
   self.buffer_subj = _7
   self.buffer_cof = _8
   if (_3 is not None):
    for _11 in range(0,self.nrows):
     self.bfix[_11] = (self.bfix[_11] + _3[_11])
   self.nunordered = _4
   self.nnz = (self.nnz + _5)
  @staticmethod
  def _match_add__3J_3I_3D_3D(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match__3D__(_2) and __arg_match__3D__(_3))
  @staticmethod
  def _match_alt_add__3J_3I_3D_3D(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match__3D__(_3))
  def _add_alt__3J_3I_3D_3D(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.float64))
   _1 = self._add__3J_3I_3D_3D(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _add__3J_3I_3D_3D(self,_0,_1,_2,_3):
   if ((int((_0).shape[0])!=(self.nrows + 1)) or ((_3 is not None) and (int((_3).shape[0])!=self.nrows))):
    raise mosek_fusion_LengthError._ctor_S("Mismatching expression lengths")
   self._unchecked_1add_1l__3J_3I_3D_3D(_0,_1,_2,_3)
  @staticmethod
  def _match_flush__3I_3I_3D_3D(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1) and __arg_match__3D__(_2) and __arg_match__3D__(_3))
  @staticmethod
  def _match_alt_flush__3I_3I_3D_3D(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match__3D__(_3))
  def _flush_alt__3I_3I_3D_3D(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.float64))
   _1 = self._flush__3I_3I_3D_3D(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _flush__3I_3I_3D_3D(self,_0,_1,_2,_3):
   _4=None
   if ((self.bfix is not None) and (_3 is not None)):
    for _5 in range(0,self.nrows):
     _3[_5] = self.bfix[_5]
   if (self.nunordered==0):
    return numpy.int64(0)
   _6=False
   _7=1
   while ((_7 < self.nunordered) and ((self.buffer_subi[(_7 - 1)] < self.buffer_subi[_7]) or ((self.buffer_subi[(_7 - 1)]==self.buffer_subi[_7]) and (self.buffer_subj[(_7 - 1)] <= self.buffer_subj[_7])))):
    _7 += 1
   _6 = (_7==self.nunordered)
   if (not _6):
    _4 = numpy.array([_8 for _8 in range(0,self.nunordered)], dtype=numpy.dtype(numpy.int64))
    mosek.fusion.CommonTools._argQsort__3J_3I_3IJJ(_4,self.buffer_subi,self.buffer_subj,0,self.nunordered)
   _9=int((self.subi).shape[0])
   _10=numpy.zeros(((self.nunordered + _9),), dtype=numpy.dtype(numpy.int32))
   _11=numpy.zeros(((self.nunordered + _9),), dtype=numpy.dtype(numpy.int32))
   _12=numpy.zeros(((self.nunordered + _9),), dtype=numpy.dtype(numpy.float64))
   _13=0
   if _6:
    _14=0
    _15=0
    _16=_9
    _17=self.nunordered
    _18=0
    _19=0
    while ((_14 < _16) and (_15 < _17)):
     if ((self.subi[_14] < self.buffer_subi[_15]) or ((self.subi[_14]==self.buffer_subi[_15]) and (self.subj[_14] < self.buffer_subj[_15]))):
      _10[_18] = self.subi[_14]
      _11[_18] = self.subj[_14]
      _12[_18] = self.cof[_14]
      _14 += 1
      _18 += 1
     elif ((self.subi[_14] > self.buffer_subi[_15]) or ((self.subi[_14]==self.buffer_subi[_15]) and (self.subj[_14] > self.buffer_subj[_15]))):
      _10[_18] = self.buffer_subi[_15]
      _11[_18] = self.buffer_subj[_15]
      _12[_18] = self.buffer_cof[_15]
      _0[_13] = _10[_18]
      _1[_13] = _11[_18]
      _2[_13] = _12[_18]
      _13 += 1
      _15 += 1
      _18 += 1
     else:
      _10[_18] = self.subi[_14]
      _11[_18] = self.subj[_14]
      _12[_18] = self.cof[_14]
      while ((_14 < int((self.subi).shape[0])) and ((_15 < int((self.buffer_subi).shape[0])) and ((self.subi[_14]==self.buffer_subi[_15]) and (self.subj[_14]==self.buffer_subj[_15])))):
       _12[_18] = (_12[_18] + self.buffer_cof[_15])
       _15 += 1
      _0[_13] = _10[_18]
      _1[_13] = _11[_18]
      _2[_13] = _12[_18]
      _13 += 1
      _14 += 1
      _18 += 1
    while (_14 < _16):
     _10[_18] = self.subi[_14]
     _11[_18] = self.subj[_14]
     _12[_18] = self.cof[_14]
     _14 += 1
     _18 += 1
    while (_15 < _17):
     _10[_18] = self.buffer_subi[_15]
     _11[_18] = self.buffer_subj[_15]
     _12[_18] = self.buffer_cof[_15]
     _0[_13] = _10[_18]
     _1[_13] = _11[_18]
     _2[_13] = _12[_18]
     _13 += 1
     _15 += 1
     _18 += 1
   else:
    _20=0
    _21=0
    _22=_9
    _23=self.nunordered
    _24=0
    _25=0
    while ((_20 < _22) and (_21 < _23)):
     if ((self.subi[_20] < self.buffer_subi[_4[_21]]) or ((self.subi[_20]==self.buffer_subi[_4[_21]]) and (self.subj[_20] < self.buffer_subj[_4[_21]]))):
      _10[_24] = self.subi[_20]
      _11[_24] = self.subj[_20]
      _12[_24] = self.cof[_20]
      _20 += 1
      _24 += 1
     elif ((self.subi[_20] > self.buffer_subi[_4[_21]]) or ((self.subi[_20]==self.buffer_subi[_4[_21]]) and (self.subj[_20] > self.buffer_subj[_4[_21]]))):
      _10[_24] = self.buffer_subi[_4[_21]]
      _11[_24] = self.buffer_subj[_4[_21]]
      _12[_24] = self.buffer_cof[_4[_21]]
      _0[_13] = _10[_24]
      _1[_13] = _11[_24]
      _2[_13] = _12[_24]
      _13 += 1
      _21 += 1
      _24 += 1
     else:
      _10[_24] = self.subi[_20]
      _11[_24] = self.subj[_20]
      _12[_24] = self.cof[_20]
      while ((self.subi[_20]==self.buffer_subi[_4[_21]]) and (self.subj[_20]==self.buffer_subj[_4[_21]])):
       _12[_24] = (_12[_24] + self.buffer_cof[_4[_21]])
       _21 += 1
      _0[_13] = _10[_24]
      _1[_13] = _11[_24]
      _2[_13] = _12[_24]
      _13 += 1
      _20 += 1
      _24 += 1
   self.subi = _10
   self.subj = _11
   self.cof = _12
   self.nunordered = 0
   return numpy.int64(_13)
  @staticmethod
  def _match_numUnsorted_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_numUnsorted_(*args):
    if len(args) != 0: return False
    return True
  def _numUnsorted_alt_(self,):
    return self._numUnsorted_()
  def _numUnsorted_(self,):
   return numpy.int64(self.nunordered)
  def _clone_alt_(self,):
    return self._clone_()
  def _clone_(self,):
   return (mosek_fusion_ConstraintCache._ctor_Lmosek_4fusion_4ConstraintCache_2(self))
 return ConstraintCache
mosek_fusion_ConstraintCache=__mk_mosek_fusion_ConstraintCache()
del __mk_mosek_fusion_ConstraintCache
#BEFORE CLASS
def __mk_mosek_fusion_Constraint():
 class Constraint(object):
  __slots__ = ['_shape_p','_model']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args): # mosek.fusion.Constraint,mosek.fusion.Model
      self._ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args):# mosek.fusion.Constraint,mosek.fusion.Model
      self._ctor_alt_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(*args): # mosek.fusion.Model,mosek.fusion.Set
      self._ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(*args):# mosek.fusion.Model,mosek.fusion.Set
      self._ctor_alt_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.Constraint.ctor(mosek.fusion.Constraint,mosek.fusion.Model)\n\tmosek.fusion.Constraint.ctor(mosek.fusion.Model,mosek.fusion.Set)')
  def get_nd(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_get_1nd_(*args): # 
      return self._get_1nd_(*args)
    elif mosek_fusion_Constraint._match_alt_get_1nd_(*args): # 
      return self._get_1nd_alt_(*args)
    else:
      raise ValueError('Invalid argument list get_nd('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.get_nd()')
  def add(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_add_Lmosek_4fusion_4Expression_2(*args): # mosek.fusion.Expression
      return self._add_Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_Constraint._match_alt_add_Lmosek_4fusion_4Expression_2(*args): # mosek.fusion.Expression
      return self._add_alt_Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_Constraint._match_add_Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.Variable
      return self._add_Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Constraint._match_alt_add_Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.Variable
      return self._add_alt_Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Constraint._match_add__3D(*args): # []double
      return self._add__3D(*args)
    elif mosek_fusion_Constraint._match_alt_add__3D(*args): # []double
      return self._add_alt__3D(*args)
    elif mosek_fusion_Constraint._match_add_D(*args): # double
      return self._add_D(*args)
    elif mosek_fusion_Constraint._match_alt_add_D(*args): # double
      return self._add_alt_D(*args)
    else:
      raise ValueError('Invalid argument list add('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.add(mosek.fusion.Expression)\n\tmosek.fusion.Constraint.add(mosek.fusion.Variable)\n\tmosek.fusion.Constraint.add(array(double,ndim=1))\n\tmosek.fusion.Constraint.add(double)')
  def index(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_index_I(*args): # int32
      return self._index_I(*args)
    elif mosek_fusion_Constraint._match_alt_index_I(*args): # int32
      return self._index_alt_I(*args)
    elif mosek_fusion_Constraint._match_index__3I(*args): # []int32
      return self._index__3I(*args)
    elif mosek_fusion_Constraint._match_alt_index__3I(*args): # []int32
      return self._index_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.index(int32)\n\tmosek.fusion.Constraint.index(array(int32,ndim=1))')
  def shape(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_shape_(*args): # 
      return self._shape_(*args)
    elif mosek_fusion_Constraint._match_alt_shape_(*args): # 
      return self._shape_alt_(*args)
    else:
      raise ValueError('Invalid argument list shape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.shape()')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_toString_(*args): # 
      return self._toString_(*args)
    elif mosek_fusion_Constraint._match_alt_toString_(*args): # 
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.toString()')
  @staticmethod
  def stack(*args):
    if False: pass
    elif mosek_fusion_Constraint._match_stack__3Lmosek_4fusion_4Constraint_2(*args): # []mosek.fusion.Constraint
      return mosek_fusion_Constraint._stack__3Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_alt_stack__3Lmosek_4fusion_4Constraint_2(*args): # []mosek.fusion.Constraint
      return mosek_fusion_Constraint._stack_alt__3Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args): # mosek.fusion.Constraint,mosek.fusion.Constraint
      return mosek_fusion_Constraint._stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_alt_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args): # mosek.fusion.Constraint,mosek.fusion.Constraint
      return mosek_fusion_Constraint._stack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args): # mosek.fusion.Constraint,mosek.fusion.Constraint,mosek.fusion.Constraint
      return mosek_fusion_Constraint._stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_alt_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args): # mosek.fusion.Constraint,mosek.fusion.Constraint,mosek.fusion.Constraint
      return mosek_fusion_Constraint._stack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    else:
      raise ValueError('Invalid argument list stack('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.stack(array(mosek.fusion.Constraint,ndim=1))\n\tmosek.fusion.Constraint.stack(mosek.fusion.Constraint,mosek.fusion.Constraint)\n\tmosek.fusion.Constraint.stack(mosek.fusion.Constraint,mosek.fusion.Constraint,mosek.fusion.Constraint)')
  def level(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_level_(*args): # 
      return self._level_(*args)
    elif mosek_fusion_Constraint._match_alt_level_(*args): # 
      return self._level_alt_(*args)
    else:
      raise ValueError('Invalid argument list level('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.level()')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_slice_II(*args): # int32,int32
      return self._slice_II(*args)
    elif mosek_fusion_Constraint._match_alt_slice_II(*args): # int32,int32
      return self._slice_alt_II(*args)
    elif mosek_fusion_Constraint._match_slice__3I_3I(*args): # []int32,[]int32
      return self._slice__3I_3I(*args)
    elif mosek_fusion_Constraint._match_alt_slice__3I_3I(*args): # []int32,[]int32
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.slice(int32,int32)\n\tmosek.fusion.Constraint.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def get_model(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_get_1model_(*args): # 
      return self._get_1model_(*args)
    elif mosek_fusion_Constraint._match_alt_get_1model_(*args): # 
      return self._get_1model_alt_(*args)
    else:
      raise ValueError('Invalid argument list get_model('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.get_model()')
  def size(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_size_(*args): # 
      return self._size_(*args)
    elif mosek_fusion_Constraint._match_alt_size_(*args): # 
      return self._size_alt_(*args)
    else:
      raise ValueError('Invalid argument list size('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.size()')
  def dual(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_dual_(*args): # 
      return self._dual_(*args)
    elif mosek_fusion_Constraint._match_alt_dual_(*args): # 
      return self._dual_alt_(*args)
    elif mosek_fusion_Constraint._match_dual_II(*args): # int32,int32
      return self._dual_II(*args)
    elif mosek_fusion_Constraint._match_alt_dual_II(*args): # int32,int32
      return self._dual_alt_II(*args)
    elif mosek_fusion_Constraint._match_dual__3I_3I(*args): # []int32,[]int32
      return self._dual__3I_3I(*args)
    elif mosek_fusion_Constraint._match_alt_dual__3I_3I(*args): # []int32,[]int32
      return self._dual_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list dual('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.dual()\n\tmosek.fusion.Constraint.dual(int32,int32)\n\tmosek.fusion.Constraint.dual(array(int32,ndim=1),array(int32,ndim=1))')
  def __str__(self): return self._toString_()
  def __repr__(self): return 'mosek.fusion.Constraint: '+self._toString_()
  @staticmethod
  def _ctor_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(c,m):
    o = Constraint.__new__(Constraint)
    o._ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(self,c,m):
   object.__init__(self)
   self._model = m
   self._shape_p = (c._shape_p)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(model_,shape_):
    o = Constraint.__new__(Constraint)
    o._ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(model_,shape_)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(*args):
    if len(args) != 2: return False
    model_,shape_, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model_) and __arg_match_Lmosek_4fusion_4Set_2__(shape_))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(*args):
    if len(args) != 2: return False
    model_,shape_, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model_) and __arg_alt_match_Lmosek_4fusion_4Set_2__(shape_))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(self,model_,shape_):
    self._ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(model_,shape_)
  def _ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(self,model_,shape_):
   object.__init__(self)
   self._model = model_
   self._shape_p = shape_
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=(self._shape_p._size)
   _1=numpy.zeros((_0,), dtype=numpy.dtype(object))
   self._toStringArray__3JJ_3S(mosek.fusion.Utils.Tools._range_J(_0),0,_1)
   _2=mosek.fusion.Utils.StringBuffer()
   _2._a_S("Constraint( (")._a_I(self._shape_p.dim(0))
   for _3 in range(1,(self._shape_p.nd)):
    _2._a_S(",")._a_I(self._shape_p.dim(_3))
   _2._a_S("),")._lf_()
   _2._a_S("  ")._a_S(_1[0])
   for _4 in range(1,int((_1).shape[0])):
    _2._a_S(",")._lf_()._a_S("  ")._a_S(_1[_4])
   _2._a_S(" )")
   return (_2._toString_())
  def _toStringArray_alt__3JJ_3S(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(object))
   _1 = self._toStringArray__3JJ_3S(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _toStringArray__3JJ_3S(self,_0,_1,_2):
   pass
  @staticmethod
  def _match_add_D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_D__(_0))
  @staticmethod
  def _match_alt_add_D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_D__(_0))
  def _add_alt_D(self,_t__0):
    return self._add_D(numpy.float64(__0))
  def _add_D(self,_0):
   _1=(self._shape_p._size)
   self._add_1l__3J_3J_3I_3I_3I_3D_3DJII(numpy.array([_2 for _2 in range(0,_1)], dtype=numpy.dtype(numpy.int64)),numpy.array([0 for _3 in range(0,(_1 + 1))], dtype=numpy.dtype(numpy.int64)),numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),numpy.zeros((0,), dtype=numpy.dtype(numpy.float64)),numpy.array([_0 for _4 in range(0,_1)], dtype=numpy.dtype(numpy.float64)),0,0,numpy.int32(_1))
   return (self)
  @staticmethod
  def _match_add__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3D__(_0))
  @staticmethod
  def _match_alt_add__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3D__(_0))
  def _add_alt__3D(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1 = self._add__3D(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _add__3D(self,_0):
   _1=(self._shape_p._size)
   if (((self._shape_p.nd)!=1) or (int((_0).shape[0])!=self._shape_p.dim(0))):
    raise mosek_fusion_DimensionError._ctor_S("The added constant array does not have the same shape as the constraint")
   self._add_1l__3J_3J_3I_3I_3I_3D_3DJII(numpy.array([_2 for _2 in range(0,_1)], dtype=numpy.dtype(numpy.int64)),numpy.array([0 for _3 in range(0,(_1 + 1))], dtype=numpy.dtype(numpy.int64)),numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),numpy.zeros((0,), dtype=numpy.dtype(numpy.float64)),_0,0,0,numpy.int32(_1))
   return (self)
  @staticmethod
  def _match_add_Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _match_alt_add_Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0))
  def _add_alt_Lmosek_4fusion_4Variable_2(self,_t__0):
    return self._add_Lmosek_4fusion_4Variable_2(_0)
  def _add_Lmosek_4fusion_4Variable_2(self,_0):
   if (not _0.shape().compare(self._shape_p)):
    raise mosek_fusion_DimensionError._ctor_S("The added variable does not have the same shape as the constraint")
   _1=(_0.getShape()._size)
   _2=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int32))
   _3=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int32))
   _4=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int32))
   _5=mosek.fusion.Utils.Tools._range_JJ(0,(_1 + 1))
   _6=numpy.zeros((_1,), dtype=numpy.dtype(numpy.float64))
   for _7 in range(0,_1):
    _0.inst(_7,_7,_2,_3,_4)
    _6[_7] = 1.0
   _8=mosek.fusion.Utils.Tools._range_JJ(0,_1)
   self._add_1l__3J_3J_3I_3I_3I_3D_3DJII(_8,_5,_2,_3,_3,_6,None,0,0,numpy.int32(_1))
   return (self)
  @staticmethod
  def _match_add_Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_0))
  @staticmethod
  def _match_alt_add_Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_0))
  def _add_alt_Lmosek_4fusion_4Expression_2(self,_t__0):
    return self._add_Lmosek_4fusion_4Expression_2(_0)
  def _add_Lmosek_4fusion_4Expression_2(self,_0):
   if (not _0.shape().compare(self._shape_p)):
    raise mosek_fusion_DimensionError._ctor_S("The added expression does not have the same shape as the constraint")
   _1=_0.eval()
   _2=(int(((_1.ptrb)).shape[0]) - 1)
   _3=numpy.zeros(((_1.nnz),), dtype=numpy.dtype(numpy.int32))
   _4=numpy.zeros(((_1.nnz),), dtype=numpy.dtype(numpy.int32))
   _5=numpy.zeros(((_1.nnz),), dtype=numpy.dtype(numpy.int32))
   mosek.fusion.Constraint._inst__3Lmosek_4fusion_4Variable_2_3J_3I_3I_3I((_1.x),(_1.subj),_3,_3,_3)
   _6=(_1.inst)
   if (_6 is None):
    _6 = mosek.fusion.Utils.Tools._range_JJ(0,numpy.int64(_2))
   self._add_1l__3J_3J_3I_3I_3I_3D_3DJII(_6,(_1.ptrb),_3,_4,_5,(_1.cof),(_1.bfix),0,0,_2)
   return (self)
  @staticmethod
  def _inst_alt__3Lmosek_4fusion_4Variable_2_3J_3I_3I_3I(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1 = mosek_fusion_Constraint._inst__3Lmosek_4fusion_4Variable_2_3J_3I_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _inst__3Lmosek_4fusion_4Variable_2_3J_3I_3I_3I(_0,_1,_2,_3,_4):
   _5=numpy.zeros(((int((_0).shape[0]) + 1),), dtype=numpy.dtype(numpy.int64))
   for _6 in range(0,int((_0).shape[0])):
    _5[(_6 + 1)] = (_5[_6] + _0[_6].size())
   for _7 in range(0,int((_1).shape[0])):
    _8=(int((_5).shape[0]) // 2)
    _9=0
    _10=(int((_5).shape[0]) - 1)
    _11=0
    while (_9 < _10):
     _11 = ((_9 + _10) // 2)
     if (_1[_7] < _5[_11]):
      _10 = _11
     elif (_1[_7] >= _5[(_11 + 1)]):
      _9 = _11
     else:
      _9 = _11
      _10 = _11
    _8 = _11
    _0[_8].inst((_1[_7] - _5[_8]),numpy.int64(_7),_2,_3,_4)
  def _add_1l_alt__3J_3J_3I_3I_3I_3D_3DJII(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7,_t__8,_t__9):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.float64))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.float64))
   _7=numpy.int64(_t__7)
   _8=numpy.int32(_t__8)
   _9=numpy.int32(_t__9)
   _1 = self._add_1l__3J_3J_3I_3I_3I_3D_3DJII(_0,_1,_2,_3,_4,_5,_6,_7,_8,_9)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _add_1l__3J_3J_3I_3I_3I_3D_3DJII(self,_0,_1,_2,_3,_4,_5,_6,_7,_8,_9):
   pass
  @staticmethod
  def _match_dual__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_dual__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _dual_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self._dual__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual__3I_3I(self,_0,_1):
   if (((self._shape_p.nd)!=int((_0).shape[0])) or ((self._shape_p.nd)!=int((_1).shape[0]))):
    raise mosek_fusion_SliceError._ctor_S("Invalid slice specification")
   _2=1
   _3=0
   while (_3 < (self._shape_p.nd)):
    if ((_0[_3] > _1[_3]) or ((_0[_3] < 0) or (_1[_3] >= self._shape_p.dim(_3)))):
     raise mosek_fusion_SliceError._ctor_S("Slice index out of bound")
    _2 = (_2 * (_1[_3] * _0[_3]))
    _3 += 1
   _4=numpy.zeros((_2,), dtype=numpy.dtype(numpy.float64))
   _5=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int32))
   _6=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int64))
   _7=0
   for _8 in range(0,(self._shape_p.nd)):
    _5[_8] = (_1[_8] - _0[_8])
    _6[_8] = self._shape_p.stride(_8)
    _7 = (_7 + (_6[_8] * _0[_8]))
   self._dual_1values_J_3I_3JI_3D(_7,_5,_6,0,_4)
   return (_4)
  @staticmethod
  def _match_dual_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_dual_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _dual_alt_II(self,_t__0,_t__1):
    return self._dual_II(numpy.int32(__0),numpy.int32(__1))
  def _dual_II(self,_0,_1):
   if (((self._shape_p.nd)!=1) or ((_0 > _1) or ((_0 < 0) or (_1 >= self._shape_p.dim(0))))):
    raise mosek_fusion_SliceError._ctor_S("Invalid slice specification")
   _2=(_1 - _0)
   _3=numpy.zeros((_2,), dtype=numpy.dtype(numpy.float64))
   self._dual_1values_J_3I_3JI_3D(_0,numpy.array([_2], dtype=numpy.dtype(numpy.int32)),numpy.array([1], dtype=numpy.dtype(numpy.int64)),0,_3)
   return (_3)
  @staticmethod
  def _match_dual_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dual_(*args):
    if len(args) != 0: return False
    return True
  def _dual_alt_(self,):
    return self._dual_()
  def _dual_(self,):
   _0=numpy.zeros(((self._shape_p._size),), dtype=numpy.dtype(numpy.float64))
   self._dual_1values_I_3D(0,_0)
   return (_0)
  def _dual_1values_alt_I_3D(self,_t__0,_t__1):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1values_I_3D(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1values_I_3D(self,_0,_1):
   _2=numpy.array([self._shape_p.dim(_3) for _3 in range(0,(self._shape_p.nd))], dtype=numpy.dtype(numpy.int32))
   _4=numpy.array([self._shape_p.stride(_5) for _5 in range(0,(self._shape_p.nd))], dtype=numpy.dtype(numpy.int64))
   self._dual_1values_J_3I_3JI_3D(0,_2,_4,_0,_1)
  def _dual_1values_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1values__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1values__3JI_3D(self,_0,_1,_2):
   pass
  def _dual_1values_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1values_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   pass
  @staticmethod
  def _match_level_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_level_(*args):
    if len(args) != 0: return False
    return True
  def _level_alt_(self,):
    return self._level_()
  def _level_(self,):
   _0=numpy.zeros(((self._shape_p._size),), dtype=numpy.dtype(numpy.float64))
   self._level_1values_I_3D(0,_0)
   return (_0)
  def _level_alt_I(self,_t__0):
    return self._level_I(numpy.int32(__0))
  def _level_I(self,_0):
   if (((self._shape_p.nd)!=1) or ((_0 < 0) or (_0 >= self._shape_p.dim(0)))):
    raise mosek_fusion_SliceError._ctor_S("Invalid index.")
   _1=numpy.array([numpy.int64(_0)], dtype=numpy.dtype(numpy.int64))
   _2=numpy.zeros((1,), dtype=numpy.dtype(numpy.float64))
   self._level_1values__3JI_3D(_1,0,_2)
   return numpy.float64(_2[0])
  def _level_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self._level__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _level__3I_3I(self,_0,_1):
   if (((self._shape_p.nd)!=int((_0).shape[0])) or ((self._shape_p.nd)!=int((_1).shape[0]))):
    raise mosek_fusion_SliceError._ctor_S("Invalid slice specification")
   _2=1
   _3=0
   while (_3 < (self._shape_p.nd)):
    if ((_0[_3] > _1[_3]) or ((_0[_3] < 0) or (_1[_3] > self._shape_p.dim(_3)))):
     raise mosek_fusion_SliceError._ctor_S("Slice index out of bound")
    _2 = (_2 * (_1[_3] - _0[_3]))
    _3 += 1
   _4=numpy.zeros((_2,), dtype=numpy.dtype(numpy.float64))
   if (_2 > 0):
    _5=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int32))
    _6=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int64))
    for _7 in range(0,(self._shape_p.nd)):
     _6[_7] = self._shape_p.stride(_7)
    for _8 in range(0,(self._shape_p.nd)):
     _5[_8] = (_1[_8] - _0[_8])
    _9=0
    for _10 in range(0,(self._shape_p.nd)):
     _9 = (_9 + (numpy.int64(_0[_10]) * _6[_10]))
    self._level_1values_J_3I_3JI_3D(_9,_5,_6,0,_4)
   return (_4)
  def _level_alt_II(self,_t__0,_t__1):
    return self._level_II(numpy.int32(__0),numpy.int32(__1))
  def _level_II(self,_0,_1):
   if (((self._shape_p.nd)!=1) or ((_0 < 0) or ((_0 > _1) or (_1 > self._shape_p.dim(0))))):
    raise mosek_fusion_SliceError._ctor_S("Invalid slice specification")
   _2=(_1 - _0)
   _3=numpy.zeros((_2,), dtype=numpy.dtype(numpy.float64))
   _4=numpy.array([(_1 - _0)], dtype=numpy.dtype(numpy.int32))
   _5=numpy.array([1], dtype=numpy.dtype(numpy.int64))
   self._level_1values_J_3I_3JI_3D(numpy.int64(_0),_4,_5,0,_3)
   return (_3)
  def _level_1values_alt_I_3D(self,_t__0,_t__1):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _1 = self._level_1values_I_3D(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _level_1values_I_3D(self,_0,_1):
   _2=numpy.array([self._shape_p.stride(_3) for _3 in range(0,(self._shape_p.nd))], dtype=numpy.dtype(numpy.int64))
   _4=numpy.array([self._shape_p.dim(_5) for _5 in range(0,(self._shape_p.nd))], dtype=numpy.dtype(numpy.int32))
   self._level_1values_J_3I_3JI_3D(0,_4,_2,_0,_1)
  def _level_1values_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self._level_1values__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _level_1values__3JI_3D(self,_0,_1,_2):
   pass
  def _level_1values_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self._level_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _level_1values_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   pass
  @staticmethod
  def _match_get_1model_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_get_1model_(*args):
    if len(args) != 0: return False
    return True
  def _get_1model_alt_(self,):
    return self._get_1model_()
  def _get_1model_(self,):
   return (self._model)
  @staticmethod
  def _match_get_1nd_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_get_1nd_(*args):
    if len(args) != 0: return False
    return True
  def _get_1nd_alt_(self,):
    return self._get_1nd_()
  def _get_1nd_(self,):
   return numpy.int32((self._shape_p._nd_p))
  @staticmethod
  def _match_size_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_size_(*args):
    if len(args) != 0: return False
    return True
  def _size_alt_(self,):
    return self._size_()
  def _size_(self,):
   return numpy.int64((self._shape_p._size))
  @staticmethod
  def _match_stack__3Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3Lmosek_4fusion_4Constraint_2__(_0))
  @staticmethod
  def _match_alt_stack__3Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Constraint_2__(_0))
  @staticmethod
  def _stack_alt__3Lmosek_4fusion_4Constraint_2(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1 = mosek_fusion_Constraint._stack__3Lmosek_4fusion_4Constraint_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def _stack__3Lmosek_4fusion_4Constraint_2(_0):
   return (mosek_fusion_CompoundConstraint._ctor__3Lmosek_4fusion_4Constraint_2(_0))
  @staticmethod
  def _match_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(_0) and __arg_match_Lmosek_4fusion_4Constraint_2__(_1) and __arg_match_Lmosek_4fusion_4Constraint_2__(_2))
  @staticmethod
  def _match_alt_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_2))
  @staticmethod
  def _stack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_t__0,_t__1,_t__2):
    return mosek_fusion_Constraint._stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_0,_1,_2)
  @staticmethod
  def _stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_0,_1,_2):
   _3=numpy.array([_0,_1], dtype=numpy.dtype(object))
   return (mosek_fusion_CompoundConstraint._ctor__3Lmosek_4fusion_4Constraint_2(_3))
  @staticmethod
  def _match_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(_0) and __arg_match_Lmosek_4fusion_4Constraint_2__(_1))
  @staticmethod
  def _match_alt_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_1))
  @staticmethod
  def _stack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_t__0,_t__1):
    return mosek_fusion_Constraint._stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_0,_1)
  @staticmethod
  def _stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_0,_1):
   _2=numpy.array([_0,_1], dtype=numpy.dtype(object))
   return (mosek_fusion_CompoundConstraint._ctor__3Lmosek_4fusion_4Constraint_2(_2))
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _index_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1 = self._index__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _index__3I(self,_0):
   return (self.slice(_0,numpy.array([(_0[_1] + 1) for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32))).__reduceDims_())
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _index_alt_I(self,_t__0):
    return self._index_I(numpy.int32(__0))
  def _index_I(self,_0):
   return (self.slice(_0,(_0 + 1)))
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _slice__3I_3I(self,_0,_1):
   pass
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   pass
  def __reduceDims_alt_(self,):
    return self.__reduceDims_()
  def __reduceDims_(self,):
   if ((self._shape_p.nd) > 1):
    _0=self._shape_p.realnd()
    _1=numpy.zeros((_0,), dtype=numpy.dtype(numpy.int32))
    _2=0
    _3=0
    while (_3 < _0):
     if (self._shape_p.dim(_3) > 1):
      _1[_2] = self._shape_p.dim(_3)
      _2 += 1
     _3 += 1
    self._shape_p = mosek_fusion_NDSet._ctor__3I(_1)
   return (self)
  @staticmethod
  def _match_shape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_shape_(*args):
    if len(args) != 0: return False
    return True
  def _shape_alt_(self,):
    return self._shape_()
  def _shape_(self,):
   return (self._shape_p)
 return Constraint
mosek_fusion_Constraint=__mk_mosek_fusion_Constraint()
del __mk_mosek_fusion_Constraint
#BEFORE CLASS
def __mk_mosek_fusion_CompoundConstraint():
 class CompoundConstraint(mosek_fusion_Constraint):
  __slots__ = ['_CompoundConstraint__stackdim','_CompoundConstraint__consb','_CompoundConstraint__cons']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor__3Lmosek_4fusion_4Constraint_2(*args): # []mosek.fusion.Constraint
      self._ctor_init__3Lmosek_4fusion_4Constraint_2(*args)
    elif self.__match_alt_ctor__3Lmosek_4fusion_4Constraint_2(*args):# []mosek.fusion.Constraint
      self._ctor_alt_init__3Lmosek_4fusion_4Constraint_2(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.CompoundConstraint.ctor(array(mosek.fusion.Constraint,ndim=1))')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_CompoundConstraint._match_slice_II(*args): # int32,int32
      return self._slice_II(*args)
    elif mosek_fusion_CompoundConstraint._match_alt_slice_II(*args): # int32,int32
      return self._slice_alt_II(*args)
    elif mosek_fusion_CompoundConstraint._match_slice__3I_3I(*args): # []int32,[]int32
      return self._slice__3I_3I(*args)
    elif mosek_fusion_CompoundConstraint._match_alt_slice__3I_3I(*args): # []int32,[]int32
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CompoundConstraint.slice(int32,int32)\n\tmosek.fusion.CompoundConstraint.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def add(self,*args):
    if False: pass
    elif mosek_fusion_CompoundConstraint._match_add_Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.Variable
      return self._add_Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_CompoundConstraint._match_alt_add_Lmosek_4fusion_4Variable_2(*args): # mosek.fusion.Variable
      return self._add_alt_Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_CompoundConstraint._match_add_Lmosek_4fusion_4Expression_2(*args): # mosek.fusion.Expression
      return self._add_Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_CompoundConstraint._match_alt_add_Lmosek_4fusion_4Expression_2(*args): # mosek.fusion.Expression
      return self._add_alt_Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_CompoundConstraint._match_add__3D(*args): # []double
      return self._add__3D(*args)
    elif mosek_fusion_CompoundConstraint._match_alt_add__3D(*args): # []double
      return self._add_alt__3D(*args)
    elif mosek_fusion_CompoundConstraint._match_add_D(*args): # double
      return self._add_D(*args)
    elif mosek_fusion_CompoundConstraint._match_alt_add_D(*args): # double
      return self._add_alt_D(*args)
    else:
      raise ValueError('Invalid argument list add('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CompoundConstraint.add(mosek.fusion.Variable)\n\tmosek.fusion.CompoundConstraint.add(mosek.fusion.Expression)\n\tmosek.fusion.CompoundConstraint.add(array(double,ndim=1))\n\tmosek.fusion.CompoundConstraint.add(double)')
  def __repr__(self): return 'mosek.fusion.CompoundConstraint'
  @staticmethod
  def _ctor__3Lmosek_4fusion_4Constraint_2(c):
    o = CompoundConstraint.__new__(CompoundConstraint)
    o._ctor_init__3Lmosek_4fusion_4Constraint_2(c)
    return o
  @staticmethod
  def __match_ctor__3Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 1: return False
    c, = args
    return (__arg_match__3Lmosek_4fusion_4Constraint_2__(c))
  @staticmethod
  def __match_alt_ctor__3Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 1: return False
    c, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Constraint_2__(c))
  def _ctor_alt_init__3Lmosek_4fusion_4Constraint_2(self,c):
    self._ctor_init__3Lmosek_4fusion_4Constraint_2(numpy.array(c,dtype=numpy.dtype(object)))
  def _ctor_init__3Lmosek_4fusion_4Constraint_2(self,c):
   mosek_fusion_Constraint._ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(self,mosek.fusion.CompoundConstraint.__model_1from_1con__3Lmosek_4fusion_4Constraint_2(c),mosek.fusion.CompoundConstraint.__compute_1shape__3Lmosek_4fusion_4Constraint_2I(c,0))
   _0=0
   _1=0
   _2=0
   _3=0
   while (_3 < int((c).shape[0])):
    if (((c[_3]._shape_p)._size)==1):
     _1 += 1
     _2 += 1
    elif (((c[_3]._shape_p)._size) > 1):
     _1 += 1
     _2 = (_2 + (c[_3]._shape_p).dim(_0))
    _3 += 1
   self.__cons = numpy.zeros((_1,), dtype=numpy.dtype(object))
   self.__consb = numpy.zeros(((_1 + 1),), dtype=numpy.dtype(numpy.int32))
   self.__consb[0] = 0
   self.__stackdim = _0
   _4=0
   _5=0
   while (_5 < int((c).shape[0])):
    if (((c[_5]._shape_p)._size) > 0):
     self.__cons[_4] = c[_5]
     _4 += 1
     if (((c[_5]._shape_p)._size)==1):
      self.__consb[(_5 + 1)] = (self.__consb[_5] + 1)
     else:
      self.__consb[(_5 + 1)] = (self.__consb[_5] + (c[_5]._shape_p).dim(_0))
    _5 += 1
  def _toStringArray_alt__3JJ_3S(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(object))
   _1 = self._toStringArray__3JJ_3S(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _toStringArray__3JJ_3S(self,_0,_1,_2):
   raise mosek_fusion_UnimplementedError._ctor_S("SliceConstraint.toStringArray() not implemented")
  def _add_1l_alt__3J_3J_3I_3I_3I_3D_3DJII(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7,_t__8,_t__9):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.float64))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.float64))
   _7=numpy.int64(_t__7)
   _8=numpy.int32(_t__8)
   _9=numpy.int32(_t__9)
   _1 = self._add_1l__3J_3J_3I_3I_3I_3D_3DJII(_0,_1,_2,_3,_4,_5,_6,_7,_8,_9)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _add_1l__3J_3J_3I_3I_3I_3D_3DJII(self,_0,_1,_2,_3,_4,_5,_6,_7,_8,_9):
   _10=numpy.array([(_0[(_8 + _11)] - _7) for _11 in range(0,_9)], dtype=numpy.dtype(numpy.int64))
   _12=numpy.array([_13 for _13 in range(0,_9)], dtype=numpy.dtype(numpy.int64))
   _14=numpy.array([self._shape_p._idxtokey_J((_0[(_8 + _15)] - _7))[self.__stackdim] for _15 in range(0,_9)], dtype=numpy.dtype(numpy.int64))
   mosek.fusion.CommonTools._argQsort__3J_3J_3JJJ(_12,_14,_10,0,numpy.int64(_9))
   _16=numpy.zeros((_9,), dtype=numpy.dtype(numpy.int32))
   _17=0
   while (self.__consb[_17] < _14[_12[0]]):
    _17 += 1
   _16[0] = _17
   for _18 in range(1,_9):
    while (self.__consb[_17] < _14[_12[_18]]):
     _17 += 1
    _16[_18] = _17
   _19=numpy.zeros((_9,), dtype=numpy.dtype(numpy.int64))
   _20=numpy.zeros(((_9 + 1),), dtype=numpy.dtype(numpy.int64))
   _21=(_1[(_8 + _9)] - _1[_8])
   _22=numpy.zeros((_21,), dtype=numpy.dtype(numpy.int32))
   _23=numpy.zeros((_21,), dtype=numpy.dtype(numpy.int32))
   _24=numpy.zeros((_21,), dtype=numpy.dtype(numpy.int32))
   _25=numpy.zeros((_21,), dtype=numpy.dtype(numpy.float64))
   _26=(None if ((_6 is None) ) else numpy.zeros((_9,), dtype=numpy.dtype(numpy.float64)))
   _20[0] = 0
   for _27 in range(0,_9):
    _28=_16[_27]
    if (((self.__cons[_28]._shape_p)._size)==1):
     _19[_27] = 0
    else:
     _29=self._shape_p._idxtokey_J(_10[_12[_27]])
     _29[self.__stackdim] = (_29[self.__stackdim] - self.__consb[_28])
     _19[_27] = (self.__cons[_28]._shape_p)._linearidx__3I(_29)
    _30=(_1[(_12[_27] + 1)] - _1[_12[_27]])
    _20[(_27 + 1)] = (_20[_27] + _30)
    mosek.fusion.Utils.Tools._arraycopy__3IJ_3IJJ(_2,_1[_12[_27]],_22,_20[_27],_30)
    mosek.fusion.Utils.Tools._arraycopy__3IJ_3IJJ(_3,_1[_12[_27]],_23,_20[_27],_30)
    mosek.fusion.Utils.Tools._arraycopy__3IJ_3IJJ(_4,_1[_12[_27]],_24,_20[_27],_30)
    mosek.fusion.Utils.Tools._arraycopy__3DJ_3DJJ(_5,_1[_12[_27]],_25,_20[_27],_30)
   if (_6 is not None):
    for _31 in range(0,_9):
     _26[_31] = _6[_12[_31]]
   _32=0
   while (_32 < _9):
    _33=_32
    _32 += 1
    while ((_32 < _9) and (_16[_32]==_16[_33])):
     _32 += 1
    self.__cons[_16[_33]]._add_1l__3J_3J_3I_3I_3I_3D_3DJII(_19,_20,_22,_23,_24,_25,_26,0,_33,(_32 - _33))
  def _dual_1values_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1values_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   _5=int((_2).shape[0])
   _6=_1[0]
   for _7 in range(1,int((_1).shape[0])):
    _6 = (_6 * _1[_7])
   _8=numpy.array([_0 for _9 in range(0,int((_1).shape[0]))], dtype=numpy.dtype(numpy.int64))
   _10=numpy.zeros((int((_1).shape[0]),), dtype=numpy.dtype(numpy.int32))
   _11=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int32))
   _12=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int64))
   _12[((self._shape_p.nd) - 1)] = 1
   for _13 in range(1,(self._shape_p.nd)):
    _12[(((self._shape_p.nd) - _13) - 1)] = (_12[((self._shape_p.nd) - _13)] * self._shape_p.dim(((self._shape_p.nd) - _13)))
   _14=numpy.zeros((1,), dtype=numpy.dtype(numpy.int64))
   for _15 in range(0,_6):
    _16=_8[0]
    for _17 in range(0,(self._shape_p.nd)):
     _11[_17] = numpy.int32((_16 // _12[_17]))
     _16 = (_16 - (numpy.int64(_11[_17]) * _12[_17]))
    _18=0
    while (_11[self.__stackdim] >= self.__consb[(_18 + 1)]):
     _18 += 1
    _11[self.__stackdim] = (_11[self.__stackdim] - self.__consb[_18])
    _14[0] = (self.__cons[_18]._shape_p)._linearidx__3I(_11)
    self.__cons[_18]._dual_1values__3JI_3D(_14,(_3 + _15),_4)
    _10[0] += 1
    _8[0] = (_8[0] + _2[(_5 - 1)])
    _19=0
    _19 = 0
    while ((_19 < (_5 - 1)) and (_10[_19]==_1[_19])):
     _10[_19] = 0
     _10[(_19 + 1)] += 1
     _19 += 1
    for _20 in range(0,_19):
     _8[_20] = _8[_19]
  def _dual_1values_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1values__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1values__3JI_3D(self,_0,_1,_2):
   _3=numpy.zeros((1,), dtype=numpy.dtype(numpy.int64))
   _4=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int32))
   for _5 in range(0,int((_0).shape[0])):
    _6=numpy.int64(_0[_5])
    for _7 in range(0,(self._shape_p.nd)):
     _4[_7] = numpy.int32((_6 // self._shape_p.stride(_7)))
     _6 = (_6 - (numpy.int64(_4[_7]) * self._shape_p.stride(_7)))
    _8=0
    while (_4[self.__stackdim] >= self.__consb[(_8 + 1)]):
     _8 += 1
    _4[self.__stackdim] = (_4[self.__stackdim] - self.__consb[_8])
    _3[0] = (self.__cons[_8]._shape_p)._linearidx__3I(_4)
    self.__cons[_8]._dual_1values__3JI_3D(_3,(_1 + _5),_2)
  def _level_1values_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self._level_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _level_1values_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   _5=int((_2).shape[0])
   _6=_1[0]
   for _7 in range(1,int((_1).shape[0])):
    _6 = (_6 * _1[_7])
   _8=numpy.array([_0 for _9 in range(0,int((_1).shape[0]))], dtype=numpy.dtype(numpy.int64))
   _10=numpy.zeros((int((_1).shape[0]),), dtype=numpy.dtype(numpy.int32))
   _11=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int32))
   _12=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int64))
   _12[((self._shape_p.nd) - 1)] = 1
   for _13 in range(1,(self._shape_p.nd)):
    _12[(((self._shape_p.nd) - _13) - 1)] = (_12[((self._shape_p.nd) - _13)] * self._shape_p.dim(((self._shape_p.nd) - _13)))
   _14=numpy.zeros((1,), dtype=numpy.dtype(numpy.int64))
   for _15 in range(0,_6):
    _16=_8[0]
    for _17 in range(0,(self._shape_p.nd)):
     _11[_17] = numpy.int32((_16 // _12[_17]))
     _16 = (_16 - (numpy.int64(_11[_17]) * _12[_17]))
    _18=0
    while (_11[self.__stackdim] >= self.__consb[(_18 + 1)]):
     _18 += 1
    _11[self.__stackdim] = (_11[self.__stackdim] - self.__consb[_18])
    _14[0] = (self.__cons[_18]._shape_p)._linearidx__3I(_11)
    self.__cons[_18]._level_1values__3JI_3D(_14,(_3 + _15),_4)
    _10[0] += 1
    _8[0] = (_8[0] + _2[(_5 - 1)])
    _19=0
    _19 = 0
    while ((_19 < (_5 - 1)) and (_10[_19]==_1[_19])):
     _10[_19] = 0
     _10[(_19 + 1)] += 1
     _19 += 1
    for _20 in range(0,_19):
     _8[_20] = _8[_19]
  def _level_1values_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self._level_1values__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _level_1values__3JI_3D(self,_0,_1,_2):
   _3=numpy.zeros((1,), dtype=numpy.dtype(numpy.int64))
   _4=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int32))
   for _5 in range(0,int((_0).shape[0])):
    _6=numpy.int64(_0[_5])
    for _7 in range(0,(self._shape_p.nd)):
     _4[_7] = numpy.int32((_6 // self._shape_p.stride(_7)))
     _6 = (_6 - (numpy.int64(_4[_7]) * self._shape_p.stride(_7)))
    _8=0
    while (_4[self.__stackdim] >= self.__consb[(_8 + 1)]):
     _8 += 1
    _4[self.__stackdim] = (_4[self.__stackdim] - self.__consb[_8])
    _3[0] = (self.__cons[_8]._shape_p)._linearidx__3I(_4)
    self.__cons[_8]._level_1values__3JI_3D(_3,(_1 + _5),_2)
  def _add_alt__3J_3I_3D_3DI_3II(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.float64))
   _4=numpy.int32(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int32))
   _6=numpy.int32(_t__6)
   _1 = self._add__3J_3I_3D_3DI_3II(_0,_1,_2,_3,_4,_5,_6)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _add__3J_3I_3D_3DI_3II(self,_0,_1,_2,_3,_4,_5,_6):
   raise mosek_fusion_UnimplementedError._ctor_S("Functionality not implemented yet.")
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _slice__3I_3I(self,_0,_1):
   raise mosek_fusion_UnimplementedError._ctor_S("Compound constraints cannot be sliced")
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   raise mosek_fusion_UnimplementedError._ctor_S("Compound constraints cannot be sliced")
  @staticmethod
  def __compute_1shape_alt__3Lmosek_4fusion_4Constraint_2I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1=numpy.int32(_t__1)
   _1 = mosek_fusion_CompoundConstraint.__compute_1shape__3Lmosek_4fusion_4Constraint_2I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def __compute_1shape__3Lmosek_4fusion_4Constraint_2I(_0,_1):
   _2=_0[0].shape()
   _3=0
   for _4 in range(0,int((_0).shape[0])):
    if (((_0[_4]._shape_p)._size) > 0):
     if (((_0[_4]._shape_p).nd)!=(_2.nd)):
      raise mosek_fusion_DimensionError._ctor_S("Mismatching variable shape")
     _5=0
     while (_5 < (_2.nd)):
      if ((_5!=_1) and (_2.dim(_5)!=(_0[_4]._shape_p).dim(_5))):
       raise mosek_fusion_DimensionError._ctor_S("Mismatching variable shape")
      _5 += 1
     _3 = (_3 + (_0[_4]._shape_p).dim(_1))
    else:
     raise mosek_fusion_DimensionError._ctor_S("Empty element in compound variable")
   if ((_2.nd)==1):
    return (mosek_fusion_IntSet._ctor_I(_3))
   else:
    _6=numpy.array([_2.dim(_7) for _7 in range(0,(_2.nd))], dtype=numpy.dtype(numpy.int32))
    _6[_1] = _3
    return (mosek_fusion_NDSet._ctor__3I(_6))
  @staticmethod
  def __count_1numcon_alt__3Lmosek_4fusion_4Constraint_2(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1 = mosek_fusion_CompoundConstraint.__count_1numcon__3Lmosek_4fusion_4Constraint_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def __count_1numcon__3Lmosek_4fusion_4Constraint_2(_0):
   _1=0
   _2=0
   while (_2 < int((_0).shape[0])):
    _3=_0[_2]
    _5=_3
    if   isinstance(_5,mosek_fusion_CompoundConstraint):
     cc=_5
     _1 = (_1 + int(((cc.__cons)).shape[0]))
    else:
     cc=_5
     _1 += 1
    _2 += 1
   return numpy.int32(_1)
  @staticmethod
  def __model_1from_1con_alt__3Lmosek_4fusion_4Constraint_2(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1 = mosek_fusion_CompoundConstraint.__model_1from_1con__3Lmosek_4fusion_4Constraint_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  @staticmethod
  def __model_1from_1con__3Lmosek_4fusion_4Constraint_2(_0):
   return ((_0[0]._model))
 return CompoundConstraint
mosek_fusion_CompoundConstraint=__mk_mosek_fusion_CompoundConstraint()
del __mk_mosek_fusion_CompoundConstraint
#BEFORE CLASS
def __mk_mosek_fusion_SliceConstraint():
 class SliceConstraint(mosek_fusion_Constraint):
  __slots__ = ['_strides','_first','_origin']
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_SliceConstraint._match_slice_II(*args): # int32,int32
      return self._slice_II(*args)
    elif mosek_fusion_SliceConstraint._match_alt_slice_II(*args): # int32,int32
      return self._slice_alt_II(*args)
    elif mosek_fusion_SliceConstraint._match_slice__3I_3I(*args): # []int32,[]int32
      return self._slice__3I_3I(*args)
    elif mosek_fusion_SliceConstraint._match_alt_slice__3I_3I(*args): # []int32,[]int32
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SliceConstraint.slice(int32,int32)\n\tmosek.fusion.SliceConstraint.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def size(self,*args):
    if False: pass
    elif mosek_fusion_SliceConstraint._match_size_(*args): # 
      return self._size_(*args)
    elif mosek_fusion_SliceConstraint._match_alt_size_(*args): # 
      return self._size_alt_(*args)
    else:
      raise ValueError('Invalid argument list size('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SliceConstraint.size()')
  def __repr__(self): return 'mosek.fusion.SliceConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Set_2J_3J(origin_,shape_,first_,strides_):
    o = SliceConstraint.__new__(SliceConstraint)
    o._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Set_2J_3J(origin_,shape_,first_,strides_)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Set_2J_3J(*args):
    if len(args) != 4: return False
    origin_,shape_,first_,strides_, = args
    return (__arg_match_Lmosek_4fusion_4ModelConstraint_2__(origin_) and __arg_match_Lmosek_4fusion_4Set_2__(shape_) and __arg_match_J__(first_) and __arg_match__3J__(strides_))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Set_2J_3J(*args):
    if len(args) != 4: return False
    origin_,shape_,first_,strides_, = args
    return (__arg_alt_match_Lmosek_4fusion_4ModelConstraint_2__(origin_) and __arg_alt_match_Lmosek_4fusion_4Set_2__(shape_) and __arg_alt_match_J__(first_) and __arg_alt_match__3J__(strides_))
  def _ctor_alt_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Set_2J_3J(self,origin_,shape_,first_,strides_):
    self._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Set_2J_3J(origin_,shape_,numpy.int64(first_),numpy.array(strides_,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Set_2J_3J(self,origin_,shape_,first_,strides_):
   mosek_fusion_Constraint._ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(self,(origin_._model),shape_)
   self._origin = origin_
   self._first = first_
   self._strides = strides_
  def _add_1l_alt__3J_3J_3I_3I_3I_3D_3DJII(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7,_t__8,_t__9):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.float64))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.float64))
   _7=numpy.int64(_t__7)
   _8=numpy.int32(_t__8)
   _9=numpy.int32(_t__9)
   _1 = self._add_1l__3J_3J_3I_3I_3I_3D_3DJII(_0,_1,_2,_3,_4,_5,_6,_7,_8,_9)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _add_1l__3J_3J_3I_3I_3I_3D_3DJII(self,_0,_1,_2,_3,_4,_5,_6,_7,_8,_9):
   _10=(_1[(_8 + _9)] - _1[_8])
   _11=numpy.zeros((_9,), dtype=numpy.dtype(numpy.int64))
   _12=numpy.zeros(((_9 + 1),), dtype=numpy.dtype(numpy.int64))
   _13=(None if ((_6 is None) ) else numpy.zeros((_9,), dtype=numpy.dtype(numpy.float64)))
   for _14 in range(0,(_9 + 1)):
    _12[_14] = _1[(_8 + _14)]
   if ((self._shape_p.nd)==1):
    for _15 in range(0,_9):
     _11[_15] = ((_0[(_15 + _8)] - _7) + self._first)
   else:
    for _16 in range(0,_9):
     _17=self._shape_p._idxtokey_J((_0[(_8 + _16)] - _7))
     _18=0
     for _19 in range(0,int((_17).shape[0])):
      _18 = (_18 + (numpy.int64(_17[_19]) * self._strides[_19]))
     _11[_16] = _18
   if (_6 is not None):
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_6,_8,_13,0,_9)
   self._origin._add_1l__3J_3J_3I_3I_3I_3D_3DJII(_11,_12,_2,_3,_4,_5,_13,0,0,_9)
  def _add_1fx_alt__3J_3DJII(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=numpy.int64(_t__2)
   _3=numpy.int32(_t__3)
   _4=numpy.int32(_t__4)
   _1 = self._add_1fx__3J_3DJII(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _add_1fx__3J_3DJII(self,_0,_1,_2,_3,_4):
   _5=numpy.zeros((_4,), dtype=numpy.dtype(numpy.int64))
   _6=numpy.zeros((_4,), dtype=numpy.dtype(numpy.float64))
   mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_1,_3,_6,0,_4)
   for _7 in range(0,_4):
    _8=self._shape_p._idxtokey_J(_0[(_3 + _7)])
    _9=0
    for _10 in range(0,int((_8).shape[0])):
     _9 = (_9 + (numpy.int64(_8[_10]) * self._strides[_10]))
    _5[_7] = _9
   self._origin._add_1fx__3J_3DJII(_5,_6,0,0,_4)
  def _dual_1values_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1values_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   if ((_0==0) and ((int((_1).shape[0])==1) and ((_1[0]==(self._shape_p._size)) and (_2[0]==1)))):
    _5=numpy.array([self._shape_p.dim(_6) for _6 in range(0,(self._shape_p.nd))], dtype=numpy.dtype(numpy.int32))
    self._origin._dual_1values_J_3I_3JI_3D(self._first,_5,self._strides,_3,_4)
   else:
    _7=int((_1).shape[0])
    _8=(_7==(self._shape_p.nd))
    _9=0
    while ((_9 < _7) and _8):
     _8 = (_2[_9]==self._shape_p.stride(_9))
     _9 += 1
    if _8:
     _10=self._first
     _11=_0
     for _12 in range(0,((self._shape_p.nd) - 1)):
      _13=(_11 // _2[_12])
      _11 = (_11 - (_2[_12] * _13))
      _10 = (_10 + (self._shape_p.stride(_12) * _13))
     self._origin._dual_1values_J_3I_3JI_3D(_10,_1,self._strides,_3,_4)
    else:
     _14=1
     for _15 in range(0,int((_1).shape[0])):
      _14 = (_14 * _1[_15])
     _16=numpy.zeros((_14,), dtype=numpy.dtype(numpy.int64))
     _17=numpy.zeros((int((_1).shape[0]),), dtype=numpy.dtype(numpy.int32))
     _18=numpy.zeros((int((_1).shape[0]),), dtype=numpy.dtype(numpy.int64))
     for _19 in range(0,int((_1).shape[0])):
      _18[_19] = 0
     for _20 in range(0,_14):
      _21=(_0 + _18[0])
      _22=0
      for _23 in range(0,(self._shape_p.nd)):
       _24=(_21 // self._shape_p.stride(_23))
       _22 = (_22 + (self._strides[_23] * _24))
       _21 = (_21 - (_24 * self._shape_p.stride(_23)))
      _16[_20] = _22
      _25=0
      _17[0] += 1
      _18[0] = (_18[0] + _2[(_7 - 1)])
      while ((_25 < (_7 - 1)) and (_17[_25] >= _1[((_7 - _25) - 1)])):
       _18[_25] = 0
       _18[_25] = (_18[_25] + _2[((_7 - _25) - 1)])
       _17[_25] = 0
       _17[(_25 + 1)] += 1
       _25 += 1
      for _26 in range(0,_25):
       _18[_26] = _18[_25]
     self._origin._dual_1values__3JI_3D(_16,_3,_4)
  def _dual_1values_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1values__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1values__3JI_3D(self,_0,_1,_2):
   _3=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
   for _4 in range(0,int((_0).shape[0])):
    _5=self._shape_p._idxtokey_J(_0[_4])
    _6=0
    for _7 in range(0,(self._shape_p.nd)):
     _6 = (_6 + (numpy.int64(_5[_7]) * self._strides[_7]))
    _3[_4] = _6
   self._origin._dual_1values__3JI_3D(_3,_1,_2)
  def _level_1values_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self._level_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _level_1values_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   if ((_0==0) and ((int((_1).shape[0])==1) and ((_1[0]==(self._shape_p._size)) and (_2[0]==1)))):
    _5=numpy.array([self._shape_p.dim(_6) for _6 in range(0,(self._shape_p.nd))], dtype=numpy.dtype(numpy.int32))
    self._origin._level_1values_J_3I_3JI_3D(self._first,_5,self._strides,_3,_4)
   else:
    _7=int((_1).shape[0])
    _8=(_7==(self._shape_p.nd))
    _9=0
    while ((_9 < _7) and _8):
     _8 = (_2[_9]==self._shape_p.stride(_9))
     _9 += 1
    if _8:
     _10=self._first
     _11=_0
     for _12 in range(0,((self._shape_p.nd) - 1)):
      _13=(_11 // _2[_12])
      _11 = (_11 - (_2[_12] * _13))
      _10 = (_10 + (self._shape_p.stride(_12) * _13))
     self._origin._level_1values_J_3I_3JI_3D(_10,_1,self._strides,_3,_4)
    else:
     _14=1
     for _15 in range(0,int((_1).shape[0])):
      _14 = (_14 * _1[_15])
     _16=numpy.zeros((_14,), dtype=numpy.dtype(numpy.int64))
     _17=numpy.zeros((int((_1).shape[0]),), dtype=numpy.dtype(numpy.int32))
     _18=numpy.zeros((int((_1).shape[0]),), dtype=numpy.dtype(numpy.int64))
     for _19 in range(0,_14):
      _20=(_0 + _18[0])
      _21=0
      for _22 in range(0,(self._shape_p.nd)):
       _23=(_20 // self._shape_p.stride(_22))
       _21 = (_21 + (self._strides[_22] * _23))
       _20 = (_20 - (_23 * self._shape_p.stride(_22)))
      _16[_19] = _21
      _24=0
      _17[0] += 1
      _18[0] = (_18[0] + _2[(_7 - 1)])
      while ((_24 < (_7 - 1)) and (_17[_24] >= _1[((_7 - _24) - 1)])):
       _18[_24] = 0
       _18[_24] = (_18[_24] + _2[((_7 - _24) - 1)])
       _17[_24] = 0
       _17[(_24 + 1)] += 1
       _24 += 1
      for _25 in range(0,_24):
       _18[_25] = _18[_24]
     self._origin._level_1values__3JI_3D(_16,_3,_4)
  def _level_1values_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self._level_1values__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _level_1values__3JI_3D(self,_0,_1,_2):
   _3=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
   for _4 in range(0,int((_0).shape[0])):
    _5=self._shape_p._idxtokey_J(_0[_4])
    _6=0
    for _7 in range(0,(self._shape_p.nd)):
     _6 = (_6 + (numpy.int64(_5[_7]) * self._strides[_7]))
    _3[_4] = _6
   self._origin._level_1values__3JI_3D(_3,_1,_2)
  def _toStringArray_alt__3JJ_3S(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(object))
   _1 = self._toStringArray__3JJ_3S(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _toStringArray__3JJ_3S(self,_0,_1,_2):
   _3=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
   for _4 in range(0,int((_0).shape[0])):
    _5=self._shape_p._idxtokey_J(_0[_4])
    _6=0
    for _7 in range(0,(self._shape_p.nd)):
     _6 = (_6 + (numpy.int64(_5[_7]) * self._strides[_7]))
    _3[_4] = _6
   self._origin._toStringArray__3JJ_3S(_3,_1,_2)
  @staticmethod
  def _match_size_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_size_(*args):
    if len(args) != 0: return False
    return True
  def _size_alt_(self,):
    return self._size_()
  def _size_(self,):
   return numpy.int64((self._shape_p._size))
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _slice__3I_3I(self,_0,_1):
   _2=self._shape_p.slice(_0,_1)
   _3=self._first
   _4=0
   while (_4 < int((_0).shape[0])):
    _3 = (_3 + (numpy.int64(_0[_4]) * self._strides[_4]))
    _4 += 1
   return (self._slice_1_Lmosek_4fusion_4Set_2J_3J(_2,_3,self._strides))
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   _2=self._shape_p.slice(_0,_1)
   return (self._slice_1_Lmosek_4fusion_4Set_2J_3J(_2,(_0 + _0),self._strides))
  def _slice_1_alt_Lmosek_4fusion_4Set_2J_3J(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _1 = self._slice_1_Lmosek_4fusion_4Set_2J_3J(_0,_1,_2)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _slice_1_Lmosek_4fusion_4Set_2J_3J(self,_0,_1,_2):
   return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Set_2J_3J(self._origin,_0,_1,_2))
 return SliceConstraint
mosek_fusion_SliceConstraint=__mk_mosek_fusion_SliceConstraint()
del __mk_mosek_fusion_SliceConstraint
#BEFORE CLASS
def __mk_mosek_fusion_BoundInterfaceConstraint():
 class BoundInterfaceConstraint(mosek_fusion_SliceConstraint):
  __slots__ = ['_BoundInterfaceConstraint__origincon','_BoundInterfaceConstraint__islower']
  def __repr__(self): return 'mosek.fusion.BoundInterfaceConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Set_2J_3JZ(origin_,shape_,first_,strides_,islower_):
    o = BoundInterfaceConstraint.__new__(BoundInterfaceConstraint)
    o._ctor_init_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Set_2J_3JZ(origin_,shape_,first_,strides_,islower_)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Set_2J_3JZ(*args):
    if len(args) != 5: return False
    origin_,shape_,first_,strides_,islower_, = args
    return (__arg_match_Lmosek_4fusion_4RangedConstraint_2__(origin_) and __arg_match_Lmosek_4fusion_4Set_2__(shape_) and __arg_match_J__(first_) and __arg_match__3J__(strides_) and __arg_match_Z__(islower_))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Set_2J_3JZ(*args):
    if len(args) != 5: return False
    origin_,shape_,first_,strides_,islower_, = args
    return (__arg_alt_match_Lmosek_4fusion_4RangedConstraint_2__(origin_) and __arg_alt_match_Lmosek_4fusion_4Set_2__(shape_) and __arg_alt_match_J__(first_) and __arg_alt_match__3J__(strides_) and __arg_alt_match_Z__(islower_))
  def _ctor_alt_init_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Set_2J_3JZ(self,origin_,shape_,first_,strides_,islower_):
    self._ctor_init_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Set_2J_3JZ(origin_,shape_,numpy.int64(first_),numpy.array(strides_,dtype=numpy.dtype(numpy.int64)),islower_)
  def _ctor_init_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Set_2J_3JZ(self,origin_,shape_,first_,strides_,islower_):
   mosek_fusion_SliceConstraint._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Set_2J_3J(self,origin_,shape_,first_,strides_)
   self.__origincon = origin_
   self.__islower = islower_
  def _slice_1_alt_Lmosek_4fusion_4Set_2J_3J(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _1 = self._slice_1_Lmosek_4fusion_4Set_2J_3J(_0,_1,_2)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _slice_1_Lmosek_4fusion_4Set_2J_3J(self,_0,_1,_2):
   return (mosek_fusion_BoundInterfaceConstraint._ctor_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Set_2J_3JZ(self.__origincon,_0,_1,_2,self.__islower))
  def _dual_1values_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1values_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   if self.__islower:
    self.__origincon._dual_1l_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   else:
    self.__origincon._dual_1u_J_3I_3JI_3D(_0,_1,_2,_3,_4)
  def _dual_1values_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1values__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1values__3JI_3D(self,_0,_1,_2):
   if self.__islower:
    self.__origincon._dual_1l__3JI_3D(_0,_1,_2)
   else:
    self.__origincon._dual_1u__3JI_3D(_0,_1,_2)
 return BoundInterfaceConstraint
mosek_fusion_BoundInterfaceConstraint=__mk_mosek_fusion_BoundInterfaceConstraint()
del __mk_mosek_fusion_BoundInterfaceConstraint
#BEFORE CLASS
def __mk_mosek_fusion_ModelConstraint():
 class ModelConstraint(mosek_fusion_Constraint):
  __slots__ = ['_ModelConstraint__names_flushed','_nativeindexes','_name','_cache_bfix','_cache']
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_ModelConstraint._match_toString_(*args): # 
      return self._toString_(*args)
    elif mosek_fusion_ModelConstraint._match_alt_toString_(*args): # 
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ModelConstraint.toString()')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_ModelConstraint._match_slice_II(*args): # int32,int32
      return self._slice_II(*args)
    elif mosek_fusion_ModelConstraint._match_alt_slice_II(*args): # int32,int32
      return self._slice_alt_II(*args)
    elif mosek_fusion_ModelConstraint._match_slice__3I_3I(*args): # []int32,[]int32
      return self._slice__3I_3I(*args)
    elif mosek_fusion_ModelConstraint._match_alt_slice__3I_3I(*args): # []int32,[]int32
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ModelConstraint.slice(int32,int32)\n\tmosek.fusion.ModelConstraint.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def __str__(self): return self._toString_()
  def __repr__(self): return 'mosek.fusion.ModelConstraint: '+self._toString_()
  @staticmethod
  def _ctor_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(c,m):
    o = ModelConstraint.__new__(ModelConstraint)
    o._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4ModelConstraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4ModelConstraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
   mosek_fusion_Constraint._ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(self,c,m)
   self._cache = (c._cache)._clone_()
   self._nativeindexes = numpy.array([(c._nativeindexes)[_0] for _0 in range(0,int(((c._nativeindexes)).shape[0]))], dtype=numpy.dtype(numpy.int32))
   self._name = (c._name)
   self._cache_bfix = numpy.array([(c._cache_bfix)[_1] for _1 in range(0,int(((c._cache_bfix)).shape[0]))], dtype=numpy.dtype(numpy.float64))
   self.__names_flushed = (c.__names_flushed)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3I_3J_3I_3D_3D_3I_3I_3I(model_,name_,shape_,nidxs_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_):
    o = ModelConstraint.__new__(ModelConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3I_3J_3I_3D_3D_3I_3I_3I(model_,name_,shape_,nidxs_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3I_3J_3I_3D_3D_3I_3I_3I(*args):
    if len(args) != 11: return False
    model_,name_,shape_,nidxs_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model_) and __arg_match_S__(name_) and __arg_match_Lmosek_4fusion_4Set_2__(shape_) and __arg_match__3I__(nidxs_) and __arg_match__3J__(ptrb) and __arg_match__3I__(subj) and __arg_match__3D__(cof) and __arg_match__3D__(bfix) and __arg_match__3I__(barsubi_) and __arg_match__3I__(barsubj_) and __arg_match__3I__(barsymmatidx_))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3I_3J_3I_3D_3D_3I_3I_3I(*args):
    if len(args) != 11: return False
    model_,name_,shape_,nidxs_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model_) and __arg_alt_match_S__(name_) and __arg_alt_match_Lmosek_4fusion_4Set_2__(shape_) and __arg_alt_match__3I__(nidxs_) and __arg_alt_match__3J__(ptrb) and __arg_alt_match__3I__(subj) and __arg_alt_match__3D__(cof) and __arg_alt_match__3D__(bfix) and __arg_alt_match__3I__(barsubi_) and __arg_alt_match__3I__(barsubj_) and __arg_alt_match__3I__(barsymmatidx_))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3I_3J_3I_3D_3D_3I_3I_3I(self,model_,name_,shape_,nidxs_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_):
    self._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3I_3J_3I_3D_3D_3I_3I_3I(model_,name_,shape_,numpy.array(nidxs_,dtype=numpy.dtype(numpy.int32)),numpy.array(ptrb,dtype=numpy.dtype(numpy.int64)),numpy.array(subj,dtype=numpy.dtype(numpy.int32)),numpy.array(cof,dtype=numpy.dtype(numpy.float64)),numpy.array(bfix,dtype=numpy.dtype(numpy.float64)),numpy.array(barsubi_,dtype=numpy.dtype(numpy.int32)),numpy.array(barsubj_,dtype=numpy.dtype(numpy.int32)),numpy.array(barsymmatidx_,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3I_3J_3I_3D_3D_3I_3I_3I(self,model_,name_,shape_,nidxs_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_):
   mosek_fusion_Constraint._ctor_init_Lmosek_4fusion_4Model_2Lmosek_4fusion_4Set_2(self,model_,shape_)
   self._cache = mosek_fusion_ConstraintCache._ctor__3J_3D_3I_3D_3I_3I_3I(ptrb,cof,subj,bfix,barsubi_,barsubj_,barsymmatidx_)
   self._nativeindexes = nidxs_
   self._name = name_
   if (bfix is not None):
    self._cache_bfix = mosek.fusion.Utils.Tools._arraycopy__3D(bfix)
   else:
    self._cache_bfix = numpy.zeros((int((nidxs_).shape[0]),), dtype=numpy.dtype(numpy.float64))
   self.__names_flushed = False
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   if ((not self.__names_flushed) and (int(len(self._name)) > 0)):
    for _0 in range(0,int((self._nativeindexes).shape[0])):
     self._model._task_1con_1name_IS(self._nativeindexes[_0],("" if ((int(len(self._name))==0) ) else mosek.fusion.Utils.StringBuffer()._a_S(self._name)._a_S("[")._a_S(self._shape_p.getname(_0))._a_S("]")._toString_()))
    self.__names_flushed = True
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=(self._shape_p._size)
   _1=numpy.zeros((_0,), dtype=numpy.dtype(object))
   self._toStringArray__3JJ_3S(mosek.fusion.Utils.Tools._range_J(_0),0,_1)
   _2=mosek.fusion.Utils.StringBuffer()
   _2._a_S("Constraint( ")
   if (int(len(self._name)) > 0):
    _2._a_S("'")._a_S(self._name)._a_S("', ")
   _2._a_S("(")._a_I(self._shape_p.dim(0))
   for _3 in range(1,(self._shape_p.nd)):
    _2._a_S(",")._a_I(self._shape_p.dim(_3))
   _2._a_S("),")._lf_()
   if (int((_1).shape[0]) > 0):
    _2._a_S("  ")._a_S(_1[0])
    for _4 in range(1,int((_1).shape[0])):
     _2._a_S(",")._lf_()._a_S("  ")._a_S(_1[_4])
   _2._a_S(" )")
   return (_2._toString_())
  def _toStringArray_alt__3JJ_3S(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(object))
   _1 = self._toStringArray__3JJ_3S(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _toStringArray__3JJ_3S(self,_0,_1,_2):
   for _3 in range(0,int((_0).shape[0])):
    if ((_0[_3] < 0) or (_0[_3] >= (self._shape_p._size))):
     raise mosek_fusion_IndexError._ctor_S("Constraint index out of bounds")
   if ((long((_0).shape[0]) + _1) > long((_2).shape[0])):
    raise mosek_fusion_LengthError._ctor_S("Result array is too small to hold the result")
   _4=mosek.fusion.Utils.StringBuffer()
   _5=0
   _6=self._cache._order_1barentries_()
   _7=0
   for _8 in range(0,int((_0).shape[0])):
    _9=_0[_8]
    _10=self._nativeindexes[_9]
    _11=_5
    while ((_5 < (self._cache.nnz)) and ((self._cache.subi)[_5]==_9)):
     _5 += 1
    _4._clear_()._a_S(self._name)._a_S("[")._a_S(self._shape_p.indexToString(_9))._a_S("] : ")
    for _12 in range(_11,_5):
     _13=(self._cache.cof)[_12]
     if (_13 > 0):
      _4._a_S(" + ")._a_D(_13)._a_S(" ")
      self._model._nativeVarToStr_ILmosek_4fusion_4Utils_4StringBuffer_2((self._cache.subj)[_12],_4)
     elif (_13 < 0):
      _4._a_S(" - ")._a_D((- _13))._a_S(" ")
      self._model._nativeVarToStr_ILmosek_4fusion_4Utils_4StringBuffer_2((self._cache.subj)[_12],_4)
    while ((_7 < _6) and ((self._cache.barsubi)[_7] < _9)):
     _7 += 1
    _14=_7
    while ((_14 < _6) and ((self._cache.barsubi)[_14]==_9)):
     _14 += 1
    while ((_7 < _14) and ((self._cache.barsubi)[_7]==_9)):
     _15=_7
     _16=(self._cache.barsubj)[_7]
     _7 += 1
     while ((_7 < _14) and ((self._cache.barsubj)[_7]==_16)):
      _7 += 1
     _4._a_S(" + < M")._a_I((self._cache.barmatidx)[_15])
     for _17 in range((_15 + 1),_7):
      _4._a_S(" + M")._a_I((self._cache.barmatidx)[_17])
     _4._a_S(" ; ")._a_S((((self._model._vars)[(self._model._natbarvarmap_Var)[(self._cache.barsubj)[_15]]]._name) if ((int(len(((self._model._vars)[(self._model._natbarvarmap_Var)[(self._cache.barsubj)[_15]]]._name))) > 0) ) else "_"))._a_S(" >")
    if (self._cache_bfix is not None):
     if (self._cache_bfix[_9] > 0):
      _4._a_S(" + ")._a_D(self._cache_bfix[_9])
     elif (self._cache_bfix[_9] < 0):
      _4._a_S(" + ")._a_D(self._cache_bfix[_9])
    _4._a_S(" ")
    self._domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(_9,_4)
    _2[(numpy.int64(_8) + _1)] = _4._toString_()
  def _domainToString_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   pass
  def _add_1l_alt__3J_3J_3I_3I_3I_3D_3DJII(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7,_t__8,_t__9):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.float64))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.float64))
   _7=numpy.int64(_t__7)
   _8=numpy.int32(_t__8)
   _9=numpy.int32(_t__9)
   _1 = self._add_1l__3J_3J_3I_3I_3I_3D_3DJII(_0,_1,_2,_3,_4,_5,_6,_7,_8,_9)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _add_1l__3J_3J_3I_3I_3I_3D_3DJII(self,_0,_1,_2,_3,_4,_5,_6,_7,_8,_9):
   for _10 in range(1,int((_0).shape[0])):
    if (_0[(_10 - 1)] >= _0[_10]):
     raise mosek_fusion_UnimplementedError._ctor_S("Not supported: Non-contiguous index ranges in ModelConstraint.add_l")
   if ((_1[(_8 + _9)] <= _1[_8]) and (_6 is None)):
    return 
   _11=numpy.zeros(((_1[(_8 + _9)] - _1[_8]),), dtype=numpy.dtype(numpy.int64))
   for _12 in range(0,(_1[(_8 + _9)] - _1[_8])):
    _11[_12] = (_1[_8] + _12)
   for _13 in range(0,_9):
    mosek.fusion.CommonTools._argQsort__3J_3I_3IJJ(_11,_2,None,_1[(_8 + _13)],_1[((_8 + _13) + 1)])
   _14=0
   _15=0
   for _16 in range(_1[_8],_1[(_8 + _9)]):
    if (_2[_16] >= 0):
     _14 += 1
    else:
     _15 += 1
   if ((_14 > 0) or (_6 is not None)):
    _17=numpy.zeros((((self._cache.nrows) + 1),), dtype=numpy.dtype(numpy.int64))
    _18=numpy.zeros((_14,), dtype=numpy.dtype(numpy.int32))
    _19=numpy.zeros((_14,), dtype=numpy.dtype(numpy.float64))
    _20=None
    if (_6 is not None):
     _20 = numpy.zeros(((self._cache.nrows),), dtype=numpy.dtype(numpy.float64))
     for _21 in range(0,_9):
      _20[(_0[(_21 + _8)] - _7)] = _6[(_8 + _21)]
    _17[0] = 0
    _22=_8
    for _23 in range(0,(self._cache.nrows)):
     if ((_22 < _9) and ((_0[_22] - _7)==_23)):
      _24=_17[_23]
      for _25 in range(_1[_22],_1[(_22 + 1)]):
       if (_2[_25] >= 0):
        _18[_24] = _2[_25]
        _19[_24] = _5[_25]
        _24 += 1
      _17[(_23 + 1)] = _24
      _22 += 1
     else:
      _17[(_23 + 1)] = _17[_23]
    self._cache.add(_17,_18,_19,_20)
    _26=(self._cache.nrows)
    _27=numpy.int32(self._cache.numUnsorted())
    _28=numpy.zeros((_27,), dtype=numpy.dtype(numpy.int32))
    _29=numpy.zeros((_27,), dtype=numpy.dtype(numpy.int32))
    _30=numpy.zeros((_27,), dtype=numpy.dtype(numpy.float64))
    _31=self._cache.flush(_28,_29,_30,None)
    for _32 in range(0,_31):
     _28[_32] = self._nativeindexes[_28[_32]]
    self._model._task_1putaijlist__3I_3I_3DJ(_28,_29,_30,_31)
    if (_6 is not None):
     self._add_1fx__3J_3DJII(_0,(self._cache.bfix),_7,_8,_9)
   if (_15 > 0):
    _33=0
    _34=_1[_8]
    for _35 in range(0,_9):
     if (_2[_11[(_1[_8] - _34)]] < 0):
      _36=1
      for _37 in range(((_1[(_8 + _35)] - _34) + 1),(_1[((_8 + _35) + 1)] - _34)):
       if ((_2[_11[_37]] < 0) and (_2[_11[_37]]!=_2[_11[(_37 - 1)]])):
        _36 += 1
      _33 += _36
    _38=numpy.zeros((_33,), dtype=numpy.dtype(numpy.int32))
    _39=numpy.zeros((_33,), dtype=numpy.dtype(numpy.int32))
    _40=numpy.zeros((_33,), dtype=numpy.dtype(numpy.int32))
    _41=numpy.zeros((_33,), dtype=numpy.dtype(numpy.int32))
    _42=_1[_8]
    _43=0
    for _44 in range(0,_9):
     _45=(_1[(_8 + _44)] - _42)
     _46=(_1[((_8 + _44) + 1)] - _42)
     if (_2[_11[_45]] < 0):
      while ((_45 < _46) and (_2[_11[_45]] < 0)):
       _39[_43] = numpy.int32(_0[(_8 + _44)])
       _38[_43] = self._nativeindexes[numpy.int32(_0[(_8 + _44)])]
       _40[_43] = ((- _2[_11[_45]]) - 1)
       _47=_45
       while ((_45 < _46) and ((_2[_11[_45]] < 0) and (_2[_11[_45]]==_2[_11[_47]]))):
        _45 += 1
       _51=1
       if ((_45 - _47) > 1):
        mosek.fusion.CommonTools._argQsort__3J_3I_3IJJ(_11,_3,_4,numpy.int64(_47),numpy.int64((_45 - _47)))
        _52=1
        for _53 in range(1,(_45 - _47)):
         if ((_3[_11[((_45 + _53) - 1)]]!=_3[_11[(_45 + _53)]]) or (_4[_11[((_45 + _53) - 1)]]!=_4[_11[(_45 + _53)]])):
          _52 += 1
        _48 = numpy.zeros((_52,), dtype=numpy.dtype(numpy.int32))
        _49 = numpy.zeros((_52,), dtype=numpy.dtype(numpy.int32))
        _50 = numpy.zeros((_52,), dtype=numpy.dtype(numpy.float64))
        _48[0] = _3[_11[0]]
        _49[0] = _4[_11[0]]
        _50[0] = _5[_11[0]]
        _54=0
        for _55 in range(1,(_45 - _47)):
         if ((_48[_11[((_45 + _55) - 1)]]!=_48[_11[(_45 + _55)]]) or (_49[_11[((_45 + _55) - 1)]]!=_49[_11[(_45 + _55)]])):
          _54 += 1
          _48[_54] = _3[_11[(_45 + _55)]]
          _49[_54] = _4[_11[(_45 + _55)]]
         _50[_54] = (_50[_54] + _5[_11[(_45 + _55)]])
       else:
        _48 = numpy.array([_3[_11[_47]]], dtype=numpy.dtype(numpy.int32))
        _49 = numpy.array([_4[_11[_47]]], dtype=numpy.dtype(numpy.int32))
        _50 = numpy.array([_5[_11[_47]]], dtype=numpy.dtype(numpy.float64))
       _56=self._model._task_1append_1barmatrix_I_3I_3I_3D(self._model._task_1barvardim_I(_40[_43]),_48,_49,_50)
       _41[_43] = _56
       _43 += 1
    self._cache._add_1bar__3I_3I_3I(_39,_40,_41)
  def _add_1fx_alt__3J_3DJII(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=numpy.int64(_t__2)
   _3=numpy.int32(_t__3)
   _4=numpy.int32(_t__4)
   _1 = self._add_1fx__3J_3DJII(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _add_1fx__3J_3DJII(self,_0,_1,_2,_3,_4):
   pass
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1 = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _slice__3I_3I(self,_0,_1):
   if (int((_0).shape[0])!=int((_1).shape[0])):
    raise mosek_fusion_LengthError._ctor_S("Mismatching array lengths")
   _2=self._shape_p.slice(_0,_1)
   _3=numpy.zeros(((self._shape_p.nd),), dtype=numpy.dtype(numpy.int64))
   _3[((self._shape_p.nd) - 1)] = 1
   _4=((self._shape_p.nd) - 1)
   while (_4 > 0):
    _3[(_4 - 1)] = (_3[_4] * self._shape_p.dim(_4))
    _4 = (_4 - 1)
   _5=0
   for _6 in range(0,int((_3).shape[0])):
    _5 = (_5 + (_3[_6] * _0[_6]))
   return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Set_2J_3J(self,_2,_5,_3))
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   _2=numpy.array([1], dtype=numpy.dtype(numpy.int64))
   return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Set_2J_3J(self,self._shape_p.slice(_0,_1),numpy.int64(_0),_2))
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   pass
 return ModelConstraint
mosek_fusion_ModelConstraint=__mk_mosek_fusion_ModelConstraint()
del __mk_mosek_fusion_ModelConstraint
#BEFORE CLASS
def __mk_mosek_fusion_LinearPSDConstraint():
 class LinearPSDConstraint(mosek_fusion_ModelConstraint):
  __slots__ = ['_LinearPSDConstraint__psdvardim','_LinearPSDConstraint__names_flushed','_LinearPSDConstraint__numcones','_LinearPSDConstraint__conesize','_LinearPSDConstraint__coneidx']
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_LinearPSDConstraint._match_toString_(*args): # 
      return self._toString_(*args)
    elif mosek_fusion_LinearPSDConstraint._match_alt_toString_(*args): # 
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearPSDConstraint.toString()')
  def __str__(self): return self._toString_()
  def __repr__(self): return 'mosek.fusion.LinearPSDConstraint: '+self._toString_()
  @staticmethod
  def _ctor_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(c,m):
    o = LinearPSDConstraint.__new__(LinearPSDConstraint)
    o._ctor_init_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4LinearPSDConstraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearPSDConstraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m)
   self.__coneidx = (c.__coneidx)
   self.__conesize = (c.__conesize)
   self.__psdvardim = (c.__psdvardim)
   self.__numcones = (c.__numcones)
   self.__names_flushed = (c.__names_flushed)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3IIII_3J_3I_3D_3D_3I_3I_3I(model_,name_,shape_,nativeidxs_,conesize_,firstcone_,numcone_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_):
    o = LinearPSDConstraint.__new__(LinearPSDConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3IIII_3J_3I_3D_3D_3I_3I_3I(model_,name_,shape_,nativeidxs_,conesize_,firstcone_,numcone_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3IIII_3J_3I_3D_3D_3I_3I_3I(*args):
    if len(args) != 14: return False
    model_,name_,shape_,nativeidxs_,conesize_,firstcone_,numcone_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model_) and __arg_match_S__(name_) and __arg_match_Lmosek_4fusion_4Set_2__(shape_) and __arg_match__3I__(nativeidxs_) and __arg_match_I__(conesize_) and __arg_match_I__(firstcone_) and __arg_match_I__(numcone_) and __arg_match__3J__(ptrb) and __arg_match__3I__(subj) and __arg_match__3D__(cof) and __arg_match__3D__(bfix) and __arg_match__3I__(barsubi_) and __arg_match__3I__(barsubj_) and __arg_match__3I__(barsymmatidx_))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3IIII_3J_3I_3D_3D_3I_3I_3I(*args):
    if len(args) != 14: return False
    model_,name_,shape_,nativeidxs_,conesize_,firstcone_,numcone_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model_) and __arg_alt_match_S__(name_) and __arg_alt_match_Lmosek_4fusion_4Set_2__(shape_) and __arg_alt_match__3I__(nativeidxs_) and __arg_alt_match_I__(conesize_) and __arg_alt_match_I__(firstcone_) and __arg_alt_match_I__(numcone_) and __arg_alt_match__3J__(ptrb) and __arg_alt_match__3I__(subj) and __arg_alt_match__3D__(cof) and __arg_alt_match__3D__(bfix) and __arg_alt_match__3I__(barsubi_) and __arg_alt_match__3I__(barsubj_) and __arg_alt_match__3I__(barsymmatidx_))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3IIII_3J_3I_3D_3D_3I_3I_3I(self,model_,name_,shape_,nativeidxs_,conesize_,firstcone_,numcone_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_):
    self._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3IIII_3J_3I_3D_3D_3I_3I_3I(model_,name_,shape_,numpy.array(nativeidxs_,dtype=numpy.dtype(numpy.int32)),numpy.int32(conesize_),numpy.int32(firstcone_),numpy.int32(numcone_),numpy.array(ptrb,dtype=numpy.dtype(numpy.int64)),numpy.array(subj,dtype=numpy.dtype(numpy.int32)),numpy.array(cof,dtype=numpy.dtype(numpy.float64)),numpy.array(bfix,dtype=numpy.dtype(numpy.float64)),numpy.array(barsubi_,dtype=numpy.dtype(numpy.int32)),numpy.array(barsubj_,dtype=numpy.dtype(numpy.int32)),numpy.array(barsymmatidx_,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3IIII_3J_3I_3D_3D_3I_3I_3I(self,model_,name_,shape_,nativeidxs_,conesize_,firstcone_,numcone_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3I_3J_3I_3D_3D_3I_3I_3I(self,model_,name_,shape_,nativeidxs_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_)
   self.__coneidx = firstcone_
   self.__conesize = conesize_
   self.__numcones = numcone_
   _0=self._shape_p.dim(0)
   _1=numpy.int32(((mosek.fusion.Utils.Tools._sqrt_D((1 + (8 * _0))) - 1) / 2))
   if (((_1 * (_1 + 1)) // 2)!=_0):
    raise mosek_fusion_DimensionError._ctor_S("Invalid size for semidefinite constraint")
   self.__psdvardim = _1
   self.__names_flushed = False
  def _domainToString_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   _2=self._shape_p._idxtokey_J(_0)
   _1._a_S(" : element (")._a_I(_2[0])
   for _3 in range(1,int((_2).shape[0])):
    _1._a_S(",")._a_I(_2[_3])
   _1._a_S(") in a positive semi-definite cone of size (")._a_I(self._shape_p.dim(0))
   for _4 in range(1,int((_2).shape[0])):
    _1._a_S(",")._a_I(self._shape_p.dim(_4))
   _1._a_S(")")
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=(self._shape_p._size)
   _1=numpy.zeros((_0,), dtype=numpy.dtype(object))
   self._toStringArray__3JJ_3SZ(numpy.array([_2 for _2 in range(0,_0)], dtype=numpy.dtype(numpy.int64)),0,_1,False)
   _3=mosek.fusion.Utils.StringBuffer()
   _3._a_S("LinearPSDConstraint( (")._a_I(self._shape_p.dim(0))
   for _4 in range(1,(self._shape_p.nd)):
    _3._a_S(",")._a_I(self._shape_p.dim(_4))
   _3._a_S("),")._lf_()
   _3._a_S("  ")._a_S(_1[0])
   for _5 in range(1,int((_1).shape[0])):
    _3._a_S(",")._lf_()._a_S("  ")._a_S(_1[_5])
   _3._a_S(" )")
   return (_3._toString_())
  def _toStringArray_alt__3JJ_3S(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(object))
   _1 = self._toStringArray__3JJ_3S(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _toStringArray__3JJ_3S(self,_0,_1,_2):
   self._toStringArray__3JJ_3SZ(_0,_1,_2,True)
  def _toStringArray_alt__3JJ_3SZ(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(object))
   _3=_t__3
   _1 = self._toStringArray__3JJ_3SZ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _toStringArray__3JJ_3SZ(self,_0,_1,_2,_3):
   for _4 in range(0,int((_0).shape[0])):
    if ((_0[_4] < 0) or (_0[_4] >= (self._shape_p._size))):
     raise mosek_fusion_IndexError._ctor_S("Constraint index out of bounds")
   if ((long((_0).shape[0]) + _1) > long((_2).shape[0])):
    raise mosek_fusion_LengthError._ctor_S("Result array is too small to hold the result")
   _5=mosek.fusion.Utils.StringBuffer()
   _6=self._cache._order_1barentries_()
   _7=0
   for _8 in range(0,int((_0).shape[0])):
    _9=_0[_8]
    _10=(_9 // self.__conesize)
    _11=(_9 % self.__conesize)
    _12=(_9 + self.__coneidx)
    _5._clear_()._a_S(self._name)._a_S("[")._a_J(_10)._a_S(",")._a_J(_11)._a_S("] : ")
    _13=self._nativeindexes[_9]
    _14=0
    while ((_14 < int(((self._cache.subi)).shape[0])) and ((self._cache.subi)[_14] < _12)):
     _14 += 1
    _15=_14
    while ((_14 < int(((self._cache.subi)).shape[0])) and ((self._cache.subi)[_14]==_12)):
     _14 += 1
    _16=0
    while ((_16 < _6) and ((self._cache.barsubi)[_16] < _12)):
     _16 += 1
    _17=_16
    while ((_16 < _6) and ((self._cache.barsubi)[_16]==_12)):
     _16 += 1
    for _18 in range(_15,_14):
     _19=(self._cache.cof)[_18]
     if (_19 > 0):
      _5._a_S(" + ")._a_D(_19)._a_S(" ")
     elif (_19 < 0):
      _5._a_S(" - ")._a_D((- _19))._a_S(" ")
     else:
      _5._a_S(" + 0.0 ")
     self._model._nativeVarToStr_ILmosek_4fusion_4Utils_4StringBuffer_2((self._cache.subj)[_18],_5)
    _20=_16
    _16 = _17
    while ((_16 < _20) and ((self._cache.barsubi)[_16]==_12)):
     _21=_16
     _22=(self._cache.barsubj)[_16]
     _16 += 1
     while ((_16 < _20) and ((self._cache.barsubj)[_16]==_22)):
      _16 += 1
     _5._a_S(" + < M")._a_I((self._cache.barmatidx)[_21])
     for _23 in range((_21 + 1),_16):
      _5._a_S(" + M")._a_I((self._cache.barmatidx)[_23])
     _5._a_S(" ; ")._a_S((((self._model._vars)[(self._model._natbarvarmap_Var)[(self._cache.barsubj)[_21]]]._name) if ((int(len(((self._model._vars)[(self._model._natbarvarmap_Var)[(self._cache.barsubj)[_21]]]._name))) > 0) ) else "_"))._a_S(" >")
    if (self._cache_bfix is not None):
     if (self._cache_bfix[_12] > 0):
      _5._a_S(" + ")._a_D(self._cache_bfix[_12])
     elif (self._cache_bfix[_12] < 0):
      _5._a_S(" + ")._a_D(self._cache_bfix[_12])
    if _3:
     _5._a_S(" ")
     self._domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(_9,_5)
    _2[(numpy.int64(_8) + _1)] = _5._toString_()
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   if ((not self.__names_flushed) and (int(len(self._name)) > 0)):
    _0=mosek.fusion.Utils.StringBuffer()
    if (self.__numcones > 1):
     _1=0
     for _2 in range(0,self.__numcones):
      for _3 in range(0,self.__conesize):
       self._model._task_1con_1name_IS(self._nativeindexes[_1],_0._clear_()._a_S(self._name)._a_S("[")._a_I(_2)._a_S(",")._a_I(_3)._a_S("]")._toString_())
       _1 += 1
    else:
     _4=0
     for _5 in range(0,self.__conesize):
      self._model._task_1con_1name_IS(self._nativeindexes[_4],_0._clear_()._a_S(self._name)._a_S("[")._a_I(_5)._a_S("]")._toString_())
      _4 += 1
    for _6 in range(0,self.__numcones):
     self._model._task_1barvar_1name_IS((self.__coneidx + _6),_0._clear_()._a_S(self._name)._a_S("[")._a_I(_6)._a_S("].coneslack")._toString_())
    self.__names_flushed = True
  def _add_1fx_alt__3J_3DJII(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=numpy.int64(_t__2)
   _3=numpy.int32(_t__3)
   _4=numpy.int32(_t__4)
   _1 = self._add_1fx__3J_3DJII(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _add_1fx__3J_3DJII(self,_0,_1,_2,_3,_4):
   _5=numpy.zeros((_4,), dtype=numpy.dtype(numpy.float64))
   _6=numpy.zeros((_4,), dtype=numpy.dtype(numpy.int32))
   for _7 in range(0,_4):
    _6[_7] = self._nativeindexes[(_0[(_3 + _7)] - _2)]
   for _8 in range(0,int((_5).shape[0])):
    _5[_8] = (- _1[(_0[(_3 + _8)] - _2)])
   self._model._task_1con_1putboundlist_1fx__3I_3D(_6,_5)
  def _dual_1values_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1values_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   _5=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
   _6=1
   for _7 in range(0,int((_1).shape[0])):
    _6 *= _1[_7]
   _8=self._model._getSolution_1bars_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   _9=self.__conesize
   for _10 in range(0,_6):
    _11=((_5.get() // _9) + self.__coneidx)
    _12=(_5.get() % _9)
    _4[_10] = _8[self.__coneidx][_12]
    _5.inc()
  def _dual_1values_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self._dual_1values__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _dual_1values__3JI_3D(self,_0,_1,_2):
   _3=self._model._getSolution_1bars_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   _4=self.__conesize
   for _5 in range(0,int((_0).shape[0])):
    _6=((_0[_5] // _4) + self.__coneidx)
    _7=(_0[_5] % _4)
    _2[_5] = _3[_6][_7]
  def _level_1values_alt_J_3I_3JI_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int32(_t__3)
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1 = self._level_1values_J_3I_3JI_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _level_1values_J_3I_3JI_3D(self,_0,_1,_2,_3,_4):
   _5=mosek_fusion_IndexCounter._ctor_J_3I_3J(_0,_1,_2)
   _6=1
   for _7 in range(0,int((_1).shape[0])):
    _6 *= _1[_7]
   _8=self._model._getSolution_1barx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   _9=self.__conesize
   for _10 in range(0,_6):
    _11=((_5.get() // _9) + self.__coneidx)
    _12=(_5.get() % _9)
    _4[_10] = _8[self.__coneidx][_12]
    _5.inc()
  def _level_1values_alt__3JI_3D(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1 = self._level_1values__3JI_3D(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _level_1values__3JI_3D(self,_0,_1,_2):
   _3=self._model._getSolution_1barx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   _4=self.__psdvardim
   for _5 in range(0,int((_0).shape[0])):
    _6=((_0[_5] // _4) + self.__coneidx)
    _7=(_0[_5] % _4)
    _2[_5] = _3[_6][_7]
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_LinearPSDConstraint._ctor_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(self,_0))
 return LinearPSDConstraint
mosek_fusion_LinearPSDConstraint=__mk_mosek_fusion_LinearPSDConstraint()
del __mk_mosek_fusion_LinearPSDConstraint
#BEFORE CLASS
def __mk_mosek_fusion_PSDConstraint():
 class PSDConstraint(mosek_fusion_ModelConstraint):
  __slots__ = ['_PSDConstraint__names_flushed','_PSDConstraint__numcones','_PSDConstraint__conesize','_PSDConstraint__coneidx']
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_PSDConstraint._match_toString_(*args): # 
      return self._toString_(*args)
    elif mosek_fusion_PSDConstraint._match_alt_toString_(*args): # 
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDConstraint.toString()')
  def __str__(self): return self._toString_()
  def __repr__(self): return 'mosek.fusion.PSDConstraint: '+self._toString_()
  @staticmethod
  def _ctor_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(c,m):
    o = PSDConstraint.__new__(PSDConstraint)
    o._ctor_init_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4PSDConstraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4PSDConstraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m)
   self.__coneidx = (c.__coneidx)
   self.__conesize = (c.__conesize)
   self.__numcones = (c.__numcones)
   self.__names_flushed = (c.__names_flushed)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3IIII_3J_3I_3D_3D_3I_3I_3I(model_,name_,shape_,nativeidxs_,conesize_,firstcone_,numcone_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_):
    o = PSDConstraint.__new__(PSDConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3IIII_3J_3I_3D_3D_3I_3I_3I(model_,name_,shape_,nativeidxs_,conesize_,firstcone_,numcone_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3IIII_3J_3I_3D_3D_3I_3I_3I(*args):
    if len(args) != 14: return False
    model_,name_,shape_,nativeidxs_,conesize_,firstcone_,numcone_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model_) and __arg_match_S__(name_) and __arg_match_Lmosek_4fusion_4Set_2__(shape_) and __arg_match__3I__(nativeidxs_) and __arg_match_I__(conesize_) and __arg_match_I__(firstcone_) and __arg_match_I__(numcone_) and __arg_match__3J__(ptrb) and __arg_match__3I__(subj) and __arg_match__3D__(cof) and __arg_match__3D__(bfix) and __arg_match__3I__(barsubi_) and __arg_match__3I__(barsubj_) and __arg_match__3I__(barsymmatidx_))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3IIII_3J_3I_3D_3D_3I_3I_3I(*args):
    if len(args) != 14: return False
    model_,name_,shape_,nativeidxs_,conesize_,firstcone_,numcone_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model_) and __arg_alt_match_S__(name_) and __arg_alt_match_Lmosek_4fusion_4Set_2__(shape_) and __arg_alt_match__3I__(nativeidxs_) and __arg_alt_match_I__(conesize_) and __arg_alt_match_I__(firstcone_) and __arg_alt_match_I__(numcone_) and __arg_alt_match__3J__(ptrb) and __arg_alt_match__3I__(subj) and __arg_alt_match__3D__(cof) and __arg_alt_match__3D__(bfix) and __arg_alt_match__3I__(barsubi_) and __arg_alt_match__3I__(barsubj_) and __arg_alt_match__3I__(barsymmatidx_))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3IIII_3J_3I_3D_3D_3I_3I_3I(self,model_,name_,shape_,nativeidxs_,conesize_,firstcone_,numcone_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_):
    self._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3IIII_3J_3I_3D_3D_3I_3I_3I(model_,name_,shape_,numpy.array(nativeidxs_,dtype=numpy.dtype(numpy.int32)),numpy.int32(conesize_),numpy.int32(firstcone_),numpy.int32(numcone_),numpy.array(ptrb,dtype=numpy.dtype(numpy.int64)),numpy.array(subj,dtype=numpy.dtype(numpy.int32)),numpy.array(cof,dtype=numpy.dtype(numpy.float64)),numpy.array(bfix,dtype=numpy.dtype(numpy.float64)),numpy.array(barsubi_,dtype=numpy.dtype(numpy.int32)),numpy.array(barsubj_,dtype=numpy.dtype(numpy.int32)),numpy.array(barsymmatidx_,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3IIII_3J_3I_3D_3D_3I_3I_3I(self,model_,name_,shape_,nativeidxs_,conesize_,firstcone_,numcone_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4Set_2_3I_3J_3I_3D_3D_3I_3I_3I(self,model_,name_,shape_,nativeidxs_,ptrb,subj,cof,bfix,barsubi_,barsubj_,barsymmatidx_)
   self.__coneidx = firstcone_
   self.__conesize = conesize_
   self.__numcones = numcone_
   self.__names_flushed = False
  def _domainToString_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   _2=self._shape_p._idxtokey_J(_0)
   _1._a_S(" : element (")._a_I(_2[0])
   for _3 in range(1,int((_2).shape[0])):
    _1._a_S(",")._a_I(_2[_3])
   _1._a_S(") in a positive semi-definite cone of size (")._a_I(self._shape_p.dim(0))
   for _4 in range(1,int((_2).shape[0])):
    _1._a_S(",")._a_I(self._shape_p.dim(_4))
   _1._a_S(")")
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=(self._shape_p._size)
   _1=numpy.zeros((_0,), dtype=numpy.dtype(object))
   self._toStringArray__3JJ_3SZ(numpy.array([_2 for _2 in range(0,_0)], dtype=numpy.dtype(numpy.int64)),0,_1,False)
   _3=mosek.fusion.Utils.StringBuffer()
   _3._a_S("PSDConstraint( (")._a_I(self._shape_p.dim(0))
   for _4 in range(1,(self._shape_p.nd)):
    _3._a_S(",")._a_I(self._shape_p.dim(_4))
   _3._a_S("),")._lf_()
   _3._a_S("  ")._a_S(_1[0])
   for _5 in range(1,int((_1).shape[0])):
    _3._a_S(",")._lf_()._a_S("  ")._a_S(_1[_5])
   _3._a_S(" )")
   return (_3._toString_())
  def _toStringArray_alt__3JJ_3S(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(object))
   _1 = self._toStringArray__3JJ_3S(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _toStringArray__3JJ_3S(self,_0,_1,_2):
   self._toStringArray__3JJ_3SZ(_0,_1,_2,True)
  def _toStringArray_alt__3JJ_3SZ(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(object))
   _3=_t__3
   _1 = self._toStringArray__3JJ_3SZ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _toStringArray__3JJ_3SZ(self,_0,_1,_2,_3):
   for _4 in range(0,int((_0).shape[0])):
    if ((_0[_4] < 0) or (_0[_4] >= (self._shape_p._size))):
     raise mosek_fusion_IndexError._ctor_S("Constraint index out of bounds")
   if ((long((_0).shape[0]) + _1) > long((_2).shape[0])):
    raise mosek_fusion_LengthError._ctor_S("Result array is too small to hold the result")
   _5=mosek.fusion.Utils.StringBuffer()
   _6=self._cache._order_1barentries_()
   _7=0
   for _8 in range(0,int((_0).shape[0])):
    _9=_0[_8]
    _10=(_9 // (self.__conesize * self.__conesize))
    _11=(_9 % (self.__conesize * self.__conesize))
    _12=(_11 // self.__conesize)
    _13=(_11 % self.__conesize)
    _14=((((_12 * (_12 + 1)) // 2) + _13) if ((_12 >= _13) ) else (((_13 * (_13 + 1)) // 2) + _12))
    _15=(_14 + (((_10 * self.__conesize) * (self.__conesize + 1)) // 2))
    _5._clear_()._a_S(self._name)._a_S("[")._a_J(_10)._a_S(",")._a_J(_12)._a_S(",")._a_J(_13)._a_S("] : ")
    _16=self._nativeindexes[_15]
    _17=0
    while ((_17 < int(((self._cache.subi)).shape[0])) and ((self._cache.subi)[_17] < _15)):
     _17 += 1
    _18=_17
    while ((_17 < int(((self._cache.subi)).shape[0])) and ((self._cache.subi)[_17]==_15)):
     _17 += 1
    _19=0
    while ((_19 < _6) and ((self._cache.barsubi)[_19] < _15)):
     _19 += 1
    _20=_19
    while ((_19 < _6) and ((self._cache.barsubi)[_19]==_15)):
     _19 += 1
    for _21 in range(_18,_17):
     _22=(self._cache.cof)[_21]
     if (_22 > 0):
      _5._a_S(" + ")._a_D(_22)._a_S(" ")
     elif (_22 < 0):
      _5._a_S(" - ")._a_D((- _22))._a_S(" ")
     else:
      _5._a_S(" + 0.0 ")
     self._model._nativeVarToStr_ILmosek_4fusion_4Utils_4StringBuffer_2((self._cache.subj)[_21],_5)
    _23=_19
    _19 = _20
    while ((_19 < _23) and ((self._cache.barsubi)[_19]==_15)):
     _24=_19
     _25=(self._cache.barsubj)[_19]
     _19 += 1
     while ((_19 < _23) and ((self._cache.barsubj)[_19]==_25)):
      _19 += 1
     _5._a_S(" + < M")._a_I((self._cache.barmatidx)[_24])
     for _26 in range((_24 + 1),_19):
      _5._a_S(" + M")._a_I((self._cache.barmatidx)[_26])
     _5._a_S(" ; ")._a_S((((self._model._vars)[(self._model._natbarvarmap_Var)[(self._cache.barsubj)[_24]]]._name) if ((int(len(((self._model._vars)[(self._model._natbarvarmap_Var)[(self._cache.barsubj)[_24]]]._name))) > 0) ) else "_"))._a_S(" >")
    if (self._cache_bfix is not None):
     if (self._cache_bfix[_15] > 0):
      _5._a_S(" + ")._a_D(self._cache_bfix[_15])
     elif (self._cache_bfix[_15] < 0):
      _5._a_S(" + ")._a_D(self._cache_bfix[_15])
    if _3:
     _5._a_S(" ")
     self._domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(_9,_5)
    _2[(numpy.int64(_8) + _1)] = _5._toString_()
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   if ((not self.__names_flushed) and (int(len(self._name)) > 0)):
    _0=mosek.fusion.Utils.StringBuffer()
    if (self.__numcones > 1):
     _1=0
     for _2 in range(0,self.__numcones):
      for _3 in range(0,self.__conesize):
       for _4 in range(0,(_3 + 1)):
        self._model._task_1con_1name_IS(self._nativeindexes[_1],_0._clear_()._a_S(self._name)._a_S("[")._a_I(_2)._a_S(",")._a_I(_3)._a_S(",")._a_I(_4)._a_S("]")._toString_())
        _1 += 1
    else:
     _5=0
     for _6 in range(0,self.__conesize):
      for _7 in range(0,(_6 + 1)):
       self._model._task_1con_1name_IS(self._nativeindexes[_5],_0._clear_()._a_S(self._name)._a_S("[")._a_I(_6)._a_S(",")._a_I(_7)._a_S("]")._toString_())
       _5 += 1
    for _8 in range(0,self.__numcones):
     self._model._task_1barvar_1name_IS((self.__coneidx + _8),_0._clear_()._a_S(self._name)._a_S("[")._a_I(_8)._a_S("].coneslack")._toString_())
    self.__names_flushed = True
  def _add_1fx_alt__3J_3DJII(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=numpy.int64(_t__2)
   _3=numpy.int32(_t__3)
   _4=numpy.int32(_t__4)
   _1 = self._add_1fx__3J_3DJII(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1
  def _add_1fx__3J_3DJII(self,_0,_1,_2,_3,_4):
   _5=numpy.zeros((_4,), d