//
//    Copyright: Copyright (c) MOSEK ApS, Denmark. All rights reserved.
//
//    File:    mioinitsol.java
//
//    Purpose:  Demonstrates how to solve a small mixed
//              integer linear optimization problem.
//
package com.mosek.fusion.examples;
import mosek.fusion.*;

public class mioinitsol {
  public static void main(String[] args)
  throws SolutionError {
    int n = 4;
    //TAG:begin-define-data
    double[] c = { 7.0, 10.0, 1.0, 5.0 };
    //TAG:end-define-data

    //TAG:begin-create-model
    Model M = new Model("mioinitsol");
    //TAG:end-create-model
    try {
      //TAG:begin-create-variable
      Variable x = M.variable("x", n, Domain.integral(Domain.greaterThan(0.0)));
      //TAG:end-create-variable

      //TAG:begin-create-lincon
      M.constraint(Expr.sum(x), Domain.lessThan(2.5));
      //TAG:end-create-lincon

      //TAG:begin-set-parameters
      M.setSolverParam("mioMaxTime", 60.0);
      M.setSolverParam("mioTolRelGap", 1e-4);
      M.setSolverParam("mioTolAbsGap", 0.0);
      //TAG:end-set-parameters

      //TAG:begin-set-objective
      M.objective("obj", ObjectiveSense.Maximize, Expr.dot(c, x));
      //TAG:end-set-objective

      //TAG:begin-init-sol
      double[] init_sol = { 0.0, 2.0, 0.0, 0.0 };      
      x.setLevel( init_sol );
      //TAG:end-init-sol

      //TAG:begin-solve
      M.solve();
      //TAG:end-solve

      //TAG:begin-get-solution
      // Get the solution values
      double[] sol = x.level();
      System.out.printf("x = [");
      for (int i = 0; i < n; i++) {
        System.out.printf("%e, ", sol[i]);
      }
      System.out.printf("]\n");
      System.out.printf("MIP rel gap = %.2f (%f)",
                        M.getSolverDoubleInfo("mioObjRelGap"),
                        M.getSolverDoubleInfo("mioObjAbsGap"));
      //TAG:end-get-solution
    } finally {
      M.dispose();
    }
  }
}
