/*
  Copyright: Copyright (c) MOSEK ApS, Denmark. All rights reserved.

  File:      parameters.cs

 Purpose: Demonstrates a very simple example about how to get/set
 parameters with MOSEK .NET API

*/

using System;

namespace mosek.example
{
  public class parameters
  {
    public static void Main()
    {
      using (mosek.Env env = new mosek.Env())
      {
        using (mosek.Task task = new mosek.Task(env, 0, 0))
        {
          int param;
          Console.WriteLine("Test MOSEK parameter get/set functions");

          /*TAG:begin-get-parameter*/
          param = task.getintparam(mosek.iparam.log);
          /*TAG:end-get-parameter*/

          Console.WriteLine("Default value for parameter task.ipar.log= " + param);
          Console.WriteLine(" setting to 1 using putintparam...");

          /*TAG:begin-put-param-id*/
          task.putintparam(mosek.iparam.log, 1);
          /*TAG:end-put-param-id*/

          Console.WriteLine(" setting to -1 using putintparam...");
          /*TAG:begin-wrong-value*/
          try
          {
            task.putintparam(mosek.iparam.log, -1);
          }
          catch (mosek.Error e)
          {
            Console.WriteLine(" -1 rejected as not a valid value");
          }
          /*TAG:end-wrong-value*/

          Console.WriteLine(" setting to 2 using putparam...");
          task.putparam("MSK_IPAR_LOG", "2");
          Console.WriteLine(" setting to 3 using putnaintparam...");

          /*TAG:begin-put-param-name*/
          task.putnaintparam("MSK_IPAR_LOG", 3);
          /*TAG:end-put-param-name*/

          Console.WriteLine(" selecting the dual simplex algorithm...");
          /*TAG:begin-algo-select*/
          task.putintparam(mosek.iparam.optimizer, mosek.optimizertype.dual_simplex);
          /*TAG:end-algo-select*/
        }
      }
    }
  }
}
