/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.BaseSet;
import mosek.fusion.IndexError;
import mosek.fusion.Set;
import mosek.fusion.SliceError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;

public class StringSet
extends BaseSet {
    private String[] keys;

    public StringSet(String[] stringArray) {
        super(stringArray.length);
        this.keys = Tools.arraycopy(stringArray);
    }

    @Override
    public String indexToString(long l) {
        return this.keys[(int)l];
    }

    @Override
    public String getname(int[] nArray) {
        if (nArray.length != 1) {
            throw new IndexError("Invalid key specification");
        }
        return this.keys[nArray[0]];
    }

    @Override
    public String getname(long l) {
        return this.keys[(int)l];
    }

    protected BaseSet slice_(int[] nArray, int[] nArray2) {
        if (nArray.length != 1 || nArray2.length != 1 || nArray[0] < 0 || nArray[0] > nArray2[0] || nArray2[0] >= this.keys.length) {
            throw new SliceError("Invalid slice specification");
        }
        return this.slice_(nArray[0], nArray2[0]);
    }

    protected BaseSet slice_(int n, int n2) {
        if (n < 0 || n > n2 || n2 > this.keys.length) {
            throw new SliceError("Invalid slice specification");
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = n2 - n;
        int n6 = n4 < n5 ? n5 - n4 : 0;
        String[] stringArray = new String[n6];
        int n7 = n4;
        int n8 = 0;
        while (n8 < n6) {
            stringArray[n3] = this.keys[n7 + n];
            ++n3;
            ++n8;
            ++n7;
        }
        return new StringSet(stringArray);
    }

    @Override
    public Set slice(int[] nArray, int[] nArray2) {
        return this.slice_(nArray, nArray2);
    }

    @Override
    public Set slice(int n, int n2) {
        return this.slice_(n, n2);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("{'").a(this.keys[0]).a("'");
        for (int i = 1; i < this.keys.length && i < this.keys.length; ++i) {
            stringBuffer.a(",'").a(this.keys[i]).a("'");
        }
        stringBuffer.a("}");
        return stringBuffer.toString();
    }

    @Override
    public long stride(int n) {
        return 1L;
    }
}

