/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.BaseVariable;
import mosek.fusion.IndexError;
import mosek.fusion.Set;
import mosek.fusion.SolutionError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Variable;

public class RepeatVariable
extends BaseVariable {
    private long d2;
    private long d1;
    private long d0;
    private int dim;
    private int count;
    private long xsize;
    private int[] xdims;
    private Variable x;

    public RepeatVariable(Variable variable, int n, int n2) {
        super(variable.getModel(), RepeatVariable.compute_shape(variable, n, n2));
        int n3;
        int n4;
        int n5;
        Set set = variable.getShape();
        this.x = variable;
        this.count = n2;
        this.xsize = set.getSize();
        if (n >= 0) {
            n5 = set.nd;
            if (n5 <= n) {
                n5 = n + 1;
            }
            this.dim = n;
            n4 = 0;
            n3 = 0;
            int n6 = n5;
            int n7 = n3 < n6 ? n6 - n3 : 0;
            int[] nArray = new int[n7];
            int n8 = n3;
            int n9 = 0;
            while (n9 < n7) {
                nArray[n4] = set.dim(n8);
                ++n4;
                ++n9;
                ++n8;
            }
            this.xdims = nArray;
        } else {
            this.dim = 0;
            this.xdims = new int[set.nd + 1];
            this.xdims[0] = 1;
            n5 = 0;
            n4 = set.nd;
            for (n3 = n5; n3 < n4; ++n3) {
                this.xdims[n3 + 1] = set.dim(n3);
            }
        }
        this.d0 = 1L;
        this.d1 = 1L;
        this.d2 = 1L;
        n5 = 0;
        n4 = n;
        for (n3 = n5; n3 < n4; ++n3) {
            this.d0 *= (long)this.xdims[n3];
        }
        this.d1 = this.xdims[this.dim] * n2;
        n5 = n + 1;
        n4 = this.xdims.length;
        for (n3 = n5; n3 < n4; ++n3) {
            this.d2 *= (long)this.xdims[n3];
        }
    }

    @Override
    public StringBuffer elementDesc(long l, StringBuffer stringBuffer) {
        if (this.dim == 0) {
            return this.x.elementDesc(l % this.xsize, stringBuffer);
        }
        if (this.dim >= this.x.getShape().nd) {
            return this.x.elementDesc(l / this.xsize, stringBuffer);
        }
        long l2 = this.d0;
        long l3 = (long)this.xdims[this.dim] * this.d2;
        long l4 = l % l3;
        long l5 = l / (l3 * (long)this.count);
        return this.x.elementDesc(l5 * l3 + l4, stringBuffer);
    }

    @Override
    public void elementName(long l, StringBuffer stringBuffer) {
        if (this.dim == 0) {
            this.x.elementName(l % this.xsize, stringBuffer);
        } else if (this.dim >= this.x.getShape().nd) {
            this.x.elementName(l / this.xsize, stringBuffer);
        } else {
            long l2 = this.d0;
            long l3 = (long)this.x.getShape().dim(this.dim) * this.d2;
            long l4 = l % l3;
            long l5 = l / (l3 * (long)this.count);
            this.x.elementName(l5 * l3 + l4, stringBuffer);
        }
    }

    @Override
    public void inst(long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.dim == 0) {
            this.x.inst(l % this.xsize, l2, nArray, nArray3, nArray2);
        } else if (this.d1 * this.d2 == 1L) {
            this.x.inst(l / (long)this.count, l2, nArray, nArray3, nArray2);
        } else {
            long l3 = this.d0;
            long l4 = (long)this.x.getShape().dim(this.dim) * this.d2;
            long l5 = l % l4;
            long l6 = l / (l4 * (long)this.count);
            this.x.inst(l6 * l4 + l5, l2, nArray, nArray3, nArray2);
        }
    }

    @Override
    public void set_values(long l, int[] nArray, long[] lArray, int n, double[] dArray, boolean bl) {
        int n2;
        if (nArray.length != this.shape_p.nd || lArray.length != this.shape_p.nd) {
            throw new IndexError("Lengths of nsize and strides are not correct");
        }
        int n3 = lArray.length;
        int n4 = nArray[0];
        int n5 = 1;
        int n6 = nArray.length;
        for (n2 = n5; n2 < n6; ++n2) {
            n4 *= nArray[n2];
        }
        n5 = 0;
        n6 = 0;
        n2 = nArray.length;
        int n7 = n6 < n2 ? n2 - n6 : 0;
        long[] lArray2 = new long[n7];
        int n8 = n6;
        int n9 = 0;
        while (n9 < n7) {
            lArray2[n5] = l;
            ++n5;
            ++n9;
            ++n8;
        }
        long[] lArray3 = lArray2;
        int[] nArray2 = this.shape_p.idxtokey(l);
        double[] dArray2 = new double[n4];
        long[] lArray4 = new long[n4];
        int n10 = 0;
        int n11 = n4;
        for (int i = n10; i < n11; ++i) {
            int n12;
            dArray2[i] = dArray[i + n];
            long l2 = lArray3[0] % this.d2;
            long l3 = lArray3[0] / this.d2 % (long)this.xdims[this.dim];
            long l4 = lArray3[0] / (this.d1 * this.d2);
            lArray4[i] = (l2 * this.d2 + l3) * (long)this.xdims[this.dim] + l4;
            nArray2[0] = nArray2[0] + 1;
            lArray3[0] = lArray3[0] + lArray[n3 - 1];
            for (n12 = 0; n12 < n3 - 1 && nArray2[n12] == nArray[n12]; ++n12) {
                nArray2[n12] = 0;
                int n13 = n12 + 1;
                nArray2[n13] = nArray2[n13] + 1;
            }
            int n14 = 0;
            int n15 = n12;
            for (int j = n14; j < n15; ++j) {
                lArray3[j] = lArray3[n12];
            }
        }
        this.set_values(lArray4, dArray2, bl);
    }

    @Override
    public void set_values(long[] lArray, double[] dArray, boolean bl) {
        if (this.dim == 0) {
            int n = 0;
            int n2 = 0;
            int n3 = lArray.length;
            int n4 = n2 < n3 ? n3 - n2 : 0;
            long[] lArray2 = new long[n4];
            int n5 = n2;
            int n6 = 0;
            while (n6 < n4) {
                lArray2[n] = lArray[n5] % this.xsize;
                ++n;
                ++n6;
                ++n5;
            }
            this.x.set_values(lArray2, dArray, bl);
        } else if (this.d1 * this.d2 == 1L) {
            int n = 0;
            int n7 = 0;
            int n8 = lArray.length;
            int n9 = n7 < n8 ? n8 - n7 : 0;
            long[] lArray3 = new long[n9];
            int n10 = n7;
            int n11 = 0;
            while (n11 < n9) {
                lArray3[n] = lArray[n10] / (long)this.count;
                ++n;
                ++n11;
                ++n10;
            }
            this.x.set_values(lArray3, dArray, bl);
        } else {
            long l = this.d0;
            long l2 = (long)this.x.getShape().dim(this.dim) * this.d2;
            long[] lArray4 = new long[lArray.length];
            int n = 0;
            int n12 = lArray.length;
            for (int i = n; i < n12; ++i) {
                long l3 = lArray[i] % l2;
                long l4 = lArray[i] / (l2 * (long)this.count);
                lArray4[i] = l4 * l2 + l3;
            }
            this.x.set_values(lArray4, dArray, bl);
        }
    }

    @Override
    public void values(long l, int[] nArray, long[] lArray, int n, double[] dArray, boolean bl) throws SolutionError {
        int n2;
        if (nArray.length != this.shape_p.nd || lArray.length != this.shape_p.nd) {
            throw new IndexError("Lengths of nsize and strides are not correct");
        }
        int n3 = lArray.length;
        int n4 = nArray[0];
        int n5 = 1;
        int n6 = nArray.length;
        for (n2 = n5; n2 < n6; ++n2) {
            n4 *= nArray[n2];
        }
        n5 = 0;
        n6 = 0;
        n2 = nArray.length;
        int n7 = n6 < n2 ? n2 - n6 : 0;
        long[] lArray2 = new long[n7];
        int n8 = n6;
        int n9 = 0;
        while (n9 < n7) {
            lArray2[n5] = l;
            ++n5;
            ++n9;
            ++n8;
        }
        long[] lArray3 = lArray2;
        int[] nArray2 = this.shape_p.idxtokey(l);
        long[] lArray4 = new long[n4];
        int n10 = 0;
        int n11 = n4;
        for (int i = n10; i < n11; ++i) {
            int n12;
            long l2 = lArray3[0] % this.d2;
            long l3 = lArray3[0] / this.d2 % (long)this.xdims[this.dim];
            long l4 = lArray3[0] / (this.d1 * this.d2);
            lArray4[i] = (l2 * this.d2 + l3) * (long)this.xdims[this.dim] + l4;
            nArray2[0] = nArray2[0] + 1;
            lArray3[0] = lArray3[0] + lArray[n3 - 1];
            for (n12 = 0; n12 < n3 - 1 && nArray2[n12] == nArray[n12]; ++n12) {
                nArray2[n12] = 0;
                int n13 = n12 + 1;
                nArray2[n13] = nArray2[n13] + 1;
            }
            int n14 = 0;
            int n15 = n12;
            for (int j = n14; j < n15; ++j) {
                lArray3[j] = lArray3[n12];
            }
        }
        this.values(lArray4, n, dArray, bl);
    }

    @Override
    public void values(long[] lArray, int n, double[] dArray, boolean bl) throws SolutionError {
        if (this.d0 == 1L) {
            int n2 = 0;
            int n3 = 0;
            int n4 = lArray.length;
            int n5 = n3 < n4 ? n4 - n3 : 0;
            long[] lArray2 = new long[n5];
            int n6 = n3;
            int n7 = 0;
            while (n7 < n5) {
                lArray2[n2] = lArray[n6] % this.xsize;
                ++n2;
                ++n7;
                ++n6;
            }
            this.x.values(lArray2, n, dArray, bl);
        } else if (this.d1 * this.d2 == 1L) {
            int n8 = 0;
            int n9 = 0;
            int n10 = lArray.length;
            int n11 = n9 < n10 ? n10 - n9 : 0;
            long[] lArray3 = new long[n11];
            int n12 = n9;
            int n13 = 0;
            while (n13 < n11) {
                lArray3[n8] = lArray[n12] / (long)this.count;
                ++n8;
                ++n13;
                ++n12;
            }
            this.x.values(lArray3, n, dArray, bl);
        } else {
            long l = this.d0;
            long l2 = (long)this.x.getShape().dim(this.dim) * this.d2;
            long[] lArray4 = new long[lArray.length];
            int n14 = 0;
            int n15 = lArray.length;
            for (int i = n14; i < n15; ++i) {
                long l3 = lArray[i] % l2;
                long l4 = lArray[i] / (l2 * (long)this.count);
                lArray4[i] = l4 * l2 + l3;
            }
            this.x.values(lArray4, n, dArray, bl);
        }
    }

    @Override
    public void make_continuous(long[] lArray) {
        if (this.d0 == 1L) {
            int n = 0;
            int n2 = 0;
            int n3 = lArray.length;
            int n4 = n2 < n3 ? n3 - n2 : 0;
            long[] lArray2 = new long[n4];
            int n5 = n2;
            int n6 = 0;
            while (n6 < n4) {
                lArray2[n] = lArray[n5] % this.xsize;
                ++n;
                ++n6;
                ++n5;
            }
            this.x.make_continuous(lArray2);
        } else if (this.d1 * this.d2 == 1L) {
            int n = 0;
            int n7 = 0;
            int n8 = lArray.length;
            int n9 = n7 < n8 ? n8 - n7 : 0;
            long[] lArray3 = new long[n9];
            int n10 = n7;
            int n11 = 0;
            while (n11 < n9) {
                lArray3[n] = lArray[n10] / (long)this.count;
                ++n;
                ++n11;
                ++n10;
            }
            this.x.make_continuous(lArray3);
        } else {
            long l = this.d0;
            long l2 = (long)this.x.getShape().dim(this.dim) * this.d2;
            long[] lArray4 = new long[lArray.length];
            int n = 0;
            int n12 = lArray.length;
            for (int i = n; i < n12; ++i) {
                long l3 = lArray[i] % l2;
                long l4 = lArray[i] / (l2 * (long)this.count);
                lArray4[i] = l4 * l2 + l3;
            }
            this.x.make_continuous(lArray4);
        }
    }

    @Override
    public void make_integer(long[] lArray) {
        if (this.dim == 0) {
            int n = 0;
            int n2 = 0;
            int n3 = lArray.length;
            int n4 = n2 < n3 ? n3 - n2 : 0;
            long[] lArray2 = new long[n4];
            int n5 = n2;
            int n6 = 0;
            while (n6 < n4) {
                lArray2[n] = lArray[n5] % this.xsize;
                ++n;
                ++n6;
                ++n5;
            }
            this.x.make_integer(lArray2);
        } else if (this.d1 * this.d2 == 1L) {
            int n = 0;
            int n7 = 0;
            int n8 = lArray.length;
            int n9 = n7 < n8 ? n8 - n7 : 0;
            long[] lArray3 = new long[n9];
            int n10 = n7;
            int n11 = 0;
            while (n11 < n9) {
                lArray3[n] = lArray[n10] / (long)this.count;
                ++n;
                ++n11;
                ++n10;
            }
            this.x.make_integer(lArray3);
        } else {
            long l = this.d0;
            long l2 = (long)this.x.getShape().dim(this.dim) * this.d2;
            long[] lArray4 = new long[lArray.length];
            int n = 0;
            int n12 = lArray.length;
            for (int i = n; i < n12; ++i) {
                long l3 = lArray[i] % l2;
                long l4 = lArray[i] / (l2 * (long)this.count);
                lArray4[i] = l4 * l2 + l3;
            }
            this.x.make_integer(lArray4);
        }
    }

    private static Set compute_shape(Variable variable, int n, int n2) {
        Set set = variable.getShape();
        if (n >= 0) {
            int n3;
            if (set.nd == 1 && n == 0) {
                return Set.make(set.dim(0) * n2);
            }
            if (n < set.nd) {
                int n4 = 0;
                int n5 = 0;
                int n6 = set.nd;
                int n7 = n5 < n6 ? n6 - n5 : 0;
                int[] nArray = new int[n7];
                int n8 = n5;
                int n9 = 0;
                while (n9 < n7) {
                    nArray[n4] = set.dim(n8);
                    ++n4;
                    ++n9;
                    ++n8;
                }
                int[] nArray2 = nArray;
                int n10 = n;
                nArray2[n10] = nArray2[n10] * n2;
                return Set.make(nArray2);
            }
            int[] nArray = new int[n + 1];
            int n11 = 0;
            int n12 = set.nd;
            for (n3 = n11; n3 < n12; ++n3) {
                nArray[n3] = set.dim(n3);
            }
            n11 = set.nd;
            n12 = n;
            for (n3 = n11; n3 < n12; ++n3) {
                nArray[n3] = 1;
            }
            nArray[n] = n2;
            return Set.make(nArray);
        }
        int[] nArray = new int[set.nd + 1];
        nArray[0] = n2;
        int n13 = 0;
        int n14 = set.nd;
        for (int i = n13; i < n14; ++i) {
            nArray[i + 1] = set.dim(i);
        }
        return Set.make(nArray);
    }
}

