/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.Set;

public class IndexCounter {
    private long start;
    private int[] dims;
    private long[] strides;
    private long[] st;
    private int[] ii;
    private int n;

    public IndexCounter(Set set) {
        int n;
        this.n = set.nd;
        this.ii = new int[this.n];
        this.st = new long[this.n];
        this.start = 0L;
        this.strides = new long[this.n];
        int n2 = 0;
        int n3 = this.n;
        for (n = n2; n < n3; ++n) {
            this.strides[n] = set.stride(n);
        }
        this.dims = new int[this.n];
        n2 = 0;
        n3 = this.n;
        for (n = n2; n < n3; ++n) {
            this.dims[n] = set.dim(n);
        }
    }

    public IndexCounter(long l, int[] nArray, Set set) {
        int n;
        this.n = nArray.length;
        this.ii = new int[this.n];
        this.st = new long[this.n];
        int n2 = 0;
        int n3 = this.n;
        for (n = n2; n < n3; ++n) {
            this.st[n] = l;
        }
        this.strides = new long[this.n];
        n2 = 0;
        n3 = this.n;
        for (n = n2; n < n3; ++n) {
            this.strides[n] = set.stride(n);
        }
        this.dims = nArray;
        this.start = l;
    }

    public IndexCounter(long l, int[] nArray, long[] lArray) {
        this.n = nArray.length;
        this.ii = new int[this.n];
        this.st = new long[this.n];
        int n = 0;
        int n2 = this.n;
        for (int i = n; i < n2; ++i) {
            this.st[i] = l;
        }
        this.strides = lArray;
        this.dims = nArray;
        this.start = l;
    }

    public boolean atEnd() {
        return this.ii[this.n - 1] >= this.dims[this.n - 1];
    }

    public int[] getIndex() {
        return this.ii;
    }

    public long next() {
        long l = this.get();
        this.inc();
        return l;
    }

    public long get() {
        return this.st[0];
    }

    public void inc() {
        int n;
        this.ii[0] = this.ii[0] + 1;
        this.st[0] = this.st[0] + this.strides[this.n - 1];
        for (n = 0; n < this.n - 1 && this.ii[n] == this.dims[this.n - n - 1] && n < this.n - 1 && this.ii[n] == this.dims[this.n - n - 1]; ++n) {
            this.ii[n] = 0;
            int n2 = n + 1;
            this.ii[n2] = this.ii[n2] + 1;
            this.st[n + 1] = this.st[n + 1] + this.strides[this.n - n - 2];
        }
        int n3 = 0;
        int n4 = n;
        for (int i = n3; i < n4; ++i) {
            this.st[i] = this.st[n];
        }
    }

    public void reset() {
        this.st = new long[this.n];
        int n = 0;
        int n2 = this.n;
        for (int i = n; i < n2; ++i) {
            this.st[i] = this.start;
        }
    }
}

