/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.CompoundConstraint;
import mosek.fusion.DimensionError;
import mosek.fusion.Expression;
import mosek.fusion.FlatExpr;
import mosek.fusion.Model;
import mosek.fusion.NDSet;
import mosek.fusion.Set;
import mosek.fusion.SliceError;
import mosek.fusion.SolutionError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;
import mosek.fusion.Variable;

public abstract class Constraint {
    protected Set shape_p;
    protected Model model;

    public Constraint(Constraint constraint, Model model) {
        this.model = model;
        this.shape_p = constraint.shape_p;
    }

    public Constraint(Model model, Set set) {
        this.model = model;
        this.shape_p = set;
    }

    public String toString() {
        int n;
        long l = this.shape_p.size;
        String[] stringArray = new String[(int)l];
        this.toStringArray(Tools.range(l), 0L, stringArray);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("Constraint( (").a(this.shape_p.dim(0));
        int n2 = 1;
        int n3 = this.shape_p.nd;
        for (n = n2; n < n3; ++n) {
            stringBuffer.a(",").a(this.shape_p.dim(n));
        }
        stringBuffer.a("),").lf();
        stringBuffer.a("  ").a(stringArray[0]);
        n2 = 1;
        n3 = stringArray.length;
        for (n = n2; n < n3; ++n) {
            stringBuffer.a(",").lf().a("  ").a(stringArray[n]);
        }
        stringBuffer.a(" )");
        return stringBuffer.toString();
    }

    protected abstract void toStringArray(long[] var1, long var2, String[] var4);

    public Constraint add(double d) {
        long l = this.shape_p.size;
        int n = 0;
        int n2 = 0;
        long l2 = l;
        long l3 = (long)n2 < l2 ? l2 - (long)n2 : 0L;
        long[] lArray = new long[(int)l3];
        long l4 = n2;
        int n3 = 0;
        while ((long)n3 < l3) {
            lArray[n] = l4++;
            ++n;
            ++n3;
        }
        n3 = 0;
        int n4 = 0;
        long l5 = l + 1L;
        long l6 = (long)n4 < l5 ? l5 - (long)n4 : 0L;
        long[] lArray2 = new long[(int)l6];
        long l7 = n4;
        int n5 = 0;
        while ((long)n5 < l6) {
            lArray2[n3] = 0L;
            ++n3;
            ++n5;
            ++l7;
        }
        n5 = 0;
        int n6 = 0;
        long l8 = l;
        long l9 = (long)n6 < l8 ? l8 - (long)n6 : 0L;
        double[] dArray = new double[(int)l9];
        long l10 = n6;
        int n7 = 0;
        while ((long)n7 < l9) {
            dArray[n5] = d;
            ++n5;
            ++n7;
            ++l10;
        }
        this.add_l(lArray, lArray2, new int[0], new int[0], new int[0], new double[0], dArray, 0L, 0, (int)l);
        return this;
    }

    public Constraint add(double[] dArray) {
        long l = this.shape_p.size;
        if (this.shape_p.nd != 1 || dArray.length != this.shape_p.dim(0)) {
            throw new DimensionError("The added constant array does not have the same shape as the constraint");
        }
        int n = 0;
        int n2 = 0;
        long l2 = l;
        long l3 = (long)n2 < l2 ? l2 - (long)n2 : 0L;
        long[] lArray = new long[(int)l3];
        long l4 = n2;
        int n3 = 0;
        while ((long)n3 < l3) {
            lArray[n] = l4++;
            ++n;
            ++n3;
        }
        n3 = 0;
        int n4 = 0;
        long l5 = l + 1L;
        long l6 = (long)n4 < l5 ? l5 - (long)n4 : 0L;
        long[] lArray2 = new long[(int)l6];
        long l7 = n4;
        int n5 = 0;
        while ((long)n5 < l6) {
            lArray2[n3] = 0L;
            ++n3;
            ++n5;
            ++l7;
        }
        this.add_l(lArray, lArray2, new int[0], new int[0], new int[0], new double[0], dArray, 0L, 0, (int)l);
        return this;
    }

    public Constraint add(Variable variable) {
        if (!variable.shape().compare(this.shape_p)) {
            throw new DimensionError("The added variable does not have the same shape as the constraint");
        }
        long l = variable.getShape().size;
        int[] nArray = new int[(int)l];
        int[] nArray2 = new int[(int)l];
        int[] nArray3 = new int[(int)l];
        long[] lArray = Tools.range(0L, l + 1L);
        double[] dArray = new double[(int)l];
        long l2 = 0L;
        long l3 = l;
        for (long i = l2; i < l3; ++i) {
            variable.inst(i, i, nArray, nArray2, nArray3);
            dArray[(int)i] = 1.0;
        }
        long[] lArray2 = Tools.range(0L, l);
        this.add_l(lArray2, lArray, nArray, nArray2, nArray2, dArray, null, 0L, 0, (int)l);
        return this;
    }

    public Constraint add(Expression expression) {
        if (!expression.shape().compare(this.shape_p)) {
            throw new DimensionError("The added expression does not have the same shape as the constraint");
        }
        FlatExpr flatExpr = expression.eval();
        int n = flatExpr.ptrb.length - 1;
        int[] nArray = new int[(int)flatExpr.nnz];
        int[] nArray2 = new int[(int)flatExpr.nnz];
        int[] nArray3 = new int[(int)flatExpr.nnz];
        Constraint.inst(flatExpr.x, flatExpr.subj, nArray, nArray, nArray);
        long[] lArray = flatExpr.inst;
        if (lArray == null) {
            lArray = Tools.range(0L, (long)n);
        }
        this.add_l(lArray, flatExpr.ptrb, nArray, nArray2, nArray3, flatExpr.cof, flatExpr.bfix, 0L, 0, n);
        return this;
    }

    protected static void inst(Variable[] variableArray, long[] lArray, int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        long[] lArray2 = new long[variableArray.length + 1];
        int n2 = 0;
        int n3 = variableArray.length;
        for (n = n2; n < n3; ++n) {
            lArray2[n + 1] = lArray2[n] + variableArray[n].size();
        }
        n2 = 0;
        n3 = lArray.length;
        for (n = n2; n < n3; ++n) {
            int n4 = lArray2.length / 2;
            int n5 = 0;
            int n6 = lArray2.length - 1;
            int n7 = 0;
            while (n5 < n6) {
                n7 = (n5 + n6) / 2;
                if (lArray[n] < lArray2[n7]) {
                    n6 = n7;
                    continue;
                }
                if (lArray[n] >= lArray2[n7 + 1]) {
                    n5 = n7;
                    continue;
                }
                n5 = n7;
                n6 = n7;
            }
            n4 = n7;
            variableArray[n4].inst(lArray[n] - lArray2[n4], n, nArray, nArray2, nArray3);
        }
    }

    protected abstract void add_l(long[] var1, long[] var2, int[] var3, int[] var4, int[] var5, double[] var6, double[] var7, long var8, int var10, int var11);

    public double[] dual(int[] nArray, int[] nArray2) throws SolutionError {
        if (this.shape_p.nd != nArray.length || this.shape_p.nd != nArray2.length) {
            throw new SliceError("Invalid slice specification");
        }
        int n = 1;
        for (int i = 0; i < this.shape_p.nd && i < this.shape_p.nd; ++i) {
            if (nArray[i] > nArray2[i] || nArray[i] < 0 || nArray2[i] >= this.shape_p.dim(i)) {
                throw new SliceError("Slice index out of bound");
            }
            n *= nArray2[i] * nArray[i];
        }
        double[] dArray = new double[n];
        int[] nArray3 = new int[this.shape_p.nd];
        long[] lArray = new long[this.shape_p.nd];
        long l = 0L;
        int n2 = 0;
        int n3 = this.shape_p.nd;
        for (int i = n2; i < n3; ++i) {
            nArray3[i] = nArray2[i] - nArray[i];
            lArray[i] = this.shape_p.stride(i);
            l += lArray[i] * (long)nArray[i];
        }
        this.dual_values(l, nArray3, lArray, 0, dArray);
        return dArray;
    }

    public double[] dual(int n, int n2) throws SolutionError {
        if (this.shape_p.nd != 1 || n > n2 || n < 0 || n2 >= this.shape_p.dim(0)) {
            throw new SliceError("Invalid slice specification");
        }
        int n3 = n2 - n;
        double[] dArray = new double[n3];
        this.dual_values(n, new int[]{n3}, new long[]{1L}, 0, dArray);
        return dArray;
    }

    public double[] dual() throws SolutionError {
        double[] dArray = new double[(int)this.shape_p.size];
        this.dual_values(0, dArray);
        return dArray;
    }

    protected void dual_values(int n, double[] dArray) throws SolutionError {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.shape_p.nd;
        int n5 = n3 < n4 ? n4 - n3 : 0;
        int[] nArray = new int[n5];
        int n6 = n3;
        int n7 = 0;
        while (n7 < n5) {
            nArray[n2] = this.shape_p.dim(n6);
            ++n2;
            ++n7;
            ++n6;
        }
        int[] nArray2 = nArray;
        int n8 = 0;
        int n9 = 0;
        int n10 = this.shape_p.nd;
        int n11 = n9 < n10 ? n10 - n9 : 0;
        long[] lArray = new long[n11];
        int n12 = n9;
        int n13 = 0;
        while (n13 < n11) {
            lArray[n8] = this.shape_p.stride(n12);
            ++n8;
            ++n13;
            ++n12;
        }
        long[] lArray2 = lArray;
        this.dual_values(0L, nArray2, lArray2, n, dArray);
    }

    protected abstract void dual_values(long[] var1, int var2, double[] var3) throws SolutionError;

    protected abstract void dual_values(long var1, int[] var3, long[] var4, int var5, double[] var6) throws SolutionError;

    public double[] level() throws SolutionError {
        double[] dArray = new double[(int)this.shape_p.size];
        this.level_values(0, dArray);
        return dArray;
    }

    protected double level(int n) throws SolutionError {
        if (this.shape_p.nd != 1 || n < 0 || n >= this.shape_p.dim(0)) {
            throw new SliceError("Invalid index.");
        }
        long[] lArray = new long[]{n};
        double[] dArray = new double[1];
        this.level_values(lArray, 0, dArray);
        return dArray[0];
    }

    protected double[] level(int[] nArray, int[] nArray2) throws SolutionError {
        if (this.shape_p.nd != nArray.length || this.shape_p.nd != nArray2.length) {
            throw new SliceError("Invalid slice specification");
        }
        int n = 1;
        for (int i = 0; i < this.shape_p.nd && i < this.shape_p.nd; ++i) {
            if (nArray[i] > nArray2[i] || nArray[i] < 0 || nArray2[i] > this.shape_p.dim(i)) {
                throw new SliceError("Slice index out of bound");
            }
            n *= nArray2[i] - nArray[i];
        }
        double[] dArray = new double[n];
        if (n > 0) {
            int n2;
            int[] nArray3 = new int[this.shape_p.nd];
            long[] lArray = new long[this.shape_p.nd];
            int n3 = 0;
            int n4 = this.shape_p.nd;
            for (n2 = n3; n2 < n4; ++n2) {
                lArray[n2] = this.shape_p.stride(n2);
            }
            n3 = 0;
            n4 = this.shape_p.nd;
            for (n2 = n3; n2 < n4; ++n2) {
                nArray3[n2] = nArray2[n2] - nArray[n2];
            }
            long l = 0L;
            n2 = 0;
            int n5 = this.shape_p.nd;
            for (int i = n2; i < n5; ++i) {
                l += (long)nArray[i] * lArray[i];
            }
            this.level_values(l, nArray3, lArray, 0, dArray);
        }
        return dArray;
    }

    protected double[] level(int n, int n2) throws SolutionError {
        if (this.shape_p.nd != 1 || n < 0 || n > n2 || n2 > this.shape_p.dim(0)) {
            throw new SliceError("Invalid slice specification");
        }
        int n3 = n2 - n;
        double[] dArray = new double[n3];
        int[] nArray = new int[]{n2 - n};
        long[] lArray = new long[]{1L};
        this.level_values(n, nArray, lArray, 0, dArray);
        return dArray;
    }

    protected void level_values(int n, double[] dArray) throws SolutionError {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.shape_p.nd;
        int n5 = n3 < n4 ? n4 - n3 : 0;
        long[] lArray = new long[n5];
        int n6 = n3;
        int n7 = 0;
        while (n7 < n5) {
            lArray[n2] = this.shape_p.stride(n6);
            ++n2;
            ++n7;
            ++n6;
        }
        long[] lArray2 = lArray;
        int n8 = 0;
        int n9 = 0;
        int n10 = this.shape_p.nd;
        int n11 = n9 < n10 ? n10 - n9 : 0;
        int[] nArray = new int[n11];
        int n12 = n9;
        int n13 = 0;
        while (n13 < n11) {
            nArray[n8] = this.shape_p.dim(n12);
            ++n8;
            ++n13;
            ++n12;
        }
        int[] nArray2 = nArray;
        this.level_values(0L, nArray2, lArray2, n, dArray);
    }

    protected abstract void level_values(long[] var1, int var2, double[] var3) throws SolutionError;

    protected abstract void level_values(long var1, int[] var3, long[] var4, int var5, double[] var6) throws SolutionError;

    public Model get_model() {
        return this.model;
    }

    public int get_nd() {
        return this.shape_p.nd_p;
    }

    public long size() {
        return this.shape_p.size;
    }

    public static Constraint stack(Constraint[] constraintArray) {
        return new CompoundConstraint(constraintArray);
    }

    public static Constraint stack(Constraint constraint, Constraint constraint2, Constraint constraint3) {
        Constraint[] constraintArray = new Constraint[]{constraint, constraint2};
        return new CompoundConstraint(constraintArray);
    }

    public static Constraint stack(Constraint constraint, Constraint constraint2) {
        Constraint[] constraintArray = new Constraint[]{constraint, constraint2};
        return new CompoundConstraint(constraintArray);
    }

    public Constraint index(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5] + 1;
            ++n;
            ++n6;
            ++n5;
        }
        return this.slice(nArray, nArray2).reduceDims();
    }

    public Constraint index(int n) {
        return this.slice(n, n + 1);
    }

    public abstract Constraint slice(int[] var1, int[] var2);

    public abstract Constraint slice(int var1, int var2);

    private Constraint reduceDims() {
        if (this.shape_p.nd > 1) {
            int n = this.shape_p.realnd();
            int[] nArray = new int[n];
            int n2 = 0;
            for (int i = 0; i < n && i < n; ++i) {
                if (this.shape_p.dim(i) <= 1) continue;
                nArray[n2] = this.shape_p.dim(i);
                ++n2;
            }
            this.shape_p = new NDSet(nArray);
        }
        return this;
    }

    public Set shape() {
        return this.shape_p;
    }
}

