/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.DimensionError;
import mosek.fusion.LinearDomain;
import mosek.fusion.RelationKey;
import mosek.fusion.Set;
import mosek.fusion.Utils.StringBuffer;

public class SymmetricLinearDomain {
    protected boolean sparse_flag;
    protected boolean cardinal_flag;
    protected RelationKey key;
    protected Set shape;
    protected LinearDomain dom;
    protected int dim;

    protected SymmetricLinearDomain(LinearDomain linearDomain) {
        this.dom = linearDomain;
        this.shape = linearDomain.shape;
        this.key = linearDomain.key;
        this.cardinal_flag = linearDomain.cardinal_flag;
        this.sparse_flag = linearDomain.sparse_flag;
        if (this.shape != null && (this.shape.nd != 2 || this.shape._dim(0) != linearDomain.shape._dim(1))) {
            throw new DimensionError("Only square domains can be symmetric");
        }
        this.dim = this.shape == null ? 0 : this.shape._dim(0);
    }

    public SymmetricLinearDomain sparse() {
        this.sparse_flag = true;
        return this;
    }

    public SymmetricLinearDomain integral() {
        this.cardinal_flag = true;
        return this;
    }

    public String domainToString(long l, StringBuffer stringBuffer) {
        return this.dom.domainToString(l, stringBuffer);
    }

    public boolean match_shape(Set set) {
        return this.dom.match_shape(set);
    }

    public double get_rhs_item(long l) {
        return this.dom.get_rhs_item(l);
    }
}

