/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.IntSet;
import mosek.fusion.NDSet;
import mosek.fusion.ProductSet;
import mosek.fusion.StringSet;
import mosek.fusion.Utils.StringBuffer;

public abstract class Set {
    protected long size;
    protected int nd_p;
    public int nd;

    public Set(int n, long l) {
        this.nd = n;
        this.nd_p = n;
        this.size = l;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("Set(shape=(").a(this._dim(0));
        int n = 1;
        int n2 = this.nd;
        for (int i = n; i < n2; ++i) {
            stringBuffer.a(",").a(this._dim(i));
        }
        stringBuffer.a("))");
        return stringBuffer.toString();
    }

    public abstract String indexToString(long var1);

    public abstract Set _slice(int[] var1, int[] var2);

    public abstract Set slice(int[] var1, int[] var2);

    public abstract Set _slice(int var1, int var2);

    public abstract Set slice(int var1, int var2);

    public long linearidx(int n, int n2, int n3) {
        return (n * this._dim(1) + n2) * this._dim(2) + n3;
    }

    public long linearidx(int n, int n2) {
        return n * this._dim(1) + n2;
    }

    public long linearidx(int[] nArray) {
        long l = nArray[0];
        int n = 1;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            l = l * (long)this._dim(i) + (long)nArray[i];
        }
        return l;
    }

    public int[] idxtokey(long l) {
        int[] nArray = new int[this.nd_p];
        long l2 = l;
        int n = 0;
        int n2 = this.nd_p;
        for (int i = n; i < n2; ++i) {
            nArray[i] = (int)(l2 / this.stride(i));
            l2 %= this.stride(i);
        }
        return nArray;
    }

    public abstract String getname(int[] var1);

    public abstract String getname(long var1);

    public abstract long stride(int var1);

    public abstract int _dim(int var1);

    public abstract int dim(int var1);

    public static Set make(Set[] setArray) {
        return new ProductSet(setArray);
    }

    public static Set make(Set set, Set set2) {
        return new ProductSet(new Set[]{set, set2});
    }

    public static Set make(int[] nArray) {
        return new NDSet(nArray);
    }

    public static Set make(int n, int n2, int n3) {
        return new NDSet(new int[]{n, n2, n3});
    }

    public static Set make(int n, int n2) {
        return new NDSet(new int[]{n, n2});
    }

    public static Set make(int n) {
        return new IntSet(n);
    }

    public static Set scalar() {
        return Set.make(1);
    }

    public static Set make(String[] stringArray) {
        return new StringSet(stringArray);
    }

    public int realnd() {
        if (this.nd == 1) {
            return 1;
        }
        int n = 0;
        for (int i = 0; i < this.nd && i < this.nd; ++i) {
            if (this._dim(i) == 1) continue;
            ++n;
        }
        if (n == 0) {
            ++n;
        }
        return n;
    }

    public long getSize() {
        return this.size;
    }

    public boolean compare(Set set) {
        if (this.size != set.size || this.realnd() != set.realnd()) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        while (n < this.nd && n2 < set.nd) {
            if (this._dim(n) == 1) {
                ++n;
                continue;
            }
            if (set._dim(n2) == 1) {
                ++n2;
                continue;
            }
            if (this._dim(n) != set._dim(n2)) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }
}

