/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.Set;
import mosek.fusion.SymmetricRangeDomain;
import mosek.fusion.Utils.IntMap;
import mosek.fusion.Utils.StringBuffer;

public class RangeDomain {
    protected boolean sparse_flag;
    protected boolean cardinal_flag;
    private double[] ub;
    private double[] lb;
    private IntMap idxmap;
    protected Set shape;

    protected RangeDomain(double[] dArray, double[] dArray2, int[] nArray, long[] lArray) {
        this.cardinal_flag = false;
        this.sparse_flag = false;
        this.shape = nArray == null ? null : Set.make(nArray);
        if (lArray != null) {
            this.idxmap = new IntMap();
            int n = 0;
            int n2 = dArray.length;
            for (int i = n; i < n2; ++i) {
                this.idxmap.setItem(lArray[i], i);
            }
        } else {
            this.idxmap = null;
        }
        this.ub = dArray2;
        this.lb = dArray;
    }

    protected RangeDomain(RangeDomain rangeDomain) {
        this.cardinal_flag = rangeDomain.cardinal_flag;
        this.sparse_flag = rangeDomain.sparse_flag;
        this.shape = rangeDomain.shape;
        this.idxmap = rangeDomain.idxmap;
        this.ub = rangeDomain.ub;
        this.lb = rangeDomain.lb;
    }

    public SymmetricRangeDomain symmetric() {
        return new SymmetricRangeDomain(this);
    }

    public RangeDomain sparse() {
        this.sparse_flag = true;
        return this;
    }

    public RangeDomain integral() {
        this.cardinal_flag = true;
        return this;
    }

    public String domainToString(long l, StringBuffer stringBuffer) {
        return stringBuffer.a(" in [ ").a(this.get_lb_item(l)).a(",").a(this.get_ub_item(l)).a("]").toString();
    }

    public boolean match_shape(Set set) {
        if (this.shape == null) {
            return true;
        }
        return this.shape.compare(set);
    }

    public double get_ub_item(long l) {
        if (this.idxmap != null) {
            if (this.ub == null) {
                return 0.0;
            }
            if (this.idxmap.hasItem(l)) {
                return this.ub[this.idxmap.getItem(l)];
            }
            return 0.0;
        }
        if (this.ub.length == 1) {
            return this.ub[0];
        }
        if (this.ub != null) {
            return this.ub[(int)l];
        }
        return 0.0;
    }

    public double get_lb_item(long l) {
        if (this.idxmap != null) {
            if (this.lb == null) {
                return 0.0;
            }
            if (this.idxmap.hasItem(l)) {
                return this.lb[this.idxmap.getItem(l)];
            }
            return 0.0;
        }
        if (this.lb.length == 1) {
            return this.lb[0];
        }
        if (this.lb != null) {
            return this.lb[(int)l];
        }
        return 0.0;
    }
}

