/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.DimensionError;
import mosek.fusion.IndexCounter;
import mosek.fusion.IndexError;
import mosek.fusion.LengthError;
import mosek.fusion.Model;
import mosek.fusion.ModelConstraint;
import mosek.fusion.Set;
import mosek.fusion.SolutionError;
import mosek.fusion.SolutionType;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;

public class LinearPSDConstraint
extends ModelConstraint {
    private int psdvardim;
    private boolean names_flushed;
    private int numcones;
    private int conesize;
    private int coneidx;

    protected LinearPSDConstraint(LinearPSDConstraint linearPSDConstraint, Model model) {
        super(linearPSDConstraint, model);
        this.coneidx = linearPSDConstraint.coneidx;
        this.conesize = linearPSDConstraint.conesize;
        this.psdvardim = linearPSDConstraint.psdvardim;
        this.numcones = linearPSDConstraint.numcones;
        this.names_flushed = linearPSDConstraint.names_flushed;
    }

    protected LinearPSDConstraint(Model model, String string, Set set, int[] nArray, int n, int n2, int n3, long[] lArray, int[] nArray2, double[] dArray, double[] dArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        super(model, string, set, nArray, lArray, nArray2, dArray, dArray2, nArray3, nArray4, nArray5);
        this.coneidx = n2;
        this.conesize = n;
        this.numcones = n3;
        int n4 = this.shape_p._dim(0);
        int n5 = (int)((Tools.sqrt(1 + 8 * n4) - 1.0) / 2.0);
        if (n5 * (n5 + 1) / 2 != n4) {
            throw new DimensionError("Invalid size for semidefinite constraint");
        }
        this.psdvardim = n5;
        this.names_flushed = false;
    }

    @Override
    public void domainToString(long l, StringBuffer stringBuffer) {
        int n;
        int[] nArray = this.shape_p.idxtokey(l);
        stringBuffer.a(" : element (").a(nArray[0]);
        int n2 = 1;
        int n3 = nArray.length;
        for (n = n2; n < n3; ++n) {
            stringBuffer.a(",").a(nArray[n]);
        }
        stringBuffer.a(") in a positive semi-definite cone of size (").a(this.shape_p._dim(0));
        n2 = 1;
        n3 = nArray.length;
        for (n = n2; n < n3; ++n) {
            stringBuffer.a(",").a(this.shape_p._dim(n));
        }
        stringBuffer.a(")");
    }

    @Override
    public String toString() {
        int n;
        long l = this.shape_p.size;
        String[] stringArray = new String[(int)l];
        int n2 = 0;
        int n3 = 0;
        long l2 = l;
        long l3 = (long)n3 < l2 ? l2 - (long)n3 : 0L;
        long[] lArray = new long[(int)l3];
        long l4 = n3;
        int n4 = 0;
        while ((long)n4 < l3) {
            lArray[n2] = l4++;
            ++n2;
            ++n4;
        }
        this.toStringArray(lArray, 0L, stringArray, false);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("LinearPSDConstraint( (").a(this.shape_p._dim(0));
        int n5 = 1;
        int n6 = this.shape_p.nd;
        for (n = n5; n < n6; ++n) {
            stringBuffer.a(",").a(this.shape_p._dim(n));
        }
        stringBuffer.a("),").lf();
        stringBuffer.a("  ").a(stringArray[0]);
        n5 = 1;
        n6 = stringArray.length;
        for (n = n5; n < n6; ++n) {
            stringBuffer.a(",").lf().a("  ").a(stringArray[n]);
        }
        stringBuffer.a(" )");
        return stringBuffer.toString();
    }

    @Override
    public void toStringArray(long[] lArray, long l, String[] stringArray) {
        this.toStringArray(lArray, l, stringArray, true);
    }

    public void toStringArray(long[] lArray, long l, String[] stringArray, boolean bl) {
        int n = 0;
        int n2 = lArray.length;
        for (int i = n; i < n2; ++i) {
            if (lArray[i] >= 0L && lArray[i] < this.shape_p.size) continue;
            throw new IndexError("Constraint index out of bounds");
        }
        if ((long)lArray.length + l > (long)stringArray.length) {
            throw new LengthError("Result array is too small to hold the result");
        }
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = this.cache.order_barentries();
        boolean bl2 = false;
        int n3 = 0;
        int n4 = lArray.length;
        for (int i = n3; i < n4; ++i) {
            int n5;
            int n6;
            long l3 = lArray[i];
            long l4 = l3 / (long)this.conesize;
            long l5 = l3 % (long)this.conesize;
            long l6 = l3 + (long)this.coneidx;
            stringBuffer.clear().a(this.name).a("[").a(l4).a(",").a(l5).a("] : ");
            int n7 = this.nativeindexes[(int)l3];
            for (n6 = 0; n6 < this.cache.subi.length && (long)this.cache.subi[n6] < l6; ++n6) {
            }
            int n8 = n6;
            while (n6 < this.cache.subi.length && (long)this.cache.subi[n6] == l6) {
                ++n6;
            }
            int n9 = 0;
            while ((long)n9 < l2 && (long)this.cache.barsubi[n9] < l6) {
                ++n9;
            }
            int n10 = n9;
            while ((long)n9 < l2 && (long)this.cache.barsubi[n9] == l6) {
                ++n9;
            }
            int n11 = n8;
            int n12 = n6;
            for (n5 = n11; n5 < n12; ++n5) {
                double d = this.cache.cof[n5];
                if (d > 0.0) {
                    stringBuffer.a(" + ").a(d).a(" ");
                } else if (d < 0.0) {
                    stringBuffer.a(" - ").a(-d).a(" ");
                } else {
                    stringBuffer.a(" + 0.0 ");
                }
                this.model.nativeVarToStr(this.cache.subj[n5], stringBuffer);
            }
            n11 = n9;
            n9 = n10;
            while (n9 < n11 && (long)this.cache.barsubi[n9] == l6) {
                n12 = n9;
                n5 = this.cache.barsubj[n9];
                ++n9;
                while (n9 < n11 && this.cache.barsubj[n9] == n5) {
                    ++n9;
                }
                stringBuffer.a(" + < M").a(this.cache.barmatidx[n12]);
                int n13 = n12 + 1;
                int n14 = n9;
                for (int j = n13; j < n14; ++j) {
                    stringBuffer.a(" + M").a(this.cache.barmatidx[j]);
                }
                stringBuffer.a(" ; ").a(this.model.vars[this.model.natbarvarmap_Var[this.cache.barsubj[n12]]].name.length() > 0 ? this.model.vars[this.model.natbarvarmap_Var[this.cache.barsubj[n12]]].name : "_").a(" >");
            }
            if (this.cache_bfix != null) {
                if (this.cache_bfix[(int)l6] > 0.0) {
                    stringBuffer.a(" + ").a(this.cache_bfix[(int)l6]);
                } else if (this.cache_bfix[(int)l6] < 0.0) {
                    stringBuffer.a(" + ").a(this.cache_bfix[(int)l6]);
                }
            }
            if (bl) {
                stringBuffer.a(" ");
                this.domainToString(l3, stringBuffer);
            }
            stringArray[(int)((long)i + l)] = stringBuffer.toString();
        }
    }

    @Override
    public void flushNames() {
        if (!this.names_flushed && this.name.length() > 0) {
            int n;
            int n2;
            int n3;
            int n4;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.numcones > 1) {
                n4 = 0;
                n3 = 0;
                n2 = this.numcones;
                for (n = n3; n < n2; ++n) {
                    int n5 = 0;
                    int n6 = this.conesize;
                    for (int i = n5; i < n6; ++i) {
                        this.model.task_con_name(this.nativeindexes[n4], stringBuffer.clear().a(this.name).a("[").a(n).a(",").a(i).a("]").toString());
                        ++n4;
                    }
                }
            } else {
                n4 = 0;
                n3 = 0;
                n2 = this.conesize;
                for (n = n3; n < n2; ++n) {
                    this.model.task_con_name(this.nativeindexes[n4], stringBuffer.clear().a(this.name).a("[").a(n).a("]").toString());
                    ++n4;
                }
            }
            n4 = 0;
            n3 = this.numcones;
            for (n2 = n4; n2 < n3; ++n2) {
                this.model.task_barvar_name(this.coneidx + n2, stringBuffer.clear().a(this.name).a("[").a(n2).a("].coneslack").toString());
            }
            this.names_flushed = true;
        }
    }

    @Override
    public void add_fx(long[] lArray, double[] dArray, long l, int n, int n2) {
        int n3;
        double[] dArray2 = new double[n2];
        int[] nArray = new int[n2];
        int n4 = 0;
        int n5 = n2;
        for (n3 = n4; n3 < n5; ++n3) {
            nArray[n3] = this.nativeindexes[(int)(lArray[n + n3] - l)];
        }
        n4 = 0;
        n5 = dArray2.length;
        for (n3 = n4; n3 < n5; ++n3) {
            dArray2[n3] = -dArray[(int)(lArray[n + n3] - l)];
        }
        this.model.task_con_putboundlist_fx(nArray, dArray2);
    }

    @Override
    public void dual_values(long l, int[] nArray, long[] lArray, int n, double[] dArray) throws SolutionError {
        int n2;
        IndexCounter indexCounter = new IndexCounter(l, nArray, lArray);
        int n3 = 1;
        int n4 = 0;
        int n5 = nArray.length;
        for (n2 = n4; n2 < n5; ++n2) {
            n3 *= nArray[n2];
        }
        double[][] dArray2 = this.model.getSolution_bars(SolutionType.Default);
        n5 = this.conesize;
        n2 = 0;
        int n6 = n3;
        for (int i = n2; i < n6; ++i) {
            long l2 = indexCounter.get() / (long)n5 + (long)this.coneidx;
            long l3 = indexCounter.get() % (long)n5;
            dArray[i] = dArray2[this.coneidx][(int)l3];
            indexCounter.inc();
        }
    }

    @Override
    public void dual_values(long[] lArray, int n, double[] dArray) throws SolutionError {
        double[][] dArray2 = this.model.getSolution_bars(SolutionType.Default);
        int n2 = this.conesize;
        int n3 = 0;
        int n4 = lArray.length;
        for (int i = n3; i < n4; ++i) {
            long l = lArray[i] / (long)n2 + (long)this.coneidx;
            long l2 = lArray[i] % (long)n2;
            dArray[i] = dArray2[(int)l][(int)l2];
        }
    }

    @Override
    public void level_values(long l, int[] nArray, long[] lArray, int n, double[] dArray) throws SolutionError {
        int n2;
        IndexCounter indexCounter = new IndexCounter(l, nArray, lArray);
        int n3 = 1;
        int n4 = 0;
        int n5 = nArray.length;
        for (n2 = n4; n2 < n5; ++n2) {
            n3 *= nArray[n2];
        }
        double[][] dArray2 = this.model.getSolution_barx(SolutionType.Default);
        n5 = this.conesize;
        n2 = 0;
        int n6 = n3;
        for (int i = n2; i < n6; ++i) {
            long l2 = indexCounter.get() / (long)n5 + (long)this.coneidx;
            long l3 = indexCounter.get() % (long)n5;
            dArray[i] = dArray2[this.coneidx][(int)l3];
            indexCounter.inc();
        }
    }

    @Override
    public void level_values(long[] lArray, int n, double[] dArray) throws SolutionError {
        double[][] dArray2 = this.model.getSolution_barx(SolutionType.Default);
        int n2 = this.psdvardim;
        int n3 = 0;
        int n4 = lArray.length;
        for (int i = n3; i < n4; ++i) {
            long l = lArray[i] / (long)n2 + (long)this.coneidx;
            long l2 = lArray[i] % (long)n2;
            dArray[i] = dArray2[(int)l][(int)l2];
        }
    }

    @Override
    public ModelConstraint clone(Model model) {
        return new LinearPSDConstraint(this, model);
    }
}

