/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import com.mosek.monty.Util;
import mosek.fusion.BaseSet;
import mosek.fusion.IndexError;
import mosek.fusion.Set;
import mosek.fusion.SliceError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;

public class IntSet
extends BaseSet {
    private int last;
    private int first;

    public IntSet(int n) {
        super(n);
        this.first = 0;
        this.last = n;
    }

    public IntSet(int n, int n2) {
        super(n2 - n);
        this.first = n;
        this.last = n2;
    }

    @Override
    public String indexToString(long l) {
        return new StringBuffer().a((int)l).toString();
    }

    @Override
    public String getname(int[] nArray) {
        if (nArray.length != 1) {
            throw new IndexError("Invalid key specification");
        }
        return Tools.stringvalue(nArray[0]);
    }

    @Override
    public String getname(long l) {
        return Tools.stringvalue(l);
    }

    @Override
    public Set _slice(int[] nArray, int[] nArray2) {
        if (nArray.length != 1 || nArray2.length != 1) {
            throw new SliceError("Invalid slice specification");
        }
        return this._slice(nArray[0], nArray2[0]);
    }

    @Override
    public Set slice(int[] nArray, int[] nArray2) {
        int[] nArray3 = Util.fromMatlab(nArray);
        int[] nArray4 = Util.fromMatlab(nArray2);
        Set set = this._slice(nArray3, nArray4);
        Util.toMatlab(nArray, nArray3);
        Util.toMatlab(nArray2, nArray4);
        return set;
    }

    @Override
    public Set _slice(int n, int n2) {
        if (n < 0 || n > n2 || n2 > this.last - this.first) {
            throw new SliceError("Invalid slice specification");
        }
        return new IntSet(this.first + n, this.first + n2);
    }

    @Override
    public Set slice(int n, int n2) {
        int n3 = Util.fromMatlab(n);
        int n4 = Util.fromMatlab(n2);
        Set set = this._slice(n3, n4);
        return set;
    }

    public int getidx(int n) {
        if (n < this.first || n > this.last) {
            throw new IndexError("Index out of bounds");
        }
        return n - this.first;
    }

    @Override
    public long stride(int n) {
        return 1L;
    }
}

