/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.CommonTools;
import mosek.fusion.LengthError;
import mosek.fusion.Sort;
import mosek.fusion.Utils.Tools;

public class ConstraintCache {
    public int[] barmatidx;
    public int[] barsubj;
    public int[] barsubi;
    public long nbarnz;
    public long nunordered;
    public int[] buffer_subi;
    public int[] buffer_subj;
    public double[] buffer_cof;
    public double[] bfix;
    public double[] cof;
    public int[] subi;
    public int[] subj;
    public long nnz;
    public int nrows;

    private ConstraintCache(ConstraintCache constraintCache) {
        this.nrows = constraintCache.nrows;
        this.nnz = constraintCache.nnz;
        this.subj = constraintCache.subj != null ? Tools.arraycopy(constraintCache.subj) : null;
        this.subi = constraintCache.subi != null ? Tools.arraycopy(constraintCache.subi) : null;
        this.cof = constraintCache.cof != null ? Tools.arraycopy(constraintCache.cof) : null;
        this.bfix = constraintCache.bfix != null ? Tools.arraycopy(constraintCache.bfix) : null;
        this.buffer_cof = constraintCache.buffer_cof != null ? Tools.arraycopy(constraintCache.buffer_cof) : null;
        this.buffer_subj = constraintCache.buffer_subj != null ? Tools.arraycopy(constraintCache.buffer_subj) : null;
        this.buffer_subi = constraintCache.buffer_subi != null ? Tools.arraycopy(constraintCache.buffer_subi) : null;
        this.nunordered = constraintCache.nunordered;
        this.nbarnz = constraintCache.nbarnz;
        this.barsubi = constraintCache.barsubi != null ? Tools.arraycopy(constraintCache.barsubi) : null;
        this.barsubj = constraintCache.barsubj != null ? Tools.arraycopy(constraintCache.barsubj) : null;
        this.barmatidx = constraintCache.barmatidx != null ? Tools.arraycopy(constraintCache.barmatidx) : null;
    }

    public ConstraintCache(long[] lArray, double[] dArray, int[] nArray, double[] dArray2, int[] nArray2, int[] nArray3, int[] nArray4) {
        this.nrows = lArray.length - 1;
        this.nnz = lArray[lArray.length - 1];
        this.subj = new int[(int)this.nnz];
        this.subi = new int[(int)this.nnz];
        this.cof = new double[(int)this.nnz];
        this.bfix = dArray2 != null ? dArray2 : new double[this.nrows];
        if (nArray2 != null && nArray3 != null && nArray4 != null) {
            this.nbarnz = nArray2.length;
            if (this.nbarnz > (long)nArray3.length) {
                this.nbarnz = nArray3.length;
            }
            if (this.nbarnz > (long)nArray4.length) {
                this.nbarnz = nArray4.length;
            }
            this.barsubi = new int[(int)this.nbarnz];
            this.barsubj = new int[(int)this.nbarnz];
            this.barmatidx = new int[(int)this.nbarnz];
            Tools.arraycopy(nArray2, 0L, this.barsubi, 0L, this.nbarnz);
            Tools.arraycopy(nArray3, 0L, this.barsubj, 0L, this.nbarnz);
            Tools.arraycopy(nArray4, 0L, this.barmatidx, 0L, this.nbarnz);
        } else {
            this.nbarnz = 0L;
            this.barsubi = null;
            this.barsubj = null;
            this.barmatidx = null;
        }
        Tools.arraycopy(nArray, 0L, this.subj, 0L, this.nnz);
        Tools.arraycopy(dArray, 0L, this.cof, 0L, this.nnz);
        int n = 0;
        int n2 = this.nrows;
        for (int i = n; i < n2; ++i) {
            long l = lArray[i];
            long l2 = lArray[i + 1];
            for (long j = l; j < l2; ++j) {
                this.subi[(int)j] = i;
            }
        }
        this.buffer_cof = null;
        this.buffer_subj = null;
        this.buffer_subi = null;
        this.nunordered = 0L;
    }

    public void unchecked_add_fx(double[] dArray) {
        int n = 0;
        int n2 = this.nrows;
        for (int i = n; i < n2; ++i) {
            this.bfix[i] = this.bfix[i] + dArray[i];
        }
    }

    public long order_barentries() {
        int n = 0;
        long l = 0L;
        long l2 = this.nbarnz;
        long l3 = l < l2 ? l2 - l : 0L;
        long[] lArray = new long[(int)l3];
        long l4 = l;
        int n2 = 0;
        while ((long)n2 < l3) {
            lArray[n] = l4++;
            ++n;
            ++n2;
        }
        long[] lArray2 = lArray;
        if (!Sort.issorted(lArray2, this.barsubi, this.barsubj, 0L, this.nbarnz, false)) {
            Sort.argsort(lArray2, this.barsubi, this.barsubj, 0L, this.nbarnz, false);
            int[] nArray = this.barsubi;
            int[] nArray2 = this.barsubj;
            int[] nArray3 = this.barmatidx;
            int n3 = 0;
            int n4 = 0;
            long l5 = this.nbarnz;
            long l6 = (long)n4 < l5 ? l5 - (long)n4 : 0L;
            int[] nArray4 = new int[(int)l6];
            long l7 = n4;
            int n5 = 0;
            while ((long)n5 < l6) {
                nArray4[n3] = nArray[(int)lArray2[(int)l7]];
                ++n3;
                ++n5;
                ++l7;
            }
            this.barsubi = nArray4;
            n5 = 0;
            int n6 = 0;
            long l8 = this.nbarnz;
            long l9 = (long)n6 < l8 ? l8 - (long)n6 : 0L;
            int[] nArray5 = new int[(int)l9];
            long l10 = n6;
            int n7 = 0;
            while ((long)n7 < l9) {
                nArray5[n5] = nArray2[(int)lArray2[(int)l10]];
                ++n5;
                ++n7;
                ++l10;
            }
            this.barsubj = nArray5;
            n7 = 0;
            int n8 = 0;
            long l11 = this.nbarnz;
            long l12 = (long)n8 < l11 ? l11 - (long)n8 : 0L;
            int[] nArray6 = new int[(int)l12];
            long l13 = n8;
            int n9 = 0;
            while ((long)n9 < l12) {
                nArray6[n7] = nArray3[(int)lArray2[(int)l13]];
                ++n7;
                ++n9;
                ++l13;
            }
            this.barmatidx = nArray6;
        }
        return this.nbarnz;
    }

    public void add_bar(int[] nArray, int[] nArray2, int[] nArray3) {
        if (nArray != null) {
            int n = nArray.length;
            if ((long)nArray.length <= this.nbarnz + (long)n) {
                int[] nArray4 = this.barsubi;
                int[] nArray5 = this.barsubj;
                int[] nArray6 = this.barmatidx;
                long l = 2L * this.nbarnz > this.nbarnz + (long)n ? 2L * this.nbarnz : this.nbarnz + (long)(n * 2);
                this.barsubi = new int[(int)l];
                this.barsubj = new int[(int)l];
                this.barmatidx = new int[(int)l];
                if (this.nbarnz > 0L) {
                    Tools.arraycopy(nArray4, 0L, this.barsubi, 0L, this.nbarnz);
                    Tools.arraycopy(nArray5, 0L, this.barsubj, 0L, this.nbarnz);
                    Tools.arraycopy(nArray6, 0L, this.barmatidx, 0L, this.nbarnz);
                }
            }
            Tools.arraycopy(nArray, 0L, this.barsubi, this.nbarnz, (long)n);
            Tools.arraycopy(nArray2, 0L, this.barsubj, this.nbarnz, (long)n);
            Tools.arraycopy(nArray3, 0L, this.barmatidx, this.nbarnz, (long)n);
            this.nbarnz += (long)n;
        }
    }

    public void unchecked_add_l(long[] lArray, int[] nArray, double[] dArray, double[] dArray2) {
        int n;
        double[] dArray3;
        int[] nArray2;
        int[] nArray3;
        long l = this.nunordered + lArray[this.nrows];
        long l2 = lArray[this.nrows];
        if (this.buffer_cof == null || (long)this.buffer_cof.length < l) {
            nArray3 = new int[(int)l];
            nArray2 = new int[(int)l];
            dArray3 = new double[(int)l];
            if (this.buffer_cof != null) {
                Tools.arraycopy(this.buffer_subi, 0L, nArray3, 0L, this.nunordered);
                Tools.arraycopy(this.buffer_subj, 0L, nArray2, 0L, this.nunordered);
                Tools.arraycopy(this.buffer_cof, 0L, dArray3, 0L, this.nunordered);
            }
        } else {
            nArray3 = this.buffer_subi;
            nArray2 = this.buffer_subj;
            dArray3 = this.buffer_cof;
        }
        int n2 = 0;
        int n3 = this.nrows;
        for (n = n2; n < n3; ++n) {
            long l3 = lArray[n];
            long l4 = lArray[n + 1];
            for (long i = l3; i < l4; ++i) {
                nArray3[(int)(this.nunordered + i)] = n;
            }
        }
        Tools.arraycopy(nArray, 0L, nArray2, this.nunordered, l2);
        Tools.arraycopy(dArray, 0L, dArray3, this.nunordered, l2);
        this.buffer_subi = nArray3;
        this.buffer_subj = nArray2;
        this.buffer_cof = dArray3;
        if (dArray2 != null) {
            n2 = 0;
            n3 = this.nrows;
            for (n = n2; n < n3; ++n) {
                this.bfix[n] = this.bfix[n] + dArray2[n];
            }
        }
        this.nunordered = l;
        this.nnz += l2;
    }

    public void add(long[] lArray, int[] nArray, double[] dArray, double[] dArray2) {
        if (lArray.length != this.nrows + 1 || dArray2 != null && dArray2.length != this.nrows) {
            throw new LengthError("Mismatching expression lengths");
        }
        this.unchecked_add_l(lArray, nArray, dArray, dArray2);
    }

    public long flush(int[] nArray, int[] nArray2, double[] dArray, double[] dArray2) {
        long l;
        int n;
        int n2;
        int n3;
        long[] lArray = null;
        if (this.bfix != null && dArray2 != null) {
            n3 = 0;
            n2 = this.nrows;
            for (n = n3; n < n2; ++n) {
                dArray2[n] = this.bfix[n];
            }
        }
        if (this.nunordered == 0L) {
            return 0L;
        }
        n3 = 0;
        n2 = 1;
        while ((long)n2 < this.nunordered && (this.buffer_subi[n2 - 1] < this.buffer_subi[n2] || this.buffer_subi[n2 - 1] == this.buffer_subi[n2] && this.buffer_subj[n2 - 1] <= this.buffer_subj[n2])) {
            ++n2;
        }
        int n4 = n3 = (long)n2 == this.nunordered ? 1 : 0;
        if (n3 == 0) {
            n2 = 0;
            n = 0;
            long l2 = this.nunordered;
            l = (long)n < l2 ? l2 - (long)n : 0L;
            long[] lArray2 = new long[(int)l];
            long l3 = n;
            int n5 = 0;
            while ((long)n5 < l) {
                lArray2[n2] = l3++;
                ++n2;
                ++n5;
            }
            lArray = lArray2;
            CommonTools.argQsort(lArray, this.buffer_subi, this.buffer_subj, 0L, this.nunordered);
        }
        n2 = this.subi.length;
        int[] nArray3 = new int[(int)(this.nunordered + (long)n2)];
        int[] nArray4 = new int[(int)(this.nunordered + (long)n2)];
        double[] dArray3 = new double[(int)(this.nunordered + (long)n2)];
        l = 0L;
        if (n3 != 0) {
            int n6 = 0;
            int n7 = 0;
            int n8 = n2;
            long l4 = this.nunordered;
            int n9 = 0;
            long l5 = 0L;
            while (n6 < n8 && (long)n7 < l4) {
                if (this.subi[n6] < this.buffer_subi[n7] || this.subi[n6] == this.buffer_subi[n7] && this.subj[n6] < this.buffer_subj[n7]) {
                    nArray3[n9] = this.subi[n6];
                    nArray4[n9] = this.subj[n6];
                    dArray3[n9] = this.cof[n6];
                    ++n6;
                    ++n9;
                    continue;
                }
                if (this.subi[n6] > this.buffer_subi[n7] || this.subi[n6] == this.buffer_subi[n7] && this.subj[n6] > this.buffer_subj[n7]) {
                    nArray3[n9] = this.buffer_subi[n7];
                    nArray4[n9] = this.buffer_subj[n7];
                    dArray3[n9] = this.buffer_cof[n7];
                    nArray[(int)l] = nArray3[n9];
                    nArray2[(int)l] = nArray4[n9];
                    dArray[(int)l] = dArray3[n9];
                    ++l;
                    ++n7;
                    ++n9;
                    continue;
                }
                nArray3[n9] = this.subi[n6];
                nArray4[n9] = this.subj[n6];
                dArray3[n9] = this.cof[n6];
                while (n6 < this.subi.length && n7 < this.buffer_subi.length && this.subi[n6] == this.buffer_subi[n7] && this.subj[n6] == this.buffer_subj[n7]) {
                    dArray3[n9] = dArray3[n9] + this.buffer_cof[n7];
                    ++n7;
                }
                nArray[(int)l] = nArray3[n9];
                nArray2[(int)l] = nArray4[n9];
                dArray[(int)l] = dArray3[n9];
                ++l;
                ++n6;
                ++n9;
            }
            while (n6 < n8) {
                nArray3[n9] = this.subi[n6];
                nArray4[n9] = this.subj[n6];
                dArray3[n9] = this.cof[n6];
                ++n6;
                ++n9;
            }
            while ((long)n7 < l4) {
                nArray3[n9] = this.buffer_subi[n7];
                nArray4[n9] = this.buffer_subj[n7];
                dArray3[n9] = this.buffer_cof[n7];
                nArray[(int)l] = nArray3[n9];
                nArray2[(int)l] = nArray4[n9];
                dArray[(int)l] = dArray3[n9];
                ++l;
                ++n7;
                ++n9;
            }
        } else {
            int n10 = 0;
            int n11 = 0;
            int n12 = n2;
            long l6 = this.nunordered;
            int n13 = 0;
            long l7 = 0L;
            while (n10 < n12 && (long)n11 < l6) {
                if (this.subi[n10] < this.buffer_subi[(int)lArray[n11]] || this.subi[n10] == this.buffer_subi[(int)lArray[n11]] && this.subj[n10] < this.buffer_subj[(int)lArray[n11]]) {
                    nArray3[n13] = this.subi[n10];
                    nArray4[n13] = this.subj[n10];
                    dArray3[n13] = this.cof[n10];
                    ++n10;
                    ++n13;
                    continue;
                }
                if (this.subi[n10] > this.buffer_subi[(int)lArray[n11]] || this.subi[n10] == this.buffer_subi[(int)lArray[n11]] && this.subj[n10] > this.buffer_subj[(int)lArray[n11]]) {
                    nArray3[n13] = this.buffer_subi[(int)lArray[n11]];
                    nArray4[n13] = this.buffer_subj[(int)lArray[n11]];
                    dArray3[n13] = this.buffer_cof[(int)lArray[n11]];
                    nArray[(int)l] = nArray3[n13];
                    nArray2[(int)l] = nArray4[n13];
                    dArray[(int)l] = dArray3[n13];
                    ++l;
                    ++n11;
                    ++n13;
                    continue;
                }
                nArray3[n13] = this.subi[n10];
                nArray4[n13] = this.subj[n10];
                dArray3[n13] = this.cof[n10];
                while (this.subi[n10] == this.buffer_subi[(int)lArray[n11]] && this.subj[n10] == this.buffer_subj[(int)lArray[n11]]) {
                    dArray3[n13] = dArray3[n13] + this.buffer_cof[(int)lArray[n11]];
                    ++n11;
                }
                nArray[(int)l] = nArray3[n13];
                nArray2[(int)l] = nArray4[n13];
                dArray[(int)l] = dArray3[n13];
                ++l;
                ++n10;
                ++n13;
            }
        }
        this.subi = nArray3;
        this.subj = nArray4;
        this.cof = dArray3;
        this.nunordered = 0L;
        return l;
    }

    public long numUnsorted() {
        return this.nunordered;
    }

    public ConstraintCache clone() {
        return new ConstraintCache(this);
    }
}

