/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.IndexCounter;
import mosek.fusion.Model;
import mosek.fusion.ModelConstraint;
import mosek.fusion.QConeDomain;
import mosek.fusion.QConeKey;
import mosek.fusion.Set;
import mosek.fusion.SliceError;
import mosek.fusion.SolutionError;
import mosek.fusion.SolutionType;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;

public class ConicConstraint
extends ModelConstraint {
    private boolean names_flushed;
    private QConeDomain dom;
    private int conesize;
    private int last;
    private int first;
    private int last_slack;
    private int first_slack;
    private int coneidx;

    protected ConicConstraint(ConicConstraint conicConstraint, Model model) {
        super(conicConstraint, model);
        this.first_slack = conicConstraint.first_slack;
        this.last_slack = conicConstraint.last_slack;
        this.first = conicConstraint.first;
        this.last = conicConstraint.last;
        this.dom = conicConstraint.dom;
        this.conesize = conicConstraint.conesize;
        this.coneidx = conicConstraint.coneidx;
        this.names_flushed = conicConstraint.names_flushed;
    }

    protected ConicConstraint(Model model, String string, QConeDomain qConeDomain, Set set, int[] nArray, int n, int n2, int n3, int n4, int n5, long[] lArray, int[] nArray2, double[] dArray, double[] dArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        super(model, string, set, nArray, lArray, nArray2, dArray, dArray2, nArray3, nArray4, nArray5);
        this.first_slack = n;
        this.last_slack = n2;
        this.first = n4;
        this.last = n4 + n5;
        this.dom = qConeDomain;
        this.conesize = n3;
        this.coneidx = n4;
        this.names_flushed = false;
    }

    @Override
    public void flushNames() {
        super.flushNames();
        if (!this.names_flushed && this.name.length() > 0) {
            int n;
            int n2 = this.first_slack;
            int n3 = this.last_slack;
            for (n = n2; n < n3; ++n) {
                this.model.task_var_name(n, this.name.length() == 0 ? "" : new StringBuffer().a(this.name).a("[").a(this.shape_p.getname(n - this.first_slack)).a("].coneslack").toString());
            }
            n2 = this.first;
            n3 = this.last;
            for (n = n2; n < n3; ++n) {
                this.model.task_cone_name(n, this.name.length() == 0 ? "" : new StringBuffer().a(this.name).a("[").a(n - this.first).a("]").toString());
            }
            this.names_flushed = true;
        }
    }

    @Override
    public String toString() {
        int n;
        long l = this.shape_p.size;
        String[] stringArray = new String[(int)l];
        this.toStringArray(Tools.range(l), 0L, stringArray);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("ConicConstraint( (").a(this.shape_p._dim(0));
        int n2 = 1;
        int n3 = this.shape_p.nd;
        for (n = n2; n < n3; ++n) {
            stringBuffer.a(",").a(this.shape_p._dim(n));
        }
        stringBuffer.a("),");
        if (this.dom.key == QConeKey.InQCone) {
            stringBuffer.a(" QuadCone,").lf();
        } else {
            stringBuffer.a(" RotatedQuadCone,").lf();
        }
        stringBuffer.a("  ").a(stringArray[0]);
        n2 = 1;
        n3 = stringArray.length;
        for (n = n2; n < n3; ++n) {
            stringBuffer.a(",").lf().a("  ").a(stringArray[n]);
        }
        stringBuffer.a(" )");
        return stringBuffer.toString();
    }

    @Override
    public void dual_values(long l, int[] nArray, long[] lArray, int n, double[] dArray) throws SolutionError {
        long l2 = 1L;
        int n2 = lArray.length;
        IndexCounter indexCounter = new IndexCounter(l, nArray, lArray);
        double[] dArray2 = this.model.getSolution_snx(SolutionType.Default);
        int n3 = 0;
        int n4 = n2;
        for (int i = n3; i < n4; ++i) {
            l2 *= (long)nArray[i];
        }
        long l3 = 0L;
        long l4 = l2;
        for (long i = l3; i < l4; ++i) {
            dArray[(int)(i + (long)n)] = dArray2[(int)((long)this.first_slack + indexCounter.get())];
            indexCounter.inc();
        }
    }

    @Override
    public void dual_values(long[] lArray, int n, double[] dArray) throws SolutionError {
        double[] dArray2 = this.model.getSolution_snx(SolutionType.Default);
        int n2 = 0;
        int n3 = lArray.length;
        for (int i = n2; i < n3; ++i) {
            dArray[n + i] = dArray2[(int)((long)this.first_slack + lArray[i])];
        }
    }

    @Override
    public void level_values(long l, int[] nArray, long[] lArray, int n, double[] dArray) throws SolutionError {
        long l2 = 1L;
        int n2 = lArray.length;
        IndexCounter indexCounter = new IndexCounter(l, nArray, lArray);
        double[] dArray2 = this.model.getSolution_xx(SolutionType.Default);
        double[] dArray3 = this.model.getSolution_xc(SolutionType.Default);
        int n3 = 0;
        int n4 = n2;
        for (int i = n3; i < n4; ++i) {
            l2 *= (long)nArray[i];
        }
        long l3 = 0L;
        long l4 = l2;
        for (long i = l3; i < l4; ++i) {
            dArray[(int)(i + (long)n)] = dArray2[(int)((long)this.first_slack + indexCounter.get())] + dArray3[this.nativeindexes[(int)indexCounter.get()]];
            indexCounter.inc();
        }
    }

    @Override
    public void level_values(long[] lArray, int n, double[] dArray) throws SolutionError {
        double[] dArray2 = this.model.getSolution_xx(SolutionType.Default);
        double[] dArray3 = this.model.getSolution_xc(SolutionType.Default);
        int n2 = 0;
        int n3 = lArray.length;
        for (int i = n2; i < n3; ++i) {
            dArray[n + i] = dArray3[this.nativeindexes[(int)lArray[i]]] + dArray2[(int)((long)this.first_slack + lArray[i])];
        }
    }

    @Override
    public void add_fx(long[] lArray, double[] dArray, long l, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n2;
        int n6 = n4 < n5 ? n5 - n4 : 0;
        double[] dArray2 = new double[n6];
        int n7 = n4;
        int n8 = 0;
        while (n8 < n6) {
            dArray2[n3] = -dArray[(int)(lArray[n + n7] - l)];
            ++n3;
            ++n8;
            ++n7;
        }
        double[] dArray3 = dArray2;
        int n9 = 0;
        int n10 = 0;
        int n11 = n2;
        int n12 = n10 < n11 ? n11 - n10 : 0;
        int[] nArray = new int[n12];
        int n13 = n10;
        int n14 = 0;
        while (n14 < n12) {
            nArray[n9] = this.nativeindexes[(int)(lArray[n + n13] - l)];
            ++n9;
            ++n14;
            ++n13;
        }
        int[] nArray2 = nArray;
        this.model.task_con_putboundlist_fx(nArray2, dArray3);
    }

    public void dual(int[] nArray, int n, int n2, int n3, double[] dArray) throws SolutionError {
        if (n2 - n > dArray.length - n3) {
            throw new SliceError("Wrong target array length");
        }
        if (n2 < n || n2 >= nArray.length) {
            throw new SliceError("Slice indexes out of bounds");
        }
        double[] dArray2 = this.model.getSolution_snx(SolutionType.Default);
        for (int i = 0; i < n2 - n && i < n2 - n; ++i) {
            dArray[i + n3] = dArray2[this.first_slack + nArray[n + i]];
        }
    }

    public void dual_values(int[] nArray, int[] nArray2, int n, double[] dArray) throws SolutionError {
        if (nArray.length != 1 || nArray2.length != 1) {
            throw new SliceError("Invalid slice dimensions");
        }
        int n2 = nArray2[0];
        int n3 = nArray[0];
        if (n2 - n3 > dArray.length - n) {
            throw new SliceError("Wrong target array length");
        }
        if (n2 < n3 || n2 > this.last_slack - this.first_slack) {
            throw new SliceError("Slice indexes out of bounds");
        }
        double[] dArray2 = this.model.getSolution_snx(SolutionType.Default);
        for (int i = 0; i < n2 - n3 && i < n2 - n3; ++i) {
            dArray[i + n] = dArray2[n3 + i + this.first_slack];
        }
    }

    @Override
    public void domainToString(long l, StringBuffer stringBuffer) {
        this.dom.domainToString(l, stringBuffer);
    }

    @Override
    public ModelConstraint clone(Model model) {
        return new ConicConstraint(this, model);
    }
}

