/*
 * Decompiled with CFR 0.152.
 */
package mosek;

import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import mosek.ArrayLengthException;
import mosek.DataCallback;
import mosek.Env;
import mosek.Error;
import mosek.Exception;
import mosek.ItgSolutionCallback;
import mosek.Progress;
import mosek.SCoptException;
import mosek.Stream;
import mosek.accmode;
import mosek.boundkey;
import mosek.compresstype;
import mosek.conetype;
import mosek.dataformat;
import mosek.dinfitem;
import mosek.dparam;
import mosek.iinfitem;
import mosek.inftype;
import mosek.iparam;
import mosek.liinfitem;
import mosek.mark;
import mosek.nametype;
import mosek.objsense;
import mosek.parametertype;
import mosek.problemtype;
import mosek.prosta;
import mosek.rescode;
import mosek.scopr;
import mosek.solitem;
import mosek.solsta;
import mosek.soltype;
import mosek.sparam;
import mosek.stakey;
import mosek.streamtype;
import mosek.symmattype;
import mosek.variabletype;

public final class Task
implements Closeable {
    long native_task;
    private long schandle;
    private int cbsattached;
    private Progress progress;
    private DataCallback datacallback;
    private ItgSolutionCallback itgsolcallback;
    private Stream[] stream;

    private native void attachStream(long var1, int var3);

    private native void detachStream(long var1, int var3);

    private native void attachProgress(long var1);

    private native void detachProgress(long var1);

    private void stream_func(int n, String string) {
        if (n < this.stream.length && this.stream[n] != null) {
            this.stream[n].print(string);
        }
    }

    public synchronized void set_Progress(Progress progress) {
        if (this.progress != null) {
            this.progress = progress;
            if (this.progress == null) {
                --this.cbsattached;
            }
            if (this.cbsattached == 0) {
                this.detachProgress(this.native_task);
            }
        } else {
            this.progress = progress;
            if (this.progress != null) {
                ++this.cbsattached;
            }
            if (this.cbsattached == 1) {
                this.attachProgress(this.native_task);
            }
        }
    }

    @Deprecated
    public synchronized void set_Progress(DataCallback dataCallback) {
        this.set_InfoCallback(dataCallback);
    }

    public synchronized void set_InfoCallback(DataCallback dataCallback) {
        if (this.datacallback != null) {
            this.datacallback = dataCallback;
            if (this.datacallback == null) {
                --this.cbsattached;
            }
            if (this.cbsattached == 0) {
                this.detachProgress(this.native_task);
            }
        } else {
            this.datacallback = dataCallback;
            if (this.datacallback != null) {
                ++this.cbsattached;
            }
            if (this.cbsattached == 1) {
                this.attachProgress(this.native_task);
            }
        }
    }

    public synchronized void set_ItgSolutionCallback(ItgSolutionCallback itgSolutionCallback) {
        if (this.itgsolcallback != null) {
            this.itgsolcallback = itgSolutionCallback;
            if (this.itgsolcallback == null) {
                --this.cbsattached;
            }
            if (this.cbsattached == 0) {
                this.detachProgress(this.native_task);
            }
        } else {
            this.itgsolcallback = itgSolutionCallback;
            if (this.itgsolcallback != null) {
                ++this.cbsattached;
            }
            if (this.cbsattached == 1) {
                this.attachProgress(this.native_task);
            }
        }
    }

    public synchronized void unset_Progress() {
        if (this.progress != null || this.datacallback != null) {
            if (this.progress != null) {
                this.progress = null;
                --this.cbsattached;
            }
            if (this.datacallback != null) {
                this.datacallback = null;
                --this.cbsattached;
            }
            if (this.cbsattached == 0) {
                this.detachProgress(this.native_task);
            }
        }
    }

    public synchronized void set_Stream(streamtype streamtype2, Stream stream) {
        int n = streamtype2.getValue();
        this.detachStream(this.native_task, n);
        if (this.stream[n] != null) {
            this.stream[n] = null;
        }
        if (stream != null) {
            this.stream[n] = stream;
            this.attachStream(this.native_task, n);
        }
    }

    private native long p_createTask(Env var1, int var2, int var3);

    private native void p_deleteTask(long var1);

    private native long p_cloneTask(long var1);

    public Task(Env env, int n, int n2) {
        this.native_task = this.p_createTask(env, n, n2);
        this.stream = new Stream[4];
        this.progress = null;
    }

    public Task(Env env) {
        this.native_task = this.p_createTask(env, 0, 0);
        this.stream = new Stream[4];
        this.progress = null;
    }

    private Task(long l) {
        this.native_task = l;
        this.stream = new Stream[4];
        this.progress = null;
    }

    public Task(Task task) {
        this.native_task = this.p_cloneTask(task.native_task);
        this.stream = new Stream[4];
        this.progress = null;
    }

    protected synchronized void finalize() {
        if (this.native_task != 0L) {
            this.cleanup();
            this.p_deleteTask(this.native_task);
            this.native_task = 0L;
        }
    }

    public synchronized void cleanup() {
        try {
            this.unset_Progress();
            for (streamtype streamtype2 : streamtype.values()) {
                this.set_Stream(streamtype2, null);
            }
            this.clearSCeval();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        this.finalize();
    }

    private native void p_putvarnamelist(long var1, int var3, IntBuffer var4, LongBuffer var5, ByteBuffer var6);

    public synchronized void putvarnamelist(int[] nArray, String[] stringArray) {
        int n = nArray.length < stringArray.length ? nArray.length : stringArray.length;
        byte[][] byArrayArray = new byte[n][];
        int n2 = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.put(nArray);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect((n + 1) * 8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer2.asLongBuffer();
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null) continue;
            try {
                byArrayArray[i] = stringArray[i].getBytes("UTF-8");
                n2 += byArrayArray[i].length;
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        longBuffer.put(0, 0L);
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(n2 += n);
        for (int i = 0; i < n; ++i) {
            if (byArrayArray[i] != null) {
                byteBuffer3.put(byArrayArray[i]);
            }
            byteBuffer3.put((byte)0);
            longBuffer.put(i + 1, byteBuffer3.position());
        }
        this.p_putvarnamelist(this.native_task, n, intBuffer, longBuffer, byteBuffer3);
    }

    public synchronized void writeSC(String string, String string2) throws Error {
        if (this.schandle != 0L && !this.__writeSC(this.native_task, this.schandle, string, string2)) {
            throw new SCoptException("Failed to write file(s)");
        }
    }

    public synchronized void clearSCeval() throws Error {
        if (this.schandle != 0L) {
            this.__clearSCeval(this.native_task, this.schandle);
        }
        this.schandle = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putSCeval(scopr[] scoprArray, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3, scopr[] scoprArray2, int[] nArray2, int[] nArray3, double[] dArray4, double[] dArray5, double[] dArray6) throws ArrayLengthException, Error {
        Task task = this;
        synchronized (task) {
            int n;
            int n2 = this.getnumvar();
            int n3 = this.getnumcon();
            int[] nArray4 = null;
            int[] nArray5 = null;
            if (!(scoprArray != null && nArray != null && dArray != null && dArray2 != null && dArray3 != null || scoprArray == null && nArray == null && dArray == null && dArray2 == null && dArray3 == null)) {
                throw new ArrayLengthException("putSCeval", "opro");
            }
            if (scoprArray != null) {
                if (scoprArray.length != nArray.length || scoprArray.length != dArray.length || scoprArray.length != dArray2.length || scoprArray.length != dArray3.length) {
                    throw new ArrayLengthException("putSCeval", "opro");
                }
                nArray4 = new int[scoprArray.length];
                for (n = 0; n < scoprArray.length; ++n) {
                    if (nArray[n] < 0 || nArray[n] >= n2) {
                        throw new SCoptException("Invalid variable index oprjo entry");
                    }
                    nArray4[n] = scoprArray[n].getValue();
                }
            }
            if (!(scoprArray2 != null && nArray2 != null && nArray3 != null && dArray4 != null && dArray5 != null && dArray6 != null || scoprArray2 == null && nArray2 == null && nArray3 == null && dArray4 == null && dArray5 == null && dArray6 == null)) {
                throw new ArrayLengthException("putSCeval", "oprc");
            }
            if (scoprArray2 != null) {
                if (scoprArray2.length != nArray2.length || scoprArray2.length != nArray3.length || scoprArray2.length != dArray4.length || scoprArray2.length != dArray5.length || scoprArray2.length != dArray6.length) {
                    throw new ArrayLengthException("putSCeval", "oprc");
                }
                nArray5 = new int[scoprArray2.length];
                for (n = 0; n < scoprArray2.length; ++n) {
                    if (nArray2[n] < 0 || nArray2[n] >= n3) {
                        throw new SCoptException("Invalid constraint index opric entry");
                    }
                    if (nArray3[n] < 0 || nArray3[n] >= n2) {
                        throw new SCoptException("Invalid variable index oprjc entry");
                    }
                    nArray5[n] = scoprArray2[n].getValue();
                }
            }
            if (this.schandle != 0L) {
                this.__clearSCeval(this.native_task, this.schandle);
            }
            this.schandle = this.__putSCeval(this.native_task, nArray4, nArray, dArray, dArray2, dArray3, nArray5, nArray2, nArray3, dArray4, dArray5, dArray6);
        }
    }

    private native void __clearSCeval(long var1, long var3) throws Error;

    private native long __putSCeval(long var1, int[] var3, int[] var4, double[] var5, double[] var6, double[] var7, int[] var8, int[] var9, int[] var10, double[] var11, double[] var12, double[] var13) throws Error;

    private native boolean __writeSC(long var1, long var3, String var5, String var6) throws Error;

    public synchronized void analyzenames(streamtype streamtype2, nametype nametype2) throws Error {
        this.p_analyzenames(this.native_task, streamtype2.getValue(), nametype2.getValue());
    }

    private native void p_analyzenames(long var1, int var3, int var4) throws Error;

    public synchronized void analyzeproblem(streamtype streamtype2) throws Error {
        this.p_analyzeproblem(this.native_task, streamtype2.getValue());
    }

    private native void p_analyzeproblem(long var1, int var3) throws Error;

    public synchronized void analyzesolution(streamtype streamtype2, soltype soltype2) throws Error {
        this.p_analyzesolution(this.native_task, streamtype2.getValue(), soltype2.getValue());
    }

    private native void p_analyzesolution(long var1, int var3, int var4) throws Error;

    public synchronized void appendbarvars(int[] nArray) throws Error {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument dim must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        this.p_appendbarvars(this.native_task, n, intBuffer);
    }

    private native void p_appendbarvars(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized void appendcone(conetype conetype2, double d, int[] nArray) throws Error {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument submem must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        this.p_appendcone(this.native_task, conetype2.getValue(), d, n, intBuffer);
    }

    private native void p_appendcone(long var1, int var3, double var4, int var6, IntBuffer var7) throws Error;

    public synchronized void appendconeseq(conetype conetype2, double d, int n, int n2) throws Error {
        this.p_appendconeseq(this.native_task, conetype2.getValue(), d, n, n2);
    }

    private native void p_appendconeseq(long var1, int var3, double var4, int var6, int var7) throws Error;

    public synchronized void appendconesseq(conetype[] conetypeArray, double[] dArray, int[] nArray, int n) throws Error {
        int n2 = conetypeArray == null ? 0 : conetypeArray.length;
        if (n2 != (dArray == null ? 0 : dArray.length)) {
            throw new ArrayLengthException("appendconesseq", "num");
        }
        if (n2 != (nArray == null ? 0 : nArray.length)) {
            throw new ArrayLengthException("appendconesseq", "num");
        }
        if (conetypeArray == null) {
            throw new NullPointerException("Argument ct must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (conetypeArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(conetypeArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            for (int i = 0; i < conetypeArray.length; ++i) {
                intBuffer.put(conetypeArray[i].getValue());
            }
        }
        if (dArray == null) {
            throw new NullPointerException("Argument conepar must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (nArray == null) {
            throw new NullPointerException("Argument nummem must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer2 = null;
        if (nArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer3 = intBuffer2 = nArray == null ? null : byteBuffer3.asIntBuffer();
        }
        if (intBuffer2 != null) {
            intBuffer2.position(0);
            intBuffer2.put(nArray);
        }
        this.p_appendconesseq(this.native_task, n2, intBuffer, doubleBuffer, intBuffer2, n);
    }

    private native void p_appendconesseq(long var1, int var3, IntBuffer var4, DoubleBuffer var5, IntBuffer var6, int var7) throws Error;

    public synchronized void appendcons(int n) throws Error {
        this.p_appendcons(this.native_task, n);
    }

    private native void p_appendcons(long var1, int var3) throws Error;

    public synchronized void appendsparsesymmat(int n, int[] nArray, int[] nArray2, double[] dArray, long[] lArray) throws Error {
        long l = nArray == null ? 0L : (long)nArray.length;
        if (l != (long)(nArray2 == null ? 0 : nArray2.length)) {
            throw new ArrayLengthException("appendsparsesymmat", "nz");
        }
        if (l != (long)(dArray == null ? 0 : dArray.length)) {
            throw new ArrayLengthException("appendsparsesymmat", "nz");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subi must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.put(nArray2);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valij must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(8);
        byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer4.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        this.p_appendsparsesymmat(this.native_task, n, l, intBuffer, intBuffer3, doubleBuffer, longBuffer);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_appendsparsesymmat(long var1, int var3, long var4, IntBuffer var6, IntBuffer var7, DoubleBuffer var8, LongBuffer var9) throws Error;

    public synchronized long appendsparsesymmat(int n, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        long l = nArray == null ? 0L : (long)nArray.length;
        if (l != (long)(nArray2 == null ? 0 : nArray2.length)) {
            throw new ArrayLengthException("appendsparsesymmat", "nz");
        }
        if (l != (long)(dArray == null ? 0 : dArray.length)) {
            throw new ArrayLengthException("appendsparsesymmat", "nz");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subi must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.put(nArray2);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valij must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(8);
        byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer4.asLongBuffer();
        this.p_appendsparsesymmat(this.native_task, n, l, intBuffer, intBuffer3, doubleBuffer, longBuffer);
        return longBuffer.get(0);
    }

    public synchronized void appendvars(int n) throws Error {
        this.p_appendvars(this.native_task, n);
    }

    private native void p_appendvars(long var1, int var3) throws Error;

    public synchronized void asyncgetresult(String string, String string2, String string3, boolean[] blArray, rescode[] rescodeArray, rescode[] rescodeArray2) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        byte[] byArray2 = null;
        try {
            byArray2 = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byArray2.length + 1);
        byteBuffer2.put(byArray2);
        byteBuffer2.put((byte)0);
        byte[] byArray3 = null;
        try {
            byArray3 = string3.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(byArray3.length + 1);
        byteBuffer3.put(byArray3);
        byteBuffer3.put((byte)0);
        ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(4);
        byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer4.asIntBuffer();
        if (blArray != null && blArray.length > 0) {
            intBuffer.put(0, blArray[0] ? 1 : 0);
        }
        ByteBuffer byteBuffer5 = ByteBuffer.allocateDirect(4);
        byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer5.asIntBuffer();
        ByteBuffer byteBuffer6 = ByteBuffer.allocateDirect(4);
        byteBuffer6.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer3 = byteBuffer6.asIntBuffer();
        this.p_asyncgetresult(this.native_task, byteBuffer, byteBuffer2, byteBuffer3, intBuffer, intBuffer2, intBuffer3);
        if (rescodeArray2 != null && rescodeArray2.length > 0) {
            rescodeArray2[0] = rescode.fromValue(intBuffer3.get(0));
        }
        if (rescodeArray != null && rescodeArray.length > 0) {
            rescodeArray[0] = rescode.fromValue(intBuffer2.get(0));
        }
        if (blArray != null && blArray.length > 0) {
            blArray[0] = intBuffer.get(0) != 0;
        }
    }

    private native void p_asyncgetresult(long var1, ByteBuffer var3, ByteBuffer var4, ByteBuffer var5, IntBuffer var6, IntBuffer var7, IntBuffer var8) throws Error;

    public synchronized boolean asyncgetresult(String string, String string2, String string3, rescode[] rescodeArray, rescode[] rescodeArray2) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        byte[] byArray2 = null;
        try {
            byArray2 = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byArray2.length + 1);
        byteBuffer2.put(byArray2);
        byteBuffer2.put((byte)0);
        byte[] byArray3 = null;
        try {
            byArray3 = string3.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(byArray3.length + 1);
        byteBuffer3.put(byArray3);
        byteBuffer3.put((byte)0);
        ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(4);
        byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer4.asIntBuffer();
        ByteBuffer byteBuffer5 = ByteBuffer.allocateDirect(4);
        byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer5.asIntBuffer();
        ByteBuffer byteBuffer6 = ByteBuffer.allocateDirect(4);
        byteBuffer6.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer3 = byteBuffer6.asIntBuffer();
        this.p_asyncgetresult(this.native_task, byteBuffer, byteBuffer2, byteBuffer3, intBuffer, intBuffer2, intBuffer3);
        if (rescodeArray2 != null && rescodeArray2.length > 0) {
            rescodeArray2[0] = rescode.fromValue(intBuffer3.get(0));
        }
        if (rescodeArray != null && rescodeArray.length > 0) {
            rescodeArray[0] = rescode.fromValue(intBuffer2.get(0));
        }
        return intBuffer.get(0) != 0;
    }

    public synchronized void asyncoptimize(String string, String string2, StringBuffer stringBuffer) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        byte[] byArray2 = null;
        try {
            byArray2 = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byArray2.length + 1);
        byteBuffer2.put(byArray2);
        byteBuffer2.put((byte)0);
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(34);
        this.p_asyncoptimize(this.native_task, byteBuffer, byteBuffer2, byteBuffer3);
        byte[] byArray3 = new byte[34];
        byteBuffer3.get(byArray3);
        try {
            stringBuffer.append(new String(byArray3, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private native void p_asyncoptimize(long var1, ByteBuffer var3, ByteBuffer var4, ByteBuffer var5) throws Error;

    public synchronized String asyncoptimize(String string, String string2) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        byte[] byArray2 = null;
        try {
            byArray2 = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byArray2.length + 1);
        byteBuffer2.put(byArray2);
        byteBuffer2.put((byte)0);
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(34);
        this.p_asyncoptimize(this.native_task, byteBuffer, byteBuffer2, byteBuffer3);
        byte[] byArray3 = new byte[34];
        byteBuffer3.get(byArray3);
        String string3 = null;
        try {
            string3 = new String(byArray3, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string3;
    }

    public synchronized void asyncpoll(String string, String string2, String string3, boolean[] blArray, rescode[] rescodeArray, rescode[] rescodeArray2) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        byte[] byArray2 = null;
        try {
            byArray2 = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byArray2.length + 1);
        byteBuffer2.put(byArray2);
        byteBuffer2.put((byte)0);
        byte[] byArray3 = null;
        try {
            byArray3 = string3.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(byArray3.length + 1);
        byteBuffer3.put(byArray3);
        byteBuffer3.put((byte)0);
        ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(4);
        byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer4.asIntBuffer();
        if (blArray != null && blArray.length > 0) {
            intBuffer.put(0, blArray[0] ? 1 : 0);
        }
        ByteBuffer byteBuffer5 = ByteBuffer.allocateDirect(4);
        byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer5.asIntBuffer();
        ByteBuffer byteBuffer6 = ByteBuffer.allocateDirect(4);
        byteBuffer6.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer3 = byteBuffer6.asIntBuffer();
        this.p_asyncpoll(this.native_task, byteBuffer, byteBuffer2, byteBuffer3, intBuffer, intBuffer2, intBuffer3);
        if (rescodeArray2 != null && rescodeArray2.length > 0) {
            rescodeArray2[0] = rescode.fromValue(intBuffer3.get(0));
        }
        if (rescodeArray != null && rescodeArray.length > 0) {
            rescodeArray[0] = rescode.fromValue(intBuffer2.get(0));
        }
        if (blArray != null && blArray.length > 0) {
            blArray[0] = intBuffer.get(0) != 0;
        }
    }

    private native void p_asyncpoll(long var1, ByteBuffer var3, ByteBuffer var4, ByteBuffer var5, IntBuffer var6, IntBuffer var7, IntBuffer var8) throws Error;

    public synchronized boolean asyncpoll(String string, String string2, String string3, rescode[] rescodeArray, rescode[] rescodeArray2) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        byte[] byArray2 = null;
        try {
            byArray2 = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byArray2.length + 1);
        byteBuffer2.put(byArray2);
        byteBuffer2.put((byte)0);
        byte[] byArray3 = null;
        try {
            byArray3 = string3.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(byArray3.length + 1);
        byteBuffer3.put(byArray3);
        byteBuffer3.put((byte)0);
        ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(4);
        byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer4.asIntBuffer();
        ByteBuffer byteBuffer5 = ByteBuffer.allocateDirect(4);
        byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer5.asIntBuffer();
        ByteBuffer byteBuffer6 = ByteBuffer.allocateDirect(4);
        byteBuffer6.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer3 = byteBuffer6.asIntBuffer();
        this.p_asyncpoll(this.native_task, byteBuffer, byteBuffer2, byteBuffer3, intBuffer, intBuffer2, intBuffer3);
        if (rescodeArray2 != null && rescodeArray2.length > 0) {
            rescodeArray2[0] = rescode.fromValue(intBuffer3.get(0));
        }
        if (rescodeArray != null && rescodeArray.length > 0) {
            rescodeArray[0] = rescode.fromValue(intBuffer2.get(0));
        }
        return intBuffer.get(0) != 0;
    }

    public synchronized void asyncstop(String string, String string2, String string3) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        byte[] byArray2 = null;
        try {
            byArray2 = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byArray2.length + 1);
        byteBuffer2.put(byArray2);
        byteBuffer2.put((byte)0);
        byte[] byArray3 = null;
        try {
            byArray3 = string3.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(byArray3.length + 1);
        byteBuffer3.put(byArray3);
        byteBuffer3.put((byte)0);
        this.p_asyncstop(this.native_task, byteBuffer, byteBuffer2, byteBuffer3);
    }

    private native void p_asyncstop(long var1, ByteBuffer var3, ByteBuffer var4, ByteBuffer var5) throws Error;

    public synchronized void basiscond(double[] dArray, double[] dArray2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer2 = byteBuffer2.asDoubleBuffer();
        if (dArray2 != null && dArray2.length > 0) {
            doubleBuffer2.put(0, dArray2[0]);
        }
        this.p_basiscond(this.native_task, doubleBuffer, doubleBuffer2);
        if (dArray2 != null && dArray2.length > 0) {
            dArray2[0] = doubleBuffer2.get(0);
        }
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
    }

    private native void p_basiscond(long var1, DoubleBuffer var3, DoubleBuffer var4) throws Error;

    public synchronized void checkconvexity() throws Error {
        this.p_checkconvexity(this.native_task);
    }

    private native void p_checkconvexity(long var1) throws Error;

    public synchronized void checkmem(String string, int n) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_checkmemtask(this.native_task, byteBuffer, n);
    }

    private native void p_checkmemtask(long var1, ByteBuffer var3, int var4) throws Error;

    public synchronized void chgbound(accmode accmode2, int n, int n2, int n3, double d) throws Error {
        this.p_chgbound(this.native_task, accmode2.getValue(), n, n2, n3, d);
    }

    private native void p_chgbound(long var1, int var3, int var4, int var5, int var6, double var7) throws Error;

    public synchronized void chgconbound(int n, int n2, int n3, double d) throws Error {
        this.p_chgconbound(this.native_task, n, n2, n3, d);
    }

    private native void p_chgconbound(long var1, int var3, int var4, int var5, double var6) throws Error;

    public synchronized void chgvarbound(int n, int n2, int n3, double d) throws Error {
        this.p_chgvarbound(this.native_task, n, n2, n3, d);
    }

    private native void p_chgvarbound(long var1, int var3, int var4, int var5, double var6) throws Error;

    public synchronized void commitchanges() throws Error {
        this.p_commitchanges(this.native_task);
    }

    private native void p_commitchanges(long var1) throws Error;

    public synchronized void deletesolution(soltype soltype2) throws Error {
        this.p_deletesolution(this.native_task, soltype2.getValue());
    }

    private native void p_deletesolution(long var1, int var3) throws Error;

    public synchronized void dualsensitivity(int[] nArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) throws Error {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument subj must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer2 = null;
        if (dArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer2 = dArray2 == null ? null : byteBuffer3.asDoubleBuffer();
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray3 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray3.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer3 = dArray3 == null ? null : byteBuffer4.asDoubleBuffer();
        }
        ByteBuffer byteBuffer5 = null;
        DoubleBuffer doubleBuffer4 = null;
        if (dArray4 != null) {
            byteBuffer5 = ByteBuffer.allocateDirect(dArray4.length * 8);
            byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer5 = doubleBuffer4 = dArray4 == null ? null : byteBuffer5.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("dualsensitivity", "leftpricej");
        }
        if (dArray2 != null && dArray2.length < n) {
            throw new ArrayLengthException("dualsensitivity", "rightpricej");
        }
        if (dArray3 != null && dArray3.length < n) {
            throw new ArrayLengthException("dualsensitivity", "leftrangej");
        }
        if (dArray4 != null && dArray4.length < n) {
            throw new ArrayLengthException("dualsensitivity", "rightrangej");
        }
        this.p_dualsensitivity(this.native_task, n, intBuffer, doubleBuffer, doubleBuffer2, doubleBuffer3, doubleBuffer4);
        if (doubleBuffer4 != null) {
            doubleBuffer4.position(0);
            doubleBuffer4.get(dArray4);
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.get(dArray3);
        }
        if (doubleBuffer2 != null) {
            doubleBuffer2.position(0);
            doubleBuffer2.get(dArray2);
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_dualsensitivity(long var1, int var3, IntBuffer var4, DoubleBuffer var5, DoubleBuffer var6, DoubleBuffer var7, DoubleBuffer var8) throws Error;

    public synchronized void getacol(int n, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer2 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer3 = intBuffer2 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valj must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (nArray2 != null && nArray2.length < this.getacolnumnz(n)) {
            throw new ArrayLengthException("getacol", "subj");
        }
        if (dArray != null && dArray.length < this.getacolnumnz(n)) {
            throw new ArrayLengthException("getacol", "valj");
        }
        this.p_getacol(this.native_task, n, intBuffer, intBuffer2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (intBuffer2 != null) {
            intBuffer2.position(0);
            intBuffer2.get(nArray2);
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getacol(long var1, int var3, IntBuffer var4, IntBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void getacolnumnz(int n, int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getacolnumnz(this.native_task, n, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getacolnumnz(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized int getacolnumnz(int n) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getacolnumnz(this.native_task, n, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getacolslicetrip(int n, int n2, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        int n3;
        long l = this.getaslicenumnz(accmode.var, n, n2);
        int n4 = n3 = nArray == null ? 0 : nArray.length;
        if (nArray2 != null) {
            n3 = Math.min(n3, nArray2.length);
        }
        if (dArray != null) {
            n3 = Math.min(n3, dArray.length);
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer2 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer2 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getacolslicetrip", "subi");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getacolslicetrip", "subj");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getacolslicetrip", "val");
        }
        this.p_getacolslicetrip(this.native_task, n, n2, l, n3, intBuffer, intBuffer2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (intBuffer2 != null) {
            intBuffer2.position(0);
            intBuffer2.get(nArray2);
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.get(nArray);
        }
    }

    private native void p_getacolslicetrip(long var1, int var3, int var4, long var5, int var7, IntBuffer var8, IntBuffer var9, DoubleBuffer var10) throws Error;

    public synchronized void getaij(int n, int n2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        this.p_getaij(this.native_task, n, n2, doubleBuffer);
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
    }

    private native void p_getaij(long var1, int var3, int var4, DoubleBuffer var5) throws Error;

    public synchronized double getaij(int n, int n2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        this.p_getaij(this.native_task, n, n2, doubleBuffer);
        return doubleBuffer.get(0);
    }

    public synchronized void getapiecenumnz(int n, int n2, int n3, int n4, int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getapiecenumnz(this.native_task, n, n2, n3, n4, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getapiecenumnz(long var1, int var3, int var4, int var5, int var6, IntBuffer var7) throws Error;

    public synchronized int getapiecenumnz(int n, int n2, int n3, int n4) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getapiecenumnz(this.native_task, n, n2, n3, n4, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getarow(int n, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subi must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer2 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer3 = intBuffer2 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        if (dArray == null) {
            throw new NullPointerException("Argument vali must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (nArray2 != null && nArray2.length < this.getarownumnz(n)) {
            throw new ArrayLengthException("getarow", "subi");
        }
        if (dArray != null && dArray.length < this.getarownumnz(n)) {
            throw new ArrayLengthException("getarow", "vali");
        }
        this.p_getarow(this.native_task, n, intBuffer, intBuffer2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (intBuffer2 != null) {
            intBuffer2.position(0);
            intBuffer2.get(nArray2);
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getarow(long var1, int var3, IntBuffer var4, IntBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void getarownumnz(int n, int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getarownumnz(this.native_task, n, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getarownumnz(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized int getarownumnz(int n) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getarownumnz(this.native_task, n, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getarowslicetrip(int n, int n2, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        int n3;
        long l = this.getaslicenumnz(accmode.var, n, n2);
        int n4 = n3 = nArray == null ? 0 : nArray.length;
        if (nArray2 != null) {
            n3 = Math.min(n3, nArray2.length);
        }
        if (dArray != null) {
            n3 = Math.min(n3, dArray.length);
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer2 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer2 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getarowslicetrip", "subi");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getarowslicetrip", "subj");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getarowslicetrip", "val");
        }
        this.p_getarowslicetrip(this.native_task, n, n2, l, n3, intBuffer, intBuffer2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (intBuffer2 != null) {
            intBuffer2.position(0);
            intBuffer2.get(nArray2);
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.get(nArray);
        }
    }

    private native void p_getarowslicetrip(long var1, int var3, int var4, long var5, int var7, IntBuffer var8, IntBuffer var9, DoubleBuffer var10) throws Error;

    public synchronized void getaslice(accmode accmode2, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        int n3;
        int n4 = (int)this.getaslicenumnz(accmode2, n, n2);
        int n5 = n3 = nArray3 == null ? 0 : nArray3.length;
        if (dArray != null) {
            n3 = Math.min(n3, dArray.length);
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer2 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer2 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer3 = null;
        if (nArray3 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray3.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer3 = nArray3 == null ? null : byteBuffer3.asIntBuffer();
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (nArray != null && nArray.length < n2 - n) {
            throw new ArrayLengthException("getaslice", "ptrb");
        }
        if (nArray2 != null && nArray2.length < n2 - n) {
            throw new ArrayLengthException("getaslice", "ptre");
        }
        if (nArray3 != null && nArray3.length < n4) {
            throw new ArrayLengthException("getaslice", "sub");
        }
        if (dArray != null && dArray.length < n4) {
            throw new ArrayLengthException("getaslice", "val");
        }
        this.p_getaslice(this.native_task, accmode2.getValue(), n, n2, n4, n3, intBuffer, intBuffer2, intBuffer3, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.get(nArray3);
        }
        if (intBuffer2 != null) {
            intBuffer2.position(0);
            intBuffer2.get(nArray2);
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.get(nArray);
        }
    }

    private native void p_getaslice(long var1, int var3, int var4, int var5, int var6, int var7, IntBuffer var8, IntBuffer var9, IntBuffer var10, DoubleBuffer var11) throws Error;

    public synchronized void getaslice(accmode accmode2, int n, int n2, long[] lArray, long[] lArray2, int[] nArray, double[] dArray) throws Error {
        int n3;
        long l = this.getaslicenumnz(accmode2, n, n2);
        int n4 = n3 = nArray == null ? 0 : nArray.length;
        if (dArray != null) {
            n3 = Math.min(n3, dArray.length);
        }
        ByteBuffer byteBuffer = null;
        LongBuffer longBuffer = null;
        if (lArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(lArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            longBuffer = lArray == null ? null : byteBuffer.asLongBuffer();
        }
        ByteBuffer byteBuffer2 = null;
        LongBuffer longBuffer2 = null;
        if (lArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(lArray2.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            longBuffer2 = lArray2 == null ? null : byteBuffer2.asLongBuffer();
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = nArray == null ? null : byteBuffer3.asIntBuffer();
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (lArray != null && lArray.length < n2 - n) {
            throw new ArrayLengthException("getaslice64", "ptrb");
        }
        if (lArray2 != null && lArray2.length < n2 - n) {
            throw new ArrayLengthException("getaslice64", "ptre");
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getaslice64", "sub");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getaslice64", "val");
        }
        this.p_getaslice64(this.native_task, accmode2.getValue(), n, n2, l, n3, longBuffer, longBuffer2, intBuffer, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.get(nArray);
        }
        if (longBuffer2 != null) {
            longBuffer2.position(0);
            longBuffer2.get(lArray2);
        }
        if (longBuffer != null) {
            longBuffer.position(0);
            longBuffer.get(lArray);
        }
    }

    private native void p_getaslice64(long var1, int var3, int var4, int var5, long var6, int var8, LongBuffer var9, LongBuffer var10, IntBuffer var11, DoubleBuffer var12) throws Error;

    public synchronized void getaslicenumnz(accmode accmode2, int n, int n2, long[] lArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        this.p_getaslicenumnz64(this.native_task, accmode2.getValue(), n, n2, longBuffer);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getaslicenumnz64(long var1, int var3, int var4, int var5, LongBuffer var6) throws Error;

    public synchronized long getaslicenumnz(accmode accmode2, int n, int n2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        this.p_getaslicenumnz64(this.native_task, accmode2.getValue(), n, n2, longBuffer);
        return longBuffer.get(0);
    }

    public synchronized void getbarablocktriplet(long[] lArray, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, double[] dArray) throws Error {
        long l = this.getnumbarablocktriplets();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subi must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer2.asIntBuffer();
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subk must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        IntBuffer intBuffer5 = null;
        if (nArray3 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(nArray3.length * 4);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer6 = intBuffer5 = nArray3 == null ? null : byteBuffer4.asIntBuffer();
        }
        if (nArray4 == null) {
            throw new NullPointerException("Argument subl must not be null");
        }
        ByteBuffer byteBuffer5 = null;
        IntBuffer intBuffer7 = null;
        if (nArray4 != null) {
            byteBuffer5 = ByteBuffer.allocateDirect(nArray4.length * 4);
            byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer8 = intBuffer7 = nArray4 == null ? null : byteBuffer5.asIntBuffer();
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valijkl must not be null");
        }
        ByteBuffer byteBuffer6 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer6 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer6.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer6.asDoubleBuffer();
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "subi");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "subj");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "subk");
        }
        if (nArray4 != null && (long)nArray4.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "subl");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "valijkl");
        }
        this.p_getbarablocktriplet(this.native_task, l, longBuffer, intBuffer, intBuffer3, intBuffer5, intBuffer7, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (intBuffer7 != null) {
            intBuffer7.position(0);
            intBuffer7.get(nArray4);
        }
        if (intBuffer5 != null) {
            intBuffer5.position(0);
            intBuffer5.get(nArray3);
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.get(nArray2);
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.get(nArray);
        }
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getbarablocktriplet(long var1, long var3, LongBuffer var5, IntBuffer var6, IntBuffer var7, IntBuffer var8, IntBuffer var9, DoubleBuffer var10) throws Error;

    public synchronized long getbarablocktriplet(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, double[] dArray) throws Error {
        long l = this.getnumbarablocktriplets();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (nArray == null) {
            throw new NullPointerException("Argument subi must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer2.asIntBuffer();
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subk must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        IntBuffer intBuffer5 = null;
        if (nArray3 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(nArray3.length * 4);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer6 = intBuffer5 = nArray3 == null ? null : byteBuffer4.asIntBuffer();
        }
        if (nArray4 == null) {
            throw new NullPointerException("Argument subl must not be null");
        }
        ByteBuffer byteBuffer5 = null;
        IntBuffer intBuffer7 = null;
        if (nArray4 != null) {
            byteBuffer5 = ByteBuffer.allocateDirect(nArray4.length * 4);
            byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer8 = intBuffer7 = nArray4 == null ? null : byteBuffer5.asIntBuffer();
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valijkl must not be null");
        }
        ByteBuffer byteBuffer6 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer6 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer6.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer6.asDoubleBuffer();
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "subi");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "subj");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "subk");
        }
        if (nArray4 != null && (long)nArray4.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "subl");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "valijkl");
        }
        this.p_getbarablocktriplet(this.native_task, l, longBuffer, intBuffer, intBuffer3, intBuffer5, intBuffer7, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (intBuffer7 != null) {
            intBuffer7.position(0);
            intBuffer7.get(nArray4);
        }
        if (intBuffer5 != null) {
            intBuffer5.position(0);
            intBuffer5.get(nArray3);
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.get(nArray2);
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.get(nArray);
        }
        return longBuffer.get(0);
    }

    public synchronized void getbaraidx(long l, int[] nArray, int[] nArray2, long[] lArray, long[] lArray2, double[] dArray) throws Error {
        long l2 = this.getbaraidxinfo(l);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer2.asIntBuffer();
        if (nArray2 != null && nArray2.length > 0) {
            intBuffer2.put(0, nArray2[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(8);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer3.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        LongBuffer longBuffer2 = null;
        if (lArray2 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(lArray2.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            LongBuffer longBuffer3 = longBuffer2 = lArray2 == null ? null : byteBuffer4.asLongBuffer();
        }
        if (dArray == null) {
            throw new NullPointerException("Argument weights must not be null");
        }
        ByteBuffer byteBuffer5 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer5 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer5.asDoubleBuffer();
        }
        if (lArray2 != null && (long)lArray2.length < l2) {
            throw new ArrayLengthException("getbaraidx", "sub");
        }
        if (dArray != null && (long)dArray.length < l2) {
            throw new ArrayLengthException("getbaraidx", "weights");
        }
        this.p_getbaraidx(this.native_task, l, l2, intBuffer, intBuffer2, longBuffer, longBuffer2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (longBuffer2 != null) {
            longBuffer2.position(0);
            longBuffer2.get(lArray2);
        }
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
        if (nArray2 != null && nArray2.length > 0) {
            nArray2[0] = intBuffer2.get(0);
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getbaraidx(long var1, long var3, long var5, IntBuffer var7, IntBuffer var8, LongBuffer var9, LongBuffer var10, DoubleBuffer var11) throws Error;

    public synchronized long getbaraidx(long l, int[] nArray, int[] nArray2, long[] lArray, double[] dArray) throws Error {
        long l2 = this.getbaraidxinfo(l);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer2.asIntBuffer();
        if (nArray2 != null && nArray2.length > 0) {
            intBuffer2.put(0, nArray2[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(8);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer3.asLongBuffer();
        if (lArray == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        LongBuffer longBuffer2 = null;
        if (lArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(lArray.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            LongBuffer longBuffer3 = longBuffer2 = lArray == null ? null : byteBuffer4.asLongBuffer();
        }
        if (dArray == null) {
            throw new NullPointerException("Argument weights must not be null");
        }
        ByteBuffer byteBuffer5 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer5 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer5.asDoubleBuffer();
        }
        if (lArray != null && (long)lArray.length < l2) {
            throw new ArrayLengthException("getbaraidx", "sub");
        }
        if (dArray != null && (long)dArray.length < l2) {
            throw new ArrayLengthException("getbaraidx", "weights");
        }
        this.p_getbaraidx(this.native_task, l, l2, intBuffer, intBuffer2, longBuffer, longBuffer2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (longBuffer2 != null) {
            longBuffer2.position(0);
            longBuffer2.get(lArray);
        }
        if (nArray2 != null && nArray2.length > 0) {
            nArray2[0] = intBuffer2.get(0);
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
        return longBuffer.get(0);
    }

    public synchronized void getbaraidxij(long l, int[] nArray, int[] nArray2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer2.asIntBuffer();
        if (nArray2 != null && nArray2.length > 0) {
            intBuffer2.put(0, nArray2[0]);
        }
        this.p_getbaraidxij(this.native_task, l, intBuffer, intBuffer2);
        if (nArray2 != null && nArray2.length > 0) {
            nArray2[0] = intBuffer2.get(0);
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getbaraidxij(long var1, long var3, IntBuffer var5, IntBuffer var6) throws Error;

    public synchronized void getbaraidxinfo(long l, long[] lArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        this.p_getbaraidxinfo(this.native_task, l, longBuffer);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getbaraidxinfo(long var1, long var3, LongBuffer var5) throws Error;

    public synchronized long getbaraidxinfo(long l) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        this.p_getbaraidxinfo(this.native_task, l, longBuffer);
        return longBuffer.get(0);
    }

    public synchronized void getbarasparsity(long[] lArray, long[] lArray2) throws Error {
        long l = this.getnumbaranz();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument idxij must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        LongBuffer longBuffer2 = null;
        if (lArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(lArray2.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            LongBuffer longBuffer3 = longBuffer2 = lArray2 == null ? null : byteBuffer2.asLongBuffer();
        }
        if (lArray2 != null && (long)lArray2.length < l) {
            throw new ArrayLengthException("getbarasparsity", "idxij");
        }
        this.p_getbarasparsity(this.native_task, l, longBuffer, longBuffer2);
        if (longBuffer2 != null) {
            longBuffer2.position(0);
            longBuffer2.get(lArray2);
        }
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getbarasparsity(long var1, long var3, LongBuffer var5, LongBuffer var6) throws Error;

    public synchronized void getbarcblocktriplet(long[] lArray, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        long l = this.getnumbarcblocktriplets();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subj must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer2.asIntBuffer();
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subk must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subl must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        IntBuffer intBuffer5 = null;
        if (nArray3 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(nArray3.length * 4);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer6 = intBuffer5 = nArray3 == null ? null : byteBuffer4.asIntBuffer();
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valjkl must not be null");
        }
        ByteBuffer byteBuffer5 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer5 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer5.asDoubleBuffer();
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getbarcblocktriplet", "subj");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getbarcblocktriplet", "subk");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("getbarcblocktriplet", "subl");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getbarcblocktriplet", "valjkl");
        }
        this.p_getbarcblocktriplet(this.native_task, l, longBuffer, intBuffer, intBuffer3, intBuffer5, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (intBuffer5 != null) {
            intBuffer5.position(0);
            intBuffer5.get(nArray3);
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.get(nArray2);
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.get(nArray);
        }
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getbarcblocktriplet(long var1, long var3, LongBuffer var5, IntBuffer var6, IntBuffer var7, IntBuffer var8, DoubleBuffer var9) throws Error;

    public synchronized long getbarcblocktriplet(int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        long l = this.getnumbarcblocktriplets();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (nArray == null) {
            throw new NullPointerException("Argument subj must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer2.asIntBuffer();
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subk must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subl must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        IntBuffer intBuffer5 = null;
        if (nArray3 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(nArray3.length * 4);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer6 = intBuffer5 = nArray3 == null ? null : byteBuffer4.asIntBuffer();
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valjkl must not be null");
        }
        ByteBuffer byteBuffer5 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer5 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer5.asDoubleBuffer();
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getbarcblocktriplet", "subj");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getbarcblocktriplet", "subk");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("getbarcblocktriplet", "subl");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getbarcblocktriplet", "valjkl");
        }
        this.p_getbarcblocktriplet(this.native_task, l, longBuffer, intBuffer, intBuffer3, intBuffer5, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (intBuffer5 != null) {
            intBuffer5.position(0);
            intBuffer5.get(nArray3);
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.get(nArray2);
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.get(nArray);
        }
        return longBuffer.get(0);
    }

    public synchronized void getbarcidx(long l, int[] nArray, long[] lArray, long[] lArray2, double[] dArray) throws Error {
        long l2 = this.getbarcidxinfo(l);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer2.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        LongBuffer longBuffer2 = null;
        if (lArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(lArray2.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            LongBuffer longBuffer3 = longBuffer2 = lArray2 == null ? null : byteBuffer3.asLongBuffer();
        }
        if (dArray == null) {
            throw new NullPointerException("Argument weights must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (lArray2 != null && (long)lArray2.length < l2) {
            throw new ArrayLengthException("getbarcidx", "sub");
        }
        if (dArray != null && (long)dArray.length < l2) {
            throw new ArrayLengthException("getbarcidx", "weights");
        }
        this.p_getbarcidx(this.native_task, l, l2, intBuffer, longBuffer, longBuffer2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (longBuffer2 != null) {
            longBuffer2.position(0);
            longBuffer2.get(lArray2);
        }
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getbarcidx(long var1, long var3, long var5, IntBuffer var7, LongBuffer var8, LongBuffer var9, DoubleBuffer var10) throws Error;

    public synchronized void getbarcidxinfo(long l, long[] lArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        this.p_getbarcidxinfo(this.native_task, l, longBuffer);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getbarcidxinfo(long var1, long var3, LongBuffer var5) throws Error;

    public synchronized long getbarcidxinfo(long l) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        this.p_getbarcidxinfo(this.native_task, l, longBuffer);
        return longBuffer.get(0);
    }

    public synchronized void getbarcidxj(long l, int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getbarcidxj(this.native_task, l, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getbarcidxj(long var1, long var3, IntBuffer var5) throws Error;

    public synchronized void getbarcsparsity(long[] lArray, long[] lArray2) throws Error {
        long l = this.getnumbarcnz();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument idxj must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        LongBuffer longBuffer2 = null;
        if (lArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(lArray2.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            LongBuffer longBuffer3 = longBuffer2 = lArray2 == null ? null : byteBuffer2.asLongBuffer();
        }
        if (lArray2 != null && (long)lArray2.length < l) {
            throw new ArrayLengthException("getbarcsparsity", "idxj");
        }
        this.p_getbarcsparsity(this.native_task, l, longBuffer, longBuffer2);
        if (longBuffer2 != null) {
            longBuffer2.position(0);
            longBuffer2.get(lArray2);
        }
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getbarcsparsity(long var1, long var3, LongBuffer var5, LongBuffer var6) throws Error;

    public synchronized void getbarsj(soltype soltype2, int n, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument barsj must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && (long)dArray.length < this.getlenbarvarj(n)) {
            throw new ArrayLengthException("getbarsj", "barsj");
        }
        this.p_getbarsj(this.native_task, soltype2.getValue(), n, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getbarsj(long var1, int var3, int var4, DoubleBuffer var5) throws Error;

    public synchronized void getbarvarname(int n, StringBuffer stringBuffer) throws Error {
        int n2 = 1 + this.getbarvarnamelen(n);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 + 1);
        this.p_getbarvarname(this.native_task, n, n2, byteBuffer);
        byte[] byArray = new byte[n2 + 1];
        byteBuffer.get(byArray);
        try {
            stringBuffer.append(new String(byArray, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private native void p_getbarvarname(long var1, int var3, int var4, ByteBuffer var5) throws Error;

    public synchronized String getbarvarname(int n) throws Error {
        int n2 = 1 + this.getbarvarnamelen(n);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 + 1);
        this.p_getbarvarname(this.native_task, n, n2, byteBuffer);
        byte[] byArray = new byte[n2 + 1];
        byteBuffer.get(byArray);
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void getbarvarnameindex(String string, int[] nArray, int[] nArray2) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer2.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(4);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer3.asIntBuffer();
        if (nArray2 != null && nArray2.length > 0) {
            intBuffer2.put(0, nArray2[0]);
        }
        this.p_getbarvarnameindex(this.native_task, byteBuffer, intBuffer, intBuffer2);
        if (nArray2 != null && nArray2.length > 0) {
            nArray2[0] = intBuffer2.get(0);
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getbarvarnameindex(long var1, ByteBuffer var3, IntBuffer var4, IntBuffer var5) throws Error;

    public synchronized int getbarvarnameindex(String string, int[] nArray) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer2.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(4);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer3.asIntBuffer();
        this.p_getbarvarnameindex(this.native_task, byteBuffer, intBuffer, intBuffer2);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
        return intBuffer2.get(0);
    }

    public synchronized void getbarvarnamelen(int n, int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getbarvarnamelen(this.native_task, n, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getbarvarnamelen(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized int getbarvarnamelen(int n) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getbarvarnamelen(this.native_task, n, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getbarxj(soltype soltype2, int n, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument barxj must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && (long)dArray.length < this.getlenbarvarj(n)) {
            throw new ArrayLengthException("getbarxj", "barxj");
        }
        this.p_getbarxj(this.native_task, soltype2.getValue(), n, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getbarxj(long var1, int var3, int var4, DoubleBuffer var5) throws Error;

    public synchronized void getbound(accmode accmode2, int n, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer2.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(8);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer2 = byteBuffer3.asDoubleBuffer();
        if (dArray2 != null && dArray2.length > 0) {
            doubleBuffer2.put(0, dArray2[0]);
        }
        this.p_getbound(this.native_task, accmode2.getValue(), n, intBuffer, doubleBuffer, doubleBuffer2);
        if (dArray2 != null && dArray2.length > 0) {
            dArray2[0] = doubleBuffer2.get(0);
        }
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
        if (boundkeyArray != null && boundkeyArray.length > 0) {
            boundkeyArray[0] = boundkey.fromValue(intBuffer.get(0));
        }
    }

    private native void p_getbound(long var1, int var3, int var4, IntBuffer var5, DoubleBuffer var6, DoubleBuffer var7) throws Error;

    public synchronized void getboundslice(accmode accmode2, int n, int n2, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (boundkeyArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(boundkeyArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            for (int i = 0; i < boundkeyArray.length; ++i) {
                boundkeyArray[i] = boundkey.fromValue(intBuffer.get());
            }
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer2 = null;
        if (dArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer3 = doubleBuffer2 = dArray2 == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (boundkeyArray != null && boundkeyArray.length < n2 - n) {
            throw new ArrayLengthException("getboundslice", "bk");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getboundslice", "bl");
        }
        if (dArray2 != null && dArray2.length < n2 - n) {
            throw new ArrayLengthException("getboundslice", "bu");
        }
        this.p_getboundslice(this.native_task, accmode2.getValue(), n, n2, intBuffer, doubleBuffer, doubleBuffer2);
        if (doubleBuffer2 != null) {
            doubleBuffer2.position(0);
            doubleBuffer2.get(dArray2);
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getboundslice(long var1, int var3, int var4, int var5, IntBuffer var6, DoubleBuffer var7, DoubleBuffer var8) throws Error;

    public synchronized void getc(double[] dArray) throws Error {
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < this.getnumvar()) {
            throw new ArrayLengthException("getc", "c");
        }
        this.p_getc(this.native_task, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getc(long var1, DoubleBuffer var3) throws Error;

    public synchronized void getcfix(double[] dArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        this.p_getcfix(this.native_task, doubleBuffer);
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
    }

    private native void p_getcfix(long var1, DoubleBuffer var3) throws Error;

    public synchronized double getcfix() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        this.p_getcfix(this.native_task, doubleBuffer);
        return doubleBuffer.get(0);
    }

    public synchronized void getcj(int n, double[] dArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        this.p_getcj(this.native_task, n, doubleBuffer);
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
    }

    private native void p_getcj(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void getconbound(int n, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer2.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(8);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer2 = byteBuffer3.asDoubleBuffer();
        if (dArray2 != null && dArray2.length > 0) {
            doubleBuffer2.put(0, dArray2[0]);
        }
        this.p_getconbound(this.native_task, n, intBuffer, doubleBuffer, doubleBuffer2);
        if (dArray2 != null && dArray2.length > 0) {
            dArray2[0] = doubleBuffer2.get(0);
        }
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
        if (boundkeyArray != null && boundkeyArray.length > 0) {
            boundkeyArray[0] = boundkey.fromValue(intBuffer.get(0));
        }
    }

    private native void p_getconbound(long var1, int var3, IntBuffer var4, DoubleBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void getconboundslice(int n, int n2, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (boundkeyArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(boundkeyArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            for (int i = 0; i < boundkeyArray.length; ++i) {
                boundkeyArray[i] = boundkey.fromValue(intBuffer.get());
            }
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer2 = null;
        if (dArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer3 = doubleBuffer2 = dArray2 == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (boundkeyArray != null && boundkeyArray.length < n2 - n) {
            throw new ArrayLengthException("getconboundslice", "bk");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getconboundslice", "bl");
        }
        if (dArray2 != null && dArray2.length < n2 - n) {
            throw new ArrayLengthException("getconboundslice", "bu");
        }
        this.p_getconboundslice(this.native_task, n, n2, intBuffer, doubleBuffer, doubleBuffer2);
        if (doubleBuffer2 != null) {
            doubleBuffer2.position(0);
            doubleBuffer2.get(dArray2);
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getconboundslice(long var1, int var3, int var4, IntBuffer var5, DoubleBuffer var6, DoubleBuffer var7) throws Error;

    public synchronized void getcone(int n, conetype[] conetypeArray, double[] dArray, int[] nArray, int[] nArray2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer2.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(4);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer3.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer2.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer4 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer4.asIntBuffer();
        }
        if (nArray2 != null) {
            IntBuffer intBuffer5 = IntBuffer.allocate(1);
            this.p_getcone(this.native_task, n, null, null, null, intBuffer5);
            if (nArray2.length < intBuffer5.get(0)) {
                throw new ArrayLengthException("getcone", "submem");
            }
        }
        this.p_getcone(this.native_task, n, intBuffer, doubleBuffer, intBuffer2, intBuffer3);
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.get(nArray2);
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer2.get(0);
        }
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
        if (conetypeArray != null && conetypeArray.length > 0) {
            conetypeArray[0] = conetype.fromValue(intBuffer.get(0));
        }
    }

    private native void p_getcone(long var1, int var3, IntBuffer var4, DoubleBuffer var5, IntBuffer var6, IntBuffer var7) throws Error;

    public synchronized void getconeinfo(int n, conetype[] conetypeArray, double[] dArray, int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer2.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(4);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer3.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer2.put(0, nArray[0]);
        }
        this.p_getconeinfo(this.native_task, n, intBuffer, doubleBuffer, intBuffer2);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer2.get(0);
        }
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
        if (conetypeArray != null && conetypeArray.length > 0) {
            conetypeArray[0] = conetype.fromValue(intBuffer.get(0));
        }
    }

    private native void p_getconeinfo(long var1, int var3, IntBuffer var4, DoubleBuffer var5, IntBuffer var6) throws Error;

    public synchronized void getconename(int n, StringBuffer stringBuffer) throws Error {
        int n2 = 1 + this.getconenamelen(n);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 + 1);
        this.p_getconename(this.native_task, n, n2, byteBuffer);
        byte[] byArray = new byte[n2 + 1];
        byteBuffer.get(byArray);
        try {
            stringBuffer.append(new String(byArray, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private native void p_getconename(long var1, int var3, int var4, ByteBuffer var5) throws Error;

    public synchronized String getconename(int n) throws Error {
        int n2 = 1 + this.getconenamelen(n);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 + 1);
        this.p_getconename(this.native_task, n, n2, byteBuffer);
        byte[] byArray = new byte[n2 + 1];
        byteBuffer.get(byArray);
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void getconenameindex(String string, int[] nArray, int[] nArray2) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer2.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(4);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer3.asIntBuffer();
        if (nArray2 != null && nArray2.length > 0) {
            intBuffer2.put(0, nArray2[0]);
        }
        this.p_getconenameindex(this.native_task, byteBuffer, intBuffer, intBuffer2);
        if (nArray2 != null && nArray2.length > 0) {
            nArray2[0] = intBuffer2.get(0);
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getconenameindex(long var1, ByteBuffer var3, IntBuffer var4, IntBuffer var5) throws Error;

    public synchronized int getconenameindex(String string, int[] nArray) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer2.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(4);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer3.asIntBuffer();
        this.p_getconenameindex(this.native_task, byteBuffer, intBuffer, intBuffer2);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
        return intBuffer2.get(0);
    }

    public synchronized void getconenamelen(int n, int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getconenamelen(this.native_task, n, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getconenamelen(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized int getconenamelen(int n) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getconenamelen(this.native_task, n, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getconname(int n, StringBuffer stringBuffer) throws Error {
        int n2 = 1 + this.getconnamelen(n);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 + 1);
        this.p_getconname(this.native_task, n, n2, byteBuffer);
        byte[] byArray = new byte[n2 + 1];
        byteBuffer.get(byArray);
        try {
            stringBuffer.append(new String(byArray, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private native void p_getconname(long var1, int var3, int var4, ByteBuffer var5) throws Error;

    public synchronized String getconname(int n) throws Error {
        int n2 = 1 + this.getconnamelen(n);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 + 1);
        this.p_getconname(this.native_task, n, n2, byteBuffer);
        byte[] byArray = new byte[n2 + 1];
        byteBuffer.get(byArray);
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void getconnameindex(String string, int[] nArray, int[] nArray2) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer2.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(4);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer3.asIntBuffer();
        if (nArray2 != null && nArray2.length > 0) {
            intBuffer2.put(0, nArray2[0]);
        }
        this.p_getconnameindex(this.native_task, byteBuffer, intBuffer, intBuffer2);
        if (nArray2 != null && nArray2.length > 0) {
            nArray2[0] = intBuffer2.get(0);
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getconnameindex(long var1, ByteBuffer var3, IntBuffer var4, IntBuffer var5) throws Error;

    public synchronized int getconnameindex(String string, int[] nArray) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer2.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(4);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer3.asIntBuffer();
        this.p_getconnameindex(this.native_task, byteBuffer, intBuffer, intBuffer2);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
        return intBuffer2.get(0);
    }

    public synchronized void getconnamelen(int n, int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getconnamelen(this.native_task, n, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getconnamelen(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized int getconnamelen(int n) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getconnamelen(this.native_task, n, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getcslice(int n, int n2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getcslice", "c");
        }
        this.p_getcslice(this.native_task, n, n2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getcslice(long var1, int var3, int var4, DoubleBuffer var5) throws Error;

    public synchronized void getdimbarvarj(int n, int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getdimbarvarj(this.native_task, n, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getdimbarvarj(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized int getdimbarvarj(int n) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getdimbarvarj(this.native_task, n, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getdouinf(dinfitem dinfitem2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        this.p_getdouinf(this.native_task, dinfitem2.getValue(), doubleBuffer);
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
    }

    private native void p_getdouinf(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized double getdouinf(dinfitem dinfitem2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        this.p_getdouinf(this.native_task, dinfitem2.getValue(), doubleBuffer);
        return doubleBuffer.get(0);
    }

    public synchronized void getdouparam(dparam dparam2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        this.p_getdouparam(this.native_task, dparam2.getValue(), doubleBuffer);
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
    }

    private native void p_getdouparam(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized double getdouparam(dparam dparam2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        this.p_getdouparam(this.native_task, dparam2.getValue(), doubleBuffer);
        return doubleBuffer.get(0);
    }

    public synchronized void getdualobj(soltype soltype2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        this.p_getdualobj(this.native_task, soltype2.getValue(), doubleBuffer);
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
    }

    private native void p_getdualobj(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void getdualsolutionnorms(soltype soltype2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer2 = byteBuffer2.asDoubleBuffer();
        if (dArray2 != null && dArray2.length > 0) {
            doubleBuffer2.put(0, dArray2[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(8);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer3 = byteBuffer3.asDoubleBuffer();
        if (dArray3 != null && dArray3.length > 0) {
            doubleBuffer3.put(0, dArray3[0]);
        }
        ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(8);
        byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer4 = byteBuffer4.asDoubleBuffer();
        if (dArray4 != null && dArray4.length > 0) {
            doubleBuffer4.put(0, dArray4[0]);
        }
        ByteBuffer byteBuffer5 = ByteBuffer.allocateDirect(8);
        byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer5 = byteBuffer5.asDoubleBuffer();
        if (dArray5 != null && dArray5.length > 0) {
            doubleBuffer5.put(0, dArray5[0]);
        }
        ByteBuffer byteBuffer6 = ByteBuffer.allocateDirect(8);
        byteBuffer6.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer6 = byteBuffer6.asDoubleBuffer();
        if (dArray6 != null && dArray6.length > 0) {
            doubleBuffer6.put(0, dArray6[0]);
        }
        ByteBuffer byteBuffer7 = ByteBuffer.allocateDirect(8);
        byteBuffer7.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer7 = byteBuffer7.asDoubleBuffer();
        if (dArray7 != null && dArray7.length > 0) {
            doubleBuffer7.put(0, dArray7[0]);
        }
        this.p_getdualsolutionnorms(this.native_task, soltype2.getValue(), doubleBuffer, doubleBuffer2, doubleBuffer3, doubleBuffer4, doubleBuffer5, doubleBuffer6, doubleBuffer7);
        if (dArray7 != null && dArray7.length > 0) {
            dArray7[0] = doubleBuffer7.get(0);
        }
        if (dArray6 != null && dArray6.length > 0) {
            dArray6[0] = doubleBuffer6.get(0);
        }
        if (dArray5 != null && dArray5.length > 0) {
            dArray5[0] = doubleBuffer5.get(0);
        }
        if (dArray4 != null && dArray4.length > 0) {
            dArray4[0] = doubleBuffer4.get(0);
        }
        if (dArray3 != null && dArray3.length > 0) {
            dArray3[0] = doubleBuffer3.get(0);
        }
        if (dArray2 != null && dArray2.length > 0) {
            dArray2[0] = doubleBuffer2.get(0);
        }
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
    }

    private native void p_getdualsolutionnorms(long var1, int var3, DoubleBuffer var4, DoubleBuffer var5, DoubleBuffer var6, DoubleBuffer var7, DoubleBuffer var8, DoubleBuffer var9, DoubleBuffer var10) throws Error;

    public synchronized void getdviolbarvar(soltype soltype2, int[] nArray, double[] dArray) throws Error {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getdviolbarvar", "viol");
        }
        this.p_getdviolbarvar(this.native_task, soltype2.getValue(), n, intBuffer, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getdviolbarvar(long var1, int var3, int var4, IntBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void getdviolcon(soltype soltype2, int[] nArray, double[] dArray) throws Error {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getdviolcon", "viol");
        }
        this.p_getdviolcon(this.native_task, soltype2.getValue(), n, intBuffer, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getdviolcon(long var1, int var3, int var4, IntBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void getdviolcones(soltype soltype2, int[] nArray, double[] dArray) throws Error {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getdviolcones", "viol");
        }
        this.p_getdviolcones(this.native_task, soltype2.getValue(), n, intBuffer, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getdviolcones(long var1, int var3, int var4, IntBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void getdviolvar(soltype soltype2, int[] nArray, double[] dArray) throws Error {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getdviolvar", "viol");
        }
        this.p_getdviolvar(this.native_task, soltype2.getValue(), n, intBuffer, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getdviolvar(long var1, int var3, int var4, IntBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void getinfeasiblesubproblem(soltype soltype2, Task[] taskArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        this.p_getinfeasiblesubproblem(this.native_task, soltype2.getValue(), longBuffer);
        if (taskArray.length > 0) {
            taskArray[0] = new Task(longBuffer.get(0));
        }
    }

    private native void p_getinfeasiblesubproblem(long var1, int var3, LongBuffer var4) throws Error;

    public synchronized Task getinfeasiblesubproblem(soltype soltype2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        this.p_getinfeasiblesubproblem(this.native_task, soltype2.getValue(), longBuffer);
        return new Task(longBuffer.get(0));
    }

    public synchronized void getinfindex(inftype inftype2, String string, int[] nArray) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer2.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getinfindex(this.native_task, inftype2.getValue(), byteBuffer, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getinfindex(long var1, int var3, ByteBuffer var4, IntBuffer var5) throws Error;

    public synchronized void getinfmax(inftype inftype2, int[] nArray) throws Error {
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (nArray != null && nArray.length < 1024) {
            throw new ArrayLengthException("getinfmax", "infmax");
        }
        this.p_getinfmax(this.native_task, inftype2.getValue(), intBuffer);
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.get(nArray);
        }
    }

    private native void p_getinfmax(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized void getinfname(inftype inftype2, int n, StringBuffer stringBuffer) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1025);
        this.p_getinfname(this.native_task, inftype2.getValue(), n, byteBuffer);
        byte[] byArray = new byte[1025];
        byteBuffer.get(byArray);
        try {
            stringBuffer.append(new String(byArray, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private native void p_getinfname(long var1, int var3, int var4, ByteBuffer var5) throws Error;

    public synchronized void getintinf(iinfitem iinfitem2, int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getintinf(this.native_task, iinfitem2.getValue(), intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getintinf(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized int getintinf(iinfitem iinfitem2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getintinf(this.native_task, iinfitem2.getValue(), intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getintparam(iparam iparam2, int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getintparam(this.native_task, iparam2.getValue(), intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getintparam(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized int getintparam(iparam iparam2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getintparam(this.native_task, iparam2.getValue(), intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getlenbarvarj(int n, long[] lArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        this.p_getlenbarvarj(this.native_task, n, longBuffer);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getlenbarvarj(long var1, int var3, LongBuffer var4) throws Error;

    public synchronized long getlenbarvarj(int n) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        this.p_getlenbarvarj(this.native_task, n, longBuffer);
        return longBuffer.get(0);
    }

    public synchronized void getlintinf(liinfitem liinfitem2, long[] lArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        this.p_getlintinf(this.native_task, liinfitem2.getValue(), longBuffer);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getlintinf(long var1, int var3, LongBuffer var4) throws Error;

    public synchronized long getlintinf(liinfitem liinfitem2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        this.p_getlintinf(this.native_task, liinfitem2.getValue(), longBuffer);
        return longBuffer.get(0);
    }

    public synchronized void getmaxnumanz(long[] lArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        this.p_getmaxnumanz64(this.native_task, longBuffer);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getmaxnumanz64(long var1, LongBuffer var3) throws Error;

    public synchronized long getmaxnumanz() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        this.p_getmaxnumanz64(this.native_task, longBuffer);
        return longBuffer.get(0);
    }

    public synchronized void getmaxnumbarvar(int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getmaxnumbarvar(this.native_task, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getmaxnumbarvar(long var1, IntBuffer var3) throws Error;

    public synchronized int getmaxnumbarvar() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getmaxnumbarvar(this.native_task, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getmaxnumcon(int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getmaxnumcon(this.native_task, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getmaxnumcon(long var1, IntBuffer var3) throws Error;

    public synchronized void getmaxnumcone(int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getmaxnumcone(this.native_task, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getmaxnumcone(long var1, IntBuffer var3) throws Error;

    public synchronized void getmaxnumqnz(long[] lArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        this.p_getmaxnumqnz64(this.native_task, longBuffer);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getmaxnumqnz64(long var1, LongBuffer var3) throws Error;

    public synchronized void getmaxnumvar(int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getmaxnumvar(this.native_task, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getmaxnumvar(long var1, IntBuffer var3) throws Error;

    public synchronized void getmemusage(long[] lArray, long[] lArray2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer2 = byteBuffer2.asLongBuffer();
        if (lArray2 != null && lArray2.length > 0) {
            longBuffer2.put(0, lArray2[0]);
        }
        this.p_getmemusagetask(this.native_task, longBuffer, longBuffer2);
        if (lArray2 != null && lArray2.length > 0) {
            lArray2[0] = longBuffer2.get(0);
        }
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getmemusagetask(long var1, LongBuffer var3, LongBuffer var4) throws Error;

    public synchronized void getnumanz(int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getnumanz(this.native_task, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getnumanz(long var1, IntBuffer var3) throws Error;

    public synchronized int getnumanz() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getnumanz(this.native_task, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getnumanz64(long[] lArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        this.p_getnumanz64(this.native_task, longBuffer);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getnumanz64(long var1, LongBuffer var3) throws Error;

    public synchronized long getnumanz64() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        this.p_getnumanz64(this.native_task, longBuffer);
        return longBuffer.get(0);
    }

    public synchronized void getnumbarablocktriplets(long[] lArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        this.p_getnumbarablocktriplets(this.native_task, longBuffer);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getnumbarablocktriplets(long var1, LongBuffer var3) throws Error;

    public synchronized long getnumbarablocktriplets() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        this.p_getnumbarablocktriplets(this.native_task, longBuffer);
        return longBuffer.get(0);
    }

    public synchronized void getnumbaranz(long[] lArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        this.p_getnumbaranz(this.native_task, longBuffer);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getnumbaranz(long var1, LongBuffer var3) throws Error;

    public synchronized long getnumbaranz() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        this.p_getnumbaranz(this.native_task, longBuffer);
        return longBuffer.get(0);
    }

    public synchronized void getnumbarcblocktriplets(long[] lArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        this.p_getnumbarcblocktriplets(this.native_task, longBuffer);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getnumbarcblocktriplets(long var1, LongBuffer var3) throws Error;

    public synchronized long getnumbarcblocktriplets() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        this.p_getnumbarcblocktriplets(this.native_task, longBuffer);
        return longBuffer.get(0);
    }

    public synchronized void getnumbarcnz(long[] lArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        this.p_getnumbarcnz(this.native_task, longBuffer);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getnumbarcnz(long var1, LongBuffer var3) throws Error;

    public synchronized long getnumbarcnz() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        this.p_getnumbarcnz(this.native_task, longBuffer);
        return longBuffer.get(0);
    }

    public synchronized void getnumbarvar(int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getnumbarvar(this.native_task, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getnumbarvar(long var1, IntBuffer var3) throws Error;

    public synchronized int getnumbarvar() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getnumbarvar(this.native_task, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getnumcon(int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getnumcon(this.native_task, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getnumcon(long var1, IntBuffer var3) throws Error;

    public synchronized int getnumcon() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getnumcon(this.native_task, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getnumcone(int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getnumcone(this.native_task, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getnumcone(long var1, IntBuffer var3) throws Error;

    public synchronized int getnumcone() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getnumcone(this.native_task, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getnumconemem(int n, int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getnumconemem(this.native_task, n, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getnumconemem(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized void getnumintvar(int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getnumintvar(this.native_task, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getnumintvar(long var1, IntBuffer var3) throws Error;

    public synchronized void getnumparam(parametertype parametertype2, int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getnumparam(this.native_task, parametertype2.getValue(), intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getnumparam(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized void getnumqconknz(int n, long[] lArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        this.p_getnumqconknz64(this.native_task, n, longBuffer);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getnumqconknz64(long var1, int var3, LongBuffer var4) throws Error;

    public synchronized long getnumqconknz(int n) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        this.p_getnumqconknz64(this.native_task, n, longBuffer);
        return longBuffer.get(0);
    }

    public synchronized void getnumqobjnz(long[] lArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        this.p_getnumqobjnz64(this.native_task, longBuffer);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getnumqobjnz64(long var1, LongBuffer var3) throws Error;

    public synchronized long getnumqobjnz() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        this.p_getnumqobjnz64(this.native_task, longBuffer);
        return longBuffer.get(0);
    }

    public synchronized void getnumsymmat(long[] lArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        this.p_getnumsymmat(this.native_task, longBuffer);
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getnumsymmat(long var1, LongBuffer var3) throws Error;

    public synchronized void getnumvar(int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getnumvar(this.native_task, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getnumvar(long var1, IntBuffer var3) throws Error;

    public synchronized int getnumvar() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getnumvar(this.native_task, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getobjname(StringBuffer stringBuffer) throws Error {
        int n = 1 + this.getobjnamelen();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n + 1);
        this.p_getobjname(this.native_task, n, byteBuffer);
        byte[] byArray = new byte[n + 1];
        byteBuffer.get(byArray);
        try {
            stringBuffer.append(new String(byArray, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private native void p_getobjname(long var1, int var3, ByteBuffer var4) throws Error;

    public synchronized String getobjname() throws Error {
        int n = 1 + this.getobjnamelen();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n + 1);
        this.p_getobjname(this.native_task, n, byteBuffer);
        byte[] byArray = new byte[n + 1];
        byteBuffer.get(byArray);
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void getobjnamelen(int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getobjnamelen(this.native_task, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getobjnamelen(long var1, IntBuffer var3) throws Error;

    public synchronized int getobjnamelen() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getobjnamelen(this.native_task, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getobjsense(objsense[] objsenseArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getobjsense(this.native_task, intBuffer);
        if (objsenseArray != null && objsenseArray.length > 0) {
            objsenseArray[0] = objsense.fromValue(intBuffer.get(0));
        }
    }

    private native void p_getobjsense(long var1, IntBuffer var3) throws Error;

    public synchronized objsense getobjsense() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getobjsense(this.native_task, intBuffer);
        return objsense.fromValue(intBuffer.get());
    }

    public synchronized void getparammax(parametertype parametertype2, int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getparammax(this.native_task, parametertype2.getValue(), intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getparammax(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized void getparamname(parametertype parametertype2, int n, StringBuffer stringBuffer) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1025);
        this.p_getparamname(this.native_task, parametertype2.getValue(), n, byteBuffer);
        byte[] byArray = new byte[1025];
        byteBuffer.get(byArray);
        try {
            stringBuffer.append(new String(byArray, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private native void p_getparamname(long var1, int var3, int var4, ByteBuffer var5) throws Error;

    public synchronized void getprimalobj(soltype soltype2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        this.p_getprimalobj(this.native_task, soltype2.getValue(), doubleBuffer);
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
    }

    private native void p_getprimalobj(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized double getprimalobj(soltype soltype2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        this.p_getprimalobj(this.native_task, soltype2.getValue(), doubleBuffer);
        return doubleBuffer.get(0);
    }

    public synchronized void getprimalsolutionnorms(soltype soltype2, double[] dArray, double[] dArray2, double[] dArray3) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer2 = byteBuffer2.asDoubleBuffer();
        if (dArray2 != null && dArray2.length > 0) {
            doubleBuffer2.put(0, dArray2[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(8);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer3 = byteBuffer3.asDoubleBuffer();
        if (dArray3 != null && dArray3.length > 0) {
            doubleBuffer3.put(0, dArray3[0]);
        }
        this.p_getprimalsolutionnorms(this.native_task, soltype2.getValue(), doubleBuffer, doubleBuffer2, doubleBuffer3);
        if (dArray3 != null && dArray3.length > 0) {
            dArray3[0] = doubleBuffer3.get(0);
        }
        if (dArray2 != null && dArray2.length > 0) {
            dArray2[0] = doubleBuffer2.get(0);
        }
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
    }

    private native void p_getprimalsolutionnorms(long var1, int var3, DoubleBuffer var4, DoubleBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void getprobtype(problemtype[] problemtypeArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getprobtype(this.native_task, intBuffer);
        if (problemtypeArray != null && problemtypeArray.length > 0) {
            problemtypeArray[0] = problemtype.fromValue(intBuffer.get(0));
        }
    }

    private native void p_getprobtype(long var1, IntBuffer var3) throws Error;

    public synchronized problemtype getprobtype() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getprobtype(this.native_task, intBuffer);
        return problemtype.fromValue(intBuffer.get());
    }

    public synchronized void getprosta(soltype soltype2, prosta[] prostaArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getprosta(this.native_task, soltype2.getValue(), intBuffer);
        if (prostaArray != null && prostaArray.length > 0) {
            prostaArray[0] = prosta.fromValue(intBuffer.get(0));
        }
    }

    private native void p_getprosta(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized prosta getprosta(soltype soltype2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getprosta(this.native_task, soltype2.getValue(), intBuffer);
        return prosta.fromValue(intBuffer.get());
    }

    public synchronized void getpviolbarvar(soltype soltype2, int[] nArray, double[] dArray) throws Error {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getpviolbarvar", "viol");
        }
        this.p_getpviolbarvar(this.native_task, soltype2.getValue(), n, intBuffer, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getpviolbarvar(long var1, int var3, int var4, IntBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void getpviolcon(soltype soltype2, int[] nArray, double[] dArray) throws Error {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getpviolcon", "viol");
        }
        this.p_getpviolcon(this.native_task, soltype2.getValue(), n, intBuffer, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getpviolcon(long var1, int var3, int var4, IntBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void getpviolcones(soltype soltype2, int[] nArray, double[] dArray) throws Error {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getpviolcones", "viol");
        }
        this.p_getpviolcones(this.native_task, soltype2.getValue(), n, intBuffer, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getpviolcones(long var1, int var3, int var4, IntBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void getpviolvar(soltype soltype2, int[] nArray, double[] dArray) throws Error {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getpviolvar", "viol");
        }
        this.p_getpviolvar(this.native_task, soltype2.getValue(), n, intBuffer, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getpviolvar(long var1, int var3, int var4, IntBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void getqconk(int n, long[] lArray, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        int n2;
        long l = this.getnumqconknz(n);
        int n3 = n2 = nArray == null ? 0 : nArray.length;
        if (nArray2 != null) {
            n2 = Math.min(n2, nArray2.length);
        }
        if (dArray != null) {
            n2 = Math.min(n2, dArray.length);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        if (nArray == null) {
            throw new NullPointerException("Argument qcsubi must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer2.asIntBuffer();
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument qcsubj must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (dArray == null) {
            throw new NullPointerException("Argument qcval must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (nArray != null && (long)nArray.length < this.getnumqconknz(n)) {
            throw new ArrayLengthException("getqconk64", "qcsubi");
        }
        if (nArray2 != null && (long)nArray2.length < this.getnumqconknz(n)) {
            throw new ArrayLengthException("getqconk64", "qcsubj");
        }
        if (dArray != null && (long)dArray.length < this.getnumqconknz(n)) {
            throw new ArrayLengthException("getqconk64", "qcval");
        }
        this.p_getqconk64(this.native_task, n, l, n2, longBuffer, intBuffer, intBuffer3, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.get(nArray2);
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.get(nArray);
        }
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getqconk64(long var1, int var3, long var4, int var6, LongBuffer var7, IntBuffer var8, IntBuffer var9, DoubleBuffer var10) throws Error;

    public synchronized long getqconk(int n, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        int n2;
        long l = this.getnumqconknz(n);
        int n3 = n2 = nArray == null ? 0 : nArray.length;
        if (nArray2 != null) {
            n2 = Math.min(n2, nArray2.length);
        }
        if (dArray != null) {
            n2 = Math.min(n2, dArray.length);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (nArray == null) {
            throw new NullPointerException("Argument qcsubi must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer2.asIntBuffer();
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument qcsubj must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (dArray == null) {
            throw new NullPointerException("Argument qcval must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (nArray != null && (long)nArray.length < this.getnumqconknz(n)) {
            throw new ArrayLengthException("getqconk64", "qcsubi");
        }
        if (nArray2 != null && (long)nArray2.length < this.getnumqconknz(n)) {
            throw new ArrayLengthException("getqconk64", "qcsubj");
        }
        if (dArray != null && (long)dArray.length < this.getnumqconknz(n)) {
            throw new ArrayLengthException("getqconk64", "qcval");
        }
        this.p_getqconk64(this.native_task, n, l, n2, longBuffer, intBuffer, intBuffer3, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.get(nArray2);
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.get(nArray);
        }
        return longBuffer.get(0);
    }

    public synchronized void getqobj(long[] lArray, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        int n;
        long l = this.getnumqobjnz();
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray2 != null) {
            n = Math.min(n, nArray2.length);
        }
        if (dArray != null) {
            n = Math.min(n, dArray.length);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        if (nArray == null) {
            throw new NullPointerException("Argument qosubi must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer2.asIntBuffer();
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument qosubj must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (dArray == null) {
            throw new NullPointerException("Argument qoval must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getqobj64", "qosubi");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getqobj64", "qosubj");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getqobj64", "qoval");
        }
        this.p_getqobj64(this.native_task, l, n, longBuffer, intBuffer, intBuffer3, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.get(nArray2);
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.get(nArray);
        }
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
    }

    private native void p_getqobj64(long var1, long var3, int var5, LongBuffer var6, IntBuffer var7, IntBuffer var8, DoubleBuffer var9) throws Error;

    public synchronized void getqobjij(int n, int n2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        this.p_getqobjij(this.native_task, n, n2, doubleBuffer);
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
    }

    private native void p_getqobjij(long var1, int var3, int var4, DoubleBuffer var5) throws Error;

    public synchronized void getreducedcosts(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getreducedcosts", "redcosts");
        }
        this.p_getreducedcosts(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getreducedcosts(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void getskc(soltype soltype2, stakey[] stakeyArray) throws Error {
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (stakeyArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(stakeyArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            for (int i = 0; i < stakeyArray.length; ++i) {
                stakeyArray[i] = stakey.fromValue(intBuffer.get());
            }
        }
        if (stakeyArray != null && stakeyArray.length < this.getnumcon()) {
            throw new ArrayLengthException("getskc", "skc");
        }
        this.p_getskc(this.native_task, soltype2.getValue(), intBuffer);
    }

    private native void p_getskc(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized void getskcslice(soltype soltype2, int n, int n2, stakey[] stakeyArray) throws Error {
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (stakeyArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(stakeyArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            for (int i = 0; i < stakeyArray.length; ++i) {
                stakeyArray[i] = stakey.fromValue(intBuffer.get());
            }
        }
        if (stakeyArray != null && stakeyArray.length < n2 - n) {
            throw new ArrayLengthException("getskcslice", "skc");
        }
        this.p_getskcslice(this.native_task, soltype2.getValue(), n, n2, intBuffer);
    }

    private native void p_getskcslice(long var1, int var3, int var4, int var5, IntBuffer var6) throws Error;

    public synchronized void getskx(soltype soltype2, stakey[] stakeyArray) throws Error {
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (stakeyArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(stakeyArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            for (int i = 0; i < stakeyArray.length; ++i) {
                stakeyArray[i] = stakey.fromValue(intBuffer.get());
            }
        }
        if (stakeyArray != null && stakeyArray.length < this.getnumvar()) {
            throw new ArrayLengthException("getskx", "skx");
        }
        this.p_getskx(this.native_task, soltype2.getValue(), intBuffer);
    }

    private native void p_getskx(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized void getskxslice(soltype soltype2, int n, int n2, stakey[] stakeyArray) throws Error {
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (stakeyArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(stakeyArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            for (int i = 0; i < stakeyArray.length; ++i) {
                stakeyArray[i] = stakey.fromValue(intBuffer.get());
            }
        }
        if (stakeyArray != null && stakeyArray.length < n2 - n) {
            throw new ArrayLengthException("getskxslice", "skx");
        }
        this.p_getskxslice(this.native_task, soltype2.getValue(), n, n2, intBuffer);
    }

    private native void p_getskxslice(long var1, int var3, int var4, int var5, IntBuffer var6) throws Error;

    public synchronized void getslc(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument slc must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < this.getnumcon()) {
            throw new ArrayLengthException("getslc", "slc");
        }
        this.p_getslc(this.native_task, soltype2.getValue(), doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getslc(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void getslcslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getslcslice", "slc");
        }
        this.p_getslcslice(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getslcslice(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void getslx(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument slx must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < this.getnumvar()) {
            throw new ArrayLengthException("getslx", "slx");
        }
        this.p_getslx(this.native_task, soltype2.getValue(), doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getslx(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void getslxslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getslxslice", "slx");
        }
        this.p_getslxslice(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getslxslice(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void getsnx(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument snx must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < this.getnumvar()) {
            throw new ArrayLengthException("getsnx", "snx");
        }
        this.p_getsnx(this.native_task, soltype2.getValue(), doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getsnx(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void getsnxslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getsnxslice", "snx");
        }
        this.p_getsnxslice(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getsnxslice(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void getsolsta(soltype soltype2, solsta[] solstaArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getsolsta(this.native_task, soltype2.getValue(), intBuffer);
        if (solstaArray != null && solstaArray.length > 0) {
            solstaArray[0] = solsta.fromValue(intBuffer.get(0));
        }
    }

    private native void p_getsolsta(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized solsta getsolsta(soltype soltype2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getsolsta(this.native_task, soltype2.getValue(), intBuffer);
        return solsta.fromValue(intBuffer.get());
    }

    public synchronized void getsolution(soltype soltype2, prosta[] prostaArray, solsta[] solstaArray, stakey[] stakeyArray, stakey[] stakeyArray2, stakey[] stakeyArray3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer2.asIntBuffer();
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer3 = null;
        if (stakeyArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(stakeyArray.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer3 = byteBuffer3.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            for (int i = 0; i < stakeyArray.length; ++i) {
                stakeyArray[i] = stakey.fromValue(intBuffer3.get());
            }
        }
        ByteBuffer byteBuffer4 = null;
        IntBuffer intBuffer4 = null;
        if (stakeyArray2 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(stakeyArray2.length * 4);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer4 = byteBuffer4.asIntBuffer();
        }
        if (intBuffer4 != null) {
            intBuffer4.position(0);
            for (int i = 0; i < stakeyArray2.length; ++i) {
                stakeyArray2[i] = stakey.fromValue(intBuffer4.get());
            }
        }
        ByteBuffer byteBuffer5 = null;
        IntBuffer intBuffer5 = null;
        if (stakeyArray3 != null) {
            byteBuffer5 = ByteBuffer.allocateDirect(stakeyArray3.length * 4);
            byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer5 = byteBuffer5.asIntBuffer();
        }
        if (intBuffer5 != null) {
            intBuffer5.position(0);
            for (int i = 0; i < stakeyArray3.length; ++i) {
                stakeyArray3[i] = stakey.fromValue(intBuffer5.get());
            }
        }
        ByteBuffer byteBuffer6 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer6 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer6.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer = dArray == null ? null : byteBuffer6.asDoubleBuffer();
        }
        ByteBuffer byteBuffer7 = null;
        DoubleBuffer doubleBuffer2 = null;
        if (dArray2 != null) {
            byteBuffer7 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer7.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer2 = dArray2 == null ? null : byteBuffer7.asDoubleBuffer();
        }
        ByteBuffer byteBuffer8 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray3 != null) {
            byteBuffer8 = ByteBuffer.allocateDirect(dArray3.length * 8);
            byteBuffer8.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer3 = dArray3 == null ? null : byteBuffer8.asDoubleBuffer();
        }
        ByteBuffer byteBuffer9 = null;
        DoubleBuffer doubleBuffer4 = null;
        if (dArray4 != null) {
            byteBuffer9 = ByteBuffer.allocateDirect(dArray4.length * 8);
            byteBuffer9.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer4 = dArray4 == null ? null : byteBuffer9.asDoubleBuffer();
        }
        ByteBuffer byteBuffer10 = null;
        DoubleBuffer doubleBuffer5 = null;
        if (dArray5 != null) {
            byteBuffer10 = ByteBuffer.allocateDirect(dArray5.length * 8);
            byteBuffer10.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer5 = dArray5 == null ? null : byteBuffer10.asDoubleBuffer();
        }
        ByteBuffer byteBuffer11 = null;
        DoubleBuffer doubleBuffer6 = null;
        if (dArray6 != null) {
            byteBuffer11 = ByteBuffer.allocateDirect(dArray6.length * 8);
            byteBuffer11.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer6 = dArray6 == null ? null : byteBuffer11.asDoubleBuffer();
        }
        ByteBuffer byteBuffer12 = null;
        DoubleBuffer doubleBuffer7 = null;
        if (dArray7 != null) {
            byteBuffer12 = ByteBuffer.allocateDirect(dArray7.length * 8);
            byteBuffer12.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer7 = dArray7 == null ? null : byteBuffer12.asDoubleBuffer();
        }
        ByteBuffer byteBuffer13 = null;
        DoubleBuffer doubleBuffer8 = null;
        if (dArray8 != null) {
            byteBuffer13 = ByteBuffer.allocateDirect(dArray8.length * 8);
            byteBuffer13.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer9 = doubleBuffer8 = dArray8 == null ? null : byteBuffer13.asDoubleBuffer();
        }
        if (stakeyArray != null && stakeyArray.length < this.getnumcon()) {
            throw new ArrayLengthException("getsolution", "skc");
        }
        if (stakeyArray2 != null && stakeyArray2.length < this.getnumvar()) {
            throw new ArrayLengthException("getsolution", "skx");
        }
        if (stakeyArray3 != null && stakeyArray3.length < this.getnumcone()) {
            throw new ArrayLengthException("getsolution", "skn");
        }
        if (dArray != null && dArray.length < this.getnumcon()) {
            throw new ArrayLengthException("getsolution", "xc");
        }
        if (dArray2 != null && dArray2.length < this.getnumvar()) {
            throw new ArrayLengthException("getsolution", "xx");
        }
        if (dArray3 != null && dArray3.length < this.getnumcon()) {
            throw new ArrayLengthException("getsolution", "y");
        }
        if (dArray4 != null && dArray4.length < this.getnumcon()) {
            throw new ArrayLengthException("getsolution", "slc");
        }
        if (dArray5 != null && dArray5.length < this.getnumcon()) {
            throw new ArrayLengthException("getsolution", "suc");
        }
        if (dArray6 != null && dArray6.length < this.getnumvar()) {
            throw new ArrayLengthException("getsolution", "slx");
        }
        if (dArray7 != null && dArray7.length < this.getnumvar()) {
            throw new ArrayLengthException("getsolution", "sux");
        }
        if (dArray8 != null && dArray8.length < this.getnumvar()) {
            throw new ArrayLengthException("getsolution", "snx");
        }
        this.p_getsolution(this.native_task, soltype2.getValue(), intBuffer, intBuffer2, intBuffer3, intBuffer4, intBuffer5, doubleBuffer, doubleBuffer2, doubleBuffer3, doubleBuffer4, doubleBuffer5, doubleBuffer6, doubleBuffer7, doubleBuffer8);
        if (doubleBuffer8 != null) {
            doubleBuffer8.position(0);
            doubleBuffer8.get(dArray8);
        }
        if (doubleBuffer7 != null) {
            doubleBuffer7.position(0);
            doubleBuffer7.get(dArray7);
        }
        if (doubleBuffer6 != null) {
            doubleBuffer6.position(0);
            doubleBuffer6.get(dArray6);
        }
        if (doubleBuffer5 != null) {
            doubleBuffer5.position(0);
            doubleBuffer5.get(dArray5);
        }
        if (doubleBuffer4 != null) {
            doubleBuffer4.position(0);
            doubleBuffer4.get(dArray4);
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.get(dArray3);
        }
        if (doubleBuffer2 != null) {
            doubleBuffer2.position(0);
            doubleBuffer2.get(dArray2);
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (solstaArray != null && solstaArray.length > 0) {
            solstaArray[0] = solsta.fromValue(intBuffer2.get(0));
        }
        if (prostaArray != null && prostaArray.length > 0) {
            prostaArray[0] = prosta.fromValue(intBuffer.get(0));
        }
    }

    private native void p_getsolution(long var1, int var3, IntBuffer var4, IntBuffer var5, IntBuffer var6, IntBuffer var7, IntBuffer var8, DoubleBuffer var9, DoubleBuffer var10, DoubleBuffer var11, DoubleBuffer var12, DoubleBuffer var13, DoubleBuffer var14, DoubleBuffer var15, DoubleBuffer var16) throws Error;

    public synchronized void getsolutioni(accmode accmode2, int n, soltype soltype2, stakey[] stakeyArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer2.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(8);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer2 = byteBuffer3.asDoubleBuffer();
        if (dArray2 != null && dArray2.length > 0) {
            doubleBuffer2.put(0, dArray2[0]);
        }
        ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(8);
        byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer3 = byteBuffer4.asDoubleBuffer();
        if (dArray3 != null && dArray3.length > 0) {
            doubleBuffer3.put(0, dArray3[0]);
        }
        ByteBuffer byteBuffer5 = ByteBuffer.allocateDirect(8);
        byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer4 = byteBuffer5.asDoubleBuffer();
        if (dArray4 != null && dArray4.length > 0) {
            doubleBuffer4.put(0, dArray4[0]);
        }
        this.p_getsolutioni(this.native_task, accmode2.getValue(), n, soltype2.getValue(), intBuffer, doubleBuffer, doubleBuffer2, doubleBuffer3, doubleBuffer4);
        if (dArray4 != null && dArray4.length > 0) {
            dArray4[0] = doubleBuffer4.get(0);
        }
        if (dArray3 != null && dArray3.length > 0) {
            dArray3[0] = doubleBuffer3.get(0);
        }
        if (dArray2 != null && dArray2.length > 0) {
            dArray2[0] = doubleBuffer2.get(0);
        }
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
        if (stakeyArray != null && stakeyArray.length > 0) {
            stakeyArray[0] = stakey.fromValue(intBuffer.get(0));
        }
    }

    private native void p_getsolutioni(long var1, int var3, int var4, int var5, IntBuffer var6, DoubleBuffer var7, DoubleBuffer var8, DoubleBuffer var9, DoubleBuffer var10) throws Error;

    public synchronized void getsolutioninfo(soltype soltype2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double[] dArray9, double[] dArray10, double[] dArray11) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer2 = byteBuffer2.asDoubleBuffer();
        if (dArray2 != null && dArray2.length > 0) {
            doubleBuffer2.put(0, dArray2[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(8);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer3 = byteBuffer3.asDoubleBuffer();
        if (dArray3 != null && dArray3.length > 0) {
            doubleBuffer3.put(0, dArray3[0]);
        }
        ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(8);
        byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer4 = byteBuffer4.asDoubleBuffer();
        if (dArray4 != null && dArray4.length > 0) {
            doubleBuffer4.put(0, dArray4[0]);
        }
        ByteBuffer byteBuffer5 = ByteBuffer.allocateDirect(8);
        byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer5 = byteBuffer5.asDoubleBuffer();
        if (dArray5 != null && dArray5.length > 0) {
            doubleBuffer5.put(0, dArray5[0]);
        }
        ByteBuffer byteBuffer6 = ByteBuffer.allocateDirect(8);
        byteBuffer6.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer6 = byteBuffer6.asDoubleBuffer();
        if (dArray6 != null && dArray6.length > 0) {
            doubleBuffer6.put(0, dArray6[0]);
        }
        ByteBuffer byteBuffer7 = ByteBuffer.allocateDirect(8);
        byteBuffer7.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer7 = byteBuffer7.asDoubleBuffer();
        if (dArray7 != null && dArray7.length > 0) {
            doubleBuffer7.put(0, dArray7[0]);
        }
        ByteBuffer byteBuffer8 = ByteBuffer.allocateDirect(8);
        byteBuffer8.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer8 = byteBuffer8.asDoubleBuffer();
        if (dArray8 != null && dArray8.length > 0) {
            doubleBuffer8.put(0, dArray8[0]);
        }
        ByteBuffer byteBuffer9 = ByteBuffer.allocateDirect(8);
        byteBuffer9.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer9 = byteBuffer9.asDoubleBuffer();
        if (dArray9 != null && dArray9.length > 0) {
            doubleBuffer9.put(0, dArray9[0]);
        }
        ByteBuffer byteBuffer10 = ByteBuffer.allocateDirect(8);
        byteBuffer10.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer10 = byteBuffer10.asDoubleBuffer();
        if (dArray10 != null && dArray10.length > 0) {
            doubleBuffer10.put(0, dArray10[0]);
        }
        ByteBuffer byteBuffer11 = ByteBuffer.allocateDirect(8);
        byteBuffer11.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer11 = byteBuffer11.asDoubleBuffer();
        if (dArray11 != null && dArray11.length > 0) {
            doubleBuffer11.put(0, dArray11[0]);
        }
        this.p_getsolutioninfo(this.native_task, soltype2.getValue(), doubleBuffer, doubleBuffer2, doubleBuffer3, doubleBuffer4, doubleBuffer5, doubleBuffer6, doubleBuffer7, doubleBuffer8, doubleBuffer9, doubleBuffer10, doubleBuffer11);
        if (dArray11 != null && dArray11.length > 0) {
            dArray11[0] = doubleBuffer11.get(0);
        }
        if (dArray10 != null && dArray10.length > 0) {
            dArray10[0] = doubleBuffer10.get(0);
        }
        if (dArray9 != null && dArray9.length > 0) {
            dArray9[0] = doubleBuffer9.get(0);
        }
        if (dArray8 != null && dArray8.length > 0) {
            dArray8[0] = doubleBuffer8.get(0);
        }
        if (dArray7 != null && dArray7.length > 0) {
            dArray7[0] = doubleBuffer7.get(0);
        }
        if (dArray6 != null && dArray6.length > 0) {
            dArray6[0] = doubleBuffer6.get(0);
        }
        if (dArray5 != null && dArray5.length > 0) {
            dArray5[0] = doubleBuffer5.get(0);
        }
        if (dArray4 != null && dArray4.length > 0) {
            dArray4[0] = doubleBuffer4.get(0);
        }
        if (dArray3 != null && dArray3.length > 0) {
            dArray3[0] = doubleBuffer3.get(0);
        }
        if (dArray2 != null && dArray2.length > 0) {
            dArray2[0] = doubleBuffer2.get(0);
        }
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
    }

    private native void p_getsolutioninfo(long var1, int var3, DoubleBuffer var4, DoubleBuffer var5, DoubleBuffer var6, DoubleBuffer var7, DoubleBuffer var8, DoubleBuffer var9, DoubleBuffer var10, DoubleBuffer var11, DoubleBuffer var12, DoubleBuffer var13, DoubleBuffer var14) throws Error;

    public synchronized void getsolutionslice(soltype soltype2, solitem solitem2, int n, int n2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getsolutionslice", "values");
        }
        this.p_getsolutionslice(this.native_task, soltype2.getValue(), solitem2.getValue(), n, n2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getsolutionslice(long var1, int var3, int var4, int var5, int var6, DoubleBuffer var7) throws Error;

    public synchronized void getsparsesymmat(long l, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        long l2;
        LongBuffer longBuffer = LongBuffer.allocate(1);
        this.p_getsymmatinfo(this.native_task, l, null, longBuffer, null);
        long l3 = l2 = longBuffer.get(0);
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer2 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer2 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (nArray != null && (long)nArray.length < l3) {
            throw new ArrayLengthException("getsparsesymmat", "subi");
        }
        if (nArray2 != null && (long)nArray2.length < l3) {
            throw new ArrayLengthException("getsparsesymmat", "subj");
        }
        if (dArray != null && (long)dArray.length < l3) {
            throw new ArrayLengthException("getsparsesymmat", "valij");
        }
        this.p_getsparsesymmat(this.native_task, l, l3, intBuffer, intBuffer2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (intBuffer2 != null) {
            intBuffer2.position(0);
            intBuffer2.get(nArray2);
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.get(nArray);
        }
    }

    private native void p_getsparsesymmat(long var1, long var3, long var5, IntBuffer var7, IntBuffer var8, DoubleBuffer var9) throws Error;

    public synchronized void getstrparam(sparam sparam2, int[] nArray, StringBuffer stringBuffer) throws Error {
        int n = 1 + this.getstrparamlen(sparam2);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n + 1);
        this.p_getstrparam(this.native_task, sparam2.getValue(), n, intBuffer, byteBuffer2);
        byte[] byArray = new byte[n + 1];
        byteBuffer2.get(byArray);
        try {
            stringBuffer.append(new String(byArray, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getstrparam(long var1, int var3, int var4, IntBuffer var5, ByteBuffer var6) throws Error;

    public synchronized String getstrparam(sparam sparam2, int[] nArray) throws Error {
        int n = 1 + this.getstrparamlen(sparam2);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n + 1);
        this.p_getstrparam(this.native_task, sparam2.getValue(), n, intBuffer, byteBuffer2);
        byte[] byArray = new byte[n + 1];
        byteBuffer2.get(byArray);
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
        return string;
    }

    public synchronized void getstrparamlen(sparam sparam2, int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getstrparamlen(this.native_task, sparam2.getValue(), intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getstrparamlen(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized int getstrparamlen(sparam sparam2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getstrparamlen(this.native_task, sparam2.getValue(), intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getsuc(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument suc must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < this.getnumcon()) {
            throw new ArrayLengthException("getsuc", "suc");
        }
        this.p_getsuc(this.native_task, soltype2.getValue(), doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getsuc(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void getsucslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getsucslice", "suc");
        }
        this.p_getsucslice(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getsucslice(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void getsux(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument sux must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < this.getnumvar()) {
            throw new ArrayLengthException("getsux", "sux");
        }
        this.p_getsux(this.native_task, soltype2.getValue(), doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getsux(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void getsuxslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getsuxslice", "sux");
        }
        this.p_getsuxslice(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getsuxslice(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void getsymmatinfo(long l, int[] nArray, long[] lArray, symmattype[] symmattypeArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer2.asLongBuffer();
        if (lArray != null && lArray.length > 0) {
            longBuffer.put(0, lArray[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(4);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer3.asIntBuffer();
        this.p_getsymmatinfo(this.native_task, l, intBuffer, longBuffer, intBuffer2);
        if (symmattypeArray != null && symmattypeArray.length > 0) {
            symmattypeArray[0] = symmattype.fromValue(intBuffer2.get(0));
        }
        if (lArray != null && lArray.length > 0) {
            lArray[0] = longBuffer.get(0);
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getsymmatinfo(long var1, long var3, IntBuffer var5, LongBuffer var6, IntBuffer var7) throws Error;

    public synchronized void gettaskname(StringBuffer stringBuffer) throws Error {
        int n = 1 + this.gettasknamelen();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n + 1);
        this.p_gettaskname(this.native_task, n, byteBuffer);
        byte[] byArray = new byte[n + 1];
        byteBuffer.get(byArray);
        try {
            stringBuffer.append(new String(byArray, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private native void p_gettaskname(long var1, int var3, ByteBuffer var4) throws Error;

    public synchronized String gettaskname() throws Error {
        int n = 1 + this.gettasknamelen();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n + 1);
        this.p_gettaskname(this.native_task, n, byteBuffer);
        byte[] byArray = new byte[n + 1];
        byteBuffer.get(byArray);
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void gettasknamelen(int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_gettasknamelen(this.native_task, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_gettasknamelen(long var1, IntBuffer var3) throws Error;

    public synchronized int gettasknamelen() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_gettasknamelen(this.native_task, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getvarbound(int n, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer = byteBuffer2.asDoubleBuffer();
        if (dArray != null && dArray.length > 0) {
            doubleBuffer.put(0, dArray[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(8);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer2 = byteBuffer3.asDoubleBuffer();
        if (dArray2 != null && dArray2.length > 0) {
            doubleBuffer2.put(0, dArray2[0]);
        }
        this.p_getvarbound(this.native_task, n, intBuffer, doubleBuffer, doubleBuffer2);
        if (dArray2 != null && dArray2.length > 0) {
            dArray2[0] = doubleBuffer2.get(0);
        }
        if (dArray != null && dArray.length > 0) {
            dArray[0] = doubleBuffer.get(0);
        }
        if (boundkeyArray != null && boundkeyArray.length > 0) {
            boundkeyArray[0] = boundkey.fromValue(intBuffer.get(0));
        }
    }

    private native void p_getvarbound(long var1, int var3, IntBuffer var4, DoubleBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void getvarboundslice(int n, int n2, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (boundkeyArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(boundkeyArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            for (int i = 0; i < boundkeyArray.length; ++i) {
                boundkeyArray[i] = boundkey.fromValue(intBuffer.get());
            }
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer2 = null;
        if (dArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer3 = doubleBuffer2 = dArray2 == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (boundkeyArray != null && boundkeyArray.length < n2 - n) {
            throw new ArrayLengthException("getvarboundslice", "bk");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getvarboundslice", "bl");
        }
        if (dArray2 != null && dArray2.length < n2 - n) {
            throw new ArrayLengthException("getvarboundslice", "bu");
        }
        this.p_getvarboundslice(this.native_task, n, n2, intBuffer, doubleBuffer, doubleBuffer2);
        if (doubleBuffer2 != null) {
            doubleBuffer2.position(0);
            doubleBuffer2.get(dArray2);
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getvarboundslice(long var1, int var3, int var4, IntBuffer var5, DoubleBuffer var6, DoubleBuffer var7) throws Error;

    public synchronized void getvarname(int n, StringBuffer stringBuffer) throws Error {
        int n2 = 1 + this.getvarnamelen(n);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 + 1);
        this.p_getvarname(this.native_task, n, n2, byteBuffer);
        byte[] byArray = new byte[n2 + 1];
        byteBuffer.get(byArray);
        try {
            stringBuffer.append(new String(byArray, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private native void p_getvarname(long var1, int var3, int var4, ByteBuffer var5) throws Error;

    public synchronized String getvarname(int n) throws Error {
        int n2 = 1 + this.getvarnamelen(n);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 + 1);
        this.p_getvarname(this.native_task, n, n2, byteBuffer);
        byte[] byArray = new byte[n2 + 1];
        byteBuffer.get(byArray);
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void getvarnameindex(String string, int[] nArray, int[] nArray2) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer2.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(4);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer3.asIntBuffer();
        if (nArray2 != null && nArray2.length > 0) {
            intBuffer2.put(0, nArray2[0]);
        }
        this.p_getvarnameindex(this.native_task, byteBuffer, intBuffer, intBuffer2);
        if (nArray2 != null && nArray2.length > 0) {
            nArray2[0] = intBuffer2.get(0);
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getvarnameindex(long var1, ByteBuffer var3, IntBuffer var4, IntBuffer var5) throws Error;

    public synchronized int getvarnameindex(String string, int[] nArray) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer2.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(4);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer3.asIntBuffer();
        this.p_getvarnameindex(this.native_task, byteBuffer, intBuffer, intBuffer2);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
        return intBuffer2.get(0);
    }

    public synchronized void getvarnamelen(int n, int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getvarnamelen(this.native_task, n, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getvarnamelen(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized int getvarnamelen(int n) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getvarnamelen(this.native_task, n, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void getvartype(int n, variabletype[] variabletypeArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getvartype(this.native_task, n, intBuffer);
        if (variabletypeArray != null && variabletypeArray.length > 0) {
            variabletypeArray[0] = variabletype.fromValue(intBuffer.get(0));
        }
    }

    private native void p_getvartype(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized variabletype getvartype(int n) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getvartype(this.native_task, n, intBuffer);
        return variabletype.fromValue(intBuffer.get());
    }

    public synchronized void getvartypelist(int[] nArray, variabletype[] variabletypeArray) throws Error {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument subj must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (variabletypeArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(variabletypeArray.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer3 = byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            for (int i = 0; i < variabletypeArray.length; ++i) {
                variabletypeArray[i] = variabletype.fromValue(intBuffer3.get());
            }
        }
        if (variabletypeArray != null && variabletypeArray.length < n) {
            throw new ArrayLengthException("getvartypelist", "vartype");
        }
        this.p_getvartypelist(this.native_task, n, intBuffer, intBuffer3);
    }

    private native void p_getvartypelist(long var1, int var3, IntBuffer var4, IntBuffer var5) throws Error;

    public synchronized void getxc(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument xc must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < this.getnumcon()) {
            throw new ArrayLengthException("getxc", "xc");
        }
        this.p_getxc(this.native_task, soltype2.getValue(), doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getxc(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void getxcslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getxcslice", "xc");
        }
        this.p_getxcslice(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getxcslice(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void getxx(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument xx must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < this.getnumvar()) {
            throw new ArrayLengthException("getxx", "xx");
        }
        this.p_getxx(this.native_task, soltype2.getValue(), doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getxx(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void getxxslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getxxslice", "xx");
        }
        this.p_getxxslice(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getxxslice(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void gety(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument y must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < this.getnumcon()) {
            throw new ArrayLengthException("gety", "y");
        }
        this.p_gety(this.native_task, soltype2.getValue(), doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_gety(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void getyslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getyslice", "y");
        }
        this.p_getyslice(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_getyslice(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void initbasissolve(int[] nArray) throws Error {
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (nArray != null && nArray.length < this.getnumcon()) {
            throw new ArrayLengthException("initbasissolve", "basis");
        }
        this.p_initbasissolve(this.native_task, intBuffer);
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.get(nArray);
        }
    }

    private native void p_initbasissolve(long var1, IntBuffer var3) throws Error;

    public synchronized void inputdata(int n, int n2, double[] dArray, double d, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray2, boundkey[] boundkeyArray, double[] dArray3, double[] dArray4, boundkey[] boundkeyArray2, double[] dArray5, double[] dArray6) throws Error {
        int n3 = dArray4 == null ? 0 : dArray4.length;
        if (n3 != (dArray3 == null ? 0 : dArray3.length)) {
            throw new ArrayLengthException("inputdata", "numcon");
        }
        if (n3 != (boundkeyArray == null ? 0 : boundkeyArray.length)) {
            throw new ArrayLengthException("inputdata", "numcon");
        }
        int n4 = dArray == null ? 0 : dArray.length;
        if (n4 != (dArray6 == null ? 0 : dArray6.length)) {
            throw new ArrayLengthException("inputdata", "numvar");
        }
        if (n4 != (dArray5 == null ? 0 : dArray5.length)) {
            throw new ArrayLengthException("inputdata", "numvar");
        }
        if (n4 != (boundkeyArray2 == null ? 0 : boundkeyArray2.length)) {
            throw new ArrayLengthException("inputdata", "numvar");
        }
        if (n4 != (nArray == null ? 0 : nArray.length)) {
            throw new ArrayLengthException("inputdata", "numvar");
        }
        if (n4 != (nArray2 == null ? 0 : nArray2.length)) {
            throw new ArrayLengthException("inputdata", "numvar");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (nArray == null) {
            throw new NullPointerException("Argument aptrb must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer2.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument aptre must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.put(nArray2);
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument asub must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        IntBuffer intBuffer5 = null;
        if (nArray3 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(nArray3.length * 4);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer6 = intBuffer5 = nArray3 == null ? null : byteBuffer4.asIntBuffer();
        }
        if (intBuffer5 != null) {
            intBuffer5.position(0);
            intBuffer5.put(nArray3);
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument aval must not be null");
        }
        ByteBuffer byteBuffer5 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer5 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer5.asDoubleBuffer();
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.put(dArray2);
        }
        if (boundkeyArray == null) {
            throw new NullPointerException("Argument bkc must not be null");
        }
        ByteBuffer byteBuffer6 = null;
        IntBuffer intBuffer7 = null;
        if (boundkeyArray != null) {
            byteBuffer6 = ByteBuffer.allocateDirect(boundkeyArray.length * 4);
            byteBuffer6.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer7 = byteBuffer6.asIntBuffer();
        }
        if (intBuffer7 != null) {
            intBuffer7.position(0);
            for (int i = 0; i < boundkeyArray.length; ++i) {
                intBuffer7.put(boundkeyArray[i].getValue());
            }
        }
        if (dArray3 == null) {
            throw new NullPointerException("Argument blc must not be null");
        }
        ByteBuffer byteBuffer7 = null;
        DoubleBuffer doubleBuffer5 = null;
        if (dArray3 != null) {
            byteBuffer7 = ByteBuffer.allocateDirect(dArray3.length * 8);
            byteBuffer7.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer6 = doubleBuffer5 = dArray3 == null ? null : byteBuffer7.asDoubleBuffer();
        }
        if (doubleBuffer5 != null) {
            doubleBuffer5.position(0);
            doubleBuffer5.put(dArray3);
        }
        if (dArray4 == null) {
            throw new NullPointerException("Argument buc must not be null");
        }
        ByteBuffer byteBuffer8 = null;
        DoubleBuffer doubleBuffer7 = null;
        if (dArray4 != null) {
            byteBuffer8 = ByteBuffer.allocateDirect(dArray4.length * 8);
            byteBuffer8.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer8 = doubleBuffer7 = dArray4 == null ? null : byteBuffer8.asDoubleBuffer();
        }
        if (doubleBuffer7 != null) {
            doubleBuffer7.position(0);
            doubleBuffer7.put(dArray4);
        }
        if (boundkeyArray2 == null) {
            throw new NullPointerException("Argument bkx must not be null");
        }
        ByteBuffer byteBuffer9 = null;
        IntBuffer intBuffer8 = null;
        if (boundkeyArray2 != null) {
            byteBuffer9 = ByteBuffer.allocateDirect(boundkeyArray2.length * 4);
            byteBuffer9.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer8 = byteBuffer9.asIntBuffer();
        }
        if (intBuffer8 != null) {
            intBuffer8.position(0);
            for (int i = 0; i < boundkeyArray2.length; ++i) {
                intBuffer8.put(boundkeyArray2[i].getValue());
            }
        }
        if (dArray5 == null) {
            throw new NullPointerException("Argument blx must not be null");
        }
        ByteBuffer byteBuffer10 = null;
        DoubleBuffer doubleBuffer9 = null;
        if (dArray5 != null) {
            byteBuffer10 = ByteBuffer.allocateDirect(dArray5.length * 8);
            byteBuffer10.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer10 = doubleBuffer9 = dArray5 == null ? null : byteBuffer10.asDoubleBuffer();
        }
        if (doubleBuffer9 != null) {
            doubleBuffer9.position(0);
            doubleBuffer9.put(dArray5);
        }
        if (dArray6 == null) {
            throw new NullPointerException("Argument bux must not be null");
        }
        ByteBuffer byteBuffer11 = null;
        DoubleBuffer doubleBuffer11 = null;
        if (dArray6 != null) {
            byteBuffer11 = ByteBuffer.allocateDirect(dArray6.length * 8);
            byteBuffer11.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer12 = doubleBuffer11 = dArray6 == null ? null : byteBuffer11.asDoubleBuffer();
        }
        if (doubleBuffer11 != null) {
            doubleBuffer11.position(0);
            doubleBuffer11.put(dArray6);
        }
        this.p_inputdata(this.native_task, n, n2, n3, n4, doubleBuffer, d, intBuffer, intBuffer3, intBuffer5, doubleBuffer3, intBuffer7, doubleBuffer5, doubleBuffer7, intBuffer8, doubleBuffer9, doubleBuffer11);
    }

    private native void p_inputdata(long var1, int var3, int var4, int var5, int var6, DoubleBuffer var7, double var8, IntBuffer var10, IntBuffer var11, IntBuffer var12, DoubleBuffer var13, IntBuffer var14, DoubleBuffer var15, DoubleBuffer var16, IntBuffer var17, DoubleBuffer var18, DoubleBuffer var19) throws Error;

    public synchronized void inputdata(int n, int n2, double[] dArray, double d, long[] lArray, long[] lArray2, int[] nArray, double[] dArray2, boundkey[] boundkeyArray, double[] dArray3, double[] dArray4, boundkey[] boundkeyArray2, double[] dArray5, double[] dArray6) throws Error {
        int n3 = dArray4 == null ? 0 : dArray4.length;
        if (n3 != (dArray3 == null ? 0 : dArray3.length)) {
            throw new ArrayLengthException("inputdata64", "numcon");
        }
        if (n3 != (boundkeyArray == null ? 0 : boundkeyArray.length)) {
            throw new ArrayLengthException("inputdata64", "numcon");
        }
        int n4 = dArray == null ? 0 : dArray.length;
        if (n4 != (dArray6 == null ? 0 : dArray6.length)) {
            throw new ArrayLengthException("inputdata64", "numvar");
        }
        if (n4 != (dArray5 == null ? 0 : dArray5.length)) {
            throw new ArrayLengthException("inputdata64", "numvar");
        }
        if (n4 != (boundkeyArray2 == null ? 0 : boundkeyArray2.length)) {
            throw new ArrayLengthException("inputdata64", "numvar");
        }
        if (n4 != (lArray == null ? 0 : lArray.length)) {
            throw new ArrayLengthException("inputdata64", "numvar");
        }
        if (n4 != (lArray2 == null ? 0 : lArray2.length)) {
            throw new ArrayLengthException("inputdata64", "numvar");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (lArray == null) {
            throw new NullPointerException("Argument aptrb must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        LongBuffer longBuffer = null;
        if (lArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(lArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            LongBuffer longBuffer2 = longBuffer = lArray == null ? null : byteBuffer2.asLongBuffer();
        }
        if (longBuffer != null) {
            longBuffer.position(0);
            longBuffer.put(lArray);
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument aptre must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        LongBuffer longBuffer3 = null;
        if (lArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(lArray2.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            LongBuffer longBuffer4 = longBuffer3 = lArray2 == null ? null : byteBuffer3.asLongBuffer();
        }
        if (longBuffer3 != null) {
            longBuffer3.position(0);
            longBuffer3.put(lArray2);
        }
        if (nArray == null) {
            throw new NullPointerException("Argument asub must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer4.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument aval must not be null");
        }
        ByteBuffer byteBuffer5 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer5 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer5.asDoubleBuffer();
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.put(dArray2);
        }
        if (boundkeyArray == null) {
            throw new NullPointerException("Argument bkc must not be null");
        }
        ByteBuffer byteBuffer6 = null;
        IntBuffer intBuffer3 = null;
        if (boundkeyArray != null) {
            byteBuffer6 = ByteBuffer.allocateDirect(boundkeyArray.length * 4);
            byteBuffer6.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer3 = byteBuffer6.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            for (int i = 0; i < boundkeyArray.length; ++i) {
                intBuffer3.put(boundkeyArray[i].getValue());
            }
        }
        if (dArray3 == null) {
            throw new NullPointerException("Argument blc must not be null");
        }
        ByteBuffer byteBuffer7 = null;
        DoubleBuffer doubleBuffer5 = null;
        if (dArray3 != null) {
            byteBuffer7 = ByteBuffer.allocateDirect(dArray3.length * 8);
            byteBuffer7.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer6 = doubleBuffer5 = dArray3 == null ? null : byteBuffer7.asDoubleBuffer();
        }
        if (doubleBuffer5 != null) {
            doubleBuffer5.position(0);
            doubleBuffer5.put(dArray3);
        }
        if (dArray4 == null) {
            throw new NullPointerException("Argument buc must not be null");
        }
        ByteBuffer byteBuffer8 = null;
        DoubleBuffer doubleBuffer7 = null;
        if (dArray4 != null) {
            byteBuffer8 = ByteBuffer.allocateDirect(dArray4.length * 8);
            byteBuffer8.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer8 = doubleBuffer7 = dArray4 == null ? null : byteBuffer8.asDoubleBuffer();
        }
        if (doubleBuffer7 != null) {
            doubleBuffer7.position(0);
            doubleBuffer7.put(dArray4);
        }
        if (boundkeyArray2 == null) {
            throw new NullPointerException("Argument bkx must not be null");
        }
        ByteBuffer byteBuffer9 = null;
        IntBuffer intBuffer4 = null;
        if (boundkeyArray2 != null) {
            byteBuffer9 = ByteBuffer.allocateDirect(boundkeyArray2.length * 4);
            byteBuffer9.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer4 = byteBuffer9.asIntBuffer();
        }
        if (intBuffer4 != null) {
            intBuffer4.position(0);
            for (int i = 0; i < boundkeyArray2.length; ++i) {
                intBuffer4.put(boundkeyArray2[i].getValue());
            }
        }
        if (dArray5 == null) {
            throw new NullPointerException("Argument blx must not be null");
        }
        ByteBuffer byteBuffer10 = null;
        DoubleBuffer doubleBuffer9 = null;
        if (dArray5 != null) {
            byteBuffer10 = ByteBuffer.allocateDirect(dArray5.length * 8);
            byteBuffer10.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer10 = doubleBuffer9 = dArray5 == null ? null : byteBuffer10.asDoubleBuffer();
        }
        if (doubleBuffer9 != null) {
            doubleBuffer9.position(0);
            doubleBuffer9.put(dArray5);
        }
        if (dArray6 == null) {
            throw new NullPointerException("Argument bux must not be null");
        }
        ByteBuffer byteBuffer11 = null;
        DoubleBuffer doubleBuffer11 = null;
        if (dArray6 != null) {
            byteBuffer11 = ByteBuffer.allocateDirect(dArray6.length * 8);
            byteBuffer11.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer12 = doubleBuffer11 = dArray6 == null ? null : byteBuffer11.asDoubleBuffer();
        }
        if (doubleBuffer11 != null) {
            doubleBuffer11.position(0);
            doubleBuffer11.put(dArray6);
        }
        this.p_inputdata64(this.native_task, n, n2, n3, n4, doubleBuffer, d, longBuffer, longBuffer3, intBuffer, doubleBuffer3, intBuffer3, doubleBuffer5, doubleBuffer7, intBuffer4, doubleBuffer9, doubleBuffer11);
    }

    private native void p_inputdata64(long var1, int var3, int var4, int var5, int var6, DoubleBuffer var7, double var8, LongBuffer var10, LongBuffer var11, IntBuffer var12, DoubleBuffer var13, IntBuffer var14, DoubleBuffer var15, DoubleBuffer var16, IntBuffer var17, DoubleBuffer var18, DoubleBuffer var19) throws Error;

    public synchronized void isdouparname(String string, dparam[] dparamArray) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer2.asIntBuffer();
        this.p_isdouparname(this.native_task, byteBuffer, intBuffer);
        if (dparamArray != null && dparamArray.length > 0) {
            dparamArray[0] = dparam.fromValue(intBuffer.get(0));
        }
    }

    private native void p_isdouparname(long var1, ByteBuffer var3, IntBuffer var4) throws Error;

    public synchronized void isintparname(String string, iparam[] iparamArray) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer2.asIntBuffer();
        this.p_isintparname(this.native_task, byteBuffer, intBuffer);
        if (iparamArray != null && iparamArray.length > 0) {
            iparamArray[0] = iparam.fromValue(intBuffer.get(0));
        }
    }

    private native void p_isintparname(long var1, ByteBuffer var3, IntBuffer var4) throws Error;

    public synchronized void isstrparname(String string, sparam[] sparamArray) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer2.asIntBuffer();
        this.p_isstrparname(this.native_task, byteBuffer, intBuffer);
        if (sparamArray != null && sparamArray.length > 0) {
            sparamArray[0] = sparam.fromValue(intBuffer.get(0));
        }
    }

    private native void p_isstrparname(long var1, ByteBuffer var3, IntBuffer var4) throws Error;

    public synchronized void linkfiletostream(streamtype streamtype2, String string, int n) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_linkfiletotaskstream(this.native_task, streamtype2.getValue(), byteBuffer, n);
    }

    private native void p_linkfiletotaskstream(long var1, int var3, ByteBuffer var4, int var5) throws Error;

    public synchronized void onesolutionsummary(streamtype streamtype2, soltype soltype2) throws Error {
        this.p_onesolutionsummary(this.native_task, streamtype2.getValue(), soltype2.getValue());
    }

    private native void p_onesolutionsummary(long var1, int var3, int var4) throws Error;

    public synchronized void optimizermt(String string, String string2, rescode[] rescodeArray) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        byte[] byArray2 = null;
        try {
            byArray2 = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byArray2.length + 1);
        byteBuffer2.put(byArray2);
        byteBuffer2.put((byte)0);
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(4);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer3.asIntBuffer();
        this.p_optimizermt(this.native_task, byteBuffer, byteBuffer2, intBuffer);
        if (rescodeArray != null && rescodeArray.length > 0) {
            rescodeArray[0] = rescode.fromValue(intBuffer.get(0));
        }
    }

    private native void p_optimizermt(long var1, ByteBuffer var3, ByteBuffer var4, IntBuffer var5) throws Error;

    public synchronized void optimizersummary(streamtype streamtype2) throws Error {
        this.p_optimizersummary(this.native_task, streamtype2.getValue());
    }

    private native void p_optimizersummary(long var1, int var3) throws Error;

    public synchronized void optimize(rescode[] rescodeArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_optimizetrm(this.native_task, intBuffer);
        if (rescodeArray != null && rescodeArray.length > 0) {
            rescodeArray[0] = rescode.fromValue(intBuffer.get(0));
        }
    }

    private native void p_optimizetrm(long var1, IntBuffer var3) throws Error;

    public synchronized rescode optimize() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_optimizetrm(this.native_task, intBuffer);
        return rescode.fromValue(intBuffer.get());
    }

    public synchronized void primalrepair(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) throws Error {
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.put(dArray2);
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer5 = null;
        if (dArray3 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray3.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer6 = doubleBuffer5 = dArray3 == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (doubleBuffer5 != null) {
            doubleBuffer5.position(0);
            doubleBuffer5.put(dArray3);
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer7 = null;
        if (dArray4 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray4.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer8 = doubleBuffer7 = dArray4 == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (doubleBuffer7 != null) {
            doubleBuffer7.position(0);
            doubleBuffer7.put(dArray4);
        }
        if (dArray != null && dArray.length < this.getnumcon()) {
            throw new ArrayLengthException("primalrepair", "wlc");
        }
        if (dArray2 != null && dArray2.length < this.getnumcon()) {
            throw new ArrayLengthException("primalrepair", "wuc");
        }
        if (dArray3 != null && dArray3.length < this.getnumvar()) {
            throw new ArrayLengthException("primalrepair", "wlx");
        }
        if (dArray4 != null && dArray4.length < this.getnumvar()) {
            throw new ArrayLengthException("primalrepair", "wux");
        }
        this.p_primalrepair(this.native_task, doubleBuffer, doubleBuffer3, doubleBuffer5, doubleBuffer7);
    }

    private native void p_primalrepair(long var1, DoubleBuffer var3, DoubleBuffer var4, DoubleBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void primalsensitivity(int[] nArray, mark[] markArray, int[] nArray2, mark[] markArray2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8) throws Error {
        int n;
        int n2 = nArray == null ? 0 : nArray.length;
        if (n2 != (markArray == null ? 0 : markArray.length)) {
            throw new ArrayLengthException("primalsensitivity", "numi");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subi must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (markArray == null) {
            throw new NullPointerException("Argument marki must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (markArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(markArray.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer3 = byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            for (n = 0; n < markArray.length; ++n) {
                intBuffer3.put(markArray[n].getValue());
            }
        }
        if ((n = nArray2 == null ? 0 : nArray2.length) != (markArray2 == null ? 0 : markArray2.length)) {
            throw new ArrayLengthException("primalsensitivity", "numj");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer4 = null;
        if (nArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer5 = intBuffer4 = nArray2 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (intBuffer4 != null) {
            intBuffer4.position(0);
            intBuffer4.put(nArray2);
        }
        if (markArray2 == null) {
            throw new NullPointerException("Argument markj must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        IntBuffer intBuffer6 = null;
        if (markArray2 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(markArray2.length * 4);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer6 = byteBuffer4.asIntBuffer();
        }
        if (intBuffer6 != null) {
            intBuffer6.position(0);
            for (int i = 0; i < markArray2.length; ++i) {
                intBuffer6.put(markArray2[i].getValue());
            }
        }
        ByteBuffer byteBuffer5 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer5 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer = dArray == null ? null : byteBuffer5.asDoubleBuffer();
        }
        ByteBuffer byteBuffer6 = null;
        DoubleBuffer doubleBuffer2 = null;
        if (dArray2 != null) {
            byteBuffer6 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer6.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer2 = dArray2 == null ? null : byteBuffer6.asDoubleBuffer();
        }
        ByteBuffer byteBuffer7 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray3 != null) {
            byteBuffer7 = ByteBuffer.allocateDirect(dArray3.length * 8);
            byteBuffer7.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer3 = dArray3 == null ? null : byteBuffer7.asDoubleBuffer();
        }
        ByteBuffer byteBuffer8 = null;
        DoubleBuffer doubleBuffer4 = null;
        if (dArray4 != null) {
            byteBuffer8 = ByteBuffer.allocateDirect(dArray4.length * 8);
            byteBuffer8.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer4 = dArray4 == null ? null : byteBuffer8.asDoubleBuffer();
        }
        ByteBuffer byteBuffer9 = null;
        DoubleBuffer doubleBuffer5 = null;
        if (dArray5 != null) {
            byteBuffer9 = ByteBuffer.allocateDirect(dArray5.length * 8);
            byteBuffer9.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer5 = dArray5 == null ? null : byteBuffer9.asDoubleBuffer();
        }
        ByteBuffer byteBuffer10 = null;
        DoubleBuffer doubleBuffer6 = null;
        if (dArray6 != null) {
            byteBuffer10 = ByteBuffer.allocateDirect(dArray6.length * 8);
            byteBuffer10.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer6 = dArray6 == null ? null : byteBuffer10.asDoubleBuffer();
        }
        ByteBuffer byteBuffer11 = null;
        DoubleBuffer doubleBuffer7 = null;
        if (dArray7 != null) {
            byteBuffer11 = ByteBuffer.allocateDirect(dArray7.length * 8);
            byteBuffer11.order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer7 = dArray7 == null ? null : byteBuffer11.asDoubleBuffer();
        }
        ByteBuffer byteBuffer12 = null;
        DoubleBuffer doubleBuffer8 = null;
        if (dArray8 != null) {
            byteBuffer12 = ByteBuffer.allocateDirect(dArray8.length * 8);
            byteBuffer12.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer9 = doubleBuffer8 = dArray8 == null ? null : byteBuffer12.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n2) {
            throw new ArrayLengthException("primalsensitivity", "leftpricei");
        }
        if (dArray2 != null && dArray2.length < n2) {
            throw new ArrayLengthException("primalsensitivity", "rightpricei");
        }
        if (dArray3 != null && dArray3.length < n2) {
            throw new ArrayLengthException("primalsensitivity", "leftrangei");
        }
        if (dArray4 != null && dArray4.length < n2) {
            throw new ArrayLengthException("primalsensitivity", "rightrangei");
        }
        if (dArray5 != null && dArray5.length < n) {
            throw new ArrayLengthException("primalsensitivity", "leftpricej");
        }
        if (dArray6 != null && dArray6.length < n) {
            throw new ArrayLengthException("primalsensitivity", "rightpricej");
        }
        if (dArray7 != null && dArray7.length < n) {
            throw new ArrayLengthException("primalsensitivity", "leftrangej");
        }
        if (dArray8 != null && dArray8.length < n) {
            throw new ArrayLengthException("primalsensitivity", "rightrangej");
        }
        this.p_primalsensitivity(this.native_task, n2, intBuffer, intBuffer3, n, intBuffer4, intBuffer6, doubleBuffer, doubleBuffer2, doubleBuffer3, doubleBuffer4, doubleBuffer5, doubleBuffer6, doubleBuffer7, doubleBuffer8);
        if (doubleBuffer8 != null) {
            doubleBuffer8.position(0);
            doubleBuffer8.get(dArray8);
        }
        if (doubleBuffer7 != null) {
            doubleBuffer7.position(0);
            doubleBuffer7.get(dArray7);
        }
        if (doubleBuffer6 != null) {
            doubleBuffer6.position(0);
            doubleBuffer6.get(dArray6);
        }
        if (doubleBuffer5 != null) {
            doubleBuffer5.position(0);
            doubleBuffer5.get(dArray5);
        }
        if (doubleBuffer4 != null) {
            doubleBuffer4.position(0);
            doubleBuffer4.get(dArray4);
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.get(dArray3);
        }
        if (doubleBuffer2 != null) {
            doubleBuffer2.position(0);
            doubleBuffer2.get(dArray2);
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_primalsensitivity(long var1, int var3, IntBuffer var4, IntBuffer var5, int var6, IntBuffer var7, IntBuffer var8, DoubleBuffer var9, DoubleBuffer var10, DoubleBuffer var11, DoubleBuffer var12, DoubleBuffer var13, DoubleBuffer var14, DoubleBuffer var15, DoubleBuffer var16) throws Error;

    public synchronized void putacol(int n, int[] nArray, double[] dArray) throws Error {
        int n2 = nArray == null ? 0 : nArray.length;
        if (n2 != (dArray == null ? 0 : dArray.length)) {
            throw new ArrayLengthException("putacol", "nzj");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subj must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valj must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        this.p_putacol(this.native_task, n, n2, intBuffer, doubleBuffer);
    }

    private native void p_putacol(long var1, int var3, int var4, IntBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void putacollist(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, double[] dArray) throws Error {
        int n = nArray == null ? 0 : nArray.length;
        if (n != (nArray2 == null ? 0 : nArray2.length)) {
            throw new ArrayLengthException("putacollist", "num");
        }
        if (n != (nArray3 == null ? 0 : nArray3.length)) {
            throw new ArrayLengthException("putacollist", "num");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument ptrb must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.put(nArray2);
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument ptre must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer5 = null;
        if (nArray3 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray3.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer6 = intBuffer5 = nArray3 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (intBuffer5 != null) {
            intBuffer5.position(0);
            intBuffer5.put(nArray3);
        }
        if (nArray4 == null) {
            throw new NullPointerException("Argument asub must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        IntBuffer intBuffer7 = null;
        if (nArray4 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(nArray4.length * 4);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer8 = intBuffer7 = nArray4 == null ? null : byteBuffer4.asIntBuffer();
        }
        if (intBuffer7 != null) {
            intBuffer7.position(0);
            intBuffer7.put(nArray4);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument aval must not be null");
        }
        ByteBuffer byteBuffer5 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer5 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer5.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        this.p_putacollist(this.native_task, n, intBuffer, intBuffer3, intBuffer5, intBuffer7, doubleBuffer);
    }

    private native void p_putacollist(long var1, int var3, IntBuffer var4, IntBuffer var5, IntBuffer var6, IntBuffer var7, DoubleBuffer var8) throws Error;

    public synchronized void putacolslice(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        if (nArray == null) {
            throw new NullPointerException("Argument ptrb must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument ptre must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.put(nArray2);
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument asub must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer5 = null;
        if (nArray3 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray3.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer6 = intBuffer5 = nArray3 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (intBuffer5 != null) {
            intBuffer5.position(0);
            intBuffer5.put(nArray3);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument aval must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        this.p_putacolslice(this.native_task, n, n2, intBuffer, intBuffer3, intBuffer5, doubleBuffer);
    }

    private native void p_putacolslice(long var1, int var3, int var4, IntBuffer var5, IntBuffer var6, IntBuffer var7, DoubleBuffer var8) throws Error;

    public synchronized void putacolslice(int n, int n2, long[] lArray, long[] lArray2, int[] nArray, double[] dArray) throws Error {
        if (lArray == null) {
            throw new NullPointerException("Argument ptrb must not be null");
        }
        ByteBuffer byteBuffer = null;
        LongBuffer longBuffer = null;
        if (lArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(lArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            LongBuffer longBuffer2 = longBuffer = lArray == null ? null : byteBuffer.asLongBuffer();
        }
        if (longBuffer != null) {
            longBuffer.position(0);
            longBuffer.put(lArray);
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument ptre must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        LongBuffer longBuffer3 = null;
        if (lArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(lArray2.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            LongBuffer longBuffer4 = longBuffer3 = lArray2 == null ? null : byteBuffer2.asLongBuffer();
        }
        if (longBuffer3 != null) {
            longBuffer3.position(0);
            longBuffer3.put(lArray2);
        }
        if (nArray == null) {
            throw new NullPointerException("Argument asub must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer3.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument aval must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        this.p_putacolslice64(this.native_task, n, n2, longBuffer, longBuffer3, intBuffer, doubleBuffer);
    }

    private native void p_putacolslice64(long var1, int var3, int var4, LongBuffer var5, LongBuffer var6, IntBuffer var7, DoubleBuffer var8) throws Error;

    public synchronized void putaij(int n, int n2, double d) throws Error {
        this.p_putaij(this.native_task, n, n2, d);
    }

    private native void p_putaij(long var1, int var3, int var4, double var5) throws Error;

    public synchronized void putaijlist(int[] nArray, int[] nArray2, double[] dArray) throws Error {
        long l = nArray == null ? 0L : (long)nArray.length;
        if (l != (long)(nArray2 == null ? 0 : nArray2.length)) {
            throw new ArrayLengthException("putaijlist64", "num");
        }
        if (l != (long)(dArray == null ? 0 : dArray.length)) {
            throw new ArrayLengthException("putaijlist64", "num");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subi must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.put(nArray2);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valij must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        this.p_putaijlist64(this.native_task, l, intBuffer, intBuffer3, doubleBuffer);
    }

    private native void p_putaijlist64(long var1, long var3, IntBuffer var5, IntBuffer var6, DoubleBuffer var7) throws Error;

    public synchronized void putarow(int n, int[] nArray, double[] dArray) throws Error {
        int n2 = nArray == null ? 0 : nArray.length;
        if (n2 != (dArray == null ? 0 : dArray.length)) {
            throw new ArrayLengthException("putarow", "nzi");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subi must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument vali must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        this.p_putarow(this.native_task, n, n2, intBuffer, doubleBuffer);
    }

    private native void p_putarow(long var1, int var3, int var4, IntBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void putarowlist(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, double[] dArray) throws Error {
        int n = nArray == null ? 0 : nArray.length;
        if (n != (nArray2 == null ? 0 : nArray2.length)) {
            throw new ArrayLengthException("putarowlist", "num");
        }
        if (n != (nArray3 == null ? 0 : nArray3.length)) {
            throw new ArrayLengthException("putarowlist", "num");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument ptrb must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.put(nArray2);
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument ptre must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer5 = null;
        if (nArray3 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray3.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer6 = intBuffer5 = nArray3 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (intBuffer5 != null) {
            intBuffer5.position(0);
            intBuffer5.put(nArray3);
        }
        if (nArray4 == null) {
            throw new NullPointerException("Argument asub must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        IntBuffer intBuffer7 = null;
        if (nArray4 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(nArray4.length * 4);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer8 = intBuffer7 = nArray4 == null ? null : byteBuffer4.asIntBuffer();
        }
        if (intBuffer7 != null) {
            intBuffer7.position(0);
            intBuffer7.put(nArray4);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument aval must not be null");
        }
        ByteBuffer byteBuffer5 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer5 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer5.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        this.p_putarowlist(this.native_task, n, intBuffer, intBuffer3, intBuffer5, intBuffer7, doubleBuffer);
    }

    private native void p_putarowlist(long var1, int var3, IntBuffer var4, IntBuffer var5, IntBuffer var6, IntBuffer var7, DoubleBuffer var8) throws Error;

    public synchronized void putarowslice(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        if (nArray == null) {
            throw new NullPointerException("Argument ptrb must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument ptre must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.put(nArray2);
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument asub must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer5 = null;
        if (nArray3 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray3.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer6 = intBuffer5 = nArray3 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (intBuffer5 != null) {
            intBuffer5.position(0);
            intBuffer5.put(nArray3);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument aval must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (nArray != null && nArray.length < n2 - n) {
            throw new ArrayLengthException("putarowslice", "ptrb");
        }
        if (nArray2 != null && nArray2.length < n2 - n) {
            throw new ArrayLengthException("putarowslice", "ptre");
        }
        this.p_putarowslice(this.native_task, n, n2, intBuffer, intBuffer3, intBuffer5, doubleBuffer);
    }

    private native void p_putarowslice(long var1, int var3, int var4, IntBuffer var5, IntBuffer var6, IntBuffer var7, DoubleBuffer var8) throws Error;

    public synchronized void putarowslice(int n, int n2, long[] lArray, long[] lArray2, int[] nArray, double[] dArray) throws Error {
        if (lArray == null) {
            throw new NullPointerException("Argument ptrb must not be null");
        }
        ByteBuffer byteBuffer = null;
        LongBuffer longBuffer = null;
        if (lArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(lArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            LongBuffer longBuffer2 = longBuffer = lArray == null ? null : byteBuffer.asLongBuffer();
        }
        if (longBuffer != null) {
            longBuffer.position(0);
            longBuffer.put(lArray);
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument ptre must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        LongBuffer longBuffer3 = null;
        if (lArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(lArray2.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            LongBuffer longBuffer4 = longBuffer3 = lArray2 == null ? null : byteBuffer2.asLongBuffer();
        }
        if (longBuffer3 != null) {
            longBuffer3.position(0);
            longBuffer3.put(lArray2);
        }
        if (nArray == null) {
            throw new NullPointerException("Argument asub must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer3.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument aval must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (lArray != null && lArray.length < n2 - n) {
            throw new ArrayLengthException("putarowslice64", "ptrb");
        }
        if (lArray2 != null && lArray2.length < n2 - n) {
            throw new ArrayLengthException("putarowslice64", "ptre");
        }
        this.p_putarowslice64(this.native_task, n, n2, longBuffer, longBuffer3, intBuffer, doubleBuffer);
    }

    private native void p_putarowslice64(long var1, int var3, int var4, LongBuffer var5, LongBuffer var6, IntBuffer var7, DoubleBuffer var8) throws Error;

    public synchronized void putbarablocktriplet(long l, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, double[] dArray) throws Error {
        if (nArray == null) {
            throw new NullPointerException("Argument subi must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.put(nArray2);
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subk must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer5 = null;
        if (nArray3 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray3.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer6 = intBuffer5 = nArray3 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (intBuffer5 != null) {
            intBuffer5.position(0);
            intBuffer5.put(nArray3);
        }
        if (nArray4 == null) {
            throw new NullPointerException("Argument subl must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        IntBuffer intBuffer7 = null;
        if (nArray4 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(nArray4.length * 4);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer8 = intBuffer7 = nArray4 == null ? null : byteBuffer4.asIntBuffer();
        }
        if (intBuffer7 != null) {
            intBuffer7.position(0);
            intBuffer7.put(nArray4);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valijkl must not be null");
        }
        ByteBuffer byteBuffer5 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer5 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer5.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("putbarablocktriplet", "subi");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("putbarablocktriplet", "subj");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("putbarablocktriplet", "subk");
        }
        if (nArray4 != null && (long)nArray4.length < l) {
            throw new ArrayLengthException("putbarablocktriplet", "subl");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("putbarablocktriplet", "valijkl");
        }
        this.p_putbarablocktriplet(this.native_task, l, intBuffer, intBuffer3, intBuffer5, intBuffer7, doubleBuffer);
    }

    private native void p_putbarablocktriplet(long var1, long var3, IntBuffer var5, IntBuffer var6, IntBuffer var7, IntBuffer var8, DoubleBuffer var9) throws Error;

    public synchronized void putbaraij(int n, int n2, long[] lArray, double[] dArray) throws Error {
        long l = lArray == null ? 0L : (long)lArray.length;
        if (l != (long)(dArray == null ? 0 : dArray.length)) {
            throw new ArrayLengthException("putbaraij", "num");
        }
        if (lArray == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer = null;
        LongBuffer longBuffer = null;
        if (lArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(lArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            LongBuffer longBuffer2 = longBuffer = lArray == null ? null : byteBuffer.asLongBuffer();
        }
        if (longBuffer != null) {
            longBuffer.position(0);
            longBuffer.put(lArray);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument weights must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        this.p_putbaraij(this.native_task, n, n2, l, longBuffer, doubleBuffer);
    }

    private native void p_putbaraij(long var1, int var3, int var4, long var5, LongBuffer var7, DoubleBuffer var8) throws Error;

    public synchronized void putbarcblocktriplet(long l, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        if (nArray == null) {
            throw new NullPointerException("Argument subj must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subk must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.put(nArray2);
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subl must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer5 = null;
        if (nArray3 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray3.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer6 = intBuffer5 = nArray3 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (intBuffer5 != null) {
            intBuffer5.position(0);
            intBuffer5.put(nArray3);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valjkl must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("putbarcblocktriplet", "subj");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("putbarcblocktriplet", "subk");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("putbarcblocktriplet", "subl");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("putbarcblocktriplet", "valjkl");
        }
        this.p_putbarcblocktriplet(this.native_task, l, intBuffer, intBuffer3, intBuffer5, doubleBuffer);
    }

    private native void p_putbarcblocktriplet(long var1, long var3, IntBuffer var5, IntBuffer var6, IntBuffer var7, DoubleBuffer var8) throws Error;

    public synchronized void putbarcj(int n, long[] lArray, double[] dArray) throws Error {
        long l = lArray == null ? 0L : (long)lArray.length;
        if (l != (long)(dArray == null ? 0 : dArray.length)) {
            throw new ArrayLengthException("putbarcj", "num");
        }
        if (lArray == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer = null;
        LongBuffer longBuffer = null;
        if (lArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(lArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            LongBuffer longBuffer2 = longBuffer = lArray == null ? null : byteBuffer.asLongBuffer();
        }
        if (longBuffer != null) {
            longBuffer.position(0);
            longBuffer.put(lArray);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument weights must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        this.p_putbarcj(this.native_task, n, l, longBuffer, doubleBuffer);
    }

    private native void p_putbarcj(long var1, int var3, long var4, LongBuffer var6, DoubleBuffer var7) throws Error;

    public synchronized void putbarsj(soltype soltype2, int n, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument barsj must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && (long)dArray.length < this.getlenbarvarj(n)) {
            throw new ArrayLengthException("putbarsj", "barsj");
        }
        this.p_putbarsj(this.native_task, soltype2.getValue(), n, doubleBuffer);
    }

    private native void p_putbarsj(long var1, int var3, int var4, DoubleBuffer var5) throws Error;

    public synchronized void putbarvarname(int n, String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_putbarvarname(this.native_task, n, byteBuffer);
    }

    private native void p_putbarvarname(long var1, int var3, ByteBuffer var4) throws Error;

    public synchronized void putbarxj(soltype soltype2, int n, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument barxj must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && (long)dArray.length < this.getlenbarvarj(n)) {
            throw new ArrayLengthException("putbarxj", "barxj");
        }
        this.p_putbarxj(this.native_task, soltype2.getValue(), n, doubleBuffer);
    }

    private native void p_putbarxj(long var1, int var3, int var4, DoubleBuffer var5) throws Error;

    public synchronized void putbound(accmode accmode2, int n, boundkey boundkey2, double d, double d2) throws Error {
        this.p_putbound(this.native_task, accmode2.getValue(), n, boundkey2.getValue(), d, d2);
    }

    private native void p_putbound(long var1, int var3, int var4, int var5, double var6, double var8) throws Error;

    public synchronized void putboundlist(accmode accmode2, int[] nArray, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        int n = nArray == null ? 0 : nArray.length;
        if (n != (boundkeyArray == null ? 0 : boundkeyArray.length)) {
            throw new ArrayLengthException("putboundlist", "num");
        }
        if (n != (dArray == null ? 0 : dArray.length)) {
            throw new ArrayLengthException("putboundlist", "num");
        }
        if (n != (dArray2 == null ? 0 : dArray2.length)) {
            throw new ArrayLengthException("putboundlist", "num");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (boundkeyArray == null) {
            throw new NullPointerException("Argument bk must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (boundkeyArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(boundkeyArray.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer3 = byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            for (int i = 0; i < boundkeyArray.length; ++i) {
                intBuffer3.put(boundkeyArray[i].getValue());
            }
        }
        if (dArray == null) {
            throw new NullPointerException("Argument bl must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument bu must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.put(dArray2);
        }
        this.p_putboundlist(this.native_task, accmode2.getValue(), n, intBuffer, intBuffer3, doubleBuffer, doubleBuffer3);
    }

    private native void p_putboundlist(long var1, int var3, int var4, IntBuffer var5, IntBuffer var6, DoubleBuffer var7, DoubleBuffer var8) throws Error;

    public synchronized void putboundslice(accmode accmode2, int n, int n2, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        if (boundkeyArray == null) {
            throw new NullPointerException("Argument bk must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (boundkeyArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(boundkeyArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            for (int i = 0; i < boundkeyArray.length; ++i) {
                intBuffer.put(boundkeyArray[i].getValue());
            }
        }
        if (dArray == null) {
            throw new NullPointerException("Argument bl must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument bu must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.put(dArray2);
        }
        if (boundkeyArray != null && boundkeyArray.length < n2 - n) {
            throw new ArrayLengthException("putboundslice", "bk");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putboundslice", "bl");
        }
        if (dArray2 != null && dArray2.length < n2 - n) {
            throw new ArrayLengthException("putboundslice", "bu");
        }
        this.p_putboundslice(this.native_task, accmode2.getValue(), n, n2, intBuffer, doubleBuffer, doubleBuffer3);
    }

    private native void p_putboundslice(long var1, int var3, int var4, int var5, IntBuffer var6, DoubleBuffer var7, DoubleBuffer var8) throws Error;

    public synchronized void putcfix(double d) throws Error {
        this.p_putcfix(this.native_task, d);
    }

    private native void p_putcfix(long var1, double var3) throws Error;

    public synchronized void putcj(int n, double d) throws Error {
        this.p_putcj(this.native_task, n, d);
    }

    private native void p_putcj(long var1, int var3, double var4) throws Error;

    public synchronized void putclist(int[] nArray, double[] dArray) throws Error {
        int n = nArray == null ? 0 : nArray.length;
        if (n != (dArray == null ? 0 : dArray.length)) {
            throw new ArrayLengthException("putclist", "num");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subj must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument val must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        this.p_putclist(this.native_task, n, intBuffer, doubleBuffer);
    }

    private native void p_putclist(long var1, int var3, IntBuffer var4, DoubleBuffer var5) throws Error;

    public synchronized void putconbound(int n, boundkey boundkey2, double d, double d2) throws Error {
        this.p_putconbound(this.native_task, n, boundkey2.getValue(), d, d2);
    }

    private native void p_putconbound(long var1, int var3, int var4, double var5, double var7) throws Error;

    public synchronized void putconboundlist(int[] nArray, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        int n = nArray == null ? 0 : nArray.length;
        if (n != (boundkeyArray == null ? 0 : boundkeyArray.length)) {
            throw new ArrayLengthException("putconboundlist", "num");
        }
        if (n != (dArray == null ? 0 : dArray.length)) {
            throw new ArrayLengthException("putconboundlist", "num");
        }
        if (n != (dArray2 == null ? 0 : dArray2.length)) {
            throw new ArrayLengthException("putconboundlist", "num");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (boundkeyArray == null) {
            throw new NullPointerException("Argument bk must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (boundkeyArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(boundkeyArray.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer3 = byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            for (int i = 0; i < boundkeyArray.length; ++i) {
                intBuffer3.put(boundkeyArray[i].getValue());
            }
        }
        if (dArray == null) {
            throw new NullPointerException("Argument bl must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument bu must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.put(dArray2);
        }
        this.p_putconboundlist(this.native_task, n, intBuffer, intBuffer3, doubleBuffer, doubleBuffer3);
    }

    private native void p_putconboundlist(long var1, int var3, IntBuffer var4, IntBuffer var5, DoubleBuffer var6, DoubleBuffer var7) throws Error;

    public synchronized void putconboundslice(int n, int n2, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        if (boundkeyArray == null) {
            throw new NullPointerException("Argument bk must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (boundkeyArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(boundkeyArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            for (int i = 0; i < boundkeyArray.length; ++i) {
                intBuffer.put(boundkeyArray[i].getValue());
            }
        }
        if (dArray == null) {
            throw new NullPointerException("Argument bl must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument bu must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.put(dArray2);
        }
        if (boundkeyArray != null && boundkeyArray.length < n2 - n) {
            throw new ArrayLengthException("putconboundslice", "bk");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putconboundslice", "bl");
        }
        if (dArray2 != null && dArray2.length < n2 - n) {
            throw new ArrayLengthException("putconboundslice", "bu");
        }
        this.p_putconboundslice(this.native_task, n, n2, intBuffer, doubleBuffer, doubleBuffer3);
    }

    private native void p_putconboundslice(long var1, int var3, int var4, IntBuffer var5, DoubleBuffer var6, DoubleBuffer var7) throws Error;

    public synchronized void putcone(int n, conetype conetype2, double d, int[] nArray) throws Error {
        int n2;
        int n3 = n2 = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument submem must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        this.p_putcone(this.native_task, n, conetype2.getValue(), d, n2, intBuffer);
    }

    private native void p_putcone(long var1, int var3, int var4, double var5, int var7, IntBuffer var8) throws Error;

    public synchronized void putconename(int n, String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_putconename(this.native_task, n, byteBuffer);
    }

    private native void p_putconename(long var1, int var3, ByteBuffer var4) throws Error;

    public synchronized void putconname(int n, String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_putconname(this.native_task, n, byteBuffer);
    }

    private native void p_putconname(long var1, int var3, ByteBuffer var4) throws Error;

    public synchronized void putcslice(int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument slice must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putcslice", "slice");
        }
        this.p_putcslice(this.native_task, n, n2, doubleBuffer);
    }

    private native void p_putcslice(long var1, int var3, int var4, DoubleBuffer var5) throws Error;

    public synchronized void putdouparam(dparam dparam2, double d) throws Error {
        this.p_putdouparam(this.native_task, dparam2.getValue(), d);
    }

    private native void p_putdouparam(long var1, int var3, double var4) throws Error;

    public synchronized void putintparam(iparam iparam2, int n) throws Error {
        this.p_putintparam(this.native_task, iparam2.getValue(), n);
    }

    private native void p_putintparam(long var1, int var3, int var4) throws Error;

    public synchronized void putmaxnumanz(long l) throws Error {
        this.p_putmaxnumanz(this.native_task, l);
    }

    private native void p_putmaxnumanz(long var1, long var3) throws Error;

    public synchronized void putmaxnumbarvar(int n) throws Error {
        this.p_putmaxnumbarvar(this.native_task, n);
    }

    private native void p_putmaxnumbarvar(long var1, int var3) throws Error;

    public synchronized void putmaxnumcon(int n) throws Error {
        this.p_putmaxnumcon(this.native_task, n);
    }

    private native void p_putmaxnumcon(long var1, int var3) throws Error;

    public synchronized void putmaxnumcone(int n) throws Error {
        this.p_putmaxnumcone(this.native_task, n);
    }

    private native void p_putmaxnumcone(long var1, int var3) throws Error;

    public synchronized void putmaxnumqnz(long l) throws Error {
        this.p_putmaxnumqnz(this.native_task, l);
    }

    private native void p_putmaxnumqnz(long var1, long var3) throws Error;

    public synchronized void putmaxnumvar(int n) throws Error {
        this.p_putmaxnumvar(this.native_task, n);
    }

    private native void p_putmaxnumvar(long var1, int var3) throws Error;

    public synchronized void putnadouparam(String string, double d) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_putnadouparam(this.native_task, byteBuffer, d);
    }

    private native void p_putnadouparam(long var1, ByteBuffer var3, double var4) throws Error;

    public synchronized void putnaintparam(String string, int n) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_putnaintparam(this.native_task, byteBuffer, n);
    }

    private native void p_putnaintparam(long var1, ByteBuffer var3, int var4) throws Error;

    public synchronized void putnastrparam(String string, String string2) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        byte[] byArray2 = null;
        try {
            byArray2 = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byArray2.length + 1);
        byteBuffer2.put(byArray2);
        byteBuffer2.put((byte)0);
        this.p_putnastrparam(this.native_task, byteBuffer, byteBuffer2);
    }

    private native void p_putnastrparam(long var1, ByteBuffer var3, ByteBuffer var4) throws Error;

    public synchronized void putobjname(String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_putobjname(this.native_task, byteBuffer);
    }

    private native void p_putobjname(long var1, ByteBuffer var3) throws Error;

    public synchronized void putobjsense(objsense objsense2) throws Error {
        this.p_putobjsense(this.native_task, objsense2.getValue());
    }

    private native void p_putobjsense(long var1, int var3) throws Error;

    public synchronized void putparam(String string, String string2) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        byte[] byArray2 = null;
        try {
            byArray2 = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byArray2.length + 1);
        byteBuffer2.put(byArray2);
        byteBuffer2.put((byte)0);
        this.p_putparam(this.native_task, byteBuffer, byteBuffer2);
    }

    private native void p_putparam(long var1, ByteBuffer var3, ByteBuffer var4) throws Error;

    public synchronized void putqcon(int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        int n = nArray2 == null ? 0 : nArray2.length;
        if (n != (nArray3 == null ? 0 : nArray3.length)) {
            throw new ArrayLengthException("putqcon", "numqcnz");
        }
        if (n != (dArray == null ? 0 : dArray.length)) {
            throw new ArrayLengthException("putqcon", "numqcnz");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument qcsubk must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument qcsubi must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.put(nArray2);
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument qcsubj must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer5 = null;
        if (nArray3 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray3.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer6 = intBuffer5 = nArray3 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (intBuffer5 != null) {
            intBuffer5.position(0);
            intBuffer5.put(nArray3);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument qcval must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        this.p_putqcon(this.native_task, n, intBuffer, intBuffer3, intBuffer5, doubleBuffer);
    }

    private native void p_putqcon(long var1, int var3, IntBuffer var4, IntBuffer var5, IntBuffer var6, DoubleBuffer var7) throws Error;

    public synchronized void putqconk(int n, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        int n2 = nArray == null ? 0 : nArray.length;
        if (n2 != (nArray2 == null ? 0 : nArray2.length)) {
            throw new ArrayLengthException("putqconk", "numqcnz");
        }
        if (n2 != (dArray == null ? 0 : dArray.length)) {
            throw new ArrayLengthException("putqconk", "numqcnz");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument qcsubi must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument qcsubj must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.put(nArray2);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument qcval must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        this.p_putqconk(this.native_task, n, n2, intBuffer, intBuffer3, doubleBuffer);
    }

    private native void p_putqconk(long var1, int var3, int var4, IntBuffer var5, IntBuffer var6, DoubleBuffer var7) throws Error;

    public synchronized void putqobj(int[] nArray, int[] nArray2, double[] dArray) throws Error {
        int n = nArray == null ? 0 : nArray.length;
        if (n != (nArray2 == null ? 0 : nArray2.length)) {
            throw new ArrayLengthException("putqobj", "numqonz");
        }
        if (n != (dArray == null ? 0 : dArray.length)) {
            throw new ArrayLengthException("putqobj", "numqonz");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument qosubi must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument qosubj must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.put(nArray2);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument qoval must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        this.p_putqobj(this.native_task, n, intBuffer, intBuffer3, doubleBuffer);
    }

    private native void p_putqobj(long var1, int var3, IntBuffer var4, IntBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void putqobjij(int n, int n2, double d) throws Error {
        this.p_putqobjij(this.native_task, n, n2, d);
    }

    private native void p_putqobjij(long var1, int var3, int var4, double var5) throws Error;

    public synchronized void putskc(soltype soltype2, stakey[] stakeyArray) throws Error {
        if (stakeyArray == null) {
            throw new NullPointerException("Argument skc must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (stakeyArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(stakeyArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            for (int i = 0; i < stakeyArray.length; ++i) {
                intBuffer.put(stakeyArray[i].getValue());
            }
        }
        if (stakeyArray != null && stakeyArray.length < this.getnumcon()) {
            throw new ArrayLengthException("putskc", "skc");
        }
        this.p_putskc(this.native_task, soltype2.getValue(), intBuffer);
    }

    private native void p_putskc(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized void putskcslice(soltype soltype2, int n, int n2, stakey[] stakeyArray) throws Error {
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (stakeyArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(stakeyArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            for (int i = 0; i < stakeyArray.length; ++i) {
                intBuffer.put(stakeyArray[i].getValue());
            }
        }
        if (stakeyArray != null && stakeyArray.length < n2 - n) {
            throw new ArrayLengthException("putskcslice", "skc");
        }
        this.p_putskcslice(this.native_task, soltype2.getValue(), n, n2, intBuffer);
    }

    private native void p_putskcslice(long var1, int var3, int var4, int var5, IntBuffer var6) throws Error;

    public synchronized void putskx(soltype soltype2, stakey[] stakeyArray) throws Error {
        if (stakeyArray == null) {
            throw new NullPointerException("Argument skx must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (stakeyArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(stakeyArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            for (int i = 0; i < stakeyArray.length; ++i) {
                intBuffer.put(stakeyArray[i].getValue());
            }
        }
        if (stakeyArray != null && stakeyArray.length < this.getnumvar()) {
            throw new ArrayLengthException("putskx", "skx");
        }
        this.p_putskx(this.native_task, soltype2.getValue(), intBuffer);
    }

    private native void p_putskx(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized void putskxslice(soltype soltype2, int n, int n2, stakey[] stakeyArray) throws Error {
        if (stakeyArray == null) {
            throw new NullPointerException("Argument skx must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (stakeyArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(stakeyArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            for (int i = 0; i < stakeyArray.length; ++i) {
                intBuffer.put(stakeyArray[i].getValue());
            }
        }
        if (stakeyArray != null && stakeyArray.length < n2 - n) {
            throw new ArrayLengthException("putskxslice", "skx");
        }
        this.p_putskxslice(this.native_task, soltype2.getValue(), n, n2, intBuffer);
    }

    private native void p_putskxslice(long var1, int var3, int var4, int var5, IntBuffer var6) throws Error;

    public synchronized void putslc(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument slc must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < this.getnumcon()) {
            throw new ArrayLengthException("putslc", "slc");
        }
        this.p_putslc(this.native_task, soltype2.getValue(), doubleBuffer);
    }

    private native void p_putslc(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void putslcslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument slc must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putslcslice", "slc");
        }
        this.p_putslcslice(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
    }

    private native void p_putslcslice(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void putslx(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument slx must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < this.getnumvar()) {
            throw new ArrayLengthException("putslx", "slx");
        }
        this.p_putslx(this.native_task, soltype2.getValue(), doubleBuffer);
    }

    private native void p_putslx(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void putslxslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument slx must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putslxslice", "slx");
        }
        this.p_putslxslice(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
    }

    private native void p_putslxslice(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void putsnx(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument sux must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < this.getnumvar()) {
            throw new ArrayLengthException("putsnx", "sux");
        }
        this.p_putsnx(this.native_task, soltype2.getValue(), doubleBuffer);
    }

    private native void p_putsnx(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void putsnxslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument snx must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putsnxslice", "snx");
        }
        this.p_putsnxslice(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
    }

    private native void p_putsnxslice(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void putsolution(soltype soltype2, stakey[] stakeyArray, stakey[] stakeyArray2, stakey[] stakeyArray3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8) throws Error {
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (stakeyArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(stakeyArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            for (int i = 0; i < stakeyArray.length; ++i) {
                intBuffer.put(stakeyArray[i].getValue());
            }
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer2 = null;
        if (stakeyArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(stakeyArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer2 = byteBuffer2.asIntBuffer();
        }
        if (intBuffer2 != null) {
            intBuffer2.position(0);
            for (int i = 0; i < stakeyArray2.length; ++i) {
                intBuffer2.put(stakeyArray2[i].getValue());
            }
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer3 = null;
        if (stakeyArray3 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(stakeyArray3.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer3 = byteBuffer3.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            for (int i = 0; i < stakeyArray3.length; ++i) {
                intBuffer3.put(stakeyArray3[i].getValue());
            }
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        ByteBuffer byteBuffer5 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer5 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer5.asDoubleBuffer();
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.put(dArray2);
        }
        ByteBuffer byteBuffer6 = null;
        DoubleBuffer doubleBuffer5 = null;
        if (dArray3 != null) {
            byteBuffer6 = ByteBuffer.allocateDirect(dArray3.length * 8);
            byteBuffer6.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer6 = doubleBuffer5 = dArray3 == null ? null : byteBuffer6.asDoubleBuffer();
        }
        if (doubleBuffer5 != null) {
            doubleBuffer5.position(0);
            doubleBuffer5.put(dArray3);
        }
        ByteBuffer byteBuffer7 = null;
        DoubleBuffer doubleBuffer7 = null;
        if (dArray4 != null) {
            byteBuffer7 = ByteBuffer.allocateDirect(dArray4.length * 8);
            byteBuffer7.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer8 = doubleBuffer7 = dArray4 == null ? null : byteBuffer7.asDoubleBuffer();
        }
        if (doubleBuffer7 != null) {
            doubleBuffer7.position(0);
            doubleBuffer7.put(dArray4);
        }
        ByteBuffer byteBuffer8 = null;
        DoubleBuffer doubleBuffer9 = null;
        if (dArray5 != null) {
            byteBuffer8 = ByteBuffer.allocateDirect(dArray5.length * 8);
            byteBuffer8.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer10 = doubleBuffer9 = dArray5 == null ? null : byteBuffer8.asDoubleBuffer();
        }
        if (doubleBuffer9 != null) {
            doubleBuffer9.position(0);
            doubleBuffer9.put(dArray5);
        }
        ByteBuffer byteBuffer9 = null;
        DoubleBuffer doubleBuffer11 = null;
        if (dArray6 != null) {
            byteBuffer9 = ByteBuffer.allocateDirect(dArray6.length * 8);
            byteBuffer9.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer12 = doubleBuffer11 = dArray6 == null ? null : byteBuffer9.asDoubleBuffer();
        }
        if (doubleBuffer11 != null) {
            doubleBuffer11.position(0);
            doubleBuffer11.put(dArray6);
        }
        ByteBuffer byteBuffer10 = null;
        DoubleBuffer doubleBuffer13 = null;
        if (dArray7 != null) {
            byteBuffer10 = ByteBuffer.allocateDirect(dArray7.length * 8);
            byteBuffer10.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer14 = doubleBuffer13 = dArray7 == null ? null : byteBuffer10.asDoubleBuffer();
        }
        if (doubleBuffer13 != null) {
            doubleBuffer13.position(0);
            doubleBuffer13.put(dArray7);
        }
        ByteBuffer byteBuffer11 = null;
        DoubleBuffer doubleBuffer15 = null;
        if (dArray8 != null) {
            byteBuffer11 = ByteBuffer.allocateDirect(dArray8.length * 8);
            byteBuffer11.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer16 = doubleBuffer15 = dArray8 == null ? null : byteBuffer11.asDoubleBuffer();
        }
        if (doubleBuffer15 != null) {
            doubleBuffer15.position(0);
            doubleBuffer15.put(dArray8);
        }
        this.p_putsolution(this.native_task, soltype2.getValue(), intBuffer, intBuffer2, intBuffer3, doubleBuffer, doubleBuffer3, doubleBuffer5, doubleBuffer7, doubleBuffer9, doubleBuffer11, doubleBuffer13, doubleBuffer15);
    }

    private native void p_putsolution(long var1, int var3, IntBuffer var4, IntBuffer var5, IntBuffer var6, DoubleBuffer var7, DoubleBuffer var8, DoubleBuffer var9, DoubleBuffer var10, DoubleBuffer var11, DoubleBuffer var12, DoubleBuffer var13, DoubleBuffer var14) throws Error;

    public synchronized void putsolutioni(accmode accmode2, int n, soltype soltype2, stakey stakey2, double d, double d2, double d3, double d4) throws Error {
        this.p_putsolutioni(this.native_task, accmode2.getValue(), n, soltype2.getValue(), stakey2.getValue(), d, d2, d3, d4);
    }

    private native void p_putsolutioni(long var1, int var3, int var4, int var5, int var6, double var7, double var9, double var11, double var13) throws Error;

    public synchronized void putsolutionyi(int n, soltype soltype2, double d) throws Error {
        this.p_putsolutionyi(this.native_task, n, soltype2.getValue(), d);
    }

    private native void p_putsolutionyi(long var1, int var3, int var4, double var5) throws Error;

    public synchronized void putstrparam(sparam sparam2, String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_putstrparam(this.native_task, sparam2.getValue(), byteBuffer);
    }

    private native void p_putstrparam(long var1, int var3, ByteBuffer var4) throws Error;

    public synchronized void putsuc(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument suc must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < this.getnumcon()) {
            throw new ArrayLengthException("putsuc", "suc");
        }
        this.p_putsuc(this.native_task, soltype2.getValue(), doubleBuffer);
    }

    private native void p_putsuc(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void putsucslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument suc must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putsucslice", "suc");
        }
        this.p_putsucslice(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
    }

    private native void p_putsucslice(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void putsux(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument sux must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < this.getnumvar()) {
            throw new ArrayLengthException("putsux", "sux");
        }
        this.p_putsux(this.native_task, soltype2.getValue(), doubleBuffer);
    }

    private native void p_putsux(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void putsuxslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument sux must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putsuxslice", "sux");
        }
        this.p_putsuxslice(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
    }

    private native void p_putsuxslice(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void puttaskname(String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_puttaskname(this.native_task, byteBuffer);
    }

    private native void p_puttaskname(long var1, ByteBuffer var3) throws Error;

    public synchronized void putvarbound(int n, boundkey boundkey2, double d, double d2) throws Error {
        this.p_putvarbound(this.native_task, n, boundkey2.getValue(), d, d2);
    }

    private native void p_putvarbound(long var1, int var3, int var4, double var5, double var7) throws Error;

    public synchronized void putvarboundlist(int[] nArray, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        int n = nArray == null ? 0 : nArray.length;
        if (n != (boundkeyArray == null ? 0 : boundkeyArray.length)) {
            throw new ArrayLengthException("putvarboundlist", "num");
        }
        if (n != (dArray == null ? 0 : dArray.length)) {
            throw new ArrayLengthException("putvarboundlist", "num");
        }
        if (n != (dArray2 == null ? 0 : dArray2.length)) {
            throw new ArrayLengthException("putvarboundlist", "num");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (boundkeyArray == null) {
            throw new NullPointerException("Argument bkx must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (boundkeyArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(boundkeyArray.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer3 = byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            for (int i = 0; i < boundkeyArray.length; ++i) {
                intBuffer3.put(boundkeyArray[i].getValue());
            }
        }
        if (dArray == null) {
            throw new NullPointerException("Argument blx must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument bux must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.put(dArray2);
        }
        this.p_putvarboundlist(this.native_task, n, intBuffer, intBuffer3, doubleBuffer, doubleBuffer3);
    }

    private native void p_putvarboundlist(long var1, int var3, IntBuffer var4, IntBuffer var5, DoubleBuffer var6, DoubleBuffer var7) throws Error;

    public synchronized void putvarboundslice(int n, int n2, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        if (boundkeyArray == null) {
            throw new NullPointerException("Argument bk must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (boundkeyArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(boundkeyArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            for (int i = 0; i < boundkeyArray.length; ++i) {
                intBuffer.put(boundkeyArray[i].getValue());
            }
        }
        if (dArray == null) {
            throw new NullPointerException("Argument bl must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument bu must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.put(dArray2);
        }
        if (boundkeyArray != null && boundkeyArray.length < n2 - n) {
            throw new ArrayLengthException("putvarboundslice", "bk");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putvarboundslice", "bl");
        }
        if (dArray2 != null && dArray2.length < n2 - n) {
            throw new ArrayLengthException("putvarboundslice", "bu");
        }
        this.p_putvarboundslice(this.native_task, n, n2, intBuffer, doubleBuffer, doubleBuffer3);
    }

    private native void p_putvarboundslice(long var1, int var3, int var4, IntBuffer var5, DoubleBuffer var6, DoubleBuffer var7) throws Error;

    public synchronized void putvarname(int n, String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_putvarname(this.native_task, n, byteBuffer);
    }

    private native void p_putvarname(long var1, int var3, ByteBuffer var4) throws Error;

    public synchronized void putvartype(int n, variabletype variabletype2) throws Error {
        this.p_putvartype(this.native_task, n, variabletype2.getValue());
    }

    private native void p_putvartype(long var1, int var3, int var4) throws Error;

    public synchronized void putvartypelist(int[] nArray, variabletype[] variabletypeArray) throws Error {
        int n = nArray == null ? 0 : nArray.length;
        if (n != (variabletypeArray == null ? 0 : variabletypeArray.length)) {
            throw new ArrayLengthException("putvartypelist", "num");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subj must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (variabletypeArray == null) {
            throw new NullPointerException("Argument vartype must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer3 = null;
        if (variabletypeArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(variabletypeArray.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            intBuffer3 = byteBuffer2.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            for (int i = 0; i < variabletypeArray.length; ++i) {
                intBuffer3.put(variabletypeArray[i].getValue());
            }
        }
        this.p_putvartypelist(this.native_task, n, intBuffer, intBuffer3);
    }

    private native void p_putvartypelist(long var1, int var3, IntBuffer var4, IntBuffer var5) throws Error;

    public synchronized void putxc(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument xc must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < this.getnumcon()) {
            throw new ArrayLengthException("putxc", "xc");
        }
        this.p_putxc(this.native_task, soltype2.getValue(), doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_putxc(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void putxcslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument xc must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putxcslice", "xc");
        }
        this.p_putxcslice(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
    }

    private native void p_putxcslice(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void putxx(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument xx must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < this.getnumvar()) {
            throw new ArrayLengthException("putxx", "xx");
        }
        this.p_putxx(this.native_task, soltype2.getValue(), doubleBuffer);
    }

    private native void p_putxx(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void putxxslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument xx must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putxxslice", "xx");
        }
        this.p_putxxslice(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
    }

    private native void p_putxxslice(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void puty(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument y must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < this.getnumcon()) {
            throw new ArrayLengthException("puty", "y");
        }
        this.p_puty(this.native_task, soltype2.getValue(), doubleBuffer);
    }

    private native void p_puty(long var1, int var3, DoubleBuffer var4) throws Error;

    public synchronized void putyslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument y must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putyslice", "y");
        }
        this.p_putyslice(this.native_task, soltype2.getValue(), n, n2, doubleBuffer);
    }

    private native void p_putyslice(long var1, int var3, int var4, int var5, DoubleBuffer var6) throws Error;

    public synchronized void readdata(String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_readdataautoformat(this.native_task, byteBuffer);
    }

    private native void p_readdataautoformat(long var1, ByteBuffer var3) throws Error;

    public synchronized void readdataformat(String string, dataformat dataformat2, compresstype compresstype2) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_readdataformat(this.native_task, byteBuffer, dataformat2.getValue(), compresstype2.getValue());
    }

    private native void p_readdataformat(long var1, ByteBuffer var3, int var4, int var5) throws Error;

    public synchronized void readparamfile(String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_readparamfile(this.native_task, byteBuffer);
    }

    private native void p_readparamfile(long var1, ByteBuffer var3) throws Error;

    public synchronized void readsolution(soltype soltype2, String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_readsolution(this.native_task, soltype2.getValue(), byteBuffer);
    }

    private native void p_readsolution(long var1, int var3, ByteBuffer var4) throws Error;

    public synchronized void readsummary(streamtype streamtype2) throws Error {
        this.p_readsummary(this.native_task, streamtype2.getValue());
    }

    private native void p_readsummary(long var1, int var3) throws Error;

    public synchronized void readtask(String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_readtask(this.native_task, byteBuffer);
    }

    private native void p_readtask(long var1, ByteBuffer var3) throws Error;

    public synchronized void removebarvars(int[] nArray) throws Error {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument subset must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        this.p_removebarvars(this.native_task, n, intBuffer);
    }

    private native void p_removebarvars(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized void removecones(int[] nArray) throws Error {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument subset must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        this.p_removecones(this.native_task, n, intBuffer);
    }

    private native void p_removecones(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized void removecons(int[] nArray) throws Error {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument subset must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        this.p_removecons(this.native_task, n, intBuffer);
    }

    private native void p_removecons(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized void removevars(int[] nArray) throws Error {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (nArray == null) {
            throw new NullPointerException("Argument subset must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        this.p_removevars(this.native_task, n, intBuffer);
    }

    private native void p_removevars(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized void resizetask(int n, int n2, int n3, long l, long l2) throws Error {
        this.p_resizetask(this.native_task, n, n2, n3, l, l2);
    }

    private native void p_resizetask(long var1, int var3, int var4, int var5, long var6, long var8) throws Error;

    public synchronized void sensitivityreport(streamtype streamtype2) throws Error {
        this.p_sensitivityreport(this.native_task, streamtype2.getValue());
    }

    private native void p_sensitivityreport(long var1, int var3) throws Error;

    public synchronized void setdefaults() throws Error {
        this.p_setdefaults(this.native_task);
    }

    private native void p_setdefaults(long var1) throws Error;

    public synchronized void solutiondef(soltype soltype2, boolean[] blArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (blArray != null && blArray.length > 0) {
            intBuffer.put(0, blArray[0] ? 1 : 0);
        }
        this.p_solutiondef(this.native_task, soltype2.getValue(), intBuffer);
        if (blArray != null && blArray.length > 0) {
            blArray[0] = intBuffer.get(0) != 0;
        }
    }

    private native void p_solutiondef(long var1, int var3, IntBuffer var4) throws Error;

    public synchronized boolean solutiondef(soltype soltype2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_solutiondef(this.native_task, soltype2.getValue(), intBuffer);
        return intBuffer.get(0) != 0;
    }

    public synchronized void solutionsummary(streamtype streamtype2) throws Error {
        this.p_solutionsummary(this.native_task, streamtype2.getValue());
    }

    private native void p_solutionsummary(long var1, int var3) throws Error;

    public synchronized void solvewithbasis(int n, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer2 = null;
        if (nArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer3 = intBuffer2 = nArray2 == null ? null : byteBuffer2.asIntBuffer();
        }
        if (intBuffer2 != null) {
            intBuffer2.position(0);
            intBuffer2.put(nArray2);
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (nArray2 != null && nArray2.length < this.getnumcon()) {
            throw new ArrayLengthException("solvewithbasis", "sub");
        }
        if (dArray != null && dArray.length < this.getnumcon()) {
            throw new ArrayLengthException("solvewithbasis", "val");
        }
        this.p_solvewithbasis(this.native_task, n, intBuffer, intBuffer2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (intBuffer2 != null) {
            intBuffer2.position(0);
            intBuffer2.get(nArray2);
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_solvewithbasis(long var1, int var3, IntBuffer var4, IntBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized int solvewithbasis(int n, int n2, int[] nArray, double[] dArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.put(0, n2);
        ByteBuffer byteBuffer2 = null;
        IntBuffer intBuffer2 = null;
        if (nArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer3 = intBuffer2 = nArray == null ? null : byteBuffer2.asIntBuffer();
        }
        if (intBuffer2 != null) {
            intBuffer2.position(0);
            intBuffer2.put(nArray);
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (nArray != null && nArray.length < this.getnumcon()) {
            throw new ArrayLengthException("solvewithbasis", "sub");
        }
        if (dArray != null && dArray.length < this.getnumcon()) {
            throw new ArrayLengthException("solvewithbasis", "val");
        }
        this.p_solvewithbasis(this.native_task, n, intBuffer, intBuffer2, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
        if (intBuffer2 != null) {
            intBuffer2.position(0);
            intBuffer2.get(nArray);
        }
        return intBuffer.get(0);
    }

    public synchronized void strtoconetype(String string, conetype[] conetypeArray) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer2.asIntBuffer();
        this.p_strtoconetype(this.native_task, byteBuffer, intBuffer);
        if (conetypeArray != null && conetypeArray.length > 0) {
            conetypeArray[0] = conetype.fromValue(intBuffer.get(0));
        }
    }

    private native void p_strtoconetype(long var1, ByteBuffer var3, IntBuffer var4) throws Error;

    public synchronized void strtosk(String string, int[] nArray) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer2.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_strtosk(this.native_task, byteBuffer, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_strtosk(long var1, ByteBuffer var3, IntBuffer var4) throws Error;

    public synchronized void toconic() throws Error {
        this.p_toconic(this.native_task);
    }

    private native void p_toconic(long var1) throws Error;

    public synchronized void updatesolutioninfo(soltype soltype2) throws Error {
        this.p_updatesolutioninfo(this.native_task, soltype2.getValue());
    }

    private native void p_updatesolutioninfo(long var1, int var3) throws Error;

    public synchronized void writedata(String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_writedata(this.native_task, byteBuffer);
    }

    private native void p_writedata(long var1, ByteBuffer var3) throws Error;

    public synchronized void writejsonsol(String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_writejsonsol(this.native_task, byteBuffer);
    }

    private native void p_writejsonsol(long var1, ByteBuffer var3) throws Error;

    public synchronized void writeparamfile(String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_writeparamfile(this.native_task, byteBuffer);
    }

    private native void p_writeparamfile(long var1, ByteBuffer var3) throws Error;

    public synchronized void writesolution(soltype soltype2, String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_writesolution(this.native_task, soltype2.getValue(), byteBuffer);
    }

    private native void p_writesolution(long var1, int var3, ByteBuffer var4) throws Error;

    public synchronized void writetask(String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_writetask(this.native_task, byteBuffer);
    }

    private native void p_writetask(long var1, ByteBuffer var3) throws Error;

    public synchronized void appendstat() throws Error {
        this.p_appendstat(this.native_task);
    }

    private native void p_appendstat(long var1) throws Error;

    public synchronized void getmionumthreads(int[] nArray) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        this.p_getmionumthreads(this.native_task, intBuffer);
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private native void p_getmionumthreads(long var1, IntBuffer var3) throws Error;

    public synchronized int getmionumthreads() throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        this.p_getmionumthreads(this.native_task, intBuffer);
        return intBuffer.get(0);
    }

    public synchronized void startstat() throws Error {
        this.p_startstat(this.native_task);
    }

    private native void p_startstat(long var1) throws Error;

    public synchronized void stopstat() throws Error {
        this.p_stopstat(this.native_task);
    }

    private native void p_stopstat(long var1) throws Error;

    @Override
    public synchronized void close() {
        this.dispose();
    }

    static {
        String string = "mosekjava8_1";
        try {
            String string2 = System.getProperty("os.name");
            String string3 = null;
            String string4 = null;
            if (string2.contains("OS X")) {
                string3 = ".jnilib";
                string4 = "lib";
            } else if (string2.contains("Windows")) {
                string3 = ".dll";
                string4 = "";
            } else {
                string3 = ".so";
                string4 = "lib";
            }
            String string5 = Env.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            String string6 = URLDecoder.decode(string5, "UTF-8");
            String string7 = string6.substring(0, string6.lastIndexOf(47) + 1) + string4 + string + string3;
            System.load(string7);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.loadLibrary(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

