/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.AccSolutionStatus;
import mosek.fusion.ProblemStatus;
import mosek.fusion.SolutionStatus;
import mosek.fusion.Utils.Tools;

public class SolutionStruct {
    public double[] snx;
    public double[] sux;
    public double[] slx;
    public double[][] bars;
    public double[][] barx;
    public double[] y;
    public double[] suc;
    public double[] slc;
    public double[] xx;
    public double[] xc;
    public double dobj;
    public double pobj;
    public ProblemStatus probstatus;
    public SolutionStatus dstatus;
    public SolutionStatus pstatus;
    public int sol_numbarvar;
    public int sol_numcone;
    public int sol_numvar;
    public int sol_numcon;

    public SolutionStruct(int n, int n2, int n3, int n4) {
        this.pobj = 0.0;
        this.dobj = 0.0;
        this.pstatus = SolutionStatus.Unknown;
        this.dstatus = SolutionStatus.Unknown;
        this.probstatus = ProblemStatus.Unknown;
        this.sol_numvar = n;
        this.sol_numcon = n2;
        this.sol_numcone = n3;
        this.sol_numbarvar = n4;
        this.slx = null;
        this.sux = null;
        this.xx = null;
        this.slc = null;
        this.suc = null;
        this.y = null;
        this.xc = null;
        this.snx = null;
        this.barx = null;
        this.bars = null;
        if (n > 0) {
            this.slx = new double[n];
            this.sux = new double[n];
            this.xx = new double[n];
        }
        if (n4 > 0) {
            this.barx = new double[n4][];
            this.bars = new double[n4][];
        }
        if (n2 > 0) {
            this.slc = new double[n2];
            this.suc = new double[n2];
            this.y = new double[n2];
            this.xc = new double[n2];
        }
        if (n3 > 0) {
            this.snx = new double[n];
        }
    }

    public SolutionStruct(SolutionStruct solutionStruct) {
        int n;
        int n2;
        double[][] dArrayArray;
        int n3;
        int n4;
        int n5;
        int n6;
        this.sol_numcon = solutionStruct.sol_numcon;
        this.sol_numvar = solutionStruct.sol_numvar;
        this.sol_numcone = solutionStruct.sol_numcone;
        this.sol_numbarvar = solutionStruct.sol_numbarvar;
        this.pstatus = solutionStruct.pstatus;
        this.dstatus = solutionStruct.dstatus;
        this.probstatus = solutionStruct.probstatus;
        this.pobj = solutionStruct.pobj;
        this.dobj = solutionStruct.dobj;
        this.xc = solutionStruct.xc != null ? Tools.arraycopy(solutionStruct.xc) : null;
        this.xx = solutionStruct.xx != null ? Tools.arraycopy(solutionStruct.xx) : null;
        this.slc = solutionStruct.slc != null ? Tools.arraycopy(solutionStruct.slx) : null;
        this.suc = solutionStruct.suc != null ? Tools.arraycopy(solutionStruct.sux) : null;
        double[] dArray = this.y = solutionStruct.y != null ? Tools.arraycopy(solutionStruct.y) : null;
        if (solutionStruct.barx != null) {
            n6 = 0;
            n5 = 0;
            n4 = solutionStruct.barx.length;
            n3 = n5 < n4 ? n4 - n5 : 0;
            dArrayArray = new double[n3][];
            n2 = n5;
            n = 0;
            while (n < n3) {
                dArrayArray[n6] = Tools.arraycopy(solutionStruct.barx[n2]);
                ++n6;
                ++n;
                ++n2;
            }
            this.barx = dArrayArray;
        } else {
            this.barx = null;
        }
        if (solutionStruct.bars != null) {
            n6 = 0;
            n5 = 0;
            n4 = solutionStruct.bars.length;
            n3 = n5 < n4 ? n4 - n5 : 0;
            dArrayArray = new double[n3][];
            n2 = n5;
            n = 0;
            while (n < n3) {
                dArrayArray[n6] = Tools.arraycopy(solutionStruct.bars[n2]);
                ++n6;
                ++n;
                ++n2;
            }
            this.bars = dArrayArray;
        } else {
            this.bars = null;
        }
        this.slx = solutionStruct.slx != null ? Tools.arraycopy(solutionStruct.slx) : null;
        this.sux = solutionStruct.sux != null ? Tools.arraycopy(solutionStruct.sux) : null;
        this.snx = solutionStruct.snx != null ? Tools.arraycopy(solutionStruct.snx) : null;
    }

    public SolutionStruct clone() {
        return new SolutionStruct(this);
    }

    public void resize(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (n4 >= 0) {
            if (n4 <= this.sol_numbarvar) {
                this.sol_numbarvar = n4;
            } else if (n <= this.barx.length) {
                n9 = this.sol_numvar;
                n8 = n;
                for (n7 = n9; n7 < n8; ++n7) {
                    this.barx[n7] = null;
                    this.bars[n7] = null;
                }
            } else {
                n9 = this.sol_numbarvar * 2 > n4 + 100 ? this.sol_numbarvar * 2 : n4 + 100;
                double[][] dArrayArray = new double[n9][];
                int n10 = 0;
                int n11 = this.barx.length;
                for (n6 = n10; n6 < n11; ++n6) {
                    dArrayArray[n6] = this.barx[n6];
                }
                this.barx = dArrayArray;
                double[][] dArrayArray2 = new double[n9][];
                n11 = 0;
                n6 = this.bars.length;
                for (n5 = n11; n5 < n6; ++n5) {
                    dArrayArray2[n5] = this.bars[n5];
                }
                this.bars = dArrayArray2;
                this.sol_numbarvar = n4;
            }
        }
        if (n >= 0) {
            if (n <= this.sol_numvar) {
                this.sol_numvar = n;
            } else if (n <= this.xx.length) {
                n9 = this.sol_numvar;
                n8 = n;
                for (n7 = n9; n7 < n8; ++n7) {
                    this.slx[n7] = 0.0;
                    this.sux[n7] = 0.0;
                    this.xx[n7] = 0.0;
                }
                this.sol_numvar = n;
            } else {
                n9 = this.sol_numvar * 2 > n + 100 ? this.sol_numvar * 2 : n + 100;
                double[] dArray = new double[n9];
                Tools.arraycopy(this.slx, 0, dArray, 0, this.slx.length);
                this.slx = dArray;
                double[] dArray2 = new double[n9];
                Tools.arraycopy(this.sux, 0, dArray2, 0, this.sux.length);
                this.sux = dArray2;
                double[] dArray3 = new double[n9];
                Tools.arraycopy(this.xx, 0, dArray3, 0, this.xx.length);
                this.xx = dArray3;
                for (n6 = this.sol_numvar; n6 < n && n6 < n; ++n6) {
                    this.slx[n6] = 0.0;
                    this.sux[n6] = 0.0;
                    this.xx[n6] = 0.0;
                }
                this.sol_numvar = n;
            }
        }
        if (n2 >= 0) {
            if (n2 <= this.sol_numcon) {
                this.sol_numcon = n2;
            } else if (n2 <= this.xx.length) {
                n9 = this.sol_numcon;
                int n12 = n2;
                for (int i = n9; i < n12; ++i) {
                    this.slc[i] = 0.0;
                    this.suc[i] = 0.0;
                    this.xc[i] = 0.0;
                    this.y[i] = 0.0;
                }
                this.sol_numcon = n2;
            } else {
                n9 = this.sol_numcon * 2 > n2 + 100 ? this.sol_numcon * 2 : n2 + 100;
                double[] dArray = new double[n9];
                Tools.arraycopy(this.slc, 0, dArray, 0, this.slc.length);
                this.slc = dArray;
                double[] dArray4 = new double[n9];
                Tools.arraycopy(this.suc, 0, dArray4, 0, this.suc.length);
                this.suc = dArray4;
                double[] dArray5 = new double[n9];
                Tools.arraycopy(this.xc, 0, dArray5, 0, this.xc.length);
                this.xc = dArray5;
                double[] dArray6 = new double[n9];
                Tools.arraycopy(this.y, 0, dArray6, 0, this.y.length);
                this.y = dArray6;
                n5 = this.sol_numcon;
                int n13 = n2;
                for (int i = n5; i < n13; ++i) {
                    this.slc[i] = 0.0;
                    this.suc[i] = 0.0;
                    this.xc[i] = 0.0;
                    this.y[i] = 0.0;
                }
                this.sol_numcon = n2;
            }
        }
        if (n3 >= 0) {
            if (n3 <= this.sol_numcone) {
                this.sol_numcone = n3;
            } else if (n3 <= this.xx.length) {
                n9 = this.sol_numcone;
                int n14 = n3;
                for (int i = n9; i < n14; ++i) {
                    this.snx[i] = 0.0;
                }
                this.sol_numcone = n3;
            } else {
                n9 = this.sol_numcone * 2 > n3 + 100 ? this.sol_numcone * 2 : n3 + 100;
                double[] dArray = new double[n9];
                Tools.arraycopy(this.snx, 0, dArray, 0, this.snx.length);
                this.snx = dArray;
                for (int i = this.sol_numcone; i < n3 && i < n3; ++i) {
                    this.snx[i] = 0.0;
                }
                this.sol_numcone = n3;
            }
        }
    }

    public boolean isDualAcceptable(AccSolutionStatus accSolutionStatus) {
        return this.isAcceptable(this.dstatus, accSolutionStatus);
    }

    public boolean isPrimalAcceptable(AccSolutionStatus accSolutionStatus) {
        return this.isAcceptable(this.pstatus, accSolutionStatus);
    }

    private boolean isAcceptable(SolutionStatus solutionStatus, AccSolutionStatus accSolutionStatus) {
        if (accSolutionStatus == AccSolutionStatus.Anything) {
            return true;
        }
        if (accSolutionStatus == AccSolutionStatus.Optimal) {
            return solutionStatus == SolutionStatus.Optimal;
        }
        if (accSolutionStatus == AccSolutionStatus.NearOptimal) {
            return solutionStatus == SolutionStatus.Optimal || solutionStatus == SolutionStatus.NearOptimal;
        }
        if (accSolutionStatus == AccSolutionStatus.Feasible) {
            return solutionStatus == SolutionStatus.Optimal || solutionStatus == SolutionStatus.NearOptimal || solutionStatus == SolutionStatus.Feasible;
        }
        if (accSolutionStatus == AccSolutionStatus.Certificate) {
            return solutionStatus == SolutionStatus.Certificate;
        }
        return false;
    }
}

