/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.BaseVariable;
import mosek.fusion.IndexError;
import mosek.fusion.Set;
import mosek.fusion.SolutionError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Variable;

public class SliceVariable
extends BaseVariable {
    private long[] strides;
    private long first;
    private Variable origin;

    protected SliceVariable(Variable variable, Set set, long l, long[] lArray) {
        super(variable.getModel(), set);
        this.origin = variable;
        this.first = l;
        this.strides = lArray;
    }

    @Override
    public void inst(long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        if (l < 0L || l >= this.shape_p.size) {
            throw new IndexError("Index out of bounds");
        }
        long l3 = this.first;
        long l4 = l;
        int n = 0;
        int n2 = this.shape_p.nd;
        for (int i = n; i < n2; ++i) {
            long l5 = l4 / this.shape_p.stride(i);
            l4 -= l5 * this.shape_p.stride(i);
            l3 += this.strides[i] * l5;
        }
        this.origin.inst(l3, l2, nArray, nArray2, nArray3);
    }

    @Override
    public void set_values(long l, int[] nArray, long[] lArray, int n, double[] dArray, boolean bl) {
        if (l == 0L && nArray.length == 1 && (long)nArray[0] == this.shape_p.size && lArray[0] == 1L) {
            int n2 = 0;
            int n3 = 0;
            int n4 = this.shape_p.nd;
            int n5 = n3 < n4 ? n4 - n3 : 0;
            int[] nArray2 = new int[n5];
            int n6 = n3;
            int n7 = 0;
            while (n7 < n5) {
                nArray2[n2] = this.shape_p.dim(n6);
                ++n2;
                ++n7;
                ++n6;
            }
            int[] nArray3 = nArray2;
            this.origin.set_values(this.first, nArray3, this.strides, n, dArray, bl);
        } else {
            int n8 = nArray.length;
            boolean bl2 = n8 == this.shape_p.nd;
            for (int i = 0; i < n8 && bl2 && i < n8 && bl2; ++i) {
                bl2 = lArray[i] == this.shape_p.stride(i);
            }
            if (bl2) {
                long l2 = this.first;
                long l3 = l;
                int n9 = 0;
                int n10 = this.shape_p.nd - 1;
                for (int i = n9; i < n10; ++i) {
                    long l4 = l3 / lArray[i];
                    l3 -= lArray[i] * l4;
                    l2 += this.shape_p.stride(i) * l4;
                }
                this.origin.set_values(l2, nArray, this.strides, n, dArray, bl);
            } else {
                int n11;
                long l5 = 1L;
                int n12 = 0;
                int n13 = nArray.length;
                for (int i = n12; i < n13; ++i) {
                    l5 *= (long)nArray[i];
                }
                long[] lArray2 = new long[(int)l5];
                Object[] objectArray = new int[nArray.length];
                long[] lArray3 = new long[nArray.length];
                long l6 = 0L;
                long l7 = l5;
                for (long i = l6; i < l7; ++i) {
                    int n14;
                    lArray2[(int)i] = this.origin.getShape().linearidx(this.shape_p.idxtokey(l + lArray3[0])) + this.first;
                    objectArray[0] = objectArray[0] + 1;
                    lArray3[0] = lArray3[0] + lArray[n8 - 1];
                    for (n14 = 0; n14 < n8 - 1 && objectArray[n14] >= nArray[n8 - n14 - 1]; ++n14) {
                        lArray3[n14 + 1] = lArray3[n14 + 1] + lArray[n8 - n14 - 2];
                        objectArray[n14] = 0;
                        int n15 = n14 + 1;
                        objectArray[n15] = objectArray[n15] + 1;
                    }
                    int n16 = 0;
                    n11 = n14;
                    for (int j = n16; j < n11; ++j) {
                        lArray3[j] = lArray3[n14];
                    }
                }
                if (n == 0) {
                    objectArray = dArray;
                } else {
                    int n17 = 0;
                    int n18 = 0;
                    long l8 = l5;
                    long l9 = (long)n18 < l8 ? l8 - (long)n18 : 0L;
                    double[] dArray2 = new double[(int)l9];
                    long l10 = n18;
                    n11 = 0;
                    while ((long)n11 < l9) {
                        dArray2[n17] = dArray[(int)(l10 + (long)n)];
                        ++n17;
                        ++n11;
                        ++l10;
                    }
                    objectArray = dArray2;
                }
                this.origin.set_values(lArray2, (double[])objectArray, bl);
            }
        }
    }

    @Override
    public void set_values(long[] lArray, double[] dArray, boolean bl) {
        long[] lArray2 = new long[lArray.length];
        int n = 0;
        int n2 = lArray.length;
        for (int i = n; i < n2; ++i) {
            int[] nArray = this.shape_p.idxtokey(lArray[i]);
            long l = this.first;
            int n3 = 0;
            int n4 = this.shape_p.nd;
            for (int j = n3; j < n4; ++j) {
                l += (long)nArray[j] * this.strides[j];
            }
            lArray2[i] = l;
        }
        this.origin.set_values(lArray2, dArray, bl);
    }

    @Override
    public StringBuffer elementDesc(long l, StringBuffer stringBuffer) {
        if (l < 0L || l >= this.shape_p.size) {
            throw new IndexError("Index out of bounds");
        }
        long l2 = this.first;
        long l3 = l;
        int n = 0;
        int n2 = this.shape_p.nd;
        for (int i = n; i < n2; ++i) {
            long l4 = l3 / this.shape_p.stride(i);
            l3 -= l4 * this.shape_p.stride(i);
            l2 += this.strides[i] * l4;
        }
        this.origin.elementDesc(l2, stringBuffer);
        return stringBuffer;
    }

    @Override
    public void elementName(long l, StringBuffer stringBuffer) {
        if (l < 0L || l >= this.shape_p.size) {
            throw new IndexError("Index out of bounds");
        }
        long l2 = this.first;
        long l3 = l;
        int n = 0;
        int n2 = this.shape_p.nd;
        for (int i = n; i < n2; ++i) {
            long l4 = l3 / this.shape_p.stride(i);
            l3 -= l4 * this.shape_p.stride(i);
            l2 += this.strides[i] * l4;
        }
        this.origin.elementName(l2, stringBuffer);
    }

    @Override
    public Variable slice(int[] nArray, int[] nArray2) {
        Set set = this.shape_p.slice(nArray, nArray2);
        long l = this.first;
        for (int i = 0; i < nArray.length && i < nArray.length; ++i) {
            l += this.strides[i] * (long)nArray[i];
        }
        return new SliceVariable(this.origin, set, l, this.strides);
    }

    @Override
    public Variable slice(int n, int n2) {
        return new SliceVariable(this.origin, this.shape_p.slice(n, n2), this.first + (long)n, this.strides);
    }

    @Override
    public void values(long l, int[] nArray, long[] lArray, int n, double[] dArray, boolean bl) throws SolutionError {
        if (l == 0L && nArray.length == 1 && (long)nArray[0] == this.shape_p.size && lArray[0] == 1L) {
            int n2 = 0;
            int n3 = 0;
            int n4 = this.shape_p.nd;
            int n5 = n3 < n4 ? n4 - n3 : 0;
            int[] nArray2 = new int[n5];
            int n6 = n3;
            int n7 = 0;
            while (n7 < n5) {
                nArray2[n2] = this.shape_p.dim(n6);
                ++n2;
                ++n7;
                ++n6;
            }
            int[] nArray3 = nArray2;
            this.origin.values(this.first, nArray3, this.strides, n, dArray, bl);
        } else {
            int n8 = nArray.length;
            boolean bl2 = n8 == this.shape_p.nd;
            for (int i = 0; i < n8 && bl2 && i < n8 && bl2; ++i) {
                bl2 = lArray[i] == this.shape_p.stride(i);
            }
            if (bl2) {
                long l2 = this.first;
                long l3 = l;
                int n9 = 0;
                int n10 = this.shape_p.nd - 1;
                for (int i = n9; i < n10; ++i) {
                    long l4 = l3 / lArray[i];
                    l3 -= lArray[i] * l4;
                    l2 += this.shape_p.stride(i) * l4;
                }
                this.origin.values(l2, nArray, this.strides, n, dArray, bl);
            } else {
                long l5 = 1L;
                int n11 = 0;
                int n12 = nArray.length;
                for (int i = n11; i < n12; ++i) {
                    l5 *= (long)nArray[i];
                }
                long[] lArray2 = new long[(int)l5];
                int[] nArray4 = new int[nArray.length];
                long[] lArray3 = new long[nArray.length];
                long l6 = 0L;
                long l7 = l5;
                for (long i = l6; i < l7; ++i) {
                    int n13;
                    lArray2[(int)i] = this.origin.getShape().linearidx(this.shape_p.idxtokey(l + lArray3[0])) + this.first;
                    nArray4[0] = nArray4[0] + 1;
                    lArray3[0] = lArray3[0] + lArray[n8 - 1];
                    for (n13 = 0; n13 < n8 - 1 && nArray4[n13] >= nArray[n8 - n13 - 1]; ++n13) {
                        lArray3[n13 + 1] = lArray3[n13 + 1] + lArray[n8 - n13 - 2];
                        nArray4[n13] = 0;
                        int n14 = n13 + 1;
                        nArray4[n14] = nArray4[n14] + 1;
                    }
                    int n15 = 0;
                    int n16 = n13;
                    for (int j = n15; j < n16; ++j) {
                        lArray3[j] = lArray3[n13];
                    }
                }
                this.origin.values(lArray2, n, dArray, bl);
            }
        }
    }

    @Override
    public void values(long[] lArray, int n, double[] dArray, boolean bl) throws SolutionError {
        long[] lArray2 = new long[lArray.length];
        int n2 = 0;
        int n3 = lArray.length;
        for (int i = n2; i < n3; ++i) {
            int[] nArray = this.shape_p.idxtokey(lArray[i]);
            long l = this.first;
            int n4 = 0;
            int n5 = this.shape_p.nd;
            for (int j = n4; j < n5; ++j) {
                l += (long)nArray[j] * this.strides[j];
            }
            lArray2[i] = l;
        }
        this.origin.values(lArray2, n, dArray, bl);
    }

    @Override
    public void make_continuous(long[] lArray) {
        long[] lArray2 = new long[lArray.length];
        int n = 0;
        int n2 = lArray.length;
        for (int i = n; i < n2; ++i) {
            int[] nArray = this.shape_p.idxtokey(lArray[i]);
            long l = this.first;
            int n3 = 0;
            int n4 = this.shape_p.nd;
            for (int j = n3; j < n4; ++j) {
                l += (long)nArray[j] * this.strides[j];
            }
            lArray2[i] = l;
        }
        this.origin.make_continuous(lArray2);
    }

    @Override
    public void make_integer(long[] lArray) {
        long[] lArray2 = new long[lArray.length];
        int n = 0;
        int n2 = lArray.length;
        for (int i = n; i < n2; ++i) {
            int[] nArray = this.shape_p.idxtokey(lArray[i]);
            long l = this.first;
            int n3 = 0;
            int n4 = this.shape_p.nd;
            for (int j = n3; j < n4; ++j) {
                l += (long)nArray[j] * this.strides[j];
            }
            lArray2[i] = l;
        }
        this.origin.make_integer(lArray2);
    }
}

