/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.CommonTools;
import mosek.fusion.Constraint;
import mosek.fusion.ConstraintCache;
import mosek.fusion.IndexError;
import mosek.fusion.LengthError;
import mosek.fusion.Model;
import mosek.fusion.Set;
import mosek.fusion.SliceConstraint;
import mosek.fusion.UnimplementedError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;

public abstract class ModelConstraint
extends Constraint {
    private boolean names_flushed;
    protected int[] nativeindexes;
    protected String name;
    protected double[] cache_bfix;
    protected ConstraintCache cache;

    protected ModelConstraint(ModelConstraint modelConstraint, Model model) {
        super(modelConstraint, model);
        this.cache = modelConstraint.cache.clone();
        int n = 0;
        int n2 = 0;
        int n3 = modelConstraint.nativeindexes.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray[n] = modelConstraint.nativeindexes[n5];
            ++n;
            ++n6;
            ++n5;
        }
        this.nativeindexes = nArray;
        this.name = modelConstraint.name;
        n6 = 0;
        int n7 = 0;
        int n8 = modelConstraint.cache_bfix.length;
        int n9 = n7 < n8 ? n8 - n7 : 0;
        double[] dArray = new double[n9];
        int n10 = n7;
        int n11 = 0;
        while (n11 < n9) {
            dArray[n6] = modelConstraint.cache_bfix[n10];
            ++n6;
            ++n11;
            ++n10;
        }
        this.cache_bfix = dArray;
        this.names_flushed = modelConstraint.names_flushed;
    }

    protected ModelConstraint(Model model, String string, Set set, int[] nArray, long[] lArray, int[] nArray2, double[] dArray, double[] dArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        super(model, set);
        this.cache = new ConstraintCache(lArray, dArray, nArray2, dArray2, nArray3, nArray4, nArray5);
        this.nativeindexes = nArray;
        this.name = string;
        this.cache_bfix = dArray2 != null ? Tools.arraycopy(dArray2) : new double[nArray.length];
        this.names_flushed = false;
    }

    protected void flushNames() {
        if (!this.names_flushed && this.name.length() > 0) {
            int n = 0;
            int n2 = this.nativeindexes.length;
            for (int i = n; i < n2; ++i) {
                this.model.task_con_name(this.nativeindexes[i], this.name.length() == 0 ? "" : new StringBuffer().a(this.name).a("[").a(this.shape_p.getname(i)).a("]").toString());
            }
            this.names_flushed = true;
        }
    }

    @Override
    public String toString() {
        int n;
        long l = this.shape_p.size;
        String[] stringArray = new String[(int)l];
        this.toStringArray(Tools.range(l), 0L, stringArray);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("Constraint( ");
        if (this.name.length() > 0) {
            stringBuffer.a("'").a(this.name).a("', ");
        }
        stringBuffer.a("(").a(this.shape_p.dim(0));
        int n2 = 1;
        int n3 = this.shape_p.nd;
        for (n = n2; n < n3; ++n) {
            stringBuffer.a(",").a(this.shape_p.dim(n));
        }
        stringBuffer.a("),").lf();
        if (stringArray.length > 0) {
            stringBuffer.a("  ").a(stringArray[0]);
            n2 = 1;
            n3 = stringArray.length;
            for (n = n2; n < n3; ++n) {
                stringBuffer.a(",").lf().a("  ").a(stringArray[n]);
            }
        }
        stringBuffer.a(" )");
        return stringBuffer.toString();
    }

    @Override
    protected void toStringArray(long[] lArray, long l, String[] stringArray) {
        int n = 0;
        int n2 = lArray.length;
        for (int i = n; i < n2; ++i) {
            if (lArray[i] >= 0L && lArray[i] < this.shape_p.size) continue;
            throw new IndexError("Constraint index out of bounds");
        }
        if ((long)lArray.length + l > (long)stringArray.length) {
            throw new LengthError("Result array is too small to hold the result");
        }
        StringBuffer stringBuffer = new StringBuffer();
        n2 = 0;
        long l2 = this.cache.order_barentries();
        int n3 = 0;
        int n4 = 0;
        int n5 = lArray.length;
        for (int i = n4; i < n5; ++i) {
            int n6;
            long l3 = lArray[i];
            int n7 = this.nativeindexes[(int)l3];
            int n8 = n2;
            while ((long)n2 < this.cache.nnz && (long)this.cache.subi[n2] == l3) {
                ++n2;
            }
            stringBuffer.clear().a(this.name).a("[").a(this.shape_p.indexToString(l3)).a("] : ");
            int n9 = n8;
            int n10 = n2;
            for (n6 = n9; n6 < n10; ++n6) {
                double d = this.cache.cof[n6];
                if (d > 0.0) {
                    stringBuffer.a(" + ").a(d).a(" ");
                    this.model.nativeVarToStr(this.cache.subj[n6], stringBuffer);
                    continue;
                }
                if (!(d < 0.0)) continue;
                stringBuffer.a(" - ").a(-d).a(" ");
                this.model.nativeVarToStr(this.cache.subj[n6], stringBuffer);
            }
            while ((long)n3 < l2 && (long)this.cache.barsubi[n3] < l3) {
                ++n3;
            }
            n9 = n3;
            while ((long)n9 < l2 && (long)this.cache.barsubi[n9] == l3) {
                ++n9;
            }
            while (n3 < n9 && (long)this.cache.barsubi[n3] == l3) {
                n10 = n3;
                n6 = this.cache.barsubj[n3];
                ++n3;
                while (n3 < n9 && this.cache.barsubj[n3] == n6) {
                    ++n3;
                }
                stringBuffer.a(" + < M").a(this.cache.barmatidx[n10]);
                int n11 = n10 + 1;
                int n12 = n3;
                for (int j = n11; j < n12; ++j) {
                    stringBuffer.a(" + M").a(this.cache.barmatidx[j]);
                }
                stringBuffer.a(" ; ").a(this.model.vars[this.model.natbarvarmap_Var[this.cache.barsubj[n10]]].name.length() > 0 ? this.model.vars[this.model.natbarvarmap_Var[this.cache.barsubj[n10]]].name : "_").a(" >");
            }
            if (this.cache_bfix != null) {
                if (this.cache_bfix[(int)l3] > 0.0) {
                    stringBuffer.a(" + ").a(this.cache_bfix[(int)l3]);
                } else if (this.cache_bfix[(int)l3] < 0.0) {
                    stringBuffer.a(" + ").a(this.cache_bfix[(int)l3]);
                }
            }
            stringBuffer.a(" ");
            this.domainToString(l3, stringBuffer);
            stringArray[(int)((long)i + l)] = stringBuffer.toString();
        }
    }

    protected abstract void domainToString(long var1, StringBuffer var3);

    @Override
    protected void add_l(long[] lArray, long[] lArray2, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray, double[] dArray2, long l, int n, int n2) {
        int n3;
        int n4;
        long l2;
        int n5;
        int n6 = 1;
        int n7 = lArray.length;
        for (n5 = n6; n5 < n7; ++n5) {
            if (lArray[n5 - 1] < lArray[n5]) continue;
            throw new UnimplementedError("Not supported: Non-contiguous index ranges in ModelConstraint.add_l");
        }
        if (lArray2[n + n2] <= lArray2[n] && dArray2 == null) {
            return;
        }
        long[] lArray3 = new long[(int)(lArray2[n + n2] - lArray2[n])];
        long l3 = 0L;
        long l4 = lArray2[n + n2] - lArray2[n];
        for (l2 = l3; l2 < l4; ++l2) {
            lArray3[(int)l2] = lArray2[n] + l2;
        }
        int n8 = 0;
        n5 = n2;
        for (int i = n8; i < n5; ++i) {
            CommonTools.argQsort(lArray3, nArray, null, lArray2[n + i], lArray2[n + i + 1]);
        }
        n8 = 0;
        n5 = 0;
        long l5 = lArray2[n];
        l2 = lArray2[n + n2];
        for (long i = l5; i < l2; ++i) {
            if (nArray[(int)i] >= 0) {
                ++n8;
                continue;
            }
            ++n5;
        }
        if (n8 > 0 || dArray2 != null) {
            long l6;
            long l7;
            long l8;
            long[] lArray4 = new long[this.cache.nrows + 1];
            int[] nArray4 = new int[n8];
            double[] dArray3 = new double[n8];
            double[] dArray4 = null;
            if (dArray2 != null) {
                dArray4 = new double[this.cache.nrows];
                int n9 = 0;
                n4 = n2;
                for (n3 = n9; n3 < n4; ++n3) {
                    dArray4[(int)(lArray[n3 + n] - l)] = dArray2[n + n3];
                }
            }
            lArray4[0] = 0L;
            int n10 = n;
            n4 = 0;
            n3 = this.cache.nrows;
            for (int i = n4; i < n3; ++i) {
                if (n10 < n2 && lArray[n10] - l == (long)i) {
                    long l9 = lArray4[i];
                    l8 = lArray2[n10];
                    l7 = lArray2[n10 + 1];
                    for (l6 = l8; l6 < l7; ++l6) {
                        if (nArray[(int)l6] < 0) continue;
                        nArray4[(int)l9] = nArray[(int)l6];
                        dArray3[(int)l9] = dArray[(int)l6];
                        ++l9;
                    }
                    lArray4[i + 1] = l9;
                    ++n10;
                    continue;
                }
                lArray4[i + 1] = lArray4[i];
            }
            this.cache.add(lArray4, nArray4, dArray3, dArray4);
            n4 = this.cache.nrows;
            n3 = (int)this.cache.numUnsorted();
            int[] nArray5 = new int[n3];
            int[] nArray6 = new int[n3];
            double[] dArray5 = new double[n3];
            l8 = this.cache.flush(nArray5, nArray6, dArray5, null);
            l7 = 0L;
            l6 = l8;
            for (long i = l7; i < l6; ++i) {
                nArray5[(int)i] = this.nativeindexes[nArray5[(int)i]];
            }
            this.model.task_putaijlist(nArray5, nArray6, dArray5, l8);
            if (dArray2 != null) {
                this.add_fx(lArray, this.cache.bfix, l, n, n2);
            }
        }
        if (n5 > 0) {
            long l10;
            int n11 = 0;
            long l11 = lArray2[n];
            int n12 = 0;
            int n13 = n2;
            for (n4 = n12; n4 < n13; ++n4) {
                if (nArray[(int)lArray3[(int)(lArray2[n] - l11)]] >= 0) continue;
                n3 = 1;
                long l12 = lArray2[n + n4] - l11 + 1L;
                long l13 = lArray2[n + n4 + 1] - l11;
                for (l10 = l12; l10 < l13; ++l10) {
                    if (nArray[(int)lArray3[(int)l10]] >= 0 || nArray[(int)lArray3[(int)l10]] == nArray[(int)lArray3[(int)(l10 - 1L)]]) continue;
                    ++n3;
                }
                n11 += n3;
            }
            int[] nArray7 = new int[n11];
            int[] nArray8 = new int[n11];
            int[] nArray9 = new int[n11];
            int[] nArray10 = new int[n11];
            long l14 = lArray2[n];
            int n14 = 0;
            int n15 = 0;
            int n16 = n2;
            for (int i = n15; i < n16; ++i) {
                l10 = lArray2[n + i] - l14;
                long l15 = lArray2[n + i + 1] - l14;
                if (nArray[(int)lArray3[(int)l10]] >= 0) continue;
                while (l10 < l15 && nArray[(int)lArray3[(int)l10]] < 0) {
                    double[] dArray6;
                    int[] nArray11;
                    int[] nArray12;
                    int n17;
                    nArray8[n14] = (int)lArray[n + i];
                    nArray7[n14] = this.nativeindexes[(int)lArray[n + i]];
                    nArray9[n14] = -nArray[(int)lArray3[(int)l10]] - 1;
                    long l16 = l10;
                    while (l10 < l15 && nArray[(int)lArray3[(int)l10]] < 0 && nArray[(int)lArray3[(int)l10]] == nArray[(int)lArray3[(int)l16]]) {
                        ++l10;
                    }
                    boolean bl = true;
                    if (l10 - l16 > 1L) {
                        CommonTools.argQsort(lArray3, nArray2, nArray3, l16, l10 - l16);
                        n17 = 1;
                        long l17 = 1L;
                        long l18 = l10 - l16;
                        for (long j = l17; j < l18; ++j) {
                            if (nArray2[(int)lArray3[(int)(l10 + j - 1L)]] == nArray2[(int)lArray3[(int)(l10 + j)]] && nArray3[(int)lArray3[(int)(l10 + j - 1L)]] == nArray3[(int)lArray3[(int)(l10 + j)]]) continue;
                            ++n17;
                        }
                        nArray12 = new int[n17];
                        nArray11 = new int[n17];
                        dArray6 = new double[n17];
                        nArray12[0] = nArray2[(int)lArray3[0]];
                        nArray11[0] = nArray3[(int)lArray3[0]];
                        dArray6[0] = dArray[(int)lArray3[0]];
                        int n18 = 0;
                        long l19 = 1L;
                        long l20 = l10 - l16;
                        for (long j = l19; j < l20; ++j) {
                            if (nArray12[(int)lArray3[(int)(l10 + j - 1L)]] != nArray12[(int)lArray3[(int)(l10 + j)]] || nArray11[(int)lArray3[(int)(l10 + j - 1L)]] != nArray11[(int)lArray3[(int)(l10 + j)]]) {
                                nArray12[++n18] = nArray2[(int)lArray3[(int)(l10 + j)]];
                                nArray11[n18] = nArray3[(int)lArray3[(int)(l10 + j)]];
                            }
                            dArray6[n18] = dArray6[n18] + dArray[(int)lArray3[(int)(l10 + j)]];
                        }
                    } else {
                        nArray12 = new int[]{nArray2[(int)lArray3[(int)l16]]};
                        nArray11 = new int[]{nArray3[(int)lArray3[(int)l16]]};
                        dArray6 = new double[]{dArray[(int)lArray3[(int)l16]]};
                    }
                    nArray10[n14] = n17 = this.model.task_append_barmatrix(this.model.task_barvardim(nArray9[n14]), nArray12, nArray11, dArray6);
                    ++n14;
                }
            }
            this.cache.add_bar(nArray8, nArray9, nArray10);
        }
    }

    protected abstract void add_fx(long[] var1, double[] var2, long var3, int var5, int var6);

    @Override
    public Constraint slice(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new LengthError("Mismatching array lengths");
        }
        Set set = this.shape_p.slice(nArray, nArray2);
        long[] lArray = new long[this.shape_p.nd];
        lArray[this.shape_p.nd - 1] = 1L;
        for (int i = this.shape_p.nd - 1; i > 0 && i > 0; --i) {
            lArray[i - 1] = lArray[i] * (long)this.shape_p.dim(i);
        }
        long l = 0L;
        int n = 0;
        int n2 = lArray.length;
        for (int i = n; i < n2; ++i) {
            l += lArray[i] * (long)nArray[i];
        }
        return new SliceConstraint(this, set, l, lArray);
    }

    @Override
    public Constraint slice(int n, int n2) {
        long[] lArray = new long[]{1L};
        return new SliceConstraint(this, this.shape_p.slice(n, n2), n, lArray);
    }

    protected abstract ModelConstraint clone(Model var1);
}

