/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.RelationKey;
import mosek.fusion.Set;
import mosek.fusion.SymmetricLinearDomain;
import mosek.fusion.Utils.IntMap;
import mosek.fusion.Utils.StringBuffer;

public class LinearDomain {
    protected boolean sparse_flag;
    protected boolean cardinal_flag;
    protected RelationKey key;
    private double[] bnd;
    private IntMap inst;
    protected Set shape;

    protected LinearDomain(RelationKey relationKey, double[] dArray, long[] lArray, int[] nArray) {
        this.shape = nArray != null ? Set.make(nArray) : null;
        this.key = relationKey;
        this.bnd = dArray;
        if (lArray != null) {
            this.inst = new IntMap();
            int n = 0;
            int n2 = lArray.length;
            for (int i = n; i < n2; ++i) {
                this.inst.setItem(lArray[i], i);
            }
        } else {
            this.inst = null;
        }
        this.cardinal_flag = false;
        this.sparse_flag = false;
    }

    protected LinearDomain(LinearDomain linearDomain) {
        this.shape = linearDomain.shape;
        this.inst = linearDomain.inst;
        this.bnd = linearDomain.bnd;
        this.key = linearDomain.key;
        this.cardinal_flag = linearDomain.cardinal_flag;
        this.sparse_flag = linearDomain.sparse_flag;
    }

    public SymmetricLinearDomain symmetric() {
        return new SymmetricLinearDomain(this);
    }

    public LinearDomain sparse() {
        this.sparse_flag = true;
        return this;
    }

    public LinearDomain integral() {
        this.cardinal_flag = true;
        return this;
    }

    protected String domainToString(long l, StringBuffer stringBuffer) {
        if (this.key == RelationKey.EqualsTo) {
            stringBuffer.a(" = ").a(this.get_rhs_item(l));
        } else if (this.key == RelationKey.LessThan) {
            stringBuffer.a(" <= ").a(this.get_rhs_item(l));
        } else if (this.key == RelationKey.GreaterThan) {
            stringBuffer.a(" >= ").a(this.get_rhs_item(l));
        } else if (this.key == RelationKey.IsFree) {
            stringBuffer.a(" is unbounded");
        }
        return stringBuffer.toString();
    }

    protected boolean match_shape(Set set) {
        if (this.shape == null) {
            return true;
        }
        return this.shape.compare(set);
    }

    protected double get_rhs_item(long l) {
        if (this.inst != null) {
            if (this.inst.hasItem(l)) {
                return this.bnd[this.inst.getItem(l)];
            }
            return 0.0;
        }
        if (this.scalable()) {
            return this.bnd != null ? this.bnd[0] : 0.0;
        }
        return this.bnd != null ? this.bnd[(int)l] : 0.0;
    }

    private boolean scalable() {
        return this.bnd == null || this.bnd.length == 1 && this.inst == null;
    }
}

