/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.CommonTools;
import mosek.fusion.DenseMatrix;
import mosek.fusion.DimensionError;
import mosek.fusion.Expression;
import mosek.fusion.ExpressionError;
import mosek.fusion.FlatExpr;
import mosek.fusion.IndexCounter;
import mosek.fusion.IndexError;
import mosek.fusion.IntSet;
import mosek.fusion.LengthError;
import mosek.fusion.Matrix;
import mosek.fusion.MatrixError;
import mosek.fusion.Model;
import mosek.fusion.ModelError;
import mosek.fusion.NDSet;
import mosek.fusion.NDSparseArray;
import mosek.fusion.Set;
import mosek.fusion.Sort;
import mosek.fusion.SparseFormatError;
import mosek.fusion.SparseMatrix;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;
import mosek.fusion.Variable;

public final class Expr
implements Expression {
    private long[] varsb;
    private long[] inst;
    private double[] cof_v;
    private Variable[] x;
    private long[] subj;
    private long[] ptrb;
    private double[] bfix;
    private Set shape_p;
    private Model model;

    public Expr(long[] lArray, Variable[] variableArray, long[] lArray2, double[] dArray, double[] dArray2, Set set, long[] lArray3) {
        this.model = Expr.extractModel(variableArray);
        this.shape_p = set;
        this.x = variableArray;
        this.varsb = new long[this.x.length + 1];
        int n = 0;
        int n2 = this.x.length;
        for (int i = n; i < n2; ++i) {
            this.varsb[i + 1] = this.varsb[i] + this.x[i].shape().size;
        }
        n = lArray.length - 1;
        long l = lArray[lArray.length - 1];
        Expr.validateData(lArray, variableArray, lArray2, dArray, dArray2, this.shape_p, lArray3);
        this.inst = (long[])(lArray3 != null ? Tools.arraycopy(lArray3) : null);
        this.shape_p = set == null ? Set.make(lArray.length - 1) : set;
        this.subj = new long[(int)l];
        this.cof_v = new double[(int)l];
        this.ptrb = new long[lArray.length];
        this.bfix = dArray2 == null ? null : new double[dArray2.length];
        Tools.arraycopy(lArray, 0, this.ptrb, 0, this.ptrb.length);
        Tools.arraycopy(lArray2, 0L, this.subj, 0L, l);
        Tools.arraycopy(dArray, 0L, this.cof_v, 0L, l);
        if (this.bfix != null) {
            Tools.arraycopy(dArray2, 0, this.bfix, 0, this.bfix.length);
        }
    }

    protected Expr(long[] lArray, Variable[] variableArray, long[] lArray2, double[] dArray, double[] dArray2, Set set, long[] lArray3, int n) {
        this.model = Expr.extractModel(variableArray);
        this.shape_p = set;
        this.x = variableArray;
        this.ptrb = lArray;
        this.subj = lArray2;
        this.cof_v = dArray;
        if (this.subj.length != this.cof_v.length) {
            throw new SparseFormatError("Mismatching subj and cof");
        }
        this.varsb = new long[this.x.length + 1];
        int n2 = 0;
        int n3 = this.x.length;
        for (int i = n2; i < n3; ++i) {
            this.varsb[i + 1] = this.varsb[i] + this.x[i].shape().size;
        }
        this.bfix = dArray2;
        this.shape_p = set == null ? new IntSet(lArray.length - 1) : set;
        this.inst = lArray3;
    }

    protected Expr(Expression expression) {
        Expression expression2 = expression;
        if (expression2 instanceof Expr) {
            Expr expr = (Expr)expression2;
            this.model = expr.model;
            this.shape_p = expr.shape_p;
            this.ptrb = expr.ptrb;
            this.subj = expr.subj;
            this.x = expr.x;
            this.cof_v = expr.cof_v;
            this.bfix = expr.bfix;
            this.varsb = expr.varsb;
            this.inst = expr.inst;
        } else {
            Expression expression3 = expression2;
            FlatExpr flatExpr = expression3.eval();
            this.model = expression.getModel();
            this.shape_p = flatExpr.shape;
            this.ptrb = flatExpr.ptrb;
            this.subj = flatExpr.subj;
            this.x = flatExpr.x;
            this.cof_v = flatExpr.cof;
            this.bfix = flatExpr.bfix;
            this.varsb = new long[this.x.length + 1];
            int n = 0;
            int n2 = this.x.length;
            for (int i = n; i < n2; ++i) {
                this.varsb[i + 1] = this.varsb[i] + this.x[i].shape().size;
            }
            this.inst = flatExpr.inst;
        }
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("Expr(ndim=(").a(this.shape_p.dim(0));
        int n2 = 1;
        int n3 = this.shape_p.nd;
        for (n = n2; n < n3; ++n) {
            stringBuffer.a(",").a(this.shape_p.dim(n));
        }
        stringBuffer.a("),\n     [ ");
        if (this.ptrb.length > 1) {
            if (this.inst == null) {
                this.tostr(stringBuffer, 0);
                n2 = 1;
                n3 = this.ptrb.length - 1;
                for (n = n2; n < n3; ++n) {
                    stringBuffer.a(",\n       ");
                    this.tostr(stringBuffer, n);
                }
            } else if (this.inst.length > 0) {
                stringBuffer.a("(").a(this.shape_p.idxtokey(this.inst[0])).a(") -> ");
                this.tostr(stringBuffer, 0);
                n2 = 1;
                n3 = this.ptrb.length - 1;
                for (n = n2; n < n3; ++n) {
                    stringBuffer.a(",\n       (").a(this.shape_p.idxtokey(this.inst[n])).a(") -> ");
                    this.tostr(stringBuffer, n);
                }
            }
        }
        stringBuffer.a(" ])");
        return stringBuffer.toString();
    }

    private void tostr(StringBuffer stringBuffer, int n) {
        long l = this.ptrb[n];
        long l2 = this.ptrb[n + 1];
        for (long i = l; i < l2; ++i) {
            int n2;
            long l3 = this.subj[(int)i];
            double d = this.cof_v[(int)i];
            if (d < 0.0) {
                n2 = 0;
                while (this.varsb[n2 + 1] <= l3) {
                    ++n2;
                }
                if (d < -1.0 || d > -1.0) {
                    stringBuffer.a(" - ").a(-d).a(" ");
                } else {
                    stringBuffer.a(" - ").a(" ");
                }
                this.x[n2].elementName(l3 - this.varsb[n2], stringBuffer);
                continue;
            }
            n2 = 0;
            while (this.varsb[n2 + 1] <= l3) {
                ++n2;
            }
            if (d < 1.0 || d > 1.0) {
                stringBuffer.a(" + ").a(d).a(" ");
            } else {
                stringBuffer.a(" + ").a(" ");
            }
            this.x[n2].elementName(l3 - this.varsb[n2], stringBuffer);
        }
        if (this.bfix != null) {
            if (this.bfix[n] < 0.0) {
                stringBuffer.a(" - ").a(-this.bfix[n]);
            } else {
                stringBuffer.a(" + ").a(this.bfix[n]);
            }
        }
    }

    private static Variable[] varstack(Variable[][] variableArray) {
        int n = 0;
        Variable[] variableArray2 = new Variable[1024];
        int n2 = 0;
        int n3 = variableArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            int n8 = variableArray[n5].length;
            int n9 = n7 < n8 ? n8 - n7 : 0;
            int n10 = n7;
            int n11 = 0;
            while (n11 < n9) {
                if (variableArray2.length == n) {
                    Variable[] variableArray3 = new Variable[2 * variableArray2.length];
                    System.arraycopy(variableArray2, 0, variableArray3, 0, variableArray2.length);
                    variableArray2 = variableArray3;
                }
                variableArray2[n] = variableArray[n5][n10];
                ++n;
                ++n11;
                ++n10;
            }
            ++n6;
            ++n5;
        }
        if (variableArray2.length > n) {
            Variable[] variableArray4 = new Variable[n];
            System.arraycopy(variableArray2, 0, variableArray4, 0, n);
            variableArray2 = variableArray4;
        }
        return variableArray2;
    }

    private static Variable[] varstack(Variable[] variableArray, Variable[] variableArray2) {
        int n;
        if (variableArray == null) {
            return variableArray2;
        }
        if (variableArray2 == null) {
            return variableArray;
        }
        Variable[] variableArray3 = new Variable[variableArray.length + variableArray2.length];
        int n2 = 0;
        int n3 = variableArray.length;
        for (n = n2; n < n3; ++n) {
            variableArray3[n] = variableArray[n];
        }
        n2 = 0;
        n3 = variableArray2.length;
        for (n = n2; n < n3; ++n) {
            variableArray3[n + variableArray.length] = variableArray2[n];
        }
        return variableArray3;
    }

    public static Expression flatten(Expression expression) {
        if (expression == null) {
            throw new NullPointerException("Arguments for flatten may not be null");
        }
        return Expr.reshape(expression, (int)expression.shape().size);
    }

    public static Expression reshape(Expression expression, int n, int n2) {
        if (expression == null) {
            throw new NullPointerException("Arguments for reshape may not be null");
        }
        return Expr.reshape(expression, new NDSet(n, n2));
    }

    public static Expression reshape(Expression expression, int n) {
        if (expression == null) {
            throw new NullPointerException("Arguments for reshape may not be null");
        }
        return Expr.reshape(expression, new IntSet(n));
    }

    public static Expression reshape(Expression expression, Set set) {
        if (expression == null || set == null) {
            throw new NullPointerException("Arguments for reshape may not be null");
        }
        if (set.size != expression.shape().size) {
            throw new DimensionError("New shape has wrong number of elements");
        }
        Expression expression2 = expression;
        if (expression2 instanceof Expr) {
            Expr expr = (Expr)expression2;
            return new Expr(expr.ptrb, expr.x, expr.subj, expr.cof_v, expr.bfix, set, expr.inst, 1);
        }
        Expression expression3 = expression2;
        FlatExpr flatExpr = expression.eval();
        return new Expr(flatExpr.ptrb, flatExpr.x, flatExpr.subj, flatExpr.cof, flatExpr.bfix, set, flatExpr.inst, 1);
    }

    public long size() {
        return (long)this.ptrb.length - 1L;
    }

    @Override
    public FlatExpr eval() {
        double[] dArray = this.bfix == null ? null : Tools.arraycopy(this.bfix);
        long[] lArray = this.inst == null ? null : Tools.arraycopy(this.inst);
        return new FlatExpr(dArray, Tools.arraycopy(this.ptrb), Tools.arraycopy(this.subj), this.x, Tools.arraycopy(this.cof_v), this.shape_p, this.inst);
    }

    public static Expression zeros(int n) {
        long[] lArray = Tools.makevector(0L, 1 + n);
        Variable[] variableArray = new Variable[]{};
        long[] lArray2 = new long[]{};
        double[] dArray = new double[]{};
        double[] dArray2 = Tools.zeros(n);
        return new Expr(lArray, variableArray, lArray2, dArray, dArray2, null, null, 1);
    }

    public static Expression ones(int n) {
        long[] lArray = Tools.makevector(0L, 1 + n);
        long[] lArray2 = new long[]{};
        double[] dArray = new double[]{};
        double[] dArray2 = Tools.ones(n);
        return new Expr(lArray, new Variable[0], lArray2, dArray, dArray2, null, null, 1);
    }

    public static Expression constTerm(NDSparseArray nDSparseArray) {
        Set set = Set.make(nDSparseArray.dims);
        long[] lArray = new long[nDSparseArray.inst.length + 1];
        Variable[] variableArray = new Variable[]{};
        long[] lArray2 = new long[]{};
        double[] dArray = new double[]{};
        double[] dArray2 = Tools.arraycopy(nDSparseArray.cof);
        long[] lArray3 = Tools.arraycopy(nDSparseArray.inst);
        return new Expr(lArray, variableArray, lArray2, dArray, dArray2, set, lArray3);
    }

    public static Expression constTerm(Matrix matrix) {
        Set set = Set.make(matrix.numRows(), matrix.numColumns());
        long[] lArray = new long[(int)(matrix.numNonzeros() + 1L)];
        Variable[] variableArray = new Variable[]{};
        long[] lArray2 = new long[]{};
        double[] dArray = new double[]{};
        double[] dArray2 = null;
        long[] lArray3 = null;
        if (matrix.isSparse()) {
            int[] nArray = new int[(int)matrix.numNonzeros()];
            int[] nArray2 = new int[(int)matrix.numNonzeros()];
            double[] dArray3 = new double[(int)matrix.numNonzeros()];
            matrix.getDataAsTriplets(nArray, nArray2, dArray3);
            dArray2 = dArray3;
            int n = 0;
            int n2 = 0;
            long l = matrix.numNonzeros();
            long l2 = (long)n2 < l ? l - (long)n2 : 0L;
            long[] lArray4 = new long[(int)l2];
            long l3 = n2;
            int n3 = 0;
            while ((long)n3 < l2) {
                lArray4[n] = (long)nArray[(int)l3] * (long)matrix.numColumns() + (long)nArray2[(int)l3];
                ++n;
                ++n3;
                ++l3;
            }
            lArray3 = lArray4;
        } else {
            dArray2 = matrix.getDataAsArray();
        }
        return new Expr(lArray, variableArray, lArray2, dArray, dArray2, set, lArray3);
    }

    public static Expression constTerm(double d) {
        long[] lArray = new long[]{0L, 0L};
        Variable[] variableArray = new Variable[]{};
        long[] lArray2 = new long[]{};
        double[] dArray = new double[]{};
        double[] dArray2 = new double[]{d};
        return new Expr(lArray, variableArray, lArray2, dArray, dArray2, null, null, 1);
    }

    public static Expression constTerm(Set set, double d) {
        long[] lArray = Tools.makevector(0L, (int)set.size + 1);
        Variable[] variableArray = new Variable[]{};
        long[] lArray2 = new long[]{};
        double[] dArray = new double[]{};
        double[] dArray2 = Tools.makevector(d, (int)set.size);
        return new Expr(lArray, variableArray, lArray2, dArray, dArray2, set, null, 1);
    }

    public static Expression constTerm(int n, double d) {
        long[] lArray = Tools.makevector(0L, n + 1);
        Variable[] variableArray = new Variable[]{};
        long[] lArray2 = new long[]{};
        double[] dArray = new double[]{};
        double[] dArray2 = Tools.makevector(d, n);
        return new Expr(lArray, variableArray, lArray2, dArray, dArray2, null, null, 1);
    }

    public static Expression constTerm(double[][] dArray) {
        if (dArray == null) {
            throw new NullPointerException("Arguments for constTerm may not be null");
        }
        int n = dArray.length * dArray[0].length;
        long[] lArray = Tools.makevector(0L, n + 1);
        Variable[] variableArray = new Variable[]{};
        long[] lArray2 = new long[]{};
        double[] dArray2 = new double[]{};
        double[] dArray3 = new double[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = dArray.length;
        for (int i = n3; i < n4; ++i) {
            int n5 = 0;
            int n6 = dArray[0].length;
            for (int j = n5; j < n6; ++j) {
                dArray3[n2] = dArray[i][j];
                ++n2;
            }
        }
        return new Expr(lArray, variableArray, lArray2, dArray2, dArray3, Set.make(dArray.length, dArray[0].length), null, 1);
    }

    public static Expression constTerm(double[] dArray) {
        if (dArray == null) {
            throw new NullPointerException("Arguments for constTerm may not be null");
        }
        long[] lArray = Tools.makevector(0L, dArray.length + 1);
        Variable[] variableArray = new Variable[]{};
        long[] lArray2 = new long[]{};
        double[] dArray2 = new double[]{};
        double[] dArray3 = Tools.arraycopy(dArray);
        return new Expr(lArray, variableArray, lArray2, dArray2, dArray3, null, null, 1);
    }

    public long numNonzeros() {
        return this.cof_v.length;
    }

    private static Expression sum_expr(Expression expression, int n, int n2) {
        int n3;
        int n4;
        int n5;
        long l;
        int n6;
        if (n < 0 || n2 <= n || expression.shape().nd < n2) {
            throw new DimensionError("The sum-dimension is invalid or out of bounds");
        }
        FlatExpr flatExpr = expression.eval();
        if (flatExpr.shape.size == 0L) {
            int n7;
            int[] nArray = new int[flatExpr.shape.nd - (n2 - n)];
            long l2 = 1L;
            long l3 = 1L;
            long l4 = 1L;
            int n8 = 0;
            int n9 = n;
            for (n7 = n8; n7 < n9; ++n7) {
                l2 *= (long)flatExpr.shape.dim(n7);
                nArray[n7] = flatExpr.shape.dim(n7);
            }
            n8 = n;
            n9 = n2;
            for (n7 = n8; n7 < n9; ++n7) {
                l3 *= (long)flatExpr.shape.dim(n7);
            }
            n8 = n2;
            n9 = flatExpr.shape.nd;
            for (n7 = n8; n7 < n9; ++n7) {
                l4 *= (long)flatExpr.shape.dim(n7);
                nArray[n7 - n2] = flatExpr.shape.dim(n7);
            }
            if (l2 == 0L || l4 == 0L) {
                return new Expr(new long[]{0L}, flatExpr.x, new long[0], new double[0], new double[0], Set.make(nArray), null);
            }
            return new Expr(new long[]{0L}, flatExpr.x, new long[0], new double[0], new double[0], Set.make(nArray), new long[0]);
        }
        long[] lArray = flatExpr.inst;
        if (lArray == null) {
            lArray = Tools.range(0L, (long)flatExpr.ptrb.length - 1L);
        }
        long[] lArray2 = new long[lArray.length];
        long[] lArray3 = new long[lArray.length];
        long l5 = 1L;
        long l6 = 1L;
        long l7 = 1L;
        int n10 = 0;
        int n11 = n;
        for (n6 = n10; n6 < n11; ++n6) {
            l5 *= (long)flatExpr.shape.dim(n6);
        }
        n10 = n;
        n11 = n2;
        for (n6 = n10; n6 < n11; ++n6) {
            l6 *= (long)flatExpr.shape.dim(n6);
        }
        n10 = n2;
        n11 = flatExpr.shape.nd;
        for (n6 = n10; n6 < n11; ++n6) {
            l7 *= (long)flatExpr.shape.dim(n6);
        }
        n10 = 0;
        n11 = lArray.length;
        for (n6 = n10; n6 < n11; ++n6) {
            l = lArray[n6];
            lArray2[n6] = l % l7 + l / (l7 * l6) * l7;
            lArray3[n6] = l / l7 % l6;
        }
        long[] lArray4 = Tools.range(0L, (long)lArray.length);
        CommonTools.argQsort(lArray4, lArray2, lArray3, 0L, (long)lArray.length);
        long l8 = 1L;
        int n12 = 1;
        int n13 = lArray2.length;
        for (int i = n12; i < n13; ++i) {
            if (lArray2[(int)lArray4[i]] <= lArray2[(int)lArray4[i - 1]]) continue;
            ++l8;
        }
        long[] lArray5 = new long[(int)(l8 + 1L)];
        long[] lArray6 = new long[flatExpr.subj.length];
        double[] dArray = new double[flatExpr.cof.length];
        n10 = 0;
        long l9 = 0L;
        l = l8;
        for (long i = l9; i < l; ++i) {
            int n14 = n10;
            long l10 = lArray2[(int)lArray4[n10]];
            while (n10 < lArray2.length && l10 == lArray2[(int)lArray4[n10]]) {
                ++n10;
            }
            lArray5[(int)(i + 1L)] = lArray5[(int)i];
            int n15 = n14;
            n5 = n10;
            for (n4 = n15; n4 < n5; ++n4) {
                long l11 = flatExpr.ptrb[(int)(lArray4[n4] + 1L)] - flatExpr.ptrb[(int)lArray4[n4]];
                Tools.arraycopy(flatExpr.subj, flatExpr.ptrb[(int)lArray4[n4]], lArray6, lArray5[(int)(i + 1L)], l11);
                Tools.arraycopy(flatExpr.cof, flatExpr.ptrb[(int)lArray4[n4]], dArray, lArray5[(int)(i + 1L)], l11);
                lArray5[(int)(i + 1L)] = lArray5[(int)(i + 1L)] + l11;
            }
        }
        double[] dArray2 = null;
        if (flatExpr.bfix != null) {
            dArray2 = new double[(int)l8];
            int n16 = 0;
            long l12 = 0L;
            long l13 = l8;
            for (long i = l12; i < l13; ++i) {
                int n17 = n16;
                long l14 = lArray2[(int)lArray4[n16]];
                while (n16 < lArray2.length && l14 == lArray2[(int)lArray4[n16]]) {
                    ++n16;
                }
                n5 = n17;
                n4 = n16;
                for (int j = n5; j < n4; ++j) {
                    int n18 = (int)i;
                    dArray2[n18] = dArray2[n18] + flatExpr.bfix[(int)lArray4[j]];
                }
            }
        }
        Object[] objectArray = new int[flatExpr.shape.nd - (n2 - n)];
        int n19 = 0;
        int n20 = 0;
        int n21 = n;
        for (n3 = n20; n3 < n21; ++n3) {
            objectArray[n19] = flatExpr.shape.dim(n3);
            ++n19;
        }
        n20 = n2;
        n21 = flatExpr.shape.nd;
        for (n3 = n20; n3 < n21; ++n3) {
            objectArray[n19] = flatExpr.shape.dim(n3);
            ++n19;
        }
        NDSet nDSet = new NDSet((int[])objectArray);
        objectArray = null;
        if (l8 < nDSet.size) {
            objectArray = new long[(int)l8];
            objectArray[0] = (int)lArray2[(int)lArray4[0]];
            n19 = 0;
            long l15 = 1L;
            long l16 = l8;
            for (long i = l15; i < l16; ++i) {
                while (lArray2[(int)lArray4[n19]] <= objectArray[(int)(i - 1L)]) {
                    ++n19;
                }
                objectArray[(int)i] = (int)lArray2[(int)lArray4[n19]];
            }
        }
        return new Expr(lArray5, flatExpr.x, lArray6, dArray, dArray2, nDSet, (long[])objectArray);
    }

    private static Expression sum_var(Variable variable, int n, int n2) {
        int n3;
        long[] lArray;
        int n4;
        int n5;
        int n6;
        Set set;
        if (n < 0 || n2 <= n || n2 > variable.shape().nd) {
            throw new DimensionError("The sum-dimension is invalid or out of bounds");
        }
        if (variable.shape().size == 0L) {
            int n7;
            int n8 = variable.shape().nd - (n2 - n);
            if (n8 < 1) {
                n8 = 1;
            }
            int[] nArray = new int[n8];
            long l = 1L;
            long l2 = 1L;
            long l3 = 1L;
            int n9 = 0;
            int n10 = n;
            for (n7 = n9; n7 < n10; ++n7) {
                l *= (long)variable.shape().dim(n7);
                nArray[n7] = variable.shape().dim(n7);
            }
            n9 = n;
            n10 = n2;
            for (n7 = n9; n7 < n10; ++n7) {
                l2 *= (long)variable.shape().dim(n7);
            }
            n9 = n2;
            n10 = variable.shape().nd;
            for (n7 = n9; n7 < n10; ++n7) {
                l3 *= (long)variable.shape().dim(n7);
                nArray[n7 - n2] = variable.shape().dim(n7);
            }
            if (n == 0 && n2 == variable.shape().nd && l2 == 0L) {
                nArray[0] = 1;
            }
            if (l == 0L || l3 == 0L) {
                return new Expr(new long[]{0L}, new Variable[0], new long[0], new double[0], new double[0], Set.make(nArray), null);
            }
            return new Expr(new long[]{0L, 0L}, new Variable[0], new long[0], new double[0], null, Set.make(nArray), null);
        }
        int n11 = variable.shape().nd - (n2 - n);
        if (n11 == 0) {
            n11 = 1;
            set = new IntSet(1);
        } else {
            int[] nArray = new int[n11];
            int n12 = 0;
            n6 = 0;
            n5 = n;
            for (n4 = n6; n4 < n5; ++n4) {
                nArray[n12] = variable.shape().dim(n4);
                ++n12;
            }
            n6 = n2;
            n5 = variable.shape().nd;
            for (n4 = n6; n4 < n5; ++n4) {
                nArray[n12] = variable.shape().dim(n4);
                ++n12;
            }
            set = n11 > 1 ? new NDSet(nArray) : new IntSet(nArray[0]);
        }
        long l = 1L;
        n6 = n;
        n5 = n2;
        for (n4 = n6; n4 < n5; ++n4) {
            l *= (long)variable.shape().dim(n4);
        }
        if (l > 0L) {
            lArray = Tools.range(0L, variable.shape().size + 1L, l);
        } else {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = 0L;
        }
        long[] lArray3 = lArray;
        double[] dArray = Tools.ones((int)variable.shape().size);
        double[] dArray2 = null;
        long l4 = 1L;
        long l5 = 1L;
        long l6 = 1L;
        int n13 = 0;
        int n14 = n;
        for (n3 = n13; n3 < n14; ++n3) {
            l4 *= (long)variable.shape().dim(n3);
        }
        n13 = n;
        n14 = n2;
        for (n3 = n13; n3 < n14; ++n3) {
            l5 *= (long)variable.shape().dim(n3);
        }
        n13 = n2;
        n14 = variable.shape().nd;
        for (n3 = n13; n3 < n14; ++n3) {
            l6 *= (long)variable.shape().dim(n3);
        }
        n13 = 0;
        n14 = 0;
        long l7 = l4;
        long l8 = (long)n14 < l7 ? l7 - (long)n14 : 0L;
        int n15 = 0;
        long l9 = l6;
        long l10 = (long)n15 < l9 ? l9 - (long)n15 : 0L;
        int n16 = 0;
        long l11 = l5;
        long l12 = (long)n16 < l11 ? l11 - (long)n16 : 0L;
        long[] lArray4 = new long[(int)(l8 * l10 * l12)];
        long l13 = n14;
        int n17 = 0;
        while ((long)n17 < l8) {
            long l14 = n15;
            int n18 = 0;
            while ((long)n18 < l10) {
                long l15 = n16;
                int n19 = 0;
                while ((long)n19 < l12) {
                    lArray4[n13] = l13 * l5 * l6 + l15 * l6 + l14;
                    ++n13;
                    ++n19;
                    ++l15;
                }
                ++n18;
                ++l14;
            }
            ++n17;
            ++l13;
        }
        long[] lArray5 = lArray4;
        return new Expr(lArray3, new Variable[]{variable}, lArray5, dArray, dArray2, set, null);
    }

    public static Expression sum(Expression expression, int n, int n2) {
        return Expr.sum_expr(expression, n, n2);
    }

    public static Expression sum(Expression expression, int n) {
        if (n < 0 || expression.shape().nd <= n) {
            throw new DimensionError("The sum-dimension is invalid or out of bounds");
        }
        return Expr.sum_expr(expression, n, n + 1);
    }

    public static Expression sum(Variable variable, int n, int n2) {
        return Expr.sum_var(variable, n, n2);
    }

    public static Expression sum(Variable variable, int n) {
        if (variable == null) {
            throw new NullPointerException("Arguments for sum may not be null");
        }
        return Expr.sum_var(variable, n, n + 1);
    }

    public static Expression sum(Variable variable) {
        if (variable == null) {
            throw new NullPointerException("Arguments for sum may not be null");
        }
        return Expr.sum_var(variable, 0, variable.shape().nd);
    }

    public static Expression sum(Expression expression) {
        double[] dArray;
        if (expression == null) {
            throw new NullPointerException("Arguments for neg may not be null");
        }
        FlatExpr flatExpr = expression.eval();
        long[] lArray = new long[]{0L, flatExpr.cof.length};
        long[] lArray2 = Tools.arraycopy(flatExpr.subj);
        double[] dArray2 = Tools.arraycopy(flatExpr.cof);
        if (flatExpr.bfix != null) {
            double d = 0.0;
            for (int i = 0; i < flatExpr.bfix.length && i < flatExpr.bfix.length; ++i) {
                d += flatExpr.bfix[i];
            }
            dArray = new double[]{d};
        } else {
            dArray = null;
        }
        return new Expr(lArray, flatExpr.x, lArray2, dArray2, dArray, null, null, 1);
    }

    public static Expression neg(Variable variable) {
        if (variable == null) {
            throw new NullPointerException("Arguments for neg may not be null");
        }
        long[] lArray = Tools.range(variable.shape().size + 1L);
        long[] lArray2 = Tools.range(variable.shape().size);
        int n = 0;
        int n2 = 0;
        long l = variable.shape().size;
        long l2 = (long)n2 < l ? l - (long)n2 : 0L;
        double[] dArray = new double[(int)l2];
        long l3 = n2;
        int n3 = 0;
        while ((long)n3 < l2) {
            dArray[n] = -1.0;
            ++n;
            ++n3;
            ++l3;
        }
        double[] dArray2 = dArray;
        return new Expr(lArray, new Variable[]{variable}, lArray2, dArray2, null, variable.shape(), null, 1);
    }

    public static Expression neg(Expression expression) {
        double[] dArray;
        if (expression == null) {
            throw new NullPointerException("Arguments for neg may not be null");
        }
        FlatExpr flatExpr = expression.eval();
        int n = 0;
        int n2 = 0;
        int n3 = flatExpr.cof.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        double[] dArray2 = new double[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            dArray2[n] = -flatExpr.cof[n5];
            ++n;
            ++n6;
            ++n5;
        }
        double[] dArray3 = dArray2;
        if (flatExpr.bfix == null) {
            dArray = null;
        } else {
            int n7 = 0;
            int n8 = 0;
            int n9 = flatExpr.bfix.length;
            int n10 = n8 < n9 ? n9 - n8 : 0;
            double[] dArray4 = new double[n10];
            int n11 = n8;
            int n12 = 0;
            while (n12 < n10) {
                dArray4[n7] = -flatExpr.bfix[n11];
                ++n7;
                ++n12;
                ++n11;
            }
            dArray = dArray4;
        }
        double[] dArray5 = dArray;
        return new Expr(flatExpr.ptrb, flatExpr.x, flatExpr.subj, dArray3, dArray5, flatExpr.shape, flatExpr.inst, 1);
    }

    private static Expression mul__(Matrix matrix, Expression expression) {
        Expr expr;
        Set set;
        Matrix matrix2 = matrix;
        Expression expression2 = expression;
        if (expression.shape().nd > 2) {
            throw new DimensionError("Expression operand must have 1 or 2 dimensions");
        }
        if (expression.shape().dim(0) != matrix2.dimj) {
            throw new DimensionError("Dimensions of operands do not match");
        }
        FlatExpr flatExpr = expression.eval();
        int n = flatExpr.shape.dim(0);
        int n2 = 1;
        int n3 = 1;
        if (flatExpr.shape.nd == 2) {
            n2 = flatExpr.shape.dim(1);
            n3 = 2;
            set = new NDSet(matrix2.dimi, n2);
        } else {
            set = new IntSet(matrix2.dimi);
        }
        Matrix matrix3 = matrix2;
        if (matrix3 instanceof DenseMatrix) {
            DenseMatrix denseMatrix = (DenseMatrix)matrix3;
            if (flatExpr.inst == null) {
                int n4 = denseMatrix.dimi * n2;
                long[] lArray = new long[n4 + 1];
                long[] lArray2 = new long[(int)(flatExpr.nnz * (long)denseMatrix.dimi)];
                double[] dArray = new double[(int)(flatExpr.nnz * (long)denseMatrix.dimi)];
                double[] dArray2 = flatExpr.bfix == null ? null : new double[n4];
                int n5 = 1;
                for (int i = 0; i < denseMatrix.dimi && i < denseMatrix.dimi; ++i) {
                    for (int j = 0; j < n2 && j < n2; ++j) {
                        long l = lArray[n5 - 1];
                        for (int k = 0; k < n && k < n; ++k) {
                            int n6 = k * n2 + j;
                            long l2 = flatExpr.ptrb[n6 + 1] - flatExpr.ptrb[n6];
                            double d = denseMatrix.data[i * denseMatrix.dimj + k];
                            int n7 = 0;
                            while ((long)n7 < l2 && (long)n7 < l2) {
                                dArray[(int)(l + (long)n7)] = flatExpr.cof[(int)(flatExpr.ptrb[n6] + (long)n7)] * d;
                                lArray2[(int)(l + (long)n7)] = flatExpr.subj[(int)(flatExpr.ptrb[n6] + (long)n7)];
                                ++n7;
                            }
                            l += l2;
                            if (flatExpr.bfix == null) continue;
                            dArray2[n5 - 1] = dArray2[n5 - 1] + flatExpr.bfix[n6] * d;
                        }
                        lArray[n5] = l;
                        ++n5;
                    }
                }
                expr = new Expr(lArray, flatExpr.x, lArray2, dArray, dArray2, set, null);
            } else {
                int n8;
                int n9;
                int n10 = flatExpr.inst.length;
                int[] nArray = new int[n10];
                int[] nArray2 = new int[n10];
                long[] lArray = Tools.range((long)flatExpr.inst.length);
                for (n9 = 0; n9 < n10 && n9 < n10; ++n9) {
                    nArray[n9] = (int)(flatExpr.inst[n9] / (long)n2);
                    nArray2[n9] = (int)(flatExpr.inst[n9] - (long)nArray[n9]);
                }
                Tools.argsort(lArray, nArray2, nArray, 0L, (long)n10);
                n9 = 0;
                if (nArray2.length > 0) {
                    n9 = 1;
                    for (n8 = 1; n8 < n10 && n8 < n10; ++n8) {
                        if (nArray2[(int)lArray[n8]] <= nArray2[(int)lArray[n8 - 1]]) continue;
                        ++n9;
                    }
                }
                n8 = n9 * denseMatrix.dimi;
                long[] lArray3 = new long[n8 + 1];
                long[] lArray4 = new long[(int)(flatExpr.nnz * (long)denseMatrix.dimi)];
                double[] dArray = new double[(int)(flatExpr.nnz * (long)denseMatrix.dimi)];
                double[] dArray3 = flatExpr.bfix == null ? null : new double[n8];
                long[] lArray5 = n9 >= n2 ? null : new long[n8];
                int n11 = 0;
                for (int i = 0; i < denseMatrix.dimi && i < denseMatrix.dimi; ++i) {
                    long l = denseMatrix.dimj * i;
                    for (int j = 0; j < n10 && j < n10; ++j) {
                        if (j == 0 || nArray2[(int)lArray[j]] > nArray2[(int)lArray[j - 1]]) {
                            lArray3[++n11] = lArray3[n11 - 1];
                            if (lArray5 != null) {
                                lArray5[n11 - 1] = (long)i * (long)n2 + (long)nArray2[(int)lArray[j]];
                            }
                        }
                        long l3 = flatExpr.ptrb[(int)lArray[j]];
                        long l4 = flatExpr.ptrb[(int)(lArray[j] + 1L)] - l3;
                        double d = denseMatrix.data[(int)(l + (long)nArray[(int)lArray[j]])];
                        int n12 = 0;
                        while ((long)n12 < l4 && (long)n12 < l4) {
                            lArray4[(int)(lArray3[n11] + (long)n12)] = flatExpr.subj[(int)(l3 + (long)n12)];
                            dArray[(int)(lArray3[n11] + (long)n12)] = flatExpr.cof[(int)(l3 + (long)n12)] * d;
                            ++n12;
                        }
                        if (dArray3 != null) {
                            dArray3[n11 - 1] = dArray3[n11 - 1] + flatExpr.bfix[(int)lArray[j]] * d;
                        }
                        if (lArray5 != null) {
                            lArray5[n11 - 1] = nArray2[(int)lArray[j]];
                        }
                        lArray3[n11] = lArray3[n11] + l4;
                    }
                }
                expr = new Expr(lArray3, flatExpr.x, lArray4, dArray, dArray3, set, lArray5);
            }
        } else {
            Matrix matrix4 = matrix3;
            long l = matrix4.numNonzeros();
            int[] nArray = new int[(int)l];
            int[] nArray3 = new int[(int)l];
            double[] dArray = new double[(int)l];
            matrix4.getDataAsTriplets(nArray, nArray3, dArray);
            if (flatExpr.inst == null) {
                int n13;
                int n14;
                long l5 = 1L;
                long l6 = 1L;
                long l7 = l;
                for (long i = l6; i < l7; ++i) {
                    if (nArray[(int)i] <= nArray[(int)(i - 1L)]) continue;
                    ++l5;
                }
                l6 = l5 * (long)n2;
                long[] lArray = new long[(int)(l6 + 1L)];
                long l8 = 0L;
                int n15 = nArray[0];
                long l9 = 0L;
                long l10 = 0L;
                long l11 = l;
                for (long i = l10; i < l11; ++i) {
                    if (n15 < nArray[(int)i]) {
                        l9 += (long)n2;
                        n15 = nArray[(int)i];
                    }
                    int n16 = 0;
                    n14 = n2;
                    for (n13 = n16; n13 < n14; ++n13) {
                        int n17 = nArray3[(int)i] * n2 + n13;
                        long l12 = flatExpr.ptrb[n17 + 1] - flatExpr.ptrb[n17];
                        l8 += l12;
                        lArray[(int)(l9 + (long)n13 + 1L)] = lArray[(int)(l9 + (long)n13 + 1L)] + l12;
                    }
                }
                long[] lArray6 = new long[(int)l8];
                double[] dArray4 = new double[(int)l8];
                double[] dArray5 = flatExpr.bfix == null ? null : new double[(int)l6];
                int n18 = 0;
                while ((long)n18 < l6 && (long)n18 < l6) {
                    lArray[n18 + 1] = lArray[n18] + lArray[n18 + 1];
                    ++n18;
                }
                long[] lArray7 = l5 >= (long)matrix4.dimi ? null : new long[(int)l6];
                long l13 = 0L;
                int n19 = nArray[0];
                int n20 = 0;
                while ((long)n20 < l && (long)n20 < l) {
                    double d = dArray[n20];
                    if (n19 < nArray[n20]) {
                        l13 += (long)n2;
                        n19 = nArray[n20];
                    }
                    for (n14 = 0; n14 < n2 && n14 < n2; ++n14) {
                        n13 = nArray3[n20] * n2 + n14;
                        long l14 = flatExpr.ptrb[n13 + 1] - flatExpr.ptrb[n13];
                        int n21 = 0;
                        while ((long)n21 < l14 && (long)n21 < l14) {
                            dArray4[(int)(lArray[(int)(l13 + (long)n14)] + (long)n21)] = flatExpr.cof[(int)(flatExpr.ptrb[n13] + (long)n21)] * d;
                            lArray6[(int)(lArray[(int)(l13 + (long)n14)] + (long)n21)] = flatExpr.subj[(int)(flatExpr.ptrb[n13] + (long)n21)];
                            ++n21;
                        }
                        if (dArray5 != null) {
                            dArray5[(int)(l13 + (long)n14)] = dArray5[(int)(l13 + (long)n14)] + flatExpr.bfix[n13] * d;
                        }
                        lArray[(int)(l13 + (long)n14)] = lArray[(int)(l13 + (long)n14)] + l14;
                        if (lArray7 == null) continue;
                        lArray7[(int)(l13 + (long)n14)] = nArray[n20] * n2 + n14;
                    }
                    ++n20;
                }
                for (int i = lArray.length - 1; i > 0 && i > 0; --i) {
                    lArray[i] = lArray[i - 1];
                }
                lArray[0] = 0L;
                expr = new Expr(lArray, flatExpr.x, lArray6, dArray4, dArray5, set, lArray7);
            } else {
                int n22;
                long l15 = matrix2.numNonzeros();
                int n23 = flatExpr.inst.length;
                int[] nArray4 = new int[n23];
                int[] nArray5 = new int[n23];
                long[] lArray = Tools.range((long)flatExpr.inst.length);
                for (int i = 0; i < n23 && i < n23; ++i) {
                    nArray4[i] = (int)(flatExpr.inst[i] / (long)n2);
                    nArray5[i] = (int)(flatExpr.inst[i] - (long)nArray4[i]);
                }
                Tools.argsort(lArray, nArray5, nArray4, 0L, (long)n23);
                long l16 = 0L;
                long l17 = 0L;
                int n24 = 0;
                while ((long)n24 < l15 && (long)n24 < l15) {
                    int n25 = n24;
                    while ((long)n25 < l15 && nArray[n25] == nArray[n24] && (long)n25 < l15 && nArray[n25] == nArray[n24]) {
                        ++n25;
                    }
                    int n26 = nArray[n24];
                    int n27 = nArray5[(int)lArray[0]];
                    int n28 = 0;
                    while (n28 < n23 && n28 < n23) {
                        for (n22 = n28 + 1; n22 < n23 && nArray5[(int)lArray[n22]] == nArray5[(int)lArray[n22 - 1]] && n22 < n23 && nArray5[(int)lArray[n22]] == nArray5[(int)lArray[n22 - 1]]; ++n22) {
                        }
                        int n29 = n24;
                        int n30 = n28;
                        long l18 = l17;
                        while (n29 < n25 && n30 < n22) {
                            if (nArray3[n29] < nArray4[(int)lArray[n30]]) {
                                ++n29;
                                continue;
                            }
                            if (nArray3[n29] > nArray4[(int)lArray[n30]]) {
                                ++n30;
                                continue;
                            }
                            l17 += flatExpr.ptrb[(int)(lArray[n30] + 1L)] - flatExpr.ptrb[(int)lArray[n30]];
                            ++n30;
                            ++n29;
                        }
                        if (l18 < l17) {
                            ++l16;
                        }
                        n28 = n22;
                    }
                    n24 = n25;
                }
                long[] lArray8 = new long[(int)(l16 + 1L)];
                long[] lArray9 = new long[(int)l17];
                double[] dArray6 = new double[(int)l17];
                long[] lArray10 = new long[(int)l16];
                double[] dArray7 = flatExpr.bfix == null ? null : new double[(int)l16];
                n22 = 0;
                long l19 = 0L;
                int n31 = 0;
                int n32 = 0;
                while ((long)n32 < l15 && (long)n32 < l15) {
                    int n33 = n32;
                    while ((long)n33 < l15 && nArray[n33] == nArray[n32] && (long)n33 < l15 && nArray[n33] == nArray[n32]) {
                        ++n33;
                    }
                    int n34 = nArray[n32];
                    int n35 = nArray5[(int)lArray[0]];
                    int n36 = 0;
                    while (n36 < n23 && n36 < n23) {
                        int n37;
                        for (n37 = n36 + 1; n37 < n23 && nArray5[(int)lArray[n37]] == nArray5[(int)lArray[n37 - 1]] && n37 < n23 && nArray5[(int)lArray[n37]] == nArray5[(int)lArray[n37 - 1]]; ++n37) {
                        }
                        int n38 = n32;
                        int n39 = n36;
                        long l20 = l19;
                        while (n38 < n33 && n39 < n37) {
                            if (nArray3[n38] < nArray4[(int)lArray[n39]]) {
                                ++n38;
                                continue;
                            }
                            if (nArray3[n38] > nArray4[(int)lArray[n39]]) {
                                ++n39;
                                continue;
                            }
                            long l21 = flatExpr.ptrb[(int)lArray[n39]];
                            long l22 = flatExpr.ptrb[(int)(lArray[n39] + 1L)] - l21;
                            Tools.arraycopy(flatExpr.subj, flatExpr.ptrb[(int)lArray[n39]], lArray9, l19, l22);
                            int n40 = 0;
                            while ((long)n40 < l22 && (long)n40 < l22) {
                                dArray6[(int)(l19 + (long)n40)] = flatExpr.cof[(int)(l21 + (long)n40)] * dArray[n38];
                                ++n40;
                            }
                            if (dArray7 != null) {
                                dArray7[n31] = dArray7[n31] + flatExpr.bfix[(int)lArray[n39]] * dArray[n38];
                            }
                            l19 += l22;
                            ++n39;
                            ++n38;
                        }
                        if (l20 < l19) {
                            lArray10[n31] = (long)(nArray[n32] * n2) + (long)nArray5[(int)lArray[n36]];
                            lArray8[++n31] = l19;
                        }
                        n36 = n37;
                    }
                    n32 = n33;
                }
                expr = new Expr(lArray8, flatExpr.x, lArray9, dArray6, dArray7, set, lArray10);
            }
        }
        return expr;
    }

    private static void sparseMatrixVector(long[] lArray, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3, int n) {
        int n2;
        for (n2 = 0; n2 < n && n2 < n; ++n2) {
            dArray3[n2] = 0.0;
        }
        for (n2 = 0; n2 < n && n2 < n; ++n2) {
            for (long i = lArray[n2]; i < lArray[n2 + 1] && i < lArray[n2 + 1]; ++i) {
                int n3 = nArray[(int)i];
                dArray3[n2] = dArray3[n2] + dArray2[n3] * dArray[n3];
            }
        }
    }

    private static void sparseMatmul(long[] lArray, int[] nArray, double[] dArray, long[] lArray2, int[] nArray2, double[] dArray2, long[] lArray3, int[] nArray3, double[] dArray3, int n, int n2, int[] nArray4) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        double[] dArray4 = new double[n2];
        for (n3 = 0; n3 < n2 && n3 < n2; ++n3) {
            nArray4[n3] = -1;
            dArray4[n3] = 0.0;
        }
        for (n3 = 0; n3 < n && n3 < n; ++n3) {
            n5 = n4;
            for (long i = lArray2[n3]; i < lArray2[n3 + 1] && i < lArray2[n3 + 1]; ++i) {
                int n6 = nArray2[(int)i];
                double d = dArray2[(int)i];
                for (long j = lArray3[n6]; j < lArray3[n6 + 1] && j < lArray3[n6 + 1]; ++j) {
                    int n7 = nArray3[(int)j];
                    if (nArray4[n7] < n5) {
                        nArray4[n7] = n4;
                        dArray4[n7] = d * dArray3[(int)j];
                        nArray[n4] = n7;
                        ++n4;
                        continue;
                    }
                    dArray4[n7] = dArray4[n7] + d * dArray3[(int)j];
                }
            }
            Tools.sort(nArray, n5, n4);
            for (int i = n5; i < n4 && i < n4; ++i) {
                dArray[i] = dArray4[nArray[i]];
                dArray4[nArray[i]] = 0.0;
            }
        }
    }

    private static long computeNz(long[] lArray, int[] nArray, long[] lArray2, int[] nArray2, int n, int n2, int[] nArray3, long[] lArray3) {
        int n3;
        long l = 0L;
        int n4 = 0;
        for (n3 = 0; n3 < n2 && n3 < n2; ++n3) {
            nArray3[n3] = 0;
        }
        for (n3 = 0; n3 < n && n3 < n; ++n3) {
            ++n4;
            lArray3[n3] = l;
            for (long i = lArray[n3]; i < lArray[n3 + 1] && i < lArray[n3 + 1]; ++i) {
                int n5 = nArray[(int)i];
                for (long j = lArray2[n5]; j < lArray2[n5 + 1] && j < lArray2[n5 + 1]; ++j) {
                    int n6 = nArray2[(int)j];
                    if (nArray3[n6] == n4) continue;
                    ++l;
                    nArray3[n6] = n4;
                }
            }
        }
        lArray3[n] = l;
        return l;
    }

    public static Expression mulDiag(Variable variable, Matrix matrix) {
        if (variable == null || matrix == null) {
            throw new NullPointerException("Arguments for mulDiag may not be null");
        }
        Variable variable2 = variable;
        Matrix matrix2 = matrix;
        if (variable2.shape().nd != 2 || matrix2.dimj != variable2.shape().dim(0) || matrix2.dimi != variable2.shape().dim(1)) {
            throw new DimensionError("Mismatching dimensions of operands");
        }
        long l = matrix2.dimj;
        Matrix matrix3 = matrix2;
        if (matrix3 instanceof DenseMatrix) {
            DenseMatrix denseMatrix = (DenseMatrix)matrix3;
            long l2 = l * (long)denseMatrix.dimi;
            long[] lArray = Tools.range(0L, l * (1L + l), l);
            long[] lArray2 = Tools.range(0L, l2);
            double[] dArray = new double[(int)l2];
            int n = 0;
            for (long i = 0L; i < (long)denseMatrix.dimj && i < (long)denseMatrix.dimj; ++i) {
                for (long j = 0L; j < (long)denseMatrix.dimi && j < (long)denseMatrix.dimi; ++j) {
                    dArray[n] = denseMatrix.data[(int)(j * l + i)];
                    ++n;
                }
            }
            return new Expr(lArray, new Variable[]{variable}, lArray2, dArray, null, null, null, 1);
        }
        Matrix matrix4 = matrix3;
        long l3 = matrix4.numNonzeros();
        long[] lArray = new long[(int)(l + 1L)];
        long[] lArray3 = new long[(int)l3];
        double[] dArray = new double[(int)l3];
        int[] nArray = new int[(int)l3];
        int[] nArray2 = new int[(int)l3];
        double[] dArray2 = new double[(int)l3];
        matrix4.getDataAsTriplets(nArray, nArray2, dArray2);
        int n = 0;
        while ((long)n < l3 && (long)n < l3) {
            int n2 = nArray2[n] + 1;
            lArray[n2] = lArray[n2] + 1L;
            ++n;
        }
        n = 0;
        while ((long)n < l && (long)n < l) {
            lArray[n + 1] = lArray[n] + lArray[n + 1];
            ++n;
        }
        n = 0;
        while ((long)n < l3 && (long)n < l3) {
            long l4 = lArray[nArray2[n]];
            dArray[(int)l4] = dArray2[n];
            lArray3[(int)l4] = nArray2[n] * matrix4.dimi + nArray[n];
            int n3 = nArray2[n];
            lArray[n3] = lArray[n3] + 1L;
            ++n;
        }
        for (long i = l; i > 0L && i > 0L; --i) {
            lArray[(int)i] = lArray[(int)(i - 1L)];
        }
        lArray[0] = 0L;
        return new Expr(lArray, new Variable[]{variable}, lArray3, dArray, null, null, null, 1);
    }

    public static Expression mulDiag(Matrix matrix, Variable variable) {
        if (variable == null || matrix == null) {
            throw new NullPointerException("Arguments for mulDiag may not be null");
        }
        Matrix matrix2 = matrix;
        Variable variable2 = variable;
        if (variable2.shape().nd != 2 || matrix2.dimj != variable2.shape().dim(0) || matrix2.dimi != variable2.shape().dim(1)) {
            throw new DimensionError("Mismatching dimensions of operands");
        }
        Matrix matrix3 = matrix2;
        if (matrix3 instanceof DenseMatrix) {
            DenseMatrix denseMatrix = (DenseMatrix)matrix3;
            long[] lArray = Tools.range(0L, (long)(denseMatrix.dimj * (1 + denseMatrix.dimi)), (long)denseMatrix.dimj);
            long[] lArray2 = new long[denseMatrix.dimi * denseMatrix.dimj];
            int n = 0;
            int n2 = 0;
            int n3 = denseMatrix.dimi;
            int n4 = n2 < n3 ? n3 - n2 : 0;
            int n5 = 0;
            int n6 = denseMatrix.dimj;
            int n7 = n5 < n6 ? n6 - n5 : 0;
            long[] lArray3 = new long[n4 * n7];
            int n8 = n2;
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n5;
                int n11 = 0;
                while (n11 < n7) {
                    lArray3[n] = (long)n8 + (long)(denseMatrix.dimi * n10);
                    ++n;
                    ++n11;
                    ++n10;
                }
                ++n9;
                ++n8;
            }
            long[] lArray4 = lArray3;
            double[] dArray = denseMatrix.data;
            return new Expr(lArray, new Variable[]{variable}, lArray4, dArray, null, null, null, 1);
        }
        if (matrix3 instanceof SparseMatrix) {
            SparseMatrix sparseMatrix = (SparseMatrix)matrix3;
            long[] lArray = new long[sparseMatrix.dimi + 1];
            int n = 0;
            int n12 = 0;
            long l = sparseMatrix.nnz;
            long l2 = (long)n12 < l ? l - (long)n12 : 0L;
            long[] lArray5 = new long[(int)l2];
            long l3 = n12;
            int n13 = 0;
            while ((long)n13 < l2) {
                lArray5[n] = sparseMatrix.subj[(int)l3] * sparseMatrix.dimi + sparseMatrix.subi[(int)l3];
                ++n;
                ++n13;
                ++l3;
            }
            long[] lArray6 = lArray5;
            double[] dArray = sparseMatrix.val;
            long l4 = sparseMatrix.nnz;
            int n14 = 0;
            long l5 = l4;
            for (long i = (long)n14; i < l5; ++i) {
                int n15 = sparseMatrix.subi[(int)i] + 1;
                lArray[n15] = lArray[n15] + 1L;
            }
            n14 = 0;
            int n16 = sparseMatrix.dimi;
            for (int i = n14; i < n16; ++i) {
                lArray[i + 1] = lArray[i] + lArray[i + 1];
            }
            return new Expr(lArray, new Variable[]{variable}, lArray6, dArray, null, null, null, 1);
        }
        Matrix matrix4 = matrix3;
        throw new MatrixError("Unknown matrix type used.");
    }

    public static Expression mulDiag(Expression expression, Matrix matrix) {
        Expr expr;
        if (matrix == null || expression == null) {
            throw new NullPointerException("Arguments for mulDiag may not be null");
        }
        Expression expression2 = expression;
        Matrix matrix2 = matrix;
        FlatExpr flatExpr = expression2.eval();
        if (flatExpr.shape.nd != 2) {
            throw new DimensionError("Expression operand must have 2 dimensions");
        }
        if (flatExpr.shape.dim(0) != matrix2.dimj || flatExpr.shape.dim(1) != matrix2.dimi) {
            throw new DimensionError("Mismatching operand dimensions");
        }
        int n = flatExpr.shape.dim(0);
        int n2 = flatExpr.shape.dim(1);
        Matrix matrix3 = matrix2;
        if (matrix3 instanceof DenseMatrix) {
            DenseMatrix denseMatrix = (DenseMatrix)matrix3;
            if (flatExpr.inst == null) {
                long[] lArray = new long[n + 1];
                long[] lArray2 = new long[(int)flatExpr.nnz];
                double[] dArray = new double[(int)flatExpr.nnz];
                double[] dArray2 = flatExpr.bfix == null ? null : new double[n];
                long[] lArray3 = null;
                Set set = null;
                int n3 = 0;
                int n4 = 0;
                int n5 = n;
                for (int i = n4; i < n5; ++i) {
                    lArray[i + 1] = lArray[i];
                    int n6 = 0;
                    int n7 = n2;
                    for (int j = n6; j < n7; ++j) {
                        long l = flatExpr.ptrb[n3 + 1] - flatExpr.ptrb[n3];
                        double d = denseMatrix.data[j * n + i];
                        Tools.arraycopy(flatExpr.subj, flatExpr.ptrb[n3], lArray2, lArray[i + 1], l);
                        int n8 = 0;
                        long l2 = l;
                        for (long k = (long)n8; k < l2; ++k) {
                            dArray[(int)(lArray[i + 1] + k)] = d * flatExpr.cof[(int)(flatExpr.ptrb[n3] + k)];
                        }
                        if (dArray2 != null) {
                            int n9 = i;
                            dArray2[n9] = dArray2[n9] + d * flatExpr.bfix[n3];
                        }
                        lArray[i + 1] = lArray[i + 1] + l;
                        ++n3;
                    }
                }
                expr = new Expr(lArray, flatExpr.x, lArray2, dArray, dArray2, set, lArray3);
            } else {
                int n10 = 0;
                long l = -1L;
                int n11 = 0;
                int n12 = flatExpr.inst.length;
                for (int i = n11; i < n12; ++i) {
                    long l3 = flatExpr.inst[i] / (long)n2;
                    if (l >= l3) continue;
                    l = l3;
                    ++n10;
                }
                long[] lArray = new long[n10 + 1];
                long[] lArray4 = new long[(int)flatExpr.nnz];
                double[] dArray = new double[(int)flatExpr.nnz];
                double[] dArray3 = flatExpr.bfix == null ? null : new double[n10];
                long[] lArray5 = n10 >= n ? null : new long[n10];
                IntSet intSet = new IntSet(n);
                long l4 = -1L;
                int n13 = 0;
                for (int i = 0; i < flatExpr.inst.length && i < flatExpr.inst.length; ++i) {
                    long l5 = flatExpr.inst[i] / (long)n2;
                    long l6 = flatExpr.inst[i] - l5 * (long)n2;
                    if (l4 < l5) {
                        l4 = l5;
                        if (lArray5 != null) {
                            lArray5[n13] = l5;
                        }
                        lArray[++n13] = lArray[n13 - 1];
                    }
                    long l7 = flatExpr.ptrb[i + 1] - flatExpr.ptrb[i];
                    Tools.arraycopy(flatExpr.subj, flatExpr.ptrb[i], lArray4, lArray[n13], l7);
                    double d = denseMatrix.data[(int)(l6 * (long)n + l5)];
                    int n14 = 0;
                    long l8 = l7;
                    for (long j = (long)n14; j < l8; ++j) {
                        dArray[(int)(lArray[n13] + j)] = d * flatExpr.cof[(int)(flatExpr.ptrb[i] + j)];
                    }
                    if (dArray3 != null) {
                        int n15 = n13 - 1;
                        dArray3[n15] = dArray3[n15] + d * flatExpr.bfix[i];
                    }
                    lArray[n13] = lArray[n13] + l7;
                }
                expr = new Expr(lArray, flatExpr.x, lArray4, dArray, dArray3, intSet, lArray5);
            }
        } else {
            Matrix matrix4 = matrix3;
            long l = matrix4.numNonzeros();
            int[] nArray = new int[(int)l];
            int[] nArray2 = new int[(int)l];
            double[] dArray = new double[(int)l];
            long[] lArray = Tools.range(l);
            matrix4.getDataAsTriplets(nArray, nArray2, dArray);
            Tools.argsort(lArray, nArray2, nArray, 0L, l);
            if (flatExpr.inst == null) {
                int n16 = 0;
                long l9 = 0L;
                int n17 = -1;
                int n18 = 0;
                while ((long)n18 < l && (long)n18 < l) {
                    if (n17 < nArray2[(int)lArray[n18]]) {
                        ++n16;
                        n17 = nArray2[(int)lArray[n18]];
                    }
                    int n19 = nArray2[(int)lArray[n18]] * matrix4.dimi + nArray[(int)lArray[n18]];
                    l9 += flatExpr.ptrb[n19 + 1] - flatExpr.ptrb[n19];
                    ++n18;
                }
                long[] lArray6 = new long[n16 + 1];
                long[] lArray7 = new long[(int)l9];
                double[] dArray4 = new double[(int)l9];
                double[] dArray5 = flatExpr.bfix == null ? null : new double[n16];
                long[] lArray8 = n16 >= matrix4.dimj ? null : new long[n16];
                IntSet intSet = new IntSet(matrix4.dimj);
                long l10 = -1L;
                int n20 = 0;
                int n21 = 0;
                long l11 = l;
                for (long i = (long)n21; i < l11; ++i) {
                    if (l10 < (long)nArray2[(int)lArray[(int)i]]) {
                        l10 = nArray2[(int)lArray[(int)i]];
                        if (lArray8 != null) {
                            lArray8[n20] = l10;
                        }
                        lArray6[++n20] = lArray6[n20 - 1];
                    }
                    int n22 = nArray2[(int)lArray[(int)i]] * matrix4.dimi + nArray[(int)lArray[(int)i]];
                    long l12 = flatExpr.ptrb[n22 + 1] - flatExpr.ptrb[n22];
                    Tools.arraycopy(flatExpr.subj, flatExpr.ptrb[n22], lArray7, lArray6[n20], l12);
                    int n23 = 0;
                    long l13 = l12;
                    for (long j = (long)n23; j < l13; ++j) {
                        dArray4[(int)(lArray6[n20] + j)] = flatExpr.cof[(int)(flatExpr.ptrb[n22] + j)] * dArray[(int)lArray[(int)i]];
                    }
                    if (dArray5 != null) {
                        int n24 = (int)l10;
                        dArray5[n24] = dArray5[n24] + flatExpr.bfix[n22] * dArray[(int)lArray[(int)i]];
                    }
                    lArray6[n20] = lArray6[n20] + l12;
                }
                expr = new Expr(lArray6, flatExpr.x, lArray7, dArray4, dArray5, intSet, lArray8);
            } else {
                int n25 = 0;
                long l14 = 0L;
                int n26 = 0;
                int n27 = 0;
                long l15 = -1L;
                while (n26 < flatExpr.inst.length && (long)n27 < l) {
                    long l16 = flatExpr.inst[n26] / (long)n2;
                    long l17 = flatExpr.inst[n26] - l16 * (long)n2;
                    if (l16 < (long)nArray2[(int)lArray[n27]]) {
                        ++n26;
                        continue;
                    }
                    if (l16 > (long)nArray2[(int)lArray[n27]]) {
                        ++n27;
                        continue;
                    }
                    if (l17 < (long)nArray[(int)lArray[n27]]) {
                        ++n26;
                        continue;
                    }
                    if (l17 > (long)nArray[(int)lArray[n27]]) {
                        ++n27;
                        continue;
                    }
                    if (l15 < l16) {
                        ++n25;
                        l15 = l16;
                    }
                    l14 += flatExpr.ptrb[n26 + 1] - flatExpr.ptrb[n26];
                    ++n26;
                    ++n27;
                }
                long[] lArray9 = new long[n25 + 1];
                long[] lArray10 = new long[(int)l14];
                double[] dArray6 = new double[(int)l14];
                double[] dArray7 = flatExpr.bfix == null ? null : new double[n25];
                long[] lArray11 = n25 >= n ? null : new long[n25];
                IntSet intSet = new IntSet(n);
                int n28 = 0;
                int n29 = 0;
                long l18 = -1L;
                int n30 = 0;
                while (n28 < flatExpr.inst.length && (long)n29 < l) {
                    long l19 = flatExpr.inst[n28] / (long)n2;
                    long l20 = flatExpr.inst[n28] - l19 * (long)n2;
                    if (l19 < (long)nArray2[(int)lArray[n29]]) {
                        ++n28;
                        continue;
                    }
                    if (l19 > (long)nArray2[(int)lArray[n29]]) {
                        ++n29;
                        continue;
                    }
                    if (l20 < (long)nArray[(int)lArray[n29]]) {
                        ++n28;
                        continue;
                    }
                    if (l20 > (long)nArray[(int)lArray[n29]]) {
                        ++n29;
                        continue;
                    }
                    if (l18 < l19) {
                        if (lArray11 != null) {
                            lArray11[n30] = l19;
                        }
                        lArray9[++n30] = lArray9[n30 - 1];
                        l18 = l19;
                    }
                    long l21 = flatExpr.ptrb[n28 + 1] - flatExpr.ptrb[n28];
                    double d = dArray[(int)lArray[n29]];
                    Tools.arraycopy(flatExpr.subj, flatExpr.ptrb[n28], lArray10, lArray9[n30], l21);
                    int n31 = 0;
                    while ((long)n31 < l21 && (long)n31 < l21) {
                        dArray6[(int)(lArray9[n30] + (long)n31)] = d * flatExpr.cof[(int)(flatExpr.ptrb[n28] + (long)n31)];
                        ++n31;
                    }
                    if (dArray7 != null) {
                        dArray7[n30 - 1] = dArray7[n30 - 1] + d * flatExpr.bfix[n28];
                    }
                    lArray9[n30] = lArray9[n30] + l21;
                    ++n28;
                    ++n29;
                }
                expr = new Expr(lArray9, flatExpr.x, lArray10, dArray6, dArray7, intSet, lArray11);
            }
        }
        return expr;
    }

    public static Expression mulDiag(Matrix matrix, Expression expression) {
        Expr expr;
        int n;
        int n2;
        long[] lArray;
        int n3;
        int n4;
        int n5;
        int n6;
        Object[] objectArray;
        int n7;
        int n8;
        int n9;
        long[] lArray2;
        long[] lArray3;
        if (matrix == null || expression == null) {
            throw new NullPointerException("Arguments for mulDiag may not be null");
        }
        Matrix matrix2 = matrix;
        Expression expression2 = expression;
        FlatExpr flatExpr = expression2.eval();
        if (flatExpr.shape.nd != 2) {
            throw new DimensionError("Expression operand must have 2 dimensions");
        }
        if (flatExpr.shape.dim(0) != matrix2.dimj || flatExpr.shape.dim(1) != matrix2.dimi) {
            throw new DimensionError("Mismatching operand dimensions");
        }
        int n10 = flatExpr.shape.dim(0);
        int n11 = flatExpr.shape.dim(1);
        if (flatExpr.inst != null) {
            lArray3 = new long[(int)((long)flatExpr.ptrb.length - 1L)];
            lArray2 = Tools.range((long)lArray3.length);
            n9 = 0;
            n8 = lArray3.length;
            for (n7 = n9; n7 < n8; ++n7) {
                long l = flatExpr.inst[n7] / (long)n11;
                long l2 = flatExpr.inst[n7] % (long)n11;
                lArray3[n7] = l2 * (long)n10 + l;
            }
            CommonTools.argQsort(lArray2, lArray3, null, 0L, (long)lArray2.length);
        } else {
            n9 = 0;
            n8 = 0;
            n7 = flatExpr.ptrb.length - 1;
            int n12 = n8 < n7 ? n7 - n8 : 0;
            objectArray = new long[n12];
            int n13 = n8;
            n6 = 0;
            while (n6 < n12) {
                objectArray[n9] = (long)(n13 % n11) * (long)n10 + (long)(n13 / n11);
                ++n9;
                ++n6;
                ++n13;
            }
            lArray3 = objectArray;
            n6 = 0;
            n5 = 0;
            n4 = flatExpr.ptrb.length - 1;
            n3 = n5 < n4 ? n4 - n5 : 0;
            lArray = new long[n3];
            n2 = n5;
            n = 0;
            while (n < n3) {
                lArray[n6] = (long)(n2 % n10) * (long)n11 + (long)(n2 / n10);
                ++n6;
                ++n;
                ++n2;
            }
            lArray2 = lArray;
        }
        Matrix matrix3 = matrix2;
        if (matrix3 instanceof DenseMatrix) {
            int n14;
            DenseMatrix denseMatrix = (DenseMatrix)matrix3;
            long l = 0L;
            if (flatExpr.inst == null) {
                l = n11;
            } else {
                int n15 = -1;
                int n16 = 0;
                n6 = lArray3.length;
                for (n5 = n16; n5 < n6; ++n5) {
                    n4 = (int)(lArray3[(int)lArray2[n5]] / (long)denseMatrix.dimj);
                    if (n4 <= n15) continue;
                    ++l;
                    n15 = n4;
                }
            }
            long l3 = flatExpr.subj.length;
            long[] lArray4 = new long[(int)(l + 1L)];
            long[] lArray5 = new long[(int)l3];
            double[] dArray = new double[(int)l3];
            double[] dArray2 = null;
            lArray = new long[(int)l];
            n2 = -1;
            long l4 = 0L;
            int n17 = 0;
            int n18 = lArray3.length;
            for (n14 = n17; n14 < n18; ++n14) {
                int n19 = (int)(lArray3[(int)lArray2[n14]] / (long)n10);
                if (n19 > n2) {
                    n2 = n19;
                    lArray4[(int)(++l4)] = lArray4[(int)(l4 - 1L)];
                    lArray[(int)(l4 - 1L)] = n19;
                }
                long l5 = flatExpr.ptrb[(int)(lArray2[n14] + 1L)] - flatExpr.ptrb[(int)lArray2[n14]];
                long l6 = 0L;
                long l7 = l5;
                for (long i = l6; i < l7; ++i) {
                    lArray5[(int)(lArray4[(int)l4] + i)] = flatExpr.subj[(int)(flatExpr.ptrb[(int)lArray2[n14]] + i)];
                    dArray[(int)(lArray4[(int)l4] + i)] = flatExpr.cof[(int)(flatExpr.ptrb[(int)lArray2[n14]] + i)] * denseMatrix.data[(int)lArray3[(int)lArray2[n14]]];
                }
                lArray4[(int)l4] = lArray4[(int)l4] + l5;
            }
            if (flatExpr.bfix != null) {
                n2 = -1;
                int n20 = 0;
                dArray2 = new double[(int)l];
                int n21 = 0;
                n17 = lArray3.length;
                for (n18 = n21; n18 < n17; ++n18) {
                    n14 = (int)(lArray3[(int)lArray2[n18]] / (long)denseMatrix.dimj);
                    if (n14 > n2) {
                        ++n20;
                        n2 = n14;
                    }
                    int n22 = n20 - 1;
                    dArray2[n22] = dArray2[n22] + denseMatrix.data[(int)lArray3[(int)lArray2[n18]]] * flatExpr.bfix[(int)lArray2[n18]];
                }
            }
            expr = new Expr(lArray4, flatExpr.x, lArray5, dArray, dArray2, null, (long[])(lArray.length < denseMatrix.dimi ? lArray : null));
        } else {
            int n23;
            Matrix matrix4 = matrix3;
            int[] nArray = new int[(int)matrix4.numNonzeros()];
            int[] nArray2 = new int[(int)matrix4.numNonzeros()];
            objectArray = new double[(int)matrix4.numNonzeros()];
            long l = matrix4.numNonzeros();
            n5 = matrix4.numRows();
            n4 = matrix4.numColumns();
            matrix4.getDataAsTriplets(nArray, nArray2, (double[])objectArray);
            n3 = 0;
            long l8 = 0L;
            n = -1;
            int n24 = 0;
            int n25 = 0;
            while ((long)n24 < l && n25 < lArray3.length) {
                int n26 = nArray[n24] * n4 + nArray2[n24];
                if ((long)n26 < lArray3[(int)lArray2[n25]]) {
                    ++n24;
                    continue;
                }
                if ((long)n26 > lArray3[(int)lArray2[n25]]) {
                    ++n25;
                    continue;
                }
                if (n < nArray[n24]) {
                    n = nArray[n24];
                    ++n3;
                }
                l8 += flatExpr.ptrb[(int)(lArray2[n25] + 1L)] - flatExpr.ptrb[(int)lArray2[n25]];
                ++n25;
                ++n24;
            }
            long[] lArray6 = new long[n3 + 1];
            long[] lArray7 = new long[(int)l8];
            double[] dArray = new double[(int)l8];
            double[] dArray3 = null;
            long[] lArray8 = new long[n3];
            int n27 = -1;
            int n28 = 0;
            int n29 = 0;
            long l9 = 0L;
            while ((long)n28 < l && n29 < lArray3.length) {
                n23 = nArray[n28] * n4 + nArray2[n28];
                if ((long)n23 < lArray3[(int)lArray2[n29]]) {
                    ++n28;
                    continue;
                }
                if ((long)n23 > lArray3[(int)lArray2[n29]]) {
                    ++n29;
                    continue;
                }
                if (n27 < nArray[n28]) {
                    n27 = nArray[n28];
                    lArray8[(int)(++l9 - 1L)] = n27;
                    lArray6[(int)l9] = lArray6[(int)(l9 - 1L)];
                }
                long l10 = flatExpr.ptrb[(int)(lArray2[n29] + 1L)] - flatExpr.ptrb[(int)lArray2[n29]];
                long l11 = 0L;
                long l12 = l10;
                for (long i = l11; i < l12; ++i) {
                    lArray7[(int)(lArray6[(int)l9] + i)] = flatExpr.subj[(int)(flatExpr.ptrb[(int)lArray2[n29]] + i)];
                    dArray[(int)lArray6[(int)(l9 + i)]] = flatExpr.cof[(int)(flatExpr.ptrb[(int)lArray2[n29]] + i)] * objectArray[n28];
                }
                lArray6[(int)l9] = lArray6[(int)l9] + l10;
                ++n29;
                ++n28;
            }
            if (flatExpr.bfix != null) {
                n27 = -1;
                n28 = 0;
                n29 = 0;
                l9 = 0L;
                dArray3 = new double[n3];
                while ((long)n28 < l && n29 < lArray3.length) {
                    n23 = nArray[n28] * n4 + nArray2[n28];
                    if ((long)n23 < lArray3[(int)lArray2[n29]]) {
                        ++n28;
                        continue;
                    }
                    if ((long)n23 > lArray3[(int)lArray2[n29]]) {
                        ++n29;
                        continue;
                    }
                    if (n27 < nArray[n28]) {
                        n27 = nArray[n28];
                        ++l9;
                    }
                    dArray3[(int)(l9 - 1L)] = dArray3[(int)(l9 - 1L)] + flatExpr.bfix[(int)lArray2[n29]] * objectArray[n28];
                    ++n29;
                    ++n28;
                }
            }
            if (lArray8.length == matrix4.dimi) {
                lArray8 = null;
            }
            expr = new Expr(lArray6, flatExpr.x, lArray7, dArray, dArray3, Set.make(matrix4.dimi), lArray8);
        }
        return expr;
    }

    public static Expression mulDiag(Variable variable, double[][] dArray) {
        return Expr.mulDiag(variable, Matrix.dense(dArray));
    }

    public static Expression mulDiag(double[][] dArray, Variable variable) {
        return Expr.mulDiag(Matrix.dense(dArray), variable);
    }

    public static Expression mulDiag(Expression expression, double[][] dArray) {
        return Expr.mulDiag(expression, Matrix.dense(dArray));
    }

    public static Expression mulDiag(double[][] dArray, Expression expression) {
        return Expr.mulDiag(Matrix.dense(dArray), expression);
    }

    private static Expression mulElm_(Matrix matrix, Expression expression) {
        if (matrix.numRows() != expression.shape().dim(0) || matrix.numColumns() != expression.shape().dim(1) || (long)(matrix.numRows() * matrix.numColumns()) != expression.shape().getSize()) {
            throw new DimensionError("Dimensions of operands do not match");
        }
        long l = matrix.numNonzeros();
        int[] nArray = new int[(int)l];
        int[] nArray2 = new int[(int)l];
        double[] dArray = new double[(int)l];
        matrix.getDataAsTriplets(nArray, nArray2, dArray);
        int n = 0;
        int n2 = 0;
        long l2 = l;
        long l3 = (long)n2 < l2 ? l2 - (long)n2 : 0L;
        long[] lArray = new long[(int)l3];
        long l4 = n2;
        int n3 = 0;
        while ((long)n3 < l3) {
            lArray[n] = nArray[(int)l4] * matrix.numColumns() + nArray2[(int)l4];
            ++n;
            ++n3;
            ++l4;
        }
        long[] lArray2 = lArray;
        FlatExpr flatExpr = expression.eval();
        return Expr.dotmul_(lArray2, dArray, flatExpr.ptrb, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.inst, flatExpr.x, flatExpr.shape);
    }

    private static Expression mulElm_(Matrix matrix, Variable variable) {
        if (matrix.numRows() != variable.shape().dim(0) || matrix.numColumns() != variable.shape().dim(1) || (long)(matrix.numRows() * matrix.numColumns()) != variable.shape().getSize()) {
            throw new DimensionError("Dimensions of operands do not match");
        }
        long l = matrix.numNonzeros();
        int[] nArray = new int[(int)l];
        int[] nArray2 = new int[(int)l];
        double[] dArray = new double[(int)l];
        matrix.getDataAsTriplets(nArray, nArray2, dArray);
        int n = 0;
        int n2 = 0;
        long l2 = l;
        long l3 = (long)n2 < l2 ? l2 - (long)n2 : 0L;
        long[] lArray = new long[(int)l3];
        long l4 = n2;
        int n3 = 0;
        while ((long)n3 < l3) {
            lArray[n] = nArray[(int)l4] * matrix.numColumns() + nArray2[(int)l4];
            ++n;
            ++n3;
            ++l4;
        }
        long[] lArray2 = lArray;
        return Expr.dotmul_(lArray2, dArray, variable, variable.shape());
    }

    private static Expression mulElm_(double[] dArray, Variable variable) {
        if (variable == null || dArray == null) {
            throw new NullPointerException("Arguments for mulElm may not be null");
        }
        if (variable.shape().dim(0) != dArray.length || variable.shape().getSize() != (long)dArray.length) {
            throw new DimensionError("Dimensions of operands do not match");
        }
        return Expr.dotmul_(Tools.range(0L, (long)dArray.length), dArray, variable, variable.shape());
    }

    private static Expression mulElm_(double[] dArray, Expression expression) {
        if (dArray == null || expression == null) {
            throw new NullPointerException("Arguments for mulElm may not be null");
        }
        if (expression.shape().dim(0) != dArray.length || expression.shape().getSize() != (long)dArray.length) {
            throw new DimensionError("Dimensions of operands do not match");
        }
        FlatExpr flatExpr = expression.eval();
        return Expr.dotmul_(Tools.range(0L, (long)dArray.length), dArray, flatExpr.ptrb, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.inst, flatExpr.x, flatExpr.shape);
    }

    private static Expression mulElm_(NDSparseArray nDSparseArray, Expression expression) {
        int n;
        if (nDSparseArray == null || expression == null) {
            throw new NullPointerException("Arguments for mulElm may not be null");
        }
        int n2 = 0;
        int n3 = nDSparseArray.dims.length;
        for (n = n2; n < n3; ++n) {
            if (nDSparseArray.dims[n] == expression.shape().dim(n)) continue;
            throw new DimensionError("Dimensions of operands do not match");
        }
        n2 = nDSparseArray.dims.length;
        n3 = expression.shape().nd;
        for (n = n2; n < n3; ++n) {
            if (1 == expression.shape().dim(n)) continue;
            throw new DimensionError("Dimensions of operands do not match");
        }
        n2 = 0;
        n3 = nDSparseArray.dims.length;
        for (n = n2; n < n3; ++n) {
            if (nDSparseArray.dims[n] == expression.shape().dim(n)) continue;
            throw new LengthError("Dimension mismatch");
        }
        FlatExpr flatExpr = expression.eval();
        return Expr.dotmul_(nDSparseArray.inst, nDSparseArray.cof, flatExpr.ptrb, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.inst, flatExpr.x, flatExpr.shape);
    }

    private static Expression mulElm_(NDSparseArray nDSparseArray, Variable variable) {
        if (variable.shape().nd != nDSparseArray.dims.length) {
            throw new LengthError("Dimension mismatch");
        }
        int n = 0;
        int n2 = nDSparseArray.dims.length;
        for (int i = n; i < n2; ++i) {
            if (nDSparseArray.dims[i] == variable.shape().dim(i)) continue;
            throw new LengthError("Dimension mismatch");
        }
        return Expr.dotmul_(nDSparseArray.inst, nDSparseArray.cof, variable, variable.shape());
    }

    private static Expression dotmul_(long[] lArray, double[] dArray, Variable variable, Set set) {
        int n = lArray.length;
        long[] lArray2 = Tools.range((long)lArray.length + 1L);
        long[] lArray3 = Tools.arraycopy(lArray);
        double[] dArray2 = Tools.arraycopy(dArray);
        double[] dArray3 = null;
        return new Expr(lArray2, new Variable[]{variable}, lArray3, dArray2, dArray3, set, lArray);
    }

    private static Expression dotmul_(long[] lArray, double[] dArray, long[] lArray2, long[] lArray3, double[] dArray2, double[] dArray3, long[] lArray4, Variable[] variableArray, Set set) {
        int n = lArray.length;
        long[] lArray5 = lArray4 != null ? lArray4 : Tools.range(0L, (long)lArray2.length - 1L);
        int n2 = lArray5.length;
        long l = 0L;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n && n5 < n2) {
            if (lArray[n4] < lArray5[n5]) {
                ++n4;
                continue;
            }
            if (lArray[n4] > lArray5[n5]) {
                ++n5;
                continue;
            }
            l += lArray2[n5 + 1] - lArray2[n5];
            ++n3;
            ++n4;
            ++n5;
        }
        long[] lArray6 = new long[(int)l];
        double[] dArray4 = new double[(int)l];
        long[] lArray7 = new long[n3 + 1];
        long[] lArray8 = new long[n3];
        double[] dArray5 = dArray3 == null ? null : new double[n3];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n6 < n && n7 < n2) {
            if (lArray[n6] < lArray5[n7]) {
                ++n6;
                continue;
            }
            if (lArray[n6] > lArray5[n7]) {
                ++n7;
                continue;
            }
            long l2 = lArray2[n7];
            long l3 = lArray2[n7 + 1];
            for (long i = l2; i < l3; ++i) {
                lArray6[n8] = lArray3[(int)i];
                dArray4[n8] = dArray2[(int)i] * dArray[n6];
                ++n8;
            }
            lArray7[n9 + 1] = lArray7[n9] + lArray2[n7 + 1] - lArray2[n7];
            lArray8[n9] = lArray5[n7];
            ++n9;
            ++n6;
            ++n7;
        }
        if (dArray3 != null) {
            n6 = 0;
            n7 = 0;
            n8 = 0;
            while (n6 < n && n7 < n2) {
                if (lArray[n6] < lArray5[n7]) {
                    ++n6;
                    continue;
                }
                if (lArray[n6] > lArray5[n7]) {
                    ++n7;
                    continue;
                }
                int n10 = n8++;
                dArray5[n10] = dArray5[n10] + dArray[n6] * dArray3[n7];
                ++n6;
                ++n7;
            }
        }
        return new Expr(lArray7, variableArray, lArray6, dArray4, dArray5, set, (long[])((long)lArray8.length < set.size ? lArray8 : null));
    }

    public static Expression mul(Matrix matrix, Expression expression) {
        if (matrix == null || expression == null) {
            throw new NullPointerException("Arguments for mul may not be null");
        }
        Expression expression2 = null;
        FlatExpr flatExpr = expression.eval();
        int n = matrix.numRows();
        int n2 = matrix.numColumns();
        Set set = null;
        if (flatExpr.shape.nd == 1 && flatExpr.shape.dim(0) == 1) {
            expression2 = Expr.mul_0DExpr_Matrix(flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.x, matrix);
        } else {
            int n3;
            int n4;
            if (flatExpr.shape.nd == 1 && flatExpr.shape.dim(0) == n2) {
                n4 = 1;
                n3 = flatExpr.shape.dim(0);
                set = new IntSet(n);
            } else if (flatExpr.shape.nd == 2 && flatExpr.shape.dim(0) == n2) {
                n3 = flatExpr.shape.dim(0);
                n4 = flatExpr.shape.dim(1);
                set = new NDSet(n, n4);
            } else {
                throw new DimensionError("Expression operand must be one- or two-dimensional, and dimensions must match for multiplication");
            }
            if (flatExpr.inst == null && !matrix.isSparse()) {
                expression2 = Expr.mul_DMatrix_2DDExpr(flatExpr.ptrb, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.x, set, n3, n4, matrix.getDataAsArray(), n, n2);
            } else {
                long l = matrix.numNonzeros();
                int[] nArray = new int[(int)l];
                int[] nArray2 = new int[(int)l];
                double[] dArray = new double[(int)l];
                matrix.getDataAsTriplets(nArray, nArray2, dArray);
                long[] lArray = flatExpr.inst;
                if (lArray == null) {
                    lArray = Tools.range(0L, (long)flatExpr.ptrb.length - 1L);
                }
                expression2 = Expr.mul_SMatrix_2DSExpr(flatExpr.ptrb, flatExpr.subj, flatExpr.cof, flatExpr.bfix, lArray, flatExpr.x, set, n3, n4, nArray, nArray2, dArray, n, n2);
            }
        }
        return expression2;
    }

    public static Expression mul(Expression expression, Matrix matrix) {
        if (matrix == null || expression == null) {
            throw new NullPointerException("Arguments for mul may not be null");
        }
        Expression expression2 = null;
        FlatExpr flatExpr = expression.eval();
        int n = matrix.numRows();
        int n2 = matrix.numColumns();
        if (flatExpr.shape.nd == 1 && flatExpr.shape.dim(0) == 1) {
            expression2 = Expr.mul_0DExpr_Matrix(flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.x, matrix);
        } else {
            int n3;
            int n4;
            Set set = null;
            if (flatExpr.shape.nd == 1 && flatExpr.shape.dim(0) == n) {
                n4 = 1;
                n3 = flatExpr.shape.dim(0);
                set = new IntSet(n2);
            } else if (flatExpr.shape.nd == 2 && flatExpr.shape.dim(1) == n) {
                n4 = flatExpr.shape.dim(0);
                n3 = flatExpr.shape.dim(1);
                set = new NDSet(n4, n2);
            } else {
                throw new DimensionError("Expression operand must be one- or two-dimensional, and dimensions must match for multiplication");
            }
            if (flatExpr.inst == null && !matrix.isSparse()) {
                expression2 = Expr.mul_2DDExpr_DMatrix(flatExpr.ptrb, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.x, set, n4, n3, matrix.getDataAsArray(), n, n2);
            } else {
                long l = matrix.numNonzeros();
                int[] nArray = new int[(int)l];
                int[] nArray2 = new int[(int)l];
                double[] dArray = new double[(int)l];
                matrix.getDataAsTriplets(nArray, nArray2, dArray);
                long[] lArray = flatExpr.inst;
                if (lArray == null) {
                    lArray = Tools.range(0L, (long)flatExpr.ptrb.length - 1L);
                }
                expression2 = Expr.mul_2DSExpr_SMatrix(flatExpr.ptrb, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.inst, flatExpr.x, set, n4, n3, nArray, nArray2, dArray, n, n2);
            }
        }
        return expression2;
    }

    public static Expression mul(Expression expression, double[] dArray) {
        if (dArray == null || expression == null) {
            throw new NullPointerException("Arguments for mul may not be null");
        }
        Expression expression2 = null;
        int n = dArray.length;
        int n2 = 1;
        FlatExpr flatExpr = expression.eval();
        if (flatExpr.shape.nd == 1 && flatExpr.shape.dim(0) == 1) {
            expression2 = Expr.mul_0DExpr_Matrix(flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.x, new DenseMatrix(dArray.length, 1, dArray));
        } else {
            int n3;
            int n4;
            IntSet intSet = null;
            if (flatExpr.shape.nd == 1) {
                intSet = new IntSet(1);
                n4 = flatExpr.shape.dim(0);
                n3 = 1;
            } else if (flatExpr.shape.realnd() == 2) {
                intSet = new IntSet(flatExpr.shape.dim(0));
                n3 = flatExpr.shape.dim(0);
                n4 = flatExpr.shape.dim(1);
            } else {
                throw new DimensionError("Expression operand must be one- or two-dimensional");
            }
            if (n4 != n) {
                throw new DimensionError("Mismatching dimensions of operands");
            }
            expression2 = flatExpr.inst == null ? Expr.mul_2DDExpr_DMatrix(flatExpr.ptrb, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.x, intSet, n3, n4, dArray, n, n2) : Expr.mul_2DSExpr_SMatrix(flatExpr.ptrb, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.inst, flatExpr.x, intSet, n3, n4, Tools.range(0, n), Tools.makevector(0, n), dArray, n, n2);
        }
        return expression2;
    }

    public static Expression mul(double[] dArray, Expression expression) {
        if (dArray == null || expression == null) {
            throw new NullPointerException("Arguments for mul may not be null");
        }
        int n = 1;
        int n2 = dArray.length;
        Expression expression2 = null;
        FlatExpr flatExpr = expression.eval();
        if (flatExpr.shape.nd == 1 && flatExpr.shape.dim(0) == 1) {
            expression2 = Expr.mul_0DExpr_Matrix(flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.x, new DenseMatrix(1, dArray.length, dArray));
        } else {
            int n3;
            int n4;
            IntSet intSet = null;
            if (flatExpr.shape.nd == 1) {
                n4 = 1;
                n3 = flatExpr.shape.dim(0);
                intSet = new IntSet(1);
            } else if (flatExpr.shape.nd == 2) {
                intSet = new IntSet(flatExpr.shape.dim(1));
                n3 = flatExpr.shape.dim(0);
                n4 = flatExpr.shape.dim(1);
            } else {
                throw new DimensionError("Mismatching dimensions of operands");
            }
            if (n3 != n2) {
                throw new DimensionError("Mismatching dimensions of operands");
            }
            expression2 = flatExpr.inst == null ? Expr.mul_DMatrix_2DDExpr(flatExpr.ptrb, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.x, intSet, n3, n4, dArray, n, n2) : Expr.mul_SMatrix_2DSExpr(flatExpr.ptrb, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.inst, flatExpr.x, intSet, n3, n4, Tools.makevector(0, n2), Tools.range(0, n2), dArray, n, n2);
        }
        return expression2;
    }

    public static Expression mul(double d, Expression expression) {
        int n;
        if (expression == null) {
            throw new NullPointerException("Arguments for mul may not be null");
        }
        FlatExpr flatExpr = expression.eval();
        int n2 = 0;
        int n3 = flatExpr.cof.length;
        for (n = n2; n < n3; ++n) {
            flatExpr.cof[n] = flatExpr.cof[n] * d;
        }
        if (flatExpr.bfix != null) {
            n2 = 0;
            n3 = flatExpr.bfix.length;
            for (n = n2; n < n3; ++n) {
                flatExpr.bfix[n] = flatExpr.bfix[n] * d;
            }
        }
        return new Expr(flatExpr.ptrb, flatExpr.x, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.shape, flatExpr.inst, 1);
    }

    public static Expression mul(Expression expression, double d) {
        if (expression == null) {
            throw new NullPointerException("Arguments for mul may not be null");
        }
        return Expr.mul(d, expression);
    }

    private static Expression mul_SMatrix_2DSExpr(long[] lArray, long[] lArray2, double[] dArray, double[] dArray2, long[] lArray3, Variable[] variableArray, Set set, int n, int n2, int[] nArray, int[] nArray2, double[] dArray3, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        long l;
        int n11;
        Expr expr = null;
        int n12 = 0;
        int n13 = 0;
        int n14 = lArray3.length;
        int n15 = n13 < n14 ? n14 - n13 : 0;
        int[] nArray3 = new int[n15];
        int n16 = n13;
        int n17 = 0;
        while (n17 < n15) {
            nArray3[n12] = (int)(lArray3[n16] / (long)n2);
            ++n12;
            ++n17;
            ++n16;
        }
        int[] nArray4 = nArray3;
        int n18 = 0;
        int n19 = 0;
        int n20 = lArray3.length;
        int n21 = n19 < n20 ? n20 - n19 : 0;
        int[] nArray5 = new int[n21];
        int n22 = n19;
        int n23 = 0;
        while (n23 < n21) {
            nArray5[n18] = (int)(lArray3[n22] % (long)n2);
            ++n18;
            ++n23;
            ++n22;
        }
        int[] nArray6 = nArray5;
        long[] lArray4 = Tools.range(0L, (long)lArray3.length);
        int n24 = nArray.length;
        int n25 = lArray3.length;
        int n26 = n3;
        int n27 = n2;
        CommonTools.argQsort(lArray4, nArray6, nArray4, 0L, (long)lArray3.length);
        int n28 = 0;
        long l2 = 0L;
        int n29 = 0;
        while (n29 < n24 && n29 < n24) {
            int n30;
            int n31 = nArray[n29];
            for (n30 = n29 + 1; n30 < n24 && n31 == nArray[n30]; ++n30) {
            }
            int n32 = 0;
            while (n32 < n25 && n32 < n25) {
                int n33 = nArray6[(int)lArray4[n32]];
                for (n11 = n32 + 1; n11 < n25 && nArray6[(int)lArray4[n11]] == n33; ++n11) {
                }
                l = l2;
                n10 = 0;
                n9 = n29;
                n8 = n32;
                while (n9 < n30 && n8 < n11) {
                    if (nArray2[n9] < nArray4[(int)lArray4[n8]]) {
                        ++n9;
                        continue;
                    }
                    if (nArray2[n9] > nArray4[(int)lArray4[n8]]) {
                        ++n8;
                        continue;
                    }
                    l += lArray[(int)(lArray4[n8] + 1L)] - lArray[(int)lArray4[n8]];
                    ++n9;
                    ++n8;
                    ++n10;
                }
                if (n10 > 0) {
                    ++n28;
                    l2 = l;
                }
                n32 = n11;
            }
            n29 = n30;
        }
        long[] lArray5 = new long[n28];
        long[] lArray6 = new long[n28 + 1];
        long[] lArray7 = new long[(int)l2];
        double[] dArray4 = new double[(int)l2];
        double[] dArray5 = null;
        n11 = 0;
        l = 0L;
        n10 = 0;
        while (n10 < n24 && n10 < n24) {
            n9 = nArray[n10];
            for (n8 = n10 + 1; n8 < n24 && n9 == nArray[n8]; ++n8) {
            }
            n7 = 0;
            while (n7 < n25 && n7 < n25) {
                int n34;
                n6 = nArray6[(int)lArray4[n7]];
                for (n34 = n7 + 1; n34 < n25 && nArray6[(int)lArray4[n34]] == n6; ++n34) {
                }
                long l3 = l;
                n5 = 0;
                int n35 = n10;
                int n36 = n7;
                while (n35 < n8 && n36 < n34) {
                    if (nArray2[n35] < nArray4[(int)lArray4[n36]]) {
                        ++n35;
                        continue;
                    }
                    if (nArray2[n35] > nArray4[(int)lArray4[n36]]) {
                        ++n36;
                        continue;
                    }
                    ++n5;
                    long l4 = lArray[(int)lArray4[n36]];
                    long l5 = lArray[(int)(lArray4[n36] + 1L)];
                    for (long i = l4; i < l5; ++i) {
                        lArray7[(int)l3] = lArray2[(int)i];
                        dArray4[(int)l3] = dArray[(int)i] * dArray3[n35];
                        ++l3;
                    }
                    ++n35;
                    ++n36;
                }
                if (n5 > 0) {
                    lArray5[n11] = (long)n9 * (long)n2 + (long)n6;
                    lArray6[n11 + 1] = l3;
                    ++n11;
                    l = l3;
                }
                n7 = n34;
            }
            n10 = n8;
        }
        if (dArray2 != null) {
            dArray5 = new double[n28];
            n11 = 0;
            int n37 = 0;
            while (n37 < n24 && n37 < n24) {
                int n38 = nArray[n37];
                for (n10 = n37 + 1; n10 < n24 && n38 == nArray[n10]; ++n10) {
                }
                n9 = 0;
                while (n9 < n25 && n9 < n25) {
                    n8 = nArray6[(int)lArray4[n9]];
                    for (n7 = n9 + 1; n7 < n25 && nArray6[(int)lArray4[n7]] == n8; ++n7) {
                    }
                    n6 = 0;
                    double d = 0.0;
                    int n39 = n37;
                    n5 = n9;
                    while (n39 < n10 && n5 < n7) {
                        if (nArray2[n39] < nArray4[(int)lArray4[n5]]) {
                            ++n39;
                            continue;
                        }
                        if (nArray2[n39] > nArray4[(int)lArray4[n5]]) {
                            ++n5;
                            continue;
                        }
                        d += dArray2[(int)lArray4[n5]] * dArray3[n39];
                        ++n6;
                        ++n39;
                        ++n5;
                    }
                    if (n6 > 0) {
                        dArray5[n11] = d;
                        ++n11;
                    }
                    n9 = n7;
                }
                n37 = n10;
            }
        }
        if (lArray5.length == n26 * n27) {
            lArray5 = null;
        }
        expr = new Expr(lArray6, variableArray, lArray7, dArray4, dArray5, set, lArray5);
        return expr;
    }

    private static Expression mul_2DSExpr_SMatrix(long[] lArray, long[] lArray2, double[] dArray, double[] dArray2, long[] lArray3, Variable[] variableArray, Set set, int n, int n2, int[] nArray, int[] nArray2, double[] dArray3, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        Expr expr = null;
        int n12 = n;
        int n13 = n4;
        long l = dArray3.length;
        long l2 = lArray3.length;
        long[] lArray4 = Tools.range(0L, (long)nArray.length);
        CommonTools.argQsort(lArray4, nArray2, nArray, 0L, (long)nArray.length);
        int n14 = 0;
        long l3 = 0L;
        int n15 = 0;
        while ((long)n15 < l2 && (long)n15 < l2) {
            int n16;
            long l4 = lArray3[n15] / (long)n2;
            for (n16 = n15; n16 < lArray3.length && l4 == lArray3[n16] / (long)n2; ++n16) {
            }
            int n17 = 0;
            while ((long)n17 < l && (long)n17 < l) {
                n11 = n17;
                int n18 = nArray2[(int)lArray4[n17]];
                while ((long)n11 < l && nArray2[(int)lArray4[n11]] == n18) {
                    ++n11;
                }
                n10 = n15;
                n9 = n17;
                long l5 = l3;
                while (n10 < n16 && n9 < n11) {
                    if (lArray3[n10] % (long)n2 < (long)nArray[(int)lArray4[n9]]) {
                        ++n10;
                        continue;
                    }
                    if (lArray3[n10] % (long)n2 > (long)nArray[(int)lArray4[n9]]) {
                        ++n9;
                        continue;
                    }
                    l5 += lArray[n10 + 1] - lArray[n10];
                    ++n10;
                    ++n9;
                }
                if (l5 > l3) {
                    l3 = l5;
                    ++n14;
                }
                n17 = n11;
            }
            n15 = n16;
        }
        long[] lArray5 = new long[n14 + 1];
        long[] lArray6 = new long[n14];
        long[] lArray7 = new long[(int)l3];
        double[] dArray4 = new double[(int)l3];
        double[] dArray5 = null;
        n11 = 0;
        long l6 = 0L;
        n9 = 0;
        while ((long)n9 < l2 && (long)n9 < l2) {
            int n19;
            long l7 = lArray3[n9] / (long)n2;
            for (n19 = n9; n19 < lArray3.length && l7 == lArray3[n19] / (long)n2; ++n19) {
            }
            n8 = 0;
            while ((long)n8 < l && (long)n8 < l) {
                n7 = n8;
                n6 = nArray2[(int)lArray4[n8]];
                while ((long)n7 < l && nArray2[(int)lArray4[n7]] == n6) {
                    ++n7;
                }
                n5 = n9;
                int n20 = n8;
                long l8 = l6;
                int n21 = 0;
                while (n5 < n19 && n20 < n7) {
                    if (lArray3[n5] % (long)n2 < (long)nArray[(int)lArray4[n20]]) {
                        ++n5;
                        continue;
                    }
                    if (lArray3[n5] % (long)n2 > (long)nArray[(int)lArray4[n20]]) {
                        ++n20;
                        continue;
                    }
                    double d = dArray3[(int)lArray4[n20]];
                    long l9 = lArray[n5];
                    long l10 = lArray[n5 + 1];
                    for (long i = l9; i < l10; ++i) {
                        lArray7[(int)l8] = lArray2[(int)i];
                        dArray4[(int)l8] = d * dArray[(int)i];
                        ++l8;
                        ++n21;
                    }
                    ++n5;
                    ++n20;
                }
                if (n21 > 0) {
                    l6 = l8;
                    lArray5[n11 + 1] = l8;
                    lArray6[n11] = l7 * (long)n13 + (long)n6;
                    ++n11;
                }
                n8 = n7;
            }
            n9 = n19;
        }
        if (dArray2 != null) {
            dArray5 = new double[n14];
            n11 = 0;
            int n22 = 0;
            while ((long)n22 < l2 && (long)n22 < l2) {
                long l11 = lArray3[n22] / (long)n2;
                for (n10 = n22; n10 < lArray3.length && l11 == lArray3[n10] / (long)n2; ++n10) {
                }
                int n23 = 0;
                while ((long)n23 < l && (long)n23 < l) {
                    int n24 = n23;
                    n8 = nArray2[(int)lArray4[n23]];
                    while ((long)n24 < l && nArray2[(int)lArray4[n24]] == n8) {
                        ++n24;
                    }
                    n7 = n22;
                    n6 = n23;
                    n5 = 0;
                    double d = 0.0;
                    while (n7 < n10 && n6 < n24) {
                        if (lArray3[n7] % (long)n2 < (long)nArray[(int)lArray4[n6]]) {
                            ++n7;
                            continue;
                        }
                        if (lArray3[n7] % (long)n2 > (long)nArray[(int)lArray4[n6]]) {
                            ++n6;
                            continue;
                        }
                        d += dArray2[n7] * dArray3[(int)lArray4[n6]];
                        ++n5;
                        ++n7;
                        ++n6;
                    }
                    if (n5 > 0) {
                        dArray5[n11] = d;
                        ++n11;
                    }
                    n23 = n24;
                }
                n22 = n10;
            }
        }
        if (lArray6.length == n12 * n13) {
            lArray6 = null;
        }
        expr = new Expr(lArray5, variableArray, lArray7, dArray4, dArray5, set, lArray6);
        return expr;
    }

    private static Expression mul_DMatrix_2DDExpr(long[] lArray, long[] lArray2, double[] dArray, double[] dArray2, Variable[] variableArray, Set set, int n, int n2, double[] dArray3, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = n3;
        int n11 = n2;
        long l = (long)n10 * (long)n11;
        long[] lArray3 = new long[(int)(l + 1L)];
        long[] lArray4 = new long[lArray2.length * n3];
        double[] dArray4 = new double[lArray2.length * n3];
        double[] dArray5 = null;
        long l2 = 0L;
        int n12 = 0;
        int n13 = 0;
        int n14 = n3;
        for (n9 = n13; n9 < n14; ++n9) {
            n8 = 0;
            n7 = n2;
            for (n6 = n8; n6 < n7; ++n6) {
                n5 = 0;
                int n15 = n;
                for (int i = n5; i < n15; ++i) {
                    double d = dArray3[n4 * n9 + i];
                    long l3 = lArray[i * n2 + n6];
                    long l4 = lArray[i * n2 + n6 + 1];
                    for (long j = l3; j < l4; ++j) {
                        dArray4[(int)l2] = d * dArray[(int)j];
                        lArray4[(int)l2] = lArray2[(int)j];
                        ++l2;
                    }
                }
                lArray3[n12 + 1] = l2;
                ++n12;
            }
        }
        if (dArray2 != null) {
            int n16 = 0;
            dArray5 = new double[(int)l];
            int n17 = 0;
            n12 = n3;
            for (n13 = n17; n13 < n12; ++n13) {
                n14 = 0;
                n9 = n2;
                for (n8 = n14; n8 < n9; ++n8) {
                    n7 = 0;
                    n6 = n;
                    for (n5 = n7; n5 < n6; ++n5) {
                        dArray5[n16] = dArray5[n16] + dArray2[n5 * n2 + n8] * dArray3[n4 * n13 + n5];
                    }
                    ++n16;
                }
            }
        }
        Expr expr = new Expr(lArray3, variableArray, lArray4, dArray4, dArray5, set, null);
        return expr;
    }

    private static Expression mul_2DDExpr_DMatrix(long[] lArray, long[] lArray2, double[] dArray, double[] dArray2, Variable[] variableArray, Set set, int n, int n2, double[] dArray3, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = n;
        int n13 = n4;
        long[] lArray3 = new long[n * n4 + 1];
        long[] lArray4 = null;
        long[] lArray5 = new long[lArray2.length * n4];
        double[] dArray4 = new double[lArray2.length * n4];
        double[] dArray5 = null;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = n12;
        for (n11 = n16; n11 < n17; ++n11) {
            n10 = 0;
            n9 = n13;
            for (n8 = n10; n8 < n9; ++n8) {
                n7 = n11 * n2;
                lArray3[n15 + 1] = lArray3[n15];
                n6 = 0;
                n5 = n3;
                for (int i = n6; i < n5; ++i) {
                    lArray3[n15 + 1] = lArray3[n15 + 1] + (lArray[n7 + i + 1] - lArray[n7 + i]);
                    double d = dArray3[n4 * i + n8];
                    long l = lArray[n7 + i];
                    long l2 = lArray[n7 + i + 1];
                    for (long j = l; j < l2; ++j) {
                        lArray5[n14] = lArray2[(int)j];
                        dArray4[n14] = dArray[(int)j] * d;
                        ++n14;
                    }
                }
                ++n15;
            }
        }
        if (dArray2 != null) {
            dArray5 = new double[n12 * n13];
            n14 = 0;
            n15 = 0;
            n16 = n12;
            for (n17 = n15; n17 < n16; ++n17) {
                n11 = 0;
                n10 = n13;
                for (n9 = n11; n9 < n10; ++n9) {
                    n8 = n17 * n2;
                    n7 = 0;
                    n6 = n3;
                    for (n5 = n7; n5 < n6; ++n5) {
                        int n18 = n14;
                        dArray5[n18] = dArray5[n18] + dArray2[n8 + n5] * dArray3[n4 * n5 + n9];
                    }
                    ++n14;
                }
            }
        }
        Expr expr = new Expr(lArray3, variableArray, lArray5, dArray4, dArray5, set, lArray4);
        return expr;
    }

    private static Expression mul_0DExpr_Matrix(long[] lArray, double[] dArray, double[] dArray2, Variable[] variableArray, Matrix matrix) {
        int n;
        double[] dArray3;
        Expr expr = null;
        int n2 = matrix.numRows();
        int n3 = matrix.numColumns();
        long l = matrix.numNonzeros();
        int[] nArray = null;
        int[] nArray2 = null;
        long[] lArray2 = Tools.range(0L, l * (long)lArray.length + 1L, (long)lArray.length);
        long[] lArray3 = new long[(int)(l * (long)lArray.length)];
        double[] dArray4 = new double[(int)(l * (long)lArray.length)];
        double[] dArray5 = null;
        long[] lArray4 = null;
        if (!matrix.isSparse()) {
            dArray3 = matrix.getDataAsArray();
        } else {
            nArray = new int[(int)l];
            nArray2 = new int[(int)l];
            dArray3 = new double[(int)l];
            lArray4 = new long[(int)l];
            matrix.getDataAsTriplets(nArray, nArray2, dArray3);
            n = 0;
            int n4 = nArray.length;
            for (int i = n; i < n4; ++i) {
                lArray4[i] = (long)nArray[i] * (long)n3 + (long)nArray2[i];
            }
        }
        n = 0;
        long l2 = 0L;
        long l3 = l;
        for (long i = l2; i < l3; ++i) {
            int n5 = 0;
            int n6 = lArray.length;
            for (int j = n5; j < n6; ++j) {
                lArray3[n] = lArray[j];
                dArray4[n] = dArray3[(int)i] * dArray3[(int)i];
                ++n;
            }
        }
        if (dArray2 != null) {
            dArray5 = new double[(int)l];
            long l4 = 0L;
            long l5 = l;
            for (long i = l4; i < l5; ++i) {
                dArray5[(int)i] = dArray3[(int)i] * dArray2[0];
            }
        }
        expr = new Expr(lArray2, variableArray, lArray3, dArray4, dArray5, new NDSet(n2, n3), null);
        return expr;
    }

    public static Expression mul(Variable variable, double[][] dArray) {
        if (dArray == null || variable == null) {
            throw new NullPointerException("Arguments for mul may not be null");
        }
        if (dArray.length == 0) {
            long[] lArray = new long[]{0L, 0L};
            long[] lArray2 = new long[]{};
            double[] dArray2 = new double[]{};
            return new Expr(lArray, new Variable[]{variable}, lArray2, dArray2, null, null, null, 1);
        }
        return Expr.mul(variable, (Matrix)new DenseMatrix(dArray));
    }

    public static Expression mul(double[][] dArray, Variable variable) {
        if (dArray == null || variable == null) {
            throw new NullPointerException("Arguments for mul may not be null");
        }
        return Expr.mul((Matrix)new DenseMatrix(dArray), variable);
    }

    public static Expression mul(Variable variable, double d) {
        if (variable == null) {
            throw new NullPointerException("Arguments for mul may not be null");
        }
        return Expr.mul(d, variable);
    }

    public static Expression mul(double d, Variable variable) {
        if (variable == null) {
            throw new NullPointerException("Arguments for mul may not be null");
        }
        double d2 = d;
        Variable variable2 = variable;
        long[] lArray = Tools.range(0L, variable2.shape().size + 1L);
        double[] dArray = Tools.makevector(d2, (int)variable2.shape().size);
        long[] lArray2 = Tools.range(0L, variable2.shape().size);
        double[] dArray2 = null;
        return new Expr(lArray, new Variable[]{variable}, lArray2, dArray, dArray2, variable2.shape(), null);
    }

    public static Expression mul(double[] dArray, Variable variable) {
        if (variable == null || dArray == null) {
            throw new NullPointerException("Arguments for mul may not be null");
        }
        double[] dArray2 = dArray;
        Variable variable2 = variable;
        if (variable2.shape().size == 1L || variable2.shape().nd == 1) {
            return Expr.mul(variable2, dArray2);
        }
        if (variable.shape().nd == 1 && variable.shape().dim(0) == dArray.length) {
            return Expr.dot(variable, dArray);
        }
        if (variable2.shape().nd == 2) {
            long l;
            if (variable2.shape().dim(0) != dArray2.length) {
                throw new DimensionError("Dimensions of operands do not match");
            }
            long l2 = variable2.shape().dim(0);
            long l3 = variable2.shape().dim(1);
            int n = 0;
            long l4 = 0L;
            long l5 = (l3 + 1L) * l2;
            long l6 = l2;
            long l7 = l4 < l5 && l6 > 0L ? (l5 - l4 - 1L) / l6 + 1L : (l5 < l4 && l6 < 0L ? (l4 - l5 - 1L) / -l6 + 1L : 0L);
            long[] lArray = new long[(int)l7];
            long l8 = l4;
            int n2 = 0;
            while ((long)n2 < l7) {
                lArray[n] = l8;
                ++n;
                ++n2;
                l8 += l6;
            }
            long[] lArray2 = lArray;
            double[] dArray3 = new double[(int)variable2.shape().size];
            long l9 = 0L;
            long l10 = l3;
            for (l = l9; l < l10; ++l) {
                Tools.arraycopy(dArray2, 0L, dArray3, l * l2, l2);
            }
            int n3 = 0;
            int n4 = 0;
            l10 = l3;
            l = (long)n4 < l10 ? l10 - (long)n4 : 0L;
            int n5 = 0;
            long l11 = l2;
            long l12 = (long)n5 < l11 ? l11 - (long)n5 : 0L;
            long[] lArray3 = new long[(int)(l * l12)];
            long l13 = n4;
            int n6 = 0;
            while ((long)n6 < l) {
                long l14 = n5;
                int n7 = 0;
                while ((long)n7 < l12) {
                    lArray3[n3] = l14 * l3 + l13;
                    ++n3;
                    ++n7;
                    ++l14;
                }
                ++n6;
                ++l13;
            }
            long[] lArray4 = lArray3;
            return new Expr(lArray2, new Variable[]{variable2}, lArray4, dArray3, null, null, null, 1);
        }
        throw new DimensionError("Dimensions of operands do not match");
    }

    public static Expression mul(Variable variable, double[] dArray) {
        if (variable == null || dArray == null) {
            throw new NullPointerException("Arguments for mul may not be null");
        }
        Variable variable2 = variable;
        double[] dArray2 = dArray;
        if (variable2.shape().size == 0L) {
            long[] lArray = new long[]{0L, 0L};
            long[] lArray2 = new long[]{};
            double[] dArray3 = new double[]{};
            return new Expr(lArray, new Variable[]{variable}, lArray2, dArray3, null, null, null, 1);
        }
        if (variable2.shape().size == 1L) {
            long[] lArray = Tools.range(0L, (long)dArray2.length + 1L);
            long[] lArray3 = Tools.makevector(0L, dArray2.length);
            double[] dArray4 = Tools.arraycopy(dArray2);
            double[] dArray5 = null;
            return new Expr(lArray, new Variable[]{variable}, lArray3, dArray4, dArray5, null, null, 1);
        }
        if (variable.shape().nd == 1 && variable.shape().dim(0) == dArray.length) {
            return Expr.dot(variable, dArray);
        }
        if (variable2.shape().nd == 2) {
            if (variable2.shape().dim(1) != dArray2.length) {
                throw new DimensionError("Dimensions of operands do not match");
            }
            int n = 0;
            int n2 = 0;
            long l = variable2.shape().size + (long)variable2.shape().dim(1);
            int n3 = variable2.shape().dim(1);
            long l2 = (long)n2 < l && n3 > 0 ? (l - (long)n2 - 1L) / (long)n3 + 1L : (l < (long)n2 && n3 < 0 ? ((long)n2 - l - 1L) / (long)(-n3) + 1L : 0L);
            long[] lArray = new long[(int)l2];
            long l3 = n2;
            int n4 = 0;
            while ((long)n4 < l2) {
                lArray[n] = l3;
                ++n;
                ++n4;
                l3 += (long)n3;
            }
            long[] lArray4 = lArray;
            int n5 = 0;
            int n6 = 0;
            long l4 = variable2.shape().size;
            long l5 = (long)n6 < l4 ? l4 - (long)n6 : 0L;
            long[] lArray5 = new long[(int)l5];
            long l6 = n6;
            int n7 = 0;
            while ((long)n7 < l5) {
                lArray5[n5] = l6++;
                ++n5;
                ++n7;
            }
            long[] lArray6 = lArray5;
            double[] dArray6 = new double[(int)variable2.shape().size];
            long l7 = variable2.shape().dim(1);
            long l8 = 0L;
            int n8 = variable2.shape().dim(0);
            for (long i = l8; i < (long)n8; ++i) {
                Tools.arraycopy(dArray2, 0L, dArray6, i * l7, l7);
            }
            double[] dArray7 = null;
            return new Expr(lArray4, new Variable[]{variable}, lArray6, dArray6, dArray7, null, null, 1);
        }
        throw new DimensionError("Dimensions of operands do not match");
    }

    public static Expression mul(Variable variable, Matrix matrix) {
        int n;
        int n2;
        if (variable == null || matrix == null) {
            throw new NullPointerException("Arguments for mul may not be null");
        }
        Variable variable2 = variable;
        Matrix matrix2 = matrix;
        int n3 = matrix.numRows();
        int n4 = matrix.numColumns();
        long l = matrix.numNonzeros();
        if (variable.shape().nd == 1 && variable.shape().dim(0) == 1) {
            return Expr.mul(matrix, variable);
        }
        if (variable2.shape().nd == 1) {
            if ((long)matrix2.dimi != variable2.shape().size) {
                throw new LengthError("Operand shapes do not match.");
            }
            n2 = 1;
            n = variable2.shape().dim(0);
        } else if (variable2.shape().nd == 2) {
            if (matrix.dimi != variable.shape().dim(1)) {
                throw new LengthError("Operand shapes do not match.");
            }
            n2 = variable2.shape().dim(0);
            n = variable2.shape().dim(1);
        } else {
            throw new LengthError("Variable must be one- or two-dimensional.");
        }
        int n5 = n2;
        int n6 = n4;
        Set set = null;
        set = variable.shape().nd == 1 ? new IntSet(n6) : new NDSet(n5, n6);
        if (!matrix.isSparse()) {
            int n7;
            int n8;
            int n9;
            int n10;
            long l2 = (long)n5 * (long)n6;
            double[] dArray = matrix.getDataAsArray();
            int n11 = 0;
            long l3 = 0L;
            long l4 = (long)n5 * (long)n6 * (long)n + 1L;
            int n12 = n;
            long l5 = l3 < l4 && n12 > 0 ? (l4 - l3 - 1L) / (long)n12 + 1L : (l4 < l3 && n12 < 0 ? (l3 - l4 - 1L) / (long)(-n12) + 1L : 0L);
            long[] lArray = new long[(int)l5];
            long l6 = l3;
            int n13 = 0;
            while ((long)n13 < l5) {
                lArray[n11] = l6;
                ++n11;
                ++n13;
                l6 += (long)n12;
            }
            long[] lArray2 = lArray;
            int n14 = 0;
            int n15 = 0;
            int n16 = n5;
            int n17 = n15 < n16 ? n16 - n15 : 0;
            int n18 = 0;
            int n19 = n6;
            int n20 = n18 < n19 ? n19 - n18 : 0;
            int n21 = 0;
            int n22 = n;
            int n23 = n21 < n22 ? n22 - n21 : 0;
            long[] lArray3 = new long[n17 * n20 * n23];
            int n24 = n15;
            int n25 = 0;
            while (n25 < n17) {
                n10 = n18;
                n9 = 0;
                while (n9 < n20) {
                    n8 = n21;
                    n7 = 0;
                    while (n7 < n23) {
                        lArray3[n14] = (long)n24 * (long)n + (long)n8;
                        ++n14;
                        ++n7;
                        ++n8;
                    }
                    ++n9;
                    ++n10;
                }
                ++n25;
                ++n24;
            }
            long[] lArray4 = lArray3;
            n10 = 0;
            n9 = 0;
            n8 = n5;
            n7 = n9 < n8 ? n8 - n9 : 0;
            int n26 = 0;
            int n27 = n6;
            int n28 = n26 < n27 ? n27 - n26 : 0;
            int n29 = 0;
            int n30 = n;
            int n31 = n29 < n30 ? n30 - n29 : 0;
            double[] dArray2 = new double[n7 * n28 * n31];
            int n32 = n9;
            int n33 = 0;
            while (n33 < n7) {
                int n34 = n26;
                int n35 = 0;
                while (n35 < n28) {
                    int n36 = n29;
                    int n37 = 0;
                    while (n37 < n31) {
                        dArray2[n10] = dArray[n36 * n4 + n34];
                        ++n10;
                        ++n37;
                        ++n36;
                    }
                    ++n35;
                    ++n34;
                }
                ++n33;
                ++n32;
            }
            double[] dArray3 = dArray2;
            return new Expr(lArray2, new Variable[]{variable}, lArray4, dArray3, null, set, null);
        }
        if (l > 0L) {
            long l7;
            int[] nArray = new int[(int)l];
            int[] nArray2 = new int[(int)l];
            double[] dArray = new double[(int)l];
            int n38 = 0;
            long l8 = 0L;
            long l9 = l;
            long l10 = l8 < l9 ? l9 - l8 : 0L;
            long[] lArray = new long[(int)l10];
            long l11 = l8;
            int n39 = 0;
            while ((long)n39 < l10) {
                lArray[n38] = l11++;
                ++n38;
                ++n39;
            }
            long[] lArray5 = lArray;
            matrix.getDataAsTriplets(nArray, nArray2, dArray);
            if (l > (long)n4) {
                Sort.argbucketsort(lArray5, nArray2, 0L, l, 0, n4);
            } else {
                Sort.argsort(lArray5, nArray2, 0L, l, false);
            }
            long l12 = 0L;
            if (l > 0L) {
                l12 = 1L;
                for (l7 = 1L; l7 < l && l7 < l; ++l7) {
                    if (nArray2[(int)lArray5[(int)l7]] <= nArray2[(int)lArray5[(int)(l7 - 1L)]]) continue;
                    ++l12;
                }
            }
            l7 = l12 * (long)n2;
            long[] lArray6 = new long[(int)(l7 + 1L)];
            long[] lArray7 = new long[(int)l7];
            long[] lArray8 = new long[(int)(l * (long)n2)];
            double[] dArray4 = new double[(int)(l * (long)n2)];
            int n40 = 0;
            long l13 = 0L;
            int n41 = 0;
            int n42 = n5;
            for (int i = n41; i < n42; ++i) {
                long l14 = 0L;
                while (l14 < l && l14 < l) {
                    long l15;
                    int n43 = nArray2[(int)lArray5[(int)l14]];
                    long l16 = l14;
                    for (l15 = l14; l15 < l && nArray2[(int)lArray5[(int)l15]] == nArray2[(int)lArray5[(int)l14]]; ++l15) {
                    }
                    long l17 = l16;
                    long l18 = l15;
                    for (long j = l17; j < l18; ++j) {
                        lArray8[(int)l13] = (long)i * (long)n + (long)nArray[(int)lArray5[(int)j]];
                        dArray4[(int)l13] = dArray[(int)lArray5[(int)j]];
                        ++l13;
                    }
                    lArray6[n40 + 1] = l13;
                    lArray7[n40] = (long)i * (long)n6 + (long)n43;
                    ++n40;
                    l14 = l15;
                }
            }
            return new Expr(lArray6, new Variable[]{variable}, lArray8, dArray4, null, set, lArray7);
        }
        return new Expr(new long[]{0L}, new Variable[]{variable}, new long[0], new double[0], null, set, new long[0]);
    }

    public static Expression mul(Matrix matrix, Variable variable) {
        Expr expr;
        int n;
        int n2;
        if (variable == null || matrix == null) {
            throw new NullPointerException("Arguments for mul may not be null");
        }
        Set set = variable.shape();
        int n3 = matrix.numRows();
        int n4 = matrix.numColumns();
        if (set.nd == 1) {
            n2 = set.dim(0);
            n = 1;
        } else if (set.nd == 2) {
            n2 = set.dim(0);
            n = set.dim(1);
        } else {
            throw new LengthError("Operand shapes do not match.");
        }
        int n5 = n3;
        int n6 = n;
        Set set2 = null;
        set2 = variable.shape().nd == 1 && variable.shape().dim(0) == 1 ? new NDSet(n3, n4) : (variable.shape().nd == 1 ? new IntSet(n5) : new NDSet(n5, n6));
        if (set.nd == 1 && set.dim(0) == 1) {
            if (matrix.isSparse()) {
                int[] nArray = new int[(int)matrix.numNonzeros()];
                int[] nArray2 = new int[(int)matrix.numNonzeros()];
                double[] dArray = new double[(int)matrix.numNonzeros()];
                matrix.getDataAsTriplets(nArray, nArray2, dArray);
                int n7 = 0;
                int n8 = 0;
                int n9 = nArray2.length;
                int n10 = n8 < n9 ? n9 - n8 : 0;
                long[] lArray = new long[n10];
                int n11 = n8;
                int n12 = 0;
                while (n12 < n10) {
                    lArray[n7] = (long)nArray[n11] * (long)n4 + (long)nArray2[n11];
                    ++n7;
                    ++n12;
                    ++n11;
                }
                long[] lArray2 = lArray;
                expr = new Expr(Tools.range(0L, matrix.numNonzeros() + 1L), new Variable[]{variable}, Tools.makevector(0L, (int)matrix.numNonzeros()), dArray, null, set2, lArray2);
            } else {
                int n13 = 0;
                int n14 = 0;
                long l = matrix.numNonzeros();
                long l2 = (long)n14 < l ? l - (long)n14 : 0L;
                long[] lArray = new long[(int)l2];
                long l3 = n14;
                int n15 = 0;
                while ((long)n15 < l2) {
                    lArray[n13] = 0L;
                    ++n13;
                    ++n15;
                    ++l3;
                }
                expr = new Expr(Tools.range(0L, matrix.numNonzeros() + 1L), new Variable[]{variable}, lArray, matrix.getDataAsArray(), null, set2, null);
            }
        } else if (n4 == n2) {
            if (matrix.isSparse()) {
                if (matrix.numNonzeros() > 0L) {
                    int[] nArray = new int[(int)matrix.numNonzeros()];
                    int[] nArray3 = new int[(int)matrix.numNonzeros()];
                    double[] dArray = new double[(int)matrix.numNonzeros()];
                    int n16 = dArray.length;
                    matrix.getDataAsTriplets(nArray, nArray3, dArray);
                    int n17 = dArray.length * n;
                    int n18 = 0;
                    int n19 = 0;
                    while (n19 < n16 && n19 < n16) {
                        int n20;
                        int n21 = nArray[n19];
                        for (n20 = n19 + 1; n20 < n16 && n21 == nArray[n20]; ++n20) {
                        }
                        ++n18;
                        n19 = n20;
                    }
                    n19 = n18 * n;
                    long[] lArray = new long[n19 + 1];
                    long[] lArray3 = new long[n19];
                    long[] lArray4 = new long[n17];
                    double[] dArray2 = new double[n17];
                    if (n18 > 0) {
                        int n22 = 0;
                        int n23 = 0;
                        int n24 = 0;
                        while (n24 < n16 && n24 < n16) {
                            int n25;
                            int n26 = nArray[n24];
                            for (n25 = n24 + 1; n25 < n16 && n26 == nArray[n25]; ++n25) {
                            }
                            int n27 = 0;
                            int n28 = n;
                            for (int i = n27; i < n28; ++i) {
                                lArray[n22 + 1] = lArray[n22] + (long)(n25 - n24);
                                lArray3[n22] = (long)n26 * (long)n + (long)i;
                                int n29 = n24;
                                int n30 = n25;
                                for (int j = n29; j < n30; ++j) {
                                    lArray4[n23] = (long)nArray3[j] * (long)n + (long)i;
                                    dArray2[n23] = dArray[j];
                                    ++n23;
                                }
                                ++n22;
                            }
                            n24 = n25;
                        }
                    }
                    if (lArray3.length == n5 * n6) {
                        lArray3 = null;
                    }
                    expr = new Expr(lArray, new Variable[]{variable}, lArray4, dArray2, null, set2, lArray3);
                } else {
                    expr = new Expr(new long[]{0L}, new Variable[]{variable}, new long[0], new double[0], null, set2, new long[0]);
                }
            } else {
                int n31 = n3 * n4 * n;
                double[] dArray = matrix.getDataAsArray();
                long[] lArray = Tools.range(0L, (long)(n31 + 1), (long)(n4 > 0 ? n4 : 1));
                long[] lArray5 = new long[n31];
                double[] dArray3 = new double[n31];
                int n32 = 0;
                int n33 = 0;
                int n34 = n5;
                for (int i = n33; i < n34; ++i) {
                    int n35 = 0;
                    int n36 = n6;
                    for (int j = n35; j < n36; ++j) {
                        int n37 = 0;
                        int n38 = n4;
                        for (int k = n37; k < n38; ++k) {
                            lArray5[n32] = k * n + j;
                            dArray3[n32] = dArray[i * n4 + k];
                            ++n32;
                        }
                    }
                }
                expr = new Expr(lArray, new Variable[]{variable}, lArray5, dArray3, null, set2, null);
            }
        } else {
            throw new LengthError("Operand shapes do not match.");
        }
        return expr;
    }

    private static Expression dot_(Matrix matrix, Expression expression) {
        if (matrix.numRows() != expression.shape().dim(0) || matrix.numColumns() != expression.shape().dim(1) || (long)(matrix.numRows() * matrix.numColumns()) != expression.shape().getSize()) {
            throw new DimensionError("Dimensions of operands do not match");
        }
        long l = matrix.numNonzeros();
        int[] nArray = new int[(int)l];
        int[] nArray2 = new int[(int)l];
        double[] dArray = new double[(int)l];
        matrix.getDataAsTriplets(nArray, nArray2, dArray);
        int n = 0;
        int n2 = 0;
        long l2 = l;
        long l3 = (long)n2 < l2 ? l2 - (long)n2 : 0L;
        long[] lArray = new long[(int)l3];
        long l4 = n2;
        int n3 = 0;
        while ((long)n3 < l3) {
            lArray[n] = nArray[(int)l4] * matrix.numColumns() + nArray2[(int)l4];
            ++n;
            ++n3;
            ++l4;
        }
        long[] lArray2 = lArray;
        FlatExpr flatExpr = expression.eval();
        return Expr.inner_(lArray2, dArray, flatExpr.ptrb, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.inst, flatExpr.x);
    }

    private static Expression dot_(Matrix matrix, Variable variable) {
        if (matrix.numRows() != variable.shape().dim(0) || matrix.numColumns() != variable.shape().dim(1) || (long)(matrix.numRows() * matrix.numColumns()) != variable.shape().getSize()) {
            throw new DimensionError("Dimensions of operands do not match");
        }
        long l = matrix.numNonzeros();
        int[] nArray = new int[(int)l];
        int[] nArray2 = new int[(int)l];
        double[] dArray = new double[(int)l];
        matrix.getDataAsTriplets(nArray, nArray2, dArray);
        int n = 0;
        int n2 = 0;
        long l2 = l;
        long l3 = (long)n2 < l2 ? l2 - (long)n2 : 0L;
        long[] lArray = new long[(int)l3];
        long l4 = n2;
        int n3 = 0;
        while ((long)n3 < l3) {
            lArray[n] = nArray[(int)l4] * matrix.numColumns() + nArray2[(int)l4];
            ++n;
            ++n3;
            ++l4;
        }
        long[] lArray2 = lArray;
        return Expr.inner_(lArray2, dArray, variable);
    }

    private static Expression dot_(double[] dArray, Variable variable) {
        if (variable == null || dArray == null) {
            throw new NullPointerException("Arguments for dot may not be null");
        }
        if (variable.shape().dim(0) != dArray.length || variable.shape().size != (long)dArray.length) {
            throw new DimensionError("Dimensions of operands do not match");
        }
        return Expr.inner_(Tools.range(0L, (long)dArray.length), dArray, variable);
    }

    private static Expression dot_(double[] dArray, Expression expression) {
        if (dArray == null || expression == null) {
            throw new NullPointerException("Arguments for dot may not be null");
        }
        if (expression.shape().dim(0) != dArray.length || expression.shape().size != (long)dArray.length) {
            throw new DimensionError("Dimensions of operands do not match");
        }
        FlatExpr flatExpr = expression.eval();
        return Expr.inner_(Tools.range(0L, (long)dArray.length), dArray, flatExpr.ptrb, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.inst, flatExpr.x);
    }

    private static Expression dot_(NDSparseArray nDSparseArray, Expression expression) {
        int n;
        if (nDSparseArray == null || expression == null) {
            throw new NullPointerException("Arguments for dot may not be null");
        }
        int n2 = 0;
        int n3 = nDSparseArray.dims.length;
        for (n = n2; n < n3; ++n) {
            if (nDSparseArray.dims[n] == expression.shape().dim(n)) continue;
            throw new DimensionError("Dimensions of operands do not match");
        }
        n2 = nDSparseArray.dims.length;
        n3 = expression.shape().nd;
        for (n = n2; n < n3; ++n) {
            if (1 == expression.shape().dim(n)) continue;
            throw new DimensionError("Dimensions of operands do not match");
        }
        n2 = 0;
        n3 = nDSparseArray.dims.length;
        for (n = n2; n < n3; ++n) {
            if (nDSparseArray.dims[n] == expression.shape().dim(n)) continue;
            throw new LengthError("Dimension mismatch");
        }
        FlatExpr flatExpr = expression.eval();
        return Expr.inner_(nDSparseArray.inst, nDSparseArray.cof, flatExpr.ptrb, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.inst, flatExpr.x);
    }

    private static Expression dot_(NDSparseArray nDSparseArray, Variable variable) {
        if (variable.shape().nd != nDSparseArray.dims.length) {
            throw new LengthError("Dimension mismatch");
        }
        int n = 0;
        int n2 = nDSparseArray.dims.length;
        for (int i = n; i < n2; ++i) {
            if (nDSparseArray.dims[i] == variable.shape().dim(i)) continue;
            throw new LengthError("Dimension mismatch");
        }
        return Expr.inner_(nDSparseArray.inst, nDSparseArray.cof, variable);
    }

    private static Expression inner_(long[] lArray, double[] dArray, Variable variable) {
        int n = lArray.length;
        long[] lArray2 = new long[]{0L, dArray.length};
        long[] lArray3 = Tools.arraycopy(lArray);
        double[] dArray2 = Tools.arraycopy(dArray);
        double[] dArray3 = null;
        return new Expr(lArray2, new Variable[]{variable}, lArray3, dArray2, dArray3, Set.scalar(), null);
    }

    private static Expression inner_(long[] lArray, double[] dArray, long[] lArray2, long[] lArray3, double[] dArray2, double[] dArray3, long[] lArray4, Variable[] variableArray) {
        int n = lArray.length;
        long[] lArray5 = lArray4 != null ? lArray4 : Tools.range(0L, (long)lArray2.length - 1L);
        int n2 = lArray5.length;
        long l = 0L;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n && n4 < n2) {
            if (lArray[n3] < lArray5[n4]) {
                ++n3;
                continue;
            }
            if (lArray[n3] > lArray5[n4]) {
                ++n4;
                continue;
            }
            l += lArray2[n4 + 1] - lArray2[n4];
            ++n3;
            ++n4;
        }
        long[] lArray6 = new long[(int)l];
        double[] dArray4 = new double[(int)l];
        double[] dArray5 = new double[1];
        long[] lArray7 = new long[]{0L, l};
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n5 < n && n6 < n2) {
            if (lArray[n5] < lArray5[n6]) {
                ++n5;
                continue;
            }
            if (lArray[n5] > lArray5[n6]) {
                ++n6;
                continue;
            }
            long l2 = lArray2[n6];
            long l3 = lArray2[n6 + 1];
            for (long i = l2; i < l3; ++i) {
                lArray6[n7] = lArray3[(int)i];
                dArray4[n7] = dArray2[(int)i] * dArray[n5];
                ++n7;
            }
            ++n5;
            ++n6;
        }
        if (dArray3 != null) {
            n5 = 0;
            n6 = 0;
            while (n5 < n && n6 < n2) {
                if (lArray[n5] < lArray5[n6]) {
                    ++n5;
                    continue;
                }
                if (lArray[n5] > lArray5[n6]) {
                    ++n6;
                    continue;
                }
                dArray5[0] = dArray5[0] + dArray[n5] * dArray3[n6];
                ++n5;
                ++n6;
            }
        }
        return new Expr(lArray7, variableArray, lArray6, dArray4, dArray5, Set.scalar(), null);
    }

    public static Expression outer(double[] dArray, Expression expression) {
        if (expression.shape().nd != 1 || expression.shape().nd != 1) {
            throw new DimensionError("Arguments must be one-dimensional");
        }
        if (expression.shape().dim(0) != dArray.length) {
            throw new DimensionError("Argument lengths do not match");
        }
        FlatExpr flatExpr = expression.eval();
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray = new int[n4];
        int n5 = n2;
        for (int i = 0; i < n4; ++i) {
            nArray[n] = n5++;
            ++n;
        }
        return Expr.outer_(flatExpr.shape.dim(0), flatExpr.ptrb, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.inst, flatExpr.x, dArray, nArray, dArray.length, true);
    }

    public static Expression outer(Expression expression, double[] dArray) {
        if (expression.shape().nd != 1 || expression.shape().nd != 1) {
            throw new DimensionError("Arguments must be one-dimensional");
        }
        FlatExpr flatExpr = expression.eval();
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray = new int[n4];
        int n5 = n2;
        for (int i = 0; i < n4; ++i) {
            nArray[n] = n5++;
            ++n;
        }
        return Expr.outer_(flatExpr.shape.dim(0), flatExpr.ptrb, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.inst, flatExpr.x, dArray, nArray, dArray.length, false);
    }

    public static Expression outer(Matrix matrix, Variable variable) {
        if (variable.shape().nd != 1 && (variable.shape().nd != 2 || variable.shape().dim(1) != 1)) {
            throw new DimensionError("Variable argument must be one-dimensional");
        }
        if (matrix.dimj != 1) {
            throw new DimensionError("Constant matrix must be a column-vector");
        }
        Matrix matrix2 = matrix;
        if (matrix2 instanceof DenseMatrix) {
            DenseMatrix denseMatrix = (DenseMatrix)matrix2;
            return Expr.outer_(variable, variable.shape().dim(0), denseMatrix.data, null, denseMatrix.data.length, true);
        }
        Matrix matrix3 = matrix2;
        int[] nArray = new int[(int)matrix3.numNonzeros()];
        int[] nArray2 = new int[(int)matrix3.numNonzeros()];
        double[] dArray = new double[(int)matrix3.numNonzeros()];
        matrix3.getDataAsTriplets(nArray, nArray2, dArray);
        return Expr.outer_(variable, variable.shape().dim(0), dArray, nArray, matrix3.dimi, true);
    }

    public static Expression outer(Variable variable, Matrix matrix) {
        if (variable.shape().nd != 1 && (variable.shape().nd != 2 || variable.shape().dim(1) != 1)) {
            throw new DimensionError("Variable argument must be one-dimensional");
        }
        if (matrix.dimj != 1) {
            throw new DimensionError("Constant matrix must be a column-vector");
        }
        Matrix matrix2 = matrix;
        if (matrix2 instanceof DenseMatrix) {
            DenseMatrix denseMatrix = (DenseMatrix)matrix2;
            return Expr.outer_(variable, variable.shape().dim(0), denseMatrix.data, null, denseMatrix.data.length, false);
        }
        Matrix matrix3 = matrix2;
        int[] nArray = new int[(int)matrix.numNonzeros()];
        int[] nArray2 = new int[(int)matrix3.numNonzeros()];
        double[] dArray = new double[(int)matrix3.numNonzeros()];
        matrix3.getDataAsTriplets(nArray, nArray2, dArray);
        return Expr.outer_(variable, variable.shape().dim(0), dArray, nArray, matrix3.dimi, false);
    }

    public static Expression outer(double[] dArray, Variable variable) {
        if (variable.shape().nd != 1 && (variable.shape().nd != 2 || variable.shape().dim(1) != 1)) {
            throw new DimensionError("Variable argument must be one-dimensional");
        }
        return Expr.outer_(variable, variable.shape().dim(0), dArray, null, dArray.length, true);
    }

    public static Expression outer(Variable variable, double[] dArray) {
        if (variable.shape().nd != 1 && (variable.shape().nd != 2 || variable.shape().dim(1) != 1)) {
            throw new DimensionError("Variable argument must be one-dimensional");
        }
        return Expr.outer_(variable, variable.shape().dim(0), dArray, null, dArray.length, false);
    }

    private static Expression outer_(int n, long[] lArray, long[] lArray2, double[] dArray, double[] dArray2, long[] lArray3, Variable[] variableArray, double[] dArray3, int[] nArray, int n2, boolean bl) {
        long[] lArray4;
        double[] dArray4;
        double[] dArray5;
        long[] lArray5;
        long[] lArray6;
        Set set;
        block12: {
            int n3;
            int n4;
            int n5;
            int n6;
            block11: {
                int n7;
                int n8;
                int n9;
                set = !bl ? Set.make(n, n2) : Set.make(n2, n);
                int n10 = dArray3.length * lArray3.length;
                int n11 = dArray3.length * lArray2.length;
                lArray6 = new long[n10 + 1];
                lArray5 = new long[n11];
                dArray5 = new double[n11];
                dArray4 = dArray2 != null ? new double[n10] : null;
                lArray4 = new long[n10];
                n6 = (int)lArray6[lArray6.length - 1];
                if (bl) break block11;
                long l = 0L;
                long l2 = 0L;
                int n12 = 0;
                int n13 = lArray3.length;
                for (n9 = n12; n9 < n13; ++n9) {
                    long l3 = lArray[n9 + 1] - lArray[n9];
                    n8 = 0;
                    n7 = dArray3.length;
                    for (int i = n8; i < n7; ++i) {
                        lArray3[(int)l] = lArray3[n9] * (long)n2 + (long)nArray[i];
                        lArray6[(int)(l + 1L)] = lArray6[(int)l] + l3;
                        ++l;
                        long l4 = lArray[n9];
                        long l5 = lArray[n9 + 1];
                        for (long j = l4; j < l5; ++j) {
                            lArray5[(int)l2] = lArray2[(int)j];
                            dArray5[(int)l2] = dArray[(int)j] * dArray3[i];
                            ++l2;
                        }
                    }
                }
                if (dArray4 == null) break block12;
                n12 = 0;
                n13 = 0;
                n9 = lArray3.length;
                for (int i = n13; i < n9; ++i) {
                    int n14 = 0;
                    n8 = dArray3.length;
                    for (n7 = n14; n7 < n8; ++n7) {
                        dArray4[n12] = dArray3[n7] * dArray2[i];
                        ++n12;
                    }
                }
                break block12;
            }
            long l = 0L;
            long l6 = 0L;
            int n15 = 0;
            int n16 = dArray3.length;
            for (n5 = n15; n5 < n16; ++n5) {
                double d = dArray3[n5];
                Tools.arraycopy(lArray2, 0L, lArray5, l6, (long)n6);
                int n17 = 0;
                n4 = n6;
                for (n3 = n17; n3 < n4; ++n3) {
                    dArray5[(int)(l6 + (long)n3)] = dArray[n3] * dArray3[n5];
                }
                n17 = 0;
                n4 = lArray3.length;
                for (n3 = n17; n3 < n4; ++n3) {
                    long l7 = lArray[n3 + 1] - lArray[n3];
                    lArray3[(int)l] = lArray3[n3] * (long)n2 + (long)nArray[n5];
                    lArray6[(int)(l + 1L)] = lArray6[(int)l] + l7;
                    ++l;
                }
                l6 += (long)n6;
            }
            if (dArray4 != null) {
                n15 = 0;
                n16 = 0;
                n5 = dArray3.length;
                for (int i = n16; i < n5; ++i) {
                    double d = dArray3[i];
                    n4 = 0;
                    n3 = lArray3.length;
                    for (int j = n4; j < n3; ++j) {
                        dArray4[n15] = dArray2[j] * d;
                        ++n15;
                    }
                }
            }
        }
        return new Expr(lArray6, variableArray, lArray5, dArray5, dArray4, set, lArray4);
    }

    private static Expression outer_(Variable variable, int n, double[] dArray, int[] nArray, int n2, boolean bl) {
        long[] lArray;
        Set set = !bl ? Set.make(n, n2) : Set.make(n2, n);
        long[] lArray2 = new long[dArray.length * n + 1];
        long[] lArray3 = new long[dArray.length * n];
        double[] dArray2 = new double[dArray.length * n];
        double[] dArray3 = null;
        long[] lArray4 = lArray = n2 == dArray.length ? null : new long[dArray.length * n];
        if (n2 == dArray.length) {
            long l = 0L;
            if (!bl) {
                int n3 = 0;
                int n4 = n;
                for (int i = n3; i < n4; ++i) {
                    int n5 = 0;
                    int n6 = n2;
                    for (int j = n5; j < n6; ++j) {
                        lArray2[(int)(l + 1L)] = l + 1L;
                        lArray3[(int)l] = i;
                        dArray2[(int)l] = dArray[j];
                        ++l;
                    }
                }
            } else {
                int n7 = 0;
                int n8 = n2;
                for (int i = n7; i < n8; ++i) {
                    int n9 = 0;
                    int n10 = n;
                    for (int j = n9; j < n10; ++j) {
                        lArray2[(int)(l + 1L)] = l + 1L;
                        lArray3[(int)l] = j;
                        dArray2[(int)l] = dArray[i];
                        ++l;
                    }
                }
            }
        } else {
            long l = 0L;
            if (!bl) {
                int n11 = 0;
                int n12 = n;
                for (int i = n11; i < n12; ++i) {
                    int n13 = 0;
                    int n14 = dArray.length;
                    for (int j = n13; j < n14; ++j) {
                        lArray2[(int)(l + 1L)] = l + 1L;
                        lArray3[(int)l] = i;
                        dArray2[(int)l] = dArray[j];
                        lArray[(int)l] = i * n2 + nArray[j];
                        ++l;
                    }
                }
            } else {
                int n15 = 0;
                int n16 = dArray.length;
                for (int i = n15; i < n16; ++i) {
                    int n17 = 0;
                    int n18 = n;
                    for (int j = n17; j < n18; ++j) {
                        lArray2[(int)(l + 1L)] = l + 1L;
                        lArray3[(int)l] = j;
                        dArray2[(int)l] = dArray[i];
                        lArray[(int)l] = nArray[i] * n + j;
                        ++l;
                    }
                }
            }
        }
        return new Expr(lArray2, new Variable[]{variable}, lArray3, dArray2, dArray3, set, lArray);
    }

    @Override
    public Expression pick(int[][] nArray) {
        int n;
        int n2;
        int n3;
        int[][] nArray2 = nArray;
        if (this.shape_p.nd != nArray2[0].length) {
            throw new DimensionError("Invalid index size");
        }
        int n4 = 0;
        int n5 = nArray2.length;
        for (n3 = n4; n3 < n5; ++n3) {
            n2 = 0;
            int n6 = nArray2[0].length;
            for (n = n2; n < n6; ++n) {
                if (nArray2[n3][n] >= 0 && nArray2[n3][n] < this.shape_p.dim(n)) continue;
                throw new IndexError("Index is out of bounds");
            }
        }
        n4 = 0;
        n5 = 0;
        n3 = nArray2.length;
        n2 = n5 < n3 ? n3 - n5 : 0;
        long[] lArray = new long[n2];
        n = n5;
        int n7 = 0;
        while (n7 < n2) {
            int n8 = 0;
            int n9 = 0;
            int n10 = nArray2[0].length;
            int n11 = n9 < n10 ? n10 - n9 : 0;
            int[] nArray3 = new int[n11];
            int n12 = n9;
            int n13 = 0;
            while (n13 < n11) {
                nArray3[n8] = nArray2[n][n12];
                ++n8;
                ++n13;
                ++n12;
            }
            lArray[n4] = this.shape_p.linearidx(nArray3);
            ++n4;
            ++n7;
            ++n;
        }
        return this.pick_(lArray);
    }

    @Override
    public Expression pick(int[] nArray) {
        int n;
        if (this.shape_p.nd != 1) {
            throw new DimensionError("Method is only valid for one-dimensional expressions");
        }
        int n2 = 0;
        int n3 = nArray.length;
        for (n = n2; n < n3; ++n) {
            if (nArray[n] >= 0 && nArray[n] < this.shape_p.dim(0)) continue;
            throw new IndexError("Index is out of bounds");
        }
        n2 = 0;
        n3 = 0;
        n = nArray.length;
        int n4 = n3 < n ? n - n3 : 0;
        long[] lArray = new long[n4];
        int n5 = n3;
        int n6 = 0;
        while (n6 < n4) {
            lArray[n2] = nArray[n5];
            ++n2;
            ++n6;
            ++n5;
        }
        return this.pick_(lArray);
    }

    private Expression pick_(long[] lArray) {
        if (lArray.length == 0) {
            return new Expr(new long[]{0L}, this.x, new long[0], new double[0], null, Set.make(0), null);
        }
        if (this.inst == null) {
            int n;
            long l = 0L;
            long[] lArray2 = new long[lArray.length + 1];
            int n2 = 0;
            int n3 = lArray.length;
            for (int i = n2; i < n3; ++i) {
                l += this.ptrb[(int)(lArray[i] + 1L)] - this.ptrb[(int)lArray[i]];
                lArray2[i + 1] = lArray2[i] + (this.ptrb[(int)(lArray[i] + 1L)] - this.ptrb[(int)lArray[i]]);
            }
            long[] lArray3 = new long[(int)l];
            double[] dArray = new double[(int)l];
            double[] dArray2 = null;
            int n4 = 0;
            int n5 = lArray.length;
            for (n = n4; n < n5; ++n) {
                long l2 = lArray2[n];
                long l3 = lArray2[n + 1] - l2;
                Tools.arraycopy(this.subj, this.ptrb[(int)lArray[n]], lArray3, l2, l3);
                Tools.arraycopy(this.cof_v, this.ptrb[(int)lArray[n]], dArray, l2, l3);
            }
            if (this.bfix != null) {
                n4 = 0;
                n5 = 0;
                n = lArray.length;
                int n6 = n5 < n ? n - n5 : 0;
                double[] dArray3 = new double[n6];
                int n7 = n5;
                int n8 = 0;
                while (n8 < n6) {
                    dArray3[n4] = this.bfix[(int)lArray[n7]];
                    ++n4;
                    ++n8;
                    ++n7;
                }
                dArray2 = dArray3;
            }
            long[] lArray4 = null;
            Set set = Set.make(lArray.length);
            return new Expr(lArray2, this.x, lArray3, dArray, dArray2, set, lArray4);
        }
        int n = 0;
        int n9 = 0;
        int n10 = lArray.length;
        int n11 = n9 < n10 ? n10 - n9 : 0;
        long[] lArray5 = new long[n11];
        int n12 = n9;
        int n13 = 0;
        while (n13 < n11) {
            lArray5[n] = n12;
            ++n;
            ++n13;
            ++n12;
        }
        long[] lArray6 = lArray5;
        Sort.argsort(lArray6, lArray);
        int n14 = 0;
        long l = 0L;
        int n15 = 0;
        int n16 = 0;
        int n17 = lArray.length;
        int n18 = this.inst.length;
        while (n15 < n17 && n16 < n18) {
            if (lArray[(int)lArray6[n15]] < this.inst[n16]) {
                ++n15;
                continue;
            }
            if (lArray[(int)lArray6[n15]] > this.inst[n16]) {
                ++n16;
                continue;
            }
            ++n14;
            l += this.ptrb[n16 + 1] - this.ptrb[n16];
        }
        long[] lArray7 = new long[n14];
        long[] lArray8 = new long[n14 + 1];
        long[] lArray9 = new long[(int)l];
        double[] dArray = new double[(int)l];
        double[] dArray4 = null;
        Set set = Set.make(lArray.length);
        int n19 = 0;
        int n20 = 0;
        int n21 = lArray.length;
        int n22 = n20 < n21 ? n21 - n20 : 0;
        int[] nArray = new int[n22];
        int n23 = n20;
        int n24 = 0;
        while (n24 < n22) {
            nArray[n19] = -1;
            ++n19;
            ++n24;
            ++n23;
        }
        int[] nArray2 = nArray;
        int n25 = 0;
        int n26 = 0;
        int n27 = lArray.length;
        int n28 = this.inst.length;
        while (n25 < n27 && n26 < n28) {
            if (lArray[(int)lArray6[n25]] < this.inst[n26]) {
                ++n25;
                continue;
            }
            if (lArray[(int)lArray6[n25]] > this.inst[n26]) {
                ++n26;
                continue;
            }
            nArray2[(int)lArray6[n25]] = n26;
        }
        n25 = 0;
        n26 = 0;
        n27 = nArray2.length;
        for (n28 = n26; n28 < n27; ++n28) {
            if (nArray2[n25] < 0) continue;
            long l4 = this.ptrb[nArray2[n25] + 1] - this.ptrb[nArray2[n28]];
            int n29 = n25 + 1;
            lArray8[n29] = lArray8[n29] + (lArray8[n25] + l4);
            lArray7[n25] = n28;
            Tools.arraycopy(this.subj, this.ptrb[nArray2[n28]], lArray9, lArray8[n25], l4);
            Tools.arraycopy(this.cof_v, this.ptrb[nArray2[n28]], dArray, lArray8[n25], l4);
            ++n25;
        }
        if (this.bfix != null) {
            dArray4 = new double[n14];
            n25 = 0;
            n26 = 0;
            n27 = nArray2.length;
            for (n28 = n26; n28 < n27; ++n28) {
                if (nArray2[n25] < 0) continue;
                dArray4[n25] = this.bfix[nArray2[n28]];
                ++n25;
            }
        }
        return new Expr(lArray8, this.x, lArray9, dArray, dArray4, set, lArray7);
    }

    public static Expression stack(Expression[][] expressionArray) {
        int n;
        int n2;
        int n3;
        if (expressionArray == null) {
            throw new NullPointerException("Argument exprs may not be null");
        }
        int n4 = 0;
        int n5 = expressionArray.length;
        for (n3 = n4; n3 < n5; ++n3) {
            Expression[] expressionArray2 = expressionArray[n3];
            if (expressionArray2 == null) {
                throw new NullPointerException("Arguments for stack may not be null");
            }
            int n6 = 0;
            n2 = expressionArray2.length;
            for (n = n6; n < n2; ++n) {
                if (expressionArray2[n] != null) continue;
                throw new NullPointerException("Arguments for stack may not be null");
            }
        }
        n4 = 0;
        n5 = 0;
        n3 = expressionArray.length;
        int n7 = n5 < n3 ? n3 - n5 : 0;
        Expression[] expressionArray3 = new Expression[n7];
        n2 = n5;
        n = 0;
        while (n < n7) {
            expressionArray3[n4] = Expr.stack_(expressionArray[n2], 1);
            ++n4;
            ++n;
            ++n2;
        }
        Expression[] expressionArray4 = expressionArray3;
        return Expr.stack_(expressionArray4, 0);
    }

    public static Expression vstack(double d, double d2, double d3) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), Expr.constTerm(d2), Expr.constTerm(d3)}, 0);
    }

    public static Expression vstack(double d, double d2, Variable variable) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), Expr.constTerm(d2), variable.asExpr()}, 0);
    }

    public static Expression vstack(double d, double d2, Expression expression) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), Expr.constTerm(d2), expression}, 0);
    }

    public static Expression vstack(double d, Variable variable, double d2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), variable.asExpr(), Expr.constTerm(d2)}, 0);
    }

    public static Expression vstack(double d, Variable variable, Variable variable2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), variable.asExpr(), variable2.asExpr()}, 0);
    }

    public static Expression vstack(double d, Variable variable, Expression expression) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), variable.asExpr(), expression}, 0);
    }

    public static Expression vstack(double d, Expression expression, double d2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression, Expr.constTerm(d2)}, 0);
    }

    public static Expression vstack(double d, Expression expression, Variable variable) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression, variable.asExpr()}, 0);
    }

    public static Expression vstack(double d, Expression expression, Expression expression2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression, expression2}, 0);
    }

    public static Expression vstack(Variable variable, double d, double d2) {
        return Expr.stack_(new Expression[]{variable.asExpr(), Expr.constTerm(d), Expr.constTerm(d2)}, 0);
    }

    public static Expression vstack(Variable variable, double d, Variable variable2) {
        return Expr.stack_(new Expression[]{variable.asExpr(), Expr.constTerm(d), variable2.asExpr()}, 0);
    }

    public static Expression vstack(Variable variable, double d, Expression expression) {
        return Expr.stack_(new Expression[]{variable.asExpr(), Expr.constTerm(d), expression}, 0);
    }

    public static Expression vstack(Variable variable, Variable variable2, double d) {
        return Expr.stack_(new Expression[]{variable.asExpr(), variable2.asExpr(), Expr.constTerm(d)}, 0);
    }

    public static Expression vstack(Variable variable, Variable variable2, Variable variable3) {
        return Expr.stack_(new Expression[]{variable.asExpr(), variable2.asExpr(), variable3.asExpr()}, 0);
    }

    public static Expression vstack(Variable variable, Variable variable2, Expression expression) {
        return Expr.stack_(new Expression[]{variable.asExpr(), variable2.asExpr(), expression}, 0);
    }

    public static Expression vstack(Variable variable, Expression expression, double d) {
        return Expr.stack_(new Expression[]{variable.asExpr(), expression, Expr.constTerm(d)}, 0);
    }

    public static Expression vstack(Variable variable, Expression expression, Variable variable2) {
        return Expr.stack_(new Expression[]{variable.asExpr(), expression, variable2.asExpr()}, 0);
    }

    public static Expression vstack(Variable variable, Expression expression, Expression expression2) {
        return Expr.stack_(new Expression[]{variable.asExpr(), expression, expression2}, 0);
    }

    public static Expression vstack(Expression expression, double d, double d2) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d), Expr.constTerm(d2)}, 0);
    }

    public static Expression vstack(Expression expression, double d, Variable variable) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d), variable.asExpr()}, 0);
    }

    public static Expression vstack(Expression expression, double d, Expression expression2) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d), expression2}, 0);
    }

    public static Expression vstack(Expression expression, Variable variable, double d) {
        return Expr.stack_(new Expression[]{expression, variable.asExpr(), Expr.constTerm(d)}, 0);
    }

    public static Expression vstack(Expression expression, Variable variable, Variable variable2) {
        return Expr.stack_(new Expression[]{expression, variable.asExpr(), variable2.asExpr()}, 0);
    }

    public static Expression vstack(Expression expression, Variable variable, Expression expression2) {
        return Expr.stack_(new Expression[]{expression, variable.asExpr(), expression2}, 0);
    }

    public static Expression vstack(Expression expression, Expression expression2, double d) {
        return Expr.stack_(new Expression[]{expression, expression2, Expr.constTerm(d)}, 0);
    }

    public static Expression vstack(Expression expression, Expression expression2, Variable variable) {
        return Expr.stack_(new Expression[]{expression, expression2, variable.asExpr()}, 0);
    }

    public static Expression vstack(Expression expression, Expression expression2, Expression expression3) {
        return Expr.stack_(new Expression[]{expression, expression2, expression3}, 0);
    }

    public static Expression vstack(double d, Variable variable) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), variable.asExpr()}, 0);
    }

    public static Expression vstack(double d, Expression expression) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression}, 0);
    }

    public static Expression vstack(Variable variable, double d) {
        return Expr.stack_(new Expression[]{variable.asExpr(), Expr.constTerm(d)}, 0);
    }

    public static Expression vstack(Variable variable, Variable variable2) {
        return Expr.stack_(new Expression[]{variable.asExpr(), variable2.asExpr()}, 0);
    }

    public static Expression vstack(Variable variable, Expression expression) {
        return Expr.stack_(new Expression[]{variable.asExpr(), expression}, 0);
    }

    public static Expression vstack(Expression expression, double d) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d)}, 0);
    }

    public static Expression vstack(Expression expression, Variable variable) {
        return Expr.stack_(new Expression[]{expression, variable.asExpr()}, 0);
    }

    public static Expression vstack(Expression expression, Expression expression2) {
        return Expr.stack_(new Expression[]{expression, expression2}, 0);
    }

    public static Expression vstack(Expression[] expressionArray) {
        if (expressionArray == null) {
            throw new NullPointerException("Argument exprs may not be null");
        }
        int n = 0;
        int n2 = expressionArray.length;
        for (int i = n; i < n2; ++i) {
            if (expressionArray[i] != null) continue;
            throw new NullPointerException("Arguments for vstack may not be null");
        }
        return Expr.stack_(expressionArray, 0);
    }

    public static Expression hstack(Expression expression, Expression expression2, Expression expression3) {
        if (expression == null || expression2 == null || expression3 == null) {
            throw new NullPointerException("Arguments e1, e2 and e3 may not be null");
        }
        return Expr.stack_(new Expression[]{expression, expression2, expression3}, 1);
    }

    public static Expression hstack(Expression expression, Expression expression2, Variable variable) {
        return Expr.stack_(new Expression[]{expression, expression2, variable.asExpr()}, 1);
    }

    public static Expression hstack(Expression expression, Expression expression2, double d) {
        return Expr.stack_(new Expression[]{expression, expression2, Expr.constTerm(d)}, 1);
    }

    public static Expression hstack(Expression expression, Variable variable, Expression expression2) {
        return Expr.stack_(new Expression[]{expression, variable.asExpr(), expression2}, 1);
    }

    public static Expression hstack(Expression expression, Variable variable, Variable variable2) {
        return Expr.stack_(new Expression[]{expression, variable.asExpr(), variable2.asExpr()}, 1);
    }

    public static Expression hstack(Expression expression, Variable variable, double d) {
        return Expr.stack_(new Expression[]{expression, variable.asExpr(), Expr.constTerm(d)}, 1);
    }

    public static Expression hstack(Expression expression, double d, Expression expression2) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d), expression2}, 1);
    }

    public static Expression hstack(Expression expression, double d, Variable variable) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d), variable.asExpr()}, 1);
    }

    public static Expression hstack(Expression expression, double d, double d2) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d), Expr.constTerm(d2)}, 1);
    }

    public static Expression hstack(Variable variable, Expression expression, Expression expression2) {
        return Expr.stack_(new Expression[]{variable.asExpr(), expression, expression2}, 1);
    }

    public static Expression hstack(Variable variable, Expression expression, Variable variable2) {
        return Expr.stack_(new Expression[]{variable.asExpr(), expression, variable2.asExpr()}, 1);
    }

    public static Expression hstack(Variable variable, Expression expression, double d) {
        return Expr.stack_(new Expression[]{variable.asExpr(), expression, Expr.constTerm(d)}, 1);
    }

    public static Expression hstack(Variable variable, Variable variable2, Expression expression) {
        return Expr.stack_(new Expression[]{variable.asExpr(), variable2.asExpr(), expression}, 1);
    }

    public static Expression hstack(Variable variable, Variable variable2, Variable variable3) {
        return Expr.stack_(new Expression[]{variable.asExpr(), variable2.asExpr(), variable3.asExpr()}, 1);
    }

    public static Expression hstack(Variable variable, Variable variable2, double d) {
        return Expr.stack_(new Expression[]{variable.asExpr(), variable2.asExpr(), Expr.constTerm(d)}, 1);
    }

    public static Expression hstack(Variable variable, double d, Expression expression) {
        return Expr.stack_(new Expression[]{variable.asExpr(), Expr.constTerm(d), expression}, 1);
    }

    public static Expression hstack(Variable variable, double d, Variable variable2) {
        return Expr.stack_(new Expression[]{variable.asExpr(), Expr.constTerm(d), variable2.asExpr()}, 1);
    }

    public static Expression hstack(Variable variable, double d, double d2) {
        return Expr.stack_(new Expression[]{variable.asExpr(), Expr.constTerm(d), Expr.constTerm(d2)}, 1);
    }

    public static Expression hstack(double d, Expression expression, Expression expression2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression, expression2}, 1);
    }

    public static Expression hstack(double d, Expression expression, Variable variable) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression, variable.asExpr()}, 1);
    }

    public static Expression hstack(double d, Expression expression, double d2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression, Expr.constTerm(d2)}, 1);
    }

    public static Expression hstack(double d, Variable variable, Expression expression) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), variable.asExpr(), expression}, 1);
    }

    public static Expression hstack(double d, Variable variable, Variable variable2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), variable.asExpr(), variable2.asExpr()}, 1);
    }

    public static Expression hstack(double d, Variable variable, double d2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), variable.asExpr(), Expr.constTerm(d2)}, 1);
    }

    public static Expression hstack(double d, double d2, Expression expression) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), Expr.constTerm(d2), expression}, 1);
    }

    public static Expression hstack(double d, double d2, Variable variable) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), Expr.constTerm(d2), variable.asExpr()}, 1);
    }

    public static Expression hstack(Variable variable, Expression expression) {
        return Expr.stack_(new Expression[]{variable.asExpr(), expression}, 1);
    }

    public static Expression hstack(Variable variable, Variable variable2) {
        return Expr.stack_(new Expression[]{variable.asExpr(), variable2.asExpr()}, 1);
    }

    public static Expression hstack(Variable variable, double d) {
        return Expr.stack_(new Expression[]{variable.asExpr(), Expr.constTerm(d)}, 1);
    }

    public static Expression hstack(double d, Expression expression) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression}, 1);
    }

    public static Expression hstack(double d, Variable variable) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), variable.asExpr()}, 1);
    }

    public static Expression hstack(Expression expression, Variable variable) {
        return Expr.stack_(new Expression[]{expression, variable.asExpr()}, 1);
    }

    public static Expression hstack(Expression expression, double d) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d)}, 1);
    }

    public static Expression hstack(Expression expression, Expression expression2) {
        return Expr.stack_(new Expression[]{expression, expression2}, 1);
    }

    public static Expression hstack(Expression[] expressionArray) {
        if (expressionArray == null) {
            throw new NullPointerException("Argument exprs may not be null");
        }
        int n = 0;
        int n2 = expressionArray.length;
        for (int i = n; i < n2; ++i) {
            if (expressionArray[i] != null) continue;
            throw new NullPointerException("Arguments for hstack may not be null");
        }
        return Expr.stack_(expressionArray, 1);
    }

    public static Expression stack(int n, Expression expression, Expression expression2, Expression expression3) {
        return Expr.stack_(new Expression[]{expression, expression2, expression3}, n);
    }

    public static Expression stack(int n, Expression expression, Expression expression2, Variable variable) {
        return Expr.stack_(new Expression[]{expression, expression2, variable.asExpr()}, n);
    }

    public static Expression stack(int n, Expression expression, Expression expression2, double d) {
        return Expr.stack_(new Expression[]{expression, expression2, Expr.constTerm(d)}, n);
    }

    public static Expression stack(int n, Expression expression, Variable variable, Expression expression2) {
        return Expr.stack_(new Expression[]{expression, variable.asExpr(), expression2}, n);
    }

    public static Expression stack(int n, Expression expression, Variable variable, Variable variable2) {
        return Expr.stack_(new Expression[]{expression, variable.asExpr(), variable2.asExpr()}, n);
    }

    public static Expression stack(int n, Expression expression, Variable variable, double d) {
        return Expr.stack_(new Expression[]{expression, variable.asExpr(), Expr.constTerm(d)}, n);
    }

    public static Expression stack(int n, Expression expression, double d, Expression expression2) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d), expression2}, n);
    }

    public static Expression stack(int n, Expression expression, double d, Variable variable) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d), variable.asExpr()}, n);
    }

    public static Expression stack(int n, Expression expression, double d, double d2) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d), Expr.constTerm(d2)}, n);
    }

    public static Expression stack(int n, Variable variable, Expression expression, Expression expression2) {
        return Expr.stack_(new Expression[]{variable.asExpr(), expression, expression2}, n);
    }

    public static Expression stack(int n, Variable variable, Expression expression, Variable variable2) {
        return Expr.stack_(new Expression[]{variable.asExpr(), expression, variable2.asExpr()}, n);
    }

    public static Expression stack(int n, Variable variable, Expression expression, double d) {
        return Expr.stack_(new Expression[]{variable.asExpr(), expression, Expr.constTerm(d)}, n);
    }

    public static Expression stack(int n, Variable variable, Variable variable2, Expression expression) {
        return Expr.stack_(new Expression[]{variable.asExpr(), variable2.asExpr(), expression}, n);
    }

    public static Expression stack(int n, Variable variable, Variable variable2, Variable variable3) {
        return Expr.stack_(new Expression[]{variable.asExpr(), variable2.asExpr(), variable3.asExpr()}, n);
    }

    public static Expression stack(int n, Variable variable, Variable variable2, double d) {
        return Expr.stack_(new Expression[]{variable.asExpr(), variable2.asExpr(), Expr.constTerm(d)}, n);
    }

    public static Expression stack(int n, Variable variable, double d, Expression expression) {
        return Expr.stack_(new Expression[]{variable.asExpr(), Expr.constTerm(d), expression}, n);
    }

    public static Expression stack(int n, Variable variable, double d, Variable variable2) {
        return Expr.stack_(new Expression[]{variable.asExpr(), Expr.constTerm(d), variable2.asExpr()}, n);
    }

    public static Expression stack(int n, Variable variable, double d, double d2) {
        return Expr.stack_(new Expression[]{variable.asExpr(), Expr.constTerm(d), Expr.constTerm(d2)}, n);
    }

    public static Expression stack(int n, double d, Expression expression, Expression expression2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression, expression2}, n);
    }

    public static Expression stack(int n, double d, Expression expression, Variable variable) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression, variable.asExpr()}, n);
    }

    public static Expression stack(int n, double d, Expression expression, double d2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression, Expr.constTerm(d2)}, n);
    }

    public static Expression stack(int n, double d, Variable variable, Expression expression) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), variable.asExpr(), expression}, n);
    }

    public static Expression stack(int n, double d, Variable variable, Variable variable2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), variable.asExpr(), variable2.asExpr()}, n);
    }

    public static Expression stack(int n, double d, Variable variable, double d2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), variable.asExpr(), Expr.constTerm(d2)}, n);
    }

    public static Expression stack(int n, double d, double d2, Expression expression) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), Expr.constTerm(d2), expression}, n);
    }

    public static Expression stack(int n, double d, double d2, Variable variable) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), Expr.constTerm(d2), variable.asExpr()}, n);
    }

    public static Expression stack(int n, Variable variable, Expression expression) {
        return Expr.stack_(new Expression[]{variable.asExpr(), expression}, n);
    }

    public static Expression stack(int n, Variable variable, Variable variable2) {
        return Expr.stack_(new Expression[]{variable.asExpr(), variable2.asExpr()}, n);
    }

    public static Expression stack(int n, Variable variable, double d) {
        return Expr.stack_(new Expression[]{variable.asExpr(), Expr.constTerm(d)}, n);
    }

    public static Expression stack(int n, double d, Expression expression) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression}, n);
    }

    public static Expression stack(int n, double d, Variable variable) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), variable.asExpr()}, n);
    }

    public static Expression stack(int n, Expression expression, Variable variable) {
        return Expr.stack_(new Expression[]{expression, variable.asExpr()}, n);
    }

    public static Expression stack(int n, Expression expression, double d) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d)}, n);
    }

    public static Expression stack(int n, Expression expression, Expression expression2) {
        return Expr.stack_(new Expression[]{expression, expression2}, n);
    }

    public static Expression stack(int n, Expression[] expressionArray) {
        return Expr.stack_(expressionArray, n);
    }

    protected static Expression stack_(Expression[] expressionArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (expressionArray.length == 0) {
            return new Expr(new long[]{0L}, new Variable[0], new long[0], new double[0], null, Set.make(0), new long[0], 1);
        }
        if (expressionArray.length == 1) {
            return expressionArray[0];
        }
        int n7 = n + 1;
        int n8 = 0;
        int n9 = expressionArray.length;
        for (int i = n8; i < n9; ++i) {
            if (expressionArray[i].shape().nd <= n7) continue;
            n7 = expressionArray[i].shape().nd;
        }
        FlatExpr[] flatExprArray = new FlatExpr[expressionArray.length];
        Expression expression = expressionArray[0];
        int[] nArray = new int[n7];
        boolean bl = true;
        boolean bl2 = false;
        Expr expr = null;
        int n10 = 0;
        Variable[] variableArray = null;
        if (expression.shape().nd < n) {
            throw new LengthError("Invalid stack dimension");
        }
        int n11 = 0;
        int n12 = flatExprArray.length;
        for (n6 = n11; n6 < n12; ++n6) {
            Expression expression2 = expressionArray[n6];
            n5 = 0;
            n4 = expression2.shape().nd;
            for (n3 = n5; n3 < n4; ++n3) {
                if (n == n3 || expression.shape().dim(n3) == expression2.shape().dim(n3)) continue;
                throw new DimensionError("Mismatching dimensions");
            }
            nArray[n] = nArray[n] + expression2.shape().dim(n);
            flatExprArray[n6] = expressionArray[n6].eval();
            n10 += flatExprArray[n6].x.length;
            bl = bl && flatExprArray[n6].inst == null;
            bl2 = bl2 || flatExprArray[n6].bfix != null;
        }
        long[] lArray = new long[flatExprArray.length];
        variableArray = new Variable[n10];
        n12 = 0;
        n6 = 0;
        int n13 = flatExprArray.length;
        for (n5 = n6; n5 < n13; ++n5) {
            n4 = 0;
            n3 = flatExprArray[n5].x.length;
            for (n2 = n4; n2 < n3; ++n2) {
                variableArray[n12] = flatExprArray[n5].x[n2];
                ++n12;
            }
        }
        n6 = 1;
        n13 = flatExprArray.length;
        for (n5 = n6; n5 < n13; ++n5) {
            lArray[n5] = lArray[n5 - 1];
            n4 = 0;
            n3 = flatExprArray[n5 - 1].x.length;
            for (n2 = n4; n2 < n3; ++n2) {
                lArray[n5] = lArray[n5] + flatExprArray[n5 - 1].x[n2].size();
            }
        }
        n12 = 0;
        n6 = n7;
        for (n13 = n12; n13 < n6; ++n13) {
            if (n13 == n) continue;
            nArray[n13] = expression.shape().dim(n13);
        }
        NDSet nDSet = new NDSet(nArray);
        long l = flatExprArray[0].nnz;
        n5 = flatExprArray[0].ptrb.length - 1;
        n4 = 1;
        n3 = expressionArray.length;
        for (n2 = n4; n2 < n3; ++n2) {
            l += flatExprArray[n2].nnz;
            n5 = n5 + flatExprArray[n2].ptrb.length - 1;
        }
        double[] dArray = !bl2 ? null : new double[n5];
        n3 = 0;
        n2 = 0;
        int n14 = flatExprArray.length;
        int n15 = n2 < n14 ? n14 - n2 : 0;
        long[][] lArrayArray = new long[n15][];
        int n16 = n2;
        int n17 = 0;
        while (n17 < n15) {
            lArrayArray[n3] = flatExprArray[n16].ptrb;
            ++n3;
            ++n17;
            ++n16;
        }
        long[][] lArrayArray2 = lArrayArray;
        int n18 = 0;
        int n19 = 0;
        int n20 = flatExprArray.length;
        int n21 = n19 < n20 ? n20 - n19 : 0;
        long[][] lArrayArray3 = new long[n21][];
        int n22 = n19;
        int n23 = 0;
        while (n23 < n21) {
            lArrayArray3[n18] = flatExprArray[n22].subj;
            ++n18;
            ++n23;
            ++n22;
        }
        long[][] lArrayArray4 = lArrayArray3;
        int n24 = 0;
        int n25 = 0;
        int n26 = flatExprArray.length;
        int n27 = n25 < n26 ? n26 - n25 : 0;
        double[][] dArrayArray = new double[n27][];
        int n28 = n25;
        int n29 = 0;
        while (n29 < n27) {
            dArrayArray[n24] = flatExprArray[n28].cof;
            ++n24;
            ++n29;
            ++n28;
        }
        double[][] dArrayArray2 = dArrayArray;
        int n30 = 0;
        int n31 = 0;
        int n32 = flatExprArray.length;
        int n33 = n31 < n32 ? n32 - n31 : 0;
        double[][] dArrayArray3 = new double[n33][];
        int n34 = n31;
        int n35 = 0;
        while (n35 < n33) {
            dArrayArray3[n30] = flatExprArray[n34].bfix;
            ++n30;
            ++n35;
            ++n34;
        }
        double[][] dArrayArray4 = dArrayArray3;
        int n36 = 0;
        int n37 = 0;
        int n38 = flatExprArray.length;
        int n39 = n37 < n38 ? n38 - n37 : 0;
        long[][] lArrayArray5 = new long[n39][];
        int n40 = n37;
        int n41 = 0;
        while (n41 < n39) {
            lArrayArray5[n36] = flatExprArray[n40].inst;
            ++n36;
            ++n41;
            ++n40;
        }
        long[][] lArrayArray6 = lArrayArray5;
        int n42 = 0;
        int n43 = 0;
        int n44 = flatExprArray.length;
        int n45 = n43 < n44 ? n44 - n43 : 0;
        long[] lArray2 = new long[n45];
        int n46 = n43;
        int n47 = 0;
        while (n47 < n45) {
            lArray2[n42] = flatExprArray[n46].nnz;
            ++n42;
            ++n47;
            ++n46;
        }
        long[] lArray3 = lArray2;
        int n48 = 0;
        int n49 = 0;
        int n50 = flatExprArray.length;
        int n51 = n49 < n50 ? n50 - n49 : 0;
        long[] lArray4 = new long[n51];
        int n52 = n49;
        int n53 = 0;
        while (n53 < n51) {
            lArray4[n48] = flatExprArray[n52].shape.size;
            ++n48;
            ++n53;
            ++n52;
        }
        long[] lArray5 = lArray4;
        if (n == 0) {
            long[] lArray6 = new long[n5 + 1];
            long[] lArray7 = new long[(int)l];
            double[] dArray2 = new double[(int)l];
            long[] lArray8 = bl ? null : new long[n5];
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            int n54 = 0;
            int n55 = lArrayArray2.length;
            for (int i = n54; i < n55; ++i) {
                Tools.arraycopy(dArrayArray2[i], 0L, dArray2, l3, lArray3[i]);
                if (dArrayArray4[i] != null) {
                    Tools.arraycopy(dArrayArray4[i], 0L, dArray, l2, (long)dArrayArray4[i].length);
                }
                int n56 = 0;
                int n57 = lArrayArray2[i].length - 1;
                for (int j = n56; j < n57; ++j) {
                    lArray6[(int)(l2 + (long)j + 1L)] = lArrayArray2[i][j + 1] + l3;
                }
                long l5 = 0L;
                long l6 = lArray3[i];
                for (long j = l5; j < l6; ++j) {
                    lArray7[(int)(l3 + j)] = lArray[i] + lArrayArray4[i][(int)j];
                }
                if (!bl) {
                    if (lArrayArray6[i] == null) {
                        int n58 = 0;
                        n57 = lArrayArray2[i].length - 1;
                        for (int j = n58; j < n57; ++j) {
                            lArray8[(int)(l2 + (long)j)] = l4 + (long)j;
                        }
                        l2 += (long)(lArrayArray2[i].length - 1);
                    } else {
                        int n59 = 0;
                        n57 = lArrayArray6[i].length;
                        for (int j = n59; j < n57; ++j) {
                            lArray8[(int)(l2 + (long)j)] = l4 + lArrayArray6[i][j];
                        }
                        l2 += (long)lArrayArray6[i].length;
                    }
                } else {
                    l2 += (long)(lArrayArray2[i].length - 1);
                }
                l4 += lArray5[i];
                l3 += lArray3[i];
            }
            expr = new Expr(lArray6, variableArray, lArray7, dArray2, dArray, nDSet, lArray8);
        } else {
            int n60;
            int n61;
            long[] lArray9 = new long[n5 + 1];
            long[] lArray10 = new long[(int)l];
            double[] dArray3 = new double[(int)l];
            long[] lArray11 = null;
            long l7 = 0L;
            long l8 = 0L;
            long l9 = 0L;
            int n62 = 1;
            int n63 = 0;
            int n64 = n;
            for (n61 = n63; n61 < n64; ++n61) {
                n62 *= nArray[n61];
            }
            n63 = 1;
            n64 = n + 1;
            n61 = nArray.length;
            for (n60 = n64; n60 < n61; ++n60) {
                n63 *= nArray[n60];
            }
            n64 = n63;
            n63 *= nArray[n];
            n61 = 0;
            n60 = 0;
            int n65 = flatExprArray.length;
            int n66 = n60 < n65 ? n65 - n60 : 0;
            int[] nArray2 = new int[n66];
            int n67 = n60;
            int n68 = 0;
            while (n68 < n66) {
                nArray2[n61] = n64 * flatExprArray[n67].shape.dim(n);
                ++n61;
                ++n68;
                ++n67;
            }
            int[] nArray3 = nArray2;
            long[] lArray12 = new long[flatExprArray.length];
            if (bl) {
                int n69 = 0;
                int n70 = n62;
                for (int i = n69; i < n70; ++i) {
                    int n71 = 0;
                    int n72 = flatExprArray.length;
                    for (int j = n71; j < n72; ++j) {
                        long l10 = flatExprArray[j].ptrb[(int)(lArray12[j] + (long)nArray3[j])] - flatExprArray[j].ptrb[(int)lArray12[j]];
                        Tools.arraycopy(flatExprArray[j].cof, flatExprArray[j].ptrb[(int)lArray12[j]], dArray3, l8, l10);
                        if (flatExprArray[j].bfix != null) {
                            Tools.arraycopy(flatExprArray[j].bfix, lArray12[j], dArray, l7, (long)nArray3[j]);
                        }
                        long l11 = flatExprArray[j].ptrb[(int)lArray12[j]];
                        long l12 = 0L;
                        long l13 = l10;
                        for (long k = l12; k < l13; ++k) {
                            lArray10[(int)(l8 + k)] = flatExprArray[j].subj[(int)(l11 + k)] + lArray[j];
                        }
                        int n73 = 0;
                        int n74 = nArray3[j];
                        for (int k = n73; k < n74; ++k) {
                            lArray9[(int)(l7 + (long)k + 1L)] = flatExprArray[j].ptrb[(int)(lArray12[j] + (long)k + 1L)] - flatExprArray[j].ptrb[(int)(lArray12[j] + (long)k)] + lArray9[(int)(l7 + (long)k)];
                        }
                        l8 += l10;
                        l7 += (long)nArray3[j];
                        l9 += flatExprArray[j].shape.size;
                        lArray12[j] = lArray12[j] + (long)nArray3[j];
                    }
                }
                expr = new Expr(lArray9, variableArray, lArray10, dArray3, dArray, nDSet, lArray11);
            } else {
                long[] lArray13 = new long[flatExprArray.length];
                lArray11 = new long[n5];
                int n75 = 0;
                int n76 = n62;
                for (int i = n75; i < n76; ++i) {
                    int n77 = 0;
                    int n78 = flatExprArray.length;
                    for (int j = n77; j < n78; ++j) {
                        long l14;
                        long l15;
                        long l16;
                        long l17;
                        if (flatExprArray[j].inst == null || flatExprArray[j].shape.size == (long)flatExprArray[j].inst.length && flatExprArray[j].inst.length > 0) {
                            int n79;
                            l17 = flatExprArray[j].ptrb[(int)(lArray12[j] + (long)nArray3[j])] - flatExprArray[j].ptrb[(int)lArray12[j]];
                            Tools.arraycopy(flatExprArray[j].cof, flatExprArray[j].ptrb[(int)lArray12[j]], dArray3, l8, l17);
                            if (flatExprArray[j].bfix != null) {
                                Tools.arraycopy(flatExprArray[j].bfix, lArray12[j], dArray, l7, (long)nArray3[j]);
                            }
                            l16 = flatExprArray[j].ptrb[(int)lArray12[j]];
                            long l18 = 0L;
                            long l19 = l17;
                            for (l15 = l18; l15 < l19; ++l15) {
                                lArray10[(int)(l8 + l15)] = flatExprArray[j].subj[(int)(l16 + l15)] + lArray[j];
                            }
                            int n80 = 0;
                            int n81 = nArray3[j];
                            for (n79 = n80; n79 < n81; ++n79) {
                                lArray9[(int)(l7 + (long)n79)] = flatExprArray[j].ptrb[(int)(lArray12[j] + (long)n79)] + lArray9[(int)l7];
                            }
                            n80 = 0;
                            n81 = nArray3[j];
                            for (n79 = n80; n79 < n81; ++n79) {
                                lArray11[(int)(l7 + (long)n79)] = l9 + (long)n79;
                            }
                            l8 += l17;
                            l7 += (long)nArray3[j];
                            l9 += flatExprArray[j].shape.size;
                            lArray12[j] = lArray12[j] + (long)nArray3[j];
                            continue;
                        }
                        if (flatExprArray[j].inst.length <= 0) continue;
                        l17 = 0L;
                        l16 = 0L;
                        while (flatExprArray[j].inst[(int)(lArray12[j] + l16)] < lArray13[j] + (long)nArray3[j]) {
                            ++l16;
                        }
                        l17 = l16;
                        l16 = flatExprArray[j].ptrb[(int)(lArray12[j] + l17)] - flatExprArray[j].ptrb[(int)lArray12[j]];
                        Tools.arraycopy(flatExprArray[j].cof, flatExprArray[j].ptrb[(int)lArray12[j]], dArray3, l8, l16);
                        if (flatExprArray[j].bfix != null) {
                            Tools.arraycopy(flatExprArray[j].bfix, lArray12[j], dArray, l7, l17);
                        }
                        long l20 = flatExprArray[j].ptrb[(int)lArray12[j]];
                        long l21 = 0L;
                        l15 = l16;
                        for (l14 = l21; l14 < l15; ++l14) {
                            lArray10[(int)(l8 + l14)] = flatExprArray[j].subj[(int)(l20 + l14)] + lArray[j];
                        }
                        l21 = 0L;
                        l15 = l17;
                        for (l14 = l21; l14 < l15; ++l14) {
                            lArray9[(int)(l7 + l14 + 1L)] = flatExprArray[j].ptrb[(int)(lArray12[j] + l14 + 1L)] - flatExprArray[j].ptrb[(int)(lArray12[j] + l14)] + lArray9[(int)(l7 + l14)];
                        }
                        l21 = 0L;
                        l15 = l17;
                        for (l14 = l21; l14 < l15; ++l14) {
                            lArray11[(int)(l7 + l14)] = flatExprArray[j].inst[(int)l14] + l9;
                        }
                        l8 += l16;
                        l7 += l17;
                        l9 += flatExprArray[j].shape.size;
                        int n82 = j;
                        lArray12[n82] = lArray12[n82] + l17;
                        int n83 = j;
                        lArray13[n83] = lArray13[n83] + (long)nArray3[j];
                    }
                }
                expr = new Expr(lArray9, variableArray, lArray10, dArray3, dArray, nDSet, lArray11);
            }
        }
        return expr;
    }

    public static Expression repeat(Expression expression, int n, int n2) {
        if (n <= 0) {
            throw new DimensionError("Cannot repeat Expression 0 or less times");
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        int n6 = n4 < n5 ? n5 - n4 : 0;
        Expression[] expressionArray = new Expression[n6];
        int n7 = n4;
        int n8 = 0;
        while (n8 < n6) {
            expressionArray[n3] = expression;
            ++n3;
            ++n8;
            ++n7;
        }
        return Expr.stack_(expressionArray, n2);
    }

    public static Expression add(Expression[] expressionArray) {
        int n;
        int n2;
        int n3;
        int n4;
        if (expressionArray.length == 0) {
            return new Expr(new long[]{0L}, new Variable[0], new long[0], new double[0], null, Set.make(0), new long[0], 1);
        }
        Expr expr = null;
        if (expressionArray == null) {
            throw new NullPointerException("Argument exps may not be null");
        }
        if (expressionArray.length > 0 && expressionArray[0] == null) {
            throw new NullPointerException("Argument exps may not contain null");
        }
        long l = expressionArray[0].shape().size;
        Set set = expressionArray[0].shape() != null ? expressionArray[0].shape() : Set.make((int)l);
        FlatExpr[] flatExprArray = new FlatExpr[expressionArray.length];
        long l2 = 0L;
        boolean bl = true;
        boolean bl2 = false;
        long[] lArray = new long[expressionArray.length];
        int n5 = 0;
        int n6 = 0;
        int n7 = expressionArray.length;
        for (n4 = n6; n4 < n7; ++n4) {
            if (expressionArray[n4] == null) {
                throw new NullPointerException("Argument exps may not contain null");
            }
            flatExprArray[n4] = expressionArray[n4].eval();
            if (!flatExprArray[n4].shape.compare(set)) {
                throw new DimensionError("Mismatching operand dimensions");
            }
            if (flatExprArray[n4].bfix != null) {
                bl2 = true;
            }
            l2 += flatExprArray[n4].nnz;
            bl = bl && flatExprArray[n4].inst == null;
            n5 += flatExprArray[n4].x.length;
        }
        Variable[] variableArray = new Variable[n5];
        n6 = 0;
        n7 = 0;
        n4 = flatExprArray.length;
        for (n3 = n7; n3 < n4; ++n3) {
            n2 = 0;
            n = flatExprArray[n3].x.length;
            for (int i = n2; i < n; ++i) {
                variableArray[n6] = flatExprArray[n3].x[i];
                ++n6;
            }
        }
        n6 = 1;
        n7 = expressionArray.length;
        for (n4 = n6; n4 < n7; ++n4) {
            lArray[n4] = lArray[n4 - 1];
            n3 = 0;
            n2 = flatExprArray[n4 - 1].x.length;
            for (n = n3; n < n2; ++n) {
                lArray[n4] = lArray[n4] + flatExprArray[n4 - 1].x[n].size();
            }
        }
        if (bl) {
            int n8;
            int n9;
            int n10;
            long l3;
            long[] lArray2 = new long[(int)(l + 1L)];
            long[] lArray3 = new long[(int)l2];
            double[] dArray = new double[(int)l2];
            double[] dArray2 = null;
            long[] lArray4 = null;
            long l4 = 0L;
            long l5 = l;
            for (l3 = l4; l3 < l5; ++l3) {
                lArray2[(int)(l3 + 1L)] = lArray2[(int)l3];
                n10 = 0;
                n9 = flatExprArray.length;
                for (n8 = n10; n8 < n9; ++n8) {
                    long l6 = flatExprArray[n8].ptrb[(int)(l3 + 1L)] - flatExprArray[n8].ptrb[(int)l3];
                    Tools.arraycopy(flatExprArray[n8].cof, flatExprArray[n8].ptrb[(int)l3], dArray, lArray2[(int)(l3 + 1L)], l6);
                    long l7 = 0L;
                    long l8 = l6;
                    for (long i = l7; i < l8; ++i) {
                        lArray3[(int)(lArray2[(int)(l3 + 1L)] + i)] = flatExprArray[n8].subj[(int)(flatExprArray[n8].ptrb[(int)l3] + i)] + lArray[n8];
                    }
                    int n11 = (int)(l3 + 1L);
                    lArray2[n11] = lArray2[n11] + l6;
                }
            }
            if (bl2) {
                dArray2 = new double[(int)l];
                l4 = 0L;
                l5 = l;
                for (l3 = l4; l3 < l5; ++l3) {
                    n10 = 0;
                    n9 = flatExprArray.length;
                    for (n8 = n10; n8 < n9; ++n8) {
                        if (flatExprArray[n8].bfix == null) continue;
                        int n12 = (int)l3;
                        dArray2[n12] = dArray2[n12] + flatExprArray[n8].bfix[(int)l3];
                    }
                }
            }
            expr = new Expr(lArray2, variableArray, lArray3, dArray, dArray2, set, lArray4);
        } else {
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int[] nArray = new int[flatExprArray.length];
            int[] nArray2 = new int[flatExprArray.length];
            long[][] lArrayArray = new long[flatExprArray.length][];
            n3 = 0;
            n2 = flatExprArray.length;
            for (n = n3; n < n2; ++n) {
                lArrayArray[n] = flatExprArray[n].inst != null ? flatExprArray[n].inst : Tools.range((long)flatExprArray[n].ptrb.length - 1L);
                nArray2[n] = lArrayArray[n].length;
            }
            n3 = 0;
            Object[] objectArray = Tools.range(flatExprArray.length);
            n = flatExprArray.length;
            while (n > 0) {
                long l9 = lArrayArray[objectArray[0]][nArray[objectArray[0]]];
                int n18 = 1;
                n17 = n;
                for (n16 = n18; n16 < n17; ++n16) {
                    if (lArrayArray[objectArray[n16]][nArray[objectArray[n16]]] >= l9) continue;
                    l9 = lArrayArray[objectArray[n16]][nArray[objectArray[n16]]];
                }
                ++n3;
                n18 = 0;
                n17 = n;
                for (n16 = n18; n16 < n17; ++n16) {
                    if (lArrayArray[objectArray[n16]][nArray[objectArray[n16]]] != l9) continue;
                    int n19 = objectArray[n16];
                    nArray[n19] = nArray[n19] + 1;
                }
                n18 = 0;
                while (n18 < n && n18 < n) {
                    if (nArray[objectArray[n18]] >= nArray2[objectArray[n18]]) {
                        n17 = objectArray[n18];
                        objectArray[n18] = objectArray[n - 1];
                        objectArray[n - 1] = n17;
                        --n;
                        continue;
                    }
                    ++n18;
                }
            }
            objectArray = new long[n3];
            long[] lArray5 = new long[n3 + 1];
            double[] dArray = new double[(int)l2];
            long[] lArray6 = new long[(int)l2];
            double[] dArray3 = null;
            n17 = 0;
            n16 = nArray.length;
            for (n15 = n17; n15 < n16; ++n15) {
                nArray[n15] = 0;
            }
            n17 = 0;
            int[] nArray3 = Tools.range(flatExprArray.length);
            n15 = flatExprArray.length;
            while (n15 > 0) {
                long l10 = lArrayArray[nArray3[0]][nArray[nArray3[0]]];
                n14 = 1;
                int n20 = n15;
                for (n13 = n14; n13 < n20; ++n13) {
                    if (lArrayArray[nArray3[n13]][nArray[nArray3[n13]]] >= l10) continue;
                    l10 = lArrayArray[nArray3[n13]][nArray[nArray3[n13]]];
                }
                objectArray[n17] = (int)l10;
                lArray5[n17 + 1] = lArray5[n17];
                n14 = 0;
                n20 = n15;
                for (n13 = n14; n13 < n20; ++n13) {
                    if (lArrayArray[nArray3[n13]][nArray[nArray3[n13]]] != l10) continue;
                    int n21 = nArray3[n13];
                    long l11 = flatExprArray[n21].ptrb[nArray[n21]];
                    long l12 = flatExprArray[n21].ptrb[nArray[n21] + 1] - l11;
                    Tools.arraycopy(flatExprArray[n21].cof, l11, dArray, lArray5[n17 + 1], l12);
                    long l13 = 0L;
                    long l14 = l12;
                    for (long i = l13; i < l14; ++i) {
                        lArray6[(int)(lArray5[n17 + 1] + i)] = flatExprArray[n21].subj[(int)(l11 + i)] + lArray[n21];
                    }
                    lArray5[n17 + 1] = lArray5[n17 + 1] + l12;
                    int n22 = n21;
                    nArray[n22] = nArray[n22] + 1;
                }
                n14 = 0;
                while (n14 < n15 && n14 < n15) {
                    if (nArray[nArray3[n14]] >= nArray2[nArray3[n14]]) {
                        n20 = nArray3[n14];
                        nArray3[n14] = nArray3[n15 - 1];
                        nArray3[n15 - 1] = n20;
                        --n15;
                        continue;
                    }
                    ++n14;
                }
                ++n17;
            }
            if (bl2) {
                int n23;
                n17 = 0;
                int n24 = nArray.length;
                for (n15 = n17; n15 < n24; ++n15) {
                    nArray[n15] = 0;
                }
                n17 = 0;
                n24 = 0;
                n15 = 0;
                int n25 = flatExprArray.length;
                for (n23 = n15; n23 < n25; ++n23) {
                    if (flatExprArray[n23].bfix == null) continue;
                    ++n24;
                }
                long[] lArray7 = new long[n24];
                n25 = 0;
                n23 = 0;
                while (n23 < n24 && n23 < n24) {
                    if (flatExprArray[n25].bfix != null) {
                        lArray7[n23] = n25;
                        ++n23;
                    }
                    ++n25;
                }
                dArray3 = new double[n3];
                while (n24 > 0) {
                    long l15 = lArrayArray[(int)lArray7[0]][nArray[(int)lArray7[0]]];
                    n14 = 1;
                    int n26 = n24;
                    for (n13 = n14; n13 < n26; ++n13) {
                        if (lArrayArray[(int)lArray7[n13]][nArray[(int)lArray7[n13]]] >= l15) continue;
                        l15 = lArrayArray[(int)lArray7[n13]][nArray[(int)lArray7[n13]]];
                    }
                    n14 = 0;
                    n26 = n24;
                    for (n13 = n14; n13 < n26; ++n13) {
                        if (lArrayArray[(int)lArray7[n13]][nArray[(int)lArray7[n13]]] != l15) continue;
                        dArray3[n17] = dArray3[n17] + flatExprArray[(int)lArray7[n13]].bfix[nArray[(int)lArray7[n13]]];
                        int n27 = (int)lArray7[n13];
                        nArray[n27] = nArray[n27] + 1;
                    }
                    n14 = 0;
                    while (n14 < n24 && n14 < n24) {
                        if (nArray[(int)lArray7[n14]] >= nArray2[(int)lArray7[n14]]) {
                            long l16 = lArray7[n14];
                            lArray7[n14] = lArray7[n24 - 1];
                            lArray7[n24 - 1] = l16;
                            --n24;
                            continue;
                        }
                        ++n14;
                    }
                    ++n17;
                }
            }
            if ((long)n3 == set.size) {
                objectArray = null;
            }
            expr = new Expr(lArray5, variableArray, lArray6, dArray, dArray3, set, (long[])objectArray);
        }
        return expr;
    }

    public static Expression add(Variable[] variableArray) {
        int n;
        int n2;
        if (variableArray == null) {
            throw new NullPointerException("Argument vs may not be null");
        }
        if (variableArray.length == 0) {
            return new Expr(new long[]{0L}, null, new long[0], new double[0], null, Set.make(0), new long[0], 1);
        }
        if (variableArray.length > 0 && variableArray[0] == null) {
            throw new NullPointerException("Argument vs may contain null");
        }
        Set set = variableArray[0].shape();
        int n3 = set.nd;
        long l = set.size;
        long l2 = set.size;
        int n4 = 1;
        int n5 = variableArray.length;
        for (int i = n4; i < n5; ++i) {
            if (variableArray[i] == null) {
                throw new NullPointerException("Argument vs may not contain null");
            }
            if (set.compare(variableArray[i].shape())) continue;
            throw new DimensionError("Mismatching operand dimensions");
        }
        long l3 = l * (long)variableArray.length;
        long[] lArray = Tools.range(0L, l3 + (long)variableArray.length, (long)variableArray.length);
        int n6 = 0;
        int n7 = 0;
        long l4 = l;
        long l5 = (long)n7 < l4 ? l4 - (long)n7 : 0L;
        int n8 = 0;
        int n9 = variableArray.length;
        int n10 = n8 < n9 ? n9 - n8 : 0;
        long[] lArray2 = new long[(int)(l5 * (long)n10)];
        long l6 = n7;
        int n11 = 0;
        while ((long)n11 < l5) {
            n2 = n8;
            n = 0;
            while (n < n10) {
                lArray2[n6] = l6 + (long)n2 * l;
                ++n6;
                ++n;
                ++n2;
            }
            ++n11;
            ++l6;
        }
        long[] lArray3 = lArray2;
        n2 = 0;
        n = 0;
        long l7 = l3;
        long l8 = (long)n < l7 ? l7 - (long)n : 0L;
        double[] dArray = new double[(int)l8];
        long l9 = n;
        int n12 = 0;
        while ((long)n12 < l8) {
            dArray[n2] = 1.0;
            ++n2;
            ++n12;
            ++l9;
        }
        double[] dArray2 = dArray;
        return new Expr(lArray, variableArray, lArray3, dArray2, null, set, null, 1);
    }

    private static Expression add_(Expression expression, double d, Expression expression2, double d2) {
        long l;
        long l2;
        long l3;
        long l4;
        if (expression.getModel() != null && expression2.getModel() != null && expression.getModel() != expression2.getModel()) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = expression.getModel().getName().length() > 0 ? expression.getModel().getName() : "?";
            String string2 = expression2.getModel().getName().length() > 0 ? expression2.getModel().getName() : "?";
            stringBuffer.a("Operands belong to different models: '").a(string).a("' and '").a(string2).a("'");
            throw new ModelError(stringBuffer.toString());
        }
        int n = expression.shape().nd >= expression2.shape().nd ? expression.shape().nd : expression2.shape().nd;
        int n2 = 0;
        int n3 = n;
        for (int i = n2; i < n3; ++i) {
            if (expression.shape().dim(i) == expression2.shape().dim(i)) continue;
            throw new DimensionError("Dimensions mismatch");
        }
        FlatExpr flatExpr = expression.eval();
        FlatExpr flatExpr2 = expression2.eval();
        n3 = flatExpr.inst != null && flatExpr2.inst != null ? 1 : 0;
        Set set = flatExpr.shape;
        long[] lArray = flatExpr.inst;
        long[] lArray2 = flatExpr2.inst;
        if (lArray == null) {
            lArray = Tools.range(set.size);
        }
        if (lArray2 == null) {
            lArray2 = Tools.range(set.size);
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n5 < lArray.length && n6 < lArray2.length) {
            if (lArray[n5] < lArray2[n6]) {
                ++n5;
                ++n4;
                continue;
            }
            if (lArray[n5] > lArray2[n6]) {
                ++n6;
                ++n4;
                continue;
            }
            ++n5;
            ++n6;
            ++n4;
        }
        n4 = n4 + lArray.length - n5;
        n4 = n4 + lArray2.length - n6;
        long[] lArray3 = new long[n4];
        long l5 = 0L;
        int n7 = 0;
        int n8 = flatExpr.x.length;
        for (int i = n7; i < n8; ++i) {
            l5 += flatExpr.x[i].size();
        }
        long[] lArray4 = new long[n4 + 1];
        long[] lArray5 = new long[flatExpr.subj.length + flatExpr2.subj.length];
        double[] dArray = new double[flatExpr.subj.length + flatExpr2.subj.length];
        Variable[] variableArray = Expr.varstack(flatExpr.x, flatExpr2.x);
        double[] dArray2 = (double[])(flatExpr.bfix == null && flatExpr2.bfix == null ? null : new double[n4]);
        long[] lArray6 = flatExpr.ptrb;
        long[] lArray7 = flatExpr.subj;
        double[] dArray3 = flatExpr.cof;
        double[] dArray4 = flatExpr.bfix;
        long[] lArray8 = flatExpr2.ptrb;
        long[] lArray9 = flatExpr2.subj;
        double[] dArray5 = flatExpr2.cof;
        double[] dArray6 = flatExpr2.bfix;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        long l6 = 0L;
        while (n9 < lArray.length && n10 < lArray2.length) {
            long l7;
            if (lArray[n9] < lArray2[n10]) {
                l4 = lArray6[n9 + 1] - lArray6[n9];
                Tools.arraycopy(lArray7, lArray6[n9], lArray5, l6, l4);
                l3 = 0L;
                l2 = l4;
                for (l = l3; l < l2; ++l) {
                    dArray[(int)(l6 + l)] = dArray3[(int)(lArray6[n9] + l)] * d;
                }
                l6 += l4;
                lArray3[n11] = lArray[n9];
                lArray4[n11 + 1] = lArray4[n11] + l4;
                ++n9;
                ++n11;
                continue;
            }
            if (lArray[n9] > lArray2[n10]) {
                l4 = lArray8[n10 + 1] - lArray8[n10];
                l3 = 0L;
                l2 = l4;
                for (l = l3; l < l2; ++l) {
                    lArray5[(int)(l6 + l)] = lArray9[(int)(lArray8[n10] + l)] + l5;
                }
                l3 = 0L;
                l2 = l4;
                for (l = l3; l < l2; ++l) {
                    dArray[(int)(l6 + l)] = dArray5[(int)(lArray8[n10] + l)] * d2;
                }
                l6 += l4;
                lArray3[n11] = lArray2[n10];
                lArray4[n11 + 1] = lArray4[n11] + l4;
                ++n10;
                ++n11;
                continue;
            }
            l4 = lArray6[n9 + 1] - lArray6[n9];
            Tools.arraycopy(lArray7, lArray6[n9], lArray5, l6, l4);
            l3 = 0L;
            l2 = l4;
            for (l = l3; l < l2; ++l) {
                dArray[(int)(l6 + l)] = dArray3[(int)(lArray6[n9] + l)] * d;
            }
            l6 += l4;
            l3 = lArray8[n10 + 1] - lArray8[n10];
            l2 = 0L;
            l = l3;
            for (l7 = l2; l7 < l; ++l7) {
                lArray5[(int)(l6 + l7)] = lArray9[(int)(lArray8[n10] + l7)] + l5;
            }
            l2 = 0L;
            l = l3;
            for (l7 = l2; l7 < l; ++l7) {
                dArray[(int)(l6 + l7)] = dArray5[(int)(lArray8[n10] + l7)] * d2;
            }
            l6 += l3;
            lArray3[n11] = lArray[n9];
            lArray4[n11 + 1] = lArray4[n11] + l4 + l3;
            ++n9;
            ++n10;
            ++n11;
        }
        while (n9 < lArray.length) {
            l4 = lArray6[n9 + 1] - lArray6[n9];
            Tools.arraycopy(lArray7, lArray6[n9], lArray5, l6, l4);
            l3 = 0L;
            l2 = l4;
            for (l = l3; l < l2; ++l) {
                dArray[(int)(l6 + l)] = dArray3[(int)(lArray6[n9] + l)] * d;
            }
            l6 += l4;
            lArray3[n11] = lArray[n9];
            lArray4[n11 + 1] = lArray4[n11] + l4;
            ++n9;
            ++n11;
        }
        while (n10 < lArray2.length) {
            l4 = lArray8[n10 + 1] - lArray8[n10];
            l3 = 0L;
            l2 = l4;
            for (l = l3; l < l2; ++l) {
                lArray5[(int)(l6 + l)] = lArray9[(int)(lArray8[n10] + l)] + l5;
            }
            l3 = 0L;
            l2 = l4;
            for (l = l3; l < l2; ++l) {
                dArray[(int)(l6 + l)] = dArray5[(int)(lArray8[n10] + l)] * d2;
            }
            l6 += l4;
            lArray3[n11] = lArray2[n10];
            lArray4[n11 + 1] = lArray4[n11] + l4;
            ++n10;
            ++n11;
        }
        if (dArray4 != null || dArray6 != null) {
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            long l8 = 0L;
            while (n12 < lArray.length && n13 < lArray2.length) {
                if (lArray[n12] < lArray2[n13]) {
                    if (dArray4 != null) {
                        dArray2[n14] = dArray4[n12] * d;
                    }
                    ++n12;
                    ++n14;
                    continue;
                }
                if (lArray[n12] > lArray2[n13]) {
                    if (dArray6 != null) {
                        dArray2[n14] = dArray6[n13] * d2;
                    }
                    ++n13;
                    ++n14;
                    continue;
                }
                if (dArray4 != null) {
                    dArray2[n14] = dArray4[n12] * d;
                }
                if (dArray6 != null) {
                    dArray2[n14] = dArray2[n14] + dArray6[n13] * d2;
                }
                ++n12;
                ++n13;
                ++n14;
            }
            while (n12 < lArray.length) {
                if (dArray4 != null) {
                    dArray2[n14] = dArray4[n12] * d;
                }
                ++n12;
                ++n14;
            }
            while (n13 < lArray2.length) {
                if (dArray6 != null) {
                    dArray2[n14] = dArray6[n13] * d2;
                }
                ++n13;
                ++n14;
            }
        }
        return new Expr(lArray4, variableArray, lArray5, dArray, dArray2, set, (long)lArray3.length == set.size ? null : lArray3);
    }

    @Override
    public Expression transpose() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Expr expr = this;
        if (expr.shape().nd > 2) {
            throw new DimensionError("Wrong dimensions for transpose");
        }
        if (expr.shape().nd == 1) {
            return Expr.reshape((Expression)expr, Set.make(1, expr.shape().dim(0)));
        }
        if (expr.shape().dim(0) == 1) {
            return Expr.reshape((Expression)expr, Set.make(1, expr.shape().dim(1)));
        }
        if (expr.shape().dim(1) == 1) {
            return Expr.reshape((Expression)expr, Set.make(expr.shape().dim(0)));
        }
        FlatExpr flatExpr = expr.eval();
        long[] lArray = flatExpr.inst;
        double[] dArray = flatExpr.bfix;
        long[] lArray2 = flatExpr.ptrb;
        long[] lArray3 = flatExpr.subj;
        double[] dArray2 = flatExpr.cof;
        if (flatExpr.inst != null) {
            int n7;
            int n8 = flatExpr.shape.dim(0);
            int n9 = flatExpr.shape.dim(1);
            int n10 = flatExpr.inst.length;
            int n11 = flatExpr.subj.length;
            double[] dArray3 = flatExpr.bfix == null ? null : new double[n10];
            long[] lArray4 = new long[n10];
            long[] lArray5 = new long[n10 + 1];
            long[] lArray6 = new long[n11];
            double[] dArray4 = new double[n11];
            Set set = Set.make(n9, n8);
            Variable[] variableArray = flatExpr.x;
            int n12 = 0;
            int n13 = 0;
            int n14 = n10;
            int n15 = n13 < n14 ? n14 - n13 : 0;
            long[] lArray7 = new long[n15];
            int n16 = n13;
            int n17 = 0;
            while (n17 < n15) {
                lArray7[n12] = lArray[n16] / (long)n9;
                ++n12;
                ++n17;
                ++n16;
            }
            long[] lArray8 = lArray7;
            int n18 = 0;
            int n19 = 0;
            int n20 = n10;
            int n21 = n19 < n20 ? n20 - n19 : 0;
            long[] lArray9 = new long[n21];
            int n22 = n19;
            int n23 = 0;
            while (n23 < n21) {
                lArray9[n18] = lArray[n22] % (long)n9;
                ++n18;
                ++n23;
                ++n22;
            }
            long[] lArray10 = lArray9;
            long[] lArray11 = new long[n10];
            long[] lArray12 = new long[n10 + 1];
            int n24 = 0;
            int n25 = n10;
            for (n7 = n24; n7 < n25; ++n7) {
                int n26 = (int)(lArray10[n7] + 1L);
                lArray12[n26] = lArray12[n26] + 1L;
            }
            n24 = 0;
            n25 = n10;
            for (n7 = n24; n7 < n25; ++n7) {
                int n27 = n7 + 1;
                lArray12[n27] = lArray12[n27] + lArray12[n7];
            }
            n24 = 0;
            n25 = n10;
            for (n7 = n24; n7 < n25; ++n7) {
                lArray11[(int)lArray12[(int)lArray10[n7]]] = n7;
                int n28 = (int)lArray10[n7];
                lArray12[n28] = lArray12[n28] + 1L;
            }
            if (dArray3 != null) {
                n24 = 0;
                n25 = n10;
                for (n7 = n24; n7 < n25; ++n7) {
                    dArray3[n7] = dArray[(int)lArray11[n7]];
                }
            }
            n24 = 0;
            n25 = n10;
            for (n7 = n24; n7 < n25; ++n7) {
                lArray4[n7] = lArray10[(int)lArray11[n7]] * (long)n8 + lArray8[(int)lArray11[n7]];
            }
            n24 = 0;
            n25 = n10;
            for (n7 = n24; n7 < n25; ++n7) {
                lArray5[n7 + 1] = lArray5[n7] + (lArray2[(int)(lArray11[n7] + 1L)] - lArray2[(int)lArray11[n7]]);
            }
            n24 = 0;
            n25 = n10;
            for (n7 = n24; n7 < n25; ++n7) {
                Tools.arraycopy(lArray3, lArray2[(int)lArray11[n7]], lArray6, lArray5[n7], lArray5[n7 + 1] - lArray5[n7]);
                Tools.arraycopy(dArray2, lArray2[(int)lArray11[n7]], dArray4, lArray5[n7], lArray5[n7 + 1] - lArray5[n7]);
            }
            return new Expr(lArray5, variableArray, lArray6, dArray4, dArray3, set, lArray4, 1);
        }
        int n29 = flatExpr.shape.dim(0);
        int n30 = flatExpr.shape.dim(1);
        long[] lArray13 = new long[flatExpr.ptrb.length];
        long[] lArray14 = new long[flatExpr.subj.length];
        double[] dArray5 = new double[flatExpr.cof.length];
        double[] dArray6 = dArray != null ? new double[n29 * n30] : null;
        Set set = Set.make(n30, n29);
        int n31 = 0;
        int n32 = n30;
        for (n6 = n31; n6 < n32; ++n6) {
            n5 = 0;
            n4 = n29;
            for (n3 = n5; n3 < n4; ++n3) {
                n2 = n3 * n30 + n6;
                n = n6 * n29 + n3;
                lArray13[n + 1] = lArray13[n] + (lArray2[n2 + 1] - lArray2[n2]);
                Tools.arraycopy(lArray3, lArray2[n2], lArray14, lArray13[n], lArray2[n2 + 1] - lArray2[n2]);
                Tools.arraycopy(dArray2, lArray2[n2], dArray5, lArray13[n], lArray2[n2 + 1] - lArray2[n2]);
            }
        }
        if (dArray != null) {
            n31 = 0;
            n32 = n30;
            for (n6 = n31; n6 < n32; ++n6) {
                n5 = 0;
                n4 = n29;
                for (n3 = n5; n3 < n4; ++n3) {
                    n2 = n3 * n30 + n6;
                    n = n6 * n29 + n3;
                    dArray6[n] = dArray[n2];
                }
            }
        }
        return new Expr(lArray13, flatExpr.x, lArray14, dArray5, dArray6, set, null, 1);
    }

    @Override
    public Expression slice(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        boolean bl;
        int[] nArray3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object[] objectArray;
        int n8;
        if (nArray.length != nArray2.length) {
            throw new LengthError("Length firsta and lasta do not match");
        }
        if (nArray.length != this.shape_p.nd) {
            throw new LengthError("Length firsta and lasta do not match shape");
        }
        int n9 = 0;
        int n10 = nArray.length;
        for (n8 = n9; n8 < n10; ++n8) {
            if (nArray[n8] >= 0 && nArray[n8] <= nArray2[n8] && nArray2[n8] <= this.shape_p.dim(n8)) continue;
            throw new IndexError("Index is invalid or out of bounds");
        }
        n9 = 0;
        n10 = 0;
        n8 = nArray.length;
        int n11 = n10 < n8 ? n8 - n10 : 0;
        int[] nArray4 = new int[n11];
        int n12 = n10;
        int n13 = 0;
        while (n13 < n11) {
            nArray4[n9] = nArray2[n12] - nArray[n12];
            ++n9;
            ++n13;
            ++n12;
        }
        int[] nArray5 = nArray4;
        NDSet nDSet = new NDSet(nArray5);
        if (this.inst == null) {
            long l;
            long l2;
            long l3 = 1L;
            int n14 = 0;
            int n15 = nArray.length;
            for (int i = n14; i < n15; ++i) {
                l3 *= (long)(nArray2[i] - nArray[i]);
            }
            long l4 = this.shape_p.linearidx(nArray);
            IndexCounter indexCounter = new IndexCounter(l4, nArray5, this.shape_p);
            long l5 = 0L;
            long l6 = 0L;
            long l7 = l3;
            for (l2 = l6; l2 < l7; ++l2) {
                l = indexCounter.get();
                l5 += this.ptrb[(int)(l + 1L)] - this.ptrb[(int)l];
                indexCounter.inc();
            }
            long[] lArray = new long[(int)(l3 + 1L)];
            long[] lArray2 = new long[(int)l5];
            double[] dArray = new double[(int)l5];
            indexCounter.reset();
            long l8 = 0L;
            long l9 = l3;
            for (long i = l8; i < l9; ++i) {
                long l10 = indexCounter.get();
                Tools.arraycopy(this.subj, this.ptrb[(int)l10], lArray2, lArray[(int)i], this.ptrb[(int)(l10 + 1L)] - this.ptrb[(int)l10]);
                Tools.arraycopy(this.cof_v, this.ptrb[(int)l10], dArray, lArray[(int)i], this.ptrb[(int)(l10 + 1L)] - this.ptrb[(int)l10]);
                lArray[(int)(i + 1L)] = lArray[(int)i] + (this.ptrb[(int)(l10 + 1L)] - this.ptrb[(int)l10]);
                indexCounter.inc();
            }
            double[] dArray2 = null;
            if (this.bfix != null) {
                indexCounter.reset();
                l2 = 0L;
                l = l3;
                for (long i = l2; i < l; ++i) {
                    dArray2[(int)i] = this.bfix[(int)indexCounter.get()];
                    indexCounter.inc();
                }
            }
            return new Expr(lArray, this.x, lArray2, dArray, dArray2, nDSet, null);
        }
        long l = 0L;
        long l11 = 0L;
        int n16 = 0;
        int n17 = this.inst.length;
        for (int i = n16; i < n17; ++i) {
            objectArray = this.shape_p.idxtokey(this.inst[i]);
            boolean bl2 = true;
            n7 = 0;
            n6 = this.shape_p.nd;
            for (n5 = n7; n5 < n6; ++n5) {
                bl2 = bl2 && nArray[n5] <= objectArray[n5] && objectArray[n5] < nArray2[n5];
            }
            if (!bl2) continue;
            ++l;
            l11 += this.ptrb[i + 1] - this.ptrb[i];
        }
        long[] lArray = new long[(int)(l + 1L)];
        long[] lArray3 = new long[(int)l11];
        double[] dArray = new double[(int)l11];
        objectArray = null;
        long[] lArray4 = new long[(int)l];
        n7 = 0;
        n6 = 0;
        n5 = this.inst.length;
        for (n4 = n6; n4 < n5; ++n4) {
            nArray3 = this.shape_p.idxtokey(this.inst[n4]);
            bl = true;
            n3 = 0;
            n2 = this.shape_p.nd;
            for (n = n3; n < n2; ++n) {
                bl = bl && nArray[n] <= nArray3[n] && nArray3[n] < nArray2[n];
            }
            if (!bl) continue;
            Tools.arraycopy(this.subj, this.ptrb[n4], lArray3, lArray[n7], this.ptrb[n4 + 1] - this.ptrb[n4]);
            Tools.arraycopy(this.cof_v, this.ptrb[n4], dArray, lArray[n7], this.ptrb[n4 + 1] - this.ptrb[n4]);
            lArray[n7 + 1] = lArray[n7] + this.ptrb[n4 + 1] - this.ptrb[n4];
            n3 = 0;
            n2 = 0;
            n = nArray3.length;
            int n18 = n2 < n ? n - n2 : 0;
            int[] nArray6 = new int[n18];
            int n19 = n2;
            int n20 = 0;
            while (n20 < n18) {
                nArray6[n3] = nArray3[n19] - nArray[n19];
                ++n3;
                ++n20;
                ++n19;
            }
            lArray4[n7] = nDSet.linearidx(nArray6);
            ++n7;
        }
        if (this.bfix != null) {
            objectArray = new double[(int)l];
            n7 = 0;
            n6 = 0;
            n5 = this.inst.length;
            for (n4 = n6; n4 < n5; ++n4) {
                nArray3 = this.shape_p.idxtokey(this.inst[n4]);
                bl = true;
                n3 = 0;
                n2 = this.shape_p.nd;
                for (n = n3; n < n2; ++n) {
                    bl = bl && nArray[n] <= nArray3[n] && nArray3[n] < nArray2[n];
                }
                if (!bl) continue;
                objectArray[n7] = (int)this.bfix[n4];
                ++n7;
            }
        }
        return new Expr(lArray, this.x, lArray3, dArray, (double[])objectArray, nDSet, lArray4);
    }

    @Override
    public Expression index(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5] + 1;
            ++n;
            ++n6;
            ++n5;
        }
        int[] nArray3 = nArray2;
        return this.slice(nArray, nArray3);
    }

    @Override
    public Expression index(int n) {
        return this.slice(new int[]{n}, new int[]{n + 1});
    }

    @Override
    public Expression slice(int n, int n2) {
        return this.slice(new int[]{n}, new int[]{n2});
    }

    public static Expression mulElm(Matrix matrix, Expression expression) {
        return Expr.mulElm_(matrix, expression);
    }

    public static Expression mulElm(Matrix matrix, Variable variable) {
        return Expr.mulElm_(matrix, variable);
    }

    public static Expression mulElm(NDSparseArray nDSparseArray, Variable variable) {
        return Expr.mulElm_(nDSparseArray, variable);
    }

    public static Expression mulElm(NDSparseArray nDSparseArray, Expression expression) {
        return Expr.mulElm_(nDSparseArray, expression);
    }

    public static Expression mulElm(double[][] dArray, Variable variable) {
        return Expr.mulElm_(Matrix.dense(dArray), variable);
    }

    public static Expression mulElm(double[][] dArray, Expression expression) {
        return Expr.mulElm_(Matrix.dense(dArray), expression);
    }

    public static Expression mulElm(double[] dArray, Variable variable) {
        return Expr.mulElm_(dArray, variable);
    }

    public static Expression mulElm(double[] dArray, Expression expression) {
        return Expr.mulElm_(dArray, expression);
    }

    public static Expression mulElm(Expression expression, Matrix matrix) {
        return Expr.mulElm_(matrix, expression);
    }

    public static Expression mulElm(Expression expression, double[][] dArray) {
        return Expr.mulElm_(Matrix.dense(dArray), expression);
    }

    public static Expression mulElm(Expression expression, double[] dArray) {
        return Expr.mulElm_(dArray, expression);
    }

    public static Expression mulElm(Expression expression, NDSparseArray nDSparseArray) {
        return Expr.mulElm_(nDSparseArray, expression);
    }

    public static Expression mulElm(Variable variable, Matrix matrix) {
        return Expr.mulElm_(matrix, variable);
    }

    public static Expression mulElm(Variable variable, NDSparseArray nDSparseArray) {
        return Expr.mulElm_(nDSparseArray, variable);
    }

    public static Expression mulElm(Variable variable, double[][] dArray) {
        return Expr.mulElm_(Matrix.dense(dArray), variable);
    }

    public static Expression mulElm(Variable variable, double[] dArray) {
        return Expr.mulElm_(dArray, variable);
    }

    public static Expression dot(Matrix matrix, Expression expression) {
        return Expr.dot_(matrix, expression);
    }

    public static Expression dot(Matrix matrix, Variable variable) {
        return Expr.dot_(matrix, variable);
    }

    public static Expression dot(NDSparseArray nDSparseArray, Variable variable) {
        return Expr.dot_(nDSparseArray, variable);
    }

    public static Expression dot(NDSparseArray nDSparseArray, Expression expression) {
        return Expr.dot_(nDSparseArray, expression);
    }

    public static Expression dot(double[][] dArray, Variable variable) {
        return Expr.dot_(Matrix.dense(dArray), variable);
    }

    public static Expression dot(double[][] dArray, Expression expression) {
        return Expr.dot_(Matrix.dense(dArray), expression);
    }

    public static Expression dot(double[] dArray, Variable variable) {
        return Expr.dot_(dArray, variable);
    }

    public static Expression dot(double[] dArray, Expression expression) {
        return Expr.dot_(dArray, expression);
    }

    public static Expression dot(Expression expression, Matrix matrix) {
        return Expr.dot_(matrix, expression);
    }

    public static Expression dot(Expression expression, double[][] dArray) {
        return Expr.dot_(Matrix.dense(dArray), expression);
    }

    public static Expression dot(Expression expression, double[] dArray) {
        return Expr.dot_(dArray, expression);
    }

    public static Expression dot(Expression expression, NDSparseArray nDSparseArray) {
        return Expr.dot_(nDSparseArray, expression);
    }

    public static Expression dot(Variable variable, NDSparseArray nDSparseArray) {
        return Expr.dot_(nDSparseArray, variable);
    }

    public static Expression dot(Variable variable, Matrix matrix) {
        return Expr.dot_(matrix, variable);
    }

    public static Expression dot(Variable variable, double[][] dArray) {
        return Expr.dot_(Matrix.dense(dArray), variable);
    }

    public static Expression dot(Variable variable, double[] dArray) {
        return Expr.dot_(dArray, variable);
    }

    public static Expression sub(NDSparseArray nDSparseArray, Variable variable) {
        return Expr.add_(Expr.constTerm(nDSparseArray), 1.0, variable.asExpr(), -1.0);
    }

    public static Expression sub(Variable variable, NDSparseArray nDSparseArray) {
        return Expr.add_(variable.asExpr(), 1.0, Expr.constTerm(nDSparseArray), -1.0);
    }

    public static Expression sub(Matrix matrix, Variable variable) {
        return Expr.add_(Expr.constTerm(matrix), 1.0, variable.asExpr(), -1.0);
    }

    public static Expression sub(Variable variable, Matrix matrix) {
        return Expr.add_(variable.asExpr(), 1.0, Expr.constTerm(matrix), -1.0);
    }

    public static Expression sub(double d, Variable variable) {
        return Expr.add_(Expr.constTerm(variable.shape(), d), 1.0, variable.asExpr(), -1.0);
    }

    public static Expression sub(Variable variable, double d) {
        return Expr.add_(variable.asExpr(), 1.0, Expr.constTerm(variable.shape(), d), -1.0);
    }

    public static Expression sub(double[][] dArray, Variable variable) {
        return Expr.add_(Expr.constTerm(dArray), 1.0, variable.asExpr(), -1.0);
    }

    public static Expression sub(double[] dArray, Variable variable) {
        return Expr.add_(Expr.constTerm(dArray), 1.0, variable.asExpr(), -1.0);
    }

    public static Expression sub(Variable variable, double[][] dArray) {
        return Expr.add_(variable.asExpr(), 1.0, Expr.constTerm(dArray), -1.0);
    }

    public static Expression sub(Variable variable, double[] dArray) {
        return Expr.add_(variable.asExpr(), 1.0, Expr.constTerm(dArray), -1.0);
    }

    public static Expression sub(Variable variable, Variable variable2) {
        return Expr.add_(variable.asExpr(), 1.0, variable2.asExpr(), -1.0);
    }

    public static Expression sub(NDSparseArray nDSparseArray, Expression expression) {
        return Expr.add_(Expr.constTerm(nDSparseArray), 1.0, expression, -1.0);
    }

    public static Expression sub(Expression expression, NDSparseArray nDSparseArray) {
        return Expr.add_(expression, 1.0, Expr.constTerm(nDSparseArray), -1.0);
    }

    public static Expression sub(Matrix matrix, Expression expression) {
        return Expr.add_(Expr.constTerm(matrix), 1.0, expression, -1.0);
    }

    public static Expression sub(Expression expression, Matrix matrix) {
        return Expr.add_(expression, 1.0, Expr.constTerm(matrix), -1.0);
    }

    public static Expression sub(double d, Expression expression) {
        return Expr.add_(Expr.constTerm(expression.shape(), d), 1.0, expression, -1.0);
    }

    public static Expression sub(Expression expression, double d) {
        return Expr.add_(expression, 1.0, Expr.constTerm(expression.shape(), d), -1.0);
    }

    public static Expression sub(double[][] dArray, Expression expression) {
        return Expr.add_(Expr.constTerm(dArray), 1.0, expression, -1.0);
    }

    public static Expression sub(double[] dArray, Expression expression) {
        return Expr.add_(Expr.constTerm(dArray), 1.0, expression, -1.0);
    }

    public static Expression sub(Expression expression, double[][] dArray) {
        return Expr.add_(expression, 1.0, Expr.constTerm(dArray), -1.0);
    }

    public static Expression sub(Expression expression, double[] dArray) {
        return Expr.add_(expression, 1.0, Expr.constTerm(dArray), -1.0);
    }

    public static Expression sub(Variable variable, Expression expression) {
        return Expr.add_(variable.asExpr(), 1.0, expression, -1.0);
    }

    public static Expression sub(Expression expression, Variable variable) {
        return Expr.add_(expression, 1.0, variable.asExpr(), -1.0);
    }

    public static Expression sub(Expression expression, Expression expression2) {
        return Expr.add_(expression, 1.0, expression2, -1.0);
    }

    public static Expression add(NDSparseArray nDSparseArray, Variable variable) {
        return Expr.add_(Expr.constTerm(nDSparseArray), 1.0, variable.asExpr(), 1.0);
    }

    public static Expression add(Variable variable, NDSparseArray nDSparseArray) {
        return Expr.add_(Expr.constTerm(nDSparseArray), 1.0, variable.asExpr(), 1.0);
    }

    public static Expression add(Matrix matrix, Variable variable) {
        return Expr.add_(Expr.constTerm(matrix), 1.0, variable.asExpr(), 1.0);
    }

    public static Expression add(Variable variable, Matrix matrix) {
        return Expr.add_(Expr.constTerm(matrix), 1.0, variable.asExpr(), 1.0);
    }

    public static Expression add(double d, Variable variable) {
        return Expr.add_(Expr.constTerm(variable.shape(), d), 1.0, variable.asExpr(), 1.0);
    }

    public static Expression add(Variable variable, double d) {
        return Expr.add_(Expr.constTerm(variable.shape(), d), 1.0, variable.asExpr(), 1.0);
    }

    public static Expression add(double[][] dArray, Variable variable) {
        return Expr.add_(Expr.constTerm(dArray), 1.0, variable.asExpr(), 1.0);
    }

    public static Expression add(double[] dArray, Variable variable) {
        return Expr.add_(Expr.constTerm(dArray), 1.0, variable.asExpr(), 1.0);
    }

    public static Expression add(Variable variable, double[][] dArray) {
        return Expr.add_(Expr.constTerm(dArray), 1.0, variable.asExpr(), 1.0);
    }

    public static Expression add(Variable variable, double[] dArray) {
        return Expr.add_(Expr.constTerm(dArray), 1.0, variable.asExpr(), 1.0);
    }

    public static Expression add(Variable variable, Variable variable2) {
        return Expr.add_(variable.asExpr(), 1.0, variable2.asExpr(), 1.0);
    }

    public static Expression add(NDSparseArray nDSparseArray, Expression expression) {
        return Expr.add_(expression, 1.0, Expr.constTerm(nDSparseArray), 1.0);
    }

    public static Expression add(Expression expression, NDSparseArray nDSparseArray) {
        return Expr.add_(expression, 1.0, Expr.constTerm(nDSparseArray), 1.0);
    }

    public static Expression add(Matrix matrix, Expression expression) {
        return Expr.add_(expression, 1.0, Expr.constTerm(matrix), 1.0);
    }

    public static Expression add(Expression expression, Matrix matrix) {
        return Expr.add_(expression, 1.0, Expr.constTerm(matrix), 1.0);
    }

    public static Expression add(double d, Expression expression) {
        return Expr.add_(expression, 1.0, Expr.constTerm(expression.shape(), d), 1.0);
    }

    public static Expression add(Expression expression, double d) {
        return Expr.add_(expression, 1.0, Expr.constTerm(expression.shape(), d), 1.0);
    }

    public static Expression add(double[][] dArray, Expression expression) {
        return Expr.add_(expression, 1.0, Expr.constTerm(dArray), 1.0);
    }

    public static Expression add(double[] dArray, Expression expression) {
        return Expr.add_(expression, 1.0, Expr.constTerm(dArray), 1.0);
    }

    public static Expression add(Expression expression, double[][] dArray) {
        return Expr.add_(expression, 1.0, Expr.constTerm(dArray), 1.0);
    }

    public static Expression add(Expression expression, double[] dArray) {
        return Expr.add_(expression, 1.0, Expr.constTerm(dArray), 1.0);
    }

    public static Expression add(Variable variable, Expression expression) {
        return Expr.add_(variable.asExpr(), 1.0, expression, 1.0);
    }

    public static Expression add(Expression expression, Variable variable) {
        return Expr.add_(expression, 1.0, variable.asExpr(), 1.0);
    }

    public static Expression add(Expression expression, Expression expression2) {
        return Expr.add_(expression, 1.0, expression2, 1.0);
    }

    @Override
    public Set shape() {
        return this.shape_p;
    }

    @Override
    public Set getShape() {
        return this.shape_p;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    private static void validateData(long[] lArray, Variable[] variableArray, long[] lArray2, double[] dArray, double[] dArray2, Set set, long[] lArray3) {
        int n;
        int n2;
        int n3;
        int n4 = lArray.length - 1;
        long l = lArray[lArray.length - 1];
        long l2 = 0L;
        if (variableArray == null) {
            throw new ExpressionError("Array v must not be null");
        }
        int n5 = 0;
        int n6 = variableArray.length;
        for (n3 = n5; n3 < n6; ++n3) {
            if (variableArray[n3] == null) {
                throw new ExpressionError("Array elements of v must not be null");
            }
            l2 += variableArray[n3].size();
        }
        if (lArray.length < 1) {
            throw new ExpressionError("Array 'ptrb' in expression has wrong size");
        }
        if (l != (long)lArray2.length) {
            throw new ExpressionError("Array 'subj' in expression has wrong size");
        }
        if (l != (long)dArray.length) {
            throw new ExpressionError("Array 'cof' in expression has wrong size");
        }
        if (dArray2 != null && n4 != dArray2.length) {
            throw new ExpressionError("Array 'bfix' in expression has wrong length");
        }
        if (set != null) {
            if (lArray3 != null && (long)lArray3.length < set.size) {
                long[] lArray4 = lArray3;
                if (lArray4.length != lArray.length - 1) {
                    throw new ExpressionError("Array 'inst' in expression has wrong length");
                }
                if (lArray4.length > 0) {
                    if (lArray4[0] < 0L || lArray4[0] >= set.size) {
                        throw new ExpressionError("Array 'inst' contains an invalid index");
                    }
                    n6 = 1;
                    long l3 = set.size;
                    n2 = 1;
                    n = lArray4.length;
                    for (int i = n2; i < n; ++i) {
                        n6 = n6 != 0 && lArray4[i] >= 0L && lArray4[i] < l3 && lArray4[i] > lArray4[i - 1] ? 1 : 0;
                    }
                    if (n6 == 0) {
                        throw new ExpressionError("Invalid array 'inst'");
                    }
                }
            } else if (set.size != (long)lArray.length - 1L) {
                throw new ExpressionError("Array 'ptrb' in expression has wrong length");
            }
        } else if (lArray3 != null) {
            throw new ExpressionError("Undefined expression shape");
        }
        boolean bl = false;
        n6 = 0;
        if (lArray[0] != 0L) {
            throw new ExpressionError("Invalid 'ptrb' argument in expression");
        }
        n3 = 1;
        int n7 = 0;
        n2 = n4;
        for (n = n7; n < n2; ++n) {
            n3 = n3 != 0 && lArray[n] <= lArray[n + 1] ? 1 : 0;
        }
        if (n3 == 0) {
            throw new ExpressionError("Invalid 'ptrb' argument in expression");
        }
        n7 = 1;
        n2 = 0;
        long l4 = l;
        for (long i = (long)n2; i < l4; ++i) {
            n7 = n7 != 0 && lArray2[(int)i] >= 0L && lArray2[(int)i] < l2 ? 1 : 0;
        }
        if (n7 == 0) {
            throw new ExpressionError("Invalid 'subj' argument in expression");
        }
    }

    private static Model extractModel(Variable[] variableArray) {
        return variableArray == null || variableArray.length == 0 ? null : variableArray[0].getModel();
    }
}

