/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.CommonTools;
import mosek.fusion.Constraint;
import mosek.fusion.DimensionError;
import mosek.fusion.IntSet;
import mosek.fusion.Model;
import mosek.fusion.ModelError;
import mosek.fusion.NDSet;
import mosek.fusion.Set;
import mosek.fusion.SolutionError;
import mosek.fusion.UnimplementedError;
import mosek.fusion.Utils.Tools;

public class CompoundConstraint
extends Constraint {
    private int stackdim;
    private int[] consb;
    private Constraint[] cons;

    public CompoundConstraint(Constraint[] constraintArray) throws ModelError {
        super(CompoundConstraint.model_from_con(constraintArray), CompoundConstraint.compute_shape(constraintArray, 0));
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < constraintArray.length && n < constraintArray.length; ++n) {
            if (constraintArray[n].shape_p.size == 1L) {
                ++n3;
                ++n4;
                continue;
            }
            if (constraintArray[n].shape_p.size <= 1L) continue;
            ++n3;
            n4 += constraintArray[n].shape_p.dim(n2);
        }
        this.cons = new Constraint[n3];
        this.consb = new int[n3 + 1];
        this.consb[0] = 0;
        this.stackdim = n2;
        n = 0;
        for (int i = 0; i < constraintArray.length && i < constraintArray.length; ++i) {
            if (constraintArray[i].shape_p.size <= 0L) continue;
            this.cons[n] = constraintArray[i];
            ++n;
            this.consb[i + 1] = constraintArray[i].shape_p.size == 1L ? this.consb[i] + 1 : this.consb[i] + constraintArray[i].shape_p.dim(n2);
        }
    }

    @Override
    protected void toStringArray(long[] lArray, long l, String[] stringArray) {
        throw new UnimplementedError("SliceConstraint.toStringArray() not implemented");
    }

    @Override
    protected void add_l(long[] lArray, long[] lArray2, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray, double[] dArray2, long l, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = n2;
        int n7 = n5 < n6 ? n6 - n5 : 0;
        long[] lArray3 = new long[n7];
        int n8 = n5;
        int n9 = 0;
        while (n9 < n7) {
            lArray3[n4] = lArray[n + n8] - l;
            ++n4;
            ++n9;
            ++n8;
        }
        long[] lArray4 = lArray3;
        int n10 = 0;
        int n11 = 0;
        int n12 = n2;
        int n13 = n11 < n12 ? n12 - n11 : 0;
        long[] lArray5 = new long[n13];
        int n14 = n11;
        int n15 = 0;
        while (n15 < n13) {
            lArray5[n10] = n14;
            ++n10;
            ++n15;
            ++n14;
        }
        long[] lArray6 = lArray5;
        int n16 = 0;
        int n17 = 0;
        int n18 = n2;
        int n19 = n17 < n18 ? n18 - n17 : 0;
        long[] lArray7 = new long[n19];
        int n20 = n17;
        int n21 = 0;
        while (n21 < n19) {
            lArray7[n16] = this.shape_p.idxtokey(lArray[n + n20] - l)[this.stackdim];
            ++n16;
            ++n21;
            ++n20;
        }
        long[] lArray8 = lArray7;
        CommonTools.argQsort(lArray6, lArray8, lArray4, 0L, (long)n2);
        int[] nArray4 = new int[n2];
        int n22 = 0;
        while ((long)this.consb[n22] < lArray8[(int)lArray6[0]]) {
            ++n22;
        }
        nArray4[0] = n22;
        int n23 = 1;
        int n24 = n2;
        for (int i = n23; i < n24; ++i) {
            while ((long)this.consb[n22] < lArray8[(int)lArray6[i]]) {
                ++n22;
            }
            nArray4[i] = n22;
        }
        long[] lArray9 = new long[n2];
        long[] lArray10 = new long[n2 + 1];
        long l2 = lArray2[n + n2] - lArray2[n];
        int[] nArray5 = new int[(int)l2];
        int[] nArray6 = new int[(int)l2];
        int[] nArray7 = new int[(int)l2];
        double[] dArray3 = new double[(int)l2];
        double[] dArray4 = dArray2 == null ? null : new double[n2];
        lArray10[0] = 0L;
        int n25 = 0;
        int n26 = n2;
        for (n3 = n25; n3 < n26; ++n3) {
            int n27 = nArray4[n3];
            if (this.cons[n27].shape_p.size == 1L) {
                lArray9[n3] = 0L;
            } else {
                int[] nArray8 = this.shape_p.idxtokey(lArray4[(int)lArray6[n3]]);
                nArray8[this.stackdim] = nArray8[this.stackdim] - this.consb[n27];
                lArray9[n3] = this.cons[n27].shape_p.linearidx(nArray8);
            }
            long l3 = lArray2[(int)(lArray6[n3] + 1L)] - lArray2[(int)lArray6[n3]];
            lArray10[n3 + 1] = lArray10[n3] + l3;
            Tools.arraycopy(nArray, lArray2[(int)lArray6[n3]], nArray5, lArray10[n3], l3);
            Tools.arraycopy(nArray2, lArray2[(int)lArray6[n3]], nArray6, lArray10[n3], l3);
            Tools.arraycopy(nArray3, lArray2[(int)lArray6[n3]], nArray7, lArray10[n3], l3);
            Tools.arraycopy(dArray, lArray2[(int)lArray6[n3]], dArray3, lArray10[n3], l3);
        }
        if (dArray2 != null) {
            n25 = 0;
            n26 = n2;
            for (n3 = n25; n3 < n26; ++n3) {
                dArray4[n3] = dArray2[(int)lArray6[n3]];
            }
        }
        n25 = 0;
        while (n25 < n2) {
            n26 = n25++;
            while (n25 < n2 && nArray4[n25] == nArray4[n26]) {
                ++n25;
            }
            this.cons[nArray4[n26]].add_l(lArray9, lArray10, nArray5, nArray6, nArray7, dArray3, dArray4, 0L, n26, n25 - n26);
        }
    }

    @Override
    protected void dual_values(long l, int[] nArray, long[] lArray, int n, double[] dArray) throws SolutionError {
        int n2;
        int n3;
        int n4 = lArray.length;
        int n5 = nArray[0];
        int n6 = 1;
        int n7 = nArray.length;
        for (n3 = n6; n3 < n7; ++n3) {
            n5 *= nArray[n3];
        }
        n6 = 0;
        n7 = 0;
        n3 = nArray.length;
        int n8 = n7 < n3 ? n3 - n7 : 0;
        long[] lArray2 = new long[n8];
        int n9 = n7;
        int n10 = 0;
        while (n10 < n8) {
            lArray2[n6] = l;
            ++n6;
            ++n10;
            ++n9;
        }
        long[] lArray3 = lArray2;
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[this.shape_p.nd];
        long[] lArray4 = new long[this.shape_p.nd];
        lArray4[this.shape_p.nd - 1] = 1L;
        int n11 = 1;
        int n12 = this.shape_p.nd;
        for (n2 = n11; n2 < n12; ++n2) {
            lArray4[this.shape_p.nd - n2 - 1] = lArray4[this.shape_p.nd - n2] * (long)this.shape_p.dim(this.shape_p.nd - n2);
        }
        long[] lArray5 = new long[1];
        n12 = 0;
        n2 = n5;
        for (int i = n12; i < n2; ++i) {
            long l2 = lArray3[0];
            int n13 = 0;
            int n14 = this.shape_p.nd;
            for (int j = n13; j < n14; ++j) {
                nArray3[j] = (int)(l2 / lArray4[j]);
                l2 -= (long)nArray3[j] * lArray4[j];
            }
            int n15 = 0;
            while (nArray3[this.stackdim] >= this.consb[n15 + 1]) {
                ++n15;
            }
            nArray3[this.stackdim] = nArray3[this.stackdim] - this.consb[n15];
            lArray5[0] = this.cons[n15].shape_p.linearidx(nArray3);
            this.cons[n15].dual_values(lArray5, n + i, dArray);
            nArray2[0] = nArray2[0] + 1;
            lArray3[0] = lArray3[0] + lArray[n4 - 1];
            n15 = 0;
            for (n15 = 0; n15 < n4 - 1 && nArray2[n15] == nArray[n15] && n15 < n4 - 1 && nArray2[n15] == nArray[n15]; ++n15) {
                nArray2[n15] = 0;
                int n16 = n15 + 1;
                nArray2[n16] = nArray2[n16] + 1;
            }
            int n17 = 0;
            n13 = n15;
            for (n14 = n17; n14 < n13; ++n14) {
                lArray3[n14] = lArray3[n15];
            }
        }
    }

    @Override
    protected void dual_values(long[] lArray, int n, double[] dArray) throws SolutionError {
        long[] lArray2 = new long[1];
        int[] nArray = new int[this.shape_p.nd];
        int n2 = 0;
        int n3 = lArray.length;
        for (int i = n2; i < n3; ++i) {
            long l = lArray[i];
            int n4 = 0;
            int n5 = this.shape_p.nd;
            for (int j = n4; j < n5; ++j) {
                nArray[j] = (int)(l / this.shape_p.stride(j));
                l -= (long)nArray[j] * this.shape_p.stride(j);
            }
            int n6 = 0;
            while (nArray[this.stackdim] >= this.consb[n6 + 1]) {
                ++n6;
            }
            nArray[this.stackdim] = nArray[this.stackdim] - this.consb[n6];
            lArray2[0] = this.cons[n6].shape_p.linearidx(nArray);
            this.cons[n6].dual_values(lArray2, n + i, dArray);
        }
    }

    @Override
    protected void level_values(long l, int[] nArray, long[] lArray, int n, double[] dArray) throws SolutionError {
        int n2;
        int n3;
        int n4 = lArray.length;
        int n5 = nArray[0];
        int n6 = 1;
        int n7 = nArray.length;
        for (n3 = n6; n3 < n7; ++n3) {
            n5 *= nArray[n3];
        }
        n6 = 0;
        n7 = 0;
        n3 = nArray.length;
        int n8 = n7 < n3 ? n3 - n7 : 0;
        long[] lArray2 = new long[n8];
        int n9 = n7;
        int n10 = 0;
        while (n10 < n8) {
            lArray2[n6] = l;
            ++n6;
            ++n10;
            ++n9;
        }
        long[] lArray3 = lArray2;
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[this.shape_p.nd];
        long[] lArray4 = new long[this.shape_p.nd];
        lArray4[this.shape_p.nd - 1] = 1L;
        int n11 = 1;
        int n12 = this.shape_p.nd;
        for (n2 = n11; n2 < n12; ++n2) {
            lArray4[this.shape_p.nd - n2 - 1] = lArray4[this.shape_p.nd - n2] * (long)this.shape_p.dim(this.shape_p.nd - n2);
        }
        long[] lArray5 = new long[1];
        n12 = 0;
        n2 = n5;
        for (int i = n12; i < n2; ++i) {
            long l2 = lArray3[0];
            int n13 = 0;
            int n14 = this.shape_p.nd;
            for (int j = n13; j < n14; ++j) {
                nArray3[j] = (int)(l2 / lArray4[j]);
                l2 -= (long)nArray3[j] * lArray4[j];
            }
            int n15 = 0;
            while (nArray3[this.stackdim] >= this.consb[n15 + 1]) {
                ++n15;
            }
            nArray3[this.stackdim] = nArray3[this.stackdim] - this.consb[n15];
            lArray5[0] = this.cons[n15].shape_p.linearidx(nArray3);
            this.cons[n15].level_values(lArray5, n + i, dArray);
            nArray2[0] = nArray2[0] + 1;
            lArray3[0] = lArray3[0] + lArray[n4 - 1];
            n15 = 0;
            for (n15 = 0; n15 < n4 - 1 && nArray2[n15] == nArray[n15] && n15 < n4 - 1 && nArray2[n15] == nArray[n15]; ++n15) {
                nArray2[n15] = 0;
                int n16 = n15 + 1;
                nArray2[n16] = nArray2[n16] + 1;
            }
            int n17 = 0;
            n13 = n15;
            for (n14 = n17; n14 < n13; ++n14) {
                lArray3[n14] = lArray3[n15];
            }
        }
    }

    @Override
    protected void level_values(long[] lArray, int n, double[] dArray) throws SolutionError {
        long[] lArray2 = new long[1];
        int[] nArray = new int[this.shape_p.nd];
        int n2 = 0;
        int n3 = lArray.length;
        for (int i = n2; i < n3; ++i) {
            long l = lArray[i];
            int n4 = 0;
            int n5 = this.shape_p.nd;
            for (int j = n4; j < n5; ++j) {
                nArray[j] = (int)(l / this.shape_p.stride(j));
                l -= (long)nArray[j] * this.shape_p.stride(j);
            }
            int n6 = 0;
            while (nArray[this.stackdim] >= this.consb[n6 + 1]) {
                ++n6;
            }
            nArray[this.stackdim] = nArray[this.stackdim] - this.consb[n6];
            lArray2[0] = this.cons[n6].shape_p.linearidx(nArray);
            this.cons[n6].level_values(lArray2, n + i, dArray);
        }
    }

    protected void add(long[] lArray, int[] nArray, double[] dArray, double[] dArray2, int n, int[] nArray2, int n2) {
        throw new UnimplementedError("Functionality not implemented yet.");
    }

    @Override
    public Constraint slice(int[] nArray, int[] nArray2) {
        throw new UnimplementedError("Compound constraints cannot be sliced");
    }

    @Override
    public Constraint slice(int n, int n2) {
        throw new UnimplementedError("Compound constraints cannot be sliced");
    }

    private static Set compute_shape(Constraint[] constraintArray, int n) {
        int n2;
        int n3;
        Set set = constraintArray[0].shape();
        int n4 = 0;
        int n5 = 0;
        int n6 = constraintArray.length;
        for (n3 = n5; n3 < n6; ++n3) {
            if (constraintArray[n3].shape_p.size > 0L) {
                if (constraintArray[n3].shape_p.nd != set.nd) {
                    throw new DimensionError("Mismatching variable shape");
                }
                for (n2 = 0; n2 < set.nd && n2 < set.nd; ++n2) {
                    if (n2 == n || set.dim(n2) == constraintArray[n3].shape_p.dim(n2)) continue;
                    throw new DimensionError("Mismatching variable shape");
                }
                n4 += constraintArray[n3].shape_p.dim(n);
                continue;
            }
            throw new DimensionError("Empty element in compound variable");
        }
        if (set.nd == 1) {
            return new IntSet(n4);
        }
        n5 = 0;
        n6 = 0;
        n3 = set.nd;
        n2 = n6 < n3 ? n3 - n6 : 0;
        int[] nArray = new int[n2];
        int n7 = n6;
        int n8 = 0;
        while (n8 < n2) {
            nArray[n5] = set.dim(n7);
            ++n5;
            ++n8;
            ++n7;
        }
        int[] nArray2 = nArray;
        nArray2[n] = n4;
        return new NDSet(nArray2);
    }

    private static int count_numcon(Constraint[] constraintArray) {
        int n = 0;
        for (int i = 0; i < constraintArray.length && i < constraintArray.length; ++i) {
            Constraint constraint;
            Constraint constraint2 = constraintArray[i];
            Constraint constraint3 = constraint2;
            if (constraint3 instanceof CompoundConstraint) {
                constraint = (CompoundConstraint)constraint3;
                n += ((CompoundConstraint)constraint).cons.length;
                continue;
            }
            constraint = constraint3;
            ++n;
        }
        return n;
    }

    private static Model model_from_con(Constraint[] constraintArray) {
        return constraintArray[0].model;
    }
}

