/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import mosek.DataCallback;
import mosek.Env;
import mosek.Error;
import mosek.MosekException;
import mosek.Progress;
import mosek.Stream;
import mosek.Task;
import mosek.Warning;
import mosek.accmode;
import mosek.boundkey;
import mosek.conetype;
import mosek.dinfitem;
import mosek.fusion.BreakCallback;
import mosek.fusion.NameError;
import mosek.fusion.OptimizeError;
import mosek.fusion.ProblemStatus;
import mosek.fusion.RelationKey;
import mosek.fusion.SolutionStatus;
import mosek.fusion.SolutionStruct;
import mosek.fusion.SolutionType;
import mosek.fusion.SolverInfo;
import mosek.fusion.UnexpectedError;
import mosek.fusion.Utils.Tools;
import mosek.iinfitem;
import mosek.iparam;
import mosek.liinfitem;
import mosek.objsense;
import mosek.prosta;
import mosek.rescode;
import mosek.solsta;
import mosek.soltype;
import mosek.streamtype;
import mosek.variabletype;

public class BaseModel
implements Closeable {
    private static Env _global_env = null;
    private static int env_counter = 0;
    private Task task;
    private final String modelname;
    protected SolutionStruct sol_itr = null;
    protected SolutionStruct sol_bas = null;
    protected SolutionStruct sol_itg = null;
    private DataCallback user_callback = null;
    private Progress user_progress = null;
    private BreakCallback breaksolve = new BreakCallback();
    private double[] blx;
    private double[] bux;
    private boundkey[] bkx;
    private String[] namex;
    private int numx;
    private int numflushedx;
    private Writer logwriter;
    protected boolean synched;
    private long cumtime = 0L;

    private void flushx() {
        int n = this.numx - this.numflushedx;
        if (n > 0) {
            double[] dArray = new double[n];
            System.arraycopy(this.blx, this.numflushedx, dArray, 0, n);
            double[] dArray2 = new double[n];
            System.arraycopy(this.bux, this.numflushedx, dArray2, 0, n);
            boundkey[] boundkeyArray = new boundkey[n];
            System.arraycopy(this.bkx, this.numflushedx, boundkeyArray, 0, n);
            try {
                this.task.appendvars(n);
                this.task.putboundslice(accmode.var, this.numflushedx, this.numx, boundkeyArray, dArray, dArray2);
            }
            catch (MosekException mosekException) {
                throw new UnexpectedError(mosekException.toString());
            }
            this.numflushedx = this.numx;
        }
    }

    private int addx(int n) {
        int n2;
        if (n + this.numx > this.bkx.length) {
            for (n2 = 2 * this.bkx.length; n2 < n + this.numx; n2 *= 2) {
            }
            double[] dArray = new double[n2];
            System.arraycopy(this.blx, 0, dArray, 0, this.numx);
            double[] dArray2 = new double[n2];
            System.arraycopy(this.bux, 0, dArray2, 0, this.numx);
            boundkey[] boundkeyArray = new boundkey[n2];
            System.arraycopy(this.bkx, 0, boundkeyArray, 0, this.numx);
            String[] stringArray = new String[n2];
            System.arraycopy(this.namex, 0, stringArray, 0, this.numx);
            this.blx = dArray;
            this.bux = dArray2;
            this.bkx = boundkeyArray;
            this.namex = stringArray;
        }
        n2 = this.numx;
        this.numx += n;
        for (int i = n2; i < this.numx; ++i) {
            this.bkx[i] = boundkey.fr;
        }
        return n2;
    }

    protected void task_setnumvar(int n) {
        this.numx = n;
    }

    protected void flushxnames() {
        this.flushx();
        int[] nArray = new int[this.numx];
        for (int i = 0; i < this.numx; ++i) {
            nArray[i] = i;
        }
        this.task.putvarnamelist(nArray, this.namex);
    }

    public int alloc_linearvar(String string, RelationKey relationKey, double d) {
        this.synched = false;
        int n = this.addx(1);
        this.namex[n] = string;
        switch (relationKey) {
            case IsFree: {
                this.bkx[n] = boundkey.fr;
                break;
            }
            case LessThan: {
                this.bkx[n] = boundkey.up;
                this.bux[n] = d;
                break;
            }
            case GreaterThan: {
                this.bkx[n] = boundkey.lo;
                this.blx[n] = d;
                break;
            }
            default: {
                this.bkx[n] = boundkey.fx;
                this.blx[n] = d;
                this.bux[n] = d;
            }
        }
        return n;
    }

    public int alloc_rangedvar(String string, double d, double d2) {
        this.synched = false;
        int n = this.addx(1);
        this.namex[n] = string;
        this.bkx[n] = boundkey.ra;
        this.blx[n] = d;
        this.bux[n] = d2;
        return n;
    }

    protected static Env globalEnv() {
        try {
            if (_global_env == null) {
                _global_env = new Env();
            }
            ++env_counter;
            return _global_env;
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected static void env_putlicensecode(int[] nArray) {
        BaseModel.globalEnv().putlicensecode(nArray);
    }

    protected static void env_putlicensepath(String string) {
        BaseModel.globalEnv().putlicensepath(string);
    }

    protected static void env_putlicensewait(boolean bl) {
        BaseModel.globalEnv().putlicensewait(bl ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseModel(Task task, String string, String string2, SolutionStruct solutionStruct, SolutionStruct solutionStruct2, SolutionStruct solutionStruct3) {
        this.modelname = string;
        this.task = task;
        boolean bl = false;
        try {
            task.putintparam(iparam.log_expand, 0);
            this.blx = new double[128];
            this.bux = new double[128];
            this.bkx = new boundkey[128];
            this.namex = new String[128];
            this.numx = 0;
            this.numflushedx = 0;
            this.sol_itr = solutionStruct != null ? solutionStruct.clone() : null;
            this.sol_bas = solutionStruct2 != null ? solutionStruct2.clone() : null;
            this.sol_itg = solutionStruct3 != null ? solutionStruct3.clone() : null;
            this.logwriter = null;
            task.set_Stream(streamtype.log, new Stream(){

                @Override
                public void stream(String string) {
                    if (BaseModel.this.logwriter != null) {
                        try {
                            BaseModel.this.logwriter.write(string);
                            BaseModel.this.logwriter.flush();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            task.set_Progress(this.breaksolve);
            bl = true;
        }
        finally {
            if (!bl) {
                task.dispose();
                task = null;
            }
        }
    }

    protected BaseModel(BaseModel baseModel) {
        this(new Task(baseModel.task), baseModel.modelname, null, baseModel.sol_itr, baseModel.sol_bas, baseModel.sol_itg);
    }

    protected BaseModel(String string, String string2) {
        this(new Task(BaseModel.globalEnv(), 0, 0), string, string2, null, null, null);
    }

    protected double task_get_dinf(String string) {
        dinfitem dinfitem2 = SolverInfo.getdouinf(string);
        if (dinfitem2 == null) {
            throw new NameError("Invalid double info name");
        }
        return this.task.getdouinf(dinfitem2);
    }

    protected int task_get_iinf(String string) {
        iinfitem iinfitem2 = SolverInfo.getintinf(string);
        if (iinfitem2 == null) {
            throw new NameError("Invalid integer info name");
        }
        return this.task.getintinf(iinfitem2);
    }

    protected long task_get_liinf(String string) {
        liinfitem liinfitem2 = SolverInfo.getlintinf(string);
        if (liinfitem2 == null) {
            throw new NameError("Invalid long integer info name");
        }
        return this.task.getlintinf(liinfitem2);
    }

    protected void task_put_param(String string, String string2) {
        this.task.putnastrparam(string, string2);
    }

    protected void task_put_param(String string, double d) {
        this.task.putnadouparam(string, d);
    }

    protected void task_put_param(String string, int n) {
        this.task.putnaintparam(string, n);
    }

    protected void task_setLogHandler(Writer writer) {
        this.logwriter = writer;
    }

    protected void task_setDataCallbackHandler(DataCallback dataCallback) {
        this.user_callback = dataCallback;
        this.task.set_Progress(dataCallback);
    }

    protected void task_setCallbackHandler(Progress progress) {
        this.user_progress = progress;
        this.task.set_Progress(progress);
    }

    protected void task_putarowslice(int n, int n2, long[] lArray, int[] nArray, double[] dArray) {
        this.synched = false;
        this.flushx();
        try {
            int n3 = n2 - n;
            int[] nArray2 = new int[n3];
            int[] nArray3 = new int[n3];
            int[] nArray4 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray4[i] = i + n;
                nArray2[i] = (int)lArray[i];
                nArray3[i] = (int)lArray[i + 1];
            }
            this.task.putarowlist(nArray4, nArray2, nArray3, nArray, dArray);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_putaijlist(int[] nArray, int[] nArray2, double[] dArray, long l) {
        double[] dArray2;
        int[] nArray3;
        int[] nArray4;
        this.synched = false;
        this.flushx();
        if ((long)nArray.length != l) {
            nArray4 = new int[(int)l];
            System.arraycopy(nArray, 0, nArray4, 0, (int)l);
        } else {
            nArray4 = nArray;
        }
        if ((long)nArray2.length != l) {
            nArray3 = new int[(int)l];
            System.arraycopy(nArray2, 0, nArray3, 0, (int)l);
        } else {
            nArray3 = nArray2;
        }
        if ((long)dArray.length != l) {
            dArray2 = new double[(int)l];
            System.arraycopy(dArray, 0, dArray2, 0, (int)l);
        } else {
            dArray2 = dArray;
        }
        try {
            this.task.putaijlist(nArray4, nArray3, dArray2);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected int task_append_barmatrix(int n, int[] nArray, int[] nArray2, double[] dArray) {
        return (int)this.task.appendsparsesymmat(n, nArray, nArray2, dArray);
    }

    protected void task_putbaraij(int n, int n2, int n3) {
        long[] lArray = new long[]{n3};
        double[] dArray = new double[]{1.0};
        this.task.putbaraij(n, n2, lArray, dArray);
    }

    protected void task_putbaraij(int n, int n2, int[] nArray) {
        long[] lArray = new long[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            lArray[i] = nArray[i];
        }
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = 1.0;
        }
        this.task.putbaraij(n, n2, lArray, dArray);
    }

    protected void task_putbarcj(int n, int n2) {
        long[] lArray = new long[]{n2};
        double[] dArray = new double[]{1.0};
        this.task.putbarcj(n, lArray, dArray);
    }

    protected void task_putbarcj(int n, int[] nArray) {
        long[] lArray = new long[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            lArray[i] = nArray[i];
        }
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = 1.0;
        }
        this.task.putbarcj(n, lArray, dArray);
    }

    protected void task_putobjectivename(String string) {
        try {
            if (string != null) {
                this.task.putobjname(string);
            } else {
                this.task.putobjname("");
            }
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_putobjective(boolean bl, int[] nArray, double[] dArray, double d) {
        this.synched = false;
        this.flushx();
        try {
            double[] dArray2 = new double[this.task.getnumvar()];
            int[] nArray2 = Tools.range(dArray2.length);
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                dArray2[n] = dArray2[n] + dArray[i];
            }
            this.task.putclist(nArray2, dArray2);
            this.task.putcfix(d);
            this.task.putobjsense(bl ? objsense.maximize : objsense.minimize);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_cleanup(int n, int n2, int n3, int n4) {
        try {
            Object[] objectArray;
            int n5 = this.task.getnumvar();
            int n6 = this.task.getnumcon();
            int n7 = this.task.getnumcone();
            int n8 = this.task.getnumbarvar();
            if (n3 < n7) {
                objectArray = Tools.range(n3, n7);
                this.task.removecones((int[])objectArray);
            }
            if (n < n5) {
                objectArray = new double[n5 - n];
                boundkey[] boundkeyArray = new boundkey[n5 - n];
                for (int i = 0; i < n5 - n; ++i) {
                    boundkeyArray[i] = boundkey.fx;
                }
                this.task.putvarboundslice(n, n5, boundkeyArray, (double[])objectArray, (double[])objectArray);
            }
            if (n2 < n6) {
                objectArray = Tools.range(n2, n6);
                this.task.removecons((int[])objectArray);
            }
            if (n4 < n8) {
                objectArray = Tools.range(n4, n8);
                this.task.removebarvars((int[])objectArray);
            }
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_write(String string) {
        try {
            this.flushxnames();
            this.flushx();
            this.task.putintparam(iparam.opf_write_solutions, 1);
            this.task.putintparam(iparam.write_ignore_incompatible_items, 1);
            this.task.writedata(string);
        }
        catch (MosekException mosekException) {
            mosekException.printStackTrace(System.out);
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected Task task_get() {
        return this.task;
    }

    private void convertSolutionStatus(soltype soltype2, SolutionStruct solutionStruct, solsta solsta2, prosta prosta2) {
        switch (solsta2) {
            case optimal: {
                solutionStruct.pstatus = SolutionStatus.Optimal;
                solutionStruct.dstatus = SolutionStatus.Optimal;
                break;
            }
            case near_optimal: {
                solutionStruct.pstatus = SolutionStatus.NearOptimal;
                solutionStruct.dstatus = SolutionStatus.NearOptimal;
                break;
            }
            case integer_optimal: {
                solutionStruct.pstatus = SolutionStatus.Optimal;
                solutionStruct.dstatus = SolutionStatus.Unknown;
                break;
            }
            case near_integer_optimal: {
                solutionStruct.pstatus = SolutionStatus.NearOptimal;
                solutionStruct.dstatus = SolutionStatus.Unknown;
                break;
            }
            case prim_and_dual_feas: {
                solutionStruct.pstatus = SolutionStatus.Feasible;
                solutionStruct.dstatus = SolutionStatus.Feasible;
                break;
            }
            case near_prim_and_dual_feas: {
                solutionStruct.pstatus = SolutionStatus.NearFeasible;
                solutionStruct.dstatus = SolutionStatus.NearFeasible;
                break;
            }
            case prim_feas: {
                solutionStruct.pstatus = SolutionStatus.Feasible;
                solutionStruct.dstatus = SolutionStatus.Unknown;
                break;
            }
            case near_prim_feas: {
                solutionStruct.pstatus = SolutionStatus.NearFeasible;
                solutionStruct.dstatus = SolutionStatus.Unknown;
                break;
            }
            case dual_feas: {
                solutionStruct.pstatus = SolutionStatus.Unknown;
                solutionStruct.dstatus = SolutionStatus.Feasible;
                break;
            }
            case near_dual_feas: {
                solutionStruct.pstatus = SolutionStatus.Unknown;
                solutionStruct.dstatus = SolutionStatus.NearFeasible;
                break;
            }
            case prim_infeas_cer: {
                solutionStruct.pstatus = SolutionStatus.Unknown;
                solutionStruct.dstatus = SolutionStatus.Certificate;
                break;
            }
            case near_prim_infeas_cer: {
                solutionStruct.pstatus = SolutionStatus.Unknown;
                solutionStruct.dstatus = SolutionStatus.NearCertificate;
                break;
            }
            case dual_infeas_cer: {
                solutionStruct.pstatus = SolutionStatus.Certificate;
                solutionStruct.dstatus = SolutionStatus.Unknown;
                break;
            }
            case near_dual_infeas_cer: {
                solutionStruct.pstatus = SolutionStatus.NearCertificate;
                solutionStruct.dstatus = SolutionStatus.Unknown;
                break;
            }
            case prim_illposed_cer: {
                solutionStruct.pstatus = SolutionStatus.Unknown;
                solutionStruct.dstatus = SolutionStatus.IllposedCert;
                break;
            }
            case dual_illposed_cer: {
                solutionStruct.pstatus = SolutionStatus.IllposedCert;
                solutionStruct.dstatus = SolutionStatus.Unknown;
                break;
            }
            default: {
                solutionStruct.pstatus = SolutionStatus.Unknown;
                solutionStruct.dstatus = SolutionStatus.Unknown;
            }
        }
        switch (prosta2) {
            case unknown: {
                solutionStruct.probstatus = ProblemStatus.Unknown;
                break;
            }
            case prim_and_dual_feas: {
                solutionStruct.probstatus = ProblemStatus.PrimalAndDualFeasible;
                break;
            }
            case prim_feas: {
                solutionStruct.probstatus = ProblemStatus.PrimalFeasible;
                break;
            }
            case dual_feas: {
                solutionStruct.probstatus = ProblemStatus.DualFeasible;
                break;
            }
            case prim_infeas: {
                solutionStruct.probstatus = ProblemStatus.PrimalInfeasible;
                break;
            }
            case dual_infeas: {
                solutionStruct.probstatus = ProblemStatus.DualInfeasible;
                break;
            }
            case prim_and_dual_infeas: {
                solutionStruct.probstatus = ProblemStatus.PrimalAndDualInfeasible;
                break;
            }
            case ill_posed: {
                solutionStruct.probstatus = ProblemStatus.IllPosed;
                break;
            }
            case near_prim_and_dual_feas: {
                solutionStruct.probstatus = ProblemStatus.PrimalAndDualInfeasible;
                break;
            }
            case near_prim_feas: {
                solutionStruct.probstatus = ProblemStatus.PrimalInfeasible;
                break;
            }
            case near_dual_feas: {
                solutionStruct.probstatus = ProblemStatus.DualInfeasible;
                break;
            }
            case prim_infeas_or_unbounded: {
                solutionStruct.probstatus = ProblemStatus.PrimalInfeasibleOrUnbounded;
                break;
            }
            default: {
                solutionStruct.probstatus = ProblemStatus.Unknown;
            }
        }
    }

    protected void task_break_solve() {
        this.breaksolve.setbreak(true);
    }

    protected void task_solve() throws OptimizeError {
        boolean bl = false;
        this.synched = false;
        this.flushx();
        try {
            int n;
            int n2;
            rescode rescode2 = rescode.ok;
            try {
                this.breaksolve.setbreak(false);
                rescode2 = this.task.optimize();
                this.task.solutionsummary(streamtype.log);
            }
            catch (Error error) {
                throw new OptimizeError(error.toString());
            }
            catch (Warning warning) {
                // empty catch block
            }
            int n3 = this.task.getnumcon();
            int n4 = this.task.getnumvar();
            int n5 = this.task.getnumcone();
            int n6 = this.task.getnumbarvar();
            boolean bl2 = this.task.solutiondef(soltype.bas);
            boolean bl3 = this.task.solutiondef(soltype.itr);
            boolean bl4 = this.task.solutiondef(soltype.itg);
            this.sol_itr = null;
            this.sol_bas = null;
            this.sol_itg = null;
            prosta[] prostaArray = new prosta[1];
            solsta[] solstaArray = new solsta[1];
            double[] dArray = new double[1];
            if (bl3) {
                this.sol_itr = new SolutionStruct(n4, n3, n5, n6);
                this.task.getsolution(soltype.itr, prostaArray, solstaArray, null, null, null, this.sol_itr.xc, this.sol_itr.xx, this.sol_itr.y, this.sol_itr.slc, this.sol_itr.suc, this.sol_itr.slx, this.sol_itr.sux, this.sol_itr.snx);
                if (n6 > 0) {
                    for (n2 = 0; n2 < n6; ++n2) {
                        n = this.task.getdimbarvarj(n2);
                        this.sol_itr.barx[n2] = new double[n * (n + 1) / 2];
                        this.sol_itr.bars[n2] = new double[n * (n + 1) / 2];
                        this.task.getbarxj(soltype.itr, n2, this.sol_itr.barx[n2]);
                        this.task.getbarsj(soltype.itr, n2, this.sol_itr.bars[n2]);
                    }
                }
                this.task.getprimalobj(soltype.itr, dArray);
                this.sol_itr.pobj = dArray[0];
                this.task.getdualobj(soltype.itr, dArray);
                this.sol_itr.dobj = dArray[0];
                this.convertSolutionStatus(soltype.itr, this.sol_itr, solstaArray[0], prostaArray[0]);
            }
            if (bl2) {
                this.sol_bas = new SolutionStruct(n4, n3, n5, n6);
                this.task.getsolution(soltype.bas, prostaArray, solstaArray, null, null, null, this.sol_bas.xc, this.sol_bas.xx, this.sol_bas.y, this.sol_bas.slc, this.sol_bas.suc, this.sol_bas.slx, this.sol_bas.sux, this.sol_bas.snx);
                if (n6 > 0) {
                    for (n2 = 0; n2 < n6; ++n2) {
                        n = this.task.getdimbarvarj(n2);
                        this.sol_bas.barx[n2] = new double[n * (n + 1) / 2];
                        this.sol_bas.bars[n2] = new double[n * (n + 1) / 2];
                        this.task.getbarxj(soltype.bas, n2, this.sol_bas.barx[n2]);
                        this.task.getbarsj(soltype.bas, n2, this.sol_bas.bars[n2]);
                    }
                }
                this.task.getprimalobj(soltype.bas, dArray);
                this.sol_bas.pobj = dArray[0];
                this.task.getdualobj(soltype.bas, dArray);
                this.sol_bas.dobj = dArray[0];
                this.convertSolutionStatus(soltype.bas, this.sol_bas, solstaArray[0], prostaArray[0]);
            }
            if (bl4) {
                this.sol_itg = new SolutionStruct(n4, n3, n5, n6);
                this.task.getsolution(soltype.itg, prostaArray, solstaArray, null, null, null, this.sol_itg.xc, this.sol_itg.xx, null, null, null, null, null, null);
                if (n6 > 0) {
                    for (n2 = 0; n2 < n6; ++n2) {
                        n = this.task.getdimbarvarj(n2);
                        this.sol_itg.barx[n2] = new double[n * (n + 1) / 2];
                        this.sol_itg.bars[n2] = new double[n * (n + 1) / 2];
                        this.task.getbarxj(soltype.itg, n2, this.sol_itg.barx[n2]);
                        this.task.getbarsj(soltype.itg, n2, this.sol_itg.bars[n2]);
                    }
                }
                this.task.getprimalobj(soltype.itg, dArray);
                this.sol_itg.pobj = dArray[0];
                this.convertSolutionStatus(soltype.itg, this.sol_itg, solstaArray[0], prostaArray[0]);
            }
            bl = true;
            this.synched = true;
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
        finally {
            if (!bl) {
                this.sol_itr = null;
                this.sol_bas = null;
                this.sol_itg = null;
            }
        }
    }

    protected int task_barvardim(int n) {
        return this.task.getdimbarvarj(n);
    }

    protected int task_numbarvar() {
        try {
            return this.task.getnumbarvar();
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected int task_numcon() {
        try {
            return this.task.getnumcon();
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected int task_numvar() {
        try {
            return this.numx;
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected int task_numcone() {
        try {
            return this.task.getnumcone();
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_con_name(int n, String string) {
        try {
            this.task.putconname(n, string);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_var_name(int n, String string) {
        try {
            this.namex[n] = string;
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_cone_name(int n, String string) {
        try {
            this.task.putconename(n, string);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_barvar_name(int n, String string) {
        try {
            this.task.putbarvarname(n, string);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_putc(int[] nArray, double[] dArray, double d) {
        this.synched = false;
        this.flushx();
        try {
            int n;
            int n2 = this.task.getnumvar();
            int[] nArray2 = new int[n2];
            double[] dArray2 = new double[n2];
            for (n = 0; n < n2; ++n) {
                nArray2[n] = n;
            }
            for (n = 0; n < nArray.length; ++n) {
                dArray2[nArray[n]] = dArray[n];
            }
            this.task.putclist(nArray2, dArray2);
            this.task.putcfix(d);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    private void task_putboundslice(accmode accmode2, int n, int n2, double[] dArray, double[] dArray2, boundkey boundkey2) {
        this.synched = false;
        this.flushx();
        int n3 = n2 - n;
        boundkey[] boundkeyArray = new boundkey[n3];
        for (int i = 0; i < n3; ++i) {
            boundkeyArray[i] = boundkey2;
        }
        if (dArray == null && dArray2 == null) {
            dArray = new double[n3];
            dArray2 = dArray;
        }
        try {
            this.task.putboundslice(accmode2, n, n2, boundkeyArray, dArray, dArray2);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    private void task_putboundlist(accmode accmode2, int[] nArray, double[] dArray, double[] dArray2, boundkey boundkey2) {
        this.synched = false;
        this.flushx();
        int n = nArray.length;
        if (dArray == null) {
            dArray = new double[n];
        }
        if (dArray2 == null) {
            dArray2 = new double[n];
        }
        boundkey[] boundkeyArray = new boundkey[n];
        for (int i = 0; i < n; ++i) {
            boundkeyArray[i] = boundkey2;
        }
        try {
            this.task.putboundlist(accmode2, nArray, boundkeyArray, dArray, dArray2);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_con_putboundslice_fx(int n, int n2, double[] dArray) {
        this.synched = false;
        this.task_putboundslice(accmode.con, n, n2, dArray, dArray, boundkey.fx);
    }

    protected void task_con_putboundslice_lo(int n, int n2, double[] dArray) {
        this.synched = false;
        this.task_putboundslice(accmode.con, n, n2, dArray, dArray, boundkey.lo);
    }

    protected void task_con_putboundslice_up(int n, int n2, double[] dArray) {
        this.synched = false;
        this.task_putboundslice(accmode.con, n, n2, dArray, dArray, boundkey.up);
    }

    protected void task_con_putboundslice_ra(int n, int n2, double[] dArray, double[] dArray2) {
        this.synched = false;
        this.task_putboundslice(accmode.con, n, n2, dArray, dArray2, boundkey.ra);
    }

    protected void task_con_putboundslice_fr(int n, int n2) {
        this.synched = false;
        this.task_putboundslice(accmode.con, n, n2, null, null, boundkey.fr);
    }

    protected void task_var_putboundslice_fx(int n, int n2, double[] dArray) {
        this.synched = false;
        this.task_putboundslice(accmode.var, n, n2, dArray, dArray, boundkey.fx);
    }

    protected void task_var_putboundslice_lo(int n, int n2, double[] dArray) {
        this.synched = false;
        this.task_putboundslice(accmode.var, n, n2, dArray, dArray, boundkey.lo);
    }

    protected void task_var_putboundslice_up(int n, int n2, double[] dArray) {
        this.synched = false;
        this.task_putboundslice(accmode.var, n, n2, dArray, dArray, boundkey.up);
    }

    protected void task_var_putboundslice_ra(int n, int n2, double[] dArray, double[] dArray2) {
        this.synched = false;
        this.task_putboundslice(accmode.var, n, n2, dArray, dArray2, boundkey.ra);
    }

    protected void task_var_putboundslice_fr(int n, int n2) {
        this.synched = false;
        this.task_putboundslice(accmode.var, n, n2, null, null, boundkey.fr);
    }

    protected void task_con_putboundlist_fx(int[] nArray, double[] dArray) {
        this.task_putboundlist(accmode.con, nArray, dArray, dArray, boundkey.fx);
    }

    protected void task_con_putboundlist_lo(int[] nArray, double[] dArray) {
        this.task_putboundlist(accmode.con, nArray, dArray, dArray, boundkey.lo);
    }

    protected void task_con_putboundlist_up(int[] nArray, double[] dArray) {
        this.task_putboundlist(accmode.con, nArray, dArray, dArray, boundkey.up);
    }

    protected void task_con_putboundlist_ra(int[] nArray, double[] dArray, double[] dArray2) {
        this.flushx();
        this.task_putboundlist(accmode.con, nArray, dArray, dArray2, boundkey.ra);
    }

    protected int task_append_var(int n) {
        return this.addx(n);
    }

    protected int task_append_barvar(int n, int n2) {
        try {
            int n3 = this.task.getnumbarvar();
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = n;
            }
            this.task.appendbarvars(nArray);
            return n3;
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected int task_append_con(int n) {
        try {
            int n2 = this.task.getnumcon();
            this.task.appendcons(n);
            return n2;
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    private int task_append_qcone(conetype conetype2, int n, int n2, int n3, int n4, int n5) {
        this.flushx();
        try {
            int n6 = this.task.getnumcone();
            int[] nArray = new int[n];
            for (int i = 0; i < n4; ++i) {
                int n7;
                for (n7 = 0; n7 < n; ++n7) {
                    nArray[n7] = n5 * (n7 + i * n) + n2;
                }
                for (n7 = 0; n7 < n5; ++n7) {
                    this.task.appendcone(conetype2, 0.0, nArray);
                    int n8 = 0;
                    while (n8 < n) {
                        int n9 = n8++;
                        nArray[n9] = nArray[n9] + n5;
                    }
                }
            }
            return n6;
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected int task_append_quadcone(int n, int n2, int n3, int n4, int n5) {
        return this.task_append_qcone(conetype.quad, n, n2, n3, n4, n5);
    }

    protected int task_append_rquadcone(int n, int n2, int n3, int n4, int n5) {
        return this.task_append_qcone(conetype.rquad, n, n2, n3, n4, n5);
    }

    protected void task_var_putintlist(int[] nArray) {
        this.flushx();
        try {
            variabletype[] variabletypeArray = new variabletype[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                variabletypeArray[i] = variabletype.type_int;
            }
            this.task.putvartypelist(nArray, variabletypeArray);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_var_putcontlist(int[] nArray) {
        this.flushx();
        try {
            variabletype[] variabletypeArray = new variabletype[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                variabletypeArray[i] = variabletype.type_cont;
            }
            this.task.putvartypelist(nArray, variabletypeArray);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_putxx_slice(SolutionType solutionType, int n, int n2, double[] dArray) {
        this.flushx();
        switch (solutionType) {
            case Interior: {
                this.task.putxxslice(soltype.itr, n, n2, dArray);
                break;
            }
            case Integer: {
                this.task.putxxslice(soltype.itg, n, n2, dArray);
                break;
            }
            case Basic: {
                this.task.putxxslice(soltype.bas, n, n2, dArray);
            }
        }
    }

    public void dispose() {
        if (this.task != null) {
            Task task = this.task;
            this.task = null;
            task.dispose();
            --env_counter;
            task.dispose();
        }
    }

    protected void finalize() {
        this.dispose();
    }

    @Override
    public void close() {
        this.dispose();
    }
}

