/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.CompoundVariable;
import mosek.fusion.DimensionError;
import mosek.fusion.IntSet;
import mosek.fusion.LengthError;
import mosek.fusion.Model;
import mosek.fusion.ModelError;
import mosek.fusion.NDSet;
import mosek.fusion.NilVariable;
import mosek.fusion.RepeatVariable;
import mosek.fusion.Set;
import mosek.fusion.SliceVariable;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Variable;

public class Var {
    public static Variable compress(Variable variable) {
        int n = variable.getShape().realnd();
        if (n == variable.getShape().nd) {
            return variable;
        }
        if (n == 1) {
            return Var.reshape(variable, (int)variable.getShape().size);
        }
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = variable.getShape().nd;
        for (int i = n3; i < n4; ++i) {
            if (variable.getShape()._dim(i) <= 1) continue;
            nArray[n2] = variable.getShape()._dim(i);
            ++n2;
        }
        return Var.reshape(variable, new NDSet(nArray));
    }

    public static Variable reshape(Variable variable, int n) {
        if ((long)n != variable.getShape().size) {
            throw new DimensionError("New shape has wrong number of elements");
        }
        return new SliceVariable(variable, new IntSet(n), 0L, new long[]{1L});
    }

    public static Variable reshape(Variable variable, int n, int n2) {
        if ((long)(n * n2) != variable.getShape().size) {
            throw new DimensionError("New shape has wrong number of elements");
        }
        return new SliceVariable(variable, new NDSet(n, n2), 0L, new long[]{n2, 1L});
    }

    public static Variable flatten(Variable variable) {
        if (variable.getShape().nd == 1) {
            return variable;
        }
        return Var.reshape(variable, Set.make((int)variable.getShape().size));
    }

    public static Variable reshape(Variable variable, int[] nArray) {
        Set set = Set.make(nArray);
        return Var.reshape(variable, set);
    }

    public static Variable reshape(Variable variable, Set set) {
        if (set.size != variable.getShape().size) {
            throw new DimensionError("New shape has wrong number of elements");
        }
        int n = 0;
        int n2 = 0;
        int n3 = set.nd;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        long[] lArray = new long[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            lArray[n] = set.stride(n5);
            ++n;
            ++n6;
            ++n5;
        }
        return new SliceVariable(variable, set, 0L, lArray);
    }

    public static Variable reshape_(Variable variable, Set set) {
        int n = 0;
        int n2 = 0;
        int n3 = set.nd;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        long[] lArray = new long[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            lArray[n] = set.stride(n5);
            ++n;
            ++n6;
            ++n5;
        }
        long[] lArray2 = lArray;
        return new SliceVariable(variable, set, 0L, lArray2);
    }

    public static Variable index_flip_(Variable variable, int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = variable.getShape().nd;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        long[] lArray = new long[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            lArray[n] = variable.getShape().stride(n5);
            ++n;
            ++n6;
            ++n5;
        }
        long[] lArray2 = lArray;
        int n7 = 0;
        int n8 = 0;
        int n9 = variable.getShape().nd;
        int n10 = n8 < n9 ? n9 - n8 : 0;
        int[] nArray2 = new int[n10];
        int n11 = n8;
        int n12 = 0;
        while (n12 < n10) {
            nArray2[n7] = variable.getShape()._dim(n11);
            ++n7;
            ++n12;
            ++n11;
        }
        int[] nArray3 = nArray2;
        long l = 0L;
        int n13 = 0;
        int n14 = nArray.length;
        for (int i = n13; i < n14; ++i) {
            l += lArray2[nArray[i]] * (long)(nArray3[i] - 1);
            lArray2[nArray3[i]] = -lArray2[nArray3[i]];
        }
        return new SliceVariable(variable, variable.getShape(), 0L, lArray2);
    }

    public static Variable index_permute_(Variable variable, int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = variable.getShape().nd;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        long[] lArray = new long[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            lArray[n] = variable.getShape().stride(nArray[n5]);
            ++n;
            ++n6;
            ++n5;
        }
        long[] lArray2 = lArray;
        int n7 = 0;
        int n8 = 0;
        int n9 = variable.getShape().nd;
        int n10 = n8 < n9 ? n9 - n8 : 0;
        int[] nArray2 = new int[n10];
        int n11 = n8;
        int n12 = 0;
        while (n12 < n10) {
            nArray2[n7] = variable.getShape()._dim(nArray[n11]);
            ++n7;
            ++n12;
            ++n11;
        }
        int[] nArray3 = nArray2;
        return new SliceVariable(variable, new NDSet(nArray3), 0L, lArray2);
    }

    public static Variable hrepeat(Variable variable, int n) {
        return Var.drepeat(variable, 1, n);
    }

    public static Variable vrepeat(Variable variable, int n) {
        return Var.drepeat(variable, 0, n);
    }

    public static Variable repeat(Variable variable, int n) {
        return Var.drepeat(variable, 0, n);
    }

    public static Variable repeat(Variable variable, int n, int n2) {
        return Var.drepeat(variable, n, n2);
    }

    public static Variable drepeat(Variable variable, int n, int n2) {
        if (n2 < 0) {
            throw new LengthError("Cannot repeat less than 0 times");
        }
        if (n2 == 0) {
            return new NilVariable();
        }
        if (n2 == 1) {
            return variable;
        }
        return new RepeatVariable(variable, n, n2);
    }

    public static Variable stack(Variable[][] variableArray) {
        int n;
        int n2;
        int n3;
        Model model = null;
        int n4 = 0;
        int n5 = variableArray.length;
        for (n3 = n4; n3 < n5; ++n3) {
            n2 = 0;
            n = variableArray[n3].length;
            for (int i = n2; i < n; ++i) {
                if (model == null) {
                    model = variableArray[n3][i].getModel();
                    continue;
                }
                if (variableArray[n3][i].getModel() == null || variableArray[n3][i].getModel() == model) continue;
                throw new ModelError("Variables belong to different models");
            }
        }
        int n6 = 0;
        n4 = 0;
        n5 = variableArray.length;
        for (n3 = n4; n3 < n5; ++n3) {
            if (variableArray[n3].length <= 0) continue;
            ++n6;
        }
        Variable[] variableArray2 = new Variable[n6];
        if (n6 == 0) {
            return new NilVariable();
        }
        n5 = 0;
        n3 = 0;
        n2 = variableArray.length;
        for (n = n3; n < n2; ++n) {
            int n7;
            if (variableArray[n].length == 0) continue;
            if (variableArray[n].length == 1) {
                Variable variable = variableArray[n][0];
                variableArray2[n5] = variable.getShape().nd == 1 ? Var.reshape(variable, variable.getShape()._dim(0), 1) : variable;
                ++n5;
                continue;
            }
            int n8 = 0;
            int n9 = 0;
            int n10 = variableArray[n].length;
            for (n7 = n9; n7 < n10; ++n7) {
                if (variableArray[n][n7].getShape().size <= 0L) continue;
                ++n8;
            }
            Variable[] variableArray3 = new Variable[n8];
            n10 = 0;
            n7 = 0;
            int n11 = variableArray[n].length;
            for (int i = n7; i < n11; ++i) {
                Variable variable = variableArray[n][i];
                if (variable.getShape().size <= 0L) continue;
                variableArray3[n10] = variable.getShape().nd == 1 ? Var.reshape(variable, variable.getShape()._dim(0), 1) : variable;
                ++n10;
            }
            variableArray2[n5] = new CompoundVariable(variableArray3, 1);
            ++n5;
        }
        return variableArray2.length == 1 ? variableArray2[0] : new CompoundVariable(variableArray2, 0);
    }

    public static Variable vstack(Variable variable, Variable variable2, Variable variable3) {
        return Var.dstack(new Variable[]{variable, variable2, variable3}, 0);
    }

    public static Variable vstack(Variable variable, Variable variable2) {
        return Var.dstack(new Variable[]{variable, variable2}, 0);
    }

    public static Variable vstack(Variable[] variableArray) {
        return Var.dstack(variableArray, 0);
    }

    public static Variable hstack(Variable variable, Variable variable2, Variable variable3) {
        return Var.dstack(new Variable[]{variable, variable2, variable3}, 1);
    }

    public static Variable hstack(Variable variable, Variable variable2) {
        return Var.dstack(new Variable[]{variable, variable2}, 1);
    }

    public static Variable hstack(Variable[] variableArray) {
        return Var.dstack(variableArray, 1);
    }

    public static Variable stack(Variable variable, Variable variable2, Variable variable3, int n) {
        return Var.dstack(new Variable[]{variable, variable2, variable3}, n);
    }

    public static Variable stack(Variable variable, Variable variable2, int n) {
        return Var.dstack(new Variable[]{variable, variable2}, n);
    }

    public static Variable stack(Variable[] variableArray, int n) {
        return Var.dstack(variableArray, n);
    }

    public static Variable dstack(Variable[] variableArray, int n) {
        int n2;
        int n3;
        Model model = null;
        int n4 = 0;
        int n5 = variableArray.length;
        for (n3 = n4; n3 < n5; ++n3) {
            if (model == null) {
                model = variableArray[n3].getModel();
                continue;
            }
            if (variableArray[n3].getModel() == null || variableArray[n3].getModel() == model) continue;
            StringBuffer stringBuffer = new StringBuffer();
            String string = model.getName().length() > 0 ? model.getName() : "?";
            String string2 = variableArray[n3].getModel().getName().length() > 0 ? variableArray[n3].getModel().getName() : "?";
            stringBuffer.a("Variables belong to different models: '").a(string).a("' and '").a(string2).a("'");
            throw new ModelError(stringBuffer.toString());
        }
        if (variableArray.length == 0) {
            return new NilVariable();
        }
        if (variableArray.length == 1) {
            return variableArray[1];
        }
        int n6 = variableArray.length;
        n4 = n + 1;
        n5 = 0;
        n3 = n6;
        for (n2 = n5; n2 < n3; ++n2) {
            if (variableArray[n2].getShape().nd <= n4) continue;
            n4 = variableArray[n2].getShape().nd;
        }
        n5 = 0;
        n3 = 0;
        n2 = n4;
        int n7 = n3 < n2 ? n2 - n3 : 0;
        int[] nArray = new int[n7];
        int n8 = n3;
        int n9 = 0;
        while (n9 < n7) {
            nArray[n5] = variableArray[0].getShape()._dim(n8);
            ++n5;
            ++n9;
            ++n8;
        }
        int[] nArray2 = nArray;
        Variable[] variableArray2 = new Variable[n6];
        variableArray2[0] = Var.reshape(variableArray[0], new NDSet(nArray2));
        int n10 = 1;
        int n11 = n6;
        for (int i = n10; i < n11; ++i) {
            int n12 = 0;
            int n13 = n4;
            for (int j = n12; j < n13; ++j) {
                if (j == n || variableArray[i].getShape()._dim(j) == nArray2[j]) continue;
                throw new DimensionError("Variable dimensions do not match");
            }
            nArray2[n] = variableArray[i].getShape()._dim(n);
            variableArray2[i] = Var.reshape(variableArray[i], new NDSet(nArray2));
        }
        return new CompoundVariable(variableArray2, n);
    }
}

