/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import com.mosek.monty.Util;
import mosek.fusion.CommonTools;
import mosek.fusion.IndexError;
import mosek.fusion.LengthError;
import mosek.fusion.Matrix;
import mosek.fusion.SparseFormatError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;

public class SparseMatrix
extends Matrix {
    protected long nnz;
    protected double[] val;
    protected int[] subj;
    protected int[] subi;

    protected SparseMatrix(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, long l) {
        super(n, n2);
        if (l > 0L) {
            if ((long)nArray.length < l || (long)nArray2.length < l || (long)dArray.length < l) {
                throw new SparseFormatError("Mismatching arrays in sparse data.");
            }
            long l2 = 0L;
            long l3 = l;
            for (long i = l2; i < l3; ++i) {
                if (nArray[(int)i] >= 0 && nArray[(int)i] < this.dimi && nArray2[(int)i] >= 0 && nArray2[(int)i] < this.dimj) continue;
                throw new SparseFormatError("Subscript out of bounds.");
            }
            int[][] nArrayArray = new int[1][];
            int[][] nArrayArray2 = new int[1][];
            double[][] dArrayArray = new double[1][];
            CommonTools.tripletSort(nArray, nArray2, dArray, nArrayArray, nArrayArray2, dArrayArray, l, this.dimi, this.dimj);
            this.subi = nArrayArray[0];
            this.subj = nArrayArray2[0];
            this.val = dArrayArray[0];
            this.nnz = this.val.length;
        } else {
            this.subi = new int[0];
            this.subj = new int[0];
            this.val = new double[0];
            this.nnz = 0L;
        }
    }

    protected SparseMatrix(int n, int n2, int[] nArray, int[] nArray2, double[] dArray) {
        super(n, n2);
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = dArray.length;
        for (n3 = n5; n3 < n6; ++n3) {
            if (!(dArray[n3] > 0.0) && !(dArray[n3] < 0.0)) continue;
            ++n4;
        }
        if (n4 > 0 && n4 < nArray.length) {
            this.subi = new int[n4];
            this.subj = new int[n4];
            this.val = new double[n4];
            this.nnz = n4;
            n5 = 0;
            n6 = 0;
            n3 = dArray.length;
            for (int i = n6; i < n3; ++i) {
                if (!(dArray[i] < 0.0) && !(dArray[i] > 0.0)) continue;
                this.val[n5] = dArray[i];
                this.subj[n5] = nArray2[i];
                this.subi[n5] = nArray[i];
                ++n5;
            }
        } else {
            this.subi = nArray;
            this.subj = nArray2;
            this.val = dArray;
            this.nnz = nArray == null ? 0L : (long)this.subi.length;
        }
    }

    public long[] formPtrb() {
        long[] lArray = new long[this.dimi + 1];
        long l = 0L;
        int n = 0;
        int n2 = this.dimi;
        for (int i = n; i < n2; ++i) {
            lArray[i] = l;
            while (l < this.nnz && this.subi[(int)l] == i && l < this.nnz && this.subi[(int)l] == i) {
                ++l;
            }
        }
        lArray[this.dimi] = l;
        return lArray;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("SparseMatrix(").a(this.dimi).a(",").a(this.dimj).a(", [");
        if (this.subi != null && this.subi.length > 0) {
            stringBuffer.a("(").a(this.subi[0]).a(",").a(this.subj[0]).a(",").a(this.val[0]).a(")");
            int n = 1;
            int n2 = this.subi.length;
            for (int i = n; i < n2; ++i) {
                stringBuffer.a(",(").a(this.subi[i]).a(",").a(this.subj[i]).a(",").a(this.val[i]).a(")");
            }
        }
        stringBuffer.a(" ])");
        return stringBuffer.toString();
    }

    @Override
    public long numNonzeros() {
        return this.nnz;
    }

    @Override
    public Matrix transpose() {
        return Matrix._sparse(this.dimj, this.dimi, this.subj, this.subi, this.val);
    }

    @Override
    public boolean isSparse() {
        return true;
    }

    @Override
    public double[] getDataAsArray() {
        double[] dArray = new double[this.dimi * this.dimj];
        int n = 0;
        int n2 = this.subi.length;
        for (int i = n; i < n2; ++i) {
            dArray[this.subi[i] * this.dimj + this.subj[i]] = this.val[i];
        }
        return dArray;
    }

    @Override
    public void _getDataAsTriplets(int[] nArray, int[] nArray2, double[] dArray) throws LengthError {
        if ((long)nArray.length < this.nnz || (long)nArray2.length < this.nnz || (long)dArray.length < this.nnz) {
            throw new LengthError("Output arrays are not long enough.");
        }
        if (this.subi != null && this.subi.length > 0) {
            Tools.arraycopy(this.subi, 0L, nArray, 0L, this.nnz);
            Tools.arraycopy(this.subj, 0L, nArray2, 0L, this.nnz);
            Tools.arraycopy(this.val, 0L, dArray, 0L, this.nnz);
        }
    }

    @Override
    public void getDataAsTriplets(int[] nArray, int[] nArray2, double[] dArray) throws LengthError {
        int[] nArray3 = Util.fromMatlab(nArray);
        int[] nArray4 = Util.fromMatlab(nArray2);
        this._getDataAsTriplets(nArray3, nArray4, dArray);
        Util.toMatlab(nArray, nArray3);
        Util.toMatlab(nArray2, nArray4);
    }

    @Override
    public double get(int n, int n2) {
        if (n < 0 || n >= this.dimi || n2 < 0 || n2 >= this.dimj) {
            throw new IndexError("Index out if bounds");
        }
        int n3 = 0;
        int n4 = this.subi.length;
        while (n4 - n3 > 1) {
            int n5 = (n3 + n4) / 2;
            if (this.subi[n5] < n || this.subi[n5] == n && this.subj[n5] < n2) {
                n3 = n5;
                continue;
            }
            if (this.subi[n5] > n || this.subi[n5] == n && this.subj[n5] > n2) {
                n4 = n5;
                continue;
            }
            return this.val[n5];
        }
        if (this.subi[n3] == n && this.subj[n3] == n2) {
            return this.val[n3];
        }
        return 0.0;
    }
}

