/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import com.mosek.monty.Util;
import mosek.fusion.BaseVariable;
import mosek.fusion.DimensionError;
import mosek.fusion.LengthError;
import mosek.fusion.Model;
import mosek.fusion.Set;
import mosek.fusion.SliceVariable;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Variable;

public abstract class ModelVariable
extends BaseVariable {
    protected long varid;
    protected String name;

    protected ModelVariable(ModelVariable modelVariable, Model model) {
        super(modelVariable, model);
        this.name = modelVariable.name;
        this.varid = modelVariable.varid;
    }

    protected ModelVariable(Model model, String string, Set set, long l) {
        super(model, set);
        this.name = string;
        this.varid = l;
    }

    public abstract void flushNames();

    @Override
    public void elementName(long l, StringBuffer stringBuffer) {
        stringBuffer.a(this.name.length() == 0 ? "_" : this.name).a("[").a(this.shape_p.indexToString(l)).a("]");
    }

    @Override
    public Variable _slice(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new LengthError("Mismatching array lengths");
        }
        Set set = this.shape_p._slice(nArray, nArray2);
        long[] lArray = new long[this.shape_p.nd];
        lArray[this.shape_p.nd - 1] = 1L;
        for (int i = this.shape_p.nd - 1; i > 0 && i > 0; --i) {
            lArray[i - 1] = lArray[i] * (long)this.shape_p._dim(i);
        }
        long l = 0L;
        for (int i = 0; i < lArray.length && i < lArray.length; ++i) {
            l += lArray[i] * (long)nArray[i];
        }
        return new SliceVariable(this, set, l, lArray);
    }

    @Override
    public Variable slice(int[] nArray, int[] nArray2) {
        int[] nArray3 = Util.fromMatlab(nArray);
        int[] nArray4 = Util.fromMatlab(nArray2);
        Variable variable = this._slice(nArray3, nArray4);
        Util.toMatlab(nArray, nArray3);
        Util.toMatlab(nArray2, nArray4);
        return variable;
    }

    @Override
    public Variable _slice(int n, int n2) {
        if (this.shape_p.nd != 1) {
            throw new DimensionError("Wrong size of slice");
        }
        long[] lArray = new long[]{1L};
        return new SliceVariable(this, this.shape_p._slice(n, n2), n, lArray);
    }

    @Override
    public Variable slice(int n, int n2) {
        int n3 = Util.fromMatlab(n);
        int n4 = Util.fromMatlab(n2);
        Variable variable = this._slice(n3, n4);
        return variable;
    }

    public abstract ModelVariable clone(Model var1);
}

