/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import com.mosek.monty.Util;
import mosek.fusion.DenseMatrix;
import mosek.fusion.DimensionError;
import mosek.fusion.LengthError;
import mosek.fusion.MatrixError;
import mosek.fusion.SparseFormatError;
import mosek.fusion.SparseMatrix;
import mosek.fusion.Utils.Tools;

public abstract class Matrix {
    protected int dimj;
    protected int dimi;

    protected Matrix(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new DimensionError("Invalid dimensions");
        }
        this.dimi = n;
        this.dimj = n2;
    }

    public String toString() {
        return "";
    }

    public void switchDims() {
        int n = this.dimi;
        this.dimi = this.dimj;
        this.dimj = n;
    }

    public static Matrix diag(int n, Matrix matrix) {
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        int n5 = n3 < n4 ? n4 - n3 : 0;
        Matrix[] matrixArray = new Matrix[n5];
        int n6 = n3;
        int n7 = 0;
        while (n7 < n5) {
            matrixArray[n2] = matrix;
            ++n2;
            ++n7;
            ++n6;
        }
        return Matrix.diag(matrixArray);
    }

    public static Matrix diag(Matrix[] matrixArray) {
        Matrix[] matrixArray2 = matrixArray;
        long l = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = matrixArray.length;
        for (int i = n3; i < n4; ++i) {
            n += matrixArray[i].dimi;
            n2 += matrixArray[i].dimj;
            l += matrixArray[i].numNonzeros();
        }
        int[] nArray = new int[(int)l];
        int[] nArray2 = new int[(int)l];
        double[] dArray = new double[(int)l];
        int n5 = 0;
        int n6 = 0;
        long l2 = 0L;
        int n7 = 0;
        int n8 = matrixArray.length;
        for (int i = n7; i < n8; ++i) {
            long l3 = matrixArray[i].numNonzeros();
            int[] nArray3 = new int[(int)l3];
            int[] nArray4 = new int[(int)l3];
            double[] dArray2 = new double[(int)l3];
            matrixArray[i]._getDataAsTriplets(nArray3, nArray4, dArray2);
            Tools.arraycopy(dArray2, 0L, dArray, l2, l3);
            long l4 = 0L;
            long l5 = l3;
            for (long j = l4; j < l5; ++j) {
                nArray[(int)(l2 + j)] = nArray3[(int)j] + n5;
                nArray2[(int)(l2 + j)] = nArray3[(int)j] + n6;
            }
            l2 += l3;
            n5 += matrixArray[i].dimi;
            n6 += matrixArray[i].dimj;
        }
        return new SparseMatrix(n, n2, nArray, nArray2, dArray);
    }

    public static Matrix antidiag(int n, double d, int n2) {
        if (n2 < n && n2 >= 0) {
            return Matrix.antidiag(Tools.makevector(d, n - n2), n2);
        }
        if (n2 > -n && n2 < 0) {
            return Matrix.antidiag(Tools.makevector(d, n + n2), n2);
        }
        throw new DimensionError("Diagonal index out of bounds");
    }

    public static Matrix antidiag(int n, double d) {
        return Matrix.antidiag(Tools.makevector(d, n), 0);
    }

    public static Matrix diag(int n, double d, int n2) {
        if (n2 < n && n2 >= 0) {
            return Matrix.diag(Tools.makevector(d, n - n2), n2);
        }
        if (n2 > -n && n2 < 0) {
            return Matrix.diag(Tools.makevector(d, n + n2), n2);
        }
        throw new DimensionError("Diagonal index out of bounds");
    }

    public static Matrix diag(int n, double d) {
        return Matrix.diag(Tools.makevector(d, n), 0);
    }

    public static Matrix antidiag(double[] dArray, int n) {
        int n2 = n > 0 ? n : -n;
        int n3 = dArray.length + n2;
        int n4 = dArray.length;
        if (n >= 0) {
            int[] nArray = Tools.range(n, n4 + n);
            int n5 = 0;
            int n6 = 1;
            int n7 = n4 + 1;
            int n8 = n6 < n7 ? n7 - n6 : 0;
            int[] nArray2 = new int[n8];
            int n9 = n6;
            int n10 = 0;
            while (n10 < n8) {
                nArray2[n5] = n4 + n - n9;
                ++n5;
                ++n10;
                ++n9;
            }
            int[] nArray3 = nArray2;
            return new SparseMatrix(n3, n3, nArray, nArray3, dArray);
        }
        int[] nArray = Tools.range(0, n4);
        int n11 = 0;
        int n12 = 1;
        int n13 = n4 + 1;
        int n14 = n12 < n13 ? n13 - n12 : 0;
        int[] nArray4 = new int[n14];
        int n15 = n12;
        int n16 = 0;
        while (n16 < n14) {
            nArray4[n11] = n4 - n15;
            ++n11;
            ++n16;
            ++n15;
        }
        int[] nArray5 = nArray4;
        return new SparseMatrix(n3, n3, nArray, nArray5, dArray);
    }

    public static Matrix antidiag(double[] dArray) {
        return Matrix.antidiag(dArray, 0);
    }

    public static Matrix diag(double[] dArray, int n) {
        int n2 = n > 0 ? n : -n;
        int n3 = dArray.length + n2;
        int n4 = dArray.length;
        if (n >= 0) {
            int[] nArray = Tools.range(0, n4);
            int[] nArray2 = Tools.range(n2, n4 + n2);
            return new SparseMatrix(n3, n3, nArray, nArray2, dArray);
        }
        int[] nArray = Tools.range(n2, n4 + n2);
        int[] nArray3 = Tools.range(0, n4);
        return new SparseMatrix(n3, n3, nArray, nArray3, dArray);
    }

    public static Matrix diag(double[] dArray) {
        return Matrix.diag(dArray, 0);
    }

    public static Matrix ones(int n, int n2) {
        return Matrix.dense(n, n2, 1.0);
    }

    public static Matrix eye(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        int n5 = n3 < n4 ? n4 - n3 : 0;
        double[] dArray = new double[n5];
        int n6 = n3;
        int n7 = 0;
        while (n7 < n5) {
            dArray[n2] = 1.0;
            ++n2;
            ++n7;
            ++n6;
        }
        return Matrix.diag(dArray);
    }

    public static Matrix dense(Matrix matrix) {
        return new DenseMatrix(matrix);
    }

    public static Matrix dense(int n, int n2, double d) {
        return new DenseMatrix(n, n2, d);
    }

    public static Matrix dense(int n, int n2, double[] dArray) {
        return new DenseMatrix(n, n2, dArray);
    }

    public static Matrix dense(double[][] dArray) {
        return new DenseMatrix(dArray);
    }

    public static Matrix sparse(Matrix matrix) {
        int[] nArray = new int[(int)matrix.numNonzeros()];
        int[] nArray2 = new int[(int)matrix.numNonzeros()];
        double[] dArray = new double[(int)matrix.numNonzeros()];
        matrix._getDataAsTriplets(nArray, nArray2, dArray);
        return new SparseMatrix(matrix.numRows(), matrix.numColumns(), nArray, nArray2, dArray);
    }

    public static Matrix sparse(Matrix[][] matrixArray) {
        int n;
        int n2;
        Object object;
        int n3 = matrixArray.length;
        int n4 = matrixArray[0].length;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n4];
        long l = 0L;
        int n5 = 0;
        for (int i = 0; i < n3 && i < n3; ++i) {
            for (int j = 0; j < n4 && j < n4; ++j) {
                object = matrixArray[i][j];
                if (object != null) {
                    if (nArray2[j] == 0) {
                        nArray2[j] = ((Matrix)object).dimj;
                    } else if (nArray2[j] != ((Matrix)object).dimj) {
                        throw new SparseFormatError("Sparse matrix construction blocks are not aligned");
                    }
                    if (nArray[i] == 0) {
                        nArray[i] = ((Matrix)object).dimi;
                    } else if (nArray[i] != ((Matrix)object).dimi) {
                        throw new SparseFormatError("Sparse matrix construction blocks are not aligned");
                    }
                    l += ((Matrix)object).numNonzeros();
                }
                ++n5;
            }
        }
        double[] dArray = new double[(int)l];
        int[] nArray3 = new int[(int)l];
        object = new int[(int)l];
        int n6 = 0;
        int n7 = 0;
        for (n2 = 0; n2 < n3 && n2 < n3; ++n2) {
            int[] nArray4 = new int[n4];
            for (n = 0; n < nArray[n2] && n < nArray[n2]; ++n) {
                int n8 = 0;
                for (int i = 0; i < n4 && i < n4; ++i) {
                    Matrix matrix = matrixArray[n2][i];
                    if (matrix != null) {
                        int n9;
                        Matrix matrix2;
                        Matrix matrix3 = matrix;
                        if (matrix3 instanceof DenseMatrix) {
                            matrix2 = (DenseMatrix)matrix3;
                            n9 = nArray4[i];
                            for (int j = 0; j < matrix2.dimj && j < matrix2.dimj; ++j) {
                                dArray[n6] = matrix2.data[n9];
                                nArray3[n6] = n7 + n;
                                object[n6] = n8 + j;
                                ++n9;
                                ++n6;
                            }
                            nArray4[i] = n9;
                        } else if (matrix3 instanceof SparseMatrix) {
                            matrix2 = (SparseMatrix)matrix3;
                            n9 = nArray4[i];
                            while ((long)n9 < ((SparseMatrix)matrix2).nnz && ((SparseMatrix)matrix2).subi[n9] == n && (long)n9 < ((SparseMatrix)matrix2).nnz && ((SparseMatrix)matrix2).subi[n9] == n) {
                                dArray[n6] = ((SparseMatrix)matrix2).val[n9];
                                object[n6] = ((SparseMatrix)matrix2).subj[n9] + n8;
                                nArray3[n6] = n7 + n;
                                ++n6;
                                ++n9;
                            }
                            nArray4[i] = n9;
                        } else {
                            matrix2 = matrix3;
                            throw new MatrixError("Unknown matrix type.");
                        }
                    }
                    n8 += nArray2[i];
                }
            }
            n7 += nArray[n2];
        }
        n2 = 0;
        int n10 = 0;
        for (n = 0; n < n3 && n < n3; ++n) {
            n2 += nArray[n];
        }
        for (n = 0; n < n4 && n < n4; ++n) {
            n10 += nArray2[n];
        }
        return new SparseMatrix(n2, n10, nArray3, (int[])object, dArray);
    }

    public static Matrix sparse(double[][] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = dArray.length;
        int n6 = dArray[0].length;
        long l = n5 * n6;
        int n7 = 0;
        int n8 = 0;
        int n9 = n5;
        int n10 = n8 < n9 ? n9 - n8 : 0;
        int n11 = 0;
        int n12 = n6;
        int n13 = n11 < n12 ? n12 - n11 : 0;
        int[] nArray = new int[n10 * n13];
        int n14 = n8;
        int n15 = 0;
        while (n15 < n10) {
            n4 = n11;
            n3 = 0;
            while (n3 < n13) {
                nArray[n7] = n14;
                ++n7;
                ++n3;
                ++n4;
            }
            ++n15;
            ++n14;
        }
        int[] nArray2 = nArray;
        n4 = 0;
        n3 = 0;
        int n16 = n5;
        int n17 = n3 < n16 ? n16 - n3 : 0;
        int n18 = 0;
        int n19 = n6;
        int n20 = n18 < n19 ? n19 - n18 : 0;
        int[] nArray3 = new int[n17 * n20];
        int n21 = n3;
        int n22 = 0;
        while (n22 < n17) {
            n2 = n18;
            for (n = 0; n < n20; ++n) {
                nArray3[n4] = n2++;
                ++n4;
            }
            ++n22;
            ++n21;
        }
        int[] nArray4 = nArray3;
        n2 = 0;
        n = 0;
        int n23 = n5;
        int n24 = n < n23 ? n23 - n : 0;
        int n25 = 0;
        int n26 = n6;
        int n27 = n25 < n26 ? n26 - n25 : 0;
        double[] dArray2 = new double[n24 * n27];
        int n28 = n;
        int n29 = 0;
        while (n29 < n24) {
            int n30 = n25;
            int n31 = 0;
            while (n31 < n27) {
                dArray2[n2] = dArray[n28][n30];
                ++n2;
                ++n31;
                ++n30;
            }
            ++n29;
            ++n28;
        }
        double[] dArray3 = dArray2;
        return new SparseMatrix(n5, n6, nArray2, nArray4, dArray3);
    }

    public static Matrix sparse(int n, int n2) {
        return new SparseMatrix(n, n2, new int[0], new int[0], new double[0], 0L);
    }

    public static Matrix _sparse(int n, int n2, int[] nArray, int[] nArray2, double d) {
        int n3 = 0;
        if (nArray != null) {
            n3 = nArray.length;
        } else if (nArray2 != null) {
            n3 = nArray2.length;
        }
        return Matrix._sparse(n, n2, nArray, nArray2, Tools.makevector(d, n3));
    }

    public static Matrix sparse(int n, int n2, int[] nArray, int[] nArray2, double d) {
        int[] nArray3 = Util.fromMatlab(nArray);
        int[] nArray4 = Util.fromMatlab(nArray2);
        Matrix matrix = Matrix._sparse(n, n2, nArray3, nArray4, d);
        Util.toMatlab(nArray, nArray3);
        Util.toMatlab(nArray2, nArray4);
        return matrix;
    }

    public static Matrix _sparse(int[] nArray, int[] nArray2, double d) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        if (n3 > nArray2.length) {
            n3 = nArray2.length;
        }
        int n4 = 0;
        int n5 = n3;
        for (int i = n4; i < n5; ++i) {
            if (n < nArray[i]) {
                n = nArray[i];
            }
            if (n2 >= nArray2[i]) continue;
            n2 = nArray2[i];
        }
        return Matrix._sparse(n + 1, n2 + 1, nArray, nArray2, d);
    }

    public static Matrix sparse(int[] nArray, int[] nArray2, double d) {
        int[] nArray3 = Util.fromMatlab(nArray);
        int[] nArray4 = Util.fromMatlab(nArray2);
        Matrix matrix = Matrix._sparse(nArray3, nArray4, d);
        Util.toMatlab(nArray, nArray3);
        Util.toMatlab(nArray2, nArray4);
        return matrix;
    }

    public static Matrix _sparse(int[] nArray, int[] nArray2, double[] dArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        if (n3 > nArray2.length) {
            n3 = nArray2.length;
        }
        if (n3 > dArray.length) {
            n3 = dArray.length;
        }
        int n4 = 0;
        int n5 = n3;
        for (int i = n4; i < n5; ++i) {
            if (n < nArray[i]) {
                n = nArray[i];
            }
            if (n2 >= nArray2[i]) continue;
            n2 = nArray2[i];
        }
        return Matrix._sparse(n + 1, n2 + 1, nArray, nArray2, dArray);
    }

    public static Matrix sparse(int[] nArray, int[] nArray2, double[] dArray) {
        int[] nArray3 = Util.fromMatlab(nArray);
        int[] nArray4 = Util.fromMatlab(nArray2);
        Matrix matrix = Matrix._sparse(nArray3, nArray4, dArray);
        Util.toMatlab(nArray, nArray3);
        Util.toMatlab(nArray2, nArray4);
        return matrix;
    }

    public static Matrix _sparse(int n, int n2, int[] nArray, int[] nArray2, double[] dArray) {
        int[] nArray3 = nArray != null ? nArray : new int[]{};
        int[] nArray4 = nArray2 != null ? nArray2 : new int[]{};
        double[] dArray2 = dArray != null ? dArray : new double[]{};
        long l = nArray3.length;
        if ((long)nArray4.length != l || (long)dArray2.length != l) {
            throw new SparseFormatError("Arrays defining sparse data have different lengths");
        }
        return new SparseMatrix(n, n2, nArray3, nArray4, dArray2, l);
    }

    public static Matrix sparse(int n, int n2, int[] nArray, int[] nArray2, double[] dArray) {
        int[] nArray3 = Util.fromMatlab(nArray);
        int[] nArray4 = Util.fromMatlab(nArray2);
        Matrix matrix = Matrix._sparse(n, n2, nArray3, nArray4, dArray);
        Util.toMatlab(nArray, nArray3);
        Util.toMatlab(nArray2, nArray4);
        return matrix;
    }

    public abstract double get(int var1, int var2);

    public abstract boolean isSparse();

    public abstract double[] getDataAsArray();

    public abstract void _getDataAsTriplets(int[] var1, int[] var2, double[] var3) throws LengthError;

    public abstract void getDataAsTriplets(int[] var1, int[] var2, double[] var3) throws LengthError;

    public abstract Matrix transpose();

    public abstract long numNonzeros();

    public int numColumns() {
        return this.dimj;
    }

    public int numRows() {
        return this.dimi;
    }
}

