/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.IndexCounter;
import mosek.fusion.IndexError;
import mosek.fusion.Model;
import mosek.fusion.ModelVariable;
import mosek.fusion.QConeDomain;
import mosek.fusion.Set;
import mosek.fusion.SolutionError;
import mosek.fusion.SolutionType;
import mosek.fusion.Utils.StringBuffer;

public class ConicVariable
extends ModelVariable {
    private boolean names_flushed;
    private int[] nativeidxs;
    private QConeDomain dom;
    private int numcone;
    private int conesize;
    private int coneidx;

    private ConicVariable(ConicVariable conicVariable, Model model) {
        super(conicVariable, model);
        int[] nArray;
        this.dom = conicVariable.dom;
        this.coneidx = conicVariable.coneidx;
        this.conesize = conicVariable.conesize;
        this.numcone = conicVariable.numcone;
        if (conicVariable.nativeidxs != null) {
            int n = 0;
            int n2 = 0;
            int n3 = conicVariable.nativeidxs.length;
            int n4 = n2 < n3 ? n3 - n2 : 0;
            int[] nArray2 = new int[n4];
            int n5 = n2;
            int n6 = 0;
            while (n6 < n4) {
                nArray2[n] = conicVariable.nativeidxs[n5];
                ++n;
                ++n6;
                ++n5;
            }
            nArray = nArray2;
        } else {
            nArray = null;
        }
        this.nativeidxs = nArray;
        this.names_flushed = conicVariable.names_flushed;
    }

    protected ConicVariable(Model model, String string, QConeDomain qConeDomain, Set set, int[] nArray, int n, int n2, int n3, long l) {
        super(model, string, set, l);
        this.dom = qConeDomain;
        this.conesize = n;
        this.coneidx = n2;
        this.numcone = n3;
        this.nativeidxs = nArray;
        this.names_flushed = false;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("ConicVariable( ");
        if (this.name.length() > 0) {
            stringBuffer.a("'").a(this.name).a("',");
        }
        stringBuffer.a("(");
        stringBuffer.a(this.shape_p._dim(0));
        int n = 1;
        int n2 = this.shape_p.nd;
        for (int i = n; i < n2; ++i) {
            stringBuffer.a(",").a(this.shape_p._dim(i));
        }
        stringBuffer.a(") )");
        return stringBuffer.toString();
    }

    @Override
    public StringBuffer elementDesc(long l, StringBuffer stringBuffer) {
        this.elementName(l, stringBuffer);
        this.dom.domainToString(l, stringBuffer);
        return stringBuffer;
    }

    @Override
    public void elementName(long l, StringBuffer stringBuffer) {
        stringBuffer.a(this.name.length() == 0 ? "_" : this.name).a("[").a(this.shape_p.indexToString(l)).a("] ");
    }

    @Override
    public void flushNames() {
        if (!this.names_flushed && this.name.length() > 0) {
            int n = 0;
            int n2 = this.nativeidxs.length;
            for (int i = n; i < n2; ++i) {
                this.model.varname(this.nativeidxs[i], new StringBuffer().a(this.name).a("[").a(this.shape_p.getname(i)).a("]").toString());
            }
            this.names_flushed = true;
        }
    }

    @Override
    public void inst(long[] lArray, int n, int n2, long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.nativeidxs != null) {
            int n3 = n;
            int n4 = n2;
            for (int i = n3; i < n4; ++i) {
                nArray[(int)(l2 + (long)(i - n))] = this.nativeidxs[(int)lArray[(int)((long)i - l)]];
            }
        }
    }

    @Override
    public void inst(long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        if (l < 0L || l >= (long)this.nativeidxs.length) {
            throw new IndexError("Index out of bounds");
        }
        nArray[(int)l2] = this.nativeidxs[(int)l];
    }

    @Override
    public void set_values(long l, int[] nArray, long[] lArray, int n, double[] dArray, boolean bl) {
        if (bl) {
            double[] dArray2;
            int n2;
            long l2 = 1L;
            int n3 = lArray.length;
            IndexCounter indexCounter = new IndexCounter(l, nArray, lArray);
            int n4 = 0;
            int n5 = n3;
            for (n2 = n4; n2 < n5; ++n2) {
                l2 *= (long)nArray[n2];
            }
            n4 = this.nativeidxs.length;
            n5 = 0;
            n2 = 0;
            long l3 = l2;
            long l4 = (long)n2 < l3 ? l3 - (long)n2 : 0L;
            int[] nArray2 = new int[(int)l4];
            long l5 = n2;
            int n6 = 0;
            while ((long)n6 < l4) {
                nArray2[n5] = this.nativeidxs[(int)indexCounter.next()];
                ++n5;
                ++n6;
                ++l5;
            }
            int[] nArray3 = nArray2;
            if (n > 0) {
                int n7 = 0;
                int n8 = 0;
                int n9 = n4;
                int n10 = n8 < n9 ? n9 - n8 : 0;
                double[] dArray3 = new double[n10];
                int n11 = n8;
                int n12 = 0;
                while (n12 < n10) {
                    dArray3[n7] = dArray[n + n11];
                    ++n7;
                    ++n12;
                    ++n11;
                }
                dArray2 = dArray3;
            } else {
                dArray2 = dArray;
            }
            double[] dArray4 = dArray2;
            this.model.setSolution_xx(nArray3, dArray4);
        }
    }

    @Override
    public void set_values(long[] lArray, double[] dArray, boolean bl) {
        if (bl) {
            int n = this.nativeidxs.length;
            int n2 = 0;
            int n3 = 0;
            int n4 = n;
            int n5 = n3 < n4 ? n4 - n3 : 0;
            int[] nArray = new int[n5];
            int n6 = n3;
            int n7 = 0;
            while (n7 < n5) {
                nArray[n2] = this.nativeidxs[(int)lArray[n6]];
                ++n2;
                ++n7;
                ++n6;
            }
            int[] nArray2 = nArray;
            int n8 = 0;
            int n9 = 0;
            int n10 = n;
            int n11 = n9 < n10 ? n10 - n9 : 0;
            double[] dArray2 = new double[n11];
            int n12 = n9;
            int n13 = 0;
            while (n13 < n11) {
                dArray2[n8] = dArray[n12];
                ++n8;
                ++n13;
                ++n12;
            }
            double[] dArray3 = dArray2;
            this.model.setSolution_xx(nArray2, dArray3);
        }
    }

    @Override
    public void values(long l, int[] nArray, long[] lArray, int n, double[] dArray, boolean bl) throws SolutionError {
        long l2 = 1L;
        int n2 = lArray.length;
        IndexCounter indexCounter = new IndexCounter(l, nArray, lArray);
        double[] dArray2 = bl ? this.model.getSolution_xx(SolutionType.Default) : this.model.getSolution_snx(SolutionType.Default);
        int n3 = 0;
        int n4 = n2;
        for (int i = n3; i < n4; ++i) {
            l2 *= (long)nArray[i];
        }
        long l3 = 0L;
        long l4 = l2;
        for (long i = l3; i < l4; ++i) {
            dArray[(int)(i + (long)n)] = dArray2[this.nativeidxs[(int)indexCounter.get()]];
            indexCounter.inc();
        }
    }

    @Override
    public void values(long[] lArray, int n, double[] dArray, boolean bl) throws SolutionError {
        double[] dArray2 = bl ? this.model.getSolution_xx(SolutionType.Default) : this.model.getSolution_snx(SolutionType.Default);
        int n2 = 0;
        int n3 = lArray.length;
        for (int i = n2; i < n3; ++i) {
            dArray[n + i] = dArray2[this.nativeidxs[(int)lArray[i]]];
        }
    }

    @Override
    public void make_continuous(long[] lArray) {
        int n = 0;
        int n2 = 0;
        int n3 = lArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray[n] = this.nativeidxs[(int)lArray[n5]];
            ++n;
            ++n6;
            ++n5;
        }
        this.getModel().task_var_putcontlist(nArray);
    }

    @Override
    public void make_integer(long[] lArray) {
        int n = 0;
        int n2 = 0;
        int n3 = lArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray[n] = this.nativeidxs[(int)lArray[n5]];
            ++n;
            ++n6;
            ++n5;
        }
        this.getModel().task_var_putintlist(nArray);
    }

    public int get_variable_index(int n) {
        if (n >= this.nativeidxs.length) {
            throw new IndexError("Variable index out of range");
        }
        return this.nativeidxs[n];
    }

    @Override
    public ModelVariable clone(Model model) {
        return new ConicVariable(this, model);
    }
}

