/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import com.mosek.monty.Util;
import mosek.fusion.DimensionError;
import mosek.fusion.Expr;
import mosek.fusion.Expression;
import mosek.fusion.IndexError;
import mosek.fusion.LengthError;
import mosek.fusion.Model;
import mosek.fusion.PickVariable;
import mosek.fusion.Set;
import mosek.fusion.SliceVariable;
import mosek.fusion.SolutionError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Variable;

public abstract class BaseVariable
implements Variable {
    protected Model model;
    protected Set shape_p;

    protected BaseVariable(BaseVariable baseVariable, Model model) {
        this.model = model;
        this.shape_p = baseVariable.shape_p;
    }

    public BaseVariable(Model model, Set set) {
        this.model = model;
        this.shape_p = set;
    }

    @Override
    public StringBuffer elementDesc(long l, StringBuffer stringBuffer) {
        this.elementName(l, stringBuffer);
        return stringBuffer;
    }

    @Override
    public abstract void elementName(long var1, StringBuffer var3);

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("Variable( (").a(this.shape_p._dim(0));
        int n2 = 1;
        int n3 = this.shape_p.nd;
        for (n = n2; n < n3; ++n) {
            stringBuffer.a(",").a(this.shape_p._dim(n));
        }
        stringBuffer.a(" )");
        if (this.shape_p.size < 51L) {
            n2 = 0;
            long l = this.shape_p.size;
            for (long i = (long)n2; i < l; ++i) {
                stringBuffer.a(",\n  ");
                this.elementDesc(i, stringBuffer);
            }
        } else {
            n2 = 0;
            n3 = 25;
            for (n = n2; n < n3; ++n) {
                stringBuffer.a(",\n  ");
                this.elementDesc(n, stringBuffer);
            }
            stringBuffer.a("... (").a(this.shape_p.size - 50L).a(" elements left out)");
            long l = this.shape_p.size - 25L;
            long l2 = this.shape_p.size;
            for (long i = l; i < l2; ++i) {
                stringBuffer.a(",\n  ");
                this.elementDesc(i, stringBuffer);
            }
        }
        stringBuffer.a(" )");
        return stringBuffer.toString();
    }

    @Override
    public void inst(long[] lArray, int n, int n2, long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        int n3 = n;
        int n4 = n2;
        for (int i = n3; i < n4; ++i) {
            this.inst(lArray[i] - l, l2 + (long)i - (long)n, nArray, nArray2, nArray3);
        }
    }

    @Override
    public abstract void inst(long var1, long var3, int[] var5, int[] var6, int[] var7);

    @Override
    public abstract void set_values(long[] var1, double[] var2, boolean var3);

    @Override
    public abstract void set_values(long var1, int[] var3, long[] var4, int var5, double[] var6, boolean var7);

    @Override
    public void values(int n, double[] dArray, boolean bl) throws SolutionError {
        int n2;
        long[] lArray = new long[this.shape_p.nd];
        int[] nArray = new int[this.shape_p.nd];
        int n3 = 0;
        int n4 = this.shape_p.nd;
        for (n2 = n3; n2 < n4; ++n2) {
            lArray[n2] = this.shape_p.stride(n2);
        }
        n3 = 0;
        n4 = this.shape_p.nd;
        for (n2 = n3; n2 < n4; ++n2) {
            nArray[n2] = this.shape_p._dim(n2);
        }
        this.values(0L, nArray, lArray, n, dArray, bl);
    }

    @Override
    public abstract void values(long[] var1, int var2, double[] var3, boolean var4) throws SolutionError;

    @Override
    public abstract void values(long var1, int[] var3, long[] var4, int var5, double[] var6, boolean var7) throws SolutionError;

    @Override
    public void setLevel(double[] dArray) {
        if (this.shape_p.size > (long)dArray.length) {
            throw new LengthError("Invalid length of solution values vector");
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.shape_p.nd;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray[n] = this.shape_p._dim(n5);
            ++n;
            ++n6;
            ++n5;
        }
        n6 = 0;
        int n7 = 0;
        int n8 = this.shape_p.nd;
        int n9 = n7 < n8 ? n8 - n7 : 0;
        long[] lArray = new long[n9];
        int n10 = n7;
        int n11 = 0;
        while (n11 < n9) {
            lArray[n6] = this.shape_p.stride(n10);
            ++n6;
            ++n11;
            ++n10;
        }
        this.set_values(0L, nArray, lArray, 0, dArray, true);
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public Set shape() {
        return this.shape_p;
    }

    @Override
    public Set getShape() {
        return this.shape_p;
    }

    @Override
    public long size() {
        return this.shape_p.size;
    }

    @Override
    public double[] dual() throws SolutionError {
        double[] dArray = new double[(int)this.shape_p.size];
        if (this.shape_p.size > 0L) {
            this.values(0, dArray, false);
        }
        return dArray;
    }

    @Override
    public double[] level() throws SolutionError {
        double[] dArray = new double[(int)this.shape_p.size];
        if (this.shape_p.size > 0L) {
            this.values(0, dArray, true);
        }
        return dArray;
    }

    @Override
    public abstract void make_continuous(long[] var1);

    @Override
    public abstract void make_integer(long[] var1);

    @Override
    public void makeContinuous() {
        int n = 0;
        long l = 0L;
        long l2 = this.size();
        long l3 = l < l2 ? l2 - l : 0L;
        long[] lArray = new long[(int)l3];
        long l4 = l;
        int n2 = 0;
        while ((long)n2 < l3) {
            lArray[n] = l4++;
            ++n;
            ++n2;
        }
        this.make_continuous(lArray);
    }

    @Override
    public void makeInteger() {
        int n = 0;
        long l = 0L;
        long l2 = this.size();
        long l3 = l < l2 ? l2 - l : 0L;
        long[] lArray = new long[(int)l3];
        long l4 = l;
        int n2 = 0;
        while ((long)n2 < l3) {
            lArray[n] = l4++;
            ++n;
            ++n2;
        }
        this.make_integer(lArray);
    }

    @Override
    public Variable transpose() {
        if (this.shape_p.nd > 2) {
            throw new DimensionError("Invalid shape for operation");
        }
        return new SliceVariable(this, Set.make(this.shape_p._dim(1), this.shape_p._dim(0)), 0L, new long[]{this.shape_p.stride(1), this.shape_p.stride(0)});
    }

    @Override
    public Variable _index(int n, int n2, int n3) {
        return this._index(new int[]{n, n2, n3});
    }

    @Override
    public Variable index(int n, int n2, int n3) {
        int n4 = Util.fromMatlab(n);
        int n5 = Util.fromMatlab(n2);
        int n6 = Util.fromMatlab(n3);
        Variable variable = this._index(n4, n5, n6);
        return variable;
    }

    @Override
    public Variable _index(int n, int n2) {
        return this._index(new int[]{n, n2});
    }

    @Override
    public Variable index(int n, int n2) {
        int n3 = Util.fromMatlab(n);
        int n4 = Util.fromMatlab(n2);
        Variable variable = this._index(n3, n4);
        return variable;
    }

    @Override
    public Variable _index(int[] nArray) {
        if (this.shape_p.nd != nArray.length) {
            throw new IndexError("Invalid index");
        }
        return new PickVariable((Variable)this, new long[]{this.shape_p.linearidx(nArray)});
    }

    @Override
    public Variable index(int[] nArray) {
        int[] nArray2 = Util.fromMatlab(nArray);
        Variable variable = this._index(nArray2);
        Util.toMatlab(nArray, nArray2);
        return variable;
    }

    @Override
    public Variable _index(int n) {
        return this._pick(new int[]{n});
    }

    @Override
    public Variable index(int n) {
        int n2 = Util.fromMatlab(n);
        Variable variable = this._index(n2);
        return variable;
    }

    @Override
    public Variable _pick(int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.shape_p.nd != 3) {
            throw new IndexError("Invalid index");
        }
        if (nArray.length != nArray2.length || nArray.length != nArray3.length) {
            throw new LengthError("Mismatching argument lengths");
        }
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        long[] lArray = new long[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            lArray[n] = this.shape_p.linearidx(new int[]{nArray[n5], nArray2[n5], nArray3[n5]});
            ++n;
            ++n6;
            ++n5;
        }
        return new PickVariable((Variable)this, lArray);
    }

    @Override
    public Variable pick(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Util.fromMatlab(nArray);
        int[] nArray5 = Util.fromMatlab(nArray2);
        int[] nArray6 = Util.fromMatlab(nArray3);
        Variable variable = this._pick(nArray4, nArray5, nArray6);
        Util.toMatlab(nArray, nArray4);
        Util.toMatlab(nArray2, nArray5);
        Util.toMatlab(nArray3, nArray6);
        return variable;
    }

    @Override
    public Variable _pick(int[] nArray, int[] nArray2) {
        if (this.shape_p.nd != 2) {
            throw new IndexError("Invalid index");
        }
        if (nArray.length != nArray2.length) {
            throw new LengthError("Mismatching argument lengths");
        }
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        long[] lArray = new long[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            lArray[n] = this.shape_p.linearidx(new int[]{nArray[n5], nArray2[n5]});
            ++n;
            ++n6;
            ++n5;
        }
        return new PickVariable((Variable)this, lArray);
    }

    @Override
    public Variable pick(int[] nArray, int[] nArray2) {
        int[] nArray3 = Util.fromMatlab(nArray);
        int[] nArray4 = Util.fromMatlab(nArray2);
        Variable variable = this._pick(nArray3, nArray4);
        Util.toMatlab(nArray, nArray3);
        Util.toMatlab(nArray2, nArray4);
        return variable;
    }

    @Override
    public Variable _pick(int[][] nArray) {
        if (this.shape_p.nd != nArray[0].length) {
            throw new IndexError("Invalid index");
        }
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        long[] lArray = new long[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            int n8 = 0;
            int n9 = nArray[0].length;
            int n10 = n8 < n9 ? n9 - n8 : 0;
            int[] nArray2 = new int[n10];
            int n11 = n8;
            int n12 = 0;
            while (n12 < n10) {
                nArray2[n7] = nArray[n5][n11];
                ++n7;
                ++n12;
                ++n11;
            }
            lArray[n] = this.shape_p.linearidx(nArray2);
            ++n;
            ++n6;
            ++n5;
        }
        return new PickVariable((Variable)this, lArray);
    }

    @Override
    public Variable pick(int[][] nArray) {
        int[][] nArray2 = Util.fromMatlab(nArray);
        Variable variable = this._pick(nArray2);
        Util.toMatlab(nArray, nArray2);
        return variable;
    }

    @Override
    public Variable _pick(int[] nArray) {
        if (this.shape_p.nd != 1) {
            throw new IndexError("Invalid index");
        }
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        long[] lArray = new long[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            lArray[n] = nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new PickVariable((Variable)this, lArray);
    }

    @Override
    public Variable pick(int[] nArray) {
        int[] nArray2 = Util.fromMatlab(nArray);
        Variable variable = this._pick(nArray2);
        Util.toMatlab(nArray, nArray2);
        return variable;
    }

    @Override
    public Variable antidiag(int n) {
        if (this.shape_p.nd != 2) {
            throw new DimensionError("antidiag() only works on two-dimensional objects");
        }
        if (n >= 0) {
            return this.general_diag(new int[]{0, this.shape_p._dim(1) - 1 - n}, new int[]{1, -1});
        }
        return this.general_diag(new int[]{-n, this.shape_p._dim(1) - 1}, new int[]{1, -1});
    }

    @Override
    public Variable antidiag() {
        if (this.shape_p.nd != 2) {
            throw new DimensionError("antidiag() only works on two-dimensional objects");
        }
        return this.general_diag(new int[]{0, this.shape_p._dim(1) - 1}, new int[]{1, -1});
    }

    @Override
    public Variable diag(int n) {
        if (this.shape_p.nd != 2) {
            throw new DimensionError("diag() only works on two-dimensional objects");
        }
        if (n >= 0) {
            return this.general_diag(new int[]{0, n}, new int[]{1, 1});
        }
        return this.general_diag(new int[]{-n, 0}, new int[]{1, 1});
    }

    @Override
    public Variable diag() {
        if (this.shape_p.nd != 2) {
            throw new DimensionError("diag() only works on two-dimensional objects");
        }
        return this.general_diag(new int[]{0, 0}, new int[]{1, 1});
    }

    public Variable general_diag(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        if (this.shape_p.nd != nArray.length || this.shape_p.nd != nArray2.length) {
            throw new DimensionError("Invalid start or step definition");
        }
        int n4 = 0;
        int n5 = this.shape_p.nd;
        for (n3 = n4; n3 < n5; ++n3) {
            if (nArray[n3] >= 0 && nArray[n3] < this.shape_p._dim(n3)) continue;
            throw new LengthError("Start element is out of bounds");
        }
        long l = 0L;
        n3 = 0;
        int n6 = this.shape_p.nd;
        for (n2 = n3; n2 < n6; ++n2) {
            l += this.shape_p.stride(n2) * (long)nArray[n2];
        }
        n3 = 0;
        n6 = 0;
        n2 = this.shape_p.nd;
        int n7 = n6 < n2 ? n2 - n6 : 0;
        int[] nArray3 = new int[n7];
        int n8 = n6;
        int n9 = 0;
        while (n9 < n7) {
            nArray3[n3] = nArray2[n8] > 0 ? (this.shape_p._dim(n8) - nArray[n8] - 1) / nArray2[n8] + 1 : (nArray2[n8] < 0 ? nArray[n8] / -nArray2[n8] + 1 : 0);
            ++n3;
            ++n9;
            ++n8;
        }
        int[] nArray4 = nArray3;
        int n10 = nArray4[0];
        int n11 = 1;
        int n12 = this.shape_p.nd;
        for (n = n11; n < n12; ++n) {
            n10 = n10 < nArray4[n] ? n10 : nArray4[n];
        }
        long l2 = 0L;
        n = 0;
        int n13 = this.shape_p.nd;
        for (int i = n; i < n13; ++i) {
            l2 += (long)nArray2[i] * this.shape_p.stride(i);
        }
        return new SliceVariable(this, Set.make(n10), l, new long[]{l2});
    }

    @Override
    public Expression asExpr() {
        int n = 0;
        long l = 0L;
        long l2 = this.shape_p.size + 1L;
        long l3 = l < l2 ? l2 - l : 0L;
        long[] lArray = new long[(int)l3];
        long l4 = l;
        int n2 = 0;
        while ((long)n2 < l3) {
            lArray[n] = l4++;
            ++n;
            ++n2;
        }
        n2 = 0;
        long l5 = 0L;
        long l6 = this.shape_p.size;
        long l7 = l5 < l6 ? l6 - l5 : 0L;
        long[] lArray2 = new long[(int)l7];
        long l8 = l5;
        int n3 = 0;
        while ((long)n3 < l7) {
            lArray2[n2] = l8++;
            ++n2;
            ++n3;
        }
        n3 = 0;
        long l9 = 0L;
        long l10 = this.shape_p.size;
        long l11 = l9 < l10 ? l10 - l9 : 0L;
        double[] dArray = new double[(int)l11];
        long l12 = l9;
        int n4 = 0;
        while ((long)n4 < l11) {
            dArray[n3] = 1.0;
            ++n3;
            ++n4;
            ++l12;
        }
        return new Expr(lArray, new Variable[]{this}, lArray2, dArray, null, this.shape_p, null, 1);
    }

    @Override
    public Variable _slice(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray3 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray3[n] = nArray2[n5] - nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        n6 = 0;
        int n7 = 0;
        int n8 = nArray.length;
        int n9 = n7 < n8 ? n8 - n7 : 0;
        long[] lArray = new long[n9];
        int n10 = n7;
        int n11 = 0;
        while (n11 < n9) {
            lArray[n6] = this.shape_p.stride(n10);
            ++n6;
            ++n11;
            ++n10;
        }
        return new SliceVariable(this, Set.make(nArray3), this.shape_p.linearidx(nArray), lArray);
    }

    @Override
    public Variable slice(int[] nArray, int[] nArray2) {
        int[] nArray3 = Util.fromMatlab(nArray);
        int[] nArray4 = Util.fromMatlab(nArray2);
        Variable variable = this._slice(nArray3, nArray4);
        Util.toMatlab(nArray, nArray3);
        Util.toMatlab(nArray2, nArray4);
        return variable;
    }

    @Override
    public Variable _slice(int n, int n2) {
        return new SliceVariable(this, Set.make(n2 - n), n, new long[]{1L});
    }

    @Override
    public Variable slice(int n, int n2) {
        int n3 = Util.fromMatlab(n);
        int n4 = Util.fromMatlab(n2);
        Variable variable = this._slice(n3, n4);
        return variable;
    }
}

