/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.IndexCounter;
import mosek.fusion.IndexError;
import mosek.fusion.Model;
import mosek.fusion.ModelVariable;
import mosek.fusion.NDSet;
import mosek.fusion.SolutionError;
import mosek.fusion.SolutionType;
import mosek.fusion.SymmetricVariable;
import mosek.fusion.UnimplementedError;
import mosek.fusion.Utils.StringBuffer;

public class PSDVariable
extends ModelVariable
implements SymmetricVariable {
    private int numcones;
    private int coneidx;
    private int conesize;

    private PSDVariable(PSDVariable pSDVariable, Model model) {
        super(pSDVariable, model);
        this.conesize = pSDVariable.conesize;
        this.coneidx = pSDVariable.coneidx;
        this.numcones = pSDVariable.numcones;
    }

    protected PSDVariable(Model model, String string, int n, int n2, int n3, long l) {
        super(model, string, new NDSet(n, n), l);
        this.conesize = n;
        this.coneidx = n2;
        this.numcones = n3;
    }

    @Override
    protected void flushNames() {
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("PSDVariable(");
        if (this.name.length() > 0) {
            stringBuffer.a("'").a(this.name).a("',");
        }
        stringBuffer.a(this.shape_p.dim(0));
        int n = 1;
        int n2 = this.shape_p.nd;
        for (int i = n; i < n2; ++i) {
            stringBuffer.a(",").a(this.shape_p.dim(i));
        }
        stringBuffer.a(")");
        return stringBuffer.toString();
    }

    @Override
    public StringBuffer elementDesc(long l, StringBuffer stringBuffer) {
        long l2 = (long)this.conesize * (long)this.conesize;
        long l3 = l / l2;
        long l4 = l % l2;
        long l5 = l4 / (long)this.conesize;
        long l6 = l4 % (long)this.conesize;
        stringBuffer.a(this.name.length() == 0 ? "_" : this.name).a("[").a(l3).a(",").a(l5).a(",").a(l6).a("] ");
        if (this.numcones > 1) {
            stringBuffer.a(" : element (").a(l3).a(",").a(l5).a(",").a(l6);
        } else {
            stringBuffer.a(" : element (").a(l5).a(",").a(l6);
        }
        stringBuffer.a(") in a semidefinite cone of size (").a(this.numcones).a(",").a(this.conesize).a(",").a(this.conesize).a(")");
        return stringBuffer;
    }

    @Override
    public void elementName(long l, StringBuffer stringBuffer) {
        long l2 = (long)this.conesize * (long)this.conesize;
        long l3 = l / l2;
        long l4 = l % l2;
        long l5 = l4 / (long)this.conesize;
        long l6 = l4 % (long)this.conesize;
        stringBuffer.a(this.name.length() == 0 ? "_" : this.name).a("[").a(l3).a(",").a(l5).a(",").a(l6).a("] ");
    }

    @Override
    public void inst(long[] lArray, int n, int n2, long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        int n3;
        int n4 = n;
        int n5 = n2;
        for (n3 = n4; n3 < n5; ++n3) {
            if (lArray[n3] >= l && lArray[n3] < this.shape_p.size + l) continue;
            throw new IndexError("Index out of bounds");
        }
        long l3 = l2;
        n3 = n;
        int n6 = n2;
        for (int i = n3; i < n6; ++i) {
            int n7;
            long l4 = lArray[i] - l;
            int n8 = (int)(l4 / (long)(this.conesize * this.conesize));
            long l5 = l4 - (long)(this.conesize * this.conesize * n8);
            nArray[(int)l3] = -(1 + this.coneidx + n8);
            int n9 = (int)l5 / this.shape_p.dim(1);
            if (n9 >= (n7 = (int)l5 - n9 * this.shape_p.dim(1))) {
                nArray2[(int)l3] = n9;
                nArray3[(int)l3] = n7;
            } else {
                nArray2[(int)l3] = n7;
                nArray3[(int)l3] = n9;
            }
            ++l3;
        }
    }

    @Override
    public void inst(long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        if (l < 0L || l >= this.shape_p.size) {
            throw new IndexError("Index out of bounds");
        }
        int n2 = (int)(l / (long)(this.conesize * this.conesize));
        long l3 = l - (long)(this.conesize * this.conesize * n2);
        nArray[(int)l2] = -(1 + this.coneidx + n2);
        int n3 = (int)l3 / this.shape_p.dim(1);
        if (n3 >= (n = (int)l3 - n3 * this.shape_p.dim(1))) {
            nArray2[(int)l2] = n3;
            nArray3[(int)l2] = n;
        } else {
            nArray2[(int)l2] = n;
            nArray3[(int)l2] = n3;
        }
    }

    @Override
    public void set_values(long l, int[] nArray, long[] lArray, int n, double[] dArray, boolean bl) {
    }

    @Override
    public void set_values(long[] lArray, double[] dArray, boolean bl) {
    }

    @Override
    public void values(long l, int[] nArray, long[] lArray, int n, double[] dArray, boolean bl) throws SolutionError {
        long l2 = 1L;
        int n2 = lArray.length;
        IndexCounter indexCounter = new IndexCounter(l, nArray, lArray);
        double[][] dArray2 = bl ? this.model.getSolution_barx(SolutionType.Default) : this.model.getSolution_bars(SolutionType.Default);
        int n3 = this.conesize * this.conesize;
        int n4 = 0;
        int n5 = n2;
        for (int i = n4; i < n5; ++i) {
            l2 *= (long)nArray[i];
        }
        long l3 = 0L;
        long l4 = l2;
        for (long i = l3; i < l4; ++i) {
            long l5;
            long l6 = indexCounter.get() / (long)n3;
            long l7 = indexCounter.get() - l6 * (long)n3;
            long l8 = l7 - (l5 = l7 / (long)this.conesize) * (long)this.conesize;
            dArray[(int)i] = l8 > l5 ? dArray2[(int)((long)this.coneidx + l6)][(int)(l5 * (long)this.conesize + l8 - l5 * (l5 + 1L) / 2L)] : dArray2[(int)((long)this.coneidx + l6)][(int)(l8 * (long)this.conesize + l5 - l8 * (l8 + 1L) / 2L)];
            indexCounter.inc();
        }
    }

    @Override
    public void values(long[] lArray, int n, double[] dArray, boolean bl) throws SolutionError {
        double[][] dArray2 = bl ? this.model.getSolution_barx(SolutionType.Default) : this.model.getSolution_bars(SolutionType.Default);
        int n2 = this.conesize * this.conesize;
        int n3 = 0;
        int n4 = lArray.length;
        for (int i = n3; i < n4; ++i) {
            long l = lArray[i] / (long)n2;
            long l2 = lArray[i] - l * (long)n2;
            long l3 = l2 / (long)this.conesize;
            long l4 = l2 - l3 * (long)this.conesize;
            dArray[i] = l4 > l3 ? dArray2[(int)((long)this.coneidx + l)][(int)(l3 * (long)this.conesize + l4 - l3 * (l3 + 1L) / 2L)] : dArray2[(int)((long)this.coneidx + l)][(int)(l4 * (long)this.conesize + l3 - l4 * (l4 + 1L) / 2L)];
        }
    }

    @Override
    public void make_continuous(long[] lArray) {
    }

    @Override
    public void make_integer(long[] lArray) {
        throw new UnimplementedError("Cannot make PSDVariable elements integer");
    }

    @Override
    protected ModelVariable clone(Model model) {
        return new PSDVariable(this, model);
    }
}

