/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.DimensionError;
import mosek.fusion.IndexError;
import mosek.fusion.IntSet;
import mosek.fusion.Set;
import mosek.fusion.SliceError;
import mosek.fusion.Utils.StringBuffer;

public class NDSet
extends Set {
    private long[] strides;
    private int[] dimdef;

    public NDSet(int n, int n2, int n3) {
        super(3, n * n2 * n3);
        this.dimdef = new int[]{n, n2, n3};
        this.strides = new long[]{n2 * n3, n3, 1L};
    }

    public NDSet(int n, int n2) {
        super(2, n * n2);
        this.dimdef = new int[]{n, n2};
        this.strides = new long[]{n2, 1L};
    }

    public NDSet(int[] nArray) {
        super(nArray.length, NDSet.sumdims(nArray));
        int n;
        int n2 = 0;
        int n3 = this.nd;
        for (n = n2; n < n3; ++n) {
            if (nArray[n] >= 0) continue;
            throw new SliceError("Negative dimension size");
        }
        n2 = 0;
        n3 = 0;
        n = nArray.length;
        int n4 = n3 < n ? n - n3 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n3;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n2] = nArray[n5];
            ++n2;
            ++n6;
            ++n5;
        }
        this.dimdef = nArray2;
        this.strides = new long[this.nd];
        this.strides[this.nd - 1] = 1L;
        for (n6 = this.nd - 1; n6 > 0 && n6 > 0; --n6) {
            this.strides[n6 - 1] = this.strides[n6] * (long)this.dimdef[n6];
        }
    }

    @Override
    public String indexToString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = this.idxtokey(l);
        stringBuffer.a(nArray[0]);
        int n = 1;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            stringBuffer.a(",").a(nArray[i]);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getname(int[] nArray) {
        if (this.nd != nArray.length) {
            throw new DimensionError("Key dimensions do not match set dimensions.");
        }
        for (int i = 0; i < this.nd && i < this.nd; ++i) {
            if (nArray[i] >= 0 && nArray[i] < this.dimdef[i] + 1) continue;
            throw new IndexError("Key dimensions do not match set dimensions.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a(nArray[0]);
        int n = 1;
        int n2 = this.nd;
        for (int i = n; i < n2; ++i) {
            stringBuffer.a(",").a(nArray[i]);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getname(long l) {
        if (this.nd == 1) {
            long[] lArray = new long[this.nd];
            long l2 = l;
            int n = 0;
            int n2 = this.nd;
            for (int i = n; i < n2; ++i) {
                lArray[i] = l2 / this.strides[i];
                l2 -= lArray[i] * this.strides[i];
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.a(l);
            return stringBuffer.toString();
        }
        return this.getname(this.idxtokey(l));
    }

    @Override
    public int dim(int n) {
        return n >= this.nd ? 1 : this.dimdef[n];
    }

    @Override
    public Set slice(int[] nArray, int[] nArray2) {
        int n;
        if (this.nd != nArray.length || this.nd != nArray2.length) {
            throw new SliceError("Slice dimensions do not match set dimensions.");
        }
        for (n = 0; n < this.nd && n < this.nd; ++n) {
            if (nArray[n] >= 0 && nArray2[n] >= nArray[n] && nArray2[n] <= this.dimdef[n]) continue;
            throw new SliceError("Slice is out of bounds.");
        }
        n = 0;
        int n2 = 0;
        int n3 = this.nd;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray3 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray3[n] = nArray2[n5] - nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        int[] nArray4 = nArray3;
        return new NDSet(nArray4);
    }

    @Override
    public Set slice(int n, int n2) {
        if (this.nd != 1) {
            throw new SliceError("Slice dimensions do not match set dimensions.");
        }
        if (n < 0 || n2 < n || (long)n2 > this.size) {
            throw new SliceError("Slice dimensions do not match set dimensions.");
        }
        return new IntSet(n, n2);
    }

    protected int[] selectidxs(String[] stringArray) {
        throw new IndexError("invalid key type");
    }

    protected int linear_index_in_dim(int n, int[] nArray) {
        throw new IndexError("invalid key type");
    }

    protected int linear_index_in_dim(int n, int n2) {
        if (n < 0 || n >= this.dimdef.length) {
            throw new IndexError("dimension index out of bounds");
        }
        if (n2 < 0 || n2 >= this.dimdef[n]) {
            throw new IndexError("key out of bounds");
        }
        return n2;
    }

    private static long sumdims(int[] nArray) {
        long l = 1L;
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            l *= (long)nArray[i];
        }
        return l;
    }

    @Override
    public long stride(int n) {
        return this.strides[n];
    }
}

