/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.IndexCounter;
import mosek.fusion.LinearDomain;
import mosek.fusion.Model;
import mosek.fusion.ModelVariable;
import mosek.fusion.Set;
import mosek.fusion.SolutionError;
import mosek.fusion.SolutionStatus;
import mosek.fusion.SolutionType;
import mosek.fusion.Utils.IntMap;
import mosek.fusion.Utils.StringBuffer;

public class LinearVariable
extends ModelVariable {
    private boolean names_flushed;
    private LinearDomain dom;
    private int[] nativeidxs;
    private IntMap idxmap;

    private LinearVariable(LinearVariable linearVariable, Model model) {
        super(linearVariable, model);
        int[] nArray;
        if (linearVariable.nativeidxs != null) {
            int n = 0;
            int n2 = 0;
            int n3 = linearVariable.nativeidxs.length;
            int n4 = n2 < n3 ? n3 - n2 : 0;
            int[] nArray2 = new int[n4];
            int n5 = n2;
            int n6 = 0;
            while (n6 < n4) {
                nArray2[n] = linearVariable.nativeidxs[n5];
                ++n;
                ++n6;
                ++n5;
            }
            nArray = nArray2;
        } else {
            nArray = null;
        }
        this.nativeidxs = nArray;
        this.idxmap = linearVariable.idxmap != null ? linearVariable.idxmap.clone() : null;
        this.dom = linearVariable.dom;
        this.names_flushed = linearVariable.names_flushed;
    }

    protected LinearVariable(Model model, String string, LinearDomain linearDomain, Set set, int[] nArray, long l) {
        super(model, string, set, l);
        this.nativeidxs = nArray;
        this.idxmap = nArray == null ? new IntMap() : null;
        this.dom = linearDomain;
        this.names_flushed = false;
    }

    @Override
    public StringBuffer elementDesc(long l, StringBuffer stringBuffer) {
        this.elementName(l, stringBuffer);
        this.dom.domainToString(l, stringBuffer);
        return stringBuffer;
    }

    @Override
    public void elementName(long l, StringBuffer stringBuffer) {
        stringBuffer.a(this.name.length() == 0 ? "_" : this.name).a("[").a(this.shape_p.indexToString(l)).a("] ");
    }

    @Override
    protected void flushNames() {
        if (!this.names_flushed && this.name.length() > 0) {
            if (this.nativeidxs != null) {
                int n = 0;
                int n2 = this.nativeidxs.length;
                for (int i = n; i < n2; ++i) {
                    this.model.varname(this.nativeidxs[i], this.name.length() == 0 ? "" : new StringBuffer().a(this.name).a("[").a(this.shape_p.getname(i)).a("]").toString());
                }
            } else {
                long[] lArray = this.idxmap.keys();
                int[] nArray = this.idxmap.values();
                int n = 0;
                int n3 = lArray.length;
                for (int i = n; i < n3; ++i) {
                    this.model.varname(nArray[i], new StringBuffer().a(this.name).a("[").a(this.shape_p.getname(lArray[i])).a("]").toString());
                }
            }
            this.names_flushed = true;
        }
    }

    @Override
    public void inst(long[] lArray, int n, int n2, long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.nativeidxs != null) {
            int n3 = n;
            int n4 = n2;
            for (int i = n3; i < n4; ++i) {
                nArray[(int)(l2 + (long)(i - n))] = this.nativeidxs[(int)lArray[(int)((long)i - l)]];
            }
        } else {
            int n5 = n;
            int n6 = n2;
            for (int i = n5; i < n6; ++i) {
                if (!this.idxmap.hasItem(lArray[(int)((long)i - l)])) {
                    int n7 = this.model.append_linearvar(this, lArray[(int)((long)i - l)], this.dom.key, this.dom.get_rhs_item(lArray[(int)((long)i - l)]));
                    this.idxmap.setItem(lArray[(int)((long)i - l)], n7);
                    nArray[(int)(l2 + (long)i - (long)n)] = n7;
                    this.names_flushed = false;
                    continue;
                }
                nArray[(int)(l2 + (long)i - (long)n)] = this.idxmap.getItem(lArray[(int)((long)i - l)]);
            }
        }
    }

    @Override
    public void inst(long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.nativeidxs != null) {
            nArray[(int)l2] = this.nativeidxs[(int)l];
        } else if (!this.idxmap.hasItem(l)) {
            int n = this.model.append_linearvar(this, l, this.dom.key, this.dom.get_rhs_item(l));
            this.idxmap.setItem(l, n);
            nArray[(int)l2] = n;
        } else {
            nArray[(int)l2] = this.idxmap.getItem(l);
        }
    }

    private void dual_values(long l, int[] nArray, long[] lArray, int n, double[] dArray) throws SolutionError {
        int n2;
        long l2 = 1L;
        int n3 = lArray.length;
        IndexCounter indexCounter = new IndexCounter(l, nArray, lArray);
        double[] dArray2 = this.model.getSolution_slx(SolutionType.Default);
        double[] dArray3 = this.model.getSolution_sux(SolutionType.Default);
        int n4 = 0;
        int n5 = n3;
        for (n2 = n4; n2 < n5; ++n2) {
            l2 *= (long)nArray[n2];
        }
        if (this.nativeidxs != null) {
            long l3 = 0L;
            long l4 = l2;
            for (long i = l3; i < l4; ++i) {
                int n6 = this.nativeidxs[(int)indexCounter.get()];
                dArray[(int)(i + (long)n)] = dArray2[n6] - dArray3[n6];
                indexCounter.inc();
            }
        } else {
            SolutionStatus solutionStatus = this.model.getPrimalSolutionStatus();
            n5 = 0;
            n2 = (int)l2;
            for (int i = n5; i < n2; ++i) {
                if (this.idxmap.hasItem(indexCounter.get())) {
                    int n7 = this.idxmap.getItem(indexCounter.get());
                    dArray[n + i] = dArray2[n7] - dArray3[n7];
                } else {
                    dArray[n + i] = solutionStatus == SolutionStatus.Optimal || solutionStatus == SolutionStatus.NearOptimal || solutionStatus == SolutionStatus.Feasible || solutionStatus == SolutionStatus.NearFeasible ? this.dom.get_rhs_item(indexCounter.get()) : 0.0;
                }
                indexCounter.inc();
            }
        }
    }

    private void dual_values(long[] lArray, int n, double[] dArray) throws SolutionError {
        double[] dArray2 = this.model.getSolution_slx(SolutionType.Default);
        double[] dArray3 = this.model.getSolution_sux(SolutionType.Default);
        if (this.nativeidxs != null) {
            int n2 = 0;
            int n3 = lArray.length;
            for (int i = n2; i < n3; ++i) {
                int n4 = this.nativeidxs[(int)lArray[i]];
                dArray[n + i] = dArray2[n4] - dArray3[n4];
            }
        } else {
            SolutionStatus solutionStatus = this.model.getPrimalSolutionStatus();
            int n5 = 0;
            int n6 = lArray.length;
            for (int i = n5; i < n6; ++i) {
                if (this.idxmap.hasItem(lArray[i])) {
                    int n7 = this.idxmap.getItem(lArray[i]);
                    dArray[n + i] = dArray2[n7] - dArray3[n7];
                    continue;
                }
                dArray[n + i] = solutionStatus == SolutionStatus.Optimal || solutionStatus == SolutionStatus.NearOptimal || solutionStatus == SolutionStatus.Feasible || solutionStatus == SolutionStatus.NearFeasible ? this.dom.get_rhs_item(lArray[i]) : 0.0;
            }
        }
    }

    @Override
    public void set_values(long l, int[] nArray, long[] lArray, int n, double[] dArray, boolean bl) {
        if (bl) {
            int n2;
            long l2 = 1L;
            int n3 = lArray.length;
            IndexCounter indexCounter = new IndexCounter(l, nArray, lArray);
            int n4 = 0;
            int n5 = n3;
            for (n2 = n4; n2 < n5; ++n2) {
                l2 *= (long)nArray[n2];
            }
            if (this.nativeidxs != null) {
                double[] dArray2;
                n4 = this.nativeidxs.length;
                n5 = 0;
                n2 = 0;
                long l3 = l2;
                long l4 = (long)n2 < l3 ? l3 - (long)n2 : 0L;
                int[] nArray2 = new int[(int)l4];
                long l5 = n2;
                int n6 = 0;
                while ((long)n6 < l4) {
                    nArray2[n5] = this.nativeidxs[(int)indexCounter.next()];
                    ++n5;
                    ++n6;
                    ++l5;
                }
                int[] nArray3 = nArray2;
                if (n > 0) {
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = n4;
                    int n10 = n8 < n9 ? n9 - n8 : 0;
                    double[] dArray3 = new double[n10];
                    int n11 = n8;
                    int n12 = 0;
                    while (n12 < n10) {
                        dArray3[n7] = dArray[n11];
                        ++n7;
                        ++n12;
                        ++n11;
                    }
                    dArray2 = dArray3;
                } else {
                    dArray2 = dArray;
                }
                double[] dArray4 = dArray2;
                this.model.setSolution_xx(nArray3, dArray4);
            } else {
                int[] nArray4 = new int[(int)l2];
                n5 = 0;
                long l6 = l2;
                for (long i = (long)n5; i < l6; ++i) {
                    this.inst(indexCounter.next(), i, nArray4, null, null);
                }
                n5 = 0;
                int n13 = 0;
                long l7 = l2;
                long l8 = (long)n13 < l7 ? l7 - (long)n13 : 0L;
                double[] dArray5 = new double[(int)l8];
                long l9 = n13;
                int n14 = 0;
                while ((long)n14 < l8) {
                    dArray5[n5] = dArray[(int)((long)n + l9)];
                    ++n5;
                    ++n14;
                    ++l9;
                }
                double[] dArray6 = dArray5;
                this.model.setSolution_xx(nArray4, dArray6);
            }
        }
    }

    @Override
    public void set_values(long[] lArray, double[] dArray, boolean bl) {
        if (bl) {
            if (this.nativeidxs != null) {
                int n = this.nativeidxs.length;
                int n2 = 0;
                int n3 = 0;
                int n4 = n;
                int n5 = n3 < n4 ? n4 - n3 : 0;
                int[] nArray = new int[n5];
                int n6 = n3;
                int n7 = 0;
                while (n7 < n5) {
                    nArray[n2] = this.nativeidxs[(int)lArray[n6]];
                    ++n2;
                    ++n7;
                    ++n6;
                }
                int[] nArray2 = nArray;
                int n8 = 0;
                int n9 = 0;
                int n10 = n;
                int n11 = n9 < n10 ? n10 - n9 : 0;
                double[] dArray2 = new double[n11];
                int n12 = n9;
                int n13 = 0;
                while (n13 < n11) {
                    dArray2[n8] = dArray[n12];
                    ++n8;
                    ++n13;
                    ++n12;
                }
                double[] dArray3 = dArray2;
                this.model.setSolution_xx(nArray2, dArray3);
            } else {
                int n;
                int[] nArray = new int[lArray.length];
                int n14 = 0;
                int n15 = lArray.length;
                for (n = n14; n < n15; ++n) {
                    this.inst(lArray[n], n, nArray, null, null);
                }
                n14 = 0;
                n15 = 0;
                n = lArray.length;
                int n16 = n15 < n ? n - n15 : 0;
                double[] dArray4 = new double[n16];
                int n17 = n15;
                int n18 = 0;
                while (n18 < n16) {
                    dArray4[n14] = dArray[n17];
                    ++n14;
                    ++n18;
                    ++n17;
                }
                double[] dArray5 = dArray4;
                this.model.setSolution_xx(nArray, dArray5);
            }
        }
    }

    @Override
    public void values(long l, int[] nArray, long[] lArray, int n, double[] dArray, boolean bl) throws SolutionError {
        if (!bl) {
            this.dual_values(l, nArray, lArray, n, dArray);
        } else {
            int n2;
            long l2 = 1L;
            int n3 = lArray.length;
            IndexCounter indexCounter = new IndexCounter(l, nArray, lArray);
            double[] dArray2 = this.model.getSolution_xx(SolutionType.Default);
            int n4 = 0;
            int n5 = n3;
            for (n2 = n4; n2 < n5; ++n2) {
                l2 *= (long)nArray[n2];
            }
            if (this.nativeidxs != null) {
                long l3 = 0L;
                long l4 = l2;
                for (long i = l3; i < l4; ++i) {
                    dArray[(int)(i + (long)n)] = dArray2[this.nativeidxs[(int)indexCounter.get()]];
                    indexCounter.inc();
                }
            } else {
                SolutionStatus solutionStatus = this.model.getPrimalSolutionStatus();
                n5 = 0;
                n2 = (int)l2;
                for (int i = n5; i < n2; ++i) {
                    dArray[n + i] = this.idxmap.hasItem(indexCounter.get()) ? dArray2[this.idxmap.getItem(indexCounter.get())] : (solutionStatus == SolutionStatus.Optimal || solutionStatus == SolutionStatus.NearOptimal || solutionStatus == SolutionStatus.Feasible || solutionStatus == SolutionStatus.NearFeasible ? this.dom.get_rhs_item(indexCounter.get()) : 0.0);
                    indexCounter.inc();
                }
            }
        }
    }

    @Override
    public void make_continuous(long[] lArray) {
        if (this.nativeidxs != null) {
            int n = 0;
            int n2 = 0;
            int n3 = lArray.length;
            int n4 = n2 < n3 ? n3 - n2 : 0;
            int[] nArray = new int[n4];
            int n5 = n2;
            int n6 = 0;
            while (n6 < n4) {
                nArray[n] = this.nativeidxs[(int)lArray[n5]];
                ++n;
                ++n6;
                ++n5;
            }
            this.getModel().task_var_putcontlist(nArray);
        } else {
            int[] nArray = new int[lArray.length];
            this.inst(lArray, 0, lArray.length, 0L, 0L, nArray, null, null);
            this.getModel().task_var_putcontlist(nArray);
        }
    }

    @Override
    public void make_integer(long[] lArray) {
        if (this.nativeidxs != null) {
            int n = 0;
            int n2 = 0;
            int n3 = lArray.length;
            int n4 = n2 < n3 ? n3 - n2 : 0;
            int[] nArray = new int[n4];
            int n5 = n2;
            int n6 = 0;
            while (n6 < n4) {
                nArray[n] = this.nativeidxs[(int)lArray[n5]];
                ++n;
                ++n6;
                ++n5;
            }
            this.getModel().task_var_putintlist(nArray);
        } else {
            int[] nArray = new int[lArray.length];
            this.inst(lArray, 0, lArray.length, 0L, 0L, nArray, null, null);
            this.getModel().task_var_putintlist(nArray);
        }
    }

    @Override
    public void values(long[] lArray, int n, double[] dArray, boolean bl) throws SolutionError {
        if (!bl) {
            this.dual_values(lArray, n, dArray);
        } else {
            double[] dArray2 = this.model.getSolution_xx(SolutionType.Default);
            if (this.nativeidxs != null) {
                int n2 = 0;
                int n3 = lArray.length;
                for (int i = n2; i < n3; ++i) {
                    dArray[n + i] = dArray2[this.nativeidxs[(int)lArray[i]]];
                }
            } else {
                SolutionStatus solutionStatus = this.model.getPrimalSolutionStatus();
                int n4 = 0;
                int n5 = lArray.length;
                for (int i = n4; i < n5; ++i) {
                    dArray[n + i] = this.idxmap.hasItem(lArray[i]) ? dArray2[this.idxmap.getItem(lArray[i])] : (solutionStatus == SolutionStatus.Optimal || solutionStatus == SolutionStatus.NearOptimal || solutionStatus == SolutionStatus.Feasible || solutionStatus == SolutionStatus.NearFeasible ? this.dom.get_rhs_item(lArray[i]) : 0.0);
                }
            }
        }
    }

    @Override
    protected ModelVariable clone(Model model) {
        return new LinearVariable(this, model);
    }
}

