/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.DimensionError;
import mosek.fusion.SymmetricMatrix;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Variable;

public class SymmetricExpr {
    private Variable[] xs;
    private SymmetricMatrix b;
    private SymmetricMatrix[] Ms;
    private int n;

    protected SymmetricExpr(int n, SymmetricMatrix[] symmetricMatrixArray, Variable[] variableArray, SymmetricMatrix symmetricMatrix) {
        this.n = n;
        this.Ms = symmetricMatrixArray;
        this.xs = variableArray;
        this.b = symmetricMatrix;
    }

    public static SymmetricExpr add(SymmetricExpr symmetricExpr, SymmetricMatrix symmetricMatrix) {
        if (symmetricExpr.n != symmetricMatrix.getdim()) {
            throw new DimensionError("Dimension does not match");
        }
        return new SymmetricExpr(symmetricExpr.n, symmetricExpr.Ms, symmetricExpr.xs, symmetricExpr.b != null ? symmetricExpr.b.add(symmetricMatrix) : symmetricMatrix);
    }

    public static SymmetricExpr mul(SymmetricExpr symmetricExpr, double d) {
        int n = 0;
        int n2 = 0;
        int n3 = symmetricExpr.Ms.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        SymmetricMatrix[] symmetricMatrixArray = new SymmetricMatrix[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            symmetricMatrixArray[n] = symmetricExpr.Ms[n5].mul(d);
            ++n;
            ++n6;
            ++n5;
        }
        return new SymmetricExpr(symmetricExpr.n, symmetricMatrixArray, symmetricExpr.xs, symmetricExpr.b != null ? symmetricExpr.b.mul(d) : null);
    }

    public static SymmetricExpr add(SymmetricExpr symmetricExpr, SymmetricExpr symmetricExpr2) {
        int n;
        int n2;
        if (symmetricExpr.n != symmetricExpr2.n) {
            throw new DimensionError("Mismatching dimensions of operands");
        }
        SymmetricMatrix[] symmetricMatrixArray = new SymmetricMatrix[symmetricExpr.Ms.length + symmetricExpr2.Ms.length];
        Variable[] variableArray = new Variable[symmetricExpr.xs.length + symmetricExpr2.xs.length];
        int n3 = symmetricExpr.Ms.length;
        int n4 = 0;
        int n5 = symmetricExpr.Ms.length;
        for (n2 = n4; n2 < n5; ++n2) {
            symmetricMatrixArray[n2] = symmetricExpr.Ms[n2];
        }
        n4 = 0;
        n5 = symmetricExpr2.Ms.length;
        for (n2 = n4; n2 < n5; ++n2) {
            symmetricMatrixArray[n2 + n3] = symmetricExpr2.Ms[n2];
        }
        n4 = symmetricExpr.xs.length;
        n5 = 0;
        n2 = symmetricExpr.xs.length;
        for (n = n5; n < n2; ++n) {
            variableArray[n] = symmetricExpr.xs[n];
        }
        n5 = 0;
        n2 = symmetricExpr2.xs.length;
        for (n = n5; n < n2; ++n) {
            variableArray[n + n4] = symmetricExpr2.xs[n];
        }
        SymmetricMatrix symmetricMatrix = symmetricExpr.b == null && symmetricExpr2.b == null ? null : (symmetricExpr.b != null && symmetricExpr2.b != null ? symmetricExpr.b.add(symmetricExpr2.b) : (symmetricExpr.b != null ? symmetricExpr.b : symmetricExpr2.b));
        return new SymmetricExpr(symmetricExpr.n, symmetricMatrixArray, variableArray, symmetricMatrix);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("SymmetricExpr( (").a(this.n).a(",").a(this.n).a(") )");
        return stringBuffer.toString();
    }
}

