/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.IndexCounter;
import mosek.fusion.Model;
import mosek.fusion.ModelVariable;
import mosek.fusion.Set;
import mosek.fusion.SolutionError;
import mosek.fusion.SolutionStatus;
import mosek.fusion.SolutionType;
import mosek.fusion.SymmetricLinearDomain;
import mosek.fusion.SymmetricVariable;
import mosek.fusion.Utils.IntMap;
import mosek.fusion.Utils.StringBuffer;

public class SymLinearVariable
extends ModelVariable
implements SymmetricVariable {
    private int dim;
    private boolean names_flushed;
    private SymmetricLinearDomain dom;
    private int[] nativeidxs;
    private IntMap idxmap;

    protected SymLinearVariable(SymLinearVariable symLinearVariable, Model model) {
        super(symLinearVariable, model);
        int[] nArray;
        if (symLinearVariable.nativeidxs != null) {
            int n = 0;
            int n2 = 0;
            int n3 = symLinearVariable.nativeidxs.length;
            int n4 = n2 < n3 ? n3 - n2 : 0;
            int[] nArray2 = new int[n4];
            int n5 = n2;
            int n6 = 0;
            while (n6 < n4) {
                nArray2[n] = symLinearVariable.nativeidxs[n5];
                ++n;
                ++n6;
                ++n5;
            }
            nArray = nArray2;
        } else {
            nArray = null;
        }
        this.nativeidxs = nArray;
        this.idxmap = symLinearVariable.idxmap != null ? symLinearVariable.idxmap.clone() : null;
        this.dom = symLinearVariable.dom;
        this.dim = symLinearVariable.dim;
        this.names_flushed = symLinearVariable.names_flushed;
    }

    protected SymLinearVariable(Model model, String string, SymmetricLinearDomain symmetricLinearDomain, int n, int[] nArray, long l) {
        super(model, string, Set.make(n, n), l);
        this.nativeidxs = nArray;
        this.idxmap = this.nativeidxs == null ? new IntMap() : null;
        this.dom = symmetricLinearDomain;
        this.dim = n;
        this.names_flushed = false;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("SymLinearVariable( (");
        if (this.name.length() > 0) {
            stringBuffer.a("'").a(this.name).a("',");
        }
        stringBuffer.a(this.shape_p._dim(0));
        int n = 1;
        int n2 = this.shape_p.nd;
        for (int i = n; i < n2; ++i) {
            stringBuffer.a(",").a(this.shape_p._dim(i));
        }
        stringBuffer.a(") )");
        return stringBuffer.toString();
    }

    @Override
    public void flushNames() {
        if (!this.names_flushed && this.name.length() > 0) {
            if (this.nativeidxs != null) {
                int n = 0;
                int n2 = this.dim;
                for (int i = n; i < n2; ++i) {
                    int n3 = 0;
                    int n4 = i + 1;
                    for (int j = n3; j < n4; ++j) {
                        int n5 = i * this.dim - i * (i + 1) / 2 + j;
                        int n6 = i * this.dim + j;
                        this.model.varname(this.nativeidxs[n5], this.name.length() == 0 ? "" : new StringBuffer().a(this.name).a("[").a(this.shape_p.getname(n6)).a("]").toString());
                    }
                }
            } else {
                int n = 0;
                int n7 = this.dim;
                for (int i = n; i < n7; ++i) {
                    int n8 = 0;
                    int n9 = i + 1;
                    for (int j = n8; j < n9; ++j) {
                        int n10 = i * this.dim + j;
                        if (!this.idxmap.hasItem(n10)) continue;
                        this.model.varname(this.nativeidxs[this.idxmap.getItem(n10)], this.name.length() == 0 ? "" : new StringBuffer().a(this.name).a("[").a(this.shape_p.getname(n10)).a("]").toString());
                    }
                }
            }
            this.names_flushed = true;
        }
    }

    @Override
    public void inst(long[] lArray, int n, int n2, long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.nativeidxs != null) {
            int n3 = n;
            int n4 = n2;
            for (int i = n3; i < n4; ++i) {
                nArray[(int)(l2 + (long)i - (long)n)] = this.nativeidxs[(int)this.tril_lin_idx(lArray[i] - l)];
            }
        } else {
            int n5 = n;
            int n6 = n2;
            for (int i = n5; i < n6; ++i) {
                long l3 = this.tril_lin_idx(lArray[i] - l);
                long l4 = this.tril_idx(lArray[i] - l);
                if (!this.idxmap.hasItem(l4)) {
                    int n7 = this.model.append_linearvar(this, l4, this.dom.key, this.dom.get_rhs_item(l3));
                    this.idxmap.setItem(l4, n7);
                    nArray[(int)(l2 + (long)i - (long)n)] = n7;
                    this.names_flushed = false;
                    continue;
                }
                nArray[(int)(l2 + (long)i - (long)n)] = this.idxmap.getItem(l4);
            }
        }
    }

    @Override
    public void inst(long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        long l3 = this.tril_lin_idx(l);
        long l4 = this.tril_idx(l);
        if (this.nativeidxs != null) {
            nArray[(int)l2] = this.nativeidxs[(int)l3];
        } else if (!this.idxmap.hasItem(l4)) {
            int n = this.model.append_linearvar(this, l4, this.dom.key, this.dom.get_rhs_item(l4));
            this.idxmap.setItem(l3, n);
            nArray[(int)l2] = n;
        } else {
            nArray[(int)l2] = this.idxmap.getItem(l3);
        }
    }

    public void dual_values(long l, int[] nArray, long[] lArray, int n, double[] dArray) throws SolutionError {
        int n2;
        long l2 = 1L;
        int n3 = lArray.length;
        IndexCounter indexCounter = new IndexCounter(l, nArray, lArray);
        double[] dArray2 = this.model.getSolution_slx(SolutionType.Default);
        double[] dArray3 = this.model.getSolution_sux(SolutionType.Default);
        int n4 = 0;
        int n5 = n3;
        for (n2 = n4; n2 < n5; ++n2) {
            l2 *= (long)nArray[n2];
        }
        if (this.nativeidxs != null) {
            long l3 = 0L;
            long l4 = l2;
            for (long i = l3; i < l4; ++i) {
                int n6 = this.nativeidxs[(int)this.tril_lin_idx(indexCounter.get())];
                dArray[(int)(i + (long)n)] = dArray2[n6] - dArray3[n6];
                indexCounter.inc();
            }
        } else {
            SolutionStatus solutionStatus = this.model.getPrimalSolutionStatus();
            n5 = 0;
            n2 = (int)l2;
            for (int i = n5; i < n2; ++i) {
                if (this.idxmap.hasItem(this.tril_lin_idx(indexCounter.get()))) {
                    int n7 = this.idxmap.getItem(indexCounter.get());
                    dArray[n + i] = dArray2[n7] - dArray3[n7];
                } else {
                    dArray[n + i] = 0.0;
                }
                indexCounter.inc();
            }
        }
    }

    public void dual_values(long[] lArray, int n, double[] dArray) throws SolutionError {
        double[] dArray2 = this.model.getSolution_slx(SolutionType.Default);
        double[] dArray3 = this.model.getSolution_sux(SolutionType.Default);
        if (this.nativeidxs != null) {
            int n2 = 0;
            int n3 = lArray.length;
            for (int i = n2; i < n3; ++i) {
                int n4 = this.nativeidxs[(int)this.tril_lin_idx(lArray[i])];
                dArray[n + i] = dArray2[n4] - dArray3[n4];
            }
        } else {
            SolutionStatus solutionStatus = this.model.getPrimalSolutionStatus();
            int n5 = 0;
            int n6 = lArray.length;
            for (int i = n5; i < n6; ++i) {
                if (this.idxmap.hasItem(lArray[i])) {
                    int n7 = this.idxmap.getItem(lArray[i]);
                    dArray[n + i] = dArray2[n7] - dArray3[n7];
                    continue;
                }
                dArray[n + i] = 0.0;
            }
        }
    }

    @Override
    public void set_values(long l, int[] nArray, long[] lArray, int n, double[] dArray, boolean bl) {
        if (bl) {
            int n2;
            long l2 = 1L;
            int n3 = lArray.length;
            IndexCounter indexCounter = new IndexCounter(l, nArray, lArray);
            int n4 = 0;
            int n5 = n3;
            for (n2 = n4; n2 < n5; ++n2) {
                l2 *= (long)nArray[n2];
            }
            if (this.nativeidxs != null) {
                double[] dArray2;
                n4 = this.nativeidxs.length;
                n5 = 0;
                n2 = 0;
                long l3 = l2;
                long l4 = (long)n2 < l3 ? l3 - (long)n2 : 0L;
                int[] nArray2 = new int[(int)l4];
                long l5 = n2;
                int n6 = 0;
                while ((long)n6 < l4) {
                    nArray2[n5] = this.nativeidxs[(int)this.tril_lin_idx(indexCounter.next())];
                    ++n5;
                    ++n6;
                    ++l5;
                }
                int[] nArray3 = nArray2;
                if (n > 0) {
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = n4;
                    int n10 = n8 < n9 ? n9 - n8 : 0;
                    double[] dArray3 = new double[n10];
                    int n11 = n8;
                    int n12 = 0;
                    while (n12 < n10) {
                        dArray3[n7] = dArray[n + n11];
                        ++n7;
                        ++n12;
                        ++n11;
                    }
                    dArray2 = dArray3;
                } else {
                    dArray2 = dArray;
                }
                double[] dArray4 = dArray2;
                this.model.setSolution_xx(nArray3, dArray4);
            } else {
                int[] nArray4 = new int[(int)l2];
                n5 = 0;
                long l6 = l2;
                for (long i = (long)n5; i < l6; ++i) {
                    this.inst(indexCounter.next(), i, nArray4, null, null);
                }
                n5 = 0;
                int n13 = 0;
                long l7 = l2;
                long l8 = (long)n13 < l7 ? l7 - (long)n13 : 0L;
                double[] dArray5 = new double[(int)l8];
                long l9 = n13;
                int n14 = 0;
                while ((long)n14 < l8) {
                    dArray5[n5] = dArray[(int)((long)n + l9)];
                    ++n5;
                    ++n14;
                    ++l9;
                }
                double[] dArray6 = dArray5;
                this.model.setSolution_xx(nArray4, dArray6);
            }
        }
    }

    @Override
    public void set_values(long[] lArray, double[] dArray, boolean bl) {
        if (bl) {
            if (this.nativeidxs != null) {
                int n = this.nativeidxs.length;
                int n2 = 0;
                int n3 = 0;
                int n4 = n;
                int n5 = n3 < n4 ? n4 - n3 : 0;
                int[] nArray = new int[n5];
                int n6 = n3;
                int n7 = 0;
                while (n7 < n5) {
                    nArray[n2] = this.nativeidxs[(int)this.tril_lin_idx(lArray[n6])];
                    ++n2;
                    ++n7;
                    ++n6;
                }
                int[] nArray2 = nArray;
                int n8 = 0;
                int n9 = 0;
                int n10 = n;
                int n11 = n9 < n10 ? n10 - n9 : 0;
                double[] dArray2 = new double[n11];
                int n12 = n9;
                int n13 = 0;
                while (n13 < n11) {
                    dArray2[n8] = dArray[n12];
                    ++n8;
                    ++n13;
                    ++n12;
                }
                double[] dArray3 = dArray2;
                this.model.setSolution_xx(nArray2, dArray3);
            } else {
                int[] nArray = new int[lArray.length];
                int n = 0;
                int n14 = lArray.length;
                for (int i = n; i < n14; ++i) {
                    this.inst(lArray[i], i, nArray, null, null);
                }
                this.model.setSolution_xx(nArray, dArray);
            }
        }
    }

    @Override
    public void values(long l, int[] nArray, long[] lArray, int n, double[] dArray, boolean bl) throws SolutionError {
        if (bl) {
            int n2;
            long l2 = 1L;
            int n3 = lArray.length;
            IndexCounter indexCounter = new IndexCounter(l, nArray, lArray);
            double[] dArray2 = this.model.getSolution_xx(SolutionType.Default);
            int n4 = 0;
            int n5 = n3;
            for (n2 = n4; n2 < n5; ++n2) {
                l2 *= (long)nArray[n2];
            }
            if (this.nativeidxs != null) {
                long l3 = 0L;
                long l4 = l2;
                for (long i = l3; i < l4; ++i) {
                    dArray[(int)(i + (long)n)] = dArray2[this.nativeidxs[(int)this.tril_lin_idx(indexCounter.get())]];
                    indexCounter.inc();
                }
            } else {
                SolutionStatus solutionStatus = this.model.getPrimalSolutionStatus();
                if (solutionStatus == SolutionStatus.Optimal || solutionStatus == SolutionStatus.NearOptimal || solutionStatus == SolutionStatus.Feasible || solutionStatus == SolutionStatus.NearFeasible) {
                    n5 = 0;
                    n2 = (int)l2;
                    for (int i = n5; i < n2; ++i) {
                        dArray[n + i] = this.idxmap.hasItem(indexCounter.get()) ? dArray2[this.idxmap.getItem(indexCounter.get())] : this.dom.get_rhs_item(this.tril_idx(indexCounter.get()));
                        indexCounter.inc();
                    }
                } else {
                    n5 = 0;
                    n2 = (int)l2;
                    for (int i = n5; i < n2; ++i) {
                        dArray[n + i] = this.idxmap.hasItem(indexCounter.get()) ? dArray2[this.idxmap.getItem(indexCounter.get())] : 0.0;
                        indexCounter.inc();
                    }
                }
            }
        } else {
            this.dual_values(l, nArray, lArray, n, dArray);
        }
    }

    @Override
    public void values(long[] lArray, int n, double[] dArray, boolean bl) throws SolutionError {
        if (bl) {
            double[] dArray2 = this.model.getSolution_xx(SolutionType.Default);
            if (this.nativeidxs != null) {
                int n2 = 0;
                int n3 = lArray.length;
                for (int i = n2; i < n3; ++i) {
                    dArray[n + i] = dArray2[this.nativeidxs[(int)this.tril_lin_idx(lArray[i])]];
                }
            } else {
                SolutionStatus solutionStatus = this.model.getPrimalSolutionStatus();
                if (solutionStatus == SolutionStatus.Optimal || solutionStatus == SolutionStatus.NearOptimal || solutionStatus == SolutionStatus.Feasible || solutionStatus == SolutionStatus.NearFeasible) {
                    int n4 = 0;
                    int n5 = lArray.length;
                    for (int i = n4; i < n5; ++i) {
                        long l = lArray[i];
                        dArray[n + i] = this.idxmap.hasItem(l) ? dArray2[this.idxmap.getItem(l)] : this.dom.get_rhs_item(this.tril_idx(l));
                    }
                } else {
                    int n6 = 0;
                    int n7 = lArray.length;
                    for (int i = n6; i < n7; ++i) {
                        long l = lArray[i];
                        dArray[n + i] = this.idxmap.hasItem(l) ? dArray2[this.idxmap.getItem(this.tril_idx(l))] : 0.0;
                    }
                }
            }
        } else {
            this.dual_values(lArray, n, dArray);
        }
    }

    @Override
    public void make_continuous(long[] lArray) {
        if (this.nativeidxs != null) {
            int n = 0;
            int n2 = 0;
            int n3 = lArray.length;
            int n4 = n2 < n3 ? n3 - n2 : 0;
            int[] nArray = new int[n4];
            int n5 = n2;
            int n6 = 0;
            while (n6 < n4) {
                nArray[n] = this.nativeidxs[(int)lArray[n5]];
                ++n;
                ++n6;
                ++n5;
            }
            this.getModel().task_var_putcontlist(nArray);
        } else {
            int[] nArray = new int[lArray.length];
            this.inst(lArray, 0, lArray.length, 0L, 0L, nArray, null, null);
            this.getModel().task_var_putcontlist(nArray);
        }
    }

    @Override
    public void make_integer(long[] lArray) {
        if (this.nativeidxs != null) {
            int n = 0;
            int n2 = 0;
            int n3 = lArray.length;
            int n4 = n2 < n3 ? n3 - n2 : 0;
            int[] nArray = new int[n4];
            int n5 = n2;
            int n6 = 0;
            while (n6 < n4) {
                nArray[n] = this.nativeidxs[(int)lArray[n5]];
                ++n;
                ++n6;
                ++n5;
            }
            this.getModel().task_var_putintlist(nArray);
        } else {
            int[] nArray = new int[lArray.length];
            this.inst(lArray, 0, lArray.length, 0L, 0L, nArray, null, null);
            this.getModel().task_var_putintlist(nArray);
        }
    }

    public long tril_idx(long l) {
        long l2 = l % (long)this.dim;
        long l3 = l / (long)this.dim;
        if (l2 > l3) {
            return l2 * (long)this.dim + l3;
        }
        return l;
    }

    public long tril_lin_idx(long l) {
        long l2 = l % (long)this.dim;
        long l3 = l / (long)this.dim;
        if (l2 > l3) {
            return l2 * (l2 + 1L) / 2L + l3;
        }
        return l3 * (l3 + 1L) / 2L + l2;
    }

    @Override
    public ModelVariable clone(Model model) {
        return new SymLinearVariable(this, model);
    }
}

