/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import java.io.Writer;
import mosek.DataCallback;
import mosek.Progress;
import mosek.Task;
import mosek.fusion.AccSolutionStatus;
import mosek.fusion.BaseModel;
import mosek.fusion.CommonTools;
import mosek.fusion.ConNZStruct;
import mosek.fusion.ConicConstraint;
import mosek.fusion.ConicVariable;
import mosek.fusion.Constraint;
import mosek.fusion.DimensionError;
import mosek.fusion.Domain;
import mosek.fusion.DomainError;
import mosek.fusion.Expr;
import mosek.fusion.Expression;
import mosek.fusion.FlatExpr;
import mosek.fusion.IndexError;
import mosek.fusion.IntSet;
import mosek.fusion.LengthError;
import mosek.fusion.LinPSDDomain;
import mosek.fusion.LinearConstraint;
import mosek.fusion.LinearDomain;
import mosek.fusion.LinearPSDConstraint;
import mosek.fusion.LinearPSDVariable;
import mosek.fusion.LinearVariable;
import mosek.fusion.ModelConstraint;
import mosek.fusion.ModelError;
import mosek.fusion.ModelVariable;
import mosek.fusion.NDSet;
import mosek.fusion.NameError;
import mosek.fusion.ObjectiveSense;
import mosek.fusion.OptimizeError;
import mosek.fusion.PSDConstraint;
import mosek.fusion.PSDDomain;
import mosek.fusion.PSDKey;
import mosek.fusion.PSDVariable;
import mosek.fusion.Parameters;
import mosek.fusion.ProblemStatus;
import mosek.fusion.QConeDomain;
import mosek.fusion.QConeKey;
import mosek.fusion.RangeDomain;
import mosek.fusion.RangedConstraint;
import mosek.fusion.RangedVariable;
import mosek.fusion.RelationKey;
import mosek.fusion.Set;
import mosek.fusion.SolutionError;
import mosek.fusion.SolutionStatus;
import mosek.fusion.SolutionStruct;
import mosek.fusion.SolutionType;
import mosek.fusion.Sort;
import mosek.fusion.SymLinearVariable;
import mosek.fusion.SymRangedVariable;
import mosek.fusion.SymmetricLinearDomain;
import mosek.fusion.SymmetricRangeDomain;
import mosek.fusion.SymmetricVariable;
import mosek.fusion.UnexpectedError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.StringIntMap;
import mosek.fusion.Utils.Tools;
import mosek.fusion.Variable;

public class Model
extends BaseModel {
    private int task_vars_used;
    private int task_vars_allocated;
    private StringIntMap con_map;
    private int cons_used;
    private ModelConstraint[] cons;
    protected int vars_used;
    protected ModelVariable[] vars;
    private boolean[] initsol_xx_flag;
    private double[] initsol_xx;
    protected int natbarvarmap_num;
    protected int[] natbarvarmap_Var;
    private StringIntMap var_map;
    private int natvarmap_num;
    private long[] natvarmap_idx;
    private int[] natvarmap_Var;
    private SolutionType solutionptr;
    private AccSolutionStatus acceptable_sol;
    private String model_name;

    private Model(Model model) {
        super(model);
        this.model_name = new StringBuffer().a(model.model_name).a("(clone)").toString();
        this.acceptable_sol = model.acceptable_sol;
        this.solutionptr = model.solutionptr;
        Model model2 = this;
        int n = 0;
        int n2 = 0;
        int n3 = model.vars_used;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        ModelVariable[] modelVariableArray = new ModelVariable[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            modelVariableArray[n] = model.vars[n5].clone(model2);
            ++n;
            ++n6;
            ++n5;
        }
        this.vars = modelVariableArray;
        this.vars_used = model.vars_used;
        this.var_map = model.var_map.clone();
        this.task_vars_allocated = model.task_vars_allocated;
        this.task_vars_used = model.task_vars_used;
        n6 = 0;
        int n7 = 0;
        int n8 = model.cons_used;
        int n9 = n7 < n8 ? n8 - n7 : 0;
        ModelConstraint[] modelConstraintArray = new ModelConstraint[n9];
        int n10 = n7;
        int n11 = 0;
        while (n11 < n9) {
            modelConstraintArray[n6] = model.cons[n10].clone(model2);
            ++n6;
            ++n11;
            ++n10;
        }
        this.cons = modelConstraintArray;
        this.cons_used = model.cons_used;
        this.con_map = model.con_map.clone();
        n11 = 0;
        int n12 = 0;
        int n13 = model.natvarmap_num;
        int n14 = n12 < n13 ? n13 - n12 : 0;
        int[] nArray = new int[n14];
        int n15 = n12;
        int n16 = 0;
        while (n16 < n14) {
            nArray[n11] = model.natvarmap_Var[n15];
            ++n11;
            ++n16;
            ++n15;
        }
        this.natvarmap_Var = nArray;
        n16 = 0;
        int n17 = 0;
        int n18 = model.natvarmap_num;
        int n19 = n17 < n18 ? n18 - n17 : 0;
        long[] lArray = new long[n19];
        int n20 = n17;
        int n21 = 0;
        while (n21 < n19) {
            lArray[n16] = model.natvarmap_idx[n20];
            ++n16;
            ++n21;
            ++n20;
        }
        this.natvarmap_idx = lArray;
        this.natvarmap_num = model.natvarmap_num;
        n21 = 0;
        int n22 = 0;
        int n23 = model.natvarmap_num;
        int n24 = n22 < n23 ? n23 - n22 : 0;
        int[] nArray2 = new int[n24];
        int n25 = n22;
        int n26 = 0;
        while (n26 < n24) {
            nArray2[n21] = model.natvarmap_Var[n25];
            ++n21;
            ++n26;
            ++n25;
        }
        this.natbarvarmap_Var = nArray2;
        this.natbarvarmap_num = model.natbarvarmap_num;
        this.initsol_xx = null;
        this.initsol_xx_flag = null;
    }

    public Model() {
        super("", "");
        this.model_name = "";
        this.acceptable_sol = AccSolutionStatus.Optimal;
        this.solutionptr = SolutionType.Default;
        this.natvarmap_Var = new int[1024];
        this.natvarmap_idx = new long[1024];
        this.natvarmap_num = 0;
        this.natbarvarmap_Var = new int[0];
        this.natbarvarmap_num = 0;
        this.task_vars_allocated = 0;
        this.task_vars_used = 0;
        this.initsol_xx = null;
        this.initsol_xx_flag = null;
        this.vars = new ModelVariable[1024];
        this.vars_used = 0;
        this.var_map = new StringIntMap();
        this.cons = new ModelConstraint[1024];
        this.cons_used = 0;
        this.con_map = new StringIntMap();
    }

    public Model(String string) {
        super(string, "");
        this.model_name = string;
        this.acceptable_sol = AccSolutionStatus.NearOptimal;
        this.solutionptr = SolutionType.Default;
        this.natvarmap_Var = new int[1024];
        this.natvarmap_idx = new long[1024];
        this.natvarmap_num = 0;
        this.natbarvarmap_Var = new int[0];
        this.natbarvarmap_num = 0;
        this.initsol_xx = null;
        this.initsol_xx_flag = null;
        this.vars = new ModelVariable[1024];
        this.vars_used = 0;
        this.var_map = new StringIntMap();
        this.task_vars_allocated = 0;
        this.task_vars_used = 0;
        this.cons = new ModelConstraint[1024];
        this.cons_used = 0;
        this.con_map = new StringIntMap();
    }

    public static void putlicensewait(boolean bl) {
        BaseModel.env_putlicensewait(bl);
    }

    public static void putlicensepath(String string) {
        BaseModel.env_putlicensepath(string);
    }

    public static void putlicensecode(int[] nArray) {
        BaseModel.env_putlicensecode(nArray);
    }

    public static void inst(Variable[] variableArray, int n, int n2, long[] lArray, int n3, int[] nArray, int[] nArray2, int[] nArray3) {
        int n4;
        long[] lArray2 = new long[variableArray.length + 1];
        int n5 = 0;
        int n6 = variableArray.length;
        for (n4 = n5; n4 < n6; ++n4) {
            lArray2[n4 + 1] = lArray2[n4] + variableArray[n4].size();
        }
        if (variableArray.length == 1) {
            variableArray[0].inst(lArray, n, n2, 0L, n3, nArray, nArray2, nArray3);
        } else if (variableArray.length == 2) {
            n5 = n;
            n6 = n2;
            for (n4 = n5; n4 < n6; ++n4) {
                if (lArray[n4] < lArray2[1]) {
                    variableArray[0].inst(lArray[n4], n3 + n4 - n, nArray, nArray2, nArray3);
                    continue;
                }
                variableArray[1].inst(lArray[n4] - lArray2[1], n3 + n4 - n, nArray, nArray2, nArray3);
            }
        } else if (variableArray.length == 3) {
            n5 = n;
            n6 = n2;
            for (n4 = n5; n4 < n6; ++n4) {
                if (lArray[n4] < lArray2[1]) {
                    variableArray[0].inst(lArray[n4], n3 + n4 - n, nArray, nArray2, nArray3);
                    continue;
                }
                if (lArray[n4] < lArray2[2]) {
                    variableArray[1].inst(lArray[n4] - lArray2[1], n3 + n4 - n, nArray, nArray2, nArray3);
                    continue;
                }
                variableArray[2].inst(lArray[n4] - lArray2[2], n3 + n4 - n, nArray, nArray2, nArray3);
            }
        } else {
            n5 = 4;
            long l = lArray2[variableArray.length];
            int n7 = 0;
            int n8 = variableArray.length;
            while (n8 > 0) {
                n8 /= 2;
                ++n7;
            }
            n8 = n;
            int n9 = n2;
            for (int i = n8; i < n9; ++i) {
                int n10 = lArray2.length / 2;
                int n11 = 0;
                int n12 = lArray2.length - 1;
                int n13 = 0;
                while (n11 < n12) {
                    n13 = (n11 + n12) / 2;
                    if (lArray[i] < lArray2[n13]) {
                        n12 = n13;
                        continue;
                    }
                    if (lArray[i] >= lArray2[n13 + 1]) {
                        n11 = n13;
                        continue;
                    }
                    n11 = n13;
                    n12 = n13;
                }
                n10 = n13;
                variableArray[n10].inst(lArray[i] - lArray2[n10], n3 + i - n, nArray, nArray2, nArray3);
            }
        }
    }

    public static void inst(Variable[] variableArray, long[] lArray, int[] nArray, int[] nArray2, int[] nArray3) {
        Model.inst(variableArray, 0, lArray.length, lArray, 0, nArray, nArray2, nArray3);
    }

    @Override
    public void dispose() {
        int n;
        int n2 = 0;
        int n3 = this.vars_used;
        for (n = n2; n < n3; ++n) {
            this.vars[n] = null;
        }
        this.vars_used = 0;
        n2 = 0;
        n3 = this.cons_used;
        for (n = n2; n < n3; ++n) {
            this.cons[n] = null;
        }
        this.cons_used = 0;
        super.dispose();
    }

    public void varname(int n, String string) {
        this.task_var_name(n, string);
    }

    public void nativeVarToStr(int n, StringBuffer stringBuffer) {
        if (n < 0 || n >= this.natvarmap_num) {
            throw new IndexError("Native variable index out of bounds");
        }
        this.vars[this.natvarmap_Var[n]].elementName(this.natvarmap_idx[n], stringBuffer);
    }

    public int append_linearvar(ModelVariable modelVariable, long l, RelationKey relationKey, double d) {
        int n = this.alloc_linearvar("", relationKey, d);
        this.natvarmap_ensure(1);
        this.natvarmap_idx[n] = l;
        this.natvarmap_Var[n] = this.vars_used;
        ++this.natvarmap_num;
        return n;
    }

    public int append_rangedvar(ModelVariable modelVariable, long l, double d, double d2) {
        int n = this.alloc_rangedvar("", d, d2);
        this.natvarmap_ensure(1);
        this.natvarmap_idx[n] = l;
        this.natvarmap_Var[n] = this.vars_used;
        ++this.natvarmap_num;
        return n;
    }

    public Task getTask() {
        return this.task_get();
    }

    public void flushNames() {
        int n;
        int n2 = 0;
        int n3 = this.vars_used;
        for (n = n2; n < n3; ++n) {
            this.vars[n].flushNames();
        }
        n2 = 0;
        n3 = this.cons_used;
        for (n = n2; n < n3; ++n) {
            this.cons[n].flushNames();
        }
    }

    public void writeTask(String string) {
        this.flushNames();
        this.task_setnumvar(this.task_vars_used);
        this.task_vars_allocated = this.task_vars_used;
        this.task_write(string);
    }

    public long getSolverLIntInfo(String string) {
        return this.task_get_liinf(string);
    }

    public int getSolverIntInfo(String string) {
        return this.task_get_iinf(string);
    }

    public double getSolverDoubleInfo(String string) {
        return this.task_get_dinf(string);
    }

    public void setCallbackHandler(Progress progress) {
        this.task_setCallbackHandler(progress);
    }

    public void setDataCallbackHandler(DataCallback dataCallback) {
        this.task_setDataCallbackHandler(dataCallback);
    }

    public void setLogHandler(Writer writer) {
        this.task_setLogHandler(writer);
    }

    public void setSolverParam(String string, double d) {
        Parameters.setParameter(this, string, d);
    }

    public void setSolverParam(String string, int n) {
        Parameters.setParameter(this, string, n);
    }

    public void setSolverParam(String string, String string2) {
        Parameters.setParameter(this, string, string2);
    }

    public void breakSolver() {
        this.task_break_solve();
    }

    public void solve() throws OptimizeError {
        this.flush_initsol(SolutionType.Interior);
        this.flush_initsol(SolutionType.Integer);
        this.flush_initsol(SolutionType.Basic);
        this.task_solve();
    }

    public void flushSolutions() {
        this.flush_initsol(SolutionType.Interior);
        this.flush_initsol(SolutionType.Integer);
        this.flush_initsol(SolutionType.Basic);
    }

    public void flush_initsol(SolutionType solutionType) {
        if (this.initsol_xx != null) {
            try {
                SolutionStruct solutionStruct = this.get_sol_cache(solutionType, true);
                if (solutionStruct.xx != null) {
                    int n = 0;
                    int n2 = this.initsol_xx.length;
                    for (int i = n; i < n2; ++i) {
                        if (this.initsol_xx_flag[i]) continue;
                        this.initsol_xx[i] = solutionStruct.xx[i];
                    }
                } else {
                    int n = 0;
                    int n3 = this.initsol_xx.length;
                    for (int i = n; i < n3; ++i) {
                        if (this.initsol_xx_flag[i]) continue;
                        this.initsol_xx[i] = 0.0;
                    }
                }
            }
            catch (SolutionError solutionError) {
                int n = 0;
                int n4 = this.initsol_xx.length;
                for (int i = n; i < n4; ++i) {
                    if (this.initsol_xx_flag[i]) continue;
                    this.initsol_xx[i] = 0.0;
                }
            }
            this.task_putxx_slice(solutionType, 0, this.initsol_xx.length, this.initsol_xx);
        }
    }

    public SolutionStatus getDualSolutionStatus() {
        SolutionStruct solutionStruct = null;
        if (this.solutionptr == SolutionType.Default) {
            solutionStruct = this.sol_itg != null ? this.sol_itg : (this.sol_bas != null ? this.sol_bas : this.sol_itr);
        } else if (this.solutionptr == SolutionType.Interior) {
            solutionStruct = this.sol_itr;
        } else if (this.solutionptr == SolutionType.Basic) {
            solutionStruct = this.sol_bas;
        } else if (this.solutionptr == SolutionType.Integer) {
            solutionStruct = this.sol_itg;
        }
        if (solutionStruct == null) {
            return SolutionStatus.Undefined;
        }
        if (!this.synched) {
            return SolutionStatus.Unknown;
        }
        return solutionStruct.dstatus;
    }

    public SolutionStatus getPrimalSolutionStatus() {
        SolutionStruct solutionStruct = null;
        solutionStruct = this.solutionptr == SolutionType.Default ? (this.sol_itg != null ? this.sol_itg : (this.sol_bas != null ? this.sol_bas : this.sol_itr)) : (this.solutionptr == SolutionType.Basic ? this.sol_bas : (this.solutionptr == SolutionType.Integer ? this.sol_itg : this.sol_itr));
        if (solutionStruct == null) {
            return SolutionStatus.Undefined;
        }
        if (!this.synched) {
            return SolutionStatus.Unknown;
        }
        return solutionStruct.pstatus;
    }

    public double dualObjValue() throws SolutionError {
        return this.get_sol_cache((SolutionType)SolutionType.Default, (boolean)false).dobj;
    }

    public double primalObjValue() throws SolutionError {
        return this.get_sol_cache((SolutionType)SolutionType.Default, (boolean)true).pobj;
    }

    public SolutionStruct get_sol_cache(SolutionType solutionType, boolean bl, boolean bl2) throws SolutionError {
        SolutionStruct solutionStruct = null;
        SolutionType solutionType2 = solutionType;
        if (solutionType2 == SolutionType.Default) {
            solutionType2 = this.solutionptr;
        }
        if (solutionType2 == SolutionType.Default) {
            solutionStruct = this.sol_itg != null ? this.sol_itg : (this.sol_bas != null ? this.sol_bas : this.sol_itr);
        } else if (solutionType2 == SolutionType.Interior) {
            solutionStruct = this.sol_itr;
        } else if (solutionType2 == SolutionType.Basic) {
            solutionStruct = this.sol_bas;
        } else if (solutionType2 == SolutionType.Integer) {
            solutionStruct = this.sol_itg;
        }
        if (solutionStruct == null) {
            throw new SolutionError("Solution not available");
        }
        if (bl && solutionStruct.isPrimalAcceptable(this.acceptable_sol) || !bl && solutionStruct.isDualAcceptable(this.acceptable_sol)) {
            return solutionStruct;
        }
        StringBuffer stringBuffer = new StringBuffer();
        SolutionStatus solutionStatus = solutionStruct.pstatus;
        if (!bl) {
            solutionStatus = solutionStruct.dstatus;
        }
        stringBuffer.a("Solution status is ");
        if (solutionStatus == SolutionStatus.Undefined) {
            stringBuffer.a("Undefined");
        } else if (solutionStatus == SolutionStatus.Unknown) {
            stringBuffer.a("Unknown");
        } else if (solutionStatus == SolutionStatus.Optimal) {
            stringBuffer.a("Optimal");
        } else if (solutionStatus == SolutionStatus.NearOptimal) {
            stringBuffer.a("NearOptimal");
        } else if (solutionStatus == SolutionStatus.Feasible) {
            stringBuffer.a("Feasible");
        } else if (solutionStatus == SolutionStatus.NearFeasible) {
            stringBuffer.a("NearFeasible");
        } else if (solutionStatus == SolutionStatus.Certificate) {
            stringBuffer.a("Certificate");
        } else if (solutionStatus == SolutionStatus.NearCertificate) {
            stringBuffer.a("NearCertificate");
        }
        stringBuffer.a(" but at least ");
        if (this.acceptable_sol == AccSolutionStatus.Anything) {
            stringBuffer.a("Anything");
        } else if (this.acceptable_sol == AccSolutionStatus.Optimal) {
            stringBuffer.a("Optimal");
        } else if (this.acceptable_sol == AccSolutionStatus.NearOptimal) {
            stringBuffer.a("NearOptimal");
        } else if (this.acceptable_sol == AccSolutionStatus.Feasible) {
            stringBuffer.a("Feasible");
        } else if (this.acceptable_sol == AccSolutionStatus.Certificate) {
            stringBuffer.a("Certificate");
        }
        stringBuffer.a(" is expected");
        throw new SolutionError(stringBuffer.toString());
    }

    public SolutionStruct get_sol_cache(SolutionType solutionType, boolean bl) throws SolutionError {
        return this.get_sol_cache(solutionType, bl, false);
    }

    public void setSolution_xx(int[] nArray, double[] dArray) {
        this.ensure_initsol_xx();
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            this.initsol_xx[nArray[i]] = dArray[i];
            this.initsol_xx_flag[nArray[i]] = true;
        }
    }

    public void ensure_initsol_xx() {
        if (this.initsol_xx == null) {
            this.initsol_xx = new double[this.natvarmap_num];
            int n = 0;
            int n2 = 0;
            int n3 = this.natvarmap_num;
            int n4 = n2 < n3 ? n3 - n2 : 0;
            boolean[] blArray = new boolean[n4];
            int n5 = n2;
            int n6 = 0;
            while (n6 < n4) {
                blArray[n] = false;
                ++n;
                ++n6;
                ++n5;
            }
            this.initsol_xx_flag = blArray;
        } else if (this.initsol_xx.length < this.natvarmap_num) {
            double[] dArray = this.initsol_xx;
            boolean[] blArray = this.initsol_xx_flag;
            this.initsol_xx = new double[this.natvarmap_num];
            this.initsol_xx_flag = new boolean[this.natvarmap_num];
            Tools.arraycopy(dArray, 0, this.initsol_xx, 0, this.natvarmap_num);
            int n = 0;
            int n7 = this.natvarmap_num;
            for (int i = n; i < n7; ++i) {
                this.initsol_xx_flag[i] = blArray[i];
            }
        }
    }

    public double[][] getSolution_bars(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)false).bars;
    }

    public double[][] getSolution_barx(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)false).barx;
    }

    public double[] getSolution_y(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)false).y;
    }

    public double[] getSolution_xc(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)true).xc;
    }

    public double[] getSolution_snx(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)false).snx;
    }

    public double[] getSolution_suc(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)false).suc;
    }

    public double[] getSolution_slc(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)false).slc;
    }

    public double[] getSolution_sux(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)false).sux;
    }

    public double[] getSolution_slx(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)false).slx;
    }

    public double[] getSolution_xx(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)true).xx;
    }

    public void selectedSolution(SolutionType solutionType) {
        this.solutionptr = solutionType;
    }

    public AccSolutionStatus getAcceptedSolutionStatus() {
        return this.acceptable_sol;
    }

    public void acceptedSolutionStatus(AccSolutionStatus accSolutionStatus) {
        this.acceptable_sol = accSolutionStatus;
    }

    public ProblemStatus getProblemStatus(SolutionType solutionType) {
        SolutionStruct solutionStruct = null;
        if (solutionType == SolutionType.Default) {
            solutionStruct = this.sol_itg != null ? this.sol_itg : (this.sol_bas != null ? this.sol_bas : this.sol_itr);
        } else if (solutionType == SolutionType.Interior) {
            solutionStruct = this.sol_itr;
        } else if (solutionType == SolutionType.Basic) {
            solutionStruct = this.sol_bas;
        } else if (solutionType == SolutionType.Integer) {
            solutionStruct = this.sol_itg;
        }
        if (solutionStruct == null) {
            return ProblemStatus.Unknown;
        }
        return solutionStruct.probstatus;
    }

    public SolutionStatus getDualSolutionStatus(SolutionType solutionType) {
        return this.getSolutionStatus(solutionType, false);
    }

    public SolutionStatus getPrimalSolutionStatus(SolutionType solutionType) {
        return this.getSolutionStatus(solutionType, true);
    }

    public SolutionStatus getSolutionStatus(SolutionType solutionType, boolean bl) {
        try {
            SolutionStruct solutionStruct = this.get_sol_cache(solutionType, bl, true);
            if (bl) {
                return solutionStruct.pstatus;
            }
            return solutionStruct.dstatus;
        }
        catch (SolutionError solutionError) {
            return SolutionStatus.Undefined;
        }
    }

    public void objective_(String string, ObjectiveSense objectiveSense, Expression expression) {
        long l;
        int n;
        int n2;
        this.task_putobjectivename(string);
        if (expression.getShape().size != 1L) {
            throw new LengthError("Objective expression must be of size 1.");
        }
        if (objectiveSense != ObjectiveSense.Minimize && objectiveSense != ObjectiveSense.Maximize) {
            throw new LengthError("Objective sense required.");
        }
        FlatExpr flatExpr = expression.eval();
        int n3 = 0;
        int n4 = flatExpr.x.length;
        for (n2 = n3; n2 < n4; ++n2) {
            if (flatExpr.x[n2].getModel() == null || flatExpr.x[n2].getModel() == this) continue;
            throw new ModelError("Expression belong to different models");
        }
        int[] nArray = null;
        double[] dArray = null;
        n2 = 0;
        int n5 = 0;
        int[] nArray2 = null;
        int[] nArray3 = null;
        int[] nArray4 = null;
        int n6 = flatExpr.subj.length;
        nArray2 = new int[n6];
        nArray3 = new int[n6];
        nArray4 = new int[n6];
        Model.inst(flatExpr.x, flatExpr.subj, nArray2, nArray3, nArray4);
        n5 = 0;
        for (n = 0; n < n6 && n < n6; ++n) {
            if (nArray2[n] < 0) continue;
            ++n5;
        }
        n2 = n6 - n5;
        if (n5 > 0) {
            nArray = new int[n5];
        }
        if (n2 == 0) {
            nArray = nArray2;
            dArray = flatExpr.cof;
        } else {
            n = 0;
            dArray = new double[n5];
            nArray = new int[n5];
            for (l = flatExpr.ptrb[0]; l < flatExpr.ptrb[1] && l < flatExpr.ptrb[1]; ++l) {
                if (nArray2[(int)l] < 0) continue;
                nArray[n] = nArray2[(int)l];
                dArray[n] = flatExpr.cof[(int)l];
                ++n;
            }
        }
        double d = 0.0;
        if (flatExpr.bfix != null) {
            d = flatExpr.bfix[0];
        }
        this.task_putobjective(objectiveSense == ObjectiveSense.Maximize, nArray, dArray, d);
        if (n2 > 0) {
            l = 0L;
            for (long i = flatExpr.ptrb[0]; i < flatExpr.ptrb[1] && i < flatExpr.ptrb[1]; ++i) {
                if (nArray2[(int)i] >= 0) continue;
                ++l;
            }
            if (l > 0L) {
                long[] lArray = new long[(int)l];
                long[] lArray2 = flatExpr.ptrb;
                int n7 = 0;
                for (long i = lArray2[0]; i < lArray2[1] && i < lArray2[1]; ++i) {
                    if (nArray2[(int)i] >= 0) continue;
                    lArray[n7] = i;
                    ++n7;
                }
                Sort.argsort(lArray, nArray2, 0L, l);
                n7 = 0;
                while ((long)n7 < l) {
                    int n8;
                    int n9 = n7++;
                    while ((long)n7 < l && nArray2[(int)lArray[n7]] == nArray2[(int)lArray[n7 - 1]]) {
                        ++n7;
                    }
                    int n10 = n7 - n9;
                    Sort.argsort(lArray, nArray3, nArray4, (long)n9, (long)n7);
                    int n11 = 1;
                    int n12 = n9 + 1;
                    int n13 = n7;
                    for (int i = n12; i < n13; ++i) {
                        long l2 = lArray[i];
                        long l3 = lArray[i - 1];
                        if (nArray3[(int)l2] == nArray3[(int)l3] && nArray4[(int)l2] == nArray4[(int)l3]) continue;
                        ++n11;
                    }
                    n12 = 0;
                    int[] nArray5 = new int[n11];
                    int[] nArray6 = new int[n11];
                    double[] dArray2 = new double[n11];
                    nArray5[0] = nArray3[(int)lArray[n9]];
                    nArray6[0] = nArray4[(int)lArray[n9]];
                    dArray2[0] = nArray5[0] == nArray6[0] ? flatExpr.cof[(int)lArray[n9]] : 0.5 * flatExpr.cof[(int)lArray[n9]];
                    int n14 = n9 + 1;
                    int n15 = n7;
                    for (n8 = n14; n8 < n15; ++n8) {
                        long l4 = lArray[n8];
                        long l5 = lArray[n8 - 1];
                        if (nArray3[(int)l4] != nArray3[(int)l5] || nArray4[(int)l4] != nArray4[(int)l5]) {
                            nArray5[++n12] = nArray3[(int)l4];
                            nArray6[n12] = nArray4[(int)l4];
                        }
                        dArray2[n12] = nArray5[n12] == nArray6[n12] ? dArray2[n12] + flatExpr.cof[(int)l4] : dArray2[n12] + 0.5 * flatExpr.cof[(int)l4];
                    }
                    n14 = -(nArray2[(int)lArray[n9]] + 1);
                    n15 = this.task_barvardim(n14);
                    n8 = this.task_append_barmatrix(n15, nArray5, nArray6, dArray2);
                    this.task_putbarcj(n14, n8);
                }
            }
        }
    }

    public void objective(double d) {
        this.objective_("", ObjectiveSense.Minimize, Expr.constTerm(d));
    }

    public void objective(ObjectiveSense objectiveSense, double d) {
        this.objective_("", objectiveSense, Expr.constTerm(d));
    }

    public void objective(ObjectiveSense objectiveSense, Variable variable) {
        this.objective_("", objectiveSense, variable.asExpr());
    }

    public void objective(ObjectiveSense objectiveSense, Expression expression) {
        this.objective_("", objectiveSense, expression);
    }

    public void objective(String string, double d) {
        this.objective_(string, ObjectiveSense.Minimize, Expr.constTerm(d));
    }

    public void objective(String string, ObjectiveSense objectiveSense, double d) {
        this.objective_(string, objectiveSense, Expr.constTerm(d));
    }

    public void objective(String string, ObjectiveSense objectiveSense, Variable variable) {
        this.objective_(string, objectiveSense, variable.asExpr());
    }

    public void objective(String string, ObjectiveSense objectiveSense, Expression expression) {
        this.objective_(string, objectiveSense, expression);
    }

    public Constraint constraint(Variable variable, QConeDomain qConeDomain) {
        return this.constraint_("", null, variable.asExpr(), qConeDomain);
    }

    public Constraint constraint(String string, Variable variable, QConeDomain qConeDomain) {
        return this.constraint_(string, null, variable.asExpr(), qConeDomain);
    }

    public Constraint constraint(Set set, Variable variable, QConeDomain qConeDomain) {
        return this.constraint_("", set, variable.asExpr(), qConeDomain);
    }

    public Constraint constraint(String string, Set set, Variable variable, QConeDomain qConeDomain) {
        return this.constraint_(string, set, variable.asExpr(), qConeDomain);
    }

    public Constraint constraint(Variable variable, RangeDomain rangeDomain) {
        return this.constraint_("", null, variable.asExpr(), rangeDomain);
    }

    public Constraint constraint(String string, Variable variable, RangeDomain rangeDomain) {
        return this.constraint_(string, null, variable.asExpr(), rangeDomain);
    }

    public Constraint constraint(Set set, Variable variable, RangeDomain rangeDomain) {
        return this.constraint_("", set, variable.asExpr(), rangeDomain);
    }

    public Constraint constraint(String string, Set set, Variable variable, RangeDomain rangeDomain) {
        return this.constraint_(string, set, variable.asExpr(), rangeDomain);
    }

    public Constraint constraint(Variable variable, LinearDomain linearDomain) {
        return this.constraint_("", null, variable.asExpr(), linearDomain);
    }

    public Constraint constraint(String string, Variable variable, LinearDomain linearDomain) {
        return this.constraint_(string, null, variable.asExpr(), linearDomain);
    }

    public Constraint constraint(Set set, Variable variable, LinearDomain linearDomain) {
        return this.constraint_("", set, variable.asExpr(), linearDomain);
    }

    public Constraint constraint(String string, Set set, Variable variable, LinearDomain linearDomain) {
        return this.constraint_(string, set, variable.asExpr(), linearDomain);
    }

    public Constraint constraint(Variable variable, LinPSDDomain linPSDDomain) {
        return this.constraint_("", variable.asExpr(), linPSDDomain);
    }

    public Constraint constraint(String string, Variable variable, LinPSDDomain linPSDDomain) {
        return this.constraint_(string, variable.asExpr(), linPSDDomain);
    }

    public Constraint constraint(Variable variable, PSDDomain pSDDomain) {
        return this.constraint_("", variable.asExpr(), pSDDomain);
    }

    public Constraint constraint(String string, Variable variable, PSDDomain pSDDomain) {
        return this.constraint_(string, variable.asExpr(), pSDDomain);
    }

    public Constraint constraint(Expression expression, QConeDomain qConeDomain) {
        return this.constraint_("", null, expression, qConeDomain);
    }

    public Constraint constraint(String string, Expression expression, QConeDomain qConeDomain) {
        return this.constraint_(string, null, expression, qConeDomain);
    }

    public Constraint constraint(Set set, Expression expression, QConeDomain qConeDomain) {
        return this.constraint_("", set, expression, qConeDomain);
    }

    public Constraint constraint(String string, Set set, Expression expression, QConeDomain qConeDomain) {
        return this.constraint_(string, set, expression, qConeDomain);
    }

    public Constraint constraint(Expression expression, RangeDomain rangeDomain) {
        return this.constraint_("", null, expression, rangeDomain);
    }

    public Constraint constraint(String string, Expression expression, RangeDomain rangeDomain) {
        return this.constraint_(string, null, expression, rangeDomain);
    }

    public Constraint constraint(Set set, Expression expression, RangeDomain rangeDomain) {
        return this.constraint_("", set, expression, rangeDomain);
    }

    public Constraint constraint(String string, Set set, Expression expression, RangeDomain rangeDomain) {
        return this.constraint_(string, set, expression, rangeDomain);
    }

    public Constraint constraint(Expression expression, LinearDomain linearDomain) {
        return this.constraint_("", null, expression, linearDomain);
    }

    public Constraint constraint(String string, Expression expression, LinearDomain linearDomain) {
        return this.constraint_(string, null, expression, linearDomain);
    }

    public Constraint constraint(Set set, Expression expression, LinearDomain linearDomain) {
        return this.constraint_("", set, expression, linearDomain);
    }

    public Constraint constraint(String string, Set set, Expression expression, LinearDomain linearDomain) {
        return this.constraint_(string, set, expression, linearDomain);
    }

    public Constraint constraint(Expression expression, LinPSDDomain linPSDDomain) {
        return this.constraint_("", expression, linPSDDomain);
    }

    public Constraint constraint(String string, Expression expression, LinPSDDomain linPSDDomain) {
        return this.constraint_(string, expression, linPSDDomain);
    }

    public Constraint constraint(Expression expression, PSDDomain pSDDomain) {
        return this.constraint_("", expression, pSDDomain);
    }

    public Constraint constraint(String string, Expression expression, PSDDomain pSDDomain) {
        return this.constraint_(string, expression, pSDDomain);
    }

    public Variable variable(LinPSDDomain linPSDDomain) {
        return this.variable_("", linPSDDomain.shape, linPSDDomain);
    }

    public Variable variable(int n, int n2, LinPSDDomain linPSDDomain) {
        return this.variable_("", Set.make(n, n, n2), linPSDDomain);
    }

    public Variable variable(int n, LinPSDDomain linPSDDomain) {
        return this.variable_("", Set.make(n, n), linPSDDomain);
    }

    public Variable variable(String string, LinPSDDomain linPSDDomain) {
        return this.variable_(string, null, linPSDDomain);
    }

    public Variable variable(String string, int n, int n2, LinPSDDomain linPSDDomain) {
        return this.variable_(string, Set.make(n, n, n2), linPSDDomain);
    }

    public Variable variable(String string, int n, LinPSDDomain linPSDDomain) {
        return this.variable_(string, Set.make(n, n), linPSDDomain);
    }

    public Variable variable(String string, Set set, LinPSDDomain linPSDDomain) {
        return this.variable_(string, set, linPSDDomain);
    }

    public Variable variable(PSDDomain pSDDomain) {
        return this.variable_("", pSDDomain.shape, pSDDomain);
    }

    public Variable variable(int n, int n2, PSDDomain pSDDomain) {
        return this.variable_("", Set.make(n, n, n2), pSDDomain);
    }

    public Variable variable(int n, PSDDomain pSDDomain) {
        return this.variable_("", Set.make(n, n), pSDDomain);
    }

    public Variable variable(String string, PSDDomain pSDDomain) {
        return this.variable_(string, null, pSDDomain);
    }

    public Variable variable(String string, int n, int n2, PSDDomain pSDDomain) {
        return this.variable_(string, Set.make(n, n, n2), pSDDomain);
    }

    public Variable variable(String string, int n, PSDDomain pSDDomain) {
        return this.variable_(string, Set.make(n, n), pSDDomain);
    }

    public Variable variable(String string, Set set, PSDDomain pSDDomain) {
        return this.variable_(string, set, pSDDomain);
    }

    public SymmetricVariable variable(int n, SymmetricLinearDomain symmetricLinearDomain) {
        return this.variable_("", n, symmetricLinearDomain);
    }

    public SymmetricVariable variable(String string, int n, SymmetricLinearDomain symmetricLinearDomain) {
        return this.variable_(string, n, symmetricLinearDomain);
    }

    public Variable variable(QConeDomain qConeDomain) {
        return this.variable_("", null, qConeDomain);
    }

    public Variable variable(RangeDomain rangeDomain) {
        return this.ranged_variable("", null, rangeDomain);
    }

    public Variable variable(LinearDomain linearDomain) {
        return this.variable_("", null, linearDomain);
    }

    public Variable variable(int[] nArray, RangeDomain rangeDomain) {
        return this.ranged_variable("", Set.make(nArray), rangeDomain);
    }

    public Variable variable(int[] nArray, LinearDomain linearDomain) {
        return this.variable_("", Set.make(nArray), linearDomain);
    }

    public Variable variable(Set set, QConeDomain qConeDomain) {
        return this.variable_("", set, qConeDomain);
    }

    public Variable variable(Set set, RangeDomain rangeDomain) {
        return this.ranged_variable("", set, rangeDomain);
    }

    public Variable variable(Set set, LinearDomain linearDomain) {
        return this.variable_("", set, linearDomain);
    }

    public Variable variable(int n, QConeDomain qConeDomain) {
        return this.variable_("", Set.make(n), qConeDomain);
    }

    public Variable variable(int n, RangeDomain rangeDomain) {
        return this.ranged_variable("", Set.make(n), rangeDomain);
    }

    public Variable variable(int n, LinearDomain linearDomain) {
        return this.variable_("", Set.make(n), linearDomain);
    }

    public Variable variable(int[] nArray) {
        return this.variable_("", Set.make(nArray), Domain.unbounded());
    }

    public Variable variable(int n) {
        return this.variable_("", Set.make(n), Domain.unbounded());
    }

    public Variable variable() {
        return this.variable_("", Set.make(1), Domain.unbounded());
    }

    public Variable variable(String string, QConeDomain qConeDomain) {
        return this.variable_(string, null, qConeDomain);
    }

    public Variable variable(String string, RangeDomain rangeDomain) {
        return this.ranged_variable(string, null, rangeDomain);
    }

    public Variable variable(String string, LinearDomain linearDomain) {
        return this.variable_(string, null, linearDomain);
    }

    public Variable variable(String string, int[] nArray, RangeDomain rangeDomain) {
        return this.ranged_variable(string, Set.make(nArray), rangeDomain);
    }

    public Variable variable(String string, int[] nArray, LinearDomain linearDomain) {
        return this.variable(string, Set.make(nArray), linearDomain);
    }

    public Variable variable(String string, Set set, QConeDomain qConeDomain) {
        return this.variable_(string, set, qConeDomain);
    }

    public Variable variable(String string, Set set, RangeDomain rangeDomain) {
        return this.ranged_variable(string, set, rangeDomain);
    }

    public Variable variable(String string, Set set, LinearDomain linearDomain) {
        return this.variable_(string, set, linearDomain);
    }

    public Variable variable(String string, int n, QConeDomain qConeDomain) {
        return this.variable_(string, Set.make(n), qConeDomain);
    }

    public Variable variable(String string, int n, RangeDomain rangeDomain) {
        return this.ranged_variable(string, Set.make(n), rangeDomain);
    }

    public Variable variable(String string, int n, LinearDomain linearDomain) {
        return this.variable_(string, Set.make(n), linearDomain);
    }

    public Variable variable(String string, int[] nArray) {
        return this.variable_(string, Set.make(nArray), Domain.unbounded());
    }

    public Variable variable(String string, int n) {
        return this.variable_(string, Set.make(n), Domain.unbounded());
    }

    public Variable variable(String string) {
        return this.variable_(string, Set.make(1), Domain.unbounded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable ranged_variable(String string, int n, SymmetricRangeDomain symmetricRangeDomain) {
        SymRangedVariable symRangedVariable = null;
        if (string.length() > 0 && this.hasVariable(string)) {
            throw new NameError(new StringBuffer().a("Duplicate variable name '").a(string).a("'").toString());
        }
        int n2 = n;
        if (n2 > 0) {
            if (symmetricRangeDomain.dim > 0 && symmetricRangeDomain.dim != n2) {
                throw new DimensionError("Mismatching shape and domain");
            }
        } else {
            n2 = symmetricRangeDomain.dim > 0 ? symmetricRangeDomain.dim : 1;
        }
        int n3 = this.task_vars_used;
        int n4 = this.task_numcon();
        int n5 = this.task_numcone();
        int n6 = this.task_numbarvar();
        try {
            int[] nArray = null;
            int n7 = n2 * (n2 + 1) / 2;
            int n8 = 0;
            if (symmetricRangeDomain.sparse_flag) {
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                n8 = this.task_alloc_vars(n7);
                this.natvarmap_ensure(n7);
                this.natvarmap_num += n7;
                int n16 = 0;
                double[] dArray = new double[1024];
                int n17 = 0;
                int n18 = n2;
                int n19 = n17 < n18 ? n18 - n17 : 0;
                int n20 = n17;
                int n21 = 0;
                while (n21 < n19) {
                    n15 = 0;
                    int n22 = n20;
                    n14 = n15 < n22 ? n22 - n15 : 0;
                    n13 = n15;
                    n12 = 0;
                    while (n12 < n14) {
                        if (dArray.length == n16) {
                            double[] dArray2 = new double[2 * dArray.length];
                            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
                            dArray = dArray2;
                        }
                        dArray[n16] = symmetricRangeDomain.get_lb_item(n20 * (n20 + 1) / 2 + n13);
                        ++n16;
                        ++n12;
                        ++n13;
                    }
                    ++n21;
                    ++n20;
                }
                if (dArray.length > n16) {
                    double[] dArray3 = new double[n16];
                    System.arraycopy(dArray, 0, dArray3, 0, n16);
                    dArray = dArray3;
                }
                double[] dArray4 = dArray;
                n15 = 0;
                double[] dArray5 = new double[1024];
                n14 = 0;
                n13 = n2;
                n12 = n14 < n13 ? n13 - n14 : 0;
                int n23 = n14;
                int n24 = 0;
                while (n24 < n12) {
                    n11 = 0;
                    n10 = n23;
                    n9 = n11 < n10 ? n10 - n11 : 0;
                    int n25 = n11;
                    int n26 = 0;
                    while (n26 < n9) {
                        if (dArray5.length == n15) {
                            double[] dArray6 = new double[2 * dArray5.length];
                            System.arraycopy(dArray5, 0, dArray6, 0, dArray5.length);
                            dArray5 = dArray6;
                        }
                        dArray5[n15] = symmetricRangeDomain.get_ub_item(n23 * (n23 + 1) / 2 + n25);
                        ++n15;
                        ++n26;
                        ++n25;
                    }
                    ++n24;
                    ++n23;
                }
                if (dArray5.length > n15) {
                    double[] dArray7 = new double[n15];
                    System.arraycopy(dArray5, 0, dArray7, 0, n15);
                    dArray5 = dArray7;
                }
                double[] dArray8 = dArray5;
                this.task_var_putboundslice_ra(n8, n8 + n7, dArray4, dArray8);
                nArray = new int[n7];
                n11 = 0;
                n10 = n7;
                for (n9 = n11; n9 < n10; ++n9) {
                    nArray[n9] = n8 + n9;
                }
                n11 = 0;
                n10 = n7;
                for (n9 = n11; n9 < n10; ++n9) {
                    this.natvarmap_idx[n9 + n8] = n9;
                }
                n11 = 0;
                n10 = n7;
                for (n9 = n11; n9 < n10; ++n9) {
                    this.natvarmap_Var[n9 + n8] = this.vars_used;
                }
            }
            symRangedVariable = new SymRangedVariable(this, string, symmetricRangeDomain, n2, nArray, this.numVariables());
            if (symmetricRangeDomain.cardinal_flag) {
                symRangedVariable.makeInteger();
            }
        }
        finally {
            if (symRangedVariable == null) {
                this.task_cleanup(n3, n4, n5, n6);
            }
        }
        this.addVariable(string, symRangedVariable);
        return symRangedVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable ranged_variable(String string, Set set, RangeDomain rangeDomain) {
        Set set2;
        RangedVariable rangedVariable = null;
        if (string.length() > 0 && this.hasVariable(string)) {
            throw new NameError(new StringBuffer().a("Duplicate variable name '").a(string).a("'").toString());
        }
        if (set != null) {
            if (!rangeDomain.match_shape(set)) {
                throw new DimensionError("Mismatching shape and domain");
            }
            set2 = set;
        } else {
            set2 = rangeDomain.shape;
            if (set2 == null) {
                set2 = new IntSet(1);
            }
        }
        int n = this.task_vars_used;
        int n2 = this.task_numcon();
        int n3 = this.task_numcone();
        int n4 = this.task_numbarvar();
        try {
            int[] nArray = null;
            int n5 = (int)set2.size;
            int n6 = 0;
            if (!rangeDomain.sparse_flag) {
                int n7;
                n6 = this.task_alloc_vars(n5);
                this.natvarmap_ensure(n5);
                this.natvarmap_num += n5;
                int n8 = 0;
                long l = 0L;
                int n9 = n5;
                long l2 = l < (long)n9 ? (long)n9 - l : 0L;
                double[] dArray = new double[(int)l2];
                long l3 = l;
                int n10 = 0;
                while ((long)n10 < l2) {
                    dArray[n8] = rangeDomain.get_lb_item(l3);
                    ++n8;
                    ++n10;
                    ++l3;
                }
                double[] dArray2 = dArray;
                int n11 = 0;
                long l4 = 0L;
                int n12 = n5;
                long l5 = l4 < (long)n12 ? (long)n12 - l4 : 0L;
                double[] dArray3 = new double[(int)l5];
                long l6 = l4;
                int n13 = 0;
                while ((long)n13 < l5) {
                    dArray3[n11] = rangeDomain.get_ub_item(l6);
                    ++n11;
                    ++n13;
                    ++l6;
                }
                double[] dArray4 = dArray3;
                this.task_var_putboundslice_ra(n6, n6 + n5, dArray2, dArray4);
                nArray = new int[n5];
                int n14 = 0;
                int n15 = n5;
                for (n7 = n14; n7 < n15; ++n7) {
                    nArray[n7] = n6 + n7;
                }
                n14 = 0;
                n15 = n5;
                for (n7 = n14; n7 < n15; ++n7) {
                    this.natvarmap_idx[n7 + n6] = n7;
                }
                n14 = 0;
                n15 = n5;
                for (n7 = n14; n7 < n15; ++n7) {
                    this.natvarmap_Var[n7 + n6] = this.vars_used;
                }
            }
            rangedVariable = new RangedVariable(this, string, set2, rangeDomain, nArray, this.numVariables());
            if (rangeDomain.cardinal_flag) {
                rangedVariable.makeInteger();
            }
        }
        finally {
            if (rangedVariable == null) {
                this.task_cleanup(n, n2, n3, n4);
            }
        }
        this.addVariable(string, rangedVariable);
        return rangedVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable variable_(String string, Set set, QConeDomain qConeDomain) {
        int n;
        int n2;
        int n3;
        Set set2;
        ConicVariable conicVariable = null;
        ConicVariable conicVariable2 = null;
        if (string.length() > 0 && this.hasVariable(string)) {
            throw new NameError(new StringBuffer().a("Duplicate variable name '").a(string).a("'").toString());
        }
        Set set3 = set != null ? set : (set2 = qConeDomain.shape != null ? qConeDomain.shape : new IntSet(1));
        if (!qConeDomain.match_shape(set2) || qConeDomain.getAxis() >= set2.nd) {
            throw new DimensionError("Mismatching shape and domain");
        }
        int n4 = qConeDomain.shape != null ? qConeDomain.getAxis() : set2.nd - 1;
        int n5 = set2._dim(n4);
        int n6 = 1;
        int n7 = 0;
        int n8 = set2.nd;
        for (n3 = n7; n3 < n8; ++n3) {
            if (n4 == n3) continue;
            n6 *= set2._dim(n3);
        }
        n7 = 1;
        n8 = 0;
        n3 = n4;
        for (n2 = n8; n2 < n3; ++n2) {
            n7 *= set2._dim(n2);
        }
        n8 = 1;
        n3 = n4 + 1;
        n2 = set2.nd;
        for (n = n3; n < n2; ++n) {
            n8 *= set2._dim(n);
        }
        if (qConeDomain.key == QConeKey.InQCone && n5 < 2 || qConeDomain.key == QConeKey.InRotatedQCone && n5 < 3) {
            throw new DimensionError("Invalid size for cone");
        }
        n3 = this.task_vars_used;
        n2 = this.task_numcon();
        n = this.task_numcone();
        int n9 = this.task_numbarvar();
        try {
            int n10;
            int n11 = (int)set2.size;
            int n12 = this.task_alloc_vars(n11);
            this.natvarmap_ensure(n11);
            this.natvarmap_num += n11;
            int n13 = n12 + n11;
            int n14 = 0;
            int n15 = n13 - n12;
            for (n10 = n14; n10 < n15; ++n10) {
                this.natvarmap_idx[n10 + n12] = n10;
            }
            this.task_var_putboundslice_fr(n12, n13);
            if (qConeDomain.int_flag) {
                this.task_var_putintlist(Tools.range(n12, n13));
            }
            n15 = 0;
            n10 = 0;
            int n16 = n6 * n5;
            int n17 = n10 < n16 ? n16 - n10 : 0;
            int[] nArray = new int[n17];
            int n18 = n10;
            int n19 = 0;
            while (n19 < n17) {
                nArray[n15] = n18 + n12;
                ++n15;
                ++n19;
                ++n18;
            }
            int[] nArray2 = nArray;
            n14 = qConeDomain.key == QConeKey.InQCone ? this.task_append_quadcone(n5, n12, n6, n7, n8) : this.task_append_rquadcone(n5, n12, n6, n7, n8);
            conicVariable2 = new ConicVariable(this, string, qConeDomain, set2, nArray2, n5, n14, n6, this.numVariables());
            if (qConeDomain.int_flag) {
                // empty if block
            }
            int n20 = 0;
            int n21 = n11;
            for (int i = n20; i < n21; ++i) {
                this.natvarmap_Var[i + n12] = this.vars_used;
            }
            conicVariable = conicVariable2;
        }
        finally {
            if (conicVariable == null) {
                this.natvarmap_num = n3;
                this.natbarvarmap_num = n9;
                this.task_cleanup(n3, n2, n, n9);
            }
        }
        this.addVariable(string, conicVariable);
        return conicVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymmetricVariable variable_(String string, int n, SymmetricLinearDomain symmetricLinearDomain) {
        SymLinearVariable symLinearVariable = null;
        if (string.length() > 0 && this.hasVariable(string)) {
            throw new NameError(new StringBuffer().a("Duplicate variable name '").a(string).a("'").toString());
        }
        int n2 = n;
        if (n2 > 0) {
            if (symmetricLinearDomain.dim > 0 && symmetricLinearDomain.dim != n2) {
                throw new DimensionError("Mismatching shape and domain");
            }
        } else {
            n2 = symmetricLinearDomain.dim > 0 ? symmetricLinearDomain.dim : 1;
        }
        int n3 = this.task_vars_used;
        int n4 = this.task_numcon();
        int n5 = this.task_numcone();
        int n6 = this.task_numbarvar();
        try {
            int n7;
            int n8;
            int n9;
            int[] nArray = null;
            RelationKey relationKey = symmetricLinearDomain.key;
            int n10 = n2 * (n2 + 1) / 2;
            int n11 = 0;
            if (!symmetricLinearDomain.sparse_flag) {
                int n12;
                int n13;
                int n14;
                int n15;
                n11 = this.task_alloc_vars(n10);
                this.natvarmap_ensure(n10);
                this.natvarmap_num += n10;
                if (relationKey == RelationKey.IsFree) {
                    this.task_var_putboundslice_fr(n11, n11 + n10);
                } else {
                    double[] dArray = new double[n10];
                    n9 = 0;
                    n8 = 0;
                    n15 = n2;
                    for (int i = n8; i < n15; ++i) {
                        n14 = 0;
                        n13 = i;
                        for (n12 = n14; n12 < n13; ++n12) {
                            dArray[n9] = symmetricLinearDomain.get_rhs_item(i * n2 + n12);
                            ++n9;
                        }
                    }
                    if (relationKey == RelationKey.LessThan) {
                        this.task_var_putboundslice_up(n11, n11 + n10, dArray);
                    } else if (relationKey == RelationKey.GreaterThan) {
                        this.task_var_putboundslice_lo(n11, n11 + n10, dArray);
                    } else if (relationKey == RelationKey.EqualsTo) {
                        this.task_var_putboundslice_fx(n11, n11 + n10, dArray);
                    }
                }
                n7 = 0;
                n9 = 0;
                n8 = n10;
                n15 = n9 < n8 ? n8 - n9 : 0;
                int[] nArray2 = new int[n15];
                n14 = n9;
                n13 = 0;
                while (n13 < n15) {
                    nArray2[n7] = n11 + n14;
                    ++n7;
                    ++n13;
                    ++n14;
                }
                nArray = nArray2;
                n13 = 0;
                n12 = n10;
                for (int i = n13; i < n12; ++i) {
                    this.natvarmap_idx[i + n11] = i;
                }
            }
            symLinearVariable = new SymLinearVariable(this, string, symmetricLinearDomain, n2, nArray, this.numVariables());
            if (symmetricLinearDomain.cardinal_flag) {
                symLinearVariable.makeInteger();
            }
            if (!symmetricLinearDomain.sparse_flag) {
                n7 = 0;
                n9 = n10;
                for (n8 = n7; n8 < n9; ++n8) {
                    this.natvarmap_Var[n8 + n11] = this.vars_used;
                }
            }
        }
        finally {
            if (symLinearVariable == null) {
                this.task_cleanup(n3, n4, n5, n6);
            }
        }
        this.addVariable(string, symLinearVariable);
        return symLinearVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable variable_(String string, Set set, LinearDomain linearDomain) {
        Set set2;
        LinearVariable linearVariable = null;
        LinearVariable linearVariable2 = null;
        if (string.length() > 0 && this.hasVariable(string)) {
            throw new NameError(new StringBuffer().a("Duplicate variable name '").a(string).a("'").toString());
        }
        if (set != null) {
            if (!linearDomain.match_shape(set)) {
                throw new DimensionError("Mismatching shape and domain");
            }
            set2 = set;
        } else {
            set2 = linearDomain.shape;
            if (set2 == null) {
                set2 = new IntSet(1);
            }
        }
        int n = this.task_vars_used;
        int n2 = this.task_numcon();
        int n3 = this.task_numcone();
        int n4 = this.task_numbarvar();
        try {
            int n5;
            int n6;
            int n7;
            int[] nArray = null;
            RelationKey relationKey = linearDomain.key;
            int n8 = (int)set2.size;
            int n9 = 0;
            if (!linearDomain.sparse_flag) {
                int n10;
                n9 = this.task_alloc_vars(n8);
                this.natvarmap_ensure(n8);
                this.natvarmap_num += n8;
                if (relationKey == RelationKey.IsFree) {
                    this.task_var_putboundslice_fr(n9, n9 + n8);
                } else {
                    double[] dArray = new double[n8];
                    n7 = 0;
                    n6 = n8;
                    for (n10 = n7; n10 < n6; ++n10) {
                        dArray[n10] = linearDomain.get_rhs_item(n10);
                    }
                    if (relationKey == RelationKey.LessThan) {
                        this.task_var_putboundslice_up(n9, n9 + n8, dArray);
                    } else if (relationKey == RelationKey.GreaterThan) {
                        this.task_var_putboundslice_lo(n9, n9 + n8, dArray);
                    } else if (relationKey == RelationKey.EqualsTo) {
                        this.task_var_putboundslice_fx(n9, n9 + n8, dArray);
                    }
                }
                n5 = 0;
                n7 = 0;
                n6 = n8;
                n10 = n7 < n6 ? n6 - n7 : 0;
                int[] nArray2 = new int[n10];
                int n11 = n7;
                int n12 = 0;
                while (n12 < n10) {
                    nArray2[n5] = n9 + n11;
                    ++n5;
                    ++n12;
                    ++n11;
                }
                nArray = nArray2;
                n12 = 0;
                int n13 = n8;
                for (int i = n12; i < n13; ++i) {
                    this.natvarmap_idx[i + n9] = i;
                }
            }
            linearVariable2 = new LinearVariable(this, string, linearDomain, set2, nArray, this.numVariables());
            if (linearDomain.cardinal_flag) {
                // empty if block
            }
            linearVariable = linearVariable2;
            if (linearDomain.cardinal_flag) {
                linearVariable2.makeInteger();
            }
            if (!linearDomain.sparse_flag) {
                n5 = 0;
                n7 = n8;
                for (n6 = n5; n6 < n7; ++n6) {
                    this.natvarmap_Var[n6 + n9] = this.vars_used;
                }
            }
        }
        finally {
            if (linearVariable == null) {
                this.task_cleanup(n, n2, n3, n4);
            }
        }
        this.addVariable(string, linearVariable);
        return linearVariable;
    }

    public Variable variable_(String string, Set set, LinPSDDomain linPSDDomain) {
        Set set2 = null;
        if (set == null) {
            if (linPSDDomain.shape == null) {
                throw new DimensionError("Missing shape for variable");
            }
            set2 = linPSDDomain.shape;
        } else if (linPSDDomain.shape == null) {
            set2 = set;
        } else {
            if (set.nd != linPSDDomain.shape.nd || set._dim(0) != linPSDDomain.shape._dim(0) || set._dim(1) != linPSDDomain.shape._dim(1)) {
                throw new DimensionError("Ambiguous dimensions for variable");
            }
            set2 = set;
        }
        int n = set2._dim(0);
        int n2 = (int)((Tools.sqrt(1 + 8 * n) - 1.0) / 2.0);
        if (n2 * (n2 + 1) / 2 != n) {
            throw new DimensionError("Invalid size for semidefinite variable");
        }
        int n3 = 1;
        int n4 = 1;
        int n5 = set2.nd;
        for (int i = n4; i < n5; ++i) {
            n3 *= set2._dim(i);
        }
        n4 = this.task_append_barvar(n2, n3);
        LinearPSDVariable linearPSDVariable = new LinearPSDVariable(this, string, n2, set2, n4, this.numVariables());
        this.natbarvarmap_ensure(1);
        this.natbarvarmap_Var[this.natbarvarmap_num] = this.vars_used;
        ++this.natbarvarmap_num;
        this.addVariable(string, linearPSDVariable);
        return linearPSDVariable;
    }

    public SymmetricVariable variable_(String string, Set set, PSDDomain pSDDomain) {
        int n;
        int n2;
        if (set != null) {
            if (set.nd != 2 && set.nd != 3) {
                throw new DimensionError("Invalid shape for semidefinite variables");
            }
            if (set._dim(0) != set._dim(1)) {
                throw new DimensionError("Invalid shape for semidefinite variables");
            }
            n2 = set._dim(0);
            n = set.nd > 2 ? set._dim(2) : 1;
            if (pSDDomain.shape != null && (pSDDomain.shape._dim(0) != n2 || pSDDomain.shape.nd == 3 && pSDDomain.shape._dim(2) != n)) {
                throw new DomainError("Domain and shape do not match");
            }
        } else {
            if (pSDDomain.shape == null) {
                throw new DomainError("Either domain size of shape must be defined");
            }
            n2 = pSDDomain.shape._dim(0);
            n = pSDDomain.shape._dim(2);
        }
        int n3 = this.task_append_barvar(n2, n);
        PSDVariable pSDVariable = new PSDVariable(this, string, n2, n3, n, this.numVariables());
        this.natbarvarmap_ensure(1);
        this.natbarvarmap_Var[this.natbarvarmap_num] = this.vars_used;
        ++this.natbarvarmap_num;
        this.addVariable(string, pSDVariable);
        return pSDVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint constraint_(String string, Set set, Expression expression, RangeDomain rangeDomain) {
        int n;
        Set set2;
        RangedConstraint rangedConstraint = null;
        if (string.length() > 0 && this.hasConstraint(string)) {
            throw new NameError(new StringBuffer().a("Duplicate constraint name '").a(string).a("'").toString());
        }
        Set set3 = set2 = set != null ? set : expression.getShape();
        if (!rangeDomain.match_shape(set2)) {
            throw new DimensionError("Mismatching shape and domain");
        }
        FlatExpr flatExpr = expression.eval();
        int n2 = 0;
        int n3 = flatExpr.x.length;
        for (n = n2; n < n3; ++n) {
            if (flatExpr.x[n].getModel() == null || flatExpr.x[n].getModel() == this) continue;
            throw new ModelError("Expression belong to different models");
        }
        ConNZStruct conNZStruct = this.build_conA(flatExpr.ptrb, set2.size, flatExpr.inst, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.x);
        n3 = conNZStruct.ptrb.length - 1;
        n = this.task_vars_used;
        int n4 = this.task_numcone();
        int n5 = this.task_numcon();
        int n6 = this.task_numbarvar();
        try {
            int n7;
            int n8;
            Object object;
            int n9 = n3;
            int n10 = this.task_append_con(n9);
            int n11 = n10 + n9;
            if (string.length() > 0) {
                object = new StringBuffer();
                for (n8 = 0; n8 < n9 && n8 < n9; ++n8) {
                    ((StringBuffer)object).clear().a(string).a("[").a(n8).a("]");
                    this.task_con_name(n8 + n10, ((StringBuffer)object).toString());
                }
            }
            if (conNZStruct.subj != null && conNZStruct.subj.length > 0) {
                this.task_putarowslice(n10, n11, conNZStruct.ptrb, conNZStruct.subj, conNZStruct.cof);
            }
            if (conNZStruct.barsubi != null) {
                int n12 = 0;
                n8 = conNZStruct.barsubi.length;
                for (n7 = n12; n7 < n8; ++n7) {
                    this.task_putbaraij(conNZStruct.barsubi[n7] + n10, conNZStruct.barsubj[n7], conNZStruct.barmidx[n7]);
                }
            }
            object = new double[n3];
            double[] dArray = new double[n3];
            if (conNZStruct.bfix != null) {
                n7 = 0;
                int n13 = n3;
                for (int i = n7; i < n13; ++i) {
                    object[i] = rangeDomain.get_lb_item(i) - conNZStruct.bfix[i];
                    dArray[i] = rangeDomain.get_ub_item(i) - conNZStruct.bfix[i];
                }
            } else {
                n7 = conNZStruct.ptrb.length - 1;
                int n14 = 0;
                int n15 = n3;
                for (int i = n14; i < n15; ++i) {
                    object[i] = rangeDomain.get_lb_item(i);
                    dArray[i] = rangeDomain.get_ub_item(i);
                }
            }
            int[] nArray = Tools.range(n10, n11);
            this.task_con_putboundslice_ra(n10, n11, (double[])object, dArray);
            rangedConstraint = new RangedConstraint(this, string, set2, rangeDomain, nArray, conNZStruct.ptrb, conNZStruct.subj, conNZStruct.cof, conNZStruct.bfix, conNZStruct.barsubi, conNZStruct.barsubj, conNZStruct.barmidx);
            this.addConstraint(string, rangedConstraint);
        }
        finally {
            if (rangedConstraint == null) {
                this.natvarmap_num = n;
                this.natbarvarmap_num = n6;
                this.task_cleanup(n, n5, n4, n6);
            }
        }
        return rangedConstraint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint constraint_(String string, Set set, Expression expression, QConeDomain qConeDomain) {
        int n;
        int n2;
        int n3;
        int n4;
        Set set2;
        ConicConstraint conicConstraint = null;
        int n5 = (int)expression.getShape().size;
        if (string.length() > 0 && this.hasConstraint(string)) {
            throw new NameError(new StringBuffer().a("Duplicate constraint name '").a(string).a("'").toString());
        }
        Set set3 = set != null ? set : (set2 = qConeDomain.shape != null ? qConeDomain.shape : expression.getShape());
        if (qConeDomain.shape != null && !qConeDomain.match_shape(set2) || expression.getShape() != null && !set2.compare(expression.getShape())) {
            throw new DimensionError("Mismatching shape and domain");
        }
        int n6 = qConeDomain.shape != null ? qConeDomain.getAxis() : set2.nd - 1;
        int n7 = set2._dim(n6);
        int n8 = 1;
        int n9 = 0;
        int n10 = set2.nd;
        for (n4 = n9; n4 < n10; ++n4) {
            if (n6 == n4) continue;
            n8 *= set2._dim(n4);
        }
        n9 = 1;
        n10 = 0;
        n4 = n6;
        for (n3 = n10; n3 < n4; ++n3) {
            n9 *= set2._dim(n3);
        }
        n10 = 1;
        n4 = n6 + 1;
        n3 = set2.nd;
        for (n2 = n4; n2 < n3; ++n2) {
            n10 *= set2._dim(n2);
        }
        FlatExpr flatExpr = expression.eval();
        n3 = 0;
        n2 = flatExpr.x.length;
        for (n = n3; n < n2; ++n) {
            if (flatExpr.x[n].getModel() == null || flatExpr.x[n].getModel() == this) continue;
            throw new ModelError("Expression belong to different models");
        }
        ConNZStruct conNZStruct = this.build_conA(flatExpr.ptrb, set2.size, flatExpr.inst, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.x);
        n2 = conNZStruct.ptrb.length - 1;
        n = this.task_vars_used;
        int n11 = this.task_numcon();
        int n12 = this.task_numcone();
        int n13 = this.task_numbarvar();
        try {
            int n14;
            int n15;
            int n16;
            int n17;
            int n18 = this.task_append_con(n2);
            int n19 = n18 + n2;
            if (conNZStruct.subj != null && conNZStruct.subj.length > 0) {
                this.task_putarowslice(n18, n19, conNZStruct.ptrb, conNZStruct.subj, conNZStruct.cof);
            }
            if (conNZStruct.barsubi != null) {
                int n20 = 0;
                int n21 = conNZStruct.barsubi.length;
                for (n17 = n20; n17 < n21; ++n17) {
                    this.task_putbaraij(conNZStruct.barsubi[n17] + n18, conNZStruct.barsubj[n17], conNZStruct.barmidx[n17]);
                }
            }
            int[] nArray = Tools.range(n18, n19);
            double[] dArray = new double[n19 - n18];
            n17 = n7 * n8;
            double[] dArray2 = new double[n17];
            double[] dArray3 = conNZStruct.bfix;
            double[] dArray4 = flatExpr.bfix;
            if (conNZStruct.bfix == null) {
                n16 = 0;
                n15 = n19 - n18;
                for (n14 = n16; n14 < n15; ++n14) {
                    dArray[n14] = -conNZStruct.bfix[n14];
                }
            }
            if (flatExpr.bfix != null) {
                n16 = 0;
                n15 = n17;
                for (n14 = n16; n14 < n15; ++n14) {
                    dArray2[n14] = -conNZStruct.bfix[n14];
                }
            }
            this.task_con_putboundslice_fx(n18, n19, dArray2);
            int n22 = this.task_alloc_vars(n17);
            this.natvarmap_ensure(n17);
            this.natvarmap_num += n17;
            int n23 = n22 + n17;
            n16 = 0;
            n15 = 0;
            n14 = n17;
            int n24 = n15 < n14 ? n14 - n15 : 0;
            double[] dArray5 = new double[n24];
            int n25 = n15;
            int n26 = 0;
            while (n26 < n24) {
                dArray5[n16] = -1.0;
                ++n16;
                ++n26;
                ++n25;
            }
            this.task_putaijlist(Tools.range(n18, n19), Tools.range(n22, n23), dArray5, n17);
            this.task_var_putboundslice_fr(n22, n23);
            n26 = qConeDomain.key == QConeKey.InQCone ? this.task_append_quadcone(n7, n22, n8, n9, n10) : this.task_append_rquadcone(n7, n22, n8, n9, n10);
            conicConstraint = new ConicConstraint(this, string, qConeDomain, set2, Tools.range(n18, n19), n22, n23, n7, n26, n8, conNZStruct.ptrb, conNZStruct.subj, conNZStruct.cof, conNZStruct.bfix, conNZStruct.barsubi, conNZStruct.barsubj, conNZStruct.barmidx);
            this.addConstraint(string, conicConstraint);
            ConicConstraint conicConstraint2 = conicConstraint;
            return conicConstraint2;
        }
        finally {
            if (conicConstraint == null) {
                this.natvarmap_num = n;
                this.natbarvarmap_num = n13;
                this.task_cleanup(n, n11, n12, n13);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint constraint_(String string, Set set, Expression expression, LinearDomain linearDomain) {
        int n;
        Set set2;
        LinearConstraint linearConstraint = null;
        int n2 = (int)expression.getShape().size;
        if (string.length() > 0 && this.hasConstraint(string)) {
            throw new NameError(new StringBuffer().a("Duplicate constraint name '").a(string).a("'").toString());
        }
        Set set3 = set != null ? set : (set2 = linearDomain.shape != null ? linearDomain.shape : expression.getShape());
        if (linearDomain.shape != null && !linearDomain.match_shape(set2) || expression.getShape() != null && !set2.compare(expression.getShape())) {
            throw new DimensionError("Mismatching shape and domain");
        }
        FlatExpr flatExpr = expression.eval();
        int n3 = 0;
        int n4 = flatExpr.x.length;
        for (n = n3; n < n4; ++n) {
            if (flatExpr.x[n].getModel() == null || flatExpr.x[n].getModel() == this) continue;
            throw new ModelError("Expression belong to different models");
        }
        ConNZStruct conNZStruct = this.build_conA(flatExpr.ptrb, set2.size, flatExpr.inst, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.x);
        n4 = conNZStruct.ptrb.length - 1;
        n = this.task_vars_used;
        int n5 = this.task_numcon();
        int n6 = this.task_numcone();
        int n7 = this.task_numbarvar();
        try {
            double[] dArray;
            int n8;
            int n9;
            int n10;
            int n11 = n4;
            int n12 = this.task_append_con(n11);
            int n13 = n12 + n11;
            if (conNZStruct.subj != null && conNZStruct.subj.length > 0) {
                this.task_putarowslice(n12, n13, conNZStruct.ptrb, conNZStruct.subj, conNZStruct.cof);
            }
            if (conNZStruct.barsubi != null) {
                int n14 = 0;
                int n15 = conNZStruct.barsubi.length;
                for (n10 = n14; n10 < n15; ++n10) {
                    this.task_putbaraij(conNZStruct.barsubi[n10] + n12, conNZStruct.barsubj[n10], conNZStruct.barmidx[n10]);
                }
            }
            int[] nArray = Tools.range(n12, n13);
            if (conNZStruct.bfix == null) {
                n10 = 0;
                n9 = 0;
                n8 = n13 - n12;
                int n16 = n9 < n8 ? n8 - n9 : 0;
                double[] dArray2 = new double[n16];
                int n17 = n9;
                int n18 = 0;
                while (n18 < n16) {
                    dArray2[n10] = linearDomain.get_rhs_item(n17);
                    ++n10;
                    ++n18;
                    ++n17;
                }
                dArray = dArray2;
            } else {
                n10 = 0;
                n9 = 0;
                n8 = n13 - n12;
                int n19 = n9 < n8 ? n8 - n9 : 0;
                double[] dArray3 = new double[n19];
                int n20 = n9;
                int n21 = 0;
                while (n21 < n19) {
                    dArray3[n10] = linearDomain.get_rhs_item(n20) - conNZStruct.bfix[n20];
                    ++n10;
                    ++n21;
                    ++n20;
                }
                dArray = dArray3;
            }
            double[] dArray4 = dArray;
            RelationKey relationKey = linearDomain.key;
            if (relationKey == RelationKey.IsFree) {
                this.task_con_putboundslice_fr(n12, n13);
            } else if (relationKey == RelationKey.LessThan) {
                this.task_con_putboundslice_up(n12, n13, dArray4);
            } else if (relationKey == RelationKey.GreaterThan) {
                this.task_con_putboundslice_lo(n12, n13, dArray4);
            } else {
                this.task_con_putboundslice_fx(n12, n13, dArray4);
            }
            linearConstraint = new LinearConstraint(this, string, linearDomain, set2, nArray, conNZStruct.ptrb, conNZStruct.subj, conNZStruct.cof, conNZStruct.bfix, conNZStruct.barsubi, conNZStruct.barsubj, conNZStruct.barmidx);
            this.addConstraint(string, linearConstraint);
            LinearConstraint linearConstraint2 = linearConstraint;
            return linearConstraint2;
        }
        finally {
            if (linearConstraint == null) {
                this.natvarmap_num = n;
                this.natbarvarmap_num = n7;
                this.task_cleanup(n, n5, n6, n7);
            }
        }
    }

    public ConNZStruct build_conA(long[] lArray, long l, long[] lArray2, long[] lArray3, double[] dArray, double[] dArray2, Variable[] variableArray) {
        long l2;
        int n;
        long l3;
        int n2;
        int n3;
        long l4;
        long l5;
        long l6;
        int n4;
        int n5;
        int n6;
        Object[] objectArray;
        int n7;
        long[] lArray4;
        int[] nArray = null;
        long[] lArray5 = new long[(int)(l + 1L)];
        double[] dArray3 = null;
        if (lArray2 != null) {
            lArray4 = lArray2;
        } else {
            int n8 = 0;
            long l7 = 0L;
            n7 = lArray.length - 1;
            long l8 = l7 < (long)n7 ? (long)n7 - l7 : 0L;
            objectArray = new long[(int)l8];
            long l9 = l7;
            int n9 = 0;
            while ((long)n9 < l8) {
                objectArray[n8] = l9++;
                ++n8;
                ++n9;
            }
            lArray4 = objectArray;
        }
        long[] lArray6 = lArray4;
        double[] dArray4 = dArray2;
        int n10 = 0;
        n7 = 0;
        int n11 = lArray3.length;
        int[] nArray2 = new int[n11];
        int[] nArray3 = new int[n11];
        objectArray = new int[n11];
        int[] nArray4 = new int[n11];
        Model.inst(variableArray, lArray3, nArray2, nArray3, (int[])objectArray);
        long[] lArray7 = Tools.range((long)lArray3.length);
        if (n11 > 3 * lArray.length) {
            n6 = 0;
            n5 = lArray.length - 1;
            for (n4 = n6; n4 < n5; ++n4) {
                Sort.argsort(lArray7, nArray2, lArray[n4], lArray[n4 + 1], true);
                l6 = lArray[n4];
                l5 = lArray[n4 + 1];
                for (l4 = l6; l4 < l5; ++l4) {
                    nArray4[(int)l4] = n4;
                }
            }
        } else {
            n6 = 0;
            n5 = lArray.length - 1;
            for (n4 = n6; n4 < n5; ++n4) {
                l6 = lArray[n4];
                l5 = lArray[n4 + 1];
                for (l4 = l6; l4 < l5; ++l4) {
                    nArray4[(int)l4] = n4;
                }
            }
            Sort.argsort(lArray7, nArray4, nArray2, 0L, (long)lArray7.length, true);
        }
        n7 = 0;
        n10 = 0;
        if (lArray7.length > 0) {
            if (nArray2[(int)lArray7[0]] >= 0) {
                ++n7;
            } else {
                ++n10;
            }
            n6 = 1;
            n5 = n11;
            for (n4 = n6; n4 < n5; ++n4) {
                if (nArray2[(int)lArray7[n4]] < 0) {
                    ++n10;
                    continue;
                }
                if (nArray4[(int)lArray7[n4]] == nArray4[(int)lArray7[n4 - 1]] && nArray2[(int)lArray7[n4]] == nArray2[(int)lArray7[n4 - 1]]) continue;
                ++n7;
            }
        }
        if (n7 == n11) {
            nArray = nArray2;
            dArray3 = dArray;
            if ((long)lArray6.length == l) {
                lArray5 = lArray;
            } else {
                n6 = 0;
                n5 = 0;
                n4 = lArray5.length - 1;
                for (int i = n5; i < n4; ++i) {
                    lArray5[i + 1] = n6 < lArray6.length && (long)i == lArray6[n6] ? lArray[++n6] : lArray5[i];
                }
            }
        } else {
            n6 = 0;
            long l10 = 0L;
            nArray = new int[n7];
            dArray3 = new double[n7];
            int n12 = 0;
            n3 = 0;
            int n13 = lArray5.length - 1;
            for (n2 = n3; n2 < n13; ++n2) {
                if (n12 >= lArray6.length || (long)n2 != lArray6[n12]) {
                    lArray5[n2 + 1] = lArray5[n2];
                    continue;
                }
                for (l4 = lArray[n12]; l4 < lArray[n12 + 1] && nArray2[(int)lArray7[(int)l4]] < 0; ++l4) {
                }
                for (l3 = l4; l3 < lArray[n12 + 1]; ++l3) {
                }
                if (l3 > l4) {
                    n = 0;
                    nArray[(int)lArray5[n2]] = nArray2[(int)lArray7[(int)l4]];
                    dArray3[(int)lArray5[n2]] = dArray[(int)lArray7[(int)l4]];
                    l2 = l4 + 1L;
                    long l11 = l3;
                    for (long i = l2; i < l11; ++i) {
                        if (nArray2[(int)lArray7[(int)(i - 1L)]] != nArray2[(int)lArray7[(int)i]]) {
                            nArray[(int)((long)(++n) + lArray5[n2])] = nArray2[(int)lArray7[(int)i]];
                            dArray3[(int)((long)n + lArray5[n2])] = dArray[(int)lArray7[(int)i]];
                            continue;
                        }
                        int n14 = (int)((long)n + lArray5[n2]);
                        dArray3[n14] = dArray3[n14] + dArray[(int)lArray7[(int)i]];
                    }
                    lArray5[n2 + 1] = lArray5[n2] + (long)n + 1L;
                } else {
                    lArray5[n2 + 1] = lArray5[n2];
                }
                ++n12;
            }
        }
        long[] lArray8 = lArray5;
        nArray4 = null;
        int[] nArray5 = null;
        int[] nArray6 = null;
        n4 = 0;
        if (n10 > 0) {
            int n15;
            int n16 = 0;
            n3 = lArray.length - 1;
            for (n15 = n16; n15 < n3; ++n15) {
                long l12;
                for (l12 = lArray[n15]; l12 < lArray[n15 + 1] && nArray2[(int)lArray7[(int)l12]] < 0; ++l12) {
                }
                if (l12 <= lArray[n15]) continue;
                ++n4;
                long l13 = lArray[n15] + 1L;
                long l14 = l12;
                for (l2 = l13; l2 < l14; ++l2) {
                    if (nArray2[(int)lArray7[(int)(l2 - 1L)]] == nArray2[(int)lArray7[(int)l2]]) continue;
                    ++n4;
                }
            }
            if (n4 > 0) {
                n16 = 0;
                nArray4 = new int[n4];
                nArray5 = new int[n4];
                nArray6 = new int[n4];
                n3 = 0;
                n15 = lArray.length - 1;
                for (n2 = n3; n2 < n15; ++n2) {
                    l4 = lArray[n2];
                    while (l4 < lArray[n2 + 1] && nArray2[(int)lArray7[(int)l4]] < 0) {
                        long l15;
                        l3 = l4;
                        n = nArray2[(int)lArray7[(int)l4]];
                        ++l4;
                        while (l4 < lArray[n2 + 1] && nArray2[(int)lArray7[(int)l4]] == n) {
                            ++l4;
                        }
                        int n17 = -(n + 1);
                        int n18 = this.task_barvardim(n17);
                        long l16 = l3;
                        long l17 = l4;
                        for (long i = l16; i < l17; ++i) {
                            long l18 = lArray7[(int)i];
                            if (nArray3[(int)l18] < objectArray[(int)l18]) {
                                int n19 = nArray3[(int)l18];
                                nArray3[(int)l18] = (int)objectArray[(int)l18];
                                objectArray[(int)l18] = n19;
                                int n20 = (int)l18;
                                dArray[n20] = dArray[n20] * 0.5;
                                continue;
                            }
                            if (nArray3[(int)l18] <= objectArray[(int)l18]) continue;
                            int n21 = (int)l18;
                            dArray[n21] = dArray[n21] * 0.5;
                        }
                        if (l4 - l3 > 1L) {
                            if (l4 - l3 < (long)(2 * n18)) {
                                Sort.argsort(lArray7, nArray3, (int[])objectArray, l3, l4, true);
                            } else {
                                Sort.argbucketsort(lArray7, (int[])objectArray, l3, l4, 0, n18);
                                Sort.argbucketsort(lArray7, nArray3, l3, l4, 0, n18);
                            }
                        }
                        int n22 = 1;
                        long l19 = l3 + 1L;
                        long l20 = l4;
                        for (l15 = l19; l15 < l20; ++l15) {
                            if (objectArray[(int)lArray7[(int)l15]] == objectArray[(int)lArray7[(int)(l15 - 1L)]] && nArray3[(int)lArray7[(int)l15]] == nArray3[(int)lArray7[(int)(l15 - 1L)]]) continue;
                            ++n22;
                        }
                        int[] nArray7 = new int[n22];
                        int[] nArray8 = new int[n22];
                        double[] dArray5 = new double[n22];
                        int n23 = 0;
                        nArray7[0] = nArray3[(int)lArray7[(int)l3]];
                        nArray8[0] = (int)objectArray[(int)lArray7[(int)l3]];
                        dArray5[0] = dArray[(int)lArray7[(int)l3]];
                        l15 = l3 + 1L;
                        long l21 = l4;
                        for (long i = l15; i < l21; ++i) {
                            if (objectArray[(int)lArray7[(int)i]] != objectArray[(int)lArray7[(int)(i - 1L)]] || nArray3[(int)lArray7[(int)i]] != nArray3[(int)lArray7[(int)(i - 1L)]]) {
                                nArray7[++n23] = nArray3[(int)lArray7[(int)i]];
                                nArray8[n23] = (int)objectArray[(int)lArray7[(int)i]];
                                dArray5[n23] = dArray[(int)lArray7[(int)i]];
                                continue;
                            }
                            int n24 = n23;
                            dArray5[n24] = dArray5[n24] + dArray[(int)lArray7[(int)i]];
                        }
                        nArray4[n16] = (int)lArray6[n2];
                        nArray5[n16] = n17;
                        nArray6[n16] = this.task_append_barmatrix(n18, nArray7, nArray8, dArray5);
                        ++n16;
                    }
                }
            }
        }
        double[] dArray6 = new double[(int)l];
        if (dArray2 != null) {
            n3 = 0;
            int n25 = lArray6.length;
            for (n2 = n3; n2 < n25; ++n2) {
                dArray6[(int)lArray6[n2]] = dArray2[n2];
            }
        }
        return new ConNZStruct(lArray5, nArray, dArray3, dArray6, nArray4, nArray5, nArray6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint constraint_(String string, Expression expression, LinPSDDomain linPSDDomain) {
        int n;
        int n2;
        Set set;
        LinearPSDConstraint linearPSDConstraint = null;
        int n3 = (int)expression.getShape().size;
        if (string.length() > 0 && this.hasConstraint(string)) {
            throw new NameError(new StringBuffer().a("Duplicate constraint name '").a(string).a("'").toString());
        }
        Set set2 = set = linPSDDomain.shape != null ? linPSDDomain.shape : expression.getShape();
        if (linPSDDomain.shape != null && !linPSDDomain.shape.compare(set) || expression.getShape() != null && !set.compare(expression.getShape())) {
            throw new DimensionError("Mismatching shape and domain");
        }
        int n4 = (int)((Tools.sqrt(1 + 8 * set._dim(0)) - 1.0) / 2.0);
        if (n4 * (n4 + 1) / 2 != set._dim(0)) {
            throw new DimensionError("Invalid size for semidefinite variable");
        }
        boolean bl = false;
        int n5 = set._dim(0);
        int n6 = 1;
        int n7 = 1;
        int n8 = set.nd;
        for (n2 = n7; n2 < n8; ++n2) {
            n6 *= set._dim(n2);
        }
        FlatExpr flatExpr = expression.eval();
        n8 = 0;
        n2 = flatExpr.x.length;
        for (n = n8; n < n2; ++n) {
            if (flatExpr.x[n].getModel() == null || flatExpr.x[n].getModel() == this) continue;
            throw new ModelError("Expression belong to different models");
        }
        ConNZStruct conNZStruct = this.build_conA(flatExpr.ptrb, set.size, flatExpr.inst, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.x);
        n2 = conNZStruct.ptrb.length - 1;
        n = this.task_vars_used;
        int n9 = this.task_numcon();
        int n10 = this.task_numcone();
        int n11 = this.task_numbarvar();
        try {
            double[] dArray;
            int n12;
            int n13;
            double[] dArray2;
            int n14;
            int n15;
            int n16;
            int n17;
            double[] dArray3;
            int n18;
            int n19 = this.task_append_con(n2);
            int n20 = n19 + n2;
            if (conNZStruct.subj != null && conNZStruct.subj.length > 0) {
                this.task_putarowslice(n19, n20, conNZStruct.ptrb, conNZStruct.subj, conNZStruct.cof);
            }
            if (conNZStruct.barsubi != null) {
                int n21 = 0;
                int n22 = conNZStruct.barsubi.length;
                for (n18 = n21; n18 < n22; ++n18) {
                    this.task_putbaraij(conNZStruct.barsubi[n18] + n19, conNZStruct.barsubj[n18], conNZStruct.barmidx[n18]);
                }
            }
            int[] nArray = Tools.range(n19, n20);
            if (conNZStruct.bfix == null) {
                dArray3 = new double[n20 - n19];
            } else {
                n18 = 0;
                n17 = 0;
                int n23 = n20 - n19;
                n16 = n17 < n23 ? n23 - n17 : 0;
                double[] dArray4 = new double[n16];
                n15 = n17;
                n14 = 0;
                while (n14 < n16) {
                    dArray4[n18] = -conNZStruct.bfix[n15];
                    ++n18;
                    ++n14;
                    ++n15;
                }
                dArray3 = dArray4;
            }
            double[] dArray5 = dArray3;
            n17 = n5 * n6;
            if (flatExpr.bfix != null) {
                n16 = 0;
                int n24 = 0;
                n15 = n17;
                n14 = n24 < n15 ? n15 - n24 : 0;
                dArray2 = new double[n14];
                n13 = n24;
                n12 = 0;
                while (n12 < n14) {
                    dArray2[n16] = -conNZStruct.bfix[n13];
                    ++n16;
                    ++n12;
                    ++n13;
                }
                dArray = dArray2;
            } else {
                dArray = new double[n17];
            }
            double[] dArray6 = dArray;
            this.task_con_putboundslice_fx(n19, n20, dArray6);
            int n25 = this.task_append_barvar(n4, n6);
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            dArray2 = new double[1];
            n13 = 0;
            n12 = 0;
            int n26 = n4;
            for (int i = n12; i < n26; ++i) {
                nArray3[0] = i;
                int n27 = i;
                int n28 = n4;
                for (int j = n27; j < n28; ++j) {
                    nArray2[0] = j;
                    dArray2[0] = -(j == i ? 1.0 : 0.5);
                    int n29 = this.task_append_barmatrix(n4, nArray2, nArray3, dArray2);
                    int n30 = 0;
                    int n31 = n6;
                    for (int k = n30; k < n31; ++k) {
                        this.task_putbaraij(n19 + n13 + k * n5, n25 + k, n29);
                    }
                    ++n13;
                }
            }
            linearPSDConstraint = new LinearPSDConstraint(this, string, set, Tools.range(n19, n20), n5, n25, n6, conNZStruct.ptrb, conNZStruct.subj, conNZStruct.cof, conNZStruct.bfix, conNZStruct.barsubi, conNZStruct.barsubj, conNZStruct.barmidx);
            this.addConstraint(string, linearPSDConstraint);
        }
        finally {
            if (linearPSDConstraint == null) {
                this.natvarmap_num = n;
                this.natbarvarmap_num = n11;
                this.task_cleanup(n, n9, n10, n11);
            }
        }
        return linearPSDConstraint;
    }

    public Constraint constraint_(String string, Expression expression, PSDDomain pSDDomain) {
        if (pSDDomain.key == PSDKey.IsSymPSD) {
            return this.nonsym_psdconstraint(string, expression, pSDDomain);
        }
        if (pSDDomain.key == PSDKey.IsTrilPSD) {
            int n;
            FlatExpr flatExpr = expression.eval();
            int n2 = 0;
            int n3 = flatExpr.x.length;
            for (n = n2; n < n3; ++n) {
                if (flatExpr.x[n].getModel() == null || flatExpr.x[n].getModel() == this) continue;
                throw new ModelError("Expression belong to different models");
            }
            if (flatExpr.shape.nd != 2 && flatExpr.shape.nd != 3 || flatExpr.shape._dim(0) != flatExpr.shape._dim(1)) {
                throw new DomainError("Invalid expression shape for semidefinite constraint");
            }
            n2 = flatExpr.shape._dim(0);
            n3 = 1;
            if (flatExpr.shape.nd > 2) {
                n3 = flatExpr.shape._dim(2);
            }
            n = n3 * n2 * (n2 + 1) / 2;
            if (pSDDomain.shape != null && (pSDDomain.shape._dim(0) != n2 || pSDDomain.shape._dim(2) != n3)) {
                throw new DomainError("Expression shape does not match domain");
            }
            long[] lArray = new long[n];
            int n4 = 0;
            int n5 = 0;
            int n6 = n3;
            for (int i = n5; i < n6; ++i) {
                int n7 = 0;
                int n8 = n2;
                for (int j = n7; j < n8; ++j) {
                    int n9 = 0;
                    int n10 = j + 1;
                    for (int k = n9; k < n10; ++k) {
                        lArray[n4] = i * n2 * n2 + j * n2 + k;
                        ++n4;
                    }
                }
            }
            double[] dArray = flatExpr.bfix;
            if (dArray == null) {
                dArray = new double[flatExpr.ptrb.length - 1];
            }
            return this.sdptrilcon(string, n2, n3, flatExpr.ptrb, flatExpr.inst, lArray, flatExpr.subj, flatExpr.cof, dArray, flatExpr.x);
        }
        throw new UnexpectedError("Invalid domain");
    }

    public Constraint nonsym_psdconstraint(String string, Expression expression, PSDDomain pSDDomain) {
        long l;
        int n;
        FlatExpr flatExpr = expression.eval();
        if (flatExpr.shape.nd != 2 && flatExpr.shape.nd != 3 || flatExpr.shape._dim(0) != flatExpr.shape._dim(1)) {
            throw new DomainError("Invalid expression shape for semidefinite constraint");
        }
        int n2 = flatExpr.shape._dim(0);
        int n3 = 1;
        if (flatExpr.shape.nd > 2) {
            n3 = flatExpr.shape._dim(2);
        }
        int n4 = n3 * n2 * (n2 + 1) / 2;
        if (pSDDomain.shape != null && (pSDDomain.shape._dim(0) != n2 || pSDDomain.shape._dim(1) != n2 || pSDDomain.shape._dim(2) != n3)) {
            throw new DomainError("Expression shape does not match domain");
        }
        if (flatExpr.inst == null || flatExpr.inst.length == n4) {
            long l2;
            long l3;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            long l4 = n4;
            long[] lArray = new long[(int)l4];
            long[] lArray2 = new long[(int)(l4 + 1L)];
            double[] dArray = new double[flatExpr.subj.length];
            long[] lArray3 = new long[flatExpr.subj.length];
            int n12 = 0;
            int n13 = 0;
            long l5 = l4;
            long l6 = (long)n13 < l5 ? l5 - (long)n13 : 0L;
            long[] lArray4 = new long[(int)l6];
            long l7 = n13;
            int n14 = 0;
            while ((long)n14 < l6) {
                lArray4[n12] = l7++;
                ++n12;
                ++n14;
            }
            long[] lArray5 = lArray4;
            double[] dArray2 = null;
            int n15 = 0;
            int n16 = 0;
            int n17 = n3;
            for (n11 = n16; n11 < n17; ++n11) {
                n10 = 0;
                n9 = n2;
                for (n8 = n10; n8 < n9; ++n8) {
                    n7 = 0;
                    n6 = n8 + 1;
                    for (n5 = n7; n5 < n6; ++n5) {
                        l3 = n11 * n2 * n2 + n8 * n2 + n5;
                        l2 = n11 * n2 * n2 + n5 * n2 + n8;
                        lArray2[n15 + 1] = n8 == n5 ? flatExpr.ptrb[(int)(l3 + 1L)] - flatExpr.ptrb[(int)l3] : flatExpr.ptrb[(int)(l3 + 1L)] - flatExpr.ptrb[(int)l3] + flatExpr.ptrb[(int)(l2 + 1L)] - flatExpr.ptrb[(int)l2];
                        lArray[n15] = l3;
                        ++n15;
                    }
                }
            }
            n16 = 0;
            n17 = n4;
            for (n11 = n16; n11 < n17; ++n11) {
                lArray2[n11 + 1] = lArray2[n11 + 1] + lArray2[n11];
            }
            if (flatExpr.bfix != null) {
                dArray2 = new double[lArray.length];
                n15 = 0;
                n16 = 0;
                n17 = n3;
                for (n11 = n16; n11 < n17; ++n11) {
                    n10 = 0;
                    n9 = n2;
                    for (n8 = n10; n8 < n9; ++n8) {
                        n7 = 0;
                        n6 = n8 + 1;
                        for (n5 = n7; n5 < n6; ++n5) {
                            l3 = n11 * n2 * n2 + n8 * n2 + n5;
                            l2 = n11 * n2 * n2 + n5 * n2 + n8;
                            dArray2[n15] = n8 == n5 ? flatExpr.bfix[(int)l3] : 0.5 * (flatExpr.bfix[(int)l3] + flatExpr.bfix[(int)l2]);
                            ++n15;
                        }
                    }
                }
            }
            n15 = 0;
            n16 = 0;
            n17 = n3;
            for (n11 = n16; n11 < n17; ++n11) {
                n10 = 0;
                n9 = n2;
                for (n8 = n10; n8 < n9; ++n8) {
                    n7 = 0;
                    n6 = n8 + 1;
                    for (n5 = n7; n5 < n6; ++n5) {
                        int n18 = n11 * n2 * n2 + n8 * n2 + n5;
                        int n19 = n11 * n2 * n2 + n5 * n2 + n8;
                        if (n8 == n5) {
                            Tools.arraycopy(flatExpr.subj, flatExpr.ptrb[n18], lArray3, lArray2[n15], flatExpr.ptrb[n18 + 1] - flatExpr.ptrb[n18]);
                            Tools.arraycopy(flatExpr.cof, flatExpr.ptrb[n18], dArray, lArray2[n15], flatExpr.ptrb[n18 + 1] - flatExpr.ptrb[n18]);
                        } else {
                            long l8;
                            l2 = flatExpr.ptrb[n18 + 1] - flatExpr.ptrb[n18];
                            long l9 = flatExpr.ptrb[n19 + 1] - flatExpr.ptrb[n19];
                            Tools.arraycopy(flatExpr.subj, flatExpr.ptrb[n18], lArray3, lArray2[n15], l2);
                            Tools.arraycopy(flatExpr.subj, flatExpr.ptrb[n19], lArray3, lArray2[n15] + l2, l9);
                            long l10 = 0L;
                            long l11 = l2;
                            for (l8 = l10; l8 < l11; ++l8) {
                                dArray[(int)(lArray2[n15] + l8)] = 0.5 * flatExpr.cof[(int)(flatExpr.ptrb[n18] + l8)];
                            }
                            l10 = 0L;
                            l11 = l9;
                            for (l8 = l10; l8 < l11; ++l8) {
                                dArray[(int)(lArray2[n15] + l2 + l8)] = 0.5 * flatExpr.cof[(int)(flatExpr.ptrb[n19] + l8)];
                            }
                        }
                        ++n15;
                    }
                }
            }
            return this.sdptrilcon(string, n2, n3, lArray2, lArray, lArray5, lArray3, dArray, dArray2, flatExpr.x);
        }
        int n20 = n2 * n2;
        long[] lArray = Tools.arraycopy(flatExpr.inst);
        int n21 = 0;
        int n22 = lArray.length;
        for (n = n21; n < n22; ++n) {
            long l12 = flatExpr.inst[n] / (long)n20;
            long l13 = flatExpr.inst[n] % (long)n2;
            long l14 = flatExpr.inst[n] / (long)n2 % (long)n2;
            lArray[n] = l13 > l14 ? l12 * (long)n20 + l13 * (long)n2 + l14 : flatExpr.inst[n];
            if (l14 == l13) continue;
            long l15 = flatExpr.ptrb[n];
            long l16 = flatExpr.ptrb[n + 1];
            for (long i = l15; i < l16; ++i) {
                int n23 = (int)i;
                flatExpr.cof[n23] = flatExpr.cof[n23] / 2.0;
            }
            if (flatExpr.bfix == null) continue;
            int n24 = n;
            flatExpr.bfix[n24] = flatExpr.bfix[n24] / 2.0;
        }
        n21 = 0;
        n22 = 0;
        n = lArray.length;
        int n25 = n22 < n ? n - n22 : 0;
        long[] lArray6 = new long[n25];
        int n26 = n22;
        int n27 = 0;
        while (n27 < n25) {
            lArray6[n21] = n26;
            ++n21;
            ++n27;
            ++n26;
        }
        long[] lArray7 = lArray6;
        long[] lArray8 = new long[n3 * n2 + 1];
        Sort.argTransposeSort(lArray7, lArray8, n3, n2, n2, lArray);
        Sort.argTransposeSort(lArray7, lArray8, n3 * n2, n2, 1, lArray);
        int n28 = 0;
        if (lArray7.length > 0) {
            ++n28;
            int n29 = 1;
            int n30 = lArray7.length;
            for (int i = n29; i < n30; ++i) {
                if (lArray[(int)lArray7[i]] <= lArray[(int)lArray7[i - 1]]) continue;
                ++n28;
            }
        }
        if (lArray.length == n28) {
            return this.sdptrilcon(string, n2, n3, flatExpr.ptrb, lArray, lArray7, flatExpr.subj, flatExpr.cof, flatExpr.bfix, flatExpr.x);
        }
        long[] lArray9 = new long[n28 + 1];
        long[] lArray10 = new long[n28];
        long[] lArray11 = new long[flatExpr.subj.length];
        double[] dArray = new double[flatExpr.subj.length];
        double[] dArray3 = new double[n28];
        int n31 = 0;
        long l17 = 0L;
        int n32 = 0;
        int n33 = lArray7.length;
        for (int i = n32; i < n33; ++i) {
            if (i > 0 && lArray[(int)lArray7[i]] != lArray[(int)lArray7[i - 1]]) {
                ++n31;
            }
            l = flatExpr.ptrb[(int)(lArray7[i] + 1L)] - flatExpr.ptrb[(int)lArray7[i]];
            Tools.arraycopy(flatExpr.subj, flatExpr.ptrb[(int)lArray7[i]], lArray11, l17, l);
            Tools.arraycopy(flatExpr.cof, flatExpr.ptrb[(int)lArray7[i]], dArray, l17, l);
            lArray9[n31 + 1] = l17 += l;
            lArray10[n31] = lArray[(int)lArray7[i]];
        }
        if (flatExpr.bfix != null) {
            n31 = 0;
            int n34 = 0;
            int n35 = lArray7.length;
            for (n32 = n34; n32 < n35; ++n32) {
                if (n32 <= 0 || lArray[(int)lArray7[n32]] != lArray[(int)lArray7[n32 - 1]]) {
                    // empty if block
                }
                long l18 = flatExpr.inst[(int)lArray7[n32]] / (long)n2 % (long)n2;
                l = flatExpr.inst[(int)lArray7[n32]] % (long)n2;
                int n36 = ++n31;
                dArray3[n36] = dArray3[n36] + flatExpr.bfix[(int)lArray7[n32]];
            }
        }
        return this.sdptrilcon(string, n2, n3, lArray9, lArray10, Tools.range((long)lArray10.length), lArray11, dArray, dArray3, flatExpr.x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint sdptrilcon(String string, int n, int n2, long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, double[] dArray, double[] dArray2, Variable[] variableArray) {
        int n3;
        int n4;
        int n5;
        PSDConstraint pSDConstraint = null;
        long l = 0L;
        int n6 = 0;
        int n7 = lArray3.length;
        for (int i = n6; i < n7; ++i) {
            l += lArray[(int)(lArray3[i] + 1L)] - lArray[(int)lArray3[i]];
        }
        int[] nArray = new int[(int)l];
        int[] nArray2 = new int[(int)l];
        int[] nArray3 = new int[(int)l];
        long[] lArray5 = new long[lArray3.length + 1];
        int n8 = 0;
        int n9 = 0;
        int n10 = lArray3.length;
        for (int i = n9; i < n10; ++i) {
            Model.inst(variableArray, (int)lArray[(int)lArray3[i]], (int)lArray[(int)(lArray3[i] + 1L)], lArray4, n8, nArray, nArray2, nArray3);
            lArray5[i + 1] = n8 += (int)(lArray[(int)(lArray3[i] + 1L)] - lArray[(int)lArray3[i]]);
        }
        n8 = n2 * (n * (n + 1) / 2);
        long l2 = 0L;
        long l3 = 0L;
        long l4 = l;
        for (long i = l3; i < l4; ++i) {
            if (nArray[(int)i] >= 0) continue;
            ++l2;
        }
        l3 = l - l2;
        long[] lArray6 = Tools.range(l);
        int n11 = 0;
        int n12 = lArray3.length;
        for (n5 = n11; n5 < n12; ++n5) {
            CommonTools.argQsort(lArray6, nArray, null, lArray5[n5], lArray5[n5 + 1]);
        }
        long l5 = 0L;
        n5 = 0;
        int n13 = lArray3.length;
        for (n4 = n5; n4 < n13; ++n4) {
            long l6;
            long l7 = lArray5[n4 + 1];
            for (l6 = lArray5[n4]; l6 < l7 && nArray[(int)lArray6[(int)l6]] < 0; ++l6) {
            }
            if (l6 < l7) {
                ++l5;
                ++l6;
            }
            while (l6 < l7) {
                if (nArray[(int)lArray6[(int)(l6 - 1L)]] < nArray[(int)lArray6[(int)l6]]) {
                    ++l5;
                }
                ++l6;
            }
        }
        long[] lArray7 = new long[lArray3.length];
        n13 = 0;
        n4 = lArray3.length;
        for (n3 = n13; n3 < n4; ++n3) {
            long l8 = lArray2[(int)lArray3[n3]] / (long)(n * n);
            long l9 = lArray2[(int)lArray3[n3]] % (long)(n * n) / (long)n;
            long l10 = lArray2[(int)lArray3[n3]] % (long)n;
            lArray7[n3] = l8 * (long)(n * (n + 1) / 2) + l9 * (l9 + 1L) / 2L + l10;
        }
        n13 = this.task_vars_used;
        n4 = this.task_numcon();
        n3 = this.task_numcone();
        int n14 = this.task_numbarvar();
        try {
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21 = this.task_append_con(n8);
            int n22 = n21 + n8;
            int n23 = this.task_alloc_vars(n8);
            int n24 = n23 + n8;
            long[] lArray8 = new long[n8 + 1];
            int[] nArray4 = new int[(int)l5];
            double[] dArray3 = new double[(int)l5];
            if (l3 > 0L) {
                long l11 = 0L;
                n20 = 0;
                n19 = n8;
                for (int i = n20; i < n19; ++i) {
                    long l12 = lArray8[i];
                    if (l11 < (long)lArray3.length && (long)i == lArray7[(int)l11]) {
                        long l13;
                        long l14 = lArray5[(int)(l11 + 1L)];
                        for (l13 = lArray5[(int)l11]; l13 < l14 && nArray[(int)lArray6[(int)l13]] < 0; ++l13) {
                        }
                        if (l13 < l14) {
                            nArray4[(int)l12] = nArray[(int)lArray6[(int)l13]];
                            dArray3[(int)l12] = dArray[(int)lArray6[(int)l13]];
                            ++l13;
                            while (l13 < l14) {
                                if (nArray[(int)lArray6[(int)l13]] == nArray4[(int)l12]) {
                                    dArray3[(int)l12] = dArray3[(int)l12] + dArray[(int)lArray6[(int)l13]];
                                } else {
                                    nArray4[(int)(++l12)] = nArray[(int)lArray6[(int)l13]];
                                    dArray3[(int)l12] = dArray[(int)lArray6[(int)l13]];
                                }
                                ++l13;
                            }
                        }
                        ++l11;
                    }
                    lArray8[i + 1] = ++l12;
                }
                this.task_putarowslice(n21, n22, lArray8, nArray4, dArray3);
            }
            double[] dArray4 = new double[n8];
            if (dArray2 != null) {
                n18 = 0;
                n20 = lArray3.length;
                for (n19 = n18; n19 < n20; ++n19) {
                    dArray4[(int)lArray7[n19]] = -dArray2[(int)lArray3[n19]];
                }
            }
            this.task_con_putboundslice_fx(n21, n22, dArray4);
            if (l2 > 0L) {
                n18 = 0;
                n20 = lArray3.length;
                for (n19 = n18; n19 < n20; ++n19) {
                    long l15;
                    long l16 = lArray[(int)lArray3[n19]];
                    long l17 = lArray[(int)(lArray3[n19] + 1L)];
                    for (l15 = l16; l15 < l17 && nArray[(int)lArray6[(int)l15]] < 0; ++l15) {
                    }
                    if (l16 >= l15) continue;
                    n17 = nArray[(int)lArray6[(int)l16]];
                    while (l16 < l15) {
                        long l18 = l16;
                        while (l16 < l15 && nArray[(int)lArray6[(int)l16]] == n17) {
                            ++l16;
                        }
                        n16 = -(n17 + 1);
                        CommonTools.argQsort(lArray6, nArray2, nArray3, l18, l16);
                        n15 = 1;
                        long l19 = l18 + 1L;
                        long l20 = l16;
                        for (long i = l19; i < l20; ++i) {
                            if (nArray2[(int)lArray6[(int)i]] == nArray2[(int)lArray6[(int)(i - 1L)]] && nArray3[(int)lArray6[(int)i]] == nArray3[(int)lArray6[(int)(i - 1L)]]) continue;
                            ++n15;
                        }
                        int[] nArray5 = new int[n15];
                        int[] nArray6 = new int[n15];
                        double[] dArray5 = new double[n15];
                        int n25 = -1;
                        int n26 = -1;
                        int n27 = 0;
                        long l21 = l18;
                        long l22 = l16;
                        for (long i = l21; i < l22; ++i) {
                            if (nArray2[(int)lArray6[(int)i]] == n26 && nArray3[(int)lArray6[(int)i]] == n27) {
                                dArray5[n25] = dArray5[n25] + dArray[(int)lArray6[(int)i]];
                                continue;
                            }
                            nArray5[++n25] = nArray2[(int)lArray6[(int)i]];
                            nArray6[n25] = nArray3[(int)lArray6[(int)i]];
                            dArray5[n25] = dArray[(int)lArray6[(int)i]];
                            n26 = nArray5[n25];
                            n27 = nArray6[n25];
                        }
                        n25 = this.task_barvardim(n16);
                        n26 = this.task_append_barmatrix(n25, nArray5, nArray6, dArray5);
                        this.task_putbaraij((int)(lArray7[n19] + (long)n21), n16, n26);
                    }
                }
            }
            n18 = this.task_append_barvar(n, n2);
            Object object = new int[1];
            Object object2 = new int[1];
            double[] dArray6 = new double[1];
            int n28 = 0;
            int n29 = n;
            for (int i = n28; i < n29; ++i) {
                int n30 = 0;
                int n31 = i + 1;
                for (n17 = n30; n17 < n31; ++n17) {
                    object[0] = i;
                    object2[0] = n17;
                    dArray6[0] = -(i == n17 ? 1.0 : 0.5);
                    int n32 = this.task_append_barmatrix(n, (int[])object, (int[])object2, dArray6);
                    int n33 = 0;
                    n16 = n2;
                    for (n15 = n33; n15 < n16; ++n15) {
                        int n34 = n15 * n * (n + 1) / 2 + i * (i + 1) / 2 + n17;
                        this.task_putbaraij(n21 + n34, n18 + n15, n32);
                    }
                }
            }
            object = null;
            object = n2 == 1 ? (Object)new NDSet(n, n) : (Object)new NDSet(n, n, n2);
            pSDConstraint = new PSDConstraint(this, string, (Set)object, Tools.range(n21, n22), n, n18, n2, lArray8, nArray4, dArray3, dArray4, null, null, null);
            this.natbarvarmap_ensure(n2);
            this.natbarvarmap_num += n2;
            this.addConstraint(string, pSDConstraint);
            object2 = pSDConstraint;
            return object2;
        }
        finally {
            if (pSDConstraint == null) {
                this.natbarvarmap_num = n14;
                this.natvarmap_num = n13;
                this.task_cleanup(n13, n4, n3, n14);
            }
        }
    }

    public void addConstraint(String string, ModelConstraint modelConstraint) {
        if (this.cons_used >= this.cons.length) {
            int n = this.cons.length > 100 ? this.cons.length * 2 : 100;
            ModelConstraint[] modelConstraintArray = this.cons;
            this.cons = new ModelConstraint[n];
            int n2 = 0;
            int n3 = this.cons_used;
            for (int i = n2; i < n3; ++i) {
                this.cons[i] = modelConstraintArray[i];
            }
        }
        this.cons[this.cons_used] = modelConstraint;
        if (string.length() > 0) {
            this.con_map.setItem(string, this.cons_used);
        }
        ++this.cons_used;
    }

    public void addVariable(String string, ModelVariable modelVariable) {
        if (this.vars_used >= this.vars.length) {
            int n = this.vars.length > 100 ? this.vars.length * 2 : 100;
            ModelVariable[] modelVariableArray = this.vars;
            this.vars = new ModelVariable[n];
            int n2 = 0;
            int n3 = this.vars_used;
            for (int i = n2; i < n3; ++i) {
                this.vars[i] = modelVariableArray[i];
            }
        }
        this.vars[this.vars_used] = modelVariable;
        if (string.length() > 0) {
            this.var_map.setItem(string, this.vars_used);
        }
        ++this.vars_used;
    }

    public long numConstraints() {
        return this.cons_used;
    }

    public long numVariables() {
        return this.vars_used;
    }

    public boolean hasConstraint(String string) {
        return this.con_map.hasItem(string);
    }

    public boolean hasVariable(String string) {
        return this.var_map.hasItem(string);
    }

    public Constraint getConstraint(int n) {
        return n >= 0 && n < this.cons_used ? this.cons[n] : null;
    }

    public Constraint getConstraint(String string) {
        return this.con_map.hasItem(string) ? this.cons[this.con_map.getItem(string)] : null;
    }

    public Variable getVariable(int n) {
        return n >= 0 && n < this.vars_used ? this.vars[n] : null;
    }

    public Variable getVariable(String string) {
        return this.var_map.hasItem(string) ? this.vars[this.var_map.getItem(string)] : null;
    }

    public String getName() {
        return this.model_name;
    }

    public Model clone() {
        return new Model(this);
    }

    public void natbarvarmap_ensure(int n) {
        if (this.natbarvarmap_num + n > this.natbarvarmap_Var.length) {
            int n2 = 2 * this.natbarvarmap_Var.length;
            if (n2 < this.natbarvarmap_num + n) {
                n2 = this.natbarvarmap_num + n;
            }
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            int n3 = 0;
            int n4 = this.natbarvarmap_num;
            for (int i = n3; i < n4; ++i) {
                nArray[i] = this.natbarvarmap_Var[i];
            }
            this.natbarvarmap_Var = nArray;
        }
    }

    public void natvarmap_ensure(int n) {
        if (this.natvarmap_num + n > this.natvarmap_idx.length) {
            int n2 = 2 * this.natvarmap_idx.length;
            if (n2 < this.natvarmap_num + n) {
                n2 = this.natvarmap_num + n;
            }
            long[] lArray = new long[n2];
            Tools.arraycopy(this.natvarmap_idx, 0, lArray, 0, this.natvarmap_num);
            int[] nArray = new int[n2];
            int n3 = 0;
            int n4 = this.natvarmap_num;
            for (int i = n3; i < n4; ++i) {
                nArray[i] = this.natvarmap_Var[i];
            }
            this.natvarmap_idx = lArray;
            this.natvarmap_Var = nArray;
        }
    }

    public int task_alloc_vars(int n) {
        int n2;
        if (this.task_vars_allocated - this.task_vars_used < n) {
            n2 = n + this.task_vars_used - this.task_vars_allocated < 1000 ? 1000 : n;
            this.task_append_var(n2);
            this.task_vars_allocated += n2;
        }
        n2 = this.task_vars_used;
        this.task_vars_used += n;
        return n2;
    }
}

