/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.IndexCounter;
import mosek.fusion.IndexError;
import mosek.fusion.Model;
import mosek.fusion.ModelVariable;
import mosek.fusion.Set;
import mosek.fusion.SolutionError;
import mosek.fusion.SolutionType;
import mosek.fusion.UnimplementedError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;

public class LinearPSDVariable
extends ModelVariable {
    private int numcones;
    private int coneidx;
    private int conesize;
    private int sdpvardim;
    private int blocksize;

    private LinearPSDVariable(LinearPSDVariable linearPSDVariable, Model model) {
        super(linearPSDVariable, model);
        this.blocksize = linearPSDVariable.blocksize;
        this.conesize = linearPSDVariable.conesize;
        this.coneidx = linearPSDVariable.coneidx;
        this.sdpvardim = linearPSDVariable.sdpvardim;
        this.numcones = linearPSDVariable.numcones;
    }

    protected LinearPSDVariable(Model model, String string, int n, Set set, int n2, long l) {
        super(model, string, set, l);
        this.blocksize = set._dim(0);
        this.conesize = set._dim(0);
        this.coneidx = n2;
        this.sdpvardim = n;
        this.numcones = 1;
        int n3 = 1;
        int n4 = set.nd;
        for (int i = n3; i < n4; ++i) {
            this.numcones *= set._dim(i);
        }
    }

    @Override
    public void flushNames() {
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("PSDVariable(");
        if (this.name.length() > 0) {
            stringBuffer.a("'").a(this.name).a("',");
        }
        stringBuffer.a(this.shape_p._dim(0));
        int n = 1;
        int n2 = this.shape_p.nd;
        for (int i = n; i < n2; ++i) {
            stringBuffer.a(",").a(this.shape_p._dim(i));
        }
        stringBuffer.a(")");
        return stringBuffer.toString();
    }

    @Override
    public void inst(long[] lArray, int n, int n2, long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        int n3;
        int n4 = n;
        int n5 = n2;
        for (n3 = n4; n3 < n5; ++n3) {
            if (lArray[n3] >= l && lArray[n3] < this.shape_p.size + l) continue;
            throw new IndexError("Index out of bounds");
        }
        long l3 = l2;
        n3 = this.sdpvardim;
        int n6 = n;
        int n7 = n2;
        for (int i = n6; i < n7; ++i) {
            long l4 = lArray[i] - l;
            int n8 = (int)(l4 / (long)this.blocksize);
            long l5 = l4 % (long)this.blocksize;
            nArray[(int)l3] = -(1 + this.coneidx + n8);
            int n9 = (int)((double)n3 + 0.5 - Tools.sqrt(((double)n3 + 0.5) * ((double)n3 + 0.5) - (double)(l5 * 2L)));
            int n10 = (int)(l5 - (long)(n9 * (2 * n3 - n9 - 1) / 2));
            if (n10 >= n9) {
                nArray2[(int)l3] = n10;
                nArray3[(int)l3] = n9;
            } else {
                nArray2[(int)l3] = n9;
                nArray3[(int)l3] = n10;
            }
            ++l3;
        }
    }

    @Override
    public void inst(long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        if (l < 0L || l >= this.shape_p.size) {
            throw new IndexError("Index out of bounds");
        }
        int n = this.sdpvardim;
        int n2 = (int)(l / (long)this.blocksize);
        long l3 = l % (long)this.blocksize;
        nArray[(int)l2] = -(1 + this.coneidx + n2);
        int n3 = (int)((double)n + 0.5 - Tools.sqrt(((double)n + 0.5) * ((double)n + 0.5) - (double)(l3 * 2L)));
        int n4 = (int)(l3 - (long)(n3 * (2 * n + 1 + n3) / 2));
        if (n4 >= n3) {
            nArray2[(int)l2] = n4;
            nArray3[(int)l2] = n3;
        } else {
            nArray2[(int)l2] = n3;
            nArray3[(int)l2] = n4;
        }
    }

    @Override
    public void set_values(long l, int[] nArray, long[] lArray, int n, double[] dArray, boolean bl) {
        throw new UnimplementedError("Cannot make PSDVariable elements integer");
    }

    @Override
    public void set_values(long[] lArray, double[] dArray, boolean bl) {
        throw new UnimplementedError("Cannot make PSDVariable elements integer");
    }

    @Override
    public void values(long l, int[] nArray, long[] lArray, int n, double[] dArray, boolean bl) throws SolutionError {
        long l2 = 1L;
        int n2 = lArray.length;
        IndexCounter indexCounter = new IndexCounter(l, nArray, lArray);
        double[][] dArray2 = bl ? this.model.getSolution_barx(SolutionType.Default) : this.model.getSolution_bars(SolutionType.Default);
        int n3 = 0;
        int n4 = n2;
        for (int i = n3; i < n4; ++i) {
            l2 *= (long)nArray[i];
        }
        long l3 = 0L;
        long l4 = l2;
        for (long i = l3; i < l4; ++i) {
            long l5 = indexCounter.get() / (long)this.blocksize;
            long l6 = indexCounter.get() % (long)this.blocksize;
            dArray[(int)i] = dArray2[(int)((long)this.coneidx + l5)][(int)l6];
            indexCounter.inc();
        }
    }

    @Override
    public void values(long[] lArray, int n, double[] dArray, boolean bl) throws SolutionError {
        int n2;
        double[][] dArray2 = bl ? this.model.getSolution_barx(SolutionType.Default) : this.model.getSolution_bars(SolutionType.Default);
        int n3 = 0;
        int n4 = lArray.length;
        for (n2 = n3; n2 < n4; ++n2) {
            if (lArray[n2] >= 0L && lArray[n2] < this.shape_p.size) continue;
            throw new IndexError("Index out of bounds");
        }
        n3 = 0;
        n4 = lArray.length;
        for (n2 = n3; n2 < n4; ++n2) {
            long l = lArray[n2] / (long)this.blocksize;
            long l2 = lArray[n2] % (long)this.blocksize;
            dArray[n2] = dArray2[(int)((long)this.coneidx + l)][(int)l2];
        }
    }

    @Override
    public void make_continuous(long[] lArray) {
    }

    @Override
    public void make_integer(long[] lArray) {
        throw new UnimplementedError("Cannot make PSDVariable elements integer");
    }

    @Override
    public ModelVariable clone(Model model) {
        return new LinearPSDVariable(this, model);
    }
}

