/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.Set;
import mosek.fusion.SparseFormatError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;
import mosek.fusion.Variable;

public class FlatExpr {
    public long[] inst;
    public Set shape;
    public long nnz;
    public double[] cof;
    public Variable[] x;
    public long[] subj;
    public long[] ptrb;
    public double[] bfix;

    public FlatExpr(FlatExpr flatExpr) {
        this.bfix = (double[])(flatExpr.bfix != null ? Tools.arraycopy(flatExpr.bfix) : null);
        this.ptrb = Tools.arraycopy(flatExpr.ptrb);
        this.subj = Tools.arraycopy(flatExpr.subj);
        this.x = flatExpr.x;
        this.cof = Tools.arraycopy(flatExpr.cof);
        this.nnz = flatExpr.nnz;
        this.shape = flatExpr.shape;
        this.inst = flatExpr.inst;
    }

    public FlatExpr(double[] dArray, long[] lArray, long[] lArray2, Variable[] variableArray, double[] dArray2, Set set, long[] lArray3) {
        if (dArray != null && dArray.length != lArray.length - 1) {
            throw new SparseFormatError("Mismatching lengths of bfix and ptrb");
        }
        if (dArray2 == null || lArray2 == null || lArray2.length != dArray2.length) {
            throw new SparseFormatError("Mismatching lengths of subj and cof");
        }
        if (set != null) {
            if (lArray3 != null) {
                if (lArray3.length != lArray.length - 1) {
                    throw new SparseFormatError("Mismatching lengths of inst and ptrb");
                }
            } else if (set.size != (long)lArray.length - 1L) {
                throw new SparseFormatError("Mismatching shape and ptrb");
            }
        }
        this.bfix = dArray;
        this.ptrb = lArray;
        this.subj = lArray2;
        this.x = variableArray;
        this.cof = dArray2;
        this.nnz = this.ptrb[this.ptrb.length - 1];
        this.shape = set;
        this.inst = lArray3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("FlatExpr:").lf().a("+-----------------").lf().a("| ptrb[").a(this.ptrb.length).a("] = ").a(this.ptrb).lf().a("| subj[").a(this.subj.length).a("] = ").a(this.subj).lf().a("| cof [").a(this.cof.length).a("] = ").a(this.cof).lf().a("| bfix[");
        if (this.bfix != null) {
            stringBuffer.a(this.bfix.length);
        }
        stringBuffer.a("] = ").a(this.bfix).lf().a("| inst[");
        if (this.inst != null) {
            stringBuffer.a(this.inst.length);
        }
        stringBuffer.a("] = ").a(this.inst).lf().a("+-----------------");
        return stringBuffer.toString();
    }

    public int size() {
        return this.ptrb.length - 1;
    }
}

