/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.DomainError;
import mosek.fusion.IntSet;
import mosek.fusion.LengthError;
import mosek.fusion.LinPSDDomain;
import mosek.fusion.LinearDomain;
import mosek.fusion.Matrix;
import mosek.fusion.NDSet;
import mosek.fusion.PSDDomain;
import mosek.fusion.PSDKey;
import mosek.fusion.QConeDomain;
import mosek.fusion.QConeKey;
import mosek.fusion.RangeDomain;
import mosek.fusion.RelationKey;
import mosek.fusion.SymmetricLinearDomain;
import mosek.fusion.SymmetricRangeDomain;

public class Domain {
    public static long dimsize(int[] nArray) {
        long l = 1L;
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            l *= (long)nArray[i];
        }
        return l;
    }

    public static LinearDomain mkLinearDomain(RelationKey relationKey, Matrix matrix) {
        if (matrix.isSparse()) {
            int[] nArray = new int[(int)matrix.numNonzeros()];
            int[] nArray2 = new int[(int)matrix.numNonzeros()];
            double[] dArray = new double[(int)matrix.numNonzeros()];
            matrix._getDataAsTriplets(nArray, nArray2, dArray);
            int n = 0;
            int n2 = 0;
            int n3 = nArray.length;
            int n4 = n2 < n3 ? n3 - n2 : 0;
            long[] lArray = new long[n4];
            int n5 = n2;
            int n6 = 0;
            while (n6 < n4) {
                lArray[n] = nArray[n5] * matrix.dimj + nArray2[n5];
                ++n;
                ++n6;
                ++n5;
            }
            long[] lArray2 = lArray;
            return new LinearDomain(relationKey, dArray, lArray2, new int[]{matrix.dimi, matrix.dimj});
        }
        return new LinearDomain(relationKey, matrix.getDataAsArray(), null, new int[]{matrix.dimi, matrix.dimj});
    }

    public static LinearDomain mkLinearDomain(RelationKey relationKey, double[][] dArray) {
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int n5 = 0;
        int n6 = dArray[0].length;
        int n7 = n5 < n6 ? n6 - n5 : 0;
        double[] dArray2 = new double[n4 * n7];
        int n8 = n2;
        int n9 = 0;
        while (n9 < n4) {
            int n10 = n5;
            int n11 = 0;
            while (n11 < n7) {
                dArray2[n] = dArray[n8][n10];
                ++n;
                ++n11;
                ++n10;
            }
            ++n9;
            ++n8;
        }
        return new LinearDomain(relationKey, dArray2, null, new int[]{dArray.length, dArray[0].length});
    }

    public static LinearDomain mkLinearDomain(RelationKey relationKey, double[] dArray, int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        double[] dArray2 = new double[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            dArray2[n] = dArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        n6 = 0;
        int n7 = 0;
        int n8 = nArray.length;
        int n9 = n7 < n8 ? n8 - n7 : 0;
        int[] nArray2 = new int[n9];
        int n10 = n7;
        int n11 = 0;
        while (n11 < n9) {
            nArray2[n6] = nArray[n10];
            ++n6;
            ++n11;
            ++n10;
        }
        return new LinearDomain(relationKey, dArray2, null, nArray2);
    }

    public static LinearDomain mkLinearDomain(RelationKey relationKey, double[] dArray) {
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        double[] dArray2 = new double[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            dArray2[n] = dArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new LinearDomain(relationKey, dArray2, null, new int[]{dArray.length});
    }

    public static LinearDomain mkLinearDomain(RelationKey relationKey, double d, int[] nArray) {
        int n = 0;
        int n2 = 0;
        long l = Domain.dimsize(nArray);
        long l2 = (long)n2 < l ? l - (long)n2 : 0L;
        double[] dArray = new double[(int)l2];
        long l3 = n2;
        int n3 = 0;
        while ((long)n3 < l2) {
            dArray[n] = d;
            ++n;
            ++n3;
            ++l3;
        }
        n3 = 0;
        int n4 = 0;
        int n5 = nArray.length;
        int n6 = n4 < n5 ? n5 - n4 : 0;
        int[] nArray2 = new int[n6];
        int n7 = n4;
        int n8 = 0;
        while (n8 < n6) {
            nArray2[n3] = nArray[n7];
            ++n3;
            ++n8;
            ++n7;
        }
        return new LinearDomain(relationKey, dArray, null, nArray2);
    }

    public static LinearDomain mkLinearDomain(RelationKey relationKey, double d) {
        return new LinearDomain(relationKey, new double[]{d}, null, null);
    }

    public static RangeDomain inRange(double[] dArray, double[] dArray2, int[] nArray) {
        if (dArray.length != dArray2.length) {
            throw new LengthError("Mismatching lengths of upper and lower bounds.");
        }
        int n = 0;
        int n2 = dArray2.length;
        for (int i = n; i < n2; ++i) {
            if (!(dArray[i] > dArray2[i])) continue;
            throw new DomainError("Invalid range specified");
        }
        if (nArray != null && Domain.dimsize(nArray) != (long)dArray.length) {
            throw new LengthError("Mismatching dimensions.");
        }
        return new RangeDomain(dArray, dArray2, nArray, null);
    }

    public static SymmetricRangeDomain symmetric(RangeDomain rangeDomain) {
        return rangeDomain.symmetric();
    }

    public static SymmetricLinearDomain symmetric(LinearDomain linearDomain) {
        return linearDomain.symmetric();
    }

    public static RangeDomain sparse(RangeDomain rangeDomain) {
        return rangeDomain.sparse();
    }

    public static LinearDomain sparse(LinearDomain linearDomain) {
        return linearDomain.sparse();
    }

    public static RangeDomain integral(RangeDomain rangeDomain) {
        return rangeDomain.integral();
    }

    public static LinearDomain integral(LinearDomain linearDomain) {
        return linearDomain.integral();
    }

    public static QConeDomain integral(QConeDomain qConeDomain) {
        return qConeDomain.integral();
    }

    public static QConeDomain axis(QConeDomain qConeDomain, int n) {
        return qConeDomain.axis(n);
    }

    public static QConeDomain inRotatedQCone(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new QConeDomain(QConeKey.InRotatedQCone, nArray2, nArray.length - 1);
    }

    public static QConeDomain inRotatedQCone(int n, int n2) {
        return new QConeDomain(QConeKey.InRotatedQCone, new int[]{n, n2}, 1);
    }

    public static QConeDomain inRotatedQCone(int n) {
        return new QConeDomain(QConeKey.InRotatedQCone, new int[]{n}, 0);
    }

    public static QConeDomain inRotatedQCone() {
        return new QConeDomain(QConeKey.InRotatedQCone, null, 0);
    }

    public static QConeDomain inQCone(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new QConeDomain(QConeKey.InQCone, nArray2, nArray.length - 1);
    }

    public static QConeDomain inQCone(int n, int n2) {
        return new QConeDomain(QConeKey.InQCone, new int[]{n, n2}, 1);
    }

    public static QConeDomain inQCone(int n) {
        return new QConeDomain(QConeKey.InQCone, new int[]{n}, 0);
    }

    public static QConeDomain inQCone() {
        return new QConeDomain(QConeKey.InQCone, null, 0);
    }

    public static LinPSDDomain isLinPSD(int n, int n2) {
        return new LinPSDDomain(new NDSet(n * (n + 1) / 2, n2));
    }

    public static LinPSDDomain isLinPSD(int n) {
        return new LinPSDDomain(new IntSet(n * (n + 1) / 2));
    }

    public static LinPSDDomain isLinPSD() {
        return new LinPSDDomain(null);
    }

    public static PSDDomain isTrilPSD(int n, int n2) {
        return new PSDDomain(PSDKey.IsTrilPSD, new NDSet(n, n, n2));
    }

    public static PSDDomain isTrilPSD(int n) {
        return new PSDDomain(PSDKey.IsTrilPSD, new NDSet(n, n, 1));
    }

    public static PSDDomain isTrilPSD() {
        return new PSDDomain(PSDKey.IsTrilPSD, null);
    }

    public static PSDDomain inPSDCone(int n, int n2) {
        return new PSDDomain(PSDKey.IsSymPSD, new NDSet(n, n, n2));
    }

    public static PSDDomain inPSDCone(int n) {
        return new PSDDomain(PSDKey.IsSymPSD, new NDSet(n, n, 1));
    }

    public static PSDDomain inPSDCone() {
        return new PSDDomain(PSDKey.IsSymPSD, null);
    }

    public static RangeDomain binary() {
        return Domain.inRange(0.0, 1.0).integral();
    }

    public static RangeDomain binary(int[] nArray) {
        int n = 0;
        int n2 = 0;
        long l = Domain.dimsize(nArray);
        long l2 = (long)n2 < l ? l - (long)n2 : 0L;
        double[] dArray = new double[(int)l2];
        long l3 = n2;
        int n3 = 0;
        while ((long)n3 < l2) {
            dArray[n] = 0.0;
            ++n;
            ++n3;
            ++l3;
        }
        n3 = 0;
        int n4 = 0;
        long l4 = Domain.dimsize(nArray);
        long l5 = (long)n4 < l4 ? l4 - (long)n4 : 0L;
        double[] dArray2 = new double[(int)l5];
        long l6 = n4;
        int n5 = 0;
        while ((long)n5 < l5) {
            dArray2[n3] = 1.0;
            ++n3;
            ++n5;
            ++l6;
        }
        return Domain.inRange(dArray, dArray2, nArray).integral();
    }

    public static RangeDomain binary(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n2 * n;
        int n6 = n4 < n5 ? n5 - n4 : 0;
        double[] dArray = new double[n6];
        int n7 = n4;
        int n8 = 0;
        while (n8 < n6) {
            dArray[n3] = 0.0;
            ++n3;
            ++n8;
            ++n7;
        }
        n8 = 0;
        int n9 = 0;
        int n10 = n2 * n;
        int n11 = n9 < n10 ? n10 - n9 : 0;
        double[] dArray2 = new double[n11];
        int n12 = n9;
        int n13 = 0;
        while (n13 < n11) {
            dArray2[n8] = 1.0;
            ++n8;
            ++n13;
            ++n12;
        }
        return Domain.inRange(dArray, dArray2, new int[]{n, n2}).integral();
    }

    public static RangeDomain binary(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        int n5 = n3 < n4 ? n4 - n3 : 0;
        double[] dArray = new double[n5];
        int n6 = n3;
        int n7 = 0;
        while (n7 < n5) {
            dArray[n2] = 0.0;
            ++n2;
            ++n7;
            ++n6;
        }
        n7 = 0;
        int n8 = 0;
        int n9 = n;
        int n10 = n8 < n9 ? n9 - n8 : 0;
        double[] dArray2 = new double[n10];
        int n11 = n8;
        int n12 = 0;
        while (n12 < n10) {
            dArray2[n7] = 1.0;
            ++n7;
            ++n12;
            ++n11;
        }
        return Domain.inRange(dArray, dArray2, new int[]{n}).integral();
    }

    public static RangeDomain inRange(Matrix matrix, Matrix matrix2) {
        return Domain.inRange(matrix.getDataAsArray(), matrix2.getDataAsArray(), new int[]{matrix.dimi, matrix.dimj});
    }

    public static RangeDomain inRange(Matrix matrix, double d) {
        int n = 0;
        int n2 = 0;
        int n3 = matrix.dimi * matrix.dimj;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        double[] dArray = new double[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            dArray[n] = d;
            ++n;
            ++n6;
            ++n5;
        }
        return Domain.inRange(matrix.getDataAsArray(), dArray, new int[]{matrix.dimi, matrix.dimj});
    }

    public static RangeDomain inRange(double d, Matrix matrix) {
        int n = 0;
        int n2 = 0;
        int n3 = matrix.dimi * matrix.dimj;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        double[] dArray = new double[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            dArray[n] = d;
            ++n;
            ++n6;
            ++n5;
        }
        return Domain.inRange(dArray, matrix.getDataAsArray(), new int[]{matrix.dimi, matrix.dimj});
    }

    public static RangeDomain inRange(double[] dArray, double[] dArray2) {
        return Domain.inRange(dArray, dArray2, new int[]{dArray.length});
    }

    public static RangeDomain inRange(double[] dArray, double d) {
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        double[] dArray2 = new double[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            dArray2[n] = d;
            ++n;
            ++n6;
            ++n5;
        }
        return Domain.inRange(dArray, dArray2, new int[]{dArray.length});
    }

    public static RangeDomain inRange(double d, double[] dArray) {
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        double[] dArray2 = new double[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            dArray2[n] = d;
            ++n;
            ++n6;
            ++n5;
        }
        return Domain.inRange(dArray2, dArray, new int[]{dArray.length});
    }

    public static RangeDomain inRange(double d, double d2) {
        return Domain.inRange(new double[]{d}, new double[]{d2}, null);
    }

    public static LinearDomain greaterThan(Matrix matrix) {
        return Domain.mkLinearDomain(RelationKey.GreaterThan, matrix);
    }

    public static LinearDomain greaterThan(double[] dArray, int[] nArray) {
        return Domain.mkLinearDomain(RelationKey.GreaterThan, dArray);
    }

    public static LinearDomain greaterThan(double[][] dArray) {
        return Domain.mkLinearDomain(RelationKey.GreaterThan, dArray);
    }

    public static LinearDomain greaterThan(double[] dArray) {
        return Domain.mkLinearDomain(RelationKey.GreaterThan, dArray);
    }

    public static LinearDomain greaterThan(double d, int[] nArray) {
        return Domain.mkLinearDomain(RelationKey.GreaterThan, d, nArray);
    }

    public static LinearDomain greaterThan(double d, int n, int n2) {
        return Domain.mkLinearDomain(RelationKey.GreaterThan, d, new int[]{n, n2});
    }

    public static LinearDomain greaterThan(double d, int n) {
        return Domain.mkLinearDomain(RelationKey.GreaterThan, d, new int[]{n});
    }

    public static LinearDomain greaterThan(double d) {
        return Domain.mkLinearDomain(RelationKey.GreaterThan, d);
    }

    public static LinearDomain lessThan(Matrix matrix) {
        return Domain.mkLinearDomain(RelationKey.LessThan, matrix);
    }

    public static LinearDomain lessThan(double[] dArray, int[] nArray) {
        return Domain.mkLinearDomain(RelationKey.LessThan, dArray, nArray);
    }

    public static LinearDomain lessThan(double[][] dArray) {
        return Domain.mkLinearDomain(RelationKey.LessThan, dArray);
    }

    public static LinearDomain lessThan(double[] dArray) {
        return Domain.mkLinearDomain(RelationKey.LessThan, dArray);
    }

    public static LinearDomain lessThan(double d, int[] nArray) {
        return Domain.mkLinearDomain(RelationKey.LessThan, d, nArray);
    }

    public static LinearDomain lessThan(double d, int n, int n2) {
        return Domain.mkLinearDomain(RelationKey.LessThan, d, new int[]{n, n2});
    }

    public static LinearDomain lessThan(double d, int n) {
        return Domain.mkLinearDomain(RelationKey.LessThan, d, new int[]{n});
    }

    public static LinearDomain lessThan(double d) {
        return Domain.mkLinearDomain(RelationKey.LessThan, d);
    }

    public static LinearDomain equalsTo(Matrix matrix) {
        return Domain.mkLinearDomain(RelationKey.EqualsTo, matrix);
    }

    public static LinearDomain equalsTo(double[] dArray, int[] nArray) {
        return Domain.mkLinearDomain(RelationKey.EqualsTo, dArray, nArray);
    }

    public static LinearDomain equalsTo(double[][] dArray) {
        return Domain.mkLinearDomain(RelationKey.EqualsTo, dArray);
    }

    public static LinearDomain equalsTo(double[] dArray) {
        return Domain.mkLinearDomain(RelationKey.EqualsTo, dArray);
    }

    public static LinearDomain equalsTo(double d, int[] nArray) {
        return Domain.mkLinearDomain(RelationKey.EqualsTo, d, nArray);
    }

    public static LinearDomain equalsTo(double d, int n, int n2) {
        return Domain.mkLinearDomain(RelationKey.EqualsTo, d, new int[]{n, n2});
    }

    public static LinearDomain equalsTo(double d, int n) {
        return Domain.mkLinearDomain(RelationKey.EqualsTo, d, new int[]{n});
    }

    public static LinearDomain equalsTo(double d) {
        return Domain.mkLinearDomain(RelationKey.EqualsTo, d);
    }

    public static LinearDomain unbounded(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new LinearDomain(RelationKey.IsFree, null, null, nArray2);
    }

    public static LinearDomain unbounded(int n, int n2) {
        return new LinearDomain(RelationKey.IsFree, null, null, new int[]{n, n2});
    }

    public static LinearDomain unbounded(int n) {
        return new LinearDomain(RelationKey.IsFree, null, null, new int[]{n});
    }

    public static LinearDomain unbounded() {
        return new LinearDomain(RelationKey.IsFree, null, null, null);
    }
}

