/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import com.mosek.monty.Util;
import mosek.fusion.LengthError;
import mosek.fusion.Matrix;
import mosek.fusion.MatrixError;
import mosek.fusion.SparseMatrix;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;

public class DenseMatrix
extends Matrix {
    protected long nnz;
    protected double[] data;

    protected DenseMatrix(int n, int n2, double[] dArray) {
        super(n, n2);
        this.nnz = n * n2;
        this.data = new double[n * n2];
        Tools.arraycopy(dArray, 0, this.data, 0, n * n2);
    }

    protected DenseMatrix(Matrix matrix) {
        super(matrix.dimi, matrix.dimj);
        Matrix matrix2 = matrix;
        if (matrix2 instanceof DenseMatrix) {
            DenseMatrix denseMatrix = (DenseMatrix)matrix2;
            this.data = Tools.arraycopy(denseMatrix.data);
        } else if (matrix2 instanceof SparseMatrix) {
            SparseMatrix sparseMatrix = (SparseMatrix)matrix2;
            this.data = Tools.zeros(sparseMatrix.dimi * sparseMatrix.dimj);
            long l = 0L;
            long l2 = sparseMatrix.nnz;
            for (long i = l; i < l2; ++i) {
                this.data[sparseMatrix.subi[(int)i] * this.dimj + sparseMatrix.subj[(int)i]] = sparseMatrix.val[(int)i];
            }
        } else {
            Matrix matrix3 = matrix2;
            throw new MatrixError("Unknown matrix type.");
        }
        this.nnz = this.dimi * this.dimj;
    }

    protected DenseMatrix(double[][] dArray) {
        super(dArray.length, dArray[0].length);
        int n = 0;
        int n2 = 0;
        int n3 = this.dimi;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int n5 = 0;
        int n6 = this.dimj;
        int n7 = n5 < n6 ? n6 - n5 : 0;
        double[] dArray2 = new double[n4 * n7];
        int n8 = n2;
        int n9 = 0;
        while (n9 < n4) {
            int n10 = n5;
            int n11 = 0;
            while (n11 < n7) {
                dArray2[n] = dArray[n8][n10];
                ++n;
                ++n11;
                ++n10;
            }
            ++n9;
            ++n8;
        }
        this.data = dArray2;
        this.nnz = this.dimi * this.dimj;
    }

    protected DenseMatrix(int n, int n2, double d) {
        super(n, n2);
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        int n6 = n4 < n5 ? n5 - n4 : 0;
        int n7 = 0;
        int n8 = n2;
        int n9 = n7 < n8 ? n8 - n7 : 0;
        double[] dArray = new double[n6 * n9];
        int n10 = n4;
        int n11 = 0;
        while (n11 < n6) {
            int n12 = n7;
            int n13 = 0;
            while (n13 < n9) {
                dArray[n3] = d;
                ++n3;
                ++n13;
                ++n12;
            }
            ++n11;
            ++n10;
        }
        this.data = dArray;
        this.nnz = n * n2;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("DenseMatrix(");
        stringBuffer.a(this.dimi);
        stringBuffer.a(",");
        stringBuffer.a(this.dimj);
        stringBuffer.a(": ");
        int n = 0;
        for (int i = 0; i < this.dimi && i < this.dimi; ++i) {
            if (i > 0) {
                stringBuffer.a(",");
            }
            stringBuffer.a("[ ");
            stringBuffer.a(this.data[n]);
            ++n;
            for (int j = 1; j < this.dimj && j < this.dimj; ++j) {
                stringBuffer.a(",");
                stringBuffer.a(this.data[n]);
                ++n;
            }
            stringBuffer.a(" ]");
        }
        stringBuffer.a(")");
        return stringBuffer.toString();
    }

    @Override
    public Matrix transpose() {
        double[] dArray = new double[this.dimi * this.dimj];
        int n = 0;
        int n2 = this.dimi;
        int n3 = 0;
        int n4 = this.dimi;
        for (int i = n3; i < n4; ++i) {
            int n5 = i;
            int n6 = 0;
            int n7 = this.dimj;
            for (int j = n6; j < n7; ++j) {
                dArray[n5] = this.data[n];
                n5 += n2;
                ++n;
            }
        }
        return new DenseMatrix(this.dimj, this.dimi, dArray);
    }

    @Override
    public boolean isSparse() {
        return false;
    }

    @Override
    public double[] getDataAsArray() {
        return Tools.arraycopy(this.data);
    }

    @Override
    public void _getDataAsTriplets(int[] nArray, int[] nArray2, double[] dArray) throws LengthError {
        if ((long)nArray.length < this.nnz || (long)nArray2.length < this.nnz || (long)dArray.length < this.nnz) {
            throw new LengthError("Output arrays are not long enough.");
        }
        Tools.arraycopy(this.data, 0, dArray, 0, this.data.length);
        int n = 0;
        int n2 = 0;
        int n3 = this.dimi;
        for (int i = n2; i < n3; ++i) {
            int n4 = 0;
            int n5 = this.dimj;
            int n6 = n4;
            while (n6 < n5) {
                nArray[n] = i;
                nArray2[n] = n6++;
                ++n;
            }
        }
    }

    @Override
    public void getDataAsTriplets(int[] nArray, int[] nArray2, double[] dArray) throws LengthError {
        int[] nArray3 = Util.fromMatlab(nArray);
        int[] nArray4 = Util.fromMatlab(nArray2);
        this._getDataAsTriplets(nArray3, nArray4, dArray);
        Util.toMatlab(nArray, nArray3);
        Util.toMatlab(nArray2, nArray4);
    }

    @Override
    public double get(int n, int n2) {
        return this.data[n * this.dimi + n2];
    }

    @Override
    public long numNonzeros() {
        return this.dimi * this.dimj;
    }
}

