/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import com.mosek.monty.Util;
import mosek.fusion.BaseVariable;
import mosek.fusion.DimensionError;
import mosek.fusion.Expr;
import mosek.fusion.Expression;
import mosek.fusion.IndexError;
import mosek.fusion.IntSet;
import mosek.fusion.LengthError;
import mosek.fusion.Model;
import mosek.fusion.NDSet;
import mosek.fusion.Set;
import mosek.fusion.SliceError;
import mosek.fusion.SliceVariable;
import mosek.fusion.SolutionError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;
import mosek.fusion.Variable;

public class CompoundVariable
extends BaseVariable {
    private int stackdim;
    private int[] varsb;
    private Variable[] vars;

    protected CompoundVariable(Variable[] variableArray, int n) {
        super(CompoundVariable.model_from_var(variableArray), CompoundVariable.compute_shape(variableArray, n));
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = variableArray.length;
        for (n2 = n5; n2 < n6; ++n2) {
            if (variableArray[n2].getShape().size == 1L) {
                ++n3;
                ++n4;
                continue;
            }
            if (variableArray[n2].getShape().size <= 1L) continue;
            ++n3;
            n4 += variableArray[n2].getShape()._dim(n);
        }
        this.vars = new Variable[n3];
        this.varsb = new int[n3 + 1];
        this.varsb[0] = 0;
        this.stackdim = n;
        n5 = 0;
        n6 = 0;
        n2 = variableArray.length;
        for (int i = n6; i < n2; ++i) {
            if (variableArray[i].getShape().size <= 0L) continue;
            this.vars[n5] = variableArray[i];
            this.varsb[n5 + 1] = variableArray[i].getShape().size == 1L ? this.varsb[n5] + 1 : this.varsb[n5] + variableArray[i].getShape()._dim(n);
            ++n5;
        }
    }

    @Override
    public StringBuffer elementDesc(long l, StringBuffer stringBuffer) {
        if (l < 0L || l >= this.shape_p.size) {
            throw new IndexError("Index out of bounds");
        }
        int[] nArray = this.shape_p.idxtokey(l);
        int n = 0;
        while (nArray[this.stackdim] >= this.varsb[n + 1]) {
            ++n;
        }
        nArray[this.stackdim] = nArray[this.stackdim] - this.varsb[n];
        this.vars[n].elementDesc(this.vars[n].getShape().linearidx(nArray), stringBuffer);
        return stringBuffer;
    }

    @Override
    public void elementName(long l, StringBuffer stringBuffer) {
        if (l < 0L || l >= this.shape_p.size) {
            throw new IndexError("Index out of bounds");
        }
        int[] nArray = this.shape_p.idxtokey(l);
        int n = 0;
        while (nArray[this.stackdim] >= this.varsb[n + 1]) {
            ++n;
        }
        nArray[this.stackdim] = nArray[this.stackdim] - this.varsb[n];
        this.vars[n].elementName(this.vars[n].getShape().linearidx(nArray), stringBuffer);
    }

    @Override
    public void inst(long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        if (l < 0L || l >= this.shape_p.size) {
            throw new IndexError("Index out of bounds");
        }
        int[] nArray4 = this.shape_p.idxtokey(l);
        int n = 0;
        while (nArray4[this.stackdim] >= this.varsb[n + 1]) {
            ++n;
        }
        nArray4[this.stackdim] = nArray4[this.stackdim] - this.varsb[n];
        this.vars[n].inst(this.vars[n].getShape().linearidx(nArray4), l2, nArray, nArray2, nArray3);
    }

    @Override
    public void set_values(long l, int[] nArray, long[] lArray, int n, double[] dArray, boolean bl) {
        int n2;
        int n3;
        int n4 = lArray.length;
        int n5 = nArray[0];
        int n6 = 1;
        int n7 = nArray.length;
        for (n3 = n6; n3 < n7; ++n3) {
            n5 *= nArray[n3];
        }
        n6 = 0;
        n7 = 0;
        n3 = nArray.length;
        int n8 = n7 < n3 ? n3 - n7 : 0;
        long[] lArray2 = new long[n8];
        int n9 = n7;
        int n10 = 0;
        while (n10 < n8) {
            lArray2[n6] = l;
            ++n6;
            ++n10;
            ++n9;
        }
        long[] lArray3 = lArray2;
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[this.shape_p.nd];
        long[] lArray4 = new long[this.shape_p.nd];
        lArray4[this.shape_p.nd - 1] = 1L;
        int n11 = 1;
        int n12 = this.shape_p.nd;
        for (n2 = n11; n2 < n12; ++n2) {
            lArray4[this.shape_p.nd - n2 - 1] = lArray4[this.shape_p.nd - n2] * (long)this.shape_p._dim(this.shape_p.nd - n2);
        }
        long[] lArray5 = new long[1];
        double[] dArray2 = new double[1];
        n2 = 0;
        int n13 = n5;
        for (int i = n2; i < n13; ++i) {
            long l2 = lArray3[0];
            int n14 = 0;
            int n15 = this.shape_p.nd;
            for (int j = n14; j < n15; ++j) {
                nArray3[j] = (int)(l2 / lArray4[j]);
                l2 -= (long)nArray3[j] * lArray4[j];
            }
            int n16 = 0;
            while (nArray3[this.stackdim] >= this.varsb[n16 + 1]) {
                ++n16;
            }
            nArray3[this.stackdim] = nArray3[this.stackdim] - this.varsb[n16];
            lArray5[0] = this.vars[n16].getShape().linearidx(nArray3);
            dArray2[0] = dArray[n + i];
            this.vars[n16].set_values(lArray5, dArray2, bl);
            nArray2[0] = nArray2[0] + 1;
            lArray3[0] = lArray3[0] + lArray[n4 - 1];
            n16 = 0;
            for (n16 = 0; n16 < n4 - 1 && nArray2[n16] == nArray[n16] && n16 < n4 - 1 && nArray2[n16] == nArray[n16]; ++n16) {
                nArray2[n16] = 0;
                int n17 = n16 + 1;
                nArray2[n17] = nArray2[n17] + 1;
            }
            int n18 = 0;
            n14 = n16;
            for (n15 = n18; n15 < n14; ++n15) {
                lArray3[n15] = lArray3[n16];
            }
        }
    }

    @Override
    public void set_values(long[] lArray, double[] dArray, boolean bl) {
        long[] lArray2 = new long[1];
        double[] dArray2 = new double[1];
        int[] nArray = new int[this.shape_p.nd];
        int n = 0;
        int n2 = lArray.length;
        for (int i = n; i < n2; ++i) {
            long l = lArray[i];
            int n3 = 0;
            int n4 = this.shape_p.nd;
            for (int j = n3; j < n4; ++j) {
                nArray[j] = (int)(l / this.shape_p.stride(j));
                l -= (long)nArray[j] * this.shape_p.stride(j);
            }
            int n5 = 0;
            while (nArray[this.stackdim] >= this.varsb[n5 + 1]) {
                ++n5;
            }
            nArray[this.stackdim] = nArray[this.stackdim] - this.varsb[n5];
            lArray2[0] = this.vars[n5].getShape().linearidx(nArray);
            dArray2[0] = dArray[i];
            this.vars[n5].set_values(lArray2, dArray2, bl);
        }
    }

    @Override
    public void values(long l, int[] nArray, long[] lArray, int n, double[] dArray, boolean bl) throws SolutionError {
        int n2;
        int n3 = lArray.length;
        int n4 = nArray[0];
        int n5 = 1;
        int n6 = nArray.length;
        for (n2 = n5; n2 < n6; ++n2) {
            n4 *= nArray[n2];
        }
        n5 = 0;
        n6 = 0;
        n2 = nArray.length;
        int n7 = n6 < n2 ? n2 - n6 : 0;
        long[] lArray2 = new long[n7];
        int n8 = n6;
        int n9 = 0;
        while (n9 < n7) {
            lArray2[n5] = l;
            ++n5;
            ++n9;
            ++n8;
        }
        long[] lArray3 = lArray2;
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[this.shape_p.nd];
        long[] lArray4 = new long[1];
        int n10 = 0;
        int n11 = n4;
        for (int i = n10; i < n11; ++i) {
            long l2 = lArray3[0];
            int n12 = 0;
            int n13 = this.shape_p.nd;
            for (int j = n12; j < n13; ++j) {
                nArray3[this.shape_p.nd - j - 1] = (int)(l2 % (long)this.shape_p._dim(this.shape_p.nd - j - 1));
                l2 /= (long)this.shape_p._dim(this.shape_p.nd - j - 1);
            }
            int n14 = 0;
            while (nArray3[this.stackdim] >= this.varsb[n14 + 1]) {
                ++n14;
            }
            nArray3[this.stackdim] = nArray3[this.stackdim] - this.varsb[n14];
            lArray4[0] = this.vars[n14].getShape().linearidx(nArray3);
            this.vars[n14].values(lArray4, n + i, dArray, bl);
            nArray2[0] = nArray2[0] + 1;
            n14 = 0;
            for (n14 = 0; n14 < n3 - 1 && nArray2[n14] == nArray[n3 - 1 - n14] && n14 < n3 - 1 && nArray2[n14] == nArray[n3 - 1 - n14]; ++n14) {
                nArray2[n14] = 0;
                int n15 = n14 + 1;
                nArray2[n15] = nArray2[n15] + 1;
            }
            int n16 = n14;
            lArray3[n16] = lArray3[n16] + lArray[n3 - n14 - 1];
            int n17 = 0;
            n12 = n14;
            for (n13 = n17; n13 < n12; ++n13) {
                lArray3[n13] = lArray3[n14];
            }
        }
    }

    @Override
    public void values(long[] lArray, int n, double[] dArray, boolean bl) throws SolutionError {
        long[] lArray2 = new long[1];
        int[] nArray = new int[this.shape_p.nd];
        int n2 = 0;
        int n3 = lArray.length;
        for (int i = n2; i < n3; ++i) {
            long l = lArray[i];
            int n4 = 0;
            int n5 = this.shape_p.nd;
            for (int j = n4; j < n5; ++j) {
                nArray[j] = (int)(l / this.shape_p.stride(j));
                l -= (long)nArray[j] * this.shape_p.stride(j);
            }
            int n6 = 0;
            while (nArray[this.stackdim] >= this.varsb[n6 + 1]) {
                ++n6;
            }
            nArray[this.stackdim] = nArray[this.stackdim] - this.varsb[n6];
            lArray2[0] = this.vars[n6].getShape().linearidx(nArray);
            this.vars[n6].values(lArray2, n + i, dArray, bl);
        }
    }

    @Override
    public void make_continuous(long[] lArray) {
        long[] lArray2 = new long[1];
        int[] nArray = new int[this.shape_p.nd];
        int n = 0;
        int n2 = lArray.length;
        for (int i = n; i < n2; ++i) {
            long l = lArray[i];
            int n3 = 0;
            int n4 = this.shape_p.nd;
            for (int j = n3; j < n4; ++j) {
                nArray[j] = (int)(l / this.shape_p.stride(j));
                l -= (long)nArray[j] * this.shape_p.stride(j);
            }
            int n5 = 0;
            while (nArray[this.stackdim] >= this.varsb[n5 + 1]) {
                ++n5;
            }
            nArray[this.stackdim] = nArray[this.stackdim] - this.varsb[n5];
            lArray2[0] = this.vars[n5].getShape().linearidx(nArray);
            this.vars[n5].make_continuous(lArray2);
        }
    }

    @Override
    public void make_integer(long[] lArray) {
        long[] lArray2 = new long[1];
        int[] nArray = new int[this.shape_p.nd];
        int n = 0;
        int n2 = lArray.length;
        for (int i = n; i < n2; ++i) {
            long l = lArray[i];
            int n3 = 0;
            int n4 = this.shape_p.nd;
            for (int j = n3; j < n4; ++j) {
                nArray[j] = (int)(l / this.shape_p.stride(j));
                l -= (long)nArray[j] * this.shape_p.stride(j);
            }
            int n5 = 0;
            while (nArray[this.stackdim] >= this.varsb[n5 + 1]) {
                ++n5;
            }
            nArray[this.stackdim] = nArray[this.stackdim] - this.varsb[n5];
            lArray2[0] = this.vars[n5].getShape().linearidx(nArray);
            this.vars[n5].make_integer(lArray2);
        }
    }

    @Override
    public Expression asExpr() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        long[] lArray = Tools.range(0L, this.shape_p.size + 1L);
        double[] dArray = Tools.ones((int)this.shape_p.size);
        long[] lArray2 = new long[(int)this.shape_p.size];
        if (this.stackdim < 1) {
            n8 = 0;
            n7 = (int)this.shape_p.size;
            for (n6 = n8; n6 < n7; ++n6) {
                lArray2[n6] = n6;
            }
        } else if (this.stackdim >= this.shape_p.nd) {
            n8 = 0;
            long l = this.vars[0].getShape().size;
            n5 = 0;
            long l2 = l;
            for (long i = (long)n5; i < l2; ++i) {
                n4 = 0;
                n3 = this.vars.length;
                for (n2 = n4; n2 < n3; ++n2) {
                    lArray2[n8] = (long)n2 * l + i;
                    ++n8;
                }
            }
        } else {
            n8 = 1;
            int n9 = 0;
            int n10 = this.stackdim;
            for (n5 = n9; n5 < n10; ++n5) {
                n8 *= this.shape_p._dim(n5);
            }
            long[] lArray3 = new long[this.vars.length];
            long[] lArray4 = new long[this.vars.length + 1];
            n5 = 1;
            int n11 = this.vars.length + 1;
            for (n = n5; n < n11; ++n) {
                lArray4[n] = lArray4[n - 1] + this.vars[n - 1].getShape().size;
            }
            n5 = 0;
            n11 = 0;
            n = n8;
            for (int i = n11; i < n; ++i) {
                boolean bl = false;
                n4 = 0;
                n3 = this.vars.length;
                for (n2 = n4; n2 < n3; ++n2) {
                    int n12 = 0;
                    long l = this.vars[n2].getShape().stride(this.stackdim - 1);
                    for (long j = (long)n12; j < l; ++j) {
                        lArray2[n5] = lArray4[n2] + lArray3[n2] + j;
                        ++n5;
                    }
                    int n13 = n2;
                    lArray3[n13] = lArray3[n13] + this.vars[n2].getShape().stride(this.stackdim - 1);
                }
            }
        }
        n8 = 0;
        n7 = 0;
        n6 = this.vars.length;
        n5 = n7 < n6 ? n6 - n7 : 0;
        Variable[] variableArray = new Variable[n5];
        n = n7;
        int n14 = 0;
        while (n14 < n5) {
            variableArray[n8] = this.vars[n];
            ++n8;
            ++n14;
            ++n;
        }
        Variable[] variableArray2 = variableArray;
        return new Expr(lArray, variableArray2, lArray2, dArray, null, this.shape_p, null, 1);
    }

    @Override
    public Variable _slice(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new LengthError("Mismatching array lengths");
        }
        if (nArray.length != this.shape_p.nd) {
            throw new SliceError("Slice has wrong number of dimensions");
        }
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            if (nArray[i] >= 0 && nArray[i] <= nArray2[i] && nArray2[i] <= this.shape_p._dim(i)) continue;
            throw new SliceError("Slice index is out of bounds");
        }
        n = 0;
        for (n2 = 0; n2 < nArray.length && n2 < nArray.length; ++n2) {
            if (nArray[n2] < nArray2[n2]) continue;
            n = 1;
        }
        if (n != 0) {
            n2 = nArray.length;
            int[] nArray3 = new int[n2];
            for (int i = 0; i < n2 && i < n2; ++i) {
                nArray3[i] = nArray[i] < nArray2[i] ? nArray2[i] - nArray[i] : 0;
            }
            return new SliceVariable(this, new NDSet(nArray3), 0L, new long[n2]);
        }
        if (nArray.length == 1) {
            return this._slice(nArray[0], nArray2[0]);
        }
        n2 = this.shape_p.nd;
        int[] nArray4 = new int[n2];
        int[] nArray5 = new int[n2];
        int n3 = 0;
        while (nArray[this.stackdim] >= this.varsb[n3 + 1]) {
            ++n3;
        }
        int n4 = n3;
        int n5 = nArray[this.stackdim] - this.varsb[n3];
        while (nArray2[this.stackdim] > this.varsb[n3 + 1]) {
            ++n3;
        }
        int n6 = n3;
        int n7 = nArray2[this.stackdim] - this.varsb[n3];
        for (n3 = 0; n3 < n2 && n3 < n2; ++n3) {
            nArray4[n3] = nArray[n3];
            nArray5[n3] = nArray2[n3];
        }
        if (n4 == n6) {
            nArray4[this.stackdim] = n5;
            nArray5[this.stackdim] = n7;
            return this.vars[n4]._slice(nArray4, nArray5);
        }
        Variable[] variableArray = new Variable[n6 - n4 + 1];
        nArray4[this.stackdim] = n5;
        nArray5[this.stackdim] = this.vars[n4].getShape()._dim(this.stackdim);
        variableArray[0] = this.vars[n4]._slice(nArray4, nArray5);
        nArray4[this.stackdim] = 0;
        nArray5[this.stackdim] = n7;
        variableArray[variableArray.length - 1] = this.vars[n6]._slice(nArray4, nArray5);
        int n8 = 1;
        int n9 = variableArray.length - 1;
        for (int i = n8; i < n9; ++i) {
            nArray4[this.stackdim] = 0;
            nArray5[this.stackdim] = this.vars[i + n4].getShape()._dim(this.stackdim);
            variableArray[i] = this.vars[i + n4]._slice(nArray4, nArray5);
        }
        return new CompoundVariable(variableArray, this.stackdim);
    }

    @Override
    public Variable slice(int[] nArray, int[] nArray2) {
        int[] nArray3 = Util.fromMatlab(nArray);
        int[] nArray4 = Util.fromMatlab(nArray2);
        Variable variable = this._slice(nArray3, nArray4);
        Util.toMatlab(nArray, nArray3);
        Util.toMatlab(nArray2, nArray4);
        return variable;
    }

    @Override
    public Variable _slice(int n, int n2) {
        if (this.shape_p.nd != 1) {
            throw new SliceError("Slice has wrong number of dimensions");
        }
        if (n > n2) {
            throw new SliceError("Invalid slice range");
        }
        if (n < 0 || n2 > this.shape_p._dim(0)) {
            throw new SliceError("Slice index is out of bounds");
        }
        if (n == n2) {
            return new SliceVariable(this, new IntSet(0), 0L, new long[]{0L});
        }
        int n3 = 0;
        while (n >= this.varsb[n3 + 1]) {
            ++n3;
        }
        int n4 = n3;
        int n5 = n - this.varsb[n3];
        while (n2 > this.varsb[n3 + 1]) {
            ++n3;
        }
        int n6 = n3;
        int n7 = n2 - this.varsb[n3];
        if (n4 == n6) {
            return this.vars[n4]._slice(n5, n7);
        }
        Variable[] variableArray = new Variable[n6 - n4 + 1];
        variableArray[0] = n5 > 0 ? this.vars[n4]._slice(n5, this.vars[n4].getShape()._dim(0)) : this.vars[n4];
        variableArray[variableArray.length - 1] = n7 < this.vars[n6].getShape()._dim(0) ? this.vars[n6]._slice(0, n7) : this.vars[n6];
        for (int i = 1; i < variableArray.length - 1 && i < variableArray.length - 1; ++i) {
            variableArray[i] = this.vars[n4 + i];
        }
        return new CompoundVariable(variableArray, 0);
    }

    @Override
    public Variable slice(int n, int n2) {
        int n3 = Util.fromMatlab(n);
        int n4 = Util.fromMatlab(n2);
        Variable variable = this._slice(n3, n4);
        return variable;
    }

    public static Set compute_shape(Variable[] variableArray, int n) {
        int n2;
        int n3;
        int n4;
        Set set = variableArray[0].getShape();
        int n5 = 0;
        int n6 = 0;
        int n7 = variableArray.length;
        for (n4 = n6; n4 < n7; ++n4) {
            Variable variable = variableArray[n4];
            if (variable.getShape().size <= 0L) continue;
            if (variable.getShape().nd != set.nd) {
                throw new DimensionError("Mismatching variable shape");
            }
            int n8 = 0;
            n3 = set.nd;
            for (n2 = n8; n2 < n3; ++n2) {
                if (n2 == n || set._dim(n2) == variable.getShape()._dim(n2)) continue;
                throw new DimensionError("Mismatching variable shape");
            }
            n5 += variable.getShape()._dim(n);
        }
        if (set.nd == 1) {
            return new IntSet(n5);
        }
        n6 = 0;
        n7 = 0;
        n4 = set.nd;
        int n9 = n7 < n4 ? n4 - n7 : 0;
        int[] nArray = new int[n9];
        n3 = n7;
        n2 = 0;
        while (n2 < n9) {
            nArray[n6] = set._dim(n3);
            ++n6;
            ++n2;
            ++n3;
        }
        int[] nArray2 = nArray;
        nArray2[n] = n5;
        return new NDSet(nArray2);
    }

    public static Model model_from_var(Variable[] variableArray) {
        return variableArray == null || variableArray.length == 0 ? null : variableArray[0].getModel();
    }
}

