/*
 * Decompiled with CFR 0.152.
 */
package mosek;

import java.io.Closeable;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import mosek.ArrayLengthException;
import mosek.Error;
import mosek.Stream;
import mosek.feature;
import mosek.rescode;
import mosek.streamtype;
import mosek.transpose;
import mosek.uplo;

public final class Env
implements Closeable {
    private long native_env;
    private Stream[] stream;

    private void set(long l) {
        this.native_env = l;
    }

    public long get() {
        return this.native_env;
    }

    private static native long createEnv(String var0);

    private static native void deleteEnv(long var0);

    private native void attachStream(long var1, int var3);

    private native void detachStream(long var1, int var3);

    private void stream_func(int n, String string) {
        if (n < this.stream.length && this.stream[n] != null) {
            this.stream[n].print(string);
        }
    }

    public Env() {
        this.native_env = Env.createEnv(null);
        this.stream = new Stream[4];
    }

    public Env(String string) {
        this.native_env = Env.createEnv(string);
        this.stream = new Stream[4];
    }

    public synchronized void set_Stream(streamtype streamtype2, Stream stream) {
        int n = streamtype2.getValue();
        this.detachStream(this.native_env, n);
        if (this.stream[n] != null) {
            this.stream[n] = null;
        }
        if (stream != null) {
            this.stream[n] = stream;
            this.attachStream(this.native_env, n);
        }
    }

    public void connectStream(Stream stream, streamtype streamtype2) {
        this.set_Stream(streamtype2, stream);
    }

    protected void finalize() {
        if (this.native_env != 0L) {
            this.cleanup();
            Env.deleteEnv(this.native_env);
            this.native_env = 0L;
        }
    }

    public void cleanup() {
        for (streamtype streamtype2 : streamtype.values()) {
            this.set_Stream(streamtype2, null);
        }
    }

    public void dispose() {
        this.finalize();
    }

    public static native boolean checkversion();

    public synchronized void axpy(int n, double d, double[] dArray, double[] dArray2) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument x must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument y must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.put(dArray2);
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("axpy", "x");
        }
        if (dArray2 != null && dArray2.length < n) {
            throw new ArrayLengthException("axpy", "y");
        }
        this.p_axpy(this.native_env, n, d, doubleBuffer, doubleBuffer3);
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.get(dArray2);
        }
    }

    private native void p_axpy(long var1, int var3, double var4, DoubleBuffer var6, DoubleBuffer var7) throws Error;

    public synchronized void checkinall() throws Error {
        this.p_checkinall(this.native_env);
    }

    private native void p_checkinall(long var1) throws Error;

    public synchronized void checkinlicense(feature feature2) throws Error {
        this.p_checkinlicense(this.native_env, feature2.getValue());
    }

    private native void p_checkinlicense(long var1, int var3) throws Error;

    public synchronized void checkoutlicense(feature feature2) throws Error {
        this.p_checkoutlicense(this.native_env, feature2.getValue());
    }

    private native void p_checkoutlicense(long var1, int var3) throws Error;

    public synchronized void computesparsecholesky(int n, int n2, double d, int[] nArray, long[] lArray, int[] nArray2, double[] dArray, int[][] nArray3, double[][] dArray2, int[][] nArray4, long[][] lArray2, long[] lArray3, int[][] nArray5, double[][] dArray3) throws Error {
        int n3 = nArray == null ? 0 : nArray.length;
        if (n3 != (lArray == null ? 0 : lArray.length)) {
            throw new ArrayLengthException("computesparsecholesky", "n");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument anzc must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (lArray == null) {
            throw new NullPointerException("Argument aptrc must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        LongBuffer longBuffer = null;
        if (lArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(lArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            LongBuffer longBuffer2 = longBuffer = lArray == null ? null : byteBuffer2.asLongBuffer();
        }
        if (longBuffer != null) {
            longBuffer.position(0);
            longBuffer.put(lArray);
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument asubc must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.put(nArray2);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument avalc must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (nArray3.length != 1) {
            throw new ArrayLengthException("computesparsecholesky", "perm");
        }
        if (dArray2.length != 1) {
            throw new ArrayLengthException("computesparsecholesky", "diag");
        }
        if (nArray4.length != 1) {
            throw new ArrayLengthException("computesparsecholesky", "lnzc");
        }
        if (lArray2.length != 1) {
            throw new ArrayLengthException("computesparsecholesky", "lptrc");
        }
        ByteBuffer byteBuffer5 = ByteBuffer.allocateDirect(8);
        byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer3 = byteBuffer5.asLongBuffer();
        if (lArray3 != null && lArray3.length > 0) {
            longBuffer3.put(0, lArray3[0]);
        }
        if (nArray5.length != 1) {
            throw new ArrayLengthException("computesparsecholesky", "lsubc");
        }
        if (dArray3.length != 1) {
            throw new ArrayLengthException("computesparsecholesky", "lvalc");
        }
        this.p_computesparsecholesky(this.native_env, n, n2, d, n3, intBuffer, longBuffer, intBuffer3, doubleBuffer, nArray3, dArray2, nArray4, lArray2, longBuffer3, nArray5, dArray3);
        if (lArray3 != null && lArray3.length > 0) {
            lArray3[0] = longBuffer3.get(0);
        }
    }

    private native void p_computesparsecholesky(long var1, int var3, int var4, double var5, int var7, IntBuffer var8, LongBuffer var9, IntBuffer var10, DoubleBuffer var11, int[][] var12, double[][] var13, int[][] var14, long[][] var15, LongBuffer var16, int[][] var17, double[][] var18) throws Error;

    public synchronized void dot(int n, double[] dArray, double[] dArray2, double[] dArray3) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument x must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument y must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.put(dArray2);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(8);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer doubleBuffer5 = byteBuffer3.asDoubleBuffer();
        if (dArray3 != null && dArray3.length > 0) {
            doubleBuffer5.put(0, dArray3[0]);
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("dot", "x");
        }
        if (dArray2 != null && dArray2.length < n) {
            throw new ArrayLengthException("dot", "y");
        }
        this.p_dot(this.native_env, n, doubleBuffer, doubleBuffer3, doubleBuffer5);
        if (dArray3 != null && dArray3.length > 0) {
            dArray3[0] = doubleBuffer5.get(0);
        }
    }

    private native void p_dot(long var1, int var3, DoubleBuffer var4, DoubleBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void echointro(int n) throws Error {
        this.p_echointro(this.native_env, n);
    }

    private native void p_echointro(long var1, int var3) throws Error;

    public synchronized void gemm(transpose transpose2, transpose transpose3, int n, int n2, int n3, double d, double[] dArray, double[] dArray2, double d2, double[] dArray3) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument a must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument b must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.put(dArray2);
        }
        if (dArray3 == null) {
            throw new NullPointerException("Argument c must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer5 = null;
        if (dArray3 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray3.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer6 = doubleBuffer5 = dArray3 == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (doubleBuffer5 != null) {
            doubleBuffer5.position(0);
            doubleBuffer5.put(dArray3);
        }
        if (dArray != null && dArray.length < n * n3) {
            throw new ArrayLengthException("gemm", "a");
        }
        if (dArray2 != null && dArray2.length < n3 * n2) {
            throw new ArrayLengthException("gemm", "b");
        }
        if (dArray3 != null && dArray3.length < n * n2) {
            throw new ArrayLengthException("gemm", "c");
        }
        this.p_gemm(this.native_env, transpose2.getValue(), transpose3.getValue(), n, n2, n3, d, doubleBuffer, doubleBuffer3, d2, doubleBuffer5);
        if (doubleBuffer5 != null) {
            doubleBuffer5.position(0);
            doubleBuffer5.get(dArray3);
        }
    }

    private native void p_gemm(long var1, int var3, int var4, int var5, int var6, int var7, double var8, DoubleBuffer var10, DoubleBuffer var11, double var12, DoubleBuffer var14) throws Error;

    public synchronized void gemv(transpose transpose2, int n, int n2, double d, double[] dArray, double[] dArray2, double d2, double[] dArray3) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument a must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument x must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.put(dArray2);
        }
        if (dArray3 == null) {
            throw new NullPointerException("Argument y must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        DoubleBuffer doubleBuffer5 = null;
        if (dArray3 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(dArray3.length * 8);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer6 = doubleBuffer5 = dArray3 == null ? null : byteBuffer3.asDoubleBuffer();
        }
        if (doubleBuffer5 != null) {
            doubleBuffer5.position(0);
            doubleBuffer5.put(dArray3);
        }
        if (dArray != null && dArray.length < n2 * n) {
            throw new ArrayLengthException("gemv", "a");
        }
        if (dArray2 != null && dArray2.length < (transpose2 == transpose.no ? n2 : n)) {
            throw new ArrayLengthException("gemv", "x");
        }
        if (dArray3 != null && dArray3.length < (transpose2 == transpose.no ? n : n2)) {
            throw new ArrayLengthException("gemv", "y");
        }
        this.p_gemv(this.native_env, transpose2.getValue(), n, n2, d, doubleBuffer, doubleBuffer3, d2, doubleBuffer5);
        if (doubleBuffer5 != null) {
            doubleBuffer5.position(0);
            doubleBuffer5.get(dArray3);
        }
    }

    private native void p_gemv(long var1, int var3, int var4, int var5, double var6, DoubleBuffer var8, DoubleBuffer var9, double var10, DoubleBuffer var12) throws Error;

    public static void getcodedesc(rescode rescode2, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1025);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(1025);
        Env.p_getcodedesc(rescode2.getValue(), byteBuffer, byteBuffer2);
        byte[] byArray = new byte[1025];
        byteBuffer2.get(byArray);
        try {
            stringBuffer2.append(new String(byArray, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] byArray2 = new byte[1025];
        byteBuffer.get(byArray2);
        try {
            stringBuffer.append(new String(byArray2, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private static native void p_getcodedesc(int var0, ByteBuffer var1, ByteBuffer var2) throws Error;

    public static void getversion(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) throws Error {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        if (nArray != null && nArray.length > 0) {
            intBuffer.put(0, nArray[0]);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer2 = byteBuffer2.asIntBuffer();
        if (nArray2 != null && nArray2.length > 0) {
            intBuffer2.put(0, nArray2[0]);
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(4);
        byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer3 = byteBuffer3.asIntBuffer();
        if (nArray3 != null && nArray3.length > 0) {
            intBuffer3.put(0, nArray3[0]);
        }
        ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(4);
        byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer4 = byteBuffer4.asIntBuffer();
        if (nArray4 != null && nArray4.length > 0) {
            intBuffer4.put(0, nArray4[0]);
        }
        Env.p_getversion(intBuffer, intBuffer2, intBuffer3, intBuffer4);
        if (nArray4 != null && nArray4.length > 0) {
            nArray4[0] = intBuffer4.get(0);
        }
        if (nArray3 != null && nArray3.length > 0) {
            nArray3[0] = intBuffer3.get(0);
        }
        if (nArray2 != null && nArray2.length > 0) {
            nArray2[0] = intBuffer2.get(0);
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = intBuffer.get(0);
        }
    }

    private static native void p_getversion(IntBuffer var0, IntBuffer var1, IntBuffer var2, IntBuffer var3) throws Error;

    public static void licensecleanup() throws Error {
        Env.p_licensecleanup();
    }

    private static native void p_licensecleanup() throws Error;

    public synchronized void linkfiletostream(streamtype streamtype2, String string, int n) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_linkfiletoenvstream(this.native_env, streamtype2.getValue(), byteBuffer, n);
    }

    private native void p_linkfiletoenvstream(long var1, int var3, ByteBuffer var4, int var5) throws Error;

    public synchronized void potrf(uplo uplo2, int n, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument a must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray != null && dArray.length < n * n) {
            throw new ArrayLengthException("potrf", "a");
        }
        this.p_potrf(this.native_env, uplo2.getValue(), n, doubleBuffer);
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_potrf(long var1, int var3, int var4, DoubleBuffer var5) throws Error;

    public synchronized void putlicensecode(int[] nArray) throws Error {
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (nArray != null && nArray.length < 21) {
            throw new ArrayLengthException("putlicensecode", "code");
        }
        this.p_putlicensecode(this.native_env, intBuffer);
    }

    private native void p_putlicensecode(long var1, IntBuffer var3) throws Error;

    public synchronized void putlicensedebug(int n) throws Error {
        this.p_putlicensedebug(this.native_env, n);
    }

    private native void p_putlicensedebug(long var1, int var3) throws Error;

    public synchronized void putlicensepath(String string) throws Error {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length + 1);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        this.p_putlicensepath(this.native_env, byteBuffer);
    }

    private native void p_putlicensepath(long var1, ByteBuffer var3) throws Error;

    public synchronized void putlicensewait(int n) throws Error {
        this.p_putlicensewait(this.native_env, n);
    }

    private native void p_putlicensewait(long var1, int var3) throws Error;

    public synchronized void sparsetriangularsolvedense(transpose transpose2, int[] nArray, long[] lArray, int[] nArray2, double[] dArray, double[] dArray2) throws Error {
        long l;
        int n = dArray2 == null ? 0 : dArray2.length;
        if (n != (nArray == null ? 0 : nArray.length)) {
            throw new ArrayLengthException("sparsetriangularsolvedense", "n");
        }
        if (n != (lArray == null ? 0 : lArray.length)) {
            throw new ArrayLengthException("sparsetriangularsolvedense", "n");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument lnzc must not be null");
        }
        ByteBuffer byteBuffer = null;
        IntBuffer intBuffer = null;
        if (nArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(nArray.length * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer2 = intBuffer = nArray == null ? null : byteBuffer.asIntBuffer();
        }
        if (intBuffer != null) {
            intBuffer.position(0);
            intBuffer.put(nArray);
        }
        if (lArray == null) {
            throw new NullPointerException("Argument lptrc must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        LongBuffer longBuffer = null;
        if (lArray != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(lArray.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            LongBuffer longBuffer2 = longBuffer = lArray == null ? null : byteBuffer2.asLongBuffer();
        }
        if (longBuffer != null) {
            longBuffer.position(0);
            longBuffer.put(lArray);
        }
        if ((l = nArray2 == null ? 0L : (long)nArray2.length) != (long)(dArray == null ? 0 : dArray.length)) {
            throw new ArrayLengthException("sparsetriangularsolvedense", "lensubnval");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument lsubc must not be null");
        }
        ByteBuffer byteBuffer3 = null;
        IntBuffer intBuffer3 = null;
        if (nArray2 != null) {
            byteBuffer3 = ByteBuffer.allocateDirect(nArray2.length * 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer4 = intBuffer3 = nArray2 == null ? null : byteBuffer3.asIntBuffer();
        }
        if (intBuffer3 != null) {
            intBuffer3.position(0);
            intBuffer3.put(nArray2);
        }
        if (dArray == null) {
            throw new NullPointerException("Argument lvalc must not be null");
        }
        ByteBuffer byteBuffer4 = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer4 = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer4.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer4.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument b must not be null");
        }
        ByteBuffer byteBuffer5 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer5 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer5.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer5.asDoubleBuffer();
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.put(dArray2);
        }
        if (nArray != null && nArray.length < n) {
            throw new ArrayLengthException("sparsetriangularsolvedense", "lnzc");
        }
        if (lArray != null && lArray.length < n) {
            throw new ArrayLengthException("sparsetriangularsolvedense", "lptrc");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("sparsetriangularsolvedense", "lsubc");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("sparsetriangularsolvedense", "lvalc");
        }
        if (dArray2 != null && dArray2.length < n) {
            throw new ArrayLengthException("sparsetriangularsolvedense", "b");
        }
        this.p_sparsetriangularsolvedense(this.native_env, transpose2.getValue(), n, intBuffer, longBuffer, l, intBuffer3, doubleBuffer, doubleBuffer3);
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.get(dArray2);
        }
    }

    private native void p_sparsetriangularsolvedense(long var1, int var3, int var4, IntBuffer var5, LongBuffer var6, long var7, IntBuffer var9, DoubleBuffer var10, DoubleBuffer var11) throws Error;

    public synchronized void syeig(uplo uplo2, int n, double[] dArray, double[] dArray2) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument a must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument w must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n * n) {
            throw new ArrayLengthException("syeig", "a");
        }
        if (dArray2 != null && dArray2.length < n) {
            throw new ArrayLengthException("syeig", "w");
        }
        this.p_syeig(this.native_env, uplo2.getValue(), n, doubleBuffer, doubleBuffer3);
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.get(dArray2);
        }
    }

    private native void p_syeig(long var1, int var3, int var4, DoubleBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void syevd(uplo uplo2, int n, double[] dArray, double[] dArray2) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument a must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument w must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (dArray != null && dArray.length < n * n) {
            throw new ArrayLengthException("syevd", "a");
        }
        if (dArray2 != null && dArray2.length < n) {
            throw new ArrayLengthException("syevd", "w");
        }
        this.p_syevd(this.native_env, uplo2.getValue(), n, doubleBuffer, doubleBuffer3);
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.get(dArray2);
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.get(dArray);
        }
    }

    private native void p_syevd(long var1, int var3, int var4, DoubleBuffer var5, DoubleBuffer var6) throws Error;

    public synchronized void syrk(uplo uplo2, transpose transpose2, int n, int n2, double d, double[] dArray, double d2, double[] dArray2) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument a must not be null");
        }
        ByteBuffer byteBuffer = null;
        DoubleBuffer doubleBuffer = null;
        if (dArray != null) {
            byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer2 = doubleBuffer = dArray == null ? null : byteBuffer.asDoubleBuffer();
        }
        if (doubleBuffer != null) {
            doubleBuffer.position(0);
            doubleBuffer.put(dArray);
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument c must not be null");
        }
        ByteBuffer byteBuffer2 = null;
        DoubleBuffer doubleBuffer3 = null;
        if (dArray2 != null) {
            byteBuffer2 = ByteBuffer.allocateDirect(dArray2.length * 8);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer4 = doubleBuffer3 = dArray2 == null ? null : byteBuffer2.asDoubleBuffer();
        }
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.put(dArray2);
        }
        if (dArray != null && dArray.length < n * n2) {
            throw new ArrayLengthException("syrk", "a");
        }
        if (dArray2 != null && dArray2.length < n * n) {
            throw new ArrayLengthException("syrk", "c");
        }
        this.p_syrk(this.native_env, uplo2.getValue(), transpose2.getValue(), n, n2, d, doubleBuffer, d2, doubleBuffer3);
        if (doubleBuffer3 != null) {
            doubleBuffer3.position(0);
            doubleBuffer3.get(dArray2);
        }
    }

    private native void p_syrk(long var1, int var3, int var4, int var5, int var6, double var7, DoubleBuffer var9, double var10, DoubleBuffer var12) throws Error;

    @Override
    public void close() {
        this.dispose();
    }

    public static void reload_library() {
        String string = "mosekjava8_1";
        try {
            String string2;
            String string3 = System.getProperty("os.name");
            String string4 = System.getProperty("os.arch");
            String string5 = null;
            String string6 = null;
            if (string3.contains("OS X")) {
                string5 = ".jnilib";
                string6 = "lib";
            } else if (string3.contains("Windows")) {
                string5 = ".dll";
                string6 = "";
            } else {
                string5 = ".so";
                string6 = "lib";
            }
            File file = new File(URLDecoder.decode(Env.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8"));
            File file2 = file.getParentFile();
            if (string3.contains("Windows")) {
                string2 = null;
                string2 = string4 == "i386" ? new File(file2, "mosek8_1.dll").getPath() : new File(file2, "mosek64_8_1.dll").getPath();
                System.out.println("Attempt to load:" + string2);
                System.load(string2);
            }
            string2 = new File(file2, string6 + string + string5).getPath();
            System.out.println("Attempt to load:" + string2);
            System.load(string2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.loadLibrary(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    static {
        Env.reload_library();
    }
}

