/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.ExpressionError;
import mosek.fusion.UnexpectedError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;

public class WorkStack {
    public int code_base = 0;
    public int cconst_base = 0;
    public int codeptr_base = 0;
    public int cof_base = 0;
    public int nidxs_base = 0;
    public int sp_base = 0;
    public int shape_base = 0;
    public int ptr_base = 0;
    public boolean hassp = false;
    public int ncodeatom = 0;
    public int nelem = 0;
    public int nnz = 0;
    public int nd = 0;
    public int pf64 = 0;
    public int pi64 = 0;
    public int pi32 = 0;
    public double[] f64;
    public long[] i64;
    public int[] i32 = new int[128];

    public WorkStack() {
        this.i64 = new long[128];
        this.f64 = new double[128];
    }

    public void validate() {
        this.validate_from(this.pi32, this.pi64, this.pf64, false);
    }

    public void validate_all() {
        this.validate_from(this.pi32, this.pi64, this.pf64, true);
    }

    private void validate_from(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int n6 = this.i32[n - 1];
        int n7 = this.i32[n - n6 - 2];
        int n8 = this.i32[n - n6 - 3];
        boolean bl2 = this.i32[n - n6 - 4] != 0;
        int n9 = this.i32[n - n6 - 5];
        int n10 = n - n6 - 6 - n7;
        int n11 = n9 > 0 ? n10 - (n8 + 1) : n10;
        int n12 = n11 - n9;
        int n13 = bl2 ? n2 - n7 : n2;
        int n14 = n13 - n8;
        int n15 = n3 - n8;
        int n16 = n15 - n9;
        long l = 1L;
        for (n5 = 0; n5 < n6 && n5 < n6; ++n5) {
            l *= (long)this.i32[n - n6 - 1 + n5];
        }
        if (l < (long)n7) {
            throw new UnexpectedError("Invalid shape/nelem");
        }
        if (l > (long)n7 && !bl2) {
            throw new UnexpectedError("Invalid hassp/nelem/shape");
        }
        if (n8 < this.i32[n10 + n7]) {
            throw new UnexpectedError("Invalid ptr/nnz");
        }
        n5 = 0;
        int n17 = n7;
        for (n4 = n5; n4 < n17; ++n4) {
            if (this.i32[n10 + n4] <= this.i32[n10 + n4 + 1]) continue;
            throw new UnexpectedError("Invalid ptr, not ascending");
        }
        if (bl2) {
            n5 = 0;
            n17 = n7 - 1;
            for (n4 = n5; n4 < n17; ++n4) {
                if (this.i64[n13 + n4] <= this.i64[n13 + n4 + 1]) continue;
                throw new UnexpectedError("Invalid sp - not sorted");
            }
        }
        if (n9 > 0) {
            n5 = 0;
            n17 = n8;
            for (n4 = n5; n4 < n17; ++n4) {
                if (this.i32[n11 + n4] <= this.i32[n11 + n4 + 1]) continue;
                throw new UnexpectedError("Invalid codeptr - not ascending");
            }
            n5 = 0;
            n17 = n8;
            for (n4 = n5; n4 < n17; ++n4) {
                int n18 = 0;
                int n19 = this.i32[n11 + n4];
                int n20 = this.i32[n11 + n4 + 1];
                for (int i = n19; i < n20; ++i) {
                    int n21 = this.i32[n12 + i];
                    if (n21 == 0) continue;
                    if (n21 == 1 || n21 == 2 || n21 == 10) {
                        ++n18;
                        continue;
                    }
                    if (n21 == 3 || n21 == 5) {
                        if (n18 < 2) {
                            throw new UnexpectedError("Code stack underflow");
                        }
                        --n18;
                        continue;
                    }
                    if (n21 == 4 || n21 == 6) {
                        if (n18 >= 1) continue;
                        throw new UnexpectedError("Code stack underflow");
                    }
                    if (n21 == 8) {
                        int n22 = (int)this.f64[n16 + i];
                        if (n22 > n18) {
                            throw new UnexpectedError("Code stack underflow in SUM");
                        }
                        n18 -= n22 - 1;
                        continue;
                    }
                    throw new UnexpectedError("Invalid code list opcode");
                }
                if (n18 == true) continue;
                throw new UnexpectedError("Invalid code list result");
            }
        }
        if (bl) {
            this.validate_from(n12, n14, n16, bl);
        }
    }

    public String formatCurrent() {
        int n;
        int n2;
        Object[] objectArray;
        int n3;
        int n4;
        int n5;
        StringBuffer stringBuffer = new StringBuffer();
        int n6 = 0;
        int n7 = 0;
        int n8 = this.nd;
        int n9 = n7 < n8 ? n8 - n7 : 0;
        int[] nArray = new int[n9];
        int n10 = n7;
        int n11 = 0;
        while (n11 < n9) {
            nArray[n6] = this.i32[this.shape_base + n10];
            ++n6;
            ++n11;
            ++n10;
        }
        n11 = 0;
        int n12 = 0;
        int n13 = this.nelem + 1;
        int n14 = n12 < n13 ? n13 - n12 : 0;
        int[] nArray2 = new int[n14];
        int n15 = n12;
        int n16 = 0;
        while (n16 < n14) {
            nArray2[n11] = this.i32[this.ptr_base + n15];
            ++n11;
            ++n16;
            ++n15;
        }
        stringBuffer.a("  nelem     = ").a(this.nelem).a("\n").a("  nnz       = ").a(this.nnz).a("\n").a("  hassp     = ").a(this.hassp).a(" / ").a(this.hassp).a("\n").a("  shape     = ").a(nArray).a("\n").a("  ptr       = ").a(nArray2).a("\n");
        if (this.ncodeatom > 0) {
            n16 = 0;
            n5 = 0;
            n4 = this.nnz + 1;
            n3 = n5 < n4 ? n4 - n5 : 0;
            objectArray = new int[n3];
            n2 = n5;
            n = 0;
            while (n < n3) {
                objectArray[n16] = this.i32[this.codeptr_base + n2];
                ++n16;
                ++n;
                ++n2;
            }
            stringBuffer.a("  codeptr   = ").a((int[])objectArray).a("\n");
        }
        if (this.hassp) {
            n16 = 0;
            n5 = 0;
            n4 = this.nelem;
            n3 = n5 < n4 ? n4 - n5 : 0;
            objectArray = new long[n3];
            n2 = n5;
            n = 0;
            while (n < n3) {
                objectArray[n16] = (int)this.i64[this.sp_base + n2];
                ++n16;
                ++n;
                ++n2;
            }
            stringBuffer.a("  sp        = ").a((long[])objectArray).a("\n");
        }
        n16 = 0;
        n5 = this.nelem;
        for (n4 = n16; n4 < n5; ++n4) {
            n3 = 0;
            int n17 = this.i32[this.ptr_base + n4];
            n2 = this.i32[this.ptr_base + n4 + 1];
            n = n17 < n2 ? n2 - n17 : 0;
            long[] lArray = new long[n];
            int n18 = n17;
            int n19 = 0;
            while (n19 < n) {
                lArray[n3] = this.i64[this.nidxs_base + n18];
                ++n3;
                ++n19;
                ++n18;
            }
            n19 = 0;
            int n20 = this.i32[this.ptr_base + n4];
            int n21 = this.i32[this.ptr_base + n4 + 1];
            int n22 = n20 < n21 ? n21 - n20 : 0;
            double[] dArray = new double[n22];
            int n23 = n20;
            int n24 = 0;
            while (n24 < n22) {
                dArray[n19] = this.f64[this.cof_base + n23];
                ++n19;
                ++n24;
                ++n23;
            }
            stringBuffer.a("  row[").a(n4).a("]").a("\n").a("    nidx : ").a(lArray).a("\n").a("    cof  : ").a(dArray).a("\n");
            if (this.ncodeatom <= 0) continue;
            n24 = this.i32[this.ptr_base + n4];
            int n25 = this.i32[this.ptr_base + n4 + 1];
            for (int i = n24; i < n25; ++i) {
                int n26 = 0;
                int n27 = this.i32[this.codeptr_base + i];
                int n28 = this.i32[this.codeptr_base + i + 1];
                int n29 = n27 < n28 ? n28 - n27 : 0;
                int[] nArray3 = new int[n29];
                int n30 = n27;
                int n31 = 0;
                while (n31 < n29) {
                    nArray3[n26] = this.i32[this.code_base + n30];
                    ++n26;
                    ++n31;
                    ++n30;
                }
                n31 = 0;
                int n32 = this.i32[this.codeptr_base + i];
                int n33 = this.i32[this.codeptr_base + i + 1];
                int n34 = n32 < n33 ? n33 - n32 : 0;
                double[] dArray2 = new double[n34];
                int n35 = n32;
                int n36 = 0;
                while (n36 < n34) {
                    dArray2[n31] = this.f64[this.cconst_base + n35];
                    ++n31;
                    ++n36;
                    ++n35;
                }
                stringBuffer.a("      code[").a(this.i64[this.nidxs_base + i]).a("] ").a(nArray3).a(dArray2).a("\n");
            }
        }
        return stringBuffer.toString();
    }

    public boolean peek_hassp() {
        return this.peeki32(3 + this.peek_nd()) != 0;
    }

    public int peek_nnz() {
        return this.peeki32(2 + this.peek_nd());
    }

    public int peek_nelem() {
        return this.peeki32(1 + this.peek_nd());
    }

    public int peek_dim(int n) {
        return this.peeki32(n + 1);
    }

    public int peek_nd() {
        return this.peeki32();
    }

    public void alloc_expr(int n, int n2, int n3, boolean bl) {
        this.alloc_expr(n, n2, n3, bl, 0);
    }

    public void alloc_expr(int n, int n2, int n3, boolean bl, int n4) {
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new ExpressionError("Attempted to allocate negative amount on work stack");
        }
        this.cof_base = this.allocf64(n3);
        this.cconst_base = this.allocf64(n4);
        this.nidxs_base = this.alloci64(n3);
        this.sp_base = bl ? this.alloci64(n2) : -9999;
        this.code_base = this.alloci32(n4);
        this.codeptr_base = n4 > 0 ? this.alloci32(n3 + 1) : -9999;
        this.ptr_base = this.alloci32(n2 + 1);
        this.pushi32(n4);
        this.pushi32(bl ? 1 : 0);
        this.pushi32(n3);
        this.pushi32(n2);
        this.shape_base = this.alloci32(n);
        this.pushi32(n);
        this.ncodeatom = n4;
        this.nd = n;
        this.nelem = n2;
        this.nnz = n3;
        this.hassp = bl;
    }

    public void pop_expr() {
        this.nd = this.popi32();
        this.shape_base = this.popi32(this.nd);
        this.nelem = this.popi32();
        this.nnz = this.popi32();
        this.hassp = this.popi32() != 0;
        this.ncodeatom = this.popi32();
        this.ptr_base = this.popi32(this.nelem + 1);
        this.codeptr_base = this.ncodeatom > 0 ? this.popi32(this.nnz + 1) : -9999;
        this.code_base = this.popi32(this.ncodeatom);
        this.sp_base = this.hassp ? this.popi64(this.nelem) : -9999;
        this.nidxs_base = this.popi64(this.nnz);
        this.cconst_base = this.popf64(this.ncodeatom);
        this.cof_base = this.popf64(this.nnz);
    }

    public void copy_expr(WorkStack workStack) {
        int n = this.pi32;
        int n2 = this.pi64;
        int n3 = this.pf64;
        this.pop_expr();
        int n4 = workStack.alloci32(n - this.pi32);
        int n5 = workStack.alloci64(n2 - this.pi64);
        int n6 = workStack.allocf64(n3 - this.pf64);
        Tools.arraycopy(this.i32, this.pi32, workStack.i32, n4, n - this.pi32);
        Tools.arraycopy(this.i64, this.pi64, workStack.i64, n5, n2 - this.pi64);
        Tools.arraycopy(this.f64, this.pf64, workStack.f64, n6, n3 - this.pf64);
        this.pi32 = n;
        this.pi64 = n2;
        this.pf64 = n3;
    }

    public void move_expr(WorkStack workStack) {
        int n = this.pi32;
        int n2 = this.pi64;
        int n3 = this.pf64;
        this.pop_expr();
        int n4 = workStack.alloci32(n - this.pi32);
        int n5 = workStack.alloci64(n2 - this.pi64);
        int n6 = workStack.allocf64(n3 - this.pf64);
        Tools.arraycopy(this.i32, this.pi32, workStack.i32, n4, n - this.pi32);
        Tools.arraycopy(this.i64, this.pi64, workStack.i64, n5, n2 - this.pi64);
        Tools.arraycopy(this.f64, this.pf64, workStack.f64, n6, n3 - this.pf64);
    }

    public void peek_expr() {
        int n = this.pi32;
        int n2 = this.pi64;
        int n3 = this.pf64;
        this.pop_expr();
        this.pi32 = n;
        this.pi64 = n2;
        this.pf64 = n3;
    }

    public void ensure_sparsity() {
        int n = this.i32[this.pi32 - 1];
        boolean bl = this.i32[this.pi32 - n - 3] != 0;
        int n2 = this.i32[this.pi32 - n - 1];
        if (!bl) {
            this.i32[this.pi32 - n - 3] = 1;
            int n3 = this.alloci64(n2);
            int n4 = 0;
            int n5 = n2;
            for (int i = n4; i < n5; ++i) {
                this.i64[n3] = i;
            }
        }
    }

    public void clear() {
        this.pi32 = 0;
        this.pi64 = 0;
        this.pf64 = 0;
    }

    public int allocf64(int n) {
        this.ensuref64(n);
        int n2 = this.pf64;
        this.pf64 += n;
        return n2;
    }

    public int alloci64(int n) {
        this.ensurei64(n);
        int n2 = this.pi64;
        this.pi64 += n;
        return n2;
    }

    public int alloci32(int n) {
        if (n > 0) {
            this.ensurei32(n);
            int n2 = this.pi32;
            this.pi32 += n;
            return n2;
        }
        return 0;
    }

    public void pushf64(double d) {
        this.ensuref64(1);
        this.f64[this.pf64] = d;
        ++this.pf64;
    }

    public void pushi64(long l) {
        this.ensurei64(1);
        this.i64[this.pi64] = l;
        ++this.pi64;
    }

    public void pushi32(int n) {
        this.ensurei32(1);
        this.i32[this.pi32] = n;
        ++this.pi32;
    }

    public void ensuref64(int n) {
        if (this.pf64 + n > this.f64.length) {
            int n2 = n < this.f64.length && this.f64.length < 0x3FFFFFFF ? this.f64.length * 2 : this.f64.length + n;
            double[] dArray = new double[n2];
            Tools.arraycopy(this.f64, 0, dArray, 0, this.pf64);
            this.f64 = dArray;
        }
    }

    public void ensurei64(int n) {
        if (this.pi64 + n > this.i64.length) {
            int n2 = this.i64.length + (n < this.i64.length && this.i64.length < 0x3FFFFFFF ? this.i64.length : n);
            long[] lArray = new long[n2];
            Tools.arraycopy(this.i64, 0, lArray, 0, this.pi64);
            this.i64 = lArray;
        }
    }

    public void ensurei32(int n) {
        if (this.pi32 + n > this.i32.length) {
            int n2 = n < this.i32.length && this.i32.length < 0x3FFFFFFF ? this.i32.length * 2 : this.i32.length + n;
            int[] nArray = new int[n2];
            Tools.arraycopy(this.i32, 0, nArray, 0, this.pi32);
            this.i32 = nArray;
        }
    }

    public int popf64(int n) {
        this.pf64 -= n;
        if (this.pf64 < 0) {
            throw new UnexpectedError("Internal: stack underflow");
        }
        return this.pf64;
    }

    public int popi64(int n) {
        this.pi64 -= n;
        if (this.pi64 < 0) {
            throw new UnexpectedError("Internal: stack underflow");
        }
        return this.pi64;
    }

    public int popi32(int n) {
        this.pi32 -= n;
        if (this.pi32 < 0) {
            throw new UnexpectedError("Internal: stack underflow");
        }
        return this.pi32;
    }

    public void popf64(int n, double[] dArray, int n2) {
        this.pf64 -= n;
        if (this.pf64 < 0) {
            throw new UnexpectedError("Internal: stack underflow");
        }
        Tools.arraycopy(this.f64, this.pf64, dArray, n2, n);
    }

    public void popi64(int n, long[] lArray, int n2) {
        this.pi64 -= n;
        if (this.pi64 < 0) {
            throw new UnexpectedError("Internal: stack underflow");
        }
        Tools.arraycopy(this.i64, this.pi64, lArray, n2, n);
    }

    public void popi32(int n, int[] nArray, int n2) {
        this.pi32 -= n;
        if (this.pi32 < 0) {
            throw new UnexpectedError("Internal: stack underflow");
        }
        Tools.arraycopy(this.i32, this.pi32, nArray, n2, n);
    }

    public double popf64() {
        --this.pf64;
        if (this.pf64 < 0) {
            throw new UnexpectedError("Internal: stack underflow");
        }
        return this.f64[this.pf64];
    }

    public long popi64() {
        if (this.pi64 < 0) {
            throw new UnexpectedError("Internal: stack underflow");
        }
        --this.pi64;
        return this.i64[this.pi64];
    }

    public int popi32() {
        --this.pi32;
        if (this.pi32 < 0) {
            throw new UnexpectedError("Internal: stack underflow");
        }
        return this.i32[this.pi32];
    }

    public double peekf64() {
        return this.f64[this.pf64 - 1];
    }

    public long peeki64() {
        return this.i64[this.pi64 - 1];
    }

    public int peeki32() {
        return this.i32[this.pi32 - 1];
    }

    public double peekf64(int n) {
        return this.f64[this.pf64 - n - 1];
    }

    public long peeki64(int n) {
        return this.i64[this.pi64 - n - 1];
    }

    public int peeki32(int n) {
        return this.i32[this.pi32 - n - 1];
    }
}

