/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.Model;
import mosek.fusion.ModelVariable;
import mosek.fusion.Utils.StringBuffer;

public class LinearVariable
extends ModelVariable {
    private int[] shape;
    private long[] sparsity;
    private int[] nativeidxs;
    private String name;

    private LinearVariable(LinearVariable linearVariable, Model model) {
        super(linearVariable, model);
        this.nativeidxs = linearVariable.nativeidxs;
        this.sparsity = linearVariable.sparsity;
        this.shape = linearVariable.shape;
        this.name = linearVariable.name;
    }

    protected LinearVariable(Model model, String string, long l, int[] nArray, long[] lArray, int[] nArray2) {
        super(model, string, nArray, l, lArray, LinearVariable.globalNativeIndexes(nArray2));
        this.name = string;
        this.nativeidxs = nArray2;
        this.sparsity = lArray;
        this.shape = nArray;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("LinearVariable((");
        if (this.shape.length > 0) {
            stringBuffer.a(this.shape[0]);
            int n = 1;
            int n2 = this.shape.length;
            for (int i = n; i < n2; ++i) {
                stringBuffer.a(",").a(this.shape[i]);
            }
        }
        stringBuffer.a(")");
        if (this.sparsity != null) {
            stringBuffer.a(",sparse");
        }
        stringBuffer.a(")");
        return stringBuffer.toString();
    }

    @Override
    protected ModelVariable clone(Model model) {
        return new LinearVariable(this, model);
    }

    private static long[] globalNativeIndexes(int[] nArray) {
        long[] lArray = new long[nArray.length];
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            lArray[i] = nArray[i];
        }
        return lArray;
    }
}

