import numpy
import types
import mosek

def _():
  import types

  class Enum:
    @staticmethod
    def __inst(c,name):
      o = c()
      o.name  = name
      o.value = len(c.__members__)
      c.__members__.append(o)
      setattr(c, name, o)

    @classmethod
    def fromInt(c,value):
      return c.members[value]

    @staticmethod
    def new(name,membernames):
      members = []
      c = type(name, (Enum,),{ '__members__' : members })
      for n in membernames:
        Enum.__inst(c,n)
      return c
    @classmethod
    def members(c):
      return iter(c.__members__)

    def __str__(self):
      return self.__class__.__name__ + "." + self.name
    def __repr__(self):
      return self.__class__.__name__ + "." + self.name
  return Enum

class _monty:
  Enum = _()
  @staticmethod
  def deduceShape(l,dim):
    def _deduceShape(l,dim):
      if dim > 1:
        shplst = [ _deduceShape(i,dim-1) for i in l ]
        if all([shplst[0] == i for i in shplst ]):
          shplst[0].append(len(l))
          return shplst[0]
        else:
          raise TypeError("Irregular array shape")
      else:
        return [len(dim)]
    return tuple(reversed(_deduceShape(l,dim)))
  @staticmethod
  def checkShape(l,dim):
    def _checkShape(l,dim):
      if dim > 1:
        shplst = [ _checkShape(i,dim-1) for i in l ]
        if all([shplst[0] == i for i in shplst ]):
          pass
        else:
          raise TypeError("Irregular array shape")
        return len(l)
      else:
        try:
          return len(l)
        except TypeError:
          raise TypeError("Wrong or irregular array shape")
    _checkShape(l,dim)
    return dim

  @staticmethod
  def initJaggedArray(data, nd):
    dims = []
    d = data
    for i in range(nd):
      dims.append(len(d))
      d = d[0]

    res = numpy.zeros(dims,dtype=object)
    res.__setitem__(tuple([ slice(d) for d in dims ]), data)

    return res


  @staticmethod
  def makeJaggedArray(src,ndims,dtype):
    if src is None:
      return None
    elif len(ndims) == 1:
      if ndims[0] == 1:
        r = numpy.zeros((len(src),),dtype=dtype)
        r[:] = src
      else:
        d = _monty.deduceDims(src,ndims[0])
        r = numpy.zeros(d,dtype=dtype)
        r.__setitem__(tuple([slice(None)]*ndims[0]),src) # basically: r[:,...,:] = src
      return r
    elif ndims[0] == 1:
      r = numpy.zeros((len(src),),dtype=numpy.dtype(object))
      # Note: This is a bit tricky to do reliably with numpy as it
      # tends to think we are dealing with multidimensional arrays and
      # explode
      for i,s in enumerate(src):
        r[i] = _monty.makeJaggedArray(s,ndims[1:],dtype)

      #r[:] = [ _monty.makeJaggedArray(s,ndims[1:],dtype) for s in src ]
      return r
    else:
      d = _monty.deduceDims(src,ndims[0])
      def _(src,nd):
        if nd == 0:
          return _monty.makeJaggedArray(src)
        else:
          return [ _(s,nd-1) for s in src ]

      r = numpy.zeros(d,dtype=numpy.dtype(object))
      r.__setitem__(tuple([slice(None)]*ndims[0]),_(src,ndims[0])) # basically: r[:,...,:] = convert(src)
      return r

  @staticmethod
  def copyArray(src,dst,dim):
    if dim == 1:
      src[:] = dst[:]
    else:
      for i in range(len(src)):
        _monty.copyArray(src[i],dst[i],dim-1)
  @staticmethod
  def arg_match_sloppy_array(v,elmmatch,dim,l=None):
    if dim == 0:
      elmmatch(v)
    elif dim == 1:
      if l is not None:
        if l != len(v): return False
      elif len(v) == 0: return True
      for e in v:
        if not elmmatch(e): return False
      return True
    elif isinstance(v,list) or isinstance(v,numpy.ndarray):
      if l is not None:
        if l != len(v): return False
      elif len(v) == 0: return True
      elif not (isinstance(v[0],list) or isinstance(v[0],numpy.ndarray)): return False

      top_len = len(v[0])
      for e in v:
        if not _monty.arg_match_sloppy_array(e,elmmatch,dim-1,top_len): return False
      return True
    else:
      return False

del _

mosek_fusion_RelationKey=_monty.Enum.new('RelationKey',['EqualsTo','LessThan','GreaterThan','IsFree','InRange'])
mosek_fusion_PSDKey=_monty.Enum.new('PSDKey',['IsSymPSD','IsTrilPSD'])
mosek_fusion_QConeKey=_monty.Enum.new('QConeKey',['InQCone','InRotatedQCone','InPExpCone','InPPowCone','InPPowConeSeq','InDExpCone','InDPowCone','InDPowConeSeq','InPGeoMeanCone','InDGeoMeanCone','Positive','Negative','Unbounded','Zero','InPSDCone','InSVecPSDCone'])
mosek_fusion_ObjectiveSense=_monty.Enum.new('ObjectiveSense',['Undefined','Minimize','Maximize'])
mosek_fusion_SolutionStatus=_monty.Enum.new('SolutionStatus',['Undefined','Unknown','Optimal','Feasible','Certificate','IllposedCert'])
mosek_fusion_AccSolutionStatus=_monty.Enum.new('AccSolutionStatus',['Anything','Optimal','Feasible','Certificate'])
mosek_fusion_ProblemStatus=_monty.Enum.new('ProblemStatus',['Unknown','PrimalAndDualFeasible','PrimalFeasible','DualFeasible','PrimalInfeasible','DualInfeasible','PrimalAndDualInfeasible','IllPosed','PrimalInfeasibleOrUnbounded'])
mosek_fusion_SolverStatus=_monty.Enum.new('SolverStatus',['OK','Error','LostRace'])
mosek_fusion_SolutionType=_monty.Enum.new('SolutionType',['Default','Basic','Interior','Integer'])
mosek_fusion_StatusKey=_monty.Enum.new('StatusKey',['Unknown','Basic','SuperBasic','OnBound','Infinity'])
mosek_fusion_DJCDomainType=_monty.Enum.new('DJCDomainType',['EqualTo','LessThan','GreaterThan','IsFree','InRange','InQCone','InRotatedQCone','InPExpCone','InPPowCone','InDExpCone','InDPowCone','InOneNormCone','InInfNormCone','InPGeoMeanCone','InDGeoMeanCone','InPSDCone'])
#BEFORE CLASS
def __mk_mosek_fusion_ExprDomain():
 class ExprDomain:
  def toDJCTerm(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.ExprDomain.toDJCTerm()

    Description
    -----------

    Convert object into a disjunctive constraint term 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_ExprDomain._match_toDJCTerm_(*args):
      return self._toDJCTerm_(*args)
    elif mosek_fusion_ExprDomain._match_alt_toDJCTerm_(*args):
      return self._toDJCTerm_alt_(*args)
    else:
      raise ValueError('Invalid argument list toDJCTerm('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ExprDomain.toDJCTerm()')
  def __repr__(self): return 'mosek.fusion.ExprDomain'
  @staticmethod
  def _match_toDJCTerm_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toDJCTerm_(*args):
    if len(args) != 0: return False
    return True
  def _toDJCTerm_alt_(self,):
    return self._toDJCTerm_()
  def _toDJCTerm_(self,):
   pass
 return ExprDomain
mosek_fusion_ExprDomain=__mk_mosek_fusion_ExprDomain()
del __mk_mosek_fusion_ExprDomain
#BEFORE CLASS
def __mk_mosek_fusion_Expression():
 class Expression:
  def index(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Expression.index(int32)
      mosek.fusion.Expression.index(array(int32,ndim=1))

    Description
    -----------

    Get a single element in the expression.

    Parameters
    ----------

    i : int32
    indexes : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Expression._match_index_I(*args):
      return self._index_I(*args)
    elif mosek_fusion_Expression._match_alt_index_I(*args):
      return self._index_alt_I(*args)
    elif mosek_fusion_Expression._match_index__3I(*args):
      return self._index__3I(*args)
    elif mosek_fusion_Expression._match_alt_index__3I(*args):
      return self._index_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.index(int32)\n\tmosek.fusion.Expression.index(array(int32,ndim=1))')
  def slice(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Expression.slice(int32,int32)
      mosek.fusion.Expression.slice(array(int32,ndim=1),array(int32,ndim=1))

    Description
    -----------

    Get a slice of the expression.

    Parameters
    ----------

    first : int32
    firsta : array(int32,ndim=1)
    last : int32
    lasta : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Expression._match_slice_II(*args):
      return self._slice_II(*args)
    elif mosek_fusion_Expression._match_alt_slice_II(*args):
      return self._slice_alt_II(*args)
    elif mosek_fusion_Expression._match_slice__3I_3I(*args):
      return self._slice__3I_3I(*args)
    elif mosek_fusion_Expression._match_alt_slice__3I_3I(*args):
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.slice(int32,int32)\n\tmosek.fusion.Expression.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def getND(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Expression.getND()

    Description
    -----------

    Return the number of dimensions in the expression.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Expression._match_getND_(*args):
      return self._getND_(*args)
    elif mosek_fusion_Expression._match_alt_getND_(*args):
      return self._getND_alt_(*args)
    else:
      raise ValueError('Invalid argument list getND('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.getND()')
  def toString(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Expression.toString()

    Description
    -----------

    Return a string representation of the expression object.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Expression._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_Expression._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.toString()')
  def getDim(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Expression.getDim(int32)

    Description
    -----------

    Return the d'th dimension in the expression.

    Parameters
    ----------

    d : int32
    '''
    if False: pass
    elif mosek_fusion_Expression._match_getDim_I(*args):
      return self._getDim_I(*args)
    elif mosek_fusion_Expression._match_alt_getDim_I(*args):
      return self._getDim_alt_I(*args)
    else:
      raise ValueError('Invalid argument list getDim('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.getDim(int32)')
  def pick(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Expression.pick(array(int32,ndim=1))
      mosek.fusion.Expression.pick(array(int32,ndim=2))

    Description
    -----------

    Pick a number of elements from the expression.

    Parameters
    ----------

    indexes : array(int32,ndim=1)
    indexrows : array(int32,ndim=2)
    '''
    if False: pass
    elif mosek_fusion_Expression._match_pick__3I(*args):
      return self._pick__3I(*args)
    elif mosek_fusion_Expression._match_alt_pick__3I(*args):
      return self._pick_alt__3I(*args)
    elif mosek_fusion_Expression._match_pick__3_5I(*args):
      return self._pick__3_5I(*args)
    elif mosek_fusion_Expression._match_alt_pick__3_5I(*args):
      return self._pick_alt__3_5I(*args)
    else:
      raise ValueError('Invalid argument list pick('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.pick(array(int32,ndim=1))\n\tmosek.fusion.Expression.pick(array(int32,ndim=2))')
  def getShape(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Expression.getShape()

    Description
    -----------

    Get the shape of the expression.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Expression._match_getShape_(*args):
      return self._getShape_(*args)
    elif mosek_fusion_Expression._match_alt_getShape_(*args):
      return self._getShape_alt_(*args)
    else:
      raise ValueError('Invalid argument list getShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.getShape()')
  def recursive_eval(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Expression.recursive_eval(mosek.fusion.WorkStack,mosek.fusion.WorkStack,mosek.fusion.WorkStack,bool)

    Description
    -----------

    

    Parameters
    ----------

    cache_eval : bool
    rs : mosek.fusion.WorkStack
    ws : mosek.fusion.WorkStack
    xs : mosek.fusion.WorkStack
    '''
    if False: pass
    elif mosek_fusion_Expression._match_recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args):
      return self._recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args)
    elif mosek_fusion_Expression._match_alt_recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args):
      return self._recursive_1eval_alt_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args)
    else:
      raise ValueError('Invalid argument list recursive_eval('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.recursive_eval(mosek.fusion.WorkStack,mosek.fusion.WorkStack,mosek.fusion.WorkStack,bool)')
  def getSize(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Expression.getSize()

    Description
    -----------

    Return the total number of elements in the expression (the product of the dimensions). 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Expression._match_getSize_(*args):
      return self._getSize_(*args)
    elif mosek_fusion_Expression._match_alt_getSize_(*args):
      return self._getSize_alt_(*args)
    else:
      raise ValueError('Invalid argument list getSize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.getSize()')
  def getModel(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Expression.getModel()

    Description
    -----------

    Get the associated model.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Expression._match_getModel_(*args):
      return self._getModel_(*args)
    elif mosek_fusion_Expression._match_alt_getModel_(*args):
      return self._getModel_alt_(*args)
    else:
      raise ValueError('Invalid argument list getModel('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.getModel()')
  def eval(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Expression.eval(mosek.fusion.WorkStack,mosek.fusion.WorkStack,mosek.fusion.WorkStack)
      mosek.fusion.Expression.eval(mosek.fusion.WorkStack,mosek.fusion.WorkStack,mosek.fusion.WorkStack,bool)

    Description
    -----------

    Evaluate the expression and push the result onto the work stack. 

    Parameters
    ----------

    cache_eval : bool
    rs : mosek.fusion.WorkStack
    ws : mosek.fusion.WorkStack
    xs : mosek.fusion.WorkStack
    '''
    if False: pass
    elif mosek_fusion_Expression._match_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args):
      return self._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args)
    elif mosek_fusion_Expression._match_alt_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args):
      return self._eval_alt_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args)
    elif mosek_fusion_Expression._match_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args):
      return self._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args)
    elif mosek_fusion_Expression._match_alt_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args):
      return self._eval_alt_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args)
    else:
      raise ValueError('Invalid argument list eval('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.eval(mosek.fusion.WorkStack,mosek.fusion.WorkStack,mosek.fusion.WorkStack)\n\tmosek.fusion.Expression.eval(mosek.fusion.WorkStack,mosek.fusion.WorkStack,mosek.fusion.WorkStack,bool)')
  def compress_when_caching(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Expression.compress_when_caching()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Expression._match_compress_1when_1caching_(*args):
      return self._compress_1when_1caching_(*args)
    elif mosek_fusion_Expression._match_alt_compress_1when_1caching_(*args):
      return self._compress_1when_1caching_alt_(*args)
    else:
      raise ValueError('Invalid argument list compress_when_caching('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.compress_when_caching()')
  def __repr__(self): return 'mosek.fusion.Expression'
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   pass
  @staticmethod
  def _match_pick__3_5I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3_5I__(_a_0))
  @staticmethod
  def _match_alt_pick__3_5I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3_5I__(_a_0))
  def _pick_alt__3_5I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,ndmin=_monty.checkShape(_t__a_0,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3_5I(_a_0)
   return _1_res
  def _pick__3_5I(self,_a_0):
   pass
  @staticmethod
  def _match_pick__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_pick__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _pick_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I(self,_a_0):
   pass
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _index_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._index__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _index__3I(self,_a_0):
   pass
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _index_alt_I(self,_t__a_0):
    return self._index_I(numpy.int32(__a_0))
  def _index_I(self,_a_0):
   pass
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1))
  def _slice_alt__3I_3I(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._slice__3I_3I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _slice__3I_3I(self,_a_0,_a_1):
   pass
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1))
  def _slice_alt_II(self,_t__a_0,_t__a_1):
    return self._slice_II(numpy.int32(__a_0),numpy.int32(__a_1))
  def _slice_II(self,_a_0,_a_1):
   pass
  @staticmethod
  def _match_compress_1when_1caching_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_compress_1when_1caching_(*args):
    if len(args) != 0: return False
    return True
  def _compress_1when_1caching_alt_(self,):
    return self._compress_1when_1caching_()
  def _compress_1when_1caching_(self,):
   pass
  @staticmethod
  def _match_recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_Lmosek_4fusion_4WorkStack_2__(_a_0) and __arg_match_Lmosek_4fusion_4WorkStack_2__(_a_1) and __arg_match_Lmosek_4fusion_4WorkStack_2__(_a_2) and __arg_match_Z__(_a_3))
  @staticmethod
  def _match_alt_recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_2) and __arg_alt_match_Z__(_a_3))
  def _recursive_1eval_alt_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3):
    return self._recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(_a_0,_a_1,_a_2,_a_3)
  def _recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(self,_a_0,_a_1,_a_2,_a_3):
   pass
  @staticmethod
  def _match_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_Lmosek_4fusion_4WorkStack_2__(_a_0) and __arg_match_Lmosek_4fusion_4WorkStack_2__(_a_1) and __arg_match_Lmosek_4fusion_4WorkStack_2__(_a_2) and __arg_match_Z__(_a_3))
  @staticmethod
  def _match_alt_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_2) and __arg_alt_match_Z__(_a_3))
  def _eval_alt_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3):
    return self._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(_a_0,_a_1,_a_2,_a_3)
  def _eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(self,_a_0,_a_1,_a_2,_a_3):
   pass
  @staticmethod
  def _match_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_Lmosek_4fusion_4WorkStack_2__(_a_0) and __arg_match_Lmosek_4fusion_4WorkStack_2__(_a_1) and __arg_match_Lmosek_4fusion_4WorkStack_2__(_a_2))
  @staticmethod
  def _match_alt_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_2))
  def _eval_alt_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(_a_0,_a_1,_a_2)
  def _eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(self,_a_0,_a_1,_a_2):
   pass
  @staticmethod
  def _match_getND_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getND_(*args):
    if len(args) != 0: return False
    return True
  def _getND_alt_(self,):
    return self._getND_()
  def _getND_(self,):
   pass
  @staticmethod
  def _match_getDim_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_getDim_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _getDim_alt_I(self,_t__a_0):
    return self._getDim_I(numpy.int32(__a_0))
  def _getDim_I(self,_a_0):
   pass
  @staticmethod
  def _match_getSize_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getSize_(*args):
    if len(args) != 0: return False
    return True
  def _getSize_alt_(self,):
    return self._getSize_()
  def _getSize_(self,):
   pass
  @staticmethod
  def _match_getShape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getShape_(*args):
    if len(args) != 0: return False
    return True
  def _getShape_alt_(self,):
    return self._getShape_()
  def _getShape_(self,):
   pass
  @staticmethod
  def _match_getModel_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getModel_(*args):
    if len(args) != 0: return False
    return True
  def _getModel_alt_(self,):
    return self._getModel_()
  def _getModel_(self,):
   pass
 return Expression
mosek_fusion_Expression=__mk_mosek_fusion_Expression()
del __mk_mosek_fusion_Expression
#BEFORE CLASS
def __mk_mosek_fusion_Variable():
 class Variable(mosek_fusion_Expression):
  def makeInteger(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.makeInteger()

    Description
    -----------

    Apply integrality constraints on the variable. Has no effect on elements of semidefinite matrix variables. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Variable._match_makeInteger_(*args):
      return self._makeInteger_(*args)
    elif mosek_fusion_Variable._match_alt_makeInteger_(*args):
      return self._makeInteger_alt_(*args)
    else:
      raise ValueError('Invalid argument list makeInteger('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.makeInteger()')
  def set_values(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.set_values(array(double,ndim=1),bool)

    Description
    -----------

    

    Parameters
    ----------

    primal : bool
    value : array(double,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Variable._match_set_1values__3DZ(*args):
      return self._set_1values__3DZ(*args)
    elif mosek_fusion_Variable._match_alt_set_1values__3DZ(*args):
      return self._set_1values_alt__3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.set_values(array(double,ndim=1),bool)')
  def dual(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.dual()

    Description
    -----------

    
    Get the dual solution value of the variable.
            

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Variable._match_dual_(*args):
      return self._dual_(*args)
    elif mosek_fusion_Variable._match_alt_dual_(*args):
      return self._dual_alt_(*args)
    else:
      raise ValueError('Invalid argument list dual('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.dual()')
  def asExpr(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.asExpr()

    Description
    -----------

    Create an expression corresponding to the variable object.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Variable._match_asExpr_(*args):
      return self._asExpr_(*args)
    elif mosek_fusion_Variable._match_alt_asExpr_(*args):
      return self._asExpr_alt_(*args)
    else:
      raise ValueError('Invalid argument list asExpr('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.asExpr()')
  def remove(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.remove()

    Description
    -----------

    Remove the variable from the model.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Variable._match_remove_(*args):
      return self._remove_(*args)
    elif mosek_fusion_Variable._match_alt_remove_(*args):
      return self._remove_alt_(*args)
    else:
      raise ValueError('Invalid argument list remove('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.remove()')
  def index(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.index(int32)
      mosek.fusion.Variable.index(array(int32,ndim=1))
      mosek.fusion.Variable.index(int32,int32)
      mosek.fusion.Variable.index(int32,int32,int32)

    Description
    -----------

    Return a single entry in the variable. 

    Parameters
    ----------

    i1 : int32
        Index in the first dimension of the element requested.
    i2 : int32
        Index in the second dimension of the element requested.
    i3 : int32
        Index in the third dimension of the element requested.
    idx : array(int32,ndim=1)
        List of indexes of the elements requested.
    '''
    if False: pass
    elif mosek_fusion_Variable._match_index_I(*args):
      return self._index_I(*args)
    elif mosek_fusion_Variable._match_alt_index_I(*args):
      return self._index_alt_I(*args)
    elif mosek_fusion_Variable._match_index__3I(*args):
      return self._index__3I(*args)
    elif mosek_fusion_Variable._match_alt_index__3I(*args):
      return self._index_alt__3I(*args)
    elif mosek_fusion_Variable._match_index_II(*args):
      return self._index_II(*args)
    elif mosek_fusion_Variable._match_alt_index_II(*args):
      return self._index_alt_II(*args)
    elif mosek_fusion_Variable._match_index_III(*args):
      return self._index_III(*args)
    elif mosek_fusion_Variable._match_alt_index_III(*args):
      return self._index_alt_III(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.index(int32)\n\tmosek.fusion.Variable.index(array(int32,ndim=1))\n\tmosek.fusion.Variable.index(int32,int32)\n\tmosek.fusion.Variable.index(int32,int32,int32)')
  def getShape(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.getShape()

    Description
    -----------

    Get the variable shape. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Variable._match_getShape_(*args):
      return self._getShape_(*args)
    elif mosek_fusion_Variable._match_alt_getShape_(*args):
      return self._getShape_alt_(*args)
    else:
      raise ValueError('Invalid argument list getShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.getShape()')
  def diag(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.diag()
      mosek.fusion.Variable.diag(int32)

    Description
    -----------

    Return a diagonal of a square matrix. 

    Parameters
    ----------

    index : int32
        Index of the diagonal. Index 0 means the main diagonal, negative indices are below it and positive indices are above it. 
    '''
    if False: pass
    elif mosek_fusion_Variable._match_diag_(*args):
      return self._diag_(*args)
    elif mosek_fusion_Variable._match_alt_diag_(*args):
      return self._diag_alt_(*args)
    elif mosek_fusion_Variable._match_diag_I(*args):
      return self._diag_I(*args)
    elif mosek_fusion_Variable._match_alt_diag_I(*args):
      return self._diag_alt_I(*args)
    else:
      raise ValueError('Invalid argument list diag('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.diag()\n\tmosek.fusion.Variable.diag(int32)')
  def antidiag(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.antidiag()
      mosek.fusion.Variable.antidiag(int32)

    Description
    -----------

    Return an anti-diagonal of a square matrix. 

    Parameters
    ----------

    index : int32
        Index of the anti-diagonal. Index 0 means the main anti-diagonal, negative indices are below it and positive indices are above it. 
    '''
    if False: pass
    elif mosek_fusion_Variable._match_antidiag_(*args):
      return self._antidiag_(*args)
    elif mosek_fusion_Variable._match_alt_antidiag_(*args):
      return self._antidiag_alt_(*args)
    elif mosek_fusion_Variable._match_antidiag_I(*args):
      return self._antidiag_I(*args)
    elif mosek_fusion_Variable._match_alt_antidiag_I(*args):
      return self._antidiag_alt_I(*args)
    else:
      raise ValueError('Invalid argument list antidiag('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.antidiag()\n\tmosek.fusion.Variable.antidiag(int32)')
  def slice(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.slice(int32,int32)
      mosek.fusion.Variable.slice(array(int32,ndim=1),array(int32,ndim=1))

    Description
    -----------

    Get a multi-dimensional slice of the variable. 

    Parameters
    ----------

    first : int32
        The index from which the slice begins. 
    firsta : array(int32,ndim=1)
        The indices from which the slice of a multidimensional variable begins.
    last : int32
        The index after the last element of the slice. 
    lasta : array(int32,ndim=1)
        The indices after the last element of slice of a multidimensional variable.
    '''
    if False: pass
    elif mosek_fusion_Variable._match_slice_II(*args):
      return self._slice_II(*args)
    elif mosek_fusion_Variable._match_alt_slice_II(*args):
      return self._slice_alt_II(*args)
    elif mosek_fusion_Variable._match_slice__3I_3I(*args):
      return self._slice__3I_3I(*args)
    elif mosek_fusion_Variable._match_alt_slice__3I_3I(*args):
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.slice(int32,int32)\n\tmosek.fusion.Variable.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def numInst(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.numInst()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Variable._match_numInst_(*args):
      return self._numInst_(*args)
    elif mosek_fusion_Variable._match_alt_numInst_(*args):
      return self._numInst_alt_(*args)
    else:
      raise ValueError('Invalid argument list numInst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.numInst()')
  def getND(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.getND()

    Description
    -----------

    Get the number of dimensions in the variable shape. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Variable._match_getND_(*args):
      return self._getND_(*args)
    elif mosek_fusion_Variable._match_alt_getND_(*args):
      return self._getND_alt_(*args)
    else:
      raise ValueError('Invalid argument list getND('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.getND()')
  def transpose(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.transpose()

    Description
    -----------

    Transpose the variable.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Variable._match_transpose_(*args):
      return self._transpose_(*args)
    elif mosek_fusion_Variable._match_alt_transpose_(*args):
      return self._transpose_alt_(*args)
    else:
      raise ValueError('Invalid argument list transpose('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.transpose()')
  def make_continuous(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.make_continuous()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Variable._match_make_1continuous_(*args):
      return self._make_1continuous_(*args)
    elif mosek_fusion_Variable._match_alt_make_1continuous_(*args):
      return self._make_1continuous_alt_(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.make_continuous()')
  def toString(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.toString()

    Description
    -----------

    Create a string representation of the variable. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Variable._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_Variable._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.toString()')
  def level(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.level()

    Description
    -----------

    
    Get the primal solution value of the variable.
            

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Variable._match_level_(*args):
      return self._level_(*args)
    elif mosek_fusion_Variable._match_alt_level_(*args):
      return self._level_alt_(*args)
    else:
      raise ValueError('Invalid argument list level('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.level()')
  def makeContinuous(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.makeContinuous()

    Description
    -----------

    Drop integrality constraints on the variable, if any. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Variable._match_makeContinuous_(*args):
      return self._makeContinuous_(*args)
    elif mosek_fusion_Variable._match_alt_makeContinuous_(*args):
      return self._makeContinuous_alt_(*args)
    else:
      raise ValueError('Invalid argument list makeContinuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.makeContinuous()')
  def reshape(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.reshape(array(int32,ndim=1))
      mosek.fusion.Variable.reshape(int32)
      mosek.fusion.Variable.reshape(int32,int32)
      mosek.fusion.Variable.reshape(int32,int32,int32)

    Description
    -----------

    Reshape the variable. The new shape must have the same total size as the current.

    Parameters
    ----------

    dim0 : int32
        First dimension of new shape
    dim1 : int32
        Second dimension of new shape
    dim2 : int32
        Third dimension of new shape
    shape : array(int32,ndim=1)
        The new shape.
    '''
    if False: pass
    elif mosek_fusion_Variable._match_reshape__3I(*args):
      return self._reshape__3I(*args)
    elif mosek_fusion_Variable._match_alt_reshape__3I(*args):
      return self._reshape_alt__3I(*args)
    elif mosek_fusion_Variable._match_reshape_I(*args):
      return self._reshape_I(*args)
    elif mosek_fusion_Variable._match_alt_reshape_I(*args):
      return self._reshape_alt_I(*args)
    elif mosek_fusion_Variable._match_reshape_II(*args):
      return self._reshape_II(*args)
    elif mosek_fusion_Variable._match_alt_reshape_II(*args):
      return self._reshape_alt_II(*args)
    elif mosek_fusion_Variable._match_reshape_III(*args):
      return self._reshape_III(*args)
    elif mosek_fusion_Variable._match_alt_reshape_III(*args):
      return self._reshape_alt_III(*args)
    else:
      raise ValueError('Invalid argument list reshape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.reshape(array(int32,ndim=1))\n\tmosek.fusion.Variable.reshape(int32)\n\tmosek.fusion.Variable.reshape(int32,int32)\n\tmosek.fusion.Variable.reshape(int32,int32,int32)')
  def inst(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.inst(int32,array(int64,ndim=1))
      mosek.fusion.Variable.inst(int32,array(int64,ndim=1),int32,array(int64,ndim=1))

    Description
    -----------

    
    Get the linear identifiers for variable elements.
            

    Parameters
    ----------

    nativeidxs : array(int64,ndim=1)
    nioffset : int32
    offset : int32
        Offset into the `nindex` where we wish to receive the result.
    sparsity : array(int64,ndim=1)
    spoffset : int32
    '''
    if False: pass
    elif mosek_fusion_Variable._match_inst_I_3J(*args):
      return self._inst_I_3J(*args)
    elif mosek_fusion_Variable._match_alt_inst_I_3J(*args):
      return self._inst_alt_I_3J(*args)
    elif mosek_fusion_Variable._match_inst_I_3JI_3J(*args):
      return self._inst_I_3JI_3J(*args)
    elif mosek_fusion_Variable._match_alt_inst_I_3JI_3J(*args):
      return self._inst_alt_I_3JI_3J(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.inst(int32,array(int64,ndim=1))\n\tmosek.fusion.Variable.inst(int32,array(int64,ndim=1),int32,array(int64,ndim=1))')
  def tril(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.tril()

    Description
    -----------

    Convert a square variable into a linear representation of the lower triangular part of the variable. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Variable._match_tril_(*args):
      return self._tril_(*args)
    elif mosek_fusion_Variable._match_alt_tril_(*args):
      return self._tril_alt_(*args)
    else:
      raise ValueError('Invalid argument list tril('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.tril()')
  def values(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.values(int32,array(double,ndim=1),bool)

    Description
    -----------

    Return a generic nd-slice of the variable value when treated as an n-dimensional object 

    Parameters
    ----------

    offset : int32
        Offset into the target array. 
    primal : bool
        
    target : array(double,ndim=1)
        Result array. 
    '''
    if False: pass
    elif mosek_fusion_Variable._match_values_I_3DZ(*args):
      return self._values_I_3DZ(*args)
    elif mosek_fusion_Variable._match_alt_values_I_3DZ(*args):
      return self._values_alt_I_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.values(int32,array(double,ndim=1),bool)')
  def make_integer(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.make_integer()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Variable._match_make_1integer_(*args):
      return self._make_1integer_(*args)
    elif mosek_fusion_Variable._match_alt_make_1integer_(*args):
      return self._make_1integer_alt_(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.make_integer()')
  def setLevel(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.setLevel(array(double,ndim=1))

    Description
    -----------

    Input solution values for this variable 

    Parameters
    ----------

    v : array(double,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Variable._match_setLevel__3D(*args):
      return self._setLevel__3D(*args)
    elif mosek_fusion_Variable._match_alt_setLevel__3D(*args):
      return self._setLevel_alt__3D(*args)
    else:
      raise ValueError('Invalid argument list setLevel('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.setLevel(array(double,ndim=1))')
  def getSize(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.getSize()

    Description
    -----------

    Get the total number of elements in the variable. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Variable._match_getSize_(*args):
      return self._getSize_(*args)
    elif mosek_fusion_Variable._match_alt_getSize_(*args):
      return self._getSize_alt_(*args)
    else:
      raise ValueError('Invalid argument list getSize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.getSize()')
  def fromTril(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.fromTril(int32)

    Description
    -----------

    Convert from a linear representation of the lower triangular part of a square variable into a square variable. 

    Parameters
    ----------

    dim : int32
    '''
    if False: pass
    elif mosek_fusion_Variable._match_fromTril_I(*args):
      return self._fromTril_I(*args)
    elif mosek_fusion_Variable._match_alt_fromTril_I(*args):
      return self._fromTril_alt_I(*args)
    else:
      raise ValueError('Invalid argument list fromTril('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.fromTril(int32)')
  def pick(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Variable.pick(array(int32,ndim=1))
      mosek.fusion.Variable.pick(array(int32,ndim=2))
      mosek.fusion.Variable.pick(array(int32,ndim=1),array(int32,ndim=1))
      mosek.fusion.Variable.pick(array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))

    Description
    -----------

    Create a one-dimensional variable by picking a list of indexes from this variable. 

    Parameters
    ----------

    i1 : array(int32,ndim=1)
        Index along the first dimension.
    i2 : array(int32,ndim=1)
        Index along the second dimension.
    i3 : array(int32,ndim=1)
        Index along the third dimension.
    idxs : array(int32,ndim=1)
        Indexes of the elements requested.
    midxs : array(int32,ndim=2)
        A sequence of multi-dimensional indexes of the elements requested.
    '''
    if False: pass
    elif mosek_fusion_Variable._match_pick__3I(*args):
      return self._pick__3I(*args)
    elif mosek_fusion_Variable._match_alt_pick__3I(*args):
      return self._pick_alt__3I(*args)
    elif mosek_fusion_Variable._match_pick__3_5I(*args):
      return self._pick__3_5I(*args)
    elif mosek_fusion_Variable._match_alt_pick__3_5I(*args):
      return self._pick_alt__3_5I(*args)
    elif mosek_fusion_Variable._match_pick__3I_3I(*args):
      return self._pick__3I_3I(*args)
    elif mosek_fusion_Variable._match_alt_pick__3I_3I(*args):
      return self._pick_alt__3I_3I(*args)
    elif mosek_fusion_Variable._match_pick__3I_3I_3I(*args):
      return self._pick__3I_3I_3I(*args)
    elif mosek_fusion_Variable._match_alt_pick__3I_3I_3I(*args):
      return self._pick_alt__3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list pick('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.pick(array(int32,ndim=1))\n\tmosek.fusion.Variable.pick(array(int32,ndim=2))\n\tmosek.fusion.Variable.pick(array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Variable.pick(array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def __repr__(self): return 'mosek.fusion.Variable'
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   pass
  @staticmethod
  def _match_numInst_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_numInst_(*args):
    if len(args) != 0: return False
    return True
  def _numInst_alt_(self,):
    return self._numInst_()
  def _numInst_(self,):
   pass
  @staticmethod
  def _match_inst_I_3JI_3J(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_I__(_a_0) and __arg_match__3J__(_a_1) and __arg_match_I__(_a_2) and __arg_match__3J__(_a_3))
  @staticmethod
  def _match_alt_inst_I_3JI_3J(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match_I__(_a_2) and __arg_alt_match__3J__(_a_3))
  def _inst_alt_I_3JI_3J(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.int32(_t__a_2)
   _a_3=numpy.array(_t__a_3,dtype=numpy.dtype(numpy.int64))
   _1_res = self._inst_I_3JI_3J(_a_0,_a_1,_a_2,_a_3)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_3[:] = _a_3
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _inst_I_3JI_3J(self,_a_0,_a_1,_a_2,_a_3):
   pass
  @staticmethod
  def _match_inst_I_3J(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match__3J__(_a_1))
  @staticmethod
  def _match_alt_inst_I_3J(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match__3J__(_a_1))
  def _inst_alt_I_3J(self,_t__a_0,_t__a_1):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _1_res = self._inst_I_3J(_a_0,_a_1)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _inst_I_3J(self,_a_0,_a_1):
   pass
  @staticmethod
  def _match_remove_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_remove_(*args):
    if len(args) != 0: return False
    return True
  def _remove_alt_(self,):
    return self._remove_()
  def _remove_(self,):
   pass
  @staticmethod
  def _match_getND_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getND_(*args):
    if len(args) != 0: return False
    return True
  def _getND_alt_(self,):
    return self._getND_()
  def _getND_(self,):
   pass
  @staticmethod
  def _match_getShape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getShape_(*args):
    if len(args) != 0: return False
    return True
  def _getShape_alt_(self,):
    return self._getShape_()
  def _getShape_(self,):
   pass
  @staticmethod
  def _match_getSize_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getSize_(*args):
    if len(args) != 0: return False
    return True
  def _getSize_alt_(self,):
    return self._getSize_()
  def _getSize_(self,):
   pass
  @staticmethod
  def _match_setLevel__3D(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3D__(_a_0))
  @staticmethod
  def _match_alt_setLevel__3D(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3D__(_a_0))
  def _setLevel_alt__3D(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.float64))
   _1_res = self._setLevel__3D(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _setLevel__3D(self,_a_0):
   pass
  @staticmethod
  def _match_fromTril_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_fromTril_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _fromTril_alt_I(self,_t__a_0):
    return self._fromTril_I(numpy.int32(__a_0))
  def _fromTril_I(self,_a_0):
   pass
  @staticmethod
  def _match_tril_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_tril_(*args):
    if len(args) != 0: return False
    return True
  def _tril_alt_(self,):
    return self._tril_()
  def _tril_(self,):
   pass
  @staticmethod
  def _match_reshape_III(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1) and __arg_match_I__(_a_2))
  @staticmethod
  def _match_alt_reshape_III(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_I__(_a_2))
  def _reshape_alt_III(self,_t__a_0,_t__a_1,_t__a_2):
    return self._reshape_III(numpy.int32(__a_0),numpy.int32(__a_1),numpy.int32(__a_2))
  def _reshape_III(self,_a_0,_a_1,_a_2):
   pass
  @staticmethod
  def _match_reshape_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_reshape_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1))
  def _reshape_alt_II(self,_t__a_0,_t__a_1):
    return self._reshape_II(numpy.int32(__a_0),numpy.int32(__a_1))
  def _reshape_II(self,_a_0,_a_1):
   pass
  @staticmethod
  def _match_reshape_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_reshape_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _reshape_alt_I(self,_t__a_0):
    return self._reshape_I(numpy.int32(__a_0))
  def _reshape_I(self,_a_0):
   pass
  @staticmethod
  def _match_reshape__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_reshape__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _reshape_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._reshape__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _reshape__3I(self,_a_0):
   pass
  @staticmethod
  def _match_set_1values__3DZ(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3D__(_a_0) and __arg_match_Z__(_a_1))
  @staticmethod
  def _match_alt_set_1values__3DZ(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3D__(_a_0) and __arg_alt_match_Z__(_a_1))
  def _set_1values_alt__3DZ(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.float64))
   _a_1=_t__a_1
   _1_res = self._set_1values__3DZ(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _set_1values__3DZ(self,_a_0,_a_1):
   pass
  @staticmethod
  def _match_dual_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dual_(*args):
    if len(args) != 0: return False
    return True
  def _dual_alt_(self,):
    return self._dual_()
  def _dual_(self,):
   pass
  @staticmethod
  def _match_level_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_level_(*args):
    if len(args) != 0: return False
    return True
  def _level_alt_(self,):
    return self._level_()
  def _level_(self,):
   pass
  @staticmethod
  def _match_values_I_3DZ(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_I__(_a_0) and __arg_match__3D__(_a_1) and __arg_match_Z__(_a_2))
  @staticmethod
  def _match_alt_values_I_3DZ(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match__3D__(_a_1) and __arg_alt_match_Z__(_a_2))
  def _values_alt_I_3DZ(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.float64))
   _a_2=_t__a_2
   _1_res = self._values_I_3DZ(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _values_I_3DZ(self,_a_0,_a_1,_a_2):
   pass
  @staticmethod
  def _match_make_1continuous_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_make_1continuous_(*args):
    if len(args) != 0: return False
    return True
  def _make_1continuous_alt_(self,):
    return self._make_1continuous_()
  def _make_1continuous_(self,):
   pass
  @staticmethod
  def _match_make_1integer_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_make_1integer_(*args):
    if len(args) != 0: return False
    return True
  def _make_1integer_alt_(self,):
    return self._make_1integer_()
  def _make_1integer_(self,):
   pass
  @staticmethod
  def _match_makeContinuous_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_makeContinuous_(*args):
    if len(args) != 0: return False
    return True
  def _makeContinuous_alt_(self,):
    return self._makeContinuous_()
  def _makeContinuous_(self,):
   pass
  @staticmethod
  def _match_makeInteger_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_makeInteger_(*args):
    if len(args) != 0: return False
    return True
  def _makeInteger_alt_(self,):
    return self._makeInteger_()
  def _makeInteger_(self,):
   pass
  @staticmethod
  def _match_transpose_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_transpose_(*args):
    if len(args) != 0: return False
    return True
  def _transpose_alt_(self,):
    return self._transpose_()
  def _transpose_(self,):
   pass
  @staticmethod
  def _match_pick__3I_3I_3I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3I__(_a_2))
  @staticmethod
  def _match_alt_pick__3I_3I_3I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3I__(_a_2))
  def _pick_alt__3I_3I_3I(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I_3I_3I(_a_0,_a_1,_a_2)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I_3I_3I(self,_a_0,_a_1,_a_2):
   pass
  @staticmethod
  def _match_pick__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_pick__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1))
  def _pick_alt__3I_3I(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I_3I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I_3I(self,_a_0,_a_1):
   pass
  @staticmethod
  def _match_pick__3_5I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3_5I__(_a_0))
  @staticmethod
  def _match_alt_pick__3_5I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3_5I__(_a_0))
  def _pick_alt__3_5I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,ndmin=_monty.checkShape(_t__a_0,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3_5I(_a_0)
   return _1_res
  def _pick__3_5I(self,_a_0):
   pass
  @staticmethod
  def _match_pick__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_pick__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _pick_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I(self,_a_0):
   pass
  @staticmethod
  def _match_antidiag_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_antidiag_(*args):
    if len(args) != 0: return False
    return True
  def _antidiag_alt_(self,):
    return self._antidiag_()
  def _antidiag_(self,):
   pass
  @staticmethod
  def _match_antidiag_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_antidiag_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _antidiag_alt_I(self,_t__a_0):
    return self._antidiag_I(numpy.int32(__a_0))
  def _antidiag_I(self,_a_0):
   pass
  @staticmethod
  def _match_diag_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_diag_(*args):
    if len(args) != 0: return False
    return True
  def _diag_alt_(self,):
    return self._diag_()
  def _diag_(self,):
   pass
  @staticmethod
  def _match_diag_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_diag_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _diag_alt_I(self,_t__a_0):
    return self._diag_I(numpy.int32(__a_0))
  def _diag_I(self,_a_0):
   pass
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _index_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._index__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _index__3I(self,_a_0):
   pass
  @staticmethod
  def _match_index_III(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1) and __arg_match_I__(_a_2))
  @staticmethod
  def _match_alt_index_III(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_I__(_a_2))
  def _index_alt_III(self,_t__a_0,_t__a_1,_t__a_2):
    return self._index_III(numpy.int32(__a_0),numpy.int32(__a_1),numpy.int32(__a_2))
  def _index_III(self,_a_0,_a_1,_a_2):
   pass
  @staticmethod
  def _match_index_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_index_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1))
  def _index_alt_II(self,_t__a_0,_t__a_1):
    return self._index_II(numpy.int32(__a_0),numpy.int32(__a_1))
  def _index_II(self,_a_0,_a_1):
   pass
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _index_alt_I(self,_t__a_0):
    return self._index_I(numpy.int32(__a_0))
  def _index_I(self,_a_0):
   pass
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1))
  def _slice_alt__3I_3I(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._slice__3I_3I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _slice__3I_3I(self,_a_0,_a_1):
   pass
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1))
  def _slice_alt_II(self,_t__a_0,_t__a_1):
    return self._slice_II(numpy.int32(__a_0),numpy.int32(__a_1))
  def _slice_II(self,_a_0,_a_1):
   pass
  @staticmethod
  def _match_asExpr_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_asExpr_(*args):
    if len(args) != 0: return False
    return True
  def _asExpr_alt_(self,):
    return self._asExpr_()
  def _asExpr_(self,):
   pass
 return Variable
mosek_fusion_Variable=__mk_mosek_fusion_Variable()
del __mk_mosek_fusion_Variable
#BEFORE CLASS
def __mk_mosek_fusion_Parameter():
 class Parameter(mosek_fusion_Expression):
  def reshape(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.reshape(array(int32,ndim=1))

    Description
    -----------

    Reshape the parameter. The new shape must have the same size as the old.

    Parameters
    ----------

    dims : array(int32,ndim=1)
        The new shape
    '''
    if False: pass
    elif mosek_fusion_Parameter._match_reshape__3I(*args):
      return self._reshape__3I(*args)
    elif mosek_fusion_Parameter._match_alt_reshape__3I(*args):
      return self._reshape_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list reshape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.reshape(array(int32,ndim=1))')
  def clone(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.clone(mosek.fusion.Model)

    Description
    -----------

    

    Parameters
    ----------

    m : mosek.fusion.Model
    '''
    if False: pass
    elif mosek_fusion_Parameter._match_clone_Lmosek_4fusion_4Model_2(*args):
      return self._clone_Lmosek_4fusion_4Model_2(*args)
    elif mosek_fusion_Parameter._match_alt_clone_Lmosek_4fusion_4Model_2(*args):
      return self._clone_alt_Lmosek_4fusion_4Model_2(*args)
    else:
      raise ValueError('Invalid argument list clone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.clone(mosek.fusion.Model)')
  def pick(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.pick(array(int32,ndim=1))
      mosek.fusion.Parameter.pick(array(int32,ndim=2))

    Description
    -----------

    

    Parameters
    ----------

    idxs : array(int32,ndim=1)
    midxs : array(int32,ndim=2)
    '''
    if False: pass
    elif mosek_fusion_Parameter._match_pick__3I(*args):
      return self._pick__3I(*args)
    elif mosek_fusion_Parameter._match_alt_pick__3I(*args):
      return self._pick_alt__3I(*args)
    elif mosek_fusion_Parameter._match_pick__3_5I(*args):
      return self._pick__3_5I(*args)
    elif mosek_fusion_Parameter._match_alt_pick__3_5I(*args):
      return self._pick_alt__3_5I(*args)
    else:
      raise ValueError('Invalid argument list pick('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.pick(array(int32,ndim=1))\n\tmosek.fusion.Parameter.pick(array(int32,ndim=2))')
  def slice(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.slice(int32,int32)
      mosek.fusion.Parameter.slice(array(int32,ndim=1),array(int32,ndim=1))

    Description
    -----------

    Take a slice of the parameter.

    Parameters
    ----------

    astart : array(int32,ndim=1)
        The first index in the parameter.
    astop : array(int32,ndim=1)
        The last-plus-one index in the parameter.
    start : int32
        The first index in a one-dimensional parameter.
    stop : int32
        The last-plus-one index in a one-dimensional parameter.
    '''
    if False: pass
    elif mosek_fusion_Parameter._match_slice_II(*args):
      return self._slice_II(*args)
    elif mosek_fusion_Parameter._match_alt_slice_II(*args):
      return self._slice_alt_II(*args)
    elif mosek_fusion_Parameter._match_slice__3I_3I(*args):
      return self._slice__3I_3I(*args)
    elif mosek_fusion_Parameter._match_alt_slice__3I_3I(*args):
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.slice(int32,int32)\n\tmosek.fusion.Parameter.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def getNumNonzero(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.getNumNonzero()

    Description
    -----------

    Get number of non-zero elements in the parameter. This means the number of elements in the sparsity pattern - *not* the number of numeric non-zeros.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Parameter._match_getNumNonzero_(*args):
      return self._getNumNonzero_(*args)
    elif mosek_fusion_Parameter._match_alt_getNumNonzero_(*args):
      return self._getNumNonzero_alt_(*args)
    else:
      raise ValueError('Invalid argument list getNumNonzero('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getNumNonzero()')
  def isSparse(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.isSparse()

    Description
    -----------

    Return whether the parameter has a sparsity pattern.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Parameter._match_isSparse_(*args):
      return self._isSparse_(*args)
    elif mosek_fusion_Parameter._match_alt_isSparse_(*args):
      return self._isSparse_alt_(*args)
    else:
      raise ValueError('Invalid argument list isSparse('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.isSparse()')
  def getValue(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.getValue()

    Description
    -----------

    Get the current parameter values. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Parameter._match_getValue_(*args):
      return self._getValue_(*args)
    elif mosek_fusion_Parameter._match_alt_getValue_(*args):
      return self._getValue_alt_(*args)
    else:
      raise ValueError('Invalid argument list getValue('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getValue()')
  def setValue(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.setValue(double)
      mosek.fusion.Parameter.setValue(array(double,ndim=1))
      mosek.fusion.Parameter.setValue(array(double,ndim=2))

    Description
    -----------

    Set the parameter values. 

    Parameters
    ----------

    value : double
        Set all parameter elements to this value.
    values : array(double,ndim=1)
        Set parameter elements to these values. The length of the array must match the size of the parameter. This form is valid no matter the shape of the parameter.
    values2 : array(double,ndim=2)
        Set parameter elements to these values. The shape must exactly match the shape of the two-dimensional parameter.
    '''
    if False: pass
    elif mosek_fusion_Parameter._match_setValue_D(*args):
      return self._setValue_D(*args)
    elif mosek_fusion_Parameter._match_alt_setValue_D(*args):
      return self._setValue_alt_D(*args)
    elif mosek_fusion_Parameter._match_setValue__3D(*args):
      return self._setValue__3D(*args)
    elif mosek_fusion_Parameter._match_alt_setValue__3D(*args):
      return self._setValue_alt__3D(*args)
    elif mosek_fusion_Parameter._match_setValue__3_5D(*args):
      return self._setValue__3_5D(*args)
    elif mosek_fusion_Parameter._match_alt_setValue__3_5D(*args):
      return self._setValue_alt__3_5D(*args)
    else:
      raise ValueError('Invalid argument list setValue('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.setValue(double)\n\tmosek.fusion.Parameter.setValue(array(double,ndim=1))\n\tmosek.fusion.Parameter.setValue(array(double,ndim=2))')
  def getND(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.getND()

    Description
    -----------

    Get the number of dimensions in the parameter shape

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Parameter._match_getND_(*args):
      return self._getND_(*args)
    elif mosek_fusion_Parameter._match_alt_getND_(*args):
      return self._getND_alt_(*args)
    else:
      raise ValueError('Invalid argument list getND('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getND()')
  def getAllIndexes(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.getAllIndexes(array(int32,ndim=1),int32)

    Description
    -----------

    

    Parameters
    ----------

    dst : array(int32,ndim=1)
    ofs : int32
    '''
    if False: pass
    elif mosek_fusion_Parameter._match_getAllIndexes__3II(*args):
      return self._getAllIndexes__3II(*args)
    elif mosek_fusion_Parameter._match_alt_getAllIndexes__3II(*args):
      return self._getAllIndexes_alt__3II(*args)
    else:
      raise ValueError('Invalid argument list getAllIndexes('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getAllIndexes(array(int32,ndim=1),int32)')
  def getDim(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.getDim(int32)

    Description
    -----------

    Get the size of one dimension of the shape

    Parameters
    ----------

    i : int32
        The index of the dimension
    '''
    if False: pass
    elif mosek_fusion_Parameter._match_getDim_I(*args):
      return self._getDim_I(*args)
    elif mosek_fusion_Parameter._match_alt_getDim_I(*args):
      return self._getDim_alt_I(*args)
    else:
      raise ValueError('Invalid argument list getDim('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getDim(int32)')
  def getIndex(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.getIndex(int32)

    Description
    -----------

    

    Parameters
    ----------

    i : int32
    '''
    if False: pass
    elif mosek_fusion_Parameter._match_getIndex_I(*args):
      return self._getIndex_I(*args)
    elif mosek_fusion_Parameter._match_alt_getIndex_I(*args):
      return self._getIndex_alt_I(*args)
    else:
      raise ValueError('Invalid argument list getIndex('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getIndex(int32)')
  def asExpr(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.asExpr()

    Description
    -----------

    Convert parameter to an expression

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Parameter._match_asExpr_(*args):
      return self._asExpr_(*args)
    elif mosek_fusion_Parameter._match_alt_asExpr_(*args):
      return self._asExpr_alt_(*args)
    else:
      raise ValueError('Invalid argument list asExpr('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.asExpr()')
  def getSize(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.getSize()

    Description
    -----------

    Get the total number of elements in the parameter

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Parameter._match_getSize_(*args):
      return self._getSize_(*args)
    elif mosek_fusion_Parameter._match_alt_getSize_(*args):
      return self._getSize_alt_(*args)
    else:
      raise ValueError('Invalid argument list getSize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getSize()')
  def getSp(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.getSp(array(int64,ndim=1),int32)

    Description
    -----------

    Return The sparsity pattern.

    Parameters
    ----------

    dest : array(int64,ndim=1)
    offset : int32
    '''
    if False: pass
    elif mosek_fusion_Parameter._match_getSp__3JI(*args):
      return self._getSp__3JI(*args)
    elif mosek_fusion_Parameter._match_alt_getSp__3JI(*args):
      return self._getSp_alt__3JI(*args)
    else:
      raise ValueError('Invalid argument list getSp('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getSp(array(int64,ndim=1),int32)')
  def transpose(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.transpose()

    Description
    -----------

    Transpose a one- or two-dimensional parameter.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Parameter._match_transpose_(*args):
      return self._transpose_(*args)
    elif mosek_fusion_Parameter._match_alt_transpose_(*args):
      return self._transpose_alt_(*args)
    else:
      raise ValueError('Invalid argument list transpose('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.transpose()')
  def getShape(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Parameter.getShape()

    Description
    -----------

    Get the parameter shape

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Parameter._match_getShape_(*args):
      return self._getShape_(*args)
    elif mosek_fusion_Parameter._match_alt_getShape_(*args):
      return self._getShape_alt_(*args)
    else:
      raise ValueError('Invalid argument list getShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getShape()')
  def __repr__(self): return 'mosek.fusion.Parameter'
  @staticmethod
  def _match_clone_Lmosek_4fusion_4Model_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(_a_0))
  @staticmethod
  def _match_alt_clone_Lmosek_4fusion_4Model_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(_a_0))
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__a_0):
    return self._clone_Lmosek_4fusion_4Model_2(_a_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_a_0):
   pass
  @staticmethod
  def _match_getSize_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getSize_(*args):
    if len(args) != 0: return False
    return True
  def _getSize_alt_(self,):
    return self._getSize_()
  def _getSize_(self,):
   pass
  @staticmethod
  def _match_getAllIndexes__3II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_getAllIndexes__3II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match_I__(_a_1))
  def _getAllIndexes_alt__3II(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.int32(_t__a_1)
   _1_res = self._getAllIndexes__3II(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _getAllIndexes__3II(self,_a_0,_a_1):
   pass
  @staticmethod
  def _match_getIndex_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_getIndex_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _getIndex_alt_I(self,_t__a_0):
    return self._getIndex_I(numpy.int32(__a_0))
  def _getIndex_I(self,_a_0):
   pass
  @staticmethod
  def _match_getSp__3JI(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3J__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_getSp__3JI(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match_I__(_a_1))
  def _getSp_alt__3JI(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.int32(_t__a_1)
   _1_res = self._getSp__3JI(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _getSp__3JI(self,_a_0,_a_1):
   pass
  @staticmethod
  def _match_getShape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getShape_(*args):
    if len(args) != 0: return False
    return True
  def _getShape_alt_(self,):
    return self._getShape_()
  def _getShape_(self,):
   pass
  @staticmethod
  def _match_getND_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getND_(*args):
    if len(args) != 0: return False
    return True
  def _getND_alt_(self,):
    return self._getND_()
  def _getND_(self,):
   pass
  @staticmethod
  def _match_getDim_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_getDim_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _getDim_alt_I(self,_t__a_0):
    return self._getDim_I(numpy.int32(__a_0))
  def _getDim_I(self,_a_0):
   pass
  @staticmethod
  def _match_transpose_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_transpose_(*args):
    if len(args) != 0: return False
    return True
  def _transpose_alt_(self,):
    return self._transpose_()
  def _transpose_(self,):
   pass
  @staticmethod
  def _match_pick__3_5I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3_5I__(_a_0))
  @staticmethod
  def _match_alt_pick__3_5I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3_5I__(_a_0))
  def _pick_alt__3_5I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,ndmin=_monty.checkShape(_t__a_0,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3_5I(_a_0)
   return _1_res
  def _pick__3_5I(self,_a_0):
   pass
  @staticmethod
  def _match_pick__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_pick__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _pick_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I(self,_a_0):
   pass
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1))
  def _slice_alt__3I_3I(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._slice__3I_3I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _slice__3I_3I(self,_a_0,_a_1):
   pass
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1))
  def _slice_alt_II(self,_t__a_0,_t__a_1):
    return self._slice_II(numpy.int32(__a_0),numpy.int32(__a_1))
  def _slice_II(self,_a_0,_a_1):
   pass
  @staticmethod
  def _match_isSparse_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_isSparse_(*args):
    if len(args) != 0: return False
    return True
  def _isSparse_alt_(self,):
    return self._isSparse_()
  def _isSparse_(self,):
   pass
  @staticmethod
  def _match_reshape__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_reshape__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _reshape_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._reshape__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _reshape__3I(self,_a_0):
   pass
  @staticmethod
  def _match_getNumNonzero_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getNumNonzero_(*args):
    if len(args) != 0: return False
    return True
  def _getNumNonzero_alt_(self,):
    return self._getNumNonzero_()
  def _getNumNonzero_(self,):
   pass
  @staticmethod
  def _match_asExpr_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_asExpr_(*args):
    if len(args) != 0: return False
    return True
  def _asExpr_alt_(self,):
    return self._asExpr_()
  def _asExpr_(self,):
   pass
  @staticmethod
  def _match_getValue_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getValue_(*args):
    if len(args) != 0: return False
    return True
  def _getValue_alt_(self,):
    return self._getValue_()
  def _getValue_(self,):
   pass
  @staticmethod
  def _match_setValue__3_5D(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3_5D__(_a_0))
  @staticmethod
  def _match_alt_setValue__3_5D(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3_5D__(_a_0))
  def _setValue_alt__3_5D(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,ndmin=_monty.checkShape(_t__a_0,2),dtype=numpy.dtype(numpy.float64))
   _1_res = self._setValue__3_5D(_a_0)
   return _1_res
  def _setValue__3_5D(self,_a_0):
   pass
  @staticmethod
  def _match_setValue__3D(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3D__(_a_0))
  @staticmethod
  def _match_alt_setValue__3D(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3D__(_a_0))
  def _setValue_alt__3D(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.float64))
   _1_res = self._setValue__3D(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _setValue__3D(self,_a_0):
   pass
  @staticmethod
  def _match_setValue_D(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_D__(_a_0))
  @staticmethod
  def _match_alt_setValue_D(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_D__(_a_0))
  def _setValue_alt_D(self,_t__a_0):
    return self._setValue_D(numpy.float64(__a_0))
  def _setValue_D(self,_a_0):
   pass
 return Parameter
mosek_fusion_Parameter=__mk_mosek_fusion_Parameter()
del __mk_mosek_fusion_Parameter
#BEFORE CLASS
def __mk_mosek_fusion_FusionException():
 class FusionException(Exception):
  __slots__ = ['_FusionException__msg']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.FusionException.ctor(string)')
  def toString(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.FusionException.toString()

    Description
    -----------

    Return the exception message. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_FusionException._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_FusionException._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.FusionException.toString()')
  def __repr__(self): return 'mosek.fusion.FusionException'
  @staticmethod
  def _ctor_S(msg_):
    o = FusionException.__new__(FusionException)
    o._ctor_init_S(msg_)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg_, = args
    return (__arg_match_S__(msg_))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg_, = args
    return (__arg_alt_match_S__(msg_))
  def _ctor_alt_init_S(self,msg_):
    self._ctor_init_S(msg_)
  def _ctor_init_S(self,msg_):
   Exception.__init__(self,msg_)
   self.__msg = msg_
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   return (self.__msg)
 return FusionException
mosek_fusion_FusionException=__mk_mosek_fusion_FusionException()
del __mk_mosek_fusion_FusionException
#BEFORE CLASS
def __mk_mosek_fusion_SolutionError():
 class SolutionError(mosek_fusion_FusionException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_(*args):
      self._ctor_init_(*args)
    elif self.__match_alt_ctor_(*args):
      self._ctor_alt_init_(*args)
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.SolutionError.ctor()\n\tmosek.fusion.SolutionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.SolutionError'
  @staticmethod
  def _ctor_():
    o = SolutionError.__new__(SolutionError)
    o._ctor_init_()
    return o
  @staticmethod
  def __match_ctor_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def __match_alt_ctor_(*args):
    if len(args) != 0: return False
    return True
  def _ctor_alt_init_(self,):
    self._ctor_init_()
  def _ctor_init_(self,):
   mosek_fusion_FusionException._ctor_init_S(self,"Solution is invalid or undefined")
  @staticmethod
  def _ctor_S(msg):
    o = SolutionError.__new__(SolutionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionException._ctor_init_S(self,msg)
 return SolutionError
mosek_fusion_SolutionError=__mk_mosek_fusion_SolutionError()
del __mk_mosek_fusion_SolutionError
#BEFORE CLASS
def __mk_mosek_fusion_UnimplementedError():
 class UnimplementedError(Exception):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.UnimplementedError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.UnimplementedError'
  @staticmethod
  def _ctor_S(msg):
    o = UnimplementedError.__new__(UnimplementedError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   Exception.__init__(self,msg)
 return UnimplementedError
mosek_fusion_UnimplementedError=__mk_mosek_fusion_UnimplementedError()
del __mk_mosek_fusion_UnimplementedError
#BEFORE CLASS
def __mk_mosek_fusion_FatalError():
 class FatalError(Exception):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.FatalError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.FatalError'
  @staticmethod
  def _ctor_S(msg):
    o = FatalError.__new__(FatalError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   Exception.__init__(self,msg)
 return FatalError
mosek_fusion_FatalError=__mk_mosek_fusion_FatalError()
del __mk_mosek_fusion_FatalError
#BEFORE CLASS
def __mk_mosek_fusion_UnexpectedError():
 class UnexpectedError(Exception):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_Lmosek_4fusion_4FusionException_2(*args):
      self._ctor_init_Lmosek_4fusion_4FusionException_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4FusionException_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4FusionException_2(*args)
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.UnexpectedError.ctor(mosek.fusion.FusionException)\n\tmosek.fusion.UnexpectedError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.UnexpectedError'
  @staticmethod
  def _ctor_Lmosek_4fusion_4FusionException_2(e):
    o = UnexpectedError.__new__(UnexpectedError)
    o._ctor_init_Lmosek_4fusion_4FusionException_2(e)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4FusionException_2(*args):
    if len(args) != 1: return False
    e, = args
    return (__arg_match_Lmosek_4fusion_4FusionException_2__(e))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4FusionException_2(*args):
    if len(args) != 1: return False
    e, = args
    return (__arg_alt_match_Lmosek_4fusion_4FusionException_2__(e))
  def _ctor_alt_init_Lmosek_4fusion_4FusionException_2(self,e):
    self._ctor_init_Lmosek_4fusion_4FusionException_2(e)
  def _ctor_init_Lmosek_4fusion_4FusionException_2(self,e):
   Exception.__init__(self,e._toString_())
  @staticmethod
  def _ctor_S(msg):
    o = UnexpectedError.__new__(UnexpectedError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   Exception.__init__(self,msg)
 return UnexpectedError
mosek_fusion_UnexpectedError=__mk_mosek_fusion_UnexpectedError()
del __mk_mosek_fusion_UnexpectedError
#BEFORE CLASS
def __mk_mosek_fusion_FusionRuntimeException():
 class FusionRuntimeException(Exception):
  __slots__ = ['_FusionRuntimeException__msg']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.FusionRuntimeException.ctor(string)')
  def toString(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.FusionRuntimeException.toString()

    Description
    -----------

    Return the exception message. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_FusionRuntimeException._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_FusionRuntimeException._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.FusionRuntimeException.toString()')
  def __repr__(self): return 'mosek.fusion.FusionRuntimeException'
  @staticmethod
  def _ctor_S(msg_):
    o = FusionRuntimeException.__new__(FusionRuntimeException)
    o._ctor_init_S(msg_)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg_, = args
    return (__arg_match_S__(msg_))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg_, = args
    return (__arg_alt_match_S__(msg_))
  def _ctor_alt_init_S(self,msg_):
    self._ctor_init_S(msg_)
  def _ctor_init_S(self,msg_):
   Exception.__init__(self,msg_)
   self.__msg = msg_
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   return (self.__msg)
 return FusionRuntimeException
mosek_fusion_FusionRuntimeException=__mk_mosek_fusion_FusionRuntimeException()
del __mk_mosek_fusion_FusionRuntimeException
#BEFORE CLASS
def __mk_mosek_fusion_SparseFormatError():
 class SparseFormatError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.SparseFormatError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.SparseFormatError'
  @staticmethod
  def _ctor_S(msg):
    o = SparseFormatError.__new__(SparseFormatError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return SparseFormatError
mosek_fusion_SparseFormatError=__mk_mosek_fusion_SparseFormatError()
del __mk_mosek_fusion_SparseFormatError
#BEFORE CLASS
def __mk_mosek_fusion_SliceError():
 class SliceError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_(*args):
      self._ctor_init_(*args)
    elif self.__match_alt_ctor_(*args):
      self._ctor_alt_init_(*args)
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.SliceError.ctor()\n\tmosek.fusion.SliceError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.SliceError'
  @staticmethod
  def _ctor_():
    o = SliceError.__new__(SliceError)
    o._ctor_init_()
    return o
  @staticmethod
  def __match_ctor_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def __match_alt_ctor_(*args):
    if len(args) != 0: return False
    return True
  def _ctor_alt_init_(self,):
    self._ctor_init_()
  def _ctor_init_(self,):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,"Invalid slice range")
  @staticmethod
  def _ctor_S(msg):
    o = SliceError.__new__(SliceError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return SliceError
mosek_fusion_SliceError=__mk_mosek_fusion_SliceError()
del __mk_mosek_fusion_SliceError
#BEFORE CLASS
def __mk_mosek_fusion_UpdateError():
 class UpdateError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_(*args):
      self._ctor_init_(*args)
    elif self.__match_alt_ctor_(*args):
      self._ctor_alt_init_(*args)
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.UpdateError.ctor()\n\tmosek.fusion.UpdateError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.UpdateError'
  @staticmethod
  def _ctor_():
    o = UpdateError.__new__(UpdateError)
    o._ctor_init_()
    return o
  @staticmethod
  def __match_ctor_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def __match_alt_ctor_(*args):
    if len(args) != 0: return False
    return True
  def _ctor_alt_init_(self,):
    self._ctor_init_()
  def _ctor_init_(self,):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,"Cannot update parameterized item")
  @staticmethod
  def _ctor_S(msg):
    o = UpdateError.__new__(UpdateError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return UpdateError
mosek_fusion_UpdateError=__mk_mosek_fusion_UpdateError()
del __mk_mosek_fusion_UpdateError
#BEFORE CLASS
def __mk_mosek_fusion_SetDefinitionError():
 class SetDefinitionError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.SetDefinitionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.SetDefinitionError'
  @staticmethod
  def _ctor_S(msg):
    o = SetDefinitionError.__new__(SetDefinitionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return SetDefinitionError
mosek_fusion_SetDefinitionError=__mk_mosek_fusion_SetDefinitionError()
del __mk_mosek_fusion_SetDefinitionError
#BEFORE CLASS
def __mk_mosek_fusion_OptimizeError():
 class OptimizeError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.OptimizeError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.OptimizeError'
  @staticmethod
  def _ctor_S(msg):
    o = OptimizeError.__new__(OptimizeError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return OptimizeError
mosek_fusion_OptimizeError=__mk_mosek_fusion_OptimizeError()
del __mk_mosek_fusion_OptimizeError
#BEFORE CLASS
def __mk_mosek_fusion_NameError():
 class NameError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.NameError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.NameError'
  @staticmethod
  def _ctor_S(msg):
    o = NameError.__new__(NameError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return NameError
mosek_fusion_NameError=__mk_mosek_fusion_NameError()
del __mk_mosek_fusion_NameError
#BEFORE CLASS
def __mk_mosek_fusion_DeletionError():
 class DeletionError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.DeletionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.DeletionError'
  @staticmethod
  def _ctor_S(msg):
    o = DeletionError.__new__(DeletionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return DeletionError
mosek_fusion_DeletionError=__mk_mosek_fusion_DeletionError()
del __mk_mosek_fusion_DeletionError
#BEFORE CLASS
def __mk_mosek_fusion_ModelError():
 class ModelError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.ModelError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.ModelError'
  @staticmethod
  def _ctor_S(msg):
    o = ModelError.__new__(ModelError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return ModelError
mosek_fusion_ModelError=__mk_mosek_fusion_ModelError()
del __mk_mosek_fusion_ModelError
#BEFORE CLASS
def __mk_mosek_fusion_MatrixError():
 class MatrixError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.MatrixError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.MatrixError'
  @staticmethod
  def _ctor_S(msg):
    o = MatrixError.__new__(MatrixError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return MatrixError
mosek_fusion_MatrixError=__mk_mosek_fusion_MatrixError()
del __mk_mosek_fusion_MatrixError
#BEFORE CLASS
def __mk_mosek_fusion_DimensionError():
 class DimensionError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.DimensionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.DimensionError'
  @staticmethod
  def _ctor_S(msg):
    o = DimensionError.__new__(DimensionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return DimensionError
mosek_fusion_DimensionError=__mk_mosek_fusion_DimensionError()
del __mk_mosek_fusion_DimensionError
#BEFORE CLASS
def __mk_mosek_fusion_LengthError():
 class LengthError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.LengthError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.LengthError'
  @staticmethod
  def _ctor_S(msg):
    o = LengthError.__new__(LengthError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return LengthError
mosek_fusion_LengthError=__mk_mosek_fusion_LengthError()
del __mk_mosek_fusion_LengthError
#BEFORE CLASS
def __mk_mosek_fusion_RangeError():
 class RangeError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.RangeError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.RangeError'
  @staticmethod
  def _ctor_S(msg):
    o = RangeError.__new__(RangeError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return RangeError
mosek_fusion_RangeError=__mk_mosek_fusion_RangeError()
del __mk_mosek_fusion_RangeError
#BEFORE CLASS
def __mk_mosek_fusion_IndexError():
 class IndexError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.IndexError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.IndexError'
  @staticmethod
  def _ctor_S(msg):
    o = IndexError.__new__(IndexError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return IndexError
mosek_fusion_IndexError=__mk_mosek_fusion_IndexError()
del __mk_mosek_fusion_IndexError
#BEFORE CLASS
def __mk_mosek_fusion_DomainError():
 class DomainError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.DomainError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.DomainError'
  @staticmethod
  def _ctor_S(msg):
    o = DomainError.__new__(DomainError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return DomainError
mosek_fusion_DomainError=__mk_mosek_fusion_DomainError()
del __mk_mosek_fusion_DomainError
#BEFORE CLASS
def __mk_mosek_fusion_ValueConversionError():
 class ValueConversionError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.ValueConversionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.ValueConversionError'
  @staticmethod
  def _ctor_S(msg):
    o = ValueConversionError.__new__(ValueConversionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return ValueConversionError
mosek_fusion_ValueConversionError=__mk_mosek_fusion_ValueConversionError()
del __mk_mosek_fusion_ValueConversionError
#BEFORE CLASS
def __mk_mosek_fusion_ParameterError():
 class ParameterError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.ParameterError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.ParameterError'
  @staticmethod
  def _ctor_S(msg):
    o = ParameterError.__new__(ParameterError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return ParameterError
mosek_fusion_ParameterError=__mk_mosek_fusion_ParameterError()
del __mk_mosek_fusion_ParameterError
#BEFORE CLASS
def __mk_mosek_fusion_ExpressionError():
 class ExpressionError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.ExpressionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.ExpressionError'
  @staticmethod
  def _ctor_S(msg):
    o = ExpressionError.__new__(ExpressionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return ExpressionError
mosek_fusion_ExpressionError=__mk_mosek_fusion_ExpressionError()
del __mk_mosek_fusion_ExpressionError
#BEFORE CLASS
def __mk_mosek_fusion_IOError():
 class IOError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.IOError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.IOError'
  @staticmethod
  def _ctor_S(msg):
    o = IOError.__new__(IOError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return IOError
mosek_fusion_IOError=__mk_mosek_fusion_IOError()
del __mk_mosek_fusion_IOError
#BEFORE CLASS
def __mk_mosek_fusion_Disjunction():
 class Disjunction(object):
  __slots__ = ['_Disjunction__id']
  def __repr__(self): return 'mosek.fusion.Disjunction'
  @staticmethod
  def _ctor_J(id):
    o = Disjunction.__new__(Disjunction)
    o._ctor_init_J(id)
    return o
  @staticmethod
  def __match_ctor_J(*args):
    if len(args) != 1: return False
    id, = args
    return (__arg_match_J__(id))
  @staticmethod
  def __match_alt_ctor_J(*args):
    if len(args) != 1: return False
    id, = args
    return (__arg_alt_match_J__(id))
  def _ctor_alt_init_J(self,id):
    self._ctor_init_J(numpy.int64(id))
  def _ctor_init_J(self,id):
   (self.__id) = id
 return Disjunction
mosek_fusion_Disjunction=__mk_mosek_fusion_Disjunction()
del __mk_mosek_fusion_Disjunction
#BEFORE CLASS
def __mk_mosek_fusion_DisjunctionTerms():
 class DisjunctionTerms(object):
  __slots__ = ['_terms']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor__3Lmosek_4fusion_4Term_2(*args):
      self._ctor_init__3Lmosek_4fusion_4Term_2(*args)
    elif self.__match_alt_ctor__3Lmosek_4fusion_4Term_2(*args):
      self._ctor_alt_init__3Lmosek_4fusion_4Term_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4ExprRangeDomain_2(*args):
      self._ctor_init_Lmosek_4fusion_4ExprRangeDomain_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4ExprRangeDomain_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4ExprRangeDomain_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4ExprLinearDomain_2(*args):
      self._ctor_init_Lmosek_4fusion_4ExprLinearDomain_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4ExprLinearDomain_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4ExprLinearDomain_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(*args):
      self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(*args):
      self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(*args):
      self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(*args):
      self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(*args):
      self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.DisjunctionTerms.ctor(array(mosek.fusion.Term,ndim=1))\n\tmosek.fusion.DisjunctionTerms.ctor(mosek.fusion.ExprRangeDomain)\n\tmosek.fusion.DisjunctionTerms.ctor(mosek.fusion.ExprLinearDomain)\n\tmosek.fusion.DisjunctionTerms.ctor(mosek.fusion.DisjunctionTerms,array(mosek.fusion.Term,ndim=1))\n\tmosek.fusion.DisjunctionTerms.ctor(mosek.fusion.DisjunctionTerms,mosek.fusion.Term)\n\tmosek.fusion.DisjunctionTerms.ctor(mosek.fusion.DisjunctionTerms,mosek.fusion.ExprRangeDomain)\n\tmosek.fusion.DisjunctionTerms.ctor(mosek.fusion.DisjunctionTerms,mosek.fusion.ExprLinearDomain)\n\tmosek.fusion.DisjunctionTerms.ctor(mosek.fusion.DisjunctionTerms,mosek.fusion.DisjunctionTerms)')
  def __repr__(self): return 'mosek.fusion.DisjunctionTerms'
  @staticmethod
  def _ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(terms1,term):
    o = DisjunctionTerms.__new__(DisjunctionTerms)
    o._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(terms1,term)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 2: return False
    terms1,term, = args
    return (__arg_match_Lmosek_4fusion_4DisjunctionTerms_2__(terms1) and __arg_match_Lmosek_4fusion_4ExprRangeDomain_2__(term))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 2: return False
    terms1,term, = args
    return (__arg_alt_match_Lmosek_4fusion_4DisjunctionTerms_2__(terms1) and __arg_alt_match_Lmosek_4fusion_4ExprRangeDomain_2__(term))
  def _ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(self,terms1,term):
    self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(terms1,term)
  def _ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(self,terms1,term):
   mosek_fusion_DisjunctionTerms._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(self,terms1,mosek.fusion.DJC._term_Lmosek_4fusion_4ExprRangeDomain_2(term))
  @staticmethod
  def _ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(terms1,term):
    o = DisjunctionTerms.__new__(DisjunctionTerms)
    o._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(terms1,term)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 2: return False
    terms1,term, = args
    return (__arg_match_Lmosek_4fusion_4DisjunctionTerms_2__(terms1) and __arg_match_Lmosek_4fusion_4ExprLinearDomain_2__(term))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 2: return False
    terms1,term, = args
    return (__arg_alt_match_Lmosek_4fusion_4DisjunctionTerms_2__(terms1) and __arg_alt_match_Lmosek_4fusion_4ExprLinearDomain_2__(term))
  def _ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(self,terms1,term):
    self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(terms1,term)
  def _ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(self,terms1,term):
   mosek_fusion_DisjunctionTerms._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(self,terms1,mosek.fusion.DJC._term_Lmosek_4fusion_4ExprLinearDomain_2(term))
  @staticmethod
  def _ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(terms1,term2):
    o = DisjunctionTerms.__new__(DisjunctionTerms)
    o._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(terms1,term2)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(*args):
    if len(args) != 2: return False
    terms1,term2, = args
    return (__arg_match_Lmosek_4fusion_4DisjunctionTerms_2__(terms1) and __arg_match_Lmosek_4fusion_4DisjunctionTerms_2__(term2))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(*args):
    if len(args) != 2: return False
    terms1,term2, = args
    return (__arg_alt_match_Lmosek_4fusion_4DisjunctionTerms_2__(terms1) and __arg_alt_match_Lmosek_4fusion_4DisjunctionTerms_2__(term2))
  def _ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(self,terms1,term2):
    self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(terms1,term2)
  def _ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(self,terms1,term2):
   mosek_fusion_DisjunctionTerms._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(self,terms1,(term2._terms))
  @staticmethod
  def _ctor_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(term1,term2):
    o = DisjunctionTerms.__new__(DisjunctionTerms)
    o._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(term1,term2)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    term1,term2, = args
    return (__arg_match_Lmosek_4fusion_4DisjunctionTerms_2__(term1) and __arg_match__3Lmosek_4fusion_4Term_2__(term2))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    term1,term2, = args
    return (__arg_alt_match_Lmosek_4fusion_4DisjunctionTerms_2__(term1) and __arg_alt_match__3Lmosek_4fusion_4Term_2__(term2))
  def _ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(self,term1,term2):
    self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(term1,numpy.array(term2,dtype=numpy.dtype(object)))
  def _ctor_init_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(self,term1,term2):
   _a_0=int(((term1._terms)).shape[0])
   self._terms = numpy.zeros(((int(((term1._terms)).shape[0]) + int((term2).shape[0])),), dtype=numpy.dtype(object))
   _a_1=0
   while (_a_1 < int(((term1._terms)).shape[0])):
    self._terms[_a_1] = (term1._terms)[_a_1]
    _a_1 += 1
   _a_2=0
   while (_a_2 < int((term2).shape[0])):
    self._terms[(_a_2 + _a_0)] = term2[_a_2]
    _a_2 += 1
  @staticmethod
  def _ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(term1,term2):
    o = DisjunctionTerms.__new__(DisjunctionTerms)
    o._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(term1,term2)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    term1,term2, = args
    return (__arg_match_Lmosek_4fusion_4DisjunctionTerms_2__(term1) and __arg_match_Lmosek_4fusion_4Term_2__(term2))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    term1,term2, = args
    return (__arg_alt_match_Lmosek_4fusion_4DisjunctionTerms_2__(term1) and __arg_alt_match_Lmosek_4fusion_4Term_2__(term2))
  def _ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(self,term1,term2):
    self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(term1,term2)
  def _ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(self,term1,term2):
   self._terms = numpy.zeros(((int(((term1._terms)).shape[0]) + 1),), dtype=numpy.dtype(object))
   _a_0=0
   while (_a_0 < int(((term1._terms)).shape[0])):
    self._terms[_a_0] = (term1._terms)[_a_0]
    _a_0 += 1
   self._terms[int(((term1._terms)).shape[0])] = term2
  @staticmethod
  def _ctor__3Lmosek_4fusion_4Term_2(terms):
    o = DisjunctionTerms.__new__(DisjunctionTerms)
    o._ctor_init__3Lmosek_4fusion_4Term_2(terms)
    return o
  @staticmethod
  def __match_ctor__3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 1: return False
    terms, = args
    return (__arg_match__3Lmosek_4fusion_4Term_2__(terms))
  @staticmethod
  def __match_alt_ctor__3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 1: return False
    terms, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Term_2__(terms))
  def _ctor_alt_init__3Lmosek_4fusion_4Term_2(self,terms):
    self._ctor_init__3Lmosek_4fusion_4Term_2(numpy.array(terms,dtype=numpy.dtype(object)))
  def _ctor_init__3Lmosek_4fusion_4Term_2(self,terms):
   (self._terms) = numpy.array([terms[_a_0] for _a_0 in range(0,int((terms).shape[0]))], dtype=numpy.dtype(object))
  @staticmethod
  def _ctor_Lmosek_4fusion_4ExprRangeDomain_2(term):
    o = DisjunctionTerms.__new__(DisjunctionTerms)
    o._ctor_init_Lmosek_4fusion_4ExprRangeDomain_2(term)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 1: return False
    term, = args
    return (__arg_match_Lmosek_4fusion_4ExprRangeDomain_2__(term))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 1: return False
    term, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprRangeDomain_2__(term))
  def _ctor_alt_init_Lmosek_4fusion_4ExprRangeDomain_2(self,term):
    self._ctor_init_Lmosek_4fusion_4ExprRangeDomain_2(term)
  def _ctor_init_Lmosek_4fusion_4ExprRangeDomain_2(self,term):
   self._terms = numpy.array([mosek.fusion.DJC._term_Lmosek_4fusion_4ExprRangeDomain_2(term)], dtype=numpy.dtype(object))
  @staticmethod
  def _ctor_Lmosek_4fusion_4ExprLinearDomain_2(term):
    o = DisjunctionTerms.__new__(DisjunctionTerms)
    o._ctor_init_Lmosek_4fusion_4ExprLinearDomain_2(term)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 1: return False
    term, = args
    return (__arg_match_Lmosek_4fusion_4ExprLinearDomain_2__(term))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 1: return False
    term, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprLinearDomain_2__(term))
  def _ctor_alt_init_Lmosek_4fusion_4ExprLinearDomain_2(self,term):
    self._ctor_init_Lmosek_4fusion_4ExprLinearDomain_2(term)
  def _ctor_init_Lmosek_4fusion_4ExprLinearDomain_2(self,term):
   self._terms = numpy.array([mosek.fusion.DJC._term_Lmosek_4fusion_4ExprLinearDomain_2(term)], dtype=numpy.dtype(object))
 return DisjunctionTerms
mosek_fusion_DisjunctionTerms=__mk_mosek_fusion_DisjunctionTerms()
del __mk_mosek_fusion_DisjunctionTerms
#BEFORE CLASS
def __mk_mosek_fusion_Term():
 class Term(mosek_fusion_ExprDomain,object):
  __slots__ = ['_domains','_exprs']
  def toDJCTerm(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Term.toDJCTerm()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Term._match_toDJCTerm_(*args):
      return self._toDJCTerm_(*args)
    elif mosek_fusion_Term._match_alt_toDJCTerm_(*args):
      return self._toDJCTerm_alt_(*args)
    else:
      raise ValueError('Invalid argument list toDJCTerm('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Term.toDJCTerm()')
  def size(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Term.size()

    Description
    -----------

    Total size of the term. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Term._match_size_(*args):
      return self._size_(*args)
    elif mosek_fusion_Term._match_alt_size_(*args):
      return self._size_alt_(*args)
    else:
      raise ValueError('Invalid argument list size('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Term.size()')
  def __repr__(self): return 'mosek.fusion.Term'
  @staticmethod
  def _ctor__3Lmosek_4fusion_4Expression_2_3Lmosek_4fusion_4DJCDomain_2(elist,dlist):
    o = Term.__new__(Term)
    o._ctor_init__3Lmosek_4fusion_4Expression_2_3Lmosek_4fusion_4DJCDomain_2(elist,dlist)
    return o
  @staticmethod
  def __match_ctor__3Lmosek_4fusion_4Expression_2_3Lmosek_4fusion_4DJCDomain_2(*args):
    if len(args) != 2: return False
    elist,dlist, = args
    return (__arg_match__3Lmosek_4fusion_4Expression_2__(elist) and __arg_match__3Lmosek_4fusion_4DJCDomain_2__(dlist))
  @staticmethod
  def __match_alt_ctor__3Lmosek_4fusion_4Expression_2_3Lmosek_4fusion_4DJCDomain_2(*args):
    if len(args) != 2: return False
    elist,dlist, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Expression_2__(elist) and __arg_alt_match__3Lmosek_4fusion_4DJCDomain_2__(dlist))
  def _ctor_alt_init__3Lmosek_4fusion_4Expression_2_3Lmosek_4fusion_4DJCDomain_2(self,elist,dlist):
    self._ctor_init__3Lmosek_4fusion_4Expression_2_3Lmosek_4fusion_4DJCDomain_2(numpy.array(elist,dtype=numpy.dtype(object)),numpy.array(dlist,dtype=numpy.dtype(object)))
  def _ctor_init__3Lmosek_4fusion_4Expression_2_3Lmosek_4fusion_4DJCDomain_2(self,elist,dlist):
   _a_0=int((elist).shape[0])
   self._exprs = numpy.ndarray((_a_0,), dtype=numpy.dtype(object))
   self._domains = numpy.ndarray((_a_0,), dtype=numpy.dtype(object))
   for _a_1 in range(0,_a_0):
    self._exprs[_a_1] = elist[_a_1]
    self._domains[_a_1] = dlist[_a_1]
  @staticmethod
  def _ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(e,d):
    o = Term.__new__(Term)
    o._ctor_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(e,d)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(*args):
    if len(args) != 2: return False
    e,d, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(e) and __arg_match_Lmosek_4fusion_4DJCDomain_2__(d))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(*args):
    if len(args) != 2: return False
    e,d, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(e) and __arg_alt_match_Lmosek_4fusion_4DJCDomain_2__(d))
  def _ctor_alt_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(self,e,d):
    self._ctor_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(e,d)
  def _ctor_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(self,e,d):
   self._exprs = numpy.array([e], dtype=numpy.dtype(object))
   self._domains = numpy.array([d], dtype=numpy.dtype(object))
  @staticmethod
  def _ctor__3Lmosek_4fusion_4SimpleTerm_2(t):
    o = Term.__new__(Term)
    o._ctor_init__3Lmosek_4fusion_4SimpleTerm_2(t)
    return o
  @staticmethod
  def __match_ctor__3Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 1: return False
    t, = args
    return (__arg_match__3Lmosek_4fusion_4SimpleTerm_2__(t))
  @staticmethod
  def __match_alt_ctor__3Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 1: return False
    t, = args
    return (__arg_alt_match__3Lmosek_4fusion_4SimpleTerm_2__(t))
  def _ctor_alt_init__3Lmosek_4fusion_4SimpleTerm_2(self,t):
    self._ctor_init__3Lmosek_4fusion_4SimpleTerm_2(numpy.array(t,dtype=numpy.dtype(object)))
  def _ctor_init__3Lmosek_4fusion_4SimpleTerm_2(self,t):
   _a_0=int((t).shape[0])
   self._exprs = numpy.ndarray((_a_0,), dtype=numpy.dtype(object))
   self._domains = numpy.ndarray((_a_0,), dtype=numpy.dtype(object))
   for _a_1 in range(0,_a_0):
    self._exprs[_a_1] = (t[_a_1]._exprs)[0]
    self._domains[_a_1] = (t[_a_1]._domains)[0]
  def _numaccterms_alt_(self,):
    return self._numaccterms_()
  def _numaccterms_(self,):
   _a_0=0
   for _a_1 in range(0,int((self._domains).shape[0])):
    _a_0 += self._domains[_a_1]._numaccterms_()
   return numpy.int32(_a_0)
  def _numaccrows_alt_(self,):
    return self._numaccrows_()
  def _numaccrows_(self,):
   _a_0=0
   for _a_1 in range(0,int((self._domains).shape[0])):
    _a_0 += self._domains[_a_1]._numaccrows_()
   return numpy.int32(_a_0)
  def _num_alt_(self,):
    return self._num_()
  def _num_(self,):
   return numpy.int32(int((self._domains).shape[0]))
  @staticmethod
  def _match_size_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_size_(*args):
    if len(args) != 0: return False
    return True
  def _size_alt_(self,):
    return self._size_()
  def _size_(self,):
   _a_0=0
   for _a_1 in range(0,int((self._domains).shape[0])):
    _a_0 += self._domains[_a_1]._size_()
   return numpy.int32(_a_0)
  @staticmethod
  def _match_toDJCTerm_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toDJCTerm_(*args):
    if len(args) != 0: return False
    return True
  def _toDJCTerm_alt_(self,):
    return self._toDJCTerm_()
  def _toDJCTerm_(self,):
   return (self)
 return Term
mosek_fusion_Term=__mk_mosek_fusion_Term()
del __mk_mosek_fusion_Term
#BEFORE CLASS
def __mk_mosek_fusion_SimpleTerm():
 class SimpleTerm(mosek_fusion_Term):
  def __repr__(self): return 'mosek.fusion.SimpleTerm'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(e,d):
    o = SimpleTerm.__new__(SimpleTerm)
    o._ctor_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(e,d)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(*args):
    if len(args) != 2: return False
    e,d, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(e) and __arg_match_Lmosek_4fusion_4DJCDomain_2__(d))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(*args):
    if len(args) != 2: return False
    e,d, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(e) and __arg_alt_match_Lmosek_4fusion_4DJCDomain_2__(d))
  def _ctor_alt_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(self,e,d):
    self._ctor_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(e,d)
  def _ctor_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(self,e,d):
   mosek_fusion_Term._ctor_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(self,e,d)
 return SimpleTerm
mosek_fusion_SimpleTerm=__mk_mosek_fusion_SimpleTerm()
del __mk_mosek_fusion_SimpleTerm
#BEFORE CLASS
def __mk_mosek_fusion_DJCDomain():
 class DJCDomain(object):
  __slots__ = ['dom','conedim','shape','par','b']
  def size(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.DJCDomain.size()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_DJCDomain._match_size_(*args):
      return self._size_(*args)
    elif mosek_fusion_DJCDomain._match_alt_size_(*args):
      return self._size_alt_(*args)
    else:
      raise ValueError('Invalid argument list size('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.DJCDomain.size()')
  def __repr__(self): return 'mosek.fusion.DJCDomain'
  @staticmethod
  def _ctor__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(b_,par_,shape_,dom_):
    o = DJCDomain.__new__(DJCDomain)
    o._ctor_init__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(b_,par_,shape_,dom_)
    return o
  @staticmethod
  def __match_ctor__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(*args):
    if len(args) != 4: return False
    b_,par_,shape_,dom_, = args
    return (__arg_match__3D__(b_) and __arg_match__3D__(par_) and __arg_match__3I__(shape_) and __arg_match_Emosek_4fusion_4DJCDomainType_2__(dom_))
  @staticmethod
  def __match_alt_ctor__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(*args):
    if len(args) != 4: return False
    b_,par_,shape_,dom_, = args
    return (__arg_alt_match__3D__(b_) and __arg_alt_match__3D__(par_) and __arg_alt_match__3I__(shape_) and __arg_alt_match_Emosek_4fusion_4DJCDomainType_2__(dom_))
  def _ctor_alt_init__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(self,b_,par_,shape_,dom_):
    self._ctor_init__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(numpy.array(b_,dtype=numpy.dtype(numpy.float64)),numpy.array(par_,dtype=numpy.dtype(numpy.float64)),numpy.array(shape_,dtype=numpy.dtype(numpy.int32)),dom_)
  def _ctor_init__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(self,b_,par_,shape_,dom_):
   self.b = b_
   self.par = par_
   self.shape = shape_
   self.dom = dom_
   self.conedim = (int((shape_).shape[0]) - 1)
  @staticmethod
  def _ctor__3D_3D_3IIEmosek_4fusion_4DJCDomainType_2(b_,par_,shape_,conedim_,dom_):
    o = DJCDomain.__new__(DJCDomain)
    o._ctor_init__3D_3D_3IIEmosek_4fusion_4DJCDomainType_2(b_,par_,shape_,conedim_,dom_)
    return o
  @staticmethod
  def __match_ctor__3D_3D_3IIEmosek_4fusion_4DJCDomainType_2(*args):
    if len(args) != 5: return False
    b_,par_,shape_,conedim_,dom_, = args
    return (__arg_match__3D__(b_) and __arg_match__3D__(par_) and __arg_match__3I__(shape_) and __arg_match_I__(conedim_) and __arg_match_Emosek_4fusion_4DJCDomainType_2__(dom_))
  @staticmethod
  def __match_alt_ctor__3D_3D_3IIEmosek_4fusion_4DJCDomainType_2(*args):
    if len(args) != 5: return False
    b_,par_,shape_,conedim_,dom_, = args
    return (__arg_alt_match__3D__(b_) and __arg_alt_match__3D__(par_) and __arg_alt_match__3I__(shape_) and __arg_alt_match_I__(conedim_) and __arg_alt_match_Emosek_4fusion_4DJCDomainType_2__(dom_))
  def _ctor_alt_init__3D_3D_3IIEmosek_4fusion_4DJCDomainType_2(self,b_,par_,shape_,conedim_,dom_):
    self._ctor_init__3D_3D_3IIEmosek_4fusion_4DJCDomainType_2(numpy.array(b_,dtype=numpy.dtype(numpy.float64)),numpy.array(par_,dtype=numpy.dtype(numpy.float64)),numpy.array(shape_,dtype=numpy.dtype(numpy.int32)),numpy.int32(conedim_),dom_)
  def _ctor_init__3D_3D_3IIEmosek_4fusion_4DJCDomainType_2(self,b_,par_,shape_,conedim_,dom_):
   self.b = b_
   self.par = par_
   self.shape = shape_
   self.dom = dom_
   self.conedim = conedim_
  def _numaccterms_alt_(self,):
    return self._numaccterms_()
  def _numaccterms_(self,):
   if (self.dom==mosek.fusion.DJCDomainType.InRange):
    return numpy.int32(2)
   else:
    return numpy.int32(1)
  def _numaccrows_alt_(self,):
    return self._numaccrows_()
  def _numaccrows_(self,):
   if (self.dom==mosek.fusion.DJCDomainType.InRange):
    return numpy.int32((self._size_() * 2))
   else:
    return numpy.int32(self._size_())
  @staticmethod
  def _match_size_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_size_(*args):
    if len(args) != 0: return False
    return True
  def _size_alt_(self,):
    return self._size_()
  def _size_(self,):
   _a_0=1
   _a_0 = fragments._c_closure_0(_a_0,self.shape)
   _a_0 = numpy.int32(_a_0) # postprocess
   return numpy.int32(_a_0)
 return DJCDomain
mosek_fusion_DJCDomain=__mk_mosek_fusion_DJCDomain()
del __mk_mosek_fusion_DJCDomain
#BEFORE CLASS
def __mk_mosek_fusion_DJC():
 class DJC(object):
  @staticmethod
  def ANDFromTerms(*args):
    '''
    Syntax
    ------

      mosek.fusion.DJC.ANDFromTerms(array(mosek.fusion.Term,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    tlist : array(mosek.fusion.Term,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_DJC._match_ANDFromTerms__3Lmosek_4fusion_4Term_2(*args):
      return mosek_fusion_DJC._ANDFromTerms__3Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_DJC._match_alt_ANDFromTerms__3Lmosek_4fusion_4Term_2(*args):
      return mosek_fusion_DJC._ANDFromTerms_alt__3Lmosek_4fusion_4Term_2(*args)
    else:
      raise ValueError('Invalid argument list ANDFromTerms('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.DJC.ANDFromTerms(array(mosek.fusion.Term,ndim=1))')
  @staticmethod
  def AND(*args):
    '''
    Syntax
    ------

      mosek.fusion.DJC.AND(array(mosek.fusion.SimpleTerm,ndim=1))
      mosek.fusion.DJC.AND(array(mosek.fusion.ExprDomain,ndim=1))
      mosek.fusion.DJC.AND(mosek.fusion.SimpleTerm)
      mosek.fusion.DJC.AND(mosek.fusion.SimpleTerm,mosek.fusion.SimpleTerm)
      mosek.fusion.DJC.AND(mosek.fusion.SimpleTerm,mosek.fusion.SimpleTerm,mosek.fusion.SimpleTerm)

    Description
    -----------

    Create a conjunction of simple terms. 

    Parameters
    ----------

    elist : array(mosek.fusion.ExprDomain,ndim=1)
    s1 : mosek.fusion.SimpleTerm
        A simple term. 
    s2 : mosek.fusion.SimpleTerm
        A simple term. 
    s3 : mosek.fusion.SimpleTerm
        A simple term. 
    slist : array(mosek.fusion.SimpleTerm,ndim=1)
        A list of simple terms in the conjunction. 
    '''
    if False: pass
    elif mosek_fusion_DJC._match_AND__3Lmosek_4fusion_4SimpleTerm_2(*args):
      return mosek_fusion_DJC._AND__3Lmosek_4fusion_4SimpleTerm_2(*args)
    elif mosek_fusion_DJC._match_alt_AND__3Lmosek_4fusion_4SimpleTerm_2(*args):
      return mosek_fusion_DJC._AND_alt__3Lmosek_4fusion_4SimpleTerm_2(*args)
    elif mosek_fusion_DJC._match_AND__3Lmosek_4fusion_4ExprDomain_2(*args):
      return mosek_fusion_DJC._AND__3Lmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_DJC._match_alt_AND__3Lmosek_4fusion_4ExprDomain_2(*args):
      return mosek_fusion_DJC._AND_alt__3Lmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_DJC._match_AND_Lmosek_4fusion_4SimpleTerm_2(*args):
      return mosek_fusion_DJC._AND_Lmosek_4fusion_4SimpleTerm_2(*args)
    elif mosek_fusion_DJC._match_alt_AND_Lmosek_4fusion_4SimpleTerm_2(*args):
      return mosek_fusion_DJC._AND_alt_Lmosek_4fusion_4SimpleTerm_2(*args)
    elif mosek_fusion_DJC._match_AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args):
      return mosek_fusion_DJC._AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args)
    elif mosek_fusion_DJC._match_alt_AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args):
      return mosek_fusion_DJC._AND_alt_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args)
    elif mosek_fusion_DJC._match_AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args):
      return mosek_fusion_DJC._AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args)
    elif mosek_fusion_DJC._match_alt_AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args):
      return mosek_fusion_DJC._AND_alt_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args)
    else:
      raise ValueError('Invalid argument list AND('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.DJC.AND(array(mosek.fusion.SimpleTerm,ndim=1))\n\tmosek.fusion.DJC.AND(array(mosek.fusion.ExprDomain,ndim=1))\n\tmosek.fusion.DJC.AND(mosek.fusion.SimpleTerm)\n\tmosek.fusion.DJC.AND(mosek.fusion.SimpleTerm,mosek.fusion.SimpleTerm)\n\tmosek.fusion.DJC.AND(mosek.fusion.SimpleTerm,mosek.fusion.SimpleTerm,mosek.fusion.SimpleTerm)')
  @staticmethod
  def term(*args):
    '''
    Syntax
    ------

      mosek.fusion.DJC.term(mosek.fusion.ExprRangeDomain)
      mosek.fusion.DJC.term(mosek.fusion.ExprLinearDomain)
      mosek.fusion.DJC.term(mosek.fusion.Variable,mosek.fusion.RangeDomain)
      mosek.fusion.DJC.term(mosek.fusion.Expression,mosek.fusion.RangeDomain)
      mosek.fusion.DJC.term(mosek.fusion.Variable,mosek.fusion.LinearDomain)
      mosek.fusion.DJC.term(mosek.fusion.Expression,mosek.fusion.LinearDomain)

    Description
    -----------

    Create a simple term. 

    Parameters
    ----------

    dom : mosek.fusion.LinearDomain
        The domain of this simple term. 
    expr : mosek.fusion.Expression
        An expression. 
    exprdom : mosek.fusion.ExprLinearDomain
    x : mosek.fusion.Variable
        A variable. 
    '''
    if False: pass
    elif mosek_fusion_DJC._match_term_Lmosek_4fusion_4ExprRangeDomain_2(*args):
      return mosek_fusion_DJC._term_Lmosek_4fusion_4ExprRangeDomain_2(*args)
    elif mosek_fusion_DJC._match_alt_term_Lmosek_4fusion_4ExprRangeDomain_2(*args):
      return mosek_fusion_DJC._term_alt_Lmosek_4fusion_4ExprRangeDomain_2(*args)
    elif mosek_fusion_DJC._match_term_Lmosek_4fusion_4ExprLinearDomain_2(*args):
      return mosek_fusion_DJC._term_Lmosek_4fusion_4ExprLinearDomain_2(*args)
    elif mosek_fusion_DJC._match_alt_term_Lmosek_4fusion_4ExprLinearDomain_2(*args):
      return mosek_fusion_DJC._term_alt_Lmosek_4fusion_4ExprLinearDomain_2(*args)
    elif mosek_fusion_DJC._match_term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args):
      return mosek_fusion_DJC._term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_DJC._match_alt_term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args):
      return mosek_fusion_DJC._term_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_DJC._match_term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
      return mosek_fusion_DJC._term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_DJC._match_alt_term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
      return mosek_fusion_DJC._term_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_DJC._match_term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args):
      return mosek_fusion_DJC._term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_DJC._match_alt_term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args):
      return mosek_fusion_DJC._term_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_DJC._match_term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
      return mosek_fusion_DJC._term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_DJC._match_alt_term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
      return mosek_fusion_DJC._term_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    else:
      raise ValueError('Invalid argument list term('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.DJC.term(mosek.fusion.ExprRangeDomain)\n\tmosek.fusion.DJC.term(mosek.fusion.ExprLinearDomain)\n\tmosek.fusion.DJC.term(mosek.fusion.Variable,mosek.fusion.RangeDomain)\n\tmosek.fusion.DJC.term(mosek.fusion.Expression,mosek.fusion.RangeDomain)\n\tmosek.fusion.DJC.term(mosek.fusion.Variable,mosek.fusion.LinearDomain)\n\tmosek.fusion.DJC.term(mosek.fusion.Expression,mosek.fusion.LinearDomain)')
  def __repr__(self): return 'mosek.fusion.DJC'
  @staticmethod
  def _match_ANDFromTerms__3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3Lmosek_4fusion_4Term_2__(_a_0))
  @staticmethod
  def _match_alt_ANDFromTerms__3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Term_2__(_a_0))
  @staticmethod
  def _ANDFromTerms_alt__3Lmosek_4fusion_4Term_2(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_DJC._ANDFromTerms__3Lmosek_4fusion_4Term_2(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _ANDFromTerms__3Lmosek_4fusion_4Term_2(_a_0):
   _a_1=0
   for _a_2 in range(0,int((_a_0).shape[0])):
    _a_1 += _a_0[_a_2]._num_()
   _a_3=numpy.ndarray((_a_1,), dtype=numpy.dtype(object))
   _a_4=numpy.ndarray((_a_1,), dtype=numpy.dtype(object))
   _a_1 = 0
   for _a_5 in range(0,int((_a_0).shape[0])):
    for _a_6 in range(0,_a_0[_a_5]._num_()):
     _a_3[_a_1] = (_a_0[_a_5]._exprs)[_a_6]
     _a_4[_a_1] = (_a_0[_a_5]._domains)[_a_6]
     _a_1 += 1
   return (mosek_fusion_Term._ctor__3Lmosek_4fusion_4Expression_2_3Lmosek_4fusion_4DJCDomain_2(_a_3,_a_4))
  @staticmethod
  def _match_AND__3Lmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3Lmosek_4fusion_4ExprDomain_2__(_a_0))
  @staticmethod
  def _match_alt_AND__3Lmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4ExprDomain_2__(_a_0))
  @staticmethod
  def _AND_alt__3Lmosek_4fusion_4ExprDomain_2(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_DJC._AND__3Lmosek_4fusion_4ExprDomain_2(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _AND__3Lmosek_4fusion_4ExprDomain_2(_a_0):
   return (mosek.fusion.DJC._ANDFromTerms__3Lmosek_4fusion_4Term_2(numpy.array([_a_0[_a_1]._toDJCTerm_() for _a_1 in range(0,int((_a_0).shape[0]))], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_Lmosek_4fusion_4SimpleTerm_2__(_a_0) and __arg_match_Lmosek_4fusion_4SimpleTerm_2__(_a_1) and __arg_match_Lmosek_4fusion_4SimpleTerm_2__(_a_2))
  @staticmethod
  def _match_alt_AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4SimpleTerm_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4SimpleTerm_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4SimpleTerm_2__(_a_2))
  @staticmethod
  def _AND_alt_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(_t__a_0,_t__a_1,_t__a_2):
    return mosek_fusion_DJC._AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(_a_0,_a_1,_a_2)
  @staticmethod
  def _AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(_a_0,_a_1,_a_2):
   return (mosek.fusion.DJC._AND__3Lmosek_4fusion_4SimpleTerm_2(numpy.array([_a_0,_a_1,_a_2], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4SimpleTerm_2__(_a_0) and __arg_match_Lmosek_4fusion_4SimpleTerm_2__(_a_1))
  @staticmethod
  def _match_alt_AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4SimpleTerm_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4SimpleTerm_2__(_a_1))
  @staticmethod
  def _AND_alt_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(_t__a_0,_t__a_1):
    return mosek_fusion_DJC._AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(_a_0,_a_1)
  @staticmethod
  def _AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(_a_0,_a_1):
   return (mosek.fusion.DJC._AND__3Lmosek_4fusion_4SimpleTerm_2(numpy.array([_a_0,_a_1], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_AND_Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4SimpleTerm_2__(_a_0))
  @staticmethod
  def _match_alt_AND_Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4SimpleTerm_2__(_a_0))
  @staticmethod
  def _AND_alt_Lmosek_4fusion_4SimpleTerm_2(_t__a_0):
    return mosek_fusion_DJC._AND_Lmosek_4fusion_4SimpleTerm_2(_a_0)
  @staticmethod
  def _AND_Lmosek_4fusion_4SimpleTerm_2(_a_0):
   return (mosek.fusion.DJC._AND__3Lmosek_4fusion_4SimpleTerm_2(numpy.array([_a_0], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_AND__3Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3Lmosek_4fusion_4SimpleTerm_2__(_a_0))
  @staticmethod
  def _match_alt_AND__3Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4SimpleTerm_2__(_a_0))
  @staticmethod
  def _AND_alt__3Lmosek_4fusion_4SimpleTerm_2(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_DJC._AND__3Lmosek_4fusion_4SimpleTerm_2(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _AND__3Lmosek_4fusion_4SimpleTerm_2(_a_0):
   return (mosek_fusion_Term._ctor__3Lmosek_4fusion_4SimpleTerm_2(_a_0))
  @staticmethod
  def _match_term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_a_1))
  @staticmethod
  def _match_alt_term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_a_1))
  @staticmethod
  def _term_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_t__a_0,_t__a_1):
    return mosek_fusion_DJC._term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_a_0,_a_1)
  @staticmethod
  def _term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_a_0,_a_1):
   if ((_a_1._sparsity) is not None):
    raise mosek_fusion_DomainError._ctor_S("Sparse domain is not acceptable in disjunctive constraints")
   if (_a_1._cardinal_flag):
    raise mosek_fusion_DomainError._ctor_S("Integer domain is not acceptable in disjunctive constraints")
   _a_2=(_a_1._lb)
   _a_3=(_a_1._ub)
   _a_4=_a_0._getShape_()
   _a_5=_a_0._getSize_()
   _a_6=(_a_1._shape)
   if (_a_6 is None):
    _a_6 = _a_4
   else:
    if (int((_a_6).shape[0])!=int((_a_4).shape[0])):
     raise mosek_fusion_DomainError._ctor_S("Mismatching shapes")
    else:
     for _a_9 in range(0,int((_a_6).shape[0])):
      if (_a_6[_a_9]!=_a_4[_a_9]):
       raise mosek_fusion_DomainError._ctor_S("Mismatching shapes")
   if (_a_1._scalable):
    _a_7 = numpy.array([_a_2[0] for _a_10 in range(0,_a_5)], dtype=numpy.dtype(numpy.float64))
    _a_8 = numpy.array([_a_3[0] for _a_11 in range(0,_a_5)], dtype=numpy.dtype(numpy.float64))
   else:
    _a_7 = _a_2
    _a_8 = _a_3
   return (mosek_fusion_SimpleTerm._ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(_a_0,mosek_fusion_DJCDomain._ctor__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(_a_7,_a_8,_a_6,mosek.fusion.DJCDomainType.InRange)))
  @staticmethod
  def _match_term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_a_1))
  @staticmethod
  def _match_alt_term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_a_1))
  @staticmethod
  def _term_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(_t__a_0,_t__a_1):
    return mosek_fusion_DJC._term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(_a_0,_a_1)
  @staticmethod
  def _term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(_a_0,_a_1):
   return (mosek.fusion.DJC._term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_a_0._asExpr_(),_a_1))
  @staticmethod
  def _match_term_Lmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4ExprRangeDomain_2__(_a_0))
  @staticmethod
  def _match_alt_term_Lmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprRangeDomain_2__(_a_0))
  @staticmethod
  def _term_alt_Lmosek_4fusion_4ExprRangeDomain_2(_t__a_0):
    return mosek_fusion_DJC._term_Lmosek_4fusion_4ExprRangeDomain_2(_a_0)
  @staticmethod
  def _term_Lmosek_4fusion_4ExprRangeDomain_2(_a_0):
   return (mosek.fusion.DJC._term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2((_a_0.expr),(_a_0.dom)))
  @staticmethod
  def _match_term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_a_1))
  @staticmethod
  def _match_alt_term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_a_1))
  @staticmethod
  def _term_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_t__a_0,_t__a_1):
    return mosek_fusion_DJC._term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_a_0,_a_1)
  @staticmethod
  def _term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_a_0,_a_1):
   if ((_a_1._sparsity) is not None):
    raise mosek_fusion_DomainError._ctor_S("Sparse domain is not acceptable in disjunctive constraints")
   if (_a_1._cardinal_flag):
    raise mosek_fusion_DomainError._ctor_S("Integer domain is not acceptable in disjunctive constraints")
   _a_2=(_a_1._bnd)
   _a_3=_a_0._getShape_()
   _a_4=_a_0._getSize_()
   _a_5=(_a_1._shape)
   if (_a_5 is None):
    _a_5 = _a_3
   else:
    if (int((_a_5).shape[0])!=int((_a_3).shape[0])):
     raise mosek_fusion_DomainError._ctor_S("Mismatching shapes")
    else:
     for _a_7 in range(0,int((_a_5).shape[0])):
      if (_a_5[_a_7]!=_a_3[_a_7]):
       raise mosek_fusion_DomainError._ctor_S("Mismatching shapes")
   if ((_a_1._bnd) is None):
    _a_6 = numpy.zeros((_a_4,), dtype=numpy.dtype(numpy.float64))
   elif (_a_1._scalable):
    _a_6 = numpy.array([_a_2[0] for _a_8 in range(0,_a_4)], dtype=numpy.dtype(numpy.float64))
   elif (_a_1._empty):
    _a_6 = numpy.zeros((_a_4,), dtype=numpy.dtype(numpy.float64))
   else:
    _a_6 = _a_2
   if ((_a_1._key)==mosek.fusion.RelationKey.EqualsTo):
    return (mosek_fusion_SimpleTerm._ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(_a_0,mosek_fusion_DJCDomain._ctor__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(_a_6,None,_a_5,mosek.fusion.DJCDomainType.EqualTo)))
   elif ((_a_1._key)==mosek.fusion.RelationKey.LessThan):
    return (mosek_fusion_SimpleTerm._ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(_a_0,mosek_fusion_DJCDomain._ctor__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(_a_6,None,_a_5,mosek.fusion.DJCDomainType.LessThan)))
   elif ((_a_1._key)==mosek.fusion.RelationKey.GreaterThan):
    return (mosek_fusion_SimpleTerm._ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(_a_0,mosek_fusion_DJCDomain._ctor__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(_a_6,None,_a_5,mosek.fusion.DJCDomainType.GreaterThan)))
   elif ((_a_1._key)==mosek.fusion.RelationKey.IsFree):
    return (mosek_fusion_SimpleTerm._ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(_a_0,mosek_fusion_DJCDomain._ctor__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(_a_6,None,_a_5,mosek.fusion.DJCDomainType.IsFree)))
   else:
    raise mosek_fusion_UnexpectedError._ctor_S("Invalid linear domain")
  @staticmethod
  def _match_term_Lmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4ExprLinearDomain_2__(_a_0))
  @staticmethod
  def _match_alt_term_Lmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprLinearDomain_2__(_a_0))
  @staticmethod
  def _term_alt_Lmosek_4fusion_4ExprLinearDomain_2(_t__a_0):
    return mosek_fusion_DJC._term_Lmosek_4fusion_4ExprLinearDomain_2(_a_0)
  @staticmethod
  def _term_Lmosek_4fusion_4ExprLinearDomain_2(_a_0):
   return (mosek.fusion.DJC._term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2((_a_0.expr),(_a_0.dom)))
  @staticmethod
  def _match_term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_a_1))
  @staticmethod
  def _match_alt_term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_a_1))
  @staticmethod
  def _term_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(_t__a_0,_t__a_1):
    return mosek_fusion_DJC._term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(_a_0,_a_1)
  @staticmethod
  def _term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(_a_0,_a_1):
   return (mosek.fusion.DJC._term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_a_0._asExpr_(),_a_1))
 return DJC
mosek_fusion_DJC=__mk_mosek_fusion_DJC()
del __mk_mosek_fusion_DJC
def __mk_mosek_fusion_BaseModel():
  import threading
  import mosek
  import mosek.fusion
  import numpy
  
  class BaseModel(object):
    _lock = threading.Lock()
    _global_env = None
    _global_env_counter = 0
  
    @classmethod
    def _globalEnv(self):
      self._lock.acquire()
      try:
        if BaseModel._global_env is None:
          try:
            env = mosek.Env(globalenv=True)
            BaseModel._global_env = env
            BaseModel._global_env_counter += 1
          except mosek.Exception as e:
            raise UnexpectedError(e)
        return BaseModel._global_env
      finally:
        self._lock.release()
  
    @classmethod
    def _env_1putlicensecode__3I(self,code):
      self._globalEnv().putlicensecode(code)
  
    @classmethod
    def _env_1putlicensepath_S(self,path):
      self._globalEnv().putlicensepath(path)
  
    @classmethod
    def _env_1putlicensewait_Z(self,yn):
      if yn:
        self._globalEnv().putlicensewait(1)
      else:
        self._globalEnv().putlicensewait(0)
  
    @classmethod
    def _env_1getversion_(self):
      return ".".join([str(_) for _ in mosek.Env.getversion()])
  
    def __callback(self,callbackkey,dinf,iinf,liinf):
      if self.__user_cb is not None:
        try:
          if self.__user_cb(callbackkey,dinf,iinf,liinf):
            self.__break = True
        except:
          self.__break = True
      if self.__user_pgs is not None:
        try:
          if self.__user_pgs(callbackkey):
            self.__break = True
        except:
          self.__break = True
      return 1 if self.__break else 0
  
    def _ctor_init_SS(self,name,licfile):
      env = self._globalEnv()
      self.__modelname = name
      self.__break = False
      task = mosek.Task(self._global_env, 0, 0);
      self.__user_cb = None
      self.__user_pgs = None
      finished = False
      try:
        task.putintparam(mosek.iparam.log_expand,0);
        task.putintparam(mosek.iparam.remove_unused_solutions,1);
        self.__task = task
        if name is not None:
          task.puttaskname(name)
  
        self._synched = mosek_fusion_SolutionStatus.Optimal;
  
        self._sol_itr = None
        self._sol_bas = None
        self._sol_itg = None
  
        self.__objname = None
  
        # handler for log output.
        def loghandler(text):
          if self.__logwriter is not None:
            self.__logwriter.write(text)
            self.__logwriter.flush()
        self.__loghandler = loghandler
        self.__logwriter = None
  
        task.set_Stream(mosek.streamtype.log,loghandler)
        task.set_InfoCallback(self.__callback)
        finished = True
      finally:
        if not finished:
          self.__task.__del__()
          self.__task = None
          BaseModel._global_env_counter -= 1
  
    def _ctor_init_Lmosek_4fusion_4BaseModel_2(self,m):
      env = self._globalEnv()
      self.__modelname = m.__modelname
      self.__break = False
      self.__user_cb = None
      self.__user_pgs = None
      task = mosek.Task(m.__task)
      finished = False
      try:
        self.__task = task
        self._synched = m._synched
  
        self._sol_itr = m._sol_itr._clone_() if m._sol_itr is not None else None
        self._sol_bas = m._sol_bas._clone_() if m._sol_bas is not None else None
        self._sol_itg = m._sol_itg._clone_() if m._sol_itg is not None else None
  
        self.__objname = m.__objname
  
        # handler for log output.
        def loghandler(text):
          if self.__logwriter is not None:
            self.__logwriter.write(text)
            self.__logwriter.flush()
        self.__loghandler = loghandler
        self.__logwriter = None
  
        task.set_Stream(mosek.streamtype.log,loghandler)
        task.set_InfoCallback(self.__callback)
        finished = True
      finally:
        if not finished:
          self.__task.__del__()
          self.__task = None
          BaseModel._global_env_counter -= 1
  
    def __del__(self):
        lock = self._lock
        if hasattr(self,'_BaseModel__task'):
          lock.acquire()
          try:
            task = self.__task
            BaseModel._global_env_counter -= 1
            task.__del__()
  
            for a in self.__class__.__slots__ + ['_sol_itr','_sol_bas','_sol_itg',
                                                 '_BaseModel__user_cb','_BaseModel__user_pgs','_BaseModel__loghandler','_BaseModel__logwriter','_BaseModel__task']:
              try: delattr(self,a)
              except AttributeError: pass
          finally:
            lock.release()
  
    def __enter__(self):
      return self
    def __exit__(self,exc_type,exc_val,exc_tb):
      self.__del__()
    def _dispose_(self):
      self.__del__()
  
    def _task_1setDataCallbackHandler_LSystem_4DataCallbackHandler_2(self,handler):
      self.__user_cb = handler
    def _task_1setCallbackHandler_LSystem_4CallbackHandler_2(self,handler):
      self.__user_pgs = handler
  
    def _task_1setLogHandler_LSystem_4StreamWriter_2(self,handler):
      """
      Set the object to handle log output from the solver.
  
      The handler object must have a write method accepting a string.
      """
      self.__logwriter = handler
  
    def _task_1put_1param_SS(self,name,value):
      self.__task.putnastrparam(name,value)
    def _task_1put_1param_SD(self,name,value):
      self.__task.putnadouparam(name,value)
    def _task_1put_1param_SI(self,name,value):
      self.__task.putnaintparam(name,value)
  
    def _task_1get_1dinf_S(self,name):
      key = mosek_fusion_SolverInfo._getdouinf(name)
      if key is None:
        raise NameError("Invalid double info name '%s'" % name)
      else:
        return self.__task.getdouinf(key)
  
    def _task_1get_1iinf_S(self,name):
      key = mosek_fusion_SolverInfo._getintinf(name)
      if key is None:
        raise NameError("Invalid integer info name '%s'" % name)
      else:
        return self.__task.getintinf(key)
  
    def _task_1get_1liinf_S(self,name):
      key = mosek_fusion_SolverInfo._getlintinf(name)
      if key is None:
        raise NameError("Invalid long integer info name '%s'" % name)
      else:
        return self.__task.getlintinf(key)
  
    def _numVariables_ (self):
      return len(self.__vars)
    def _numConstraints_ (self):
      return len(self.__cons)
  
    @staticmethod
    def __convert_names(names):
      namelist = None
      if names is not None:
        namelist = []
        namedaxisidxs = []
        for axisi,nl in enumerate(names):
          if nl is not None:
            namelist.extend(nl)
            namedaxisidxs.append(axisi)
      else:
        namelist = None
        namedaxisidxs = None
  
      return namedaxisidxs,namelist
    def _task_1format_1djc_1names__3JS_3I_3_3S(self,sub,fmt,dims,names):
      namedaxisidxs,namelist = self.__convert_names(names)
      self.__task.generatedjcnames(sub,fmt,dims,None,namedaxisidxs,namelist)
    def _task_1format_1acc_1names__3JS_3I_3_3S(self,sub,fmt,dims,names):
      namedaxisidxs,namelist = self.__convert_names(names)
      self.__task.generateaccnames(sub,fmt,dims,None,namedaxisidxs,namelist)
    def _task_1format_1var_1names__3IS_3I_3J_3_3S(self,subj,fmt,dims,sp,names):
      namedaxisidxs,namelist = self.__convert_names(names)
      self.__task.generatevarnames(subj,fmt,dims,sp,namedaxisidxs,namelist)
    def _task_1format_1barvar_1names__3IS_3I_3_3S(self,subj,fmt,dims,names):
      namedaxisidxs,namelist = self.__convert_names(names)
      self.__task.generatebarvarnames(subj,fmt,dims,None,namedaxisidxs,namelist)
    def _task_1format_1con_1names__3IS_3I_3J_3_3S(self,subj,fmt,dims,sp,names):
      namedaxisidxs,namelist = self.__convert_names(names)
      self.__task.generateconnames(subj,fmt,dims,sp,namedaxisidxs,namelist)
  
    def _task_1con_1name_IS(self,idx,name): self.__task.putconname(idx,name)
    def _task_1var_1name_IS(self,idx, name): self.__task.putvarname(idx,name)
    def _task_1acc_1name_JS(self,idx, name): self.__task.putaccname(idx,name)
    def _task_1djc_1name_JS(self,idx, name): self.__task.putdjcname(idx,name)
    def _task_1barvar_1name_IS(self,idx, name): self.__task.putbarvarname(idx,name)
  
    def _task_1numcon_(self):
      return self.__task.getnumcon()
    def _task_1numvar_(self):
      return self.__task.getnumvar()
    def _task_1numacc_(self):
      return self.__task.getnumacc()
    def _task_1numafe_(self):
      return self.__task.getnumafe()
    def _task_1numdjc_(self):
      return self.__task.getnumdjc()
  
    def __task_putvarboundlist(self,idxs,bl,bu,bk):
      num = len(idxs)
      if bl is None: bl = numpy.zeros(num,numpy.float64)
      if bu is None: bu = numpy.zeros(num,numpy.float64)
  
      bka = [bk] * num
      self.__task.putvarboundlist(idxs,bka,bl,bu)
  
    def __task_putconboundlist(self,idxs,bl,bu,bk):
      num = len(idxs)
      if bl is None: bl = numpy.zeros(num,numpy.float64)
      if bu is None: bu = numpy.zeros(num,numpy.float64)
  
      bka = [bk] * num
      self.__task.putconboundlist(idxs,bka,bl,bu)
  
    def _task_1con_1putboundlist_1fx__3I_3D(self,idxs, rhs):
      self.__task_putconboundlist( idxs, rhs, rhs, mosek.boundkey.fx);
  
    def _task_1con_1putboundlist_1lo__3I_3D(self,idxs, rhs):
      self.__task_putconboundlist( idxs, rhs, rhs, mosek.boundkey.lo);
  
    def _task_1con_1putboundlist_1up__3I_3D(self,idxs, rhs):
      self.__task_putconboundlist( idxs, rhs, rhs, mosek.boundkey.up);
  
    def _task_1con_1putboundlist_1ra__3I_3D_3D(self,idxs, lb, ub):
      self.__task_putconboundlist( idxs, lb, ub, mosek.boundkey.ra);
  
    def _task_1con_1putboundlist_1fr__3I(self,idxs):
      self.__task_putconboundlist( idxs, None, None, mosek.boundkey.fr);
  
  
    def _task_1var_1putboundlist_1fx__3I_3D(self,idxs, rhs):
      self.__task_putvarboundlist( idxs, rhs, rhs, mosek.boundkey.fx);
  
    def _task_1var_1putboundlist_1lo__3I_3D(self,idxs, rhs):
      self.__task_putvarboundlist( idxs, rhs, rhs, mosek.boundkey.lo);
  
    def _task_1var_1putboundlist_1up__3I_3D(self,idxs, rhs):
      self.__task_putvarboundlist( idxs, rhs, rhs, mosek.boundkey.up);
  
    def _task_1var_1putboundlist_1ra__3I_3D_3D(self,idxs, lb, ub):
      self.__task_putvarboundlist( idxs, lb, ub, mosek.boundkey.ra);
  
    def _task_1var_1putboundlist_1fr__3I(self,idxs):
      self.__task_putvarboundlist( idxs, None, None, mosek.boundkey.fr);
  
    def _task_1var_1putintlist__3I(self,idxs):
      self.__task.putvartypelist(idxs,[mosek.variabletype.type_int] * len(idxs))
    def _task_1var_1putcontlist__3I(self,idxs):
      self.__task.putvartypelist(idxs,[mosek.variabletype.type_cont] * len(idxs))
  
  
    def _task_1task_1optimize_ (self):
      try:
        self.__task.optimize()
        if self.__logwriter is not None:
          self.__task.solutionsummary(streamtype.log)
      except mosek.Error as e:
        raise OptimizeError("Error occurred while optimizing")
  
    def __task_appendvars(self,num):
      idx = self.__task.getnumvar()
      self.__task.appendvars(num)
      return idx
  
    def __task_appendcons(self,num):
      idx = self.__task.getnumcon()
      self.__task.appendcons(num)
      return idx
  
    def _task_1append_1var_I(self,num):
      return self.__task_appendvars(num)
  
    def _task_1append_1con_I(self,num):
      return self.__task_appendcons(num)
  
    # def _task_1append_1zerocones_I(self, numcone):
    #   self.__task.appendconesseq([mosek.conetype.zero for i in range(numcone)], numpy.zeros(numcone),numpy.zeros(numcone,int), 0)
  
    # def _task_1clear_1cones__3I(self, idxs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.zero, 0.0, 0,[])
  
    # def _task_1put_1zerocones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.zero, 0.0, membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1quadcones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.quad, 0.0, membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1rquadcones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.rquad, 0.0, membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1pexpcones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.pexp, 0.0, membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1ppowcones__3III_3I_3D(self, idxs, conesize, numcone, membs, alpha):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.ppow, alpha[i], membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1dexpcones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.dexp, 0.0, membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1dpowcones__3III_3I_3D(self, idxs, conesize, numcone, membs, alpha):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.dpow, alpha[i], membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1onenormcones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.onenrm, 0.0, membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1infnormcones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.infnrm, 0.0, membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1pgeomeancones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.pgeomean, 0.0, membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1dgeomeancones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.dgeomean, 0.0, membs[i*conesize:(i+1)*conesize])
  
    def _task_1putarowlist__3I_3J_3I_3D(self,sub, ptrb, subj, cof):
      num   = len(sub)
      self.__task.putarowlist(sub, ptrb[:-1], ptrb[1:], subj, cof);
  
    def _task_1cleararowlist__3I(self,sub):
      num  = len(sub)
      ptr = numpy.zeros(num,dtype=numpy.int64)
      self.__task.putarowlist(sub, ptr, ptr, numpy.zeros(0,dtype=numpy.int32), numpy.zeros(0,dtype=numpy.float64))
  
      # This is probably awfully slow
      nnz   = self.__task.getnumbaranz()
      if nnz > 0:
        idxij = numpy.zeros(nnz,dtype=numpy.int64)
        self.__task.getbarasparsity(idxij)
        sub = set(sub)
        for idx in idxij:
          i,j = self.__task.getbaraidxij(idx)
          if i in sub:
            self.__task.putbaraij(i,j,[],[])
  
    def _task_1clearacollist__3I(self,sub):
      num  = len(sub)
      ptr = numpy.zeros(num,dtype=numpy.int64)
      self.__task.putacollist(sub, ptr, ptr, numpy.zeros(0,dtype=numpy.int32), numpy.zeros(0,dtype=numpy.float64))
  
    def _task_1putaijlist__3I_3I_3DJ(self,subi,subj,cof,num):
      self.__task.putaijlist(subi[:num],subj[:num],cof[:num])
  
    def _task_1putobjectivename_S(self,name):
      self.__task.putobjname("" if name is None else name)
  
    def _task_1putobjective_Z_3I_3DD(self,maximize,subj,cof,cfix):
      c = numpy.zeros(self.__task.getnumvar(),numpy.float64)
      idxs = numpy.arange(0,len(c),dtype=numpy.int32)
      for i in range(len(subj)):
        c[subj[i]] += cof[i]
      self.__task.putclist(idxs,c)
      self.__task.putcfix(cfix)
      self.__task.putobjsense(mosek.objsense.maximize if maximize else mosek.objsense.minimize)
  
    def _task_1putclist__3I_3D(self,subj,cof):
      self.__task.putclist(subj,cof)
  
  
    def _task_1appendsymmatlist__3I_3J_3I_3I_3D(self,dim,nz,subi,subj,cof):
      r = numpy.zeros(len(dim),numpy.int64)
      #print(dim,nz,"totalnz = {}, len(subi) = {},len(subj) = {}, subi = {}".format(sum(nz),len(subi),len(subj),subi))
      self.__task.appendsparsesymmatlist(dim,nz,subi,subj,cof,r)
      return r
  
    def _task_1putbarc__3I_3I_3I_3D(self,subj,subk,subl,val):
      #rint("putbarc: ",subj,subk,subl,val)
      self.__task.putbarcblocktriplet(subj,subk,subl,val)
      #self.__task.writedata("intermediate1.ptf")
  
    def _task_1putbaraijlist__3I_3I_3J(self,subi,subj,matidx):
      alpha = numpy.ones(len(subi),numpy.float64)
      ptr = numpy.arange(0,len(subi)+1,dtype=numpy.int64)
      self.__task.putbaraijlist(subi,subj,ptr[:-1],ptr[1:],matidx,alpha)
  
    def _task_1putbararowlist__3I_3J_3I_3J(self,subi,ptr,subj,matidx):
      alpha = numpy.ones(len(subj),numpy.float64)
      nummat = numpy.ones(len(subj),numpy.int64)
      self.__task.putbararowlist(subi,ptr[:-1],ptr[1:],subj,nummat,matidx,alpha)
  
  
    def _task_1barvardim_I(self,index):
      return self.__task.getdimbarvarj(index)
  
    def _task_1numbarvar_(self):
      return self.__task.getnumbarvar()
  
  
    def _task_1append_1barvar_II(self,size, num):
      res = self.__task.getnumbarvar()
      self.__task.appendbarvars([size] * num)
      return res
  
    def _task_1setnumvar_I(self,num):
      numvar = self.__task.getnumvar()
      if numvar > num:
        self.__task.removevars(range(num,numvar))
  
  
    def _task_1putxx_1slice_Emosek_4fusion_4SolutionType_2II_3D(self,whichsol,first,last,xx):
      if   whichsol == mosek_fusion_SolutionType.Interior:
        self.__task.putxxslice(mosek.soltype.itr, first,last,xx)
      elif whichsol == mosek_fusion_SolutionType.Integer:
        self.__task.putxxslice(mosek.soltype.itg, first,last,xx)
      elif whichsol == mosek_fusion_SolutionType.Basic:
        self.__task.putxxslice(mosek.soltype.bas, first,last,xx)
  
    def _task_1cleanup_IIII(self,inumvar,inumcon,inumcone,inumbarvar):
      numvar  = self.__task.getnumvar()
      numcon  = self.__task.getnumcon()
      numcone = self.__task.getnumcone()
      numbarvar = self.__task.getnumbarvar()
  
      if inumcone < numcone:
        self.__task.removecones(range(inumcone,numcone))
  
      if inumvar < numvar:
        n = numvar-inumvar
        vals = numpy.zeros((n,), numpy.float64)
        bk   = [ mosek.boundkey.fx for i in range(n) ]
        self.__task.putvarboundslice(inumvar,numvar,bk, vals, vals)
  
      if (inumcon < numcon):
        idxs = range(inumcon,numcon)
        self.__task.removecons(idxs)
  
      if (inumbarvar < numbarvar):
        self.__task.removebarvars(range(inumbarvar,numbarvar))
  
    def _task_1append_1afes_J(self,num):
      first = self.__task.getnumafe()
      self.__task.appendafes(num)
      return first
  
  
    def _task_1clearafelist__3J(self,idxs):
      self.__task.emptyafefrowlist(idxs)
      self.__task.emptyafebarfrowlist(idxs)
      self.__task.putafeglist(idxs,numpy.zeros(len(idxs),dtype=numpy.float64))
  
    def _task_1putafeflist__3J_3I_3I_3D_3D(self,idxs,ptr,subj,cof,g):
      lptr = numpy.array(ptr[:-1],dtype=numpy.int64)
      rownz = numpy.array([ptr[i+1]-ptr[i] for i in range(len(ptr)-1)],dtype=numpy.int32)
      self.__task.putafefrowlist(idxs,rownz,lptr, subj,cof)
      self.__task.putafeglist(idxs,g)
  
    # def _task_1putafebarfrowlist__3I_3J_3I_3J (self,idxs,ptr,barsubj,symmatidx):
    #     num = len(barsubj)
    #     afeidxlist = numpy.array([ idxs[i] for i in range(len(idxs)) for j in range(ptr[i],ptr[i+1]) ],dtype=numpy.int64)
    #     numtermslist = numpy.ones(num,numpy.int64)
    #     ptrtermslist = numpy.arange(num,numpy.int64)
    #     termweights = numpy.ones(num,numpy.float64)
    #     self.__task.putafebarfentrylist(afeidxlist,barsubj,numtermslist,ptrtermslist,symmatidx,termweights)
  
    def _task_1putafefijlist__3I_3I_3D (self,idxs,subj,cof):
      self.__task.putafefentrylist(numpy.array(idxs,dtype=numpy.int64),subj,cof)
    def _task_putafefglist__3I_3D(self,idxs,g):
      self.__task.putafeglist(idxs,g)
  
    def _task_1append_1accs_JI_3J_3D(self,domidx,numcone,afeidxs,g):
      domidxs = numpy.array([domidx for i in range(numcone)],dtype=numpy.int64)
      self.__task.appendaccs(domidxs,afeidxs,g)
  
    def _task_1putacclist__3J_3J_3J_3D(self,accidxs,domidxs,afeidxs,g):
      self.__task.putacclist(accidxs,domidxs,afeidxs,g)
  
  
  
    @staticmethod
    def __convertSolutionStatus(soltype,sol,status,prosta):
      pd = {
          mosek.solsta.optimal :                    mosek_fusion_SolutionStatus.Optimal,
          mosek.solsta.integer_optimal :            mosek_fusion_SolutionStatus.Optimal,
          mosek.solsta.prim_and_dual_feas :         mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.prim_feas :                  mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.dual_feas :                  mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.prim_infeas_cer :            mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.dual_infeas_cer :            mosek_fusion_SolutionStatus.Certificate,
          mosek.solsta.prim_illposed_cer :          mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.dual_illposed_cer :          mosek_fusion_SolutionStatus.IllposedCert,
      }
  
      dd = {
          mosek.solsta.optimal :                    mosek_fusion_SolutionStatus.Optimal,
          mosek.solsta.integer_optimal :            mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.prim_and_dual_feas :         mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.prim_feas :                  mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.dual_feas :                  mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.prim_infeas_cer :            mosek_fusion_SolutionStatus.Certificate,
          mosek.solsta.dual_infeas_cer :            mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.prim_illposed_cer :          mosek_fusion_SolutionStatus.IllposedCert,
          mosek.solsta.dual_illposed_cer :          mosek_fusion_SolutionStatus.Unknown,
      }
  
      psd = {
          mosek.prosta.unknown  :                   mosek_fusion_ProblemStatus.Unknown,
          mosek.prosta.prim_and_dual_feas :         mosek_fusion_ProblemStatus.PrimalAndDualFeasible,
          mosek.prosta.prim_feas :                  mosek_fusion_ProblemStatus.PrimalFeasible,
          mosek.prosta.dual_feas :                  mosek_fusion_ProblemStatus.DualFeasible,
          mosek.prosta.prim_infeas :                mosek_fusion_ProblemStatus.PrimalInfeasible,
          mosek.prosta.dual_infeas :                mosek_fusion_ProblemStatus.DualInfeasible,
          mosek.prosta.prim_and_dual_infeas :       mosek_fusion_ProblemStatus.PrimalAndDualInfeasible,
          mosek.prosta.ill_posed :                  mosek_fusion_ProblemStatus.IllPosed,
          mosek.prosta.prim_infeas_or_unbounded :   mosek_fusion_ProblemStatus.PrimalInfeasibleOrUnbounded,
        }
  
      try: sol.pstatus = pd[status]
      except KeyError: sol.pstatus = mosek_fusion_SolutionStatus.Unknown
  
      try: sol.dstatus = dd[status]
      except KeyError: sol.dstatus = mosek_fusion_SolutionStatus.Unknown
  
      try: sol.probstatus = psd[prosta]
      except KeyError: sol.probstatus = mosek_fusion_SolutionStatus.Unknown
  
  
    @staticmethod
    def _matchargs_task_1write_S(self,*args):
        return True
    def _task_1write_S(self,filename):
        self.__task.putintparam(mosek.iparam.opf_write_solutions, 1)
        #self.__task.putintparam(mosek.iparam.write_ignore_incompatible_items, 1)
        self.__task.writedata(filename)
  
    def _task_1write_1stream_SLSystem_4DataStream_2(self,ext,stream):
        exts = {
          'mps' : mosek.dataformat.mps,
          'cbf' : mosek.dataformat.cb,
          'ptf' : mosek.dataformat.ptf,
          'opf' : mosek.dataformat.op,
          'lp'  : mosek.dataformat.lp,
          'jtask'  : mosek.dataformat.json_task,
          'task'  : mosek.dataformat.task,
        }
        ct = {
          'gz' : mosek.compresstype.gzip,
          'zst' : mosek.compresstype.zstd,
        }
  
        fmt = mosek.dataformat.mps
        comptype = mosek.compresstype.none
        parts = ext.split('.')
        if len(parts) > 0: fmt = parts[0]
        if len(parts) > 1: comptype = parts[1]
  
        try:
          self.__task.putintparam(mosek.iparam.opf_write_solutions, 1)
          self.__task.writedatastream(exts.get(fmt,mosek.dataformat.mps), ct.get(comptype,mosek.compresstype.none), stream)
        except mosek.Error as e:
          raise mosek.fusion.UnexpectedError(e.msg)
  
    def _task_1write(self,filename):
      return self._writeProblem_S(filename)
  
    def _task_1get_(self):
      return self.__task
  
    def _clonetask_(self):
      return mosek.Task(self.__task)
    clonetask = _clonetask_
  
    def _task_1break_1solve_(self):
      self.__break = True
  
    def _task_1putoptserver_1host_S(self, addr):
      self.__task.putoptserverhost(addr)
  
    def _task_1analyze_1problem_I(self, detail):
      try:
        self.__task.putintparam(mosek.iparam.log_ana_pro, detail)
        self.__task.analyzeproblem(mosek.streamtype.log)
      except mosek.Error as e:
        raise mosek.fusion.UnexpectedError(e.msg)
  
    def _report_1solution__Lmosek_4fusion_4SolutionType_Emosek_4fusion_4ProblemStatus_Emosek_4fusion_4SolutionStatus_Lmosek_4fusion_4SolutionStatus_DDIIIIIZZ(
        self,
        soltype,
        prosta,
        psolsta,
        dsolsta,
        pobj,
        dobj,
        numvar,
        numcon,
        numbarelm,
        numacc,
        numaccelm,
        hasprimal,
        hasdual):
      assert False
    def _report_1solution_1get_1xx__3D  (self,v): self.__task.getxxslice(  self.__cursol,0,len(v),v)
    def _report_1solution_1get_1slx__3D (self,v): self.__task.getslxslice( self.__cursol,0,len(v),v)
    def _report_1solution_1get_1sux__3D (self,v): self.__task.getsuxslice( self.__cursol,0,len(v),v)
    def _report_1solution_1get_1xc__3D  (self,v): self.__task.getxcslice(  self.__cursol,0,len(v),v)
    def _report_1solution_1get_1slc__3D (self,v): self.__task.getslcslice( self.__cursol,0,len(v),v)
    def _report_1solution_1get_1suc__3D (self,v): self.__task.getsucslice( self.__cursol,0,len(v),v)
    def _report_1solution_1get_1barx__3D(self,v): self.__task.getbarxslice(self.__cursol,0,self.__task.getnumbarvar(),len(v),v)
    def _report_1solution_1get_1bars__3D(self,v): self.__task.getbarsslice(self.__cursol,0,self.__task.getnumbarvar(),len(v),v)
    def _report_1solution_1get_1accx__3D(self,v): self.__task.evaluateaccs(self.__cursol,v)
    def _report_1solution_1get_1accy__3D(self,v):
      ptr = 0
      numacc = self.__task.getnumacc()
      for i in range(numacc):
        accn   = self.__task.getaccn(i)
        data = numpy.zeros(accn,numpy.float64)
        self.__task.getaccdoty(self.__cursol,i,data);
        v[ptr:ptr+accn] = data
        ptr += accn
  
    def _report_1solution_1get_1accptr__3I(self,v):
      ptr = 0
      numacc = self.__task.getnumacc()
      for i in range(numacc):
        v[i] = ptr;
        ptr += self.__task.getaccn(i)
  
    #def __report_task_solution(self,mosek.soltype st, int numvar, int numcon, int numbarelm, long numacc, long numaccelm) {
    def __report_task_solution(self,st,numvar,numcon,numbarelm,numacc,numaccelm):
      pd = {
          mosek.solsta.optimal :                    mosek_fusion_SolutionStatus.Optimal,
          mosek.solsta.integer_optimal :            mosek_fusion_SolutionStatus.Optimal,
          mosek.solsta.prim_and_dual_feas :         mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.prim_feas :                  mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.dual_feas :                  mosek_fusion_SolutionStatus.Undefined,
          mosek.solsta.prim_infeas_cer :            mosek_fusion_SolutionStatus.Undefined,
          mosek.solsta.dual_infeas_cer :            mosek_fusion_SolutionStatus.Certificate,
          mosek.solsta.prim_illposed_cer :          mosek_fusion_SolutionStatus.Undefined,
          mosek.solsta.dual_illposed_cer :          mosek_fusion_SolutionStatus.IllposedCert,
          mosek.solsta.unknown :                    mosek_fusion_SolutionStatus.Unknown,
      }
  
      dd = {
          mosek.solsta.optimal :                    mosek_fusion_SolutionStatus.Optimal,
          mosek.solsta.integer_optimal :            mosek_fusion_SolutionStatus.Undefined,
          mosek.solsta.prim_and_dual_feas :         mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.prim_feas :                  mosek_fusion_SolutionStatus.Undefined,
          mosek.solsta.dual_feas :                  mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.prim_infeas_cer :            mosek_fusion_SolutionStatus.Certificate,
          mosek.solsta.dual_infeas_cer :            mosek_fusion_SolutionStatus.Undefined,
          mosek.solsta.prim_illposed_cer :          mosek_fusion_SolutionStatus.IllposedCert,
          mosek.solsta.dual_illposed_cer :          mosek_fusion_SolutionStatus.Undefined,
          mosek.solsta.unknown :                    mosek_fusion_SolutionStatus.Unknown,
      }
  
      psd = {
          mosek.prosta.unknown  :                   mosek_fusion_ProblemStatus.Unknown,
          mosek.prosta.prim_and_dual_feas :         mosek_fusion_ProblemStatus.PrimalAndDualFeasible,
          mosek.prosta.prim_feas :                  mosek_fusion_ProblemStatus.PrimalFeasible,
          mosek.prosta.dual_feas :                  mosek_fusion_ProblemStatus.DualFeasible,
          mosek.prosta.prim_infeas :                mosek_fusion_ProblemStatus.PrimalInfeasible,
          mosek.prosta.dual_infeas :                mosek_fusion_ProblemStatus.DualInfeasible,
          mosek.prosta.prim_and_dual_infeas :       mosek_fusion_ProblemStatus.PrimalAndDualInfeasible,
          mosek.prosta.ill_posed :                  mosek_fusion_ProblemStatus.IllPosed,
          mosek.prosta.prim_infeas_or_unbounded :   mosek_fusion_ProblemStatus.PrimalInfeasibleOrUnbounded,
        }
  
  
      solsta = self.__task.getsolsta(st)
      prosta = self.__task.getprosta(st)
  
      psolsta = pd[solsta]
      dsolsta = dd[solsta]
  
      # Special unconditional cases for integer solution:
      if st == mosek.soltype.itg:
        dsolsta = mosek_fusion_SolutionStatus.Undefined
        if prosta == mosek.prosta.prim_infeas:
          psolsta = mosek_fusion_SolutionStatus.Undefined
  
      hasprimal = psolsta != mosek_fusion_SolutionStatus.Undefined
      hasdual   = dsolsta != mosek_fusion_SolutionStatus.Undefined
  
      pobj   = self.__task.getprimalobj(st) if hasprimal else 0.0
      dobj   = self.__task.getdualobj(st) if hasdual else 0.0
  
      ps = psd[prosta]
  
      if   st == mosek.soltype.bas: soltp = mosek_fusion_SolutionType.Basic
      elif st == mosek.soltype.itr: soltp = mosek_fusion_SolutionType.Interior
      elif st == mosek.soltype.itg: soltp = mosek_fusion_SolutionType.Integer
  
      self.__cursol = st
      self._report_1solution_Emosek_4fusion_4SolutionType_2Emosek_4fusion_4ProblemStatus_2Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4SolutionStatus_2DDIIIIIZZ(
        soltp,ps,psolsta,dsolsta,pobj,dobj,numvar,numcon,numbarelm,numacc,numaccelm,hasprimal,hasdual)
  
  
  
  
    @classmethod
    def _env_1solve_1batch_ZDI_3Lmosek_4fusion_4Model_2(self,israce,timelimit,numthreads,models):
      n = len(models)
      tasks = [_m.getTask() for _m in models]
      res = [mosek.rescode.err_unknown] * n
      trm = [mosek.rescode.err_unknown] * n
      ok = False
      try:
        BaseModel._globalEnv().optimizebatch(israce,          # israce
                                             timelimit,       # timelimit
                                             numthreads,      # numthread
                                             tasks,
                                             trm,
                                             res)
        ok = True
      except mosek.Error as e:
        raise mosek_fusion_OptimizeError(str(e))
      finally:
        if not ok: # means exception, post-solve won't be called
          for _m in models:
            _m._sol_itr = None
            _m._sol_bas = None
            _m._sol_itg = None
  
      return [mosek_fusion_SolverStatus.Error if res[i]!=mosek.rescode.ok else mosek_fusion_SolverStatus.LostRace if trm[i]==mosek.rescode.trm_lost_race else mosek_fusion_SolverStatus.OK for i in range(n)]
  
    @staticmethod
    def _matchargs_task_1solve_(self,*args):
      return True
    def _task_1solve_ZSS(self, remote, server, port):
      task = self.__task
      ok = False
      try:
        trmcode = mosek.rescode.ok
        try:
          self.__break = False
          if remote:
            trmcode = task.optimizermt(server, port)
          else:
            trmcode = task.optimize()
          task.solutionsummary(mosek.streamtype.log)
          ok = True
        except mosek.Error as e:
          raise mosek_fusion_OptimizeError(str(e))
      finally:
        if not ok: # means exception, post-solve won't be called
          self._sol_itr = None
          self._sol_bas = None
          self._sol_itg = None
  
    def _task_1post_1solve_(self):
      task = self.__task  
      numcon  = task.getnumcon()
      numvar  = task.getnumvar()
      numbarvar = task.getnumbarvar()
      barvarveclen = 0
      for j in range(numbarvar):
        barxjdim = task.getdimbarvarj(j)
        barvarveclen += barxjdim * (1+barxjdim)/2
      barvarveclen = numpy.int32(barvarveclen)
      numacc = task.getnumacc();
      numaccelm = task.getaccntot();
  
      sol_bas_def = 0 != task.solutiondef(mosek.soltype.bas)
      sol_itr_def = 0 != task.solutiondef(mosek.soltype.itr)
      sol_itg_def = 0 != task.solutiondef(mosek.soltype.itg)
  
      self._clear_1solutions_();
      if sol_itr_def:
        self.__report_task_solution(mosek.soltype.itr, numvar, numcon, barvarveclen,numacc,numaccelm)
      if sol_bas_def:
        self.__report_task_solution(mosek.soltype.bas, numvar, numcon, barvarveclen,numacc,numaccelm)
      if sol_itg_def:
        self.__report_task_solution(mosek.soltype.itg, numvar, numcon, barvarveclen,numacc,numaccelm)
  
  
    @staticmethod
    def _env_1syeig_I_3D_3D(n,a,w): BaseModel._globalEnv().syeig(n,a,w)
    @staticmethod
    def _env_1syevd_I_3D_3D(n,a,w): BaseModel._globalEnv().syevd(n,a,w)
    #@staticmethod
    #def _env_1potrf_I_3D(n,a):      BaseModel._globalEnv().potrf(n,a)
  
  
  
    def _task_1putafefrow_J_3I_3D(self,idx,subj,cof): self.__task.putafefrow(idx,subj,cof)
  
    def _task_1clearaferowlist__3I(self,idxs):
      subj = numpy.zeros(0,dtype=numpy.int32)
      val  = numpy.zeros(0,dtype=numpy.float64)
  
      for i in range(len(idxs)):
          self.__task.putafefrow(idxs[i],subj,val)
          self.__task.putafeg(idxs[i],0.0)
      raise  UnexpectedError("Not implemented: clearbarfrowlist");
  
    def _task_1putafefrowlist__3I_3I_3I_3D_3D(self,idxs,ptr,subj,cof,g):
      for i in range(len(idxs)):
          self.__task.putafefrow(idxs[i],subj[ptr[i]:ptr[i+1]],cof[ptr[i]:ptr[i+1]])
          self.__task.putafeg(idxs[i],g[i])
  
    def _task_1putafebarfrowlist__3I_3I_3I_3J (self,idxs,ptr,barsubj,symmatidx):
      num = len(barsubj);
      #print('ptr = ',ptr)
      #print('idxs = ',idxs)
      #print('barsubj = ',barsubj)
      afeidxlist   = numpy.array([idxs[i] for i in range(len(idxs)) for j in range(ptr[i],ptr[i+1])],dtype=numpy.int64)
      numtermslist = numpy.ones(num,dtype=numpy.int64)
      ptrtermslist = numpy.arange(num,dtype=numpy.int64)
      termweights  = numpy.ones(num,dtype=numpy.float64)
      #print('afeidxlist   = ',afeidxlist  )
      #print('numtermslist = ',numtermslist)
      #print('ptrtermslist = ',ptrtermslist)
      #print('termweights  = ',termweights )
  
      #print(idxs,afeidxlist,barsubj,numtermslist,ptrtermslist,symmatidx,termweights)
      #print(len(idxs),len(afeidxlist),len(barsubj),len(numtermslist),len(ptrtermslist),len(symmatidx),len(termweights))
      self.__task.putafebarfentrylist(afeidxlist,barsubj,numtermslist,ptrtermslist,symmatidx,termweights)
  
    #def _task_1putafefijlist__3I_3I_3D(self,idxs,subj,cof):
    #  raise UnexpectedError("Not implemented: putafefijlist")
  
    def _task_1putafefglist__3I_3D (self,idxs,g):
      for i,v in zip(idxs,g):
        self.__task.putafeg(i,v)
  
    def _task_1append_1accs_II_3I_3D_3I(self,domidx,numcone,afeidxs,g,accidxs):
      domidxs = numpy.array([domidx]*numcone,dtype=numpy.int32)
      lafeidxs = numpy.array(afeidxs,dtype=numpy.int64)
      firstacc = self.__task.getnumacc()
  
      for i in range(numcone):
        accidxs[i] = firstacc + i
      self.__task.appendaccs(domidxs,lafeidxs,g)
  
    def _task_1putafefrow_I_3I_3D (self,idx,subj,cof):
      self.__task.putafefrow(idx, subj, cof)
  
    def _task_1append_1domain_1quad_I     (self, conesize): return self.__task.appendquadraticconedomain(conesize)
    def _task_1append_1domain_1rquad_I    (self, conesize): return self.__task.appendrquadraticconedomain(conesize)
    def _task_1append_1domain_1pexp_      (self): return self.__task.appendprimalexpconedomain()
    def _task_1append_1domain_1dexp_      (self): return self.__task.appenddualexpconedomain()
    def _task_1append_1domain_1ppow_I_3D  (self, conesize, alpha): return self.__task.appendprimalpowerconedomain(conesize,alpha)
    def _task_1append_1domain_1ppow_1seq_II_3D(self, conesize, nleftcommon, alpha): 
      numcones = len(alpha) // nleftcommon
      return self.__task.appendprimalpowerconedomainseq(numpy.array([conesize]*numcones,dtype=numpy.int64),
                                                        numpy.array([nleftcommon]*numcones,dtype=numpy.int64),
                                                        alpha)
    def _task_1append_1domain_1dpow_I_3D  (self, conesize, alpha): return self.__task.appenddualpowerconedomain(conesize,alpha)
    def _task_1append_1domain_1dpow_1seq_II_3D(self, conesize, nleftcommon, alpha): 
      numcones = len(alpha) // nleftcommon
      return self.__task.appenddualpowerconedomainseq(numpy.array([conesize]*numcones,dtype=numpy.int64),
                                                      numpy.array([nleftcommon]*numcones,dtype=numpy.int64),
                                                      alpha)
    #def _task_1append_1domain_1onenorm_I  (self, conesize): return self.__task.appendonenormconedomain(conesize)
    #def _task_1append_1domain_1infnorm_I  (self, conesize): return self.__task.appendinfnormconedomain(conesize)
    def _task_1append_1domain_1pgeomean_I (self, conesize): return self.__task.appendprimalgeomeanconedomain(conesize)
    def _task_1append_1domain_1dgeomean_I (self, conesize): return self.__task.appenddualgeomeanconedomain(conesize)
    def _task_1append_1domain_1rpos_I     (self, conesize): return self.__task.appendrplusdomain(conesize)
    def _task_1append_1domain_1rneg_I     (self, conesize): return self.__task.appendrminusdomain(conesize)
    def _task_1append_1domain_1r_I        (self, conesize): return self.__task.appendrdomain(conesize)
    def _task_1append_1domain_1rzero_I    (self, conesize): return self.__task.appendrzerodomain(conesize)
    def _task_1append_1domain_1svec_1psd_I(self, conesize): return self.__task.appendsvecpsdconedomain(conesize)
    def _task_1append_1domain_1empty_     (self): return self.__task.appendrdomain(0)
    def __task_append_1afes(self,num):
      idx = self.__task.getnumafe()
      self.__task.appendafes(num)
      return idx
  
    def __task_appenddjcs(self,num):
      idx = self.__task.getnumdjc()
      self.__task.appenddjcs(num)
      return idx
  
    def _task_1append_1djc_J(self,num):
      return self.__task_appenddjcs(num)
  
    def _task_1putdjcslice_JJ_3J_3J_3J_3J_3D(self,first,last,numterm,termsizes,domidxlist,afeidxlist,b):
      return self.__task.putdjcslice(first,last,domidxlist,afeidxlist,b,termsizes,numterm)
  return BaseModel
mosek_fusion_BaseModel=__mk_mosek_fusion_BaseModel()
#BEFORE CLASS
def __mk_mosek_fusion_Model():
 class Model(mosek_fusion_BaseModel):
  __slots__ = ['_Model__xs','_Model__ws','_Model__rs','_Model__sol_itg','_Model__sol_bas','_Model__sol_itr','_Model__con_map','_Model__acons','_Model__cons','_Model__task_numaferow','_Model__param_value','_Model__param_num','_Model__par_map','_Model__numparameter','_Model__parameters','_Model__initsol_xx_flag','_Model__initsol_xx','_Model__var_map','_Model__barvars','_Model__vars','_Model__bfixidx','_Model__barvar_block_elm_j','_Model__barvar_block_elm_i','_Model__barvar_block_elm_barj','_Model__barvar_block_elm_ptr','_Model__barvar_block_dim','_Model__barvar_block_ptr','_Model__barvar_dim','_Model__barvar_num','_Model__var_elm_acc_ofs','_Model__var_elm_acc_idx','_Model__var_block_acc_id','_Model__var_block_map','_Model__acon_elm_afe','_Model__acon_elm_ofs','_Model__acon_elm_scale','_Model__acon_elm_accid','_Model__acon_afe','_Model__acon_acc','_Model__acon_block_map','_Model__acc_block_map','_Model__obj_blocks','_Model__afe_blocks','_Model__con_blocks','_Model__num_task_acc','_Model__num_task_afe','_Model__num_task_con','_Model__cache_evaluations','_Model__solutionptr','_Model__acceptable_sol','_Model__model_name']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_(*args):
      self._ctor_init_(*args)
    elif self.__match_alt_ctor_(*args):
      self._ctor_alt_init_(*args)
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    elif self.__match_ctor_IZ(*args):
      self._ctor_init_IZ(*args)
    elif self.__match_alt_ctor_IZ(*args):
      self._ctor_alt_init_IZ(*args)
    elif self.__match_ctor_SIZ(*args):
      self._ctor_init_SIZ(*args)
    elif self.__match_alt_ctor_SIZ(*args):
      self._ctor_alt_init_SIZ(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.Model.ctor()\n\tmosek.fusion.Model.ctor(string)\n\tmosek.fusion.Model.ctor(int32,bool)\n\tmosek.fusion.Model.ctor(string,int32,bool)')
  def solve(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.solve()
      mosek.fusion.Model.solve(string,string)

    Description
    -----------

    Attempt to optimize the model.

    Parameters
    ----------

    accesstoken : string
        Access token if optimizing remotely with authentication.
    addr : string
        Address of the |optserver| if optimizing remotely. It should be a valid URL, for example ``http://server:port`` or ``https://server:port``.
    '''
    if False: pass
    elif mosek_fusion_Model._match_solve_(*args):
      return self._solve_(*args)
    elif mosek_fusion_Model._match_alt_solve_(*args):
      return self._solve_alt_(*args)
    elif mosek_fusion_Model._match_solve_SS(*args):
      return self._solve_SS(*args)
    elif mosek_fusion_Model._match_alt_solve_SS(*args):
      return self._solve_alt_SS(*args)
    else:
      raise ValueError('Invalid argument list solve('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.solve()\n\tmosek.fusion.Model.solve(string,string)')
  def getSolverLIntInfo(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getSolverLIntInfo(string)

    Description
    -----------

    Fetch a solution information item from the solver 

    Parameters
    ----------

    name : string
    '''
    if False: pass
    elif mosek_fusion_Model._match_getSolverLIntInfo_S(*args):
      return self._getSolverLIntInfo_S(*args)
    elif mosek_fusion_Model._match_alt_getSolverLIntInfo_S(*args):
      return self._getSolverLIntInfo_alt_S(*args)
    else:
      raise ValueError('Invalid argument list getSolverLIntInfo('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getSolverLIntInfo(string)')
  def getConstraintDuals(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getConstraintDuals(bool,array(int32,ndim=1),array(double,ndim=1),int32)

    Description
    -----------

    

    Parameters
    ----------

    lower : bool
    nativeidxs : array(int32,ndim=1)
    offset : int32
    res : array(double,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Model._match_getConstraintDuals_Z_3I_3DI(*args):
      return self._getConstraintDuals_Z_3I_3DI(*args)
    elif mosek_fusion_Model._match_alt_getConstraintDuals_Z_3I_3DI(*args):
      return self._getConstraintDuals_alt_Z_3I_3DI(*args)
    else:
      raise ValueError('Invalid argument list getConstraintDuals('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getConstraintDuals(bool,array(int32,ndim=1),array(double,ndim=1),int32)')
  @staticmethod
  def putlicensepath(*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.putlicensepath(string)

    Description
    -----------

    Set the license path in the global environment. 

    Parameters
    ----------

    licfile : string
    '''
    if False: pass
    elif mosek_fusion_Model._match_putlicensepath_S(*args):
      return mosek_fusion_Model._putlicensepath_S(*args)
    elif mosek_fusion_Model._match_alt_putlicensepath_S(*args):
      return mosek_fusion_Model._putlicensepath_alt_S(*args)
    else:
      raise ValueError('Invalid argument list putlicensepath('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.putlicensepath(string)')
  def primalObjValue(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.primalObjValue()

    Description
    -----------

    Get the primal objective value in the current solution.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Model._match_primalObjValue_(*args):
      return self._primalObjValue_(*args)
    elif mosek_fusion_Model._match_alt_primalObjValue_(*args):
      return self._primalObjValue_alt_(*args)
    else:
      raise ValueError('Invalid argument list primalObjValue('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.primalObjValue()')
  def getVariableDuals(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getVariableDuals(bool,array(int64,ndim=1),array(double,ndim=1),int32)

    Description
    -----------

    

    Parameters
    ----------

    lower : bool
    nativeidxs : array(int64,ndim=1)
    offset : int32
    res : array(double,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Model._match_getVariableDuals_Z_3J_3DI(*args):
      return self._getVariableDuals_Z_3J_3DI(*args)
    elif mosek_fusion_Model._match_alt_getVariableDuals_Z_3J_3DI(*args):
      return self._getVariableDuals_alt_Z_3J_3DI(*args)
    else:
      raise ValueError('Invalid argument list getVariableDuals('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getVariableDuals(bool,array(int64,ndim=1),array(double,ndim=1),int32)')
  def getSolverDoubleInfo(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getSolverDoubleInfo(string)

    Description
    -----------

    Fetch a solution information item from the solver 

    Parameters
    ----------

    name : string
    '''
    if False: pass
    elif mosek_fusion_Model._match_getSolverDoubleInfo_S(*args):
      return self._getSolverDoubleInfo_S(*args)
    elif mosek_fusion_Model._match_alt_getSolverDoubleInfo_S(*args):
      return self._getSolverDoubleInfo_alt_S(*args)
    else:
      raise ValueError('Invalid argument list getSolverDoubleInfo('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getSolverDoubleInfo(string)')
  def breakSolver(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.breakSolver()

    Description
    -----------

    Request that the solver terminates as soon as possible. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Model._match_breakSolver_(*args):
      return self._breakSolver_(*args)
    elif mosek_fusion_Model._match_alt_breakSolver_(*args):
      return self._breakSolver_alt_(*args)
    else:
      raise ValueError('Invalid argument list breakSolver('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.breakSolver()')
  def optserverHost(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.optserverHost(string)

    Description
    -----------

    Specify an OptServer for remote calls.

    Parameters
    ----------

    addr : string
        Address of the |optserver|. It should be a valid URL, for example ``http://server:port`` or ``https://server:port``.
    '''
    if False: pass
    elif mosek_fusion_Model._match_optserverHost_S(*args):
      return self._optserverHost_S(*args)
    elif mosek_fusion_Model._match_alt_optserverHost_S(*args):
      return self._optserverHost_alt_S(*args)
    else:
      raise ValueError('Invalid argument list optserverHost('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.optserverHost(string)')
  def writeTaskStream(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.writeTaskStream(string,System.DataStream)

    Description
    -----------

    Write the current solver task to a stream.

    Parameters
    ----------

    ext : string
    stream : System.DataStream
    '''
    if False: pass
    elif mosek_fusion_Model._match_writeTaskStream_SLSystem_4DataStream_2(*args):
      return self._writeTaskStream_SLSystem_4DataStream_2(*args)
    elif mosek_fusion_Model._match_alt_writeTaskStream_SLSystem_4DataStream_2(*args):
      return self._writeTaskStream_alt_SLSystem_4DataStream_2(*args)
    else:
      raise ValueError('Invalid argument list writeTaskStream('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.writeTaskStream(string,System.DataStream)')
  def writeTask(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.writeTask(string)

    Description
    -----------

    Dump the current solver task to a file.

    Parameters
    ----------

    filename : string
    '''
    if False: pass
    elif mosek_fusion_Model._match_writeTask_S(*args):
      return self._writeTask_S(*args)
    elif mosek_fusion_Model._match_alt_writeTask_S(*args):
      return self._writeTask_alt_S(*args)
    else:
      raise ValueError('Invalid argument list writeTask('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.writeTask(string)')
  def getDualSolutionStatus(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getDualSolutionStatus()
      mosek.fusion.Model.getDualSolutionStatus(mosek.fusion.SolutionType)

    Description
    -----------

    Return the dual solution status.

    Parameters
    ----------

    which : mosek.fusion.SolutionType
    '''
    if False: pass
    elif mosek_fusion_Model._match_getDualSolutionStatus_(*args):
      return self._getDualSolutionStatus_(*args)
    elif mosek_fusion_Model._match_alt_getDualSolutionStatus_(*args):
      return self._getDualSolutionStatus_alt_(*args)
    elif mosek_fusion_Model._match_getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
      return self._getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(*args)
    elif mosek_fusion_Model._match_alt_getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
      return self._getDualSolutionStatus_alt_Emosek_4fusion_4SolutionType_2(*args)
    else:
      raise ValueError('Invalid argument list getDualSolutionStatus('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getDualSolutionStatus()\n\tmosek.fusion.Model.getDualSolutionStatus(mosek.fusion.SolutionType)')
  def dispose(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.dispose()

    Description
    -----------

    Destroy the Model object 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Model._match_dispose_(*args):
      return self._dispose_(*args)
    elif mosek_fusion_Model._match_alt_dispose_(*args):
      return self._dispose_alt_(*args)
    else:
      raise ValueError('Invalid argument list dispose('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.dispose()')
  def flushParameters(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.flushParameters()

    Description
    -----------

    
    Flush all parameters to the underlying task.
            

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Model._match_flushParameters_(*args):
      return self._flushParameters_(*args)
    elif mosek_fusion_Model._match_alt_flushParameters_(*args):
      return self._flushParameters_alt_(*args)
    else:
      raise ValueError('Invalid argument list flushParameters('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.flushParameters()')
  def selectedSolution(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.selectedSolution(mosek.fusion.SolutionType)

    Description
    -----------

    Chooses a solution.

    Parameters
    ----------

    soltype : mosek.fusion.SolutionType
    '''
    if False: pass
    elif mosek_fusion_Model._match_selectedSolution_Emosek_4fusion_4SolutionType_2(*args):
      return self._selectedSolution_Emosek_4fusion_4SolutionType_2(*args)
    elif mosek_fusion_Model._match_alt_selectedSolution_Emosek_4fusion_4SolutionType_2(*args):
      return self._selectedSolution_alt_Emosek_4fusion_4SolutionType_2(*args)
    else:
      raise ValueError('Invalid argument list selectedSolution('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.selectedSolution(mosek.fusion.SolutionType)')
  def setVariableValues(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.setVariableValues(bool,array(int64,ndim=1),array(double,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    nativeidxs : array(int64,ndim=1)
    primal : bool
    values : array(double,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Model._match_setVariableValues_Z_3J_3D(*args):
      return self._setVariableValues_Z_3J_3D(*args)
    elif mosek_fusion_Model._match_alt_setVariableValues_Z_3J_3D(*args):
      return self._setVariableValues_alt_Z_3J_3D(*args)
    else:
      raise ValueError('Invalid argument list setVariableValues('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.setVariableValues(bool,array(int64,ndim=1),array(double,ndim=1))')
  @staticmethod
  def solveBatch(*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.solveBatch(bool,double,int32,array(mosek.fusion.Model,ndim=1))

    Description
    -----------

    Attempt to optimize a collection of models in parallel.

    Parameters
    ----------

    israce : bool
        If true, then the function is terminated after the first model completed.
    maxtime : double
        Time limit: if nonnegative, then the function is terminated after this time (seconds).
    models : array(mosek.fusion.Model,ndim=1)
        An array of models to be solved.
    numthreads : int32
        The number of threads for the whole pool available to all models. If set to 0 the number of threads used will be equal to the number of cores detected on the machine.
    '''
    if False: pass
    elif mosek_fusion_Model._match_solveBatch_ZDI_3Lmosek_4fusion_4Model_2(*args):
      return mosek_fusion_Model._solveBatch_ZDI_3Lmosek_4fusion_4Model_2(*args)
    elif mosek_fusion_Model._match_alt_solveBatch_ZDI_3Lmosek_4fusion_4Model_2(*args):
      return mosek_fusion_Model._solveBatch_alt_ZDI_3Lmosek_4fusion_4Model_2(*args)
    else:
      raise ValueError('Invalid argument list solveBatch('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.solveBatch(bool,double,int32,array(mosek.fusion.Model,ndim=1))')
  def dualObjValue(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.dualObjValue()

    Description
    -----------

    Get the dual objective value in the current solution.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Model._match_dualObjValue_(*args):
      return self._dualObjValue_(*args)
    elif mosek_fusion_Model._match_alt_dualObjValue_(*args):
      return self._dualObjValue_alt_(*args)
    else:
      raise ValueError('Invalid argument list dualObjValue('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.dualObjValue()')
  def objective(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.objective(double)
      mosek.fusion.Model.objective(string,double)
      mosek.fusion.Model.objective(mosek.fusion.ObjectiveSense,double)
      mosek.fusion.Model.objective(mosek.fusion.ObjectiveSense,mosek.fusion.Expression)
      mosek.fusion.Model.objective(string,mosek.fusion.ObjectiveSense,double)
      mosek.fusion.Model.objective(string,mosek.fusion.ObjectiveSense,mosek.fusion.Expression)

    Description
    -----------

    Replace the objective expression.

    Parameters
    ----------

    c : double
        A constant scalar. 
    expr : mosek.fusion.Expression
        The objective expression. This must be an affine expression that evaluates to a scalar. 
    name : string
        Name of the objective. This may be any string, and it has no function except when writing the problem to an external file format.
    sense : mosek.fusion.ObjectiveSense
        The objective sense. Defines whether the objective must be minimized or maximized.
    '''
    if False: pass
    elif mosek_fusion_Model._match_objective_D(*args):
      return self._objective_D(*args)
    elif mosek_fusion_Model._match_alt_objective_D(*args):
      return self._objective_alt_D(*args)
    elif mosek_fusion_Model._match_objective_SD(*args):
      return self._objective_SD(*args)
    elif mosek_fusion_Model._match_alt_objective_SD(*args):
      return self._objective_alt_SD(*args)
    elif mosek_fusion_Model._match_objective_Emosek_4fusion_4ObjectiveSense_2D(*args):
      return self._objective_Emosek_4fusion_4ObjectiveSense_2D(*args)
    elif mosek_fusion_Model._match_alt_objective_Emosek_4fusion_4ObjectiveSense_2D(*args):
      return self._objective_alt_Emosek_4fusion_4ObjectiveSense_2D(*args)
    elif mosek_fusion_Model._match_objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
      return self._objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_Model._match_alt_objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
      return self._objective_alt_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_Model._match_objective_SEmosek_4fusion_4ObjectiveSense_2D(*args):
      return self._objective_SEmosek_4fusion_4ObjectiveSense_2D(*args)
    elif mosek_fusion_Model._match_alt_objective_SEmosek_4fusion_4ObjectiveSense_2D(*args):
      return self._objective_alt_SEmosek_4fusion_4ObjectiveSense_2D(*args)
    elif mosek_fusion_Model._match_objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
      return self._objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_Model._match_alt_objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
      return self._objective_alt_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args)
    else:
      raise ValueError('Invalid argument list objective('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.objective(double)\n\tmosek.fusion.Model.objective(string,double)\n\tmosek.fusion.Model.objective(mosek.fusion.ObjectiveSense,double)\n\tmosek.fusion.Model.objective(mosek.fusion.ObjectiveSense,mosek.fusion.Expression)\n\tmosek.fusion.Model.objective(string,mosek.fusion.ObjectiveSense,double)\n\tmosek.fusion.Model.objective(string,mosek.fusion.ObjectiveSense,mosek.fusion.Expression)')
  def getVariableValues(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getVariableValues(bool,array(int64,ndim=1),array(double,ndim=1),int32)

    Description
    -----------

    

    Parameters
    ----------

    nativeidxs : array(int64,ndim=1)
    offset : int32
    primal : bool
    res : array(double,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Model._match_getVariableValues_Z_3J_3DI(*args):
      return self._getVariableValues_Z_3J_3DI(*args)
    elif mosek_fusion_Model._match_alt_getVariableValues_Z_3J_3DI(*args):
      return self._getVariableValues_alt_Z_3J_3DI(*args)
    else:
      raise ValueError('Invalid argument list getVariableValues('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getVariableValues(bool,array(int64,ndim=1),array(double,ndim=1),int32)')
  def getPrimalSolutionStatus(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getPrimalSolutionStatus()
      mosek.fusion.Model.getPrimalSolutionStatus(mosek.fusion.SolutionType)

    Description
    -----------

    Return the primal solution status.

    Parameters
    ----------

    which : mosek.fusion.SolutionType
    '''
    if False: pass
    elif mosek_fusion_Model._match_getPrimalSolutionStatus_(*args):
      return self._getPrimalSolutionStatus_(*args)
    elif mosek_fusion_Model._match_alt_getPrimalSolutionStatus_(*args):
      return self._getPrimalSolutionStatus_alt_(*args)
    elif mosek_fusion_Model._match_getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
      return self._getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(*args)
    elif mosek_fusion_Model._match_alt_getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
      return self._getPrimalSolutionStatus_alt_Emosek_4fusion_4SolutionType_2(*args)
    else:
      raise ValueError('Invalid argument list getPrimalSolutionStatus('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getPrimalSolutionStatus()\n\tmosek.fusion.Model.getPrimalSolutionStatus(mosek.fusion.SolutionType)')
  def setCallbackHandler(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.setCallbackHandler(System.CallbackHandler)

    Description
    -----------

    Attach a progress callback handler. 

    Parameters
    ----------

    h : System.CallbackHandler
    '''
    if False: pass
    elif mosek_fusion_Model._match_setCallbackHandler_LSystem_4CallbackHandler_2(*args):
      return self._setCallbackHandler_LSystem_4CallbackHandler_2(*args)
    elif mosek_fusion_Model._match_alt_setCallbackHandler_LSystem_4CallbackHandler_2(*args):
      return self._setCallbackHandler_alt_LSystem_4CallbackHandler_2(*args)
    else:
      raise ValueError('Invalid argument list setCallbackHandler('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.setCallbackHandler(System.CallbackHandler)')
  @staticmethod
  def putlicensecode(*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.putlicensecode(array(int32,ndim=1))

    Description
    -----------

    Set the license code in the global environment. 

    Parameters
    ----------

    code : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Model._match_putlicensecode__3I(*args):
      return mosek_fusion_Model._putlicensecode__3I(*args)
    elif mosek_fusion_Model._match_alt_putlicensecode__3I(*args):
      return mosek_fusion_Model._putlicensecode_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list putlicensecode('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.putlicensecode(array(int32,ndim=1))')
  def dataReport(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.dataReport()
      mosek.fusion.Model.dataReport(int32)

    Description
    -----------

    Print out a report about problem data.

    Parameters
    ----------

    detail : int32
        The amount of detail to include, where 0 means nothing and 10 is full. If not provided then a full report is printed.
    '''
    if False: pass
    elif mosek_fusion_Model._match_dataReport_(*args):
      return self._dataReport_(*args)
    elif mosek_fusion_Model._match_alt_dataReport_(*args):
      return self._dataReport_alt_(*args)
    elif mosek_fusion_Model._match_dataReport_I(*args):
      return self._dataReport_I(*args)
    elif mosek_fusion_Model._match_alt_dataReport_I(*args):
      return self._dataReport_alt_I(*args)
    else:
      raise ValueError('Invalid argument list dataReport('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.dataReport()\n\tmosek.fusion.Model.dataReport(int32)')
  def getConstraint(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getConstraint(string)
      mosek.fusion.Model.getConstraint(int32)

    Description
    -----------

    Get the constraint matching the given name or linear index. 

    Parameters
    ----------

    index : int32
        The constraint's linear index.
    name : string
        The constraint's name.
    '''
    if False: pass
    elif mosek_fusion_Model._match_getConstraint_S(*args):
      return self._getConstraint_S(*args)
    elif mosek_fusion_Model._match_alt_getConstraint_S(*args):
      return self._getConstraint_alt_S(*args)
    elif mosek_fusion_Model._match_getConstraint_I(*args):
      return self._getConstraint_I(*args)
    elif mosek_fusion_Model._match_alt_getConstraint_I(*args):
      return self._getConstraint_alt_I(*args)
    else:
      raise ValueError('Invalid argument list getConstraint('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getConstraint(string)\n\tmosek.fusion.Model.getConstraint(int32)')
  def getName(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getName()

    Description
    -----------

    Return the model name, or an empty string if it has not been set.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Model._match_getName_(*args):
      return self._getName_(*args)
    elif mosek_fusion_Model._match_alt_getName_(*args):
      return self._getName_alt_(*args)
    else:
      raise ValueError('Invalid argument list getName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getName()')
  def parameter(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.parameter()
      mosek.fusion.Model.parameter(string)
      mosek.fusion.Model.parameter(int32)
      mosek.fusion.Model.parameter(array(int32,ndim=1))
      mosek.fusion.Model.parameter(string,int32)
      mosek.fusion.Model.parameter(array(int32,ndim=1),array(int64,ndim=1))
      mosek.fusion.Model.parameter(int32,int32)
      mosek.fusion.Model.parameter(array(int32,ndim=1),array(int32,ndim=2))
      mosek.fusion.Model.parameter(string,array(int32,ndim=1))
      mosek.fusion.Model.parameter(string,array(int32,ndim=1),array(int64,ndim=1))
      mosek.fusion.Model.parameter(int32,int32,int32)
      mosek.fusion.Model.parameter(string,array(int32,ndim=1),array(int32,ndim=2))
      mosek.fusion.Model.parameter(string,int32,int32)
      mosek.fusion.Model.parameter(string,int32,int32,int32)

    Description
    -----------

    Create a new parameter in the model. 

    Parameters
    ----------

    d1 : int32
        First dimension of a parameter.
    d2 : int32
        Second dimension of a parameter.
    d3 : int32
        Third dimension of a parameter.
    name : string
        Name of the parameter.
    shape : array(int32,ndim=1)
        Shape of the parameter.
    sp : array(int64,ndim=1)
        Non-zero sparsity pattern as a list of linear indexes, if the parameter is sparse.
    sparsity : array(int32,ndim=2)
        Non-zero sparsity pattern, if the parameter is sparse.
    '''
    if False: pass
    elif mosek_fusion_Model._match_parameter_(*args):
      return self._parameter_(*args)
    elif mosek_fusion_Model._match_alt_parameter_(*args):
      return self._parameter_alt_(*args)
    elif mosek_fusion_Model._match_parameter_S(*args):
      return self._parameter_S(*args)
    elif mosek_fusion_Model._match_alt_parameter_S(*args):
      return self._parameter_alt_S(*args)
    elif mosek_fusion_Model._match_parameter_I(*args):
      return self._parameter_I(*args)
    elif mosek_fusion_Model._match_alt_parameter_I(*args):
      return self._parameter_alt_I(*args)
    elif mosek_fusion_Model._match_parameter__3I(*args):
      return self._parameter__3I(*args)
    elif mosek_fusion_Model._match_alt_parameter__3I(*args):
      return self._parameter_alt__3I(*args)
    elif mosek_fusion_Model._match_parameter_SI(*args):
      return self._parameter_SI(*args)
    elif mosek_fusion_Model._match_alt_parameter_SI(*args):
      return self._parameter_alt_SI(*args)
    elif mosek_fusion_Model._match_parameter__3I_3J(*args):
      return self._parameter__3I_3J(*args)
    elif mosek_fusion_Model._match_alt_parameter__3I_3J(*args):
      return self._parameter_alt__3I_3J(*args)
    elif mosek_fusion_Model._match_parameter_II(*args):
      return self._parameter_II(*args)
    elif mosek_fusion_Model._match_alt_parameter_II(*args):
      return self._parameter_alt_II(*args)
    elif mosek_fusion_Model._match_parameter__3I_3_5I(*args):
      return self._parameter__3I_3_5I(*args)
    elif mosek_fusion_Model._match_alt_parameter__3I_3_5I(*args):
      return self._parameter_alt__3I_3_5I(*args)
    elif mosek_fusion_Model._match_parameter_S_3I(*args):
      return self._parameter_S_3I(*args)
    elif mosek_fusion_Model._match_alt_parameter_S_3I(*args):
      return self._parameter_alt_S_3I(*args)
    elif mosek_fusion_Model._match_parameter_S_3I_3J(*args):
      return self._parameter_S_3I_3J(*args)
    elif mosek_fusion_Model._match_alt_parameter_S_3I_3J(*args):
      return self._parameter_alt_S_3I_3J(*args)
    elif mosek_fusion_Model._match_parameter_III(*args):
      return self._parameter_III(*args)
    elif mosek_fusion_Model._match_alt_parameter_III(*args):
      return self._parameter_alt_III(*args)
    elif mosek_fusion_Model._match_parameter_S_3I_3_5I(*args):
      return self._parameter_S_3I_3_5I(*args)
    elif mosek_fusion_Model._match_alt_parameter_S_3I_3_5I(*args):
      return self._parameter_alt_S_3I_3_5I(*args)
    elif mosek_fusion_Model._match_parameter_SII(*args):
      return self._parameter_SII(*args)
    elif mosek_fusion_Model._match_alt_parameter_SII(*args):
      return self._parameter_alt_SII(*args)
    elif mosek_fusion_Model._match_parameter_SIII(*args):
      return self._parameter_SIII(*args)
    elif mosek_fusion_Model._match_alt_parameter_SIII(*args):
      return self._parameter_alt_SIII(*args)
    else:
      raise ValueError('Invalid argument list parameter('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.parameter()\n\tmosek.fusion.Model.parameter(string)\n\tmosek.fusion.Model.parameter(int32)\n\tmosek.fusion.Model.parameter(array(int32,ndim=1))\n\tmosek.fusion.Model.parameter(string,int32)\n\tmosek.fusion.Model.parameter(array(int32,ndim=1),array(int64,ndim=1))\n\tmosek.fusion.Model.parameter(int32,int32)\n\tmosek.fusion.Model.parameter(array(int32,ndim=1),array(int32,ndim=2))\n\tmosek.fusion.Model.parameter(string,array(int32,ndim=1))\n\tmosek.fusion.Model.parameter(string,array(int32,ndim=1),array(int64,ndim=1))\n\tmosek.fusion.Model.parameter(int32,int32,int32)\n\tmosek.fusion.Model.parameter(string,array(int32,ndim=1),array(int32,ndim=2))\n\tmosek.fusion.Model.parameter(string,int32,int32)\n\tmosek.fusion.Model.parameter(string,int32,int32,int32)')
  def clone(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.clone()

    Description
    -----------

    Return a copy of the model.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Model._match_clone_(*args):
      return self._clone_(*args)
    elif mosek_fusion_Model._match_alt_clone_(*args):
      return self._clone_alt_(*args)
    else:
      raise ValueError('Invalid argument list clone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.clone()')
  def constraint(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.constraint(mosek.fusion.ExprRangeDomain)
      mosek.fusion.Model.constraint(mosek.fusion.ExprConicDomain)
      mosek.fusion.Model.constraint(mosek.fusion.ExprPSDDomain)
      mosek.fusion.Model.constraint(mosek.fusion.ExprLinearDomain)
      mosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.ConeDomain)
      mosek.fusion.Model.constraint(string,mosek.fusion.ExprLinearDomain)
      mosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.PSDDomain)
      mosek.fusion.Model.constraint(string,mosek.fusion.ExprPSDDomain)
      mosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.RangeDomain)
      mosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.LinearDomain)
      mosek.fusion.Model.constraint(string,mosek.fusion.ExprRangeDomain)
      mosek.fusion.Model.constraint(string,mosek.fusion.ExprConicDomain)
      mosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.RangeDomain)
      mosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.LinearDomain)
      mosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.PSDDomain)
      mosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.ConeDomain)

    Description
    -----------

    Create a new constraint in the model. 

    Parameters
    ----------

    expr : mosek.fusion.Expression
        An expression. 
    exprdom : mosek.fusion.ExprConicDomain
    ldom : mosek.fusion.LinearDomain
        
        A linear domain.
                  
    name : string
        
        Name of the constraint. This must be unique among all constraints in
        the model. The value |null| is allowed instead of a unique name.
                  
    psddom : mosek.fusion.PSDDomain
        
        A positive semidefinte domain.
    qdom : mosek.fusion.ConeDomain
        
        A domain in a cone.
    rdom : mosek.fusion.RangeDomain
        
        A ranged domain.
    '''
    if False: pass
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4ExprRangeDomain_2(*args):
      return self._constraint_Lmosek_4fusion_4ExprRangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4ExprRangeDomain_2(*args):
      return self._constraint_alt_Lmosek_4fusion_4ExprRangeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4ExprConicDomain_2(*args):
      return self._constraint_Lmosek_4fusion_4ExprConicDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4ExprConicDomain_2(*args):
      return self._constraint_alt_Lmosek_4fusion_4ExprConicDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4ExprPSDDomain_2(*args):
      return self._constraint_Lmosek_4fusion_4ExprPSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4ExprPSDDomain_2(*args):
      return self._constraint_alt_Lmosek_4fusion_4ExprPSDDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4ExprLinearDomain_2(*args):
      return self._constraint_Lmosek_4fusion_4ExprLinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4ExprLinearDomain_2(*args):
      return self._constraint_alt_Lmosek_4fusion_4ExprLinearDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args):
      return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args):
      return self._constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4ExprLinearDomain_2(*args):
      return self._constraint_SLmosek_4fusion_4ExprLinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4ExprLinearDomain_2(*args):
      return self._constraint_alt_SLmosek_4fusion_4ExprLinearDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
      return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
      return self._constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4ExprPSDDomain_2(*args):
      return self._constraint_SLmosek_4fusion_4ExprPSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4ExprPSDDomain_2(*args):
      return self._constraint_alt_SLmosek_4fusion_4ExprPSDDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
      return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
      return self._constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
      return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
      return self._constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4ExprRangeDomain_2(*args):
      return self._constraint_SLmosek_4fusion_4ExprRangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4ExprRangeDomain_2(*args):
      return self._constraint_alt_SLmosek_4fusion_4ExprRangeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4ExprConicDomain_2(*args):
      return self._constraint_SLmosek_4fusion_4ExprConicDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4ExprConicDomain_2(*args):
      return self._constraint_alt_SLmosek_4fusion_4ExprConicDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
      return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
      return self._constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
      return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
      return self._constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
      return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
      return self._constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args):
      return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args):
      return self._constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args)
    else:
      raise ValueError('Invalid argument list constraint('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.constraint(mosek.fusion.ExprRangeDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.ExprConicDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.ExprPSDDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.ExprLinearDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.ConeDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.ExprLinearDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.ExprPSDDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.ExprRangeDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.ExprConicDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.ConeDomain)')
  def getAcceptedSolutionStatus(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getAcceptedSolutionStatus()

    Description
    -----------

    Get the accepted solution status. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Model._match_getAcceptedSolutionStatus_(*args):
      return self._getAcceptedSolutionStatus_(*args)
    elif mosek_fusion_Model._match_alt_getAcceptedSolutionStatus_(*args):
      return self._getAcceptedSolutionStatus_alt_(*args)
    else:
      raise ValueError('Invalid argument list getAcceptedSolutionStatus('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getAcceptedSolutionStatus()')
  def hasParameter(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.hasParameter(string)

    Description
    -----------

    Check whether the model contains a parameter with a given name.

    Parameters
    ----------

    name : string
        The parameter's name.
    '''
    if False: pass
    elif mosek_fusion_Model._match_hasParameter_S(*args):
      return self._hasParameter_S(*args)
    elif mosek_fusion_Model._match_alt_hasParameter_S(*args):
      return self._hasParameter_alt_S(*args)
    else:
      raise ValueError('Invalid argument list hasParameter('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.hasParameter(string)')
  def getSolverIntInfo(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getSolverIntInfo(string)

    Description
    -----------

    Fetch a solution information item from the solver 

    Parameters
    ----------

    name : string
    '''
    if False: pass
    elif mosek_fusion_Model._match_getSolverIntInfo_S(*args):
      return self._getSolverIntInfo_S(*args)
    elif mosek_fusion_Model._match_alt_getSolverIntInfo_S(*args):
      return self._getSolverIntInfo_alt_S(*args)
    else:
      raise ValueError('Invalid argument list getSolverIntInfo('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getSolverIntInfo(string)')
  def getConstraintValues(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getConstraintValues(bool,array(int32,ndim=1),array(double,ndim=1),int32)

    Description
    -----------

    

    Parameters
    ----------

    nativeidxs : array(int32,ndim=1)
    offset : int32
    primal : bool
    res : array(double,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Model._match_getConstraintValues_Z_3I_3DI(*args):
      return self._getConstraintValues_Z_3I_3DI(*args)
    elif mosek_fusion_Model._match_alt_getConstraintValues_Z_3I_3DI(*args):
      return self._getConstraintValues_alt_Z_3I_3DI(*args)
    else:
      raise ValueError('Invalid argument list getConstraintValues('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getConstraintValues(bool,array(int32,ndim=1),array(double,ndim=1),int32)')
  def hasConstraint(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.hasConstraint(string)

    Description
    -----------

    Check whether the model contains a constraint with a given name.

    Parameters
    ----------

    name : string
        The constraint name.
    '''
    if False: pass
    elif mosek_fusion_Model._match_hasConstraint_S(*args):
      return self._hasConstraint_S(*args)
    elif mosek_fusion_Model._match_alt_hasConstraint_S(*args):
      return self._hasConstraint_alt_S(*args)
    else:
      raise ValueError('Invalid argument list hasConstraint('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.hasConstraint(string)')
  def updateObjective(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.updateObjective(mosek.fusion.Expression,mosek.fusion.Variable)

    Description
    -----------

    Update part of the objective.

    Parameters
    ----------

    expr : mosek.fusion.Expression
    x : mosek.fusion.Variable
    '''
    if False: pass
    elif mosek_fusion_Model._match_updateObjective_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args):
      return self._updateObjective_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Model._match_alt_updateObjective_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args):
      return self._updateObjective_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args)
    else:
      raise ValueError('Invalid argument list updateObjective('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.updateObjective(mosek.fusion.Expression,mosek.fusion.Variable)')
  def acceptedSolutionStatus(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.acceptedSolutionStatus(mosek.fusion.AccSolutionStatus)

    Description
    -----------

    Set the accepted solution status. 

    Parameters
    ----------

    what : mosek.fusion.AccSolutionStatus
    '''
    if False: pass
    elif mosek_fusion_Model._match_acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(*args):
      return self._acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(*args)
    elif mosek_fusion_Model._match_alt_acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(*args):
      return self._acceptedSolutionStatus_alt_Emosek_4fusion_4AccSolutionStatus_2(*args)
    else:
      raise ValueError('Invalid argument list acceptedSolutionStatus('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.acceptedSolutionStatus(mosek.fusion.AccSolutionStatus)')
  def getProblemStatus(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getProblemStatus()
      mosek.fusion.Model.getProblemStatus(mosek.fusion.SolutionType)

    Description
    -----------

    Return the problem status.

    Parameters
    ----------

    which : mosek.fusion.SolutionType
    '''
    if False: pass
    elif mosek_fusion_Model._match_getProblemStatus_(*args):
      return self._getProblemStatus_(*args)
    elif mosek_fusion_Model._match_alt_getProblemStatus_(*args):
      return self._getProblemStatus_alt_(*args)
    elif mosek_fusion_Model._match_getProblemStatus_Emosek_4fusion_4SolutionType_2(*args):
      return self._getProblemStatus_Emosek_4fusion_4SolutionType_2(*args)
    elif mosek_fusion_Model._match_alt_getProblemStatus_Emosek_4fusion_4SolutionType_2(*args):
      return self._getProblemStatus_alt_Emosek_4fusion_4SolutionType_2(*args)
    else:
      raise ValueError('Invalid argument list getProblemStatus('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getProblemStatus()\n\tmosek.fusion.Model.getProblemStatus(mosek.fusion.SolutionType)')
  def disjunction(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.disjunction(mosek.fusion.DisjunctionTerms)
      mosek.fusion.Model.disjunction(array(mosek.fusion.Term,ndim=1))
      mosek.fusion.Model.disjunction(mosek.fusion.Term)
      mosek.fusion.Model.disjunction(mosek.fusion.ExprDomain)
      mosek.fusion.Model.disjunction(array(mosek.fusion.ExprDomain,ndim=1))
      mosek.fusion.Model.disjunction(mosek.fusion.Term,mosek.fusion.Term)
      mosek.fusion.Model.disjunction(string,mosek.fusion.Term)
      mosek.fusion.Model.disjunction(string,mosek.fusion.ExprDomain)
      mosek.fusion.Model.disjunction(string,array(mosek.fusion.Term,ndim=1))
      mosek.fusion.Model.disjunction(string,array(mosek.fusion.ExprDomain,ndim=1))
      mosek.fusion.Model.disjunction(string,mosek.fusion.DisjunctionTerms)
      mosek.fusion.Model.disjunction(string,mosek.fusion.Term,mosek.fusion.Term)
      mosek.fusion.Model.disjunction(mosek.fusion.Term,mosek.fusion.Term,mosek.fusion.Term)
      mosek.fusion.Model.disjunction(string,mosek.fusion.Term,mosek.fusion.Term,mosek.fusion.Term)

    Description
    -----------

    Create a new disjunctive constraint in the model. 

    Parameters
    ----------

    djcterms : mosek.fusion.DisjunctionTerms
        An object encapsulating the terms of a disjunctive constraint. 
    name : string
        The name of this disjunctive constraint. 
    t1 : mosek.fusion.Term
        A term in the disjunction. 
    t2 : mosek.fusion.Term
        A term in the disjunction. 
    t3 : mosek.fusion.Term
        A term in the disjunction. 
    term : mosek.fusion.ExprDomain
    terms : array(mosek.fusion.ExprDomain,ndim=1)
        A list of terms forming the disjunctive constraint. 
    '''
    if False: pass
    elif mosek_fusion_Model._match_disjunction_Lmosek_4fusion_4DisjunctionTerms_2(*args):
      return self._disjunction_Lmosek_4fusion_4DisjunctionTerms_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_Lmosek_4fusion_4DisjunctionTerms_2(*args):
      return self._disjunction_alt_Lmosek_4fusion_4DisjunctionTerms_2(*args)
    elif mosek_fusion_Model._match_disjunction__3Lmosek_4fusion_4Term_2(*args):
      return self._disjunction__3Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction__3Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_alt__3Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_disjunction_Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_alt_Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_disjunction_Lmosek_4fusion_4ExprDomain_2(*args):
      return self._disjunction_Lmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_Lmosek_4fusion_4ExprDomain_2(*args):
      return self._disjunction_alt_Lmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_Model._match_disjunction__3Lmosek_4fusion_4ExprDomain_2(*args):
      return self._disjunction__3Lmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction__3Lmosek_4fusion_4ExprDomain_2(*args):
      return self._disjunction_alt__3Lmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_Model._match_disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_alt_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_disjunction_SLmosek_4fusion_4Term_2(*args):
      return self._disjunction_SLmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_SLmosek_4fusion_4Term_2(*args):
      return self._disjunction_alt_SLmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_disjunction_SLmosek_4fusion_4ExprDomain_2(*args):
      return self._disjunction_SLmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_SLmosek_4fusion_4ExprDomain_2(*args):
      return self._disjunction_alt_SLmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_Model._match_disjunction_S_3Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_S_3Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_S_3Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_alt_S_3Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_disjunction_S_3Lmosek_4fusion_4ExprDomain_2(*args):
      return self._disjunction_S_3Lmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_S_3Lmosek_4fusion_4ExprDomain_2(*args):
      return self._disjunction_alt_S_3Lmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_Model._match_disjunction_SLmosek_4fusion_4DisjunctionTerms_2(*args):
      return self._disjunction_SLmosek_4fusion_4DisjunctionTerms_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_SLmosek_4fusion_4DisjunctionTerms_2(*args):
      return self._disjunction_alt_SLmosek_4fusion_4DisjunctionTerms_2(*args)
    elif mosek_fusion_Model._match_disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_alt_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_alt_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_alt_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args)
    else:
      raise ValueError('Invalid argument list disjunction('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.disjunction(mosek.fusion.DisjunctionTerms)\n\tmosek.fusion.Model.disjunction(array(mosek.fusion.Term,ndim=1))\n\tmosek.fusion.Model.disjunction(mosek.fusion.Term)\n\tmosek.fusion.Model.disjunction(mosek.fusion.ExprDomain)\n\tmosek.fusion.Model.disjunction(array(mosek.fusion.ExprDomain,ndim=1))\n\tmosek.fusion.Model.disjunction(mosek.fusion.Term,mosek.fusion.Term)\n\tmosek.fusion.Model.disjunction(string,mosek.fusion.Term)\n\tmosek.fusion.Model.disjunction(string,mosek.fusion.ExprDomain)\n\tmosek.fusion.Model.disjunction(string,array(mosek.fusion.Term,ndim=1))\n\tmosek.fusion.Model.disjunction(string,array(mosek.fusion.ExprDomain,ndim=1))\n\tmosek.fusion.Model.disjunction(string,mosek.fusion.DisjunctionTerms)\n\tmosek.fusion.Model.disjunction(string,mosek.fusion.Term,mosek.fusion.Term)\n\tmosek.fusion.Model.disjunction(mosek.fusion.Term,mosek.fusion.Term,mosek.fusion.Term)\n\tmosek.fusion.Model.disjunction(string,mosek.fusion.Term,mosek.fusion.Term,mosek.fusion.Term)')
  def getVariable(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getVariable(string)
      mosek.fusion.Model.getVariable(int32)

    Description
    -----------

    Get the variable matching the given name or linear index. 

    Parameters
    ----------

    index : int32
        The variable's linear index.
    name : string
        The variable's name.
    '''
    if False: pass
    elif mosek_fusion_Model._match_getVariable_S(*args):
      return self._getVariable_S(*args)
    elif mosek_fusion_Model._match_alt_getVariable_S(*args):
      return self._getVariable_alt_S(*args)
    elif mosek_fusion_Model._match_getVariable_I(*args):
      return self._getVariable_I(*args)
    elif mosek_fusion_Model._match_alt_getVariable_I(*args):
      return self._getVariable_alt_I(*args)
    else:
      raise ValueError('Invalid argument list getVariable('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getVariable(string)\n\tmosek.fusion.Model.getVariable(int32)')
  def setLogHandler(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.setLogHandler(System.StreamWriter)

    Description
    -----------

    Attach a log handler. 

    Parameters
    ----------

    h : System.StreamWriter
    '''
    if False: pass
    elif mosek_fusion_Model._match_setLogHandler_LSystem_4StreamWriter_2(*args):
      return self._setLogHandler_LSystem_4StreamWriter_2(*args)
    elif mosek_fusion_Model._match_alt_setLogHandler_LSystem_4StreamWriter_2(*args):
      return self._setLogHandler_alt_LSystem_4StreamWriter_2(*args)
    else:
      raise ValueError('Invalid argument list setLogHandler('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.setLogHandler(System.StreamWriter)')
  def flushSolutions(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.flushSolutions()

    Description
    -----------

    If any solution values have been provided, flush those values to the underlying task. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Model._match_flushSolutions_(*args):
      return self._flushSolutions_(*args)
    elif mosek_fusion_Model._match_alt_flushSolutions_(*args):
      return self._flushSolutions_alt_(*args)
    else:
      raise ValueError('Invalid argument list flushSolutions('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.flushSolutions()')
  def getParameter(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getParameter(string)

    Description
    -----------

    Get the parameter matching the given name. 

    Parameters
    ----------

    name : string
        The parameter's name.
    '''
    if False: pass
    elif mosek_fusion_Model._match_getParameter_S(*args):
      return self._getParameter_S(*args)
    elif mosek_fusion_Model._match_alt_getParameter_S(*args):
      return self._getParameter_alt_S(*args)
    else:
      raise ValueError('Invalid argument list getParameter('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getParameter(string)')
  def writeTaskNoFlush(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.writeTaskNoFlush(string)

    Description
    -----------

    

    Parameters
    ----------

    filename : string
    '''
    if False: pass
    elif mosek_fusion_Model._match_writeTaskNoFlush_S(*args):
      return self._writeTaskNoFlush_S(*args)
    elif mosek_fusion_Model._match_alt_writeTaskNoFlush_S(*args):
      return self._writeTaskNoFlush_alt_S(*args)
    else:
      raise ValueError('Invalid argument list writeTaskNoFlush('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.writeTaskNoFlush(string)')
  def setSolverParam(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.setSolverParam(string,string)
      mosek.fusion.Model.setSolverParam(string,int32)
      mosek.fusion.Model.setSolverParam(string,double)

    Description
    -----------

    Set a double parameter  

    Parameters
    ----------

    floatval : double
        A floating point value to assign to the parameter.
    intval : int32
        An integer value to assign to the parameter.
    name : string
        Name of the parameter to set
    strval : string
        A string value to assign to the parameter.
    '''
    if False: pass
    elif mosek_fusion_Model._match_setSolverParam_SS(*args):
      return self._setSolverParam_SS(*args)
    elif mosek_fusion_Model._match_alt_setSolverParam_SS(*args):
      return self._setSolverParam_alt_SS(*args)
    elif mosek_fusion_Model._match_setSolverParam_SI(*args):
      return self._setSolverParam_SI(*args)
    elif mosek_fusion_Model._match_alt_setSolverParam_SI(*args):
      return self._setSolverParam_alt_SI(*args)
    elif mosek_fusion_Model._match_setSolverParam_SD(*args):
      return self._setSolverParam_SD(*args)
    elif mosek_fusion_Model._match_alt_setSolverParam_SD(*args):
      return self._setSolverParam_alt_SD(*args)
    else:
      raise ValueError('Invalid argument list setSolverParam('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.setSolverParam(string,string)\n\tmosek.fusion.Model.setSolverParam(string,int32)\n\tmosek.fusion.Model.setSolverParam(string,double)')
  @staticmethod
  def putlicensewait(*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.putlicensewait(bool)

    Description
    -----------

    Set the license wait flag in the global environment. 

    Parameters
    ----------

    wait : bool
    '''
    if False: pass
    elif mosek_fusion_Model._match_putlicensewait_Z(*args):
      return mosek_fusion_Model._putlicensewait_Z(*args)
    elif mosek_fusion_Model._match_alt_putlicensewait_Z(*args):
      return mosek_fusion_Model._putlicensewait_alt_Z(*args)
    else:
      raise ValueError('Invalid argument list putlicensewait('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.putlicensewait(bool)')
  def variable(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.variable()
      mosek.fusion.Model.variable(mosek.fusion.RangeDomain)
      mosek.fusion.Model.variable(string)
      mosek.fusion.Model.variable(mosek.fusion.LinearDomain)
      mosek.fusion.Model.variable(int32)
      mosek.fusion.Model.variable(mosek.fusion.ConeDomain)
      mosek.fusion.Model.variable(array(int32,ndim=1))
      mosek.fusion.Model.variable(mosek.fusion.PSDDomain)
      mosek.fusion.Model.variable(string,mosek.fusion.LinearDomain)
      mosek.fusion.Model.variable(string,mosek.fusion.PSDDomain)
      mosek.fusion.Model.variable(array(int32,ndim=1),mosek.fusion.ConeDomain)
      mosek.fusion.Model.variable(array(int32,ndim=1),mosek.fusion.RangeDomain)
      mosek.fusion.Model.variable(string,int32)
      mosek.fusion.Model.variable(array(int32,ndim=1),mosek.fusion.LinearDomain)
      mosek.fusion.Model.variable(int32,mosek.fusion.LinearDomain)
      mosek.fusion.Model.variable(string,array(int32,ndim=1))
      mosek.fusion.Model.variable(int32,mosek.fusion.RangeDomain)
      mosek.fusion.Model.variable(int32,mosek.fusion.ConeDomain)
      mosek.fusion.Model.variable(string,mosek.fusion.ConeDomain)
      mosek.fusion.Model.variable(string,mosek.fusion.RangeDomain)
      mosek.fusion.Model.variable(int32,mosek.fusion.PSDDomain)
      mosek.fusion.Model.variable(string,array(int32,ndim=1),mosek.fusion.RangeDomain)
      mosek.fusion.Model.variable(string,array(int32,ndim=1),mosek.fusion.LinearDomain)
      mosek.fusion.Model.variable(string,int32,mosek.fusion.ConeDomain)
      mosek.fusion.Model.variable(int32,int32,mosek.fusion.PSDDomain)
      mosek.fusion.Model.variable(string,array(int32,ndim=1),mosek.fusion.ConeDomain)
      mosek.fusion.Model.variable(string,array(int32,ndim=1),mosek.fusion.PSDDomain)
      mosek.fusion.Model.variable(string,int32,mosek.fusion.RangeDomain)
      mosek.fusion.Model.variable(string,int32,mosek.fusion.PSDDomain)
      mosek.fusion.Model.variable(string,int32,mosek.fusion.LinearDomain)
      mosek.fusion.Model.variable(string,int32,int32,mosek.fusion.PSDDomain)

    Description
    -----------

    Create a new variable in the model. 

    Parameters
    ----------

    ldom : mosek.fusion.LinearDomain
        
        A linear domain for the variable.
                  
    m : int32
        
        Number of semidefinite variables.
    n : int32
        
        Dimension of the semidefinite variable.
    name : string
        
        Name of the variable. This must be unique among all variables in
        the model. The value |null| is allowed instead of a unique name.
                  
    psddom : mosek.fusion.PSDDomain
        
        A semidefinte domain for the variable.
    qdom : mosek.fusion.ConeDomain
        
        A conic domain for the variable.
    rdom : mosek.fusion.RangeDomain
        
        A ranged domain for the variable.
    shp : array(int32,ndim=1)
        
        Defines the shape of the variable.
                  
    size : int32
        
        Size of the variable. The variable becomes a one-dimensional vector of the given size.
                  
    '''
    if False: pass
    elif mosek_fusion_Model._match_variable_(*args):
      return self._variable_(*args)
    elif mosek_fusion_Model._match_alt_variable_(*args):
      return self._variable_alt_(*args)
    elif mosek_fusion_Model._match_variable_Lmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_Lmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_alt_Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_S(*args):
      return self._variable_S(*args)
    elif mosek_fusion_Model._match_alt_variable_S(*args):
      return self._variable_alt_S(*args)
    elif mosek_fusion_Model._match_variable_Lmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_Lmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_alt_Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_I(*args):
      return self._variable_I(*args)
    elif mosek_fusion_Model._match_alt_variable_I(*args):
      return self._variable_alt_I(*args)
    elif mosek_fusion_Model._match_variable_Lmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_Lmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_Lmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_alt_Lmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable__3I(*args):
      return self._variable__3I(*args)
    elif mosek_fusion_Model._match_alt_variable__3I(*args):
      return self._variable_alt__3I(*args)
    elif mosek_fusion_Model._match_variable_Lmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_Lmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_alt_Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_SLmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_alt_SLmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_SLmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_alt_SLmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable__3ILmosek_4fusion_4ConeDomain_2(*args):
      return self._variable__3ILmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable__3ILmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_alt__3ILmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable__3ILmosek_4fusion_4RangeDomain_2(*args):
      return self._variable__3ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable__3ILmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_alt__3ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SI(*args):
      return self._variable_SI(*args)
    elif mosek_fusion_Model._match_alt_variable_SI(*args):
      return self._variable_alt_SI(*args)
    elif mosek_fusion_Model._match_variable__3ILmosek_4fusion_4LinearDomain_2(*args):
      return self._variable__3ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable__3ILmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_alt__3ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_ILmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_ILmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_alt_ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_S_3I(*args):
      return self._variable_S_3I(*args)
    elif mosek_fusion_Model._match_alt_variable_S_3I(*args):
      return self._variable_alt_S_3I(*args)
    elif mosek_fusion_Model._match_variable_ILmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_ILmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_alt_ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_ILmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_ILmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_ILmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_alt_ILmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_SLmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_alt_SLmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_SLmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_alt_SLmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_ILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_ILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_ILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_alt_ILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_S_3ILmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_S_3ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_S_3ILmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_alt_S_3ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_S_3ILmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_S_3ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_S_3ILmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_alt_S_3ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SILmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_SILmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SILmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_alt_SILmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_IILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_IILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_IILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_alt_IILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_S_3ILmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_S_3ILmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_S_3ILmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_alt_S_3ILmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_S_3ILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_S_3ILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_S_3ILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_alt_S_3ILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SILmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_SILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SILmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_alt_SILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_SILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_alt_SILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SILmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_SILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SILmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_alt_SILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SIILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_SIILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SIILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_alt_SIILmosek_4fusion_4PSDDomain_2(*args)
    else:
      raise ValueError('Invalid argument list variable('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.variable()\n\tmosek.fusion.Model.variable(mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(string)\n\tmosek.fusion.Model.variable(mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(int32)\n\tmosek.fusion.Model.variable(mosek.fusion.ConeDomain)\n\tmosek.fusion.Model.variable(array(int32,ndim=1))\n\tmosek.fusion.Model.variable(mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(array(int32,ndim=1),mosek.fusion.ConeDomain)\n\tmosek.fusion.Model.variable(array(int32,ndim=1),mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(string,int32)\n\tmosek.fusion.Model.variable(array(int32,ndim=1),mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(int32,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(string,array(int32,ndim=1))\n\tmosek.fusion.Model.variable(int32,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(int32,mosek.fusion.ConeDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.ConeDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(int32,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(string,array(int32,ndim=1),mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(string,array(int32,ndim=1),mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(string,int32,mosek.fusion.ConeDomain)\n\tmosek.fusion.Model.variable(int32,int32,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(string,array(int32,ndim=1),mosek.fusion.ConeDomain)\n\tmosek.fusion.Model.variable(string,array(int32,ndim=1),mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(string,int32,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(string,int32,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(string,int32,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(string,int32,int32,mosek.fusion.PSDDomain)')
  @staticmethod
  def getVersion(*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getVersion()

    Description
    -----------

    Return MOSEK version.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Model._match_getVersion_(*args):
      return mosek_fusion_Model._getVersion_(*args)
    elif mosek_fusion_Model._match_alt_getVersion_(*args):
      return mosek_fusion_Model._getVersion_alt_(*args)
    else:
      raise ValueError('Invalid argument list getVersion('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getVersion()')
  def getTask(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.getTask()

    Description
    -----------

    Return the underlying MOSEK task object. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Model._match_getTask_(*args):
      return self._getTask_(*args)
    elif mosek_fusion_Model._match_alt_getTask_(*args):
      return self._getTask_alt_(*args)
    else:
      raise ValueError('Invalid argument list getTask('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getTask()')
  def hasVariable(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.hasVariable(string)

    Description
    -----------

    Check whether the model contains a variable with a given name.

    Parameters
    ----------

    name : string
        The variable name.
    '''
    if False: pass
    elif mosek_fusion_Model._match_hasVariable_S(*args):
      return self._hasVariable_S(*args)
    elif mosek_fusion_Model._match_alt_hasVariable_S(*args):
      return self._hasVariable_alt_S(*args)
    else:
      raise ValueError('Invalid argument list hasVariable('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.hasVariable(string)')
  def setDataCallbackHandler(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.setDataCallbackHandler(System.DataCallbackHandler)

    Description
    -----------

    Attach a data callback handler. 

    Parameters
    ----------

    h : System.DataCallbackHandler
    '''
    if False: pass
    elif mosek_fusion_Model._match_setDataCallbackHandler_LSystem_4DataCallbackHandler_2(*args):
      return self._setDataCallbackHandler_LSystem_4DataCallbackHandler_2(*args)
    elif mosek_fusion_Model._match_alt_setDataCallbackHandler_LSystem_4DataCallbackHandler_2(*args):
      return self._setDataCallbackHandler_alt_LSystem_4DataCallbackHandler_2(*args)
    else:
      raise ValueError('Invalid argument list setDataCallbackHandler('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.setDataCallbackHandler(System.DataCallbackHandler)')
  def expressionCache(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Model.expressionCache(bool)

    Description
    -----------

    Toggle expression cache.

    Parameters
    ----------

    cache : bool
        Whether to use expression cache. The default state when the model object is created is ``false``.
    '''
    if False: pass
    elif mosek_fusion_Model._match_expressionCache_Z(*args):
      return self._expressionCache_Z(*args)
    elif mosek_fusion_Model._match_alt_expressionCache_Z(*args):
      return self._expressionCache_alt_Z(*args)
    else:
      raise ValueError('Invalid argument list expressionCache('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.expressionCache(bool)')
  def __repr__(self): return 'mosek.fusion.Model'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2(m):
    o = Model.__new__(Model)
    o._ctor_init_Lmosek_4fusion_4Model_2(m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2(*args):
    if len(args) != 1: return False
    m, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2(*args):
    if len(args) != 1: return False
    m, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2(self,m):
    self._ctor_init_Lmosek_4fusion_4Model_2(m)
  def _ctor_init_Lmosek_4fusion_4Model_2(self,m):
   mosek_fusion_BaseModel._ctor_init_Lmosek_4fusion_4BaseModel_2(self,m)
   _a_0=self
   self.__model_name = (m.__model_name)
   self.__acceptable_sol = (m.__acceptable_sol)
   self.__solutionptr = (m.__solutionptr)
   self.__cache_evaluations = (m.__cache_evaluations)
   self.__sol_itr = ((m.__sol_itr)._clone_() if (((m.__sol_itr) is not None) ) else None)
   self.__sol_itg = ((m.__sol_itg)._clone_() if (((m.__sol_itg) is not None) ) else None)
   self.__sol_bas = ((m.__sol_bas)._clone_() if (((m.__sol_bas) is not None) ) else None)
   self.__num_task_afe = (m.__num_task_afe)
   self.__num_task_con = (m.__num_task_con)
   self.__num_task_acc = (m.__num_task_acc)
   self.__con_blocks = mosek_fusion_RowBlockManager._ctor_Lmosek_4fusion_4RowBlockManager_2((m.__con_blocks))
   self.__afe_blocks = mosek_fusion_RowBlockManager._ctor_Lmosek_4fusion_4RowBlockManager_2((m.__afe_blocks))
   self.__obj_blocks = mosek_fusion_RowBlockManager._ctor_Lmosek_4fusion_4RowBlockManager_2((m.__obj_blocks))
   self.__acc_block_map = mosek_fusion_LinkedBlocks._ctor_Lmosek_4fusion_4LinkedBlocks_2((m.__acc_block_map))
   self.__acon_block_map = mosek_fusion_LinkedBlocks._ctor_Lmosek_4fusion_4LinkedBlocks_2((m.__acon_block_map))
   self.__acon_acc = mosek.fusion.Utils.Tools._arraycopy__3I((m.__acon_acc))
   self.__acon_afe = mosek.fusion.Utils.Tools._arraycopy__3I((m.__acon_afe))
   self.__acon_elm_accid = mosek.fusion.Utils.Tools._arraycopy__3I((m.__acon_elm_accid))
   self.__acon_elm_scale = mosek.fusion.Utils.Tools._arraycopy__3D((m.__acon_elm_scale))
   self.__acon_elm_ofs = mosek.fusion.Utils.Tools._arraycopy__3I((m.__acon_elm_ofs))
   self.__acon_elm_afe = mosek.fusion.Utils.Tools._arraycopy__3I((m.__acon_elm_afe))
   self.__task_numaferow = (m.__task_numaferow)
   self.__var_block_map = mosek_fusion_LinkedBlocks._ctor_Lmosek_4fusion_4LinkedBlocks_2((m.__var_block_map))
   self.__var_block_acc_id = mosek.fusion.Utils.Tools._arraycopy__3I((m.__var_block_acc_id))
   self.__var_elm_acc_idx = mosek.fusion.Utils.Tools._arraycopy__3I((m.__var_elm_acc_idx))
   self.__var_elm_acc_ofs = mosek.fusion.Utils.Tools._arraycopy__3I((m.__var_elm_acc_ofs))
   self.__barvar_num = 0
   self.__barvar_dim = mosek.fusion.Utils.Tools._arraycopy__3I((m.__barvar_dim))
   self.__barvar_block_ptr = mosek.fusion.Utils.Tools._arraycopy__3I((m.__barvar_block_ptr))
   self.__barvar_block_dim = mosek.fusion.Utils.Tools._arraycopy__3I((m.__barvar_block_dim))
   self.__barvar_block_elm_ptr = mosek.fusion.Utils.Tools._arraycopy__3I((m.__barvar_block_elm_ptr))
   self.__barvar_block_elm_barj = mosek.fusion.Utils.Tools._arraycopy__3I((m.__barvar_block_elm_barj))
   self.__barvar_block_elm_i = mosek.fusion.Utils.Tools._arraycopy__3I((m.__barvar_block_elm_i))
   self.__barvar_block_elm_j = mosek.fusion.Utils.Tools._arraycopy__3I((m.__barvar_block_elm_j))
   self.__vars = numpy.array([((m.__vars)[_a_1]._clone_Lmosek_4fusion_4Model_2(_a_0) if (((m.__vars)[_a_1] is not None) ) else None) for _a_1 in range(0,int(((m.__vars)).shape[0]))], dtype=numpy.dtype(object))
   self.__barvars = numpy.array([((m.__barvars)[_a_2]._clone_Lmosek_4fusion_4Model_2(_a_0) if (((m.__barvars)[_a_2] is not None) ) else None) for _a_2 in range(0,int(((m.__barvars)).shape[0]))], dtype=numpy.dtype(object))
   self.__var_map = (m.__var_map)._clone_()
   self.__cons = numpy.array([((m.__cons)[_a_3]._clone_Lmosek_4fusion_4Model_2(_a_0) if (((m.__cons)[_a_3] is not None) ) else None) for _a_3 in range(0,int(((m.__cons)).shape[0]))], dtype=numpy.dtype(object))
   self.__acons = numpy.array([((m.__acons)[_a_4]._clone_Lmosek_4fusion_4Model_2(_a_0) if (((m.__acons)[_a_4] is not None) ) else None) for _a_4 in range(0,int(((m.__acons)).shape[0]))], dtype=numpy.dtype(object))
   self.__con_map = (m.__con_map)._clone_()
   self.__numparameter = (m.__numparameter)
   self.__parameters = (None if (((m.__parameters) is None) ) else numpy.array([((m.__parameters)[_a_5]._clone_Lmosek_4fusion_4Model_2(_a_0) if (((m.__parameters)[_a_5] is not None) ) else None) for _a_5 in range(0,int(((m.__parameters)).shape[0]))], dtype=numpy.dtype(object)))
   self.__par_map = (m.__par_map)._clone_()
   self.__param_num = (m.__param_num)
   self.__param_value = (mosek.fusion.Utils.Tools._arraycopy__3D((m.__param_value)) if (((m.__param_value) is not None) ) else None)
   self.__initsol_xx = None
   self.__initsol_xx_flag = None
   self.__bfixidx = (m.__bfixidx)
   self.__rs = mosek_fusion_WorkStack._ctor_()
   self.__ws = mosek_fusion_WorkStack._ctor_()
   self.__xs = mosek_fusion_WorkStack._ctor_()
  @staticmethod
  def _ctor_SIZ(name,basesize,cache_eval):
    o = Model.__new__(Model)
    o._ctor_init_SIZ(name,basesize,cache_eval)
    return o
  @staticmethod
  def __match_ctor_SIZ(*args):
    if len(args) != 3: return False
    name,basesize,cache_eval, = args
    return (__arg_match_S__(name) and __arg_match_I__(basesize) and __arg_match_Z__(cache_eval))
  @staticmethod
  def __match_alt_ctor_SIZ(*args):
    if len(args) != 3: return False
    name,basesize,cache_eval, = args
    return (__arg_alt_match_S__(name) and __arg_alt_match_I__(basesize) and __arg_alt_match_Z__(cache_eval))
  def _ctor_alt_init_SIZ(self,name,basesize,cache_eval):
    self._ctor_init_SIZ(name,numpy.int32(basesize),cache_eval)
  def _ctor_init_SIZ(self,name,basesize,cache_eval):
   mosek_fusion_BaseModel._ctor_init_SS(self,name,"")
   self.__model_name = name
   self.__acceptable_sol = mosek.fusion.AccSolutionStatus.Optimal
   self.__solutionptr = mosek.fusion.SolutionType.Default
   self.__cache_evaluations = cache_eval
   self.__sol_itr = None
   self.__sol_itg = None
   self.__sol_bas = None
   self.__num_task_afe = 0
   self.__num_task_con = 0
   self.__num_task_acc = 0
   self.__con_blocks = mosek_fusion_RowBlockManager._ctor_()
   self.__afe_blocks = mosek_fusion_RowBlockManager._ctor_()
   self.__obj_blocks = mosek_fusion_RowBlockManager._ctor_()
   self.__acc_block_map = mosek_fusion_LinkedBlocks._ctor_()
   self.__acon_block_map = mosek_fusion_LinkedBlocks._ctor_()
   self.__task_numaferow = 0
   self.__acon_acc = numpy.zeros((self.__acon_block_map._block_1capacity_(),), dtype=numpy.dtype(numpy.int32))
   self.__acon_afe = numpy.zeros((self.__acon_block_map._block_1capacity_(),), dtype=numpy.dtype(numpy.int32))
   self.__acon_elm_accid = numpy.zeros((self.__acon_block_map._capacity_(),), dtype=numpy.dtype(numpy.int32))
   self.__acon_elm_scale = numpy.array([1.0 for _a_0 in range(0,self.__acon_block_map._capacity_())], dtype=numpy.dtype(numpy.float64))
   self.__acon_elm_ofs = numpy.zeros((self.__acon_block_map._capacity_(),), dtype=numpy.dtype(numpy.int32))
   self.__acon_elm_afe = numpy.zeros((self.__acon_block_map._capacity_(),), dtype=numpy.dtype(numpy.int32))
   self.__var_block_map = mosek_fusion_LinkedBlocks._ctor_()
   self.__var_block_acc_id = numpy.zeros((self.__var_block_map._block_1capacity_(),), dtype=numpy.dtype(numpy.int32))
   self.__var_elm_acc_idx = numpy.zeros((self.__var_block_map._capacity_(),), dtype=numpy.dtype(numpy.int32))
   self.__var_elm_acc_ofs = numpy.zeros((self.__var_block_map._capacity_(),), dtype=numpy.dtype(numpy.int32))
   self.__barvar_num = 0
   self.__barvar_dim = numpy.zeros((basesize,), dtype=numpy.dtype(numpy.int32))
   self.__barvar_block_ptr = numpy.zeros(((basesize + 1),), dtype=numpy.dtype(numpy.int32))
   self.__barvar_block_dim = numpy.zeros((basesize,), dtype=numpy.dtype(numpy.int32))
   self.__barvar_block_elm_ptr = numpy.zeros(((basesize + 1),), dtype=numpy.dtype(numpy.int32))
   self.__barvar_block_elm_barj = numpy.zeros((basesize,), dtype=numpy.dtype(numpy.int32))
   self.__barvar_block_elm_i = numpy.zeros((basesize,), dtype=numpy.dtype(numpy.int32))
   self.__barvar_block_elm_j = numpy.zeros((basesize,), dtype=numpy.dtype(numpy.int32))
   self.__vars = numpy.array([None for _a_1 in range(0,(basesize * 8))], dtype=numpy.dtype(object))
   self.__barvars = numpy.array([None for _a_2 in range(0,basesize)], dtype=numpy.dtype(object))
   self.__var_map = mosek.fusion.Utils.StringIntMap()
   self.__initsol_xx = None
   self.__initsol_xx_flag = None
   self.__cons = numpy.array([None for _a_3 in range(0,(basesize * 8))], dtype=numpy.dtype(object))
   self.__acons = numpy.array([None for _a_4 in range(0,(basesize * 8))], dtype=numpy.dtype(object))
   self.__con_map = mosek.fusion.Utils.StringIntMap()
   self.__numparameter = 0
   self.__parameters = None
   self.__par_map = mosek.fusion.Utils.StringIntMap()
   self.__param_num = 0
   self.__param_value = None
   _a_5=numpy.zeros((1,), dtype=numpy.dtype(numpy.int32))
   _a_6=self.__linearvar_1alloc_I_3I(1,_a_5)
   self.__bfixidx = _a_5[0]
   self._task_1var_1putboundlist_1fx__3I_3D(numpy.array([self.__bfixidx], dtype=numpy.dtype(numpy.int32)),numpy.array([1.0], dtype=numpy.dtype(numpy.float64)))
   self._task_1var_1name_IS(self.__bfixidx,"1.0")
   self._task_1append_1domain_1empty_()
   self.__rs = mosek_fusion_WorkStack._ctor_()
   self.__ws = mosek_fusion_WorkStack._ctor_()
   self.__xs = mosek_fusion_WorkStack._ctor_()
  @staticmethod
  def _ctor_IZ(basesize,cache_eval):
    o = Model.__new__(Model)
    o._ctor_init_IZ(basesize,cache_eval)
    return o
  @staticmethod
  def __match_ctor_IZ(*args):
    if len(args) != 2: return False
    basesize,cache_eval, = args
    return (__arg_match_I__(basesize) and __arg_match_Z__(cache_eval))
  @staticmethod
  def __match_alt_ctor_IZ(*args):
    if len(args) != 2: return False
    basesize,cache_eval, = args
    return (__arg_alt_match_I__(basesize) and __arg_alt_match_Z__(cache_eval))
  def _ctor_alt_init_IZ(self,basesize,cache_eval):
    self._ctor_init_IZ(numpy.int32(basesize),cache_eval)
  def _ctor_init_IZ(self,basesize,cache_eval):
   mosek_fusion_Model._ctor_init_SIZ(self,"",basesize,cache_eval)
  @staticmethod
  def _ctor_S(name):
    o = Model.__new__(Model)
    o._ctor_init_S(name)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    name, = args
    return (__arg_match_S__(name))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    name, = args
    return (__arg_alt_match_S__(name))
  def _ctor_alt_init_S(self,name):
    self._ctor_init_S(name)
  def _ctor_init_S(self,name):
   mosek_fusion_Model._ctor_init_SIZ(self,name,128,False)
  @staticmethod
  def _ctor_():
    o = Model.__new__(Model)
    o._ctor_init_()
    return o
  @staticmethod
  def __match_ctor_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def __match_alt_ctor_(*args):
    if len(args) != 0: return False
    return True
  def _ctor_alt_init_(self,):
    self._ctor_init_()
  def _ctor_init_(self,):
   mosek_fusion_Model._ctor_init_SIZ(self,"",128,False)
  @staticmethod
  def _match_disjunction_S_3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match__3Lmosek_4fusion_4Term_2__(_a_1))
  @staticmethod
  def _match_alt_disjunction_S_3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match__3Lmosek_4fusion_4Term_2__(_a_1))
  def _disjunction_alt_S_3Lmosek_4fusion_4Term_2(self,_t__a_0,_t__a_1):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(object))
   _1_res = self._disjunction_S_3Lmosek_4fusion_4Term_2(_a_0,_a_1)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _disjunction_S_3Lmosek_4fusion_4Term_2(self,_a_0,_a_1):
   _a_2=int((_a_1).shape[0])
   _a_3=0
   _a_4=0
   _a_5=0
   _a_6=0
   for _a_7 in range(0,_a_2):
    _a_3 += _a_1[_a_7]._size_()
    _a_4 += _a_1[_a_7]._num_()
    _a_6 += _a_1[_a_7]._numaccrows_()
    _a_5 += _a_1[_a_7]._numaccterms_()
   _a_8=numpy.zeros((_a_3,), dtype=numpy.dtype(numpy.int32))
   _a_9=numpy.zeros((_a_6,), dtype=numpy.dtype(numpy.int32))
   _a_10=numpy.zeros((_a_6,), dtype=numpy.dtype(numpy.float64))
   _a_11=numpy.zeros((_a_5,), dtype=numpy.dtype(numpy.int64))
   _a_12=numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.int64))
   _a_13=self.__afe_1allocate__3I(_a_8)
   _a_14=0
   _a_15=0
   _a_16=0
   _a_17=0
   for _a_18 in range(0,_a_2):
    for _a_19 in range(0,_a_1[_a_18]._num_()):
     _a_20=(_a_1[_a_18]._domains)[_a_19]
     _a_21=mosek_fusion_ExprDense._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprOptimizeCode._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2((_a_1[_a_18]._exprs)[_a_19])))
     _a_21._recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(self.__rs,self.__ws,self.__xs,self.__cache_evaluations)
     self.__rs._pop_1expr_()
     _a_22=(self.__rs.i32)
     _a_23=(self.__rs.i64)
     _a_24=(self.__rs.f64)
     _a_25=(self.__rs.nd)
     _a_26=(self.__rs.shape_base)
     _a_27=(self.__rs.nelem)
     _a_28=(self.__rs.nnz)
     _a_29=(self.__rs.ncodeatom)
     _a_30=(self.__rs.hassp)
     _a_31=(self.__rs.ptr_base)
     _a_32=(self.__rs.nidxs_base)
     _a_33=(self.__rs.cof_base)
     _a_34=(self.__rs.code_base)
     _a_35=(self.__rs.codeptr_base)
     _a_36=(self.__rs.cconst_base)
     _a_37=numpy.array([_a_22[(_a_26 + _a_38)] for _a_38 in range(0,_a_25)], dtype=numpy.dtype(numpy.int32))
     self.__putfrows__3IILmosek_4fusion_4WorkStack_2IIIII(_a_8,_a_17,self.__rs,_a_27,_a_28,_a_31,_a_32,_a_33)
     if ((_a_20.dom)==mosek.fusion.DJCDomainType.InRange):
      _a_39=(_a_20.b)
      _a_40=(_a_20.par)
      fragments._c_closure_1(_a_9,_a_10,_a_8,_a_17,_a_16,_a_39,_a_27,_a_40) 
      _a_11[_a_15] = self._task_1append_1domain_1rpos_I(_a_27)
      _a_11[(_a_15 + 1)] = self._task_1append_1domain_1rneg_I(_a_27)
      _a_12[_a_18] += 2
      _a_15 += 2
      _a_16 += (_a_27 * 2)
     elif (((_a_20.dom)==mosek.fusion.DJCDomainType.EqualTo) or (((_a_20.dom)==mosek.fusion.DJCDomainType.LessThan) or (((_a_20.dom)==mosek.fusion.DJCDomainType.GreaterThan) or ((_a_20.dom)==mosek.fusion.DJCDomainType.IsFree)))):
      _a_41=(_a_20.b)
      fragments._c_closure_2(_a_9,_a_10,_a_8,_a_17,_a_16,_a_41,_a_27) 
      if ((_a_20.dom)==mosek.fusion.DJCDomainType.EqualTo):
       _a_11[_a_15] = self._task_1append_1domain_1rzero_I(_a_27)
      elif ((_a_20.dom)==mosek.fusion.DJCDomainType.LessThan):
       _a_11[_a_15] = self._task_1append_1domain_1rneg_I(_a_27)
      elif ((_a_20.dom)==mosek.fusion.DJCDomainType.GreaterThan):
       _a_11[_a_15] = self._task_1append_1domain_1rpos_I(_a_27)
      else:
       _a_11[_a_15] = self._task_1append_1domain_1r_I(_a_27)
      _a_12[_a_18] += 1
      _a_15 += 1
      _a_16 += _a_27
     else:
      raise mosek_fusion_UnexpectedError._ctor_S("Not implemented: Non-linear conic DJC constraints")
     if (_a_29 > 0):
      self.__afe_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,numpy.array([_a_8[(_a_17 + _a_42)] for _a_42 in range(0,_a_27)], dtype=numpy.dtype(numpy.int32)),_a_31,_a_32,_a_35,_a_34,_a_36)
     _a_17 += _a_27
     _a_14 += 1
   _a_43=self._task_1append_1djc_J(1)
   self._task_1putdjcslice_JJ_3J_3J_3J_3J_3D(_a_43,(_a_43 + 1),numpy.array([numpy.int64(_a_2)], dtype=numpy.dtype(numpy.int64)),_a_12,_a_11,numpy.array([_a_9[_a_44] for _a_44 in range(0,int((_a_9).shape[0]))], dtype=numpy.dtype(numpy.int64)),_a_10)
   if (int(len(_a_0)) > 0):
    self._task_1djc_1name_JS(_a_43,mosek.fusion.Utils.StringBuffer()._a_S(_a_0)._a_S("[")._a_S("]")._toString_())
   return (mosek_fusion_Disjunction._ctor_J(_a_43))
  @staticmethod
  def _match_disjunction__3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3Lmosek_4fusion_4Term_2__(_a_0))
  @staticmethod
  def _match_alt_disjunction__3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Term_2__(_a_0))
  def _disjunction_alt__3Lmosek_4fusion_4Term_2(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(object))
   _1_res = self._disjunction__3Lmosek_4fusion_4Term_2(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _disjunction__3Lmosek_4fusion_4Term_2(self,_a_0):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2("",_a_0))
  @staticmethod
  def _match_disjunction_Lmosek_4fusion_4DisjunctionTerms_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4DisjunctionTerms_2__(_a_0))
  @staticmethod
  def _match_alt_disjunction_Lmosek_4fusion_4DisjunctionTerms_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4DisjunctionTerms_2__(_a_0))
  def _disjunction_alt_Lmosek_4fusion_4DisjunctionTerms_2(self,_t__a_0):
    return self._disjunction_Lmosek_4fusion_4DisjunctionTerms_2(_a_0)
  def _disjunction_Lmosek_4fusion_4DisjunctionTerms_2(self,_a_0):
   return (self._disjunction__3Lmosek_4fusion_4Term_2((_a_0._terms)))
  @staticmethod
  def _match_disjunction_SLmosek_4fusion_4DisjunctionTerms_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4DisjunctionTerms_2__(_a_1))
  @staticmethod
  def _match_alt_disjunction_SLmosek_4fusion_4DisjunctionTerms_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4DisjunctionTerms_2__(_a_1))
  def _disjunction_alt_SLmosek_4fusion_4DisjunctionTerms_2(self,_t__a_0,_t__a_1):
    return self._disjunction_SLmosek_4fusion_4DisjunctionTerms_2(_a_0,_a_1)
  def _disjunction_SLmosek_4fusion_4DisjunctionTerms_2(self,_a_0,_a_1):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2(_a_0,(_a_1._terms)))
  @staticmethod
  def _match_disjunction_S_3Lmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match__3Lmosek_4fusion_4ExprDomain_2__(_a_1))
  @staticmethod
  def _match_alt_disjunction_S_3Lmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match__3Lmosek_4fusion_4ExprDomain_2__(_a_1))
  def _disjunction_alt_S_3Lmosek_4fusion_4ExprDomain_2(self,_t__a_0,_t__a_1):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(object))
   _1_res = self._disjunction_S_3Lmosek_4fusion_4ExprDomain_2(_a_0,_a_1)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _disjunction_S_3Lmosek_4fusion_4ExprDomain_2(self,_a_0,_a_1):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2(_a_0,numpy.array([_a_1[_a_2]._toDJCTerm_() for _a_2 in range(0,int((_a_1).shape[0]))], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction__3Lmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3Lmosek_4fusion_4ExprDomain_2__(_a_0))
  @staticmethod
  def _match_alt_disjunction__3Lmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4ExprDomain_2__(_a_0))
  def _disjunction_alt__3Lmosek_4fusion_4ExprDomain_2(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(object))
   _1_res = self._disjunction__3Lmosek_4fusion_4ExprDomain_2(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _disjunction__3Lmosek_4fusion_4ExprDomain_2(self,_a_0):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2("",numpy.array([_a_0[_a_1]._toDJCTerm_() for _a_1 in range(0,int((_a_0).shape[0]))], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction_SLmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4ExprDomain_2__(_a_1))
  @staticmethod
  def _match_alt_disjunction_SLmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4ExprDomain_2__(_a_1))
  def _disjunction_alt_SLmosek_4fusion_4ExprDomain_2(self,_t__a_0,_t__a_1):
    return self._disjunction_SLmosek_4fusion_4ExprDomain_2(_a_0,_a_1)
  def _disjunction_SLmosek_4fusion_4ExprDomain_2(self,_a_0,_a_1):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2(_a_0,numpy.array([_a_1._toDJCTerm_()], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction_Lmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4ExprDomain_2__(_a_0))
  @staticmethod
  def _match_alt_disjunction_Lmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprDomain_2__(_a_0))
  def _disjunction_alt_Lmosek_4fusion_4ExprDomain_2(self,_t__a_0):
    return self._disjunction_Lmosek_4fusion_4ExprDomain_2(_a_0)
  def _disjunction_Lmosek_4fusion_4ExprDomain_2(self,_a_0):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2("",numpy.array([_a_0._toDJCTerm_()], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_Lmosek_4fusion_4Term_2__(_a_0) and __arg_match_Lmosek_4fusion_4Term_2__(_a_1) and __arg_match_Lmosek_4fusion_4Term_2__(_a_2))
  @staticmethod
  def _match_alt_disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Term_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_a_2))
  def _disjunction_alt_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self._disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(_a_0,_a_1,_a_2)
  def _disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(self,_a_0,_a_1,_a_2):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2("",numpy.array([_a_0,_a_1,_a_2], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Term_2__(_a_0) and __arg_match_Lmosek_4fusion_4Term_2__(_a_1))
  @staticmethod
  def _match_alt_disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Term_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_a_1))
  def _disjunction_alt_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(self,_t__a_0,_t__a_1):
    return self._disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(_a_0,_a_1)
  def _disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(self,_a_0,_a_1):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2("",numpy.array([_a_0,_a_1], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction_Lmosek_4fusion_4Term_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4Term_2__(_a_0))
  @staticmethod
  def _match_alt_disjunction_Lmosek_4fusion_4Term_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4Term_2__(_a_0))
  def _disjunction_alt_Lmosek_4fusion_4Term_2(self,_t__a_0):
    return self._disjunction_Lmosek_4fusion_4Term_2(_a_0)
  def _disjunction_Lmosek_4fusion_4Term_2(self,_a_0):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2("",numpy.array([_a_0], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4Term_2__(_a_1) and __arg_match_Lmosek_4fusion_4Term_2__(_a_2) and __arg_match_Lmosek_4fusion_4Term_2__(_a_3))
  @staticmethod
  def _match_alt_disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_a_2) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_a_3))
  def _disjunction_alt_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3):
    return self._disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(_a_0,_a_1,_a_2,_a_3)
  def _disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(self,_a_0,_a_1,_a_2,_a_3):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2(_a_0,numpy.array([_a_1,_a_2,_a_3], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4Term_2__(_a_1) and __arg_match_Lmosek_4fusion_4Term_2__(_a_2))
  @staticmethod
  def _match_alt_disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_a_2))
  def _disjunction_alt_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self._disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(_a_0,_a_1,_a_2)
  def _disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(self,_a_0,_a_1,_a_2):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2(_a_0,numpy.array([_a_1,_a_2], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction_SLmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4Term_2__(_a_1))
  @staticmethod
  def _match_alt_disjunction_SLmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_a_1))
  def _disjunction_alt_SLmosek_4fusion_4Term_2(self,_t__a_0,_t__a_1):
    return self._disjunction_SLmosek_4fusion_4Term_2(_a_0,_a_1)
  def _disjunction_SLmosek_4fusion_4Term_2(self,_a_0,_a_1):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2(_a_0,numpy.array([_a_1], dtype=numpy.dtype(object))))
  def _formstConstr_alt_Lmosek_4fusion_4Utils_4StringBuffer_2_3I_3I(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _1_res = self._formstConstr_Lmosek_4fusion_4Utils_4StringBuffer_2_3I_3I(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _formstConstr_Lmosek_4fusion_4Utils_4StringBuffer_2_3I_3I(self,_a_0,_a_1,_a_2):
   return (_a_0)
  def __acon_1release_alt_I(self,_t__a_0):
    return self.__acon_1release_I(numpy.int32(__a_0))
  def __acon_1release_I(self,_a_0):
   _a_1=self.__acon_block_map._blocksize_I(_a_0)
   if (_a_1 >= 0):
    _a_2=self.__acc_block_map._blocksize_I(self.__acon_acc[_a_0])
    _a_3=numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.int32))
    _a_4=numpy.zeros((_a_1,), dtype=numpy.dtype(numpy.int32))
    self.__acc_block_map._get_I_3II(self.__acon_acc[_a_0],_a_3,0)
    self.__acc_block_map._free_I(self.__acon_acc[_a_0])
    self.__afe_blocks._get_I_3II(self.__acon_afe[_a_0],_a_4,0)
    self.__afe_1release_I(self.__acon_afe[_a_0])
    self.__acon_block_map._free_I(_a_0)
    self._task_1clearafelist__3J(numpy.array([_a_4[_a_5] for _a_5 in range(0,_a_1)], dtype=numpy.dtype(numpy.int64)))
    self._task_1putacclist__3J_3J_3J_3D(numpy.array([_a_3[_a_6] for _a_6 in range(0,_a_2)], dtype=numpy.dtype(numpy.int64)),numpy.array([0 for _a_7 in range(0,_a_2)], dtype=numpy.dtype(numpy.int64)),numpy.zeros((0,), dtype=numpy.dtype(numpy.int64)),numpy.zeros((0,), dtype=numpy.dtype(numpy.float64)))
  def __acon_1allocate_alt__3JII_3D_3I_3I(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.int32(_t__a_1)
   _a_2=numpy.int32(_t__a_2)
   _a_3=numpy.array(_t__a_3,dtype=numpy.dtype(numpy.float64))
   _a_4=numpy.array(_t__a_4,dtype=numpy.dtype(numpy.int32))
   _a_5=numpy.array(_t__a_5,dtype=numpy.dtype(numpy.int32))
   _1_res = self.__acon_1allocate__3JII_3D_3I_3I(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_3[:] = _a_3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_4[:] = _a_4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_5[:] = _a_5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __acon_1allocate__3JII_3D_3I_3I(self,_a_0,_a_1,_a_2,_a_3,_a_4,_a_5):
   _a_6=(_a_2 * _a_1)
   _a_7=numpy.zeros((_a_6,), dtype=numpy.dtype(numpy.int32))
   _a_8=self.__acon_block_map._alloc_I(_a_6)
   _a_9=self.__acc_block_map._alloc_I(_a_2)
   _a_10=self.__afe_1allocate__3I(_a_4)
   self.__acon_block_map._get_I_3II(_a_8,_a_7,0)
   self.__acc_block_map._get_I_3II(_a_9,_a_5,0)
   _a_11=self.__acon_block_map._block_1capacity_()
   _a_12=self.__acon_block_map._capacity_()
   if (_a_11 > int((self.__acon_acc).shape[0])):
    _a_13=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.int32))
    _a_14=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__acon_acc,0,_a_13,0,int((self.__acon_acc).shape[0]))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__acon_afe,0,_a_14,0,int((self.__acon_afe).shape[0]))
    self.__acon_acc = _a_13
    self.__acon_afe = _a_14
   self.__acon_acc[_a_8] = _a_9
   self.__acon_afe[_a_8] = _a_10
   if (_a_8 >= int((self.__acons).shape[0])):
    _a_15=numpy.array([None for _a_16 in range(0,(int((self.__acons).shape[0]) * 2))], dtype=numpy.dtype(object))
    for _a_17 in range(0,int((self.__acons).shape[0])):
     _a_15[_a_17] = self.__acons[_a_17]
    self.__acons = _a_15
   if (_a_12 > int((self.__acon_elm_accid).shape[0])):
    _a_18=numpy.zeros((_a_12,), dtype=numpy.dtype(numpy.int32))
    _a_19=numpy.zeros((_a_12,), dtype=numpy.dtype(numpy.float64))
    _a_20=numpy.zeros((_a_12,), dtype=numpy.dtype(numpy.int32))
    _a_21=numpy.zeros((_a_12,), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__acon_elm_accid,0,_a_18,0,int((self.__acon_elm_accid).shape[0]))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.__acon_elm_scale,0,_a_19,0,int((self.__acon_elm_scale).shape[0]))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__acon_elm_ofs,0,_a_20,0,int((self.__acon_elm_ofs).shape[0]))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__acon_elm_afe,0,_a_21,0,int((self.__acon_elm_afe).shape[0]))
    self.__acon_elm_accid = _a_18
    self.__acon_elm_ofs = _a_20
    self.__acon_elm_afe = _a_21
    self.__acon_elm_scale = _a_19
   _a_22=0
   _a_22 = fragments._c_closure_3(_a_5,_a_22)
   _a_22 = numpy.int32(_a_22) # postprocess
   _a_22 += 1
   _a_23=self._task_1numacc_()
   if (_a_23 < _a_22):
    self._task_1append_1accs_JI_3J_3D(0,(_a_22 - _a_23),numpy.zeros((0,), dtype=numpy.dtype(numpy.int64)),numpy.zeros((0,), dtype=numpy.dtype(numpy.float64)))
   self._task_1putacclist__3J_3J_3J_3D(numpy.array([_a_5[_a_24] for _a_24 in range(0,int((_a_5).shape[0]))], dtype=numpy.dtype(numpy.int64)),_a_0,numpy.array([_a_4[_a_25] for _a_25 in range(0,int((_a_4).shape[0]))], dtype=numpy.dtype(numpy.int64)),_a_3)
   fragments._c_closure_4(_a_5,self.__acon_elm_accid,self.__acon_elm_afe,self.__acon_elm_ofs,self.__acon_elm_scale,_a_7,_a_4,_a_1,_a_2) 
   return numpy.int32(_a_8)
  def __afe_1release_alt_I(self,_t__a_0):
    return self.__afe_1release_I(numpy.int32(__a_0))
  def __afe_1release_I(self,_a_0):
   _a_1=numpy.zeros((self.__afe_blocks._blocksize_I(_a_0),), dtype=numpy.dtype(numpy.int32))
   self.__afe_blocks._release_I_3I(_a_0,_a_1)
   self._task_1clearafelist__3J(numpy.array([_a_1[_a_2] for _a_2 in range(0,int((_a_1).shape[0]))], dtype=numpy.dtype(numpy.int64)))
  def __afe_1allocate_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self.__afe_1allocate__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __afe_1allocate__3I(self,_a_0):
   _a_1=self.__afe_blocks._allocate__3I(_a_0)
   if (int((_a_0).shape[0]) > 0):
    _a_2=self._task_1numafe_()
    _a_3=_a_0[0]
    _a_3 = fragments._c_closure_5(_a_3,_a_0)
    _a_3 = numpy.int32(_a_3) # postprocess
    if ((_a_3 + 1) > _a_2):
     _a_4=((_a_3 + 1) - _a_2)
     self._task_1append_1afes_J(_a_4)
     self.__task_numaferow += _a_4
   return numpy.int32(_a_1)
  def __con_1release_alt_I(self,_t__a_0):
    return self.__con_1release_I(numpy.int32(__a_0))
  def __con_1release_I(self,_a_0):
   _a_1=self.__con_blocks._blocksize_I(_a_0)
   if (_a_1 >= 0):
    _a_2=numpy.zeros((_a_1,), dtype=numpy.dtype(numpy.int32))
    self.__con_blocks._release_I_3I(_a_0,_a_2)
    self.__cons[_a_0] = None
    self._task_1con_1putboundlist_1fr__3I(_a_2)
  def __con_1allocate_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self.__con_1allocate__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __con_1allocate__3I(self,_a_0):
   _a_1=self.__con_blocks._allocate__3I(_a_0)
   if (int((_a_0).shape[0]) > 0):
    _a_2=_a_0[0]
    _a_2 = fragments._c_closure_6(_a_2,_a_0)
    _a_2 = numpy.int32(_a_2) # postprocess
    if ((_a_2 + 1) > self.__num_task_con):
     _a_3=((_a_2 + 1) - self.__num_task_con)
     self._task_1append_1con_I(_a_3)
     self.__num_task_con += _a_3
   if (_a_1 >= int((self.__cons).shape[0])):
    _a_4=numpy.array([None for _a_5 in range(0,(int((self.__cons).shape[0]) * 2))], dtype=numpy.dtype(object))
    for _a_6 in range(0,int((self.__cons).shape[0])):
     _a_4[_a_6] = self.__cons[_a_6]
    self.__cons = _a_4
   return numpy.int32(_a_1)
  def __barvar_1alloc_alt_II_3I_3J(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.int32(_t__a_1)
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _a_3=numpy.array(_t__a_3,dtype=numpy.dtype(numpy.int64))
   _1_res = self.__barvar_1alloc_II_3I_3J(_a_0,_a_1,_a_2,_a_3)
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_3[:] = _a_3
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __barvar_1alloc_II_3I_3J(self,_a_0,_a_1,_a_2,_a_3):
   _a_4=self.__barvar_num
   self.__barvar_num += 1
   _a_5=((_a_0 * (_a_0 + 1)) // 2)
   _a_6=(_a_5 * _a_1)
   _a_7=self.__barvar_block_ptr[_a_4]
   _a_8=int((self.__barvar_block_dim).shape[0])
   _a_9=self.__barvar_block_elm_ptr[_a_4]
   _a_10=int((self.__barvar_block_elm_barj).shape[0])
   if (_a_8 < (_a_7 + 1)):
    _a_11=numpy.zeros(((int((self.__barvar_block_dim).shape[0]) * 2),), dtype=numpy.dtype(numpy.int32))
    _a_12=numpy.zeros((((int((self.__barvar_block_dim).shape[0]) * 2) + 1),), dtype=numpy.dtype(numpy.int32))
    _a_13=numpy.zeros((((int((self.__barvar_block_dim).shape[0]) * 2) + 1),), dtype=numpy.dtype(numpy.int32))
    _a_14=numpy.array([None for _a_15 in range(0,((int((self.__barvar_block_dim).shape[0]) * 2) + 1))], dtype=numpy.dtype(object))
    for _a_16 in range(0,int((self.__barvars).shape[0])):
     _a_14[_a_16] = self.__barvars[_a_16]
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__barvar_block_dim,0,_a_11,0,int((self.__barvar_block_dim).shape[0]))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__barvar_block_ptr,0,_a_12,0,int((self.__barvar_block_ptr).shape[0]))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__barvar_block_elm_ptr,0,_a_13,0,int((self.__barvar_block_elm_ptr).shape[0]))
    self.__barvar_block_dim = _a_11
    self.__barvar_block_ptr = _a_12
    self.__barvar_block_elm_ptr = _a_13
    self.__barvars = _a_14
   if (_a_10 < (_a_9 + _a_6)):
    _a_17=((_a_10 + _a_6) - _a_9)
    if (_a_17 < _a_10):
     _a_17 = _a_10
    _a_18=(_a_10 + _a_17)
    _a_19=numpy.zeros((_a_18,), dtype=numpy.dtype(numpy.int32))
    _a_20=numpy.zeros((_a_18,), dtype=numpy.dtype(numpy.int32))
    _a_21=numpy.zeros((_a_18,), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__barvar_block_elm_barj,0,_a_19,0,int((self.__barvar_block_elm_barj).shape[0]))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__barvar_block_elm_i,0,_a_20,0,int((self.__barvar_block_elm_i).shape[0]))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__barvar_block_elm_j,0,_a_21,0,int((self.__barvar_block_elm_j).shape[0]))
    self.__barvar_block_elm_barj = _a_19
    self.__barvar_block_elm_i = _a_20
    self.__barvar_block_elm_j = _a_21
   _a_22=self._task_1numbarvar_()
   fragments._c_closure_7(_a_2,_a_22,_a_1) 
   if ((_a_22 + _a_1) >= int((self.__barvar_dim).shape[0])):
    _a_23=((_a_22 + _a_1) - int((self.__barvar_dim).shape[0]))
    if (_a_23 < int((self.__barvar_dim).shape[0])):
     _a_23 = int((self.__barvar_dim).shape[0])
    _a_24=(_a_23 + int((self.__barvar_dim).shape[0]))
    _a_25=numpy.zeros((_a_24,), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__barvar_dim,0,_a_25,0,int((self.__barvar_dim).shape[0]))
    self.__barvar_dim = _a_25
   self.__barvar_block_dim[_a_4] = _a_0
   self.__barvar_block_ptr[(_a_4 + 1)] = (self.__barvar_block_ptr[_a_4] + _a_1)
   self.__barvar_block_elm_ptr[(_a_4 + 1)] = (self.__barvar_block_elm_ptr[_a_4] + _a_6)
   fragments._c_closure_8(self.__barvar_block_elm_barj,self.__barvar_block_elm_i,self.__barvar_block_elm_j,self.__barvar_block_elm_ptr,self.__barvar_dim,_a_4,_a_0,_a_22,_a_3,_a_1) 
   _a_26=self._task_1append_1barvar_II(_a_0,_a_1)
   return numpy.int32(_a_4)
  def __conicvar_1alloc_alt__3JII_3I_3I(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.int32(_t__a_1)
   _a_2=numpy.int32(_t__a_2)
   _a_3=numpy.array(_t__a_3,dtype=numpy.dtype(numpy.int32))
   _a_4=numpy.array(_t__a_4,dtype=numpy.dtype(numpy.int32))
   _1_res = self.__conicvar_1alloc__3JII_3I_3I(_a_0,_a_1,_a_2,_a_3,_a_4)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_3[:] = _a_3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_4[:] = _a_4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __conicvar_1alloc__3JII_3I_3I(self,_a_0,_a_1,_a_2,_a_3,_a_4):
   _a_5=(_a_1 * _a_2)
   _a_6=self.__linearvar_1alloc_I_3I(_a_5,_a_4)
   _a_7=numpy.zeros((_a_5,), dtype=numpy.dtype(numpy.float64))
   _a_8=numpy.zeros((_a_5,), dtype=numpy.dtype(numpy.int32))
   _a_9=numpy.zeros((_a_5,), dtype=numpy.dtype(numpy.int32))
   _a_10=self.__acon_1allocate__3JII_3D_3I_3I(_a_0,_a_1,_a_2,_a_7,_a_9,_a_3)
   self.__var_block_acc_id[_a_6] = _a_10
   fragments._c_closure_9(_a_3,_a_1,_a_5,_a_4,self.__var_elm_acc_idx,self.__var_elm_acc_ofs) 
   self._task_1putafeflist__3J_3I_3I_3D_3D(numpy.array([_a_9[_a_11] for _a_11 in range(0,int((_a_9).shape[0]))], dtype=numpy.dtype(numpy.int64)),numpy.array([_a_12 for _a_12 in range(0,(_a_5 + 1))], dtype=numpy.dtype(numpy.int32)),_a_4,numpy.array([1.0 for _a_13 in range(0,_a_5)], dtype=numpy.dtype(numpy.float64)),numpy.array([0.0 for _a_14 in range(0,_a_5)], dtype=numpy.dtype(numpy.float64)))
   return numpy.int32(_a_6)
  def __linearvar_1alloc_alt_I_3I(self,_t__a_0,_t__a_1):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = self.__linearvar_1alloc_I_3I(_a_0,_a_1)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __linearvar_1alloc_I_3I(self,_a_0,_a_1):
   _a_2=self.__var_block_map._alloc_I(_a_0)
   _a_3=(self.__var_block_map._maxidx_I(_a_2) + 1)
   _a_4=self.__var_block_map._capacity_()
   _a_5=self.__var_block_map._block_1capacity_()
   self.__var_block_map._get_I_3II(_a_2,_a_1,0)
   if (self._task_1numvar_() < _a_3):
    self._task_1append_1var_I((_a_3 - self._task_1numvar_()))
   if (_a_2 >= int((self.__vars).shape[0])):
    _a_6=numpy.array([None for _a_7 in range(0,(int((self.__vars).shape[0]) * 2))], dtype=numpy.dtype(object))
    for _a_8 in range(0,int((self.__vars).shape[0])):
     _a_6[_a_8] = self.__vars[_a_8]
    self.__vars = _a_6
   if (_a_5 > int((self.__var_block_acc_id).shape[0])):
    _a_9=numpy.zeros((_a_5,), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__var_block_acc_id,0,_a_9,0,int((self.__var_block_acc_id).shape[0]))
    self.__var_block_acc_id = _a_9
   if (_a_4 > int((self.__var_elm_acc_idx).shape[0])):
    _a_10=numpy.zeros((_a_4,), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__var_elm_acc_idx,0,_a_10,0,int((self.__var_elm_acc_idx).shape[0]))
    self.__var_elm_acc_idx = _a_10
    _a_11=numpy.zeros((_a_4,), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__var_elm_acc_ofs,0,_a_11,0,int((self.__var_elm_acc_ofs).shape[0]))
    self.__var_elm_acc_ofs = _a_11
   self.__var_block_acc_id[_a_2] = (- 1)
   fragments._c_closure_10(_a_0,_a_1,self.__var_elm_acc_idx) 
   return numpy.int32(_a_2)
  def _make_1continuous_alt__3J(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _1_res = self._make_1continuous__3J(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _make_1continuous__3J(self,_a_0):
   _a_1=0
   _a_1 = fragments._c_closure_11(_a_1,_a_0)
   _a_1 = numpy.int32(_a_1) # postprocess
   _a_2=numpy.zeros((_a_1,), dtype=numpy.dtype(numpy.int32))
   _a_3=0
   _a_3 = fragments._c_closure_12(_a_0,_a_3,_a_2)
   _a_3 = numpy.int32(_a_3) # postprocess
   self._task_1var_1putcontlist__3I(_a_2)
  def _make_1integer_alt__3J(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _1_res = self._make_1integer__3J(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _make_1integer__3J(self,_a_0):
   _a_1=0
   _a_1 = fragments._c_closure_13(_a_1,_a_0)
   _a_1 = numpy.int32(_a_1) # postprocess
   _a_2=numpy.zeros((_a_1,), dtype=numpy.dtype(numpy.int32))
   _a_3=0
   _a_3 = fragments._c_closure_14(_a_0,_a_3,_a_2)
   _a_3 = numpy.int32(_a_3) # postprocess
   self._task_1var_1putintlist__3I(_a_2)
  @staticmethod
  def _match_putlicensewait_Z(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Z__(_a_0))
  @staticmethod
  def _match_alt_putlicensewait_Z(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Z__(_a_0))
  @staticmethod
  def _putlicensewait_alt_Z(_t__a_0):
    return mosek_fusion_Model._putlicensewait_Z(_a_0)
  @staticmethod
  def _putlicensewait_Z(_a_0):
   mosek.fusion.BaseModel._env_1putlicensewait_Z(_a_0)
  @staticmethod
  def _match_putlicensepath_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_S__(_a_0))
  @staticmethod
  def _match_alt_putlicensepath_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_S__(_a_0))
  @staticmethod
  def _putlicensepath_alt_S(_t__a_0):
    return mosek_fusion_Model._putlicensepath_S(_a_0)
  @staticmethod
  def _putlicensepath_S(_a_0):
   mosek.fusion.BaseModel._env_1putlicensepath_S(_a_0)
  @staticmethod
  def _match_putlicensecode__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_putlicensecode__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  @staticmethod
  def _putlicensecode_alt__3I(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Model._putlicensecode__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _putlicensecode__3I(_a_0):
   mosek.fusion.BaseModel._env_1putlicensecode__3I(_a_0)
  @staticmethod
  def _match_dispose_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dispose_(*args):
    if len(args) != 0: return False
    return True
  def _dispose_alt_(self,):
    return self._dispose_()
  def _dispose_(self,):
   for _a_0 in range(0,int((self.__vars).shape[0])):
    self.__vars[_a_0] = None
   for _a_1 in range(0,int((self.__cons).shape[0])):
    self.__cons[_a_1] = None
   for _a_2 in range(0,int((self.__acons).shape[0])):
    self.__acons[_a_2] = None
   for _a_3 in range(0,int((self.__barvars).shape[0])):
    self.__barvars[_a_3] = None
   if (self.__parameters is not None):
    for _a_4 in range(0,int((self.__parameters).shape[0])):
     self.__parameters[_a_4] = None
   mosek_fusion_BaseModel._dispose_(self)
  @staticmethod
  def _match_getTask_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getTask_(*args):
    if len(args) != 0: return False
    return True
  def _getTask_alt_(self,):
    return self._getTask_()
  def _getTask_(self,):
   return (self._task_1get_())
  @staticmethod
  def _match_getConstraintDuals_Z_3I_3DI(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_Z__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3D__(_a_2) and __arg_match_I__(_a_3))
  @staticmethod
  def _match_alt_getConstraintDuals_Z_3I_3DI(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_Z__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3D__(_a_2) and __arg_alt_match_I__(_a_3))
  def _getConstraintDuals_alt_Z_3I_3DI(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.float64))
   _a_3=numpy.int32(_t__a_3)
   _1_res = self._getConstraintDuals_Z_3I_3DI(_a_0,_a_1,_a_2,_a_3)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _getConstraintDuals_Z_3I_3DI(self,_a_0,_a_1,_a_2,_a_3):
   _a_4=int((_a_1).shape[0])
   _a_5=self._getSolution_1slc_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   _a_6=self._getSolution_1suc_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   for _a_7 in range(0,_a_4):
    if (_a_1[_a_7] >= 0):
     if _a_0:
      _a_2[(_a_3 + _a_7)] = _a_5[_a_1[_a_7]]
     else:
      _a_2[(_a_3 + _a_7)] = (- _a_6[_a_1[_a_7]])
    else:
     raise mosek_fusion_SolutionError._ctor_S("Requested invalid solution item")
  @staticmethod
  def _match_getConstraintValues_Z_3I_3DI(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_Z__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3D__(_a_2) and __arg_match_I__(_a_3))
  @staticmethod
  def _match_alt_getConstraintValues_Z_3I_3DI(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_Z__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3D__(_a_2) and __arg_alt_match_I__(_a_3))
  def _getConstraintValues_alt_Z_3I_3DI(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.float64))
   _a_3=numpy.int32(_t__a_3)
   _1_res = self._getConstraintValues_Z_3I_3DI(_a_0,_a_1,_a_2,_a_3)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _getConstraintValues_Z_3I_3DI(self,_a_0,_a_1,_a_2,_a_3):
   _a_4=int((_a_1).shape[0])
   if _a_0:
    _a_5=self._getSolution_1xc_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    _a_6=self._getSolution_1accx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    _a_7=self._getSolution_1accptr_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    fragments._c_closure_15(_a_7,_a_6,self.__acon_elm_accid,self.__acon_elm_ofs,self.__acon_elm_scale,_a_4,_a_1,_a_3,_a_2,_a_5) 
   else:
    _a_8=self._getSolution_1y_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    _a_9=self._getSolution_1accy_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    _a_10=self._getSolution_1accptr_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    fragments._c_closure_16(_a_10,_a_9,self.__acon_elm_accid,self.__acon_elm_ofs,self.__acon_elm_scale,_a_4,_a_1,_a_3,_a_2,_a_8) 
  @staticmethod
  def _match_getVariableDuals_Z_3J_3DI(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_Z__(_a_0) and __arg_match__3J__(_a_1) and __arg_match__3D__(_a_2) and __arg_match_I__(_a_3))
  @staticmethod
  def _match_alt_getVariableDuals_Z_3J_3DI(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_Z__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match__3D__(_a_2) and __arg_alt_match_I__(_a_3))
  def _getVariableDuals_alt_Z_3J_3DI(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.float64))
   _a_3=numpy.int32(_t__a_3)
   _1_res = self._getVariableDuals_Z_3J_3DI(_a_0,_a_1,_a_2,_a_3)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _getVariableDuals_Z_3J_3DI(self,_a_0,_a_1,_a_2,_a_3):
   _a_4=int((_a_1).shape[0])
   if _a_0:
    _a_5=self._getSolution_1slx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    fragments._c_closure_17(_a_4,_a_1,_a_3,_a_2,_a_5) 
   else:
    _a_6=self._getSolution_1sux_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    fragments._c_closure_18(_a_4,_a_1,_a_3,_a_2,_a_6) 
  @staticmethod
  def _match_getVariableValues_Z_3J_3DI(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_Z__(_a_0) and __arg_match__3J__(_a_1) and __arg_match__3D__(_a_2) and __arg_match_I__(_a_3))
  @staticmethod
  def _match_alt_getVariableValues_Z_3J_3DI(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_Z__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match__3D__(_a_2) and __arg_alt_match_I__(_a_3))
  def _getVariableValues_alt_Z_3J_3DI(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.float64))
   _a_3=numpy.int32(_t__a_3)
   _1_res = self._getVariableValues_Z_3J_3DI(_a_0,_a_1,_a_2,_a_3)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _getVariableValues_Z_3J_3DI(self,_a_0,_a_1,_a_2,_a_3):
   _a_4=int((_a_1).shape[0])
   self.__barvar_num = self._task_1numbarvar_()
   if _a_0:
    _a_5=self._getSolution_1xx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    _a_6=(self._getSolution_1barx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default) if ((self.__barvar_num > 0) ) else None)
    fragments._c_closure_19(_a_6,_a_4,_a_1,_a_3,_a_2,_a_5) 
   else:
    _a_7=self._getSolution_1yx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    _a_8=(self._getSolution_1bars_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default) if ((self.__barvar_num > 0) ) else None)
    _a_9=self._getSolution_1accy_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    _a_10=self._getSolution_1accptr_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    fragments._c_closure_20(_a_10,_a_9,_a_8,_a_4,_a_1,_a_3,_a_2,self.__var_elm_acc_idx,self.__var_elm_acc_ofs,_a_7) 
  @staticmethod
  def _match_setVariableValues_Z_3J_3D(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_Z__(_a_0) and __arg_match__3J__(_a_1) and __arg_match__3D__(_a_2))
  @staticmethod
  def _match_alt_setVariableValues_Z_3J_3D(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_Z__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match__3D__(_a_2))
  def _setVariableValues_alt_Z_3J_3D(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.float64))
   _1_res = self._setVariableValues_Z_3J_3D(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _setVariableValues_Z_3J_3D(self,_a_0,_a_1,_a_2):
   if _a_0:
    _a_3=0
    _a_3 = fragments._c_closure_21(_a_1,_a_3)
    _a_3 = numpy.int32(_a_3) # postprocess
    _a_4=numpy.zeros((_a_3,), dtype=numpy.dtype(numpy.int32))
    _a_5=numpy.zeros((_a_3,), dtype=numpy.dtype(numpy.float64))
    _a_6=0
    _a_6 = fragments._c_closure_22(_a_6,_a_1,_a_4,_a_5,_a_2)
    _a_6 = numpy.int32(_a_6) # postprocess
    self._setSolution_1xx__3I_3D(_a_4,_a_5)
   else:
    pass
  @staticmethod
  def _match_writeTaskNoFlush_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_S__(_a_0))
  @staticmethod
  def _match_alt_writeTaskNoFlush_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_S__(_a_0))
  def _writeTaskNoFlush_alt_S(self,_t__a_0):
    return self._writeTaskNoFlush_S(_a_0)
  def _writeTaskNoFlush_S(self,_a_0):
   self._task_1write_S(_a_0)
  @staticmethod
  def _match_writeTaskStream_SLSystem_4DataStream_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_LSystem_4DataStream_2__(_a_1))
  @staticmethod
  def _match_alt_writeTaskStream_SLSystem_4DataStream_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_LSystem_4DataStream_2__(_a_1))
  def _writeTaskStream_alt_SLSystem_4DataStream_2(self,_t__a_0,_t__a_1):
    return self._writeTaskStream_SLSystem_4DataStream_2(_a_0,_a_1)
  def _writeTaskStream_SLSystem_4DataStream_2(self,_a_0,_a_1):
   self.__flush_1parameters_()
   self._task_1write_1stream_SLSystem_4DataStream_2(_a_0,_a_1)
  @staticmethod
  def _match_expressionCache_Z(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Z__(_a_0))
  @staticmethod
  def _match_alt_expressionCache_Z(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Z__(_a_0))
  def _expressionCache_alt_Z(self,_t__a_0):
    return self._expressionCache_Z(_a_0)
  def _expressionCache_Z(self,_a_0):
   self.__cache_evaluations = _a_0
  @staticmethod
  def _match_dataReport_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dataReport_(*args):
    if len(args) != 0: return False
    return True
  def _dataReport_alt_(self,):
    return self._dataReport_()
  def _dataReport_(self,):
   self._dataReport_I(10)
  @staticmethod
  def _match_dataReport_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_dataReport_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _dataReport_alt_I(self,_t__a_0):
    return self._dataReport_I(numpy.int32(__a_0))
  def _dataReport_I(self,_a_0):
   self.__flush_1parameters_()
   self._task_1analyze_1problem_I(_a_0)
  @staticmethod
  def _match_writeTask_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_S__(_a_0))
  @staticmethod
  def _match_alt_writeTask_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_S__(_a_0))
  def _writeTask_alt_S(self,_t__a_0):
    return self._writeTask_S(_a_0)
  def _writeTask_S(self,_a_0):
   self.__flush_1parameters_()
   self._task_1write_S(_a_0)
  @staticmethod
  def _match_getSolverLIntInfo_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_S__(_a_0))
  @staticmethod
  def _match_alt_getSolverLIntInfo_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_S__(_a_0))
  def _getSolverLIntInfo_alt_S(self,_t__a_0):
    return self._getSolverLIntInfo_S(_a_0)
  def _getSolverLIntInfo_S(self,_a_0):
   return numpy.int64(self._task_1get_1liinf_S(_a_0))
  @staticmethod
  def _match_getSolverIntInfo_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_S__(_a_0))
  @staticmethod
  def _match_alt_getSolverIntInfo_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_S__(_a_0))
  def _getSolverIntInfo_alt_S(self,_t__a_0):
    return self._getSolverIntInfo_S(_a_0)
  def _getSolverIntInfo_S(self,_a_0):
   return numpy.int32(self._task_1get_1iinf_S(_a_0))
  @staticmethod
  def _match_getSolverDoubleInfo_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_S__(_a_0))
  @staticmethod
  def _match_alt_getSolverDoubleInfo_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_S__(_a_0))
  def _getSolverDoubleInfo_alt_S(self,_t__a_0):
    return self._getSolverDoubleInfo_S(_a_0)
  def _getSolverDoubleInfo_S(self,_a_0):
   return numpy.float64(self._task_1get_1dinf_S(_a_0))
  @staticmethod
  def _match_setCallbackHandler_LSystem_4CallbackHandler_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_LSystem_4CallbackHandler_2__(_a_0))
  @staticmethod
  def _match_alt_setCallbackHandler_LSystem_4CallbackHandler_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_LSystem_4CallbackHandler_2__(_a_0))
  def _setCallbackHandler_alt_LSystem_4CallbackHandler_2(self,_t__a_0):
    return self._setCallbackHandler_LSystem_4CallbackHandler_2(_a_0)
  def _setCallbackHandler_LSystem_4CallbackHandler_2(self,_a_0):
   self._task_1setCallbackHandler_LSystem_4CallbackHandler_2(_a_0)
  @staticmethod
  def _match_setDataCallbackHandler_LSystem_4DataCallbackHandler_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_LSystem_4DataCallbackHandler_2__(_a_0))
  @staticmethod
  def _match_alt_setDataCallbackHandler_LSystem_4DataCallbackHandler_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_LSystem_4DataCallbackHandler_2__(_a_0))
  def _setDataCallbackHandler_alt_LSystem_4DataCallbackHandler_2(self,_t__a_0):
    return self._setDataCallbackHandler_LSystem_4DataCallbackHandler_2(_a_0)
  def _setDataCallbackHandler_LSystem_4DataCallbackHandler_2(self,_a_0):
   self._task_1setDataCallbackHandler_LSystem_4DataCallbackHandler_2(_a_0)
  @staticmethod
  def _match_setLogHandler_LSystem_4StreamWriter_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_LSystem_4StreamWriter_2__(_a_0))
  @staticmethod
  def _match_alt_setLogHandler_LSystem_4StreamWriter_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_LSystem_4StreamWriter_2__(_a_0))
  def _setLogHandler_alt_LSystem_4StreamWriter_2(self,_t__a_0):
    return self._setLogHandler_LSystem_4StreamWriter_2(_a_0)
  def _setLogHandler_LSystem_4StreamWriter_2(self,_a_0):
   self._task_1setLogHandler_LSystem_4StreamWriter_2(_a_0)
  @staticmethod
  def _match_setSolverParam_SD(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_D__(_a_1))
  @staticmethod
  def _match_alt_setSolverParam_SD(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_D__(_a_1))
  def _setSolverParam_alt_SD(self,_t__a_0,_t__a_1):
    return self._setSolverParam_SD(_a_0,numpy.float64(__a_1))
  def _setSolverParam_SD(self,_a_0,_a_1):
   mosek.fusion.Parameters._setParameter_Lmosek_4fusion_4Model_2SD(self,_a_0,_a_1)
  @staticmethod
  def _match_setSolverParam_SI(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_setSolverParam_SI(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_I__(_a_1))
  def _setSolverParam_alt_SI(self,_t__a_0,_t__a_1):
    return self._setSolverParam_SI(_a_0,numpy.int32(__a_1))
  def _setSolverParam_SI(self,_a_0,_a_1):
   mosek.fusion.Parameters._setParameter_Lmosek_4fusion_4Model_2SI(self,_a_0,_a_1)
  @staticmethod
  def _match_setSolverParam_SS(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_S__(_a_1))
  @staticmethod
  def _match_alt_setSolverParam_SS(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_S__(_a_1))
  def _setSolverParam_alt_SS(self,_t__a_0,_t__a_1):
    return self._setSolverParam_SS(_a_0,_a_1)
  def _setSolverParam_SS(self,_a_0,_a_1):
   mosek.fusion.Parameters._setParameter_Lmosek_4fusion_4Model_2SS(self,_a_0,_a_1)
  @staticmethod
  def _match_breakSolver_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_breakSolver_(*args):
    if len(args) != 0: return False
    return True
  def _breakSolver_alt_(self,):
    return self._breakSolver_()
  def _breakSolver_(self,):
   self._task_1break_1solve_()
  @staticmethod
  def _match_optserverHost_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_S__(_a_0))
  @staticmethod
  def _match_alt_optserverHost_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_S__(_a_0))
  def _optserverHost_alt_S(self,_t__a_0):
    return self._optserverHost_S(_a_0)
  def _optserverHost_S(self,_a_0):
   self._task_1putoptserver_1host_S(_a_0)
  def _report_1solution_alt_Emosek_4fusion_4SolutionType_2Emosek_4fusion_4ProblemStatus_2Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4SolutionStatus_2DDIIIIIZZ(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5,_t__a_6,_t__a_7,_t__a_8,_t__a_9,_t__a_10,_t__a_11,_t__a_12):
    return self._report_1solution_Emosek_4fusion_4SolutionType_2Emosek_4fusion_4ProblemStatus_2Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4SolutionStatus_2DDIIIIIZZ(__a_0,__a_1,__a_2,__a_3,numpy.float64(__a_4),numpy.float64(__a_5),numpy.int32(__a_6),numpy.int32(__a_7),numpy.int32(__a_8),numpy.int32(__a_9),numpy.int32(__a_10),_a_11,_a_12)
  def _report_1solution_Emosek_4fusion_4SolutionType_2Emosek_4fusion_4ProblemStatus_2Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4SolutionStatus_2DDIIIIIZZ(self,_a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7,_a_8,_a_9,_a_10,_a_11,_a_12):
   if (_a_0==mosek.fusion.SolutionType.Interior):
    _a_13 = self.__sol_itr
   elif (_a_0==mosek.fusion.SolutionType.Basic):
    _a_13 = self.__sol_bas
   elif (_a_0==mosek.fusion.SolutionType.Integer):
    _a_13 = self.__sol_itg
   else:
    _a_13 = None
   if (_a_13 is None):
    _a_13 = mosek_fusion_SolutionStruct._ctor_IIIII(_a_6,_a_7,_a_8,_a_9,_a_10)
   else:
    _a_13._resize_IIIII(_a_6,_a_7,_a_8,_a_9,_a_10)
   (_a_13.pobj) = _a_4
   (_a_13.dobj) = _a_5
   (_a_13.pstatus) = _a_2
   (_a_13.dstatus) = _a_3
   (_a_13.probstatus) = _a_1
   if (_a_6 > 0):
    if _a_11:
     self._report_1solution_1get_1xx__3D((_a_13.xx))
    if _a_12:
     self._report_1solution_1get_1slx__3D((_a_13.slx))
     self._report_1solution_1get_1sux__3D((_a_13.sux))
     _a_14=(_a_13.yx)
     _a_15=(_a_13.slx)
     _a_16=(_a_13.sux)
     fragments._c_closure_23(_a_6,_a_15,_a_16,_a_14) 
   if (_a_7 > 0):
    if _a_11:
     self._report_1solution_1get_1xc__3D((_a_13.xc))
    if _a_12:
     self._report_1solution_1get_1slc__3D((_a_13.slc))
     self._report_1solution_1get_1suc__3D((_a_13.suc))
     _a_17=(_a_13.y)
     _a_18=(_a_13.slc)
     _a_19=(_a_13.suc)
     fragments._c_closure_24(_a_7,_a_18,_a_19,_a_17) 
   if (_a_8 > 0):
    if _a_11:
     self._report_1solution_1get_1barx__3D((_a_13.barx))
    if _a_12:
     self._report_1solution_1get_1bars__3D((_a_13.bars))
   if (self._task_1numacc_() > 0):
    self._report_1solution_1get_1accptr__3I((_a_13.accptr))
    if _a_11:
     self._report_1solution_1get_1accx__3D((_a_13.accx))
    if _a_12:
     self._report_1solution_1get_1accy__3D((_a_13.accy))
   if (_a_0==mosek.fusion.SolutionType.Interior):
    self.__sol_itr = _a_13
   elif (_a_0==mosek.fusion.SolutionType.Basic):
    self.__sol_bas = _a_13
   elif (_a_0==mosek.fusion.SolutionType.Integer):
    self.__sol_itg = _a_13
  def _clear_1solutions_alt_(self,):
    return self._clear_1solutions_()
  def _clear_1solutions_(self,):
   self.__sol_itr = None
   self.__sol_itg = None
   self.__sol_bas = None
  @staticmethod
  def _match_solveBatch_ZDI_3Lmosek_4fusion_4Model_2(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_Z__(_a_0) and __arg_match_D__(_a_1) and __arg_match_I__(_a_2) and __arg_match__3Lmosek_4fusion_4Model_2__(_a_3))
  @staticmethod
  def _match_alt_solveBatch_ZDI_3Lmosek_4fusion_4Model_2(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_Z__(_a_0) and __arg_alt_match_D__(_a_1) and __arg_alt_match_I__(_a_2) and __arg_alt_match__3Lmosek_4fusion_4Model_2__(_a_3))
  @staticmethod
  def _solveBatch_alt_ZDI_3Lmosek_4fusion_4Model_2(_t__a_0,_t__a_1,_t__a_2,_t__a_3):
   _a_0=_t__a_0
   _a_1=numpy.float64(_t__a_1)
   _a_2=numpy.int32(_t__a_2)
   _a_3=numpy.array(_t__a_3,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_Model._solveBatch_ZDI_3Lmosek_4fusion_4Model_2(_a_0,_a_1,_a_2,_a_3)
   try:
     _t__a_3[:] = _a_3
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _solveBatch_ZDI_3Lmosek_4fusion_4Model_2(_a_0,_a_1,_a_2,_a_3):
   _a_4=int((_a_3).shape[0])
   for _a_5 in range(0,_a_4):
    if (_a_3[_a_5] is None):
     raise mosek_fusion_OptimizeError._ctor_S("One of the models is a null object")
   for _a_6 in range(0,_a_4):
    _a_3[_a_6]._flushSolutions_()
    _a_3[_a_6].__flush_1parameters_()
   _a_7=mosek.fusion.BaseModel._env_1solve_1batch_ZDI_3Lmosek_4fusion_4Model_2(_a_0,_a_1,_a_2,_a_3)
   for _a_8 in range(0,_a_4):
    _a_3[_a_8]._task_1post_1solve_()
   return (_a_7)
  @staticmethod
  def _match_solve_SS(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_S__(_a_1))
  @staticmethod
  def _match_alt_solve_SS(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_S__(_a_1))
  def _solve_alt_SS(self,_t__a_0,_t__a_1):
    return self._solve_SS(_a_0,_a_1)
  def _solve_SS(self,_a_0,_a_1):
   self._flushSolutions_()
   self.__flush_1parameters_()
   self._task_1solve_ZSS(True,_a_0,_a_1)
   self._task_1post_1solve_()
  @staticmethod
  def _match_solve_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_solve_(*args):
    if len(args) != 0: return False
    return True
  def _solve_alt_(self,):
    return self._solve_()
  def _solve_(self,):
   self._flushSolutions_()
   self.__flush_1parameters_()
   self._task_1solve_ZSS(False,"","")
   self._task_1post_1solve_()
  def __flush_1parameters_alt_(self,):
    return self.__flush_1parameters_()
  def __flush_1parameters_(self,):
   _a_0=self.__con_blocks._num_1parameterized_()
   _a_1=self.__afe_blocks._num_1parameterized_()
   _a_2=self.__obj_blocks._num_1parameterized_()
   if (_a_0 > 0):
    _a_3=numpy.zeros((_a_0,), dtype=numpy.dtype(numpy.int32))
    _a_4=numpy.zeros((_a_0,), dtype=numpy.dtype(numpy.int32))
    _a_5=numpy.zeros((_a_0,), dtype=numpy.dtype(numpy.float64))
    self.__con_blocks._evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(self.__xs,self.__param_value,_a_3,_a_4,_a_5)
    self._task_1putaijlist__3I_3I_3DJ(_a_3,_a_4,_a_5,_a_0)
   if (_a_1 > 0):
    _a_6=numpy.zeros((_a_1,), dtype=numpy.dtype(numpy.int32))
    _a_7=numpy.zeros((_a_1,), dtype=numpy.dtype(numpy.int32))
    _a_8=numpy.zeros((_a_1,), dtype=numpy.dtype(numpy.float64))
    self.__afe_blocks._evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(self.__xs,self.__param_value,_a_6,_a_7,_a_8)
    self._task_1putafefijlist__3I_3I_3D(_a_6,_a_7,_a_8)
   if (_a_2 > 0):
    _a_9=numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.int32))
    _a_10=numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.int32))
    _a_11=numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.float64))
    self.__obj_blocks._evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(self.__xs,self.__param_value,_a_9,_a_10,_a_11)
    self._task_1putclist__3I_3D(_a_10,_a_11)
  @staticmethod
  def _match_flushParameters_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_flushParameters_(*args):
    if len(args) != 0: return False
    return True
  def _flushParameters_alt_(self,):
    return self._flushParameters_()
  def _flushParameters_(self,):
   self.__flush_1parameters_()
  def __evaluate_1parameterized_alt_Lmosek_4fusion_4WorkStack_2I_3I_3I_3J_3I_3I_3I_3D_3I_3D(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5,_t__a_6,_t__a_7,_t__a_8,_t__a_9,_t__a_10):
   _a_0=_t__a_0
   _a_1=numpy.int32(_t__a_1)
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _a_3=numpy.array(_t__a_3,dtype=numpy.dtype(numpy.int32))
   _a_4=numpy.array(_t__a_4,dtype=numpy.dtype(numpy.int64))
   _a_5=numpy.array(_t__a_5,dtype=numpy.dtype(numpy.int32))
   _a_6=numpy.array(_t__a_6,dtype=numpy.dtype(numpy.int32))
   _a_7=numpy.array(_t__a_7,dtype=numpy.dtype(numpy.int32))
   _a_8=numpy.array(_t__a_8,dtype=numpy.dtype(numpy.float64))
   _a_9=numpy.array(_t__a_9,dtype=numpy.dtype(numpy.int32))
   _a_10=numpy.array(_t__a_10,dtype=numpy.dtype(numpy.float64))
   _1_res = self.__evaluate_1parameterized_Lmosek_4fusion_4WorkStack_2I_3I_3I_3J_3I_3I_3I_3D_3I_3D(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7,_a_8,_a_9,_a_10)
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_3[:] = _a_3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_4[:] = _a_4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_5[:] = _a_5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_6[:] = _a_6
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_7[:] = _a_7
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_8[:] = _a_8
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_9[:] = _a_9
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_10[:] = _a_10
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __evaluate_1parameterized_Lmosek_4fusion_4WorkStack_2I_3I_3I_3J_3I_3I_3I_3D_3I_3D(self,_a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7,_a_8,_a_9,_a_10):
   _a_11=_a_0._allocf64_I(int((_a_7).shape[0]))
   _a_12=0
   _a_13=(_a_0.f64)
   _a_14=0
   _a_14,_a_12 = fragments._c_closure_25(_a_8,_a_7,_a_4,_a_5,_a_6,_a_14,_a_1,self.__param_value,_a_2,_a_3,_a_11,_a_12,_a_9,_a_10,_a_13)
   _a_14 = numpy.int32(_a_14) # postprocess
   _a_12 = numpy.int32(_a_12) # postprocess
   _a_0._popf64_I(int((_a_7).shape[0]))
  @staticmethod
  def _match_flushSolutions_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_flushSolutions_(*args):
    if len(args) != 0: return False
    return True
  def _flushSolutions_alt_(self,):
    return self._flushSolutions_()
  def _flushSolutions_(self,):
   self.__flush_1initsol_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Interior)
   self.__flush_1initsol_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Integer)
   self.__flush_1initsol_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Basic)
  def __flush_1initsol_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self.__flush_1initsol_Emosek_4fusion_4SolutionType_2(__a_0)
  def __flush_1initsol_Emosek_4fusion_4SolutionType_2(self,_a_0):
   if (self.__initsol_xx is not None):
    _a_1=self._task_1numvar_()
    _a_2=numpy.zeros((_a_1,), dtype=numpy.dtype(numpy.float64))
    try:
     _a_3=self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_a_0,True)
     if ((_a_3.xx) is not None):
      mosek.fusion.Utils.Tools._arraycopy__3DI_3DII((_a_3.xx),0,_a_2,0,(int(((_a_3.xx)).shape[0]) if ((int(((_a_3.xx)).shape[0]) <= _a_1) ) else _a_1))
    except mosek_fusion_SolutionError as _a_4:
     pass
    _a_5=(int((self.__initsol_xx).shape[0]) if ((int((self.__initsol_xx).shape[0]) <= _a_1) ) else _a_1)
    for _a_6 in range(0,_a_5):
     if self.__initsol_xx_flag[_a_6]:
      _a_2[_a_6] = self.__initsol_xx[_a_6]
    _a_2[self.__bfixidx] = 1.0
    self._task_1putxx_1slice_Emosek_4fusion_4SolutionType_2II_3D(_a_0,0,_a_1,_a_2)
  @staticmethod
  def _match_getDualSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getDualSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  def _getDualSolutionStatus_alt_(self,):
    return self._getDualSolutionStatus_()
  def _getDualSolutionStatus_(self,):
   return (self._getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(self.__solutionptr))
  @staticmethod
  def _match_getProblemStatus_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getProblemStatus_(*args):
    if len(args) != 0: return False
    return True
  def _getProblemStatus_alt_(self,):
    return self._getProblemStatus_()
  def _getProblemStatus_(self,):
   return (self._getProblemStatus_Emosek_4fusion_4SolutionType_2(self.__solutionptr))
  @staticmethod
  def _match_getPrimalSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getPrimalSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  def _getPrimalSolutionStatus_alt_(self,):
    return self._getPrimalSolutionStatus_()
  def _getPrimalSolutionStatus_(self,):
   return (self._getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(self.__solutionptr))
  @staticmethod
  def _match_dualObjValue_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dualObjValue_(*args):
    if len(args) != 0: return False
    return True
  def _dualObjValue_alt_(self,):
    return self._dualObjValue_()
  def _dualObjValue_(self,):
   return numpy.float64((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(mosek.fusion.SolutionType.Default,False).dobj))
  @staticmethod
  def _match_primalObjValue_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_primalObjValue_(*args):
    if len(args) != 0: return False
    return True
  def _primalObjValue_alt_(self,):
    return self._primalObjValue_()
  def _primalObjValue_(self,):
   return numpy.float64((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(mosek.fusion.SolutionType.Default,True).pobj))
  def _get_1sol_1cache_alt_Emosek_4fusion_4SolutionType_2ZZ(self,_t__a_0,_t__a_1,_t__a_2):
    return self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2ZZ(__a_0,_a_1,_a_2)
  def _get_1sol_1cache_Emosek_4fusion_4SolutionType_2ZZ(self,_a_0,_a_1,_a_2):
   _a_3=None
   _a_4=_a_0
   if (_a_4==mosek.fusion.SolutionType.Default):
    _a_4 = self.__solutionptr
   if (_a_4==mosek.fusion.SolutionType.Default):
    if (self.__sol_itg is not None):
     _a_3 = self.__sol_itg
    elif (self.__sol_bas is not None):
     _a_3 = self.__sol_bas
    else:
     _a_3 = self.__sol_itr
   elif (_a_4==mosek.fusion.SolutionType.Interior):
    _a_3 = self.__sol_itr
   elif (_a_4==mosek.fusion.SolutionType.Basic):
    _a_3 = self.__sol_bas
   elif (_a_4==mosek.fusion.SolutionType.Integer):
    _a_3 = self.__sol_itg
   if (_a_3 is None):
    raise mosek_fusion_SolutionError._ctor_S("Solution not available")
   else:
    if (_a_2 or ((_a_1 and _a_3._isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(self.__acceptable_sol)) or ((not _a_1) and _a_3._isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(self.__acceptable_sol)))):
     return (_a_3)
    elif ((_a_3 is self.__sol_itg) and (not _a_1)):
     raise mosek_fusion_SolutionError._ctor_S("Dual solution does not exists for mixed-integer problems.")
    else:
     _a_5=mosek.fusion.Utils.StringBuffer()
     _a_6=(_a_3.pstatus)
     _a_7=(_a_3.probstatus)
     if (not _a_1):
      _a_6 = (_a_3.dstatus)
     _a_5._a_S("Solution status is ")
     if (_a_6==mosek.fusion.SolutionStatus.Undefined):
      _a_5._a_S("Undefined")
     elif (_a_6==mosek.fusion.SolutionStatus.Unknown):
      _a_5._a_S("Unknown")
     elif (_a_6==mosek.fusion.SolutionStatus.Optimal):
      _a_5._a_S("Optimal")
     elif (_a_6==mosek.fusion.SolutionStatus.Feasible):
      _a_5._a_S("Feasible")
     elif (_a_6==mosek.fusion.SolutionStatus.Certificate):
      _a_5._a_S("Certificate")
     elif (_a_6==mosek.fusion.SolutionStatus.IllposedCert):
      _a_5._a_S("IllposedCert")
     _a_5._a_S(" but ")
     if (self.__acceptable_sol==mosek.fusion.AccSolutionStatus.Anything):
      _a_5._a_S("Anything")
     elif (self.__acceptable_sol==mosek.fusion.AccSolutionStatus.Optimal):
      _a_5._a_S("Optimal")
     elif (self.__acceptable_sol==mosek.fusion.AccSolutionStatus.Feasible):
      _a_5._a_S("at least Feasible")
     elif (self.__acceptable_sol==mosek.fusion.AccSolutionStatus.Certificate):
      _a_5._a_S("Certificate")
     _a_5._a_S(" is expected. Reason: Accessing ")
     if (_a_3 is self.__sol_itr):
      _a_5._a_S("interior-point solution")
     elif (_a_3 is self.__sol_bas):
      _a_5._a_S("basic solution")
     elif (_a_3 is self.__sol_itg):
      _a_5._a_S("integer solution")
     _a_5._a_S(" whose problem status is ")
     if (_a_7==mosek.fusion.ProblemStatus.Unknown):
      _a_5._a_S("Unknown")
     elif (_a_7==mosek.fusion.ProblemStatus.PrimalAndDualFeasible):
      _a_5._a_S("PrimalAndDualFeasible")
     elif (_a_7==mosek.fusion.ProblemStatus.PrimalFeasible):
      _a_5._a_S("PrimalFeasible")
     elif (_a_7==mosek.fusion.ProblemStatus.DualFeasible):
      _a_5._a_S("DualFeasible")
     elif (_a_7==mosek.fusion.ProblemStatus.PrimalInfeasible):
      _a_5._a_S("PrimalInfeasible")
     elif (_a_7==mosek.fusion.ProblemStatus.DualInfeasible):
      _a_5._a_S("DualInfeasible")
     elif (_a_7==mosek.fusion.ProblemStatus.PrimalAndDualInfeasible):
      _a_5._a_S("PrimalAndDualInfeasible")
     elif (_a_7==mosek.fusion.ProblemStatus.IllPosed):
      _a_5._a_S("IllPosed")
     elif (_a_7==mosek.fusion.ProblemStatus.PrimalInfeasibleOrUnbounded):
      _a_5._a_S("PrimalInfeasibleOrUnbounded")
     _a_5._a_S(".")
     raise mosek_fusion_SolutionError._ctor_S(_a_5._toString_())
  def _get_1sol_1cache_alt_Emosek_4fusion_4SolutionType_2Z(self,_t__a_0,_t__a_1):
    return self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(__a_0,_a_1)
  def _get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(self,_a_0,_a_1):
   return (self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2ZZ(_a_0,_a_1,False))
  def _setSolution_1xx_alt__3I_3D(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.float64))
   _1_res = self._setSolution_1xx__3I_3D(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _setSolution_1xx__3I_3D(self,_a_0,_a_1):
   self._ensure_1initsol_1xx_()
   for _a_2 in range(0,int((_a_0).shape[0])):
    self.__initsol_xx[_a_0[_a_2]] = _a_1[_a_2]
    self.__initsol_xx_flag[_a_0[_a_2]] = True
  def _ensure_1initsol_1xx_alt_(self,):
    return self._ensure_1initsol_1xx_()
  def _ensure_1initsol_1xx_(self,):
   _a_0=self._task_1numvar_()
   if (self.__initsol_xx is None):
    self.__initsol_xx = numpy.zeros((_a_0,), dtype=numpy.dtype(numpy.float64))
    self.__initsol_xx_flag = numpy.array([False for _a_1 in range(0,_a_0)], dtype=numpy.dtype(bool))
   elif (int((self.__initsol_xx).shape[0]) < _a_0):
    _a_2=self.__initsol_xx
    _a_3=self.__initsol_xx_flag
    self.__initsol_xx = numpy.zeros((_a_0,), dtype=numpy.dtype(numpy.float64))
    self.__initsol_xx_flag = numpy.zeros((_a_0,), dtype=numpy.dtype(bool))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_a_2,0,self.__initsol_xx,0,int((_a_2).shape[0]))
    for _a_4 in range(0,int((_a_2).shape[0])):
     self.__initsol_xx_flag[_a_4] = _a_3[_a_4]
  def _getSolution_1accptr_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._getSolution_1accptr_Emosek_4fusion_4SolutionType_2(__a_0)
  def _getSolution_1accptr_Emosek_4fusion_4SolutionType_2(self,_a_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2ZZ(_a_0,True,True).accptr))
  def _getSolution_1accy_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._getSolution_1accy_Emosek_4fusion_4SolutionType_2(__a_0)
  def _getSolution_1accy_Emosek_4fusion_4SolutionType_2(self,_a_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_a_0,False).accy))
  def _getSolution_1accx_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._getSolution_1accx_Emosek_4fusion_4SolutionType_2(__a_0)
  def _getSolution_1accx_Emosek_4fusion_4SolutionType_2(self,_a_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_a_0,True).accx))
  def _getSolution_1bars_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._getSolution_1bars_Emosek_4fusion_4SolutionType_2(__a_0)
  def _getSolution_1bars_Emosek_4fusion_4SolutionType_2(self,_a_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_a_0,False).bars))
  def _getSolution_1barx_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._getSolution_1barx_Emosek_4fusion_4SolutionType_2(__a_0)
  def _getSolution_1barx_Emosek_4fusion_4SolutionType_2(self,_a_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_a_0,True).barx))
  def _getSolution_1y_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._getSolution_1y_Emosek_4fusion_4SolutionType_2(__a_0)
  def _getSolution_1y_Emosek_4fusion_4SolutionType_2(self,_a_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_a_0,False).y))
  def _getSolution_1xc_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._getSolution_1xc_Emosek_4fusion_4SolutionType_2(__a_0)
  def _getSolution_1xc_Emosek_4fusion_4SolutionType_2(self,_a_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_a_0,True).xc))
  def _getSolution_1suc_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._getSolution_1suc_Emosek_4fusion_4SolutionType_2(__a_0)
  def _getSolution_1suc_Emosek_4fusion_4SolutionType_2(self,_a_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_a_0,False).suc))
  def _getSolution_1slc_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._getSolution_1slc_Emosek_4fusion_4SolutionType_2(__a_0)
  def _getSolution_1slc_Emosek_4fusion_4SolutionType_2(self,_a_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_a_0,False).slc))
  def _getSolution_1sux_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._getSolution_1sux_Emosek_4fusion_4SolutionType_2(__a_0)
  def _getSolution_1sux_Emosek_4fusion_4SolutionType_2(self,_a_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_a_0,False).sux))
  def _getSolution_1slx_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._getSolution_1slx_Emosek_4fusion_4SolutionType_2(__a_0)
  def _getSolution_1slx_Emosek_4fusion_4SolutionType_2(self,_a_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_a_0,False).slx))
  def _getSolution_1yx_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._getSolution_1yx_Emosek_4fusion_4SolutionType_2(__a_0)
  def _getSolution_1yx_Emosek_4fusion_4SolutionType_2(self,_a_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_a_0,False).yx))
  def _getSolution_1xx_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._getSolution_1xx_Emosek_4fusion_4SolutionType_2(__a_0)
  def _getSolution_1xx_Emosek_4fusion_4SolutionType_2(self,_a_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_a_0,True).xx))
  @staticmethod
  def _match_selectedSolution_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Emosek_4fusion_4SolutionType_2__(_a_0))
  @staticmethod
  def _match_alt_selectedSolution_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Emosek_4fusion_4SolutionType_2__(_a_0))
  def _selectedSolution_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._selectedSolution_Emosek_4fusion_4SolutionType_2(__a_0)
  def _selectedSolution_Emosek_4fusion_4SolutionType_2(self,_a_0):
   self.__solutionptr = _a_0
  @staticmethod
  def _match_getAcceptedSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getAcceptedSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  def _getAcceptedSolutionStatus_alt_(self,):
    return self._getAcceptedSolutionStatus_()
  def _getAcceptedSolutionStatus_(self,):
   return (self.__acceptable_sol)
  @staticmethod
  def _match_acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Emosek_4fusion_4AccSolutionStatus_2__(_a_0))
  @staticmethod
  def _match_alt_acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Emosek_4fusion_4AccSolutionStatus_2__(_a_0))
  def _acceptedSolutionStatus_alt_Emosek_4fusion_4AccSolutionStatus_2(self,_t__a_0):
    return self._acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(__a_0)
  def _acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(self,_a_0):
   self.__acceptable_sol = _a_0
  @staticmethod
  def _match_getProblemStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Emosek_4fusion_4SolutionType_2__(_a_0))
  @staticmethod
  def _match_alt_getProblemStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Emosek_4fusion_4SolutionType_2__(_a_0))
  def _getProblemStatus_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._getProblemStatus_Emosek_4fusion_4SolutionType_2(__a_0)
  def _getProblemStatus_Emosek_4fusion_4SolutionType_2(self,_a_0):
   _a_1=None
   if (_a_0==mosek.fusion.SolutionType.Default):
    if (self.__sol_itg is not None):
     _a_1 = self.__sol_itg
    elif (self.__sol_bas is not None):
     _a_1 = self.__sol_bas
    else:
     _a_1 = self.__sol_itr
   elif (_a_0==mosek.fusion.SolutionType.Interior):
    _a_1 = self.__sol_itr
   elif (_a_0==mosek.fusion.SolutionType.Basic):
    _a_1 = self.__sol_bas
   elif (_a_0==mosek.fusion.SolutionType.Integer):
    _a_1 = self.__sol_itg
   if (_a_1 is None):
    return (mosek.fusion.ProblemStatus.Unknown)
   else:
    return ((_a_1.probstatus))
  @staticmethod
  def _match_getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Emosek_4fusion_4SolutionType_2__(_a_0))
  @staticmethod
  def _match_alt_getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Emosek_4fusion_4SolutionType_2__(_a_0))
  def _getDualSolutionStatus_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(__a_0)
  def _getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(self,_a_0):
   return (self._getSolutionStatus_Emosek_4fusion_4SolutionType_2Z(_a_0,False))
  @staticmethod
  def _match_getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Emosek_4fusion_4SolutionType_2__(_a_0))
  @staticmethod
  def _match_alt_getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Emosek_4fusion_4SolutionType_2__(_a_0))
  def _getPrimalSolutionStatus_alt_Emosek_4fusion_4SolutionType_2(self,_t__a_0):
    return self._getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(__a_0)
  def _getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(self,_a_0):
   return (self._getSolutionStatus_Emosek_4fusion_4SolutionType_2Z(_a_0,True))
  def _getSolutionStatus_alt_Emosek_4fusion_4SolutionType_2Z(self,_t__a_0,_t__a_1):
    return self._getSolutionStatus_Emosek_4fusion_4SolutionType_2Z(__a_0,_a_1)
  def _getSolutionStatus_Emosek_4fusion_4SolutionType_2Z(self,_a_0,_a_1):
   try:
    _a_2=self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2ZZ(_a_0,_a_1,True)
    if _a_1:
     return ((_a_2.pstatus))
    else:
     return ((_a_2.dstatus))
   except mosek_fusion_SolutionError as _a_3:
    return (mosek.fusion.SolutionStatus.Undefined)
  def _update_alt__3ILmosek_4fusion_4Expression_2(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=_t__a_1
   _1_res = self._update__3ILmosek_4fusion_4Expression_2(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _update__3ILmosek_4fusion_4Expression_2(self,_a_0,_a_1):
   mosek_fusion_ExprDense._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprOptimizeCode._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2(_a_1)))._recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(self.__ws,self.__rs,self.__xs,self.__cache_evaluations)
   self.__ws._pop_1expr_()
   _a_2=(self.__ws.nd)
   _a_3=(self.__ws.shape_base)
   _a_4=(self.__ws.nelem)
   _a_5=(self.__ws.nnz)
   _a_6=(self.__ws.hassp)
   _a_7=(self.__ws.ncodeatom)
   _a_8=(self.__ws.ptr_base)
   _a_9=(self.__ws.sp_base)
   _a_10=(self.__ws.nidxs_base)
   _a_11=(self.__ws.cof_base)
   _a_12=(self.__ws.code_base)
   _a_13=(self.__ws.codeptr_base)
   _a_14=(self.__ws.cconst_base)
   _a_15=(self.__ws.i32)
   _a_16=(self.__ws.i64)
   _a_17=(self.__ws.f64)
   _a_18=0
   _a_18 = fragments._c_closure_26(_a_0,_a_4,_a_18)
   _a_18 = numpy.int32(_a_18) # postprocess
   _a_19=(_a_4 - _a_18)
   if (_a_18==_a_4):
    self.__putarows__3ILmosek_4fusion_4WorkStack_2IIIII(_a_0,self.__ws,_a_4,_a_5,_a_8,_a_10,_a_11)
    if (_a_7 > 0):
     self.__con_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,_a_0,_a_8,_a_10,_a_13,_a_12,_a_14)
    else:
     self.__con_blocks._clear_1row_1code__3I(_a_0)
   elif (_a_19==_a_4):
    self.__putfrows__3IILmosek_4fusion_4WorkStack_2IIIII(numpy.array([(- (1 + _a_0[_a_20])) for _a_20 in range(0,_a_4)], dtype=numpy.dtype(numpy.int32)),0,self.__ws,_a_4,_a_5,_a_8,_a_10,_a_11)
    if (_a_7 > 0):
     self.__afe_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,numpy.array([(- (1 + _a_0[_a_21])) for _a_21 in range(0,_a_4)], dtype=numpy.dtype(numpy.int32)),_a_8,_a_10,_a_13,_a_12,_a_14)
    else:
     self.__afe_blocks._clear_1row_1code__3I(numpy.array([(- (1 + _a_0[_a_22])) for _a_22 in range(0,_a_4)], dtype=numpy.dtype(numpy.int32)))
   else:
    _a_23=0
    _a_24=0
    _a_25=0
    _a_26=0
    _a_25,_a_26 = fragments._c_closure_27(_a_25,_a_0,_a_26,_a_4,_a_8,_a_15)
    _a_25 = numpy.int32(_a_25) # postprocess
    _a_26 = numpy.int32(_a_26) # postprocess
    _a_27=self.__xs._alloci32_I(_a_18)
    _a_28=self.__xs._alloci32_I(_a_19)
    _a_29=self.__xs._alloci32_I((_a_18 + 1))
    _a_30=self.__xs._alloci32_I((_a_19 + 1))
    _a_31=self.__xs._alloci64_I(_a_26)
    _a_32=self.__xs._alloci64_I(_a_25)
    _a_33=self.__xs._allocf64_I(_a_26)
    _a_34=self.__xs._allocf64_I(_a_25)
    _a_35=(self.__xs.f64)
    _a_36=(self.__xs.i64)
    _a_37=(self.__xs.i32)
    _a_37[_a_29] = 0
    _a_37[_a_30] = 0
    _a_38=0
    _a_39=0
    _a_40=0
    _a_41=0
    for _a_42 in range(0,_a_4):
     _a_43=_a_15[(_a_8 + _a_42)]
     _a_44=_a_15[((_a_8 + _a_42) + 1)]
     if (_a_0[_a_42] >= 0):
      mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(_a_16,(_a_10 + _a_43),_a_36,(_a_31 + _a_41),(_a_44 - _a_43))
      mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_a_17,(_a_11 + _a_43),_a_35,(_a_33 + _a_41),(_a_44 - _a_43))
      _a_41 += (_a_44 - _a_43)
      _a_37[(_a_27 + _a_39)] = _a_0[_a_42]
      _a_37[((_a_29 + _a_39) + 1)] = _a_41
      _a_39 += 1
     else:
      mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(_a_16,(_a_10 + _a_43),_a_36,(_a_32 + _a_40),(_a_44 - _a_43))
      mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_a_17,(_a_11 + _a_43),_a_35,(_a_34 + _a_40),(_a_44 - _a_43))
      _a_40 += (_a_44 - _a_43)
      _a_37[(_a_28 + _a_38)] = (- (1 + _a_0[_a_42]))
      _a_37[((_a_30 + _a_38) + 1)] = _a_40
      _a_38 += 1
    self.__putarows__3ILmosek_4fusion_4WorkStack_2IIIII(numpy.array([_a_37[(_a_27 + _a_45)] for _a_45 in range(0,_a_18)], dtype=numpy.dtype(numpy.int32)),self.__xs,_a_18,_a_26,_a_29,_a_31,_a_33)
    self.__putfrows__3IILmosek_4fusion_4WorkStack_2IIIII(_a_37,_a_28,self.__xs,_a_19,_a_25,_a_30,_a_32,_a_34)
    if (_a_7 > 0):
     _a_23,_a_24 = fragments._c_closure_28(_a_23,_a_13,_a_0,_a_24,_a_4,_a_8,_a_15)
     _a_23 = numpy.int32(_a_23) # postprocess
     _a_24 = numpy.int32(_a_24) # postprocess
     _a_46=self.__xs._alloci32_I((_a_26 + 1))
     _a_47=self.__xs._alloci32_I((_a_25 + 1))
     _a_48=self.__xs._alloci32_I(_a_24)
     _a_49=self.__xs._alloci32_I(_a_23)
     _a_50=self.__xs._allocf64_I(_a_24)
     _a_51=self.__xs._allocf64_I(_a_23)
     _a_37[_a_46] = 0
     _a_37[_a_47] = 0
     _a_52=0
     _a_53=0
     _a_54=0
     _a_55=0
     for _a_56 in range(0,_a_4):
      _a_57=_a_15[(_a_8 + _a_56)]
      _a_58=_a_15[((_a_8 + _a_56) + 1)]
      if (_a_0[_a_56] >= 0):
       mosek.fusion.Utils.Tools._arraycopy__3II_3III(_a_15,(_a_12 + _a_15[(_a_13 + _a_57)]),_a_37,(_a_48 + _a_53),(_a_15[(_a_13 + _a_58)] - _a_15[(_a_13 + _a_57)]))
       mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_a_17,(_a_14 + _a_15[(_a_13 + _a_57)]),_a_35,(_a_50 + _a_53),(_a_15[(_a_13 + _a_58)] - _a_15[(_a_13 + _a_57)]))
       _a_53,_a_55 = fragments._c_closure_29(_a_13,_a_53,_a_46,_a_55,_a_57,_a_58,_a_15,_a_37)
       _a_53 = numpy.int32(_a_53) # postprocess
       _a_55 = numpy.int32(_a_55) # postprocess
      else:
       mosek.fusion.Utils.Tools._arraycopy__3II_3III(_a_15,(_a_12 + _a_15[(_a_13 + _a_57)]),_a_37,(_a_49 + _a_52),(_a_15[(_a_13 + _a_58)] - _a_15[(_a_13 + _a_57)]))
       mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_a_17,(_a_14 + _a_15[(_a_13 + _a_57)]),_a_35,(_a_51 + _a_52),(_a_15[(_a_13 + _a_58)] - _a_15[(_a_13 + _a_57)]))
       _a_52,_a_40 = fragments._c_closure_30(_a_52,_a_47,_a_40,_a_13,_a_57,_a_58,_a_15,_a_37)
       _a_52 = numpy.int32(_a_52) # postprocess
       _a_40 = numpy.int32(_a_40) # postprocess
     self.__con_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__xs,numpy.array([_a_37[(_a_27 + _a_59)] for _a_59 in range(0,_a_18)], dtype=numpy.dtype(numpy.int32)),_a_29,_a_31,_a_46,_a_48,_a_50)
     self.__afe_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__xs,numpy.array([numpy.int32(_a_36[(_a_28 + _a_60)]) for _a_60 in range(0,_a_19)], dtype=numpy.dtype(numpy.int32)),_a_30,_a_32,_a_47,_a_49,_a_51)
    else:
     self.__con_blocks._clear_1row_1code__3I(numpy.array([_a_37[(_a_27 + _a_61)] for _a_61 in range(0,_a_18)], dtype=numpy.dtype(numpy.int32)))
     self.__afe_blocks._clear_1row_1code__3I(numpy.array([numpy.int32(_a_36[(_a_28 + _a_62)]) for _a_62 in range(0,_a_19)], dtype=numpy.dtype(numpy.int32)))
   self.__xs._clear_()
  def _update_alt__3ILmosek_4fusion_4Expression_2_3I(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=_t__a_1
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _1_res = self._update__3ILmosek_4fusion_4Expression_2_3I(_a_0,_a_1,_a_2)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _update__3ILmosek_4fusion_4Expression_2_3I(self,_a_0,_a_1,_a_2):
   for _a_3 in range(0,int((_a_0).shape[0])):
    if ((_a_0[_a_3] >= 0) and self.__con_blocks._row_1is_1parameterized_I(_a_3)):
     raise mosek_fusion_UpdateError._ctor_S("Cannot update parameterized constraint")
    elif ((_a_0[_a_3] < 0) and self.__con_blocks._row_1is_1parameterized_I((- (_a_3 + 1)))):
     raise mosek_fusion_UpdateError._ctor_S("Cannot update parameterized constraint")
   mosek_fusion_ExprDense._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2(_a_1))._recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(self.__ws,self.__rs,self.__xs,self.__cache_evaluations)
   self.__ws._pop_1expr_()
   _a_4=(self.__ws.nd)
   _a_5=(self.__ws.nelem)
   _a_6=(self.__ws.nnz)
   _a_7=(self.__ws.hassp)
   _a_8=(self.__ws.ncodeatom)
   _a_9=(self.__ws.shape_base)
   _a_10=(self.__ws.ptr_base)
   _a_11=(self.__ws.sp_base)
   _a_12=(self.__ws.nidxs_base)
   _a_13=(self.__ws.cof_base)
   _a_14=(self.__ws.code_base)
   _a_15=(self.__ws.codeptr_base)
   _a_16=(self.__ws.cconst_base)
   _a_17=(self.__ws.i32)
   _a_18=(self.__ws.i64)
   _a_19=(self.__ws.f64)
   _a_20=0
   _a_20 = fragments._c_closure_31(_a_0,_a_5,_a_20)
   _a_20 = numpy.int32(_a_20) # postprocess
   _a_21=(_a_5 - _a_20)
   if ((_a_20==_a_5) or (_a_21==_a_5)):
    _a_22=(int((_a_0).shape[0]) * int((_a_2).shape[0]))
    _a_23=numpy.zeros((_a_22,), dtype=numpy.dtype(numpy.float64))
    _a_24=0
    _a_24 = fragments._c_closure_32(_a_23,_a_13,_a_5,_a_12,_a_24,_a_10,_a_2,_a_19,_a_17,_a_18)
    _a_24 = numpy.int32(_a_24) # postprocess
    _a_25=numpy.array([_a_2[_a_27] for _a_26 in range(0,_a_5) for _a_27 in range(0,int((_a_2).shape[0]))], dtype=numpy.dtype(numpy.int32))
    if (_a_20==_a_5):
     _a_28=numpy.array([_a_0[_a_29] for _a_29 in range(0,_a_5) for _a_30 in range(0,int((_a_2).shape[0]))], dtype=numpy.dtype(numpy.int32))
     self._task_1putaijlist__3I_3I_3DJ(_a_28,_a_25,_a_23,_a_24)
     if (_a_8 > 0):
      self.__con_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,_a_0,_a_10,_a_12,_a_15,_a_14,_a_16)
    else:
     _a_31=numpy.array([(- (_a_0[_a_32] + 1)) for _a_32 in range(0,_a_5) for _a_33 in range(0,int((_a_2).shape[0]))], dtype=numpy.dtype(numpy.int32))
     self._task_1putafefijlist__3I_3I_3D(_a_31,_a_25,_a_23)
     if (_a_8 > 0):
      self.__afe_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,numpy.array([(- (1 + _a_0[_a_34])) for _a_34 in range(0,_a_5)], dtype=numpy.dtype(numpy.int32)),_a_10,_a_12,_a_15,_a_14,_a_16)
   else:
    _a_35=(_a_21 * int((_a_2).shape[0]))
    _a_36=(_a_20 * int((_a_2).shape[0]))
    _a_37=numpy.zeros((_a_36,), dtype=numpy.dtype(numpy.float64))
    _a_38=numpy.zeros((_a_35,), dtype=numpy.dtype(numpy.float64))
    _a_39=numpy.array([_a_2[_a_41] for _a_40 in range(0,_a_20) for _a_41 in range(0,int((_a_2).shape[0]))], dtype=numpy.dtype(numpy.int32))
    _a_42=numpy.array([_a_2[_a_44] for _a_43 in range(0,_a_21) for _a_44 in range(0,int((_a_2).shape[0]))], dtype=numpy.dtype(numpy.int32))
    _a_45=numpy.zeros((_a_20,), dtype=numpy.dtype(numpy.int32))
    _a_46=numpy.zeros((_a_21,), dtype=numpy.dtype(numpy.int32))
    _a_47=0
    _a_48=0
    _a_49=0
    _a_50=0
    _a_51=0
    _a_52=0
    _a_51,_a_52 = fragments._c_closure_33(_a_38,_a_51,_a_13,_a_0,_a_46,_a_37,_a_52,_a_45,_a_5,_a_12,_a_10,_a_2,_a_19,_a_17,_a_18)
    _a_51 = numpy.int32(_a_51) # postprocess
    _a_52 = numpy.int32(_a_52) # postprocess
    self._task_1putaijlist__3I_3I_3DJ(_a_45,_a_39,_a_37,_a_52)
    self._task_1putafefijlist__3I_3I_3D(_a_46,_a_42,_a_38)
    if (_a_8 > 0):
     _a_51,_a_52 = fragments._c_closure_34(_a_51,_a_0,_a_52,_a_5,_a_10,_a_17)
     _a_51 = numpy.int32(_a_51) # postprocess
     _a_52 = numpy.int32(_a_52) # postprocess
     _a_53=numpy.zeros((_a_20,), dtype=numpy.dtype(numpy.int32))
     _a_54=numpy.zeros((_a_21,), dtype=numpy.dtype(numpy.int32))
     _a_55=self.__xs._alloci32_I((_a_20 + 1))
     _a_56=self.__xs._alloci32_I((_a_21 + 1))
     _a_57=self.__xs._alloci64_I(_a_52)
     _a_58=self.__xs._alloci64_I(_a_51)
     _a_59=(self.__xs.f64)
     _a_60=(self.__xs.i64)
     _a_61=(self.__xs.i32)
     _a_61[_a_55] = 0
     _a_61[_a_56] = 0
     _a_62=0
     _a_63=0
     _a_64=0
     _a_65=0
     _a_62,_a_64,_a_63,_a_65 = fragments._c_closure_35(_a_62,_a_64,_a_0,_a_56,_a_54,_a_63,_a_65,_a_55,_a_53,_a_5,_a_10,_a_17,_a_61)
     _a_62 = numpy.int32(_a_62) # postprocess
     _a_64 = numpy.int32(_a_64) # postprocess
     _a_63 = numpy.int32(_a_63) # postprocess
     _a_65 = numpy.int32(_a_65) # postprocess
     _a_49,_a_50 = fragments._c_closure_36(_a_49,_a_15,_a_0,_a_50,_a_5,_a_10,_a_17)
     _a_49 = numpy.int32(_a_49) # postprocess
     _a_50 = numpy.int32(_a_50) # postprocess
     _a_66=self.__xs._alloci32_I((_a_52 + 1))
     _a_67=self.__xs._alloci32_I((_a_51 + 1))
     _a_68=self.__xs._alloci32_I(_a_50)
     _a_69=self.__xs._alloci32_I(_a_49)
     _a_70=self.__xs._allocf64_I(_a_50)
     _a_71=self.__xs._allocf64_I(_a_49)
     _a_61[_a_66] = 0
     _a_61[_a_67] = 0
     _a_72=0
     _a_73=0
     _a_74=0
     _a_75=0
     for _a_76 in range(0,_a_5):
      _a_77=_a_17[(_a_10 + _a_76)]
      _a_78=_a_17[((_a_10 + _a_76) + 1)]
      if (_a_0[_a_76] >= 0):
       mosek.fusion.Utils.Tools._arraycopy__3II_3III(_a_17,(_a_14 + _a_17[(_a_15 + _a_77)]),_a_61,(_a_68 + _a_73),(_a_17[(_a_15 + _a_78)] - _a_17[(_a_15 + _a_77)]))
       mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_a_19,(_a_16 + _a_17[(_a_15 + _a_77)]),_a_59,(_a_70 + _a_73),(_a_17[(_a_15 + _a_78)] - _a_17[(_a_15 + _a_77)]))
       _a_73,_a_75 = fragments._c_closure_37(_a_15,_a_73,_a_66,_a_75,_a_77,_a_78,_a_17,_a_61)
       _a_73 = numpy.int32(_a_73) # postprocess
       _a_75 = numpy.int32(_a_75) # postprocess
      else:
       mosek.fusion.Utils.Tools._arraycopy__3II_3III(_a_17,(_a_14 + _a_17[(_a_15 + _a_77)]),_a_61,(_a_69 + _a_72),(_a_17[(_a_15 + _a_78)] - _a_17[(_a_15 + _a_77)]))
       mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_a_19,(_a_16 + _a_17[(_a_15 + _a_77)]),_a_59,(_a_71 + _a_72),(_a_17[(_a_15 + _a_78)] - _a_17[(_a_15 + _a_77)]))
       _a_72,_a_64 = fragments._c_closure_38(_a_72,_a_67,_a_64,_a_15,_a_77,_a_78,_a_17,_a_61)
       _a_72 = numpy.int32(_a_72) # postprocess
       _a_64 = numpy.int32(_a_64) # postprocess
     self.__con_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__xs,_a_53,_a_55,_a_57,_a_66,_a_68,_a_70)
     self.__afe_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__xs,_a_54,_a_56,_a_58,_a_67,_a_69,_a_71)
    else:
     _a_79=numpy.zeros((_a_20,), dtype=numpy.dtype(numpy.int32))
     _a_80=numpy.zeros((_a_21,), dtype=numpy.dtype(numpy.int32))
     _a_81=0
     _a_82=0
     _a_81,_a_82 = fragments._c_closure_39(_a_81,_a_0,_a_80,_a_82,_a_79,_a_5)
     _a_81 = numpy.int32(_a_81) # postprocess
     _a_82 = numpy.int32(_a_82) # postprocess
     self.__con_blocks._clear_1row_1code__3I(_a_79)
     self.__afe_blocks._clear_1row_1code__3I(_a_80)
   self.__xs._clear_()
  @staticmethod
  def _match_updateObjective_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_1))
  @staticmethod
  def _match_alt_updateObjective_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_1))
  def _updateObjective_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(self,_t__a_0,_t__a_1):
    return self._updateObjective_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(_a_0,_a_1)
  def _updateObjective_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(self,_a_0,_a_1):
   if (_a_0._getSize_()!=1):
    raise mosek_fusion_DimensionError._ctor_S("Invalid expression size for objective")
   if ((self.__obj_blocks.code_used) > 0):
    raise mosek_fusion_UpdateError._ctor_S("Cannot update parameterized constraint")
   _a_2=_a_1._numInst_()
   _a_3=numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.int64))
   if (_a_2 < _a_1._getSize_()):
    _a_4=numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.int64))
    _a_1._inst_I_3JI_3J(0,_a_4,0,_a_3)
   else:
    _a_1._inst_I_3J(0,_a_3)
   for _a_5 in range(0,_a_2):
    if (_a_3[_a_5] < 0):
     raise mosek_fusion_UpdateError._ctor_S("Updating semidefinite terms is currently not possible")
   _a_6=True
   _a_6 = fragments._c_closure_40(_a_2,_a_3,_a_6)
   _a_7=None
   if _a_6:
    _a_7 = numpy.array([numpy.int32(_a_3[_a_8]) for _a_8 in range(0,_a_2)], dtype=numpy.dtype(numpy.int32))
   else:
    _a_9=numpy.array([_a_10 for _a_10 in range((- 1),_a_2)], dtype=numpy.dtype(numpy.int64))
    mosek.fusion.CommonTools._argQsort__3J_3J_3JJJ(_a_9,_a_3,None,0,_a_2)
    _a_7 = numpy.array([numpy.int32(_a_3[_a_9[_a_11]]) for _a_11 in range(0,_a_2)], dtype=numpy.dtype(numpy.int32))
   _a_12=int((_a_7).shape[0])
   _a_13=numpy.zeros((_a_12,), dtype=numpy.dtype(numpy.float64))
   _a_14=_a_7
   mosek_fusion_ExprDense._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2(_a_0))._recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(self.__ws,self.__rs,self.__xs,self.__cache_evaluations)
   self.__ws._pop_1expr_()
   pass
   _a_15=(self.__ws.nd)
   _a_16=(self.__ws.nelem)
   _a_17=(self.__ws.nnz)
   _a_18=(self.__ws.hassp)
   _a_19=(self.__ws.ncodeatom)
   _a_20=(self.__ws.shape_base)
   _a_21=(self.__ws.ptr_base)
   _a_22=(self.__ws.sp_base)
   _a_23=(self.__ws.nidxs_base)
   _a_24=(self.__ws.cof_base)
   _a_25=(self.__ws.code_base)
   _a_26=(self.__ws.codeptr_base)
   _a_27=(self.__ws.cconst_base)
   pass
   if (_a_19 > 0):
    raise mosek_fusion_UpdateError._ctor_S("Cannot update parameterized objective")
   _a_28=(self.__ws.i32)
   _a_29=(self.__ws.i64)
   _a_30=(self.__ws.f64)
   _a_31=0
   _a_31 = fragments._c_closure_41(_a_13,_a_24,_a_31,_a_16,_a_23,_a_21,_a_7,_a_30,_a_28,_a_29)
   _a_31 = numpy.int32(_a_31) # postprocess
   self._task_1putclist__3I_3D(_a_14,_a_13)
   if (_a_19 > 0):
    self.__obj_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,numpy.array([0], dtype=numpy.dtype(numpy.int32)),_a_21,_a_23,_a_26,_a_25,_a_27)
  def __parameter_1unchecked_alt_S_3I_3J(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int64))
   _1_res = self.__parameter_1unchecked_S_3I_3J(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __parameter_1unchecked_S_3I_3J(self,_a_0,_a_1,_a_2):
   if ((int(len(_a_0)) > 0) and self.__par_map._hasItem_S(_a_0)):
    raise mosek_fusion_NameError._ctor_S("Duplicate parameter name")
   _a_3=mosek.fusion.Set._size__3I(_a_1)
   _a_4=(int((_a_2).shape[0]) if ((_a_2 is not None) ) else numpy.int32(_a_3))
   if (self.__param_value is None):
    self.__param_value = numpy.zeros((_a_4,), dtype=numpy.dtype(numpy.float64))
   else:
    if ((self.__param_num + _a_4) > int((self.__param_value).shape[0])):
     _a_5=self.__param_value
     _a_6=((2 * int((_a_5).shape[0])) if (((2 * int((_a_5).shape[0])) > (int((_a_5).shape[0]) + _a_4)) ) else (int((_a_5).shape[0]) + _a_4))
     self.__param_value = numpy.zeros((_a_6,), dtype=numpy.dtype(numpy.float64))
     if (self.__param_num > 0):
      mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_a_5,0,self.__param_value,0,self.__param_num)
   _a_7=mosek_fusion_ParameterImpl._ctor_Lmosek_4fusion_4Model_2_3I_3J_3I(self,_a_1,_a_2,numpy.array([(self.__param_num + _a_8) for _a_8 in range(0,numpy.int32(_a_4))], dtype=numpy.dtype(numpy.int32)))
   self.__param_num += _a_4
   if (int(len(_a_0)) > 0):
    if ((self.__parameters is None) or (self.__numparameter==int((self.__parameters).shape[0]))):
     _a_9=self.__parameters
     self.__parameters = numpy.array([None for _a_10 in range(0,((self.__numparameter * 2) + 64))], dtype=numpy.dtype(object))
     for _a_11 in range(0,self.__numparameter):
      self.__parameters[_a_11] = _a_9[_a_11]
    self.__parameters[self.__numparameter] = _a_7
    self.__par_map._setItem_SI(_a_0,self.__numparameter)
    self.__numparameter += 1
   return (_a_7)
  def __parameter_1_alt_S_3I_3J(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int64))
   _1_res = self.__parameter_1_S_3I_3J(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __parameter_1_S_3I_3J(self,_a_0,_a_1,_a_2):
   _a_3=True
   _a_4=int((_a_1).shape[0])
   if ((_a_2 is not None) and (int((_a_2).shape[0]) > 0)):
    _a_5=(_a_2[(int((_a_2).shape[0]) - 1)] < mosek.fusion.Set._size__3I(_a_1))
    _a_5 = fragments._c_closure_42(_a_5,_a_2)
    if (not _a_5):
     raise mosek_fusion_IndexError._ctor_S("Unordered sparsity pattern")
   return (self.__parameter_1unchecked_S_3I_3J(_a_0,_a_1,_a_2))
  def __parameter_1_alt_S_3I_3_5I(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,ndmin=_monty.checkShape(_t__a_2,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self.__parameter_1_S_3I_3_5I(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __parameter_1_S_3I_3_5I(self,_a_0,_a_1,_a_2):
   _a_3=int((_a_2).shape[0])
   _a_4=int((_a_2).shape[1])
   if (int((_a_1).shape[0])!=_a_4):
    raise mosek_fusion_LengthError._ctor_S("Invalid sparsity")
   if (_a_2 is None):
    return (self.__parameter_1unchecked_S_3I_3J(_a_0,_a_1,None))
   else:
    _a_5=numpy.zeros((_a_3,), dtype=numpy.dtype(numpy.int64))
    _a_6=numpy.zeros((_a_4,), dtype=numpy.dtype(numpy.int64))
    _a_6[(_a_4 - 1)] = 1
    fragments._c_closure_43(_a_4,_a_1,_a_6) 
    fragments._c_closure_44(_a_4,_a_3,_a_5,_a_2,_a_6) 
    return (self.__parameter_1_S_3I_3J(_a_0,_a_1,_a_5))
  @staticmethod
  def _match_parameter_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_S__(_a_0))
  @staticmethod
  def _match_alt_parameter_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_S__(_a_0))
  def _parameter_alt_S(self,_t__a_0):
    return self._parameter_S(_a_0)
  def _parameter_S(self,_a_0):
   _a_1=None
   return (self.__parameter_1_S_3I_3J(_a_0,numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),_a_1))
  @staticmethod
  def _match_parameter_SIII(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_S__(_a_0) and __arg_match_I__(_a_1) and __arg_match_I__(_a_2) and __arg_match_I__(_a_3))
  @staticmethod
  def _match_alt_parameter_SIII(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_I__(_a_2) and __arg_alt_match_I__(_a_3))
  def _parameter_alt_SIII(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3):
    return self._parameter_SIII(_a_0,numpy.int32(__a_1),numpy.int32(__a_2),numpy.int32(__a_3))
  def _parameter_SIII(self,_a_0,_a_1,_a_2,_a_3):
   _a_4=None
   return (self.__parameter_1_S_3I_3J(_a_0,numpy.array([_a_1,_a_2,_a_3], dtype=numpy.dtype(numpy.int32)),_a_4))
  @staticmethod
  def _match_parameter_SII(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match_I__(_a_1) and __arg_match_I__(_a_2))
  @staticmethod
  def _match_alt_parameter_SII(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_I__(_a_2))
  def _parameter_alt_SII(self,_t__a_0,_t__a_1,_t__a_2):
    return self._parameter_SII(_a_0,numpy.int32(__a_1),numpy.int32(__a_2))
  def _parameter_SII(self,_a_0,_a_1,_a_2):
   _a_3=None
   return (self.__parameter_1_S_3I_3J(_a_0,numpy.array([_a_1,_a_2], dtype=numpy.dtype(numpy.int32)),_a_3))
  @staticmethod
  def _match_parameter_SI(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_parameter_SI(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_I__(_a_1))
  def _parameter_alt_SI(self,_t__a_0,_t__a_1):
    return self._parameter_SI(_a_0,numpy.int32(__a_1))
  def _parameter_SI(self,_a_0,_a_1):
   _a_2=None
   return (self.__parameter_1_S_3I_3J(_a_0,numpy.array([_a_1], dtype=numpy.dtype(numpy.int32)),_a_2))
  @staticmethod
  def _match_parameter_S_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_parameter_S_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match__3I__(_a_1))
  def _parameter_alt_S_3I(self,_t__a_0,_t__a_1):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._parameter_S_3I(_a_0,_a_1)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _parameter_S_3I(self,_a_0,_a_1):
   _a_2=None
   return (self.__parameter_1_S_3I_3J(_a_0,_a_1,_a_2))
  @staticmethod
  def _match_parameter_S_3I_3J(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3J__(_a_2))
  @staticmethod
  def _match_alt_parameter_S_3I_3J(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3J__(_a_2))
  def _parameter_alt_S_3I_3J(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int64))
   _1_res = self._parameter_S_3I_3J(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _parameter_S_3I_3J(self,_a_0,_a_1,_a_2):
   return (self.__parameter_1_S_3I_3J(_a_0,_a_1,_a_2))
  @staticmethod
  def _match_parameter_S_3I_3_5I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3_5I__(_a_2))
  @staticmethod
  def _match_alt_parameter_S_3I_3_5I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3_5I__(_a_2))
  def _parameter_alt_S_3I_3_5I(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,ndmin=_monty.checkShape(_t__a_2,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._parameter_S_3I_3_5I(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _parameter_S_3I_3_5I(self,_a_0,_a_1,_a_2):
   return (self.__parameter_1_S_3I_3_5I(_a_0,_a_1,_a_2))
  @staticmethod
  def _match_parameter_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_parameter_(*args):
    if len(args) != 0: return False
    return True
  def _parameter_alt_(self,):
    return self._parameter_()
  def _parameter_(self,):
   _a_0=None
   return (self.__parameter_1_S_3I_3J("",numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),_a_0))
  @staticmethod
  def _match_parameter_III(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1) and __arg_match_I__(_a_2))
  @staticmethod
  def _match_alt_parameter_III(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_I__(_a_2))
  def _parameter_alt_III(self,_t__a_0,_t__a_1,_t__a_2):
    return self._parameter_III(numpy.int32(__a_0),numpy.int32(__a_1),numpy.int32(__a_2))
  def _parameter_III(self,_a_0,_a_1,_a_2):
   _a_3=None
   return (self.__parameter_1_S_3I_3J("",numpy.array([_a_0,_a_1,_a_2], dtype=numpy.dtype(numpy.int32)),_a_3))
  @staticmethod
  def _match_parameter_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_parameter_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1))
  def _parameter_alt_II(self,_t__a_0,_t__a_1):
    return self._parameter_II(numpy.int32(__a_0),numpy.int32(__a_1))
  def _parameter_II(self,_a_0,_a_1):
   _a_2=None
   return (self.__parameter_1_S_3I_3J("",numpy.array([_a_0,_a_1], dtype=numpy.dtype(numpy.int32)),_a_2))
  @staticmethod
  def _match_parameter_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_parameter_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _parameter_alt_I(self,_t__a_0):
    return self._parameter_I(numpy.int32(__a_0))
  def _parameter_I(self,_a_0):
   _a_1=None
   return (self.__parameter_1_S_3I_3J("",numpy.array([_a_0], dtype=numpy.dtype(numpy.int32)),_a_1))
  @staticmethod
  def _match_parameter__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_parameter__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _parameter_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._parameter__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _parameter__3I(self,_a_0):
   _a_1=None
   return (self.__parameter_1_S_3I_3J("",_a_0,_a_1))
  @staticmethod
  def _match_parameter__3I_3J(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3J__(_a_1))
  @staticmethod
  def _match_alt_parameter__3I_3J(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3J__(_a_1))
  def _parameter_alt__3I_3J(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _1_res = self._parameter__3I_3J(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _parameter__3I_3J(self,_a_0,_a_1):
   return (self.__parameter_1_S_3I_3J("",_a_0,_a_1))
  @staticmethod
  def _match_parameter__3I_3_5I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3_5I__(_a_1))
  @staticmethod
  def _match_alt_parameter__3I_3_5I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3_5I__(_a_1))
  def _parameter_alt__3I_3_5I(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,ndmin=_monty.checkShape(_t__a_1,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._parameter__3I_3_5I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _parameter__3I_3_5I(self,_a_0,_a_1):
   return (self.__parameter_1_S_3I_3_5I("",_a_0,_a_1))
  def __objective_1_alt_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(_a_0,__a_1,_a_2)
  def __objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_a_0,_a_1,_a_2):
   self._task_1putobjectivename_S(_a_0)
   _a_3=mosek_fusion_WorkStack._ctor_()
   _a_4=mosek_fusion_WorkStack._ctor_()
   _a_5=mosek_fusion_ExprDense._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprOptimizeCode._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2(_a_2)))
   _a_5._recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(_a_3,_a_4,self.__xs,self.__cache_evaluations)
   _a_3._pop_1expr_()
   _a_6=(_a_3.i32)
   _a_7=(_a_3.i64)
   _a_8=(_a_3.f64)
   _a_9=(_a_3.nd)
   _a_10=(_a_3.nelem)
   _a_11=(_a_3.nnz)
   _a_12=(_a_3.hassp)
   _a_13=(_a_3.ncodeatom)
   _a_14=(_a_3.ptr_base)
   _a_15=(_a_3.shape_base)
   _a_16=(_a_3.nidxs_base)
   _a_17=(_a_3.cof_base)
   _a_18=(_a_3.code_base)
   _a_19=(_a_3.codeptr_base)
   _a_20=(_a_3.cconst_base)
   _a_21=1
   _a_9 = fragments._c_closure_45(_a_9,_a_6,_a_15)
   _a_9 = numpy.int32(_a_9) # postprocess
   if (_a_21!=1):
    raise mosek_fusion_LengthError._ctor_S("Invalid expression size for objective")
   if (_a_10!=1):
    raise mosek_fusion_LengthError._ctor_S("Invalid expression for objective")
   _a_22=0
   _a_23=0
   _a_22,_a_23 = fragments._c_closure_46(_a_22,_a_16,_a_11,_a_23,_a_7)
   _a_22 = numpy.int32(_a_22) # postprocess
   _a_23 = numpy.int32(_a_23) # postprocess
   _a_24=numpy.zeros((_a_22,), dtype=numpy.dtype(numpy.int32))
   _a_25=numpy.zeros((_a_22,), dtype=numpy.dtype(numpy.float64))
   fragments._c_closure_47(_a_25,_a_17,_a_16,_a_11,_a_8,_a_7,_a_24) 
   self._task_1putobjective_Z_3I_3DD((_a_1==mosek.fusion.ObjectiveSense.Maximize),_a_24,_a_25,0.0)
   if (_a_23 > 0):
    _a_26=numpy.zeros((_a_23,), dtype=numpy.dtype(numpy.int32))
    _a_27=numpy.zeros((_a_23,), dtype=numpy.dtype(numpy.int32))
    _a_28=numpy.zeros((_a_23,), dtype=numpy.dtype(numpy.int32))
    _a_29=numpy.zeros((_a_23,), dtype=numpy.dtype(numpy.float64))
    fragments._c_closure_48(self.__barvar_block_elm_barj,self.__barvar_block_elm_i,self.__barvar_block_elm_j,_a_17,_a_16,_a_23,_a_8,_a_7,_a_26,_a_27,_a_28,_a_29) 
    self._task_1putbarc__3I_3I_3I_3D(_a_26,_a_27,_a_28,_a_29)
   if (_a_13 > 0):
    self.__obj_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(_a_3,numpy.array([0], dtype=numpy.dtype(numpy.int32)),_a_14,_a_16,_a_19,_a_18,_a_20)
  @staticmethod
  def _match_objective_D(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_D__(_a_0))
  @staticmethod
  def _match_alt_objective_D(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_D__(_a_0))
  def _objective_alt_D(self,_t__a_0):
    return self._objective_D(numpy.float64(__a_0))
  def _objective_D(self,_a_0):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2("",mosek.fusion.ObjectiveSense.Minimize,mosek.fusion.Expr._constTerm_D(_a_0))
  @staticmethod
  def _match_objective_Emosek_4fusion_4ObjectiveSense_2D(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Emosek_4fusion_4ObjectiveSense_2__(_a_0) and __arg_match_D__(_a_1))
  @staticmethod
  def _match_alt_objective_Emosek_4fusion_4ObjectiveSense_2D(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Emosek_4fusion_4ObjectiveSense_2__(_a_0) and __arg_alt_match_D__(_a_1))
  def _objective_alt_Emosek_4fusion_4ObjectiveSense_2D(self,_t__a_0,_t__a_1):
    return self._objective_Emosek_4fusion_4ObjectiveSense_2D(__a_0,numpy.float64(__a_1))
  def _objective_Emosek_4fusion_4ObjectiveSense_2D(self,_a_0,_a_1):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2("",_a_0,mosek.fusion.Expr._constTerm_D(_a_1))
  @staticmethod
  def _match_objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Emosek_4fusion_4ObjectiveSense_2__(_a_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_a_1))
  @staticmethod
  def _match_alt_objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Emosek_4fusion_4ObjectiveSense_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_a_1))
  def _objective_alt_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_t__a_0,_t__a_1):
    return self._objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(__a_0,_a_1)
  def _objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_a_0,_a_1):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2("",_a_0,_a_1)
  @staticmethod
  def _match_objective_SD(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_D__(_a_1))
  @staticmethod
  def _match_alt_objective_SD(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_D__(_a_1))
  def _objective_alt_SD(self,_t__a_0,_t__a_1):
    return self._objective_SD(_a_0,numpy.float64(__a_1))
  def _objective_SD(self,_a_0,_a_1):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(_a_0,mosek.fusion.ObjectiveSense.Minimize,mosek.fusion.Expr._constTerm_D(_a_1))
  @staticmethod
  def _match_objective_SEmosek_4fusion_4ObjectiveSense_2D(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match_Emosek_4fusion_4ObjectiveSense_2__(_a_1) and __arg_match_D__(_a_2))
  @staticmethod
  def _match_alt_objective_SEmosek_4fusion_4ObjectiveSense_2D(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Emosek_4fusion_4ObjectiveSense_2__(_a_1) and __arg_alt_match_D__(_a_2))
  def _objective_alt_SEmosek_4fusion_4ObjectiveSense_2D(self,_t__a_0,_t__a_1,_t__a_2):
    return self._objective_SEmosek_4fusion_4ObjectiveSense_2D(_a_0,__a_1,numpy.float64(__a_2))
  def _objective_SEmosek_4fusion_4ObjectiveSense_2D(self,_a_0,_a_1,_a_2):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(_a_0,_a_1,mosek.fusion.Expr._constTerm_D(_a_2))
  @staticmethod
  def _match_objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match_Emosek_4fusion_4ObjectiveSense_2__(_a_1) and __arg_match_Lmosek_4fusion_4Expression_2__(_a_2))
  @staticmethod
  def _match_alt_objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Emosek_4fusion_4ObjectiveSense_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_a_2))
  def _objective_alt_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self._objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(_a_0,__a_1,_a_2)
  def _objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_a_0,_a_1,_a_2):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(_a_0,_a_1,_a_2)
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4ExprRangeDomain_2__(_a_0))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprRangeDomain_2__(_a_0))
  def _constraint_alt_Lmosek_4fusion_4ExprRangeDomain_2(self,_t__a_0):
    return self._constraint_Lmosek_4fusion_4ExprRangeDomain_2(_a_0)
  def _constraint_Lmosek_4fusion_4ExprRangeDomain_2(self,_a_0):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2("",(_a_0.expr),(_a_0.dom)))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4ExprRangeDomain_2__(_a_1))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4ExprRangeDomain_2__(_a_1))
  def _constraint_alt_SLmosek_4fusion_4ExprRangeDomain_2(self,_t__a_0,_t__a_1):
    return self._constraint_SLmosek_4fusion_4ExprRangeDomain_2(_a_0,_a_1)
  def _constraint_SLmosek_4fusion_4ExprRangeDomain_2(self,_a_0,_a_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_a_0,(_a_1.expr),(_a_1.dom)))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_a_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_a_1))
  def _constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_t__a_0,_t__a_1):
    return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_a_0,_a_1)
  def _constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_a_0,_a_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2("",_a_0,_a_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_a_1) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_a_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_a_2))
  def _constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_a_0,_a_1,_a_2)
  def _constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_a_0,_a_1,_a_2):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_a_0,_a_1,_a_2))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4ExprConicDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4ExprConicDomain_2__(_a_0))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4ExprConicDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprConicDomain_2__(_a_0))
  def _constraint_alt_Lmosek_4fusion_4ExprConicDomain_2(self,_t__a_0):
    return self._constraint_Lmosek_4fusion_4ExprConicDomain_2(_a_0)
  def _constraint_Lmosek_4fusion_4ExprConicDomain_2(self,_a_0):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2("",(_a_0.expr),(_a_0.dom)))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4ExprConicDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4ExprConicDomain_2__(_a_1))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4ExprConicDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4ExprConicDomain_2__(_a_1))
  def _constraint_alt_SLmosek_4fusion_4ExprConicDomain_2(self,_t__a_0,_t__a_1):
    return self._constraint_SLmosek_4fusion_4ExprConicDomain_2(_a_0,_a_1)
  def _constraint_SLmosek_4fusion_4ExprConicDomain_2(self,_a_0,_a_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(_a_0,(_a_1.expr),(_a_1.dom)))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_match_Lmosek_4fusion_4ConeDomain_2__(_a_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_a_1))
  def _constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(self,_t__a_0,_t__a_1):
    return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(_a_0,_a_1)
  def _constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(self,_a_0,_a_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2("",_a_0,_a_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_a_1) and __arg_match_Lmosek_4fusion_4ConeDomain_2__(_a_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_a_2))
  def _constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(_a_0,_a_1,_a_2)
  def _constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(self,_a_0,_a_1,_a_2):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(_a_0,_a_1,_a_2))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4ExprLinearDomain_2__(_a_0))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprLinearDomain_2__(_a_0))
  def _constraint_alt_Lmosek_4fusion_4ExprLinearDomain_2(self,_t__a_0):
    return self._constraint_Lmosek_4fusion_4ExprLinearDomain_2(_a_0)
  def _constraint_Lmosek_4fusion_4ExprLinearDomain_2(self,_a_0):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2("",(_a_0.expr),(_a_0.dom)))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4ExprLinearDomain_2__(_a_1))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4ExprLinearDomain_2__(_a_1))
  def _constraint_alt_SLmosek_4fusion_4ExprLinearDomain_2(self,_t__a_0,_t__a_1):
    return self._constraint_SLmosek_4fusion_4ExprLinearDomain_2(_a_0,_a_1)
  def _constraint_SLmosek_4fusion_4ExprLinearDomain_2(self,_a_0,_a_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_a_0,(_a_1.expr),(_a_1.dom)))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_a_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_a_1))
  def _constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_t__a_0,_t__a_1):
    return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_a_0,_a_1)
  def _constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_a_0,_a_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2("",_a_0,_a_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_a_1) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_a_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_a_2))
  def _constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_a_0,_a_1,_a_2)
  def _constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_a_0,_a_1,_a_2):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_a_0,_a_1,_a_2))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4ExprPSDDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4ExprPSDDomain_2__(_a_0))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4ExprPSDDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprPSDDomain_2__(_a_0))
  def _constraint_alt_Lmosek_4fusion_4ExprPSDDomain_2(self,_t__a_0):
    return self._constraint_Lmosek_4fusion_4ExprPSDDomain_2(_a_0)
  def _constraint_Lmosek_4fusion_4ExprPSDDomain_2(self,_a_0):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2("",(_a_0.expr),(_a_0.dom)))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4ExprPSDDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4ExprPSDDomain_2__(_a_1))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4ExprPSDDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4ExprPSDDomain_2__(_a_1))
  def _constraint_alt_SLmosek_4fusion_4ExprPSDDomain_2(self,_t__a_0,_t__a_1):
    return self._constraint_SLmosek_4fusion_4ExprPSDDomain_2(_a_0,_a_1)
  def _constraint_SLmosek_4fusion_4ExprPSDDomain_2(self,_a_0,_a_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_a_0,(_a_1.expr),(_a_1.dom)))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_a_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_a_1))
  def _constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_t__a_0,_t__a_1):
    return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_a_0,_a_1)
  def _constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_a_0,_a_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2("",_a_0,_a_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_a_1) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_a_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_a_2))
  def _constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_a_0,_a_1,_a_2)
  def _constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_a_0,_a_1,_a_2):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_a_0,_a_1,_a_2))
  @staticmethod
  def _match_variable_Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4PSDDomain_2__(_a_0))
  @staticmethod
  def _match_alt_variable_Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_a_0))
  def _variable_alt_Lmosek_4fusion_4PSDDomain_2(self,_t__a_0):
    return self._variable_Lmosek_4fusion_4PSDDomain_2(_a_0)
  def _variable_Lmosek_4fusion_4PSDDomain_2(self,_a_0):
   return (self.__variable_1_S_3ILmosek_4fusion_4PSDDomain_2("",(_a_0._shape),_a_0))
  @staticmethod
  def _match_variable_IILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_a_2))
  @staticmethod
  def _match_alt_variable_IILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_a_2))
  def _variable_alt_IILmosek_4fusion_4PSDDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self._variable_IILmosek_4fusion_4PSDDomain_2(numpy.int32(__a_0),numpy.int32(__a_1),_a_2)
  def _variable_IILmosek_4fusion_4PSDDomain_2(self,_a_0,_a_1,_a_2):
   return (self.__variable_1_S_3ILmosek_4fusion_4PSDDomain_2("",numpy.array([_a_1,_a_0,_a_0], dtype=numpy.dtype(numpy.int32)),_a_2))
  @staticmethod
  def _match_variable_ILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_a_1))
  @staticmethod
  def _match_alt_variable_ILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_a_1))
  def _variable_alt_ILmosek_4fusion_4PSDDomain_2(self,_t__a_0,_t__a_1):
    return self._variable_ILmosek_4fusion_4PSDDomain_2(numpy.int32(__a_0),_a_1)
  def _variable_ILmosek_4fusion_4PSDDomain_2(self,_a_0,_a_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4PSDDomain_2("",numpy.array([_a_0,_a_0], dtype=numpy.dtype(numpy.int32)),_a_1))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_a_1))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_a_1))
  def _variable_alt_SLmosek_4fusion_4PSDDomain_2(self,_t__a_0,_t__a_1):
    return self._variable_SLmosek_4fusion_4PSDDomain_2(_a_0,_a_1)
  def _variable_SLmosek_4fusion_4PSDDomain_2(self,_a_0,_a_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4PSDDomain_2(_a_0,None,_a_1))
  @staticmethod
  def _match_variable_SIILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_S__(_a_0) and __arg_match_I__(_a_1) and __arg_match_I__(_a_2) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_a_3))
  @staticmethod
  def _match_alt_variable_SIILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_I__(_a_2) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_a_3))
  def _variable_alt_SIILmosek_4fusion_4PSDDomain_2(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3):
    return self._variable_SIILmosek_4fusion_4PSDDomain_2(_a_0,numpy.int32(__a_1),numpy.int32(__a_2),_a_3)
  def _variable_SIILmosek_4fusion_4PSDDomain_2(self,_a_0,_a_1,_a_2,_a_3):
   return (self.__variable_1_S_3ILmosek_4fusion_4PSDDomain_2(_a_0,numpy.array([_a_2,_a_1,_a_1], dtype=numpy.dtype(numpy.int32)),_a_3))
  @staticmethod
  def _match_variable_SILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match_I__(_a_1) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_a_2))
  @staticmethod
  def _match_alt_variable_SILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_a_2))
  def _variable_alt_SILmosek_4fusion_4PSDDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self._variable_SILmosek_4fusion_4PSDDomain_2(_a_0,numpy.int32(__a_1),_a_2)
  def _variable_SILmosek_4fusion_4PSDDomain_2(self,_a_0,_a_1,_a_2):
   return (self.__variable_1_S_3ILmosek_4fusion_4PSDDomain_2(_a_0,numpy.array([_a_1,_a_1], dtype=numpy.dtype(numpy.int32)),_a_2))
  @staticmethod
  def _match_variable_S_3ILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match__3I__(_a_1) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_a_2))
  @staticmethod
  def _match_alt_variable_S_3ILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_a_2))
  def _variable_alt_S_3ILmosek_4fusion_4PSDDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=_t__a_2
   _1_res = self._variable_S_3ILmosek_4fusion_4PSDDomain_2(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable_S_3ILmosek_4fusion_4PSDDomain_2(self,_a_0,_a_1,_a_2):
   return (self.__variable_1_S_3ILmosek_4fusion_4PSDDomain_2(_a_0,_a_1,_a_2))
  @staticmethod
  def _match_variable_Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4ConeDomain_2__(_a_0))
  @staticmethod
  def _match_alt_variable_Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_a_0))
  def _variable_alt_Lmosek_4fusion_4ConeDomain_2(self,_t__a_0):
    return self._variable_Lmosek_4fusion_4ConeDomain_2(_a_0)
  def _variable_Lmosek_4fusion_4ConeDomain_2(self,_a_0):
   return (self.__variable_1_S_3ILmosek_4fusion_4ConeDomain_2("",None,_a_0))
  @staticmethod
  def _match_variable_Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4RangeDomain_2__(_a_0))
  @staticmethod
  def _match_alt_variable_Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_a_0))
  def _variable_alt_Lmosek_4fusion_4RangeDomain_2(self,_t__a_0):
    return self._variable_Lmosek_4fusion_4RangeDomain_2(_a_0)
  def _variable_Lmosek_4fusion_4RangeDomain_2(self,_a_0):
   return (self.__ranged_1variable_S_3ILmosek_4fusion_4RangeDomain_2("",None,_a_0))
  @staticmethod
  def _match_variable_Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4LinearDomain_2__(_a_0))
  @staticmethod
  def _match_alt_variable_Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_a_0))
  def _variable_alt_Lmosek_4fusion_4LinearDomain_2(self,_t__a_0):
    return self._variable_Lmosek_4fusion_4LinearDomain_2(_a_0)
  def _variable_Lmosek_4fusion_4LinearDomain_2(self,_a_0):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2("",None,_a_0))
  @staticmethod
  def _match_variable__3ILmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match_Lmosek_4fusion_4ConeDomain_2__(_a_1))
  @staticmethod
  def _match_alt_variable__3ILmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_a_1))
  def _variable_alt__3ILmosek_4fusion_4ConeDomain_2(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=_t__a_1
   _1_res = self._variable__3ILmosek_4fusion_4ConeDomain_2(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable__3ILmosek_4fusion_4ConeDomain_2(self,_a_0,_a_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4ConeDomain_2("",_a_0,_a_1))
  @staticmethod
  def _match_variable__3ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_a_1))
  @staticmethod
  def _match_alt_variable__3ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_a_1))
  def _variable_alt__3ILmosek_4fusion_4RangeDomain_2(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=_t__a_1
   _1_res = self._variable__3ILmosek_4fusion_4RangeDomain_2(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable__3ILmosek_4fusion_4RangeDomain_2(self,_a_0,_a_1):
   return (self.__ranged_1variable_S_3ILmosek_4fusion_4RangeDomain_2("",_a_0,_a_1))
  @staticmethod
  def _match_variable__3ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_a_1))
  @staticmethod
  def _match_alt_variable__3ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_a_1))
  def _variable_alt__3ILmosek_4fusion_4LinearDomain_2(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=_t__a_1
   _1_res = self._variable__3ILmosek_4fusion_4LinearDomain_2(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable__3ILmosek_4fusion_4LinearDomain_2(self,_a_0,_a_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2("",_a_0,_a_1))
  @staticmethod
  def _match_variable__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_variable__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _variable_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._variable__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable__3I(self,_a_0):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2("",_a_0,mosek.fusion.Domain._unbounded_()))
  @staticmethod
  def _match_variable_ILmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_Lmosek_4fusion_4ConeDomain_2__(_a_1))
  @staticmethod
  def _match_alt_variable_ILmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_a_1))
  def _variable_alt_ILmosek_4fusion_4ConeDomain_2(self,_t__a_0,_t__a_1):
    return self._variable_ILmosek_4fusion_4ConeDomain_2(numpy.int32(__a_0),_a_1)
  def _variable_ILmosek_4fusion_4ConeDomain_2(self,_a_0,_a_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4ConeDomain_2("",numpy.array([_a_0], dtype=numpy.dtype(numpy.int32)),_a_1))
  @staticmethod
  def _match_variable_ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_a_1))
  @staticmethod
  def _match_alt_variable_ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_a_1))
  def _variable_alt_ILmosek_4fusion_4RangeDomain_2(self,_t__a_0,_t__a_1):
    return self._variable_ILmosek_4fusion_4RangeDomain_2(numpy.int32(__a_0),_a_1)
  def _variable_ILmosek_4fusion_4RangeDomain_2(self,_a_0,_a_1):
   return (self.__ranged_1variable_S_3ILmosek_4fusion_4RangeDomain_2("",numpy.array([_a_0], dtype=numpy.dtype(numpy.int32)),_a_1))
  @staticmethod
  def _match_variable_ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_a_1))
  @staticmethod
  def _match_alt_variable_ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_a_1))
  def _variable_alt_ILmosek_4fusion_4LinearDomain_2(self,_t__a_0,_t__a_1):
    return self._variable_ILmosek_4fusion_4LinearDomain_2(numpy.int32(__a_0),_a_1)
  def _variable_ILmosek_4fusion_4LinearDomain_2(self,_a_0,_a_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2("",numpy.array([_a_0], dtype=numpy.dtype(numpy.int32)),_a_1))
  @staticmethod
  def _match_variable_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_variable_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _variable_alt_I(self,_t__a_0):
    return self._variable_I(numpy.int32(__a_0))
  def _variable_I(self,_a_0):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2("",numpy.array([_a_0], dtype=numpy.dtype(numpy.int32)),mosek.fusion.Domain._unbounded_()))
  @staticmethod
  def _match_variable_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_variable_(*args):
    if len(args) != 0: return False
    return True
  def _variable_alt_(self,):
    return self._variable_()
  def _variable_(self,):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2("",numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),mosek.fusion.Domain._unbounded_()))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4ConeDomain_2__(_a_1))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_a_1))
  def _variable_alt_SLmosek_4fusion_4ConeDomain_2(self,_t__a_0,_t__a_1):
    return self._variable_SLmosek_4fusion_4ConeDomain_2(_a_0,_a_1)
  def _variable_SLmosek_4fusion_4ConeDomain_2(self,_a_0,_a_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4ConeDomain_2(_a_0,None,_a_1))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_a_1))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_a_1))
  def _variable_alt_SLmosek_4fusion_4RangeDomain_2(self,_t__a_0,_t__a_1):
    return self._variable_SLmosek_4fusion_4RangeDomain_2(_a_0,_a_1)
  def _variable_SLmosek_4fusion_4RangeDomain_2(self,_a_0,_a_1):
   return (self.__ranged_1variable_S_3ILmosek_4fusion_4RangeDomain_2(_a_0,None,_a_1))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_a_1))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_a_1))
  def _variable_alt_SLmosek_4fusion_4LinearDomain_2(self,_t__a_0,_t__a_1):
    return self._variable_SLmosek_4fusion_4LinearDomain_2(_a_0,_a_1)
  def _variable_SLmosek_4fusion_4LinearDomain_2(self,_a_0,_a_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2(_a_0,None,_a_1))
  @staticmethod
  def _match_variable_S_3ILmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match__3I__(_a_1) and __arg_match_Lmosek_4fusion_4ConeDomain_2__(_a_2))
  @staticmethod
  def _match_alt_variable_S_3ILmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_a_2))
  def _variable_alt_S_3ILmosek_4fusion_4ConeDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=_t__a_2
   _1_res = self._variable_S_3ILmosek_4fusion_4ConeDomain_2(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable_S_3ILmosek_4fusion_4ConeDomain_2(self,_a_0,_a_1,_a_2):
   return (self.__variable_1_S_3ILmosek_4fusion_4ConeDomain_2(_a_0,_a_1,_a_2))
  @staticmethod
  def _match_variable_S_3ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match__3I__(_a_1) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_a_2))
  @staticmethod
  def _match_alt_variable_S_3ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_a_2))
  def _variable_alt_S_3ILmosek_4fusion_4RangeDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=_t__a_2
   _1_res = self._variable_S_3ILmosek_4fusion_4RangeDomain_2(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable_S_3ILmosek_4fusion_4RangeDomain_2(self,_a_0,_a_1,_a_2):
   return (self.__ranged_1variable_S_3ILmosek_4fusion_4RangeDomain_2(_a_0,_a_1,_a_2))
  @staticmethod
  def _match_variable_S_3ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match__3I__(_a_1) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_a_2))
  @staticmethod
  def _match_alt_variable_S_3ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_a_2))
  def _variable_alt_S_3ILmosek_4fusion_4LinearDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=_t__a_2
   _1_res = self._variable_S_3ILmosek_4fusion_4LinearDomain_2(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable_S_3ILmosek_4fusion_4LinearDomain_2(self,_a_0,_a_1,_a_2):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2(_a_0,_a_1,_a_2))
  @staticmethod
  def _match_variable_S_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_variable_S_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match__3I__(_a_1))
  def _variable_alt_S_3I(self,_t__a_0,_t__a_1):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._variable_S_3I(_a_0,_a_1)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable_S_3I(self,_a_0,_a_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2(_a_0,_a_1,mosek.fusion.Domain._unbounded_()))
  @staticmethod
  def _match_variable_SILmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match_I__(_a_1) and __arg_match_Lmosek_4fusion_4ConeDomain_2__(_a_2))
  @staticmethod
  def _match_alt_variable_SILmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_a_2))
  def _variable_alt_SILmosek_4fusion_4ConeDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self._variable_SILmosek_4fusion_4ConeDomain_2(_a_0,numpy.int32(__a_1),_a_2)
  def _variable_SILmosek_4fusion_4ConeDomain_2(self,_a_0,_a_1,_a_2):
   return (self.__variable_1_S_3ILmosek_4fusion_4ConeDomain_2(_a_0,numpy.array([_a_1], dtype=numpy.dtype(numpy.int32)),_a_2))
  @staticmethod
  def _match_variable_SILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match_I__(_a_1) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_a_2))
  @staticmethod
  def _match_alt_variable_SILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_a_2))
  def _variable_alt_SILmosek_4fusion_4RangeDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self._variable_SILmosek_4fusion_4RangeDomain_2(_a_0,numpy.int32(__a_1),_a_2)
  def _variable_SILmosek_4fusion_4RangeDomain_2(self,_a_0,_a_1,_a_2):
   return (self.__ranged_1variable_S_3ILmosek_4fusion_4RangeDomain_2(_a_0,numpy.array([_a_1], dtype=numpy.dtype(numpy.int32)),_a_2))
  @staticmethod
  def _match_variable_SILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_S__(_a_0) and __arg_match_I__(_a_1) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_a_2))
  @staticmethod
  def _match_alt_variable_SILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_a_2))
  def _variable_alt_SILmosek_4fusion_4LinearDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self._variable_SILmosek_4fusion_4LinearDomain_2(_a_0,numpy.int32(__a_1),_a_2)
  def _variable_SILmosek_4fusion_4LinearDomain_2(self,_a_0,_a_1,_a_2):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2(_a_0,numpy.array([_a_1], dtype=numpy.dtype(numpy.int32)),_a_2))
  @staticmethod
  def _match_variable_SI(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_S__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_variable_SI(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_S__(_a_0) and __arg_alt_match_I__(_a_1))
  def _variable_alt_SI(self,_t__a_0,_t__a_1):
    return self._variable_SI(_a_0,numpy.int32(__a_1))
  def _variable_SI(self,_a_0,_a_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2(_a_0,numpy.array([_a_1], dtype=numpy.dtype(numpy.int32)),mosek.fusion.Domain._unbounded_()))
  @staticmethod
  def _match_variable_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_S__(_a_0))
  @staticmethod
  def _match_alt_variable_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_S__(_a_0))
  def _variable_alt_S(self,_t__a_0):
    return self._variable_S(_a_0)
  def _variable_S(self,_a_0):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2(_a_0,numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),mosek.fusion.Domain._unbounded_()))
  def _removeConstraintBlock_alt_I(self,_t__a_0):
    return self._removeConstraintBlock_I(numpy.int32(__a_0))
  def _removeConstraintBlock_I(self,_a_0):
   if (_a_0 >= 0):
    self.__con_1release_I(_a_0)
   else:
    self.__acon_1release_I((- (1 + _a_0)))
  def _removeVariableBlock_alt_J(self,_t__a_0):
    return self._removeVariableBlock_J(numpy.int64(__a_0))
  def _removeVariableBlock_J(self,_a_0):
   if (self.__con_blocks._is_1parameterized_() or self.__afe_blocks._is_1parameterized_()):
    raise mosek_fusion_DeletionError._ctor_S("Cannot remove variables in parameterized model")
   if (_a_0 < 0):
    raise mosek_fusion_DeletionError._ctor_S("PSD variables cannot be removed")
   else:
    _a_1=numpy.int32(_a_0)
    _a_2=self.__var_block_map._blocksize_I(_a_1)
    _a_3=numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.int32))
    self.__var_block_map._get_I_3II(_a_1,_a_3,0)
    self.__var_block_map._free_I(_a_1)
    _a_4=self.__var_block_acc_id[_a_1]
    if (_a_4 >= 0):
     self._removeConstraintBlock_I(_a_4)
    self._task_1var_1putboundlist_1fr__3I(_a_3)
    self._task_1clearacollist__3I(_a_3)
  def __ranged_1variable_alt_S_3ILmosek_4fusion_4RangeDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=_t__a_2
   _1_res = self.__ranged_1variable_S_3ILmosek_4fusion_4RangeDomain_2(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __ranged_1variable_S_3ILmosek_4fusion_4RangeDomain_2(self,_a_0,_a_1,_a_2):
   if ((int(len(_a_0)) > 0) and self._hasVariable_S(_a_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate variable name '")._a_S(_a_0)._a_S("'")._toString_())
   _a_3=_a_2._finalize_1and_1validate__3I(_a_1)
   _a_4=(_a_3._shape)
   _a_5=int((_a_4).shape[0])
   _a_6=numpy.zeros((_a_5,), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_49(_a_5,_a_4,_a_6) 
   _a_7=1
   _a_7 = fragments._c_closure_50(_a_7,_a_4)
   _a_7 = numpy.int32(_a_7) # postprocess
   _a_8=None
   _a_9=None
   _a_10=None
   _a_11=None
   _a_12=None
   _a_13=None
   if ((int(len(_a_0)) > 0) and ((_a_3._indexnames) is not None)):
    _a_14=mosek.fusion.Utils.StringBuffer()
    _a_15=mosek.fusion.Utils.StringBuffer()
    _a_16=0
    _a_17=0
    _a_18=0
    if (int(((_a_3._indexnames)).shape[0])!=_a_5):
     raise mosek_fusion_DomainError._ctor_S("Invalid index name definition")
    for _a_19 in range(0,int(((_a_3._indexnames)).shape[0])):
     if ((_a_3._indexnames)[_a_19] is not None):
      if (_a_4[_a_19]!=int(((_a_3._indexnames)[_a_19]).shape[0])):
       raise mosek_fusion_DomainError._ctor_S("Invalid index name definition")
      _a_18 += _a_4[_a_19]
    _a_9 = numpy.zeros(((_a_18 + 1),), dtype=numpy.dtype(numpy.int64))
    _a_8 = numpy.array([(- 1) for _a_20 in range(0,_a_5)], dtype=numpy.dtype(numpy.int32))
    for _a_21 in range(0,int(((_a_3._indexnames)).shape[0])):
     if ((_a_3._indexnames)[_a_21] is not None):
      _a_8[_a_21] = _a_16
      for _a_22 in range(0,_a_4[_a_21]):
       _a_14._a_S((_a_3._indexnames)[_a_21][_a_22])
       _a_16 += 1
       _a_17 += int(len((_a_3._indexnames)[_a_21][_a_22]))
       _a_9[_a_16] = _a_17
    _a_10 = _a_14
    _a_13 = _a_15
   _a_23=None
   _a_24=None
   if (_a_3._empty):
    _a_23 = numpy.zeros((0,), dtype=numpy.dtype(numpy.int64))
   elif ((_a_3._sparsity) is not None):
    if (int(((_a_3._sparsity)).shape[1])!=_a_5):
     raise mosek_fusion_SparseFormatError._ctor_S("Sparsity pattern is not correct")
    _a_25=int(((_a_3._sparsity)).shape[0])
    _a_23 = numpy.zeros((_a_25,), dtype=numpy.dtype(numpy.int64))
    _a_26=False
    _a_27=(_a_3._sparsity)
    _a_26 = fragments._c_closure_51(_a_26,_a_25,_a_4,_a_27,_a_23,_a_6)
    if _a_26:
     raise mosek_fusion_SparseFormatError._ctor_S("Sparsity pattern is out of bounds")
    _a_28=(_a_3._sparsity)
    _a_29=0
    _a_29 = fragments._c_closure_52(_a_29,_a_5,_a_4)
    _a_29 = numpy.int32(_a_29) # postprocess
    _a_30=numpy.zeros((_a_25,), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_53(_a_30,_a_25) 
    _a_31=numpy.zeros((_a_25,), dtype=numpy.dtype(numpy.int32))
    _a_32=numpy.zeros(((_a_29 + 1),), dtype=numpy.dtype(numpy.int32))
    for _a_33 in range(0,_a_5):
     fragments._c_closure_54(_a_30,_a_33,_a_28,_a_25,_a_5,_a_32,_a_4,_a_31) 
     _a_34=_a_30
     _a_30 = _a_31
     _a_31 = _a_34
    fragments._c_closure_55(_a_30,_a_28,_a_25,_a_5,_a_23,_a_6) 
   _a_35=(int((_a_23).shape[0]) if ((_a_23 is not None) ) else _a_7)
   _a_36=numpy.zeros((_a_35,), dtype=numpy.dtype(numpy.int32))
   _a_37=self.__linearvar_1alloc_I_3I(_a_35,_a_36)
   if (int(len(_a_0)) > 0):
    self.__var_map._setItem_SI(_a_0,_a_37)
    _a_38=mosek.fusion.Utils.StringBuffer()
    _a_38._a_S(_a_0)._a_S("[")
    if (_a_5 > 0):
     _a_38._a_S("%0")
     for _a_39 in range(1,_a_5):
      _a_38._a_S(",%")._a_I(_a_39)
    _a_38._a_S("]")
    if ((_a_3._indexnames) is not None):
     self._task_1format_1var_1names__3IS_3I_3J_3_3S(_a_36,_a_38._toString_(),_a_4,_a_23,(_a_3._indexnames))
    else:
     self._task_1format_1var_1names__3IS_3I_3J_3_3S(_a_36,_a_38._toString_(),_a_4,_a_23,None)
   if (_a_3._scalable):
    _a_40 = numpy.array([(_a_3._lb)[0] for _a_42 in range(0,_a_35)], dtype=numpy.dtype(numpy.float64))
    _a_41 = numpy.array([(_a_3._ub)[0] for _a_43 in range(0,_a_35)], dtype=numpy.dtype(numpy.float64))
   else:
    _a_40 = (_a_3._lb)
    _a_41 = (_a_3._ub)
   self._task_1var_1putboundlist_1ra__3I_3D_3D(_a_36,_a_40,_a_41)
   _a_44=mosek_fusion_RangedVariable._ctor_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(self,_a_0,_a_37,_a_4,_a_23,_a_36)
   if (_a_3._cardinal_flag):
    self._task_1var_1putintlist__3I(_a_36)
   self.__vars[_a_37] = _a_44
   return (_a_44)
  def __variable_1_alt_S_3ILmosek_4fusion_4ConeDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=_t__a_2
   _1_res = self.__variable_1_S_3ILmosek_4fusion_4ConeDomain_2(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __variable_1_S_3ILmosek_4fusion_4ConeDomain_2(self,_a_0,_a_1,_a_2):
   _a_3=_a_2._finalize_1and_1validate__3I(_a_1)
   if ((int(len(_a_0)) > 0) and self._hasVariable_S(_a_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate variable name '")._a_S(_a_0)._a_S("'")._toString_())
   _a_4=(_a_3._shape)
   _a_5=int((_a_4).shape[0])
   _a_6=_a_3._getAxis_()
   _a_7=_a_4[_a_6]
   _a_8=1
   _a_9=1
   _a_10=1
   _a_10 = fragments._c_closure_56(_a_10,_a_5,_a_4)
   _a_10 = numpy.int32(_a_10) # postprocess
   _a_9 = fragments._c_closure_57(_a_6,_a_9,_a_4)
   _a_9 = numpy.int32(_a_9) # postprocess
   _a_8 = fragments._c_closure_58(_a_6,_a_8,_a_5,_a_4)
   _a_8 = numpy.int32(_a_8) # postprocess
   _a_11=(_a_9 * _a_8)
   _a_12=(- 1)
   _a_13=numpy.zeros((0,), dtype=numpy.dtype(numpy.int64))
   if ((_a_3._key)==mosek.fusion.QConeKey.InQCone):
    if (_a_7 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_7)._a_S(") for quadratic cone")._toString_())
    _a_12 = self._task_1append_1domain_1quad_I(_a_7)
   elif ((_a_3._key)==mosek.fusion.QConeKey.InRotatedQCone):
    if (_a_7 < 3):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_7)._a_S(") for rotated quadratic cone")._toString_())
    _a_12 = self._task_1append_1domain_1rquad_I(_a_7)
   elif ((_a_3._key)==mosek.fusion.QConeKey.InPExpCone):
    if (_a_7!=3):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_7)._a_S(") for exponential cone")._toString_())
    _a_12 = self._task_1append_1domain_1pexp_()
   elif ((_a_3._key)==mosek.fusion.QConeKey.InPPowCone):
    if (_a_7 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_7)._a_S(") for power cone")._toString_())
    _a_12 = self._task_1append_1domain_1ppow_I_3D(_a_7,(_a_3._alpha))
   elif ((_a_3._key)==mosek.fusion.QConeKey.InPPowConeSeq):
    _a_13 = self._task_1append_1domain_1ppow_1seq_II_3D(_a_7,(int(((_a_3._alpha)).shape[0]) // _a_11),(_a_3._alpha))
   elif ((_a_3._key)==mosek.fusion.QConeKey.InDExpCone):
    if (_a_7!=3):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_7)._a_S(") for dual exponential cone")._toString_())
    _a_12 = self._task_1append_1domain_1dexp_()
   elif ((_a_3._key)==mosek.fusion.QConeKey.InDPowCone):
    if (_a_7 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_7)._a_S(") for dual power cone")._toString_())
    _a_12 = self._task_1append_1domain_1dpow_I_3D(_a_7,(_a_3._alpha))
   elif ((_a_3._key)==mosek.fusion.QConeKey.InDPowConeSeq):
    _a_13 = self._task_1append_1domain_1dpow_1seq_II_3D(_a_7,(int(((_a_3._alpha)).shape[0]) // _a_11),(_a_3._alpha))
   elif ((_a_3._key)==mosek.fusion.QConeKey.InPGeoMeanCone):
    if (_a_7 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_7)._a_S(") for primal geometric mean cone")._toString_())
    _a_12 = self._task_1append_1domain_1pgeomean_I(_a_7)
   elif ((_a_3._key)==mosek.fusion.QConeKey.InDGeoMeanCone):
    if (_a_7 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_7)._a_S(") for dual geometric mean cone")._toString_())
    _a_12 = self._task_1append_1domain_1dgeomean_I(_a_7)
   elif ((_a_3._key)==mosek.fusion.QConeKey.Positive):
    _a_12 = self._task_1append_1domain_1rpos_I(_a_7)
   elif ((_a_3._key)==mosek.fusion.QConeKey.InSVecPSDCone):
    _a_14=numpy.int32(((mosek.fusion.Utils.Tools._sqrt_D((1 + (8 * _a_7))) - 1) / 2))
    if (((_a_14 * (_a_14 + 1)) // 2)!=_a_7):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_7)._a_S(") for vector positive semidefinite cone")._toString_())
    _a_12 = self._task_1append_1domain_1svec_1psd_I(_a_7)
   elif ((_a_3._key)==mosek.fusion.QConeKey.Negative):
    _a_12 = self._task_1append_1domain_1rneg_I(_a_7)
   elif ((_a_3._key)==mosek.fusion.QConeKey.Unbounded):
    _a_12 = self._task_1append_1domain_1r_I(_a_7)
   elif ((_a_3._key)==mosek.fusion.QConeKey.Zero):
    _a_12 = self._task_1append_1domain_1rzero_I(_a_7)
   elif ((_a_3._key)==mosek.fusion.QConeKey.InPSDCone):
    if (_a_7 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_7)._a_S(") for positive semidefinite cone")._toString_())
    else:
     _a_15=numpy.int32(((mosek.fusion.Utils.Tools._sqrt_D((1 + (8 * _a_7))) - 1) / 2))
     if (((_a_15 * (_a_15 + 1)) // 2)!=_a_7):
      raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_7)._a_S(") for positive semidefinite cone")._toString_())
    _a_12 = self._task_1append_1domain_1svec_1psd_I(_a_7)
   else:
    raise mosek_fusion_UnexpectedError._ctor_S("Internal error: Invalid cone type")
   if (((_a_3._key)==mosek.fusion.QConeKey.InPPowConeSeq) or ((_a_3._key)==mosek.fusion.QConeKey.InDPowConeSeq)):
    pass
   else:
    _a_13 = numpy.array([_a_12 for _a_16 in range(0,_a_11)], dtype=numpy.dtype(numpy.int64))
   _a_17=numpy.zeros(((_a_11 * _a_7),), dtype=numpy.dtype(numpy.int32))
   _a_18=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.int32))
   _a_19=self.__conicvar_1alloc__3JII_3I_3I(_a_13,_a_7,_a_11,_a_18,_a_17)
   self._task_1var_1putboundlist_1fr__3I(_a_17)
   if (_a_3._int_flag):
    self._task_1var_1putintlist__3I(_a_17)
   _a_20=_a_17
   if (_a_6 < (int((_a_4).shape[0]) - 1)):
    _a_20 = numpy.zeros((int((_a_17).shape[0]),), dtype=numpy.dtype(numpy.int32))
    _a_21=0
    _a_21 = fragments._c_closure_59(_a_7,_a_9,_a_8,_a_17,_a_21,_a_20)
    _a_21 = numpy.int32(_a_21) # postprocess
   _a_22=mosek_fusion_ConicVariable._ctor_Lmosek_4fusion_4Model_2SI_3I_3I(self,_a_0,_a_19,_a_4,_a_17)
   self.__vars[_a_19] = _a_22
   if (int(len(_a_0)) > 0):
    _a_23=mosek.fusion.Utils.StringBuffer()
    _a_23._a_S(_a_0)._a_S("[")
    if (_a_5 > 0):
     _a_23._a_S("%0")
     for _a_24 in range(1,_a_5):
      _a_23._a_S(",%")._a_I(_a_24)
    _a_23._a_S("]")
    if ((_a_3._indexnames) is not None):
     self._task_1format_1var_1names__3IS_3I_3J_3_3S(_a_20,_a_23._toString_(),_a_4,None,(_a_3._indexnames))
    else:
     self._task_1format_1var_1names__3IS_3I_3J_3_3S(_a_20,_a_23._toString_(),_a_4,None,None)
    _a_25=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.int32))
    self.__acc_block_map._get_I_3II(self.__var_block_acc_id[_a_19],_a_25,0)
    _a_26=numpy.zeros(((int((_a_4).shape[0]) - 1),), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_60(_a_26,_a_6,_a_4) 
    fragments._c_closure_61(_a_26,_a_6,_a_5,_a_4) 
    _a_27=mosek.fusion.Utils.StringBuffer()
    _a_27._a_S(_a_0)._a_S("[")
    if ((_a_5 - 1) > 0):
     _a_27._a_S("%0")
     for _a_28 in range(1,(_a_5 - 1)):
      _a_27._a_S(",%")._a_I(_a_28)
    _a_27._a_S("]")
    if ((_a_3._indexnames) is not None):
     _a_29=numpy.ndarray(((_a_5 - 1),), dtype=numpy.dtype(object))
     for _a_30 in range(0,_a_6):
      _a_29[_a_30] = (_a_3._indexnames)[_a_30]
     for _a_31 in range((_a_6 + 1),_a_5):
      _a_29[(_a_31 - 1)] = (_a_3._indexnames)[_a_31]
     self._task_1format_1acc_1names__3JS_3I_3_3S(numpy.array([numpy.int64(_a_25[_a_32]) for _a_32 in range(0,_a_11)], dtype=numpy.dtype(numpy.int64)),_a_27._toString_(),_a_26,_a_29)
    else:
     self._task_1format_1acc_1names__3JS_3I_3_3S(numpy.array([numpy.int64(_a_25[_a_33]) for _a_33 in range(0,_a_11)], dtype=numpy.dtype(numpy.int64)),_a_27._toString_(),_a_26,None)
    self.__var_map._setItem_SI(_a_0,_a_19)
   return (_a_22)
  def __variable_1_alt_S_3ILmosek_4fusion_4LinearDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=_t__a_2
   _1_res = self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __variable_1_S_3ILmosek_4fusion_4LinearDomain_2(self,_a_0,_a_1,_a_2):
   if ((int(len(_a_0)) > 0) and self._hasVariable_S(_a_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate variable name '")._a_S(_a_0)._a_S("'")._toString_())
   _a_3=_a_2._finalize_1and_1validate__3I(_a_1)
   _a_4=(_a_3._shape)
   _a_5=int((_a_4).shape[0])
   _a_6=numpy.zeros((_a_5,), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_62(_a_5,_a_4,_a_6) 
   _a_7=1
   _a_7 = fragments._c_closure_63(_a_7,_a_4)
   _a_7 = numpy.int32(_a_7) # postprocess
   _a_8=None
   _a_9=None
   _a_10=None
   _a_11=None
   _a_12=None
   _a_13=None
   if ((int(len(_a_0)) > 0) and ((_a_3._indexnames) is not None)):
    _a_14=mosek.fusion.Utils.StringBuffer()
    _a_15=mosek.fusion.Utils.StringBuffer()
    _a_16=0
    _a_17=0
    _a_18=0
    if (int(((_a_3._indexnames)).shape[0])!=_a_5):
     raise mosek_fusion_DomainError._ctor_S("Invalid index name definition")
    for _a_19 in range(0,int(((_a_3._indexnames)).shape[0])):
     if ((_a_3._indexnames)[_a_19] is not None):
      if (_a_4[_a_19]!=int(((_a_3._indexnames)[_a_19]).shape[0])):
       raise mosek_fusion_DomainError._ctor_S("Invalid index name definition")
      _a_18 += _a_4[_a_19]
    _a_9 = numpy.zeros(((_a_18 + 1),), dtype=numpy.dtype(numpy.int64))
    _a_8 = numpy.array([(- 1) for _a_20 in range(0,_a_5)], dtype=numpy.dtype(numpy.int32))
    for _a_21 in range(0,int(((_a_3._indexnames)).shape[0])):
     if ((_a_3._indexnames)[_a_21] is not None):
      _a_8[_a_21] = _a_16
      for _a_22 in range(0,_a_4[_a_21]):
       _a_14._a_S((_a_3._indexnames)[_a_21][_a_22])
       _a_16 += 1
       _a_17 += int(len((_a_3._indexnames)[_a_21][_a_22]))
       _a_9[_a_16] = _a_17
    _a_10 = _a_14
    _a_13 = _a_15
   _a_23=None
   _a_24=None
   if (_a_3._empty):
    _a_23 = numpy.zeros((0,), dtype=numpy.dtype(numpy.int64))
   elif ((_a_3._sparsity) is not None):
    if (int(((_a_3._sparsity)).shape[1])!=_a_5):
     raise mosek_fusion_SparseFormatError._ctor_S("Sparsity pattern is not correct")
    _a_25=int(((_a_3._sparsity)).shape[0])
    _a_23 = numpy.zeros((_a_25,), dtype=numpy.dtype(numpy.int64))
    _a_26=False
    _a_27=(_a_3._sparsity)
    _a_26 = fragments._c_closure_64(_a_26,_a_25,_a_4,_a_27,_a_23,_a_6)
    if _a_26:
     raise mosek_fusion_SparseFormatError._ctor_S("Sparsity pattern is out of bounds")
    _a_28=(_a_3._sparsity)
    _a_29=0
    _a_29 = fragments._c_closure_65(_a_29,_a_5,_a_4)
    _a_29 = numpy.int32(_a_29) # postprocess
    _a_30=numpy.zeros((_a_25,), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_66(_a_30,_a_25) 
    _a_31=numpy.zeros((_a_25,), dtype=numpy.dtype(numpy.int32))
    _a_32=numpy.zeros(((_a_29 + 1),), dtype=numpy.dtype(numpy.int32))
    for _a_33 in range(0,_a_5):
     fragments._c_closure_67(_a_30,_a_33,_a_28,_a_25,_a_5,_a_32,_a_4,_a_31) 
     _a_34=_a_30
     _a_30 = _a_31
     _a_31 = _a_34
    fragments._c_closure_68(_a_30,_a_28,_a_25,_a_5,_a_23,_a_6) 
   _a_35=(int((_a_23).shape[0]) if ((_a_23 is not None) ) else _a_7)
   _a_36=numpy.zeros((_a_35,), dtype=numpy.dtype(numpy.float64))
   if ((_a_3._bnd) is not None):
    if (int(((_a_3._bnd)).shape[0])==1):
     for _a_37 in range(0,_a_35):
      _a_36[_a_37] = (_a_3._bnd)[0]
    elif (int(((_a_3._bnd)).shape[0])==_a_35):
     mosek.fusion.Utils.Tools._arraycopy__3DI_3DII((_a_3._bnd),0,_a_36,0,_a_35)
    else:
     raise mosek_fusion_DimensionError._ctor_S("Invalid right hand side shape in domain")
   _a_38=numpy.zeros((_a_35,), dtype=numpy.dtype(numpy.int32))
   _a_39=self.__linearvar_1alloc_I_3I(_a_35,_a_38)
   if ((_a_3._key)==mosek.fusion.RelationKey.IsFree):
    self._task_1var_1putboundlist_1fr__3I(_a_38)
   if ((_a_3._key)==mosek.fusion.RelationKey.LessThan):
    self._task_1var_1putboundlist_1up__3I_3D(_a_38,_a_36)
   elif ((_a_3._key)==mosek.fusion.RelationKey.GreaterThan):
    self._task_1var_1putboundlist_1lo__3I_3D(_a_38,_a_36)
   elif ((_a_3._key)==mosek.fusion.RelationKey.EqualsTo):
    self._task_1var_1putboundlist_1fx__3I_3D(_a_38,_a_36)
   _a_40=mosek_fusion_LinearVariable._ctor_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(self,_a_0,_a_39,_a_4,_a_23,_a_38)
   self.__vars[_a_39] = _a_40
   if (int(len(_a_0)) > 0):
    _a_41=mosek.fusion.Utils.StringBuffer()
    _a_41._a_S(_a_0)._a_S("[")
    if (_a_5 > 0):
     _a_41._a_S("%0")
     for _a_42 in range(1,_a_5):
      _a_41._a_S(",%")._a_I(_a_42)
    _a_41._a_S("]")
    if ((_a_3._indexnames) is not None):
     self._task_1format_1var_1names__3IS_3I_3J_3_3S(_a_38,_a_41._toString_(),_a_4,_a_23,(_a_3._indexnames))
    else:
     self._task_1format_1var_1names__3IS_3I_3J_3_3S(_a_38,_a_41._toString_(),_a_4,_a_23,None)
    self.__var_map._setItem_SI(_a_0,_a_39)
   if (_a_3._cardinal_flag):
    self._task_1var_1putintlist__3I(_a_38)
   return (_a_40)
  def __variable_1_alt_S_3ILmosek_4fusion_4PSDDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=_t__a_2
   _1_res = self.__variable_1_S_3ILmosek_4fusion_4PSDDomain_2(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __variable_1_S_3ILmosek_4fusion_4PSDDomain_2(self,_a_0,_a_1,_a_2):
   if ((int(len(_a_0)) > 0) and self._hasVariable_S(_a_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate variable name '")._a_S(_a_0)._a_S("'")._toString_())
   _a_3=_a_2._finalize_1and_1validate__3I(_a_1)
   _a_4=(_a_3._shape)
   _a_5=(_a_3._conedim1)
   _a_6=(_a_3._conedim2)
   _a_7=int((_a_4).shape[0])
   _a_8=_a_4[_a_5]
   if (_a_5 > _a_6):
    _a_9=_a_5
    _a_5 = _a_6
    _a_6 = _a_9
   if ((_a_5==_a_6) or ((_a_5 < 0) or (_a_6 >= _a_7))):
    raise mosek_fusion_DimensionError._ctor_S("Invalid cone order dimensions for semidefinite variables")
   if (_a_4[_a_5]!=_a_4[_a_6]):
    raise mosek_fusion_DimensionError._ctor_S("Mismatching shape in cone order dimensions")
   _a_10=1
   _a_10 = fragments._c_closure_69(_a_5,_a_10,_a_4)
   _a_10 = numpy.int32(_a_10) # postprocess
   _a_10 = fragments._c_closure_70(_a_5,_a_6,_a_10,_a_4)
   _a_10 = numpy.int32(_a_10) # postprocess
   _a_10 = fragments._c_closure_71(_a_6,_a_7,_a_10,_a_4)
   _a_10 = numpy.int32(_a_10) # postprocess
   _a_11=(((_a_10 * _a_8) * (_a_8 + 1)) // 2)
   _a_12=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.int64))
   _a_13=numpy.zeros((_a_10,), dtype=numpy.dtype(numpy.int32))
   _a_14=self.__barvar_1alloc_II_3I_3J(_a_8,_a_10,_a_13,_a_12)
   _a_15=mosek_fusion_PSDVariable._ctor_Lmosek_4fusion_4Model_2SI_3III_3I_3J(self,_a_0,_a_14,_a_4,(_a_3._conedim1),(_a_3._conedim2),_a_13,_a_12)
   if (int(len(_a_0)) > 0):
    _a_16=numpy.zeros(((_a_7 - 2),), dtype=numpy.dtype(numpy.int32))
    _a_17=(_a_5 if ((_a_5 < _a_6) ) else _a_6)
    _a_18=(_a_6 if ((_a_5 < _a_6) ) else _a_5)
    fragments._c_closure_72(_a_17,_a_16,_a_4) 
    fragments._c_closure_73(_a_17,_a_18,_a_16,_a_4) 
    fragments._c_closure_74(_a_18,_a_16,_a_7,_a_4) 
    _a_19=mosek.fusion.Utils.StringBuffer()
    _a_19._a_S(_a_0)._a_S("[")
    if ((_a_7 - 2) > 0):
     _a_19._a_S("%0")
     for _a_20 in range(1,(_a_7 - 2)):
      _a_19._a_S(",%")._a_I(_a_20)
    _a_19._a_S("]")
    if ((_a_3._indexnames) is not None):
     _a_21=numpy.ndarray(((_a_7 - 2),), dtype=numpy.dtype(object))
     for _a_22 in range(0,_a_17):
      _a_21[_a_22] = (_a_3._indexnames)[_a_22]
     for _a_23 in range((_a_17 + 1),_a_18):
      _a_21[(_a_23 - 1)] = (_a_3._indexnames)[_a_23]
     for _a_24 in range((_a_18 + 1),_a_7):
      _a_21[(_a_24 - 2)] = (_a_3._indexnames)[_a_24]
     self._task_1format_1barvar_1names__3IS_3I_3_3S(_a_13,_a_19._toString_(),_a_16,_a_21)
    else:
     self._task_1format_1barvar_1names__3IS_3I_3_3S(_a_13,_a_19._toString_(),_a_16,None)
   self.__barvars[_a_14] = _a_15
   if (int(len(_a_0)) > 0):
    self.__var_map._setItem_SI(_a_0,(- (_a_14 + 1)))
   return (_a_15)
  def __putfrows_alt__3IILmosek_4fusion_4WorkStack_2IIIII(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5,_t__a_6,_t__a_7):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.int32(_t__a_1)
   _a_2=_t__a_2
   _a_3=numpy.int32(_t__a_3)
   _a_4=numpy.int32(_t__a_4)
   _a_5=numpy.int32(_t__a_5)
   _a_6=numpy.int32(_t__a_6)
   _a_7=numpy.int32(_t__a_7)
   _1_res = self.__putfrows__3IILmosek_4fusion_4WorkStack_2IIIII(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __putfrows__3IILmosek_4fusion_4WorkStack_2IIIII(self,_a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7):
   _a_8=(_a_2.i32)
   _a_9=(_a_2.i64)
   _a_10=(_a_2.f64)
   _a_11=0
   _a_12=0
   _a_13=0
   _a_12,_a_11,_a_13 = fragments._c_closure_75(_a_12,self.__barvar_block_elm_barj,_a_11,_a_3,_a_6,_a_5,_a_8,_a_9,_a_13)
   _a_12 = numpy.int32(_a_12) # postprocess
   _a_11 = numpy.int32(_a_11) # postprocess
   _a_13 = numpy.int32(_a_13) # postprocess
   if (_a_3 > (int((_a_0).shape[0]) - _a_1)):
    raise mosek_fusion_UnexpectedError._ctor_S("Internal: Mismatching sizes")
   _a_14=_a_3
   _a_15=numpy.zeros(((_a_14 + 1),), dtype=numpy.dtype(numpy.int32))
   _a_16=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.int32))
   _a_17=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.float64))
   _a_18=numpy.zeros((_a_3,), dtype=numpy.dtype(numpy.float64))
   fragments._c_closure_76(_a_18,_a_17,_a_7,_a_3,_a_6,_a_5,_a_15,_a_10,_a_8,_a_9,_a_16) 
   self._task_1putafeflist__3J_3I_3I_3D_3D(numpy.array([_a_0[(_a_19 + _a_1)] for _a_19 in range(0,_a_3)], dtype=numpy.dtype(numpy.int64)),_a_15,_a_16,_a_17,_a_18)
   if (_a_12 > 0):
    _a_20=_a_0
    _a_21=numpy.zeros(((_a_14 + 1),), dtype=numpy.dtype(numpy.int32))
    _a_22=numpy.zeros((_a_12,), dtype=numpy.dtype(numpy.int32))
    _a_23=numpy.zeros((_a_12,), dtype=numpy.dtype(numpy.int32))
    _a_24=numpy.zeros((_a_12,), dtype=numpy.dtype(numpy.int64))
    _a_25=numpy.array([(- 1) for _a_26 in range(0,_a_13)], dtype=numpy.dtype(numpy.int32))
    _a_27=numpy.zeros((_a_13,), dtype=numpy.dtype(numpy.int32))
    _a_28=numpy.zeros((_a_13,), dtype=numpy.dtype(numpy.float64))
    _a_29=0
    _a_30=0
    _a_30,_a_29 = fragments._c_closure_77(_a_30,_a_29,_a_22,self.__barvar_block_elm_barj,self.__barvar_block_elm_i,self.__barvar_block_elm_j,self.__barvar_dim,_a_7,_a_28,_a_23,_a_24,_a_25,_a_27,_a_6,_a_14,_a_21,_a_5,_a_10,_a_8,_a_9)
    _a_30 = numpy.int32(_a_30) # postprocess
    _a_29 = numpy.int32(_a_29) # postprocess
    _a_31=self._task_1appendsymmatlist__3I_3J_3I_3I_3D(_a_23,_a_24,_a_25,_a_27,_a_28)
    self._task_1putafebarfrowlist__3I_3I_3I_3J(_a_20,_a_21,_a_22,_a_31)
  def __putarows_alt__3ILmosek_4fusion_4WorkStack_2IIIII(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5,_t__a_6):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=_t__a_1
   _a_2=numpy.int32(_t__a_2)
   _a_3=numpy.int32(_t__a_3)
   _a_4=numpy.int32(_t__a_4)
   _a_5=numpy.int32(_t__a_5)
   _a_6=numpy.int32(_t__a_6)
   _1_res = self.__putarows__3ILmosek_4fusion_4WorkStack_2IIIII(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __putarows__3ILmosek_4fusion_4WorkStack_2IIIII(self,_a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6):
   _a_7=(_a_1.i32)
   _a_8=(_a_1.i64)
   _a_9=(_a_1.f64)
   _a_10=0
   _a_11=0
   _a_12=0
   _a_11,_a_10,_a_12 = fragments._c_closure_78(_a_11,self.__barvar_block_elm_barj,_a_6,_a_10,_a_2,_a_5,_a_4,_a_9,_a_7,_a_8,_a_12)
   _a_11 = numpy.int32(_a_11) # postprocess
   _a_10 = numpy.int32(_a_10) # postprocess
   _a_12 = numpy.int32(_a_12) # postprocess
   _a_13=int((_a_0).shape[0])
   _a_14=numpy.zeros(((_a_13 + 1),), dtype=numpy.dtype(numpy.int64))
   _a_15=numpy.zeros((_a_10,), dtype=numpy.dtype(numpy.int32))
   _a_16=numpy.zeros((_a_10,), dtype=numpy.dtype(numpy.float64))
   fragments._c_closure_79(_a_16,_a_6,_a_2,_a_5,_a_4,_a_14,_a_9,_a_7,_a_8,_a_15) 
   self._task_1putarowlist__3I_3J_3I_3D(_a_0,_a_14,_a_15,_a_16)
   if (_a_11 > 0):
    _a_17=_a_0
    _a_18=numpy.zeros(((_a_13 + 1),), dtype=numpy.dtype(numpy.int64))
    _a_19=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.int32))
    _a_20=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.int32))
    _a_21=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.int64))
    _a_22=numpy.zeros((_a_12,), dtype=numpy.dtype(numpy.int32))
    _a_23=numpy.zeros((_a_12,), dtype=numpy.dtype(numpy.int32))
    _a_24=numpy.zeros((_a_12,), dtype=numpy.dtype(numpy.float64))
    _a_25=0
    _a_26=0
    _a_26,_a_25 = fragments._c_closure_80(_a_26,_a_25,_a_19,self.__barvar_block_elm_barj,self.__barvar_block_elm_i,self.__barvar_block_elm_j,self.__barvar_dim,_a_6,_a_24,_a_20,_a_21,_a_22,_a_23,_a_5,_a_13,_a_18,_a_4,_a_9,_a_7,_a_8)
    _a_26 = numpy.int32(_a_26) # postprocess
    _a_25 = numpy.int32(_a_25) # postprocess
    _a_27=self._task_1appendsymmatlist__3I_3J_3I_3I_3D(_a_20,_a_21,_a_22,_a_23,_a_24)
    self._task_1putbararowlist__3I_3J_3I_3J(_a_17,_a_18,_a_19,_a_27)
  def __constraint_1_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_a_0,_a_1,_a_2)
  def __constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_a_0,_a_1,_a_2):
   if (((self.__rs.pi32)!=0) or (((self.__rs.pi64)!=0) or ((self.__rs.pf64)!=0))):
    raise mosek_fusion_UnexpectedError._ctor_S("Stack rs not clean")
   if (((self.__ws.pi32)!=0) or (((self.__ws.pi64)!=0) or ((self.__ws.pf64)!=0))):
    raise mosek_fusion_UnexpectedError._ctor_S("Stack ws not clean")
   self.__xs._clear_()
   if ((int(len(_a_0)) > 0) and self._hasConstraint_S(_a_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate constraint name '")._a_S(_a_0)._a_S("'")._toString_())
   if (_a_2._cardinal_flag):
    raise mosek_fusion_DomainError._ctor_S("Integer domain not allowed in a constraint")
   _a_3=mosek_fusion_ExprDense._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprOptimizeCode._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2(_a_1)))
   _a_3._recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(self.__rs,self.__ws,self.__xs,self.__cache_evaluations)
   self.__rs._pop_1expr_()
   _a_4=(self.__rs.i32)
   _a_5=(self.__rs.i64)
   _a_6=(self.__rs.f64)
   _a_7=(self.__rs.nd)
   _a_8=(self.__rs.shape_base)
   _a_9=(self.__rs.nelem)
   _a_10=(self.__rs.nnz)
   _a_11=(self.__rs.ncodeatom)
   _a_12=(self.__rs.hassp)
   _a_13=(self.__rs.ptr_base)
   _a_14=(self.__rs.nidxs_base)
   _a_15=(self.__rs.cof_base)
   _a_16=(self.__rs.codeptr_base)
   _a_17=(self.__rs.code_base)
   _a_18=(self.__rs.cconst_base)
   _a_19=numpy.array([_a_4[(_a_8 + _a_20)] for _a_20 in range(0,_a_7)], dtype=numpy.dtype(numpy.int32))
   _a_21=_a_2._finalize_1and_1validate__3I(_a_19)
   if ((_a_21._shape) is not None):
    if (int(((_a_21._shape)).shape[0])!=_a_7):
     raise mosek_fusion_DimensionError._ctor_S("Mismatching expression and domain")
    else:
     for _a_22 in range(0,_a_7):
      if ((_a_21._shape)[_a_22]!=_a_4[(_a_8 + _a_22)]):
       raise mosek_fusion_DimensionError._ctor_S("Mismatching expression and domain")
   _a_23=1
   _a_23 = fragments._c_closure_81(_a_7,_a_23,_a_4,_a_8)
   _a_23 = numpy.int32(_a_23) # postprocess
   _a_24=numpy.zeros((_a_23,), dtype=numpy.dtype(numpy.int32))
   _a_25=self.__con_1allocate__3I(_a_24)
   self.__putarows__3ILmosek_4fusion_4WorkStack_2IIIII(_a_24,self.__rs,_a_9,_a_10,_a_13,_a_14,_a_15)
   self.__xs._clear_()
   _a_26=numpy.zeros((_a_23,), dtype=numpy.dtype(numpy.float64))
   _a_27=numpy.zeros((_a_23,), dtype=numpy.dtype(numpy.float64))
   _a_28=(_a_21._lb)
   _a_29=(_a_21._ub)
   _a_30=(_a_21._empty)
   _a_31=(_a_21._scalable)
   _a_32=(_a_21._sparsity)
   fragments._c_closure_82(_a_26,_a_27,_a_30,_a_28,_a_31,_a_32,_a_29,_a_7,_a_23,_a_4,_a_8) 
   self._task_1con_1putboundlist_1ra__3I_3D_3D(_a_24,_a_26,_a_27)
   if (_a_11 > 0):
    self.__con_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,_a_24,_a_13,_a_14,_a_16,_a_17,_a_18)
   if (int(len(_a_0)) > 0):
    _a_33=mosek.fusion.Utils.StringBuffer()
    _a_33._a_S(_a_0)._a_S("[")
    if (int((_a_19).shape[0]) > 0):
     _a_33._a_S("%0")
    for _a_34 in range(1,int((_a_19).shape[0])):
     _a_33._a_S(",%")._a_I(_a_34)
    _a_33._a_S("]")
    if ((_a_21._indexnames) is not None):
     self._task_1format_1con_1names__3IS_3I_3J_3_3S(_a_24,_a_33._toString_(),_a_19,None,(_a_21._indexnames))
    else:
     self._task_1format_1con_1names__3IS_3I_3J_3_3S(_a_24,_a_33._toString_(),_a_19,None,None)
   _a_35=mosek_fusion_RangedConstraint._ctor_Lmosek_4fusion_4Model_2S_3I_3II(self,_a_0,numpy.array([_a_4[(_a_8 + _a_36)] for _a_36 in range(0,_a_7)], dtype=numpy.dtype(numpy.int32)),_a_24,_a_25)
   self.__cons[_a_25] = _a_35
   if (int(len(_a_0)) > 0):
    self.__con_map._setItem_SI(_a_0,_a_25)
   return (_a_35)
  def __constraint_1_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_a_0,_a_1,_a_2)
  def __constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_a_0,_a_1,_a_2):
   if (((self.__rs.pi32)!=0) or (((self.__rs.pi64)!=0) or ((self.__rs.pf64)!=0))):
    raise mosek_fusion_UnexpectedError._ctor_S("Stack rs not clean")
   if (((self.__ws.pi32)!=0) or (((self.__ws.pi64)!=0) or ((self.__ws.pf64)!=0))):
    raise mosek_fusion_UnexpectedError._ctor_S("Stack ws not clean")
   self.__xs._clear_()
   _a_3=_a_1._getShape_()
   _a_4=_a_2._finalize_1and_1validate__3I(_a_3)
   _a_5=((_a_4._conedim1) < (_a_4._conedim2))
   _a_6=((_a_4._conedim2) if (((_a_4._conedim1) < (_a_4._conedim2)) ) else (_a_4._conedim1))
   _a_7=((_a_4._conedim1) if (((_a_4._conedim1) < (_a_4._conedim2)) ) else (_a_4._conedim2))
   _a_8=mosek_fusion_ExprDenseTril._ctor_IILmosek_4fusion_4Expression_2(_a_7,_a_6,mosek_fusion_ExprOptimizeCode._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprScaleVecPSD._ctor_IILmosek_4fusion_4Expression_2(_a_7,_a_6,mosek_fusion_ExprDenseTril._ctor_IILmosek_4fusion_4Expression_2(_a_7,_a_6,(mosek_fusion_ExprSymmetrize._ctor_IILmosek_4fusion_4Expression_2(_a_7,_a_6,_a_1) if (((_a_4._key)==mosek.fusion.PSDKey.IsSymPSD) ) else _a_1))))))
   _a_8._recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(self.__rs,self.__ws,self.__xs,self.__cache_evaluations)
   self.__rs._pop_1expr_()
   _a_9=(self.__rs.i32)
   _a_10=(self.__rs.i64)
   _a_11=(self.__rs.f64)
   _a_12=(self.__rs.nd)
   _a_13=(self.__rs.nelem)
   _a_14=(self.__rs.nnz)
   _a_15=(self.__rs.hassp)
   _a_16=(self.__rs.ncodeatom)
   _a_17=(self.__rs.shape_base)
   _a_18=(self.__rs.ptr_base)
   _a_19=(self.__rs.nidxs_base)
   _a_20=(self.__rs.sp_base)
   _a_21=(self.__rs.cof_base)
   _a_22=(self.__rs.codeptr_base)
   _a_23=(self.__rs.code_base)
   _a_24=(self.__rs.cconst_base)
   _a_25=_a_3[_a_6]
   _a_26=((_a_25 * (_a_25 + 1)) // 2)
   _a_27=1
   _a_27 = fragments._c_closure_83(_a_7,_a_6,_a_12,_a_27,_a_3)
   _a_27 = numpy.int32(_a_27) # postprocess
   _a_28=self._task_1append_1domain_1svec_1psd_I(_a_26)
   _a_29=(_a_26 * _a_27)
   _a_30=numpy.zeros((_a_29,), dtype=numpy.dtype(numpy.int32))
   _a_31=numpy.zeros((_a_27,), dtype=numpy.dtype(numpy.int32))
   _a_32=numpy.zeros((_a_29,), dtype=numpy.dtype(numpy.int32))
   _a_33=numpy.zeros((_a_29,), dtype=numpy.dtype(numpy.float64))
   _a_34=self.__acon_1allocate__3JII_3D_3I_3I(numpy.array([_a_28 for _a_35 in range(0,_a_27)], dtype=numpy.dtype(numpy.int64)),_a_26,_a_27,_a_33,_a_30,_a_31)
   _a_36=numpy.zeros((_a_29,), dtype=numpy.dtype(numpy.int32))
   self.__acon_block_map._get_I_3II(_a_34,_a_36,0)
   _a_37=1
   _a_38=_a_3[_a_6]
   _a_39=1
   _a_40=_a_3[_a_7]
   _a_41=1
   _a_41 = fragments._c_closure_84(_a_7,_a_41,_a_3)
   _a_41 = numpy.int64(_a_41) # postprocess
   _a_39 = fragments._c_closure_85(_a_7,_a_6,_a_39,_a_3)
   _a_39 = numpy.int64(_a_39) # postprocess
   _a_37 = fragments._c_closure_86(_a_6,_a_37,_a_12,_a_3)
   _a_37 = numpy.int64(_a_37) # postprocess
   _a_42=0
   _a_43=(1.0 / mosek.fusion.Utils.Tools._sqrt_D(2))
   _a_42 = fragments._c_closure_87(self.__acon_elm_scale,_a_36,_a_41,_a_40,_a_39,_a_38,_a_37,_a_42,_a_43)
   _a_42 = numpy.int32(_a_42) # postprocess
   _a_44=numpy.zeros((_a_13,), dtype=numpy.dtype(numpy.int32))
   _a_45=0
   _a_45 = fragments._c_closure_88(_a_30,_a_44,_a_26,_a_41,_a_40,_a_39,_a_38,_a_37,_a_45,_a_5)
   _a_45 = numpy.int32(_a_45) # postprocess
   self.__putfrows__3IILmosek_4fusion_4WorkStack_2IIIII(_a_44,0,self.__rs,_a_13,_a_14,_a_18,_a_19,_a_21)
   if (_a_16 > 0):
    self.__afe_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,_a_44,_a_18,_a_19,_a_22,_a_23,_a_24)
   else:
    pass
   _a_46=numpy.zeros((((_a_27 * _a_40) * _a_40),), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_89(_a_30,_a_26,_a_41,_a_40,_a_39,_a_38,_a_37,_a_46,_a_5) 
   if (int(len(_a_0)) > 0):
    _a_47=numpy.zeros(((int((_a_3).shape[0]) - 2),), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_90(_a_7,_a_47,_a_3) 
    fragments._c_closure_91(_a_7,_a_6,_a_47,_a_3) 
    fragments._c_closure_92(_a_6,_a_47,_a_12,_a_3) 
    _a_48=mosek.fusion.Utils.StringBuffer()
    _a_48._a_S(_a_0)._a_S("[")
    if (_a_12 > 2):
     _a_48._a_S("%0")
     for _a_49 in range(1,(_a_12 - 2)):
      _a_48._a_S(",%")._a_I(_a_49)
    _a_48._a_S("]")
    if ((_a_4._indexnames) is not None):
     _a_50=(_a_4._indexnames)
     _a_51=numpy.ndarray(((_a_12 - 2),), dtype=numpy.dtype(object))
     for _a_52 in range(0,_a_7):
      _a_51[_a_52] = _a_50[_a_52]
     for _a_53 in range((_a_7 + 1),_a_6):
      _a_51[(_a_53 - 1)] = _a_50[_a_53]
     for _a_54 in range((_a_6 + 1),_a_12):
      _a_51[(_a_54 - 2)] = _a_50[_a_54]
     self._task_1format_1acc_1names__3JS_3I_3_3S(numpy.array([_a_31[_a_55] for _a_55 in range(0,int((_a_31).shape[0]))], dtype=numpy.dtype(numpy.int64)),_a_48._toString_(),_a_47,_a_51)
    else:
     self._task_1format_1acc_1names__3JS_3I_3_3S(numpy.array([_a_31[_a_56] for _a_56 in range(0,int((_a_31).shape[0]))], dtype=numpy.dtype(numpy.int64)),_a_48._toString_(),_a_47,None)
   _a_57=mosek_fusion_ConicConstraint._ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(self,_a_0,None,_a_3,_a_34,_a_46,None)
   self.__acons[_a_34] = _a_57
   if (int(len(_a_0)) > 0):
    self.__con_map._setItem_SI(_a_0,(- (1 + _a_34)))
   return (_a_57)
  def __constraint_1_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(_a_0,_a_1,_a_2)
  def __constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(self,_a_0,_a_1,_a_2):
   if (((self.__rs.pi32)!=0) or (((self.__rs.pi64)!=0) or ((self.__rs.pf64)!=0))):
    raise mosek_fusion_UnexpectedError._ctor_S("Stack rs not clean")
   if (((self.__ws.pi32)!=0) or (((self.__ws.pi64)!=0) or ((self.__ws.pf64)!=0))):
    raise mosek_fusion_UnexpectedError._ctor_S("Stack ws not clean")
   self.__xs._clear_()
   if ((int(len(_a_0)) > 0) and self._hasConstraint_S(_a_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate constraint name '")._a_S(_a_0)._a_S("'")._toString_())
   if ((int(len(_a_0)) > 0) and self._hasConstraint_S(_a_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate constraint name '")._a_S(_a_0)._a_S("'")._toString_())
   if (_a_2._int_flag):
    raise mosek_fusion_DomainError._ctor_S("Integer domain not allowed in a constraint")
   _a_3=mosek_fusion_ExprDense._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprOptimizeCode._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2(_a_1)))
   _a_3._recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(self.__rs,self.__ws,self.__xs,self.__cache_evaluations)
   self.__rs._pop_1expr_()
   _a_4=(self.__rs.i32)
   _a_5=(self.__rs.i64)
   _a_6=(self.__rs.f64)
   _a_7=(self.__rs.nd)
   _a_8=(self.__rs.shape_base)
   _a_9=(self.__rs.nelem)
   _a_10=(self.__rs.nnz)
   _a_11=(self.__rs.ncodeatom)
   _a_12=(self.__rs.hassp)
   _a_13=(self.__rs.ptr_base)
   _a_14=(self.__rs.nidxs_base)
   _a_15=(self.__rs.cof_base)
   _a_16=(self.__rs.code_base)
   _a_17=(self.__rs.codeptr_base)
   _a_18=(self.__rs.cconst_base)
   _a_19=numpy.array([_a_4[(_a_8 + _a_20)] for _a_20 in range(0,_a_7)], dtype=numpy.dtype(numpy.int32))
   _a_21=_a_2._finalize_1and_1validate__3I(_a_19)
   _a_22=(_a_21._getAxis_() if (_a_21._axisIsSet_() ) else (_a_7 - 1))
   _a_23=_a_19[_a_22]
   _a_24=1
   _a_25=1
   _a_26=1
   _a_26 = fragments._c_closure_93(_a_26,_a_7,_a_19)
   _a_26 = numpy.int32(_a_26) # postprocess
   _a_25 = fragments._c_closure_94(_a_22,_a_25,_a_19)
   _a_25 = numpy.int32(_a_25) # postprocess
   _a_24 = fragments._c_closure_95(_a_22,_a_24,_a_7,_a_19)
   _a_24 = numpy.int32(_a_24) # postprocess
   _a_27=(_a_25 * _a_24)
   _a_28=(- 1)
   _a_29=numpy.zeros((0,), dtype=numpy.dtype(numpy.int64))
   if ((_a_21._key)==mosek.fusion.QConeKey.InQCone):
    if (_a_23 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_23)._a_S(") for quadratic cone")._toString_())
    _a_28 = self._task_1append_1domain_1quad_I(_a_23)
   elif ((_a_21._key)==mosek.fusion.QConeKey.InRotatedQCone):
    if (_a_23 < 3):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_23)._a_S(") for rotated quadratic cone")._toString_())
    _a_28 = self._task_1append_1domain_1rquad_I(_a_23)
   elif ((_a_21._key)==mosek.fusion.QConeKey.InPExpCone):
    if (_a_23!=3):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_23)._a_S(") for exponential cone")._toString_())
    _a_28 = self._task_1append_1domain_1pexp_()
   elif ((_a_21._key)==mosek.fusion.QConeKey.InPPowCone):
    if (_a_23 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_23)._a_S(") for power cone")._toString_())
    if (int(((_a_21._alpha)).shape[0]) < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Power cone requires at least two parameters")._toString_())
    _a_28 = self._task_1append_1domain_1ppow_I_3D(_a_23,(_a_21._alpha))
   elif ((_a_21._key)==mosek.fusion.QConeKey.InPPowConeSeq):
    if (_a_23 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_23)._a_S(") for power cone")._toString_())
    if ((int(((_a_21._alpha)).shape[0]) % _a_27)!=0):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Incompatible number of cones and number of exponents alpha")._toString_())
    _a_30=(int(((_a_21._alpha)).shape[0]) // _a_27)
    if (_a_30 > _a_23):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid number of exponents (")._a_I(_a_30)._a_S(") per power cone of dimension ")._a_I(_a_23)._toString_())
    _a_29 = self._task_1append_1domain_1ppow_1seq_II_3D(_a_23,_a_30,(_a_21._alpha))
   elif ((_a_21._key)==mosek.fusion.QConeKey.InDExpCone):
    if (_a_23!=3):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_23)._a_S(") for dual exponential cone")._toString_())
    _a_28 = self._task_1append_1domain_1dexp_()
   elif ((_a_21._key)==mosek.fusion.QConeKey.InDPowCone):
    if (_a_23 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_23)._a_S(") for dual power cone")._toString_())
    if (int(((_a_21._alpha)).shape[0]) < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Power cone requires at least two parameters")._toString_())
    _a_28 = self._task_1append_1domain_1dpow_I_3D(_a_23,(_a_21._alpha))
   elif ((_a_21._key)==mosek.fusion.QConeKey.InDPowConeSeq):
    if (_a_23 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_23)._a_S(") for power cone")._toString_())
    if ((int(((_a_21._alpha)).shape[0]) % _a_27)!=0):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Incompatible number of cones and number of exponents alpha")._toString_())
    _a_31=(int(((_a_21._alpha)).shape[0]) // _a_27)
    if (_a_31 > _a_23):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid number of exponents (")._a_I(_a_31)._a_S(") per power cone of dimension ")._a_I(_a_23)._toString_())
    _a_29 = self._task_1append_1domain_1dpow_1seq_II_3D(_a_23,_a_31,(_a_21._alpha))
   elif ((_a_21._key)==mosek.fusion.QConeKey.InPGeoMeanCone):
    if (_a_23 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_23)._a_S(") for primal geometric mean cone")._toString_())
    _a_28 = self._task_1append_1domain_1pgeomean_I(_a_23)
   elif ((_a_21._key)==mosek.fusion.QConeKey.InDGeoMeanCone):
    if (_a_23 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_23)._a_S(") for dual geometric mean cone")._toString_())
    _a_28 = self._task_1append_1domain_1dgeomean_I(_a_23)
   elif ((_a_21._key)==mosek.fusion.QConeKey.InSVecPSDCone):
    _a_32=numpy.int32(((mosek.fusion.Utils.Tools._sqrt_D((1 + (8 * _a_23))) - 1) / 2))
    if (((_a_32 * (_a_32 + 1)) // 2)!=_a_23):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_23)._a_S(") for vector positive semidefinite cone")._toString_())
    _a_28 = self._task_1append_1domain_1svec_1psd_I(_a_23)
   elif ((_a_21._key)==mosek.fusion.QConeKey.Positive):
    _a_28 = self._task_1append_1domain_1rpos_I(_a_23)
   elif ((_a_21._key)==mosek.fusion.QConeKey.Negative):
    _a_28 = self._task_1append_1domain_1rneg_I(_a_23)
   elif ((_a_21._key)==mosek.fusion.QConeKey.Unbounded):
    _a_28 = self._task_1append_1domain_1r_I(_a_23)
   elif ((_a_21._key)==mosek.fusion.QConeKey.Zero):
    _a_28 = self._task_1append_1domain_1rzero_I(_a_23)
   elif ((_a_21._key)==mosek.fusion.QConeKey.InPSDCone):
    if (_a_23 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_23)._a_S(") for positive semidefinite cone")._toString_())
    else:
     _a_33=numpy.int32(((mosek.fusion.Utils.Tools._sqrt_D((1 + (8 * _a_23))) - 1) / 2))
     if (((_a_33 * (_a_33 + 1)) // 2)!=_a_23):
      raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_a_23)._a_S(") for positive semidefinite cone")._toString_())
    _a_28 = self._task_1append_1domain_1svec_1psd_I(_a_23)
   else:
    raise mosek_fusion_UnexpectedError._ctor_S("Internal error: Invalid cone type")
   _a_34=numpy.zeros((_a_26,), dtype=numpy.dtype(numpy.float64))
   _a_35=numpy.zeros((_a_26,), dtype=numpy.dtype(numpy.int32))
   _a_36=numpy.zeros((_a_27,), dtype=numpy.dtype(numpy.int32))
   if (((_a_21._key)==mosek.fusion.QConeKey.InPPowConeSeq) or ((_a_21._key)==mosek.fusion.QConeKey.InDPowConeSeq)):
    pass
   else:
    _a_29 = numpy.array([_a_28 for _a_37 in range(0,_a_27)], dtype=numpy.dtype(numpy.int64))
   _a_38=self.__acon_1allocate__3JII_3D_3I_3I(_a_29,_a_23,_a_27,_a_34,_a_35,_a_36)
   _a_39=numpy.zeros((_a_26,), dtype=numpy.dtype(numpy.int32))
   _a_40=0
   _a_41=(_a_21._domofs)
   _a_40 = fragments._c_closure_96(_a_23,_a_25,_a_24,_a_26,_a_34,_a_40,_a_41,_a_39)
   _a_40 = numpy.int32(_a_40) # postprocess
   _a_42=numpy.array([_a_35[_a_39[_a_43]] for _a_43 in range(0,_a_26)], dtype=numpy.dtype(numpy.int32))
   self.__putfrows__3IILmosek_4fusion_4WorkStack_2IIIII(_a_42,0,self.__rs,_a_9,_a_10,_a_13,_a_14,_a_15)
   if (_a_11 > 0):
    self.__afe_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,_a_42,_a_13,_a_14,_a_17,_a_16,_a_18)
   if (int(len(_a_0)) > 0):
    _a_44=numpy.zeros(((int((_a_19).shape[0]) - 1),), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_97(_a_44,_a_22,_a_19) 
    fragments._c_closure_98(_a_44,_a_22,_a_7,_a_19) 
    _a_45=mosek.fusion.Utils.StringBuffer()
    _a_45._a_S(_a_0)._a_S("[")
    if (_a_7 > 1):
     _a_45._a_S("%0")
     for _a_46 in range(1,(_a_7 - 1)):
      _a_45._a_S(",%")._a_I(_a_46)
    _a_45._a_S("]")
    if ((_a_21._indexnames) is not None):
     _a_47=(_a_21._indexnames)
     _a_48=numpy.ndarray(((_a_7 - 1),), dtype=numpy.dtype(object))
     for _a_49 in range(0,_a_22):
      _a_48[_a_49] = _a_47[_a_49]
     for _a_50 in range((_a_22 + 1),_a_7):
      _a_48[(_a_50 - 1)] = _a_47[_a_50]
     self._task_1format_1acc_1names__3JS_3I_3_3S(numpy.array([_a_36[_a_51] for _a_51 in range(0,int((_a_36).shape[0]))], dtype=numpy.dtype(numpy.int64)),_a_45._toString_(),_a_44,_a_48)
    else:
     self._task_1format_1acc_1names__3JS_3I_3_3S(numpy.array([_a_36[_a_52] for _a_52 in range(0,int((_a_36).shape[0]))], dtype=numpy.dtype(numpy.int64)),_a_45._toString_(),_a_44,None)
   _a_53=mosek_fusion_ConicConstraint._ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(self,_a_0,_a_21,_a_19,_a_38,_a_35,(_a_21._indexnames))
   self.__acons[_a_38] = _a_53
   if (int(len(_a_0)) > 0):
    self.__con_map._setItem_SI(_a_0,(- (_a_38 + 1)))
   return (_a_53)
  def __constraint_1_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_a_0,_a_1,_a_2)
  def __constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_a_0,_a_1,_a_2):
   if (((self.__rs.pi32)!=0) or (((self.__rs.pi64)!=0) or ((self.__rs.pf64)!=0))):
    raise mosek_fusion_UnexpectedError._ctor_S("Stack rs not clean")
   if (((self.__ws.pi32)!=0) or (((self.__ws.pi64)!=0) or ((self.__ws.pf64)!=0))):
    raise mosek_fusion_UnexpectedError._ctor_S("Stack ws not clean")
   self.__xs._clear_()
   if ((int(len(_a_0)) > 0) and self._hasConstraint_S(_a_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate constraint name '")._a_S(_a_0)._a_S("'")._toString_())
   if (_a_2._cardinal_flag):
    raise mosek_fusion_DomainError._ctor_S("Integer domain not allowed in a constraint")
   _a_3=mosek_fusion_ExprDense._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprOptimizeCode._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2(_a_1)))
   _a_3._recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(self.__rs,self.__ws,self.__xs,self.__cache_evaluations)
   self.__rs._pop_1expr_()
   _a_4=(self.__rs.i32)
   _a_5=(self.__rs.i64)
   _a_6=(self.__rs.f64)
   _a_7=(self.__rs.nd)
   _a_8=(self.__rs.nelem)
   _a_9=(self.__rs.nnz)
   _a_10=(self.__rs.hassp)
   _a_11=(self.__rs.ncodeatom)
   _a_12=(self.__rs.shape_base)
   _a_13=(self.__rs.ptr_base)
   _a_14=(self.__rs.nidxs_base)
   _a_15=(self.__rs.cof_base)
   _a_16=(self.__rs.codeptr_base)
   _a_17=(self.__rs.code_base)
   _a_18=(self.__rs.cconst_base)
   _a_19=numpy.array([_a_4[(_a_12 + _a_20)] for _a_20 in range(0,_a_7)], dtype=numpy.dtype(numpy.int32))
   _a_21=_a_2._finalize_1and_1validate__3I(_a_19)
   _a_22=(_a_21._domsize)
   _a_23=(_a_21._indexnames)
   _a_25=numpy.zeros((_a_22,), dtype=numpy.dtype(numpy.int32))
   _a_26=self.__con_1allocate__3I(_a_25)
   self.__putarows__3ILmosek_4fusion_4WorkStack_2IIIII(_a_25,self.__rs,_a_8,_a_9,_a_13,_a_14,_a_15)
   _a_27=(_a_21._sparsity)
   _a_28=(_a_21._empty)
   _a_29=(_a_21._bnd)
   _a_30=(_a_21._scalable)
   if (_a_29 is None):
    _a_24 = numpy.zeros((int((_a_25).shape[0]),), dtype=numpy.dtype(numpy.float64))
   elif _a_30:
    _a_24 = numpy.array([_a_29[0] for _a_31 in range(0,int((_a_25).shape[0]))], dtype=numpy.dtype(numpy.float64))
   elif (_a_27 is not None):
    _a_32=numpy.zeros((_a_7,), dtype=numpy.dtype(numpy.int32))
    _a_32[(_a_7 - 1)] = 1
    fragments._c_closure_99(_a_7,_a_19,_a_32) 
    _a_24 = numpy.zeros((int((_a_25).shape[0]),), dtype=numpy.dtype(numpy.float64))
    fragments._c_closure_100(_a_24,_a_29,_a_27,_a_7,_a_32) 
   elif _a_28:
    _a_24 = numpy.zeros((int((_a_25).shape[0]),), dtype=numpy.dtype(numpy.float64))
   else:
    _a_24 = numpy.array([_a_29[_a_33] for _a_33 in range(0,int((_a_25).shape[0]))], dtype=numpy.dtype(numpy.float64))
   if ((_a_21._key)==mosek.fusion.RelationKey.IsFree):
    self._task_1con_1putboundlist_1fr__3I(_a_25)
   if ((_a_21._key)==mosek.fusion.RelationKey.LessThan):
    self._task_1con_1putboundlist_1up__3I_3D(_a_25,_a_24)
   elif ((_a_21._key)==mosek.fusion.RelationKey.GreaterThan):
    self._task_1con_1putboundlist_1lo__3I_3D(_a_25,_a_24)
   elif ((_a_21._key)==mosek.fusion.RelationKey.EqualsTo):
    self._task_1con_1putboundlist_1fx__3I_3D(_a_25,_a_24)
   if (_a_11 > 0):
    self.__con_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,_a_25,_a_13,_a_14,_a_16,_a_17,_a_18)
   if (int(len(_a_0)) > 0):
    _a_34=mosek.fusion.Utils.StringBuffer()
    _a_34._a_S(_a_0)._a_S("[")
    if (int((_a_19).shape[0]) > 0):
     _a_34._a_S("%0")
    for _a_35 in range(1,int((_a_19).shape[0])):
     _a_34._a_S(",%")._a_I(_a_35)
    _a_34._a_S("]")
    if ((_a_21._indexnames) is not None):
     self._task_1format_1con_1names__3IS_3I_3J_3_3S(_a_25,_a_34._toString_(),_a_19,None,(_a_21._indexnames))
    else:
     self._task_1format_1con_1names__3IS_3I_3J_3_3S(_a_25,_a_34._toString_(),_a_19,None,None)
   _a_36=mosek_fusion_LinearConstraint._ctor_Lmosek_4fusion_4Model_2SI_3I_3I_3_3S(self,_a_0,_a_26,_a_19,_a_25,_a_23)
   self.__cons[_a_26] = _a_36
   if (int(len(_a_0)) > 0):
    self.__con_map._setItem_SI(_a_0,_a_26)
   return (_a_36)
  @staticmethod
  def _match_getVersion_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getVersion_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _getVersion_alt_():
    return mosek_fusion_Model._getVersion_()
  @staticmethod
  def _getVersion_():
   return (mosek.fusion.BaseModel._env_1getversion_())
  @staticmethod
  def _match_hasParameter_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_S__(_a_0))
  @staticmethod
  def _match_alt_hasParameter_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_S__(_a_0))
  def _hasParameter_alt_S(self,_t__a_0):
    return self._hasParameter_S(_a_0)
  def _hasParameter_S(self,_a_0):
   return (self.__par_map._hasItem_S(_a_0))
  @staticmethod
  def _match_hasConstraint_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_S__(_a_0))
  @staticmethod
  def _match_alt_hasConstraint_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_S__(_a_0))
  def _hasConstraint_alt_S(self,_t__a_0):
    return self._hasConstraint_S(_a_0)
  def _hasConstraint_S(self,_a_0):
   return (self.__con_map._hasItem_S(_a_0))
  @staticmethod
  def _match_hasVariable_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_S__(_a_0))
  @staticmethod
  def _match_alt_hasVariable_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_S__(_a_0))
  def _hasVariable_alt_S(self,_t__a_0):
    return self._hasVariable_S(_a_0)
  def _hasVariable_S(self,_a_0):
   return (self.__var_map._hasItem_S(_a_0))
  @staticmethod
  def _match_getParameter_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_S__(_a_0))
  @staticmethod
  def _match_alt_getParameter_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_S__(_a_0))
  def _getParameter_alt_S(self,_t__a_0):
    return self._getParameter_S(_a_0)
  def _getParameter_S(self,_a_0):
   return ((self.__parameters[self.__par_map._getItem_S(_a_0)] if (self.__par_map._hasItem_S(_a_0) ) else None))
  @staticmethod
  def _match_getConstraint_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_getConstraint_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _getConstraint_alt_I(self,_t__a_0):
    return self._getConstraint_I(numpy.int32(__a_0))
  def _getConstraint_I(self,_a_0):
   if (_a_0 >= 0):
    _a_1 = self.__cons[_a_0]
   else:
    _a_1 = self.__acons[(- (1 + _a_0))]
   return (_a_1)
  @staticmethod
  def _match_getConstraint_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_S__(_a_0))
  @staticmethod
  def _match_alt_getConstraint_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_S__(_a_0))
  def _getConstraint_alt_S(self,_t__a_0):
    return self._getConstraint_S(_a_0)
  def _getConstraint_S(self,_a_0):
   _a_1=None
   if self.__con_map._hasItem_S(_a_0):
    _a_2=self.__con_map._getItem_S(_a_0)
    if (_a_2 >= 0):
     _a_1 = self.__cons[_a_2]
    else:
     _a_1 = self.__acons[(- (1 + _a_2))]
   return (_a_1)
  @staticmethod
  def _match_getVariable_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_getVariable_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _getVariable_alt_I(self,_t__a_0):
    return self._getVariable_I(numpy.int32(__a_0))
  def _getVariable_I(self,_a_0):
   return (self.__vars[_a_0])
  @staticmethod
  def _match_getVariable_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_S__(_a_0))
  @staticmethod
  def _match_alt_getVariable_S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_S__(_a_0))
  def _getVariable_alt_S(self,_t__a_0):
    return self._getVariable_S(_a_0)
  def _getVariable_S(self,_a_0):
   if self.__var_map._hasItem_S(_a_0):
    _a_1=self.__var_map._getItem_S(_a_0)
    if (_a_1 < 0):
     return (self.__barvars[(- (_a_1 + 1))])
    else:
     return (self.__vars[_a_1])
   else:
    return (None)
  @staticmethod
  def _match_getName_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getName_(*args):
    if len(args) != 0: return False
    return True
  def _getName_alt_(self,):
    return self._getName_()
  def _getName_(self,):
   return (self.__model_name)
  def _getParameterValue_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._getParameterValue__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _getParameterValue__3I(self,_a_0):
   _a_1=numpy.zeros((int((_a_0).shape[0]),), dtype=numpy.dtype(numpy.float64))
   fragments._c_closure_101(_a_0,self.__param_value,_a_1) 
   return (_a_1)
  def _setParameterValue_alt__3I_3D(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.float64))
   _1_res = self._setParameterValue__3I_3D(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _setParameterValue__3I_3D(self,_a_0,_a_1):
   fragments._c_closure_102(_a_0,self.__param_value,_a_1) 
  @staticmethod
  def _match_clone_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_clone_(*args):
    if len(args) != 0: return False
    return True
  def _clone_alt_(self,):
    return self._clone_()
  def _clone_(self,):
   return (mosek_fusion_Model._ctor_Lmosek_4fusion_4Model_2(self))
 return Model
mosek_fusion_Model=__mk_mosek_fusion_Model()
del __mk_mosek_fusion_Model
def __mk_mosek_fusion_Debug():
  import sys
  class Debug:
    @staticmethod
    def _o_(): return Debug()
    def p(self,v):
      sys.stdout.write(str(v))
      return self
    _p_S = p
    _p_I = p
    _p_J = p
    _p_D = p
    _p_Z = p
  
    def p_array (self,v):
      if v is None:
          sys.stdout.write('None')
      else:
          sys.stdout.write('[ %s ]' % ','.join([str(i) for i in v]))
      return self
  
    _p__3I = p_array
    _p__3J = p_array
    _p__3D = p_array
  
    def _lf_(self):
      sys.stdout.write("\n")
      return self
  return Debug
mosek_fusion_Debug=__mk_mosek_fusion_Debug()
#BEFORE CLASS
def __mk_mosek_fusion_Sort():
 class Sort(object):
  @staticmethod
  def argbucketsort(*args):
    '''
    Syntax
    ------

      mosek.fusion.Sort.argbucketsort(array(int64,ndim=1),array(int32,ndim=1),int64,int64,int32,int32)
      mosek.fusion.Sort.argbucketsort(array(int64,ndim=1),array(int64,ndim=1),int64,int64,int64,int64)

    Description
    -----------

    

    Parameters
    ----------

    first : int64
    idx : array(int64,ndim=1)
    last : int64
    maxv : int64
    minv : int64
    vals : array(int64,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Sort._match_argbucketsort__3J_3IJJII(*args):
      return mosek_fusion_Sort._argbucketsort__3J_3IJJII(*args)
    elif mosek_fusion_Sort._match_alt_argbucketsort__3J_3IJJII(*args):
      return mosek_fusion_Sort._argbucketsort_alt__3J_3IJJII(*args)
    elif mosek_fusion_Sort._match_argbucketsort__3J_3JJJJJ(*args):
      return mosek_fusion_Sort._argbucketsort__3J_3JJJJJ(*args)
    elif mosek_fusion_Sort._match_alt_argbucketsort__3J_3JJJJJ(*args):
      return mosek_fusion_Sort._argbucketsort_alt__3J_3JJJJJ(*args)
    else:
      raise ValueError('Invalid argument list argbucketsort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Sort.argbucketsort(array(int64,ndim=1),array(int32,ndim=1),int64,int64,int32,int32)\n\tmosek.fusion.Sort.argbucketsort(array(int64,ndim=1),array(int64,ndim=1),int64,int64,int64,int64)')
  @staticmethod
  def getminmax(*args):
    '''
    Syntax
    ------

      mosek.fusion.Sort.getminmax(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64,array(int32,ndim=1))
      mosek.fusion.Sort.getminmax(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64,array(int64,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    first : int64
    idx : array(int64,ndim=1)
    last : int64
    res : array(int64,ndim=1)
    vals1 : array(int64,ndim=1)
    vals2 : array(int64,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Sort._match_getminmax__3J_3I_3IJJ_3I(*args):
      return mosek_fusion_Sort._getminmax__3J_3I_3IJJ_3I(*args)
    elif mosek_fusion_Sort._match_alt_getminmax__3J_3I_3IJJ_3I(*args):
      return mosek_fusion_Sort._getminmax_alt__3J_3I_3IJJ_3I(*args)
    elif mosek_fusion_Sort._match_getminmax__3J_3J_3JJJ_3J(*args):
      return mosek_fusion_Sort._getminmax__3J_3J_3JJJ_3J(*args)
    elif mosek_fusion_Sort._match_alt_getminmax__3J_3J_3JJJ_3J(*args):
      return mosek_fusion_Sort._getminmax_alt__3J_3J_3JJJ_3J(*args)
    else:
      raise ValueError('Invalid argument list getminmax('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Sort.getminmax(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64,array(int32,ndim=1))\n\tmosek.fusion.Sort.getminmax(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64,array(int64,ndim=1))')
  @staticmethod
  def argsort(*args):
    '''
    Syntax
    ------

      mosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1))
      mosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1))
      mosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1))
      mosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1))
      mosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),int64,int64)
      mosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),int64,int64)
      mosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),int64,int64,bool)
      mosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64)
      mosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64)
      mosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),int64,int64,bool)
      mosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64,bool)
      mosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64,bool)

    Description
    -----------

    

    Parameters
    ----------

    check : bool
    first : int64
    idx : array(int64,ndim=1)
    last : int64
    vals1 : array(int64,ndim=1)
    vals2 : array(int64,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Sort._match_argsort__3J_3J(*args):
      return mosek_fusion_Sort._argsort__3J_3J(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3J(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3J(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3I(*args):
      return mosek_fusion_Sort._argsort__3J_3I(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3I(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3I(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3I_3I(*args):
      return mosek_fusion_Sort._argsort__3J_3I_3I(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3I_3I(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3I_3I(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3J_3J(*args):
      return mosek_fusion_Sort._argsort__3J_3J_3J(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3J_3J(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3J_3J(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3JJJ(*args):
      return mosek_fusion_Sort._argsort__3J_3JJJ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3JJJ(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3JJJ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3IJJ(*args):
      return mosek_fusion_Sort._argsort__3J_3IJJ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3IJJ(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3IJJ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3JJJZ(*args):
      return mosek_fusion_Sort._argsort__3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3JJJZ(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3I_3IJJ(*args):
      return mosek_fusion_Sort._argsort__3J_3I_3IJJ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3I_3IJJ(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3I_3IJJ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3J_3JJJ(*args):
      return mosek_fusion_Sort._argsort__3J_3J_3JJJ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3J_3JJJ(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3J_3JJJ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3IJJZ(*args):
      return mosek_fusion_Sort._argsort__3J_3IJJZ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3IJJZ(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3IJJZ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3I_3IJJZ(*args):
      return mosek_fusion_Sort._argsort__3J_3I_3IJJZ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3I_3IJJZ(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3I_3IJJZ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3J_3JJJZ(*args):
      return mosek_fusion_Sort._argsort__3J_3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3J_3JJJZ(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3J_3JJJZ(*args)
    else:
      raise ValueError('Invalid argument list argsort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1))\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1))\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),int64,int64)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),int64,int64)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64,bool)')
  @staticmethod
  def argTransposeSort(*args):
    '''
    Syntax
    ------

      mosek.fusion.Sort.argTransposeSort(array(int64,ndim=1),array(int64,ndim=1),int32,int32,int32,array(int64,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    m : int32
    n : int32
    p : int32
    perm : array(int64,ndim=1)
    ptrb : array(int64,ndim=1)
    val : array(int64,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Sort._match_argTransposeSort__3J_3JIII_3J(*args):
      return mosek_fusion_Sort._argTransposeSort__3J_3JIII_3J(*args)
    elif mosek_fusion_Sort._match_alt_argTransposeSort__3J_3JIII_3J(*args):
      return mosek_fusion_Sort._argTransposeSort_alt__3J_3JIII_3J(*args)
    else:
      raise ValueError('Invalid argument list argTransposeSort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Sort.argTransposeSort(array(int64,ndim=1),array(int64,ndim=1),int32,int32,int32,array(int64,ndim=1))')
  @staticmethod
  def issorted(*args):
    '''
    Syntax
    ------

      mosek.fusion.Sort.issorted(array(int64,ndim=1),array(int32,ndim=1),int64,int64,bool)
      mosek.fusion.Sort.issorted(array(int64,ndim=1),array(int64,ndim=1),int64,int64,bool)
      mosek.fusion.Sort.issorted(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64,bool)
      mosek.fusion.Sort.issorted(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64,bool)

    Description
    -----------

    

    Parameters
    ----------

    check : bool
    first : int64
    idx : array(int64,ndim=1)
    last : int64
    vals1 : array(int64,ndim=1)
    vals2 : array(int64,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Sort._match_issorted__3J_3IJJZ(*args):
      return mosek_fusion_Sort._issorted__3J_3IJJZ(*args)
    elif mosek_fusion_Sort._match_alt_issorted__3J_3IJJZ(*args):
      return mosek_fusion_Sort._issorted_alt__3J_3IJJZ(*args)
    elif mosek_fusion_Sort._match_issorted__3J_3JJJZ(*args):
      return mosek_fusion_Sort._issorted__3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_alt_issorted__3J_3JJJZ(*args):
      return mosek_fusion_Sort._issorted_alt__3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_issorted__3J_3I_3IJJZ(*args):
      return mosek_fusion_Sort._issorted__3J_3I_3IJJZ(*args)
    elif mosek_fusion_Sort._match_alt_issorted__3J_3I_3IJJZ(*args):
      return mosek_fusion_Sort._issorted_alt__3J_3I_3IJJZ(*args)
    elif mosek_fusion_Sort._match_issorted__3J_3J_3JJJZ(*args):
      return mosek_fusion_Sort._issorted__3J_3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_alt_issorted__3J_3J_3JJJZ(*args):
      return mosek_fusion_Sort._issorted_alt__3J_3J_3JJJZ(*args)
    else:
      raise ValueError('Invalid argument list issorted('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Sort.issorted(array(int64,ndim=1),array(int32,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.issorted(array(int64,ndim=1),array(int64,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.issorted(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.issorted(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64,bool)')
  def __repr__(self): return 'mosek.fusion.Sort'
  @staticmethod
  def _match_argTransposeSort__3J_3JIII_3J(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3J__(_a_1) and __arg_match_I__(_a_2) and __arg_match_I__(_a_3) and __arg_match_I__(_a_4) and __arg_match__3J__(_a_5))
  @staticmethod
  def _match_alt_argTransposeSort__3J_3JIII_3J(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match_I__(_a_2) and __arg_alt_match_I__(_a_3) and __arg_alt_match_I__(_a_4) and __arg_alt_match__3J__(_a_5))
  @staticmethod
  def _argTransposeSort_alt__3J_3JIII_3J(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.int32(_t__a_2)
   _a_3=numpy.int32(_t__a_3)
   _a_4=numpy.int32(_t__a_4)
   _a_5=numpy.array(_t__a_5,dtype=numpy.dtype(numpy.int64))
   _1_res = mosek_fusion_Sort._argTransposeSort__3J_3JIII_3J(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_5[:] = _a_5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argTransposeSort__3J_3JIII_3J(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5):
   fragments._c_closure_103(_a_2,_a_3,_a_4,_a_0,_a_1,_a_5) 
  @staticmethod
  def _match_argsort__3J_3J(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3J__(_a_1))
  @staticmethod
  def _match_alt_argsort__3J_3J(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3J__(_a_1))
  @staticmethod
  def _argsort_alt__3J_3J(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _1_res = mosek_fusion_Sort._argsort__3J_3J(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3J(_a_0,_a_1):
   mosek.fusion.Sort._argsort__3J_3JJJZ(_a_0,_a_1,0,int((_a_0).shape[0]),False)
  @staticmethod
  def _match_argsort__3J_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_argsort__3J_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3I__(_a_1))
  @staticmethod
  def _argsort_alt__3J_3I(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Sort._argsort__3J_3I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3I(_a_0,_a_1):
   mosek.fusion.Sort._argsort__3J_3IJJZ(_a_0,_a_1,0,int((_a_0).shape[0]),False)
  @staticmethod
  def _match_argsort__3J_3J_3J(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3J__(_a_1) and __arg_match__3J__(_a_2))
  @staticmethod
  def _match_alt_argsort__3J_3J_3J(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match__3J__(_a_2))
  @staticmethod
  def _argsort_alt__3J_3J_3J(_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int64))
   _1_res = mosek_fusion_Sort._argsort__3J_3J_3J(_a_0,_a_1,_a_2)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3J_3J(_a_0,_a_1,_a_2):
   mosek.fusion.Sort._argsort__3J_3J_3JJJZ(_a_0,_a_1,_a_2,0,int((_a_0).shape[0]),False)
  @staticmethod
  def _match_argsort__3J_3I_3I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3I__(_a_2))
  @staticmethod
  def _match_alt_argsort__3J_3I_3I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3I__(_a_2))
  @staticmethod
  def _argsort_alt__3J_3I_3I(_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Sort._argsort__3J_3I_3I(_a_0,_a_1,_a_2)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3I_3I(_a_0,_a_1,_a_2):
   mosek.fusion.Sort._argsort__3J_3I_3IJJZ(_a_0,_a_1,_a_2,0,int((_a_0).shape[0]),False)
  @staticmethod
  def _match_argsort__3J_3JJJ(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3J__(_a_1) and __arg_match_J__(_a_2) and __arg_match_J__(_a_3))
  @staticmethod
  def _match_alt_argsort__3J_3JJJ(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match_J__(_a_2) and __arg_alt_match_J__(_a_3))
  @staticmethod
  def _argsort_alt__3J_3JJJ(_t__a_0,_t__a_1,_t__a_2,_t__a_3):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.int64(_t__a_2)
   _a_3=numpy.int64(_t__a_3)
   _1_res = mosek_fusion_Sort._argsort__3J_3JJJ(_a_0,_a_1,_a_2,_a_3)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3JJJ(_a_0,_a_1,_a_2,_a_3):
   mosek.fusion.Sort._argsort__3J_3JJJZ(_a_0,_a_1,_a_2,_a_3,False)
  @staticmethod
  def _match_argsort__3J_3IJJ(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3I__(_a_1) and __arg_match_J__(_a_2) and __arg_match_J__(_a_3))
  @staticmethod
  def _match_alt_argsort__3J_3IJJ(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match_J__(_a_2) and __arg_alt_match_J__(_a_3))
  @staticmethod
  def _argsort_alt__3J_3IJJ(_t__a_0,_t__a_1,_t__a_2,_t__a_3):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.int64(_t__a_2)
   _a_3=numpy.int64(_t__a_3)
   _1_res = mosek_fusion_Sort._argsort__3J_3IJJ(_a_0,_a_1,_a_2,_a_3)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3IJJ(_a_0,_a_1,_a_2,_a_3):
   mosek.fusion.Sort._argsort__3J_3IJJZ(_a_0,_a_1,_a_2,_a_3,False)
  @staticmethod
  def _match_argsort__3J_3J_3JJJ(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3J__(_a_1) and __arg_match__3J__(_a_2) and __arg_match_J__(_a_3) and __arg_match_J__(_a_4))
  @staticmethod
  def _match_alt_argsort__3J_3J_3JJJ(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match__3J__(_a_2) and __arg_alt_match_J__(_a_3) and __arg_alt_match_J__(_a_4))
  @staticmethod
  def _argsort_alt__3J_3J_3JJJ(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int64))
   _a_3=numpy.int64(_t__a_3)
   _a_4=numpy.int64(_t__a_4)
   _1_res = mosek_fusion_Sort._argsort__3J_3J_3JJJ(_a_0,_a_1,_a_2,_a_3,_a_4)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3J_3JJJ(_a_0,_a_1,_a_2,_a_3,_a_4):
   mosek.fusion.Sort._argsort__3J_3J_3JJJZ(_a_0,_a_1,_a_2,_a_3,_a_4,False)
  @staticmethod
  def _match_argsort__3J_3I_3IJJ(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3I__(_a_2) and __arg_match_J__(_a_3) and __arg_match_J__(_a_4))
  @staticmethod
  def _match_alt_argsort__3J_3I_3IJJ(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3I__(_a_2) and __arg_alt_match_J__(_a_3) and __arg_alt_match_J__(_a_4))
  @staticmethod
  def _argsort_alt__3J_3I_3IJJ(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _a_3=numpy.int64(_t__a_3)
   _a_4=numpy.int64(_t__a_4)
   _1_res = mosek_fusion_Sort._argsort__3J_3I_3IJJ(_a_0,_a_1,_a_2,_a_3,_a_4)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3I_3IJJ(_a_0,_a_1,_a_2,_a_3,_a_4):
   mosek.fusion.Sort._argsort__3J_3I_3IJJZ(_a_0,_a_1,_a_2,_a_3,_a_4,False)
  @staticmethod
  def _match_argsort__3J_3JJJZ(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3J__(_a_1) and __arg_match_J__(_a_2) and __arg_match_J__(_a_3) and __arg_match_Z__(_a_4))
  @staticmethod
  def _match_alt_argsort__3J_3JJJZ(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match_J__(_a_2) and __arg_alt_match_J__(_a_3) and __arg_alt_match_Z__(_a_4))
  @staticmethod
  def _argsort_alt__3J_3JJJZ(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.int64(_t__a_2)
   _a_3=numpy.int64(_t__a_3)
   _a_4=_t__a_4
   _1_res = mosek_fusion_Sort._argsort__3J_3JJJZ(_a_0,_a_1,_a_2,_a_3,_a_4)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3JJJZ(_a_0,_a_1,_a_2,_a_3,_a_4):
   if ((not _a_4) or ((_a_3 - _a_2) < 16)):
    mosek.fusion.Utils.Tools._argsort__3J_3JJJ(_a_0,_a_1,_a_2,_a_3)
   elif (not mosek.fusion.Sort._issorted__3J_3JJJZ(_a_0,_a_1,_a_2,_a_3,_a_4)):
    _a_5=numpy.zeros((4,), dtype=numpy.dtype(numpy.int64))
    _a_6=2
    mosek.fusion.Sort._getminmax__3J_3J_3JJJ_3J(_a_0,_a_1,None,_a_2,_a_3,_a_5)
    if ((_a_5[1] - _a_5[0]) < (_a_6 * (_a_3 - _a_2))):
     mosek.fusion.Sort._argbucketsort__3J_3JJJJJ(_a_0,_a_1,_a_2,_a_3,_a_5[0],_a_5[1])
    else:
     mosek.fusion.Utils.Tools._argsort__3J_3JJJ(_a_0,_a_1,_a_2,_a_3)
  @staticmethod
  def _match_argsort__3J_3IJJZ(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3I__(_a_1) and __arg_match_J__(_a_2) and __arg_match_J__(_a_3) and __arg_match_Z__(_a_4))
  @staticmethod
  def _match_alt_argsort__3J_3IJJZ(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match_J__(_a_2) and __arg_alt_match_J__(_a_3) and __arg_alt_match_Z__(_a_4))
  @staticmethod
  def _argsort_alt__3J_3IJJZ(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.int64(_t__a_2)
   _a_3=numpy.int64(_t__a_3)
   _a_4=_t__a_4
   _1_res = mosek_fusion_Sort._argsort__3J_3IJJZ(_a_0,_a_1,_a_2,_a_3,_a_4)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3IJJZ(_a_0,_a_1,_a_2,_a_3,_a_4):
   if ((not _a_4) or ((_a_3 - _a_2) < 16)):
    mosek.fusion.Utils.Tools._argsort__3J_3IJJ(_a_0,_a_1,_a_2,_a_3)
   elif (not mosek.fusion.Sort._issorted__3J_3IJJZ(_a_0,_a_1,_a_2,_a_3,_a_4)):
    _a_5=numpy.zeros((4,), dtype=numpy.dtype(numpy.int32))
    _a_6=2
    mosek.fusion.Sort._getminmax__3J_3I_3IJJ_3I(_a_0,_a_1,None,_a_2,_a_3,_a_5)
    if ((_a_5[1] - _a_5[0]) < (_a_6 * (_a_3 - _a_2))):
     mosek.fusion.Sort._argbucketsort__3J_3IJJII(_a_0,_a_1,_a_2,_a_3,_a_5[0],_a_5[1])
    else:
     mosek.fusion.Utils.Tools._argsort__3J_3IJJ(_a_0,_a_1,_a_2,_a_3)
  @staticmethod
  def _match_argsort__3J_3J_3JJJZ(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3J__(_a_1) and __arg_match__3J__(_a_2) and __arg_match_J__(_a_3) and __arg_match_J__(_a_4) and __arg_match_Z__(_a_5))
  @staticmethod
  def _match_alt_argsort__3J_3J_3JJJZ(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match__3J__(_a_2) and __arg_alt_match_J__(_a_3) and __arg_alt_match_J__(_a_4) and __arg_alt_match_Z__(_a_5))
  @staticmethod
  def _argsort_alt__3J_3J_3JJJZ(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int64))
   _a_3=numpy.int64(_t__a_3)
   _a_4=numpy.int64(_t__a_4)
   _a_5=_t__a_5
   _1_res = mosek_fusion_Sort._argsort__3J_3J_3JJJZ(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3J_3JJJZ(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5):
   if ((not _a_5) or ((_a_4 - _a_3) < 16)):
    mosek.fusion.Utils.Tools._argsort__3J_3J_3JJJ(_a_0,_a_1,_a_2,_a_3,_a_4)
   elif (not mosek.fusion.Sort._issorted__3J_3J_3JJJZ(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5)):
    _a_6=numpy.zeros((4,), dtype=numpy.dtype(numpy.int64))
    _a_7=2
    mosek.fusion.Sort._getminmax__3J_3J_3JJJ_3J(_a_0,_a_1,_a_2,_a_3,_a_4,_a_6)
    if (((_a_6[1] - _a_6[0]) < (_a_7 * (_a_4 - _a_3))) and ((_a_6[3] - _a_6[2]) < (_a_7 * (_a_4 - _a_3)))):
     mosek.fusion.Sort._argbucketsort__3J_3JJJJJ(_a_0,_a_2,_a_3,_a_4,_a_6[2],_a_6[3])
     mosek.fusion.Sort._argbucketsort__3J_3JJJJJ(_a_0,_a_1,_a_3,_a_4,_a_6[0],_a_6[1])
    else:
     mosek.fusion.Utils.Tools._argsort__3J_3J_3JJJ(_a_0,_a_1,_a_2,_a_3,_a_4)
  @staticmethod
  def _match_argsort__3J_3I_3IJJZ(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3I__(_a_2) and __arg_match_J__(_a_3) and __arg_match_J__(_a_4) and __arg_match_Z__(_a_5))
  @staticmethod
  def _match_alt_argsort__3J_3I_3IJJZ(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3I__(_a_2) and __arg_alt_match_J__(_a_3) and __arg_alt_match_J__(_a_4) and __arg_alt_match_Z__(_a_5))
  @staticmethod
  def _argsort_alt__3J_3I_3IJJZ(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _a_3=numpy.int64(_t__a_3)
   _a_4=numpy.int64(_t__a_4)
   _a_5=_t__a_5
   _1_res = mosek_fusion_Sort._argsort__3J_3I_3IJJZ(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3I_3IJJZ(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5):
   if ((not _a_5) or ((_a_4 - _a_3) < 16)):
    mosek.fusion.Utils.Tools._argsort__3J_3I_3IJJ(_a_0,_a_1,_a_2,_a_3,_a_4)
   elif (not mosek.fusion.Sort._issorted__3J_3I_3IJJZ(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5)):
    _a_6=numpy.zeros((4,), dtype=numpy.dtype(numpy.int32))
    _a_7=2
    mosek.fusion.Sort._getminmax__3J_3I_3IJJ_3I(_a_0,_a_1,_a_2,_a_3,_a_4,_a_6)
    if (((_a_6[1] - _a_6[0]) < (_a_7 * (_a_4 - _a_3))) and ((_a_6[3] - _a_6[2]) < (_a_7 * (_a_4 - _a_3)))):
     mosek.fusion.Sort._argbucketsort__3J_3IJJII(_a_0,_a_2,_a_3,_a_4,_a_6[2],_a_6[3])
     mosek.fusion.Sort._argbucketsort__3J_3IJJII(_a_0,_a_1,_a_3,_a_4,_a_6[0],_a_6[1])
    else:
     mosek.fusion.Utils.Tools._argsort__3J_3I_3IJJ(_a_0,_a_1,_a_2,_a_3,_a_4)
  @staticmethod
  def _match_argbucketsort__3J_3JJJJJ(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3J__(_a_1) and __arg_match_J__(_a_2) and __arg_match_J__(_a_3) and __arg_match_J__(_a_4) and __arg_match_J__(_a_5))
  @staticmethod
  def _match_alt_argbucketsort__3J_3JJJJJ(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match_J__(_a_2) and __arg_alt_match_J__(_a_3) and __arg_alt_match_J__(_a_4) and __arg_alt_match_J__(_a_5))
  @staticmethod
  def _argbucketsort_alt__3J_3JJJJJ(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.int64(_t__a_2)
   _a_3=numpy.int64(_t__a_3)
   _a_4=numpy.int64(_t__a_4)
   _a_5=numpy.int64(_t__a_5)
   _1_res = mosek_fusion_Sort._argbucketsort__3J_3JJJJJ(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argbucketsort__3J_3JJJJJ(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5):
   mosek.fusion.Utils.Tools._bucketsort__3JJJ_3JJJ(_a_0,_a_2,_a_3,_a_1,_a_4,_a_5)
  @staticmethod
  def _match_argbucketsort__3J_3IJJII(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3I__(_a_1) and __arg_match_J__(_a_2) and __arg_match_J__(_a_3) and __arg_match_I__(_a_4) and __arg_match_I__(_a_5))
  @staticmethod
  def _match_alt_argbucketsort__3J_3IJJII(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match_J__(_a_2) and __arg_alt_match_J__(_a_3) and __arg_alt_match_I__(_a_4) and __arg_alt_match_I__(_a_5))
  @staticmethod
  def _argbucketsort_alt__3J_3IJJII(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.int64(_t__a_2)
   _a_3=numpy.int64(_t__a_3)
   _a_4=numpy.int32(_t__a_4)
   _a_5=numpy.int32(_t__a_5)
   _1_res = mosek_fusion_Sort._argbucketsort__3J_3IJJII(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argbucketsort__3J_3IJJII(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5):
   mosek.fusion.Utils.Tools._bucketsort__3JJJ_3III(_a_0,_a_2,_a_3,_a_1,_a_4,_a_5)
  @staticmethod
  def _match_getminmax__3J_3J_3JJJ_3J(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3J__(_a_1) and __arg_match__3J__(_a_2) and __arg_match_J__(_a_3) and __arg_match_J__(_a_4) and __arg_match__3J__(_a_5))
  @staticmethod
  def _match_alt_getminmax__3J_3J_3JJJ_3J(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match__3J__(_a_2) and __arg_alt_match_J__(_a_3) and __arg_alt_match_J__(_a_4) and __arg_alt_match__3J__(_a_5))
  @staticmethod
  def _getminmax_alt__3J_3J_3JJJ_3J(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int64))
   _a_3=numpy.int64(_t__a_3)
   _a_4=numpy.int64(_t__a_4)
   _a_5=numpy.array(_t__a_5,dtype=numpy.dtype(numpy.int64))
   _1_res = mosek_fusion_Sort._getminmax__3J_3J_3JJJ_3J(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_5[:] = _a_5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _getminmax__3J_3J_3JJJ_3J(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5):
   fragments._c_closure_104(_a_3,_a_0,_a_4,_a_5,_a_1,_a_2) 
  @staticmethod
  def _match_getminmax__3J_3I_3IJJ_3I(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3I__(_a_2) and __arg_match_J__(_a_3) and __arg_match_J__(_a_4) and __arg_match__3I__(_a_5))
  @staticmethod
  def _match_alt_getminmax__3J_3I_3IJJ_3I(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3I__(_a_2) and __arg_alt_match_J__(_a_3) and __arg_alt_match_J__(_a_4) and __arg_alt_match__3I__(_a_5))
  @staticmethod
  def _getminmax_alt__3J_3I_3IJJ_3I(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _a_3=numpy.int64(_t__a_3)
   _a_4=numpy.int64(_t__a_4)
   _a_5=numpy.array(_t__a_5,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Sort._getminmax__3J_3I_3IJJ_3I(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_5[:] = _a_5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _getminmax__3J_3I_3IJJ_3I(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5):
   fragments._c_closure_105(_a_3,_a_0,_a_4,_a_5,_a_1,_a_2) 
  @staticmethod
  def _match_issorted__3J_3JJJZ(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3J__(_a_1) and __arg_match_J__(_a_2) and __arg_match_J__(_a_3) and __arg_match_Z__(_a_4))
  @staticmethod
  def _match_alt_issorted__3J_3JJJZ(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match_J__(_a_2) and __arg_alt_match_J__(_a_3) and __arg_alt_match_Z__(_a_4))
  @staticmethod
  def _issorted_alt__3J_3JJJZ(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.int64(_t__a_2)
   _a_3=numpy.int64(_t__a_3)
   _a_4=_t__a_4
   _1_res = mosek_fusion_Sort._issorted__3J_3JJJZ(_a_0,_a_1,_a_2,_a_3,_a_4)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _issorted__3J_3JJJZ(_a_0,_a_1,_a_2,_a_3,_a_4):
   for _a_5 in range(_a_2,(_a_3 - 1)):
    if (_a_1[_a_0[_a_5]] > _a_1[_a_0[(_a_5 + 1)]]):
     return (False)
   return (True)
  @staticmethod
  def _match_issorted__3J_3IJJZ(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3I__(_a_1) and __arg_match_J__(_a_2) and __arg_match_J__(_a_3) and __arg_match_Z__(_a_4))
  @staticmethod
  def _match_alt_issorted__3J_3IJJZ(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match_J__(_a_2) and __arg_alt_match_J__(_a_3) and __arg_alt_match_Z__(_a_4))
  @staticmethod
  def _issorted_alt__3J_3IJJZ(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.int64(_t__a_2)
   _a_3=numpy.int64(_t__a_3)
   _a_4=_t__a_4
   _1_res = mosek_fusion_Sort._issorted__3J_3IJJZ(_a_0,_a_1,_a_2,_a_3,_a_4)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _issorted__3J_3IJJZ(_a_0,_a_1,_a_2,_a_3,_a_4):
   for _a_5 in range(_a_2,(_a_3 - 1)):
    if (_a_1[_a_0[_a_5]] > _a_1[_a_0[(_a_5 + 1)]]):
     return (False)
   return (True)
  @staticmethod
  def _match_issorted__3J_3J_3JJJZ(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3J__(_a_1) and __arg_match__3J__(_a_2) and __arg_match_J__(_a_3) and __arg_match_J__(_a_4) and __arg_match_Z__(_a_5))
  @staticmethod
  def _match_alt_issorted__3J_3J_3JJJZ(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match__3J__(_a_2) and __arg_alt_match_J__(_a_3) and __arg_alt_match_J__(_a_4) and __arg_alt_match_Z__(_a_5))
  @staticmethod
  def _issorted_alt__3J_3J_3JJJZ(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int64))
   _a_3=numpy.int64(_t__a_3)
   _a_4=numpy.int64(_t__a_4)
   _a_5=_t__a_5
   _1_res = mosek_fusion_Sort._issorted__3J_3J_3JJJZ(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _issorted__3J_3J_3JJJZ(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5):
   for _a_6 in range(_a_3,(_a_4 - 1)):
    if ((_a_1[_a_0[_a_6]] > _a_1[_a_0[(_a_6 + 1)]]) or ((_a_1[_a_0[(_a_6 + 1)]]==_a_1[_a_0[_a_6]]) and (_a_2[_a_0[_a_6]] > _a_2[_a_0[(_a_6 + 1)]]))):
     return (False)
   return (True)
  @staticmethod
  def _match_issorted__3J_3I_3IJJZ(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3I__(_a_2) and __arg_match_J__(_a_3) and __arg_match_J__(_a_4) and __arg_match_Z__(_a_5))
  @staticmethod
  def _match_alt_issorted__3J_3I_3IJJZ(*args):
    if len(args) != 6: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3I__(_a_2) and __arg_alt_match_J__(_a_3) and __arg_alt_match_J__(_a_4) and __arg_alt_match_Z__(_a_5))
  @staticmethod
  def _issorted_alt__3J_3I_3IJJZ(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _a_3=numpy.int64(_t__a_3)
   _a_4=numpy.int64(_t__a_4)
   _a_5=_t__a_5
   _1_res = mosek_fusion_Sort._issorted__3J_3I_3IJJZ(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _issorted__3J_3I_3IJJZ(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5):
   for _a_6 in range(_a_3,(_a_4 - 1)):
    if ((_a_1[_a_0[_a_6]] > _a_1[_a_0[(_a_6 + 1)]]) or ((_a_1[_a_0[_a_6]]==_a_1[_a_0[(_a_6 + 1)]]) and (_a_2[_a_0[_a_6]] > _a_2[_a_0[(_a_6 + 1)]]))):
     return (False)
   return (True)
 return Sort
mosek_fusion_Sort=__mk_mosek_fusion_Sort()
del __mk_mosek_fusion_Sort
#BEFORE CLASS
def __mk_mosek_fusion_IndexCounter():
 class IndexCounter(object):
  __slots__ = ['_IndexCounter__start','_IndexCounter__dims','_IndexCounter__strides','_IndexCounter__st','_IndexCounter__ii','_IndexCounter__n']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor__3I(*args):
      self._ctor_init__3I(*args)
    elif self.__match_alt_ctor__3I(*args):
      self._ctor_alt_init__3I(*args)
    elif self.__match_ctor_J_3I_3I(*args):
      self._ctor_init_J_3I_3I(*args)
    elif self.__match_alt_ctor_J_3I_3I(*args):
      self._ctor_alt_init_J_3I_3I(*args)
    elif self.__match_ctor_J_3I_3J(*args):
      self._ctor_init_J_3I_3J(*args)
    elif self.__match_alt_ctor_J_3I_3J(*args):
      self._ctor_alt_init_J_3I_3J(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.IndexCounter.ctor(array(int32,ndim=1))\n\tmosek.fusion.IndexCounter.ctor(int64,array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.IndexCounter.ctor(int64,array(int32,ndim=1),array(int64,ndim=1))')
  def atEnd(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.IndexCounter.atEnd()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_IndexCounter._match_atEnd_(*args):
      return self._atEnd_(*args)
    elif mosek_fusion_IndexCounter._match_alt_atEnd_(*args):
      return self._atEnd_alt_(*args)
    else:
      raise ValueError('Invalid argument list atEnd('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.atEnd()')
  def getIndex(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.IndexCounter.getIndex()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_IndexCounter._match_getIndex_(*args):
      return self._getIndex_(*args)
    elif mosek_fusion_IndexCounter._match_alt_getIndex_(*args):
      return self._getIndex_alt_(*args)
    else:
      raise ValueError('Invalid argument list getIndex('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.getIndex()')
  def inc(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.IndexCounter.inc()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_IndexCounter._match_inc_(*args):
      return self._inc_(*args)
    elif mosek_fusion_IndexCounter._match_alt_inc_(*args):
      return self._inc_alt_(*args)
    else:
      raise ValueError('Invalid argument list inc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.inc()')
  def get(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.IndexCounter.get()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_IndexCounter._match_get_(*args):
      return self._get_(*args)
    elif mosek_fusion_IndexCounter._match_alt_get_(*args):
      return self._get_alt_(*args)
    else:
      raise ValueError('Invalid argument list get('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.get()')
  def reset(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.IndexCounter.reset()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_IndexCounter._match_reset_(*args):
      return self._reset_(*args)
    elif mosek_fusion_IndexCounter._match_alt_reset_(*args):
      return self._reset_alt_(*args)
    else:
      raise ValueError('Invalid argument list reset('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.reset()')
  def next(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.IndexCounter.next()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_IndexCounter._match_next_(*args):
      return self._next_(*args)
    elif mosek_fusion_IndexCounter._match_alt_next_(*args):
      return self._next_alt_(*args)
    else:
      raise ValueError('Invalid argument list next('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.next()')
  def __repr__(self): return 'mosek.fusion.IndexCounter'
  @staticmethod
  def _ctor__3I(shape):
    o = IndexCounter.__new__(IndexCounter)
    o._ctor_init__3I(shape)
    return o
  @staticmethod
  def __match_ctor__3I(*args):
    if len(args) != 1: return False
    shape, = args
    return (__arg_match__3I__(shape))
  @staticmethod
  def __match_alt_ctor__3I(*args):
    if len(args) != 1: return False
    shape, = args
    return (__arg_alt_match__3I__(shape))
  def _ctor_alt_init__3I(self,shape):
    self._ctor_init__3I(numpy.array(shape,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init__3I(self,shape):
   self.__n = int((shape).shape[0])
   self.__ii = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int32))
   self.__st = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int64))
   self.__start = 0
   self.__strides = mosek.fusion.Set._strides__3I(shape)
   self.__dims = numpy.array([shape[_a_0] for _a_0 in range(0,int((shape).shape[0]))], dtype=numpy.dtype(numpy.int32))
  @staticmethod
  def _ctor_J_3I_3I(start_,dims_,shape):
    o = IndexCounter.__new__(IndexCounter)
    o._ctor_init_J_3I_3I(start_,dims_,shape)
    return o
  @staticmethod
  def __match_ctor_J_3I_3I(*args):
    if len(args) != 3: return False
    start_,dims_,shape, = args
    return (__arg_match_J__(start_) and __arg_match__3I__(dims_) and __arg_match__3I__(shape))
  @staticmethod
  def __match_alt_ctor_J_3I_3I(*args):
    if len(args) != 3: return False
    start_,dims_,shape, = args
    return (__arg_alt_match_J__(start_) and __arg_alt_match__3I__(dims_) and __arg_alt_match__3I__(shape))
  def _ctor_alt_init_J_3I_3I(self,start_,dims_,shape):
    self._ctor_init_J_3I_3I(numpy.int64(start_),numpy.array(dims_,dtype=numpy.dtype(numpy.int32)),numpy.array(shape,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_J_3I_3I(self,start_,dims_,shape):
   _a_0=int((shape).shape[0])
   self.__n = int((dims_).shape[0])
   self.__ii = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int32))
   self.__st = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_106(self.__n,self.__st,start_) 
   self.__strides = mosek.fusion.Set._strides__3I(shape)
   self.__dims = dims_
   self.__start = start_
  @staticmethod
  def _ctor_J_3I_3J(start_,dims_,strides_):
    o = IndexCounter.__new__(IndexCounter)
    o._ctor_init_J_3I_3J(start_,dims_,strides_)
    return o
  @staticmethod
  def __match_ctor_J_3I_3J(*args):
    if len(args) != 3: return False
    start_,dims_,strides_, = args
    return (__arg_match_J__(start_) and __arg_match__3I__(dims_) and __arg_match__3J__(strides_))
  @staticmethod
  def __match_alt_ctor_J_3I_3J(*args):
    if len(args) != 3: return False
    start_,dims_,strides_, = args
    return (__arg_alt_match_J__(start_) and __arg_alt_match__3I__(dims_) and __arg_alt_match__3J__(strides_))
  def _ctor_alt_init_J_3I_3J(self,start_,dims_,strides_):
    self._ctor_init_J_3I_3J(numpy.int64(start_),numpy.array(dims_,dtype=numpy.dtype(numpy.int32)),numpy.array(strides_,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_J_3I_3J(self,start_,dims_,strides_):
   self.__n = int((dims_).shape[0])
   self.__ii = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int32))
   self.__st = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_107(self.__n,self.__st,start_) 
   self.__strides = strides_
   self.__dims = dims_
   self.__start = start_
  @staticmethod
  def _match_atEnd_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_atEnd_(*args):
    if len(args) != 0: return False
    return True
  def _atEnd_alt_(self,):
    return self._atEnd_()
  def _atEnd_(self,):
   return ((self.__ii[(self.__n - 1)] >= self.__dims[(self.__n - 1)]))
  @staticmethod
  def _match_getIndex_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getIndex_(*args):
    if len(args) != 0: return False
    return True
  def _getIndex_alt_(self,):
    return self._getIndex_()
  def _getIndex_(self,):
   return (self.__ii)
  @staticmethod
  def _match_next_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_next_(*args):
    if len(args) != 0: return False
    return True
  def _next_alt_(self,):
    return self._next_()
  def _next_(self,):
   _a_0=self._get_()
   self._inc_()
   return numpy.int64(_a_0)
  @staticmethod
  def _match_get_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_get_(*args):
    if len(args) != 0: return False
    return True
  def _get_alt_(self,):
    return self._get_()
  def _get_(self,):
   return numpy.int64(self.__st[0])
  @staticmethod
  def _match_inc_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_inc_(*args):
    if len(args) != 0: return False
    return True
  def _inc_alt_(self,):
    return self._inc_()
  def _inc_(self,):
   fragments._c_closure_108(self.__dims,self.__ii,self.__n,self.__st,self.__strides) 
  @staticmethod
  def _match_reset_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_reset_(*args):
    if len(args) != 0: return False
    return True
  def _reset_alt_(self,):
    return self._reset_()
  def _reset_(self,):
   self.__st = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_109(self.__n,self.__st,self.__start) 
 return IndexCounter
mosek_fusion_IndexCounter=__mk_mosek_fusion_IndexCounter()
del __mk_mosek_fusion_IndexCounter
#BEFORE CLASS
def __mk_mosek_fusion_CommonTools():
 class CommonTools(object):
  @staticmethod
  def tripletSort(*args):
    '''
    Syntax
    ------

      mosek.fusion.CommonTools.tripletSort(array(int32,ndim=1),array(int32,ndim=1),array(double,ndim=1),array(array(int32,ndim=1),ndim=1),array(array(int32,ndim=1),ndim=1),array(array(double,ndim=1),ndim=1),int64,int32,int32)

    Description
    -----------

    Sort with two indexes by transposing data twice.

    Parameters
    ----------

    dimi : int32
    dimj : int32
    nelm : int64
    subi : array(int32,ndim=1)
    subj : array(int32,ndim=1)
    tsubi_ : array(array(int32,ndim=1),ndim=1)
    tsubj_ : array(array(int32,ndim=1),ndim=1)
    tval_ : array(array(double,ndim=1),ndim=1)
    val : array(double,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_CommonTools._match_tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
      return mosek_fusion_CommonTools._tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(*args)
    elif mosek_fusion_CommonTools._match_alt_tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
      return mosek_fusion_CommonTools._tripletSort_alt__3I_3I_3D_3_3I_3_3I_3_3DJII(*args)
    else:
      raise ValueError('Invalid argument list tripletSort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.tripletSort(array(int32,ndim=1),array(int32,ndim=1),array(double,ndim=1),array(array(int32,ndim=1),ndim=1),array(array(int32,ndim=1),ndim=1),array(array(double,ndim=1),ndim=1),int64,int32,int32)')
  @staticmethod
  def binarySearchL(*args):
    '''
    Syntax
    ------

      mosek.fusion.CommonTools.binarySearchL(array(int64,ndim=1),int64)

    Description
    -----------

    

    Parameters
    ----------

    target : int64
    values : array(int64,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_CommonTools._match_binarySearchL__3JJ(*args):
      return mosek_fusion_CommonTools._binarySearchL__3JJ(*args)
    elif mosek_fusion_CommonTools._match_alt_binarySearchL__3JJ(*args):
      return mosek_fusion_CommonTools._binarySearchL_alt__3JJ(*args)
    else:
      raise ValueError('Invalid argument list binarySearchL('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.binarySearchL(array(int64,ndim=1),int64)')
  @staticmethod
  def binarySearchR(*args):
    '''
    Syntax
    ------

      mosek.fusion.CommonTools.binarySearchR(array(int64,ndim=1),int64)

    Description
    -----------

    

    Parameters
    ----------

    target : int64
    values : array(int64,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_CommonTools._match_binarySearchR__3JJ(*args):
      return mosek_fusion_CommonTools._binarySearchR__3JJ(*args)
    elif mosek_fusion_CommonTools._match_alt_binarySearchR__3JJ(*args):
      return mosek_fusion_CommonTools._binarySearchR_alt__3JJ(*args)
    else:
      raise ValueError('Invalid argument list binarySearchR('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.binarySearchR(array(int64,ndim=1),int64)')
  @staticmethod
  def argMSort(*args):
    '''
    Syntax
    ------

      mosek.fusion.CommonTools.argMSort(array(int32,ndim=1),array(int32,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    idx : array(int32,ndim=1)
    vals : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_CommonTools._match_argMSort__3I_3I(*args):
      return mosek_fusion_CommonTools._argMSort__3I_3I(*args)
    elif mosek_fusion_CommonTools._match_alt_argMSort__3I_3I(*args):
      return mosek_fusion_CommonTools._argMSort_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list argMSort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.argMSort(array(int32,ndim=1),array(int32,ndim=1))')
  @staticmethod
  def ndIncr(*args):
    '''
    Syntax
    ------

      mosek.fusion.CommonTools.ndIncr(array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    first : array(int32,ndim=1)
    last : array(int32,ndim=1)
    ndidx : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_CommonTools._match_ndIncr__3I_3I_3I(*args):
      return mosek_fusion_CommonTools._ndIncr__3I_3I_3I(*args)
    elif mosek_fusion_CommonTools._match_alt_ndIncr__3I_3I_3I(*args):
      return mosek_fusion_CommonTools._ndIncr_alt__3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list ndIncr('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.ndIncr(array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  @staticmethod
  def argQsort(*args):
    '''
    Syntax
    ------

      mosek.fusion.CommonTools.argQsort(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64)
      mosek.fusion.CommonTools.argQsort(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64)

    Description
    -----------

    

    Parameters
    ----------

    first : int64
    idx : array(int64,ndim=1)
    last : int64
    vals1 : array(int64,ndim=1)
    vals2 : array(int64,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_CommonTools._match_argQsort__3J_3I_3IJJ(*args):
      return mosek_fusion_CommonTools._argQsort__3J_3I_3IJJ(*args)
    elif mosek_fusion_CommonTools._match_alt_argQsort__3J_3I_3IJJ(*args):
      return mosek_fusion_CommonTools._argQsort_alt__3J_3I_3IJJ(*args)
    elif mosek_fusion_CommonTools._match_argQsort__3J_3J_3JJJ(*args):
      return mosek_fusion_CommonTools._argQsort__3J_3J_3JJJ(*args)
    elif mosek_fusion_CommonTools._match_alt_argQsort__3J_3J_3JJJ(*args):
      return mosek_fusion_CommonTools._argQsort_alt__3J_3J_3JJJ(*args)
    else:
      raise ValueError('Invalid argument list argQsort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.argQsort(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64)\n\tmosek.fusion.CommonTools.argQsort(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64)')
  @staticmethod
  def binarySearch(*args):
    '''
    Syntax
    ------

      mosek.fusion.CommonTools.binarySearch(array(int64,ndim=1),int64)
      mosek.fusion.CommonTools.binarySearch(array(int32,ndim=1),int32)

    Description
    -----------

    

    Parameters
    ----------

    target : int32
    values : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_CommonTools._match_binarySearch__3JJ(*args):
      return mosek_fusion_CommonTools._binarySearch__3JJ(*args)
    elif mosek_fusion_CommonTools._match_alt_binarySearch__3JJ(*args):
      return mosek_fusion_CommonTools._binarySearch_alt__3JJ(*args)
    elif mosek_fusion_CommonTools._match_binarySearch__3II(*args):
      return mosek_fusion_CommonTools._binarySearch__3II(*args)
    elif mosek_fusion_CommonTools._match_alt_binarySearch__3II(*args):
      return mosek_fusion_CommonTools._binarySearch_alt__3II(*args)
    else:
      raise ValueError('Invalid argument list binarySearch('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.binarySearch(array(int64,ndim=1),int64)\n\tmosek.fusion.CommonTools.binarySearch(array(int32,ndim=1),int32)')
  @staticmethod
  def transposeTriplets(*args):
    '''
    Syntax
    ------

      mosek.fusion.CommonTools.transposeTriplets(array(int32,ndim=1),array(int32,ndim=1),array(double,ndim=1),array(array(int32,ndim=1),ndim=1),array(array(int32,ndim=1),ndim=1),array(array(double,ndim=1),ndim=1),int64,int32,int32)
      mosek.fusion.CommonTools.transposeTriplets(array(int32,ndim=1),array(int32,ndim=1),array(double,ndim=1),array(array(int64,ndim=1),ndim=1),array(array(int64,ndim=1),ndim=1),array(array(double,ndim=1),ndim=1),int64,int32,int32)

    Description
    -----------

    Matrix transpose similar to tripletSort.

    Parameters
    ----------

    dimi : int32
    dimj : int32
    nelm : int64
    subi : array(int32,ndim=1)
    subj : array(int32,ndim=1)
    tsubi_ : array(array(int64,ndim=1),ndim=1)
    tsubj_ : array(array(int64,ndim=1),ndim=1)
    tval_ : array(array(double,ndim=1),ndim=1)
    val : array(double,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_CommonTools._match_transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
      return mosek_fusion_CommonTools._transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(*args)
    elif mosek_fusion_CommonTools._match_alt_transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
      return mosek_fusion_CommonTools._transposeTriplets_alt__3I_3I_3D_3_3I_3_3I_3_3DJII(*args)
    elif mosek_fusion_CommonTools._match_transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(*args):
      return mosek_fusion_CommonTools._transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(*args)
    elif mosek_fusion_CommonTools._match_alt_transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(*args):
      return mosek_fusion_CommonTools._transposeTriplets_alt__3I_3I_3D_3_3J_3_3J_3_3DJII(*args)
    else:
      raise ValueError('Invalid argument list transposeTriplets('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.transposeTriplets(array(int32,ndim=1),array(int32,ndim=1),array(double,ndim=1),array(array(int32,ndim=1),ndim=1),array(array(int32,ndim=1),ndim=1),array(array(double,ndim=1),ndim=1),int64,int32,int32)\n\tmosek.fusion.CommonTools.transposeTriplets(array(int32,ndim=1),array(int32,ndim=1),array(double,ndim=1),array(array(int64,ndim=1),ndim=1),array(array(int64,ndim=1),ndim=1),array(array(double,ndim=1),ndim=1),int64,int32,int32)')
  @staticmethod
  def resize(*args):
    '''
    Syntax
    ------

      mosek.fusion.CommonTools.resize(array(double,ndim=1),int32)
      mosek.fusion.CommonTools.resize(array(int32,ndim=1),int32)
      mosek.fusion.CommonTools.resize(array(int64,ndim=1),int32)

    Description
    -----------

    

    Parameters
    ----------

    newsize : int32
    values : array(int64,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_CommonTools._match_resize__3DI(*args):
      return mosek_fusion_CommonTools._resize__3DI(*args)
    elif mosek_fusion_CommonTools._match_alt_resize__3DI(*args):
      return mosek_fusion_CommonTools._resize_alt__3DI(*args)
    elif mosek_fusion_CommonTools._match_resize__3II(*args):
      return mosek_fusion_CommonTools._resize__3II(*args)
    elif mosek_fusion_CommonTools._match_alt_resize__3II(*args):
      return mosek_fusion_CommonTools._resize_alt__3II(*args)
    elif mosek_fusion_CommonTools._match_resize__3JI(*args):
      return mosek_fusion_CommonTools._resize__3JI(*args)
    elif mosek_fusion_CommonTools._match_alt_resize__3JI(*args):
      return mosek_fusion_CommonTools._resize_alt__3JI(*args)
    else:
      raise ValueError('Invalid argument list resize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.resize(array(double,ndim=1),int32)\n\tmosek.fusion.CommonTools.resize(array(int32,ndim=1),int32)\n\tmosek.fusion.CommonTools.resize(array(int64,ndim=1),int32)')
  def __repr__(self): return 'mosek.fusion.CommonTools'
  @staticmethod
  def _match_resize__3JI(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3J__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_resize__3JI(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match_I__(_a_1))
  @staticmethod
  def _resize_alt__3JI(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.int32(_t__a_1)
   _1_res = mosek_fusion_CommonTools._resize__3JI(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _resize__3JI(_a_0,_a_1):
   if (_a_1==int((_a_0).shape[0])):
    return (_a_0)
   else:
    _a_2=numpy.zeros((_a_1,), dtype=numpy.dtype(numpy.int64))
    if (_a_1 > int((_a_0).shape[0])):
     mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(_a_0,0,_a_2,0,int((_a_0).shape[0]))
    else:
     mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(_a_0,0,_a_2,0,_a_1)
    return (_a_2)
  @staticmethod
  def _match_resize__3II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_resize__3II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match_I__(_a_1))
  @staticmethod
  def _resize_alt__3II(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.int32(_t__a_1)
   _1_res = mosek_fusion_CommonTools._resize__3II(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _resize__3II(_a_0,_a_1):
   if (_a_1==int((_a_0).shape[0])):
    return (_a_0)
   else:
    _a_2=numpy.zeros((_a_1,), dtype=numpy.dtype(numpy.int32))
    if (_a_1 > int((_a_0).shape[0])):
     mosek.fusion.Utils.Tools._arraycopy__3II_3III(_a_0,0,_a_2,0,int((_a_0).shape[0]))
    else:
     mosek.fusion.Utils.Tools._arraycopy__3II_3III(_a_0,0,_a_2,0,_a_1)
    return (_a_2)
  @staticmethod
  def _match_resize__3DI(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3D__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_resize__3DI(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3D__(_a_0) and __arg_alt_match_I__(_a_1))
  @staticmethod
  def _resize_alt__3DI(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.float64))
   _a_1=numpy.int32(_t__a_1)
   _1_res = mosek_fusion_CommonTools._resize__3DI(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _resize__3DI(_a_0,_a_1):
   if (_a_1==int((_a_0).shape[0])):
    return (_a_0)
   else:
    _a_2=numpy.zeros((_a_1,), dtype=numpy.dtype(numpy.float64))
    if (_a_1 > int((_a_0).shape[0])):
     mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_a_0,0,_a_2,0,int((_a_0).shape[0]))
    else:
     mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_a_0,0,_a_2,0,_a_1)
    return (_a_2)
  @staticmethod
  def _match_binarySearch__3II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_binarySearch__3II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match_I__(_a_1))
  @staticmethod
  def _binarySearch_alt__3II(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.int32(_t__a_1)
   _1_res = mosek_fusion_CommonTools._binarySearch__3II(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _binarySearch__3II(_a_0,_a_1):
   _a_2=0
   _a_3=int((_a_0).shape[0])
   if (_a_0[_a_2]==_a_1):
    return numpy.int32(_a_2)
   elif (_a_0[(_a_3 - 1)]==_a_1):
    return numpy.int32((_a_3 - 1))
   while (_a_2 < (_a_3 - 1)):
    _a_4=((_a_3 - _a_2) // 2)
    if (_a_1 < _a_0[_a_4]):
     _a_2 = (_a_4 + 1)
    elif (_a_1 > _a_0[_a_4]):
     _a_3 = _a_4
    else:
     return numpy.int32(_a_4)
   return numpy.int32((- 1))
  @staticmethod
  def _match_binarySearch__3JJ(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3J__(_a_0) and __arg_match_J__(_a_1))
  @staticmethod
  def _match_alt_binarySearch__3JJ(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match_J__(_a_1))
  @staticmethod
  def _binarySearch_alt__3JJ(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.int64(_t__a_1)
   _1_res = mosek_fusion_CommonTools._binarySearch__3JJ(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _binarySearch__3JJ(_a_0,_a_1):
   _a_2=mosek.fusion.CommonTools._binarySearchL__3JJ(_a_0,_a_1)
   if ((_a_2 < int((_a_0).shape[0])) and (_a_0[_a_2]==_a_1)):
    return numpy.int32(_a_2)
   else:
    return numpy.int32((- 1))
  @staticmethod
  def _match_binarySearchR__3JJ(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3J__(_a_0) and __arg_match_J__(_a_1))
  @staticmethod
  def _match_alt_binarySearchR__3JJ(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match_J__(_a_1))
  @staticmethod
  def _binarySearchR_alt__3JJ(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.int64(_t__a_1)
   _1_res = mosek_fusion_CommonTools._binarySearchR__3JJ(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _binarySearchR__3JJ(_a_0,_a_1):
   _a_2=0
   _a_3=int((_a_0).shape[0])
   if (_a_0[_a_2] > _a_1):
    return numpy.int32(_a_2)
   _a_2,_a_3 = fragments._c_closure_110(_a_2,_a_3,_a_1,_a_0)
   _a_2 = numpy.int32(_a_2) # postprocess
   _a_3 = numpy.int32(_a_3) # postprocess
   return numpy.int32(_a_3)
  @staticmethod
  def _match_binarySearchL__3JJ(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3J__(_a_0) and __arg_match_J__(_a_1))
  @staticmethod
  def _match_alt_binarySearchL__3JJ(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match_J__(_a_1))
  @staticmethod
  def _binarySearchL_alt__3JJ(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.int64(_t__a_1)
   _1_res = mosek_fusion_CommonTools._binarySearchL__3JJ(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _binarySearchL__3JJ(_a_0,_a_1):
   _a_2=0
   _a_3=int((_a_0).shape[0])
   if (_a_1 <= _a_0[_a_2]):
    return numpy.int32(_a_2)
   _a_2,_a_3 = fragments._c_closure_111(_a_2,_a_3,_a_1,_a_0)
   _a_2 = numpy.int32(_a_2) # postprocess
   _a_3 = numpy.int32(_a_3) # postprocess
   return numpy.int32(_a_3)
  @staticmethod
  def _match_ndIncr__3I_3I_3I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3I__(_a_2))
  @staticmethod
  def _match_alt_ndIncr__3I_3I_3I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3I__(_a_2))
  @staticmethod
  def _ndIncr_alt__3I_3I_3I(_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_CommonTools._ndIncr__3I_3I_3I(_a_0,_a_1,_a_2)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _ndIncr__3I_3I_3I(_a_0,_a_1,_a_2):
   fragments._c_closure_112(_a_1,_a_2,_a_0) 
  @staticmethod
  def _match_transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(*args):
    if len(args) != 9: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7,_a_8, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3D__(_a_2) and __arg_match__3_3J__(_a_3) and __arg_match__3_3J__(_a_4) and __arg_match__3_3D__(_a_5) and __arg_match_J__(_a_6) and __arg_match_I__(_a_7) and __arg_match_I__(_a_8))
  @staticmethod
  def _match_alt_transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(*args):
    if len(args) != 9: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7,_a_8, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3D__(_a_2) and __arg_alt_match__3_3J__(_a_3) and __arg_alt_match__3_3J__(_a_4) and __arg_alt_match__3_3D__(_a_5) and __arg_alt_match_J__(_a_6) and __arg_alt_match_I__(_a_7) and __arg_alt_match_I__(_a_8))
  @staticmethod
  def _transposeTriplets_alt__3I_3I_3D_3_3J_3_3J_3_3DJII(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5,_t__a_6,_t__a_7,_t__a_8):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.float64))
   _a_3=_monty.makeJaggedArray(_t__a_3,(1,1),numpy.dtype(numpy.int64))
   _a_4=_monty.makeJaggedArray(_t__a_4,(1,1),numpy.dtype(numpy.int64))
   _a_5=_monty.makeJaggedArray(_t__a_5,(1,1),numpy.dtype(numpy.float64))
   _a_6=numpy.int64(_t__a_6)
   _a_7=numpy.int32(_t__a_7)
   _a_8=numpy.int32(_t__a_8)
   _1_res = mosek_fusion_CommonTools._transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7,_a_8)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_3[:] = _a_3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_4[:] = _a_4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_5[:] = _a_5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7,_a_8):
   _a_9=numpy.zeros(((_a_7 + 2),), dtype=numpy.dtype(numpy.int64))
   _a_10=numpy.zeros(((_a_8 + 2),), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_113(_a_10,_a_6,_a_9,_a_0,_a_1) 
   fragments._c_closure_114(_a_7,_a_9) 
   fragments._c_closure_115(_a_10,_a_8) 
   _a_11=numpy.zeros((_a_6,), dtype=numpy.dtype(numpy.int64))
   _a_12=numpy.zeros((_a_6,), dtype=numpy.dtype(numpy.int64))
   _a_13=numpy.zeros((_a_6,), dtype=numpy.dtype(numpy.float64))
   fragments._c_closure_116(_a_10,_a_7,_a_9,_a_1,_a_11,_a_12,_a_13,_a_2) 
   _a_3[0] = _a_12
   _a_4[0] = _a_11
   _a_5[0] = _a_13
  @staticmethod
  def _match_transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
    if len(args) != 9: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7,_a_8, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3D__(_a_2) and __arg_match__3_3I__(_a_3) and __arg_match__3_3I__(_a_4) and __arg_match__3_3D__(_a_5) and __arg_match_J__(_a_6) and __arg_match_I__(_a_7) and __arg_match_I__(_a_8))
  @staticmethod
  def _match_alt_transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
    if len(args) != 9: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7,_a_8, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3D__(_a_2) and __arg_alt_match__3_3I__(_a_3) and __arg_alt_match__3_3I__(_a_4) and __arg_alt_match__3_3D__(_a_5) and __arg_alt_match_J__(_a_6) and __arg_alt_match_I__(_a_7) and __arg_alt_match_I__(_a_8))
  @staticmethod
  def _transposeTriplets_alt__3I_3I_3D_3_3I_3_3I_3_3DJII(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5,_t__a_6,_t__a_7,_t__a_8):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.float64))
   _a_3=_monty.makeJaggedArray(_t__a_3,(1,1),numpy.dtype(numpy.int32))
   _a_4=_monty.makeJaggedArray(_t__a_4,(1,1),numpy.dtype(numpy.int32))
   _a_5=_monty.makeJaggedArray(_t__a_5,(1,1),numpy.dtype(numpy.float64))
   _a_6=numpy.int64(_t__a_6)
   _a_7=numpy.int32(_t__a_7)
   _a_8=numpy.int32(_t__a_8)
   _1_res = mosek_fusion_CommonTools._transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7,_a_8)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_3[:] = _a_3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_4[:] = _a_4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_5[:] = _a_5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7,_a_8):
   _a_9=numpy.zeros(((_a_7 + 2),), dtype=numpy.dtype(numpy.int64))
   _a_10=numpy.zeros(((_a_8 + 2),), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_117(_a_10,_a_6,_a_9,_a_0,_a_1) 
   fragments._c_closure_118(_a_7,_a_9) 
   fragments._c_closure_119(_a_10,_a_8) 
   _a_11=numpy.zeros((_a_6,), dtype=numpy.dtype(numpy.int32))
   _a_12=numpy.zeros((_a_6,), dtype=numpy.dtype(numpy.int32))
   _a_13=numpy.zeros((_a_6,), dtype=numpy.dtype(numpy.float64))
   fragments._c_closure_120(_a_10,_a_7,_a_9,_a_1,_a_11,_a_12,_a_13,_a_2) 
   _a_3[0] = _a_12
   _a_4[0] = _a_11
   _a_5[0] = _a_13
  @staticmethod
  def _match_tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
    if len(args) != 9: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7,_a_8, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3D__(_a_2) and __arg_match__3_3I__(_a_3) and __arg_match__3_3I__(_a_4) and __arg_match__3_3D__(_a_5) and __arg_match_J__(_a_6) and __arg_match_I__(_a_7) and __arg_match_I__(_a_8))
  @staticmethod
  def _match_alt_tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
    if len(args) != 9: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7,_a_8, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3D__(_a_2) and __arg_alt_match__3_3I__(_a_3) and __arg_alt_match__3_3I__(_a_4) and __arg_alt_match__3_3D__(_a_5) and __arg_alt_match_J__(_a_6) and __arg_alt_match_I__(_a_7) and __arg_alt_match_I__(_a_8))
  @staticmethod
  def _tripletSort_alt__3I_3I_3D_3_3I_3_3I_3_3DJII(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5,_t__a_6,_t__a_7,_t__a_8):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.float64))
   _a_3=_monty.makeJaggedArray(_t__a_3,(1,1),numpy.dtype(numpy.int32))
   _a_4=_monty.makeJaggedArray(_t__a_4,(1,1),numpy.dtype(numpy.int32))
   _a_5=_monty.makeJaggedArray(_t__a_5,(1,1),numpy.dtype(numpy.float64))
   _a_6=numpy.int64(_t__a_6)
   _a_7=numpy.int32(_t__a_7)
   _a_8=numpy.int32(_t__a_8)
   _1_res = mosek_fusion_CommonTools._tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7,_a_8)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_3[:] = _a_3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_4[:] = _a_4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_5[:] = _a_5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6,_a_7,_a_8):
   _a_9=numpy.zeros((_a_6,), dtype=numpy.dtype(numpy.int32))
   _a_10=numpy.zeros(((_a_8 + 2),), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_121(_a_10,_a_6,_a_1) 
   fragments._c_closure_122(_a_10,_a_8) 
   fragments._c_closure_123(_a_9,_a_10,_a_6,_a_1) 
   _a_11=numpy.zeros(((_a_7 + 2),), dtype=numpy.dtype(numpy.int64))
   _a_12=numpy.zeros((_a_6,), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_124(_a_6,_a_11,_a_0) 
   fragments._c_closure_125(_a_7,_a_11) 
   fragments._c_closure_126(_a_9,_a_10,_a_8,_a_12,_a_11,_a_0) 
   _a_13=1
   _a_13 = fragments._c_closure_127(_a_6,_a_13,_a_12,_a_0,_a_1)
   _a_13 = numpy.int32(_a_13) # postprocess
   _a_14=numpy.zeros((_a_13,), dtype=numpy.dtype(numpy.int32))
   _a_15=numpy.zeros((_a_13,), dtype=numpy.dtype(numpy.int32))
   _a_16=numpy.zeros((_a_13,), dtype=numpy.dtype(numpy.float64))
   _a_17=_a_12[0]
   _a_14[0] = _a_0[_a_17]
   _a_15[0] = _a_1[_a_17]
   _a_16[0] = _a_2[_a_17]
   _a_18=1
   _a_18 = fragments._c_closure_128(_a_18,_a_6,_a_12,_a_0,_a_1,_a_14,_a_15,_a_16,_a_2)
   _a_18 = numpy.int32(_a_18) # postprocess
   _a_3[0] = _a_14
   _a_4[0] = _a_15
   _a_5[0] = _a_16
  @staticmethod
  def _match_argMSort__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_argMSort__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1))
  @staticmethod
  def _argMSort_alt__3I_3I(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_CommonTools._argMSort__3I_3I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argMSort__3I_3I(_a_0,_a_1):
   _a_2=numpy.zeros((int((_a_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
   _a_3=False
   _a_4=1
   while (_a_4 < int((_a_0).shape[0])):
    _a_3 = (not _a_3)
    for _a_5 in range(0,int((_a_0).shape[0]),(_a_4 * 2)):
     if _a_3:
      mosek.fusion.CommonTools.__mergeInto__3I_3I_3IIII(_a_0,_a_2,_a_1,_a_5,(_a_5 + _a_4),(_a_5 + (2 * _a_4)))
     else:
      mosek.fusion.CommonTools.__mergeInto__3I_3I_3IIII(_a_2,_a_0,_a_1,_a_5,(_a_5 + _a_4),(_a_5 + (2 * _a_4)))
    _a_4 *= 2
   if _a_3:
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(_a_2,0,_a_0,0,int((_a_0).shape[0]))
  @staticmethod
  def __mergeInto_alt__3I_3I_3IIII(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _a_3=numpy.int32(_t__a_3)
   _a_4=numpy.int32(_t__a_4)
   _a_5=numpy.int32(_t__a_5)
   _1_res = mosek_fusion_CommonTools.__mergeInto__3I_3I_3IIII(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __mergeInto__3I_3I_3IIII(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5):
   _a_6=(int((_a_0).shape[0]) if ((_a_5 > int((_a_0).shape[0])) ) else _a_5)
   _a_7=(_a_6 if ((_a_4 > _a_6) ) else _a_4)
   if (_a_7==_a_6):
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(_a_0,_a_3,_a_1,_a_3,(_a_7 - _a_3))
   else:
    fragments._c_closure_129(_a_3,_a_7,_a_6,_a_0,_a_1,_a_2) 
  @staticmethod
  def _match_argQsort__3J_3J_3JJJ(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3J__(_a_1) and __arg_match__3J__(_a_2) and __arg_match_J__(_a_3) and __arg_match_J__(_a_4))
  @staticmethod
  def _match_alt_argQsort__3J_3J_3JJJ(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match__3J__(_a_2) and __arg_alt_match_J__(_a_3) and __arg_alt_match_J__(_a_4))
  @staticmethod
  def _argQsort_alt__3J_3J_3JJJ(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int64))
   _a_3=numpy.int64(_t__a_3)
   _a_4=numpy.int64(_t__a_4)
   _1_res = mosek_fusion_CommonTools._argQsort__3J_3J_3JJJ(_a_0,_a_1,_a_2,_a_3,_a_4)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argQsort__3J_3J_3JJJ(_a_0,_a_1,_a_2,_a_3,_a_4):
   if (_a_2 is None):
    mosek.fusion.Utils.Tools._argsort__3J_3JJJ(_a_0,_a_1,_a_3,_a_4)
   else:
    mosek.fusion.Utils.Tools._argsort__3J_3J_3JJJ(_a_0,_a_1,_a_2,_a_3,_a_4)
  @staticmethod
  def _match_argQsort__3J_3I_3IJJ(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_match__3J__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3I__(_a_2) and __arg_match_J__(_a_3) and __arg_match_J__(_a_4))
  @staticmethod
  def _match_alt_argQsort__3J_3I_3IJJ(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_alt_match__3J__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3I__(_a_2) and __arg_alt_match_J__(_a_3) and __arg_alt_match_J__(_a_4))
  @staticmethod
  def _argQsort_alt__3J_3I_3IJJ(_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _a_3=numpy.int64(_t__a_3)
   _a_4=numpy.int64(_t__a_4)
   _1_res = mosek_fusion_CommonTools._argQsort__3J_3I_3IJJ(_a_0,_a_1,_a_2,_a_3,_a_4)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argQsort__3J_3I_3IJJ(_a_0,_a_1,_a_2,_a_3,_a_4):
   if (_a_2 is None):
    mosek.fusion.Utils.Tools._argsort__3J_3IJJ(_a_0,_a_1,_a_3,_a_4)
   else:
    mosek.fusion.Utils.Tools._argsort__3J_3I_3IJJ(_a_0,_a_1,_a_2,_a_3,_a_4)
 return CommonTools
mosek_fusion_CommonTools=__mk_mosek_fusion_CommonTools()
del __mk_mosek_fusion_CommonTools
#BEFORE CLASS
def __mk_mosek_fusion_SolutionStruct():
 class SolutionStruct(object):
  __slots__ = ['accy','accx','accptr','yx','sux','slx','bars','barx','y','suc','slc','xx','xc','dobj','pobj','probstatus','dstatus','pstatus','sol_numbarvar','sol_numaccelm','sol_numacc','sol_numvar','sol_numcon']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_Lmosek_4fusion_4SolutionStruct_2(*args):
      self._ctor_init_Lmosek_4fusion_4SolutionStruct_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4SolutionStruct_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4SolutionStruct_2(*args)
    elif self.__match_ctor_IIIII(*args):
      self._ctor_init_IIIII(*args)
    elif self.__match_alt_ctor_IIIII(*args):
      self._ctor_alt_init_IIIII(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.SolutionStruct.ctor(mosek.fusion.SolutionStruct)\n\tmosek.fusion.SolutionStruct.ctor(int32,int32,int32,int32,int32)')
  def resize(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.SolutionStruct.resize(int32,int32,int32,int32,int32)

    Description
    -----------

    

    Parameters
    ----------

    numacc : int32
    numaccelm : int32
    numbarvar : int32
    numcon : int32
    numvar : int32
    '''
    if False: pass
    elif mosek_fusion_SolutionStruct._match_resize_IIIII(*args):
      return self._resize_IIIII(*args)
    elif mosek_fusion_SolutionStruct._match_alt_resize_IIIII(*args):
      return self._resize_alt_IIIII(*args)
    else:
      raise ValueError('Invalid argument list resize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SolutionStruct.resize(int32,int32,int32,int32,int32)')
  def isDualAcceptable(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.SolutionStruct.isDualAcceptable(mosek.fusion.AccSolutionStatus)

    Description
    -----------

    

    Parameters
    ----------

    acceptable_sol : mosek.fusion.AccSolutionStatus
    '''
    if False: pass
    elif mosek_fusion_SolutionStruct._match_isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
      return self._isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args)
    elif mosek_fusion_SolutionStruct._match_alt_isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
      return self._isDualAcceptable_alt_Emosek_4fusion_4AccSolutionStatus_2(*args)
    else:
      raise ValueError('Invalid argument list isDualAcceptable('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SolutionStruct.isDualAcceptable(mosek.fusion.AccSolutionStatus)')
  def isPrimalAcceptable(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.SolutionStruct.isPrimalAcceptable(mosek.fusion.AccSolutionStatus)

    Description
    -----------

    

    Parameters
    ----------

    acceptable_sol : mosek.fusion.AccSolutionStatus
    '''
    if False: pass
    elif mosek_fusion_SolutionStruct._match_isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
      return self._isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args)
    elif mosek_fusion_SolutionStruct._match_alt_isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
      return self._isPrimalAcceptable_alt_Emosek_4fusion_4AccSolutionStatus_2(*args)
    else:
      raise ValueError('Invalid argument list isPrimalAcceptable('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SolutionStruct.isPrimalAcceptable(mosek.fusion.AccSolutionStatus)')
  def clone(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.SolutionStruct.clone()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_SolutionStruct._match_clone_(*args):
      return self._clone_(*args)
    elif mosek_fusion_SolutionStruct._match_alt_clone_(*args):
      return self._clone_alt_(*args)
    else:
      raise ValueError('Invalid argument list clone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SolutionStruct.clone()')
  def __repr__(self): return 'mosek.fusion.SolutionStruct'
  @staticmethod
  def _ctor_IIIII(numvar,numcon,numbarvar,numacc,numaccelm):
    o = SolutionStruct.__new__(SolutionStruct)
    o._ctor_init_IIIII(numvar,numcon,numbarvar,numacc,numaccelm)
    return o
  @staticmethod
  def __match_ctor_IIIII(*args):
    if len(args) != 5: return False
    numvar,numcon,numbarvar,numacc,numaccelm, = args
    return (__arg_match_I__(numvar) and __arg_match_I__(numcon) and __arg_match_I__(numbarvar) and __arg_match_I__(numacc) and __arg_match_I__(numaccelm))
  @staticmethod
  def __match_alt_ctor_IIIII(*args):
    if len(args) != 5: return False
    numvar,numcon,numbarvar,numacc,numaccelm, = args
    return (__arg_alt_match_I__(numvar) and __arg_alt_match_I__(numcon) and __arg_alt_match_I__(numbarvar) and __arg_alt_match_I__(numacc) and __arg_alt_match_I__(numaccelm))
  def _ctor_alt_init_IIIII(self,numvar,numcon,numbarvar,numacc,numaccelm):
    self._ctor_init_IIIII(numpy.int32(numvar),numpy.int32(numcon),numpy.int32(numbarvar),numpy.int32(numacc),numpy.int32(numaccelm))
  def _ctor_init_IIIII(self,numvar,numcon,numbarvar,numacc,numaccelm):
   self.pobj = 0.0
   self.dobj = 0.0
   self.pstatus = mosek.fusion.SolutionStatus.Unknown
   self.dstatus = mosek.fusion.SolutionStatus.Unknown
   self.probstatus = mosek.fusion.ProblemStatus.Unknown
   self.sol_numvar = numvar
   self.sol_numcon = numcon
   self.sol_numbarvar = numbarvar
   self.sol_numacc = numacc
   self.sol_numaccelm = numaccelm
   self.slx = None
   self.sux = None
   self.xx = None
   self.yx = None
   self.slc = None
   self.suc = None
   self.y = None
   self.xc = None
   self.barx = None
   self.bars = None
   self.accx = None
   self.accy = None
   self.accptr = None
   if (numvar > 0):
    self.slx = numpy.zeros((numvar,), dtype=numpy.dtype(numpy.float64))
    self.sux = numpy.zeros((numvar,), dtype=numpy.dtype(numpy.float64))
    self.xx = numpy.zeros((numvar,), dtype=numpy.dtype(numpy.float64))
    self.yx = numpy.zeros((numvar,), dtype=numpy.dtype(numpy.float64))
   if (numbarvar > 0):
    self.barx = numpy.zeros((numbarvar,), dtype=numpy.dtype(numpy.float64))
    self.bars = numpy.zeros((numbarvar,), dtype=numpy.dtype(numpy.float64))
   if (numcon > 0):
    self.slc = numpy.zeros((numcon,), dtype=numpy.dtype(numpy.float64))
    self.suc = numpy.zeros((numcon,), dtype=numpy.dtype(numpy.float64))
    self.y = numpy.zeros((numcon,), dtype=numpy.dtype(numpy.float64))
    self.xc = numpy.zeros((numcon,), dtype=numpy.dtype(numpy.float64))
   if (numacc > 0):
    self.accx = numpy.zeros((numaccelm,), dtype=numpy.dtype(numpy.float64))
    self.accy = numpy.zeros((numaccelm,), dtype=numpy.dtype(numpy.float64))
    self.accptr = numpy.zeros(((numacc + 1),), dtype=numpy.dtype(numpy.int32))
  @staticmethod
  def _ctor_Lmosek_4fusion_4SolutionStruct_2(that):
    o = SolutionStruct.__new__(SolutionStruct)
    o._ctor_init_Lmosek_4fusion_4SolutionStruct_2(that)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4SolutionStruct_2(*args):
    if len(args) != 1: return False
    that, = args
    return (__arg_match_Lmosek_4fusion_4SolutionStruct_2__(that))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4SolutionStruct_2(*args):
    if len(args) != 1: return False
    that, = args
    return (__arg_alt_match_Lmosek_4fusion_4SolutionStruct_2__(that))
  def _ctor_alt_init_Lmosek_4fusion_4SolutionStruct_2(self,that):
    self._ctor_init_Lmosek_4fusion_4SolutionStruct_2(that)
  def _ctor_init_Lmosek_4fusion_4SolutionStruct_2(self,that):
   self.sol_numcon = (that.sol_numcon)
   self.sol_numvar = (that.sol_numvar)
   self.sol_numbarvar = (that.sol_numbarvar)
   self.sol_numacc = (that.sol_numacc)
   self.sol_numaccelm = (that.sol_numaccelm)
   self.pstatus = (that.pstatus)
   self.dstatus = (that.dstatus)
   self.probstatus = (that.probstatus)
   self.pobj = (that.pobj)
   self.dobj = (that.dobj)
   self.xc = (mosek.fusion.Utils.Tools._arraycopy__3D((that.xc)) if (((that.xc) is not None) ) else None)
   self.xx = (mosek.fusion.Utils.Tools._arraycopy__3D((that.xx)) if (((that.xx) is not None) ) else None)
   self.yx = (mosek.fusion.Utils.Tools._arraycopy__3D((that.yx)) if (((that.yx) is not None) ) else None)
   self.slc = (mosek.fusion.Utils.Tools._arraycopy__3D((that.slc)) if (((that.slc) is not None) ) else None)
   self.suc = (mosek.fusion.Utils.Tools._arraycopy__3D((that.suc)) if (((that.suc) is not None) ) else None)
   self.y = (mosek.fusion.Utils.Tools._arraycopy__3D((that.y)) if (((that.y) is not None) ) else None)
   self.barx = (mosek.fusion.Utils.Tools._arraycopy__3D((that.barx)) if (((that.barx) is not None) ) else None)
   self.bars = (mosek.fusion.Utils.Tools._arraycopy__3D((that.bars)) if (((that.bars) is not None) ) else None)
   self.slx = (mosek.fusion.Utils.Tools._arraycopy__3D((that.slx)) if (((that.slx) is not None) ) else None)
   self.sux = (mosek.fusion.Utils.Tools._arraycopy__3D((that.sux)) if (((that.sux) is not None) ) else None)
   self.accptr = (mosek.fusion.Utils.Tools._arraycopy__3I((that.accptr)) if (((that.accptr) is not None) ) else None)
   self.accx = (mosek.fusion.Utils.Tools._arraycopy__3D((that.accx)) if (((that.accx) is not None) ) else None)
   self.accy = (mosek.fusion.Utils.Tools._arraycopy__3D((that.accy)) if (((that.accy) is not None) ) else None)
  @staticmethod
  def _match_clone_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_clone_(*args):
    if len(args) != 0: return False
    return True
  def _clone_alt_(self,):
    return self._clone_()
  def _clone_(self,):
   return (mosek_fusion_SolutionStruct._ctor_Lmosek_4fusion_4SolutionStruct_2(self))
  @staticmethod
  def _match_resize_IIIII(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1) and __arg_match_I__(_a_2) and __arg_match_I__(_a_3) and __arg_match_I__(_a_4))
  @staticmethod
  def _match_alt_resize_IIIII(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_I__(_a_2) and __arg_alt_match_I__(_a_3) and __arg_alt_match_I__(_a_4))
  def _resize_alt_IIIII(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4):
    return self._resize_IIIII(numpy.int32(__a_0),numpy.int32(__a_1),numpy.int32(__a_2),numpy.int32(__a_3),numpy.int32(__a_4))
  def _resize_IIIII(self,_a_0,_a_1,_a_2,_a_3,_a_4):
   if (_a_3 <= 0):
    self.sol_numacc = 0
   elif (_a_3 <= (int((self.accptr).shape[0]) - 1)):
    self.sol_numacc = _a_3
   else:
    _a_5=((int((self.accptr).shape[0]) - 1) * 2)
    if (_a_5 < _a_3):
     _a_5 = _a_3
    _a_6=numpy.zeros(((_a_5 + 1),), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.accptr,0,_a_6,0,(_a_3 + 1))
    self.accptr = _a_6
    self.sol_numacc = _a_3
   if (_a_4 <= 0):
    self.sol_numaccelm = 0
   elif (_a_4 > int((self.accx).shape[0])):
    self.sol_numaccelm = _a_4
   else:
    _a_7=(int((self.accx).shape[0]) * 2)
    if (_a_7 < _a_4):
     _a_7 = _a_4
    _a_8=numpy.zeros((_a_7,), dtype=numpy.dtype(numpy.float64))
    _a_9=numpy.zeros((_a_7,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.accx,0,_a_8,0,_a_4)
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.accy,0,_a_9,0,_a_4)
    self.accx = _a_8
    self.accy = _a_9
    self.sol_numaccelm = _a_4
   if (_a_2 < 0):
    pass
   elif (_a_2 <= self.sol_numbarvar):
    self.sol_numbarvar = _a_2
   elif (_a_2 <= int((self.barx).shape[0])):
    pass
   else:
    if ((self.sol_numbarvar * 2) > (_a_2 + 100)):
     _a_10 = (self.sol_numbarvar * 2)
    else:
     _a_10 = (_a_2 + 100)
    self.barx = mosek.fusion.CommonTools._resize__3DI(self.barx,_a_10)
    self.bars = mosek.fusion.CommonTools._resize__3DI(self.bars,_a_10)
    self.sol_numbarvar = _a_10
   if (_a_0 < 0):
    pass
   elif (_a_0 <= self.sol_numvar):
    self.sol_numvar = _a_0
   elif (_a_0 <= int((self.xx).shape[0])):
    self.sol_numvar = fragments._c_closure_130(_a_0,self.slx,self.sol_numvar,self.sux,self.xx,self.yx)
    self.sol_numvar = numpy.int32(self.sol_numvar) # postprocess
   else:
    if ((self.sol_numvar * 2) > (_a_0 + 100)):
     _a_11 = (self.sol_numvar * 2)
    else:
     _a_11 = (_a_0 + 100)
    _a_12=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.slx,0,_a_12,0,int((self.slx).shape[0]))
    self.slx = _a_12
    _a_13=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.sux,0,_a_13,0,int((self.sux).shape[0]))
    self.sux = _a_13
    _a_14=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.xx,0,_a_14,0,int((self.xx).shape[0]))
    self.xx = _a_14
    _a_15=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.yx,0,_a_15,0,int((self.yx).shape[0]))
    self.yx = _a_15
    fragments._c_closure_131(_a_0,self.slx,self.sol_numvar,self.sux,self.xx) 
    self.sol_numvar = _a_0
   if (_a_1 < 0):
    pass
   elif (_a_1 <= self.sol_numcon):
    self.sol_numcon = _a_1
   elif (_a_1 <= int((self.xx).shape[0])):
    self.sol_numcon = fragments._c_closure_132(_a_1,self.slc,self.sol_numcon,self.suc,self.xc,self.y)
    self.sol_numcon = numpy.int32(self.sol_numcon) # postprocess
   else:
    if ((self.sol_numcon * 2) > (_a_1 + 100)):
     _a_16 = (self.sol_numcon * 2)
    else:
     _a_16 = (_a_1 + 100)
    _a_17=numpy.zeros((_a_16,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.slc,0,_a_17,0,int((self.slc).shape[0]))
    self.slc = _a_17
    _a_18=numpy.zeros((_a_16,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.suc,0,_a_18,0,int((self.suc).shape[0]))
    self.suc = _a_18
    _a_19=numpy.zeros((_a_16,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.xc,0,_a_19,0,int((self.xc).shape[0]))
    self.xc = _a_19
    _a_20=numpy.zeros((_a_16,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.y,0,_a_20,0,int((self.y).shape[0]))
    self.y = _a_20
    fragments._c_closure_133(_a_1,self.slc,self.sol_numcon,self.suc,self.xc,self.y) 
    self.sol_numcon = _a_1
  @staticmethod
  def _match_isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Emosek_4fusion_4AccSolutionStatus_2__(_a_0))
  @staticmethod
  def _match_alt_isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Emosek_4fusion_4AccSolutionStatus_2__(_a_0))
  def _isDualAcceptable_alt_Emosek_4fusion_4AccSolutionStatus_2(self,_t__a_0):
    return self._isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(__a_0)
  def _isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(self,_a_0):
   return (self.__isAcceptable_Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4AccSolutionStatus_2(self.dstatus,_a_0))
  @staticmethod
  def _match_isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Emosek_4fusion_4AccSolutionStatus_2__(_a_0))
  @staticmethod
  def _match_alt_isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Emosek_4fusion_4AccSolutionStatus_2__(_a_0))
  def _isPrimalAcceptable_alt_Emosek_4fusion_4AccSolutionStatus_2(self,_t__a_0):
    return self._isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(__a_0)
  def _isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(self,_a_0):
   return (self.__isAcceptable_Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4AccSolutionStatus_2(self.pstatus,_a_0))
  def __isAcceptable_alt_Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4AccSolutionStatus_2(self,_t__a_0,_t__a_1):
    return self.__isAcceptable_Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4AccSolutionStatus_2(__a_0,__a_1)
  def __isAcceptable_Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4AccSolutionStatus_2(self,_a_0,_a_1):
   if (_a_1==mosek.fusion.AccSolutionStatus.Anything):
    return (True)
   elif (_a_1==mosek.fusion.AccSolutionStatus.Optimal):
    return ((_a_0==mosek.fusion.SolutionStatus.Optimal))
   elif (_a_1==mosek.fusion.AccSolutionStatus.Feasible):
    return (((_a_0==mosek.fusion.SolutionStatus.Optimal) or (_a_0==mosek.fusion.SolutionStatus.Feasible)))
   elif (_a_1==mosek.fusion.AccSolutionStatus.Certificate):
    return ((_a_0==mosek.fusion.SolutionStatus.Certificate))
   return (False)
 return SolutionStruct
mosek_fusion_SolutionStruct=__mk_mosek_fusion_SolutionStruct()
del __mk_mosek_fusion_SolutionStruct
#BEFORE CLASS
def __mk_mosek_fusion_RowBlockManager():
 class RowBlockManager(object):
  __slots__ = ['varidx_used','code_used','cconst','code','first_free_codeitem','param_code_sizes','param_varidx','first_free_entry','row_code_ptr','row_param_ptre','row_param_ptrb','blocks']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_(*args):
      self._ctor_init_(*args)
    elif self.__match_alt_ctor_(*args):
      self._ctor_alt_init_(*args)
    elif self.__match_ctor_Lmosek_4fusion_4RowBlockManager_2(*args):
      self._ctor_init_Lmosek_4fusion_4RowBlockManager_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4RowBlockManager_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4RowBlockManager_2(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.RowBlockManager.ctor()\n\tmosek.fusion.RowBlockManager.ctor(mosek.fusion.RowBlockManager)')
  def block_capacity(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RowBlockManager.block_capacity()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_RowBlockManager._match_block_1capacity_(*args):
      return self._block_1capacity_(*args)
    elif mosek_fusion_RowBlockManager._match_alt_block_1capacity_(*args):
      return self._block_1capacity_alt_(*args)
    else:
      raise ValueError('Invalid argument list block_capacity('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.block_capacity()')
  def num_parameterized(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RowBlockManager.num_parameterized()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_RowBlockManager._match_num_1parameterized_(*args):
      return self._num_1parameterized_(*args)
    elif mosek_fusion_RowBlockManager._match_alt_num_1parameterized_(*args):
      return self._num_1parameterized_alt_(*args)
    else:
      raise ValueError('Invalid argument list num_parameterized('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.num_parameterized()')
  def is_parameterized(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RowBlockManager.is_parameterized()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_RowBlockManager._match_is_1parameterized_(*args):
      return self._is_1parameterized_(*args)
    elif mosek_fusion_RowBlockManager._match_alt_is_1parameterized_(*args):
      return self._is_1parameterized_alt_(*args)
    else:
      raise ValueError('Invalid argument list is_parameterized('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.is_parameterized()')
  def row_is_parameterized(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RowBlockManager.row_is_parameterized(int32)

    Description
    -----------

    

    Parameters
    ----------

    i : int32
    '''
    if False: pass
    elif mosek_fusion_RowBlockManager._match_row_1is_1parameterized_I(*args):
      return self._row_1is_1parameterized_I(*args)
    elif mosek_fusion_RowBlockManager._match_alt_row_1is_1parameterized_I(*args):
      return self._row_1is_1parameterized_alt_I(*args)
    else:
      raise ValueError('Invalid argument list row_is_parameterized('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.row_is_parameterized(int32)')
  def replace_row_code(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RowBlockManager.replace_row_code(mosek.fusion.WorkStack,array(int32,ndim=1),int32,int32,int32,int32,int32)

    Description
    -----------

    Replace the parameterization code in a set of rows 

    Parameters
    ----------

    cconst_p : int32
    code_p : int32
    codeptr : int32
    nativeidxs : array(int32,ndim=1)
    nidxs : int32
    ptr : int32
    rs : mosek.fusion.WorkStack
    '''
    if False: pass
    elif mosek_fusion_RowBlockManager._match_replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(*args):
      return self._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(*args)
    elif mosek_fusion_RowBlockManager._match_alt_replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(*args):
      return self._replace_1row_1code_alt_Lmosek_4fusion_4WorkStack_2_3IIIIII(*args)
    else:
      raise ValueError('Invalid argument list replace_row_code('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.replace_row_code(mosek.fusion.WorkStack,array(int32,ndim=1),int32,int32,int32,int32,int32)')
  def allocate(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RowBlockManager.allocate(array(int32,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    nativeidxs : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_RowBlockManager._match_allocate__3I(*args):
      return self._allocate__3I(*args)
    elif mosek_fusion_RowBlockManager._match_alt_allocate__3I(*args):
      return self._allocate_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list allocate('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.allocate(array(int32,ndim=1))')
  def release(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RowBlockManager.release(int32,array(int32,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    id : int32
    nativeidxs : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_RowBlockManager._match_release_I_3I(*args):
      return self._release_I_3I(*args)
    elif mosek_fusion_RowBlockManager._match_alt_release_I_3I(*args):
      return self._release_alt_I_3I(*args)
    else:
      raise ValueError('Invalid argument list release('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.release(int32,array(int32,ndim=1))')
  def get(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RowBlockManager.get(int32,array(int32,ndim=1),int32)

    Description
    -----------

    

    Parameters
    ----------

    id : int32
    offset : int32
    target : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_RowBlockManager._match_get_I_3II(*args):
      return self._get_I_3II(*args)
    elif mosek_fusion_RowBlockManager._match_alt_get_I_3II(*args):
      return self._get_alt_I_3II(*args)
    else:
      raise ValueError('Invalid argument list get('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.get(int32,array(int32,ndim=1),int32)')
  def blocksize(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RowBlockManager.blocksize(int32)

    Description
    -----------

    

    Parameters
    ----------

    id : int32
    '''
    if False: pass
    elif mosek_fusion_RowBlockManager._match_blocksize_I(*args):
      return self._blocksize_I(*args)
    elif mosek_fusion_RowBlockManager._match_alt_blocksize_I(*args):
      return self._blocksize_alt_I(*args)
    else:
      raise ValueError('Invalid argument list blocksize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.blocksize(int32)')
  def clear_row_code(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RowBlockManager.clear_row_code(array(int32,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    nativeidxs : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_RowBlockManager._match_clear_1row_1code__3I(*args):
      return self._clear_1row_1code__3I(*args)
    elif mosek_fusion_RowBlockManager._match_alt_clear_1row_1code__3I(*args):
      return self._clear_1row_1code_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list clear_row_code('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.clear_row_code(array(int32,ndim=1))')
  def capacity(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RowBlockManager.capacity()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_RowBlockManager._match_capacity_(*args):
      return self._capacity_(*args)
    elif mosek_fusion_RowBlockManager._match_alt_capacity_(*args):
      return self._capacity_alt_(*args)
    else:
      raise ValueError('Invalid argument list capacity('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.capacity()')
  def evaluate(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RowBlockManager.evaluate(mosek.fusion.WorkStack,array(double,ndim=1),array(int32,ndim=1),array(int32,ndim=1),array(double,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    param_value : array(double,ndim=1)
    subi : array(int32,ndim=1)
    subj : array(int32,ndim=1)
    val : array(double,ndim=1)
    xs : mosek.fusion.WorkStack
    '''
    if False: pass
    elif mosek_fusion_RowBlockManager._match_evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(*args):
      return self._evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(*args)
    elif mosek_fusion_RowBlockManager._match_alt_evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(*args):
      return self._evaluate_alt_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(*args)
    else:
      raise ValueError('Invalid argument list evaluate('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.evaluate(mosek.fusion.WorkStack,array(double,ndim=1),array(int32,ndim=1),array(int32,ndim=1),array(double,ndim=1))')
  def __repr__(self): return 'mosek.fusion.RowBlockManager'
  @staticmethod
  def _ctor_Lmosek_4fusion_4RowBlockManager_2(that):
    o = RowBlockManager.__new__(RowBlockManager)
    o._ctor_init_Lmosek_4fusion_4RowBlockManager_2(that)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4RowBlockManager_2(*args):
    if len(args) != 1: return False
    that, = args
    return (__arg_match_Lmosek_4fusion_4RowBlockManager_2__(that))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4RowBlockManager_2(*args):
    if len(args) != 1: return False
    that, = args
    return (__arg_alt_match_Lmosek_4fusion_4RowBlockManager_2__(that))
  def _ctor_alt_init_Lmosek_4fusion_4RowBlockManager_2(self,that):
    self._ctor_init_Lmosek_4fusion_4RowBlockManager_2(that)
  def _ctor_init_Lmosek_4fusion_4RowBlockManager_2(self,that):
   self.blocks = mosek_fusion_LinkedBlocks._ctor_Lmosek_4fusion_4LinkedBlocks_2((that.blocks))
   self.row_param_ptrb = (mosek.fusion.Utils.Tools._arraycopy__3I((that.row_param_ptrb)) if (((that.row_param_ptrb) is not None) ) else None)
   self.row_param_ptre = (mosek.fusion.Utils.Tools._arraycopy__3I((that.row_param_ptre)) if (((that.row_param_ptre) is not None) ) else None)
   self.row_code_ptr = (mosek.fusion.Utils.Tools._arraycopy__3I((that.row_code_ptr)) if (((that.row_code_ptr) is not None) ) else None)
   self.first_free_entry = (that.first_free_entry)
   self.param_varidx = (mosek.fusion.Utils.Tools._arraycopy__3J((that.param_varidx)) if (((that.param_varidx) is not None) ) else None)
   self.param_code_sizes = (mosek.fusion.Utils.Tools._arraycopy__3I((that.param_code_sizes)) if (((that.param_code_sizes) is not None) ) else None)
   self.first_free_codeitem = (that.first_free_codeitem)
   self.code = (mosek.fusion.Utils.Tools._arraycopy__3I((that.code)) if (((that.code) is not None) ) else None)
   self.cconst = (mosek.fusion.Utils.Tools._arraycopy__3D((that.cconst)) if (((that.cconst) is not None) ) else None)
   self.code_used = (that.code_used)
   self.varidx_used = (that.varidx_used)
  @staticmethod
  def _ctor_():
    o = RowBlockManager.__new__(RowBlockManager)
    o._ctor_init_()
    return o
  @staticmethod
  def __match_ctor_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def __match_alt_ctor_(*args):
    if len(args) != 0: return False
    return True
  def _ctor_alt_init_(self,):
    self._ctor_init_()
  def _ctor_init_(self,):
   self.blocks = mosek_fusion_LinkedBlocks._ctor_()
   self.row_param_ptrb = None
   self.row_param_ptre = None
   self.row_code_ptr = None
   self.first_free_entry = 0
   self.param_varidx = None
   self.param_code_sizes = None
   self.first_free_codeitem = 0
   self.code = None
   self.cconst = None
   self.code_used = 0
   self.varidx_used = 0
  @staticmethod
  def _match_num_1parameterized_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_num_1parameterized_(*args):
    if len(args) != 0: return False
    return True
  def _num_1parameterized_alt_(self,):
    return self._num_1parameterized_()
  def _num_1parameterized_(self,):
   return numpy.int32(self.varidx_used)
  @staticmethod
  def _match_is_1parameterized_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_is_1parameterized_(*args):
    if len(args) != 0: return False
    return True
  def _is_1parameterized_alt_(self,):
    return self._is_1parameterized_()
  def _is_1parameterized_(self,):
   return ((self.code_used > 0))
  @staticmethod
  def _match_blocksize_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_blocksize_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _blocksize_alt_I(self,_t__a_0):
    return self._blocksize_I(numpy.int32(__a_0))
  def _blocksize_I(self,_a_0):
   return numpy.int32(self.blocks._blocksize_I(_a_0))
  @staticmethod
  def _match_block_1capacity_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_block_1capacity_(*args):
    if len(args) != 0: return False
    return True
  def _block_1capacity_alt_(self,):
    return self._block_1capacity_()
  def _block_1capacity_(self,):
   return numpy.int32(self.blocks._block_1capacity_())
  @staticmethod
  def _match_capacity_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_capacity_(*args):
    if len(args) != 0: return False
    return True
  def _capacity_alt_(self,):
    return self._capacity_()
  def _capacity_(self,):
   return numpy.int32(self.blocks._capacity_())
  @staticmethod
  def _match_get_I_3II(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_I__(_a_0) and __arg_match__3I__(_a_1) and __arg_match_I__(_a_2))
  @staticmethod
  def _match_alt_get_I_3II(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match_I__(_a_2))
  def _get_alt_I_3II(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.int32(_t__a_2)
   _1_res = self._get_I_3II(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _get_I_3II(self,_a_0,_a_1,_a_2):
   self.blocks._get_I_3II(_a_0,_a_1,_a_2)
  @staticmethod
  def _match_evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_match_Lmosek_4fusion_4WorkStack_2__(_a_0) and __arg_match__3D__(_a_1) and __arg_match__3I__(_a_2) and __arg_match__3I__(_a_3) and __arg_match__3D__(_a_4))
  @staticmethod
  def _match_alt_evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(*args):
    if len(args) != 5: return False
    _a_0,_a_1,_a_2,_a_3,_a_4, = args
    return (__arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_0) and __arg_alt_match__3D__(_a_1) and __arg_alt_match__3I__(_a_2) and __arg_alt_match__3I__(_a_3) and __arg_alt_match__3D__(_a_4))
  def _evaluate_alt_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.float64))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _a_3=numpy.array(_t__a_3,dtype=numpy.dtype(numpy.int32))
   _a_4=numpy.array(_t__a_4,dtype=numpy.dtype(numpy.float64))
   _1_res = self._evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(_a_0,_a_1,_a_2,_a_3,_a_4)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_3[:] = _a_3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_4[:] = _a_4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(self,_a_0,_a_1,_a_2,_a_3,_a_4):
   _a_5=_a_0._allocf64_I(self.code_used)
   _a_6=0
   _a_7=(_a_0.f64)
   _a_8=0
   _a_8,_a_6 = fragments._c_closure_134(self.cconst,self.code,_a_8,self.param_code_sizes,_a_1,self.param_varidx,self.row_code_ptr,self.row_param_ptrb,self.row_param_ptre,_a_5,_a_6,_a_2,_a_3,_a_4,_a_7)
   _a_8 = numpy.int32(_a_8) # postprocess
   _a_6 = numpy.int32(_a_6) # postprocess
   _a_0._popf64_I(self.code_used)
  @staticmethod
  def _match_replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(*args):
    if len(args) != 7: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6, = args
    return (__arg_match_Lmosek_4fusion_4WorkStack_2__(_a_0) and __arg_match__3I__(_a_1) and __arg_match_I__(_a_2) and __arg_match_I__(_a_3) and __arg_match_I__(_a_4) and __arg_match_I__(_a_5) and __arg_match_I__(_a_6))
  @staticmethod
  def _match_alt_replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(*args):
    if len(args) != 7: return False
    _a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6, = args
    return (__arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match_I__(_a_2) and __arg_alt_match_I__(_a_3) and __arg_alt_match_I__(_a_4) and __arg_alt_match_I__(_a_5) and __arg_alt_match_I__(_a_6))
  def _replace_1row_1code_alt_Lmosek_4fusion_4WorkStack_2_3IIIIII(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3,_t__a_4,_t__a_5,_t__a_6):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.int32(_t__a_2)
   _a_3=numpy.int32(_t__a_3)
   _a_4=numpy.int32(_t__a_4)
   _a_5=numpy.int32(_t__a_5)
   _a_6=numpy.int32(_t__a_6)
   _1_res = self._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(_a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self,_a_0,_a_1,_a_2,_a_3,_a_4,_a_5,_a_6):
   _a_7=int((_a_1).shape[0])
   _a_8=(_a_0.i32)
   _a_9=(_a_0.i64)
   _a_10=(_a_0.f64)
   _a_11=True
   _a_12=0
   _a_13=0
   _a_13,_a_12 = fragments._c_closure_135(_a_5,_a_4,_a_7,_a_13,_a_12,_a_2,_a_8)
   _a_13 = numpy.int32(_a_13) # postprocess
   _a_12 = numpy.int32(_a_12) # postprocess
   self._clear_1row_1code__3I(_a_1)
   self.__ensure_1code_1cap_II(_a_13,_a_12)
   self.code_used += _a_12
   self.varidx_used += _a_13
   if (self.first_free_codeitem > (self.code_used * 2)):
    self.__compress_()
   self.first_free_codeitem,self.first_free_entry = fragments._c_closure_136(_a_5,_a_4,self.first_free_codeitem,self.first_free_entry,_a_1,_a_7,_a_2,_a_8,self.row_code_ptr,self.row_param_ptrb,self.row_param_ptre)
   self.first_free_codeitem = numpy.int32(self.first_free_codeitem) # postprocess
   self.first_free_entry = numpy.int32(self.first_free_entry) # postprocess
   _a_11 = fragments._c_closure_137(self.cconst,_a_6,self.code,_a_5,_a_4,_a_1,_a_7,_a_3,_a_11,self.param_code_sizes,self.param_varidx,_a_2,_a_10,_a_8,_a_9,self.row_code_ptr,self.row_param_ptrb)
   if (not _a_11):
    raise mosek_fusion_ParameterError._ctor_S("Expression contains parameterized SDP non-zero")
  @staticmethod
  def _match_clear_1row_1code__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_clear_1row_1code__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _clear_1row_1code_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._clear_1row_1code__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _clear_1row_1code__3I(self,_a_0):
   self.code_used,self.varidx_used = fragments._c_closure_138(self.code_used,_a_0,self.param_code_sizes,self.row_param_ptrb,self.row_param_ptre,self.varidx_used)
   self.code_used = numpy.int32(self.code_used) # postprocess
   self.varidx_used = numpy.int32(self.varidx_used) # postprocess
  def __compress_alt_(self,):
    return self.__compress_()
  def __compress_(self,):
   _a_0=numpy.zeros((self.code_used,), dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.zeros((self.code_used,), dtype=numpy.dtype(numpy.float64))
   _a_2=numpy.zeros((self.first_free_entry,), dtype=numpy.dtype(numpy.int64))
   _a_3=numpy.zeros((self.first_free_entry,), dtype=numpy.dtype(numpy.int32))
   _a_4=0
   _a_5=0
   for _a_6 in range(0,int((self.row_param_ptrb).shape[0])):
    _a_7=0
    _a_8=(self.row_param_ptre[_a_6] - self.row_param_ptrb[_a_6])
    mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(self.param_varidx,self.row_param_ptrb[_a_6],_a_2,_a_4,_a_8)
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.param_code_sizes,self.row_param_ptrb[_a_6],_a_3,_a_4,_a_8)
    _a_7 = fragments._c_closure_139(_a_7,_a_6,self.param_code_sizes,self.row_param_ptrb,self.row_param_ptre)
    _a_7 = numpy.int32(_a_7) # postprocess
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.code,self.row_code_ptr[_a_6],_a_0,_a_5,_a_7)
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.cconst,self.row_code_ptr[_a_6],_a_1,_a_5,_a_7)
    self.row_param_ptrb[_a_6] = _a_4
    self.row_param_ptre[_a_6] = (_a_4 + _a_8)
    self.row_code_ptr[_a_6] = _a_5
    _a_5 += _a_7
    _a_4 += _a_8
   mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(_a_2,0,self.param_varidx,0,_a_4)
   mosek.fusion.Utils.Tools._arraycopy__3II_3III(_a_3,0,self.param_code_sizes,0,_a_4)
   mosek.fusion.Utils.Tools._arraycopy__3II_3III(_a_0,0,self.code,0,_a_5)
   mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_a_1,0,self.cconst,0,_a_5)
   self.first_free_codeitem = _a_5
   self.first_free_entry = _a_4
  def __ensure_1code_1cap_alt_II(self,_t__a_0,_t__a_1):
    return self.__ensure_1code_1cap_II(numpy.int32(__a_0),numpy.int32(__a_1))
  def __ensure_1code_1cap_II(self,_a_0,_a_1):
   if (self.row_code_ptr is None):
    _a_2=128
    _a_2 = fragments._c_closure_140(_a_2,_a_0)
    _a_2 = numpy.int32(_a_2) # postprocess
    _a_3=128
    _a_3 = fragments._c_closure_141(_a_1,_a_3)
    _a_3 = numpy.int32(_a_3) # postprocess
    self.row_param_ptrb = numpy.zeros((self.blocks._capacity_(),), dtype=numpy.dtype(numpy.int32))
    self.row_param_ptre = numpy.zeros((self.blocks._capacity_(),), dtype=numpy.dtype(numpy.int32))
    self.row_code_ptr = numpy.zeros((self.blocks._capacity_(),), dtype=numpy.dtype(numpy.int32))
    self.param_varidx = numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.int64))
    self.param_code_sizes = numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.int32))
    self.code = numpy.zeros((_a_3,), dtype=numpy.dtype(numpy.int32))
    self.cconst = numpy.zeros((_a_3,), dtype=numpy.dtype(numpy.float64))
   else:
    if (_a_0 > (int((self.param_varidx).shape[0]) - self.first_free_entry)):
     _a_4=int((self.param_varidx).shape[0])
     _a_4 = fragments._c_closure_142(self.first_free_entry,_a_4,_a_0)
     _a_4 = numpy.int32(_a_4) # postprocess
     _a_5=numpy.zeros((_a_4,), dtype=numpy.dtype(numpy.int32))
     _a_6=numpy.zeros((_a_4,), dtype=numpy.dtype(numpy.int64))
     _a_7=numpy.zeros((_a_4,), dtype=numpy.dtype(numpy.int32))
     mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(self.param_varidx,0,_a_6,0,self.first_free_entry)
     mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.param_code_sizes,0,_a_7,0,self.first_free_entry)
     self.param_varidx = _a_6
     self.param_code_sizes = _a_7
    if (_a_1 > (int((self.code).shape[0]) - self.first_free_codeitem)):
     _a_8=int((self.code).shape[0])
     _a_8 = fragments._c_closure_143(_a_1,self.first_free_codeitem,_a_8)
     _a_8 = numpy.int32(_a_8) # postprocess
     _a_9=numpy.zeros((_a_8,), dtype=numpy.dtype(numpy.int32))
     mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.code,0,_a_9,0,self.first_free_codeitem)
     _a_10=numpy.zeros((_a_8,), dtype=numpy.dtype(numpy.float64))
     mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.cconst,0,_a_10,0,self.first_free_codeitem)
     self.code = _a_9
     self.cconst = _a_10
  @staticmethod
  def _match_release_I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_release_I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match__3I__(_a_1))
  def _release_alt_I_3I(self,_t__a_0,_t__a_1):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._release_I_3I(_a_0,_a_1)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _release_I_3I(self,_a_0,_a_1):
   _a_2=self.blocks._blocksize_I(_a_0)
   self.blocks._get_I_3II(_a_0,_a_1,0)
   self.blocks._free_I(_a_0)
   self.code_used = fragments._c_closure_144(self.code_used,_a_1,_a_2,self.row_code_ptr,self.row_param_ptrb,self.row_param_ptre)
   self.code_used = numpy.int32(self.code_used) # postprocess
  @staticmethod
  def _match_allocate__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_allocate__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _allocate_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._allocate__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _allocate__3I(self,_a_0):
   _a_1=int((_a_0).shape[0])
   _a_2=self.blocks._alloc_I(_a_1)
   self.blocks._get_I_3II(_a_2,_a_0,0)
   if ((self.row_code_ptr is not None) and (self.blocks._capacity_() > int((self.row_param_ptrb).shape[0]))):
    _a_3=numpy.zeros((self.blocks._capacity_(),), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.row_param_ptrb,0,_a_3,0,int((self.row_param_ptrb).shape[0]))
    _a_4=numpy.zeros((self.blocks._capacity_(),), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.row_param_ptre,0,_a_4,0,int((self.row_param_ptre).shape[0]))
    _a_5=numpy.zeros((self.blocks._capacity_(),), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.row_code_ptr,0,_a_5,0,int((self.row_code_ptr).shape[0]))
    self.row_param_ptrb = _a_3
    self.row_param_ptre = _a_4
    self.row_code_ptr = _a_5
   return numpy.int32(_a_2)
  @staticmethod
  def _match_row_1is_1parameterized_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_row_1is_1parameterized_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _row_1is_1parameterized_alt_I(self,_t__a_0):
    return self._row_1is_1parameterized_I(numpy.int32(__a_0))
  def _row_1is_1parameterized_I(self,_a_0):
   return (((self.row_param_ptrb is not None) and (self.row_param_ptrb[_a_0] < self.row_param_ptre[_a_0])))
 return RowBlockManager
mosek_fusion_RowBlockManager=__mk_mosek_fusion_RowBlockManager()
del __mk_mosek_fusion_RowBlockManager
#BEFORE CLASS
def __mk_mosek_fusion_BaseVariable():
 class BaseVariable(mosek_fusion_Variable,object):
  __slots__ = ['_BaseVariable__sparsity','_BaseVariable__basevar_nativeidxs','_BaseVariable__model','_BaseVariable__shape']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(*args):
      self._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(*args):
      self._ctor_alt_init_Lmosek_4fusion_4Model_2_3I_3J_3J(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.BaseVariable.ctor(mosek.fusion.Model,array(int32,ndim=1),array(int64,ndim=1),array(int64,ndim=1))')
  def diag(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.diag()
      mosek.fusion.BaseVariable.diag(int32)

    Description
    -----------

    Return the diagonal of a square variable matrix.

    Parameters
    ----------

    index : int32
        Index of the anti-diagonal
    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_diag_(*args):
      return self._diag_(*args)
    elif mosek_fusion_BaseVariable._match_alt_diag_(*args):
      return self._diag_alt_(*args)
    elif mosek_fusion_BaseVariable._match_diag_I(*args):
      return self._diag_I(*args)
    elif mosek_fusion_BaseVariable._match_alt_diag_I(*args):
      return self._diag_alt_I(*args)
    else:
      raise ValueError('Invalid argument list diag('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.diag()\n\tmosek.fusion.BaseVariable.diag(int32)')
  def set_values(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.set_values(array(double,ndim=1),bool)

    Description
    -----------

    

    Parameters
    ----------

    primal : bool
    values : array(double,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_set_1values__3DZ(*args):
      return self._set_1values__3DZ(*args)
    elif mosek_fusion_BaseVariable._match_alt_set_1values__3DZ(*args):
      return self._set_1values_alt__3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.set_values(array(double,ndim=1),bool)')
  def antidiag(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.antidiag()
      mosek.fusion.BaseVariable.antidiag(int32)

    Description
    -----------

    Return the antidiagonal of a square variable matrix.

    Parameters
    ----------

    index : int32
        Index of the anti-diagonal
    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_antidiag_(*args):
      return self._antidiag_(*args)
    elif mosek_fusion_BaseVariable._match_alt_antidiag_(*args):
      return self._antidiag_alt_(*args)
    elif mosek_fusion_BaseVariable._match_antidiag_I(*args):
      return self._antidiag_I(*args)
    elif mosek_fusion_BaseVariable._match_alt_antidiag_I(*args):
      return self._antidiag_alt_I(*args)
    else:
      raise ValueError('Invalid argument list antidiag('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.antidiag()\n\tmosek.fusion.BaseVariable.antidiag(int32)')
  def makeContinuous(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.makeContinuous()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_makeContinuous_(*args):
      return self._makeContinuous_(*args)
    elif mosek_fusion_BaseVariable._match_alt_makeContinuous_(*args):
      return self._makeContinuous_alt_(*args)
    else:
      raise ValueError('Invalid argument list makeContinuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.makeContinuous()')
  def slice(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.slice(int32,int32)
      mosek.fusion.BaseVariable.slice(array(int32,ndim=1),array(int32,ndim=1))

    Description
    -----------

    Create a slice variable by picking a range of indexes for each variable dimension. 

    Parameters
    ----------

    first : array(int32,ndim=1)
        The indices from which the slice of a multidimensional variable begins.
    last : array(int32,ndim=1)
        The indices after the last element of slice of a multidimensional variable.
    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_slice_II(*args):
      return self._slice_II(*args)
    elif mosek_fusion_BaseVariable._match_alt_slice_II(*args):
      return self._slice_alt_II(*args)
    elif mosek_fusion_BaseVariable._match_slice__3I_3I(*args):
      return self._slice__3I_3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_slice__3I_3I(*args):
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.slice(int32,int32)\n\tmosek.fusion.BaseVariable.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def getModel(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.getModel()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_getModel_(*args):
      return self._getModel_(*args)
    elif mosek_fusion_BaseVariable._match_alt_getModel_(*args):
      return self._getModel_alt_(*args)
    else:
      raise ValueError('Invalid argument list getModel('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.getModel()')
  def index(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.index(int32)
      mosek.fusion.BaseVariable.index(array(int32,ndim=1))
      mosek.fusion.BaseVariable.index(int32,int32)
      mosek.fusion.BaseVariable.index(int32,int32,int32)

    Description
    -----------

    Return a variable slice of size 1 corresponding to a single element in the variable object..

    Parameters
    ----------

    i0 : int32
        Index in the first dimension of the element requested.
    i1 : int32
        Index in the second dimension of the element requested.
    i2 : int32
    index : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_index_I(*args):
      return self._index_I(*args)
    elif mosek_fusion_BaseVariable._match_alt_index_I(*args):
      return self._index_alt_I(*args)
    elif mosek_fusion_BaseVariable._match_index__3I(*args):
      return self._index__3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_index__3I(*args):
      return self._index_alt__3I(*args)
    elif mosek_fusion_BaseVariable._match_index_II(*args):
      return self._index_II(*args)
    elif mosek_fusion_BaseVariable._match_alt_index_II(*args):
      return self._index_alt_II(*args)
    elif mosek_fusion_BaseVariable._match_index_III(*args):
      return self._index_III(*args)
    elif mosek_fusion_BaseVariable._match_alt_index_III(*args):
      return self._index_alt_III(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.index(int32)\n\tmosek.fusion.BaseVariable.index(array(int32,ndim=1))\n\tmosek.fusion.BaseVariable.index(int32,int32)\n\tmosek.fusion.BaseVariable.index(int32,int32,int32)')
  def remove(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.remove()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_remove_(*args):
      return self._remove_(*args)
    elif mosek_fusion_BaseVariable._match_alt_remove_(*args):
      return self._remove_alt_(*args)
    else:
      raise ValueError('Invalid argument list remove('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.remove()')
  def getND(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.getND()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_getND_(*args):
      return self._getND_(*args)
    elif mosek_fusion_BaseVariable._match_alt_getND_(*args):
      return self._getND_alt_(*args)
    else:
      raise ValueError('Invalid argument list getND('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.getND()')
  def dual(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.dual()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_dual_(*args):
      return self._dual_(*args)
    elif mosek_fusion_BaseVariable._match_alt_dual_(*args):
      return self._dual_alt_(*args)
    else:
      raise ValueError('Invalid argument list dual('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.dual()')
  def reshape(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.reshape(array(int32,ndim=1))
      mosek.fusion.BaseVariable.reshape(int32)
      mosek.fusion.BaseVariable.reshape(int32,int32)
      mosek.fusion.BaseVariable.reshape(int32,int32,int32)

    Description
    -----------

    

    Parameters
    ----------

    dim0 : int32
    dim1 : int32
    dim2 : int32
    shape : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_reshape__3I(*args):
      return self._reshape__3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_reshape__3I(*args):
      return self._reshape_alt__3I(*args)
    elif mosek_fusion_BaseVariable._match_reshape_I(*args):
      return self._reshape_I(*args)
    elif mosek_fusion_BaseVariable._match_alt_reshape_I(*args):
      return self._reshape_alt_I(*args)
    elif mosek_fusion_BaseVariable._match_reshape_II(*args):
      return self._reshape_II(*args)
    elif mosek_fusion_BaseVariable._match_alt_reshape_II(*args):
      return self._reshape_alt_II(*args)
    elif mosek_fusion_BaseVariable._match_reshape_III(*args):
      return self._reshape_III(*args)
    elif mosek_fusion_BaseVariable._match_alt_reshape_III(*args):
      return self._reshape_alt_III(*args)
    else:
      raise ValueError('Invalid argument list reshape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.reshape(array(int32,ndim=1))\n\tmosek.fusion.BaseVariable.reshape(int32)\n\tmosek.fusion.BaseVariable.reshape(int32,int32)\n\tmosek.fusion.BaseVariable.reshape(int32,int32,int32)')
  def makeInteger(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.makeInteger()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_makeInteger_(*args):
      return self._makeInteger_(*args)
    elif mosek_fusion_BaseVariable._match_alt_makeInteger_(*args):
      return self._makeInteger_alt_(*args)
    else:
      raise ValueError('Invalid argument list makeInteger('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.makeInteger()')
  def eval(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.eval(mosek.fusion.WorkStack,mosek.fusion.WorkStack,mosek.fusion.WorkStack)
      mosek.fusion.BaseVariable.eval(mosek.fusion.WorkStack,mosek.fusion.WorkStack,mosek.fusion.WorkStack,bool)

    Description
    -----------

    

    Parameters
    ----------

    cache_eval : bool
    rs : mosek.fusion.WorkStack
    ws : mosek.fusion.WorkStack
    xs : mosek.fusion.WorkStack
    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args):
      return self._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args)
    elif mosek_fusion_BaseVariable._match_alt_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args):
      return self._eval_alt_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args)
    elif mosek_fusion_BaseVariable._match_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args):
      return self._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args)
    elif mosek_fusion_BaseVariable._match_alt_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args):
      return self._eval_alt_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args)
    else:
      raise ValueError('Invalid argument list eval('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.eval(mosek.fusion.WorkStack,mosek.fusion.WorkStack,mosek.fusion.WorkStack)\n\tmosek.fusion.BaseVariable.eval(mosek.fusion.WorkStack,mosek.fusion.WorkStack,mosek.fusion.WorkStack,bool)')
  def setLevel(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.setLevel(array(double,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    v : array(double,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_setLevel__3D(*args):
      return self._setLevel__3D(*args)
    elif mosek_fusion_BaseVariable._match_alt_setLevel__3D(*args):
      return self._setLevel_alt__3D(*args)
    else:
      raise ValueError('Invalid argument list setLevel('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.setLevel(array(double,ndim=1))')
  def make_continuous(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.make_continuous()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_make_1continuous_(*args):
      return self._make_1continuous_(*args)
    elif mosek_fusion_BaseVariable._match_alt_make_1continuous_(*args):
      return self._make_1continuous_alt_(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.make_continuous()')
  def getShape(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.getShape()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_getShape_(*args):
      return self._getShape_(*args)
    elif mosek_fusion_BaseVariable._match_alt_getShape_(*args):
      return self._getShape_alt_(*args)
    else:
      raise ValueError('Invalid argument list getShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.getShape()')
  def pick(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.pick(array(int32,ndim=1))
      mosek.fusion.BaseVariable.pick(array(int32,ndim=2))
      mosek.fusion.BaseVariable.pick(array(int32,ndim=1),array(int32,ndim=1))
      mosek.fusion.BaseVariable.pick(array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))

    Description
    -----------

    Create a one-dimensional variable by picking a list of indexes from this variable. 

    Parameters
    ----------

    i0 : array(int32,ndim=1)
        Index along the first dimension.
    i1 : array(int32,ndim=1)
        Index along the second dimension.
    i2 : array(int32,ndim=1)
        Index along the third dimension.
    idxs : array(int32,ndim=1)
        Indexes of the elements requested.
    midxs : array(int32,ndim=2)
        A sequence of multi-dimensional indexes of the elements requested.
    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_pick__3I(*args):
      return self._pick__3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_pick__3I(*args):
      return self._pick_alt__3I(*args)
    elif mosek_fusion_BaseVariable._match_pick__3_5I(*args):
      return self._pick__3_5I(*args)
    elif mosek_fusion_BaseVariable._match_alt_pick__3_5I(*args):
      return self._pick_alt__3_5I(*args)
    elif mosek_fusion_BaseVariable._match_pick__3I_3I(*args):
      return self._pick__3I_3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_pick__3I_3I(*args):
      return self._pick_alt__3I_3I(*args)
    elif mosek_fusion_BaseVariable._match_pick__3I_3I_3I(*args):
      return self._pick__3I_3I_3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_pick__3I_3I_3I(*args):
      return self._pick_alt__3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list pick('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.pick(array(int32,ndim=1))\n\tmosek.fusion.BaseVariable.pick(array(int32,ndim=2))\n\tmosek.fusion.BaseVariable.pick(array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.BaseVariable.pick(array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def recursive_eval(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.recursive_eval(mosek.fusion.WorkStack,mosek.fusion.WorkStack,mosek.fusion.WorkStack,bool)

    Description
    -----------

    

    Parameters
    ----------

    cache_eval : bool
    rs : mosek.fusion.WorkStack
    ws : mosek.fusion.WorkStack
    xs : mosek.fusion.WorkStack
    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args):
      return self._recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args)
    elif mosek_fusion_BaseVariable._match_alt_recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args):
      return self._recursive_1eval_alt_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args)
    else:
      raise ValueError('Invalid argument list recursive_eval('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.recursive_eval(mosek.fusion.WorkStack,mosek.fusion.WorkStack,mosek.fusion.WorkStack,bool)')
  def make_integer(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.make_integer()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_make_1integer_(*args):
      return self._make_1integer_(*args)
    elif mosek_fusion_BaseVariable._match_alt_make_1integer_(*args):
      return self._make_1integer_alt_(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.make_integer()')
  def level(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.level()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_level_(*args):
      return self._level_(*args)
    elif mosek_fusion_BaseVariable._match_alt_level_(*args):
      return self._level_alt_(*args)
    else:
      raise ValueError('Invalid argument list level('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.level()')
  def toString(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.toString()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_BaseVariable._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.toString()')
  def compress_when_caching(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.compress_when_caching()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_compress_1when_1caching_(*args):
      return self._compress_1when_1caching_(*args)
    elif mosek_fusion_BaseVariable._match_alt_compress_1when_1caching_(*args):
      return self._compress_1when_1caching_alt_(*args)
    else:
      raise ValueError('Invalid argument list compress_when_caching('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.compress_when_caching()')
  def getDim(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.getDim(int32)

    Description
    -----------

    

    Parameters
    ----------

    d : int32
    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_getDim_I(*args):
      return self._getDim_I(*args)
    elif mosek_fusion_BaseVariable._match_alt_getDim_I(*args):
      return self._getDim_alt_I(*args)
    else:
      raise ValueError('Invalid argument list getDim('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.getDim(int32)')
  def transpose(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.transpose()

    Description
    -----------

    Transpose the variable.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_transpose_(*args):
      return self._transpose_(*args)
    elif mosek_fusion_BaseVariable._match_alt_transpose_(*args):
      return self._transpose_alt_(*args)
    else:
      raise ValueError('Invalid argument list transpose('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.transpose()')
  def inst(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.inst(int32,array(int64,ndim=1))
      mosek.fusion.BaseVariable.inst(int32,array(int64,ndim=1),int32,array(int64,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    basevar_nativeidxs : array(int64,ndim=1)
    nindex : array(int64,ndim=1)
    nioffset : int32
    offset : int32
    sparsity : array(int64,ndim=1)
    spoffset : int32
    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_inst_I_3J(*args):
      return self._inst_I_3J(*args)
    elif mosek_fusion_BaseVariable._match_alt_inst_I_3J(*args):
      return self._inst_alt_I_3J(*args)
    elif mosek_fusion_BaseVariable._match_inst_I_3JI_3J(*args):
      return self._inst_I_3JI_3J(*args)
    elif mosek_fusion_BaseVariable._match_alt_inst_I_3JI_3J(*args):
      return self._inst_alt_I_3JI_3J(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.inst(int32,array(int64,ndim=1))\n\tmosek.fusion.BaseVariable.inst(int32,array(int64,ndim=1),int32,array(int64,ndim=1))')
  def asExpr(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.asExpr()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_asExpr_(*args):
      return self._asExpr_(*args)
    elif mosek_fusion_BaseVariable._match_alt_asExpr_(*args):
      return self._asExpr_alt_(*args)
    else:
      raise ValueError('Invalid argument list asExpr('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.asExpr()')
  def getSize(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.getSize()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_getSize_(*args):
      return self._getSize_(*args)
    elif mosek_fusion_BaseVariable._match_alt_getSize_(*args):
      return self._getSize_alt_(*args)
    else:
      raise ValueError('Invalid argument list getSize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.getSize()')
  def numInst(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.numInst()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_numInst_(*args):
      return self._numInst_(*args)
    elif mosek_fusion_BaseVariable._match_alt_numInst_(*args):
      return self._numInst_alt_(*args)
    else:
      raise ValueError('Invalid argument list numInst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.numInst()')
  def fromTril(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.fromTril(int32)
      mosek.fusion.BaseVariable.fromTril(int32,int32)

    Description
    -----------

    Convert from a trilinear representation into a square variable. 

    Parameters
    ----------

    d : int32
        Dimension of the square variable. 
    dim0 : int32
        Index of the trilinear variable slices in a multi-dimensional representation. 
    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_fromTril_I(*args):
      return self._fromTril_I(*args)
    elif mosek_fusion_BaseVariable._match_alt_fromTril_I(*args):
      return self._fromTril_alt_I(*args)
    elif mosek_fusion_BaseVariable._match_fromTril_II(*args):
      return self._fromTril_II(*args)
    elif mosek_fusion_BaseVariable._match_alt_fromTril_II(*args):
      return self._fromTril_alt_II(*args)
    else:
      raise ValueError('Invalid argument list fromTril('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.fromTril(int32)\n\tmosek.fusion.BaseVariable.fromTril(int32,int32)')
  def values(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.values(int32,array(double,ndim=1),bool)

    Description
    -----------

    

    Parameters
    ----------

    offset : int32
    primal : bool
    target : array(double,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_values_I_3DZ(*args):
      return self._values_I_3DZ(*args)
    elif mosek_fusion_BaseVariable._match_alt_values_I_3DZ(*args):
      return self._values_alt_I_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.values(int32,array(double,ndim=1),bool)')
  def tril(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BaseVariable.tril()
      mosek.fusion.BaseVariable.tril(int32,int32)

    Description
    -----------

    Convert from a square variable to a trilinear representation. 

    Parameters
    ----------

    dim1 : int32
        First dimension in the current shape containing the square variables. 
    dim2 : int32
        Second dimension in the current shape containing the square variables. 
    '''
    if False: pass
    elif mosek_fusion_BaseVariable._match_tril_(*args):
      return self._tril_(*args)
    elif mosek_fusion_BaseVariable._match_alt_tril_(*args):
      return self._tril_alt_(*args)
    elif mosek_fusion_BaseVariable._match_tril_II(*args):
      return self._tril_II(*args)
    elif mosek_fusion_BaseVariable._match_alt_tril_II(*args):
      return self._tril_alt_II(*args)
    else:
      raise ValueError('Invalid argument list tril('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.tril()\n\tmosek.fusion.BaseVariable.tril(int32,int32)')
  def __repr__(self): return 'mosek.fusion.BaseVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = BaseVariable.__new__(BaseVariable)
    o._ctor_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4BaseVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4BaseVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   self.__model = m
   self.__shape = (v.__shape)
   self.__sparsity = (v.__sparsity)
   self.__basevar_nativeidxs = (v.__basevar_nativeidxs)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(m,shape,sparsity,basevar_nativeidxs):
    o = BaseVariable.__new__(BaseVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(m,shape,sparsity,basevar_nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(*args):
    if len(args) != 4: return False
    m,shape,sparsity,basevar_nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(m) and __arg_match__3I__(shape) and __arg_match__3J__(sparsity) and __arg_match__3J__(basevar_nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(*args):
    if len(args) != 4: return False
    m,shape,sparsity,basevar_nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(m) and __arg_alt_match__3I__(shape) and __arg_alt_match__3J__(sparsity) and __arg_alt_match__3J__(basevar_nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2_3I_3J_3J(self,m,shape,sparsity,basevar_nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(m,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(sparsity,dtype=numpy.dtype(numpy.int64)),numpy.array(basevar_nativeidxs,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(self,m,shape,sparsity,basevar_nativeidxs):
   self.__model = m
   (self.__shape) = shape
   (self.__sparsity) = sparsity
   (self.__basevar_nativeidxs) = basevar_nativeidxs
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _a_0=mosek.fusion.Utils.StringBuffer()
   _a_0._a_S("Variable((")
   if (int((self.__shape).shape[0]) > 0):
    _a_0._a_I(self.__shape[0])
    for _a_1 in range(1,int((self.__shape).shape[0])):
     _a_0._a_S(",")._a_I(self.__shape[_a_1])
   _a_0._a_S("))")
   return (_a_0._toString_())
  @staticmethod
  def _match_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_Lmosek_4fusion_4WorkStack_2__(_a_0) and __arg_match_Lmosek_4fusion_4WorkStack_2__(_a_1) and __arg_match_Lmosek_4fusion_4WorkStack_2__(_a_2) and __arg_match_Z__(_a_3))
  @staticmethod
  def _match_alt_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_2) and __arg_alt_match_Z__(_a_3))
  def _eval_alt_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3):
    return self._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(_a_0,_a_1,_a_2,_a_3)
  def _eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(self,_a_0,_a_1,_a_2,_a_3):
   _a_4=int((self.__basevar_nativeidxs).shape[0])
   _a_5=_a_4
   _a_6=int((self.__shape).shape[0])
   _a_7=(self.__sparsity is not None)
   _a_0._alloc_1expr_IIIZ(_a_6,_a_5,_a_4,_a_7)
   _a_8=(_a_0.ptr_base)
   _a_9=(_a_0.nidxs_base)
   _a_10=(_a_0.sp_base)
   _a_11=(_a_0.cof_base)
   _a_12=(_a_0.shape_base)
   _a_13=(_a_0.i32)
   _a_14=(_a_0.i64)
   _a_15=(_a_0.f64)
   fragments._c_closure_145(_a_6,_a_13,self.__shape,_a_12) 
   fragments._c_closure_146(self.__basevar_nativeidxs,_a_11,_a_7,_a_9,_a_4,_a_8,_a_15,_a_13,_a_14,_a_10,self.__sparsity) 
  @staticmethod
  def _match_compress_1when_1caching_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_compress_1when_1caching_(*args):
    if len(args) != 0: return False
    return True
  def _compress_1when_1caching_alt_(self,):
    return self._compress_1when_1caching_()
  def _compress_1when_1caching_(self,):
   return (False)
  @staticmethod
  def _match_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_Lmosek_4fusion_4WorkStack_2__(_a_0) and __arg_match_Lmosek_4fusion_4WorkStack_2__(_a_1) and __arg_match_Lmosek_4fusion_4WorkStack_2__(_a_2))
  @staticmethod
  def _match_alt_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_2))
  def _eval_alt_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(self,_t__a_0,_t__a_1,_t__a_2):
    return self._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(_a_0,_a_1,_a_2)
  def _eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(self,_a_0,_a_1,_a_2):
   self._recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(_a_0,_a_1,_a_2,False)
  @staticmethod
  def _match_recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_Lmosek_4fusion_4WorkStack_2__(_a_0) and __arg_match_Lmosek_4fusion_4WorkStack_2__(_a_1) and __arg_match_Lmosek_4fusion_4WorkStack_2__(_a_2) and __arg_match_Z__(_a_3))
  @staticmethod
  def _match_alt_recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_a_2) and __arg_alt_match_Z__(_a_3))
  def _recursive_1eval_alt_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3):
    return self._recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(_a_0,_a_1,_a_2,_a_3)
  def _recursive_1eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(self,_a_0,_a_1,_a_2,_a_3):
   self._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Z(_a_0,_a_1,_a_2,_a_3)
  @staticmethod
  def _match_remove_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_remove_(*args):
    if len(args) != 0: return False
    return True
  def _remove_alt_(self,):
    return self._remove_()
  def _remove_(self,):
   raise mosek_fusion_DeletionError._ctor_S("Only original variables can be removed")
  @staticmethod
  def _match_fromTril_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_fromTril_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1))
  def _fromTril_alt_II(self,_t__a_0,_t__a_1):
    return self._fromTril_II(numpy.int32(__a_0),numpy.int32(__a_1))
  def _fromTril_II(self,_a_0,_a_1):
   if ((_a_0 < 0) or (_a_0 >= int((self.__shape).shape[0]))):
    raise mosek_fusion_DimensionError._ctor_S("Invalid dimension")
   elif (self.__shape[_a_0]!=((_a_1 * (_a_1 + 1)) // 2)):
    raise mosek_fusion_DimensionError._ctor_S("Invalid shape for operation")
   _a_2=1
   _a_2 = fragments._c_closure_147(_a_2,_a_0,self.__shape)
   _a_2 = numpy.int32(_a_2) # postprocess
   _a_3=self.__shape[_a_0]
   _a_4=1
   _a_4 = fragments._c_closure_148(_a_4,_a_0,self.__shape)
   _a_4 = numpy.int32(_a_4) # postprocess
   _a_5=numpy.zeros(((int((self.__shape).shape[0]) + 1),), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_149(_a_0,_a_5,self.__shape) 
   _a_5[_a_0] = _a_1
   _a_5[(_a_0 + 1)] = _a_1
   fragments._c_closure_150(_a_0,_a_5,self.__shape) 
   if (self.__sparsity is None):
    _a_6=numpy.zeros(((((_a_2 * _a_1) * _a_1) * _a_4),), dtype=numpy.dtype(numpy.int64))
    _a_7=0
    _a_7 = fragments._c_closure_151(self.__basevar_nativeidxs,_a_1,_a_2,_a_3,_a_4,_a_6,_a_7)
    _a_7 = numpy.int32(_a_7) # postprocess
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),_a_5,None,_a_6))
   else:
    _a_8=0
    for _a_9 in range(0,int((self.__sparsity).shape[0])):
     _a_10=((self.__sparsity[_a_9] // _a_4) % _a_3)
     _a_11=numpy.int32((((- 1) + mosek.fusion.Utils.Tools._sqrt_D(((1 + (2 * _a_10)) * (1 + (2 * _a_10))))) / 4))
     _a_12=(self.__sparsity[_a_9] - ((_a_11 * (_a_11 + 1)) // 2))
     if (_a_11==_a_12):
      _a_8 += 1
     else:
      _a_8 += 2
    _a_13=numpy.zeros((_a_8,), dtype=numpy.dtype(numpy.int64))
    _a_14=numpy.zeros((_a_8,), dtype=numpy.dtype(numpy.int64))
    _a_15=numpy.zeros((_a_8,), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_152(_a_8,_a_15) 
    _a_16=0
    for _a_17 in range(0,int((self.__sparsity).shape[0])):
     _a_18=(self.__sparsity[_a_17] // (_a_3 * _a_4))
     _a_19=((self.__sparsity[_a_17] // _a_4) % _a_3)
     _a_20=(self.__sparsity[_a_17] % _a_4)
     _a_21=numpy.int32((((- 1) + mosek.fusion.Utils.Tools._sqrt_D(((1 + (2 * _a_19)) * (1 + (2 * _a_19))))) / 4))
     _a_22=(self.__sparsity[_a_17] - ((_a_21 * (_a_21 + 1)) // 2))
     if (_a_21==_a_22):
      _a_13[_a_16] = self.__basevar_nativeidxs[_a_17]
      _a_14[_a_16] = (((((_a_18 * _a_1) * _a_1) * _a_4) + (((_a_21 * _a_1) + _a_22) * _a_4)) + _a_20)
      _a_16 += 1
     else:
      _a_13[_a_16] = self.__basevar_nativeidxs[_a_17]
      _a_13[(_a_16 + 1)] = self.__basevar_nativeidxs[_a_17]
      _a_14[_a_16] = (((((_a_18 * _a_1) * _a_1) * _a_4) + (((_a_21 * _a_1) + _a_22) * _a_4)) + _a_20)
      _a_14[(_a_16 + 1)] = (((((_a_18 * _a_1) * _a_1) * _a_4) + (((_a_22 * _a_1) + _a_21) * _a_4)) + _a_20)
      _a_16 += 2
    mosek.fusion.CommonTools._argQsort__3J_3J_3JJJ(_a_15,_a_13,None,0,_a_8)
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),_a_5,numpy.array([_a_14[_a_15[_a_23]] for _a_23 in range(0,_a_8)], dtype=numpy.dtype(numpy.int64)),numpy.array([_a_13[_a_15[_a_24]] for _a_24 in range(0,_a_8)], dtype=numpy.dtype(numpy.int64))))
  @staticmethod
  def _match_fromTril_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_fromTril_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _fromTril_alt_I(self,_t__a_0):
    return self._fromTril_I(numpy.int32(__a_0))
  def _fromTril_I(self,_a_0):
   return (self._fromTril_II(0,_a_0))
  @staticmethod
  def _match_tril_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_tril_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1))
  def _tril_alt_II(self,_t__a_0,_t__a_1):
    return self._tril_II(numpy.int32(__a_0),numpy.int32(__a_1))
  def _tril_II(self,_a_0,_a_1):
   if ((_a_0 < 0) or ((_a_0 >= _a_1) or (_a_1 >= int((self.__shape).shape[0])))):
    raise mosek_fusion_DimensionError._ctor_S("Invalid dimension specification")
   else:
    if (self.__shape[_a_0]!=self.__shape[_a_1]):
     raise mosek_fusion_DimensionError._ctor_S("Operation only valid for square variables")
   _a_2=numpy.zeros(((int((self.__shape).shape[0]) - 1),), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_153(_a_0,_a_2,self.__shape) 
   _a_2[_a_0] = ((self.__shape[_a_0] * (self.__shape[_a_0] + 1)) // 2)
   fragments._c_closure_154(_a_0,_a_1,_a_2,self.__shape) 
   fragments._c_closure_155(_a_1,_a_2,self.__shape) 
   if (self.__sparsity is None):
    _a_3=1
    _a_3 = fragments._c_closure_156(_a_3,_a_0,self.__shape)
    _a_3 = numpy.int32(_a_3) # postprocess
    _a_4=self.__shape[_a_0]
    _a_5=1
    _a_5 = fragments._c_closure_157(_a_5,_a_0,_a_1,self.__shape)
    _a_5 = numpy.int32(_a_5) # postprocess
    _a_6=self.__shape[_a_1]
    _a_7=1
    _a_7 = fragments._c_closure_158(_a_7,_a_1,self.__shape)
    _a_7 = numpy.int32(_a_7) # postprocess
    _a_8=numpy.zeros(((((((_a_3 * _a_5) * _a_7) * _a_4) * (_a_4 + 1)) // 2),), dtype=numpy.dtype(numpy.int64))
    _a_9=0
    _a_9 = fragments._c_closure_159(self.__basevar_nativeidxs,_a_3,_a_4,_a_5,_a_6,_a_7,_a_9,_a_8)
    _a_9 = numpy.int32(_a_9) # postprocess
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),_a_2,None,_a_8))
   else:
    _a_10=1
    _a_10 = fragments._c_closure_160(_a_10,_a_0,self.__shape)
    _a_10 = numpy.int32(_a_10) # postprocess
    _a_11=self.__shape[_a_0]
    _a_12=1
    _a_12 = fragments._c_closure_161(_a_12,_a_0,_a_1,self.__shape)
    _a_12 = numpy.int32(_a_12) # postprocess
    _a_13=self.__shape[_a_1]
    _a_14=1
    _a_14 = fragments._c_closure_162(_a_14,_a_1,self.__shape)
    _a_14 = numpy.int32(_a_14) # postprocess
    _a_15=1
    _a_16=_a_14
    _a_17=(_a_16 * _a_13)
    _a_18=(_a_17 * _a_12)
    _a_19=(_a_18 * _a_11)
    _a_20=0
    _a_20 = fragments._c_closure_163(_a_11,_a_13,_a_20,_a_18,_a_16,self.__sparsity)
    _a_20 = numpy.int32(_a_20) # postprocess
    _a_21=1
    _a_22=_a_14
    _a_23=(_a_22 * _a_12)
    _a_24=(((_a_23 * _a_11) * (_a_11 + 1)) // 2)
    _a_25=numpy.zeros((_a_20,), dtype=numpy.dtype(numpy.int64))
    _a_26=numpy.zeros((_a_20,), dtype=numpy.dtype(numpy.int64))
    _a_27=numpy.zeros((_a_20,), dtype=numpy.dtype(numpy.int64))
    _a_28=0
    _a_28 = fragments._c_closure_164(self.__basevar_nativeidxs,_a_11,_a_12,_a_13,_a_14,_a_28,_a_20,_a_25,_a_26,_a_24,_a_23,_a_22,_a_21,_a_27,_a_19,_a_18,_a_17,_a_16,_a_15,self.__sparsity)
    _a_28 = numpy.int32(_a_28) # postprocess
    mosek.fusion.CommonTools._argQsort__3J_3J_3JJJ(_a_25,_a_26,None,0,_a_20)
    _a_29=numpy.zeros((_a_20,), dtype=numpy.dtype(numpy.int64))
    _a_30=numpy.zeros((_a_20,), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_165(_a_20,_a_29,_a_25,_a_26) 
    fragments._c_closure_166(_a_20,_a_25,_a_27,_a_30) 
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),_a_2,_a_30,_a_29))
  @staticmethod
  def _match_tril_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_tril_(*args):
    if len(args) != 0: return False
    return True
  def _tril_alt_(self,):
    return self._tril_()
  def _tril_(self,):
   return (self._tril_II(0,1))
  @staticmethod
  def _match_reshape_III(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1) and __arg_match_I__(_a_2))
  @staticmethod
  def _match_alt_reshape_III(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_I__(_a_2))
  def _reshape_alt_III(self,_t__a_0,_t__a_1,_t__a_2):
    return self._reshape_III(numpy.int32(__a_0),numpy.int32(__a_1),numpy.int32(__a_2))
  def _reshape_III(self,_a_0,_a_1,_a_2):
   return (self._reshape__3I(numpy.array([_a_0,_a_1,_a_2], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_reshape_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_reshape_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1))
  def _reshape_alt_II(self,_t__a_0,_t__a_1):
    return self._reshape_II(numpy.int32(__a_0),numpy.int32(__a_1))
  def _reshape_II(self,_a_0,_a_1):
   return (self._reshape__3I(numpy.array([_a_0,_a_1], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_reshape_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_reshape_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _reshape_alt_I(self,_t__a_0):
    return self._reshape_I(numpy.int32(__a_0))
  def _reshape_I(self,_a_0):
   return (self._reshape__3I(numpy.array([_a_0], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_reshape__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_reshape__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _reshape_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._reshape__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _reshape__3I(self,_a_0):
   _a_1=1
   for _a_2 in range(0,int((_a_0).shape[0])):
    if (_a_0[_a_2] < 0):
     raise mosek_fusion_DimensionError._ctor_S("Invalid shape")
    _a_1 *= _a_0[_a_2]
   if (_a_1!=self._getSize_()):
    raise mosek_fusion_LengthError._ctor_S("Shape size does not match variable size")
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),numpy.array([_a_0[_a_3] for _a_3 in range(0,int((_a_0).shape[0]))], dtype=numpy.dtype(numpy.int32)),self.__sparsity,self.__basevar_nativeidxs))
  @staticmethod
  def _match_setLevel__3D(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3D__(_a_0))
  @staticmethod
  def _match_alt_setLevel__3D(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3D__(_a_0))
  def _setLevel_alt__3D(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.float64))
   _1_res = self._setLevel__3D(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _setLevel__3D(self,_a_0):
   if (self.__sparsity is None):
    if (int((_a_0).shape[0])!=int((self.__basevar_nativeidxs).shape[0])):
     raise mosek_fusion_LengthError._ctor_S("Invalid length of solution values vector")
    self.__model._setVariableValues_Z_3J_3D(True,self.__basevar_nativeidxs,_a_0)
   else:
    if (int((_a_0).shape[0])!=self._getSize_()):
     raise mosek_fusion_LengthError._ctor_S("Invalid length of solution values vector")
    _a_1=numpy.array([_a_0[self.__sparsity[_a_2]] for _a_2 in range(0,int((self.__basevar_nativeidxs).shape[0]))], dtype=numpy.dtype(numpy.float64))
    self.__model._setVariableValues_Z_3J_3D(True,self.__basevar_nativeidxs,_a_1)
  @staticmethod
  def _match_getModel_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getModel_(*args):
    if len(args) != 0: return False
    return True
  def _getModel_alt_(self,):
    return self._getModel_()
  def _getModel_(self,):
   return (self.__model)
  @staticmethod
  def _match_getND_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getND_(*args):
    if len(args) != 0: return False
    return True
  def _getND_alt_(self,):
    return self._getND_()
  def _getND_(self,):
   return numpy.int32(int((self.__shape).shape[0]))
  @staticmethod
  def _match_getDim_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_getDim_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _getDim_alt_I(self,_t__a_0):
    return self._getDim_I(numpy.int32(__a_0))
  def _getDim_I(self,_a_0):
   return numpy.int32(self.__shape[_a_0])
  @staticmethod
  def _match_getShape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getShape_(*args):
    if len(args) != 0: return False
    return True
  def _getShape_alt_(self,):
    return self._getShape_()
  def _getShape_(self,):
   return (mosek.fusion.Utils.Tools._arraycopy__3I(self.__shape))
  @staticmethod
  def _match_getSize_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getSize_(*args):
    if len(args) != 0: return False
    return True
  def _getSize_alt_(self,):
    return self._getSize_()
  def _getSize_(self,):
   _a_0=1
   _a_0 = fragments._c_closure_167(self.__shape,_a_0)
   _a_0 = numpy.int64(_a_0) # postprocess
   return numpy.int64(_a_0)
  @staticmethod
  def _match_dual_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dual_(*args):
    if len(args) != 0: return False
    return True
  def _dual_alt_(self,):
    return self._dual_()
  def _dual_(self,):
   _a_0=numpy.zeros((int((self.__basevar_nativeidxs).shape[0]),), dtype=numpy.dtype(numpy.float64))
   self.__model._getVariableValues_Z_3J_3DI(False,self.__basevar_nativeidxs,_a_0,0)
   if (self.__sparsity is not None):
    _a_1=numpy.zeros((self._getSize_(),), dtype=numpy.dtype(numpy.float64))
    fragments._c_closure_168(self.__basevar_nativeidxs,_a_0,self.__sparsity,_a_1) 
    _a_0 = _a_1
   return (_a_0)
  @staticmethod
  def _match_level_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_level_(*args):
    if len(args) != 0: return False
    return True
  def _level_alt_(self,):
    return self._level_()
  def _level_(self,):
   _a_0=numpy.zeros((int((self.__basevar_nativeidxs).shape[0]),), dtype=numpy.dtype(numpy.float64))
   self.__model._getVariableValues_Z_3J_3DI(True,self.__basevar_nativeidxs,_a_0,0)
   if (self.__sparsity is not None):
    _a_1=numpy.zeros((self._getSize_(),), dtype=numpy.dtype(numpy.float64))
    fragments._c_closure_169(self.__basevar_nativeidxs,_a_0,self.__sparsity,_a_1) 
    _a_0 = _a_1
   return (_a_0)
  @staticmethod
  def _match_makeContinuous_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_makeContinuous_(*args):
    if len(args) != 0: return False
    return True
  def _makeContinuous_alt_(self,):
    return self._makeContinuous_()
  def _makeContinuous_(self,):
   self._make_1continuous_()
  @staticmethod
  def _match_makeInteger_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_makeInteger_(*args):
    if len(args) != 0: return False
    return True
  def _makeInteger_alt_(self,):
    return self._makeInteger_()
  def _makeInteger_(self,):
   self._make_1integer_()
  @staticmethod
  def _match_transpose_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_transpose_(*args):
    if len(args) != 0: return False
    return True
  def _transpose_alt_(self,):
    return self._transpose_()
  def _transpose_(self,):
   if (int((self.__shape).shape[0])==1):
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),numpy.array([1,self.__shape[0]], dtype=numpy.dtype(numpy.int32)),self.__sparsity,self.__basevar_nativeidxs))
   elif (int((self.__shape).shape[0]) > 2):
    raise mosek_fusion_DimensionError._ctor_S("Invalid shape for operation")
   else:
    _a_0=numpy.zeros((int((self.__basevar_nativeidxs).shape[0]),), dtype=numpy.dtype(numpy.int64))
    _a_1=(None if ((self.__sparsity is None) ) else numpy.zeros((int((self.__basevar_nativeidxs).shape[0]),), dtype=numpy.dtype(numpy.int64)))
    fragments._c_closure_170(self.__basevar_nativeidxs,_a_0,self.__shape,_a_1,self.__sparsity) 
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),numpy.array([self.__shape[1],self.__shape[0]], dtype=numpy.dtype(numpy.int32)),_a_1,_a_0))
  @staticmethod
  def _match_index_III(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1) and __arg_match_I__(_a_2))
  @staticmethod
  def _match_alt_index_III(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_I__(_a_2))
  def _index_alt_III(self,_t__a_0,_t__a_1,_t__a_2):
    return self._index_III(numpy.int32(__a_0),numpy.int32(__a_1),numpy.int32(__a_2))
  def _index_III(self,_a_0,_a_1,_a_2):
   return (self._index__3I(numpy.array([_a_0,_a_1,_a_2], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_index_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_index_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1))
  def _index_alt_II(self,_t__a_0,_t__a_1):
    return self._index_II(numpy.int32(__a_0),numpy.int32(__a_1))
  def _index_II(self,_a_0,_a_1):
   return (self._index__3I(numpy.array([_a_0,_a_1], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _index_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._index__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _index__3I(self,_a_0):
   _a_1=numpy.zeros((1,int((_a_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_171(_a_0,_a_1) 
   return (self._pick__3_5I(_a_1)._reshape__3I(numpy.zeros((0,), dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _index_alt_I(self,_t__a_0):
    return self._index_I(numpy.int32(__a_0))
  def _index_I(self,_a_0):
   return (self._pick__3I(numpy.array([_a_0], dtype=numpy.dtype(numpy.int32)))._reshape__3I(numpy.zeros((0,), dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_pick__3I_3I_3I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3I__(_a_2))
  @staticmethod
  def _match_alt_pick__3I_3I_3I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3I__(_a_2))
  def _pick_alt__3I_3I_3I(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I_3I_3I(_a_0,_a_1,_a_2)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I_3I_3I(self,_a_0,_a_1,_a_2):
   if (int((self.__shape).shape[0])!=3):
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   if ((int((_a_0).shape[0])!=int((_a_1).shape[0])) or (int((_a_0).shape[0])!=int((_a_2).shape[0]))):
    raise mosek_fusion_LengthError._ctor_S("Mismatching argument lengths")
   _a_3=numpy.zeros((int((_a_0).shape[0]),3,), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_172(_a_0,_a_1,_a_2,_a_3) 
   return (self._pick__3_5I(_a_3))
  @staticmethod
  def _match_pick__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_pick__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1))
  def _pick_alt__3I_3I(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I_3I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I_3I(self,_a_0,_a_1):
   if ((int((self.__shape).shape[0])!=2) or (int((_a_0).shape[0])!=int((_a_1).shape[0]))):
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   _a_2=numpy.zeros((int((_a_0).shape[0]),2,), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_173(_a_0,_a_1,_a_2) 
   return (self._pick__3_5I(_a_2))
  @staticmethod
  def _match_pick__3_5I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3_5I__(_a_0))
  @staticmethod
  def _match_alt_pick__3_5I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3_5I__(_a_0))
  def _pick_alt__3_5I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,ndmin=_monty.checkShape(_t__a_0,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3_5I(_a_0)
   return _1_res
  def _pick__3_5I(self,_a_0):
   if (int((self.__shape).shape[0])!=int((_a_0).shape[1])):
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   _a_1=False
   _a_1 = fragments._c_closure_174(_a_1,_a_0,self.__shape)
   if _a_1:
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   _a_2=int((self.__shape).shape[0])
   _a_3=numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.int64))
   _a_3[(_a_2 - 1)] = 1
   fragments._c_closure_175(_a_2,self.__shape,_a_3) 
   _a_4=numpy.array([int((_a_0).shape[0])], dtype=numpy.dtype(numpy.int32))
   _a_6=None
   if (self.__sparsity is None):
    _a_5 = numpy.zeros((int((_a_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_176(self.__basevar_nativeidxs,_a_5,_a_0,_a_2,_a_3) 
   else:
    _a_7=0
    for _a_8 in range(0,int((_a_0).shape[0])):
     _a_9=0
     _a_9 = fragments._c_closure_177(_a_8,_a_9,_a_0,_a_2,_a_3)
     _a_9 = numpy.int64(_a_9) # postprocess
     if (mosek.fusion.CommonTools._binarySearch__3JJ(self.__sparsity,_a_9) >= 0):
      _a_7 += 1
    _a_5 = numpy.zeros((_a_7,), dtype=numpy.dtype(numpy.int64))
    _a_6 = numpy.zeros((_a_7,), dtype=numpy.dtype(numpy.int64))
    _a_10=0
    for _a_11 in range(0,int((_a_0).shape[0])):
     _a_12=0
     _a_12 = fragments._c_closure_178(_a_11,_a_12,_a_0,_a_2,_a_3)
     _a_12 = numpy.int64(_a_12) # postprocess
     _a_13=mosek.fusion.CommonTools._binarySearch__3JJ(self.__sparsity,_a_12)
     if (_a_13 >= 0):
      _a_5[_a_10] = self.__basevar_nativeidxs[_a_13]
      _a_6[_a_10] = _a_11
      _a_10 += 1
    if (_a_7==int((_a_0).shape[0])):
     _a_6 = None
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),_a_4,_a_6,_a_5))
  @staticmethod
  def _match_pick__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_pick__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _pick_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I(self,_a_0):
   if (int((self.__shape).shape[0])!=1):
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   _a_1=False
   _a_1 = fragments._c_closure_179(_a_0,_a_1,self.__shape)
   if _a_1:
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   _a_3=None
   if (self.__sparsity is None):
    _a_2 = numpy.array([self.__basevar_nativeidxs[_a_0[_a_4]] for _a_4 in range(0,int((_a_0).shape[0]))], dtype=numpy.dtype(numpy.int64))
   else:
    _a_5=0
    for _a_6 in range(0,int((_a_0).shape[0])):
     if (mosek.fusion.CommonTools._binarySearch__3JJ(self.__sparsity,_a_0[_a_6]) >= 0):
      _a_5 += 1
    _a_2 = numpy.zeros((_a_5,), dtype=numpy.dtype(numpy.int64))
    _a_3 = numpy.zeros((_a_5,), dtype=numpy.dtype(numpy.int64))
    _a_7=0
    for _a_8 in range(0,int((_a_0).shape[0])):
     _a_9=mosek.fusion.CommonTools._binarySearch__3JJ(self.__sparsity,_a_0[_a_8])
     if (_a_9 >= 0):
      _a_3[_a_7] = _a_8
      _a_2[_a_7] = self.__basevar_nativeidxs[_a_9]
      _a_7 += 1
    if (_a_5==int((_a_0).shape[0])):
     _a_3 = None
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),numpy.array([int((_a_0).shape[0])], dtype=numpy.dtype(numpy.int32)),_a_3,_a_2))
  @staticmethod
  def _match_antidiag_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_antidiag_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _antidiag_alt_I(self,_t__a_0):
    return self._antidiag_I(numpy.int32(__a_0))
  def _antidiag_I(self,_a_0):
   if (int((self.__shape).shape[0])!=2):
    raise mosek_fusion_DimensionError._ctor_S("antidiag() only works on two-dimensional objects")
   elif ((_a_0 >= self.__shape[1]) or ((- _a_0) >= self.__shape[2])):
    raise mosek_fusion_IndexError._ctor_S("Diagonal index out of bounds")
   if (_a_0 >= 0):
    return (self.__general_1diag__3I_3II(numpy.array([0,((self.__shape[1] - 1) - _a_0)], dtype=numpy.dtype(numpy.int32)),numpy.array([1,(- 1)], dtype=numpy.dtype(numpy.int32)),(self.__shape[0] if ((self.__shape[0] < (self.__shape[1] - _a_0)) ) else (self.__shape[1] - _a_0))))
   else:
    return (self.__general_1diag__3I_3II(numpy.array([(- _a_0),(self.__shape[1] - 1)], dtype=numpy.dtype(numpy.int32)),numpy.array([1,(- 1)], dtype=numpy.dtype(numpy.int32)),(self.__shape[1] if ((self.__shape[1] < (self.__shape[0] + _a_0)) ) else (self.__shape[0] + _a_0))))
  @staticmethod
  def _match_antidiag_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_antidiag_(*args):
    if len(args) != 0: return False
    return True
  def _antidiag_alt_(self,):
    return self._antidiag_()
  def _antidiag_(self,):
   if (int((self.__shape).shape[0])!=2):
    raise mosek_fusion_DimensionError._ctor_S("antidiag() only works on two-dimensional objects")
   return (self.__general_1diag__3I_3II(numpy.array([0,(self.__shape[1] - 1)], dtype=numpy.dtype(numpy.int32)),numpy.array([1,(- 1)], dtype=numpy.dtype(numpy.int32)),(self.__shape[0] if ((self.__shape[0] < self.__shape[1]) ) else self.__shape[1])))
  @staticmethod
  def _match_diag_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_diag_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _diag_alt_I(self,_t__a_0):
    return self._diag_I(numpy.int32(__a_0))
  def _diag_I(self,_a_0):
   if (int((self.__shape).shape[0])!=2):
    raise mosek_fusion_DimensionError._ctor_S("diag() only works on two-dimensional objects")
   elif ((_a_0 >= self.__shape[1]) or ((- _a_0) >= self.__shape[2])):
    raise mosek_fusion_IndexError._ctor_S("Diagonal index out of bounds")
   if (_a_0 >= 0):
    return (self.__general_1diag__3I_3II(numpy.array([0,_a_0], dtype=numpy.dtype(numpy.int32)),numpy.array([1,1], dtype=numpy.dtype(numpy.int32)),(self.__shape[0] if ((self.__shape[0] < (self.__shape[1] - _a_0)) ) else (self.__shape[1] - _a_0))))
   else:
    return (self.__general_1diag__3I_3II(numpy.array([(- _a_0),0], dtype=numpy.dtype(numpy.int32)),numpy.array([1,1], dtype=numpy.dtype(numpy.int32)),(self.__shape[1] if ((self.__shape[1] < (self.__shape[0] + _a_0)) ) else (self.__shape[0] + _a_0))))
  @staticmethod
  def _match_diag_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_diag_(*args):
    if len(args) != 0: return False
    return True
  def _diag_alt_(self,):
    return self._diag_()
  def _diag_(self,):
   if (int((self.__shape).shape[0])!=2):
    raise mosek_fusion_DimensionError._ctor_S("diag() only works on two-dimensional objects")
   return (self.__general_1diag__3I_3II(numpy.array([0,0], dtype=numpy.dtype(numpy.int32)),numpy.array([1,1], dtype=numpy.dtype(numpy.int32)),(self.__shape[0] if ((self.__shape[0] < self.__shape[1]) ) else self.__shape[1])))
  def __general_1diag_alt__3I_3II(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.int32(_t__a_2)
   _1_res = self.__general_1diag__3I_3II(_a_0,_a_1,_a_2)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __general_1diag__3I_3II(self,_a_0,_a_1,_a_2):
   _a_3=int((self.__shape).shape[0])
   if ((_a_3!=int((_a_0).shape[0])) or (_a_3!=int((_a_1).shape[0]))):
    raise mosek_fusion_DimensionError._ctor_S("Invalid start or step definition")
   for _a_4 in range(0,_a_3):
    if ((_a_0[_a_4] < 0) or (_a_0[_a_4] >= self.__shape[_a_4])):
     raise mosek_fusion_LengthError._ctor_S("Start element is out of bounds")
   _a_5=numpy.zeros((_a_3,), dtype=numpy.dtype(numpy.int64))
   _a_5[(_a_3 - 1)] = 1
   fragments._c_closure_180(_a_3,self.__shape,_a_5) 
   _a_6=0
   _a_6 = fragments._c_closure_181(_a_0,_a_6,_a_1,_a_5)
   _a_6 = numpy.int64(_a_6) # postprocess
   _a_7=0
   _a_7 = fragments._c_closure_182(_a_1,_a_7,_a_5)
   _a_7 = numpy.int64(_a_7) # postprocess
   if (self.__sparsity is None):
    _a_8=numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_183(self.__basevar_nativeidxs,_a_2,_a_8,_a_6,_a_7) 
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),numpy.array([_a_2], dtype=numpy.dtype(numpy.int32)),None,_a_8))
   else:
    _a_9=0
    for _a_10 in range(0,_a_2):
     _a_11=(_a_6 + (_a_7 * _a_10))
     _a_12=mosek.fusion.CommonTools._binarySearch__3JJ(self.__sparsity,_a_11)
     if (_a_12 >= 0):
      _a_9 += 1
    _a_13=numpy.zeros((_a_9,), dtype=numpy.dtype(numpy.int64))
    _a_14=numpy.zeros((_a_9,), dtype=numpy.dtype(numpy.int64))
    _a_15=0
    for _a_16 in range(0,_a_2):
     _a_13[_a_16] = self.__basevar_nativeidxs[(_a_6 + (_a_7 * _a_16))]
     _a_17=(_a_6 + (_a_7 * _a_16))
     _a_18=mosek.fusion.CommonTools._binarySearch__3JJ(self.__sparsity,_a_17)
     if (_a_18 >= 0):
      _a_14[_a_15] = _a_16
      _a_13[_a_15] = self.__basevar_nativeidxs[_a_18]
      _a_15 += 1
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),numpy.array([_a_2], dtype=numpy.dtype(numpy.int32)),_a_14,_a_13))
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1))
  def _slice_alt__3I_3I(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._slice__3I_3I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _slice__3I_3I(self,_a_0,_a_1):
   if (int((_a_0).shape[0])!=int((_a_1).shape[0])):
    raise mosek_fusion_SliceError._ctor_S("Invalid slice")
   elif (int((_a_0).shape[0])!=int((self.__shape).shape[0])):
    raise mosek_fusion_DimensionError._ctor_S("Variable shape and slice do not match")
   else:
    for _a_2 in range(0,int((self.__shape).shape[0])):
     if ((_a_0[_a_2] < 0) or (_a_1[_a_2] > self.__shape[_a_2])):
      raise mosek_fusion_IndexError._ctor_S("Slice is out of bounds")
     elif (_a_0[_a_2] > _a_1[_a_2]):
      raise mosek_fusion_SliceError._ctor_S("Invalid slice")
    _a_3=int((self.__shape).shape[0])
    _a_4=numpy.array([(_a_1[_a_5] - _a_0[_a_5]) for _a_5 in range(0,_a_3)], dtype=numpy.dtype(numpy.int32))
    _a_6=1
    _a_6 = fragments._c_closure_184(_a_0,_a_1,_a_3,_a_6)
    _a_6 = numpy.int32(_a_6) # postprocess
    if (_a_6==0):
     return (mosek_fusion_NilVariable._ctor_())
    elif (self.__sparsity is not None):
     _a_7=0
     _a_8=numpy.zeros((_a_3,), dtype=numpy.dtype(numpy.int32))
     _a_7 = fragments._c_closure_185(_a_0,_a_8,_a_1,_a_3,_a_7,self.__shape,self.__sparsity)
     _a_7 = numpy.int32(_a_7) # postprocess
     _a_9=0
     _a_10=numpy.zeros((_a_7,), dtype=numpy.dtype(numpy.int64))
     _a_11=numpy.zeros((_a_7,), dtype=numpy.dtype(numpy.int64))
     _a_9 = fragments._c_closure_186(self.__basevar_nativeidxs,_a_0,_a_9,_a_10,_a_8,_a_1,_a_3,self.__shape,_a_4,_a_11,self.__sparsity)
     _a_9 = numpy.int32(_a_9) # postprocess
     return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),_a_4,_a_11,_a_10))
    else:
     _a_12=numpy.zeros((_a_6,), dtype=numpy.dtype(numpy.int64))
     fragments._c_closure_187(self.__basevar_nativeidxs,_a_0,_a_1,_a_3,self.__shape,_a_12,_a_6) 
     return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),_a_4,None,_a_12))
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1))
  def _slice_alt_II(self,_t__a_0,_t__a_1):
    return self._slice_II(numpy.int32(__a_0),numpy.int32(__a_1))
  def _slice_II(self,_a_0,_a_1):
   if (int((self.__shape).shape[0])!=1):
    raise mosek_fusion_DimensionError._ctor_S("Variable shape and slice do not match")
   if ((_a_0==0) and (_a_1==self.__shape[0])):
    return (self)
   elif ((_a_0 < 0) or (_a_1 > self.__shape[0])):
    raise mosek_fusion_IndexError._ctor_S("Slice is out of bounds")
   elif (_a_0 > _a_1):
    raise mosek_fusion_SliceError._ctor_S("Invalid slice")
   elif (_a_0==_a_1):
    return (mosek_fusion_NilVariable._ctor_())
   elif (self.__sparsity is not None):
    _a_2=(_a_1 - _a_0)
    _a_3=0
    _a_4=mosek.fusion.CommonTools._binarySearchL__3JJ(self.__sparsity,_a_0)
    _a_5=mosek.fusion.CommonTools._binarySearchL__3JJ(self.__sparsity,_a_1)
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),numpy.array([_a_2], dtype=numpy.dtype(numpy.int32)),numpy.array([(self.__sparsity[_a_6] - _a_0) for _a_6 in range(_a_4,_a_5)], dtype=numpy.dtype(numpy.int64)),numpy.array([self.__basevar_nativeidxs[_a_7] for _a_7 in range(_a_4,_a_5)], dtype=numpy.dtype(numpy.int64))))
   else:
    _a_8=(_a_1 - _a_0)
    _a_9=numpy.zeros((_a_8,), dtype=numpy.dtype(numpy.int64))
    mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(self.__basevar_nativeidxs,_a_0,_a_9,0,_a_8)
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),numpy.array([_a_8], dtype=numpy.dtype(numpy.int32)),None,_a_9))
  @staticmethod
  def _match_asExpr_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_asExpr_(*args):
    if len(args) != 0: return False
    return True
  def _asExpr_alt_(self,):
    return self._asExpr_()
  def _asExpr_(self,):
   return (mosek_fusion_ExprFromVar._ctor_Lmosek_4fusion_4Variable_2(self))
  @staticmethod
  def _match_inst_I_3JI_3J(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_I__(_a_0) and __arg_match__3J__(_a_1) and __arg_match_I__(_a_2) and __arg_match__3J__(_a_3))
  @staticmethod
  def _match_alt_inst_I_3JI_3J(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match_I__(_a_2) and __arg_alt_match__3J__(_a_3))
  def _inst_alt_I_3JI_3J(self,_t__a_0,_t__a_1,_t__a_2,_t__a_3):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.int32(_t__a_2)
   _a_3=numpy.array(_t__a_3,dtype=numpy.dtype(numpy.int64))
   _1_res = self._inst_I_3JI_3J(_a_0,_a_1,_a_2,_a_3)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_3[:] = _a_3
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _inst_I_3JI_3J(self,_a_0,_a_1,_a_2,_a_3):
   _a_4=(self.__basevar_nativeidxs)
   _a_5=(self.__sparsity)
   if (_a_5 is None):
    fragments._c_closure_188(_a_3,_a_2,_a_1,_a_0,_a_4) 
   else:
    for _a_6 in range(0,int(((self.__sparsity)).shape[0])):
     _a_1[(_a_0 + _a_6)] = _a_5[_a_6]
     _a_3[(_a_6 + _a_2)] = _a_4[_a_6]
   return numpy.int32(int(((self.__basevar_nativeidxs)).shape[0]))
  @staticmethod
  def _match_numInst_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_numInst_(*args):
    if len(args) != 0: return False
    return True
  def _numInst_alt_(self,):
    return self._numInst_()
  def _numInst_(self,):
   return numpy.int32(int((self.__basevar_nativeidxs).shape[0]))
  @staticmethod
  def _match_inst_I_3J(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match__3J__(_a_1))
  @staticmethod
  def _match_alt_inst_I_3J(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match__3J__(_a_1))
  def _inst_alt_I_3J(self,_t__a_0,_t__a_1):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _1_res = self._inst_I_3J(_a_0,_a_1)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _inst_I_3J(self,_a_0,_a_1):
   if (self.__sparsity is None):
    fragments._c_closure_189(self.__basevar_nativeidxs,_a_1,_a_0) 
   else:
    _a_2=self._getShape_()
    _a_3=1
    _a_3 = fragments._c_closure_190(_a_3,_a_2)
    _a_3 = numpy.int32(_a_3) # postprocess
    fragments._c_closure_191(_a_3,_a_1,_a_0) 
    fragments._c_closure_192(self.__basevar_nativeidxs,_a_1,_a_0,self.__sparsity) 
  @staticmethod
  def _match_set_1values__3DZ(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3D__(_a_0) and __arg_match_Z__(_a_1))
  @staticmethod
  def _match_alt_set_1values__3DZ(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3D__(_a_0) and __arg_alt_match_Z__(_a_1))
  def _set_1values_alt__3DZ(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.float64))
   _a_1=_t__a_1
   _1_res = self._set_1values__3DZ(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _set_1values__3DZ(self,_a_0,_a_1):
   if (self.__sparsity is None):
    self._getModel_()._setVariableValues_Z_3J_3D(_a_1,self.__basevar_nativeidxs,_a_0)
   else:
    _a_2=1
    _a_2 = fragments._c_closure_193(self.__shape,_a_2)
    _a_2 = numpy.int32(_a_2) # postprocess
    _a_3=numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_194(self.__basevar_nativeidxs,_a_3,self.__sparsity) 
    self._getModel_()._setVariableValues_Z_3J_3D(_a_1,_a_3,_a_0)
  def _dual_1lu_alt_I_3DZ(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.float64))
   _a_2=_t__a_2
   _1_res = self._dual_1lu_I_3DZ(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _dual_1lu_I_3DZ(self,_a_0,_a_1,_a_2):
   if (self.__sparsity is None):
    self.__model._getVariableDuals_Z_3J_3DI(_a_2,self.__basevar_nativeidxs,_a_1,_a_0)
   else:
    _a_3=numpy.zeros((self._getSize_(),), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_195(self.__basevar_nativeidxs,_a_3,self.__sparsity) 
    self.__model._getVariableDuals_Z_3J_3DI(_a_2,_a_3,_a_1,_a_0)
  @staticmethod
  def _match_values_I_3DZ(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_I__(_a_0) and __arg_match__3D__(_a_1) and __arg_match_Z__(_a_2))
  @staticmethod
  def _match_alt_values_I_3DZ(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match__3D__(_a_1) and __arg_alt_match_Z__(_a_2))
  def _values_alt_I_3DZ(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.float64))
   _a_2=_t__a_2
   _1_res = self._values_I_3DZ(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _values_I_3DZ(self,_a_0,_a_1,_a_2):
   if (self.__sparsity is None):
    self.__model._getVariableValues_Z_3J_3DI(_a_2,self.__basevar_nativeidxs,_a_1,_a_0)
   else:
    _a_3=numpy.zeros((self._getSize_(),), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_196(self.__basevar_nativeidxs,_a_3,self.__sparsity) 
    self.__model._getVariableValues_Z_3J_3DI(_a_2,_a_3,_a_1,_a_0)
  @staticmethod
  def _match_make_1continuous_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_make_1continuous_(*args):
    if len(args) != 0: return False
    return True
  def _make_1continuous_alt_(self,):
    return self._make_1continuous_()
  def _make_1continuous_(self,):
   self._getModel_()._make_1continuous__3J(self.__basevar_nativeidxs)
  @staticmethod
  def _match_make_1integer_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_make_1integer_(*args):
    if len(args) != 0: return False
    return True
  def _make_1integer_alt_(self,):
    return self._make_1integer_()
  def _make_1integer_(self,):
   self._getModel_()._make_1integer__3J(self.__basevar_nativeidxs)
 return BaseVariable
mosek_fusion_BaseVariable=__mk_mosek_fusion_BaseVariable()
del __mk_mosek_fusion_BaseVariable
#BEFORE CLASS
def __mk_mosek_fusion_SliceVariable():
 class SliceVariable(mosek_fusion_BaseVariable):
  __slots__ = ['_SliceVariable__shape','_SliceVariable__sparsity','_SliceVariable__nativeidxs']
  def __repr__(self): return 'mosek.fusion.SliceVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(m,shape,sparsity,nativeidxs):
    o = SliceVariable.__new__(SliceVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(m,shape,sparsity,nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(*args):
    if len(args) != 4: return False
    m,shape,sparsity,nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(m) and __arg_match__3I__(shape) and __arg_match__3J__(sparsity) and __arg_match__3J__(nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(*args):
    if len(args) != 4: return False
    m,shape,sparsity,nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(m) and __arg_alt_match__3I__(shape) and __arg_alt_match__3J__(sparsity) and __arg_alt_match__3J__(nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2_3I_3J_3J(self,m,shape,sparsity,nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(m,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(sparsity,dtype=numpy.dtype(numpy.int64)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(self,m,shape,sparsity,nativeidxs):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(self,m,shape,sparsity,nativeidxs)
   (self.__nativeidxs) = nativeidxs
   (self.__sparsity) = sparsity
   (self.__shape) = shape
  @staticmethod
  def _ctor_Lmosek_4fusion_4SliceVariable_2(v):
    o = SliceVariable.__new__(SliceVariable)
    o._ctor_init_Lmosek_4fusion_4SliceVariable_2(v)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4SliceVariable_2(*args):
    if len(args) != 1: return False
    v, = args
    return (__arg_match_Lmosek_4fusion_4SliceVariable_2__(v))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4SliceVariable_2(*args):
    if len(args) != 1: return False
    v, = args
    return (__arg_alt_match_Lmosek_4fusion_4SliceVariable_2__(v))
  def _ctor_alt_init_Lmosek_4fusion_4SliceVariable_2(self,v):
    self._ctor_init_Lmosek_4fusion_4SliceVariable_2(v)
  def _ctor_init_Lmosek_4fusion_4SliceVariable_2(self,v):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(self,v,v._getModel_())
   (self.__nativeidxs) = (v.__nativeidxs)
   (self.__sparsity) = (v.__sparsity)
   (self.__shape) = (v.__shape)
 return SliceVariable
mosek_fusion_SliceVariable=__mk_mosek_fusion_SliceVariable()
del __mk_mosek_fusion_SliceVariable
#BEFORE CLASS
def __mk_mosek_fusion_BoundInterfaceVariable():
 class BoundInterfaceVariable(mosek_fusion_SliceVariable):
  __slots__ = ['_BoundInterfaceVariable__islower']
  def diag(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BoundInterfaceVariable.diag()
      mosek.fusion.BoundInterfaceVariable.diag(int32)

    Description
    -----------

    

    Parameters
    ----------

    index : int32
    '''
    if False: pass
    elif mosek_fusion_BoundInterfaceVariable._match_diag_(*args):
      return self._diag_(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_diag_(*args):
      return self._diag_alt_(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_diag_I(*args):
      return self._diag_I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_diag_I(*args):
      return self._diag_alt_I(*args)
    else:
      raise ValueError('Invalid argument list diag('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceVariable.diag()\n\tmosek.fusion.BoundInterfaceVariable.diag(int32)')
  def pick(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BoundInterfaceVariable.pick(array(int32,ndim=1))
      mosek.fusion.BoundInterfaceVariable.pick(array(int32,ndim=2))
      mosek.fusion.BoundInterfaceVariable.pick(array(int32,ndim=1),array(int32,ndim=1))
      mosek.fusion.BoundInterfaceVariable.pick(array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    i0 : array(int32,ndim=1)
    i1 : array(int32,ndim=1)
    i2 : array(int32,ndim=1)
    idxs : array(int32,ndim=1)
    midxs : array(int32,ndim=2)
    '''
    if False: pass
    elif mosek_fusion_BoundInterfaceVariable._match_pick__3I(*args):
      return self._pick__3I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_pick__3I(*args):
      return self._pick_alt__3I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_pick__3_5I(*args):
      return self._pick__3_5I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_pick__3_5I(*args):
      return self._pick_alt__3_5I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_pick__3I_3I(*args):
      return self._pick__3I_3I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_pick__3I_3I(*args):
      return self._pick_alt__3I_3I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_pick__3I_3I_3I(*args):
      return self._pick__3I_3I_3I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_pick__3I_3I_3I(*args):
      return self._pick_alt__3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list pick('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceVariable.pick(array(int32,ndim=1))\n\tmosek.fusion.BoundInterfaceVariable.pick(array(int32,ndim=2))\n\tmosek.fusion.BoundInterfaceVariable.pick(array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.BoundInterfaceVariable.pick(array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def transpose(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BoundInterfaceVariable.transpose()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BoundInterfaceVariable._match_transpose_(*args):
      return self._transpose_(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_transpose_(*args):
      return self._transpose_alt_(*args)
    else:
      raise ValueError('Invalid argument list transpose('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceVariable.transpose()')
  def dual(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BoundInterfaceVariable.dual()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BoundInterfaceVariable._match_dual_(*args):
      return self._dual_(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_dual_(*args):
      return self._dual_alt_(*args)
    else:
      raise ValueError('Invalid argument list dual('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceVariable.dual()')
  def antidiag(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BoundInterfaceVariable.antidiag()
      mosek.fusion.BoundInterfaceVariable.antidiag(int32)

    Description
    -----------

    

    Parameters
    ----------

    index : int32
    '''
    if False: pass
    elif mosek_fusion_BoundInterfaceVariable._match_antidiag_(*args):
      return self._antidiag_(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_antidiag_(*args):
      return self._antidiag_alt_(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_antidiag_I(*args):
      return self._antidiag_I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_antidiag_I(*args):
      return self._antidiag_alt_I(*args)
    else:
      raise ValueError('Invalid argument list antidiag('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceVariable.antidiag()\n\tmosek.fusion.BoundInterfaceVariable.antidiag(int32)')
  def slice(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BoundInterfaceVariable.slice(int32,int32)
      mosek.fusion.BoundInterfaceVariable.slice(array(int32,ndim=1),array(int32,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    first : int32
    firsta : array(int32,ndim=1)
    last : int32
    lasta : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_BoundInterfaceVariable._match_slice_II(*args):
      return self._slice_II(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_slice_II(*args):
      return self._slice_alt_II(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_slice__3I_3I(*args):
      return self._slice__3I_3I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_slice__3I_3I(*args):
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceVariable.slice(int32,int32)\n\tmosek.fusion.BoundInterfaceVariable.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def __repr__(self): return 'mosek.fusion.BoundInterfaceVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2_3I_3J_3JZ(m,shape,sparsity,nativeidxs,islower):
    o = BoundInterfaceVariable.__new__(BoundInterfaceVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3JZ(m,shape,sparsity,nativeidxs,islower)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2_3I_3J_3JZ(*args):
    if len(args) != 5: return False
    m,shape,sparsity,nativeidxs,islower, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(m) and __arg_match__3I__(shape) and __arg_match__3J__(sparsity) and __arg_match__3J__(nativeidxs) and __arg_match_Z__(islower))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2_3I_3J_3JZ(*args):
    if len(args) != 5: return False
    m,shape,sparsity,nativeidxs,islower, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(m) and __arg_alt_match__3I__(shape) and __arg_alt_match__3J__(sparsity) and __arg_alt_match__3J__(nativeidxs) and __arg_alt_match_Z__(islower))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2_3I_3J_3JZ(self,m,shape,sparsity,nativeidxs,islower):
    self._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3JZ(m,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(sparsity,dtype=numpy.dtype(numpy.int64)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int64)),islower)
  def _ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3JZ(self,m,shape,sparsity,nativeidxs,islower):
   mosek_fusion_SliceVariable._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(self,m,shape,sparsity,nativeidxs)
   (self.__islower) = islower
  @staticmethod
  def _ctor_Lmosek_4fusion_4SliceVariable_2Z(v,islower):
    o = BoundInterfaceVariable.__new__(BoundInterfaceVariable)
    o._ctor_init_Lmosek_4fusion_4SliceVariable_2Z(v,islower)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4SliceVariable_2Z(*args):
    if len(args) != 2: return False
    v,islower, = args
    return (__arg_match_Lmosek_4fusion_4SliceVariable_2__(v) and __arg_match_Z__(islower))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4SliceVariable_2Z(*args):
    if len(args) != 2: return False
    v,islower, = args
    return (__arg_alt_match_Lmosek_4fusion_4SliceVariable_2__(v) and __arg_alt_match_Z__(islower))
  def _ctor_alt_init_Lmosek_4fusion_4SliceVariable_2Z(self,v,islower):
    self._ctor_init_Lmosek_4fusion_4SliceVariable_2Z(v,islower)
  def _ctor_init_Lmosek_4fusion_4SliceVariable_2Z(self,v,islower):
   mosek_fusion_SliceVariable._ctor_init_Lmosek_4fusion_4SliceVariable_2(self,v)
   (self.__islower) = islower
  @staticmethod
  def _match_dual_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dual_(*args):
    if len(args) != 0: return False
    return True
  def _dual_alt_(self,):
    return self._dual_()
  def _dual_(self,):
   _a_0=numpy.zeros((self._getSize_(),), dtype=numpy.dtype(numpy.float64))
   self._dual_1lu_I_3DZ(0,_a_0,self.__islower)
   return (_a_0)
  @staticmethod
  def _match_transpose_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_transpose_(*args):
    if len(args) != 0: return False
    return True
  def _transpose_alt_(self,):
    return self._transpose_()
  def _transpose_(self,):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._transpose_(self)))
  @staticmethod
  def _match_pick__3I_3I_3I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1) and __arg_match__3I__(_a_2))
  @staticmethod
  def _match_alt_pick__3I_3I_3I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1) and __arg_alt_match__3I__(_a_2))
  def _pick_alt__3I_3I_3I(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I_3I_3I(_a_0,_a_1,_a_2)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I_3I_3I(self,_a_0,_a_1,_a_2):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._pick__3I_3I_3I(self,_a_0,_a_1,_a_2)))
  @staticmethod
  def _match_pick__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_pick__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1))
  def _pick_alt__3I_3I(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I_3I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I_3I(self,_a_0,_a_1):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._pick__3I_3I(self,_a_0,_a_1)))
  @staticmethod
  def _match_pick__3_5I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3_5I__(_a_0))
  @staticmethod
  def _match_alt_pick__3_5I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3_5I__(_a_0))
  def _pick_alt__3_5I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,ndmin=_monty.checkShape(_t__a_0,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3_5I(_a_0)
   return _1_res
  def _pick__3_5I(self,_a_0):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._pick__3_5I(self,_a_0)))
  @staticmethod
  def _match_pick__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_pick__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _pick_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I(self,_a_0):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._pick__3I(self,_a_0)))
  @staticmethod
  def _match_antidiag_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_antidiag_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _antidiag_alt_I(self,_t__a_0):
    return self._antidiag_I(numpy.int32(__a_0))
  def _antidiag_I(self,_a_0):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._antidiag_I(self,_a_0)))
  @staticmethod
  def _match_antidiag_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_antidiag_(*args):
    if len(args) != 0: return False
    return True
  def _antidiag_alt_(self,):
    return self._antidiag_()
  def _antidiag_(self,):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._antidiag_(self)))
  @staticmethod
  def _match_diag_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_diag_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _diag_alt_I(self,_t__a_0):
    return self._diag_I(numpy.int32(__a_0))
  def _diag_I(self,_a_0):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._diag_I(self,_a_0)))
  @staticmethod
  def _match_diag_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_diag_(*args):
    if len(args) != 0: return False
    return True
  def _diag_alt_(self,):
    return self._diag_()
  def _diag_(self,):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._diag_(self)))
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1))
  def _slice_alt__3I_3I(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._slice__3I_3I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _slice__3I_3I(self,_a_0,_a_1):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._slice__3I_3I(self,_a_0,_a_1)))
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1))
  def _slice_alt_II(self,_t__a_0,_t__a_1):
    return self._slice_II(numpy.int32(__a_0),numpy.int32(__a_1))
  def _slice_II(self,_a_0,_a_1):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._slice_II(self,_a_0,_a_1)))
  def __from_1_alt_Lmosek_4fusion_4Variable_2(self,_t__a_0):
    return self.__from_1_Lmosek_4fusion_4Variable_2(_a_0)
  def __from_1_Lmosek_4fusion_4Variable_2(self,_a_0):
   _a_1=self._getShape_()
   _a_2=_a_0._numInst_()
   _a_3=numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.int64))
   _a_4=None
   if (_a_0._getSize_()==_a_2):
    _a_0._inst_I_3J(0,_a_3)
   else:
    _a_4 = numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.int64))
    _a_0._inst_I_3JI_3J(0,_a_4,0,_a_3)
   return (mosek_fusion_BoundInterfaceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3JZ(_a_0._getModel_(),_a_1,_a_4,_a_3,self.__islower))
 return BoundInterfaceVariable
mosek_fusion_BoundInterfaceVariable=__mk_mosek_fusion_BoundInterfaceVariable()
del __mk_mosek_fusion_BoundInterfaceVariable
#BEFORE CLASS
def __mk_mosek_fusion_ModelVariable():
 class ModelVariable(mosek_fusion_BaseVariable):
  __slots__ = ['_ModelVariable__sparsity','_ModelVariable__shape','_ModelVariable__modelvar_nativeidxs','_ModelVariable__varid','_ModelVariable__name']
  def elementName(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.ModelVariable.elementName(int64,mosek.fusion.Utils.StringBuffer)

    Description
    -----------

    

    Parameters
    ----------

    index : int64
    sb : mosek.fusion.Utils.StringBuffer
    '''
    if False: pass
    elif mosek_fusion_ModelVariable._match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_ModelVariable._match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ModelVariable.elementName(int64,mosek.fusion.Utils.StringBuffer)')
  def remove(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.ModelVariable.remove()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_ModelVariable._match_remove_(*args):
      return self._remove_(*args)
    elif mosek_fusion_ModelVariable._match_alt_remove_(*args):
      return self._remove_alt_(*args)
    else:
      raise ValueError('Invalid argument list remove('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ModelVariable.remove()')
  def __repr__(self): return 'mosek.fusion.ModelVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = ModelVariable.__new__(ModelVariable)
    o._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4ModelVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4ModelVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__name = (v.__name)
   self.__varid = (v.__varid)
   self.__modelvar_nativeidxs = (v.__modelvar_nativeidxs)
   self.__shape = (v.__shape)
   self.__sparsity = (v.__sparsity)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(model,name,shape,varid,sparsity,modelvar_nativeidxs):
    o = ModelVariable.__new__(ModelVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(model,name,shape,varid,sparsity,modelvar_nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(*args):
    if len(args) != 6: return False
    model,name,shape,varid,sparsity,modelvar_nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match__3I__(shape) and __arg_match_J__(varid) and __arg_match__3J__(sparsity) and __arg_match__3J__(modelvar_nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(*args):
    if len(args) != 6: return False
    model,name,shape,varid,sparsity,modelvar_nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match__3I__(shape) and __arg_alt_match_J__(varid) and __arg_alt_match__3J__(sparsity) and __arg_alt_match__3J__(modelvar_nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(self,model,name,shape,varid,sparsity,modelvar_nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(model,name,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.int64(varid),numpy.array(sparsity,dtype=numpy.dtype(numpy.int64)),numpy.array(modelvar_nativeidxs,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(self,model,name,shape,varid,sparsity,modelvar_nativeidxs):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(self,model,shape,sparsity,modelvar_nativeidxs)
   (self.__name) = name
   (self.__varid) = varid
   (self.__shape) = shape
   (self.__sparsity) = sparsity
   (self.__modelvar_nativeidxs) = modelvar_nativeidxs
  @staticmethod
  def _match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_J__(_a_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_a_1))
  @staticmethod
  def _match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_J__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_a_1))
  def _elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__a_0,_t__a_1):
    return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__a_0),_a_1)
  def _elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_a_0,_a_1):
   _a_1._a_S(("_" if ((int(len(self.__name))==0) ) else self.__name))._a_S("[")._a_S(mosek.fusion.Set._indexToString__3IJ(self.__shape,_a_0))._a_S("]")
  @staticmethod
  def _match_remove_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_remove_(*args):
    if len(args) != 0: return False
    return True
  def _remove_alt_(self,):
    return self._remove_()
  def _remove_(self,):
   self._getModel_()._removeVariableBlock_J(self.__varid)
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__a_0):
    return self._clone_Lmosek_4fusion_4Model_2(_a_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_a_0):
   pass
 return ModelVariable
mosek_fusion_ModelVariable=__mk_mosek_fusion_ModelVariable()
del __mk_mosek_fusion_ModelVariable
#BEFORE CLASS
def __mk_mosek_fusion_RangedVariable():
 class RangedVariable(mosek_fusion_ModelVariable):
  __slots__ = ['_RangedVariable__shape','_RangedVariable__name','_RangedVariable__nativeidxs','_RangedVariable__sparsity']
  def upperBoundVar(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RangedVariable.upperBoundVar()

    Description
    -----------

    Obtain the interface to the variable's upper bound. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_RangedVariable._match_upperBoundVar_(*args):
      return self._upperBoundVar_(*args)
    elif mosek_fusion_RangedVariable._match_alt_upperBoundVar_(*args):
      return self._upperBoundVar_alt_(*args)
    else:
      raise ValueError('Invalid argument list upperBoundVar('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedVariable.upperBoundVar()')
  def elementDesc(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RangedVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)

    Description
    -----------

    

    Parameters
    ----------

    index : int64
    sb : mosek.fusion.Utils.StringBuffer
    '''
    if False: pass
    elif mosek_fusion_RangedVariable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_RangedVariable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def lowerBoundVar(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RangedVariable.lowerBoundVar()

    Description
    -----------

    Obtain the interface to the variable's lower bound. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_RangedVariable._match_lowerBoundVar_(*args):
      return self._lowerBoundVar_(*args)
    elif mosek_fusion_RangedVariable._match_alt_lowerBoundVar_(*args):
      return self._lowerBoundVar_alt_(*args)
    else:
      raise ValueError('Invalid argument list lowerBoundVar('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedVariable.lowerBoundVar()')
  def __repr__(self): return 'mosek.fusion.RangedVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = RangedVariable.__new__(RangedVariable)
    o._ctor_init_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4RangedVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4RangedVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__name = (v.__name)
   self.__nativeidxs = (v.__nativeidxs)
   self.__sparsity = (v.__sparsity)
   self.__shape = (v.__shape)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(model,name,varid,shape,sparsity,nativeidxs):
    o = RangedVariable.__new__(RangedVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(model,name,varid,shape,sparsity,nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(*args):
    if len(args) != 6: return False
    model,name,varid,shape,sparsity,nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_J__(varid) and __arg_match__3I__(shape) and __arg_match__3J__(sparsity) and __arg_match__3I__(nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(*args):
    if len(args) != 6: return False
    model,name,varid,shape,sparsity,nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_J__(varid) and __arg_alt_match__3I__(shape) and __arg_alt_match__3J__(sparsity) and __arg_alt_match__3I__(nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(self,model,name,varid,shape,sparsity,nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(model,name,numpy.int64(varid),numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(sparsity,dtype=numpy.dtype(numpy.int64)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(self,model,name,varid,shape,sparsity,nativeidxs):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(self,model,name,shape,varid,sparsity,mosek.fusion.RangedVariable.__globalNativeIndexes__3I(nativeidxs))
   (self.__nativeidxs) = nativeidxs
   (self.__sparsity) = sparsity
   (self.__name) = name
   (self.__shape) = shape
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_J__(_a_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_a_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_J__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_a_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__a_0,_t__a_1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__a_0),_a_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_a_0,_a_1):
   self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(_a_0,_a_1)
   _a_1._a_S(" : in range")
   return (_a_1)
  def _dual_1u_alt_I_3D(self,_t__a_0,_t__a_1):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.float64))
   _1_res = self._dual_1u_I_3D(_a_0,_a_1)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _dual_1u_I_3D(self,_a_0,_a_1):
   self._dual_1lu_I_3DZ(_a_0,_a_1,False)
  def _dual_1l_alt_I_3D(self,_t__a_0,_t__a_1):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.float64))
   _1_res = self._dual_1l_I_3D(_a_0,_a_1)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _dual_1l_I_3D(self,_a_0,_a_1):
   self._dual_1lu_I_3DZ(_a_0,_a_1,True)
  @staticmethod
  def _match_upperBoundVar_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_upperBoundVar_(*args):
    if len(args) != 0: return False
    return True
  def _upperBoundVar_alt_(self,):
    return self._upperBoundVar_()
  def _upperBoundVar_(self,):
   return (mosek_fusion_BoundInterfaceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3JZ(self._getModel_(),self.__shape,self.__sparsity,numpy.array([self.__nativeidxs[_a_0] for _a_0 in range(0,int((self.__nativeidxs).shape[0]))], dtype=numpy.dtype(numpy.int64)),False))
  @staticmethod
  def _match_lowerBoundVar_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_lowerBoundVar_(*args):
    if len(args) != 0: return False
    return True
  def _lowerBoundVar_alt_(self,):
    return self._lowerBoundVar_()
  def _lowerBoundVar_(self,):
   return (mosek_fusion_BoundInterfaceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3JZ(self._getModel_(),self.__shape,self.__sparsity,numpy.array([self.__nativeidxs[_a_0] for _a_0 in range(0,int((self.__nativeidxs).shape[0]))], dtype=numpy.dtype(numpy.int64)),True))
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__a_0):
    return self._clone_Lmosek_4fusion_4Model_2(_a_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_a_0):
   return (mosek_fusion_RangedVariable._ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(self,_a_0))
  @staticmethod
  def __globalNativeIndexes_alt__3I(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_RangedVariable.__globalNativeIndexes__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __globalNativeIndexes__3I(_a_0):
   _a_1=numpy.zeros((int((_a_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_197(_a_0,_a_1) 
   return (_a_1)
 return RangedVariable
mosek_fusion_RangedVariable=__mk_mosek_fusion_RangedVariable()
del __mk_mosek_fusion_RangedVariable
#BEFORE CLASS
def __mk_mosek_fusion_LinearPSDVariable():
 class LinearPSDVariable(mosek_fusion_ModelVariable):
  __slots__ = ['_LinearPSDVariable__shape','_LinearPSDVariable__name','_LinearPSDVariable__varid','_LinearPSDVariable__nativeidxs','_LinearPSDVariable__conedim']
  def make_integer(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.LinearPSDVariable.make_integer()
      mosek.fusion.LinearPSDVariable.make_integer(array(int64,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    idxs : array(int64,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_LinearPSDVariable._match_make_1integer_(*args):
      return self._make_1integer_(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_make_1integer_(*args):
      return self._make_1integer_alt_(*args)
    elif mosek_fusion_LinearPSDVariable._match_make_1integer__3J(*args):
      return self._make_1integer__3J(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_make_1integer__3J(*args):
      return self._make_1integer_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearPSDVariable.make_integer()\n\tmosek.fusion.LinearPSDVariable.make_integer(array(int64,ndim=1))')
  def make_continuous(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.LinearPSDVariable.make_continuous()
      mosek.fusion.LinearPSDVariable.make_continuous(array(int64,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    idxs : array(int64,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_LinearPSDVariable._match_make_1continuous_(*args):
      return self._make_1continuous_(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_make_1continuous_(*args):
      return self._make_1continuous_alt_(*args)
    elif mosek_fusion_LinearPSDVariable._match_make_1continuous__3J(*args):
      return self._make_1continuous__3J(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_make_1continuous__3J(*args):
      return self._make_1continuous_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearPSDVariable.make_continuous()\n\tmosek.fusion.LinearPSDVariable.make_continuous(array(int64,ndim=1))')
  def toString(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.LinearPSDVariable.toString()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_LinearPSDVariable._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearPSDVariable.toString()')
  def __repr__(self): return 'mosek.fusion.LinearPSDVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = LinearPSDVariable.__new__(LinearPSDVariable)
    o._ctor_init_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4LinearPSDVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearPSDVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   (self.__conedim) = (v.__conedim)
   (self.__varid) = (v.__varid)
   (self.__name) = (v.__name)
   (self.__shape) = (v.__shape)
   (self.__nativeidxs) = (v.__nativeidxs)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SI_3II_3J(model,name,varid,shape,conedim,nativeidxs):
    o = LinearPSDVariable.__new__(LinearPSDVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SI_3II_3J(model,name,varid,shape,conedim,nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SI_3II_3J(*args):
    if len(args) != 6: return False
    model,name,varid,shape,conedim,nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_I__(varid) and __arg_match__3I__(shape) and __arg_match_I__(conedim) and __arg_match__3J__(nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SI_3II_3J(*args):
    if len(args) != 6: return False
    model,name,varid,shape,conedim,nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_I__(varid) and __arg_alt_match__3I__(shape) and __arg_alt_match_I__(conedim) and __arg_alt_match__3J__(nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SI_3II_3J(self,model,name,varid,shape,conedim,nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2SI_3II_3J(model,name,numpy.int32(varid),numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.int32(conedim),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_Lmosek_4fusion_4Model_2SI_3II_3J(self,model,name,varid,shape,conedim,nativeidxs):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(self,model,name,shape,varid,None,mosek.fusion.LinearPSDVariable.__globalNativeIndexes__3J(nativeidxs))
   (self.__name) = name
   (self.__conedim) = conedim
   (self.__varid) = varid
   (self.__shape) = shape
   (self.__nativeidxs) = nativeidxs
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _a_0=mosek.fusion.Utils.StringBuffer()
   _a_0._a_S("PSDVariable(")
   if (int(len(self.__name)) > 0):
    _a_0._a_S("'")._a_S(self.__name)._a_S("',")
   _a_0._a_I(self.__shape[0])
   for _a_1 in range(1,int((self.__shape).shape[0])):
    _a_0._a_S(",")._a_I(self.__shape[_a_1])
   _a_0._a_S(")")
   return (_a_0._toString_())
  @staticmethod
  def _match_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3J__(_a_0))
  @staticmethod
  def _match_alt_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3J__(_a_0))
  def _make_1continuous_alt__3J(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _1_res = self._make_1continuous__3J(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _make_1continuous__3J(self,_a_0):
   pass
  @staticmethod
  def _match_make_1integer__3J(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3J__(_a_0))
  @staticmethod
  def _match_alt_make_1integer__3J(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3J__(_a_0))
  def _make_1integer_alt__3J(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _1_res = self._make_1integer__3J(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _make_1integer__3J(self,_a_0):
   raise mosek_fusion_UnimplementedError._ctor_S("Cannot make PSDVariable elements integer")
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__a_0):
    return self._clone_Lmosek_4fusion_4Model_2(_a_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_a_0):
   return (mosek_fusion_LinearPSDVariable._ctor_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(self,_a_0))
  @staticmethod
  def __globalNativeIndexes_alt__3J(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _1_res = mosek_fusion_LinearPSDVariable.__globalNativeIndexes__3J(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __globalNativeIndexes__3J(_a_0):
   return (numpy.array([(- (_a_0[_a_1] + 1)) for _a_1 in range(0,int((_a_0).shape[0]))], dtype=numpy.dtype(numpy.int64)))
 return LinearPSDVariable
mosek_fusion_LinearPSDVariable=__mk_mosek_fusion_LinearPSDVariable()
del __mk_mosek_fusion_LinearPSDVariable
#BEFORE CLASS
def __mk_mosek_fusion_PSDVariable():
 class PSDVariable(mosek_fusion_ModelVariable):
  __slots__ = ['_PSDVariable__model','_PSDVariable__barvaridxs','_PSDVariable__conedim2','_PSDVariable__conedim1','_PSDVariable__shape','_PSDVariable__name','_PSDVariable__nativeidxs','_PSDVariable__varid']
  def toString(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.PSDVariable.toString()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_PSDVariable._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_PSDVariable._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDVariable.toString()')
  def elementDesc(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.PSDVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)

    Description
    -----------

    

    Parameters
    ----------

    index : int64
    sb : mosek.fusion.Utils.StringBuffer
    '''
    if False: pass
    elif mosek_fusion_PSDVariable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_PSDVariable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def __repr__(self): return 'mosek.fusion.PSDVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = PSDVariable.__new__(PSDVariable)
    o._ctor_init_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4PSDVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4PSDVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__varid = (v.__varid)
   self.__nativeidxs = (v.__nativeidxs)
   self.__name = (v.__name)
   self.__shape = (v.__shape)
   self.__conedim1 = (v.__conedim1)
   self.__conedim2 = (v.__conedim2)
   self.__model = m
   self.__barvaridxs = (v.__barvaridxs)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SI_3III_3I_3J(model,name,varid,shape,conedim1,conedim2,barvaridxs,nativeidxs):
    o = PSDVariable.__new__(PSDVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SI_3III_3I_3J(model,name,varid,shape,conedim1,conedim2,barvaridxs,nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SI_3III_3I_3J(*args):
    if len(args) != 8: return False
    model,name,varid,shape,conedim1,conedim2,barvaridxs,nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_I__(varid) and __arg_match__3I__(shape) and __arg_match_I__(conedim1) and __arg_match_I__(conedim2) and __arg_match__3I__(barvaridxs) and __arg_match__3J__(nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SI_3III_3I_3J(*args):
    if len(args) != 8: return False
    model,name,varid,shape,conedim1,conedim2,barvaridxs,nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_I__(varid) and __arg_alt_match__3I__(shape) and __arg_alt_match_I__(conedim1) and __arg_alt_match_I__(conedim2) and __arg_alt_match__3I__(barvaridxs) and __arg_alt_match__3J__(nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SI_3III_3I_3J(self,model,name,varid,shape,conedim1,conedim2,barvaridxs,nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2SI_3III_3I_3J(model,name,numpy.int32(varid),numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.int32(conedim1),numpy.int32(conedim2),numpy.array(barvaridxs,dtype=numpy.dtype(numpy.int32)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_Lmosek_4fusion_4Model_2SI_3III_3I_3J(self,model,name,varid,shape,conedim1,conedim2,barvaridxs,nativeidxs):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(self,model,name,shape,varid,None,mosek.fusion.PSDVariable.__fullnativeidxs__3III_3J(shape,conedim1,conedim2,nativeidxs))
   (self.__varid) = varid
   (self.__nativeidxs) = nativeidxs
   (self.__name) = name
   (self.__shape) = shape
   (self.__conedim1) = conedim1
   (self.__conedim2) = conedim2
   (self.__model) = model
   (self.__barvaridxs) = barvaridxs
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _a_0=mosek.fusion.Utils.StringBuffer()
   _a_0._a_S("PSDVariable(")
   if (int(len(self.__name)) > 0):
    _a_0._a_S("'")._a_S(self.__name)._a_S("',")
   _a_0._a_I(self.__shape[0])
   for _a_1 in range(1,int((self.__shape).shape[0])):
    _a_0._a_S(",")._a_I(self.__shape[_a_1])
   _a_0._a_S(")")
   return (_a_0._toString_())
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_J__(_a_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_a_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_J__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_a_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__a_0,_t__a_1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__a_0),_a_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_a_0,_a_1):
   self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(_a_0,_a_1)
   _a_1._a_S(" : element in positive semidefinite cone")
   return (_a_1)
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__a_0):
    return self._clone_Lmosek_4fusion_4Model_2(_a_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_a_0):
   return (mosek_fusion_PSDVariable._ctor_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(self,_a_0))
  @staticmethod
  def __fullnativeidxs_alt__3III_3J(_t__a_0,_t__a_1,_t__a_2,_t__a_3):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.int32(_t__a_1)
   _a_2=numpy.int32(_t__a_2)
   _a_3=numpy.array(_t__a_3,dtype=numpy.dtype(numpy.int64))
   _1_res = mosek_fusion_PSDVariable.__fullnativeidxs__3III_3J(_a_0,_a_1,_a_2,_a_3)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_3[:] = _a_3
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __fullnativeidxs__3III_3J(_a_0,_a_1,_a_2,_a_3):
   _a_4=int((_a_0).shape[0])
   _a_5=(_a_1 < _a_2)
   _a_6=(_a_1 if (_a_5 ) else _a_2)
   _a_7=(_a_1 if ((not _a_5) ) else _a_2)
   _a_8=1
   _a_8 = fragments._c_closure_198(_a_6,_a_8,_a_0)
   _a_8 = numpy.int32(_a_8) # postprocess
   _a_9=_a_0[_a_6]
   _a_10=1
   _a_10 = fragments._c_closure_199(_a_6,_a_7,_a_10,_a_0)
   _a_10 = numpy.int32(_a_10) # postprocess
   _a_11=_a_0[_a_7]
   _a_12=1
   _a_12 = fragments._c_closure_200(_a_7,_a_12,_a_4,_a_0)
   _a_12 = numpy.int32(_a_12) # postprocess
   _a_13=((((_a_8 * _a_9) * _a_10) * _a_11) * _a_12)
   _a_14=numpy.zeros((_a_13,), dtype=numpy.dtype(numpy.int64))
   _a_15=_a_12
   _a_16=(_a_15 * _a_11)
   _a_17=(_a_16 * _a_10)
   _a_18=(_a_17 * _a_17)
   fragments._c_closure_201(_a_8,_a_9,_a_10,_a_11,_a_12,_a_3,_a_14,_a_18,_a_17,_a_16,_a_15) 
   return (_a_14)
 return PSDVariable
mosek_fusion_PSDVariable=__mk_mosek_fusion_PSDVariable()
del __mk_mosek_fusion_PSDVariable
#BEFORE CLASS
def __mk_mosek_fusion_LinearVariable():
 class LinearVariable(mosek_fusion_ModelVariable):
  __slots__ = ['_LinearVariable__shape','_LinearVariable__sparsity','_LinearVariable__nativeidxs','_LinearVariable__name']
  def toString(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.LinearVariable.toString()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_LinearVariable._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_LinearVariable._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearVariable.toString()')
  def __repr__(self): return 'mosek.fusion.LinearVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = LinearVariable.__new__(LinearVariable)
    o._ctor_init_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4LinearVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__nativeidxs = (v.__nativeidxs)
   self.__sparsity = (v.__sparsity)
   self.__shape = (v.__shape)
   self.__name = (v.__name)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(model,name,varid,shape,sparsity,nativeidxs):
    o = LinearVariable.__new__(LinearVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(model,name,varid,shape,sparsity,nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(*args):
    if len(args) != 6: return False
    model,name,varid,shape,sparsity,nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_J__(varid) and __arg_match__3I__(shape) and __arg_match__3J__(sparsity) and __arg_match__3I__(nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(*args):
    if len(args) != 6: return False
    model,name,varid,shape,sparsity,nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_J__(varid) and __arg_alt_match__3I__(shape) and __arg_alt_match__3J__(sparsity) and __arg_alt_match__3I__(nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(self,model,name,varid,shape,sparsity,nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(model,name,numpy.int64(varid),numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(sparsity,dtype=numpy.dtype(numpy.int64)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(self,model,name,varid,shape,sparsity,nativeidxs):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(self,model,name,shape,varid,sparsity,mosek.fusion.LinearVariable.__globalNativeIndexes__3I(nativeidxs))
   (self.__name) = name
   (self.__nativeidxs) = nativeidxs
   (self.__sparsity) = sparsity
   (self.__shape) = shape
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _a_0=mosek.fusion.Utils.StringBuffer()
   _a_0._a_S("LinearVariable((")
   if (int((self.__shape).shape[0]) > 0):
    _a_0._a_I(self.__shape[0])
    for _a_1 in range(1,int((self.__shape).shape[0])):
     _a_0._a_S(",")._a_I(self.__shape[_a_1])
   _a_0._a_S(")")
   if (self.__sparsity is not None):
    _a_0._a_S(",sparse")
   _a_0._a_S(")")
   return (_a_0._toString_())
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__a_0):
    return self._clone_Lmosek_4fusion_4Model_2(_a_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_a_0):
   return (mosek_fusion_LinearVariable._ctor_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(self,_a_0))
  @staticmethod
  def __globalNativeIndexes_alt__3I(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_LinearVariable.__globalNativeIndexes__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __globalNativeIndexes__3I(_a_0):
   _a_1=numpy.zeros((int((_a_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_202(_a_0,_a_1) 
   return (_a_1)
 return LinearVariable
mosek_fusion_LinearVariable=__mk_mosek_fusion_LinearVariable()
del __mk_mosek_fusion_LinearVariable
#BEFORE CLASS
def __mk_mosek_fusion_ConicVariable():
 class ConicVariable(mosek_fusion_ModelVariable):
  __slots__ = ['_ConicVariable__nativeidxs','_ConicVariable__shape','_ConicVariable__name','_ConicVariable__varid']
  def toString(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.ConicVariable.toString()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_ConicVariable._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_ConicVariable._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConicVariable.toString()')
  def __repr__(self): return 'mosek.fusion.ConicVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = ConicVariable.__new__(ConicVariable)
    o._ctor_init_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4ConicVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4ConicVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__shape = (v.__shape)
   self.__nativeidxs = (v.__nativeidxs)
   self.__shape = (v.__shape)
   self.__varid = (v.__varid)
   self.__name = (v.__name)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SI_3I_3I(model,name,varid,shape,nativeidxs):
    o = ConicVariable.__new__(ConicVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SI_3I_3I(model,name,varid,shape,nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SI_3I_3I(*args):
    if len(args) != 5: return False
    model,name,varid,shape,nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_I__(varid) and __arg_match__3I__(shape) and __arg_match__3I__(nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SI_3I_3I(*args):
    if len(args) != 5: return False
    model,name,varid,shape,nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_I__(varid) and __arg_alt_match__3I__(shape) and __arg_alt_match__3I__(nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SI_3I_3I(self,model,name,varid,shape,nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2SI_3I_3I(model,name,numpy.int32(varid),numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Lmosek_4fusion_4Model_2SI_3I_3I(self,model,name,varid,shape,nativeidxs):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(self,model,name,shape,varid,None,mosek.fusion.ConicVariable.__globalNativeIndexes__3I(nativeidxs))
   (self.__name) = name
   (self.__varid) = varid
   (self.__shape) = shape
   (self.__nativeidxs) = nativeidxs
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _a_0=mosek.fusion.Utils.StringBuffer()
   _a_0._a_S("ConicVariable( ")
   if (int(len(self.__name)) > 0):
    _a_0._a_S("'")._a_S(self.__name)._a_S("',")
   _a_0._a_S("(")
   _a_0._a_I(self.__shape[0])
   for _a_1 in range(1,int((self.__shape).shape[0])):
    _a_0._a_S(",")._a_I(self.__shape[_a_1])
   _a_0._a_S(") )")
   return (_a_0._toString_())
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__a_0):
    return self._clone_Lmosek_4fusion_4Model_2(_a_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_a_0):
   return (mosek_fusion_ConicVariable._ctor_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(self,_a_0))
  @staticmethod
  def __globalNativeIndexes_alt__3I(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_ConicVariable.__globalNativeIndexes__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __globalNativeIndexes__3I(_a_0):
   _a_1=numpy.zeros((int((_a_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_203(_a_0,_a_1) 
   return (_a_1)
 return ConicVariable
mosek_fusion_ConicVariable=__mk_mosek_fusion_ConicVariable()
del __mk_mosek_fusion_ConicVariable
#BEFORE CLASS
def __mk_mosek_fusion_NilVariable():
 class NilVariable(mosek_fusion_BaseVariable):
  __slots__ = ['_NilVariable__shape']
  def numInst(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.NilVariable.numInst()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_NilVariable._match_numInst_(*args):
      return self._numInst_(*args)
    elif mosek_fusion_NilVariable._match_alt_numInst_(*args):
      return self._numInst_alt_(*args)
    else:
      raise ValueError('Invalid argument list numInst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.numInst()')
  def toString(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.NilVariable.toString()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_NilVariable._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_NilVariable._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.toString()')
  def elementDesc(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.NilVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)

    Description
    -----------

    

    Parameters
    ----------

    index : int64
    sb : mosek.fusion.Utils.StringBuffer
    '''
    if False: pass
    elif mosek_fusion_NilVariable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_NilVariable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def index(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.NilVariable.index(int32)
      mosek.fusion.NilVariable.index(array(int32,ndim=1))
      mosek.fusion.NilVariable.index(int32,int32)
      mosek.fusion.NilVariable.index(int32,int32,int32)

    Description
    -----------

    

    Parameters
    ----------

    first : array(int32,ndim=1)
    i0 : int32
    i1 : int32
    i2 : int32
    '''
    if False: pass
    elif mosek_fusion_NilVariable._match_index_I(*args):
      return self._index_I(*args)
    elif mosek_fusion_NilVariable._match_alt_index_I(*args):
      return self._index_alt_I(*args)
    elif mosek_fusion_NilVariable._match_index__3I(*args):
      return self._index__3I(*args)
    elif mosek_fusion_NilVariable._match_alt_index__3I(*args):
      return self._index_alt__3I(*args)
    elif mosek_fusion_NilVariable._match_index_II(*args):
      return self._index_II(*args)
    elif mosek_fusion_NilVariable._match_alt_index_II(*args):
      return self._index_alt_II(*args)
    elif mosek_fusion_NilVariable._match_index_III(*args):
      return self._index_III(*args)
    elif mosek_fusion_NilVariable._match_alt_index_III(*args):
      return self._index_alt_III(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.index(int32)\n\tmosek.fusion.NilVariable.index(array(int32,ndim=1))\n\tmosek.fusion.NilVariable.index(int32,int32)\n\tmosek.fusion.NilVariable.index(int32,int32,int32)')
  def elementName(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.NilVariable.elementName(int64,mosek.fusion.Utils.StringBuffer)

    Description
    -----------

    

    Parameters
    ----------

    index : int64
    sb : mosek.fusion.Utils.StringBuffer
    '''
    if False: pass
    elif mosek_fusion_NilVariable._match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_NilVariable._match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.elementName(int64,mosek.fusion.Utils.StringBuffer)')
  def inst(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.NilVariable.inst(int32,array(int64,ndim=1))
      mosek.fusion.NilVariable.inst(int32,array(int64,ndim=1),array(int64,ndim=1))
      mosek.fusion.NilVariable.inst(int32,array(int64,ndim=1),int32,array(int64,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    basevar_nativeidxs : array(int64,ndim=1)
    nindex : array(int64,ndim=1)
    nioffset : int32
    offset : int32
    sparsity : array(int64,ndim=1)
    spoffset : int32
    '''
    if False: pass
    elif mosek_fusion_NilVariable._match_inst_I_3J(*args):
      return self._inst_I_3J(*args)
    elif mosek_fusion_NilVariable._match_alt_inst_I_3J(*args):
      return self._inst_alt_I_3J(*args)
    elif mosek_fusion_NilVariable._match_inst_I_3J_3J(*args):
      return self._inst_I_3J_3J(*args)
    elif mosek_fusion_NilVariable._match_alt_inst_I_3J_3J(*args):
      return self._inst_alt_I_3J_3J(*args)
    elif mosek_fusion_NilVariable._match_inst_I_3JI_3J(*args):
      return self._inst_I_3JI_3J(*args)
    elif mosek_fusion_NilVariable._match_alt_inst_I_3JI_3J(*args):
      return self._inst_alt_I_3JI_3J(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.inst(int32,array(int64,ndim=1))\n\tmosek.fusion.NilVariable.inst(int32,array(int64,ndim=1),array(int64,ndim=1))\n\tmosek.fusion.NilVariable.inst(int32,array(int64,ndim=1),int32,array(int64,ndim=1))')
  def make_integer(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.NilVariable.make_integer()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_NilVariable._match_make_1integer_(*args):
      return self._make_1integer_(*args)
    elif mosek_fusion_NilVariable._match_alt_make_1integer_(*args):
      return self._make_1integer_alt_(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.make_integer()')
  def slice(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.NilVariable.slice(int32,int32)
      mosek.fusion.NilVariable.slice(array(int32,ndim=1),array(int32,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    first : array(int32,ndim=1)
    last : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_NilVariable._match_slice_II(*args):
      return self._slice_II(*args)
    elif mosek_fusion_NilVariable._match_alt_slice_II(*args):
      return self._slice_alt_II(*args)
    elif mosek_fusion_NilVariable._match_slice__3I_3I(*args):
      return self._slice__3I_3I(*args)
    elif mosek_fusion_NilVariable._match_alt_slice__3I_3I(*args):
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.slice(int32,int32)\n\tmosek.fusion.NilVariable.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def set_values(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.NilVariable.set_values(array(double,ndim=1),bool)

    Description
    -----------

    

    Parameters
    ----------

    primal : bool
    target : array(double,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_NilVariable._match_set_1values__3DZ(*args):
      return self._set_1values__3DZ(*args)
    elif mosek_fusion_NilVariable._match_alt_set_1values__3DZ(*args):
      return self._set_1values_alt__3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.set_values(array(double,ndim=1),bool)')
  def make_continuous(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.NilVariable.make_continuous()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_NilVariable._match_make_1continuous_(*args):
      return self._make_1continuous_(*args)
    elif mosek_fusion_NilVariable._match_alt_make_1continuous_(*args):
      return self._make_1continuous_alt_(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.make_continuous()')
  def values(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.NilVariable.values(int32,array(double,ndim=1),bool)

    Description
    -----------

    

    Parameters
    ----------

    offset : int32
    primal : bool
    target : array(double,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_NilVariable._match_values_I_3DZ(*args):
      return self._values_I_3DZ(*args)
    elif mosek_fusion_NilVariable._match_alt_values_I_3DZ(*args):
      return self._values_alt_I_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.values(int32,array(double,ndim=1),bool)')
  def __repr__(self): return 'mosek.fusion.NilVariable'
  @staticmethod
  def _ctor__3I(shape):
    o = NilVariable.__new__(NilVariable)
    o._ctor_init__3I(shape)
    return o
  @staticmethod
  def __match_ctor__3I(*args):
    if len(args) != 1: return False
    shape, = args
    return (__arg_match__3I__(shape))
  @staticmethod
  def __match_alt_ctor__3I(*args):
    if len(args) != 1: return False
    shape, = args
    return (__arg_alt_match__3I__(shape))
  def _ctor_alt_init__3I(self,shape):
    self._ctor_init__3I(numpy.array(shape,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init__3I(self,shape):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(self,None,mosek.fusion.Utils.Tools._arraycopy__3I(shape),numpy.zeros((0,), dtype=numpy.dtype(numpy.int64)),numpy.zeros((0,), dtype=numpy.dtype(numpy.int64)))
   (self.__shape) = numpy.array([shape[_a_0] for _a_0 in range(0,int((shape).shape[0]))], dtype=numpy.dtype(numpy.int32))
  @staticmethod
  def _ctor_():
    o = NilVariable.__new__(NilVariable)
    o._ctor_init_()
    return o
  @staticmethod
  def __match_ctor_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def __match_alt_ctor_(*args):
    if len(args) != 0: return False
    return True
  def _ctor_alt_init_(self,):
    self._ctor_init_()
  def _ctor_init_(self,):
   mosek_fusion_NilVariable._ctor_init__3I(self,numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)))
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_J__(_a_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_a_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_J__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_a_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__a_0,_t__a_1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__a_0),_a_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_a_0,_a_1):
   return (_a_1)
  @staticmethod
  def _match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_J__(_a_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_a_1))
  @staticmethod
  def _match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_J__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_a_1))
  def _elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__a_0,_t__a_1):
    return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__a_0),_a_1)
  def _elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_a_0,_a_1):
   pass
  @staticmethod
  def _match_numInst_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_numInst_(*args):
    if len(args) != 0: return False
    return True
  def _numInst_alt_(self,):
    return self._numInst_()
  def _numInst_(self,):
   return numpy.int32(0)
  @staticmethod
  def _match_inst_I_3J_3J(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_I__(_a_0) and __arg_match__3J__(_a_1) and __arg_match__3J__(_a_2))
  @staticmethod
  def _match_alt_inst_I_3J_3J(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match__3J__(_a_1) and __arg_alt_match__3J__(_a_2))
  def _inst_alt_I_3J_3J(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int64))
   _1_res = self._inst_I_3J_3J(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _inst_I_3J_3J(self,_a_0,_a_1,_a_2):
   return numpy.int32(0)
  @staticmethod
  def _match_inst_I_3J(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match__3J__(_a_1))
  @staticmethod
  def _match_alt_inst_I_3J(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match__3J__(_a_1))
  def _inst_alt_I_3J(self,_t__a_0,_t__a_1):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int64))
   _1_res = self._inst_I_3J(_a_0,_a_1)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _inst_I_3J(self,_a_0,_a_1):
   pass
  @staticmethod
  def _match_set_1values__3DZ(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3D__(_a_0) and __arg_match_Z__(_a_1))
  @staticmethod
  def _match_alt_set_1values__3DZ(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3D__(_a_0) and __arg_alt_match_Z__(_a_1))
  def _set_1values_alt__3DZ(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.float64))
   _a_1=_t__a_1
   _1_res = self._set_1values__3DZ(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _set_1values__3DZ(self,_a_0,_a_1):
   pass
  @staticmethod
  def _match_values_I_3DZ(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_I__(_a_0) and __arg_match__3D__(_a_1) and __arg_match_Z__(_a_2))
  @staticmethod
  def _match_alt_values_I_3DZ(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match__3D__(_a_1) and __arg_alt_match_Z__(_a_2))
  def _values_alt_I_3DZ(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.float64))
   _a_2=_t__a_2
   _1_res = self._values_I_3DZ(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _values_I_3DZ(self,_a_0,_a_1,_a_2):
   pass
  @staticmethod
  def _match_make_1continuous_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_make_1continuous_(*args):
    if len(args) != 0: return False
    return True
  def _make_1continuous_alt_(self,):
    return self._make_1continuous_()
  def _make_1continuous_(self,):
   pass
  @staticmethod
  def _match_make_1integer_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_make_1integer_(*args):
    if len(args) != 0: return False
    return True
  def _make_1integer_alt_(self,):
    return self._make_1integer_()
  def _make_1integer_(self,):
   pass
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   return ("NilVariable")
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _index_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._index__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _index__3I(self,_a_0):
   return (mosek_fusion_NilVariable._ctor__3I(numpy.array([1 for _a_1 in range(0,int((self.__shape).shape[0]))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _index_alt_I(self,_t__a_0):
    return self._index_I(numpy.int32(__a_0))
  def _index_I(self,_a_0):
   return (mosek_fusion_NilVariable._ctor__3I(numpy.array([1 for _a_1 in range(0,int((self.__shape).shape[0]))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1))
  def _slice_alt__3I_3I(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._slice__3I_3I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _slice__3I_3I(self,_a_0,_a_1):
   if ((int((self.__shape).shape[0])!=int((_a_0).shape[0])) or (int((self.__shape).shape[0])!=int((_a_1).shape[0]))):
    raise mosek_fusion_DimensionError._ctor_S("Mismatching slice shape")
   for _a_2 in range(0,int((_a_0).shape[0])):
    if ((_a_1[_a_2] > _a_0[_a_2]) or ((_a_0[_a_2] < 0) or (_a_1[_a_2] >= self.__shape[_a_2]))):
     raise mosek_fusion_SliceError._ctor_S("Slice is out of bounds")
   return (mosek_fusion_NilVariable._ctor__3I(numpy.array([(_a_1[_a_3] - _a_0[_a_3]) for _a_3 in range(0,int((self.__shape).shape[0]))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1))
  def _slice_alt_II(self,_t__a_0,_t__a_1):
    return self._slice_II(numpy.int32(__a_0),numpy.int32(__a_1))
  def _slice_II(self,_a_0,_a_1):
   if ((_a_1 > _a_0) or ((_a_0 < 0) or (_a_1 > self.__shape[0]))):
    raise mosek_fusion_SliceError._ctor_S("Slice is out of bounds")
   elif (int((self.__shape).shape[0])!=1):
    raise mosek_fusion_DimensionError._ctor_S("Mismatching slice shape")
   else:
    return (mosek_fusion_NilVariable._ctor__3I(numpy.array([(_a_1 - _a_0)], dtype=numpy.dtype(numpy.int32))))
 return NilVariable
mosek_fusion_NilVariable=__mk_mosek_fusion_NilVariable()
del __mk_mosek_fusion_NilVariable
#BEFORE CLASS
def __mk_mosek_fusion_Var():
 class Var(object):
  @staticmethod
  def hstack(*args):
    '''
    Syntax
    ------

      mosek.fusion.Var.hstack(array(mosek.fusion.Variable,ndim=1))
      mosek.fusion.Var.hstack(mosek.fusion.Variable,mosek.fusion.Variable)
      mosek.fusion.Var.hstack(mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable)

    Description
    -----------

    Stack three variables in second dimension. 

    Parameters
    ----------

    v : array(mosek.fusion.Variable,ndim=1)
        List of variables to stack.
    v1 : mosek.fusion.Variable
        First variable in the stack.
    v2 : mosek.fusion.Variable
        Second variable in the stack.
    v3 : mosek.fusion.Variable
        Third variable in the stack.
    '''
    if False: pass
    elif mosek_fusion_Var._match_hstack__3Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._hstack__3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_hstack__3Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._hstack_alt__3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._hstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._hstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    else:
      raise ValueError('Invalid argument list hstack('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.hstack(array(mosek.fusion.Variable,ndim=1))\n\tmosek.fusion.Var.hstack(mosek.fusion.Variable,mosek.fusion.Variable)\n\tmosek.fusion.Var.hstack(mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable)')
  @staticmethod
  def reshape(*args):
    '''
    Syntax
    ------

      mosek.fusion.Var.reshape(mosek.fusion.Variable,array(int32,ndim=1))
      mosek.fusion.Var.reshape(mosek.fusion.Variable,int32)
      mosek.fusion.Var.reshape(mosek.fusion.Variable,int32,int32)

    Description
    -----------

    Reshape a variable object. 

    Parameters
    ----------

    d1 : int32
        Size of first dimension in the result.
    d2 : int32
        Size of second dimension in the result.
    shape : array(int32,ndim=1)
        An array containing the shape of the new variable.
    v : mosek.fusion.Variable
        A variable object.
    '''
    if False: pass
    elif mosek_fusion_Var._match_reshape_Lmosek_4fusion_4Variable_2_3I(*args):
      return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2_3I(*args)
    elif mosek_fusion_Var._match_alt_reshape_Lmosek_4fusion_4Variable_2_3I(*args):
      return mosek_fusion_Var._reshape_alt_Lmosek_4fusion_4Variable_2_3I(*args)
    elif mosek_fusion_Var._match_reshape_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_reshape_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._reshape_alt_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_reshape_Lmosek_4fusion_4Variable_2II(*args):
      return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2II(*args)
    elif mosek_fusion_Var._match_alt_reshape_Lmosek_4fusion_4Variable_2II(*args):
      return mosek_fusion_Var._reshape_alt_Lmosek_4fusion_4Variable_2II(*args)
    else:
      raise ValueError('Invalid argument list reshape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.reshape(mosek.fusion.Variable,array(int32,ndim=1))\n\tmosek.fusion.Var.reshape(mosek.fusion.Variable,int32)\n\tmosek.fusion.Var.reshape(mosek.fusion.Variable,int32,int32)')
  @staticmethod
  def hrepeat(*args):
    '''
    Syntax
    ------

      mosek.fusion.Var.hrepeat(mosek.fusion.Variable,int32)

    Description
    -----------

    Repeat a variable a number of times in the second dimension.

    Parameters
    ----------

    n : int32
        Number of times to repeat ``v``.
    v : mosek.fusion.Variable
        A variable object.
    '''
    if False: pass
    elif mosek_fusion_Var._match_hrepeat_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._hrepeat_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_hrepeat_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._hrepeat_alt_Lmosek_4fusion_4Variable_2I(*args)
    else:
      raise ValueError('Invalid argument list hrepeat('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.hrepeat(mosek.fusion.Variable,int32)')
  @staticmethod
  def empty(*args):
    '''
    Syntax
    ------

      mosek.fusion.Var.empty(array(int32,ndim=1))

    Description
    -----------

    
    Produce a new empty variable of the given shape.
          

    Parameters
    ----------

    shape : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Var._match_empty__3I(*args):
      return mosek_fusion_Var._empty__3I(*args)
    elif mosek_fusion_Var._match_alt_empty__3I(*args):
      return mosek_fusion_Var._empty_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list empty('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.empty(array(int32,ndim=1))')
  @staticmethod
  def repeat(*args):
    '''
    Syntax
    ------

      mosek.fusion.Var.repeat(mosek.fusion.Variable,int32)
      mosek.fusion.Var.repeat(mosek.fusion.Variable,int32,int32)

    Description
    -----------

    Repeat a variable a number of times in the given dimension.

    Parameters
    ----------

    dim : int32
        Dimension to repeat in. 
    n : int32
        Number of times to repeat ``v``.
    v : mosek.fusion.Variable
        A variable object.
    '''
    if False: pass
    elif mosek_fusion_Var._match_repeat_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._repeat_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_repeat_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._repeat_alt_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_repeat_Lmosek_4fusion_4Variable_2II(*args):
      return mosek_fusion_Var._repeat_Lmosek_4fusion_4Variable_2II(*args)
    elif mosek_fusion_Var._match_alt_repeat_Lmosek_4fusion_4Variable_2II(*args):
      return mosek_fusion_Var._repeat_alt_Lmosek_4fusion_4Variable_2II(*args)
    else:
      raise ValueError('Invalid argument list repeat('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.repeat(mosek.fusion.Variable,int32)\n\tmosek.fusion.Var.repeat(mosek.fusion.Variable,int32,int32)')
  @staticmethod
  def vstack(*args):
    '''
    Syntax
    ------

      mosek.fusion.Var.vstack(array(mosek.fusion.Variable,ndim=1))
      mosek.fusion.Var.vstack(mosek.fusion.Variable,mosek.fusion.Variable)
      mosek.fusion.Var.vstack(mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable)

    Description
    -----------

    Stack three variables. 

    Parameters
    ----------

    v : array(mosek.fusion.Variable,ndim=1)
        List of variables to stack.
    v1 : mosek.fusion.Variable
        First variable in the stack.
    v2 : mosek.fusion.Variable
        Second variable in the stack.
    v3 : mosek.fusion.Variable
        Third variable in the stack.
    '''
    if False: pass
    elif mosek_fusion_Var._match_vstack__3Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._vstack__3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_vstack__3Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._vstack_alt__3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._vstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._vstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    else:
      raise ValueError('Invalid argument list vstack('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.vstack(array(mosek.fusion.Variable,ndim=1))\n\tmosek.fusion.Var.vstack(mosek.fusion.Variable,mosek.fusion.Variable)\n\tmosek.fusion.Var.vstack(mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable)')
  @staticmethod
  def flatten(*args):
    '''
    Syntax
    ------

      mosek.fusion.Var.flatten(mosek.fusion.Variable)

    Description
    -----------

    Create a one-dimensional logical view of a variable object.

    Parameters
    ----------

    v : mosek.fusion.Variable
    '''
    if False: pass
    elif mosek_fusion_Var._match_flatten_Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._flatten_Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_flatten_Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._flatten_alt_Lmosek_4fusion_4Variable_2(*args)
    else:
      raise ValueError('Invalid argument list flatten('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.flatten(mosek.fusion.Variable)')
  @staticmethod
  def promote(*args):
    '''
    Syntax
    ------

      mosek.fusion.Var.promote(mosek.fusion.Variable,int32)

    Description
    -----------

    Pad variable shape.

    Parameters
    ----------

    nd : int32
    v : mosek.fusion.Variable
    '''
    if False: pass
    elif mosek_fusion_Var._match_promote_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._promote_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_promote_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._promote_alt_Lmosek_4fusion_4Variable_2I(*args)
    else:
      raise ValueError('Invalid argument list promote('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.promote(mosek.fusion.Variable,int32)')
  @staticmethod
  def vrepeat(*args):
    '''
    Syntax
    ------

      mosek.fusion.Var.vrepeat(mosek.fusion.Variable,int32)

    Description
    -----------

    Repeat a variable a number of times in the first dimension.

    Parameters
    ----------

    n : int32
        Number of times to repeat ``v``.
    v : mosek.fusion.Variable
        A variable object.
    '''
    if False: pass
    elif mosek_fusion_Var._match_vrepeat_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._vrepeat_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_vrepeat_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._vrepeat_alt_Lmosek_4fusion_4Variable_2I(*args)
    else:
      raise ValueError('Invalid argument list vrepeat('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.vrepeat(mosek.fusion.Variable,int32)')
  @staticmethod
  def compress(*args):
    '''
    Syntax
    ------

      mosek.fusion.Var.compress(mosek.fusion.Variable)

    Description
    -----------

    Reshape a variable object by removing all dimensions of size 1. 

    Parameters
    ----------

    v : mosek.fusion.Variable
    '''
    if False: pass
    elif mosek_fusion_Var._match_compress_Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._compress_Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_compress_Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._compress_alt_Lmosek_4fusion_4Variable_2(*args)
    else:
      raise ValueError('Invalid argument list compress('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.compress(mosek.fusion.Variable)')
  @staticmethod
  def stack(*args):
    '''
    Syntax
    ------

      mosek.fusion.Var.stack(array(array(mosek.fusion.Variable,ndim=1),ndim=1))
      mosek.fusion.Var.stack(array(mosek.fusion.Variable,ndim=1),int32)
      mosek.fusion.Var.stack(int32,array(mosek.fusion.Variable,ndim=1))
      mosek.fusion.Var.stack(mosek.fusion.Variable,mosek.fusion.Variable,int32)
      mosek.fusion.Var.stack(int32,mosek.fusion.Variable,mosek.fusion.Variable)
      mosek.fusion.Var.stack(mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable,int32)
      mosek.fusion.Var.stack(int32,mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable)

    Description
    -----------

    Create a stacked variable. 

    Parameters
    ----------

    dim : int32
        Dimension in which to stack.
    v : array(mosek.fusion.Variable,ndim=1)
        List of variables to stack.
    v1 : mosek.fusion.Variable
        First variable in the stack.
    v2 : mosek.fusion.Variable
        Second variable in the stack.
    v3 : mosek.fusion.Variable
        Third variable in the stack.
    vlist : array(array(mosek.fusion.Variable,ndim=1),ndim=1)
        List of variables to stack.
    '''
    if False: pass
    elif mosek_fusion_Var._match_stack__3_3Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._stack__3_3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_stack__3_3Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._stack_alt__3_3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_stack__3Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._stack__3Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_stack__3Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._stack_alt__3Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_stack_I_3Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._stack_I_3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_stack_I_3Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._stack_alt_I_3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._stack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._stack_alt_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._stack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._stack_alt_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    else:
      raise ValueError('Invalid argument list stack('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.stack(array(array(mosek.fusion.Variable,ndim=1),ndim=1))\n\tmosek.fusion.Var.stack(array(mosek.fusion.Variable,ndim=1),int32)\n\tmosek.fusion.Var.stack(int32,array(mosek.fusion.Variable,ndim=1))\n\tmosek.fusion.Var.stack(mosek.fusion.Variable,mosek.fusion.Variable,int32)\n\tmosek.fusion.Var.stack(int32,mosek.fusion.Variable,mosek.fusion.Variable)\n\tmosek.fusion.Var.stack(mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable,int32)\n\tmosek.fusion.Var.stack(int32,mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable)')
  def __repr__(self): return 'mosek.fusion.Var'
  @staticmethod
  def _match_empty__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_empty__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  @staticmethod
  def _empty_alt__3I(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Var._empty__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _empty__3I(_a_0):
   for _a_1 in range(0,int((_a_0).shape[0])):
    if (_a_0[_a_1] < 0):
     raise mosek_fusion_DimensionError._ctor_S("Invalid shape")
   return (mosek_fusion_NilVariable._ctor__3I(_a_0))
  @staticmethod
  def _match_compress_Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0))
  @staticmethod
  def _match_alt_compress_Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0))
  @staticmethod
  def _compress_alt_Lmosek_4fusion_4Variable_2(_t__a_0):
    return mosek_fusion_Var._compress_Lmosek_4fusion_4Variable_2(_a_0)
  @staticmethod
  def _compress_Lmosek_4fusion_4Variable_2(_a_0):
   _a_1=_a_0._getShape_()
   _a_2=int((_a_1).shape[0])
   _a_3=0
   _a_3 = fragments._c_closure_204(_a_2,_a_3,_a_1)
   _a_3 = numpy.int32(_a_3) # postprocess
   _a_4=numpy.zeros((_a_3,), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_205(_a_2,_a_4,_a_1) 
   return (mosek.fusion.Var._reshape_Lmosek_4fusion_4Variable_2_3I(_a_0,_a_4))
  @staticmethod
  def _match_reshape_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_reshape_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match_I__(_a_1))
  @staticmethod
  def _reshape_alt_Lmosek_4fusion_4Variable_2I(_t__a_0,_t__a_1):
    return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2I(_a_0,numpy.int32(__a_1))
  @staticmethod
  def _reshape_Lmosek_4fusion_4Variable_2I(_a_0,_a_1):
   return (mosek.fusion.Var._reshape_Lmosek_4fusion_4Variable_2_3I(_a_0,numpy.array([_a_1], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_reshape_Lmosek_4fusion_4Variable_2II(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match_I__(_a_1) and __arg_match_I__(_a_2))
  @staticmethod
  def _match_alt_reshape_Lmosek_4fusion_4Variable_2II(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_I__(_a_2))
  @staticmethod
  def _reshape_alt_Lmosek_4fusion_4Variable_2II(_t__a_0,_t__a_1,_t__a_2):
    return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2II(_a_0,numpy.int32(__a_1),numpy.int32(__a_2))
  @staticmethod
  def _reshape_Lmosek_4fusion_4Variable_2II(_a_0,_a_1,_a_2):
   return (mosek.fusion.Var._reshape_Lmosek_4fusion_4Variable_2_3I(_a_0,numpy.array([_a_1,_a_2], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_flatten_Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0))
  @staticmethod
  def _match_alt_flatten_Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0))
  @staticmethod
  def _flatten_alt_Lmosek_4fusion_4Variable_2(_t__a_0):
    return mosek_fusion_Var._flatten_Lmosek_4fusion_4Variable_2(_a_0)
  @staticmethod
  def _flatten_Lmosek_4fusion_4Variable_2(_a_0):
   return (mosek.fusion.Var._reshape_Lmosek_4fusion_4Variable_2_3I(_a_0,numpy.array([numpy.int32(mosek.fusion.Set._size__3I(_a_0._getShape_()))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_reshape_Lmosek_4fusion_4Variable_2_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_reshape_Lmosek_4fusion_4Variable_2_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match__3I__(_a_1))
  @staticmethod
  def _reshape_alt_Lmosek_4fusion_4Variable_2_3I(_t__a_0,_t__a_1):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2_3I(_a_0,_a_1)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _reshape_Lmosek_4fusion_4Variable_2_3I(_a_0,_a_1):
   return (_a_0._reshape__3I(_a_1))
  @staticmethod
  def _index_1permute_1_alt_Lmosek_4fusion_4Variable_2_3I(_t__a_0,_t__a_1):
   _a_0=_t__a_0
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Var._index_1permute_1_Lmosek_4fusion_4Variable_2_3I(_a_0,_a_1)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _index_1permute_1_Lmosek_4fusion_4Variable_2_3I(_a_0,_a_1):
   _a_4=_a_0._getShape_()
   _a_5=int((_a_4).shape[0])
   _a_6=1
   _a_6 = fragments._c_closure_206(_a_5,_a_4,_a_6)
   _a_6 = numpy.int32(_a_6) # postprocess
   _a_7=_a_0._numInst_()
   _a_8=numpy.zeros((_a_5,), dtype=numpy.dtype(numpy.int64))
   _a_8[(_a_5 - 1)] = 1
   fragments._c_closure_207(_a_5,_a_1,_a_8,_a_4) 
   if (_a_7 < _a_6):
    _a_2 = numpy.zeros((_a_7,), dtype=numpy.dtype(numpy.int64))
    _a_3 = numpy.zeros((_a_7,), dtype=numpy.dtype(numpy.int64))
    _a_0._inst_I_3JI_3J(0,_a_2,0,_a_3)
   else:
    _a_2 = None
    _a_3 = numpy.zeros((_a_7,), dtype=numpy.dtype(numpy.int64))
    _a_0._inst_I_3J(0,_a_3)
   if (_a_2 is None):
    _a_9=numpy.zeros((_a_7,), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_208(_a_3,_a_5,_a_7,_a_1,_a_8,_a_9,_a_4) 
    _a_3 = _a_9
   else:
    _a_10=numpy.zeros((_a_7,), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_209(_a_5,_a_7,_a_1,_a_8,_a_10,_a_4) 
    _a_11=numpy.array([_a_12 for _a_12 in range(0,_a_7)], dtype=numpy.dtype(numpy.int64))
    mosek.fusion.CommonTools._argQsort__3J_3J_3JJJ(_a_11,_a_10,None,0,_a_7)
    _a_2 = numpy.array([_a_2[_a_11[_a_13]] for _a_13 in range(0,_a_7)], dtype=numpy.dtype(numpy.int64))
    _a_3 = numpy.array([_a_3[_a_11[_a_14]] for _a_14 in range(0,_a_7)], dtype=numpy.dtype(numpy.int64))
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(_a_0._getModel_(),numpy.array([_a_4[_a_1[_a_15]] for _a_15 in range(0,_a_5)], dtype=numpy.dtype(numpy.int32)),_a_2,_a_3))
  @staticmethod
  def _match_hrepeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_hrepeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match_I__(_a_1))
  @staticmethod
  def _hrepeat_alt_Lmosek_4fusion_4Variable_2I(_t__a_0,_t__a_1):
    return mosek_fusion_Var._hrepeat_Lmosek_4fusion_4Variable_2I(_a_0,numpy.int32(__a_1))
  @staticmethod
  def _hrepeat_Lmosek_4fusion_4Variable_2I(_a_0,_a_1):
   return (mosek.fusion.Var.__drepeat_Lmosek_4fusion_4Variable_2II(_a_0,1,_a_1))
  @staticmethod
  def _match_vrepeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_vrepeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match_I__(_a_1))
  @staticmethod
  def _vrepeat_alt_Lmosek_4fusion_4Variable_2I(_t__a_0,_t__a_1):
    return mosek_fusion_Var._vrepeat_Lmosek_4fusion_4Variable_2I(_a_0,numpy.int32(__a_1))
  @staticmethod
  def _vrepeat_Lmosek_4fusion_4Variable_2I(_a_0,_a_1):
   return (mosek.fusion.Var.__drepeat_Lmosek_4fusion_4Variable_2II(_a_0,0,_a_1))
  @staticmethod
  def _match_repeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_repeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match_I__(_a_1))
  @staticmethod
  def _repeat_alt_Lmosek_4fusion_4Variable_2I(_t__a_0,_t__a_1):
    return mosek_fusion_Var._repeat_Lmosek_4fusion_4Variable_2I(_a_0,numpy.int32(__a_1))
  @staticmethod
  def _repeat_Lmosek_4fusion_4Variable_2I(_a_0,_a_1):
   return (mosek.fusion.Var.__drepeat_Lmosek_4fusion_4Variable_2II(_a_0,0,_a_1))
  @staticmethod
  def _match_repeat_Lmosek_4fusion_4Variable_2II(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match_I__(_a_1) and __arg_match_I__(_a_2))
  @staticmethod
  def _match_alt_repeat_Lmosek_4fusion_4Variable_2II(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_I__(_a_2))
  @staticmethod
  def _repeat_alt_Lmosek_4fusion_4Variable_2II(_t__a_0,_t__a_1,_t__a_2):
    return mosek_fusion_Var._repeat_Lmosek_4fusion_4Variable_2II(_a_0,numpy.int32(__a_1),numpy.int32(__a_2))
  @staticmethod
  def _repeat_Lmosek_4fusion_4Variable_2II(_a_0,_a_1,_a_2):
   return (mosek.fusion.Var.__drepeat_Lmosek_4fusion_4Variable_2II(_a_0,_a_2,_a_1))
  @staticmethod
  def __drepeat_alt_Lmosek_4fusion_4Variable_2II(_t__a_0,_t__a_1,_t__a_2):
    return mosek_fusion_Var.__drepeat_Lmosek_4fusion_4Variable_2II(_a_0,numpy.int32(__a_1),numpy.int32(__a_2))
  @staticmethod
  def __drepeat_Lmosek_4fusion_4Variable_2II(_a_0,_a_1,_a_2):
   if (_a_2 < 0):
    raise mosek_fusion_LengthError._ctor_S("Cannot repeat less than 0 times")
   elif (_a_2==0):
    _a_3=_a_0._getShape_()
    _a_4=_a_3
    if (int((_a_3).shape[0])==_a_1):
     _a_4 = numpy.zeros(((_a_1 + 1),), dtype=numpy.dtype(numpy.int32))
     fragments._c_closure_210(_a_1,_a_4,_a_3) 
    _a_4[_a_1] = 0
    mosek.fusion.Debug._o_()._p_S("drepeat dim=")._p_I(_a_1)._p_S(", n=")._p_I(_a_2)._p_S(", shape=")._p__3I(_a_0._getShape_())._p_S(" -> ")._p__3I(_a_4)._lf_()
    return (mosek_fusion_NilVariable._ctor__3I(_a_4))
   elif (_a_2==1):
    _a_5=_a_0._getShape_()
    _a_6=_a_5
    if (int((_a_5).shape[0])==_a_1):
     _a_6 = numpy.zeros(((_a_1 + 1),), dtype=numpy.dtype(numpy.int32))
     fragments._c_closure_211(_a_1,_a_6,_a_5) 
     _a_6[_a_1] = 1
    mosek.fusion.Debug._o_()._p_S("drepeat dim=")._p_I(_a_1)._p_S(", n=")._p_I(_a_2)._p_S(", shape=")._p__3I(_a_0._getShape_())._p_S(" -> ")._p__3I(_a_6)._lf_()
    return (_a_0)
   else:
    _a_7=_a_0._getModel_()
    _a_8=_a_0._getShape_()
    _a_9=int((_a_8).shape[0])
    if ((_a_1 < 0) or (_a_1 > _a_9)):
     raise mosek_fusion_DimensionError._ctor_S("Invalid stacking dimension")
    _a_10=mosek.fusion.Set._size__3I(_a_8)
    _a_11=_a_0._numInst_()
    _a_12=(_a_11 * _a_2)
    _a_13=1
    _a_13 = fragments._c_closure_212(_a_13,_a_1,_a_8)
    _a_13 = numpy.int32(_a_13) # postprocess
    _a_14=(_a_8[_a_1] if ((_a_1 < _a_9) ) else 1)
    _a_15=(_a_14 * _a_2)
    _a_16=1
    _a_16 = fragments._c_closure_213(_a_16,_a_1,_a_9,_a_8)
    _a_16 = numpy.int32(_a_16) # postprocess
    _a_17=(_a_9 if ((_a_1 < _a_9) ) else (_a_1 + 1))
    _a_18=numpy.zeros((_a_17,), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_214(_a_9,_a_18,_a_8) 
    fragments._c_closure_215(_a_9,_a_17,_a_18) 
    _a_18[_a_1] = _a_15
    if (_a_11 < _a_10):
     _a_19=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.int64))
     _a_20=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.int64))
     _a_21=numpy.zeros((_a_12,), dtype=numpy.dtype(numpy.int64))
     _a_22=numpy.zeros((_a_12,), dtype=numpy.dtype(numpy.int64))
     _a_0._inst_I_3JI_3J(0,_a_20,0,_a_19)
     _a_23=(_a_15 * _a_16)
     _a_24=(_a_14 * _a_16)
     _a_25=_a_16
     if (_a_1==0):
      _a_26=0
      _a_26 = fragments._c_closure_216(_a_10,_a_26,_a_2,_a_11,_a_21,_a_22,_a_19,_a_20)
      _a_26 = numpy.int32(_a_26) # postprocess
      return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(_a_7,_a_18,_a_22,_a_21))
     elif (_a_1 >= _a_9):
      _a_27=0
      _a_27 = fragments._c_closure_217(_a_27,_a_2,_a_11,_a_21,_a_22,_a_19,_a_20)
      _a_27 = numpy.int32(_a_27) # postprocess
      return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(_a_7,_a_18,_a_22,_a_21))
     else:
      _a_28=0
      _a_28 = fragments._c_closure_218(_a_14,_a_16,_a_28,_a_2,_a_11,_a_23,_a_21,_a_22,_a_24,_a_25,_a_19,_a_20)
      _a_28 = numpy.int32(_a_28) # postprocess
      _a_29=1
      _a_29 = fragments._c_closure_219(_a_29,_a_17,_a_18)
      _a_29 = numpy.int32(_a_29) # postprocess
      _a_30=numpy.zeros((_a_12,), dtype=numpy.dtype(numpy.int32))
      _a_31=numpy.zeros((_a_12,), dtype=numpy.dtype(numpy.int32))
      _a_32=numpy.zeros(((_a_29 + 1),), dtype=numpy.dtype(numpy.int32))
      _a_33=numpy.zeros((_a_17,), dtype=numpy.dtype(numpy.int64))
      _a_33[(_a_17 - 1)] = 1
      fragments._c_closure_220(_a_17,_a_18,_a_33) 
      fragments._c_closure_221(_a_30,_a_12) 
      for _a_34 in range(0,_a_17):
       _a_35=((_a_17 - _a_34) - 1)
       fragments._c_closure_222(_a_35,_a_32,_a_18) 
       fragments._c_closure_223(_a_35,_a_32,_a_12,_a_18,_a_22,_a_33) 
       fragments._c_closure_224(_a_35,_a_32,_a_18) 
       fragments._c_closure_225(_a_30,_a_35,_a_32,_a_12,_a_18,_a_22,_a_33,_a_31) 
       _a_36=_a_30
       _a_30 = _a_31
       _a_31 = _a_36
      return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(_a_7,_a_18,numpy.array([_a_22[_a_30[_a_37]] for _a_37 in range(0,_a_12)], dtype=numpy.dtype(numpy.int64)),numpy.array([_a_21[_a_30[_a_38]] for _a_38 in range(0,_a_12)], dtype=numpy.dtype(numpy.int64))))
    else:
     _a_39=numpy.zeros((_a_11,), dtype=numpy.dtype(numpy.int64))
     _a_40=numpy.zeros(((_a_11 * _a_2),), dtype=numpy.dtype(numpy.int64))
     _a_0._inst_I_3J(0,_a_39)
     _a_41=(_a_15 * _a_16)
     _a_42=_a_16
     _a_43=0
     _a_43 = fragments._c_closure_226(_a_13,_a_14,_a_16,_a_43,_a_2,_a_40,_a_41,_a_42,_a_39)
     _a_43 = numpy.int32(_a_43) # postprocess
     return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(_a_7,_a_18,None,_a_40))
  @staticmethod
  def _match_stack__3_3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3_3Lmosek_4fusion_4Variable_2__(_a_0))
  @staticmethod
  def _match_alt_stack__3_3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3_3Lmosek_4fusion_4Variable_2__(_a_0))
  @staticmethod
  def _stack_alt__3_3Lmosek_4fusion_4Variable_2(_t__a_0):
   _a_0=_monty.makeJaggedArray(_t__a_0,(1,1),numpy.dtype(object))
   _1_res = mosek_fusion_Var._stack__3_3Lmosek_4fusion_4Variable_2(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _stack__3_3Lmosek_4fusion_4Variable_2(_a_0):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(_a_0[_a_1],1) for _a_1 in range(0,int((_a_0).shape[0]))], dtype=numpy.dtype(object)),0))
  @staticmethod
  def _match_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_2))
  @staticmethod
  def _match_alt_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_2))
  @staticmethod
  def _vstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_t__a_0,_t__a_1,_t__a_2):
    return mosek_fusion_Var._vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_a_0,_a_1,_a_2)
  @staticmethod
  def _vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_a_0,_a_1,_a_2):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_a_0,_a_1,_a_2], dtype=numpy.dtype(object)),0))
  @staticmethod
  def _match_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_1))
  @staticmethod
  def _match_alt_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_1))
  @staticmethod
  def _vstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_t__a_0,_t__a_1):
    return mosek_fusion_Var._vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_a_0,_a_1)
  @staticmethod
  def _vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_a_0,_a_1):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_a_0,_a_1], dtype=numpy.dtype(object)),0))
  @staticmethod
  def _match_vstack__3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3Lmosek_4fusion_4Variable_2__(_a_0))
  @staticmethod
  def _match_alt_vstack__3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Variable_2__(_a_0))
  @staticmethod
  def _vstack_alt__3Lmosek_4fusion_4Variable_2(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_Var._vstack__3Lmosek_4fusion_4Variable_2(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _vstack__3Lmosek_4fusion_4Variable_2(_a_0):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(_a_0,0))
  @staticmethod
  def _match_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_2))
  @staticmethod
  def _match_alt_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_2))
  @staticmethod
  def _hstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_t__a_0,_t__a_1,_t__a_2):
    return mosek_fusion_Var._hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_a_0,_a_1,_a_2)
  @staticmethod
  def _hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_a_0,_a_1,_a_2):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_a_0,_a_1,_a_2], dtype=numpy.dtype(object)),1))
  @staticmethod
  def _match_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_1))
  @staticmethod
  def _match_alt_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_1))
  @staticmethod
  def _hstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_t__a_0,_t__a_1):
    return mosek_fusion_Var._hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_a_0,_a_1)
  @staticmethod
  def _hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_a_0,_a_1):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_a_0,_a_1], dtype=numpy.dtype(object)),1))
  @staticmethod
  def _match_hstack__3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3Lmosek_4fusion_4Variable_2__(_a_0))
  @staticmethod
  def _match_alt_hstack__3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Variable_2__(_a_0))
  @staticmethod
  def _hstack_alt__3Lmosek_4fusion_4Variable_2(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_Var._hstack__3Lmosek_4fusion_4Variable_2(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _hstack__3Lmosek_4fusion_4Variable_2(_a_0):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(_a_0,1))
  @staticmethod
  def _match_stack__3Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_stack__3Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match_I__(_a_1))
  @staticmethod
  def _stack_alt__3Lmosek_4fusion_4Variable_2I(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(object))
   _a_1=numpy.int32(_t__a_1)
   _1_res = mosek_fusion_Var._stack__3Lmosek_4fusion_4Variable_2I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _stack__3Lmosek_4fusion_4Variable_2I(_a_0,_a_1):
   return (mosek.fusion.Var._stack_I_3Lmosek_4fusion_4Variable_2(_a_1,_a_0))
  @staticmethod
  def _match_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_2) and __arg_match_I__(_a_3))
  @staticmethod
  def _match_alt_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_2) and __arg_alt_match_I__(_a_3))
  @staticmethod
  def _stack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_t__a_0,_t__a_1,_t__a_2,_t__a_3):
    return mosek_fusion_Var._stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_a_0,_a_1,_a_2,numpy.int32(__a_3))
  @staticmethod
  def _stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_a_0,_a_1,_a_2,_a_3):
   return (mosek.fusion.Var._stack_I_3Lmosek_4fusion_4Variable_2(_a_3,numpy.array([_a_0,_a_1,_a_2], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_1) and __arg_match_I__(_a_2))
  @staticmethod
  def _match_alt_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_1) and __arg_alt_match_I__(_a_2))
  @staticmethod
  def _stack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_t__a_0,_t__a_1,_t__a_2):
    return mosek_fusion_Var._stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_a_0,_a_1,numpy.int32(__a_2))
  @staticmethod
  def _stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_a_0,_a_1,_a_2):
   return (mosek.fusion.Var._stack_I_3Lmosek_4fusion_4Variable_2(_a_2,numpy.array([_a_0,_a_1], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_stack_I_3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match__3Lmosek_4fusion_4Variable_2__(_a_1))
  @staticmethod
  def _match_alt_stack_I_3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match__3Lmosek_4fusion_4Variable_2__(_a_1))
  @staticmethod
  def _stack_alt_I_3Lmosek_4fusion_4Variable_2(_t__a_0,_t__a_1):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_Var._stack_I_3Lmosek_4fusion_4Variable_2(_a_0,_a_1)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _stack_I_3Lmosek_4fusion_4Variable_2(_a_0,_a_1):
   _a_2=_a_0
   for _a_3 in range(0,int((_a_1).shape[0])):
    if (_a_2 < _a_1[_a_3]._getND_()):
     _a_2 = _a_1[_a_3]._getND_()
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(_a_1,_a_0))
  @staticmethod
  def _match_stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_I__(_a_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_2) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_3))
  @staticmethod
  def _match_alt_stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_2) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_3))
  @staticmethod
  def _stack_alt_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_t__a_0,_t__a_1,_t__a_2,_t__a_3):
    return mosek_fusion_Var._stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(numpy.int32(__a_0),_a_1,_a_2,_a_3)
  @staticmethod
  def _stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_a_0,_a_1,_a_2,_a_3):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_a_1,_a_2,_a_3], dtype=numpy.dtype(object)),_a_0))
  @staticmethod
  def _match_stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_I__(_a_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_2))
  @staticmethod
  def _match_alt_stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_2))
  @staticmethod
  def _stack_alt_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_t__a_0,_t__a_1,_t__a_2):
    return mosek_fusion_Var._stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(numpy.int32(__a_0),_a_1,_a_2)
  @staticmethod
  def _stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_a_0,_a_1,_a_2):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_a_1,_a_2], dtype=numpy.dtype(object)),_a_0))
  @staticmethod
  def _match_promote_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_promote_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_0) and __arg_alt_match_I__(_a_1))
  @staticmethod
  def _promote_alt_Lmosek_4fusion_4Variable_2I(_t__a_0,_t__a_1):
    return mosek_fusion_Var._promote_Lmosek_4fusion_4Variable_2I(_a_0,numpy.int32(__a_1))
  @staticmethod
  def _promote_Lmosek_4fusion_4Variable_2I(_a_0,_a_1):
   if (_a_1 > _a_0._getND_()):
    _a_2=numpy.zeros((_a_1,), dtype=numpy.dtype(numpy.int32))
    _a_3=_a_0._getShape_()
    fragments._c_closure_227(_a_3,_a_2) 
    fragments._c_closure_228(_a_1,_a_3,_a_2) 
    return (_a_0._reshape__3I(_a_2))
   else:
    return (_a_0)
  @staticmethod
  def _dstack_alt__3Lmosek_4fusion_4Variable_2I(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(object))
   _a_1=numpy.int32(_t__a_1)
   _1_res = mosek_fusion_Var._dstack__3Lmosek_4fusion_4Variable_2I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _dstack__3Lmosek_4fusion_4Variable_2I(_a_0,_a_1):
   if (_a_1 < 0):
    raise mosek_fusion_DimensionError._ctor_S("Invalid stacking dimension")
   _a_2=None
   for _a_3 in range(0,int((_a_0).shape[0])):
    if (_a_2 is None):
     _a_2 = _a_0[_a_3]._getModel_()
    elif ((_a_0[_a_3]._getModel_() is not None) and (_a_0[_a_3]._getModel_() is not _a_2)):
     _a_4=mosek.fusion.Utils.StringBuffer()
     _a_5=(_a_2._getName_() if ((int(len(_a_2._getName_())) > 0) ) else "?")
     _a_6=(_a_0[_a_3]._getModel_()._getName_() if ((int(len(_a_0[_a_3]._getModel_()._getName_())) > 0) ) else "?")
     _a_4._a_S("Variables belong to different models: '")._a_S(_a_5)._a_S("' and '")._a_S(_a_6)._a_S("'")
     raise mosek_fusion_ModelError._ctor_S(_a_4._toString_())
   if (int((_a_0).shape[0])==0):
    return (mosek_fusion_NilVariable._ctor_())
   elif (int((_a_0).shape[0])==1):
    return (_a_0[0])
   else:
    _a_7=int((_a_0).shape[0])
    _a_8=numpy.array([_a_0[_a_9]._numInst_() for _a_9 in range(0,_a_7)], dtype=numpy.dtype(numpy.int32))
    _a_10=_monty.initJaggedArray([_a_0[_a_11]._getShape_() for _a_11 in range(0,_a_7)], 1)
    _a_12=numpy.array([int((_a_10[_a_13]).shape[0]) for _a_13 in range(0,_a_7)], dtype=numpy.dtype(numpy.int32))
    _a_14=_a_10[0]
    _a_15=_a_12[0]
    _a_16=0
    _a_16 = fragments._c_closure_229(_a_7,_a_8,_a_16)
    _a_16 = numpy.int32(_a_16) # postprocess
    _a_17=(_a_1 + 1)
    _a_17 = fragments._c_closure_230(_a_7,_a_12,_a_17)
    _a_17 = numpy.int32(_a_17) # postprocess
    _a_18=numpy.zeros((_a_17,), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_231(_a_15,_a_18,_a_14) 
    fragments._c_closure_232(_a_15,_a_17,_a_18) 
    _a_18[_a_1] = 0
    fragments._c_closure_233(_a_1,_a_7,_a_18,_a_10) 
    for _a_19 in range(0,_a_7):
     for _a_20 in range(0,int((_a_10[_a_19]).shape[0])):
      if ((_a_20!=_a_1) and (_a_10[_a_19][_a_20]!=_a_18[_a_20])):
       raise mosek_fusion_DimensionError._ctor_S("Variable dimensions do not match")
     for _a_21 in range(int((_a_10[_a_19]).shape[0]),_a_17):
      if ((_a_21!=_a_1) and (1!=_a_18[_a_21])):
       raise mosek_fusion_DimensionError._ctor_S("Variable dimensions do not match")
    _a_22=numpy.zeros((_a_16,), dtype=numpy.dtype(numpy.int64))
    _a_23=numpy.zeros((_a_16,), dtype=numpy.dtype(numpy.int64))
    _a_24=numpy.array([(_a_10[_a_25][_a_1] if ((_a_1 < int((_a_10[_a_25]).shape[0])) ) else 1) for _a_25 in range(0,int((_a_0).shape[0]))], dtype=numpy.dtype(numpy.int32))
    _a_26=1
    _a_26 = fragments._c_closure_234(_a_26,_a_1,_a_14)
    _a_26 = numpy.int32(_a_26) # postprocess
    _a_27=0
    _a_27 = fragments._c_closure_235(_a_27,_a_7,_a_24)
    _a_27 = numpy.int32(_a_27) # postprocess
    _a_28=1
    _a_28 = fragments._c_closure_236(_a_28,_a_1,_a_14)
    _a_28 = numpy.int32(_a_28) # postprocess
    if (_a_26==1):
     _a_29=0
     _a_30=0
     for _a_31 in range(0,_a_7):
      _a_0[_a_31]._inst_I_3JI_3J(_a_29,_a_23,_a_29,_a_22)
      _a_29 = fragments._c_closure_237(_a_31,_a_29,_a_30,_a_8,_a_23)
      _a_29 = numpy.int32(_a_29) # postprocess
      _a_30 += mosek.fusion.Set._size__3I(_a_10[_a_31])
     return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(_a_2,_a_18,(_a_23 if ((_a_16 < ((_a_26 * _a_27) * _a_28)) ) else None),_a_22))
    else:
     _a_32=0
     for _a_33 in range(0,_a_7):
      _a_32 += _a_0[_a_33]._inst_I_3JI_3J(_a_32,_a_23,_a_32,_a_22)
     _a_34=numpy.zeros((_a_16,), dtype=numpy.dtype(numpy.int32))
     _a_35=numpy.zeros((_a_16,), dtype=numpy.dtype(numpy.int32))
     _a_36=numpy.zeros((_a_7,), dtype=numpy.dtype(numpy.int32))
     fragments._c_closure_238(_a_7,_a_36,_a_24) 
     fragments._c_closure_239(_a_34,_a_16) 
     _a_37=0
     _a_37 = fragments._c_closure_240(_a_27,_a_28,_a_37,_a_7,_a_8,_a_36,_a_23,_a_24)
     _a_37 = numpy.int32(_a_37) # postprocess
     _a_38=1
     _a_38 = fragments._c_closure_241(_a_38,_a_17,_a_18)
     _a_38 = numpy.int32(_a_38) # postprocess
     _a_39=numpy.zeros((_a_17,), dtype=numpy.dtype(numpy.int64))
     _a_39[(_a_17 - 1)] = 1
     fragments._c_closure_242(_a_17,_a_18,_a_39) 
     _a_40=numpy.zeros(((_a_38 + 1),), dtype=numpy.dtype(numpy.int32))
     for _a_41 in range(0,_a_17):
      _a_42=((_a_17 - _a_41) - 1)
      fragments._c_closure_243(_a_42,_a_40,_a_18) 
      fragments._c_closure_244(_a_42,_a_40,_a_16,_a_18,_a_23,_a_39) 
      fragments._c_closure_245(_a_42,_a_40,_a_18) 
      fragments._c_closure_246(_a_34,_a_42,_a_40,_a_16,_a_18,_a_23,_a_39,_a_35) 
      _a_43=_a_34
      _a_34 = _a_35
      _a_35 = _a_43
     return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(_a_2,_a_18,(numpy.array([_a_23[_a_34[_a_44]] for _a_44 in range(0,_a_16)], dtype=numpy.dtype(numpy.int64)) if ((_a_16 < ((_a_26 * _a_27) * _a_28)) ) else None),numpy.array([_a_22[_a_34[_a_45]] for _a_45 in range(0,_a_16)], dtype=numpy.dtype(numpy.int64))))
 return Var
mosek_fusion_Var=__mk_mosek_fusion_Var()
del __mk_mosek_fusion_Var
#BEFORE CLASS
def __mk_mosek_fusion_Constraint():
 class Constraint(object):
  __slots__ = ['_Constraint__con_nativeidxs','_Constraint__shape','_Constraint__model']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args):
      self._ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4Model_2_3I_3I(*args):
      self._ctor_init_Lmosek_4fusion_4Model_2_3I_3I(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4Model_2_3I_3I(*args):
      self._ctor_alt_init_Lmosek_4fusion_4Model_2_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.Constraint.ctor(mosek.fusion.Constraint,mosek.fusion.Model)\n\tmosek.fusion.Constraint.ctor(mosek.fusion.Model,array(int32,ndim=1),array(int32,ndim=1))')
  def dual(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.dual()

    Description
    -----------

    
    Get the dual solution values of the constraint.
            

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Constraint._match_dual_(*args):
      return self._dual_(*args)
    elif mosek_fusion_Constraint._match_alt_dual_(*args):
      return self._dual_alt_(*args)
    else:
      raise ValueError('Invalid argument list dual('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.dual()')
  @staticmethod
  def hstack(*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.hstack(array(mosek.fusion.Constraint,ndim=1))
      mosek.fusion.Constraint.hstack(mosek.fusion.Constraint,mosek.fusion.Constraint)
      mosek.fusion.Constraint.hstack(mosek.fusion.Constraint,mosek.fusion.Constraint,mosek.fusion.Constraint)

    Description
    -----------

    Stack a number of constraints horizontally.

    Parameters
    ----------

    clist : array(mosek.fusion.Constraint,ndim=1)
        The constraints in the stack. 
    v1 : mosek.fusion.Constraint
        The first constraint in the stack. 
    v2 : mosek.fusion.Constraint
        The second constraint in the stack. 
    v3 : mosek.fusion.Constraint
        The third constraint in the stack. 
    '''
    if False: pass
    elif mosek_fusion_Constraint._match_hstack__3Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._hstack__3Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_alt_hstack__3Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._hstack_alt__3Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_alt_hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._hstack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_alt_hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._hstack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    else:
      raise ValueError('Invalid argument list hstack('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.hstack(array(mosek.fusion.Constraint,ndim=1))\n\tmosek.fusion.Constraint.hstack(mosek.fusion.Constraint,mosek.fusion.Constraint)\n\tmosek.fusion.Constraint.hstack(mosek.fusion.Constraint,mosek.fusion.Constraint,mosek.fusion.Constraint)')
  def level(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.level()

    Description
    -----------

    
    Get the primal solution values of the constraint.
            

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Constraint._match_level_(*args):
      return self._level_(*args)
    elif mosek_fusion_Constraint._match_alt_level_(*args):
      return self._level_alt_(*args)
    else:
      raise ValueError('Invalid argument list level('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.level()')
  @staticmethod
  def vstack(*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.vstack(array(mosek.fusion.Constraint,ndim=1))
      mosek.fusion.Constraint.vstack(mosek.fusion.Constraint,mosek.fusion.Constraint)
      mosek.fusion.Constraint.vstack(mosek.fusion.Constraint,mosek.fusion.Constraint,mosek.fusion.Constraint)

    Description
    -----------

    Stack three constraints. 

    Parameters
    ----------

    clist : array(mosek.fusion.Constraint,ndim=1)
        The constraints in the stack. 
    v1 : mosek.fusion.Constraint
        The first constraint in the stack. 
    v2 : mosek.fusion.Constraint
        The second constraint in the stack. 
    v3 : mosek.fusion.Constraint
        The third constraint in the stack. 
    '''
    if False: pass
    elif mosek_fusion_Constraint._match_vstack__3Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._vstack__3Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_alt_vstack__3Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._vstack_alt__3Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_alt_vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._vstack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_alt_vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._vstack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    else:
      raise ValueError('Invalid argument list vstack('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.vstack(array(mosek.fusion.Constraint,ndim=1))\n\tmosek.fusion.Constraint.vstack(mosek.fusion.Constraint,mosek.fusion.Constraint)\n\tmosek.fusion.Constraint.vstack(mosek.fusion.Constraint,mosek.fusion.Constraint,mosek.fusion.Constraint)')
  def index(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.index(int32)
      mosek.fusion.Constraint.index(array(int32,ndim=1))

    Description
    -----------

    Get a single element from a one-dimensional constraint. 

    Parameters
    ----------

    idx : int32
        The index of the element.
    idxa : array(int32,ndim=1)
        A multi-dimensional index of the element.
    '''
    if False: pass
    elif mosek_fusion_Constraint._match_index_I(*args):
      return self._index_I(*args)
    elif mosek_fusion_Constraint._match_alt_index_I(*args):
      return self._index_alt_I(*args)
    elif mosek_fusion_Constraint._match_index__3I(*args):
      return self._index__3I(*args)
    elif mosek_fusion_Constraint._match_alt_index__3I(*args):
      return self._index_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.index(int32)\n\tmosek.fusion.Constraint.index(array(int32,ndim=1))')
  def size(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.size()

    Description
    -----------

    Get the total number of elements in the constraint.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Constraint._match_size_(*args):
      return self._size_(*args)
    elif mosek_fusion_Constraint._match_alt_size_(*args):
      return self._size_alt_(*args)
    else:
      raise ValueError('Invalid argument list size('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.size()')
  def get_model(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.get_model()

    Description
    -----------

    Get the model to which the constraint belongs.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Constraint._match_get_1model_(*args):
      return self._get_1model_(*args)
    elif mosek_fusion_Constraint._match_alt_get_1model_(*args):
      return self._get_1model_alt_(*args)
    else:
      raise ValueError('Invalid argument list get_model('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.get_model()')
  @staticmethod
  def stack(*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.stack(array(mosek.fusion.Constraint,ndim=1),int32)
      mosek.fusion.Constraint.stack(mosek.fusion.Constraint,mosek.fusion.Constraint,int32)
      mosek.fusion.Constraint.stack(mosek.fusion.Constraint,mosek.fusion.Constraint,mosek.fusion.Constraint,int32)

    Description
    -----------

    Stack a number of constraints.

    Parameters
    ----------

    clist : array(mosek.fusion.Constraint,ndim=1)
        The constraints in the stack. 
    dim : int32
        The dimension in which to stack, 0 means vertically. 
    v1 : mosek.fusion.Constraint
        The first constraint in the stack. 
    v2 : mosek.fusion.Constraint
        The second constraint in the stack. 
    v3 : mosek.fusion.Constraint
        The third constraint in the stack. 
    '''
    if False: pass
    elif mosek_fusion_Constraint._match_stack__3Lmosek_4fusion_4Constraint_2I(*args):
      return mosek_fusion_Constraint._stack__3Lmosek_4fusion_4Constraint_2I(*args)
    elif mosek_fusion_Constraint._match_alt_stack__3Lmosek_4fusion_4Constraint_2I(*args):
      return mosek_fusion_Constraint._stack_alt__3Lmosek_4fusion_4Constraint_2I(*args)
    elif mosek_fusion_Constraint._match_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args):
      return mosek_fusion_Constraint._stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args)
    elif mosek_fusion_Constraint._match_alt_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args):
      return mosek_fusion_Constraint._stack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args)
    elif mosek_fusion_Constraint._match_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args):
      return mosek_fusion_Constraint._stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args)
    elif mosek_fusion_Constraint._match_alt_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args):
      return mosek_fusion_Constraint._stack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args)
    else:
      raise ValueError('Invalid argument list stack('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.stack(array(mosek.fusion.Constraint,ndim=1),int32)\n\tmosek.fusion.Constraint.stack(mosek.fusion.Constraint,mosek.fusion.Constraint,int32)\n\tmosek.fusion.Constraint.stack(mosek.fusion.Constraint,mosek.fusion.Constraint,mosek.fusion.Constraint,int32)')
  def getSize(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.getSize()

    Description
    -----------

    Return the total number of elements in the constraint. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Constraint._match_getSize_(*args):
      return self._getSize_(*args)
    elif mosek_fusion_Constraint._match_alt_getSize_(*args):
      return self._getSize_alt_(*args)
    else:
      raise ValueError('Invalid argument list getSize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.getSize()')
  def getModel(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.getModel()

    Description
    -----------

    Return the model that the constraint belongs to. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Constraint._match_getModel_(*args):
      return self._getModel_(*args)
    elif mosek_fusion_Constraint._match_alt_getModel_(*args):
      return self._getModel_alt_(*args)
    else:
      raise ValueError('Invalid argument list getModel('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.getModel()')
  def toString(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.toString()

    Description
    -----------

    Create a human readable string representation of the constraint.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Constraint._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_Constraint._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.toString()')
  def update(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.update(mosek.fusion.Expression)
      mosek.fusion.Constraint.update(array(double,ndim=1))
      mosek.fusion.Constraint.update(mosek.fusion.Expression,mosek.fusion.Variable)
      mosek.fusion.Constraint.update(mosek.fusion.Expression,mosek.fusion.Variable,bool)

    Description
    -----------

    Update part of a constraint. 

    Parameters
    ----------

    bfix : array(double,ndim=1)
        The fixed term to update with.
    bfixupdate : bool
        Whether to include fixed terms as well.
    expr : mosek.fusion.Expression
        The expression to update with.
    x : mosek.fusion.Variable
        Variable object defining the columns to update.
    '''
    if False: pass
    elif mosek_fusion_Constraint._match_update_Lmosek_4fusion_4Expression_2(*args):
      return self._update_Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_Constraint._match_alt_update_Lmosek_4fusion_4Expression_2(*args):
      return self._update_alt_Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_Constraint._match_update__3D(*args):
      return self._update__3D(*args)
    elif mosek_fusion_Constraint._match_alt_update__3D(*args):
      return self._update_alt__3D(*args)
    elif mosek_fusion_Constraint._match_update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args):
      return self._update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Constraint._match_alt_update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args):
      return self._update_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Constraint._match_update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(*args):
      return self._update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(*args)
    elif mosek_fusion_Constraint._match_alt_update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(*args):
      return self._update_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(*args)
    else:
      raise ValueError('Invalid argument list update('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.update(mosek.fusion.Expression)\n\tmosek.fusion.Constraint.update(array(double,ndim=1))\n\tmosek.fusion.Constraint.update(mosek.fusion.Expression,mosek.fusion.Variable)\n\tmosek.fusion.Constraint.update(mosek.fusion.Expression,mosek.fusion.Variable,bool)')
  def getShape(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.getShape()

    Description
    -----------

    Return the constraint's shape. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Constraint._match_getShape_(*args):
      return self._getShape_(*args)
    elif mosek_fusion_Constraint._match_alt_getShape_(*args):
      return self._getShape_alt_(*args)
    else:
      raise ValueError('Invalid argument list getShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.getShape()')
  def remove(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.remove()

    Description
    -----------

    Remove the constraint from the model.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Constraint._match_remove_(*args):
      return self._remove_(*args)
    elif mosek_fusion_Constraint._match_alt_remove_(*args):
      return self._remove_alt_(*args)
    else:
      raise ValueError('Invalid argument list remove('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.remove()')
  def get_nd(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.get_nd()

    Description
    -----------

    Get the number of dimensions of the constraint. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Constraint._match_get_1nd_(*args):
      return self._get_1nd_(*args)
    elif mosek_fusion_Constraint._match_alt_get_1nd_(*args):
      return self._get_1nd_alt_(*args)
    else:
      raise ValueError('Invalid argument list get_nd('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.get_nd()')
  def slice(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.slice(int32,int32)
      mosek.fusion.Constraint.slice(array(int32,ndim=1),array(int32,ndim=1))

    Description
    -----------

    Create a slice constraint.

    Parameters
    ----------

    first : int32
        Index of the first element in the slice.
    firsta : array(int32,ndim=1)
        The indexes of first elements in the slice along each dimension.
    last : int32
        Index of the first element after the end of the slice.
    lasta : array(int32,ndim=1)
        The indexes of first elements after the end of the slice along each dimension.
    '''
    if False: pass
    elif mosek_fusion_Constraint._match_slice_II(*args):
      return self._slice_II(*args)
    elif mosek_fusion_Constraint._match_alt_slice_II(*args):
      return self._slice_alt_II(*args)
    elif mosek_fusion_Constraint._match_slice__3I_3I(*args):
      return self._slice__3I_3I(*args)
    elif mosek_fusion_Constraint._match_alt_slice__3I_3I(*args):
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.slice(int32,int32)\n\tmosek.fusion.Constraint.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def getND(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.Constraint.getND()

    Description
    -----------

    Return the number of dimensions in the constraint shape. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Constraint._match_getND_(*args):
      return self._getND_(*args)
    elif mosek_fusion_Constraint._match_alt_getND_(*args):
      return self._getND_alt_(*args)
    else:
      raise ValueError('Invalid argument list getND('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.getND()')
  def __repr__(self): return 'mosek.fusion.Constraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(c,m):
    o = Constraint.__new__(Constraint)
    o._ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(self,c,m):
   self.__model = m
   self.__shape = (c.__shape)
   self.__con_nativeidxs = (c.__con_nativeidxs)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2_3I_3I(model,shape,con_nativeidxs):
    o = Constraint.__new__(Constraint)
    o._ctor_init_Lmosek_4fusion_4Model_2_3I_3I(model,shape,con_nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2_3I_3I(*args):
    if len(args) != 3: return False
    model,shape,con_nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match__3I__(shape) and __arg_match__3I__(con_nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2_3I_3I(*args):
    if len(args) != 3: return False
    model,shape,con_nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match__3I__(shape) and __arg_alt_match__3I__(con_nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2_3I_3I(self,model,shape,con_nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2_3I_3I(model,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(con_nativeidxs,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Lmosek_4fusion_4Model_2_3I_3I(self,model,shape,con_nativeidxs):
   (self.__model) = model
   (self.__shape) = shape
   (self.__con_nativeidxs) = con_nativeidxs
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   raise mosek_fusion_UnimplementedError._ctor_S("Constraint.toString")
  def _toStringArray_alt__3JJ_3S(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int64))
   _a_1=numpy.int64(_t__a_1)
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(object))
   _1_res = self._toStringArray__3JJ_3S(_a_0,_a_1,_a_2)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _toStringArray__3JJ_3S(self,_a_0,_a_1,_a_2):
   pass
  def _dual_1lu_alt_I_3DZ(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.int32(_t__a_0)
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.float64))
   _a_2=_t__a_2
   _1_res = self._dual_1lu_I_3DZ(_a_0,_a_1,_a_2)
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _dual_1lu_I_3DZ(self,_a_0,_a_1,_a_2):
   self.__model._getConstraintDuals_Z_3I_3DI(_a_2,self.__con_nativeidxs,_a_1,_a_0)
  @staticmethod
  def _match_dual_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dual_(*args):
    if len(args) != 0: return False
    return True
  def _dual_alt_(self,):
    return self._dual_()
  def _dual_(self,):
   _a_0=numpy.zeros((int((self.__con_nativeidxs).shape[0]),), dtype=numpy.dtype(numpy.float64))
   self.__values_ZI_3D(False,0,_a_0)
   return (_a_0)
  @staticmethod
  def _match_level_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_level_(*args):
    if len(args) != 0: return False
    return True
  def _level_alt_(self,):
    return self._level_()
  def _level_(self,):
   _a_0=numpy.zeros((int((self.__con_nativeidxs).shape[0]),), dtype=numpy.dtype(numpy.float64))
   self.__values_ZI_3D(True,0,_a_0)
   return (_a_0)
  def __values_alt_ZI_3D(self,_t__a_0,_t__a_1,_t__a_2):
   _a_0=_t__a_0
   _a_1=numpy.int32(_t__a_1)
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.float64))
   _1_res = self.__values_ZI_3D(_a_0,_a_1,_a_2)
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __values_ZI_3D(self,_a_0,_a_1,_a_2):
   self.__model._getConstraintValues_Z_3I_3DI(_a_0,self.__con_nativeidxs,_a_2,_a_1)
  @staticmethod
  def _match_remove_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_remove_(*args):
    if len(args) != 0: return False
    return True
  def _remove_alt_(self,):
    return self._remove_()
  def _remove_(self,):
   raise mosek_fusion_DeletionError._ctor_S("Only original constraints can be removed")
  @staticmethod
  def _match_update__3D(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3D__(_a_0))
  @staticmethod
  def _match_alt_update__3D(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3D__(_a_0))
  def _update_alt__3D(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.float64))
   _1_res = self._update__3D(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _update__3D(self,_a_0):
   self._update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(mosek.fusion.Expr._reshape_Lmosek_4fusion_4Expression_2_3I(mosek.fusion.Expr._constTerm__3D(_a_0),self._getShape_()),mosek_fusion_NilVariable._ctor_(),True)
  @staticmethod
  def _match_update_Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_a_0))
  @staticmethod
  def _match_alt_update_Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_a_0))
  def _update_alt_Lmosek_4fusion_4Expression_2(self,_t__a_0):
    return self._update_Lmosek_4fusion_4Expression_2(_a_0)
  def _update_Lmosek_4fusion_4Expression_2(self,_a_0):
   _a_1=_a_0._getShape_()
   if (int((self.__shape).shape[0]) < int((_a_1).shape[0])):
    raise mosek_fusion_DimensionError._ctor_S("Expression shape does not match constraint")
   for _a_2 in range(0,int((_a_1).shape[0])):
    if (_a_1[_a_2]!=self.__shape[_a_2]):
     raise mosek_fusion_DimensionError._ctor_S("Expression shape does not match constraint")
   for _a_3 in range(int((_a_1).shape[0]),int((self.__shape).shape[0])):
    if (self.__shape[_a_3]!=1):
     raise mosek_fusion_DimensionError._ctor_S("Expression shape does not match constraint")
   self.__model._update__3ILmosek_4fusion_4Expression_2(self.__con_nativeidxs,_a_0)
  @staticmethod
  def _match_update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_1) and __arg_match_Z__(_a_2))
  @staticmethod
  def _match_alt_update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_1) and __arg_alt_match_Z__(_a_2))
  def _update_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(self,_t__a_0,_t__a_1,_t__a_2):
    return self._update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(_a_0,_a_1,_a_2)
  def _update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(self,_a_0,_a_1,_a_2):
   _a_3=self._getND_()
   _a_4=_a_0._getShape_()
   if (_a_3 < int((_a_4).shape[0])):
    raise mosek_fusion_DimensionError._ctor_S("Expression shape does not match constraint")
   for _a_5 in range(0,int((_a_4).shape[0])):
    if (_a_4[_a_5]!=self.__shape[_a_5]):
     raise mosek_fusion_DimensionError._ctor_S("Expression shape does not match constraint")
   for _a_6 in range(int((_a_4).shape[0]),int((self.__shape).shape[0])):
    if (self.__shape[_a_6]!=1):
     raise mosek_fusion_DimensionError._ctor_S("Expression shape does not match constraint")
   _a_7=_a_1._numInst_()
   _a_8=numpy.zeros((_a_7,), dtype=numpy.dtype(numpy.int64))
   if (_a_7 < _a_1._getSize_()):
    _a_9=numpy.zeros((_a_7,), dtype=numpy.dtype(numpy.int64))
    _a_1._inst_I_3JI_3J(0,_a_9,0,_a_8)
   else:
    _a_1._inst_I_3J(0,_a_8)
   for _a_10 in range(0,_a_7):
    if (_a_8[_a_10] < 0):
     raise mosek_fusion_UpdateError._ctor_S("Semidefinite terms cannot be updated")
   _a_12=True
   _a_12 = fragments._c_closure_247(_a_12,_a_7,_a_8)
   if _a_12:
    if (not _a_2):
     _a_11 = numpy.array([numpy.int32(_a_8[_a_13]) for _a_13 in range(0,_a_7)], dtype=numpy.dtype(numpy.int32))
    else:
     _a_11 = numpy.zeros(((_a_7 + 1),), dtype=numpy.dtype(numpy.int32))
     _a_11[0] = 0
     fragments._c_closure_248(_a_7,_a_8,_a_11) 
   else:
    _a_14=numpy.array([_a_15 for _a_15 in range(0,_a_7)], dtype=numpy.dtype(numpy.int64))
    mosek.fusion.CommonTools._argQsort__3J_3J_3JJJ(_a_14,_a_8,None,0,_a_7)
    _a_16=1
    _a_16 = fragments._c_closure_249(_a_7,_a_16,_a_14,_a_8)
    _a_16 = numpy.int32(_a_16) # postprocess
    if _a_2:
     _a_16 += 1
    _a_11 = numpy.zeros((_a_16,), dtype=numpy.dtype(numpy.int32))
    _a_17=0
    if _a_2:
     _a_11[0] = 0
     _a_17 += 1
    _a_11[_a_17] = numpy.int32(_a_8[_a_14[0]])
    _a_17 = fragments._c_closure_250(_a_17,_a_7,_a_14,_a_8,_a_11)
    _a_17 = numpy.int32(_a_17) # postprocess
   self.__model._update__3ILmosek_4fusion_4Expression_2_3I(self.__con_nativeidxs,_a_0,_a_11)
  @staticmethod
  def _match_update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_a_1))
  @staticmethod
  def _match_alt_update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_a_1))
  def _update_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(self,_t__a_0,_t__a_1):
    return self._update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(_a_0,_a_1)
  def _update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(self,_a_0,_a_1):
   self._update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(_a_0,_a_1,False)
  @staticmethod
  def _match_get_1model_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_get_1model_(*args):
    if len(args) != 0: return False
    return True
  def _get_1model_alt_(self,):
    return self._get_1model_()
  def _get_1model_(self,):
   return (self.__model)
  @staticmethod
  def _match_get_1nd_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_get_1nd_(*args):
    if len(args) != 0: return False
    return True
  def _get_1nd_alt_(self,):
    return self._get_1nd_()
  def _get_1nd_(self,):
   return numpy.int32(int((self.__shape).shape[0]))
  @staticmethod
  def _match_size_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_size_(*args):
    if len(args) != 0: return False
    return True
  def _size_alt_(self,):
    return self._size_()
  def _size_(self,):
   _a_0=1
   _a_0 = fragments._c_closure_251(self.__shape,_a_0)
   _a_0 = numpy.int64(_a_0) # postprocess
   return numpy.int64(_a_0)
  @staticmethod
  def _match_stack__3Lmosek_4fusion_4Constraint_2I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3Lmosek_4fusion_4Constraint_2__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_stack__3Lmosek_4fusion_4Constraint_2I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Constraint_2__(_a_0) and __arg_alt_match_I__(_a_1))
  @staticmethod
  def _stack_alt__3Lmosek_4fusion_4Constraint_2I(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(object))
   _a_1=numpy.int32(_t__a_1)
   _1_res = mosek_fusion_Constraint._stack__3Lmosek_4fusion_4Constraint_2I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _stack__3Lmosek_4fusion_4Constraint_2I(_a_0,_a_1):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(_a_0,_a_1))
  @staticmethod
  def _match_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(_a_0) and __arg_match_Lmosek_4fusion_4Constraint_2__(_a_1) and __arg_match_Lmosek_4fusion_4Constraint_2__(_a_2) and __arg_match_I__(_a_3))
  @staticmethod
  def _match_alt_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args):
    if len(args) != 4: return False
    _a_0,_a_1,_a_2,_a_3, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_a_2) and __arg_alt_match_I__(_a_3))
  @staticmethod
  def _stack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(_t__a_0,_t__a_1,_t__a_2,_t__a_3):
    return mosek_fusion_Constraint._stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(_a_0,_a_1,_a_2,numpy.int32(__a_3))
  @staticmethod
  def _stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(_a_0,_a_1,_a_2,_a_3):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(numpy.array([_a_0,_a_1,_a_2], dtype=numpy.dtype(object)),_a_3))
  @staticmethod
  def _match_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(_a_0) and __arg_match_Lmosek_4fusion_4Constraint_2__(_a_1) and __arg_match_I__(_a_2))
  @staticmethod
  def _match_alt_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_a_1) and __arg_alt_match_I__(_a_2))
  @staticmethod
  def _stack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(_t__a_0,_t__a_1,_t__a_2):
    return mosek_fusion_Constraint._stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(_a_0,_a_1,numpy.int32(__a_2))
  @staticmethod
  def _stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(_a_0,_a_1,_a_2):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(numpy.array([_a_0,_a_1], dtype=numpy.dtype(object)),_a_2))
  @staticmethod
  def _match_hstack__3Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3Lmosek_4fusion_4Constraint_2__(_a_0))
  @staticmethod
  def _match_alt_hstack__3Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Constraint_2__(_a_0))
  @staticmethod
  def _hstack_alt__3Lmosek_4fusion_4Constraint_2(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_Constraint._hstack__3Lmosek_4fusion_4Constraint_2(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _hstack__3Lmosek_4fusion_4Constraint_2(_a_0):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(_a_0,1))
  @staticmethod
  def _match_vstack__3Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3Lmosek_4fusion_4Constraint_2__(_a_0))
  @staticmethod
  def _match_alt_vstack__3Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Constraint_2__(_a_0))
  @staticmethod
  def _vstack_alt__3Lmosek_4fusion_4Constraint_2(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_Constraint._vstack__3Lmosek_4fusion_4Constraint_2(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _vstack__3Lmosek_4fusion_4Constraint_2(_a_0):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(_a_0,0))
  @staticmethod
  def _match_hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(_a_0) and __arg_match_Lmosek_4fusion_4Constraint_2__(_a_1) and __arg_match_Lmosek_4fusion_4Constraint_2__(_a_2))
  @staticmethod
  def _match_alt_hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_a_2))
  @staticmethod
  def _hstack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_t__a_0,_t__a_1,_t__a_2):
    return mosek_fusion_Constraint._hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_a_0,_a_1,_a_2)
  @staticmethod
  def _hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_a_0,_a_1,_a_2):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(numpy.array([_a_0,_a_1,_a_2], dtype=numpy.dtype(object)),1))
  @staticmethod
  def _match_vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(_a_0) and __arg_match_Lmosek_4fusion_4Constraint_2__(_a_1) and __arg_match_Lmosek_4fusion_4Constraint_2__(_a_2))
  @staticmethod
  def _match_alt_vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_a_1) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_a_2))
  @staticmethod
  def _vstack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_t__a_0,_t__a_1,_t__a_2):
    return mosek_fusion_Constraint._vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_a_0,_a_1,_a_2)
  @staticmethod
  def _vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_a_0,_a_1,_a_2):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(numpy.array([_a_0,_a_1,_a_2], dtype=numpy.dtype(object)),0))
  @staticmethod
  def _match_hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(_a_0) and __arg_match_Lmosek_4fusion_4Constraint_2__(_a_1))
  @staticmethod
  def _match_alt_hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_a_1))
  @staticmethod
  def _hstack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_t__a_0,_t__a_1):
    return mosek_fusion_Constraint._hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_a_0,_a_1)
  @staticmethod
  def _hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_a_0,_a_1):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(numpy.array([_a_0,_a_1], dtype=numpy.dtype(object)),1))
  @staticmethod
  def _match_vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(_a_0) and __arg_match_Lmosek_4fusion_4Constraint_2__(_a_1))
  @staticmethod
  def _match_alt_vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(_a_0) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_a_1))
  @staticmethod
  def _vstack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_t__a_0,_t__a_1):
    return mosek_fusion_Constraint._vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_a_0,_a_1)
  @staticmethod
  def _vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_a_0,_a_1):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(numpy.array([_a_0,_a_1], dtype=numpy.dtype(object)),0))
  @staticmethod
  def _dstack_alt__3Lmosek_4fusion_4Constraint_2I(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(object))
   _a_1=numpy.int32(_t__a_1)
   _1_res = mosek_fusion_Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _dstack__3Lmosek_4fusion_4Constraint_2I(_a_0,_a_1):
   _a_2=None
   for _a_3 in range(0,int((_a_0).shape[0])):
    if (_a_2 is None):
     _a_2 = _a_0[_a_3]._getModel_()
    elif (((_a_0[_a_3].__model) is not None) and ((_a_0[_a_3].__model) is not _a_2)):
     _a_4=mosek.fusion.Utils.StringBuffer()
     _a_5=(_a_2._getName_() if ((int(len(_a_2._getName_())) > 0) ) else "?")
     _a_6=(_a_0[_a_3]._getModel_()._getName_() if ((int(len(_a_0[_a_3]._getModel_()._getName_())) > 0) ) else "?")
     _a_4._a_S("Constraints belong to different models: '")._a_S(_a_5)._a_S("' and '")._a_S(_a_6)._a_S("'")
     raise mosek_fusion_ModelError._ctor_S(_a_4._toString_())
   if (int((_a_0).shape[0])==0):
    return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3I(None,numpy.array([0], dtype=numpy.dtype(numpy.int32)),numpy.zeros((0,), dtype=numpy.dtype(numpy.int32))))
   elif (int((_a_0).shape[0])==1):
    return (_a_0[1])
   else:
    _a_7=int((_a_0).shape[0])
    _a_8=1
    for _a_9 in range(0,_a_7):
     _a_8 = (_a_0[_a_9]._getND_() if ((_a_0[_a_9]._getND_() > _a_8) ) else _a_8)
    if (_a_1==_a_8):
     _a_8 += 1
    _a_10=numpy.zeros((_a_7,_a_8,), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_252(_a_7,_a_8,_a_10) 
    _a_11=numpy.array([_a_0[_a_12]._getSize_() for _a_12 in range(0,_a_7)], dtype=numpy.dtype(numpy.int32))
    _a_13=0
    _a_13 = fragments._c_closure_253(_a_7,_a_11,_a_13)
    _a_13 = numpy.int32(_a_13) # postprocess
    for _a_14 in range(0,_a_7):
     _a_15=_a_0[_a_14]._getShape_()
     fragments._c_closure_254(_a_14,_a_10,_a_15) 
    if ((_a_1 < 0) or (_a_1 > _a_8)):
     raise mosek_fusion_DimensionError._ctor_S("Invalid stacking dimension")
    for _a_16 in range(0,_a_1):
     for _a_17 in range(1,_a_7):
      if (_a_10[0,_a_16]!=_a_10[_a_17,_a_16]):
       raise mosek_fusion_DimensionError._ctor_S("Constraint dimensions do not match")
    for _a_18 in range((_a_1 + 1),_a_8):
     for _a_19 in range(1,_a_7):
      if (_a_10[0,_a_18]!=_a_10[_a_19,_a_18]):
       raise mosek_fusion_DimensionError._ctor_S("Constraint dimensions do not match")
    _a_20=numpy.zeros((_a_13,), dtype=numpy.dtype(numpy.int32))
    _a_21=numpy.array([_a_10[0,_a_22] for _a_22 in range(0,_a_8)], dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_255(_a_1,_a_7,_a_21,_a_10) 
    _a_23=int((_a_21).shape[0])
    _a_24=numpy.zeros(((int((_a_0).shape[0]) + 1),), dtype=numpy.dtype(numpy.int64))
    for _a_25 in range(0,int((_a_0).shape[0])):
     _a_24[(_a_25 + 1)] = (_a_24[_a_25] + _a_10[_a_25,_a_1])
    if (_a_1==0):
     _a_26=0
     for _a_27 in range(0,_a_7):
      _a_28=int(((_a_0[_a_27].__con_nativeidxs)).shape[0])
      mosek.fusion.Utils.Tools._arraycopy__3II_3III((_a_0[_a_27].__con_nativeidxs),0,_a_20,_a_26,_a_28)
      _a_26 += _a_28
    else:
     _a_29=_monty.initJaggedArray([(_a_0[_a_30].__con_nativeidxs) for _a_30 in range(0,_a_7)], 1)
     if (_a_1 < _a_8):
      _a_31=1
      _a_31 = fragments._c_closure_256(_a_31,_a_1,_a_21)
      _a_31 = numpy.int32(_a_31) # postprocess
      _a_32=1
      _a_32 = fragments._c_closure_257(_a_32,_a_1,_a_8,_a_21)
      _a_32 = numpy.int32(_a_32) # postprocess
      _a_33=0
      for _a_34 in range(0,_a_31):
       for _a_35 in range(0,_a_7):
        _a_36=0
        _a_37=_a_10[_a_35,_a_1]
        for _a_38 in range(0,_a_37):
         for _a_39 in range(0,_a_32):
          _a_20[_a_33] = (_a_0[_a_7].__con_nativeidxs)[(((_a_34 * _a_32) * _a_37) + _a_36)]
          _a_33 += 1
          _a_36 += 1
     else:
      fragments._c_closure_258(_a_20,_a_7,_a_8,_a_29,_a_21) 
    return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3I(_a_2,_a_21,_a_20))
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _index_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._index__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _index__3I(self,_a_0):
   if (int((_a_0).shape[0])!=int((self.__shape).shape[0])):
    raise mosek_fusion_DimensionError._ctor_S("variable shape and slice do not match")
   else:
    for _a_1 in range(0,int((self.__shape).shape[0])):
     if ((_a_0[_a_1] < 0) or (_a_0[_a_1] > self.__shape[_a_1])):
      raise mosek_fusion_IndexError._ctor_S("index is out of bounds")
    _a_2=int((self.__shape).shape[0])
    _a_3=numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.int64))
    _a_3[(_a_2 - 1)] = 1
    fragments._c_closure_259(_a_2,self.__shape,_a_3) 
    _a_4=0
    _a_4 = fragments._c_closure_260(_a_0,_a_4,_a_2,_a_3)
    _a_4 = numpy.int32(_a_4) # postprocess
    return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3I(self.__model,numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),numpy.array([self.__con_nativeidxs[_a_4]], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _index_alt_I(self,_t__a_0):
    return self._index_I(numpy.int32(__a_0))
  def _index_I(self,_a_0):
   if ((int((self.__shape).shape[0])==0) and (_a_0==0)):
    return (self)
   elif (int((self.__shape).shape[0])!=1):
    raise mosek_fusion_DimensionError._ctor_S("Variable shape and slice do not match")
   elif ((_a_0 < 0) or (_a_0 > self.__shape[0])):
    raise mosek_fusion_IndexError._ctor_S("Index is out of bounds")
   else:
    return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3I(self.__model,numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),numpy.array([self.__con_nativeidxs[_a_0]], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1))
  def _slice_alt__3I_3I(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._slice__3I_3I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _slice__3I_3I(self,_a_0,_a_1):
   if (int((_a_0).shape[0])!=int((_a_1).shape[0])):
    raise mosek_fusion_SliceError._ctor_S("invalid slice")
   elif (int((_a_0).shape[0])!=int((self.__shape).shape[0])):
    raise mosek_fusion_DimensionError._ctor_S("variable shape and slice do not match")
   else:
    for _a_2 in range(0,int((self.__shape).shape[0])):
     if ((_a_0[_a_2] < 0) or (_a_1[_a_2] > self.__shape[_a_2])):
      raise mosek_fusion_IndexError._ctor_S("slice is out of bounds")
     elif (_a_0[_a_2] > _a_1[_a_2]):
      raise mosek_fusion_SliceError._ctor_S("invalid slice")
    _a_3=int((self.__shape).shape[0])
    _a_4=numpy.array([(_a_1[_a_5] - _a_0[_a_5]) for _a_5 in range(0,_a_3)], dtype=numpy.dtype(numpy.int32))
    _a_6=1
    _a_6 = fragments._c_closure_261(_a_0,_a_1,_a_3,_a_6)
    _a_6 = numpy.int32(_a_6) # postprocess
    if (_a_6==0):
     return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3I(self.__model,_a_4,numpy.zeros((0,), dtype=numpy.dtype(numpy.int32))))
    else:
     _a_7=numpy.zeros((_a_6,), dtype=numpy.dtype(numpy.int32))
     fragments._c_closure_262(self.__con_nativeidxs,_a_0,_a_1,_a_3,self.__shape,_a_7,_a_6) 
     return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3I(self._getModel_(),_a_4,_a_7))
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1))
  def _slice_alt_II(self,_t__a_0,_t__a_1):
    return self._slice_II(numpy.int32(__a_0),numpy.int32(__a_1))
  def _slice_II(self,_a_0,_a_1):
   if (int((self.__shape).shape[0])!=1):
    raise mosek_fusion_DimensionError._ctor_S("Variable shape and slice do not match")
   if ((_a_0==0) and (_a_1==self.__shape[0])):
    return (self)
   elif ((_a_0 < 0) or (_a_1 > self.__shape[0])):
    raise mosek_fusion_IndexError._ctor_S("Slice is out of bounds")
   elif (_a_0 > _a_1):
    raise mosek_fusion_SliceError._ctor_S("Invalid slice")
   else:
    return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3I(self.__model,numpy.array([(_a_1 - _a_0)], dtype=numpy.dtype(numpy.int32)),numpy.array([self.__con_nativeidxs[_a_2] for _a_2 in range(_a_0,_a_1)], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_getND_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getND_(*args):
    if len(args) != 0: return False
    return True
  def _getND_alt_(self,):
    return self._getND_()
  def _getND_(self,):
   return numpy.int32(int((self.__shape).shape[0]))
  @staticmethod
  def _match_getSize_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getSize_(*args):
    if len(args) != 0: return False
    return True
  def _getSize_alt_(self,):
    return self._getSize_()
  def _getSize_(self,):
   _a_0=1
   _a_0 = fragments._c_closure_263(self.__shape,_a_0)
   _a_0 = numpy.int32(_a_0) # postprocess
   return numpy.int32(_a_0)
  @staticmethod
  def _match_getModel_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getModel_(*args):
    if len(args) != 0: return False
    return True
  def _getModel_alt_(self,):
    return self._getModel_()
  def _getModel_(self,):
   return (self.__model)
  @staticmethod
  def _match_getShape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getShape_(*args):
    if len(args) != 0: return False
    return True
  def _getShape_alt_(self,):
    return self._getShape_()
  def _getShape_(self,):
   return (numpy.array([self.__shape[_a_0] for _a_0 in range(0,int((self.__shape).shape[0]))], dtype=numpy.dtype(numpy.int32)))
  def _getNativeidxs_alt_(self,):
    return self._getNativeidxs_()
  def _getNativeidxs_(self,):
   return (self.__con_nativeidxs)
 return Constraint
mosek_fusion_Constraint=__mk_mosek_fusion_Constraint()
del __mk_mosek_fusion_Constraint
#BEFORE CLASS
def __mk_mosek_fusion_SliceConstraint():
 class SliceConstraint(mosek_fusion_Constraint):
  def toString(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.SliceConstraint.toString()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_SliceConstraint._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_SliceConstraint._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SliceConstraint.toString()')
  def __repr__(self): return 'mosek.fusion.SliceConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4SliceConstraint_2(c):
    o = SliceConstraint.__new__(SliceConstraint)
    o._ctor_init_Lmosek_4fusion_4SliceConstraint_2(c)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4SliceConstraint_2(*args):
    if len(args) != 1: return False
    c, = args
    return (__arg_match_Lmosek_4fusion_4SliceConstraint_2__(c))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4SliceConstraint_2(*args):
    if len(args) != 1: return False
    c, = args
    return (__arg_alt_match_Lmosek_4fusion_4SliceConstraint_2__(c))
  def _ctor_alt_init_Lmosek_4fusion_4SliceConstraint_2(self,c):
    self._ctor_init_Lmosek_4fusion_4SliceConstraint_2(c)
  def _ctor_init_Lmosek_4fusion_4SliceConstraint_2(self,c):
   mosek_fusion_Constraint._ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(self,c,c._getModel_())
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2_3I_3I(model,shape,nativeidxs):
    o = SliceConstraint.__new__(SliceConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2_3I_3I(model,shape,nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2_3I_3I(*args):
    if len(args) != 3: return False
    model,shape,nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match__3I__(shape) and __arg_match__3I__(nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2_3I_3I(*args):
    if len(args) != 3: return False
    model,shape,nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match__3I__(shape) and __arg_alt_match__3I__(nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2_3I_3I(self,model,shape,nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2_3I_3I(model,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Lmosek_4fusion_4Model_2_3I_3I(self,model,shape,nativeidxs):
   mosek_fusion_Constraint._ctor_init_Lmosek_4fusion_4Model_2_3I_3I(self,model,shape,nativeidxs)
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _a_0=mosek.fusion.Utils.StringBuffer()
   _a_0._a_S("SliceConstraint()")
   return (_a_0._toString_())
 return SliceConstraint
mosek_fusion_SliceConstraint=__mk_mosek_fusion_SliceConstraint()
del __mk_mosek_fusion_SliceConstraint
#BEFORE CLASS
def __mk_mosek_fusion_BoundInterfaceConstraint():
 class BoundInterfaceConstraint(mosek_fusion_SliceConstraint):
  __slots__ = ['_BoundInterfaceConstraint__islower']
  def dual(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BoundInterfaceConstraint.dual()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_BoundInterfaceConstraint._match_dual_(*args):
      return self._dual_(*args)
    elif mosek_fusion_BoundInterfaceConstraint._match_alt_dual_(*args):
      return self._dual_alt_(*args)
    else:
      raise ValueError('Invalid argument list dual('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceConstraint.dual()')
  def slice(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BoundInterfaceConstraint.slice(int32,int32)
      mosek.fusion.BoundInterfaceConstraint.slice(array(int32,ndim=1),array(int32,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    first : int32
    firsta : array(int32,ndim=1)
    last : int32
    lasta : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_BoundInterfaceConstraint._match_slice_II(*args):
      return self._slice_II(*args)
    elif mosek_fusion_BoundInterfaceConstraint._match_alt_slice_II(*args):
      return self._slice_alt_II(*args)
    elif mosek_fusion_BoundInterfaceConstraint._match_slice__3I_3I(*args):
      return self._slice__3I_3I(*args)
    elif mosek_fusion_BoundInterfaceConstraint._match_alt_slice__3I_3I(*args):
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceConstraint.slice(int32,int32)\n\tmosek.fusion.BoundInterfaceConstraint.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def index(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.BoundInterfaceConstraint.index(int32)
      mosek.fusion.BoundInterfaceConstraint.index(array(int32,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    idx : int32
    idxa : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_BoundInterfaceConstraint._match_index_I(*args):
      return self._index_I(*args)
    elif mosek_fusion_BoundInterfaceConstraint._match_alt_index_I(*args):
      return self._index_alt_I(*args)
    elif mosek_fusion_BoundInterfaceConstraint._match_index__3I(*args):
      return self._index__3I(*args)
    elif mosek_fusion_BoundInterfaceConstraint._match_alt_index__3I(*args):
      return self._index_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceConstraint.index(int32)\n\tmosek.fusion.BoundInterfaceConstraint.index(array(int32,ndim=1))')
  def __repr__(self): return 'mosek.fusion.BoundInterfaceConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2_3I_3IZ(m,shape,nativeidxs,islower):
    o = BoundInterfaceConstraint.__new__(BoundInterfaceConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2_3I_3IZ(m,shape,nativeidxs,islower)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2_3I_3IZ(*args):
    if len(args) != 4: return False
    m,shape,nativeidxs,islower, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(m) and __arg_match__3I__(shape) and __arg_match__3I__(nativeidxs) and __arg_match_Z__(islower))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2_3I_3IZ(*args):
    if len(args) != 4: return False
    m,shape,nativeidxs,islower, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(m) and __arg_alt_match__3I__(shape) and __arg_alt_match__3I__(nativeidxs) and __arg_alt_match_Z__(islower))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2_3I_3IZ(self,m,shape,nativeidxs,islower):
    self._ctor_init_Lmosek_4fusion_4Model_2_3I_3IZ(m,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)),islower)
  def _ctor_init_Lmosek_4fusion_4Model_2_3I_3IZ(self,m,shape,nativeidxs,islower):
   mosek_fusion_SliceConstraint._ctor_init_Lmosek_4fusion_4Model_2_3I_3I(self,m,shape,nativeidxs)
   (self.__islower) = islower
  @staticmethod
  def _ctor_Lmosek_4fusion_4SliceConstraint_2Z(c,islower):
    o = BoundInterfaceConstraint.__new__(BoundInterfaceConstraint)
    o._ctor_init_Lmosek_4fusion_4SliceConstraint_2Z(c,islower)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4SliceConstraint_2Z(*args):
    if len(args) != 2: return False
    c,islower, = args
    return (__arg_match_Lmosek_4fusion_4SliceConstraint_2__(c) and __arg_match_Z__(islower))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4SliceConstraint_2Z(*args):
    if len(args) != 2: return False
    c,islower, = args
    return (__arg_alt_match_Lmosek_4fusion_4SliceConstraint_2__(c) and __arg_alt_match_Z__(islower))
  def _ctor_alt_init_Lmosek_4fusion_4SliceConstraint_2Z(self,c,islower):
    self._ctor_init_Lmosek_4fusion_4SliceConstraint_2Z(c,islower)
  def _ctor_init_Lmosek_4fusion_4SliceConstraint_2Z(self,c,islower):
   mosek_fusion_SliceConstraint._ctor_init_Lmosek_4fusion_4SliceConstraint_2(self,c)
   (self.__islower) = islower
  @staticmethod
  def _match_dual_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dual_(*args):
    if len(args) != 0: return False
    return True
  def _dual_alt_(self,):
    return self._dual_()
  def _dual_(self,):
   _a_0=numpy.zeros((self._getSize_(),), dtype=numpy.dtype(numpy.float64))
   self._dual_1lu_I_3DZ(0,_a_0,self.__islower)
   return (_a_0)
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1))
  def _slice_alt__3I_3I(self,_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._slice__3I_3I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _slice__3I_3I(self,_a_0,_a_1):
   _a_2=mosek_fusion_Constraint._slice__3I_3I(self,_a_0,_a_1)
   return (self.__from_1_Lmosek_4fusion_4Constraint_2(_a_2))
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1))
  def _slice_alt_II(self,_t__a_0,_t__a_1):
    return self._slice_II(numpy.int32(__a_0),numpy.int32(__a_1))
  def _slice_II(self,_a_0,_a_1):
   _a_2=mosek_fusion_Constraint._slice_II(self,_a_0,_a_1)
   return (self.__from_1_Lmosek_4fusion_4Constraint_2(_a_2))
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  def _index_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._index__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _index__3I(self,_a_0):
   _a_1=mosek_fusion_Constraint._index__3I(self,_a_0)
   return (self.__from_1_Lmosek_4fusion_4Constraint_2(_a_1))
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _index_alt_I(self,_t__a_0):
    return self._index_I(numpy.int32(__a_0))
  def _index_I(self,_a_0):
   _a_1=mosek_fusion_Constraint._index_I(self,_a_0)
   return (self.__from_1_Lmosek_4fusion_4Constraint_2(_a_1))
  def __from_1_alt_Lmosek_4fusion_4Constraint_2(self,_t__a_0):
    return self.__from_1_Lmosek_4fusion_4Constraint_2(_a_0)
  def __from_1_Lmosek_4fusion_4Constraint_2(self,_a_0):
   _a_2=_a_0
   if   isinstance(_a_2,mosek_fusion_SliceConstraint):
    cc=_a_2
    return (mosek_fusion_BoundInterfaceConstraint._ctor_Lmosek_4fusion_4SliceConstraint_2Z(cc,self.__islower))
   else:
    cc=_a_2
    return (None)
 return BoundInterfaceConstraint
mosek_fusion_BoundInterfaceConstraint=__mk_mosek_fusion_BoundInterfaceConstraint()
del __mk_mosek_fusion_BoundInterfaceConstraint
#BEFORE CLASS
def __mk_mosek_fusion_ModelConstraint():
 class ModelConstraint(mosek_fusion_Constraint):
  __slots__ = ['_ModelConstraint__conid','_ModelConstraint__shape','_ModelConstraint__modelcon_nativeidxs','_ModelConstraint__name']
  def toString(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.ModelConstraint.toString()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_ModelConstraint._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_ModelConstraint._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ModelConstraint.toString()')
  def remove(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.ModelConstraint.remove()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_ModelConstraint._match_remove_(*args):
      return self._remove_(*args)
    elif mosek_fusion_ModelConstraint._match_alt_remove_(*args):
      return self._remove_alt_(*args)
    else:
      raise ValueError('Invalid argument list remove('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ModelConstraint.remove()')
  def __repr__(self): return 'mosek.fusion.ModelConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(c,m):
    o = ModelConstraint.__new__(ModelConstraint)
    o._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4ModelConstraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4ModelConstraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
   mosek_fusion_Constraint._ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(self,c,m)
   (self.__conid) = (c.__conid)
   self.__name = (c.__name)
   self.__modelcon_nativeidxs = (c.__modelcon_nativeidxs)
   self.__shape = (c.__shape)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2S_3I_3II(model,name,shape,nidxs,conid):
    o = ModelConstraint.__new__(ModelConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(model,name,shape,nidxs,conid)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2S_3I_3II(*args):
    if len(args) != 5: return False
    model,name,shape,nidxs,conid, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match__3I__(shape) and __arg_match__3I__(nidxs) and __arg_match_I__(conid))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2S_3I_3II(*args):
    if len(args) != 5: return False
    model,name,shape,nidxs,conid, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match__3I__(shape) and __arg_alt_match__3I__(nidxs) and __arg_alt_match_I__(conid))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,nidxs,conid):
    self._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(model,name,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(nidxs,dtype=numpy.dtype(numpy.int32)),numpy.int32(conid))
  def _ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,nidxs,conid):
   mosek_fusion_Constraint._ctor_init_Lmosek_4fusion_4Model_2_3I_3I(self,model,shape,nidxs)
   (self.__name) = name
   (self.__modelcon_nativeidxs) = nidxs
   (self.__shape) = shape
   (self.__conid) = conid
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _a_0=mosek.fusion.Utils.StringBuffer()
   _a_0._a_S("Constraint('")._a_S(self.__name)._a_S("')")
   return (_a_0._toString_())
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__a_0):
    return self._clone_Lmosek_4fusion_4Model_2(_a_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_a_0):
   pass
  @staticmethod
  def _match_remove_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_remove_(*args):
    if len(args) != 0: return False
    return True
  def _remove_alt_(self,):
    return self._remove_()
  def _remove_(self,):
   self._getModel_()._removeConstraintBlock_I(self.__conid)
 return ModelConstraint
mosek_fusion_ModelConstraint=__mk_mosek_fusion_ModelConstraint()
del __mk_mosek_fusion_ModelConstraint
#BEFORE CLASS
def __mk_mosek_fusion_LinearPSDConstraint():
 class LinearPSDConstraint(mosek_fusion_ModelConstraint):
  __slots__ = ['_LinearPSDConstraint__conedim','_LinearPSDConstraint__shape','_LinearPSDConstraint__conid','_LinearPSDConstraint__slackidxs','_LinearPSDConstraint__nativeidxs']
  def __repr__(self): return 'mosek.fusion.LinearPSDConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(c,m):
    o = LinearPSDConstraint.__new__(LinearPSDConstraint)
    o._ctor_init_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4LinearPSDConstraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearPSDConstraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m)
   self.__conid = (c.__conid)
   self.__slackidxs = (c.__slackidxs)
   self.__nativeidxs = (c.__nativeidxs)
   self.__conedim = (c.__conedim)
   self.__shape = (c.__shape)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SI_3II_3I_3J(model,name,conid,shape,conedim,nativeidxs,slackidxs):
    o = LinearPSDConstraint.__new__(LinearPSDConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2SI_3II_3I_3J(model,name,conid,shape,conedim,nativeidxs,slackidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SI_3II_3I_3J(*args):
    if len(args) != 7: return False
    model,name,conid,shape,conedim,nativeidxs,slackidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_I__(conid) and __arg_match__3I__(shape) and __arg_match_I__(conedim) and __arg_match__3I__(nativeidxs) and __arg_match__3J__(slackidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SI_3II_3I_3J(*args):
    if len(args) != 7: return False
    model,name,conid,shape,conedim,nativeidxs,slackidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_I__(conid) and __arg_alt_match__3I__(shape) and __arg_alt_match_I__(conedim) and __arg_alt_match__3I__(nativeidxs) and __arg_alt_match__3J__(slackidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SI_3II_3I_3J(self,model,name,conid,shape,conedim,nativeidxs,slackidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2SI_3II_3I_3J(model,name,numpy.int32(conid),numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.int32(conedim),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)),numpy.array(slackidxs,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_Lmosek_4fusion_4Model_2SI_3II_3I_3J(self,model,name,conid,shape,conedim,nativeidxs,slackidxs):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,nativeidxs,conid)
   (self.__conid) = conid
   (self.__slackidxs) = slackidxs
   (self.__nativeidxs) = nativeidxs
   (self.__conedim) = conedim
   (self.__shape) = shape
  def _domainToString_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__a_0,_t__a_1):
    return self._domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__a_0),_a_1)
  def _domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_a_0,_a_1):
   _a_2=mosek.fusion.Set._idxtokey__3IJ(self.__shape,_a_0)
   _a_1._a_S(" : element (")._a_I(_a_2[0])
   for _a_3 in range(1,int((_a_2).shape[0])):
    _a_1._a_S(",")._a_I(_a_2[_a_3])
   _a_1._a_S(") in a positive semi-definite cone of size (")._a_I(self.__shape[0])
   for _a_4 in range(1,int((_a_2).shape[0])):
    _a_1._a_S(",")._a_I(self.__shape[_a_4])
   _a_1._a_S(")")
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__a_0):
    return self._clone_Lmosek_4fusion_4Model_2(_a_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_a_0):
   return (mosek_fusion_LinearPSDConstraint._ctor_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(self,_a_0))
 return LinearPSDConstraint
mosek_fusion_LinearPSDConstraint=__mk_mosek_fusion_LinearPSDConstraint()
del __mk_mosek_fusion_LinearPSDConstraint
#BEFORE CLASS
def __mk_mosek_fusion_PSDConstraint():
 class PSDConstraint(mosek_fusion_ModelConstraint):
  __slots__ = ['_PSDConstraint__conedim1','_PSDConstraint__conedim0','_PSDConstraint__shape','_PSDConstraint__name','_PSDConstraint__slackidxs','_PSDConstraint__nativeidxs','_PSDConstraint__conid']
  def toString(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.PSDConstraint.toString()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_PSDConstraint._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_PSDConstraint._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDConstraint.toString()')
  def __repr__(self): return 'mosek.fusion.PSDConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(c,m):
    o = PSDConstraint.__new__(PSDConstraint)
    o._ctor_init_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4PSDConstraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4PSDConstraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m)
   self.__conid = (c.__conid)
   self.__name = (c.__name)
   self.__shape = (c.__shape)
   self.__slackidxs = (c.__slackidxs)
   self.__nativeidxs = (c.__nativeidxs)
   self.__conedim0 = (c.__conedim0)
   self.__conedim1 = (c.__conedim1)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SI_3III_3J_3I(model,name,conid,shape,conedim0,conedim1,slackidxs,nativeidxs):
    o = PSDConstraint.__new__(PSDConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2SI_3III_3J_3I(model,name,conid,shape,conedim0,conedim1,slackidxs,nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SI_3III_3J_3I(*args):
    if len(args) != 8: return False
    model,name,conid,shape,conedim0,conedim1,slackidxs,nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_I__(conid) and __arg_match__3I__(shape) and __arg_match_I__(conedim0) and __arg_match_I__(conedim1) and __arg_match__3J__(slackidxs) and __arg_match__3I__(nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SI_3III_3J_3I(*args):
    if len(args) != 8: return False
    model,name,conid,shape,conedim0,conedim1,slackidxs,nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_I__(conid) and __arg_alt_match__3I__(shape) and __arg_alt_match_I__(conedim0) and __arg_alt_match_I__(conedim1) and __arg_alt_match__3J__(slackidxs) and __arg_alt_match__3I__(nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SI_3III_3J_3I(self,model,name,conid,shape,conedim0,conedim1,slackidxs,nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2SI_3III_3J_3I(model,name,numpy.int32(conid),numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.int32(conedim0),numpy.int32(conedim1),numpy.array(slackidxs,dtype=numpy.dtype(numpy.int64)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Lmosek_4fusion_4Model_2SI_3III_3J_3I(self,model,name,conid,shape,conedim0,conedim1,slackidxs,nativeidxs):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,mosek.fusion.PSDConstraint.__computenidxs__3III_3I(shape,conedim0,conedim1,nativeidxs),conid)
   (self.__conid) = conid
   (self.__nativeidxs) = nativeidxs
   (self.__slackidxs) = slackidxs
   (self.__name) = name
   (self.__shape) = shape
   (self.__conedim0) = conedim0
   (self.__conedim1) = conedim1
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   raise mosek_fusion_UnimplementedError._ctor_S("PSDConstraint.toString not implemented")
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__a_0):
    return self._clone_Lmosek_4fusion_4Model_2(_a_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_a_0):
   return (mosek_fusion_PSDConstraint._ctor_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(self,_a_0))
  @staticmethod
  def __computenidxs_alt__3III_3I(_t__a_0,_t__a_1,_t__a_2,_t__a_3):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.int32(_t__a_1)
   _a_2=numpy.int32(_t__a_2)
   _a_3=numpy.array(_t__a_3,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_PSDConstraint.__computenidxs__3III_3I(_a_0,_a_1,_a_2,_a_3)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_3[:] = _a_3
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __computenidxs__3III_3I(_a_0,_a_1,_a_2,_a_3):
   _a_4=int((_a_0).shape[0])
   _a_5=(_a_1 < _a_2)
   _a_6=(_a_1 if (_a_5 ) else _a_2)
   _a_7=(_a_2 if (_a_5 ) else _a_1)
   _a_8=numpy.array([1,1,1,1,1], dtype=numpy.dtype(numpy.int32))
   _a_9=numpy.zeros((5,), dtype=numpy.dtype(numpy.int32))
   _a_10=1
   _a_10 = fragments._c_closure_264(_a_0,_a_10)
   _a_10 = numpy.int32(_a_10) # postprocess
   fragments._c_closure_265(_a_6,_a_8,_a_0) 
   _a_8[1] = _a_0[_a_6]
   fragments._c_closure_266(_a_6,_a_7,_a_8,_a_0) 
   _a_8[3] = _a_0[_a_7]
   fragments._c_closure_267(_a_7,_a_8,_a_4,_a_0) 
   _a_9[4] = 1
   fragments._c_closure_268(_a_8,_a_9) 
   _a_11=numpy.zeros((_a_10,), dtype=numpy.dtype(numpy.int32))
   _a_12=0
   _a_12 = fragments._c_closure_269(_a_8,_a_12,_a_3,_a_11,_a_9,_a_5)
   _a_12 = numpy.int32(_a_12) # postprocess
   return (_a_11)
 return PSDConstraint
mosek_fusion_PSDConstraint=__mk_mosek_fusion_PSDConstraint()
del __mk_mosek_fusion_PSDConstraint
#BEFORE CLASS
def __mk_mosek_fusion_RangedConstraint():
 class RangedConstraint(mosek_fusion_ModelConstraint):
  __slots__ = ['_RangedConstraint__nativeidxs','_RangedConstraint__shape']
  def upperBoundCon(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RangedConstraint.upperBoundCon()

    Description
    -----------

    Obtain the interface to the variable's upper bound. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_RangedConstraint._match_upperBoundCon_(*args):
      return self._upperBoundCon_(*args)
    elif mosek_fusion_RangedConstraint._match_alt_upperBoundCon_(*args):
      return self._upperBoundCon_alt_(*args)
    else:
      raise ValueError('Invalid argument list upperBoundCon('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedConstraint.upperBoundCon()')
  def lowerBoundCon(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.RangedConstraint.lowerBoundCon()

    Description
    -----------

    Obtain the interface to the variable's lower bound. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_RangedConstraint._match_lowerBoundCon_(*args):
      return self._lowerBoundCon_(*args)
    elif mosek_fusion_RangedConstraint._match_alt_lowerBoundCon_(*args):
      return self._lowerBoundCon_alt_(*args)
    else:
      raise ValueError('Invalid argument list lowerBoundCon('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedConstraint.lowerBoundCon()')
  def __repr__(self): return 'mosek.fusion.RangedConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Model_2(c,m):
    o = RangedConstraint.__new__(RangedConstraint)
    o._ctor_init_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4RangedConstraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4RangedConstraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m)
   self.__shape = (c.__shape)
   self.__nativeidxs = (c.__nativeidxs)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2S_3I_3II(model,name,shape,nativeidxs,conid):
    o = RangedConstraint.__new__(RangedConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(model,name,shape,nativeidxs,conid)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2S_3I_3II(*args):
    if len(args) != 5: return False
    model,name,shape,nativeidxs,conid, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match__3I__(shape) and __arg_match__3I__(nativeidxs) and __arg_match_I__(conid))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2S_3I_3II(*args):
    if len(args) != 5: return False
    model,name,shape,nativeidxs,conid, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match__3I__(shape) and __arg_alt_match__3I__(nativeidxs) and __arg_alt_match_I__(conid))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,nativeidxs,conid):
    self._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(model,name,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)),numpy.int32(conid))
  def _ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,nativeidxs,conid):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,nativeidxs,conid)
   (self.__shape) = shape
   (self.__nativeidxs) = nativeidxs
  @staticmethod
  def _match_upperBoundCon_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_upperBoundCon_(*args):
    if len(args) != 0: return False
    return True
  def _upperBoundCon_alt_(self,):
    return self._upperBoundCon_()
  def _upperBoundCon_(self,):
   return (mosek_fusion_BoundInterfaceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3IZ(self._getModel_(),self.__shape,self.__nativeidxs,False))
  @staticmethod
  def _match_lowerBoundCon_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_lowerBoundCon_(*args):
    if len(args) != 0: return False
    return True
  def _lowerBoundCon_alt_(self,):
    return self._lowerBoundCon_()
  def _lowerBoundCon_(self,):
   return (mosek_fusion_BoundInterfaceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3IZ(self._getModel_(),self.__shape,self.__nativeidxs,True))
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__a_0):
    return self._clone_Lmosek_4fusion_4Model_2(_a_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_a_0):
   return (mosek_fusion_RangedConstraint._ctor_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Model_2(self,_a_0))
 return RangedConstraint
mosek_fusion_RangedConstraint=__mk_mosek_fusion_RangedConstraint()
del __mk_mosek_fusion_RangedConstraint
#BEFORE CLASS
def __mk_mosek_fusion_ConicConstraint():
 class ConicConstraint(mosek_fusion_ModelConstraint):
  __slots__ = ['_ConicConstraint__indexnames','_ConicConstraint__nativeidxs','_ConicConstraint__names_flushed','_ConicConstraint__name','_ConicConstraint__shape','_ConicConstraint__dom','_ConicConstraint__conid']
  def toString(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.ConicConstraint.toString()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_ConicConstraint._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_ConicConstraint._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConicConstraint.toString()')
  def __repr__(self): return 'mosek.fusion.ConicConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4ConicConstraint_2Lmosek_4fusion_4Model_2(c,m):
    o = ConicConstraint.__new__(ConicConstraint)
    o._ctor_init_Lmosek_4fusion_4ConicConstraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ConicConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4ConicConstraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ConicConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4ConicConstraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4ConicConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4ConicConstraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4ConicConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m)
   self.__dom = (c.__dom)
   self.__conid = (c.__conid)
   self.__shape = (c.__shape)
   self.__name = (c.__name)
   self.__nativeidxs = (c.__nativeidxs)
   self.__names_flushed = (c.__names_flushed)
   self.__indexnames = (c.__indexnames)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(model,name,dom,shape,conid,nativeidxs,indexnames):
    o = ConicConstraint.__new__(ConicConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(model,name,dom,shape,conid,nativeidxs,indexnames)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(*args):
    if len(args) != 7: return False
    model,name,dom,shape,conid,nativeidxs,indexnames, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_Lmosek_4fusion_4ConeDomain_2__(dom) and __arg_match__3I__(shape) and __arg_match_I__(conid) and __arg_match__3I__(nativeidxs) and __arg_match__3_3S__(indexnames))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(*args):
    if len(args) != 7: return False
    model,name,dom,shape,conid,nativeidxs,indexnames, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(dom) and __arg_alt_match__3I__(shape) and __arg_alt_match_I__(conid) and __arg_alt_match__3I__(nativeidxs) and __arg_alt_match__3_3S__(indexnames))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(self,model,name,dom,shape,conid,nativeidxs,indexnames):
    self._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(model,name,dom,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.int32(conid),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)),numpy.array(indexnames,dtype=numpy.dtype(object)))
  def _ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(self,model,name,dom,shape,conid,nativeidxs,indexnames):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,numpy.array([(- (1 + nativeidxs[_a_0])) for _a_0 in range(0,int((nativeidxs).shape[0]))], dtype=numpy.dtype(numpy.int32)),(- (1 + conid)))
   (self.__dom) = dom
   (self.__shape) = shape
   (self.__name) = name
   (self.__nativeidxs) = nativeidxs
   (self.__indexnames) = indexnames
   (self.__conid) = conid
   self.__names_flushed = False
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _a_0=mosek.fusion.Utils.StringBuffer()
   _a_0._a_S("ConicConstraint('")._a_S(self.__name)._a_S("')")
   return (_a_0._toString_())
  def _domainToString_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__a_0,_t__a_1):
    return self._domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__a_0),_a_1)
  def _domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_a_0,_a_1):
   raise mosek_fusion_UnimplementedError._ctor_S("ConicConstraint.domainToString")
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__a_0):
    return self._clone_Lmosek_4fusion_4Model_2(_a_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_a_0):
   return (mosek_fusion_ConicConstraint._ctor_Lmosek_4fusion_4ConicConstraint_2Lmosek_4fusion_4Model_2(self,_a_0))
 return ConicConstraint
mosek_fusion_ConicConstraint=__mk_mosek_fusion_ConicConstraint()
del __mk_mosek_fusion_ConicConstraint
#BEFORE CLASS
def __mk_mosek_fusion_LinearConstraint():
 class LinearConstraint(mosek_fusion_ModelConstraint):
  __slots__ = ['_LinearConstraint__indexnames','_LinearConstraint__nidxs','_LinearConstraint__name','_LinearConstraint__conid']
  def toString(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.LinearConstraint.toString()

    Description
    -----------

    

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_LinearConstraint._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_LinearConstraint._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearConstraint.toString()')
  def __repr__(self): return 'mosek.fusion.LinearConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4LinearConstraint_2Lmosek_4fusion_4Model_2(c,m):
    o = LinearConstraint.__new__(LinearConstraint)
    o._ctor_init_Lmosek_4fusion_4LinearConstraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4LinearConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4LinearConstraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4LinearConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearConstraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4LinearConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4LinearConstraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4LinearConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m)
   self.__conid = (c.__conid)
   self.__name = (c.__name)
   self.__nidxs = mosek.fusion.Utils.Tools._arraycopy__3I((c.__nidxs))
   self.__indexnames = (c.__indexnames)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SI_3I_3I_3_3S(model,name,conid,shape,nidxs,indexnames):
    o = LinearConstraint.__new__(LinearConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2SI_3I_3I_3_3S(model,name,conid,shape,nidxs,indexnames)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SI_3I_3I_3_3S(*args):
    if len(args) != 6: return False
    model,name,conid,shape,nidxs,indexnames, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_I__(conid) and __arg_match__3I__(shape) and __arg_match__3I__(nidxs) and __arg_match__3_3S__(indexnames))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SI_3I_3I_3_3S(*args):
    if len(args) != 6: return False
    model,name,conid,shape,nidxs,indexnames, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_I__(conid) and __arg_alt_match__3I__(shape) and __arg_alt_match__3I__(nidxs) and __arg_alt_match__3_3S__(indexnames))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SI_3I_3I_3_3S(self,model,name,conid,shape,nidxs,indexnames):
    self._ctor_init_Lmosek_4fusion_4Model_2SI_3I_3I_3_3S(model,name,numpy.int32(conid),numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(nidxs,dtype=numpy.dtype(numpy.int32)),numpy.array(indexnames,dtype=numpy.dtype(object)))
  def _ctor_init_Lmosek_4fusion_4Model_2SI_3I_3I_3_3S(self,model,name,conid,shape,nidxs,indexnames):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,nidxs,conid)
   (self.__nidxs) = nidxs
   (self.__conid) = conid
   (self.__name) = name
   (self.__indexnames) = indexnames
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _a_0=mosek.fusion.Utils.StringBuffer()
   _a_0._a_S("LinearConstraint('")._a_S(self.__name)._a_S("')")
   return (_a_0._toString_())
  def _domainToString_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__a_0,_t__a_1):
    return self._domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__a_0),_a_1)
  def _domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_a_0,_a_1):
   pass
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__a_0):
    return self._clone_Lmosek_4fusion_4Model_2(_a_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_a_0):
   return (mosek_fusion_LinearConstraint._ctor_Lmosek_4fusion_4LinearConstraint_2Lmosek_4fusion_4Model_2(self,_a_0))
 return LinearConstraint
mosek_fusion_LinearConstraint=__mk_mosek_fusion_LinearConstraint()
del __mk_mosek_fusion_LinearConstraint
#BEFORE CLASS
def __mk_mosek_fusion_Set():
 class Set(object):
  @staticmethod
  def indexToString(*args):
    '''
    Syntax
    ------

      mosek.fusion.Set.indexToString(array(int32,ndim=1),int64)

    Description
    -----------

    

    Parameters
    ----------

    key : int64
    shape : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Set._match_indexToString__3IJ(*args):
      return mosek_fusion_Set._indexToString__3IJ(*args)
    elif mosek_fusion_Set._match_alt_indexToString__3IJ(*args):
      return mosek_fusion_Set._indexToString_alt__3IJ(*args)
    else:
      raise ValueError('Invalid argument list indexToString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.indexToString(array(int32,ndim=1),int64)')
  @staticmethod
  def match(*args):
    '''
    Syntax
    ------

      mosek.fusion.Set.match(array(int32,ndim=1),array(int32,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    s1 : array(int32,ndim=1)
    s2 : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Set._match_match__3I_3I(*args):
      return mosek_fusion_Set._match__3I_3I(*args)
    elif mosek_fusion_Set._match_alt_match__3I_3I(*args):
      return mosek_fusion_Set._match_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list match('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.match(array(int32,ndim=1),array(int32,ndim=1))')
  @staticmethod
  def size(*args):
    '''
    Syntax
    ------

      mosek.fusion.Set.size(array(int32,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    shape : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Set._match_size__3I(*args):
      return mosek_fusion_Set._size__3I(*args)
    elif mosek_fusion_Set._match_alt_size__3I(*args):
      return mosek_fusion_Set._size_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list size('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.size(array(int32,ndim=1))')
  @staticmethod
  def strides(*args):
    '''
    Syntax
    ------

      mosek.fusion.Set.strides(array(int32,ndim=1))

    Description
    -----------

    Compute the strides from a shape. 

    Parameters
    ----------

    shape : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Set._match_strides__3I(*args):
      return mosek_fusion_Set._strides__3I(*args)
    elif mosek_fusion_Set._match_alt_strides__3I(*args):
      return mosek_fusion_Set._strides_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list strides('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.strides(array(int32,ndim=1))')
  @staticmethod
  def make(*args):
    '''
    Syntax
    ------

      mosek.fusion.Set.make(array(string,ndim=1))
      mosek.fusion.Set.make(int32)
      mosek.fusion.Set.make(array(int32,ndim=1))
      mosek.fusion.Set.make(array(int32,ndim=1),array(int32,ndim=1))
      mosek.fusion.Set.make(int32,int32)
      mosek.fusion.Set.make(int32,int32,int32)

    Description
    -----------

    Creates a shape. 

    Parameters
    ----------

    names : array(string,ndim=1)
        A list of strings for a set of strings. 
    s1 : int32
        Size of the first dimension. 
    s2 : int32
        Size of the second dimension. 
    s3 : int32
        Size of the third dimension. 
    set1 : array(int32,ndim=1)
        First factor in a Cartesian product. 
    set2 : array(int32,ndim=1)
        Second factor in a Cartesian product. 
    sizes : array(int32,ndim=1)
        The sizes of dimensions for a multi-dimensional integer set. 
    sz : int32
        The size of a one-dimensional set of integers. 
    '''
    if False: pass
    elif mosek_fusion_Set._match_make__3S(*args):
      return mosek_fusion_Set._make__3S(*args)
    elif mosek_fusion_Set._match_alt_make__3S(*args):
      return mosek_fusion_Set._make_alt__3S(*args)
    elif mosek_fusion_Set._match_make_I(*args):
      return mosek_fusion_Set._make_I(*args)
    elif mosek_fusion_Set._match_alt_make_I(*args):
      return mosek_fusion_Set._make_alt_I(*args)
    elif mosek_fusion_Set._match_make__3I(*args):
      return mosek_fusion_Set._make__3I(*args)
    elif mosek_fusion_Set._match_alt_make__3I(*args):
      return mosek_fusion_Set._make_alt__3I(*args)
    elif mosek_fusion_Set._match_make__3I_3I(*args):
      return mosek_fusion_Set._make__3I_3I(*args)
    elif mosek_fusion_Set._match_alt_make__3I_3I(*args):
      return mosek_fusion_Set._make_alt__3I_3I(*args)
    elif mosek_fusion_Set._match_make_II(*args):
      return mosek_fusion_Set._make_II(*args)
    elif mosek_fusion_Set._match_alt_make_II(*args):
      return mosek_fusion_Set._make_alt_II(*args)
    elif mosek_fusion_Set._match_make_III(*args):
      return mosek_fusion_Set._make_III(*args)
    elif mosek_fusion_Set._match_alt_make_III(*args):
      return mosek_fusion_Set._make_alt_III(*args)
    else:
      raise ValueError('Invalid argument list make('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.make(array(string,ndim=1))\n\tmosek.fusion.Set.make(int32)\n\tmosek.fusion.Set.make(array(int32,ndim=1))\n\tmosek.fusion.Set.make(array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Set.make(int32,int32)\n\tmosek.fusion.Set.make(int32,int32,int32)')
  @staticmethod
  def keyToString(*args):
    '''
    Syntax
    ------

      mosek.fusion.Set.keyToString(array(int32,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    key : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Set._match_keyToString__3I(*args):
      return mosek_fusion_Set._keyToString__3I(*args)
    elif mosek_fusion_Set._match_alt_keyToString__3I(*args):
      return mosek_fusion_Set._keyToString_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list keyToString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.keyToString(array(int32,ndim=1))')
  @staticmethod
  def linearidx(*args):
    '''
    Syntax
    ------

      mosek.fusion.Set.linearidx(array(int32,ndim=1),array(int32,ndim=1))

    Description
    -----------

    
    Look up the linear index associated with a key.
            

    Parameters
    ----------

    key : array(int32,ndim=1)
    shape : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Set._match_linearidx__3I_3I(*args):
      return mosek_fusion_Set._linearidx__3I_3I(*args)
    elif mosek_fusion_Set._match_alt_linearidx__3I_3I(*args):
      return mosek_fusion_Set._linearidx_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list linearidx('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.linearidx(array(int32,ndim=1),array(int32,ndim=1))')
  @staticmethod
  def idxtokey(*args):
    '''
    Syntax
    ------

      mosek.fusion.Set.idxtokey(array(int32,ndim=1),int64)
      mosek.fusion.Set.idxtokey(array(int32,ndim=1),int64,array(int32,ndim=1))

    Description
    -----------

    Convert a linear index to a N-dimensional key.

    Parameters
    ----------

    dest : array(int32,ndim=1)
    idx : int64
    shape : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Set._match_idxtokey__3IJ(*args):
      return mosek_fusion_Set._idxtokey__3IJ(*args)
    elif mosek_fusion_Set._match_alt_idxtokey__3IJ(*args):
      return mosek_fusion_Set._idxtokey_alt__3IJ(*args)
    elif mosek_fusion_Set._match_idxtokey__3IJ_3I(*args):
      return mosek_fusion_Set._idxtokey__3IJ_3I(*args)
    elif mosek_fusion_Set._match_alt_idxtokey__3IJ_3I(*args):
      return mosek_fusion_Set._idxtokey_alt__3IJ_3I(*args)
    else:
      raise ValueError('Invalid argument list idxtokey('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.idxtokey(array(int32,ndim=1),int64)\n\tmosek.fusion.Set.idxtokey(array(int32,ndim=1),int64,array(int32,ndim=1))')
  @staticmethod
  def indexToKey(*args):
    '''
    Syntax
    ------

      mosek.fusion.Set.indexToKey(array(int32,ndim=1),int64,array(int32,ndim=1))

    Description
    -----------

    

    Parameters
    ----------

    key : int64
    res : array(int32,ndim=1)
    shape : array(int32,ndim=1)
    '''
    if False: pass
    elif mosek_fusion_Set._match_indexToKey__3IJ_3I(*args):
      return mosek_fusion_Set._indexToKey__3IJ_3I(*args)
    elif mosek_fusion_Set._match_alt_indexToKey__3IJ_3I(*args):
      return mosek_fusion_Set._indexToKey_alt__3IJ_3I(*args)
    else:
      raise ValueError('Invalid argument list indexToKey('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.indexToKey(array(int32,ndim=1),int64,array(int32,ndim=1))')
  @staticmethod
  def scalar(*args):
    '''
    Syntax
    ------

      mosek.fusion.Set.scalar()

    Description
    -----------

    Create a shape of size 1. 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_Set._match_scalar_(*args):
      return mosek_fusion_Set._scalar_(*args)
    elif mosek_fusion_Set._match_alt_scalar_(*args):
      return mosek_fusion_Set._scalar_alt_(*args)
    else:
      raise ValueError('Invalid argument list scalar('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.scalar()')
  def __repr__(self): return 'mosek.fusion.Set'
  @staticmethod
  def _match_size__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_size__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  @staticmethod
  def _size_alt__3I(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._size__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _size__3I(_a_0):
   _a_1=1
   _a_1 = fragments._c_closure_270(_a_0,_a_1)
   _a_1 = numpy.int64(_a_1) # postprocess
   return numpy.int64(_a_1)
  @staticmethod
  def _match_match__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_match__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1))
  @staticmethod
  def _match_alt__3I_3I(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._match__3I_3I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _match__3I_3I(_a_0,_a_1):
   if (int((_a_0).shape[0])!=int((_a_1).shape[0])):
    return (False)
   for _a_2 in range(0,int((_a_0).shape[0])):
    if (_a_0[_a_2]!=_a_1[_a_2]):
     return (False)
   return (True)
  @staticmethod
  def _match_linearidx__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_linearidx__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1))
  @staticmethod
  def _linearidx_alt__3I_3I(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._linearidx__3I_3I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _linearidx__3I_3I(_a_0,_a_1):
   _a_2=_a_1[0]
   _a_2 = fragments._c_closure_271(_a_1,_a_2,_a_0)
   _a_2 = numpy.int64(_a_2) # postprocess
   return numpy.int64(_a_2)
  @staticmethod
  def _match_idxtokey__3IJ(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match_J__(_a_1))
  @staticmethod
  def _match_alt_idxtokey__3IJ(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match_J__(_a_1))
  @staticmethod
  def _idxtokey_alt__3IJ(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.int64(_t__a_1)
   _1_res = mosek_fusion_Set._idxtokey__3IJ(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _idxtokey__3IJ(_a_0,_a_1):
   _a_2=numpy.zeros((int((_a_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
   mosek.fusion.Set._idxtokey__3IJ_3I(_a_0,_a_1,_a_2)
   return (_a_2)
  @staticmethod
  def _match_idxtokey__3IJ_3I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match__3I__(_a_0) and __arg_match_J__(_a_1) and __arg_match__3I__(_a_2))
  @staticmethod
  def _match_alt_idxtokey__3IJ_3I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match_J__(_a_1) and __arg_alt_match__3I__(_a_2))
  @staticmethod
  def _idxtokey_alt__3IJ_3I(_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.int64(_t__a_1)
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._idxtokey__3IJ_3I(_a_0,_a_1,_a_2)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _idxtokey__3IJ_3I(_a_0,_a_1,_a_2):
   fragments._c_closure_272(_a_2,_a_1,_a_0) 
  @staticmethod
  def _match_indexToString__3IJ(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match_J__(_a_1))
  @staticmethod
  def _match_alt_indexToString__3IJ(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match_J__(_a_1))
  @staticmethod
  def _indexToString_alt__3IJ(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.int64(_t__a_1)
   _1_res = mosek_fusion_Set._indexToString__3IJ(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _indexToString__3IJ(_a_0,_a_1):
   _a_2=int((_a_0).shape[0])
   _a_3=mosek.fusion.Utils.StringBuffer()
   if (_a_2==0):
    return ("0")
   elif (_a_2==1):
    return (_a_3._a_J(_a_1)._toString_())
   else:
    _a_4=_a_1
    _a_5=numpy.zeros((_a_2,), dtype=numpy.dtype(numpy.int32))
    _a_4 = fragments._c_closure_273(_a_5,_a_2,_a_4,_a_0)
    _a_4 = numpy.int64(_a_4) # postprocess
    _a_5[0] = numpy.int32(_a_4)
    _a_3._a_I(_a_5[0])
    for _a_6 in range(1,_a_2):
     _a_3._a_S(",")._a_I(_a_5[_a_6])
    return (_a_3._toString_())
  @staticmethod
  def _match_keyToString__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_keyToString__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  @staticmethod
  def _keyToString_alt__3I(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._keyToString__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _keyToString__3I(_a_0):
   _a_1=mosek.fusion.Utils.StringBuffer()
   _a_1._a_I(_a_0[0])
   for _a_2 in range(1,int((_a_0).shape[0])):
    _a_1._a_S(",")._a_I(_a_0[_a_2])
   return (_a_1._toString_())
  @staticmethod
  def _match_indexToKey__3IJ_3I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match__3I__(_a_0) and __arg_match_J__(_a_1) and __arg_match__3I__(_a_2))
  @staticmethod
  def _match_alt_indexToKey__3IJ_3I(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match_J__(_a_1) and __arg_alt_match__3I__(_a_2))
  @staticmethod
  def _indexToKey_alt__3IJ_3I(_t__a_0,_t__a_1,_t__a_2):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.int64(_t__a_1)
   _a_2=numpy.array(_t__a_2,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._indexToKey__3IJ_3I(_a_0,_a_1,_a_2)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_2[:] = _a_2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _indexToKey__3IJ_3I(_a_0,_a_1,_a_2):
   fragments._c_closure_274(_a_1,_a_2,_a_0) 
  @staticmethod
  def _match_strides__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_strides__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  @staticmethod
  def _strides_alt__3I(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._strides__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _strides__3I(_a_0):
   _a_1=int((_a_0).shape[0])
   _a_2=numpy.zeros((_a_1,), dtype=numpy.dtype(numpy.int64))
   _a_2[(_a_1 - 1)] = 1
   fragments._c_closure_275(_a_1,_a_0,_a_2) 
   return (_a_2)
  @staticmethod
  def _match_make__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match__3I__(_a_0) and __arg_match__3I__(_a_1))
  @staticmethod
  def _match_alt_make__3I_3I(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match__3I__(_a_0) and __arg_alt_match__3I__(_a_1))
  @staticmethod
  def _make_alt__3I_3I(_t__a_0,_t__a_1):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _a_1=numpy.array(_t__a_1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._make__3I_3I(_a_0,_a_1)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__a_1[:] = _a_1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _make__3I_3I(_a_0,_a_1):
   _a_2=numpy.zeros(((int((_a_0).shape[0]) + int((_a_1).shape[0])),), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_276(_a_2,_a_0) 
   fragments._c_closure_277(_a_2,_a_0,_a_1) 
   return (_a_2)
  @staticmethod
  def _match_make__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3I__(_a_0))
  @staticmethod
  def _match_alt_make__3I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3I__(_a_0))
  @staticmethod
  def _make_alt__3I(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._make__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _make__3I(_a_0):
   return (numpy.array([_a_0[_a_1] for _a_1 in range(0,int((_a_0).shape[0]))], dtype=numpy.dtype(numpy.int32)))
  @staticmethod
  def _match_make_III(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1) and __arg_match_I__(_a_2))
  @staticmethod
  def _match_alt_make_III(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_match_I__(_a_2))
  @staticmethod
  def _make_alt_III(_t__a_0,_t__a_1,_t__a_2):
    return mosek_fusion_Set._make_III(numpy.int32(__a_0),numpy.int32(__a_1),numpy.int32(__a_2))
  @staticmethod
  def _make_III(_a_0,_a_1,_a_2):
   return (numpy.array([_a_0,_a_1,_a_2], dtype=numpy.dtype(numpy.int32)))
  @staticmethod
  def _match_make_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1))
  @staticmethod
  def _match_alt_make_II(*args):
    if len(args) != 2: return False
    _a_0,_a_1, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1))
  @staticmethod
  def _make_alt_II(_t__a_0,_t__a_1):
    return mosek_fusion_Set._make_II(numpy.int32(__a_0),numpy.int32(__a_1))
  @staticmethod
  def _make_II(_a_0,_a_1):
   return (numpy.array([_a_0,_a_1], dtype=numpy.dtype(numpy.int32)))
  @staticmethod
  def _match_make_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_make_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  @staticmethod
  def _make_alt_I(_t__a_0):
    return mosek_fusion_Set._make_I(numpy.int32(__a_0))
  @staticmethod
  def _make_I(_a_0):
   return (numpy.array([_a_0], dtype=numpy.dtype(numpy.int32)))
  @staticmethod
  def _match_scalar_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_scalar_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _scalar_alt_():
    return mosek_fusion_Set._scalar_()
  @staticmethod
  def _scalar_():
   return (numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)))
  @staticmethod
  def _match_make__3S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match__3S__(_a_0))
  @staticmethod
  def _match_alt_make__3S(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match__3S__(_a_0))
  @staticmethod
  def _make_alt__3S(_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_Set._make__3S(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _make__3S(_a_0):
   return (numpy.array([int((_a_0).shape[0])], dtype=numpy.dtype(numpy.int32)))
 return Set
mosek_fusion_Set=__mk_mosek_fusion_Set()
del __mk_mosek_fusion_Set
#BEFORE CLASS
def __mk_mosek_fusion_ConeDomain():
 class ConeDomain(object):
  __slots__ = ['_indexnames','_domsize','_domofs','_alpha','_shape','_int_flag','_axisset','_axisidx','_key']
  def axis(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.ConeDomain.axis(int32)

    Description
    -----------

    Set the dimension along which the cones are created.

    Parameters
    ----------

    a : int32
    '''
    if False: pass
    elif mosek_fusion_ConeDomain._match_axis_I(*args):
      return self._axis_I(*args)
    elif mosek_fusion_ConeDomain._match_alt_axis_I(*args):
      return self._axis_alt_I(*args)
    else:
      raise ValueError('Invalid argument list axis('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConeDomain.axis(int32)')
  def withNamesOnAxis(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.ConeDomain.withNamesOnAxis(array(string,ndim=1),int32)

    Description
    -----------

    Set index names in a specific axis. 

    Parameters
    ----------

    axis : int32
        The axis to change names on.
    names : array(string,ndim=1)
        List of names, this must match the actual dimension on that axis. 
    '''
    if False: pass
    elif mosek_fusion_ConeDomain._match_withNamesOnAxis__3SI(*args):
      return self._withNamesOnAxis__3SI(*args)
    elif mosek_fusion_ConeDomain._match_alt_withNamesOnAxis__3SI(*args):
      return self._withNamesOnAxis_alt__3SI(*args)
    else:
      raise ValueError('Invalid argument list withNamesOnAxis('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConeDomain.withNamesOnAxis(array(string,ndim=1),int32)')
  def axisIsSet(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.ConeDomain.axisIsSet()

    Description
    -----------

    Returns true if the cone axis was set 

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_ConeDomain._match_axisIsSet_(*args):
      return self._axisIsSet_(*args)
    elif mosek_fusion_ConeDomain._match_alt_axisIsSet_(*args):
      return self._axisIsSet_alt_(*args)
    else:
      raise ValueError('Invalid argument list axisIsSet('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConeDomain.axisIsSet()')
  def withShape(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.ConeDomain.withShape(array(int32,ndim=1))
      mosek.fusion.ConeDomain.withShape(int32)
      mosek.fusion.ConeDomain.withShape(int32,int32)
      mosek.fusion.ConeDomain.withShape(int32,int32,int32)

    Description
    -----------

    Set the shape of the domain.  

    Parameters
    ----------

    dim0 : int32
        First dimension
    dim1 : int32
        Second dimension
    dim2 : int32
        Third dimension
    shp : array(int32,ndim=1)
        The shape of the domain
    '''
    if False: pass
    elif mosek_fusion_ConeDomain._match_withShape__3I(*args):
      return self._withShape__3I(*args)
    elif mosek_fusion_ConeDomain._match_alt_withShape__3I(*args):
      return self._withShape_alt__3I(*args)
    elif mosek_fusion_ConeDomain._match_withShape_I(*args):
      return self._withShape_I(*args)
    elif mosek_fusion_ConeDomain._match_alt_withShape_I(*args):
      return self._withShape_alt_I(*args)
    elif mosek_fusion_ConeDomain._match_withShape_II(*args):
      return self._withShape_II(*args)
    elif mosek_fusion_ConeDomain._match_alt_withShape_II(*args):
      return self._withShape_alt_II(*args)
    elif mosek_fusion_ConeDomain._match_withShape_III(*args):
      return self._withShape_III(*args)
    elif mosek_fusion_ConeDomain._match_alt_withShape_III(*args):
      return self._withShape_alt_III(*args)
    else:
      raise ValueError('Invalid argument list withShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConeDomain.withShape(array(int32,ndim=1))\n\tmosek.fusion.ConeDomain.withShape(int32)\n\tmosek.fusion.ConeDomain.withShape(int32,int32)\n\tmosek.fusion.ConeDomain.withShape(int32,int32,int32)')
  def getAxis(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.ConeDomain.getAxis()

    Description
    -----------

    Get the dimension along which the cones are created.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_ConeDomain._match_getAxis_(*args):
      return self._getAxis_(*args)
    elif mosek_fusion_ConeDomain._match_alt_getAxis_(*args):
      return self._getAxis_alt_(*args)
    else:
      raise ValueError('Invalid argument list getAxis('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConeDomain.getAxis()')
  def integral(self,*args):
    '''
    Syntax
    ------

      mosek.fusion.ConeDomain.integral()

    Description
    -----------

    Creates a domain of integral variables.

    Parameters
    ----------

    '''
    if False: pass
    elif mosek_fusion_ConeDomain._match_integral_(*args):
      return self._integral_(*args)
    elif mosek_fusion_ConeDomain._match_alt_integral_(*args):
      return self._integral_alt_(*args)
    else:
      raise ValueError('Invalid argument list integral('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConeDomain.integral()')
  def __repr__(self): return 'mosek.fusion.ConeDomain'
  @staticmethod
  def _ctor_Emosek_4fusion_4QConeKey_2_3D_3I(k,alpha,d):
    o = ConeDomain.__new__(ConeDomain)
    o._ctor_init_Emosek_4fusion_4QConeKey_2_3D_3I(k,alpha,d)
    return o
  @staticmethod
  def __match_ctor_Emosek_4fusion_4QConeKey_2_3D_3I(*args):
    if len(args) != 3: return False
    k,alpha,d, = args
    return (__arg_match_Emosek_4fusion_4QConeKey_2__(k) and __arg_match__3D__(alpha) and __arg_match__3I__(d))
  @staticmethod
  def __match_alt_ctor_Emosek_4fusion_4QConeKey_2_3D_3I(*args):
    if len(args) != 3: return False
    k,alpha,d, = args
    return (__arg_alt_match_Emosek_4fusion_4QConeKey_2__(k) and __arg_alt_match__3D__(alpha) and __arg_alt_match__3I__(d))
  def _ctor_alt_init_Emosek_4fusion_4QConeKey_2_3D_3I(self,k,alpha,d):
    self._ctor_init_Emosek_4fusion_4QConeKey_2_3D_3I(k,numpy.array(alpha,dtype=numpy.dtype(numpy.float64)),numpy.array(d,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Emosek_4fusion_4QConeKey_2_3D_3I(self,k,alpha,d):
   self._shape = (mosek.fusion.Utils.Tools._arraycopy__3I(d) if ((d is not None) ) else None)
   self._domsize = 0
   (self._alpha) = alpha
   self._key = k
   self._axisidx = 0
   self._axisset = False
   self._int_flag = False
   self._domofs = None
   self._indexnames = None
  @staticmethod
  def _ctor_Emosek_4fusion_4QConeKey_2_3I(k,d):
    o = ConeDomain.__new__(ConeDomain)
    o._ctor_init_Emosek_4fusion_4QConeKey_2_3I(k,d)
    return o
  @staticmethod
  def __match_ctor_Emosek_4fusion_4QConeKey_2_3I(*args):
    if len(args) != 2: return False
    k,d, = args
    return (__arg_match_Emosek_4fusion_4QConeKey_2__(k) and __arg_match__3I__(d))
  @staticmethod
  def __match_alt_ctor_Emosek_4fusion_4QConeKey_2_3I(*args):
    if len(args) != 2: return False
    k,d, = args
    return (__arg_alt_match_Emosek_4fusion_4QConeKey_2__(k) and __arg_alt_match__3I__(d))
  def _ctor_alt_init_Emosek_4fusion_4QConeKey_2_3I(self,k,d):
    self._ctor_init_Emosek_4fusion_4QConeKey_2_3I(k,numpy.array(d,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Emosek_4fusion_4QConeKey_2_3I(self,k,d):
   mosek_fusion_ConeDomain._ctor_init_Emosek_4fusion_4QConeKey_2_3D_3I(self,k,None,d)
  @staticmethod
  def _ctor_Lmosek_4fusion_4ConeDomain_2(other):
    o = ConeDomain.__new__(ConeDomain)
    o._ctor_init_Lmosek_4fusion_4ConeDomain_2(other)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 1: return False
    other, = args
    return (__arg_match_Lmosek_4fusion_4ConeDomain_2__(other))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 1: return False
    other, = args
    return (__arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(other))
  def _ctor_alt_init_Lmosek_4fusion_4ConeDomain_2(self,other):
    self._ctor_init_Lmosek_4fusion_4ConeDomain_2(other)
  def _ctor_init_Lmosek_4fusion_4ConeDomain_2(self,other):
   self._key = (other._key)
   self._axisidx = (other._axisidx)
   self._axisset = (other._axisset)
   self._int_flag = (other._int_flag)
   self._shape = (other._shape)
   self._alpha = (other._alpha)
   self._domofs = (other._domofs)
   self._domsize = (other._domsize)
   self._indexnames = (other._indexnames)
  def _match_1shape_alt__3I(self,_t__a_0):
   _a_0=numpy.array(_t__a_0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._match_1shape__3I(_a_0)
   try:
     _t__a_0[:] = _a_0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _match_1shape__3I(self,_a_0):
   return (((self._shape is None) or mosek.fusion.Set._match__3I_3I(_a_0,self._shape)))
  @staticmethod
  def _match_integral_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_integral_(*args):
    if len(args) != 0: return False
    return True
  def _integral_alt_(self,):
    return self._integral_()
  def _integral_(self,):
   self._int_flag = True
   return (self)
  @staticmethod
  def _match_axisIsSet_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_axisIsSet_(*args):
    if len(args) != 0: return False
    return True
  def _axisIsSet_alt_(self,):
    return self._axisIsSet_()
  def _axisIsSet_(self,):
   return (self._axisset)
  @staticmethod
  def _match_getAxis_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getAxis_(*args):
    if len(args) != 0: return False
    return True
  def _getAxis_alt_(self,):
    return self._getAxis_()
  def _getAxis_(self,):
   return numpy.int32(self._axisidx)
  @staticmethod
  def _match_axis_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_match_I__(_a_0))
  @staticmethod
  def _match_alt_axis_I(*args):
    if len(args) != 1: return False
    _a_0, = args
    return (__arg_alt_match_I__(_a_0))
  def _axis_alt_I(self,_t__a_0):
    return self._axis_I(numpy.int32(__a_0))
  def _axis_I(self,_a_0):
   self._axisidx = _a_0
   self._axisset = True
   return (self)
  @staticmethod
  def _match_withShape_III(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_match_I__(_a_0) and __arg_match_I__(_a_1) and __arg_match_I__(_a_2))
  @staticmethod
  def _match_alt_withShape_III(*args):
    if len(args) != 3: return False
    _a_0,_a_1,_a_2, = args
    return (__arg_alt_match_I__(_a_0) and __arg_alt_match_I__(_a_1) and __arg_alt_matc