/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.CommonTools;
import mosek.fusion.Debug;
import mosek.fusion.DimensionError;
import mosek.fusion.LengthError;
import mosek.fusion.Model;
import mosek.fusion.ModelError;
import mosek.fusion.NilVariable;
import mosek.fusion.Set;
import mosek.fusion.SliceVariable;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Variable;

public class Var {
    public static Variable empty(int[] nArray) {
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            if (nArray[i] >= 0) continue;
            throw new DimensionError("Invalid shape");
        }
        return new NilVariable(nArray);
    }

    public static Variable compress(Variable variable) {
        int n;
        int[] nArray = variable.getShape();
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = n2;
        for (n = n4; n < n5; ++n) {
            if (nArray[n] == 1) continue;
            ++n3;
        }
        int[] nArray2 = new int[n3];
        n5 = 0;
        n = 0;
        int n6 = n2;
        for (int i = n; i < n6; ++i) {
            if (nArray[i] == 1) continue;
            nArray2[n5] = nArray[i];
            ++n5;
        }
        return Var.reshape(variable, nArray2);
    }

    public static Variable reshape(Variable variable, int n) {
        return Var.reshape(variable, new int[]{n});
    }

    public static Variable reshape(Variable variable, int n, int n2) {
        return Var.reshape(variable, new int[]{n, n2});
    }

    public static Variable flatten(Variable variable) {
        return Var.reshape(variable, new int[]{(int)Set.size(variable.getShape())});
    }

    public static Variable reshape(Variable variable, int[] nArray) {
        return variable.reshape(nArray);
    }

    protected static Variable index_permute_(Variable variable, int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        long[] lArray;
        long[] lArray2;
        long[] lArray3;
        int n6;
        int n7;
        int[] nArray2 = variable.getShape();
        int n8 = nArray2.length;
        int n9 = 1;
        int n10 = 0;
        int n11 = n8;
        for (n7 = n10; n7 < n11; ++n7) {
            n9 *= nArray2[n7];
        }
        n10 = variable.numInst();
        long[] lArray4 = new long[n8];
        lArray4[n8 - 1] = 1L;
        n7 = 1;
        int n12 = n8;
        for (n6 = n7; n6 < n12; ++n6) {
            lArray4[n8 - n6 - 1] = lArray4[n8 - n6] * (long)nArray2[nArray[n8 - n6]];
        }
        if (n10 < n9) {
            lArray3 = new long[n10];
            lArray2 = new long[n10];
            variable.inst(0, lArray3, 0, lArray2);
        } else {
            lArray3 = null;
            lArray2 = new long[n10];
            variable.inst(0, lArray2);
        }
        if (lArray3 == null) {
            lArray = new long[n10];
            int[] nArray3 = new int[n8];
            n6 = 0;
            n5 = n10;
            for (n4 = n6; n4 < n5; ++n4) {
                int n13 = n4;
                n3 = 0;
                int n14 = n8;
                for (n2 = n3; n2 < n14; ++n2) {
                    nArray3[n8 - n4 - 1] = n13 % nArray2[n8 - n4 - 1];
                    n13 /= nArray2[n8 - n4 - 1];
                }
                n3 = 0;
                n14 = 0;
                n2 = n8;
                for (n = n14; n < n2; ++n) {
                    n3 += (int)((long)nArray3[nArray[n]] * lArray4[n]);
                }
                lArray[n3] = lArray2[n4];
            }
            lArray2 = lArray;
        } else {
            int n15;
            lArray = new long[n10];
            int[] nArray4 = new int[n8];
            n6 = 0;
            n5 = n10;
            for (n4 = n6; n4 < n5; ++n4) {
                int n16 = n4;
                n3 = 0;
                n15 = n8;
                for (n2 = n3; n2 < n15; ++n2) {
                    nArray4[n8 - n4 - 1] = n16 % nArray2[n8 - n4 - 1];
                    n16 /= nArray2[n8 - n4 - 1];
                }
                n3 = 0;
                n15 = 0;
                n2 = n8;
                for (n = n15; n < n2; ++n) {
                    n3 += (int)((long)nArray4[nArray[n]] * lArray4[n]);
                }
                lArray[n4] = n3;
            }
            int n17 = 0;
            n6 = 0;
            n5 = n10;
            n4 = n6 < n5 ? n5 - n6 : 0;
            long[] lArray5 = new long[n4];
            n3 = n6;
            n15 = 0;
            while (n15 < n4) {
                lArray5[n17] = n3;
                ++n17;
                ++n15;
                ++n3;
            }
            long[] lArray6 = lArray5;
            CommonTools.argQsort(lArray6, lArray, null, 0L, (long)n10);
            n2 = 0;
            n = 0;
            int n18 = n10;
            int n19 = n < n18 ? n18 - n : 0;
            long[] lArray7 = new long[n19];
            int n20 = n;
            int n21 = 0;
            while (n21 < n19) {
                lArray7[n2] = lArray3[(int)lArray6[n20]];
                ++n2;
                ++n21;
                ++n20;
            }
            lArray3 = lArray7;
            n21 = 0;
            int n22 = 0;
            int n23 = n10;
            int n24 = n22 < n23 ? n23 - n22 : 0;
            long[] lArray8 = new long[n24];
            int n25 = n22;
            int n26 = 0;
            while (n26 < n24) {
                lArray8[n21] = lArray2[(int)lArray6[n25]];
                ++n21;
                ++n26;
                ++n25;
            }
            lArray2 = lArray8;
        }
        int n27 = 0;
        int n28 = 0;
        n6 = n8;
        n5 = n28 < n6 ? n6 - n28 : 0;
        int[] nArray5 = new int[n5];
        int n29 = n28;
        n3 = 0;
        while (n3 < n5) {
            nArray5[n27] = nArray2[nArray[n29]];
            ++n27;
            ++n3;
            ++n29;
        }
        return new SliceVariable(variable.getModel(), nArray5, lArray3, lArray2);
    }

    public static Variable hrepeat(Variable variable, int n) {
        return Var.drepeat(variable, 1, n);
    }

    public static Variable vrepeat(Variable variable, int n) {
        return Var.drepeat(variable, 0, n);
    }

    public static Variable repeat(Variable variable, int n) {
        return Var.drepeat(variable, 0, n);
    }

    public static Variable repeat(Variable variable, int n, int n2) {
        return Var.drepeat(variable, n2, n);
    }

    private static Variable drepeat(Variable variable, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 < 0) {
            throw new LengthError("Cannot repeat less than 0 times");
        }
        if (n2 == 0) {
            int[] nArray;
            int[] nArray2 = nArray = variable.getShape();
            if (nArray.length == n) {
                nArray2 = new int[n + 1];
                int n6 = 0;
                int n7 = n;
                for (int i = n6; i < n7; ++i) {
                    nArray2[i] = nArray[i];
                }
            }
            nArray2[n] = 0;
            Debug.o().p("drepeat dim=").p(n).p(", n=").p(n2).p(", shape=").p(variable.getShape()).p(" -> ").p(nArray2).lf();
            return new NilVariable(nArray2);
        }
        if (n2 == 1) {
            int[] nArray;
            int[] nArray3 = nArray = variable.getShape();
            if (nArray.length == n) {
                nArray3 = new int[n + 1];
                int n8 = 0;
                int n9 = n;
                for (int i = n8; i < n9; ++i) {
                    nArray3[i] = nArray[i];
                }
                nArray3[n] = 1;
            }
            Debug.o().p("drepeat dim=").p(n).p(", n=").p(n2).p(", shape=").p(variable.getShape()).p(" -> ").p(nArray3).lf();
            return variable;
        }
        Model model = variable.getModel();
        int[] nArray = variable.getShape();
        int n10 = nArray.length;
        if (n < 0 || n > n10) {
            throw new DimensionError("Invalid stacking dimension");
        }
        long l = Set.size(nArray);
        int n11 = variable.numInst();
        int n12 = n11 * n2;
        int n13 = 1;
        int n14 = 0;
        int n15 = n;
        for (n5 = n14; n5 < n15; ++n5) {
            n13 *= nArray[n5];
        }
        n14 = n < n10 ? nArray[n] : 1;
        n15 = n14 * n2;
        n5 = 1;
        int n16 = n + 1;
        int n17 = n10;
        for (n4 = n16; n4 < n17; ++n4) {
            n5 *= nArray[n4];
        }
        n16 = n < n10 ? n10 : n + 1;
        int[] nArray4 = new int[n16];
        n4 = 0;
        int n18 = n10;
        for (n3 = n4; n3 < n18; ++n3) {
            nArray4[n3] = nArray[n3];
        }
        n4 = n10;
        n18 = n16;
        for (n3 = n4; n3 < n18; ++n3) {
            nArray4[n3] = 1;
        }
        nArray4[n] = n15;
        if ((long)n11 < l) {
            int n19;
            int n20;
            int n21;
            int n22;
            int n23;
            int n24;
            long[] lArray = new long[n11];
            long[] lArray2 = new long[n11];
            long[] lArray3 = new long[n12];
            long[] lArray4 = new long[n12];
            variable.inst(0, lArray2, 0, lArray);
            int n25 = n15 * n5;
            int n26 = n14 * n5;
            int n27 = n5;
            if (n == 0) {
                int n28 = 0;
                int n29 = 0;
                int n30 = n2;
                for (int i = n29; i < n30; ++i) {
                    int n31 = 0;
                    int n32 = n11;
                    for (int j = n31; j < n32; ++j) {
                        lArray4[n28] = lArray2[j] + (long)i * l;
                        lArray3[n28] = lArray[j];
                        ++n28;
                    }
                }
                return new SliceVariable(model, nArray4, lArray4, lArray3);
            }
            if (n >= n10) {
                int n33 = 0;
                int n34 = 0;
                int n35 = n11;
                for (int i = n34; i < n35; ++i) {
                    int n36 = 0;
                    int n37 = n2;
                    for (int j = n36; j < n37; ++j) {
                        lArray4[n33] = lArray2[i] * (long)n2 + (long)j;
                        lArray3[n33] = lArray[i];
                        ++n33;
                    }
                }
                return new SliceVariable(model, nArray4, lArray4, lArray3);
            }
            int n38 = 0;
            int n39 = 0;
            int n40 = n11;
            for (n24 = n39; n24 < n40; ++n24) {
                long l2 = lArray2[n24] / (long)n26;
                long l3 = lArray2[n24] / (long)n27 % (long)n14;
                long l4 = lArray2[n24] % (long)n5;
                int n41 = 0;
                n23 = n2;
                for (n22 = n41; n22 < n23; ++n22) {
                    lArray4[n38] = l2 * (long)n25 + (l3 + (long)(n14 * n22)) * (long)n5 + l4;
                    lArray3[n38] = lArray[n24];
                    ++n38;
                }
            }
            n39 = 1;
            n40 = 0;
            n24 = n16;
            for (int i = n40; i < n24; ++i) {
                if (n39 >= nArray4[i]) continue;
                n39 = nArray4[i];
            }
            int[] nArray5 = new int[n12];
            int[] nArray6 = new int[n12];
            int[] nArray7 = new int[n39 + 1];
            long[] lArray5 = new long[n16];
            lArray5[n16 - 1] = 1L;
            int n42 = 1;
            int n43 = n16;
            for (n21 = n42; n21 < n43; ++n21) {
                lArray5[n16 - n21 - 1] = lArray5[n16 - n21] * (long)nArray4[n16 - n21];
            }
            n42 = 0;
            n43 = n12;
            for (n21 = n42; n21 < n43; ++n21) {
                nArray5[n21] = n21;
            }
            n42 = 0;
            n43 = n16;
            for (n21 = n42; n21 < n43; ++n21) {
                n20 = n16 - n21 - 1;
                int n44 = 0;
                n23 = nArray4[n20] + 1;
                for (n22 = n44; n22 < n23; ++n22) {
                    nArray7[n22] = 0;
                }
                n44 = 0;
                n23 = n12;
                for (n22 = n44; n22 < n23; ++n22) {
                    int n45 = (int)(lArray4[n22] / lArray5[n20] % (long)nArray4[n20] + 1L);
                    nArray7[n45] = nArray7[n45] + 1;
                }
                n44 = 0;
                n23 = nArray4[n20];
                for (n22 = n44; n22 < n23; ++n22) {
                    int n46 = n22 + 1;
                    nArray7[n46] = nArray7[n46] + nArray7[n22];
                }
                n44 = 0;
                n23 = n12;
                for (n22 = n44; n22 < n23; ++n22) {
                    n19 = nArray5[n22];
                    long l5 = lArray4[n19] / lArray5[n20] % (long)nArray4[n20];
                    nArray6[nArray7[(int)l5]] = n19;
                    int n47 = (int)l5;
                    nArray7[n47] = nArray7[n47] + 1;
                }
                int[] nArray8 = nArray5;
                nArray5 = nArray6;
                nArray6 = nArray8;
            }
            int n48 = 0;
            int n49 = 0;
            n42 = n12;
            n43 = n49 < n42 ? n42 - n49 : 0;
            long[] lArray6 = new long[n43];
            n20 = n49;
            int n50 = 0;
            while (n50 < n43) {
                lArray6[n48] = lArray4[nArray5[n20]];
                ++n48;
                ++n50;
                ++n20;
            }
            n50 = 0;
            n23 = 0;
            n22 = n12;
            n19 = n23 < n22 ? n22 - n23 : 0;
            long[] lArray7 = new long[n19];
            int n51 = n23;
            int n52 = 0;
            while (n52 < n19) {
                lArray7[n50] = lArray3[nArray5[n51]];
                ++n50;
                ++n52;
                ++n51;
            }
            return new SliceVariable(model, nArray4, lArray6, lArray7);
        }
        long[] lArray = new long[n11];
        long[] lArray8 = new long[n11 * n2];
        variable.inst(0, lArray);
        n3 = n15 * n5;
        int n53 = n5;
        int n54 = 0;
        int n55 = 0;
        int n56 = n13;
        for (int i = n55; i < n56; ++i) {
            int n57 = 0;
            int n58 = n14;
            for (int j = n57; j < n58; ++j) {
                int n59 = 0;
                int n60 = n5;
                for (int k = n59; k < n60; ++k) {
                    int n61 = 0;
                    int n62 = n2;
                    for (int i2 = n61; i2 < n62; ++i2) {
                        lArray8[i * n3 + (j + i2 * n14) * n53 + k] = lArray[n54];
                    }
                    ++n54;
                }
            }
        }
        return new SliceVariable(model, nArray4, null, lArray8);
    }

    public static Variable stack(Variable[][] variableArray) {
        int n = 0;
        int n2 = 0;
        int n3 = variableArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        Variable[] variableArray2 = new Variable[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            variableArray2[n] = Var.dstack(variableArray[n5], 1);
            ++n;
            ++n6;
            ++n5;
        }
        return Var.dstack(variableArray2, 0);
    }

    public static Variable vstack(Variable variable, Variable variable2, Variable variable3) {
        return Var.dstack(new Variable[]{variable, variable2, variable3}, 0);
    }

    public static Variable vstack(Variable variable, Variable variable2) {
        return Var.dstack(new Variable[]{variable, variable2}, 0);
    }

    public static Variable vstack(Variable[] variableArray) {
        return Var.dstack(variableArray, 0);
    }

    public static Variable hstack(Variable variable, Variable variable2, Variable variable3) {
        return Var.dstack(new Variable[]{variable, variable2, variable3}, 1);
    }

    public static Variable hstack(Variable variable, Variable variable2) {
        return Var.dstack(new Variable[]{variable, variable2}, 1);
    }

    public static Variable hstack(Variable[] variableArray) {
        return Var.dstack(variableArray, 1);
    }

    public static Variable stack(Variable[] variableArray, int n) {
        return Var.stack(n, variableArray);
    }

    public static Variable stack(Variable variable, Variable variable2, Variable variable3, int n) {
        return Var.stack(n, new Variable[]{variable, variable2, variable3});
    }

    public static Variable stack(Variable variable, Variable variable2, int n) {
        return Var.stack(n, new Variable[]{variable, variable2});
    }

    public static Variable stack(int n, Variable[] variableArray) {
        int n2 = n;
        int n3 = 0;
        int n4 = variableArray.length;
        for (int i = n3; i < n4; ++i) {
            if (n2 >= variableArray[i].getND()) continue;
            n2 = variableArray[i].getND();
        }
        return Var.dstack(variableArray, n);
    }

    public static Variable stack(int n, Variable variable, Variable variable2, Variable variable3) {
        return Var.dstack(new Variable[]{variable, variable2, variable3}, n);
    }

    public static Variable stack(int n, Variable variable, Variable variable2) {
        return Var.dstack(new Variable[]{variable, variable2}, n);
    }

    public static Variable promote(Variable variable, int n) {
        if (n > variable.getND()) {
            int n2;
            int[] nArray = new int[n];
            int[] nArray2 = variable.getShape();
            int n3 = 0;
            int n4 = nArray2.length;
            for (n2 = n3; n2 < n4; ++n2) {
                nArray[n2] = nArray2[n2];
            }
            n3 = nArray2.length;
            n4 = n;
            for (n2 = n3; n2 < n4; ++n2) {
                nArray[n2] = 1;
            }
            return variable.reshape(nArray);
        }
        return variable;
    }

    protected static Variable dstack(Variable[] variableArray, int n) {
        long[] lArray;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        if (n < 0) {
            throw new DimensionError("Invalid stacking dimension");
        }
        Model model = null;
        int n18 = 0;
        int n19 = variableArray.length;
        for (n17 = n18; n17 < n19; ++n17) {
            if (model == null) {
                model = variableArray[n17].getModel();
                continue;
            }
            if (variableArray[n17].getModel() == null || variableArray[n17].getModel() == model) continue;
            StringBuffer stringBuffer = new StringBuffer();
            String string = model.getName().length() > 0 ? model.getName() : "?";
            String string2 = variableArray[n17].getModel().getName().length() > 0 ? variableArray[n17].getModel().getName() : "?";
            stringBuffer.a("Variables belong to different models: '").a(string).a("' and '").a(string2).a("'");
            throw new ModelError(stringBuffer.toString());
        }
        if (variableArray.length == 0) {
            return new NilVariable();
        }
        if (variableArray.length == 1) {
            return variableArray[0];
        }
        n18 = variableArray.length;
        n19 = 0;
        n17 = 0;
        int n20 = n18;
        int n21 = n17 < n20 ? n20 - n17 : 0;
        int[] nArray = new int[n21];
        int n22 = n17;
        int n23 = 0;
        while (n23 < n21) {
            nArray[n19] = variableArray[n22].numInst();
            ++n19;
            ++n23;
            ++n22;
        }
        int[] nArray2 = nArray;
        int n24 = 0;
        int n25 = 0;
        int n26 = n18;
        int n27 = n25 < n26 ? n26 - n25 : 0;
        int[][] nArrayArray = new int[n27][];
        int n28 = n25;
        int n29 = 0;
        while (n29 < n27) {
            nArrayArray[n24] = variableArray[n28].getShape();
            ++n24;
            ++n29;
            ++n28;
        }
        int[][] nArrayArray2 = nArrayArray;
        int n30 = 0;
        int n31 = 0;
        int n32 = n18;
        int n33 = n31 < n32 ? n32 - n31 : 0;
        int[] nArray3 = new int[n33];
        int n34 = n31;
        int n35 = 0;
        while (n35 < n33) {
            nArray3[n30] = nArrayArray2[n34].length;
            ++n30;
            ++n35;
            ++n34;
        }
        int[] nArray4 = nArray3;
        int[] nArray5 = nArrayArray2[0];
        int n36 = nArray4[0];
        int n37 = 0;
        int n38 = 0;
        int n39 = n18;
        for (n16 = n38; n16 < n39; ++n16) {
            n37 += nArray2[n16];
        }
        n38 = n + 1;
        n39 = 0;
        n16 = n18;
        for (n15 = n39; n15 < n16; ++n15) {
            if (n38 >= nArray4[n15]) continue;
            n38 = nArray4[n15];
        }
        int[] nArray6 = new int[n38];
        n16 = 0;
        n15 = n36;
        for (n14 = n16; n14 < n15; ++n14) {
            nArray6[n14] = nArray5[n14];
        }
        n16 = n36;
        n15 = n38;
        for (n14 = n16; n14 < n15; ++n14) {
            nArray6[n14] = 1;
        }
        nArray6[n] = 0;
        n16 = 0;
        n15 = n18;
        for (n14 = n16; n14 < n15; ++n14) {
            int n40 = n;
            nArray6[n40] = nArray6[n40] + (nArrayArray2[n14].length > n ? nArrayArray2[n14][n] : 1);
        }
        n16 = 0;
        n15 = n18;
        for (n14 = n16; n14 < n15; ++n14) {
            n13 = 0;
            n12 = nArrayArray2[n14].length;
            for (n11 = n13; n11 < n12; ++n11) {
                if (n11 == n || nArrayArray2[n14][n11] == nArray6[n11]) continue;
                throw new DimensionError("Variable dimensions do not match");
            }
            n13 = nArrayArray2[n14].length;
            n12 = n38;
            for (n11 = n13; n11 < n12; ++n11) {
                if (n11 == n || 1 == nArray6[n11]) continue;
                throw new DimensionError("Variable dimensions do not match");
            }
        }
        long[] lArray2 = new long[n37];
        long[] lArray3 = new long[n37];
        n14 = 0;
        n13 = 0;
        n12 = variableArray.length;
        n11 = n13 < n12 ? n12 - n13 : 0;
        int[] nArray7 = new int[n11];
        int n41 = n13;
        int n42 = 0;
        while (n42 < n11) {
            nArray7[n14] = n < nArrayArray2[n41].length ? nArrayArray2[n41][n] : 1;
            ++n14;
            ++n42;
            ++n41;
        }
        int[] nArray8 = nArray7;
        int n43 = 1;
        int n44 = 0;
        int n45 = n;
        for (n10 = n44; n10 < n45; ++n10) {
            n43 *= n10 < nArray5.length ? nArray5[n10] : 1;
        }
        n44 = 0;
        n45 = 0;
        n10 = n18;
        for (n9 = n45; n9 < n10; ++n9) {
            n44 += nArray8[n9];
        }
        n45 = 1;
        n10 = n + 1;
        n9 = nArray5.length;
        for (n8 = n10; n8 < n9; ++n8) {
            n45 *= nArray5[n8];
        }
        if (n43 == 1) {
            n10 = 0;
            long l = 0L;
            int n46 = 0;
            int n47 = n18;
            for (int i = n46; i < n47; ++i) {
                variableArray[i].inst(n10, lArray3, n10, lArray2);
                int n48 = 0;
                int n49 = nArray2[i];
                for (int j = n48; j < n49; ++j) {
                    int n50 = n10++;
                    lArray3[n50] = lArray3[n50] + l;
                }
                l += Set.size(nArrayArray2[i]);
            }
            return new SliceVariable(model, nArray6, (long[])(n37 < n43 * n44 * n45 ? lArray3 : null), lArray2);
        }
        n10 = 0;
        n9 = 0;
        n8 = n18;
        for (int i = n9; i < n8; ++i) {
            n10 += variableArray[i].inst(n10, lArray3, n10, lArray2);
        }
        int[] nArray9 = new int[n37];
        int[] nArray10 = new int[n37];
        int[] nArray11 = new int[n18];
        int n51 = 0;
        int n52 = n18 - 1;
        for (n7 = n51; n7 < n52; ++n7) {
            nArray11[n7 + 1] = nArray11[n7] + nArray8[n7];
        }
        n51 = 0;
        n52 = n37;
        for (n7 = n51; n7 < n52; ++n7) {
            nArray9[n7] = n7;
        }
        n51 = 0;
        n52 = 0;
        n7 = n18;
        for (n6 = n52; n6 < n7; ++n6) {
            n5 = 0;
            n4 = nArray2[n6];
            for (n3 = n5; n3 < n4; ++n3) {
                long l = lArray3[n51] / (long)(nArray8[n6] * n45);
                long l2 = lArray3[n51] / (long)n45 % (long)nArray8[n6];
                long l3 = lArray3[n51] % (long)n45;
                lArray3[n51] = (l * (long)n44 + l2 + (long)nArray11[n6]) * (long)n45 + l3;
                ++n51;
            }
        }
        n52 = 1;
        n7 = 0;
        n6 = n38;
        for (n5 = n7; n5 < n6; ++n5) {
            n52 = n52 < nArray6[n5] ? nArray6[n5] : n52;
        }
        long[] lArray4 = new long[n38];
        lArray4[n38 - 1] = 1L;
        n6 = 1;
        n5 = n38;
        for (n4 = n6; n4 < n5; ++n4) {
            lArray4[n38 - n4 - 1] = lArray4[n38 - n4] * (long)nArray6[n38 - n4];
        }
        int[] nArray12 = new int[n52 + 1];
        n5 = 0;
        n4 = n38;
        for (n3 = n5; n3 < n4; ++n3) {
            int n53 = n38 - n3 - 1;
            int n54 = 0;
            int n55 = nArray6[n53] + 1;
            for (n2 = n54; n2 < n55; ++n2) {
                nArray12[n2] = 0;
            }
            n54 = 0;
            n55 = n37;
            for (n2 = n54; n2 < n55; ++n2) {
                int n56 = (int)(lArray3[n2] / lArray4[n53] % (long)nArray6[n53] + 1L);
                nArray12[n56] = nArray12[n56] + 1;
            }
            n54 = 0;
            n55 = nArray6[n53];
            for (n2 = n54; n2 < n55; ++n2) {
                int n57 = n2 + 1;
                nArray12[n57] = nArray12[n57] + nArray12[n2];
            }
            n54 = 0;
            n55 = n37;
            for (n2 = n54; n2 < n55; ++n2) {
                int n58 = nArray9[n2];
                long l = lArray3[n58] / lArray4[n53] % (long)nArray6[n53];
                nArray10[nArray12[(int)l]] = n58;
                int n59 = (int)l;
                nArray12[n59] = nArray12[n59] + 1;
            }
            int[] nArray13 = nArray9;
            nArray9 = nArray10;
            nArray10 = nArray13;
        }
        if (n37 < n43 * n44 * n45) {
            n4 = 0;
            n3 = 0;
            int n60 = n37;
            int n61 = n3 < n60 ? n60 - n3 : 0;
            long[] lArray5 = new long[n61];
            n2 = n3;
            int n62 = 0;
            while (n62 < n61) {
                lArray5[n4] = lArray3[nArray9[n2]];
                ++n4;
                ++n62;
                ++n2;
            }
            lArray = lArray5;
        } else {
            lArray = null;
        }
        n4 = 0;
        n3 = 0;
        int n63 = n37;
        int n64 = n3 < n63 ? n63 - n3 : 0;
        long[] lArray6 = new long[n64];
        n2 = n3;
        int n65 = 0;
        while (n65 < n64) {
            lArray6[n4] = lArray2[nArray9[n2]];
            ++n4;
            ++n65;
            ++n2;
        }
        return new SliceVariable(model, nArray6, lArray, lArray6);
    }
}

