#
#  Copyright : Copyright (c) MOSEK ApS, Denmark. All rights reserved.
#
#  File :      opt_server_sync.R
#
#  Purpose : Demonstrates solving a problem remotely using the OptServer.
#
#            url should be 'http://server:port' or 'https://server:port'
#            cert is the path to a TLS certificate, if using https
#
library("Rmosek")

opt_server_sync <- function(filename, url, cert)
{
    # Read problem
    r <- mosek_read(filename, list(verbose=1, usesol=FALSE, useparam=TRUE))
    stopifnot(identical(r$response$code, 0))
    prob <- r$prob

    # Set remote OptServer parameters
    prob$sparam <- list(REMOTE_OPTSERVER_HOST = url,    # address of the server
    	                REMOTE_TLS_CERT_PATH = cert)    # certificate, only for HTTPS
    
    # Solve problem using the remote server
    r <- mosek(prob, list(verbose=10))
    stopifnot(identical(r$response$code, 0))
    sol <- r$sol

    # Print solution
    print(sol)
}

# Run only if called directly from the command-line
if( sys.nframe() == 0L )
{
    args <- commandArgs(trailingOnly=TRUE)
    if( !file.exists(args[1]) ) {
        stop("Expected problem file as input argument.")
    }

    opt_server_sync(args[1], args[2], args[3])
}


