/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.DimensionError;

public class RangeDomain {
    protected long domsize;
    protected long nelements;
    protected String[][] indexnames;
    protected boolean cardinal_flag;
    protected boolean scalable;
    protected double[] ub;
    protected double[] lb;
    protected int[][] sparsity;
    protected boolean empty;
    protected int[] shape;

    protected RangeDomain(boolean bl, double[] dArray, double[] dArray2, int[] nArray) {
        this(bl, dArray, dArray2, nArray, null, 1);
    }

    protected RangeDomain(boolean bl, double d, double d2, int[] nArray) {
        int n;
        this.cardinal_flag = false;
        this.shape = nArray;
        this.sparsity = null;
        this.scalable = bl;
        int n2 = 1;
        int n3 = 0;
        int n4 = nArray.length;
        for (n = n3; n < n4; ++n) {
            n2 *= nArray[n];
        }
        n3 = 0;
        n4 = 0;
        n = n2;
        int n5 = n4 < n ? n - n4 : 0;
        double[] dArray = new double[n5];
        int n6 = n4;
        int n7 = 0;
        while (n7 < n5) {
            dArray[n3] = d2;
            ++n3;
            ++n7;
            ++n6;
        }
        this.ub = dArray;
        n7 = 0;
        int n8 = 0;
        int n9 = n2;
        int n10 = n8 < n9 ? n9 - n8 : 0;
        double[] dArray2 = new double[n10];
        int n11 = n8;
        int n12 = 0;
        while (n12 < n10) {
            dArray2[n7] = d;
            ++n7;
            ++n12;
            ++n11;
        }
        this.lb = dArray2;
        this.empty = false;
        this.indexnames = null;
        this.domsize = 0L;
        this.nelements = 0L;
    }

    protected RangeDomain(boolean bl, double[] dArray, double[] dArray2, int[] nArray, int[][] nArray2) {
        this(bl, dArray, dArray2, nArray, nArray2, 1);
    }

    protected RangeDomain(boolean bl, double[] dArray, double[] dArray2, int[] nArray, int[][] nArray2, int n) {
        this.cardinal_flag = false;
        this.shape = nArray;
        this.sparsity = null;
        this.scalable = bl;
        this.ub = dArray2;
        this.lb = dArray;
        this.sparsity = nArray2;
        this.empty = false;
        this.indexnames = null;
        this.domsize = 0L;
        this.nelements = 0L;
    }

    protected RangeDomain(RangeDomain rangeDomain) {
        String[][] stringArrayArray;
        this.cardinal_flag = rangeDomain.cardinal_flag;
        this.sparsity = rangeDomain.sparsity;
        this.scalable = rangeDomain.scalable;
        this.shape = rangeDomain.shape;
        this.ub = rangeDomain.ub;
        this.lb = rangeDomain.lb;
        this.domsize = rangeDomain.domsize;
        this.nelements = rangeDomain.nelements;
        this.empty = rangeDomain.empty;
        if (rangeDomain.indexnames != null) {
            int n = 0;
            int n2 = 0;
            int n3 = rangeDomain.indexnames.length;
            int n4 = n2 < n3 ? n3 - n2 : 0;
            String[][] stringArrayArray2 = new String[n4][];
            int n5 = n2;
            int n6 = 0;
            while (n6 < n4) {
                stringArrayArray2[n] = rangeDomain.indexnames[n5];
                ++n;
                ++n6;
                ++n5;
            }
            stringArrayArray = stringArrayArray2;
        } else {
            stringArrayArray = null;
        }
        this.indexnames = stringArrayArray;
    }

    public RangeDomain sparse(int[][] nArray) {
        this.sparsity = new int[nArray.length][nArray[0].length];
        for (int i = 0; i < nArray.length && i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length && j < nArray[0].length; ++j) {
                this.sparsity[i][j] = nArray[i][j];
            }
        }
        return this;
    }

    public RangeDomain sparse(int[] nArray) {
        this.sparsity = new int[nArray.length][1];
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            this.sparsity[i][0] = nArray[i];
        }
        return this;
    }

    public RangeDomain sparse() {
        this.empty = true;
        this.sparsity = null;
        return this;
    }

    public RangeDomain integral() {
        this.cardinal_flag = true;
        return this;
    }

    public RangeDomain withShape(int n, int n2, int n3) {
        this.shape = new int[]{n, n2, n3};
        return this;
    }

    public RangeDomain withShape(int n, int n2) {
        this.shape = new int[]{n, n2};
        return this;
    }

    public RangeDomain withShape(int n) {
        this.shape = new int[]{n};
        return this;
    }

    public RangeDomain withShape(int[] nArray) {
        this.shape = nArray;
        return this;
    }

    public RangeDomain withNamesOnAxis(String[] stringArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String[][] stringArrayArray;
        int n7;
        int n8;
        int n9;
        int n10;
        if (this.indexnames == null) {
            n10 = 0;
            n9 = 0;
            n8 = n + 1;
            n7 = n9 < n8 ? n8 - n9 : 0;
            stringArrayArray = new String[n7][];
            n6 = n9;
            n5 = 0;
            while (n5 < n7) {
                stringArrayArray[n10] = null;
                ++n10;
                ++n5;
                ++n6;
            }
            this.indexnames = stringArrayArray;
            n5 = 0;
            n4 = 0;
            n3 = stringArray.length;
            n2 = n4 < n3 ? n3 - n4 : 0;
            String[] stringArray2 = new String[n2];
            int n11 = n4;
            int n12 = 0;
            while (n12 < n2) {
                stringArray2[n5] = stringArray[n11];
                ++n5;
                ++n12;
                ++n11;
            }
            this.indexnames[n] = stringArray2;
        }
        if (this.indexnames.length < n + 1) {
            n10 = 0;
            n9 = 0;
            n8 = n + 1;
            n7 = n9 < n8 ? n8 - n9 : 0;
            stringArrayArray = new String[n7][];
            n6 = n9;
            n5 = 0;
            while (n5 < n7) {
                stringArrayArray[n10] = null;
                ++n10;
                ++n5;
                ++n6;
            }
            String[][] stringArrayArray2 = stringArrayArray;
            n4 = 0;
            n3 = this.indexnames.length;
            for (n2 = n4; n2 < n3; ++n2) {
                stringArrayArray2[n2] = this.indexnames[n2];
            }
            this.indexnames = stringArrayArray2;
        }
        n10 = 0;
        n9 = 0;
        n8 = stringArray.length;
        n7 = n9 < n8 ? n8 - n9 : 0;
        stringArrayArray = new String[n7];
        n6 = n9;
        int n13 = 0;
        while (n13 < n7) {
            stringArrayArray[n10] = stringArray[n6];
            ++n10;
            ++n13;
            ++n6;
        }
        this.indexnames[n] = stringArrayArray;
        return this;
    }

    protected boolean match_shape(int[] nArray) {
        if (this.scalable) {
            return true;
        }
        if (this.shape.length != nArray.length) {
            return false;
        }
        int n = 0;
        int n2 = this.shape.length;
        for (int i = n; i < n2; ++i) {
            if (this.shape[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    private void finalize_and_validate_inplace(int[] nArray) {
        int n;
        int n2;
        int n3;
        this.domsize = 1L;
        if (this.scalable) {
            this.shape = nArray != null ? nArray : new int[0];
            n3 = 0;
            n2 = this.shape.length;
            for (n = n3; n < n2; ++n) {
                this.domsize *= (long)this.shape[n];
            }
        } else {
            if (nArray != null) {
                if (nArray.length != this.shape.length) {
                    throw new DimensionError("Conflicting shape definitions");
                }
                n3 = 0;
                n2 = nArray.length;
                for (n = n3; n < n2; ++n) {
                    if (nArray[n] == this.shape[n]) continue;
                    throw new DimensionError("Conflicting shape definitions");
                }
            }
            n3 = 0;
            n2 = this.shape.length;
            for (n = n3; n < n2; ++n) {
                this.domsize *= (long)this.shape[n];
            }
        }
        if (this.indexnames != null) {
            if (this.indexnames.length != this.shape.length) {
                throw new DimensionError("Index names do not match shape");
            }
            n3 = 0;
            n2 = this.shape.length;
            for (n = n3; n < n2; ++n) {
                if (this.indexnames[n] == null || this.indexnames[n].length == this.shape[n]) continue;
                throw new DimensionError("Index names do not match shape");
            }
        }
        if (this.sparsity != null) {
            this.nelements = this.sparsity.length;
            if (this.shape.length != this.sparsity[0].length) {
                throw new DimensionError("Mismatching shape and sparsity pattern");
            }
            n3 = 0;
            long l = this.nelements;
            for (long i = (long)n3; i < l; ++i) {
                int n4 = 0;
                int n5 = this.sparsity[0].length;
                for (int j = n4; j < n5; ++j) {
                    if (this.sparsity[(int)i][j] >= 0 && this.sparsity[(int)i][j] < this.shape[j]) continue;
                    throw new DimensionError("Sparsity pattern entry is out of bounds");
                }
            }
            if (!this.scalable && this.lb != null && (long)this.lb.length != this.nelements) {
                throw new DimensionError("Sparsity pattern does not match bound");
            }
            if (!this.scalable && this.ub != null && (long)this.ub.length != this.nelements) {
                throw new DimensionError("Sparsity pattern does not match bound");
            }
        } else {
            this.nelements = this.domsize;
            if (this.lb != null && !this.scalable && (long)this.lb.length != this.nelements) {
                throw new DimensionError("Domain bound does not match shape");
            }
            if (this.ub != null && !this.scalable && (long)this.ub.length != this.nelements) {
                throw new DimensionError("Domain bound does not match shape");
            }
        }
    }

    protected RangeDomain finalize_and_validate(int[] nArray) {
        RangeDomain rangeDomain = new RangeDomain(this);
        rangeDomain.finalize_and_validate_inplace(nArray);
        return rangeDomain;
    }
}

