/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.BaseExpression;
import mosek.fusion.DimensionError;
import mosek.fusion.Expression;
import mosek.fusion.LengthError;
import mosek.fusion.Matrix;
import mosek.fusion.UnexpectedError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;
import mosek.fusion.WorkStack;

public final class ExprCrossDot
extends BaseExpression {
    private Expression expr;
    private double[] mval;
    private int[] msubj;
    private int[] msubi;
    private int mdim1;
    private int mdim0;

    public ExprCrossDot(Matrix matrix, Expression expression) {
        super(expression.getModel(), ExprCrossDot.computeshape(matrix.numRows(), matrix.numColumns(), expression.getShape()));
        long l = matrix.numNonzeros();
        this.mdim0 = matrix.numRows();
        this.mdim1 = matrix.numColumns();
        if (matrix.isSparse()) {
            this.msubi = new int[(int)l];
            this.msubj = new int[(int)l];
            this.mval = new double[(int)l];
            matrix.getDataAsTriplets(this.msubi, this.msubj, this.mval);
        } else {
            this.mval = matrix.getDataAsArray();
            this.msubi = null;
            this.msubj = null;
        }
        ExprCrossDot.validate(this.mdim0, this.mdim1, this.msubi, this.msubj, this.mval, expression);
        this.expr = expression;
    }

    protected ExprCrossDot(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Expression expression, int n3) {
        super(expression.getModel(), ExprCrossDot.computeshape(n, n2, expression.getShape()));
        this.mdim0 = n;
        this.mdim1 = n2;
        this.msubi = nArray;
        this.msubj = nArray2;
        this.mval = dArray;
        this.expr = expression;
    }

    public ExprCrossDot(int n, int n2, double[] dArray, Expression expression) {
        this(n, n2, null, null, dArray, expression, ExprCrossDot.validate(n, n2, null, null, dArray, expression));
    }

    public ExprCrossDot(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Expression expression) {
        this(n, n2, nArray, nArray2, dArray, expression, 1);
    }

    @Override
    public void eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        this.expr.recursive_eval(workStack2, workStack, workStack3, bl);
        workStack2.pop_expr();
        int n12 = workStack2.nd;
        int n13 = workStack2.nnz;
        int n14 = workStack2.nelem;
        int n15 = workStack2.ncodeatom;
        boolean bl2 = workStack2.hassp;
        int n16 = workStack2.shape_base;
        int n17 = workStack2.ptr_base;
        int n18 = workStack2.sp_base;
        int n19 = workStack2.nidxs_base;
        int n20 = workStack2.cof_base;
        int n21 = workStack2.codeptr_base;
        int n22 = workStack2.code_base;
        int n23 = workStack2.cconst_base;
        int[] nArray = workStack2.i32;
        long[] lArray = workStack2.i64;
        double[] dArray = workStack2.f64;
        int n24 = 0;
        int n25 = 0;
        boolean bl3 = false;
        int n26 = 0;
        int n27 = nArray[n16 + 0];
        int n28 = nArray[n16 + 1];
        int n29 = this.mval.length;
        if (this.msubi == null || this.msubj == null) {
            if (!bl2) {
                n24 = n13 * this.mdim0;
                n25 = this.mdim0 * n27;
                n26 = n15 > 0 ? (n15 + n13 * 2) * this.mdim0 : 0;
            } else {
                n24 = n13 * this.mdim0;
                n26 = n15 > 0 ? (n15 + n13 * 2) * this.mdim0 : 0;
                n11 = -1;
                var29_29 = 0;
                while (var29_29 < n14 && var29_29 < n14) {
                    long l = lArray[n18 + var29_29] / (long)n28;
                    ++var29_29;
                    while (var29_29 < n14 && lArray[n18 + var29_29] / (long)n28 == l) {
                        ++var29_29;
                    }
                    ++n25;
                }
                n25 *= this.mdim0;
            }
        } else if (!bl2) {
            n11 = 0;
            while (n11 < n29 && n11 < n29) {
                ++n25;
                var29_29 = n11;
                int n30 = this.msubi[n11];
                ++n11;
                while (n11 < n29 && this.msubi[n11] == n30) {
                    ++n11;
                }
                var31_35 = n11;
                n10 = 0;
                n9 = n27;
                for (int i = n10; i < n9; ++i) {
                    n8 = var29_29;
                    n7 = var31_35;
                    for (n6 = n8; n6 < n7; ++n6) {
                        n5 = this.msubj[n6];
                        n4 = nArray[n17 + i * n28 + n5 + 1];
                        n3 = nArray[n17 + i * n28 + n5];
                        n2 = n4 - n3;
                        n24 += n2;
                        n26 += n15 > 0 ? nArray[n21 + n4] - nArray[n21 + n3] + n2 * 2 : 0;
                    }
                }
            }
            n25 *= n27;
        } else {
            n11 = 0;
            while (n11 < n29 && n11 < n29) {
                var29_29 = n11;
                int n31 = this.msubi[n11];
                ++n11;
                while (n11 < n29 && this.msubi[n11] == n31) {
                    ++n11;
                }
                var31_35 = n11;
                n10 = 0;
                while (n10 < n14 && n10 < n14) {
                    n9 = n10;
                    long l = lArray[n18 + n10] / (long)n28;
                    ++n10;
                    while (n10 < n14 && lArray[n18 + n10] / (long)n28 == l) {
                        ++n10;
                    }
                    n7 = n10;
                    n6 = 0;
                    n5 = n9;
                    n4 = var29_29;
                    while (n4 < var31_35 && n5 < n7) {
                        if ((long)this.msubj[n4] < lArray[n18 + n5] % (long)n28) {
                            ++n4;
                            continue;
                        }
                        if ((long)this.msubj[n4] > lArray[n18 + n5] % (long)n28) {
                            ++n5;
                            continue;
                        }
                        ++n6;
                        n3 = nArray[n17 + n5];
                        n2 = nArray[n17 + n5 + 1];
                        n = n2 - n3;
                        n24 += n;
                        n26 += n15 > 0 ? nArray[n21 + n2] - nArray[n21 + n3] + n * 2 : 0;
                        ++n4;
                        ++n5;
                    }
                    if (n6 <= 0) continue;
                    ++n25;
                }
            }
        }
        n11 = n25 < n27 * this.mdim0 ? 1 : 0;
        workStack.alloc_expr(2, n25, n24, n11 != 0, n26);
        int[] nArray2 = workStack.i32;
        long[] lArray2 = workStack.i64;
        double[] dArray2 = workStack.f64;
        n10 = workStack.ncodeatom;
        n9 = workStack.shape_base;
        int n32 = workStack.ptr_base;
        n8 = n11 != 0 ? workStack.sp_base : -9999;
        n7 = workStack.nidxs_base;
        n6 = workStack.cof_base;
        n5 = workStack.codeptr_base;
        n4 = workStack.code_base;
        n3 = workStack.cconst_base;
        nArray2[n9] = this.mdim0;
        nArray2[n9 + 1] = n27;
        nArray2[n32] = 0;
        if (n10 > 0) {
            nArray2[n5] = 0;
        }
        if (this.msubi == null || this.msubj == null) {
            if (!bl2) {
                int n33;
                int n34;
                int n35;
                int n36;
                int n37;
                int n38;
                int n39;
                int n40;
                int n41;
                int n42;
                int n43;
                n2 = 0;
                n = 0;
                int n44 = 0;
                int n45 = this.mdim0;
                for (n43 = n44; n43 < n45; ++n43) {
                    Tools.arraycopy(lArray, n19, lArray2, n7 + n2, n13);
                    n42 = 0;
                    n41 = 0;
                    n40 = n27;
                    for (n39 = n41; n39 < n40; ++n39) {
                        n38 = 0;
                        n37 = this.mdim1;
                        for (n36 = n38; n36 < n37; ++n36) {
                            n35 = nArray[n17 + n42];
                            n34 = nArray[n17 + n42 + 1];
                            for (n33 = n35; n33 < n34; ++n33) {
                                dArray2[n6 + n2] = this.mval[n43 * this.mdim1 + n36] * dArray[n20 + n33];
                                ++n2;
                            }
                            ++n42;
                        }
                        nArray2[n32 + n + 1] = n2;
                        ++n;
                    }
                }
                if (n10 > 0) {
                    n2 = 0;
                    n = 0;
                    n44 = 0;
                    n45 = this.mdim0;
                    for (n43 = n44; n43 < n45; ++n43) {
                        n42 = 0;
                        n41 = 0;
                        n40 = n27;
                        for (n39 = n41; n39 < n40; ++n39) {
                            n38 = 0;
                            n37 = this.mdim1;
                            for (n36 = n38; n36 < n37; ++n36) {
                                n35 = nArray[n17 + n42];
                                n34 = nArray[n17 + n42 + 1];
                                for (n33 = n35; n33 < n34; ++n33) {
                                    int n46 = nArray[n21 + n33];
                                    int n47 = nArray[n21 + n33 + 1];
                                    for (int i = n46; i < n47; ++i) {
                                        nArray2[n4 + n] = nArray[n22 + i];
                                        dArray2[n3 + n] = dArray[n23 + i];
                                        ++n;
                                    }
                                    nArray2[n4 + n] = 2;
                                    dArray2[n3 + n] = this.mval[n43 * this.mdim1 + n36];
                                    nArray2[n4 + ++n] = 5;
                                    nArray2[n5 + n2 + 1] = ++n;
                                    ++n2;
                                }
                                ++n42;
                            }
                        }
                    }
                }
            } else {
                int n48;
                int n49;
                int n50;
                long l;
                int n51;
                int n52;
                int n53;
                int n54;
                int n55;
                long l2;
                int n56;
                boolean bl4;
                int n57;
                n2 = 0;
                n = 0;
                int n58 = 0;
                int n59 = this.mdim0;
                for (n57 = n58; n57 < n59; ++n57) {
                    Tools.arraycopy(lArray, n19, lArray2, n7 + n2, n13);
                    bl4 = false;
                    n56 = 0;
                    while (n56 < n14 && n56 < n14) {
                        l2 = lArray[n18 + n56] / (long)n28;
                        n55 = n56++;
                        while (n56 < n14 && lArray[n18 + n56] / (long)n28 == l2) {
                            ++n56;
                        }
                        n54 = n56;
                        n53 = n55;
                        n52 = n54;
                        for (n51 = n53; n51 < n52; ++n51) {
                            l = lArray[n18 + n51] % (long)n28;
                            n50 = nArray[n17 + n51];
                            n49 = nArray[n17 + n51 + 1];
                            for (n48 = n50; n48 < n49; ++n48) {
                                dArray2[n6 + n2] = this.mval[(int)((long)(n57 * this.mdim1) + l)] * dArray[n20 + n48];
                                ++n2;
                            }
                        }
                        if (n11 != 0) {
                            lArray2[n8 + n] = (long)(n57 * n27) + l2;
                        }
                        nArray2[n32 + ++n] = n2;
                    }
                }
                if (n10 > 0) {
                    n2 = 0;
                    n = 0;
                    n58 = 0;
                    n59 = this.mdim0;
                    for (n57 = n58; n57 < n59; ++n57) {
                        bl4 = false;
                        n56 = 0;
                        while (n56 < n14 && n56 < n14) {
                            l2 = lArray[n18 + n56] / (long)n28;
                            n55 = n56++;
                            while (n56 < n14 && lArray[n18 + n56] / (long)n28 == l2) {
                                ++n56;
                            }
                            n54 = n56;
                            n53 = n55;
                            n52 = n54;
                            for (n51 = n53; n51 < n52; ++n51) {
                                l = lArray[n18 + n51] % (long)n28;
                                n50 = nArray[n17 + n51];
                                n49 = nArray[n17 + n51 + 1];
                                for (n48 = n50; n48 < n49; ++n48) {
                                    int n60 = nArray[n21 + n48];
                                    int n61 = nArray[n21 + n48 + 1];
                                    for (int i = n60; i < n61; ++i) {
                                        nArray2[n4 + n] = nArray[n22 + i];
                                        dArray2[n3 + n] = dArray[n23 + i];
                                        ++n;
                                    }
                                    nArray2[n4 + n] = 2;
                                    dArray2[n3 + n] = this.mval[(int)((long)(n57 * n27) + l)];
                                    nArray2[n4 + ++n] = 5;
                                    nArray2[n5 + n2 + 1] = ++n;
                                    ++n2;
                                }
                            }
                        }
                    }
                }
            }
        } else if (!bl2) {
            n2 = 0;
            n = 0;
            int n62 = 0;
            int n63 = 0;
            while (n63 < n29 && n63 < n29) {
                int n64 = n63;
                int n65 = this.msubi[n63];
                ++n63;
                while (n63 < n29 && this.msubi[n63] == n65) {
                    ++n63;
                }
                int n66 = n63;
                int n67 = 0;
                int n68 = n27;
                for (int i = n67; i < n68; ++i) {
                    int n69 = n64;
                    int n70 = n66;
                    for (int j = n69; j < n70; ++j) {
                        int n71 = i * n28 + this.msubj[j];
                        int n72 = nArray[n17 + n71];
                        int n73 = nArray[n17 + n71 + 1];
                        for (int k = n72; k < n73; ++k) {
                            lArray2[n7 + n2] = lArray[n19 + k];
                            dArray2[n6 + n2] = dArray[n20 + k] * this.mval[j];
                            if (n10 > 0) {
                                int n74 = nArray[n21 + k];
                                int n75 = nArray[n21 + k + 1];
                                for (int i2 = n74; i2 < n75; ++i2) {
                                    nArray2[n4 + n62] = nArray[n22 + i2];
                                    dArray2[n3 + n62] = dArray[n23 + i2];
                                    ++n62;
                                }
                                nArray2[n4 + n62] = 2;
                                dArray2[n3 + n62] = this.mval[j];
                                nArray2[n4 + ++n62] = 5;
                                nArray2[n5 + n2 + 1] = ++n62;
                            }
                            ++n2;
                        }
                    }
                    nArray2[n32 + n + 1] = n2;
                    if (n11 != 0) {
                        lArray2[n8 + n] = n65 * n27 + i;
                    }
                    ++n;
                }
            }
            if (n2 != n24) {
                throw new UnexpectedError("Error in evaluation: Incorrect number of nonzeros");
            }
            if (n != n25) {
                throw new UnexpectedError("Error in evaluation: Incorrect number of elements");
            }
            if (n62 != n10) {
                throw new UnexpectedError("Error in evaluation: Incorrect number of code elements");
            }
        } else {
            int n76;
            int n77;
            int n78;
            int n79;
            int n80;
            int n81;
            int n82;
            long l;
            int n83;
            int n84;
            int n85;
            int n86;
            int n87;
            n2 = 0;
            n = 0;
            int n88 = 0;
            while (n88 < n29 && n88 < n29) {
                n87 = n88;
                n86 = this.msubi[n88];
                ++n88;
                while (n88 < n29 && this.msubi[n88] == n86) {
                    ++n88;
                }
                n85 = n88;
                n84 = 0;
                while (n84 < n14 && n84 < n14) {
                    n83 = n84;
                    l = lArray[n18 + n84] / (long)n28;
                    ++n84;
                    while (n84 < n14 && lArray[n18 + n84] / (long)n28 == l) {
                        ++n84;
                    }
                    n82 = n84;
                    n81 = 0;
                    n80 = n83;
                    n79 = n87;
                    while (n79 < n85 && n80 < n82) {
                        if ((long)this.msubj[n79] < lArray[n18 + n80] % (long)n28) {
                            ++n79;
                            continue;
                        }
                        if ((long)this.msubj[n79] > lArray[n18 + n80] % (long)n28) {
                            ++n80;
                            continue;
                        }
                        ++n81;
                        n78 = nArray[n17 + n80];
                        n77 = nArray[n17 + n80 + 1];
                        for (n76 = n78; n76 < n77; ++n76) {
                            lArray2[n7 + n2] = lArray[n19 + n76];
                            dArray2[n6 + n2] = dArray[n20 + n76] * this.mval[n79];
                            ++n2;
                        }
                        ++n79;
                        ++n80;
                    }
                    if (n81 <= 0) continue;
                    nArray2[n32 + n + 1] = n2;
                    if (n11 != 0) {
                        lArray2[n8 + n] = (long)(n86 * n27) + l;
                    }
                    ++n;
                }
            }
            if (n2 != n24) {
                throw new UnexpectedError("Error in evaluation: Incorrect number of nonzeros");
            }
            if (n != n25) {
                throw new UnexpectedError("Error in evaluation: Incorrect number of elements");
            }
            if (n10 > 0) {
                n2 = 0;
                n = 0;
                n88 = 0;
                while (n88 < n29 && n88 < n29) {
                    n87 = n88;
                    n86 = this.msubi[n88];
                    ++n88;
                    while (n88 < n29 && this.msubi[n88] == n86) {
                        ++n88;
                    }
                    n85 = n88;
                    n84 = 0;
                    while (n84 < n14 && n84 < n14) {
                        n83 = n84;
                        l = lArray[n18 + n84] / (long)n28;
                        ++n84;
                        while (n84 < n14 && lArray[n18 + n84] / (long)n28 == l) {
                            ++n84;
                        }
                        n82 = n84;
                        n81 = 0;
                        n80 = n83;
                        n79 = n87;
                        while (n79 < n85 && n80 < n82) {
                            if ((long)this.msubj[n79] < lArray[n18 + n80] % (long)n28) {
                                ++n79;
                                continue;
                            }
                            if ((long)this.msubj[n79] > lArray[n18 + n80] % (long)n28) {
                                ++n80;
                                continue;
                            }
                            ++n81;
                            n78 = nArray[n17 + n80];
                            n77 = nArray[n17 + n80 + 1];
                            for (n76 = n78; n76 < n77; ++n76) {
                                int n89 = nArray[n21 + n76];
                                int n90 = nArray[n21 + n76 + 1];
                                for (int i = n89; i < n90; ++i) {
                                    nArray2[n4 + n] = nArray[n22 + i];
                                    dArray2[n3 + n] = dArray[n23 + i];
                                    ++n;
                                }
                                nArray2[n4 + n] = 2;
                                dArray2[n3 + n] = this.mval[n79];
                                nArray2[n4 + ++n] = 5;
                                nArray2[n5 + n2 + 1] = ++n;
                                ++n2;
                            }
                            ++n79;
                            ++n80;
                        }
                    }
                }
                if (n != n10) {
                    throw new UnexpectedError("Error in evaluation: Incorrect number of code elements");
                }
            }
        }
    }

    private static int[] computeshape(int n, int n2, int[] nArray) {
        if (nArray.length != 2) {
            throw new DimensionError("Mismatching dimensions");
        }
        if (n2 != nArray[1]) {
            throw new DimensionError("Mismatching dimensions");
        }
        return new int[]{n, nArray[0]};
    }

    private static int validate(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Expression expression) {
        if (expression.getND() != 2) {
            throw new DimensionError("Invalid operand dimensions");
        }
        int n3 = expression.getDim(0);
        int n4 = expression.getDim(1);
        if (n < 0 || n2 < 0) {
            throw new DimensionError("Invalid operand dimensions");
        }
        if (n2 != n4) {
            throw new DimensionError("Mismatching operand dimensions");
        }
        if (nArray != null && nArray2 != null ? nArray.length != nArray2.length || nArray.length != dArray.length : dArray.length != n * n2) {
            throw new LengthError("Invalid matrix data");
        }
        int n5 = dArray.length;
        boolean bl = false;
        boolean bl2 = false;
        if (nArray != null && nArray2 != null) {
            int n6;
            int n7 = 0;
            int n8 = n5;
            for (n6 = n7; n6 < n8; ++n6) {
                bl = bl || nArray[n6] < 0 || nArray[n6] >= n || nArray2[n6] < 0 || nArray2[n6] >= n2;
            }
            if (!bl) {
                n7 = 0;
                n8 = n5 - 1;
                for (n6 = n7; n6 < n8; ++n6) {
                    bl2 = bl2 || nArray[n6] > nArray[n6 + 1] || nArray[n6] == nArray[n6 + 1] && nArray2[n6] >= nArray2[n6 + 1];
                }
            }
        }
        if (bl) {
            throw new LengthError("Invalid matrix data");
        }
        if (bl2) {
            throw new LengthError("Unsorted matrix data");
        }
        return 1;
    }

    @Override
    public String toString() {
        return new StringBuffer().a("ExprCrossDot(M(").a(this.mdim0).a(",").a(this.mdim1).a("),").a(this.expr.toString()).a(")").toString();
    }
}

