#ifndef __FUSION_P_H__
#define __FUSION_P_H__
#include "monty.h"
#include "mosektask_p.h"
#include "list"
#include "vector"
#include "unordered_map"
#include "fusion.h"
namespace mosek
{
  namespace fusion
  {
    struct p_Disjunction
    {
      Disjunction * _pubthis;
      static mosek::fusion::p_Disjunction* _get_impl(mosek::fusion::Disjunction * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_Disjunction * _get_impl(mosek::fusion::Disjunction::t _inst) { return _get_impl(_inst.get()); }
      p_Disjunction(Disjunction * _pubthis);
      virtual ~p_Disjunction() { /* std::cout << "~p_Disjunction" << std::endl;*/ };
      int64_t id{};

      virtual void destroy();

      static Disjunction::t _new_Disjunction(int64_t _7_id);
      void _initialize(int64_t _7_id);
    }; // struct Disjunction;

    struct p_DisjunctionTerms
    {
      DisjunctionTerms * _pubthis;
      static mosek::fusion::p_DisjunctionTerms* _get_impl(mosek::fusion::DisjunctionTerms * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_DisjunctionTerms * _get_impl(mosek::fusion::DisjunctionTerms::t _inst) { return _get_impl(_inst.get()); }
      p_DisjunctionTerms(DisjunctionTerms * _pubthis);
      virtual ~p_DisjunctionTerms() { /* std::cout << "~p_DisjunctionTerms" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Term >,1 > > terms{};

      virtual void destroy();

      static DisjunctionTerms::t _new_DisjunctionTerms(monty::rc_ptr< ::mosek::fusion::DisjunctionTerms > _8_terms1,monty::rc_ptr< ::mosek::fusion::ExprRangeDomain > _9_term);
      void _initialize(monty::rc_ptr< ::mosek::fusion::DisjunctionTerms > _8_terms1,monty::rc_ptr< ::mosek::fusion::ExprRangeDomain > _9_term);
      static DisjunctionTerms::t _new_DisjunctionTerms(monty::rc_ptr< ::mosek::fusion::DisjunctionTerms > _10_terms1,monty::rc_ptr< ::mosek::fusion::ExprLinearDomain > _11_term);
      void _initialize(monty::rc_ptr< ::mosek::fusion::DisjunctionTerms > _10_terms1,monty::rc_ptr< ::mosek::fusion::ExprLinearDomain > _11_term);
      static DisjunctionTerms::t _new_DisjunctionTerms(monty::rc_ptr< ::mosek::fusion::DisjunctionTerms > _12_terms1,monty::rc_ptr< ::mosek::fusion::DisjunctionTerms > _13_term2);
      void _initialize(monty::rc_ptr< ::mosek::fusion::DisjunctionTerms > _12_terms1,monty::rc_ptr< ::mosek::fusion::DisjunctionTerms > _13_term2);
      static DisjunctionTerms::t _new_DisjunctionTerms(monty::rc_ptr< ::mosek::fusion::DisjunctionTerms > _14_term1,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Term >,1 > > _15_term2);
      void _initialize(monty::rc_ptr< ::mosek::fusion::DisjunctionTerms > _14_term1,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Term >,1 > > _15_term2);
      static DisjunctionTerms::t _new_DisjunctionTerms(monty::rc_ptr< ::mosek::fusion::DisjunctionTerms > _19_term1,monty::rc_ptr< ::mosek::fusion::Term > _20_term2);
      void _initialize(monty::rc_ptr< ::mosek::fusion::DisjunctionTerms > _19_term1,monty::rc_ptr< ::mosek::fusion::Term > _20_term2);
      static DisjunctionTerms::t _new_DisjunctionTerms(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Term >,1 > > _22_terms);
      void _initialize(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Term >,1 > > _22_terms);
      static DisjunctionTerms::t _new_DisjunctionTerms(monty::rc_ptr< ::mosek::fusion::ExprRangeDomain > _24_term);
      void _initialize(monty::rc_ptr< ::mosek::fusion::ExprRangeDomain > _24_term);
      static DisjunctionTerms::t _new_DisjunctionTerms(monty::rc_ptr< ::mosek::fusion::ExprLinearDomain > _25_term);
      void _initialize(monty::rc_ptr< ::mosek::fusion::ExprLinearDomain > _25_term);
    }; // struct DisjunctionTerms;

    struct p_Term : public /*implements*/ virtual ::mosek::fusion::ExprDomain
    {
      Term * _pubthis;
      static mosek::fusion::p_Term* _get_impl(mosek::fusion::Term * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_Term * _get_impl(mosek::fusion::Term::t _inst) { return _get_impl(_inst.get()); }
      p_Term(Term * _pubthis);
      virtual ~p_Term() { /* std::cout << "~p_Term" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::DJCDomain >,1 > > domains{};
      std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > exprs{};

      virtual void destroy();

      static Term::t _new_Term(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _26_elist,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::DJCDomain >,1 > > _27_dlist);
      void _initialize(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _26_elist,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::DJCDomain >,1 > > _27_dlist);
      static Term::t _new_Term(monty::rc_ptr< ::mosek::fusion::Expression > _30_e,monty::rc_ptr< ::mosek::fusion::DJCDomain > _31_d);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _30_e,monty::rc_ptr< ::mosek::fusion::DJCDomain > _31_d);
      static Term::t _new_Term(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::SimpleTerm >,1 > > _32_t);
      void _initialize(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::SimpleTerm >,1 > > _32_t);
      virtual int32_t numaccterms() ;
      virtual int32_t numaccrows() ;
      virtual int32_t num() ;
      virtual int32_t size() ;
      virtual monty::rc_ptr< ::mosek::fusion::Term > __mosek_2fusion_2Term__toDJCTerm() ;
      virtual monty::rc_ptr< ::mosek::fusion::Term > __mosek_2fusion_2ExprDomain__toDJCTerm() { return __mosek_2fusion_2Term__toDJCTerm(); }
    }; // struct Term;

    struct p_SimpleTerm : public ::mosek::fusion::p_Term
    {
      SimpleTerm * _pubthis;
      static mosek::fusion::p_SimpleTerm* _get_impl(mosek::fusion::SimpleTerm * _inst){ return static_cast< mosek::fusion::p_SimpleTerm* >(mosek::fusion::p_Term::_get_impl(_inst)); }
      static mosek::fusion::p_SimpleTerm * _get_impl(mosek::fusion::SimpleTerm::t _inst) { return _get_impl(_inst.get()); }
      p_SimpleTerm(SimpleTerm * _pubthis);
      virtual ~p_SimpleTerm() { /* std::cout << "~p_SimpleTerm" << std::endl;*/ };

      virtual void destroy();

      static SimpleTerm::t _new_SimpleTerm(monty::rc_ptr< ::mosek::fusion::Expression > _41_e,monty::rc_ptr< ::mosek::fusion::DJCDomain > _42_d);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _41_e,monty::rc_ptr< ::mosek::fusion::DJCDomain > _42_d);
    }; // struct SimpleTerm;

    struct p_DJCDomain
    {
      DJCDomain * _pubthis;
      static mosek::fusion::p_DJCDomain* _get_impl(mosek::fusion::DJCDomain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_DJCDomain * _get_impl(mosek::fusion::DJCDomain::t _inst) { return _get_impl(_inst.get()); }
      p_DJCDomain(DJCDomain * _pubthis);
      virtual ~p_DJCDomain() { /* std::cout << "~p_DJCDomain" << std::endl;*/ };
      mosek::fusion::DJCDomainType dom{};
      int32_t conedim{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};
      std::shared_ptr< monty::ndarray< double,1 > > par{};
      std::shared_ptr< monty::ndarray< double,1 > > b{};

      virtual void destroy();

      static DJCDomain::t _new_DJCDomain(std::shared_ptr< monty::ndarray< double,1 > > _43_b_,std::shared_ptr< monty::ndarray< double,1 > > _44_par_,std::shared_ptr< monty::ndarray< int32_t,1 > > _45_shape_,mosek::fusion::DJCDomainType _46_dom_);
      void _initialize(std::shared_ptr< monty::ndarray< double,1 > > _43_b_,std::shared_ptr< monty::ndarray< double,1 > > _44_par_,std::shared_ptr< monty::ndarray< int32_t,1 > > _45_shape_,mosek::fusion::DJCDomainType _46_dom_);
      static DJCDomain::t _new_DJCDomain(std::shared_ptr< monty::ndarray< double,1 > > _47_b_,std::shared_ptr< monty::ndarray< double,1 > > _48_par_,std::shared_ptr< monty::ndarray< int32_t,1 > > _49_shape_,int32_t _50_conedim_,mosek::fusion::DJCDomainType _51_dom_);
      void _initialize(std::shared_ptr< monty::ndarray< double,1 > > _47_b_,std::shared_ptr< monty::ndarray< double,1 > > _48_par_,std::shared_ptr< monty::ndarray< int32_t,1 > > _49_shape_,int32_t _50_conedim_,mosek::fusion::DJCDomainType _51_dom_);
      virtual int32_t numaccterms() ;
      virtual int32_t numaccrows() ;
      virtual int32_t size() ;
    }; // struct DJCDomain;

    struct p_DJC
    {
      DJC * _pubthis;
      static mosek::fusion::p_DJC* _get_impl(mosek::fusion::DJC * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_DJC * _get_impl(mosek::fusion::DJC::t _inst) { return _get_impl(_inst.get()); }
      p_DJC(DJC * _pubthis);
      virtual ~p_DJC() { /* std::cout << "~p_DJC" << std::endl;*/ };

      virtual void destroy();

      static  monty::rc_ptr< ::mosek::fusion::Term > ANDFromTerms(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Term >,1 > > _54_tlist);
      static  monty::rc_ptr< ::mosek::fusion::Term > AND(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::ExprDomain >,1 > > _61_elist);
      static  monty::rc_ptr< ::mosek::fusion::Term > AND(monty::rc_ptr< ::mosek::fusion::SimpleTerm > _63_s1,monty::rc_ptr< ::mosek::fusion::SimpleTerm > _64_s2,monty::rc_ptr< ::mosek::fusion::SimpleTerm > _65_s3);
      static  monty::rc_ptr< ::mosek::fusion::Term > AND(monty::rc_ptr< ::mosek::fusion::SimpleTerm > _66_s1,monty::rc_ptr< ::mosek::fusion::SimpleTerm > _67_s2);
      static  monty::rc_ptr< ::mosek::fusion::Term > AND(monty::rc_ptr< ::mosek::fusion::SimpleTerm > _68_s1);
      static  monty::rc_ptr< ::mosek::fusion::Term > AND(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::SimpleTerm >,1 > > _69_slist);
      static  monty::rc_ptr< ::mosek::fusion::SimpleTerm > term(monty::rc_ptr< ::mosek::fusion::Expression > _70_expr,monty::rc_ptr< ::mosek::fusion::RangeDomain > _71_dom);
      static  monty::rc_ptr< ::mosek::fusion::SimpleTerm > term(monty::rc_ptr< ::mosek::fusion::Variable > _82_x,monty::rc_ptr< ::mosek::fusion::RangeDomain > _83_dom);
      static  monty::rc_ptr< ::mosek::fusion::SimpleTerm > term(monty::rc_ptr< ::mosek::fusion::ExprRangeDomain > _84_exprdom);
      static  monty::rc_ptr< ::mosek::fusion::SimpleTerm > term(monty::rc_ptr< ::mosek::fusion::Expression > _85_expr,monty::rc_ptr< ::mosek::fusion::LinearDomain > _86_dom);
      static  monty::rc_ptr< ::mosek::fusion::SimpleTerm > term(monty::rc_ptr< ::mosek::fusion::ExprLinearDomain > _94_exprdom);
      static  monty::rc_ptr< ::mosek::fusion::SimpleTerm > term(monty::rc_ptr< ::mosek::fusion::Variable > _95_x,monty::rc_ptr< ::mosek::fusion::LinearDomain > _96_dom);
    }; // struct DJC;

    // mosek.fusion.BaseModel from file 'src/fusion/cxx/BaseModel_p.h'
    // namespace mosek::fusion
    struct p_BaseModel
    {
      p_BaseModel(BaseModel * _pubthis);
    
      void _initialize( monty::rc_ptr<BaseModel> m);
      void _initialize( const std::string & name,
                        const std::string & licpath);
    
      virtual ~p_BaseModel() { /* std::cout << "~p_BaseModel()" << std::endl;*/  }
    
      static p_BaseModel * _get_impl(Model * _inst) { return _inst->_impl; }
    
      //----------------------
    
      bool synched;
      std::string taskname;
    
      monty::rc_ptr<SolutionStruct> sol_itr;
      monty::rc_ptr<SolutionStruct> sol_itg;
      monty::rc_ptr<SolutionStruct> sol_bas;
    
      MSKsoltypee cursol;
      //---------------------
    
      std::unique_ptr<Task> task;
    
      //---------------------
      template<class T>
      using array_t = std::shared_ptr<monty::ndarray<T,1>>;
    
      virtual void clear_solutions() = 0;
      virtual void report_solution(SolutionType soltype,
                                   ProblemStatus prosta,
                                   SolutionStatus psolsta,
                                   SolutionStatus dsolsta,
                                   double pobj,
                                   double dobj,
                                   int32_t numvar,
                                   int32_t numcon,
                                   int32_t numbarelm,
                                   int32_t numacc,
                                   int32_t numaccelm,
                                   bool hasprimal,
                                   bool hasdual) = 0;
    
      void report_solution_get_xx(array_t<double> v);
      void report_solution_get_slx(array_t<double> v);
      void report_solution_get_sux(array_t<double> v);
      void report_solution_get_xc(array_t<double> v);
      void report_solution_get_slc(array_t<double> v);
      void report_solution_get_suc(array_t<double> v);
      void report_solution_get_barx(array_t<double> v);
      void report_solution_get_bars(array_t<double> v);
      void report_solution_get_accx(array_t<double> v);
      void report_solution_get_accy(array_t<double> v);
      void report_solution_get_accptr(array_t<int32_t> v);
    
      //---------------------
      void task_setLogHandler (const msghandler_t & handler);
      void task_setDataCallbackHandler (const datacbhandler_t & handler);
      void task_setCallbackHandler (const cbhandler_t & handler);
    
      int task_append_barvar(int size, int num);
    
      void task_djc_name   (int64_t index, const std::string & name);
      void task_var_name   (int index, const std::string & name);
      void task_con_name   (int index, const std::string & name);
      void task_barvar_name(int index, const std::string & name);
      void task_objectivename(         const std::string & name);
    
      void task_format_djc_names
      ( const std::shared_ptr<monty::ndarray<int64_t,1>> sub,
        const std::string                              & format,
        const std::shared_ptr<monty::ndarray<int,1>>     dims,
        const std::shared_ptr<monty::ndarray<std::shared_ptr<monty::ndarray<std::string,1>>>> names);
      void task_format_acc_names
      ( const std::shared_ptr<monty::ndarray<int64_t,1>> sub,
        const std::string                              & format,
        const std::shared_ptr<monty::ndarray<int,1>>     dims,
        const std::shared_ptr<monty::ndarray<std::shared_ptr<monty::ndarray<std::string,1>>>> names);
      void task_format_var_names
      ( const std::shared_ptr<monty::ndarray<int,1>>     subj,
        const std::string                              & format,
        const std::shared_ptr<monty::ndarray<int,1>>     dims,
        const std::shared_ptr<monty::ndarray<int64_t,1>> sp,
        const std::shared_ptr<monty::ndarray<std::shared_ptr<monty::ndarray<std::string,1>>>> names);
      void task_format_con_names
      ( const std::shared_ptr<monty::ndarray<int,1>>     subi,
        const std::string                              & format,
        const std::shared_ptr<monty::ndarray<int,1>>     dims,
        const std::shared_ptr<monty::ndarray<int64_t,1>> sp,
        const std::shared_ptr<monty::ndarray<std::shared_ptr<monty::ndarray<std::string,1>>>> names);
      void task_format_barvar_names
      ( const std::shared_ptr<monty::ndarray<int,1>>     subj,
        const std::string                              & format,
        const std::shared_ptr<monty::ndarray<int,1>>     dims,
        const std::shared_ptr<monty::ndarray<std::shared_ptr<monty::ndarray<std::string,1>>>> names);
    
      void task_break_solve();
    
      //--------------------------
    
      int task_numvar();
      int task_numcon();
      int task_numbarvar();
      int task_numacc();
      int task_numdjc();
      int task_numafe();
    
      //--------------------------
    
      void task_put_param(const std::string & name, const std::string & value);
      void task_put_param(const std::string & name, int    value);
      void task_put_param(const std::string & name, double value);
    
      double    task_get_dinf (const std::string & name);
      int       task_get_iinf (const std::string & name);
      int64_t task_get_liinf(const std::string & name);
    
      //--------------------------
    
      void task_con_putboundlist_fr(const std::shared_ptr<monty::ndarray<int,1>> idxs);
      void task_con_putboundlist_lo(const std::shared_ptr<monty::ndarray<int,1>> idxs, const std::shared_ptr<monty::ndarray<double,1>> & rhs);
      void task_con_putboundlist_up(const std::shared_ptr<monty::ndarray<int,1>> idxs, const std::shared_ptr<monty::ndarray<double,1>> & rhs);
      void task_con_putboundlist_fx(const std::shared_ptr<monty::ndarray<int,1>> idxs, const std::shared_ptr<monty::ndarray<double,1>> & rhs);
      void task_con_putboundlist_ra(const std::shared_ptr<monty::ndarray<int,1>> idxs, const std::shared_ptr<monty::ndarray<double,1>> & lb ,
                                    const std::shared_ptr<monty::ndarray<double,1>> & ub );
    
      void task_var_putboundlist_fr(const std::shared_ptr<monty::ndarray<int,1>> idxs);
      void task_var_putboundlist_lo(const std::shared_ptr<monty::ndarray<int,1>> idxs, const std::shared_ptr<monty::ndarray<double,1>> & rhs);
      void task_var_putboundlist_up(const std::shared_ptr<monty::ndarray<int,1>> idxs, const std::shared_ptr<monty::ndarray<double,1>> & rhs);
      void task_var_putboundlist_fx(const std::shared_ptr<monty::ndarray<int,1>> idxs, const std::shared_ptr<monty::ndarray<double,1>> & rhs);
      void task_var_putboundlist_ra(const std::shared_ptr<monty::ndarray<int,1>> idxs, const std::shared_ptr<monty::ndarray<double,1>> & lb ,
                                    const std::shared_ptr<monty::ndarray<double,1>> & ub );
    
      void task_var_putintlist(const std::shared_ptr<monty::ndarray<int,1>> & idxs);
      void task_var_putcontlist(const std::shared_ptr<monty::ndarray<int,1>> & idxs);
    
      //--------------------------
    
      void task_putbararowlist(const std::shared_ptr<monty::ndarray<int,1>>       subi,
                               const std::shared_ptr<monty::ndarray<int64_t,1>> ptr,
                               const std::shared_ptr<monty::ndarray<int,1>>       subj,
                               const std::shared_ptr<monty::ndarray<int64_t,1>> matidx);
    
      void task_putbaraijlist(const std::shared_ptr<monty::ndarray<int,1>> subi,
                              const std::shared_ptr<monty::ndarray<int,1>> subj,
                              std::shared_ptr<monty::ndarray<int64_t,1>> matidx);
    
      void task_putbarc(const std::shared_ptr<monty::ndarray<int,1>> subj,
                        const std::shared_ptr<monty::ndarray<int,1>> subl,
                        const std::shared_ptr<monty::ndarray<int,1>> subk,
                        const std::shared_ptr<monty::ndarray<double,1>> val);
    
      std::shared_ptr<monty::ndarray<int64_t,1>> task_appendsymmatlist (const std::shared_ptr<monty::ndarray<int,1>>       & dim,
                                                                        const std::shared_ptr<monty::ndarray<int64_t,1>> & nz,
                                                                        const std::shared_ptr<monty::ndarray<int,1>>       & subk,
                                                                        const std::shared_ptr<monty::ndarray<int,1>>       & subl,
                                                                        const std::shared_ptr<monty::ndarray<double,1>>    & val);
      int  task_barvar_dim(int j);
      void task_putbaraij (int i, int j, int k);
      void task_putbaraij (int i, int j, const std::shared_ptr<monty::ndarray<int,1>> & k);
      void task_putbarcj  (int j, int k);
      void task_putbarcj  (int j,        const std::shared_ptr<monty::ndarray<int,1>> & k);
      int  task_barvardim (int index);
    
      int task_append_var(int num);
      int task_append_con(int num);
    
      void task_cleararowlist(const std::shared_ptr<monty::ndarray<int,1>> & idxs);
      void task_clearacollist(const std::shared_ptr<monty::ndarray<int,1>> & idxs);
    
      void task_putarowlist(
        const std::shared_ptr<monty::ndarray<int,1>>       & idxs,
        const std::shared_ptr<monty::ndarray<int64_t,1>> & ptrb,
        const std::shared_ptr<monty::ndarray<int,1>>       & subj,
        const std::shared_ptr<monty::ndarray<double,1>>    & cof);
      void task_putaijlist(
        const std::shared_ptr<monty::ndarray<int,1>>       & subi,
        const std::shared_ptr<monty::ndarray<int,1>>       & subj,
        const std::shared_ptr<monty::ndarray<double,1>>    & cof,
        int64_t                           num);
    
      void task_setnumvar(int num);
      void task_cleanup(int oldnum, int oldnumcon, int oldnumcone, int oldnumbarvar);
      void task_putoptserver_host(const std::string & addr);
      void report_task_solution(MSKsoltypee st, int numvar, int numcon, int numbarelm, int64_t numacc, int64_t numaccelm);
    
      void task_solve(bool remote, const std::string & server, const std::string & port);
      void task_post_solve();
      static std::shared_ptr<monty::ndarray<SolverStatus,1>>  env_solve_batch(bool israce, 
                                                                              double timelimit, 
                                                                              int numthreads, 
                                                                              std::shared_ptr<monty::ndarray<Model::t,1>> & models);
    
      void task_putobjective(
        bool                             maximize,
        const std::shared_ptr<monty::ndarray<int,1>>    & subj    ,
        const std::shared_ptr<monty::ndarray<double,1>> & cof     ,
        double                           cfix    );
    
      void task_putclist(
        const std::shared_ptr<monty::ndarray<int,1>>    & subj,
        const std::shared_ptr<monty::ndarray<double,1>> & cof);
    
    
      void task_putobjectivename(const std::string & name);
    
      void task_write(const std::string & filename);
      void task_write_stream(const std::string & ext, std::ostream & stream);
      void task_dump (const std::string & filename);
      void task_analyze_problem(int detail);
    
      MSKtask_t task_get();
      MSKtask_t __mosek_2fusion_2BaseModel__task_get();
    
      MSKtask_t __mosek_2fusion_2BaseModel__clonetask();
      MSKtask_t clonetask();
    
    
      void dispose();
    
      void task_putxx_slice(SolutionType which, int first, int last, std::shared_ptr<monty::ndarray<double,1>> & xx);
    
      static void env_syeig (int n, std::shared_ptr<monty::ndarray<double,1>> & a, std::shared_ptr<monty::ndarray<double,1>> & w);
      static void env_potrf (int n, std::shared_ptr<monty::ndarray<double,1>> & a);
      static void env_syevd (int n, std::shared_ptr<monty::ndarray<double,1>> & a, std::shared_ptr<monty::ndarray<double,1>> & w);
    
      static void env_putlicensecode(std::shared_ptr<monty::ndarray<int,1>> code);
      static void env_putlicensepath(const std::string &licfile);
      static void env_putlicensewait(int wait);
    
      static std::string env_getversion();
    
      // void convertSolutionStatus(MSKsoltypee soltype, p_SolutionStruct * sol, MSKsolstae status, MSKprostae prosta);
    
      int64_t task_append_afes (int64_t n);
      void task_putafeflist  (array_t<int64_t> idxs, array_t<int> ptr, array_t<int>subj, array_t<double>cof, array_t<double>g);
      void task_putafebarfrowlist (array_t<int> idxs, array_t<int> ptr, array_t<int> barsubj, array_t<int64_t> symmatidx);
      void task_putafefijlist (array_t<int> &idxs, array_t<int> &subj, array_t<double> &cof);
      void task_putafefglist (array_t<int64_t> idxs, array_t<double> g);
      void task_clearafelist (array_t<int64_t>idxs);
      void task_putacclist  (array_t<int64_t>idxs, array_t<int64_t>domidxs, array_t<int64_t>afeidxs_t,array_t<double>g);
      void task_append_accs ( int64_t domidx, int numcone,array_t<int64_t> afeidxs,array_t<double> g);
    
      int64_t task_append_domain_quad     (int conesize);
      int64_t task_append_domain_rquad    (int conesize);
      int64_t task_append_domain_pexp     ();
      int64_t task_append_domain_ppow     (int conesize,array_t<double> alpha);
      array_t<int64_t> task_append_domain_ppow_seq     (int conesize,int nleftcommon,array_t<double> alpha);
      int64_t task_append_domain_dexp     ();
      int64_t task_append_domain_dpow     (int conesize,array_t<double> alpha);
      array_t<int64_t> task_append_domain_dpow_seq     (int conesize,int nleftcommon,array_t<double> alpha);
      /* int64_t task_append_domain_onenorm  (int conesize); */
      /* int64_t task_append_domain_infnorm  (int conesize); */
      int64_t task_append_domain_pgeomean (int conesize);
      int64_t task_append_domain_dgeomean (int conesize);
      int64_t task_append_domain_rpos     (int conesize);
      int64_t task_append_domain_rneg     (int conesize);
      int64_t task_append_domain_r        (int conesize);
      int64_t task_append_domain_rzero    (int conesize);
      int64_t task_append_domain_svec_psd (int conesize);
      int64_t task_append_domain_empty    ();
      int64_t task_append_djc             (int64_t n);
      void task_putdjcslice(int64_t first, int64_t last , array_t<int64_t> numterm_t, array_t<int64_t> termsizes, array_t<int64_t> domidxlist, array_t<int64_t> afeidxlist,  array_t<double> b);
    
    };
    // End of file 'src/fusion/cxx/BaseModel_p.h'
    struct p_Model : public ::mosek::fusion::p_BaseModel
    {
      Model * _pubthis;
      static mosek::fusion::p_Model* _get_impl(mosek::fusion::Model * _inst){ return static_cast< mosek::fusion::p_Model* >(mosek::fusion::p_BaseModel::_get_impl(_inst)); }
      static mosek::fusion::p_Model * _get_impl(mosek::fusion::Model::t _inst) { return _get_impl(_inst.get()); }
      p_Model(Model * _pubthis);
      virtual ~p_Model() { /* std::cout << "~p_Model" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::WorkStack > xs{};
      monty::rc_ptr< ::mosek::fusion::WorkStack > ws{};
      monty::rc_ptr< ::mosek::fusion::WorkStack > rs{};
      monty::rc_ptr< ::mosek::fusion::SolutionStruct > sol_itg{};
      monty::rc_ptr< ::mosek::fusion::SolutionStruct > sol_bas{};
      monty::rc_ptr< ::mosek::fusion::SolutionStruct > sol_itr{};
      monty::rc_ptr< ::mosek::fusion::Utils::StringIntMap > con_map{};
      std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::ModelConstraint >,1 > > acons{};
      std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::ModelConstraint >,1 > > cons{};
      int64_t task_numaferow{};
      std::shared_ptr< monty::ndarray< double,1 > > param_value{};
      int32_t param_num{};
      monty::rc_ptr< ::mosek::fusion::Utils::StringIntMap > par_map{};
      int32_t numparameter{};
      std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Parameter >,1 > > parameters{};
      std::shared_ptr< monty::ndarray< bool,1 > > initsol_xx_flag{};
      std::shared_ptr< monty::ndarray< double,1 > > initsol_xx{};
      monty::rc_ptr< ::mosek::fusion::Utils::StringIntMap > var_map{};
      std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::ModelVariable >,1 > > barvars{};
      std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::ModelVariable >,1 > > vars{};
      int32_t bfixidx{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > barvar_block_elm_j{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > barvar_block_elm_i{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > barvar_block_elm_barj{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > barvar_block_elm_ptr{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > barvar_block_dim{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > barvar_block_ptr{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > barvar_dim{};
      int32_t barvar_num{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > var_elm_acc_ofs{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > var_elm_acc_idx{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > var_block_acc_id{};
      monty::rc_ptr< ::mosek::fusion::LinkedBlocks > var_block_map{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > acon_elm_afe{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > acon_elm_ofs{};
      std::shared_ptr< monty::ndarray< double,1 > > acon_elm_scale{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > acon_elm_accid{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > acon_afe{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > acon_acc{};
      monty::rc_ptr< ::mosek::fusion::LinkedBlocks > acon_block_map{};
      monty::rc_ptr< ::mosek::fusion::LinkedBlocks > acc_block_map{};
      monty::rc_ptr< ::mosek::fusion::RowBlockManager > obj_blocks{};
      monty::rc_ptr< ::mosek::fusion::RowBlockManager > afe_blocks{};
      monty::rc_ptr< ::mosek::fusion::RowBlockManager > con_blocks{};
      int32_t num_task_acc{};
      int32_t num_task_afe{};
      int32_t num_task_con{};
      bool cache_evaluations{};
      mosek::fusion::SolutionType solutionptr{};
      mosek::fusion::AccSolutionStatus acceptable_sol{};
      std::string model_name{};

      virtual void destroy();

      static Model::t _new_Model(monty::rc_ptr< ::mosek::fusion::Model > _703_m);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _703_m);
      static Model::t _new_Model(const std::string &  _710_name,int32_t _711_basesize,bool _712_cache_eval);
      void _initialize(const std::string &  _710_name,int32_t _711_basesize,bool _712_cache_eval);
      static Model::t _new_Model(int32_t _720_basesize,bool _721_cache_eval);
      void _initialize(int32_t _720_basesize,bool _721_cache_eval);
      static Model::t _new_Model(const std::string &  _722_name);
      void _initialize(const std::string &  _722_name);
      static Model::t _new_Model();
      void _initialize();
      virtual monty::rc_ptr< ::mosek::fusion::Disjunction > __mosek_2fusion_2Model__disjunction(const std::string &  _723_name,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Term >,1 > > _724_terms) ;
      virtual monty::rc_ptr< ::mosek::fusion::Disjunction > __mosek_2fusion_2Model__disjunction(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Term >,1 > > _770_terms) ;
      virtual monty::rc_ptr< ::mosek::fusion::Disjunction > __mosek_2fusion_2Model__disjunction(monty::rc_ptr< ::mosek::fusion::DisjunctionTerms > _771_djcterms) ;
      virtual monty::rc_ptr< ::mosek::fusion::Disjunction > __mosek_2fusion_2Model__disjunction(const std::string &  _772_name,monty::rc_ptr< ::mosek::fusion::DisjunctionTerms > _773_djcterms) ;
      virtual monty::rc_ptr< ::mosek::fusion::Disjunction > __mosek_2fusion_2Model__disjunction(const std::string &  _774_name,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::ExprDomain >,1 > > _775_terms) ;
      virtual monty::rc_ptr< ::mosek::fusion::Disjunction > __mosek_2fusion_2Model__disjunction(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::ExprDomain >,1 > > _777_terms) ;
      virtual monty::rc_ptr< ::mosek::fusion::Disjunction > __mosek_2fusion_2Model__disjunction(const std::string &  _779_name,monty::rc_ptr< ::mosek::fusion::ExprDomain > _780_term) ;
      virtual monty::rc_ptr< ::mosek::fusion::Disjunction > __mosek_2fusion_2Model__disjunction(monty::rc_ptr< ::mosek::fusion::ExprDomain > _781_term) ;
      virtual monty::rc_ptr< ::mosek::fusion::Disjunction > __mosek_2fusion_2Model__disjunction(monty::rc_ptr< ::mosek::fusion::Term > _782_t1,monty::rc_ptr< ::mosek::fusion::Term > _783_t2,monty::rc_ptr< ::mosek::fusion::Term > _784_t3) ;
      virtual monty::rc_ptr< ::mosek::fusion::Disjunction > __mosek_2fusion_2Model__disjunction(monty::rc_ptr< ::mosek::fusion::Term > _785_t1,monty::rc_ptr< ::mosek::fusion::Term > _786_t2) ;
      virtual monty::rc_ptr< ::mosek::fusion::Disjunction > __mosek_2fusion_2Model__disjunction(monty::rc_ptr< ::mosek::fusion::Term > _787_t1) ;
      virtual monty::rc_ptr< ::mosek::fusion::Disjunction > __mosek_2fusion_2Model__disjunction(const std::string &  _788_name,monty::rc_ptr< ::mosek::fusion::Term > _789_t1,monty::rc_ptr< ::mosek::fusion::Term > _790_t2,monty::rc_ptr< ::mosek::fusion::Term > _791_t3) ;
      virtual monty::rc_ptr< ::mosek::fusion::Disjunction > __mosek_2fusion_2Model__disjunction(const std::string &  _792_name,monty::rc_ptr< ::mosek::fusion::Term > _793_t1,monty::rc_ptr< ::mosek::fusion::Term > _794_t2) ;
      virtual monty::rc_ptr< ::mosek::fusion::Disjunction > __mosek_2fusion_2Model__disjunction(const std::string &  _795_name,monty::rc_ptr< ::mosek::fusion::Term > _796_t1) ;
      virtual monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > __mosek_2fusion_2Model__formstConstr(monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _797_sb,std::shared_ptr< monty::ndarray< int32_t,1 > > _798_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _799_idxs) ;
      virtual void acon_release(int32_t _800_id) ;
      virtual int32_t acon_allocate(std::shared_ptr< monty::ndarray< int64_t,1 > > _808_domidxs,int32_t _809_conesize,int32_t _810_numcone,std::shared_ptr< monty::ndarray< double,1 > > _811_g,std::shared_ptr< monty::ndarray< int32_t,1 > > _812_afeidxs,std::shared_ptr< monty::ndarray< int32_t,1 > > _813_accidxs) ;
      virtual void afe_release(int32_t _838_id) ;
      virtual int32_t afe_allocate(std::shared_ptr< monty::ndarray< int32_t,1 > > _841_nativeidxs) ;
      virtual void con_release(int32_t _847_id) ;
      virtual int32_t con_allocate(std::shared_ptr< monty::ndarray< int32_t,1 > > _850_nativeidxs) ;
      virtual int32_t barvar_alloc(int32_t _858_conedim,int32_t _859_numcone,std::shared_ptr< monty::ndarray< int32_t,1 > > _860_barvaridxs,std::shared_ptr< monty::ndarray< int64_t,1 > > _861_nativeidxs) ;
      virtual int32_t conicvar_alloc(std::shared_ptr< monty::ndarray< int64_t,1 > > _892_domidxs,int32_t _893_conesize,int32_t _894_numcone,std::shared_ptr< monty::ndarray< int32_t,1 > > _895_accidxs,std::shared_ptr< monty::ndarray< int32_t,1 > > _896_nativeidxs) ;
      virtual int32_t linearvar_alloc(int32_t _908_n,std::shared_ptr< monty::ndarray< int32_t,1 > > _909_nativeidxs) ;
      virtual void make_continuous(std::shared_ptr< monty::ndarray< int64_t,1 > > _921_idxs) ;
      virtual void make_integer(std::shared_ptr< monty::ndarray< int64_t,1 > > _927_idxs) ;
      static  void putlicensewait(bool _933_wait);
      static  void putlicensepath(const std::string &  _934_licfile);
      static  void putlicensecode(std::shared_ptr< monty::ndarray< int32_t,1 > > _935_code);
      virtual /* override */ void dispose() ;
      virtual MSKtask_t __mosek_2fusion_2Model__getTask() ;
      virtual void getConstraintDuals(bool _941_lower,std::shared_ptr< monty::ndarray< int32_t,1 > > _942_nativeidxs,std::shared_ptr< monty::ndarray< double,1 > > _943_res,int32_t _944_offset) ;
      virtual void getConstraintValues(bool _949_primal,std::shared_ptr< monty::ndarray< int32_t,1 > > _950_nativeidxs,std::shared_ptr< monty::ndarray< double,1 > > _951_res,int32_t _952_offset) ;
      virtual void getVariableDuals(bool _964_lower,std::shared_ptr< monty::ndarray< int64_t,1 > > _965_nativeidxs,std::shared_ptr< monty::ndarray< double,1 > > _966_res,int32_t _967_offset) ;
      virtual void getVariableValues(bool _973_primal,std::shared_ptr< monty::ndarray< int64_t,1 > > _974_nativeidxs,std::shared_ptr< monty::ndarray< double,1 > > _975_res,int32_t _976_offset) ;
      virtual void setVariableValues(bool _988_primal,std::shared_ptr< monty::ndarray< int64_t,1 > > _989_nativeidxs,std::shared_ptr< monty::ndarray< double,1 > > _990_values) ;
      virtual void writeTaskNoFlush(const std::string &  _997_filename) ;
      virtual void writeTaskStream(const std::string &  _998_ext,std::ostream&  _999_stream) ;
      virtual void expressionCache(bool _1000_cache) ;
      virtual void dataReport() ;
      virtual void dataReport(int32_t _1001_detail) ;
      virtual void writeTask(const std::string &  _1002_filename) ;
      virtual int64_t getSolverLIntInfo(const std::string &  _1003_name) ;
      virtual int32_t getSolverIntInfo(const std::string &  _1004_name) ;
      virtual double getSolverDoubleInfo(const std::string &  _1005_name) ;
      virtual void setCallbackHandler(mosek::cbhandler_t  _1006_h) ;
      virtual void setDataCallbackHandler(mosek::datacbhandler_t  _1007_h) ;
      virtual void setLogHandler(mosek::msghandler_t  _1008_h) ;
      virtual void setSolverParam(const std::string &  _1009_name,double _1010_floatval) ;
      virtual void setSolverParam(const std::string &  _1011_name,int32_t _1012_intval) ;
      virtual void setSolverParam(const std::string &  _1013_name,const std::string &  _1014_strval) ;
      virtual void breakSolver() ;
      virtual void optserverHost(const std::string &  _1015_addr) ;
      virtual /* override */ void report_solution(mosek::fusion::SolutionType _1016_soltype,mosek::fusion::ProblemStatus _1017_prosta,mosek::fusion::SolutionStatus _1018_psolsta,mosek::fusion::SolutionStatus _1019_dsolsta,double _1020_pobj,double _1021_dobj,int32_t _1022_numvar,int32_t _1023_numcon,int32_t _1024_numbarelm,int32_t _1025_numacc,int32_t _1026_numaccelm,bool _1027_hasprimal,bool _1028_hasdual) ;
      virtual /* override */ void clear_solutions() ;
      static  std::shared_ptr< monty::ndarray< mosek::fusion::SolverStatus,1 > > solveBatch(bool _1038_israce,double _1039_maxtime,int32_t _1040_numthreads,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Model >,1 > > _1041_models);
      virtual void solve(const std::string &  _1047_addr,const std::string &  _1048_accesstoken) ;
      virtual void solve() ;
      virtual void flush_parameters() ;
      virtual void flushParameters() ;
      virtual void evaluate_parameterized(monty::rc_ptr< ::mosek::fusion::WorkStack > _1061_xs,int32_t _1062_numrow,std::shared_ptr< monty::ndarray< int32_t,1 > > _1063_rowptrb,std::shared_ptr< monty::ndarray< int32_t,1 > > _1064_rowptre,std::shared_ptr< monty::ndarray< int64_t,1 > > _1065_codenidx,std::shared_ptr< monty::ndarray< int32_t,1 > > _1066_codeptr,std::shared_ptr< monty::ndarray< int32_t,1 > > _1067_codesizes,std::shared_ptr< monty::ndarray< int32_t,1 > > _1068_code,std::shared_ptr< monty::ndarray< double,1 > > _1069_cconst,std::shared_ptr< monty::ndarray< int32_t,1 > > _1070_subj,std::shared_ptr< monty::ndarray< double,1 > > _1071_val) ;
      virtual void flushSolutions() ;
      virtual void flush_initsol(mosek::fusion::SolutionType _1082_which) ;
      virtual mosek::fusion::SolutionStatus getDualSolutionStatus() ;
      virtual mosek::fusion::ProblemStatus getProblemStatus() ;
      virtual mosek::fusion::SolutionStatus getPrimalSolutionStatus() ;
      virtual double dualObjValue() ;
      virtual double primalObjValue() ;
      virtual monty::rc_ptr< ::mosek::fusion::SolutionStruct > __mosek_2fusion_2Model__get_sol_cache(mosek::fusion::SolutionType _1089_which_,bool _1090_primal,bool _1091_nothrow) ;
      virtual monty::rc_ptr< ::mosek::fusion::SolutionStruct > __mosek_2fusion_2Model__get_sol_cache(mosek::fusion::SolutionType _1097_which_,bool _1098_primal) ;
      virtual void setSolution_xx(std::shared_ptr< monty::ndarray< int32_t,1 > > _1099_subj,std::shared_ptr< monty::ndarray< double,1 > > _1100_val) ;
      virtual void ensure_initsol_xx() ;
      virtual std::shared_ptr< monty::ndarray< int32_t,1 > > getSolution_accptr(mosek::fusion::SolutionType _1107_which) ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_accy(mosek::fusion::SolutionType _1108_which) ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_accx(mosek::fusion::SolutionType _1109_which) ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_bars(mosek::fusion::SolutionType _1110_which) ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_barx(mosek::fusion::SolutionType _1111_which) ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_y(mosek::fusion::SolutionType _1112_which) ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_xc(mosek::fusion::SolutionType _1113_which) ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_suc(mosek::fusion::SolutionType _1114_which) ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_slc(mosek::fusion::SolutionType _1115_which) ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_sux(mosek::fusion::SolutionType _1116_which) ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_slx(mosek::fusion::SolutionType _1117_which) ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_yx(mosek::fusion::SolutionType _1118_which) ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > getSolution_xx(mosek::fusion::SolutionType _1119_which) ;
      virtual void selectedSolution(mosek::fusion::SolutionType _1120_soltype) ;
      virtual mosek::fusion::AccSolutionStatus getAcceptedSolutionStatus() ;
      virtual void acceptedSolutionStatus(mosek::fusion::AccSolutionStatus _1121_what) ;
      virtual mosek::fusion::ProblemStatus getProblemStatus(mosek::fusion::SolutionType _1122_which) ;
      virtual mosek::fusion::SolutionStatus getDualSolutionStatus(mosek::fusion::SolutionType _1124_which) ;
      virtual mosek::fusion::SolutionStatus getPrimalSolutionStatus(mosek::fusion::SolutionType _1125_which) ;
      virtual mosek::fusion::SolutionStatus getSolutionStatus(mosek::fusion::SolutionType _1126_which,bool _1127_primal) ;
      virtual void update(std::shared_ptr< monty::ndarray< int32_t,1 > > _1130_conidxs,monty::rc_ptr< ::mosek::fusion::Expression > _1131_expr) ;
      virtual void update(std::shared_ptr< monty::ndarray< int32_t,1 > > _1198_conidxs,monty::rc_ptr< ::mosek::fusion::Expression > _1199_expr,std::shared_ptr< monty::ndarray< int32_t,1 > > _1200_varidxs) ;
      virtual void updateObjective(monty::rc_ptr< ::mosek::fusion::Expression > _1302_expr,monty::rc_ptr< ::mosek::fusion::Variable > _1303_x) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter_unchecked(const std::string &  _1340_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _1341_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _1342_sp) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter_(const std::string &  _1352_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _1353_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _1354_sp) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter_(const std::string &  _1359_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _1360_shape,std::shared_ptr< monty::ndarray< int32_t,2 > > _1361_sparsity) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter(const std::string &  _1369_name) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter(const std::string &  _1371_name,int32_t _1372_d1,int32_t _1373_d2,int32_t _1374_d3) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter(const std::string &  _1376_name,int32_t _1377_d1,int32_t _1378_d2) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter(const std::string &  _1380_name,int32_t _1381_d1) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter(const std::string &  _1383_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _1384_shape) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter(const std::string &  _1386_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _1387_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _1388_sp) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter(const std::string &  _1389_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _1390_shape,std::shared_ptr< monty::ndarray< int32_t,2 > > _1391_sparsity) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter() ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter(int32_t _1393_d1,int32_t _1394_d2,int32_t _1395_d3) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter(int32_t _1397_d1,int32_t _1398_d2) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter(int32_t _1400_d1) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter(std::shared_ptr< monty::ndarray< int32_t,1 > > _1402_shape) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter(std::shared_ptr< monty::ndarray< int32_t,1 > > _1404_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _1405_sp) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__parameter(std::shared_ptr< monty::ndarray< int32_t,1 > > _1406_shape,std::shared_ptr< monty::ndarray< int32_t,2 > > _1407_sparsity) ;
      virtual void objective_(const std::string &  _1408_name,mosek::fusion::ObjectiveSense _1409_sense,monty::rc_ptr< ::mosek::fusion::Expression > _1410_expr) ;
      virtual void objective(double _1444_c) ;
      virtual void objective(mosek::fusion::ObjectiveSense _1445_sense,double _1446_c) ;
      virtual void objective(mosek::fusion::ObjectiveSense _1447_sense,monty::rc_ptr< ::mosek::fusion::Expression > _1448_expr) ;
      virtual void objective(const std::string &  _1449_name,double _1450_c) ;
      virtual void objective(const std::string &  _1451_name,mosek::fusion::ObjectiveSense _1452_sense,double _1453_c) ;
      virtual void objective(const std::string &  _1454_name,mosek::fusion::ObjectiveSense _1455_sense,monty::rc_ptr< ::mosek::fusion::Expression > _1456_expr) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangedConstraint > __mosek_2fusion_2Model__constraint(monty::rc_ptr< ::mosek::fusion::ExprRangeDomain > _1457_exprdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangedConstraint > __mosek_2fusion_2Model__constraint(const std::string &  _1458_name,monty::rc_ptr< ::mosek::fusion::ExprRangeDomain > _1459_exprdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangedConstraint > __mosek_2fusion_2Model__constraint(monty::rc_ptr< ::mosek::fusion::Expression > _1460_expr,monty::rc_ptr< ::mosek::fusion::RangeDomain > _1461_rdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangedConstraint > __mosek_2fusion_2Model__constraint(const std::string &  _1462_name,monty::rc_ptr< ::mosek::fusion::Expression > _1463_expr,monty::rc_ptr< ::mosek::fusion::RangeDomain > _1464_rdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__constraint(monty::rc_ptr< ::mosek::fusion::ExprConicDomain > _1465_exprdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__constraint(const std::string &  _1466_name,monty::rc_ptr< ::mosek::fusion::ExprConicDomain > _1467_exprdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__constraint(monty::rc_ptr< ::mosek::fusion::Expression > _1468_expr,monty::rc_ptr< ::mosek::fusion::ConeDomain > _1469_qdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__constraint(const std::string &  _1470_name,monty::rc_ptr< ::mosek::fusion::Expression > _1471_expr,monty::rc_ptr< ::mosek::fusion::ConeDomain > _1472_qdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__constraint(monty::rc_ptr< ::mosek::fusion::ExprLinearDomain > _1473_exprdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__constraint(const std::string &  _1474_name,monty::rc_ptr< ::mosek::fusion::ExprLinearDomain > _1475_exprdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__constraint(monty::rc_ptr< ::mosek::fusion::Expression > _1476_expr,monty::rc_ptr< ::mosek::fusion::LinearDomain > _1477_ldom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__constraint(const std::string &  _1478_name,monty::rc_ptr< ::mosek::fusion::Expression > _1479_expr,monty::rc_ptr< ::mosek::fusion::LinearDomain > _1480_ldom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__constraint(monty::rc_ptr< ::mosek::fusion::ExprPSDDomain > _1481_exprdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__constraint(const std::string &  _1482_name,monty::rc_ptr< ::mosek::fusion::ExprPSDDomain > _1483_exprdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__constraint(monty::rc_ptr< ::mosek::fusion::Expression > _1484_expr,monty::rc_ptr< ::mosek::fusion::PSDDomain > _1485_psddom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__constraint(const std::string &  _1486_name,monty::rc_ptr< ::mosek::fusion::Expression > _1487_expr,monty::rc_ptr< ::mosek::fusion::PSDDomain > _1488_psddom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(monty::rc_ptr< ::mosek::fusion::PSDDomain > _1489_psddom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(int32_t _1490_n,int32_t _1491_m,monty::rc_ptr< ::mosek::fusion::PSDDomain > _1492_psddom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(int32_t _1493_n,monty::rc_ptr< ::mosek::fusion::PSDDomain > _1494_psddom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(const std::string &  _1495_name,monty::rc_ptr< ::mosek::fusion::PSDDomain > _1496_psddom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(const std::string &  _1497_name,int32_t _1498_n,int32_t _1499_m,monty::rc_ptr< ::mosek::fusion::PSDDomain > _1500_psddom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(const std::string &  _1501_name,int32_t _1502_n,monty::rc_ptr< ::mosek::fusion::PSDDomain > _1503_psddom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(const std::string &  _1504_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _1505_shp,monty::rc_ptr< ::mosek::fusion::PSDDomain > _1506_psddom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(monty::rc_ptr< ::mosek::fusion::ConeDomain > _1507_qdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangedVariable > __mosek_2fusion_2Model__variable(monty::rc_ptr< ::mosek::fusion::RangeDomain > _1508_rdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(monty::rc_ptr< ::mosek::fusion::LinearDomain > _1509_ldom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(std::shared_ptr< monty::ndarray< int32_t,1 > > _1510_shp,monty::rc_ptr< ::mosek::fusion::ConeDomain > _1511_qdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangedVariable > __mosek_2fusion_2Model__variable(std::shared_ptr< monty::ndarray< int32_t,1 > > _1512_shp,monty::rc_ptr< ::mosek::fusion::RangeDomain > _1513_rdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(std::shared_ptr< monty::ndarray< int32_t,1 > > _1514_shp,monty::rc_ptr< ::mosek::fusion::LinearDomain > _1515_ldom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(std::shared_ptr< monty::ndarray< int32_t,1 > > _1516_shp) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(int32_t _1517_size,monty::rc_ptr< ::mosek::fusion::ConeDomain > _1518_qdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangedVariable > __mosek_2fusion_2Model__variable(int32_t _1519_size,monty::rc_ptr< ::mosek::fusion::RangeDomain > _1520_rdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(int32_t _1521_size,monty::rc_ptr< ::mosek::fusion::LinearDomain > _1522_ldom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(int32_t _1523_size) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable() ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(const std::string &  _1524_name,monty::rc_ptr< ::mosek::fusion::ConeDomain > _1525_qdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangedVariable > __mosek_2fusion_2Model__variable(const std::string &  _1526_name,monty::rc_ptr< ::mosek::fusion::RangeDomain > _1527_rdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(const std::string &  _1528_name,monty::rc_ptr< ::mosek::fusion::LinearDomain > _1529_ldom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(const std::string &  _1530_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _1531_shp,monty::rc_ptr< ::mosek::fusion::ConeDomain > _1532_qdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangedVariable > __mosek_2fusion_2Model__variable(const std::string &  _1533_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _1534_shp,monty::rc_ptr< ::mosek::fusion::RangeDomain > _1535_rdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(const std::string &  _1536_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _1537_shp,monty::rc_ptr< ::mosek::fusion::LinearDomain > _1538_ldom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(const std::string &  _1539_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _1540_shp) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(const std::string &  _1541_name,int32_t _1542_size,monty::rc_ptr< ::mosek::fusion::ConeDomain > _1543_qdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangedVariable > __mosek_2fusion_2Model__variable(const std::string &  _1544_name,int32_t _1545_size,monty::rc_ptr< ::mosek::fusion::RangeDomain > _1546_rdom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(const std::string &  _1547_name,int32_t _1548_size,monty::rc_ptr< ::mosek::fusion::LinearDomain > _1549_ldom) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(const std::string &  _1550_name,int32_t _1551_size) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable(const std::string &  _1552_name) ;
      virtual void removeConstraintBlock(int32_t _1553_conid) ;
      virtual void removeVariableBlock(int64_t _1554_varid64) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangedVariable > __mosek_2fusion_2Model__ranged_variable(const std::string &  _1559_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _1560_shp,monty::rc_ptr< ::mosek::fusion::RangeDomain > _1561_dom_) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable_(const std::string &  _1622_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _1623_shp,monty::rc_ptr< ::mosek::fusion::ConeDomain > _1624_dom_) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable_(const std::string &  _1664_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _1665_shp,monty::rc_ptr< ::mosek::fusion::LinearDomain > _1666_dom_) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__variable_(const std::string &  _1725_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _1726_shp,monty::rc_ptr< ::mosek::fusion::PSDDomain > _1727_dom_) ;
      virtual void putfrows(std::shared_ptr< monty::ndarray< int32_t,1 > > _1756_nativeidxs,int32_t _1757_nativebaseptr,monty::rc_ptr< ::mosek::fusion::WorkStack > _1758_rs,int32_t _1759_nelem,int32_t _1760_nnz,int32_t _1761_ptr_base,int32_t _1762_nidxs_base,int32_t _1763_cof_base) ;
      virtual void putarows(std::shared_ptr< monty::ndarray< int32_t,1 > > _1803_nativeidxs,monty::rc_ptr< ::mosek::fusion::WorkStack > _1804_rs,int32_t _1805_nelem,int32_t _1806_nnz,int32_t _1807_ptr_base,int32_t _1808_nidxs_base,int32_t _1809_cof_base) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangedConstraint > __mosek_2fusion_2Model__constraint_(const std::string &  _1846_name,monty::rc_ptr< ::mosek::fusion::Expression > _1847_expr,monty::rc_ptr< ::mosek::fusion::RangeDomain > _1848_dom_) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__constraint_(const std::string &  _1891_name,monty::rc_ptr< ::mosek::fusion::Expression > _1892_expr,monty::rc_ptr< ::mosek::fusion::PSDDomain > _1893_dom_) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__constraint_(const std::string &  _1988_name,monty::rc_ptr< ::mosek::fusion::Expression > _1989_expr,monty::rc_ptr< ::mosek::fusion::ConeDomain > _1990_dom_) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__constraint_(const std::string &  _2051_name,monty::rc_ptr< ::mosek::fusion::Expression > _2052_expr,monty::rc_ptr< ::mosek::fusion::LinearDomain > _2053_dom_) ;
      static  std::string getVersion();
      virtual bool hasParameter(const std::string &  _2092_name) ;
      virtual bool hasConstraint(const std::string &  _2093_name) ;
      virtual bool hasVariable(const std::string &  _2094_name) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Model__getParameter(const std::string &  _2095_name) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__getConstraint(int32_t _2096_index) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Model__getConstraint(const std::string &  _2098_name) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__getVariable(int32_t _2101_index) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Model__getVariable(const std::string &  _2102_name) ;
      virtual std::string getName() ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > getParameterValue(std::shared_ptr< monty::ndarray< int32_t,1 > > _2104_idxs) ;
      virtual void setParameterValue(std::shared_ptr< monty::ndarray< int32_t,1 > > _2107_idxs,std::shared_ptr< monty::ndarray< double,1 > > _2108_vals) ;
      virtual monty::rc_ptr< ::mosek::fusion::Model > __mosek_2fusion_2Model__clone() ;
    }; // struct Model;

    // mosek.fusion.Debug from file 'src/fusion/cxx/Debug_p.h'
    // namespace mosek::fusion
    struct p_Debug
    {
      Debug * _pubthis;
    
      p_Debug(Debug * _pubthis) : _pubthis(_pubthis) {}
    
      static Debug::t o ()                 { return monty::rc_ptr<Debug>(new Debug()); }
      Debug::t p (const std::string & val) { std::cout << val; return Debug::t(_pubthis); }
      Debug::t p (      int val)           { std::cout << val; return Debug::t(_pubthis); }
      Debug::t p (int64_t val)           { std::cout << val; return Debug::t(_pubthis); }
      Debug::t p (   double val)           { std::cout << val; return Debug::t(_pubthis); }
      Debug::t p (     bool val)           { std::cout << val; return Debug::t(_pubthis); }
      Debug::t lf()                        { std::cout << std::endl; return Debug::t(_pubthis); }
    
      static p_Debug * _get_impl(Debug * _inst) { return _inst->ptr; }
    
      template<typename T>
      Debug::t p(const std::shared_ptr<monty::ndarray<T,1>> & val)
      {
        if (val->size() > 0)
        {
          std::cout << (*val)[0];
          for (int i = 1; i < val->size(); ++i)
            std::cout << "," << (*val)[i];
        }
        return Debug::t(_pubthis);
      }
    
      Debug::t __mosek_2fusion_2Debug__p (const std::string & val) { std::cout << val; return Debug::t(_pubthis); }
    
      template<class C>
      Debug::t __mosek_2fusion_2Debug__p (C val) { std::cout << val; return Debug::t(_pubthis); }
      Debug::t __mosek_2fusion_2Debug__lf()      { std::cout << std::endl; return Debug::t(_pubthis); }
    
    };
    // End of file 'src/fusion/cxx/Debug_p.h'
    struct p_Sort
    {
      Sort * _pubthis;
      static mosek::fusion::p_Sort* _get_impl(mosek::fusion::Sort * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_Sort * _get_impl(mosek::fusion::Sort::t _inst) { return _get_impl(_inst.get()); }
      p_Sort(Sort * _pubthis);
      virtual ~p_Sort() { /* std::cout << "~p_Sort" << std::endl;*/ };

      virtual void destroy();

      static  void argTransposeSort(std::shared_ptr< monty::ndarray< int64_t,1 > > _309_perm,std::shared_ptr< monty::ndarray< int64_t,1 > > _310_ptrb,int32_t _311_m,int32_t _312_n,int32_t _313_p,std::shared_ptr< monty::ndarray< int64_t,1 > > _314_val);
      static  void argsort(std::shared_ptr< monty::ndarray< int64_t,1 > > _322_idx,std::shared_ptr< monty::ndarray< int64_t,1 > > _323_vals1);
      static  void argsort(std::shared_ptr< monty::ndarray< int64_t,1 > > _324_idx,std::shared_ptr< monty::ndarray< int32_t,1 > > _325_vals1);
      static  void argsort(std::shared_ptr< monty::ndarray< int64_t,1 > > _326_idx,std::shared_ptr< monty::ndarray< int64_t,1 > > _327_vals1,std::shared_ptr< monty::ndarray< int64_t,1 > > _328_vals2);
      static  void argsort(std::shared_ptr< monty::ndarray< int64_t,1 > > _329_idx,std::shared_ptr< monty::ndarray< int32_t,1 > > _330_vals1,std::shared_ptr< monty::ndarray< int32_t,1 > > _331_vals2);
      static  void argsort(std::shared_ptr< monty::ndarray< int64_t,1 > > _332_idx,std::shared_ptr< monty::ndarray< int64_t,1 > > _333_vals1,int64_t _334_first,int64_t _335_last);
      static  void argsort(std::shared_ptr< monty::ndarray< int64_t,1 > > _336_idx,std::shared_ptr< monty::ndarray< int32_t,1 > > _337_vals1,int64_t _338_first,int64_t _339_last);
      static  void argsort(std::shared_ptr< monty::ndarray< int64_t,1 > > _340_idx,std::shared_ptr< monty::ndarray< int64_t,1 > > _341_vals1,std::shared_ptr< monty::ndarray< int64_t,1 > > _342_vals2,int64_t _343_first,int64_t _344_last);
      static  void argsort(std::shared_ptr< monty::ndarray< int64_t,1 > > _345_idx,std::shared_ptr< monty::ndarray< int32_t,1 > > _346_vals1,std::shared_ptr< monty::ndarray< int32_t,1 > > _347_vals2,int64_t _348_first,int64_t _349_last);
      static  void argsort(std::shared_ptr< monty::ndarray< int64_t,1 > > _350_idx,std::shared_ptr< monty::ndarray< int64_t,1 > > _351_vals1,int64_t _352_first,int64_t _353_last,bool _354_check);
      static  void argsort(std::shared_ptr< monty::ndarray< int64_t,1 > > _357_idx,std::shared_ptr< monty::ndarray< int32_t,1 > > _358_vals1,int64_t _359_first,int64_t _360_last,bool _361_check);
      static  void argsort(std::shared_ptr< monty::ndarray< int64_t,1 > > _364_idx,std::shared_ptr< monty::ndarray< int64_t,1 > > _365_vals1,std::shared_ptr< monty::ndarray< int64_t,1 > > _366_vals2,int64_t _367_first,int64_t _368_last,bool _369_check);
      static  void argsort(std::shared_ptr< monty::ndarray< int64_t,1 > > _372_idx,std::shared_ptr< monty::ndarray< int32_t,1 > > _373_vals1,std::shared_ptr< monty::ndarray< int32_t,1 > > _374_vals2,int64_t _375_first,int64_t _376_last,bool _377_check);
      static  void argbucketsort(std::shared_ptr< monty::ndarray< int64_t,1 > > _380_idx,std::shared_ptr< monty::ndarray< int64_t,1 > > _381_vals,int64_t _382_first,int64_t _383_last,int64_t _384_minv,int64_t _385_maxv);
      static  void argbucketsort(std::shared_ptr< monty::ndarray< int64_t,1 > > _386_idx,std::shared_ptr< monty::ndarray< int32_t,1 > > _387_vals,int64_t _388_first,int64_t _389_last,int32_t _390_minv,int32_t _391_maxv);
      static  void getminmax(std::shared_ptr< monty::ndarray< int64_t,1 > > _392_idx,std::shared_ptr< monty::ndarray< int64_t,1 > > _393_vals1,std::shared_ptr< monty::ndarray< int64_t,1 > > _394_vals2,int64_t _395_first,int64_t _396_last,std::shared_ptr< monty::ndarray< int64_t,1 > > _397_res);
      static  void getminmax(std::shared_ptr< monty::ndarray< int64_t,1 > > _400_idx,std::shared_ptr< monty::ndarray< int32_t,1 > > _401_vals1,std::shared_ptr< monty::ndarray< int32_t,1 > > _402_vals2,int64_t _403_first,int64_t _404_last,std::shared_ptr< monty::ndarray< int32_t,1 > > _405_res);
      static  bool issorted(std::shared_ptr< monty::ndarray< int64_t,1 > > _408_idx,std::shared_ptr< monty::ndarray< int64_t,1 > > _409_vals1,int64_t _410_first,int64_t _411_last,bool _412_check);
      static  bool issorted(std::shared_ptr< monty::ndarray< int64_t,1 > > _414_idx,std::shared_ptr< monty::ndarray< int32_t,1 > > _415_vals1,int64_t _416_first,int64_t _417_last,bool _418_check);
      static  bool issorted(std::shared_ptr< monty::ndarray< int64_t,1 > > _420_idx,std::shared_ptr< monty::ndarray< int64_t,1 > > _421_vals1,std::shared_ptr< monty::ndarray< int64_t,1 > > _422_vals2,int64_t _423_first,int64_t _424_last,bool _425_check);
      static  bool issorted(std::shared_ptr< monty::ndarray< int64_t,1 > > _427_idx,std::shared_ptr< monty::ndarray< int32_t,1 > > _428_vals1,std::shared_ptr< monty::ndarray< int32_t,1 > > _429_vals2,int64_t _430_first,int64_t _431_last,bool _432_check);
    }; // struct Sort;

    struct p_IndexCounter
    {
      IndexCounter * _pubthis;
      static mosek::fusion::p_IndexCounter* _get_impl(mosek::fusion::IndexCounter * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_IndexCounter * _get_impl(mosek::fusion::IndexCounter::t _inst) { return _get_impl(_inst.get()); }
      p_IndexCounter(IndexCounter * _pubthis);
      virtual ~p_IndexCounter() { /* std::cout << "~p_IndexCounter" << std::endl;*/ };
      int64_t start{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > dims{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > strides{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > st{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > ii{};
      int32_t n{};

      virtual void destroy();

      static IndexCounter::t _new_IndexCounter(std::shared_ptr< monty::ndarray< int32_t,1 > > _434_shape);
      void _initialize(std::shared_ptr< monty::ndarray< int32_t,1 > > _434_shape);
      static IndexCounter::t _new_IndexCounter(int64_t _436_start_,std::shared_ptr< monty::ndarray< int32_t,1 > > _437_dims_,std::shared_ptr< monty::ndarray< int32_t,1 > > _438_shape);
      void _initialize(int64_t _436_start_,std::shared_ptr< monty::ndarray< int32_t,1 > > _437_dims_,std::shared_ptr< monty::ndarray< int32_t,1 > > _438_shape);
      static IndexCounter::t _new_IndexCounter(int64_t _441_start_,std::shared_ptr< monty::ndarray< int32_t,1 > > _442_dims_,std::shared_ptr< monty::ndarray< int64_t,1 > > _443_strides_);
      void _initialize(int64_t _441_start_,std::shared_ptr< monty::ndarray< int32_t,1 > > _442_dims_,std::shared_ptr< monty::ndarray< int64_t,1 > > _443_strides_);
      virtual bool atEnd() ;
      virtual std::shared_ptr< monty::ndarray< int32_t,1 > > getIndex() ;
      virtual int64_t next() ;
      virtual int64_t get() ;
      virtual void inc() ;
      virtual void reset() ;
    }; // struct IndexCounter;

    struct p_CommonTools
    {
      CommonTools * _pubthis;
      static mosek::fusion::p_CommonTools* _get_impl(mosek::fusion::CommonTools * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_CommonTools * _get_impl(mosek::fusion::CommonTools::t _inst) { return _get_impl(_inst.get()); }
      p_CommonTools(CommonTools * _pubthis);
      virtual ~p_CommonTools() { /* std::cout << "~p_CommonTools" << std::endl;*/ };

      virtual void destroy();

      static  std::shared_ptr< monty::ndarray< int64_t,1 > > resize(std::shared_ptr< monty::ndarray< int64_t,1 > > _449_values,int32_t _450_newsize);
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > resize(std::shared_ptr< monty::ndarray< int32_t,1 > > _452_values,int32_t _453_newsize);
      static  std::shared_ptr< monty::ndarray< double,1 > > resize(std::shared_ptr< monty::ndarray< double,1 > > _455_values,int32_t _456_newsize);
      static  int32_t binarySearch(std::shared_ptr< monty::ndarray< int32_t,1 > > _458_values,int32_t _459_target);
      static  int32_t binarySearch(std::shared_ptr< monty::ndarray< int64_t,1 > > _463_values,int64_t _464_target);
      static  int32_t binarySearchR(std::shared_ptr< monty::ndarray< int64_t,1 > > _466_values,int64_t _467_target);
      static  int32_t binarySearchL(std::shared_ptr< monty::ndarray< int64_t,1 > > _471_values,int64_t _472_target);
      static  void ndIncr(std::shared_ptr< monty::ndarray< int32_t,1 > > _476_ndidx,std::shared_ptr< monty::ndarray< int32_t,1 > > _477_first,std::shared_ptr< monty::ndarray< int32_t,1 > > _478_last);
      static  void transposeTriplets(std::shared_ptr< monty::ndarray< int32_t,1 > > _480_subi,std::shared_ptr< monty::ndarray< int32_t,1 > > _481_subj,std::shared_ptr< monty::ndarray< double,1 > > _482_val,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< int64_t,1 > >,1 > > _483_tsubi_,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< int64_t,1 > >,1 > > _484_tsubj_,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< double,1 > >,1 > > _485_tval_,int64_t _486_nelm,int32_t _487_dimi,int32_t _488_dimj);
      static  void transposeTriplets(std::shared_ptr< monty::ndarray< int32_t,1 > > _501_subi,std::shared_ptr< monty::ndarray< int32_t,1 > > _502_subj,std::shared_ptr< monty::ndarray< double,1 > > _503_val,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< int32_t,1 > >,1 > > _504_tsubi_,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< int32_t,1 > >,1 > > _505_tsubj_,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< double,1 > >,1 > > _506_tval_,int64_t _507_nelm,int32_t _508_dimi,int32_t _509_dimj);
      static  void tripletSort(std::shared_ptr< monty::ndarray< int32_t,1 > > _522_subi,std::shared_ptr< monty::ndarray< int32_t,1 > > _523_subj,std::shared_ptr< monty::ndarray< double,1 > > _524_val,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< int32_t,1 > >,1 > > _525_tsubi_,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< int32_t,1 > >,1 > > _526_tsubj_,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< double,1 > >,1 > > _527_tval_,int64_t _528_nelm,int32_t _529_dimi,int32_t _530_dimj);
      static  void argMSort(std::shared_ptr< monty::ndarray< int32_t,1 > > _556_idx,std::shared_ptr< monty::ndarray< int32_t,1 > > _557_vals);
      static  void mergeInto(std::shared_ptr< monty::ndarray< int32_t,1 > > _562_src,std::shared_ptr< monty::ndarray< int32_t,1 > > _563_tgt,std::shared_ptr< monty::ndarray< int32_t,1 > > _564_vals,int32_t _565_si0,int32_t _566_si1_,int32_t _567_si2_);
      static  void argQsort(std::shared_ptr< monty::ndarray< int64_t,1 > > _573_idx,std::shared_ptr< monty::ndarray< int64_t,1 > > _574_vals1,std::shared_ptr< monty::ndarray< int64_t,1 > > _575_vals2,int64_t _576_first,int64_t _577_last);
      static  void argQsort(std::shared_ptr< monty::ndarray< int64_t,1 > > _578_idx,std::shared_ptr< monty::ndarray< int32_t,1 > > _579_vals1,std::shared_ptr< monty::ndarray< int32_t,1 > > _580_vals2,int64_t _581_first,int64_t _582_last);
    }; // struct CommonTools;

    struct p_SolutionStruct
    {
      SolutionStruct * _pubthis;
      static mosek::fusion::p_SolutionStruct* _get_impl(mosek::fusion::SolutionStruct * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_SolutionStruct * _get_impl(mosek::fusion::SolutionStruct::t _inst) { return _get_impl(_inst.get()); }
      p_SolutionStruct(SolutionStruct * _pubthis);
      virtual ~p_SolutionStruct() { /* std::cout << "~p_SolutionStruct" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< double,1 > > accy{};
      std::shared_ptr< monty::ndarray< double,1 > > accx{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > accptr{};
      std::shared_ptr< monty::ndarray< double,1 > > yx{};
      std::shared_ptr< monty::ndarray< double,1 > > sux{};
      std::shared_ptr< monty::ndarray< double,1 > > slx{};
      std::shared_ptr< monty::ndarray< double,1 > > bars{};
      std::shared_ptr< monty::ndarray< double,1 > > barx{};
      std::shared_ptr< monty::ndarray< double,1 > > y{};
      std::shared_ptr< monty::ndarray< double,1 > > suc{};
      std::shared_ptr< monty::ndarray< double,1 > > slc{};
      std::shared_ptr< monty::ndarray< double,1 > > xx{};
      std::shared_ptr< monty::ndarray< double,1 > > xc{};
      double dobj{};
      double pobj{};
      mosek::fusion::ProblemStatus probstatus{};
      mosek::fusion::SolutionStatus dstatus{};
      mosek::fusion::SolutionStatus pstatus{};
      int32_t sol_numbarvar{};
      int32_t sol_numaccelm{};
      int32_t sol_numacc{};
      int32_t sol_numvar{};
      int32_t sol_numcon{};

      virtual void destroy();

      static SolutionStruct::t _new_SolutionStruct(int32_t _583_numvar,int32_t _584_numcon,int32_t _585_numbarvar,int32_t _586_numacc,int32_t _587_numaccelm);
      void _initialize(int32_t _583_numvar,int32_t _584_numcon,int32_t _585_numbarvar,int32_t _586_numacc,int32_t _587_numaccelm);
      static SolutionStruct::t _new_SolutionStruct(monty::rc_ptr< ::mosek::fusion::SolutionStruct > _588_that);
      void _initialize(monty::rc_ptr< ::mosek::fusion::SolutionStruct > _588_that);
      virtual monty::rc_ptr< ::mosek::fusion::SolutionStruct > __mosek_2fusion_2SolutionStruct__clone() ;
      virtual void resize(int32_t _589_numvar,int32_t _590_numcon,int32_t _591_numbarvar,int32_t _592_numacc,int32_t _593_numaccelm) ;
      virtual bool isDualAcceptable(mosek::fusion::AccSolutionStatus _614_acceptable_sol) ;
      virtual bool isPrimalAcceptable(mosek::fusion::AccSolutionStatus _615_acceptable_sol) ;
      virtual bool isAcceptable(mosek::fusion::SolutionStatus _616_stat,mosek::fusion::AccSolutionStatus _617_accstat) ;
    }; // struct SolutionStruct;

    struct p_RowBlockManager
    {
      RowBlockManager * _pubthis;
      static mosek::fusion::p_RowBlockManager* _get_impl(mosek::fusion::RowBlockManager * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_RowBlockManager * _get_impl(mosek::fusion::RowBlockManager::t _inst) { return _get_impl(_inst.get()); }
      p_RowBlockManager(RowBlockManager * _pubthis);
      virtual ~p_RowBlockManager() { /* std::cout << "~p_RowBlockManager" << std::endl;*/ };
      int32_t varidx_used{};
      int32_t code_used{};
      std::shared_ptr< monty::ndarray< double,1 > > cconst{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > code{};
      int32_t first_free_codeitem{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > param_code_sizes{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > param_varidx{};
      int32_t first_free_entry{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > row_code_ptr{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > row_param_ptre{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > row_param_ptrb{};
      monty::rc_ptr< ::mosek::fusion::LinkedBlocks > blocks{};

      virtual void destroy();

      static RowBlockManager::t _new_RowBlockManager(monty::rc_ptr< ::mosek::fusion::RowBlockManager > _618_that);
      void _initialize(monty::rc_ptr< ::mosek::fusion::RowBlockManager > _618_that);
      static RowBlockManager::t _new_RowBlockManager();
      void _initialize();
      virtual int32_t num_parameterized() ;
      virtual bool is_parameterized() ;
      virtual int32_t blocksize(int32_t _619_id) ;
      virtual int32_t block_capacity() ;
      virtual int32_t capacity() ;
      virtual void get(int32_t _620_id,std::shared_ptr< monty::ndarray< int32_t,1 > > _621_target,int32_t _622_offset) ;
      virtual void evaluate(monty::rc_ptr< ::mosek::fusion::WorkStack > _623_xs,std::shared_ptr< monty::ndarray< double,1 > > _624_param_value,std::shared_ptr< monty::ndarray< int32_t,1 > > _625_subi,std::shared_ptr< monty::ndarray< int32_t,1 > > _626_subj,std::shared_ptr< monty::ndarray< double,1 > > _627_val) ;
      virtual void replace_row_code(monty::rc_ptr< ::mosek::fusion::WorkStack > _638_rs,std::shared_ptr< monty::ndarray< int32_t,1 > > _639_nativeidxs,int32_t _640_ptr,int32_t _641_nidxs,int32_t _642_codeptr,int32_t _643_code_p,int32_t _644_cconst_p) ;
      virtual void clear_row_code(std::shared_ptr< monty::ndarray< int32_t,1 > > _667_nativeidxs) ;
      virtual void compress() ;
      virtual void ensure_code_cap(int32_t _680_nentry,int32_t _681_codesize) ;
      virtual void release(int32_t _691_id,std::shared_ptr< monty::ndarray< int32_t,1 > > _692_nativeidxs) ;
      virtual int32_t allocate(std::shared_ptr< monty::ndarray< int32_t,1 > > _696_nativeidxs) ;
      virtual bool row_is_parameterized(int32_t _702_i) ;
    }; // struct RowBlockManager;

    struct p_BaseVariable : public /*implements*/ virtual ::mosek::fusion::Variable
    {
      BaseVariable * _pubthis;
      static mosek::fusion::p_BaseVariable* _get_impl(mosek::fusion::BaseVariable * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_BaseVariable * _get_impl(mosek::fusion::BaseVariable::t _inst) { return _get_impl(_inst.get()); }
      p_BaseVariable(BaseVariable * _pubthis);
      virtual ~p_BaseVariable() { /* std::cout << "~p_BaseVariable" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< int64_t,1 > > sparsity{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > basevar_nativeidxs{};
      monty::rc_ptr< ::mosek::fusion::Model > model{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};

      virtual void destroy();

      static BaseVariable::t _new_BaseVariable(monty::rc_ptr< ::mosek::fusion::BaseVariable > _2283_v,monty::rc_ptr< ::mosek::fusion::Model > _2284_m);
      void _initialize(monty::rc_ptr< ::mosek::fusion::BaseVariable > _2283_v,monty::rc_ptr< ::mosek::fusion::Model > _2284_m);
      static BaseVariable::t _new_BaseVariable(monty::rc_ptr< ::mosek::fusion::Model > _2285_m,std::shared_ptr< monty::ndarray< int32_t,1 > > _2286_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _2287_sparsity,std::shared_ptr< monty::ndarray< int64_t,1 > > _2288_basevar_nativeidxs);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2285_m,std::shared_ptr< monty::ndarray< int32_t,1 > > _2286_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _2287_sparsity,std::shared_ptr< monty::ndarray< int64_t,1 > > _2288_basevar_nativeidxs);
      virtual /* override */ std::string toString() ;
      virtual void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _2291_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _2292_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _2293_xs,bool _2294_cache_eval) ;
      virtual bool compress_when_caching() ;
      virtual void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _2312_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _2313_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _2314_xs) ;
      virtual void recursive_eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _2315_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _2316_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _2317_xs,bool _2318_cache_eval) ;
      virtual void remove() ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__fromTril(int32_t _2319_dim0,int32_t _2320_d) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__fromTril(int32_t _2353_d) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__fromTril(int32_t _2353_d) { return __mosek_2fusion_2BaseVariable__fromTril(_2353_d); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__tril(int32_t _2354_dim1,int32_t _2355_dim2) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__tril() ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__tril() { return __mosek_2fusion_2BaseVariable__tril(); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__reshape(int32_t _2409_dim0,int32_t _2410_dim1,int32_t _2411_dim2) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__reshape(int32_t _2409_dim0,int32_t _2410_dim1,int32_t _2411_dim2) { return __mosek_2fusion_2BaseVariable__reshape(_2409_dim0,_2410_dim1,_2411_dim2); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__reshape(int32_t _2412_dim0,int32_t _2413_dim1) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__reshape(int32_t _2412_dim0,int32_t _2413_dim1) { return __mosek_2fusion_2BaseVariable__reshape(_2412_dim0,_2413_dim1); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__reshape(int32_t _2414_dim0) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__reshape(int32_t _2414_dim0) { return __mosek_2fusion_2BaseVariable__reshape(_2414_dim0); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__reshape(std::shared_ptr< monty::ndarray< int32_t,1 > > _2415_shape) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__reshape(std::shared_ptr< monty::ndarray< int32_t,1 > > _2415_shape) { return __mosek_2fusion_2BaseVariable__reshape(_2415_shape); }
      virtual void setLevel(std::shared_ptr< monty::ndarray< double,1 > > _2419_v) ;
      virtual monty::rc_ptr< ::mosek::fusion::Model > __mosek_2fusion_2BaseVariable__getModel() ;
      virtual monty::rc_ptr< ::mosek::fusion::Model > __mosek_2fusion_2Expression__getModel() { return __mosek_2fusion_2BaseVariable__getModel(); }
      virtual int32_t getND() ;
      virtual int32_t getDim(int32_t _2422_d) ;
      virtual std::shared_ptr< monty::ndarray< int32_t,1 > > getShape() ;
      virtual int64_t getSize() ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > dual() ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > level() ;
      virtual void makeContinuous() ;
      virtual void makeInteger() ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__transpose() ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__transpose() { return __mosek_2fusion_2BaseVariable__transpose(); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__index(int32_t _2443_i0,int32_t _2444_i1,int32_t _2445_i2) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__index(int32_t _2443_i0,int32_t _2444_i1,int32_t _2445_i2) { return __mosek_2fusion_2BaseVariable__index(_2443_i0,_2444_i1,_2445_i2); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__index(int32_t _2446_i0,int32_t _2447_i1) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__index(int32_t _2446_i0,int32_t _2447_i1) { return __mosek_2fusion_2BaseVariable__index(_2446_i0,_2447_i1); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__index(std::shared_ptr< monty::ndarray< int32_t,1 > > _2448_index) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__index(std::shared_ptr< monty::ndarray< int32_t,1 > > _2448_index) { return __mosek_2fusion_2BaseVariable__index(_2448_index); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__index(int32_t _2451_index) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__index(int32_t _2451_index) { return __mosek_2fusion_2BaseVariable__index(_2451_index); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__pick(std::shared_ptr< monty::ndarray< int32_t,1 > > _2452_i0,std::shared_ptr< monty::ndarray< int32_t,1 > > _2453_i1,std::shared_ptr< monty::ndarray< int32_t,1 > > _2454_i2) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__pick(std::shared_ptr< monty::ndarray< int32_t,1 > > _2452_i0,std::shared_ptr< monty::ndarray< int32_t,1 > > _2453_i1,std::shared_ptr< monty::ndarray< int32_t,1 > > _2454_i2) { return __mosek_2fusion_2BaseVariable__pick(_2452_i0,_2453_i1,_2454_i2); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__pick(std::shared_ptr< monty::ndarray< int32_t,1 > > _2457_i0,std::shared_ptr< monty::ndarray< int32_t,1 > > _2458_i1) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__pick(std::shared_ptr< monty::ndarray< int32_t,1 > > _2457_i0,std::shared_ptr< monty::ndarray< int32_t,1 > > _2458_i1) { return __mosek_2fusion_2BaseVariable__pick(_2457_i0,_2458_i1); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__pick(std::shared_ptr< monty::ndarray< int32_t,2 > > _2461_midxs) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__pick(std::shared_ptr< monty::ndarray< int32_t,2 > > _2461_midxs) { return __mosek_2fusion_2BaseVariable__pick(_2461_midxs); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__pick(std::shared_ptr< monty::ndarray< int32_t,1 > > _2483_idxs) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__pick(std::shared_ptr< monty::ndarray< int32_t,1 > > _2483_idxs) { return __mosek_2fusion_2BaseVariable__pick(_2483_idxs); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__antidiag(int32_t _2494_index) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__antidiag(int32_t _2494_index) { return __mosek_2fusion_2BaseVariable__antidiag(_2494_index); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__antidiag() ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__antidiag() { return __mosek_2fusion_2BaseVariable__antidiag(); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__diag(int32_t _2495_index) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__diag(int32_t _2495_index) { return __mosek_2fusion_2BaseVariable__diag(_2495_index); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__diag() ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__diag() { return __mosek_2fusion_2BaseVariable__diag(); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__general_diag(std::shared_ptr< monty::ndarray< int32_t,1 > > _2496_firstidx,std::shared_ptr< monty::ndarray< int32_t,1 > > _2497_step,int32_t _2498_num) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__slice(std::shared_ptr< monty::ndarray< int32_t,1 > > _2519_first,std::shared_ptr< monty::ndarray< int32_t,1 > > _2520_last) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__slice(std::shared_ptr< monty::ndarray< int32_t,1 > > _2519_first,std::shared_ptr< monty::ndarray< int32_t,1 > > _2520_last) { return __mosek_2fusion_2BaseVariable__slice(_2519_first,_2520_last); }
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__slice(int32_t _2554_first,int32_t _2555_last) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2Variable__slice(int32_t _2554_first,int32_t _2555_last) { return __mosek_2fusion_2BaseVariable__slice(_2554_first,_2555_last); }
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2BaseVariable__asExpr() ;
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2Variable__asExpr() { return __mosek_2fusion_2BaseVariable__asExpr(); }
      virtual int32_t inst(int32_t _2564_spoffset,std::shared_ptr< monty::ndarray< int64_t,1 > > _2565_sparsity,int32_t _2566_nioffset,std::shared_ptr< monty::ndarray< int64_t,1 > > _2567_basevar_nativeidxs) ;
      virtual int32_t numInst() ;
      virtual void inst(int32_t _2572_offset,std::shared_ptr< monty::ndarray< int64_t,1 > > _2573_nindex) ;
      virtual void set_values(std::shared_ptr< monty::ndarray< double,1 > > _2580_values,bool _2581_primal) ;
      virtual void dual_lu(int32_t _2586_offset,std::shared_ptr< monty::ndarray< double,1 > > _2587_target,bool _2588_lower) ;
      virtual void values(int32_t _2591_offset,std::shared_ptr< monty::ndarray< double,1 > > _2592_target,bool _2593_primal) ;
      virtual void make_continuous() ;
      virtual void make_integer() ;
    }; // struct BaseVariable;

    struct p_SliceVariable : public ::mosek::fusion::p_BaseVariable
    {
      SliceVariable * _pubthis;
      static mosek::fusion::p_SliceVariable* _get_impl(mosek::fusion::SliceVariable * _inst){ return static_cast< mosek::fusion::p_SliceVariable* >(mosek::fusion::p_BaseVariable::_get_impl(_inst)); }
      static mosek::fusion::p_SliceVariable * _get_impl(mosek::fusion::SliceVariable::t _inst) { return _get_impl(_inst.get()); }
      p_SliceVariable(SliceVariable * _pubthis);
      virtual ~p_SliceVariable() { /* std::cout << "~p_SliceVariable" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > sparsity{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > nativeidxs{};

      virtual void destroy();

      static SliceVariable::t _new_SliceVariable(monty::rc_ptr< ::mosek::fusion::Model > _2136_m,std::shared_ptr< monty::ndarray< int32_t,1 > > _2137_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _2138_sparsity,std::shared_ptr< monty::ndarray< int64_t,1 > > _2139_nativeidxs);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2136_m,std::shared_ptr< monty::ndarray< int32_t,1 > > _2137_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _2138_sparsity,std::shared_ptr< monty::ndarray< int64_t,1 > > _2139_nativeidxs);
      static SliceVariable::t _new_SliceVariable(monty::rc_ptr< ::mosek::fusion::SliceVariable > _2140_v);
      void _initialize(monty::rc_ptr< ::mosek::fusion::SliceVariable > _2140_v);
    }; // struct SliceVariable;

    struct p_BoundInterfaceVariable : public ::mosek::fusion::p_SliceVariable
    {
      BoundInterfaceVariable * _pubthis;
      static mosek::fusion::p_BoundInterfaceVariable* _get_impl(mosek::fusion::BoundInterfaceVariable * _inst){ return static_cast< mosek::fusion::p_BoundInterfaceVariable* >(mosek::fusion::p_SliceVariable::_get_impl(_inst)); }
      static mosek::fusion::p_BoundInterfaceVariable * _get_impl(mosek::fusion::BoundInterfaceVariable::t _inst) { return _get_impl(_inst.get()); }
      p_BoundInterfaceVariable(BoundInterfaceVariable * _pubthis);
      virtual ~p_BoundInterfaceVariable() { /* std::cout << "~p_BoundInterfaceVariable" << std::endl;*/ };
      bool islower{};

      virtual void destroy();

      static BoundInterfaceVariable::t _new_BoundInterfaceVariable(monty::rc_ptr< ::mosek::fusion::Model > _2110_m,std::shared_ptr< monty::ndarray< int32_t,1 > > _2111_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _2112_sparsity,std::shared_ptr< monty::ndarray< int64_t,1 > > _2113_nativeidxs,bool _2114_islower);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2110_m,std::shared_ptr< monty::ndarray< int32_t,1 > > _2111_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _2112_sparsity,std::shared_ptr< monty::ndarray< int64_t,1 > > _2113_nativeidxs,bool _2114_islower);
      static BoundInterfaceVariable::t _new_BoundInterfaceVariable(monty::rc_ptr< ::mosek::fusion::SliceVariable > _2115_v,bool _2116_islower);
      void _initialize(monty::rc_ptr< ::mosek::fusion::SliceVariable > _2115_v,bool _2116_islower);
      virtual /* override */ std::shared_ptr< monty::ndarray< double,1 > > dual() ;
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BoundInterfaceVariable__transpose() ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__transpose() { return __mosek_2fusion_2BoundInterfaceVariable__transpose(); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BoundInterfaceVariable__pick(std::shared_ptr< monty::ndarray< int32_t,1 > > _2118_i0,std::shared_ptr< monty::ndarray< int32_t,1 > > _2119_i1,std::shared_ptr< monty::ndarray< int32_t,1 > > _2120_i2) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__pick(std::shared_ptr< monty::ndarray< int32_t,1 > > _2118_i0,std::shared_ptr< monty::ndarray< int32_t,1 > > _2119_i1,std::shared_ptr< monty::ndarray< int32_t,1 > > _2120_i2) { return __mosek_2fusion_2BoundInterfaceVariable__pick(_2118_i0,_2119_i1,_2120_i2); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BoundInterfaceVariable__pick(std::shared_ptr< monty::ndarray< int32_t,1 > > _2121_i0,std::shared_ptr< monty::ndarray< int32_t,1 > > _2122_i1) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__pick(std::shared_ptr< monty::ndarray< int32_t,1 > > _2121_i0,std::shared_ptr< monty::ndarray< int32_t,1 > > _2122_i1) { return __mosek_2fusion_2BoundInterfaceVariable__pick(_2121_i0,_2122_i1); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BoundInterfaceVariable__pick(std::shared_ptr< monty::ndarray< int32_t,2 > > _2123_midxs) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__pick(std::shared_ptr< monty::ndarray< int32_t,2 > > _2123_midxs) { return __mosek_2fusion_2BoundInterfaceVariable__pick(_2123_midxs); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BoundInterfaceVariable__pick(std::shared_ptr< monty::ndarray< int32_t,1 > > _2124_idxs) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__pick(std::shared_ptr< monty::ndarray< int32_t,1 > > _2124_idxs) { return __mosek_2fusion_2BoundInterfaceVariable__pick(_2124_idxs); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BoundInterfaceVariable__antidiag(int32_t _2125_index) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__antidiag(int32_t _2125_index) { return __mosek_2fusion_2BoundInterfaceVariable__antidiag(_2125_index); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BoundInterfaceVariable__antidiag() ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__antidiag() { return __mosek_2fusion_2BoundInterfaceVariable__antidiag(); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BoundInterfaceVariable__diag(int32_t _2126_index) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__diag(int32_t _2126_index) { return __mosek_2fusion_2BoundInterfaceVariable__diag(_2126_index); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BoundInterfaceVariable__diag() ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__diag() { return __mosek_2fusion_2BoundInterfaceVariable__diag(); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BoundInterfaceVariable__slice(std::shared_ptr< monty::ndarray< int32_t,1 > > _2127_firsta,std::shared_ptr< monty::ndarray< int32_t,1 > > _2128_lasta) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__slice(std::shared_ptr< monty::ndarray< int32_t,1 > > _2127_firsta,std::shared_ptr< monty::ndarray< int32_t,1 > > _2128_lasta) { return __mosek_2fusion_2BoundInterfaceVariable__slice(_2127_firsta,_2128_lasta); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BoundInterfaceVariable__slice(int32_t _2129_first,int32_t _2130_last) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__slice(int32_t _2129_first,int32_t _2130_last) { return __mosek_2fusion_2BoundInterfaceVariable__slice(_2129_first,_2130_last); }
      virtual monty::rc_ptr< ::mosek::fusion::BoundInterfaceVariable > __mosek_2fusion_2BoundInterfaceVariable__from_(monty::rc_ptr< ::mosek::fusion::Variable > _2131_v) ;
    }; // struct BoundInterfaceVariable;

    struct p_ModelVariable : public ::mosek::fusion::p_BaseVariable
    {
      ModelVariable * _pubthis;
      static mosek::fusion::p_ModelVariable* _get_impl(mosek::fusion::ModelVariable * _inst){ return static_cast< mosek::fusion::p_ModelVariable* >(mosek::fusion::p_BaseVariable::_get_impl(_inst)); }
      static mosek::fusion::p_ModelVariable * _get_impl(mosek::fusion::ModelVariable::t _inst) { return _get_impl(_inst.get()); }
      p_ModelVariable(ModelVariable * _pubthis);
      virtual ~p_ModelVariable() { /* std::cout << "~p_ModelVariable" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< int64_t,1 > > sparsity{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > modelvar_nativeidxs{};
      int64_t varid{};
      std::string name{};

      virtual void destroy();

      static ModelVariable::t _new_ModelVariable(monty::rc_ptr< ::mosek::fusion::ModelVariable > _2246_v,monty::rc_ptr< ::mosek::fusion::Model > _2247_m);
      void _initialize(monty::rc_ptr< ::mosek::fusion::ModelVariable > _2246_v,monty::rc_ptr< ::mosek::fusion::Model > _2247_m);
      static ModelVariable::t _new_ModelVariable(monty::rc_ptr< ::mosek::fusion::Model > _2248_model,const std::string &  _2249_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _2250_shape,int64_t _2251_varid,std::shared_ptr< monty::ndarray< int64_t,1 > > _2252_sparsity,std::shared_ptr< monty::ndarray< int64_t,1 > > _2253_modelvar_nativeidxs);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2248_model,const std::string &  _2249_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _2250_shape,int64_t _2251_varid,std::shared_ptr< monty::ndarray< int64_t,1 > > _2252_sparsity,std::shared_ptr< monty::ndarray< int64_t,1 > > _2253_modelvar_nativeidxs);
      virtual void elementName(int64_t _2254_index,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2255_sb) ;
      virtual /* override */ void remove() ;
      virtual monty::rc_ptr< ::mosek::fusion::ModelVariable > __mosek_2fusion_2ModelVariable__clone(monty::rc_ptr< ::mosek::fusion::Model > _2256_m) { throw monty::AbstractClassError("Call to abstract method"); }
    }; // struct ModelVariable;

    struct p_RangedVariable : public ::mosek::fusion::p_ModelVariable
    {
      RangedVariable * _pubthis;
      static mosek::fusion::p_RangedVariable* _get_impl(mosek::fusion::RangedVariable * _inst){ return static_cast< mosek::fusion::p_RangedVariable* >(mosek::fusion::p_ModelVariable::_get_impl(_inst)); }
      static mosek::fusion::p_RangedVariable * _get_impl(mosek::fusion::RangedVariable::t _inst) { return _get_impl(_inst.get()); }
      p_RangedVariable(RangedVariable * _pubthis);
      virtual ~p_RangedVariable() { /* std::cout << "~p_RangedVariable" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};
      std::string name{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > nativeidxs{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > sparsity{};

      virtual void destroy();

      static RangedVariable::t _new_RangedVariable(monty::rc_ptr< ::mosek::fusion::RangedVariable > _2141_v,monty::rc_ptr< ::mosek::fusion::Model > _2142_m);
      void _initialize(monty::rc_ptr< ::mosek::fusion::RangedVariable > _2141_v,monty::rc_ptr< ::mosek::fusion::Model > _2142_m);
      static RangedVariable::t _new_RangedVariable(monty::rc_ptr< ::mosek::fusion::Model > _2143_model,const std::string &  _2144_name,int64_t _2145_varid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2146_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _2147_sparsity,std::shared_ptr< monty::ndarray< int32_t,1 > > _2148_nativeidxs);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2143_model,const std::string &  _2144_name,int64_t _2145_varid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2146_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _2147_sparsity,std::shared_ptr< monty::ndarray< int32_t,1 > > _2148_nativeidxs);
      virtual monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > __mosek_2fusion_2RangedVariable__elementDesc(int64_t _2149_index,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2150_sb) ;
      virtual void dual_u(int32_t _2151_offset,std::shared_ptr< monty::ndarray< double,1 > > _2152_target) ;
      virtual void dual_l(int32_t _2153_offset,std::shared_ptr< monty::ndarray< double,1 > > _2154_target) ;
      virtual monty::rc_ptr< ::mosek::fusion::BoundInterfaceVariable > __mosek_2fusion_2RangedVariable__upperBoundVar() ;
      virtual monty::rc_ptr< ::mosek::fusion::BoundInterfaceVariable > __mosek_2fusion_2RangedVariable__lowerBoundVar() ;
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::ModelVariable > __mosek_2fusion_2RangedVariable__clone(monty::rc_ptr< ::mosek::fusion::Model > _2157_m) ;
      virtual monty::rc_ptr< ::mosek::fusion::ModelVariable > __mosek_2fusion_2ModelVariable__clone(monty::rc_ptr< ::mosek::fusion::Model > _2157_m) { return __mosek_2fusion_2RangedVariable__clone(_2157_m); }
      static  std::shared_ptr< monty::ndarray< int64_t,1 > > globalNativeIndexes(std::shared_ptr< monty::ndarray< int32_t,1 > > _2158_nativeidxs);
    }; // struct RangedVariable;

    struct p_LinearPSDVariable : public ::mosek::fusion::p_ModelVariable
    {
      LinearPSDVariable * _pubthis;
      static mosek::fusion::p_LinearPSDVariable* _get_impl(mosek::fusion::LinearPSDVariable * _inst){ return static_cast< mosek::fusion::p_LinearPSDVariable* >(mosek::fusion::p_ModelVariable::_get_impl(_inst)); }
      static mosek::fusion::p_LinearPSDVariable * _get_impl(mosek::fusion::LinearPSDVariable::t _inst) { return _get_impl(_inst.get()); }
      p_LinearPSDVariable(LinearPSDVariable * _pubthis);
      virtual ~p_LinearPSDVariable() { /* std::cout << "~p_LinearPSDVariable" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};
      std::string name{};
      int32_t varid{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > nativeidxs{};
      int32_t conedim{};

      virtual void destroy();

      static LinearPSDVariable::t _new_LinearPSDVariable(monty::rc_ptr< ::mosek::fusion::LinearPSDVariable > _2161_v,monty::rc_ptr< ::mosek::fusion::Model > _2162_m);
      void _initialize(monty::rc_ptr< ::mosek::fusion::LinearPSDVariable > _2161_v,monty::rc_ptr< ::mosek::fusion::Model > _2162_m);
      static LinearPSDVariable::t _new_LinearPSDVariable(monty::rc_ptr< ::mosek::fusion::Model > _2163_model,const std::string &  _2164_name,int32_t _2165_varid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2166_shape,int32_t _2167_conedim,std::shared_ptr< monty::ndarray< int64_t,1 > > _2168_nativeidxs);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2163_model,const std::string &  _2164_name,int32_t _2165_varid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2166_shape,int32_t _2167_conedim,std::shared_ptr< monty::ndarray< int64_t,1 > > _2168_nativeidxs);
      virtual /* override */ std::string toString() ;
      virtual void make_continuous(std::shared_ptr< monty::ndarray< int64_t,1 > > _2171_idxs) ;
      virtual void make_integer(std::shared_ptr< monty::ndarray< int64_t,1 > > _2172_idxs) ;
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::ModelVariable > __mosek_2fusion_2LinearPSDVariable__clone(monty::rc_ptr< ::mosek::fusion::Model > _2173_m) ;
      virtual monty::rc_ptr< ::mosek::fusion::ModelVariable > __mosek_2fusion_2ModelVariable__clone(monty::rc_ptr< ::mosek::fusion::Model > _2173_m) { return __mosek_2fusion_2LinearPSDVariable__clone(_2173_m); }
      static  std::shared_ptr< monty::ndarray< int64_t,1 > > globalNativeIndexes(std::shared_ptr< monty::ndarray< int64_t,1 > > _2174_nativeidxs);
    }; // struct LinearPSDVariable;

    struct p_PSDVariable : public ::mosek::fusion::p_ModelVariable
    {
      PSDVariable * _pubthis;
      static mosek::fusion::p_PSDVariable* _get_impl(mosek::fusion::PSDVariable * _inst){ return static_cast< mosek::fusion::p_PSDVariable* >(mosek::fusion::p_ModelVariable::_get_impl(_inst)); }
      static mosek::fusion::p_PSDVariable * _get_impl(mosek::fusion::PSDVariable::t _inst) { return _get_impl(_inst.get()); }
      p_PSDVariable(PSDVariable * _pubthis);
      virtual ~p_PSDVariable() { /* std::cout << "~p_PSDVariable" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Model > model{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > barvaridxs{};
      int32_t conedim2{};
      int32_t conedim1{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};
      std::string name{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > nativeidxs{};
      int32_t varid{};

      virtual void destroy();

      static PSDVariable::t _new_PSDVariable(monty::rc_ptr< ::mosek::fusion::PSDVariable > _2176_v,monty::rc_ptr< ::mosek::fusion::Model > _2177_m);
      void _initialize(monty::rc_ptr< ::mosek::fusion::PSDVariable > _2176_v,monty::rc_ptr< ::mosek::fusion::Model > _2177_m);
      static PSDVariable::t _new_PSDVariable(monty::rc_ptr< ::mosek::fusion::Model > _2178_model,const std::string &  _2179_name,int32_t _2180_varid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2181_shape,int32_t _2182_conedim1,int32_t _2183_conedim2,std::shared_ptr< monty::ndarray< int32_t,1 > > _2184_barvaridxs,std::shared_ptr< monty::ndarray< int64_t,1 > > _2185_nativeidxs);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2178_model,const std::string &  _2179_name,int32_t _2180_varid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2181_shape,int32_t _2182_conedim1,int32_t _2183_conedim2,std::shared_ptr< monty::ndarray< int32_t,1 > > _2184_barvaridxs,std::shared_ptr< monty::ndarray< int64_t,1 > > _2185_nativeidxs);
      virtual /* override */ std::string toString() ;
      virtual monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > __mosek_2fusion_2PSDVariable__elementDesc(int64_t _2188_index,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2189_sb) ;
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::ModelVariable > __mosek_2fusion_2PSDVariable__clone(monty::rc_ptr< ::mosek::fusion::Model > _2190_m) ;
      virtual monty::rc_ptr< ::mosek::fusion::ModelVariable > __mosek_2fusion_2ModelVariable__clone(monty::rc_ptr< ::mosek::fusion::Model > _2190_m) { return __mosek_2fusion_2PSDVariable__clone(_2190_m); }
      static  std::shared_ptr< monty::ndarray< int64_t,1 > > fullnativeidxs(std::shared_ptr< monty::ndarray< int32_t,1 > > _2191_shape,int32_t _2192_conedim1,int32_t _2193_conedim2,std::shared_ptr< monty::ndarray< int64_t,1 > > _2194_nativeidxs);
    }; // struct PSDVariable;

    struct p_LinearVariable : public ::mosek::fusion::p_ModelVariable
    {
      LinearVariable * _pubthis;
      static mosek::fusion::p_LinearVariable* _get_impl(mosek::fusion::LinearVariable * _inst){ return static_cast< mosek::fusion::p_LinearVariable* >(mosek::fusion::p_ModelVariable::_get_impl(_inst)); }
      static mosek::fusion::p_LinearVariable * _get_impl(mosek::fusion::LinearVariable::t _inst) { return _get_impl(_inst.get()); }
      p_LinearVariable(LinearVariable * _pubthis);
      virtual ~p_LinearVariable() { /* std::cout << "~p_LinearVariable" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > sparsity{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > nativeidxs{};
      std::string name{};

      virtual void destroy();

      static LinearVariable::t _new_LinearVariable(monty::rc_ptr< ::mosek::fusion::LinearVariable > _2219_v,monty::rc_ptr< ::mosek::fusion::Model > _2220_m);
      void _initialize(monty::rc_ptr< ::mosek::fusion::LinearVariable > _2219_v,monty::rc_ptr< ::mosek::fusion::Model > _2220_m);
      static LinearVariable::t _new_LinearVariable(monty::rc_ptr< ::mosek::fusion::Model > _2221_model,const std::string &  _2222_name,int64_t _2223_varid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2224_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _2225_sparsity,std::shared_ptr< monty::ndarray< int32_t,1 > > _2226_nativeidxs);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2221_model,const std::string &  _2222_name,int64_t _2223_varid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2224_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _2225_sparsity,std::shared_ptr< monty::ndarray< int32_t,1 > > _2226_nativeidxs);
      virtual /* override */ std::string toString() ;
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::ModelVariable > __mosek_2fusion_2LinearVariable__clone(monty::rc_ptr< ::mosek::fusion::Model > _2229_m) ;
      virtual monty::rc_ptr< ::mosek::fusion::ModelVariable > __mosek_2fusion_2ModelVariable__clone(monty::rc_ptr< ::mosek::fusion::Model > _2229_m) { return __mosek_2fusion_2LinearVariable__clone(_2229_m); }
      static  std::shared_ptr< monty::ndarray< int64_t,1 > > globalNativeIndexes(std::shared_ptr< monty::ndarray< int32_t,1 > > _2230_nativeidxs);
    }; // struct LinearVariable;

    struct p_ConicVariable : public ::mosek::fusion::p_ModelVariable
    {
      ConicVariable * _pubthis;
      static mosek::fusion::p_ConicVariable* _get_impl(mosek::fusion::ConicVariable * _inst){ return static_cast< mosek::fusion::p_ConicVariable* >(mosek::fusion::p_ModelVariable::_get_impl(_inst)); }
      static mosek::fusion::p_ConicVariable * _get_impl(mosek::fusion::ConicVariable::t _inst) { return _get_impl(_inst.get()); }
      p_ConicVariable(ConicVariable * _pubthis);
      virtual ~p_ConicVariable() { /* std::cout << "~p_ConicVariable" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< int32_t,1 > > nativeidxs{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};
      std::string name{};
      int32_t varid{};

      virtual void destroy();

      static ConicVariable::t _new_ConicVariable(monty::rc_ptr< ::mosek::fusion::ConicVariable > _2233_v,monty::rc_ptr< ::mosek::fusion::Model > _2234_m);
      void _initialize(monty::rc_ptr< ::mosek::fusion::ConicVariable > _2233_v,monty::rc_ptr< ::mosek::fusion::Model > _2234_m);
      static ConicVariable::t _new_ConicVariable(monty::rc_ptr< ::mosek::fusion::Model > _2235_model,const std::string &  _2236_name,int32_t _2237_varid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2238_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _2239_nativeidxs);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2235_model,const std::string &  _2236_name,int32_t _2237_varid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2238_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _2239_nativeidxs);
      virtual /* override */ std::string toString() ;
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::ModelVariable > __mosek_2fusion_2ConicVariable__clone(monty::rc_ptr< ::mosek::fusion::Model > _2242_m) ;
      virtual monty::rc_ptr< ::mosek::fusion::ModelVariable > __mosek_2fusion_2ModelVariable__clone(monty::rc_ptr< ::mosek::fusion::Model > _2242_m) { return __mosek_2fusion_2ConicVariable__clone(_2242_m); }
      static  std::shared_ptr< monty::ndarray< int64_t,1 > > globalNativeIndexes(std::shared_ptr< monty::ndarray< int32_t,1 > > _2243_nativeidxs);
    }; // struct ConicVariable;

    struct p_NilVariable : public ::mosek::fusion::p_BaseVariable
    {
      NilVariable * _pubthis;
      static mosek::fusion::p_NilVariable* _get_impl(mosek::fusion::NilVariable * _inst){ return static_cast< mosek::fusion::p_NilVariable* >(mosek::fusion::p_BaseVariable::_get_impl(_inst)); }
      static mosek::fusion::p_NilVariable * _get_impl(mosek::fusion::NilVariable::t _inst) { return _get_impl(_inst.get()); }
      p_NilVariable(NilVariable * _pubthis);
      virtual ~p_NilVariable() { /* std::cout << "~p_NilVariable" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};

      virtual void destroy();

      static NilVariable::t _new_NilVariable(std::shared_ptr< monty::ndarray< int32_t,1 > > _2257_shape);
      void _initialize(std::shared_ptr< monty::ndarray< int32_t,1 > > _2257_shape);
      static NilVariable::t _new_NilVariable();
      void _initialize();
      virtual monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > __mosek_2fusion_2NilVariable__elementDesc(int64_t _2259_index,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2260_sb) ;
      virtual void elementName(int64_t _2261_index,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2262_sb) ;
      virtual /* override */ int32_t numInst() ;
      virtual int32_t inst(int32_t _2263_offset,std::shared_ptr< monty::ndarray< int64_t,1 > > _2264_sparsity,std::shared_ptr< monty::ndarray< int64_t,1 > > _2265_basevar_nativeidxs) ;
      virtual /* override */ void inst(int32_t _2266_offset,std::shared_ptr< monty::ndarray< int64_t,1 > > _2267_nindex) ;
      virtual /* override */ void set_values(std::shared_ptr< monty::ndarray< double,1 > > _2268_target,bool _2269_primal) ;
      virtual /* override */ void values(int32_t _2270_offset,std::shared_ptr< monty::ndarray< double,1 > > _2271_target,bool _2272_primal) ;
      virtual /* override */ void make_continuous() ;
      virtual /* override */ void make_integer() ;
      virtual /* override */ std::string toString() ;
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2NilVariable__index(std::shared_ptr< monty::ndarray< int32_t,1 > > _2273_first) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__index(std::shared_ptr< monty::ndarray< int32_t,1 > > _2273_first) { return __mosek_2fusion_2NilVariable__index(_2273_first); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2NilVariable__index(int32_t _2275_first) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__index(int32_t _2275_first) { return __mosek_2fusion_2NilVariable__index(_2275_first); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2NilVariable__slice(std::shared_ptr< monty::ndarray< int32_t,1 > > _2277_first,std::shared_ptr< monty::ndarray< int32_t,1 > > _2278_last) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__slice(std::shared_ptr< monty::ndarray< int32_t,1 > > _2277_first,std::shared_ptr< monty::ndarray< int32_t,1 > > _2278_last) { return __mosek_2fusion_2NilVariable__slice(_2277_first,_2278_last); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2NilVariable__slice(int32_t _2281_first,int32_t _2282_last) ;
      virtual monty::rc_ptr< ::mosek::fusion::Variable > __mosek_2fusion_2BaseVariable__slice(int32_t _2281_first,int32_t _2282_last) { return __mosek_2fusion_2NilVariable__slice(_2281_first,_2282_last); }
    }; // struct NilVariable;

    struct p_Var
    {
      Var * _pubthis;
      static mosek::fusion::p_Var* _get_impl(mosek::fusion::Var * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_Var * _get_impl(mosek::fusion::Var::t _inst) { return _get_impl(_inst.get()); }
      p_Var(Var * _pubthis);
      virtual ~p_Var() { /* std::cout << "~p_Var" << std::endl;*/ };

      virtual void destroy();

      static  monty::rc_ptr< ::mosek::fusion::Variable > empty(std::shared_ptr< monty::ndarray< int32_t,1 > > _2636_shape);
      static  monty::rc_ptr< ::mosek::fusion::Variable > compress(monty::rc_ptr< ::mosek::fusion::Variable > _2638_v);
      static  monty::rc_ptr< ::mosek::fusion::Variable > reshape(monty::rc_ptr< ::mosek::fusion::Variable > _2646_v,int32_t _2647_d1);
      static  monty::rc_ptr< ::mosek::fusion::Variable > reshape(monty::rc_ptr< ::mosek::fusion::Variable > _2648_v,int32_t _2649_d1,int32_t _2650_d2);
      static  monty::rc_ptr< ::mosek::fusion::Variable > flatten(monty::rc_ptr< ::mosek::fusion::Variable > _2651_v);
      static  monty::rc_ptr< ::mosek::fusion::Variable > reshape(monty::rc_ptr< ::mosek::fusion::Variable > _2652_v,std::shared_ptr< monty::ndarray< int32_t,1 > > _2653_shape);
      static  monty::rc_ptr< ::mosek::fusion::Variable > index_permute_(monty::rc_ptr< ::mosek::fusion::Variable > _2654_v,std::shared_ptr< monty::ndarray< int32_t,1 > > _2655_perm);
      static  monty::rc_ptr< ::mosek::fusion::Variable > hrepeat(monty::rc_ptr< ::mosek::fusion::Variable > _2684_v,int32_t _2685_n);
      static  monty::rc_ptr< ::mosek::fusion::Variable > vrepeat(monty::rc_ptr< ::mosek::fusion::Variable > _2686_v,int32_t _2687_n);
      static  monty::rc_ptr< ::mosek::fusion::Variable > repeat(monty::rc_ptr< ::mosek::fusion::Variable > _2688_v,int32_t _2689_n);
      static  monty::rc_ptr< ::mosek::fusion::Variable > repeat(monty::rc_ptr< ::mosek::fusion::Variable > _2690_v,int32_t _2691_n,int32_t _2692_dim);
      static  monty::rc_ptr< ::mosek::fusion::Variable > drepeat(monty::rc_ptr< ::mosek::fusion::Variable > _2693_v,int32_t _2694_dim,int32_t _2695_n);
      static  monty::rc_ptr< ::mosek::fusion::Variable > stack(std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > >,1 > > _2765_vlist);
      static  monty::rc_ptr< ::mosek::fusion::Variable > vstack(monty::rc_ptr< ::mosek::fusion::Variable > _2767_v1,monty::rc_ptr< ::mosek::fusion::Variable > _2768_v2,monty::rc_ptr< ::mosek::fusion::Variable > _2769_v3);
      static  monty::rc_ptr< ::mosek::fusion::Variable > vstack(monty::rc_ptr< ::mosek::fusion::Variable > _2770_v1,monty::rc_ptr< ::mosek::fusion::Variable > _2771_v2);
      static  monty::rc_ptr< ::mosek::fusion::Variable > vstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _2772_v);
      static  monty::rc_ptr< ::mosek::fusion::Variable > hstack(monty::rc_ptr< ::mosek::fusion::Variable > _2773_v1,monty::rc_ptr< ::mosek::fusion::Variable > _2774_v2,monty::rc_ptr< ::mosek::fusion::Variable > _2775_v3);
      static  monty::rc_ptr< ::mosek::fusion::Variable > hstack(monty::rc_ptr< ::mosek::fusion::Variable > _2776_v1,monty::rc_ptr< ::mosek::fusion::Variable > _2777_v2);
      static  monty::rc_ptr< ::mosek::fusion::Variable > hstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _2778_v);
      static  monty::rc_ptr< ::mosek::fusion::Variable > stack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _2779_v,int32_t _2780_dim);
      static  monty::rc_ptr< ::mosek::fusion::Variable > stack(monty::rc_ptr< ::mosek::fusion::Variable > _2781_v1,monty::rc_ptr< ::mosek::fusion::Variable > _2782_v2,monty::rc_ptr< ::mosek::fusion::Variable > _2783_v3,int32_t _2784_dim);
      static  monty::rc_ptr< ::mosek::fusion::Variable > stack(monty::rc_ptr< ::mosek::fusion::Variable > _2785_v1,monty::rc_ptr< ::mosek::fusion::Variable > _2786_v2,int32_t _2787_dim);
      static  monty::rc_ptr< ::mosek::fusion::Variable > stack(int32_t _2788_dim,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _2789_v);
      static  monty::rc_ptr< ::mosek::fusion::Variable > stack(int32_t _2792_dim,monty::rc_ptr< ::mosek::fusion::Variable > _2793_v1,monty::rc_ptr< ::mosek::fusion::Variable > _2794_v2,monty::rc_ptr< ::mosek::fusion::Variable > _2795_v3);
      static  monty::rc_ptr< ::mosek::fusion::Variable > stack(int32_t _2796_dim,monty::rc_ptr< ::mosek::fusion::Variable > _2797_v1,monty::rc_ptr< ::mosek::fusion::Variable > _2798_v2);
      static  monty::rc_ptr< ::mosek::fusion::Variable > promote(monty::rc_ptr< ::mosek::fusion::Variable > _2799_v,int32_t _2800_nd);
      static  monty::rc_ptr< ::mosek::fusion::Variable > dstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _2805_v,int32_t _2806_dim);
    }; // struct Var;

    struct p_Constraint
    {
      Constraint * _pubthis;
      static mosek::fusion::p_Constraint* _get_impl(mosek::fusion::Constraint * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_Constraint * _get_impl(mosek::fusion::Constraint::t _inst) { return _get_impl(_inst.get()); }
      p_Constraint(Constraint * _pubthis);
      virtual ~p_Constraint() { /* std::cout << "~p_Constraint" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< int32_t,1 > > con_nativeidxs{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};
      monty::rc_ptr< ::mosek::fusion::Model > model{};

      virtual void destroy();

      static Constraint::t _new_Constraint(monty::rc_ptr< ::mosek::fusion::Constraint > _2997_c,monty::rc_ptr< ::mosek::fusion::Model > _2998_m);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Constraint > _2997_c,monty::rc_ptr< ::mosek::fusion::Model > _2998_m);
      static Constraint::t _new_Constraint(monty::rc_ptr< ::mosek::fusion::Model > _2999_model,std::shared_ptr< monty::ndarray< int32_t,1 > > _3000_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _3001_con_nativeidxs);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2999_model,std::shared_ptr< monty::ndarray< int32_t,1 > > _3000_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _3001_con_nativeidxs);
      virtual /* override */ std::string toString() ;
      virtual void toStringArray(std::shared_ptr< monty::ndarray< int64_t,1 > > _3002_subi,int64_t _3003_dstidx,std::shared_ptr< monty::ndarray< std::string,1 > > _3004_result) ;
      virtual void dual_lu(int32_t _3005_offset,std::shared_ptr< monty::ndarray< double,1 > > _3006_target,bool _3007_islower) ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > dual() ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > level() ;
      virtual void values(bool _3010_primal,int32_t _3011_offset,std::shared_ptr< monty::ndarray< double,1 > > _3012_target) ;
      virtual void remove() ;
      virtual void update(std::shared_ptr< monty::ndarray< double,1 > > _3013_bfix) ;
      virtual void update(monty::rc_ptr< ::mosek::fusion::Expression > _3014_expr) ;
      virtual void update(monty::rc_ptr< ::mosek::fusion::Expression > _3018_expr,monty::rc_ptr< ::mosek::fusion::Variable > _3019_x,bool _3020_bfixupdate) ;
      virtual void update(monty::rc_ptr< ::mosek::fusion::Expression > _3040_expr,monty::rc_ptr< ::mosek::fusion::Variable > _3041_x) ;
      virtual monty::rc_ptr< ::mosek::fusion::Model > __mosek_2fusion_2Constraint__get_model() ;
      virtual int32_t get_nd() ;
      virtual int64_t size() ;
      static  monty::rc_ptr< ::mosek::fusion::Constraint > stack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Constraint >,1 > > _3044_clist,int32_t _3045_dim);
      static  monty::rc_ptr< ::mosek::fusion::Constraint > stack(monty::rc_ptr< ::mosek::fusion::Constraint > _3046_v1,monty::rc_ptr< ::mosek::fusion::Constraint > _3047_v2,monty::rc_ptr< ::mosek::fusion::Constraint > _3048_v3,int32_t _3049_dim);
      static  monty::rc_ptr< ::mosek::fusion::Constraint > stack(monty::rc_ptr< ::mosek::fusion::Constraint > _3050_v1,monty::rc_ptr< ::mosek::fusion::Constraint > _3051_v2,int32_t _3052_dim);
      static  monty::rc_ptr< ::mosek::fusion::Constraint > hstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Constraint >,1 > > _3053_clist);
      static  monty::rc_ptr< ::mosek::fusion::Constraint > vstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Constraint >,1 > > _3054_clist);
      static  monty::rc_ptr< ::mosek::fusion::Constraint > hstack(monty::rc_ptr< ::mosek::fusion::Constraint > _3055_v1,monty::rc_ptr< ::mosek::fusion::Constraint > _3056_v2,monty::rc_ptr< ::mosek::fusion::Constraint > _3057_v3);
      static  monty::rc_ptr< ::mosek::fusion::Constraint > vstack(monty::rc_ptr< ::mosek::fusion::Constraint > _3058_v1,monty::rc_ptr< ::mosek::fusion::Constraint > _3059_v2,monty::rc_ptr< ::mosek::fusion::Constraint > _3060_v3);
      static  monty::rc_ptr< ::mosek::fusion::Constraint > hstack(monty::rc_ptr< ::mosek::fusion::Constraint > _3061_v1,monty::rc_ptr< ::mosek::fusion::Constraint > _3062_v2);
      static  monty::rc_ptr< ::mosek::fusion::Constraint > vstack(monty::rc_ptr< ::mosek::fusion::Constraint > _3063_v1,monty::rc_ptr< ::mosek::fusion::Constraint > _3064_v2);
      static  monty::rc_ptr< ::mosek::fusion::Constraint > dstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Constraint >,1 > > _3065_c,int32_t _3066_dim);
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Constraint__index(std::shared_ptr< monty::ndarray< int32_t,1 > > _3117_idxa) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Constraint__index(int32_t _3124_idx) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Constraint__slice(std::shared_ptr< monty::ndarray< int32_t,1 > > _3125_firsta,std::shared_ptr< monty::ndarray< int32_t,1 > > _3126_lasta) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Constraint__slice(int32_t _3145_first,int32_t _3146_last) ;
      virtual int32_t getND() ;
      virtual int32_t getSize() ;
      virtual monty::rc_ptr< ::mosek::fusion::Model > __mosek_2fusion_2Constraint__getModel() ;
      virtual std::shared_ptr< monty::ndarray< int32_t,1 > > getShape() ;
      virtual std::shared_ptr< monty::ndarray< int32_t,1 > > getNativeidxs() ;
    }; // struct Constraint;

    struct p_SliceConstraint : public ::mosek::fusion::p_Constraint
    {
      SliceConstraint * _pubthis;
      static mosek::fusion::p_SliceConstraint* _get_impl(mosek::fusion::SliceConstraint * _inst){ return static_cast< mosek::fusion::p_SliceConstraint* >(mosek::fusion::p_Constraint::_get_impl(_inst)); }
      static mosek::fusion::p_SliceConstraint * _get_impl(mosek::fusion::SliceConstraint::t _inst) { return _get_impl(_inst.get()); }
      p_SliceConstraint(SliceConstraint * _pubthis);
      virtual ~p_SliceConstraint() { /* std::cout << "~p_SliceConstraint" << std::endl;*/ };

      virtual void destroy();

      static SliceConstraint::t _new_SliceConstraint(monty::rc_ptr< ::mosek::fusion::SliceConstraint > _2949_c);
      void _initialize(monty::rc_ptr< ::mosek::fusion::SliceConstraint > _2949_c);
      static SliceConstraint::t _new_SliceConstraint(monty::rc_ptr< ::mosek::fusion::Model > _2950_model,std::shared_ptr< monty::ndarray< int32_t,1 > > _2951_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _2952_nativeidxs);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2950_model,std::shared_ptr< monty::ndarray< int32_t,1 > > _2951_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _2952_nativeidxs);
      virtual /* override */ std::string toString() ;
    }; // struct SliceConstraint;

    struct p_BoundInterfaceConstraint : public ::mosek::fusion::p_SliceConstraint
    {
      BoundInterfaceConstraint * _pubthis;
      static mosek::fusion::p_BoundInterfaceConstraint* _get_impl(mosek::fusion::BoundInterfaceConstraint * _inst){ return static_cast< mosek::fusion::p_BoundInterfaceConstraint* >(mosek::fusion::p_SliceConstraint::_get_impl(_inst)); }
      static mosek::fusion::p_BoundInterfaceConstraint * _get_impl(mosek::fusion::BoundInterfaceConstraint::t _inst) { return _get_impl(_inst.get()); }
      p_BoundInterfaceConstraint(BoundInterfaceConstraint * _pubthis);
      virtual ~p_BoundInterfaceConstraint() { /* std::cout << "~p_BoundInterfaceConstraint" << std::endl;*/ };
      bool islower{};

      virtual void destroy();

      static BoundInterfaceConstraint::t _new_BoundInterfaceConstraint(monty::rc_ptr< ::mosek::fusion::Model > _2875_m,std::shared_ptr< monty::ndarray< int32_t,1 > > _2876_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _2877_nativeidxs,bool _2878_islower);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2875_m,std::shared_ptr< monty::ndarray< int32_t,1 > > _2876_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _2877_nativeidxs,bool _2878_islower);
      static BoundInterfaceConstraint::t _new_BoundInterfaceConstraint(monty::rc_ptr< ::mosek::fusion::SliceConstraint > _2879_c,bool _2880_islower);
      void _initialize(monty::rc_ptr< ::mosek::fusion::SliceConstraint > _2879_c,bool _2880_islower);
      virtual /* override */ std::shared_ptr< monty::ndarray< double,1 > > dual() ;
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2BoundInterfaceConstraint__slice(std::shared_ptr< monty::ndarray< int32_t,1 > > _2882_firsta,std::shared_ptr< monty::ndarray< int32_t,1 > > _2883_lasta) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Constraint__slice(std::shared_ptr< monty::ndarray< int32_t,1 > > _2882_firsta,std::shared_ptr< monty::ndarray< int32_t,1 > > _2883_lasta) { return __mosek_2fusion_2BoundInterfaceConstraint__slice(_2882_firsta,_2883_lasta); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2BoundInterfaceConstraint__slice(int32_t _2885_first,int32_t _2886_last) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Constraint__slice(int32_t _2885_first,int32_t _2886_last) { return __mosek_2fusion_2BoundInterfaceConstraint__slice(_2885_first,_2886_last); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2BoundInterfaceConstraint__index(std::shared_ptr< monty::ndarray< int32_t,1 > > _2888_idxa) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Constraint__index(std::shared_ptr< monty::ndarray< int32_t,1 > > _2888_idxa) { return __mosek_2fusion_2BoundInterfaceConstraint__index(_2888_idxa); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2BoundInterfaceConstraint__index(int32_t _2890_idx) ;
      virtual monty::rc_ptr< ::mosek::fusion::Constraint > __mosek_2fusion_2Constraint__index(int32_t _2890_idx) { return __mosek_2fusion_2BoundInterfaceConstraint__index(_2890_idx); }
      virtual monty::rc_ptr< ::mosek::fusion::BoundInterfaceConstraint > __mosek_2fusion_2BoundInterfaceConstraint__from_(monty::rc_ptr< ::mosek::fusion::Constraint > _2892_c) ;
    }; // struct BoundInterfaceConstraint;

    struct p_ModelConstraint : public ::mosek::fusion::p_Constraint
    {
      ModelConstraint * _pubthis;
      static mosek::fusion::p_ModelConstraint* _get_impl(mosek::fusion::ModelConstraint * _inst){ return static_cast< mosek::fusion::p_ModelConstraint* >(mosek::fusion::p_Constraint::_get_impl(_inst)); }
      static mosek::fusion::p_ModelConstraint * _get_impl(mosek::fusion::ModelConstraint::t _inst) { return _get_impl(_inst.get()); }
      p_ModelConstraint(ModelConstraint * _pubthis);
      virtual ~p_ModelConstraint() { /* std::cout << "~p_ModelConstraint" << std::endl;*/ };
      int32_t conid{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > modelcon_nativeidxs{};
      std::string name{};

      virtual void destroy();

      static ModelConstraint::t _new_ModelConstraint(monty::rc_ptr< ::mosek::fusion::ModelConstraint > _2988_c,monty::rc_ptr< ::mosek::fusion::Model > _2989_m);
      void _initialize(monty::rc_ptr< ::mosek::fusion::ModelConstraint > _2988_c,monty::rc_ptr< ::mosek::fusion::Model > _2989_m);
      static ModelConstraint::t _new_ModelConstraint(monty::rc_ptr< ::mosek::fusion::Model > _2990_model,const std::string &  _2991_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _2992_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _2993_nidxs,int32_t _2994_conid);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2990_model,const std::string &  _2991_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _2992_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _2993_nidxs,int32_t _2994_conid);
      virtual /* override */ std::string toString() ;
      virtual monty::rc_ptr< ::mosek::fusion::ModelConstraint > __mosek_2fusion_2ModelConstraint__clone(monty::rc_ptr< ::mosek::fusion::Model > _2996_m) { throw monty::AbstractClassError("Call to abstract method"); }
      virtual /* override */ void remove() ;
    }; // struct ModelConstraint;

    struct p_LinearPSDConstraint : public ::mosek::fusion::p_ModelConstraint
    {
      LinearPSDConstraint * _pubthis;
      static mosek::fusion::p_LinearPSDConstraint* _get_impl(mosek::fusion::LinearPSDConstraint * _inst){ return static_cast< mosek::fusion::p_LinearPSDConstraint* >(mosek::fusion::p_ModelConstraint::_get_impl(_inst)); }
      static mosek::fusion::p_LinearPSDConstraint * _get_impl(mosek::fusion::LinearPSDConstraint::t _inst) { return _get_impl(_inst.get()); }
      p_LinearPSDConstraint(LinearPSDConstraint * _pubthis);
      virtual ~p_LinearPSDConstraint() { /* std::cout << "~p_LinearPSDConstraint" << std::endl;*/ };
      int32_t conedim{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};
      int32_t conid{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > slackidxs{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > nativeidxs{};

      virtual void destroy();

      static LinearPSDConstraint::t _new_LinearPSDConstraint(monty::rc_ptr< ::mosek::fusion::LinearPSDConstraint > _2895_c,monty::rc_ptr< ::mosek::fusion::Model > _2896_m);
      void _initialize(monty::rc_ptr< ::mosek::fusion::LinearPSDConstraint > _2895_c,monty::rc_ptr< ::mosek::fusion::Model > _2896_m);
      static LinearPSDConstraint::t _new_LinearPSDConstraint(monty::rc_ptr< ::mosek::fusion::Model > _2897_model,const std::string &  _2898_name,int32_t _2899_conid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2900_shape,int32_t _2901_conedim,std::shared_ptr< monty::ndarray< int32_t,1 > > _2902_nativeidxs,std::shared_ptr< monty::ndarray< int64_t,1 > > _2903_slackidxs);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2897_model,const std::string &  _2898_name,int32_t _2899_conid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2900_shape,int32_t _2901_conedim,std::shared_ptr< monty::ndarray< int32_t,1 > > _2902_nativeidxs,std::shared_ptr< monty::ndarray< int64_t,1 > > _2903_slackidxs);
      virtual void domainToString(int64_t _2904_i,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2905_sb) ;
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::ModelConstraint > __mosek_2fusion_2LinearPSDConstraint__clone(monty::rc_ptr< ::mosek::fusion::Model > _2909_m) ;
      virtual monty::rc_ptr< ::mosek::fusion::ModelConstraint > __mosek_2fusion_2ModelConstraint__clone(monty::rc_ptr< ::mosek::fusion::Model > _2909_m) { return __mosek_2fusion_2LinearPSDConstraint__clone(_2909_m); }
    }; // struct LinearPSDConstraint;

    struct p_PSDConstraint : public ::mosek::fusion::p_ModelConstraint
    {
      PSDConstraint * _pubthis;
      static mosek::fusion::p_PSDConstraint* _get_impl(mosek::fusion::PSDConstraint * _inst){ return static_cast< mosek::fusion::p_PSDConstraint* >(mosek::fusion::p_ModelConstraint::_get_impl(_inst)); }
      static mosek::fusion::p_PSDConstraint * _get_impl(mosek::fusion::PSDConstraint::t _inst) { return _get_impl(_inst.get()); }
      p_PSDConstraint(PSDConstraint * _pubthis);
      virtual ~p_PSDConstraint() { /* std::cout << "~p_PSDConstraint" << std::endl;*/ };
      int32_t conedim1{};
      int32_t conedim0{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};
      std::string name{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > slackidxs{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > nativeidxs{};
      int32_t conid{};

      virtual void destroy();

      static PSDConstraint::t _new_PSDConstraint(monty::rc_ptr< ::mosek::fusion::PSDConstraint > _2910_c,monty::rc_ptr< ::mosek::fusion::Model > _2911_m);
      void _initialize(monty::rc_ptr< ::mosek::fusion::PSDConstraint > _2910_c,monty::rc_ptr< ::mosek::fusion::Model > _2911_m);
      static PSDConstraint::t _new_PSDConstraint(monty::rc_ptr< ::mosek::fusion::Model > _2912_model,const std::string &  _2913_name,int32_t _2914_conid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2915_shape,int32_t _2916_conedim0,int32_t _2917_conedim1,std::shared_ptr< monty::ndarray< int64_t,1 > > _2918_slackidxs,std::shared_ptr< monty::ndarray< int32_t,1 > > _2919_nativeidxs);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2912_model,const std::string &  _2913_name,int32_t _2914_conid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2915_shape,int32_t _2916_conedim0,int32_t _2917_conedim1,std::shared_ptr< monty::ndarray< int64_t,1 > > _2918_slackidxs,std::shared_ptr< monty::ndarray< int32_t,1 > > _2919_nativeidxs);
      virtual /* override */ std::string toString() ;
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::ModelConstraint > __mosek_2fusion_2PSDConstraint__clone(monty::rc_ptr< ::mosek::fusion::Model > _2920_m) ;
      virtual monty::rc_ptr< ::mosek::fusion::ModelConstraint > __mosek_2fusion_2ModelConstraint__clone(monty::rc_ptr< ::mosek::fusion::Model > _2920_m) { return __mosek_2fusion_2PSDConstraint__clone(_2920_m); }
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > computenidxs(std::shared_ptr< monty::ndarray< int32_t,1 > > _2921_shape,int32_t _2922_d0,int32_t _2923_d1,std::shared_ptr< monty::ndarray< int32_t,1 > > _2924_nativeidxs);
    }; // struct PSDConstraint;

    struct p_RangedConstraint : public ::mosek::fusion::p_ModelConstraint
    {
      RangedConstraint * _pubthis;
      static mosek::fusion::p_RangedConstraint* _get_impl(mosek::fusion::RangedConstraint * _inst){ return static_cast< mosek::fusion::p_RangedConstraint* >(mosek::fusion::p_ModelConstraint::_get_impl(_inst)); }
      static mosek::fusion::p_RangedConstraint * _get_impl(mosek::fusion::RangedConstraint::t _inst) { return _get_impl(_inst.get()); }
      p_RangedConstraint(RangedConstraint * _pubthis);
      virtual ~p_RangedConstraint() { /* std::cout << "~p_RangedConstraint" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< int32_t,1 > > nativeidxs{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};

      virtual void destroy();

      static RangedConstraint::t _new_RangedConstraint(monty::rc_ptr< ::mosek::fusion::RangedConstraint > _2954_c,monty::rc_ptr< ::mosek::fusion::Model > _2955_m);
      void _initialize(monty::rc_ptr< ::mosek::fusion::RangedConstraint > _2954_c,monty::rc_ptr< ::mosek::fusion::Model > _2955_m);
      static RangedConstraint::t _new_RangedConstraint(monty::rc_ptr< ::mosek::fusion::Model > _2956_model,const std::string &  _2957_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _2958_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _2959_nativeidxs,int32_t _2960_conid);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2956_model,const std::string &  _2957_name,std::shared_ptr< monty::ndarray< int32_t,1 > > _2958_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _2959_nativeidxs,int32_t _2960_conid);
      virtual monty::rc_ptr< ::mosek::fusion::BoundInterfaceConstraint > __mosek_2fusion_2RangedConstraint__upperBoundCon() ;
      virtual monty::rc_ptr< ::mosek::fusion::BoundInterfaceConstraint > __mosek_2fusion_2RangedConstraint__lowerBoundCon() ;
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::ModelConstraint > __mosek_2fusion_2RangedConstraint__clone(monty::rc_ptr< ::mosek::fusion::Model > _2961_m) ;
      virtual monty::rc_ptr< ::mosek::fusion::ModelConstraint > __mosek_2fusion_2ModelConstraint__clone(monty::rc_ptr< ::mosek::fusion::Model > _2961_m) { return __mosek_2fusion_2RangedConstraint__clone(_2961_m); }
    }; // struct RangedConstraint;

    struct p_ConicConstraint : public ::mosek::fusion::p_ModelConstraint
    {
      ConicConstraint * _pubthis;
      static mosek::fusion::p_ConicConstraint* _get_impl(mosek::fusion::ConicConstraint * _inst){ return static_cast< mosek::fusion::p_ConicConstraint* >(mosek::fusion::p_ModelConstraint::_get_impl(_inst)); }
      static mosek::fusion::p_ConicConstraint * _get_impl(mosek::fusion::ConicConstraint::t _inst) { return _get_impl(_inst.get()); }
      p_ConicConstraint(ConicConstraint * _pubthis);
      virtual ~p_ConicConstraint() { /* std::cout << "~p_ConicConstraint" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< std::string,1 > >,1 > > indexnames{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > nativeidxs{};
      bool names_flushed{};
      std::string name{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};
      monty::rc_ptr< ::mosek::fusion::ConeDomain > dom{};
      int32_t conid{};

      virtual void destroy();

      static ConicConstraint::t _new_ConicConstraint(monty::rc_ptr< ::mosek::fusion::ConicConstraint > _2962_c,monty::rc_ptr< ::mosek::fusion::Model > _2963_m);
      void _initialize(monty::rc_ptr< ::mosek::fusion::ConicConstraint > _2962_c,monty::rc_ptr< ::mosek::fusion::Model > _2963_m);
      static ConicConstraint::t _new_ConicConstraint(monty::rc_ptr< ::mosek::fusion::Model > _2964_model,const std::string &  _2965_name,monty::rc_ptr< ::mosek::fusion::ConeDomain > _2966_dom,std::shared_ptr< monty::ndarray< int32_t,1 > > _2967_shape,int32_t _2968_conid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2969_nativeidxs,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< std::string,1 > >,1 > > _2970_indexnames);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2964_model,const std::string &  _2965_name,monty::rc_ptr< ::mosek::fusion::ConeDomain > _2966_dom,std::shared_ptr< monty::ndarray< int32_t,1 > > _2967_shape,int32_t _2968_conid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2969_nativeidxs,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< std::string,1 > >,1 > > _2970_indexnames);
      virtual /* override */ std::string toString() ;
      virtual void domainToString(int64_t _2973_i,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2974_sb) ;
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::ModelConstraint > __mosek_2fusion_2ConicConstraint__clone(monty::rc_ptr< ::mosek::fusion::Model > _2975_m) ;
      virtual monty::rc_ptr< ::mosek::fusion::ModelConstraint > __mosek_2fusion_2ModelConstraint__clone(monty::rc_ptr< ::mosek::fusion::Model > _2975_m) { return __mosek_2fusion_2ConicConstraint__clone(_2975_m); }
    }; // struct ConicConstraint;

    struct p_LinearConstraint : public ::mosek::fusion::p_ModelConstraint
    {
      LinearConstraint * _pubthis;
      static mosek::fusion::p_LinearConstraint* _get_impl(mosek::fusion::LinearConstraint * _inst){ return static_cast< mosek::fusion::p_LinearConstraint* >(mosek::fusion::p_ModelConstraint::_get_impl(_inst)); }
      static mosek::fusion::p_LinearConstraint * _get_impl(mosek::fusion::LinearConstraint::t _inst) { return _get_impl(_inst.get()); }
      p_LinearConstraint(LinearConstraint * _pubthis);
      virtual ~p_LinearConstraint() { /* std::cout << "~p_LinearConstraint" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< std::string,1 > >,1 > > indexnames{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > nidxs{};
      std::string name{};
      int32_t conid{};

      virtual void destroy();

      static LinearConstraint::t _new_LinearConstraint(monty::rc_ptr< ::mosek::fusion::LinearConstraint > _2976_c,monty::rc_ptr< ::mosek::fusion::Model > _2977_m);
      void _initialize(monty::rc_ptr< ::mosek::fusion::LinearConstraint > _2976_c,monty::rc_ptr< ::mosek::fusion::Model > _2977_m);
      static LinearConstraint::t _new_LinearConstraint(monty::rc_ptr< ::mosek::fusion::Model > _2978_model,const std::string &  _2979_name,int32_t _2980_conid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2981_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _2982_nidxs,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< std::string,1 > >,1 > > _2983_indexnames);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _2978_model,const std::string &  _2979_name,int32_t _2980_conid,std::shared_ptr< monty::ndarray< int32_t,1 > > _2981_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _2982_nidxs,std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< std::string,1 > >,1 > > _2983_indexnames);
      virtual /* override */ std::string toString() ;
      virtual void domainToString(int64_t _2985_i,monty::rc_ptr< ::mosek::fusion::Utils::StringBuffer > _2986_sb) ;
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::ModelConstraint > __mosek_2fusion_2LinearConstraint__clone(monty::rc_ptr< ::mosek::fusion::Model > _2987_m) ;
      virtual monty::rc_ptr< ::mosek::fusion::ModelConstraint > __mosek_2fusion_2ModelConstraint__clone(monty::rc_ptr< ::mosek::fusion::Model > _2987_m) { return __mosek_2fusion_2LinearConstraint__clone(_2987_m); }
    }; // struct LinearConstraint;

    struct p_Set
    {
      Set * _pubthis;
      static mosek::fusion::p_Set* _get_impl(mosek::fusion::Set * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_Set * _get_impl(mosek::fusion::Set::t _inst) { return _get_impl(_inst.get()); }
      p_Set(Set * _pubthis);
      virtual ~p_Set() { /* std::cout << "~p_Set" << std::endl;*/ };

      virtual void destroy();

      static  int64_t size(std::shared_ptr< monty::ndarray< int32_t,1 > > _3151_shape);
      static  bool match(std::shared_ptr< monty::ndarray< int32_t,1 > > _3154_s1,std::shared_ptr< monty::ndarray< int32_t,1 > > _3155_s2);
      static  int64_t linearidx(std::shared_ptr< monty::ndarray< int32_t,1 > > _3157_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _3158_key);
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > idxtokey(std::shared_ptr< monty::ndarray< int32_t,1 > > _3161_shape,int64_t _3162_idx);
      static  void idxtokey(std::shared_ptr< monty::ndarray< int32_t,1 > > _3164_shape,int64_t _3165_idx,std::shared_ptr< monty::ndarray< int32_t,1 > > _3166_dest);
      static  std::string indexToString(std::shared_ptr< monty::ndarray< int32_t,1 > > _3170_shape,int64_t _3171_key);
      static  std::string keyToString(std::shared_ptr< monty::ndarray< int32_t,1 > > _3178_key);
      static  void indexToKey(std::shared_ptr< monty::ndarray< int32_t,1 > > _3181_shape,int64_t _3182_key,std::shared_ptr< monty::ndarray< int32_t,1 > > _3183_res);
      static  std::shared_ptr< monty::ndarray< int64_t,1 > > strides(std::shared_ptr< monty::ndarray< int32_t,1 > > _3187_shape);
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > make(std::shared_ptr< monty::ndarray< int32_t,1 > > _3191_set1,std::shared_ptr< monty::ndarray< int32_t,1 > > _3192_set2);
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > make(std::shared_ptr< monty::ndarray< int32_t,1 > > _3196_sizes);
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > make(int32_t _3198_s1,int32_t _3199_s2,int32_t _3200_s3);
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > make(int32_t _3201_s1,int32_t _3202_s2);
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > make(int32_t _3203_sz);
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > scalar();
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > make(std::shared_ptr< monty::ndarray< std::string,1 > > _3204_names);
    }; // struct Set;

    struct p_ConeDomain
    {
      ConeDomain * _pubthis;
      static mosek::fusion::p_ConeDomain* _get_impl(mosek::fusion::ConeDomain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_ConeDomain * _get_impl(mosek::fusion::ConeDomain::t _inst) { return _get_impl(_inst.get()); }
      p_ConeDomain(ConeDomain * _pubthis);
      virtual ~p_ConeDomain() { /* std::cout << "~p_ConeDomain" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< std::string,1 > >,1 > > indexnames{};
      int64_t domsize{};
      std::shared_ptr< monty::ndarray< double,1 > > domofs{};
      std::shared_ptr< monty::ndarray< double,1 > > alpha{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};
      bool int_flag{};
      bool axisset{};
      int32_t axisidx{};
      mosek::fusion::QConeKey key{};

      virtual void destroy();

      static ConeDomain::t _new_ConeDomain(mosek::fusion::QConeKey _3205_k,std::shared_ptr< monty::ndarray< double,1 > > _3206_alpha,std::shared_ptr< monty::ndarray< int32_t,1 > > _3207_d);
      void _initialize(mosek::fusion::QConeKey _3205_k,std::shared_ptr< monty::ndarray< double,1 > > _3206_alpha,std::shared_ptr< monty::ndarray< int32_t,1 > > _3207_d);
      static ConeDomain::t _new_ConeDomain(mosek::fusion::QConeKey _3208_k,std::shared_ptr< monty::ndarray< int32_t,1 > > _3209_d);
      void _initialize(mosek::fusion::QConeKey _3208_k,std::shared_ptr< monty::ndarray< int32_t,1 > > _3209_d);
      static ConeDomain::t _new_ConeDomain(monty::rc_ptr< ::mosek::fusion::ConeDomain > _3210_other);
      void _initialize(monty::rc_ptr< ::mosek::fusion::ConeDomain > _3210_other);
      virtual bool match_shape(std::shared_ptr< monty::ndarray< int32_t,1 > > _3211_shp) ;
      virtual monty::rc_ptr< ::mosek::fusion::ConeDomain > __mosek_2fusion_2ConeDomain__integral() ;
      virtual bool axisIsSet() ;
      virtual int32_t getAxis() ;
      virtual monty::rc_ptr< ::mosek::fusion::ConeDomain > __mosek_2fusion_2ConeDomain__axis(int32_t _3212_a) ;
      virtual monty::rc_ptr< ::mosek::fusion::ConeDomain > __mosek_2fusion_2ConeDomain__withShape(int32_t _3213_dim0,int32_t _3214_dim1,int32_t _3215_dim2) ;
      virtual monty::rc_ptr< ::mosek::fusion::ConeDomain > __mosek_2fusion_2ConeDomain__withShape(int32_t _3216_dim0,int32_t _3217_dim1) ;
      virtual monty::rc_ptr< ::mosek::fusion::ConeDomain > __mosek_2fusion_2ConeDomain__withShape(int32_t _3218_dim0) ;
      virtual monty::rc_ptr< ::mosek::fusion::ConeDomain > __mosek_2fusion_2ConeDomain__withShape(std::shared_ptr< monty::ndarray< int32_t,1 > > _3219_shp) ;
      virtual monty::rc_ptr< ::mosek::fusion::ConeDomain > __mosek_2fusion_2ConeDomain__withShape_(std::shared_ptr< monty::ndarray< int32_t,1 > > _3220_shp) ;
      virtual monty::rc_ptr< ::mosek::fusion::ConeDomain > __mosek_2fusion_2ConeDomain__withNamesOnAxis(std::shared_ptr< monty::ndarray< std::string,1 > > _3221_names,int32_t _3222_axis) ;
      virtual void finalize_and_validate_inplace(std::shared_ptr< monty::ndarray< int32_t,1 > > _3229_shp) ;
      virtual monty::rc_ptr< ::mosek::fusion::ConeDomain > __mosek_2fusion_2ConeDomain__finalize_and_validate(std::shared_ptr< monty::ndarray< int32_t,1 > > _3233_shp) ;
    }; // struct ConeDomain;

    struct p_PSDDomain
    {
      PSDDomain * _pubthis;
      static mosek::fusion::p_PSDDomain* _get_impl(mosek::fusion::PSDDomain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_PSDDomain * _get_impl(mosek::fusion::PSDDomain::t _inst) { return _get_impl(_inst.get()); }
      p_PSDDomain(PSDDomain * _pubthis);
      virtual ~p_PSDDomain() { /* std::cout << "~p_PSDDomain" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< std::string,1 > >,1 > > indexnames{};
      bool axisIsSet{};
      int32_t conedim2{};
      int32_t conedim1{};
      mosek::fusion::PSDKey key{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};

      virtual void destroy();

      static PSDDomain::t _new_PSDDomain(mosek::fusion::PSDKey _3235_k,std::shared_ptr< monty::ndarray< int32_t,1 > > _3236_shp,int32_t _3237_conedim1,int32_t _3238_conedim2);
      void _initialize(mosek::fusion::PSDKey _3235_k,std::shared_ptr< monty::ndarray< int32_t,1 > > _3236_shp,int32_t _3237_conedim1,int32_t _3238_conedim2);
      static PSDDomain::t _new_PSDDomain(mosek::fusion::PSDKey _3240_k,std::shared_ptr< monty::ndarray< int32_t,1 > > _3241_shp);
      void _initialize(mosek::fusion::PSDKey _3240_k,std::shared_ptr< monty::ndarray< int32_t,1 > > _3241_shp);
      static PSDDomain::t _new_PSDDomain(mosek::fusion::PSDKey _3242_k);
      void _initialize(mosek::fusion::PSDKey _3242_k);
      static PSDDomain::t _new_PSDDomain(monty::rc_ptr< ::mosek::fusion::PSDDomain > _3243_other);
      void _initialize(monty::rc_ptr< ::mosek::fusion::PSDDomain > _3243_other);
      virtual monty::rc_ptr< ::mosek::fusion::PSDDomain > __mosek_2fusion_2PSDDomain__axis(int32_t _3244_conedim1,int32_t _3245_conedim2) ;
      virtual monty::rc_ptr< ::mosek::fusion::PSDDomain > __mosek_2fusion_2PSDDomain__withNamesOnAxis(std::shared_ptr< monty::ndarray< std::string,1 > > _3246_names,int32_t _3247_axis) ;
      virtual void finalize_and_validate_inplace(std::shared_ptr< monty::ndarray< int32_t,1 > > _3254_shp) ;
      virtual monty::rc_ptr< ::mosek::fusion::PSDDomain > __mosek_2fusion_2PSDDomain__finalize_and_validate(std::shared_ptr< monty::ndarray< int32_t,1 > > _3257_shp) ;
    }; // struct PSDDomain;

    struct p_RangeDomain
    {
      RangeDomain * _pubthis;
      static mosek::fusion::p_RangeDomain* _get_impl(mosek::fusion::RangeDomain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_RangeDomain * _get_impl(mosek::fusion::RangeDomain::t _inst) { return _get_impl(_inst.get()); }
      p_RangeDomain(RangeDomain * _pubthis);
      virtual ~p_RangeDomain() { /* std::cout << "~p_RangeDomain" << std::endl;*/ };
      int64_t domsize{};
      int64_t nelements{};
      std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< std::string,1 > >,1 > > indexnames{};
      bool cardinal_flag{};
      bool scalable{};
      std::shared_ptr< monty::ndarray< double,1 > > ub{};
      std::shared_ptr< monty::ndarray< double,1 > > lb{};
      std::shared_ptr< monty::ndarray< int32_t,2 > > sparsity{};
      bool empty{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};

      virtual void destroy();

      static RangeDomain::t _new_RangeDomain(bool _3259_scalable,std::shared_ptr< monty::ndarray< double,1 > > _3260_lb,std::shared_ptr< monty::ndarray< double,1 > > _3261_ub,std::shared_ptr< monty::ndarray< int32_t,1 > > _3262_dims);
      void _initialize(bool _3259_scalable,std::shared_ptr< monty::ndarray< double,1 > > _3260_lb,std::shared_ptr< monty::ndarray< double,1 > > _3261_ub,std::shared_ptr< monty::ndarray< int32_t,1 > > _3262_dims);
      static RangeDomain::t _new_RangeDomain(bool _3263_scalable,double _3264_lb,double _3265_ub,std::shared_ptr< monty::ndarray< int32_t,1 > > _3266_dims);
      void _initialize(bool _3263_scalable,double _3264_lb,double _3265_ub,std::shared_ptr< monty::ndarray< int32_t,1 > > _3266_dims);
      static RangeDomain::t _new_RangeDomain(bool _3271_scalable,std::shared_ptr< monty::ndarray< double,1 > > _3272_lb,std::shared_ptr< monty::ndarray< double,1 > > _3273_ub,std::shared_ptr< monty::ndarray< int32_t,1 > > _3274_dims,std::shared_ptr< monty::ndarray< int32_t,2 > > _3275_sp);
      void _initialize(bool _3271_scalable,std::shared_ptr< monty::ndarray< double,1 > > _3272_lb,std::shared_ptr< monty::ndarray< double,1 > > _3273_ub,std::shared_ptr< monty::ndarray< int32_t,1 > > _3274_dims,std::shared_ptr< monty::ndarray< int32_t,2 > > _3275_sp);
      static RangeDomain::t _new_RangeDomain(bool _3276_scalable,std::shared_ptr< monty::ndarray< double,1 > > _3277_lb,std::shared_ptr< monty::ndarray< double,1 > > _3278_ub,std::shared_ptr< monty::ndarray< int32_t,1 > > _3279_dims,std::shared_ptr< monty::ndarray< int32_t,2 > > _3280_sp,int32_t _3281_steal);
      void _initialize(bool _3276_scalable,std::shared_ptr< monty::ndarray< double,1 > > _3277_lb,std::shared_ptr< monty::ndarray< double,1 > > _3278_ub,std::shared_ptr< monty::ndarray< int32_t,1 > > _3279_dims,std::shared_ptr< monty::ndarray< int32_t,2 > > _3280_sp,int32_t _3281_steal);
      static RangeDomain::t _new_RangeDomain(monty::rc_ptr< ::mosek::fusion::RangeDomain > _3282_other);
      void _initialize(monty::rc_ptr< ::mosek::fusion::RangeDomain > _3282_other);
      virtual monty::rc_ptr< ::mosek::fusion::RangeDomain > __mosek_2fusion_2RangeDomain__sparse(std::shared_ptr< monty::ndarray< int32_t,2 > > _3284_sparsity) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangeDomain > __mosek_2fusion_2RangeDomain__sparse(std::shared_ptr< monty::ndarray< int32_t,1 > > _3287_sparsity) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangeDomain > __mosek_2fusion_2RangeDomain__sparse() ;
      virtual monty::rc_ptr< ::mosek::fusion::RangeDomain > __mosek_2fusion_2RangeDomain__integral() ;
      virtual monty::rc_ptr< ::mosek::fusion::RangeDomain > __mosek_2fusion_2RangeDomain__withShape(int32_t _3289_dim0,int32_t _3290_dim1,int32_t _3291_dim2) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangeDomain > __mosek_2fusion_2RangeDomain__withShape(int32_t _3292_dim0,int32_t _3293_dim1) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangeDomain > __mosek_2fusion_2RangeDomain__withShape(int32_t _3294_dim0) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangeDomain > __mosek_2fusion_2RangeDomain__withShape(std::shared_ptr< monty::ndarray< int32_t,1 > > _3295_shp) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangeDomain > __mosek_2fusion_2RangeDomain__withNamesOnAxis(std::shared_ptr< monty::ndarray< std::string,1 > > _3296_names,int32_t _3297_axis) ;
      virtual bool match_shape(std::shared_ptr< monty::ndarray< int32_t,1 > > _3304_shp) ;
      virtual void finalize_and_validate_inplace(std::shared_ptr< monty::ndarray< int32_t,1 > > _3306_shp) ;
      virtual monty::rc_ptr< ::mosek::fusion::RangeDomain > __mosek_2fusion_2RangeDomain__finalize_and_validate(std::shared_ptr< monty::ndarray< int32_t,1 > > _3313_shp) ;
    }; // struct RangeDomain;

    struct p_LinearDomain
    {
      LinearDomain * _pubthis;
      static mosek::fusion::p_LinearDomain* _get_impl(mosek::fusion::LinearDomain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_LinearDomain * _get_impl(mosek::fusion::LinearDomain::t _inst) { return _get_impl(_inst.get()); }
      p_LinearDomain(LinearDomain * _pubthis);
      virtual ~p_LinearDomain() { /* std::cout << "~p_LinearDomain" << std::endl;*/ };
      int64_t nelements{};
      int64_t domsize{};
      std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< std::string,1 > >,1 > > indexnames{};
      bool empty{};
      bool scalable{};
      std::shared_ptr< monty::ndarray< int32_t,2 > > sparsity{};
      bool cardinal_flag{};
      mosek::fusion::RelationKey key{};
      std::shared_ptr< monty::ndarray< double,1 > > bnd{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};

      virtual void destroy();

      static LinearDomain::t _new_LinearDomain(mosek::fusion::RelationKey _3315_k,bool _3316_scalable,std::shared_ptr< monty::ndarray< double,1 > > _3317_rhs,std::shared_ptr< monty::ndarray< int32_t,1 > > _3318_dims);
      void _initialize(mosek::fusion::RelationKey _3315_k,bool _3316_scalable,std::shared_ptr< monty::ndarray< double,1 > > _3317_rhs,std::shared_ptr< monty::ndarray< int32_t,1 > > _3318_dims);
      static LinearDomain::t _new_LinearDomain(mosek::fusion::RelationKey _3319_k,bool _3320_scalable,std::shared_ptr< monty::ndarray< double,1 > > _3321_rhs,std::shared_ptr< monty::ndarray< int32_t,1 > > _3322_dims,std::shared_ptr< monty::ndarray< int32_t,2 > > _3323_sp,int32_t _3324_steal);
      void _initialize(mosek::fusion::RelationKey _3319_k,bool _3320_scalable,std::shared_ptr< monty::ndarray< double,1 > > _3321_rhs,std::shared_ptr< monty::ndarray< int32_t,1 > > _3322_dims,std::shared_ptr< monty::ndarray< int32_t,2 > > _3323_sp,int32_t _3324_steal);
      static LinearDomain::t _new_LinearDomain(monty::rc_ptr< ::mosek::fusion::LinearDomain > _3325_other);
      void _initialize(monty::rc_ptr< ::mosek::fusion::LinearDomain > _3325_other);
      virtual monty::rc_ptr< ::mosek::fusion::LinearDomain > __mosek_2fusion_2LinearDomain__sparse(std::shared_ptr< monty::ndarray< int32_t,2 > > _3326_sparsity) ;
      virtual monty::rc_ptr< ::mosek::fusion::LinearDomain > __mosek_2fusion_2LinearDomain__sparse(std::shared_ptr< monty::ndarray< int32_t,1 > > _3329_sparsity) ;
      virtual monty::rc_ptr< ::mosek::fusion::LinearDomain > __mosek_2fusion_2LinearDomain__sparse() ;
      virtual monty::rc_ptr< ::mosek::fusion::LinearDomain > __mosek_2fusion_2LinearDomain__integral() ;
      virtual monty::rc_ptr< ::mosek::fusion::LinearDomain > __mosek_2fusion_2LinearDomain__withShape(int32_t _3331_dim0,int32_t _3332_dim1,int32_t _3333_dim2) ;
      virtual monty::rc_ptr< ::mosek::fusion::LinearDomain > __mosek_2fusion_2LinearDomain__withShape(int32_t _3334_dim0,int32_t _3335_dim1) ;
      virtual monty::rc_ptr< ::mosek::fusion::LinearDomain > __mosek_2fusion_2LinearDomain__withShape(int32_t _3336_dim0) ;
      virtual monty::rc_ptr< ::mosek::fusion::LinearDomain > __mosek_2fusion_2LinearDomain__withShape(std::shared_ptr< monty::ndarray< int32_t,1 > > _3337_shp) ;
      virtual monty::rc_ptr< ::mosek::fusion::LinearDomain > __mosek_2fusion_2LinearDomain__withNamesOnAxis(std::shared_ptr< monty::ndarray< std::string,1 > > _3338_names,int32_t _3339_axis) ;
      virtual bool match_shape(std::shared_ptr< monty::ndarray< int32_t,1 > > _3346_shp) ;
      virtual void finalize_and_validate_inplace(std::shared_ptr< monty::ndarray< int32_t,1 > > _3348_shp) ;
      virtual monty::rc_ptr< ::mosek::fusion::LinearDomain > __mosek_2fusion_2LinearDomain__finalize_and_validate(std::shared_ptr< monty::ndarray< int32_t,1 > > _3356_shp) ;
    }; // struct LinearDomain;

    struct p_Domain
    {
      Domain * _pubthis;
      static mosek::fusion::p_Domain* _get_impl(mosek::fusion::Domain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_Domain * _get_impl(mosek::fusion::Domain::t _inst) { return _get_impl(_inst.get()); }
      p_Domain(Domain * _pubthis);
      virtual ~p_Domain() { /* std::cout << "~p_Domain" << std::endl;*/ };

      virtual void destroy();

      static  int64_t dimsize(std::shared_ptr< monty::ndarray< int32_t,1 > > _3358_dims);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > mkRangedDomain(monty::rc_ptr< ::mosek::fusion::Matrix > _3361_lb,monty::rc_ptr< ::mosek::fusion::Matrix > _3362_ub);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > mkRangedDomain(std::shared_ptr< monty::ndarray< double,2 > > _3391_lb,std::shared_ptr< monty::ndarray< double,2 > > _3392_ub);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > mkLinearDomain(mosek::fusion::RelationKey _3401_k,monty::rc_ptr< ::mosek::fusion::Matrix > _3402_mx);
      static  int64_t prod(std::shared_ptr< monty::ndarray< int32_t,1 > > _3408_dim);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(bool _3411_scalable,std::shared_ptr< monty::ndarray< double,1 > > _3412_lb,std::shared_ptr< monty::ndarray< double,1 > > _3413_ub,std::shared_ptr< monty::ndarray< int32_t,2 > > _3414_sp,std::shared_ptr< monty::ndarray< int32_t,1 > > _3415_dims);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > sparse(monty::rc_ptr< ::mosek::fusion::RangeDomain > _3417_rd,std::shared_ptr< monty::ndarray< int32_t,2 > > _3418_sparsity);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > sparse(monty::rc_ptr< ::mosek::fusion::RangeDomain > _3419_rd,std::shared_ptr< monty::ndarray< int32_t,1 > > _3420_sparsity);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > sparse(monty::rc_ptr< ::mosek::fusion::LinearDomain > _3421_ld,std::shared_ptr< monty::ndarray< int32_t,2 > > _3422_sparsity);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > sparse(monty::rc_ptr< ::mosek::fusion::LinearDomain > _3423_ld,std::shared_ptr< monty::ndarray< int32_t,1 > > _3424_sparsity);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > integral(monty::rc_ptr< ::mosek::fusion::RangeDomain > _3425_rd);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > integral(monty::rc_ptr< ::mosek::fusion::LinearDomain > _3426_ld);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > integral(monty::rc_ptr< ::mosek::fusion::ConeDomain > _3427_c);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > axis(monty::rc_ptr< ::mosek::fusion::ConeDomain > _3428_c,int32_t _3429_a);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inDPowerConeSeq(std::shared_ptr< monty::ndarray< double,2 > > _3430_alphas);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inDPowerConeSeq(std::shared_ptr< monty::ndarray< double,1 > > _3437_alpha);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inDPowerCone(std::shared_ptr< monty::ndarray< double,1 > > _3441_alphas,std::shared_ptr< monty::ndarray< int32_t,1 > > _3442_dims);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inDPowerCone(std::shared_ptr< monty::ndarray< double,1 > > _3444_alphas,int32_t _3445_m);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inDPowerCone(std::shared_ptr< monty::ndarray< double,1 > > _3446_alphas);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inDPowerCone(double _3447_alpha,std::shared_ptr< monty::ndarray< int32_t,1 > > _3448_dims);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inDPowerCone(double _3450_alpha,int32_t _3451_m);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inDPowerCone(double _3452_alpha);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inPPowerConeSeq(std::shared_ptr< monty::ndarray< double,2 > > _3453_alphas);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inPPowerConeSeq(std::shared_ptr< monty::ndarray< double,1 > > _3460_alpha);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inPPowerCone(std::shared_ptr< monty::ndarray< double,1 > > _3464_alphas,std::shared_ptr< monty::ndarray< int32_t,1 > > _3465_dims);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inPPowerCone(std::shared_ptr< monty::ndarray< double,1 > > _3467_alphas,int32_t _3468_m);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inPPowerCone(std::shared_ptr< monty::ndarray< double,1 > > _3469_alphas);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inPPowerCone(double _3470_alpha,std::shared_ptr< monty::ndarray< int32_t,1 > > _3471_dims);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inPPowerCone(double _3473_alpha,int32_t _3474_m);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inPPowerCone(double _3475_alpha);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inDExpCone(std::shared_ptr< monty::ndarray< int32_t,1 > > _3476_dims);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inDExpCone(int32_t _3478_m);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inDExpCone();
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inPExpCone(std::shared_ptr< monty::ndarray< int32_t,1 > > _3479_dims);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inPExpCone(int32_t _3481_m);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inPExpCone();
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inDGeoMeanCone(std::shared_ptr< monty::ndarray< int32_t,1 > > _3482_dims);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inDGeoMeanCone(int32_t _3484_m,int32_t _3485_n);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inDGeoMeanCone(int32_t _3486_n);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inDGeoMeanCone();
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inPGeoMeanCone(std::shared_ptr< monty::ndarray< int32_t,1 > > _3487_dims);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inPGeoMeanCone(int32_t _3489_m,int32_t _3490_n);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inPGeoMeanCone(int32_t _3491_n);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inPGeoMeanCone();
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inRotatedQCone(std::shared_ptr< monty::ndarray< int32_t,1 > > _3492_dims);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inRotatedQCone(int32_t _3494_m,int32_t _3495_n);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inRotatedQCone(int32_t _3496_n);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inRotatedQCone();
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inQCone(std::shared_ptr< monty::ndarray< int32_t,1 > > _3497_dims);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inQCone(int32_t _3499_m,int32_t _3500_n);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inQCone(int32_t _3501_n);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inQCone();
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inSVecPSDCone(std::shared_ptr< monty::ndarray< int32_t,1 > > _3502_dims);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inSVecPSDCone(int32_t _3503_d1,int32_t _3504_d2);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inSVecPSDCone(int32_t _3505_n);
      static  monty::rc_ptr< ::mosek::fusion::ConeDomain > inSVecPSDCone();
      static  monty::rc_ptr< ::mosek::fusion::PSDDomain > isTrilPSD(int32_t _3506_n,int32_t _3507_m);
      static  monty::rc_ptr< ::mosek::fusion::PSDDomain > isTrilPSD(int32_t _3508_n);
      static  monty::rc_ptr< ::mosek::fusion::PSDDomain > isTrilPSD();
      static  monty::rc_ptr< ::mosek::fusion::PSDDomain > inPSDCone(int32_t _3509_n,int32_t _3510_m);
      static  monty::rc_ptr< ::mosek::fusion::PSDDomain > inPSDCone(int32_t _3511_n);
      static  monty::rc_ptr< ::mosek::fusion::PSDDomain > inPSDCone();
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > binary();
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > binary(std::shared_ptr< monty::ndarray< int32_t,1 > > _3512_dims);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > binary(int32_t _3513_m,int32_t _3514_n);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > binary(int32_t _3515_n);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(monty::rc_ptr< ::mosek::fusion::Matrix > _3516_lbm,monty::rc_ptr< ::mosek::fusion::Matrix > _3517_ubm);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(std::shared_ptr< monty::ndarray< double,2 > > _3518_lba,std::shared_ptr< monty::ndarray< double,2 > > _3519_uba);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(std::shared_ptr< monty::ndarray< double,1 > > _3520_lba,std::shared_ptr< monty::ndarray< double,1 > > _3521_uba,std::shared_ptr< monty::ndarray< int32_t,1 > > _3522_dims);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(std::shared_ptr< monty::ndarray< double,1 > > _3523_lba,double _3524_ub,std::shared_ptr< monty::ndarray< int32_t,1 > > _3525_dims);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(double _3527_lb,std::shared_ptr< monty::ndarray< double,1 > > _3528_uba,std::shared_ptr< monty::ndarray< int32_t,1 > > _3529_dims);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(double _3531_lb,double _3532_ub,std::shared_ptr< monty::ndarray< int32_t,1 > > _3533_dims);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(std::shared_ptr< monty::ndarray< double,1 > > _3534_lba,std::shared_ptr< monty::ndarray< double,1 > > _3535_uba);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(std::shared_ptr< monty::ndarray< double,1 > > _3536_lba,double _3537_ub);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(double _3539_lb,std::shared_ptr< monty::ndarray< double,1 > > _3540_uba);
      static  monty::rc_ptr< ::mosek::fusion::RangeDomain > inRange(double _3542_lb,double _3543_ub);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > greaterThan(monty::rc_ptr< ::mosek::fusion::Matrix > _3544_mx);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > greaterThan(std::shared_ptr< monty::ndarray< double,1 > > _3545_a1,std::shared_ptr< monty::ndarray< int32_t,1 > > _3546_dims);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > greaterThan(std::shared_ptr< monty::ndarray< double,2 > > _3547_a2);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > greaterThan(std::shared_ptr< monty::ndarray< double,1 > > _3550_a1);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > greaterThan(double _3551_b,std::shared_ptr< monty::ndarray< int32_t,1 > > _3552_dims);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > greaterThan(double _3554_b,int32_t _3555_m,int32_t _3556_n);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > greaterThan(double _3558_b,int32_t _3559_n);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > greaterThan(double _3561_b);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > lessThan(monty::rc_ptr< ::mosek::fusion::Matrix > _3562_mx);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > lessThan(std::shared_ptr< monty::ndarray< double,1 > > _3563_a1,std::shared_ptr< monty::ndarray< int32_t,1 > > _3564_dims);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > lessThan(std::shared_ptr< monty::ndarray< double,2 > > _3565_a2);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > lessThan(std::shared_ptr< monty::ndarray< double,1 > > _3568_a1);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > lessThan(double _3569_b,std::shared_ptr< monty::ndarray< int32_t,1 > > _3570_dims);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > lessThan(double _3571_b,int32_t _3572_m,int32_t _3573_n);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > lessThan(double _3574_b,int32_t _3575_n);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > lessThan(double _3576_b);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > equalsTo(monty::rc_ptr< ::mosek::fusion::Matrix > _3577_mx);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > equalsTo(std::shared_ptr< monty::ndarray< double,1 > > _3578_a1,std::shared_ptr< monty::ndarray< int32_t,1 > > _3579_dims);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > equalsTo(std::shared_ptr< monty::ndarray< double,2 > > _3580_a2);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > equalsTo(std::shared_ptr< monty::ndarray< double,1 > > _3583_a1);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > equalsTo(double _3584_b,std::shared_ptr< monty::ndarray< int32_t,1 > > _3585_dims);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > equalsTo(double _3586_b,int32_t _3587_m,int32_t _3588_n);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > equalsTo(double _3589_b,int32_t _3590_n);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > equalsTo(double _3591_b);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > unbounded(std::shared_ptr< monty::ndarray< int32_t,1 > > _3592_dims);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > unbounded(int32_t _3594_m,int32_t _3595_n);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > unbounded(int32_t _3596_n);
      static  monty::rc_ptr< ::mosek::fusion::LinearDomain > unbounded();
    }; // struct Domain;

    struct p_Param
    {
      Param * _pubthis;
      static mosek::fusion::p_Param* _get_impl(mosek::fusion::Param * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_Param * _get_impl(mosek::fusion::Param::t _inst) { return _get_impl(_inst.get()); }
      p_Param(Param * _pubthis);
      virtual ~p_Param() { /* std::cout << "~p_Param" << std::endl;*/ };

      virtual void destroy();

      static  monty::rc_ptr< ::mosek::fusion::Parameter > repeat(monty::rc_ptr< ::mosek::fusion::Parameter > _3606_p,int32_t _3607_n,int32_t _3608_dim);
      static  monty::rc_ptr< ::mosek::fusion::Parameter > stack(int32_t _3610_dim,monty::rc_ptr< ::mosek::fusion::Parameter > _3611_p1,monty::rc_ptr< ::mosek::fusion::Parameter > _3612_p2,monty::rc_ptr< ::mosek::fusion::Parameter > _3613_p3);
      static  monty::rc_ptr< ::mosek::fusion::Parameter > stack(int32_t _3614_dim,monty::rc_ptr< ::mosek::fusion::Parameter > _3615_p1,monty::rc_ptr< ::mosek::fusion::Parameter > _3616_p2);
      static  monty::rc_ptr< ::mosek::fusion::Parameter > stack(int32_t _3617_dim,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Parameter >,1 > > _3618_p);
      static  monty::rc_ptr< ::mosek::fusion::Parameter > stack(std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Parameter >,1 > >,1 > > _3619_p);
      static  monty::rc_ptr< ::mosek::fusion::Parameter > hstack(monty::rc_ptr< ::mosek::fusion::Parameter > _3621_p1,monty::rc_ptr< ::mosek::fusion::Parameter > _3622_p2,monty::rc_ptr< ::mosek::fusion::Parameter > _3623_p3);
      static  monty::rc_ptr< ::mosek::fusion::Parameter > hstack(monty::rc_ptr< ::mosek::fusion::Parameter > _3624_p1,monty::rc_ptr< ::mosek::fusion::Parameter > _3625_p2);
      static  monty::rc_ptr< ::mosek::fusion::Parameter > hstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Parameter >,1 > > _3626_p);
      static  monty::rc_ptr< ::mosek::fusion::Parameter > vstack(monty::rc_ptr< ::mosek::fusion::Parameter > _3627_p1,monty::rc_ptr< ::mosek::fusion::Parameter > _3628_p2,monty::rc_ptr< ::mosek::fusion::Parameter > _3629_p3);
      static  monty::rc_ptr< ::mosek::fusion::Parameter > vstack(monty::rc_ptr< ::mosek::fusion::Parameter > _3630_p1,monty::rc_ptr< ::mosek::fusion::Parameter > _3631_p2);
      static  monty::rc_ptr< ::mosek::fusion::Parameter > vstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Parameter >,1 > > _3632_p);
      static  monty::rc_ptr< ::mosek::fusion::Parameter > dstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Parameter >,1 > > _3633_p,int32_t _3634_dim);
    }; // struct Param;

    struct p_ParameterImpl : public /*implements*/ virtual ::mosek::fusion::Parameter
    {
      ParameterImpl * _pubthis;
      static mosek::fusion::p_ParameterImpl* _get_impl(mosek::fusion::ParameterImpl * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_ParameterImpl * _get_impl(mosek::fusion::ParameterImpl::t _inst) { return _get_impl(_inst.get()); }
      p_ParameterImpl(ParameterImpl * _pubthis);
      virtual ~p_ParameterImpl() { /* std::cout << "~p_ParameterImpl" << std::endl;*/ };
      int64_t size{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > nidxs{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > sp{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};
      monty::rc_ptr< ::mosek::fusion::Model > model{};

      virtual void destroy();

      static ParameterImpl::t _new_ParameterImpl(monty::rc_ptr< ::mosek::fusion::ParameterImpl > _4431_other,monty::rc_ptr< ::mosek::fusion::Model > _4432_model);
      void _initialize(monty::rc_ptr< ::mosek::fusion::ParameterImpl > _4431_other,monty::rc_ptr< ::mosek::fusion::Model > _4432_model);
      static ParameterImpl::t _new_ParameterImpl(monty::rc_ptr< ::mosek::fusion::Model > _4433_model,std::shared_ptr< monty::ndarray< int32_t,1 > > _4434_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _4435_sp,std::shared_ptr< monty::ndarray< int32_t,1 > > _4436_nidxs);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _4433_model,std::shared_ptr< monty::ndarray< int32_t,1 > > _4434_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _4435_sp,std::shared_ptr< monty::ndarray< int32_t,1 > > _4436_nidxs);
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2ParameterImpl__clone(monty::rc_ptr< ::mosek::fusion::Model > _4437_m) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Parameter__clone(monty::rc_ptr< ::mosek::fusion::Model > _4437_m) { return __mosek_2fusion_2ParameterImpl__clone(_4437_m); }
      virtual /* override */ std::string toString() ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2ParameterImpl__pick(std::shared_ptr< monty::ndarray< int32_t,2 > > _4440_midxs) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Parameter__pick(std::shared_ptr< monty::ndarray< int32_t,2 > > _4440_midxs) { return __mosek_2fusion_2ParameterImpl__pick(_4440_midxs); }
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2ParameterImpl__pick(std::shared_ptr< monty::ndarray< int32_t,1 > > _4462_idxs) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Parameter__pick(std::shared_ptr< monty::ndarray< int32_t,1 > > _4462_idxs) { return __mosek_2fusion_2ParameterImpl__pick(_4462_idxs); }
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2ParameterImpl__index(std::shared_ptr< monty::ndarray< int32_t,1 > > _4473_indexes) ;
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2Expression__index(std::shared_ptr< monty::ndarray< int32_t,1 > > _4473_indexes) { return __mosek_2fusion_2ParameterImpl__index(_4473_indexes); }
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2ParameterImpl__index(int32_t _4482_i) ;
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2Expression__index(int32_t _4482_i) { return __mosek_2fusion_2ParameterImpl__index(_4482_i); }
      virtual void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _4484_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _4485_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _4486_xs,bool _4487_cache_eval) ;
      virtual bool compress_when_caching() ;
      virtual void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _4509_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _4510_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _4511_xs) ;
      virtual void recursive_eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _4512_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _4513_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _4514_xs,bool _4515_cache_eval) ;
      virtual void getSp(std::shared_ptr< monty::ndarray< int64_t,1 > > _4516_dest,int32_t _4517_offset) ;
      virtual bool isSparse() ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2ParameterImpl__slice(std::shared_ptr< monty::ndarray< int32_t,1 > > _4520_astart,std::shared_ptr< monty::ndarray< int32_t,1 > > _4521_astop) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Parameter__slice(std::shared_ptr< monty::ndarray< int32_t,1 > > _4520_astart,std::shared_ptr< monty::ndarray< int32_t,1 > > _4521_astop) { return __mosek_2fusion_2ParameterImpl__slice(_4520_astart,_4521_astop); }
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2ParameterImpl__transpose() ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Parameter__transpose() { return __mosek_2fusion_2ParameterImpl__transpose(); }
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2ParameterImpl__slice(int32_t _4567_start,int32_t _4568_stop) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Parameter__slice(int32_t _4567_start,int32_t _4568_stop) { return __mosek_2fusion_2ParameterImpl__slice(_4567_start,_4568_stop); }
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2ParameterImpl__reshape(std::shared_ptr< monty::ndarray< int32_t,1 > > _4576_dims) ;
      virtual monty::rc_ptr< ::mosek::fusion::Parameter > __mosek_2fusion_2Parameter__reshape(std::shared_ptr< monty::ndarray< int32_t,1 > > _4576_dims) { return __mosek_2fusion_2ParameterImpl__reshape(_4576_dims); }
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2ParameterImpl__asExpr() ;
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2Parameter__asExpr() { return __mosek_2fusion_2ParameterImpl__asExpr(); }
      virtual int64_t getSize() ;
      virtual int32_t getNumNonzero() ;
      virtual int32_t getND() ;
      virtual std::shared_ptr< monty::ndarray< int32_t,1 > > getShape() ;
      virtual int32_t getDim(int32_t _4577_i) ;
      virtual void getAllIndexes(std::shared_ptr< monty::ndarray< int32_t,1 > > _4578_dst,int32_t _4579_ofs) ;
      virtual int32_t getIndex(int32_t _4581_i) ;
      virtual std::shared_ptr< monty::ndarray< double,1 > > getValue() ;
      virtual void setValue(std::shared_ptr< monty::ndarray< double,2 > > _4582_values2) ;
      virtual void setValue(std::shared_ptr< monty::ndarray< double,1 > > _4588_values) ;
      virtual void setValue(double _4591_value) ;
      virtual monty::rc_ptr< ::mosek::fusion::Model > __mosek_2fusion_2ParameterImpl__getModel() ;
      virtual monty::rc_ptr< ::mosek::fusion::Model > __mosek_2fusion_2Expression__getModel() { return __mosek_2fusion_2ParameterImpl__getModel(); }
    }; // struct ParameterImpl;

    struct p_ExprRangeDomain : public /*implements*/ virtual ::mosek::fusion::ExprDomain
    {
      ExprRangeDomain * _pubthis;
      static mosek::fusion::p_ExprRangeDomain* _get_impl(mosek::fusion::ExprRangeDomain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_ExprRangeDomain * _get_impl(mosek::fusion::ExprRangeDomain::t _inst) { return _get_impl(_inst.get()); }
      p_ExprRangeDomain(ExprRangeDomain * _pubthis);
      virtual ~p_ExprRangeDomain() { /* std::cout << "~p_ExprRangeDomain" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::RangeDomain > dom{};
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprRangeDomain::t _new_ExprRangeDomain(monty::rc_ptr< ::mosek::fusion::Expression > _7284_expr,monty::rc_ptr< ::mosek::fusion::RangeDomain > _7285_dom);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _7284_expr,monty::rc_ptr< ::mosek::fusion::RangeDomain > _7285_dom);
      virtual monty::rc_ptr< ::mosek::fusion::Term > __mosek_2fusion_2ExprRangeDomain__toDJCTerm() ;
      virtual monty::rc_ptr< ::mosek::fusion::Term > __mosek_2fusion_2ExprDomain__toDJCTerm() { return __mosek_2fusion_2ExprRangeDomain__toDJCTerm(); }
    }; // struct ExprRangeDomain;

    struct p_ExprPSDDomain
    {
      ExprPSDDomain * _pubthis;
      static mosek::fusion::p_ExprPSDDomain* _get_impl(mosek::fusion::ExprPSDDomain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_ExprPSDDomain * _get_impl(mosek::fusion::ExprPSDDomain::t _inst) { return _get_impl(_inst.get()); }
      p_ExprPSDDomain(ExprPSDDomain * _pubthis);
      virtual ~p_ExprPSDDomain() { /* std::cout << "~p_ExprPSDDomain" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::PSDDomain > dom{};
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprPSDDomain::t _new_ExprPSDDomain(monty::rc_ptr< ::mosek::fusion::Expression > _7286_expr,monty::rc_ptr< ::mosek::fusion::PSDDomain > _7287_dom);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _7286_expr,monty::rc_ptr< ::mosek::fusion::PSDDomain > _7287_dom);
    }; // struct ExprPSDDomain;

    struct p_ExprConicDomain
    {
      ExprConicDomain * _pubthis;
      static mosek::fusion::p_ExprConicDomain* _get_impl(mosek::fusion::ExprConicDomain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_ExprConicDomain * _get_impl(mosek::fusion::ExprConicDomain::t _inst) { return _get_impl(_inst.get()); }
      p_ExprConicDomain(ExprConicDomain * _pubthis);
      virtual ~p_ExprConicDomain() { /* std::cout << "~p_ExprConicDomain" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::ConeDomain > dom{};
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprConicDomain::t _new_ExprConicDomain(monty::rc_ptr< ::mosek::fusion::Expression > _7288_expr,monty::rc_ptr< ::mosek::fusion::ConeDomain > _7289_dom);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _7288_expr,monty::rc_ptr< ::mosek::fusion::ConeDomain > _7289_dom);
    }; // struct ExprConicDomain;

    struct p_ExprLinearDomain : public /*implements*/ virtual ::mosek::fusion::ExprDomain
    {
      ExprLinearDomain * _pubthis;
      static mosek::fusion::p_ExprLinearDomain* _get_impl(mosek::fusion::ExprLinearDomain * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_ExprLinearDomain * _get_impl(mosek::fusion::ExprLinearDomain::t _inst) { return _get_impl(_inst.get()); }
      p_ExprLinearDomain(ExprLinearDomain * _pubthis);
      virtual ~p_ExprLinearDomain() { /* std::cout << "~p_ExprLinearDomain" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::LinearDomain > dom{};
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprLinearDomain::t _new_ExprLinearDomain(monty::rc_ptr< ::mosek::fusion::Expression > _7290_expr,monty::rc_ptr< ::mosek::fusion::LinearDomain > _7291_dom);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _7290_expr,monty::rc_ptr< ::mosek::fusion::LinearDomain > _7291_dom);
      virtual monty::rc_ptr< ::mosek::fusion::Term > __mosek_2fusion_2ExprLinearDomain__toDJCTerm() ;
      virtual monty::rc_ptr< ::mosek::fusion::Term > __mosek_2fusion_2ExprDomain__toDJCTerm() { return __mosek_2fusion_2ExprLinearDomain__toDJCTerm(); }
    }; // struct ExprLinearDomain;

    struct p_BaseExpression : public /*implements*/ virtual ::mosek::fusion::Expression
    {
      BaseExpression * _pubthis;
      static mosek::fusion::p_BaseExpression* _get_impl(mosek::fusion::BaseExpression * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_BaseExpression * _get_impl(mosek::fusion::BaseExpression::t _inst) { return _get_impl(_inst.get()); }
      p_BaseExpression(BaseExpression * _pubthis);
      virtual ~p_BaseExpression() { /* std::cout << "~p_BaseExpression" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::WorkStack > evaluated{};
      bool has_evaluation{};
      monty::rc_ptr< ::mosek::fusion::Model > owner{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};

      virtual void destroy();

      static BaseExpression::t _new_BaseExpression(monty::rc_ptr< ::mosek::fusion::Model > _7292_owner,std::shared_ptr< monty::ndarray< int32_t,1 > > _7293_shape);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Model > _7292_owner,std::shared_ptr< monty::ndarray< int32_t,1 > > _7293_shape);
      virtual /* override */ std::string toString() ;
      virtual void printStack(monty::rc_ptr< ::mosek::fusion::WorkStack > _7294_rs) ;
      virtual void recursive_eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _7311_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _7312_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _7313_xs,bool _7314_cache_eval) ;
      virtual bool compress_when_caching() ;
      virtual void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _7315_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _7316_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _7317_xs) ;
      virtual void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _7318_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _7319_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _7320_xs,bool _7321_cache_eval) { throw monty::AbstractClassError("Call to abstract method"); }
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2BaseExpression__pick(std::shared_ptr< monty::ndarray< int32_t,2 > > _7322_indexrows) ;
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2Expression__pick(std::shared_ptr< monty::ndarray< int32_t,2 > > _7322_indexrows) { return __mosek_2fusion_2BaseExpression__pick(_7322_indexrows); }
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2BaseExpression__pick(std::shared_ptr< monty::ndarray< int32_t,1 > > _7323_indexes) ;
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2Expression__pick(std::shared_ptr< monty::ndarray< int32_t,1 > > _7323_indexes) { return __mosek_2fusion_2BaseExpression__pick(_7323_indexes); }
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2BaseExpression__index(std::shared_ptr< monty::ndarray< int32_t,1 > > _7326_indexes) ;
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2Expression__index(std::shared_ptr< monty::ndarray< int32_t,1 > > _7326_indexes) { return __mosek_2fusion_2BaseExpression__index(_7326_indexes); }
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2BaseExpression__index(int32_t _7329_i) ;
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2Expression__index(int32_t _7329_i) { return __mosek_2fusion_2BaseExpression__index(_7329_i); }
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2BaseExpression__slice(std::shared_ptr< monty::ndarray< int32_t,1 > > _7331_firsta,std::shared_ptr< monty::ndarray< int32_t,1 > > _7332_lasta) ;
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2Expression__slice(std::shared_ptr< monty::ndarray< int32_t,1 > > _7331_firsta,std::shared_ptr< monty::ndarray< int32_t,1 > > _7332_lasta) { return __mosek_2fusion_2BaseExpression__slice(_7331_firsta,_7332_lasta); }
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2BaseExpression__slice(int32_t _7333_first,int32_t _7334_last) ;
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2Expression__slice(int32_t _7333_first,int32_t _7334_last) { return __mosek_2fusion_2BaseExpression__slice(_7333_first,_7334_last); }
      virtual int64_t getSize() ;
      virtual int32_t getND() ;
      virtual int32_t getDim(int32_t _7335_d) ;
      virtual std::shared_ptr< monty::ndarray< int32_t,1 > > getShape() ;
      virtual monty::rc_ptr< ::mosek::fusion::Model > __mosek_2fusion_2BaseExpression__getModel() ;
      virtual monty::rc_ptr< ::mosek::fusion::Model > __mosek_2fusion_2Expression__getModel() { return __mosek_2fusion_2BaseExpression__getModel(); }
      static  monty::rc_ptr< ::mosek::fusion::Model > modelFrom(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _7336_es);
      static  monty::rc_ptr< ::mosek::fusion::Model > modelFrom(monty::rc_ptr< ::mosek::fusion::Model > _7339_m1,monty::rc_ptr< ::mosek::fusion::Expression > _7340_e2);
      static  monty::rc_ptr< ::mosek::fusion::Model > modelFrom(monty::rc_ptr< ::mosek::fusion::Expression > _7341_e1,monty::rc_ptr< ::mosek::fusion::Expression > _7342_e2);
      static  monty::rc_ptr< ::mosek::fusion::Model > modelFrom(monty::rc_ptr< ::mosek::fusion::Model > _7343_m1,monty::rc_ptr< ::mosek::fusion::Model > _7344_m2);
    }; // struct BaseExpression;

    struct p_ExprParameter : public ::mosek::fusion::p_BaseExpression
    {
      ExprParameter * _pubthis;
      static mosek::fusion::p_ExprParameter* _get_impl(mosek::fusion::ExprParameter * _inst){ return static_cast< mosek::fusion::p_ExprParameter* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprParameter * _get_impl(mosek::fusion::ExprParameter::t _inst) { return _get_impl(_inst.get()); }
      p_ExprParameter(ExprParameter * _pubthis);
      virtual ~p_ExprParameter() { /* std::cout << "~p_ExprParameter" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Parameter > p{};

      virtual void destroy();

      static ExprParameter::t _new_ExprParameter(monty::rc_ptr< ::mosek::fusion::Parameter > _3597_p);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Parameter > _3597_p);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _3598_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _3599_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _3600_xs,bool _3601_cache_eval) ;
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2ExprParameter__slice(std::shared_ptr< monty::ndarray< int32_t,1 > > _3602_start,std::shared_ptr< monty::ndarray< int32_t,1 > > _3603_stop) ;
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2BaseExpression__slice(std::shared_ptr< monty::ndarray< int32_t,1 > > _3602_start,std::shared_ptr< monty::ndarray< int32_t,1 > > _3603_stop) { return __mosek_2fusion_2ExprParameter__slice(_3602_start,_3603_stop); }
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2ExprParameter__slice(int32_t _3604_start,int32_t _3605_stop) ;
      virtual monty::rc_ptr< ::mosek::fusion::Expression > __mosek_2fusion_2BaseExpression__slice(int32_t _3604_start,int32_t _3605_stop) { return __mosek_2fusion_2ExprParameter__slice(_3604_start,_3605_stop); }
      virtual /* override */ std::string toString() ;
    }; // struct ExprParameter;

    struct p_ExprMulParamScalarExpr : public ::mosek::fusion::p_BaseExpression
    {
      ExprMulParamScalarExpr * _pubthis;
      static mosek::fusion::p_ExprMulParamScalarExpr* _get_impl(mosek::fusion::ExprMulParamScalarExpr * _inst){ return static_cast< mosek::fusion::p_ExprMulParamScalarExpr* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprMulParamScalarExpr * _get_impl(mosek::fusion::ExprMulParamScalarExpr::t _inst) { return _get_impl(_inst.get()); }
      p_ExprMulParamScalarExpr(ExprMulParamScalarExpr * _pubthis);
      virtual ~p_ExprMulParamScalarExpr() { /* std::cout << "~p_ExprMulParamScalarExpr" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > e{};
      monty::rc_ptr< ::mosek::fusion::Parameter > p{};

      virtual void destroy();

      static ExprMulParamScalarExpr::t _new_ExprMulParamScalarExpr(monty::rc_ptr< ::mosek::fusion::Parameter > _3693_p,monty::rc_ptr< ::mosek::fusion::Expression > _3694_e);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Parameter > _3693_p,monty::rc_ptr< ::mosek::fusion::Expression > _3694_e);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _3695_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _3696_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _3697_xs,bool _3698_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprMulParamScalarExpr;

    struct p_ExprMulParamScalar : public ::mosek::fusion::p_BaseExpression
    {
      ExprMulParamScalar * _pubthis;
      static mosek::fusion::p_ExprMulParamScalar* _get_impl(mosek::fusion::ExprMulParamScalar * _inst){ return static_cast< mosek::fusion::p_ExprMulParamScalar* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprMulParamScalar * _get_impl(mosek::fusion::ExprMulParamScalar::t _inst) { return _get_impl(_inst.get()); }
      p_ExprMulParamScalar(ExprMulParamScalar * _pubthis);
      virtual ~p_ExprMulParamScalar() { /* std::cout << "~p_ExprMulParamScalar" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > e{};
      monty::rc_ptr< ::mosek::fusion::Parameter > p{};

      virtual void destroy();

      static ExprMulParamScalar::t _new_ExprMulParamScalar(monty::rc_ptr< ::mosek::fusion::Parameter > _3749_p,monty::rc_ptr< ::mosek::fusion::Expression > _3750_e);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Parameter > _3749_p,monty::rc_ptr< ::mosek::fusion::Expression > _3750_e);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _3751_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _3752_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _3753_xs,bool _3754_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprMulParamScalar;

    struct p_ExprMulParamDiagLeft : public ::mosek::fusion::p_BaseExpression
    {
      ExprMulParamDiagLeft * _pubthis;
      static mosek::fusion::p_ExprMulParamDiagLeft* _get_impl(mosek::fusion::ExprMulParamDiagLeft * _inst){ return static_cast< mosek::fusion::p_ExprMulParamDiagLeft* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprMulParamDiagLeft * _get_impl(mosek::fusion::ExprMulParamDiagLeft::t _inst) { return _get_impl(_inst.get()); }
      p_ExprMulParamDiagLeft(ExprMulParamDiagLeft * _pubthis);
      virtual ~p_ExprMulParamDiagLeft() { /* std::cout << "~p_ExprMulParamDiagLeft" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > e{};
      monty::rc_ptr< ::mosek::fusion::Parameter > p{};

      virtual void destroy();

      static ExprMulParamDiagLeft::t _new_ExprMulParamDiagLeft(monty::rc_ptr< ::mosek::fusion::Parameter > _3797_p,monty::rc_ptr< ::mosek::fusion::Expression > _3798_e);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Parameter > _3797_p,monty::rc_ptr< ::mosek::fusion::Expression > _3798_e);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _3799_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _3800_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _3801_xs,bool _3802_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprMulParamDiagLeft;

    struct p_ExprMulParamDiagRight : public ::mosek::fusion::p_BaseExpression
    {
      ExprMulParamDiagRight * _pubthis;
      static mosek::fusion::p_ExprMulParamDiagRight* _get_impl(mosek::fusion::ExprMulParamDiagRight * _inst){ return static_cast< mosek::fusion::p_ExprMulParamDiagRight* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprMulParamDiagRight * _get_impl(mosek::fusion::ExprMulParamDiagRight::t _inst) { return _get_impl(_inst.get()); }
      p_ExprMulParamDiagRight(ExprMulParamDiagRight * _pubthis);
      virtual ~p_ExprMulParamDiagRight() { /* std::cout << "~p_ExprMulParamDiagRight" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > e{};
      monty::rc_ptr< ::mosek::fusion::Parameter > p{};

      virtual void destroy();

      static ExprMulParamDiagRight::t _new_ExprMulParamDiagRight(monty::rc_ptr< ::mosek::fusion::Expression > _3917_e,monty::rc_ptr< ::mosek::fusion::Parameter > _3918_p);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _3917_e,monty::rc_ptr< ::mosek::fusion::Parameter > _3918_p);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _3919_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _3920_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _3921_xs,bool _3922_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprMulParamDiagRight;

    struct p_ExprDotParam : public ::mosek::fusion::p_BaseExpression
    {
      ExprDotParam * _pubthis;
      static mosek::fusion::p_ExprDotParam* _get_impl(mosek::fusion::ExprDotParam * _inst){ return static_cast< mosek::fusion::p_ExprDotParam* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprDotParam * _get_impl(mosek::fusion::ExprDotParam::t _inst) { return _get_impl(_inst.get()); }
      p_ExprDotParam(ExprDotParam * _pubthis);
      virtual ~p_ExprDotParam() { /* std::cout << "~p_ExprDotParam" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > e{};
      monty::rc_ptr< ::mosek::fusion::Parameter > p{};

      virtual void destroy();

      static ExprDotParam::t _new_ExprDotParam(monty::rc_ptr< ::mosek::fusion::Parameter > _4036_p,monty::rc_ptr< ::mosek::fusion::Expression > _4037_e);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Parameter > _4036_p,monty::rc_ptr< ::mosek::fusion::Expression > _4037_e);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _4039_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _4040_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _4041_xs,bool _4042_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprDotParam;

    struct p_ExprMulParamElem : public ::mosek::fusion::p_BaseExpression
    {
      ExprMulParamElem * _pubthis;
      static mosek::fusion::p_ExprMulParamElem* _get_impl(mosek::fusion::ExprMulParamElem * _inst){ return static_cast< mosek::fusion::p_ExprMulParamElem* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprMulParamElem * _get_impl(mosek::fusion::ExprMulParamElem::t _inst) { return _get_impl(_inst.get()); }
      p_ExprMulParamElem(ExprMulParamElem * _pubthis);
      virtual ~p_ExprMulParamElem() { /* std::cout << "~p_ExprMulParamElem" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > e{};
      monty::rc_ptr< ::mosek::fusion::Parameter > p{};

      virtual void destroy();

      static ExprMulParamElem::t _new_ExprMulParamElem(monty::rc_ptr< ::mosek::fusion::Parameter > _4100_p,monty::rc_ptr< ::mosek::fusion::Expression > _4101_e);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Parameter > _4100_p,monty::rc_ptr< ::mosek::fusion::Expression > _4101_e);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _4103_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _4104_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _4105_xs,bool _4106_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprMulParamElem;

    struct p_ExprMulParamRight : public ::mosek::fusion::p_BaseExpression
    {
      ExprMulParamRight * _pubthis;
      static mosek::fusion::p_ExprMulParamRight* _get_impl(mosek::fusion::ExprMulParamRight * _inst){ return static_cast< mosek::fusion::p_ExprMulParamRight* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprMulParamRight * _get_impl(mosek::fusion::ExprMulParamRight::t _inst) { return _get_impl(_inst.get()); }
      p_ExprMulParamRight(ExprMulParamRight * _pubthis);
      virtual ~p_ExprMulParamRight() { /* std::cout << "~p_ExprMulParamRight" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > e{};
      monty::rc_ptr< ::mosek::fusion::Parameter > p{};

      virtual void destroy();

      static ExprMulParamRight::t _new_ExprMulParamRight(monty::rc_ptr< ::mosek::fusion::Expression > _4168_e,monty::rc_ptr< ::mosek::fusion::Parameter > _4169_p);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _4168_e,monty::rc_ptr< ::mosek::fusion::Parameter > _4169_p);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _4170_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _4171_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _4172_xs,bool _4173_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprMulParamRight;

    struct p_ExprMulParamLeft : public ::mosek::fusion::p_BaseExpression
    {
      ExprMulParamLeft * _pubthis;
      static mosek::fusion::p_ExprMulParamLeft* _get_impl(mosek::fusion::ExprMulParamLeft * _inst){ return static_cast< mosek::fusion::p_ExprMulParamLeft* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprMulParamLeft * _get_impl(mosek::fusion::ExprMulParamLeft::t _inst) { return _get_impl(_inst.get()); }
      p_ExprMulParamLeft(ExprMulParamLeft * _pubthis);
      virtual ~p_ExprMulParamLeft() { /* std::cout << "~p_ExprMulParamLeft" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > e{};
      monty::rc_ptr< ::mosek::fusion::Parameter > p{};

      virtual void destroy();

      static ExprMulParamLeft::t _new_ExprMulParamLeft(monty::rc_ptr< ::mosek::fusion::Parameter > _4273_p,monty::rc_ptr< ::mosek::fusion::Expression > _4274_e);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Parameter > _4273_p,monty::rc_ptr< ::mosek::fusion::Expression > _4274_e);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _4275_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _4276_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _4277_xs,bool _4278_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprMulParamLeft;

    struct p_ExprOptimizeCode : public ::mosek::fusion::p_BaseExpression
    {
      ExprOptimizeCode * _pubthis;
      static mosek::fusion::p_ExprOptimizeCode* _get_impl(mosek::fusion::ExprOptimizeCode * _inst){ return static_cast< mosek::fusion::p_ExprOptimizeCode* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprOptimizeCode * _get_impl(mosek::fusion::ExprOptimizeCode::t _inst) { return _get_impl(_inst.get()); }
      p_ExprOptimizeCode(ExprOptimizeCode * _pubthis);
      virtual ~p_ExprOptimizeCode() { /* std::cout << "~p_ExprOptimizeCode" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprOptimizeCode::t _new_ExprOptimizeCode(monty::rc_ptr< ::mosek::fusion::Expression > _4611_expr);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _4611_expr);
      static  void compress_code(monty::rc_ptr< ::mosek::fusion::WorkStack > _4612_xs,int32_t _4613_n,std::shared_ptr< monty::ndarray< int32_t,1 > > _4614_code,int32_t _4615_code_base,std::shared_ptr< monty::ndarray< int32_t,1 > > _4616_ptr,int32_t _4617_ptr_base,std::shared_ptr< monty::ndarray< double,1 > > _4618_fixterm,int32_t _4619_fixterm_base,std::shared_ptr< monty::ndarray< double,1 > > _4620_code_consts,int32_t _4621_code_consts_base,int32_t _4622_target_code_base,int32_t _4623_target_const_base,int32_t _4624_target_ptr_base);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _4677_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _4678_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _4679_xs,bool _4680_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprOptimizeCode;

    struct p_ExprCompress : public ::mosek::fusion::p_BaseExpression
    {
      ExprCompress * _pubthis;
      static mosek::fusion::p_ExprCompress* _get_impl(mosek::fusion::ExprCompress * _inst){ return static_cast< mosek::fusion::p_ExprCompress* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprCompress * _get_impl(mosek::fusion::ExprCompress::t _inst) { return _get_impl(_inst.get()); }
      p_ExprCompress(ExprCompress * _pubthis);
      virtual ~p_ExprCompress() { /* std::cout << "~p_ExprCompress" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprCompress::t _new_ExprCompress(monty::rc_ptr< ::mosek::fusion::Expression > _4747_expr);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _4747_expr);
      static  void arg_sort(monty::rc_ptr< ::mosek::fusion::WorkStack > _4748_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _4749_xs,int32_t _4750_perm,int32_t _4751_nelem,int32_t _4752_nnz,int32_t _4753_ptr,int32_t _4754_nidxs);
      static  void merge_sort(int32_t _4790_origperm1,int32_t _4791_origperm2,int32_t _4792_nelem,int32_t _4793_nnz,int32_t _4794_ptr_base,int32_t _4795_nidxs_base,std::shared_ptr< monty::ndarray< int32_t,1 > > _4796_wi32,std::shared_ptr< monty::ndarray< int64_t,1 > > _4797_wi64);
      virtual void eval_continue(monty::rc_ptr< ::mosek::fusion::WorkStack > _4820_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _4821_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _4822_xs) ;
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _4908_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _4909_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _4910_xs,bool _4911_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprCompress;

    struct p_ExprConst : public ::mosek::fusion::p_BaseExpression
    {
      ExprConst * _pubthis;
      static mosek::fusion::p_ExprConst* _get_impl(mosek::fusion::ExprConst * _inst){ return static_cast< mosek::fusion::p_ExprConst* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprConst * _get_impl(mosek::fusion::ExprConst::t _inst) { return _get_impl(_inst.get()); }
      p_ExprConst(ExprConst * _pubthis);
      virtual ~p_ExprConst() { /* std::cout << "~p_ExprConst" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< int64_t,1 > > sparsity{};
      std::shared_ptr< monty::ndarray< double,1 > > bfix{};

      virtual void destroy();

      static ExprConst::t _new_ExprConst(std::shared_ptr< monty::ndarray< int32_t,1 > > _4912_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _4913_sparsity,std::shared_ptr< monty::ndarray< double,1 > > _4914_bfix);
      void _initialize(std::shared_ptr< monty::ndarray< int32_t,1 > > _4912_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _4913_sparsity,std::shared_ptr< monty::ndarray< double,1 > > _4914_bfix);
      static ExprConst::t _new_ExprConst(std::shared_ptr< monty::ndarray< int32_t,1 > > _4915_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _4916_sparsity,double _4917_bfix);
      void _initialize(std::shared_ptr< monty::ndarray< int32_t,1 > > _4915_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _4916_sparsity,double _4917_bfix);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _4920_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _4921_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _4922_xs,bool _4923_cache_eval) ;
      virtual /* override */ void recursive_eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _4942_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _4943_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _4944_xs,bool _4945_cache_eval) ;
      static  void validate(std::shared_ptr< monty::ndarray< int32_t,1 > > _4946_shape,std::shared_ptr< monty::ndarray< double,1 > > _4947_bfix,std::shared_ptr< monty::ndarray< int64_t,1 > > _4948_sparsity);
      virtual /* override */ std::string toString() ;
    }; // struct ExprConst;

    struct p_ExprPick : public ::mosek::fusion::p_BaseExpression
    {
      ExprPick * _pubthis;
      static mosek::fusion::p_ExprPick* _get_impl(mosek::fusion::ExprPick * _inst){ return static_cast< mosek::fusion::p_ExprPick* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprPick * _get_impl(mosek::fusion::ExprPick::t _inst) { return _get_impl(_inst.get()); }
      p_ExprPick(ExprPick * _pubthis);
      virtual ~p_ExprPick() { /* std::cout << "~p_ExprPick" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< int64_t,1 > > idxs{};
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprPick::t _new_ExprPick(monty::rc_ptr< ::mosek::fusion::Expression > _4952_expr,std::shared_ptr< monty::ndarray< int32_t,2 > > _4953_idxs);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _4952_expr,std::shared_ptr< monty::ndarray< int32_t,2 > > _4953_idxs);
      static ExprPick::t _new_ExprPick(monty::rc_ptr< ::mosek::fusion::Expression > _4965_expr,std::shared_ptr< monty::ndarray< int64_t,1 > > _4966_idxs);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _4965_expr,std::shared_ptr< monty::ndarray< int64_t,1 > > _4966_idxs);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _4971_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _4972_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _4973_xs,bool _4974_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprPick;

    struct p_ExprSlice : public ::mosek::fusion::p_BaseExpression
    {
      ExprSlice * _pubthis;
      static mosek::fusion::p_ExprSlice* _get_impl(mosek::fusion::ExprSlice * _inst){ return static_cast< mosek::fusion::p_ExprSlice* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprSlice * _get_impl(mosek::fusion::ExprSlice::t _inst) { return _get_impl(_inst.get()); }
      p_ExprSlice(ExprSlice * _pubthis);
      virtual ~p_ExprSlice() { /* std::cout << "~p_ExprSlice" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< int32_t,1 > > last{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > first{};
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprSlice::t _new_ExprSlice(monty::rc_ptr< ::mosek::fusion::Expression > _5039_expr,std::shared_ptr< monty::ndarray< int32_t,1 > > _5040_first,std::shared_ptr< monty::ndarray< int32_t,1 > > _5041_last);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _5039_expr,std::shared_ptr< monty::ndarray< int32_t,1 > > _5040_first,std::shared_ptr< monty::ndarray< int32_t,1 > > _5041_last);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _5042_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _5043_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _5044_xs,bool _5045_cache_eval) ;
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > makeShape(std::shared_ptr< monty::ndarray< int32_t,1 > > _5110_shape,std::shared_ptr< monty::ndarray< int32_t,1 > > _5111_first,std::shared_ptr< monty::ndarray< int32_t,1 > > _5112_last);
      virtual /* override */ std::string toString() ;
    }; // struct ExprSlice;

    struct p_ExprPermuteDims : public ::mosek::fusion::p_BaseExpression
    {
      ExprPermuteDims * _pubthis;
      static mosek::fusion::p_ExprPermuteDims* _get_impl(mosek::fusion::ExprPermuteDims * _inst){ return static_cast< mosek::fusion::p_ExprPermuteDims* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprPermuteDims * _get_impl(mosek::fusion::ExprPermuteDims::t _inst) { return _get_impl(_inst.get()); }
      p_ExprPermuteDims(ExprPermuteDims * _pubthis);
      virtual ~p_ExprPermuteDims() { /* std::cout << "~p_ExprPermuteDims" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< int32_t,1 > > dperm{};
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprPermuteDims::t _new_ExprPermuteDims(std::shared_ptr< monty::ndarray< int32_t,1 > > _5117_perm,monty::rc_ptr< ::mosek::fusion::Expression > _5118_expr);
      void _initialize(std::shared_ptr< monty::ndarray< int32_t,1 > > _5117_perm,monty::rc_ptr< ::mosek::fusion::Expression > _5118_expr);
      static ExprPermuteDims::t _new_ExprPermuteDims(std::shared_ptr< monty::ndarray< int32_t,1 > > _5124_perm,monty::rc_ptr< ::mosek::fusion::Expression > _5125_expr,int32_t _5126_validated);
      void _initialize(std::shared_ptr< monty::ndarray< int32_t,1 > > _5124_perm,monty::rc_ptr< ::mosek::fusion::Expression > _5125_expr,int32_t _5126_validated);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _5127_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _5128_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _5129_xs,bool _5130_cache_eval) ;
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > computeshape(std::shared_ptr< monty::ndarray< int32_t,1 > > _5188_perm,std::shared_ptr< monty::ndarray< int32_t,1 > > _5189_shape);
    }; // struct ExprPermuteDims;

    struct p_ExprTranspose : public ::mosek::fusion::p_BaseExpression
    {
      ExprTranspose * _pubthis;
      static mosek::fusion::p_ExprTranspose* _get_impl(mosek::fusion::ExprTranspose * _inst){ return static_cast< mosek::fusion::p_ExprTranspose* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprTranspose * _get_impl(mosek::fusion::ExprTranspose::t _inst) { return _get_impl(_inst.get()); }
      p_ExprTranspose(ExprTranspose * _pubthis);
      virtual ~p_ExprTranspose() { /* std::cout << "~p_ExprTranspose" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprTranspose::t _new_ExprTranspose(monty::rc_ptr< ::mosek::fusion::Expression > _5191_expr);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _5191_expr);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _5192_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _5193_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _5194_xs,bool _5195_cache_eval) ;
      virtual /* override */ std::string toString() ;
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > transposeShape(std::shared_ptr< monty::ndarray< int32_t,1 > > _5250_shape);
    }; // struct ExprTranspose;

    struct p_ExprRepeat : public ::mosek::fusion::p_BaseExpression
    {
      ExprRepeat * _pubthis;
      static mosek::fusion::p_ExprRepeat* _get_impl(mosek::fusion::ExprRepeat * _inst){ return static_cast< mosek::fusion::p_ExprRepeat* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprRepeat * _get_impl(mosek::fusion::ExprRepeat::t _inst) { return _get_impl(_inst.get()); }
      p_ExprRepeat(ExprRepeat * _pubthis);
      virtual ~p_ExprRepeat() { /* std::cout << "~p_ExprRepeat" << std::endl;*/ };
      int32_t n{};
      int32_t dim{};
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprRepeat::t _new_ExprRepeat(monty::rc_ptr< ::mosek::fusion::Expression > _5251_expr,int32_t _5252_dim,int32_t _5253_n);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _5251_expr,int32_t _5252_dim,int32_t _5253_n);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _5254_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _5255_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _5256_xs,bool _5257_cache_eval) ;
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > getshape(monty::rc_ptr< ::mosek::fusion::Expression > _5322_e,int32_t _5323_dim,int32_t _5324_n);
      virtual /* override */ std::string toString() ;
    }; // struct ExprRepeat;

    struct p_ExprStack : public ::mosek::fusion::p_BaseExpression
    {
      ExprStack * _pubthis;
      static mosek::fusion::p_ExprStack* _get_impl(mosek::fusion::ExprStack * _inst){ return static_cast< mosek::fusion::p_ExprStack* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprStack * _get_impl(mosek::fusion::ExprStack::t _inst) { return _get_impl(_inst.get()); }
      p_ExprStack(ExprStack * _pubthis);
      virtual ~p_ExprStack() { /* std::cout << "~p_ExprStack" << std::endl;*/ };
      int32_t dim{};
      std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > exprs{};

      virtual void destroy();

      static ExprStack::t _new_ExprStack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _5329_exprs,int32_t _5330_dim);
      void _initialize(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _5329_exprs,int32_t _5330_dim);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _5332_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _5333_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _5334_xs,bool _5335_cache_eval) ;
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > getshape(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _5479_es,int32_t _5480_dim);
      virtual /* override */ std::string toString() ;
    }; // struct ExprStack;

    struct p_ExprInner : public ::mosek::fusion::p_BaseExpression
    {
      ExprInner * _pubthis;
      static mosek::fusion::p_ExprInner* _get_impl(mosek::fusion::ExprInner * _inst){ return static_cast< mosek::fusion::p_ExprInner* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprInner * _get_impl(mosek::fusion::ExprInner::t _inst) { return _get_impl(_inst.get()); }
      p_ExprInner(ExprInner * _pubthis);
      virtual ~p_ExprInner() { /* std::cout << "~p_ExprInner" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< double,1 > > vcof{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > vsub{};
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprInner::t _new_ExprInner(monty::rc_ptr< ::mosek::fusion::Expression > _5494_expr3,std::shared_ptr< monty::ndarray< int64_t,1 > > _5495_vsub3,std::shared_ptr< monty::ndarray< double,1 > > _5496_vcof3);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _5494_expr3,std::shared_ptr< monty::ndarray< int64_t,1 > > _5495_vsub3,std::shared_ptr< monty::ndarray< double,1 > > _5496_vcof3);
      static ExprInner::t _new_ExprInner(monty::rc_ptr< ::mosek::fusion::Expression > _5502_expr2,std::shared_ptr< monty::ndarray< double,1 > > _5503_vcof2);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _5502_expr2,std::shared_ptr< monty::ndarray< double,1 > > _5503_vcof2);
      static ExprInner::t _new_ExprInner(monty::rc_ptr< ::mosek::fusion::Expression > _5505_expr1,std::shared_ptr< monty::ndarray< int32_t,2 > > _5506_vsub1,std::shared_ptr< monty::ndarray< double,1 > > _5507_vcof1);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _5505_expr1,std::shared_ptr< monty::ndarray< int32_t,2 > > _5506_vsub1,std::shared_ptr< monty::ndarray< double,1 > > _5507_vcof1);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _5508_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _5509_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _5510_xs,bool _5511_cache_eval) ;
      static  std::shared_ptr< monty::ndarray< int64_t,1 > > range(int32_t _5555_n);
      static  std::shared_ptr< monty::ndarray< int64_t,1 > > convert(std::shared_ptr< monty::ndarray< int32_t,1 > > _5557_shape,std::shared_ptr< monty::ndarray< int32_t,2 > > _5558_vsub);
      virtual /* override */ std::string toString() ;
    }; // struct ExprInner;

    struct p_ExprMulDiagRight : public ::mosek::fusion::p_BaseExpression
    {
      ExprMulDiagRight * _pubthis;
      static mosek::fusion::p_ExprMulDiagRight* _get_impl(mosek::fusion::ExprMulDiagRight * _inst){ return static_cast< mosek::fusion::p_ExprMulDiagRight* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprMulDiagRight * _get_impl(mosek::fusion::ExprMulDiagRight::t _inst) { return _get_impl(_inst.get()); }
      p_ExprMulDiagRight(ExprMulDiagRight * _pubthis);
      virtual ~p_ExprMulDiagRight() { /* std::cout << "~p_ExprMulDiagRight" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};
      std::shared_ptr< monty::ndarray< double,1 > > mval{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > msubj{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > msubi{};
      int32_t mdim1{};
      int32_t mdim0{};

      virtual void destroy();

      static ExprMulDiagRight::t _new_ExprMulDiagRight(int32_t _5565_mdim0,int32_t _5566_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5567_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5568_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5569_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5570_expr,int32_t _5571_validated);
      void _initialize(int32_t _5565_mdim0,int32_t _5566_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5567_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5568_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5569_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5570_expr,int32_t _5571_validated);
      static ExprMulDiagRight::t _new_ExprMulDiagRight(int32_t _5572_mdim0,int32_t _5573_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5574_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5575_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5576_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5577_expr);
      void _initialize(int32_t _5572_mdim0,int32_t _5573_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5574_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5575_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5576_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5577_expr);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _5578_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _5579_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _5580_xs,bool _5581_cache_eval) ;
      static  int32_t validate(int32_t _5660_mdim0,int32_t _5661_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5662_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5663_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5664_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5665_expr);
      virtual /* override */ std::string toString() ;
    }; // struct ExprMulDiagRight;

    struct p_ExprMulDiagLeft : public ::mosek::fusion::p_BaseExpression
    {
      ExprMulDiagLeft * _pubthis;
      static mosek::fusion::p_ExprMulDiagLeft* _get_impl(mosek::fusion::ExprMulDiagLeft * _inst){ return static_cast< mosek::fusion::p_ExprMulDiagLeft* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprMulDiagLeft * _get_impl(mosek::fusion::ExprMulDiagLeft::t _inst) { return _get_impl(_inst.get()); }
      p_ExprMulDiagLeft(ExprMulDiagLeft * _pubthis);
      virtual ~p_ExprMulDiagLeft() { /* std::cout << "~p_ExprMulDiagLeft" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};
      std::shared_ptr< monty::ndarray< double,1 > > mval{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > msubj{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > msubi{};
      int32_t mdim1{};
      int32_t mdim0{};

      virtual void destroy();

      static ExprMulDiagLeft::t _new_ExprMulDiagLeft(int32_t _5674_mdim0,int32_t _5675_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5676_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5677_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5678_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5679_expr,int32_t _5680_validated);
      void _initialize(int32_t _5674_mdim0,int32_t _5675_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5676_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5677_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5678_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5679_expr,int32_t _5680_validated);
      static ExprMulDiagLeft::t _new_ExprMulDiagLeft(int32_t _5681_mdim0,int32_t _5682_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5683_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5684_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5685_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5686_expr);
      void _initialize(int32_t _5681_mdim0,int32_t _5682_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5683_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5684_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5685_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5686_expr);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _5687_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _5688_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _5689_xs,bool _5690_cache_eval) ;
      static  int32_t validate(int32_t _5788_mdim0,int32_t _5789_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5790_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5791_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5792_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5793_expr);
      virtual /* override */ std::string toString() ;
    }; // struct ExprMulDiagLeft;

    struct p_ExprMulElement : public ::mosek::fusion::p_BaseExpression
    {
      ExprMulElement * _pubthis;
      static mosek::fusion::p_ExprMulElement* _get_impl(mosek::fusion::ExprMulElement * _inst){ return static_cast< mosek::fusion::p_ExprMulElement* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprMulElement * _get_impl(mosek::fusion::ExprMulElement::t _inst) { return _get_impl(_inst.get()); }
      p_ExprMulElement(ExprMulElement * _pubthis);
      virtual ~p_ExprMulElement() { /* std::cout << "~p_ExprMulElement" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > msp{};
      std::shared_ptr< monty::ndarray< double,1 > > mcof{};

      virtual void destroy();

      static ExprMulElement::t _new_ExprMulElement(std::shared_ptr< monty::ndarray< double,1 > > _5802_mcof,std::shared_ptr< monty::ndarray< int64_t,1 > > _5803_msp,monty::rc_ptr< ::mosek::fusion::Expression > _5804_expr);
      void _initialize(std::shared_ptr< monty::ndarray< double,1 > > _5802_mcof,std::shared_ptr< monty::ndarray< int64_t,1 > > _5803_msp,monty::rc_ptr< ::mosek::fusion::Expression > _5804_expr);
      static ExprMulElement::t _new_ExprMulElement(std::shared_ptr< monty::ndarray< double,1 > > _5811_cof,std::shared_ptr< monty::ndarray< int64_t,1 > > _5812_msp,monty::rc_ptr< ::mosek::fusion::Expression > _5813_expr,int32_t _5814_validated);
      void _initialize(std::shared_ptr< monty::ndarray< double,1 > > _5811_cof,std::shared_ptr< monty::ndarray< int64_t,1 > > _5812_msp,monty::rc_ptr< ::mosek::fusion::Expression > _5813_expr,int32_t _5814_validated);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _5815_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _5816_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _5817_xs,bool _5818_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprMulElement;

    struct p_ExprMulScalarConst : public ::mosek::fusion::p_BaseExpression
    {
      ExprMulScalarConst * _pubthis;
      static mosek::fusion::p_ExprMulScalarConst* _get_impl(mosek::fusion::ExprMulScalarConst * _inst){ return static_cast< mosek::fusion::p_ExprMulScalarConst* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprMulScalarConst * _get_impl(mosek::fusion::ExprMulScalarConst::t _inst) { return _get_impl(_inst.get()); }
      p_ExprMulScalarConst(ExprMulScalarConst * _pubthis);
      virtual ~p_ExprMulScalarConst() { /* std::cout << "~p_ExprMulScalarConst" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};
      double c{};

      virtual void destroy();

      static ExprMulScalarConst::t _new_ExprMulScalarConst(double _5876_c,monty::rc_ptr< ::mosek::fusion::Expression > _5877_expr);
      void _initialize(double _5876_c,monty::rc_ptr< ::mosek::fusion::Expression > _5877_expr);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _5878_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _5879_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _5880_xs,bool _5881_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprMulScalarConst;

    struct p_ExprScalarMul : public ::mosek::fusion::p_BaseExpression
    {
      ExprScalarMul * _pubthis;
      static mosek::fusion::p_ExprScalarMul* _get_impl(mosek::fusion::ExprScalarMul * _inst){ return static_cast< mosek::fusion::p_ExprScalarMul* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprScalarMul * _get_impl(mosek::fusion::ExprScalarMul::t _inst) { return _get_impl(_inst.get()); }
      p_ExprScalarMul(ExprScalarMul * _pubthis);
      virtual ~p_ExprScalarMul() { /* std::cout << "~p_ExprScalarMul" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};
      std::shared_ptr< monty::ndarray< double,1 > > mval{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > msubj{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > msubi{};
      int32_t mdim1{};
      int32_t mdim0{};

      virtual void destroy();

      static ExprScalarMul::t _new_ExprScalarMul(int32_t _5919_mdim0,int32_t _5920_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5921_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5922_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5923_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5924_expr,int32_t _5925_validated);
      void _initialize(int32_t _5919_mdim0,int32_t _5920_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5921_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5922_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5923_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5924_expr,int32_t _5925_validated);
      static ExprScalarMul::t _new_ExprScalarMul(int32_t _5926_mdim0,int32_t _5927_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5928_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5929_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5930_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5931_expr);
      void _initialize(int32_t _5926_mdim0,int32_t _5927_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5928_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5929_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5930_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5931_expr);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _5932_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _5933_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _5934_xs,bool _5935_cache_eval) ;
      static  int32_t validate(int32_t _5971_mdim0,int32_t _5972_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5973_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5974_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5975_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5976_expr);
      virtual /* override */ std::string toString() ;
    }; // struct ExprScalarMul;

    struct p_ExprCrossDot : public ::mosek::fusion::p_BaseExpression
    {
      ExprCrossDot * _pubthis;
      static mosek::fusion::p_ExprCrossDot* _get_impl(mosek::fusion::ExprCrossDot * _inst){ return static_cast< mosek::fusion::p_ExprCrossDot* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprCrossDot * _get_impl(mosek::fusion::ExprCrossDot::t _inst) { return _get_impl(_inst.get()); }
      p_ExprCrossDot(ExprCrossDot * _pubthis);
      virtual ~p_ExprCrossDot() { /* std::cout << "~p_ExprCrossDot" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};
      std::shared_ptr< monty::ndarray< double,1 > > mval{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > msubj{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > msubi{};
      int32_t mdim1{};
      int32_t mdim0{};

      virtual void destroy();

      static ExprCrossDot::t _new_ExprCrossDot(monty::rc_ptr< ::mosek::fusion::Matrix > _5983_m,monty::rc_ptr< ::mosek::fusion::Expression > _5984_expr);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Matrix > _5983_m,monty::rc_ptr< ::mosek::fusion::Expression > _5984_expr);
      static ExprCrossDot::t _new_ExprCrossDot(int32_t _5986_mdim0,int32_t _5987_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5988_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5989_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5990_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5991_expr,int32_t _5992_validated);
      void _initialize(int32_t _5986_mdim0,int32_t _5987_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _5988_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _5989_msubj,std::shared_ptr< monty::ndarray< double,1 > > _5990_mval,monty::rc_ptr< ::mosek::fusion::Expression > _5991_expr,int32_t _5992_validated);
      static ExprCrossDot::t _new_ExprCrossDot(int32_t _5993_mdim0__,int32_t _5994_mdim1__,std::shared_ptr< monty::ndarray< double,1 > > _5995_mval__,monty::rc_ptr< ::mosek::fusion::Expression > _5996_expr__);
      void _initialize(int32_t _5993_mdim0__,int32_t _5994_mdim1__,std::shared_ptr< monty::ndarray< double,1 > > _5995_mval__,monty::rc_ptr< ::mosek::fusion::Expression > _5996_expr__);
      static ExprCrossDot::t _new_ExprCrossDot(int32_t _5997_mdim0_,int32_t _5998_mdim1_,std::shared_ptr< monty::ndarray< int32_t,1 > > _5999_msubi_,std::shared_ptr< monty::ndarray< int32_t,1 > > _6000_msubj_,std::shared_ptr< monty::ndarray< double,1 > > _6001_mval_,monty::rc_ptr< ::mosek::fusion::Expression > _6002_expr_);
      void _initialize(int32_t _5997_mdim0_,int32_t _5998_mdim1_,std::shared_ptr< monty::ndarray< int32_t,1 > > _5999_msubi_,std::shared_ptr< monty::ndarray< int32_t,1 > > _6000_msubj_,std::shared_ptr< monty::ndarray< double,1 > > _6001_mval_,monty::rc_ptr< ::mosek::fusion::Expression > _6002_expr_);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _6003_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _6004_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _6005_xs,bool _6006_cache_eval) ;
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > computeshape(int32_t _6149_d0,int32_t _6150_d1,std::shared_ptr< monty::ndarray< int32_t,1 > > _6151_ds);
      static  int32_t validate(int32_t _6152_mdim0,int32_t _6153_mdim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _6154_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _6155_msubj,std::shared_ptr< monty::ndarray< double,1 > > _6156_mval,monty::rc_ptr< ::mosek::fusion::Expression > _6157_expr);
      virtual /* override */ std::string toString() ;
    }; // struct ExprCrossDot;

    struct p_ExprMulVar : public ::mosek::fusion::p_BaseExpression
    {
      ExprMulVar * _pubthis;
      static mosek::fusion::p_ExprMulVar* _get_impl(mosek::fusion::ExprMulVar * _inst){ return static_cast< mosek::fusion::p_ExprMulVar* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprMulVar * _get_impl(mosek::fusion::ExprMulVar::t _inst) { return _get_impl(_inst.get()); }
      p_ExprMulVar(ExprMulVar * _pubthis);
      virtual ~p_ExprMulVar() { /* std::cout << "~p_ExprMulVar" << std::endl;*/ };
      bool left{};
      monty::rc_ptr< ::mosek::fusion::Variable > x{};
      std::shared_ptr< monty::ndarray< double,1 > > mcof{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > msubj{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > msubi{};
      int32_t mdimj{};
      int32_t mdimi{};

      virtual void destroy();

      static ExprMulVar::t _new_ExprMulVar(bool _6165_left,int32_t _6166_mdimi,int32_t _6167_mdimj,std::shared_ptr< monty::ndarray< int32_t,1 > > _6168_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _6169_msubj,std::shared_ptr< monty::ndarray< double,1 > > _6170_mcof,monty::rc_ptr< ::mosek::fusion::Variable > _6171_x);
      void _initialize(bool _6165_left,int32_t _6166_mdimi,int32_t _6167_mdimj,std::shared_ptr< monty::ndarray< int32_t,1 > > _6168_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _6169_msubj,std::shared_ptr< monty::ndarray< double,1 > > _6170_mcof,monty::rc_ptr< ::mosek::fusion::Variable > _6171_x);
      static ExprMulVar::t _new_ExprMulVar(bool _6174_left,int32_t _6175_mdimi,int32_t _6176_mdimj,std::shared_ptr< monty::ndarray< int32_t,1 > > _6177_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _6178_msubj,std::shared_ptr< monty::ndarray< double,1 > > _6179_mcof,monty::rc_ptr< ::mosek::fusion::Variable > _6180_x,int32_t _6181_unchecked_);
      void _initialize(bool _6174_left,int32_t _6175_mdimi,int32_t _6176_mdimj,std::shared_ptr< monty::ndarray< int32_t,1 > > _6177_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _6178_msubj,std::shared_ptr< monty::ndarray< double,1 > > _6179_mcof,monty::rc_ptr< ::mosek::fusion::Variable > _6180_x,int32_t _6181_unchecked_);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _6182_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _6183_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _6184_xs,bool _6185_cache_eval) ;
      virtual void eval_right(monty::rc_ptr< ::mosek::fusion::WorkStack > _6186_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _6187_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _6188_xs,bool _6189_cache_eval) ;
      virtual void eval_left(monty::rc_ptr< ::mosek::fusion::WorkStack > _6294_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _6295_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _6296_xs,bool _6297_cache_eval) ;
      virtual void validate(int32_t _6370_mdimi,int32_t _6371_mdimj,std::shared_ptr< monty::ndarray< int32_t,1 > > _6372_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _6373_msubj,std::shared_ptr< monty::ndarray< double,1 > > _6374_mcof) ;
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > resshape(int32_t _6378_mdimi,int32_t _6379_mdimj,std::shared_ptr< monty::ndarray< int32_t,1 > > _6380_xshape,bool _6381_left);
      virtual /* override */ std::string toString() ;
    }; // struct ExprMulVar;

    struct p_ExprMulScalarVar : public ::mosek::fusion::p_BaseExpression
    {
      ExprMulScalarVar * _pubthis;
      static mosek::fusion::p_ExprMulScalarVar* _get_impl(mosek::fusion::ExprMulScalarVar * _inst){ return static_cast< mosek::fusion::p_ExprMulScalarVar* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprMulScalarVar * _get_impl(mosek::fusion::ExprMulScalarVar::t _inst) { return _get_impl(_inst.get()); }
      p_ExprMulScalarVar(ExprMulScalarVar * _pubthis);
      virtual ~p_ExprMulScalarVar() { /* std::cout << "~p_ExprMulScalarVar" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Variable > x{};
      std::shared_ptr< monty::ndarray< double,1 > > mcof{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > msubj{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > msubi{};
      int32_t mdimj{};
      int32_t mdimi{};

      virtual void destroy();

      static ExprMulScalarVar::t _new_ExprMulScalarVar(int32_t _6382_mdimi,int32_t _6383_mdimj,std::shared_ptr< monty::ndarray< int32_t,1 > > _6384_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _6385_msubj,std::shared_ptr< monty::ndarray< double,1 > > _6386_mcof,monty::rc_ptr< ::mosek::fusion::Variable > _6387_x);
      void _initialize(int32_t _6382_mdimi,int32_t _6383_mdimj,std::shared_ptr< monty::ndarray< int32_t,1 > > _6384_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _6385_msubj,std::shared_ptr< monty::ndarray< double,1 > > _6386_mcof,monty::rc_ptr< ::mosek::fusion::Variable > _6387_x);
      static ExprMulScalarVar::t _new_ExprMulScalarVar(int32_t _6392_mdimi,int32_t _6393_mdimj,std::shared_ptr< monty::ndarray< int32_t,1 > > _6394_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _6395_msubj,std::shared_ptr< monty::ndarray< double,1 > > _6396_mcof,monty::rc_ptr< ::mosek::fusion::Variable > _6397_x,int32_t _6398_unchecked_);
      void _initialize(int32_t _6392_mdimi,int32_t _6393_mdimj,std::shared_ptr< monty::ndarray< int32_t,1 > > _6394_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _6395_msubj,std::shared_ptr< monty::ndarray< double,1 > > _6396_mcof,monty::rc_ptr< ::mosek::fusion::Variable > _6397_x,int32_t _6398_unchecked_);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _6399_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _6400_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _6401_xs,bool _6402_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprMulScalarVar;

    struct p_ExprSumReduceEnd : public ::mosek::fusion::p_BaseExpression
    {
      ExprSumReduceEnd * _pubthis;
      static mosek::fusion::p_ExprSumReduceEnd* _get_impl(mosek::fusion::ExprSumReduceEnd * _inst){ return static_cast< mosek::fusion::p_ExprSumReduceEnd* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprSumReduceEnd * _get_impl(mosek::fusion::ExprSumReduceEnd::t _inst) { return _get_impl(_inst.get()); }
      p_ExprSumReduceEnd(ExprSumReduceEnd * _pubthis);
      virtual ~p_ExprSumReduceEnd() { /* std::cout << "~p_ExprSumReduceEnd" << std::endl;*/ };
      int32_t ndim{};
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprSumReduceEnd::t _new_ExprSumReduceEnd(int32_t _6419_ndim,monty::rc_ptr< ::mosek::fusion::Expression > _6420_expr);
      void _initialize(int32_t _6419_ndim,monty::rc_ptr< ::mosek::fusion::Expression > _6420_expr);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _6421_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _6422_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _6423_xs,bool _6424_cache_eval) ;
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > computeShape(int32_t _6490_ndim,std::shared_ptr< monty::ndarray< int32_t,1 > > _6491_shape);
      virtual /* override */ bool compress_when_caching() ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprSumReduceEnd;

    struct p_ExprAdd : public ::mosek::fusion::p_BaseExpression
    {
      ExprAdd * _pubthis;
      static mosek::fusion::p_ExprAdd* _get_impl(mosek::fusion::ExprAdd * _inst){ return static_cast< mosek::fusion::p_ExprAdd* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprAdd * _get_impl(mosek::fusion::ExprAdd::t _inst) { return _get_impl(_inst.get()); }
      p_ExprAdd(ExprAdd * _pubthis);
      virtual ~p_ExprAdd() { /* std::cout << "~p_ExprAdd" << std::endl;*/ };
      double m2{};
      double m1{};
      monty::rc_ptr< ::mosek::fusion::Expression > e2{};
      monty::rc_ptr< ::mosek::fusion::Expression > e1{};

      virtual void destroy();

      static ExprAdd::t _new_ExprAdd(monty::rc_ptr< ::mosek::fusion::Expression > _6494_e1,monty::rc_ptr< ::mosek::fusion::Expression > _6495_e2,double _6496_m1,double _6497_m2);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _6494_e1,monty::rc_ptr< ::mosek::fusion::Expression > _6495_e2,double _6496_m1,double _6497_m2);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _6499_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _6500_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _6501_xs,bool _6502_cache_eval) ;
      virtual /* override */ bool compress_when_caching() ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprAdd;

    struct p_ExprWSum : public ::mosek::fusion::p_BaseExpression
    {
      ExprWSum * _pubthis;
      static mosek::fusion::p_ExprWSum* _get_impl(mosek::fusion::ExprWSum * _inst){ return static_cast< mosek::fusion::p_ExprWSum* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprWSum * _get_impl(mosek::fusion::ExprWSum::t _inst) { return _get_impl(_inst.get()); }
      p_ExprWSum(ExprWSum * _pubthis);
      virtual ~p_ExprWSum() { /* std::cout << "~p_ExprWSum" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< double,1 > > w{};
      std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > es{};

      virtual void destroy();

      static ExprWSum::t _new_ExprWSum(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _6632_es,std::shared_ptr< monty::ndarray< double,1 > > _6633_w);
      void _initialize(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _6632_es,std::shared_ptr< monty::ndarray< double,1 > > _6633_w);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _6640_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _6641_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _6642_xs,bool _6643_cache_eval) ;
      virtual /* override */ bool compress_when_caching() ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprWSum;

    struct p_ExprSumReduce : public ::mosek::fusion::p_BaseExpression
    {
      ExprSumReduce * _pubthis;
      static mosek::fusion::p_ExprSumReduce* _get_impl(mosek::fusion::ExprSumReduce * _inst){ return static_cast< mosek::fusion::p_ExprSumReduce* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprSumReduce * _get_impl(mosek::fusion::ExprSumReduce::t _inst) { return _get_impl(_inst.get()); }
      p_ExprSumReduce(ExprSumReduce * _pubthis);
      virtual ~p_ExprSumReduce() { /* std::cout << "~p_ExprSumReduce" << std::endl;*/ };
      int32_t dim{};
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprSumReduce::t _new_ExprSumReduce(int32_t _6737_dim,monty::rc_ptr< ::mosek::fusion::Expression > _6738_expr);
      void _initialize(int32_t _6737_dim,monty::rc_ptr< ::mosek::fusion::Expression > _6738_expr);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _6740_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _6741_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _6742_xs,bool _6743_cache_eval) ;
      static  std::shared_ptr< monty::ndarray< int32_t,1 > > computeShape(int32_t _6859_dim,std::shared_ptr< monty::ndarray< int32_t,1 > > _6860_shape);
      virtual /* override */ bool compress_when_caching() ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprSumReduce;

    struct p_ExprScaleVecPSD : public ::mosek::fusion::p_BaseExpression
    {
      ExprScaleVecPSD * _pubthis;
      static mosek::fusion::p_ExprScaleVecPSD* _get_impl(mosek::fusion::ExprScaleVecPSD * _inst){ return static_cast< mosek::fusion::p_ExprScaleVecPSD* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprScaleVecPSD * _get_impl(mosek::fusion::ExprScaleVecPSD::t _inst) { return _get_impl(_inst.get()); }
      p_ExprScaleVecPSD(ExprScaleVecPSD * _pubthis);
      virtual ~p_ExprScaleVecPSD() { /* std::cout << "~p_ExprScaleVecPSD" << std::endl;*/ };
      int32_t dim1{};
      int32_t dim0{};
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprScaleVecPSD::t _new_ExprScaleVecPSD(int32_t _6864_dim0,int32_t _6865_dim1,monty::rc_ptr< ::mosek::fusion::Expression > _6866_expr);
      void _initialize(int32_t _6864_dim0,int32_t _6865_dim1,monty::rc_ptr< ::mosek::fusion::Expression > _6866_expr);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _6867_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _6868_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _6869_xs,bool _6870_cache_eval) ;
    }; // struct ExprScaleVecPSD;

    struct p_ExprDenseTril : public ::mosek::fusion::p_BaseExpression
    {
      ExprDenseTril * _pubthis;
      static mosek::fusion::p_ExprDenseTril* _get_impl(mosek::fusion::ExprDenseTril * _inst){ return static_cast< mosek::fusion::p_ExprDenseTril* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprDenseTril * _get_impl(mosek::fusion::ExprDenseTril::t _inst) { return _get_impl(_inst.get()); }
      p_ExprDenseTril(ExprDenseTril * _pubthis);
      virtual ~p_ExprDenseTril() { /* std::cout << "~p_ExprDenseTril" << std::endl;*/ };
      int32_t dim1{};
      int32_t dim0{};
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprDenseTril::t _new_ExprDenseTril(int32_t _6944_dim0,int32_t _6945_dim1,monty::rc_ptr< ::mosek::fusion::Expression > _6946_expr,int32_t _6947_unchecked_);
      void _initialize(int32_t _6944_dim0,int32_t _6945_dim1,monty::rc_ptr< ::mosek::fusion::Expression > _6946_expr,int32_t _6947_unchecked_);
      static ExprDenseTril::t _new_ExprDenseTril(int32_t _6948_dim0_,int32_t _6949_dim1_,monty::rc_ptr< ::mosek::fusion::Expression > _6950_expr);
      void _initialize(int32_t _6948_dim0_,int32_t _6949_dim1_,monty::rc_ptr< ::mosek::fusion::Expression > _6950_expr);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _6952_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _6953_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _6954_xs,bool _6955_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprDenseTril;

    struct p_ExprDense : public ::mosek::fusion::p_BaseExpression
    {
      ExprDense * _pubthis;
      static mosek::fusion::p_ExprDense* _get_impl(mosek::fusion::ExprDense * _inst){ return static_cast< mosek::fusion::p_ExprDense* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprDense * _get_impl(mosek::fusion::ExprDense::t _inst) { return _get_impl(_inst.get()); }
      p_ExprDense(ExprDense * _pubthis);
      virtual ~p_ExprDense() { /* std::cout << "~p_ExprDense" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprDense::t _new_ExprDense(monty::rc_ptr< ::mosek::fusion::Expression > _7039_expr);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _7039_expr);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _7040_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _7041_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _7042_xs,bool _7043_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprDense;

    struct p_ExprSymmetrize : public ::mosek::fusion::p_BaseExpression
    {
      ExprSymmetrize * _pubthis;
      static mosek::fusion::p_ExprSymmetrize* _get_impl(mosek::fusion::ExprSymmetrize * _inst){ return static_cast< mosek::fusion::p_ExprSymmetrize* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprSymmetrize * _get_impl(mosek::fusion::ExprSymmetrize::t _inst) { return _get_impl(_inst.get()); }
      p_ExprSymmetrize(ExprSymmetrize * _pubthis);
      virtual ~p_ExprSymmetrize() { /* std::cout << "~p_ExprSymmetrize" << std::endl;*/ };
      int32_t dim1{};
      int32_t dim0{};
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprSymmetrize::t _new_ExprSymmetrize(int32_t _7084_dim0,int32_t _7085_dim1,monty::rc_ptr< ::mosek::fusion::Expression > _7086_expr,int32_t _7087_unchecked_);
      void _initialize(int32_t _7084_dim0,int32_t _7085_dim1,monty::rc_ptr< ::mosek::fusion::Expression > _7086_expr,int32_t _7087_unchecked_);
      static ExprSymmetrize::t _new_ExprSymmetrize(int32_t _7088_dim0_,int32_t _7089_dim1_,monty::rc_ptr< ::mosek::fusion::Expression > _7090_expr);
      void _initialize(int32_t _7088_dim0_,int32_t _7089_dim1_,monty::rc_ptr< ::mosek::fusion::Expression > _7090_expr);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _7092_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _7093_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _7094_xs,bool _7095_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprSymmetrize;

    struct p_ExprCondense : public ::mosek::fusion::p_BaseExpression
    {
      ExprCondense * _pubthis;
      static mosek::fusion::p_ExprCondense* _get_impl(mosek::fusion::ExprCondense * _inst){ return static_cast< mosek::fusion::p_ExprCondense* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprCondense * _get_impl(mosek::fusion::ExprCondense::t _inst) { return _get_impl(_inst.get()); }
      p_ExprCondense(ExprCondense * _pubthis);
      virtual ~p_ExprCondense() { /* std::cout << "~p_ExprCondense" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > expr{};

      virtual void destroy();

      static ExprCondense::t _new_ExprCondense(monty::rc_ptr< ::mosek::fusion::Expression > _7237_expr);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Expression > _7237_expr);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _7238_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _7239_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _7240_xs,bool _7241_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprCondense;

    struct p_ExprFromVar : public ::mosek::fusion::p_BaseExpression
    {
      ExprFromVar * _pubthis;
      static mosek::fusion::p_ExprFromVar* _get_impl(mosek::fusion::ExprFromVar * _inst){ return static_cast< mosek::fusion::p_ExprFromVar* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprFromVar * _get_impl(mosek::fusion::ExprFromVar::t _inst) { return _get_impl(_inst.get()); }
      p_ExprFromVar(ExprFromVar * _pubthis);
      virtual ~p_ExprFromVar() { /* std::cout << "~p_ExprFromVar" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Variable > x{};

      virtual void destroy();

      static ExprFromVar::t _new_ExprFromVar(monty::rc_ptr< ::mosek::fusion::Variable > _7245_x);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Variable > _7245_x);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _7246_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _7247_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _7248_xs,bool _7249_cache_eval) ;
      virtual /* override */ void recursive_eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _7266_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _7267_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _7268_xs,bool _7269_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprFromVar;

    struct p_ExprReshape : public ::mosek::fusion::p_BaseExpression
    {
      ExprReshape * _pubthis;
      static mosek::fusion::p_ExprReshape* _get_impl(mosek::fusion::ExprReshape * _inst){ return static_cast< mosek::fusion::p_ExprReshape* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_ExprReshape * _get_impl(mosek::fusion::ExprReshape::t _inst) { return _get_impl(_inst.get()); }
      p_ExprReshape(ExprReshape * _pubthis);
      virtual ~p_ExprReshape() { /* std::cout << "~p_ExprReshape" << std::endl;*/ };
      monty::rc_ptr< ::mosek::fusion::Expression > e{};

      virtual void destroy();

      static ExprReshape::t _new_ExprReshape(std::shared_ptr< monty::ndarray< int32_t,1 > > _7270_shape,monty::rc_ptr< ::mosek::fusion::Expression > _7271_e);
      void _initialize(std::shared_ptr< monty::ndarray< int32_t,1 > > _7270_shape,monty::rc_ptr< ::mosek::fusion::Expression > _7271_e);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _7273_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _7274_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _7275_xs,bool _7276_cache_eval) ;
      virtual /* override */ std::string toString() ;
    }; // struct ExprReshape;

    struct p_Expr : public ::mosek::fusion::p_BaseExpression
    {
      Expr * _pubthis;
      static mosek::fusion::p_Expr* _get_impl(mosek::fusion::Expr * _inst){ return static_cast< mosek::fusion::p_Expr* >(mosek::fusion::p_BaseExpression::_get_impl(_inst)); }
      static mosek::fusion::p_Expr * _get_impl(mosek::fusion::Expr::t _inst) { return _get_impl(_inst.get()); }
      p_Expr(Expr * _pubthis);
      virtual ~p_Expr() { /* std::cout << "~p_Expr" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< int64_t,1 > > inst{};
      std::shared_ptr< monty::ndarray< double,1 > > cof_v{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > subj{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > ptrb{};
      std::shared_ptr< monty::ndarray< double,1 > > bfix{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > shape{};

      virtual void destroy();

      static Expr::t _new_Expr(std::shared_ptr< monty::ndarray< int64_t,1 > > _7447_ptrb,std::shared_ptr< monty::ndarray< int64_t,1 > > _7448_subj,std::shared_ptr< monty::ndarray< double,1 > > _7449_cof,std::shared_ptr< monty::ndarray< double,1 > > _7450_bfix,std::shared_ptr< monty::ndarray< int32_t,1 > > _7451_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _7452_inst);
      void _initialize(std::shared_ptr< monty::ndarray< int64_t,1 > > _7447_ptrb,std::shared_ptr< monty::ndarray< int64_t,1 > > _7448_subj,std::shared_ptr< monty::ndarray< double,1 > > _7449_cof,std::shared_ptr< monty::ndarray< double,1 > > _7450_bfix,std::shared_ptr< monty::ndarray< int32_t,1 > > _7451_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _7452_inst);
      static Expr::t _new_Expr(std::shared_ptr< monty::ndarray< int64_t,1 > > _7463_ptrb,std::shared_ptr< monty::ndarray< int64_t,1 > > _7464_subj,std::shared_ptr< monty::ndarray< double,1 > > _7465_cof,std::shared_ptr< monty::ndarray< double,1 > > _7466_bfix,std::shared_ptr< monty::ndarray< int32_t,1 > > _7467_shp,std::shared_ptr< monty::ndarray< int64_t,1 > > _7468_inst,int32_t _7469_unchecked_);
      void _initialize(std::shared_ptr< monty::ndarray< int64_t,1 > > _7463_ptrb,std::shared_ptr< monty::ndarray< int64_t,1 > > _7464_subj,std::shared_ptr< monty::ndarray< double,1 > > _7465_cof,std::shared_ptr< monty::ndarray< double,1 > > _7466_bfix,std::shared_ptr< monty::ndarray< int32_t,1 > > _7467_shp,std::shared_ptr< monty::ndarray< int64_t,1 > > _7468_inst,int32_t _7469_unchecked_);
      virtual int64_t prod(std::shared_ptr< monty::ndarray< int32_t,1 > > _7470_vals) ;
      static  std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > varstack(std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > >,1 > > _7473_vs);
      static  std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > varstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _7476_v1,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _7477_v2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > condense(monty::rc_ptr< ::mosek::fusion::Expression > _7481_e);
      static  monty::rc_ptr< ::mosek::fusion::Expression > flatten(monty::rc_ptr< ::mosek::fusion::Expression > _7482_e);
      static  monty::rc_ptr< ::mosek::fusion::Expression > reshape(monty::rc_ptr< ::mosek::fusion::Expression > _7484_e,int32_t _7485_dimi,int32_t _7486_dimj);
      static  monty::rc_ptr< ::mosek::fusion::Expression > reshape(monty::rc_ptr< ::mosek::fusion::Expression > _7487_e,int32_t _7488_size);
      static  monty::rc_ptr< ::mosek::fusion::Expression > reshape(monty::rc_ptr< ::mosek::fusion::Expression > _7489_e,std::shared_ptr< monty::ndarray< int32_t,1 > > _7490_newshape);
      static  monty::rc_ptr< ::mosek::fusion::Expression > zeros(std::shared_ptr< monty::ndarray< int32_t,1 > > _7491_shp);
      static  monty::rc_ptr< ::mosek::fusion::Expression > zeros(int32_t _7492_size);
      static  monty::rc_ptr< ::mosek::fusion::Expression > ones();
      static  monty::rc_ptr< ::mosek::fusion::Expression > ones(std::shared_ptr< monty::ndarray< int32_t,1 > > _7493_shp,std::shared_ptr< monty::ndarray< int32_t,2 > > _7494_sparsity);
      static  monty::rc_ptr< ::mosek::fusion::Expression > ones(std::shared_ptr< monty::ndarray< int32_t,1 > > _7495_shp);
      static  monty::rc_ptr< ::mosek::fusion::Expression > ones(int32_t _7496_size);
      static  monty::rc_ptr< ::mosek::fusion::Expression > constTerm(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _7497_nda);
      static  monty::rc_ptr< ::mosek::fusion::Expression > constTerm(monty::rc_ptr< ::mosek::fusion::Matrix > _7498_m);
      static  monty::rc_ptr< ::mosek::fusion::Expression > constTerm(double _7507_val);
      static  monty::rc_ptr< ::mosek::fusion::Expression > constTerm(std::shared_ptr< monty::ndarray< int32_t,1 > > _7508_shp,std::shared_ptr< monty::ndarray< int32_t,2 > > _7509_sparsity,double _7510_val);
      static  monty::rc_ptr< ::mosek::fusion::Expression > constTerm(std::shared_ptr< monty::ndarray< int32_t,1 > > _7518_shp,std::shared_ptr< monty::ndarray< int32_t,2 > > _7519_sparsity,std::shared_ptr< monty::ndarray< double,1 > > _7520_vals1);
      static  monty::rc_ptr< ::mosek::fusion::Expression > constTerm(std::shared_ptr< monty::ndarray< int32_t,1 > > _7528_shp,double _7529_val);
      static  monty::rc_ptr< ::mosek::fusion::Expression > constTerm(int32_t _7530_size,double _7531_val);
      static  monty::rc_ptr< ::mosek::fusion::Expression > constTerm(std::shared_ptr< monty::ndarray< double,2 > > _7533_vals2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > constTerm(std::shared_ptr< monty::ndarray< double,1 > > _7536_vals1);
      static  monty::rc_ptr< ::mosek::fusion::Expression > sum(monty::rc_ptr< ::mosek::fusion::Expression > _7537_expr,std::shared_ptr< monty::ndarray< int32_t,1 > > _7538_dims);
      static  monty::rc_ptr< ::mosek::fusion::Expression > sum(monty::rc_ptr< ::mosek::fusion::Expression > _7547_expr,int32_t _7548_dim);
      static  monty::rc_ptr< ::mosek::fusion::Expression > sum(monty::rc_ptr< ::mosek::fusion::Expression > _7549_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > neg(monty::rc_ptr< ::mosek::fusion::Expression > _7550_e);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(bool _7551_left,monty::rc_ptr< ::mosek::fusion::Matrix > _7552_mx,monty::rc_ptr< ::mosek::fusion::Expression > _7553_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(monty::rc_ptr< ::mosek::fusion::Variable > _7560_v,monty::rc_ptr< ::mosek::fusion::Parameter > _7561_p);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(monty::rc_ptr< ::mosek::fusion::Parameter > _7562_p,monty::rc_ptr< ::mosek::fusion::Variable > _7563_v);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(monty::rc_ptr< ::mosek::fusion::Expression > _7564_expr,monty::rc_ptr< ::mosek::fusion::Parameter > _7565_p);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(monty::rc_ptr< ::mosek::fusion::Parameter > _7566_p,monty::rc_ptr< ::mosek::fusion::Expression > _7567_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(monty::rc_ptr< ::mosek::fusion::Variable > _7568_v,monty::rc_ptr< ::mosek::fusion::Matrix > _7569_mx);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(monty::rc_ptr< ::mosek::fusion::Matrix > _7570_mx,monty::rc_ptr< ::mosek::fusion::Variable > _7571_v);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(monty::rc_ptr< ::mosek::fusion::Expression > _7572_expr,monty::rc_ptr< ::mosek::fusion::Matrix > _7573_mx);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(monty::rc_ptr< ::mosek::fusion::Matrix > _7574_mx,monty::rc_ptr< ::mosek::fusion::Expression > _7575_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(monty::rc_ptr< ::mosek::fusion::Variable > _7576_v,std::shared_ptr< monty::ndarray< double,2 > > _7577_a);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(monty::rc_ptr< ::mosek::fusion::Expression > _7584_expr,std::shared_ptr< monty::ndarray< double,2 > > _7585_a);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(std::shared_ptr< monty::ndarray< double,2 > > _7592_a,monty::rc_ptr< ::mosek::fusion::Variable > _7593_v);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulDiag(std::shared_ptr< monty::ndarray< double,2 > > _7600_a,monty::rc_ptr< ::mosek::fusion::Expression > _7601_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm_(monty::rc_ptr< ::mosek::fusion::Matrix > _7608_m,monty::rc_ptr< ::mosek::fusion::Expression > _7609_e);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm_(std::shared_ptr< monty::ndarray< double,1 > > _7618_a,monty::rc_ptr< ::mosek::fusion::Expression > _7619_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm_(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _7621_spm,monty::rc_ptr< ::mosek::fusion::Expression > _7622_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Expression > _7625_expr,double _7626_c);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(double _7627_c,monty::rc_ptr< ::mosek::fusion::Expression > _7628_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Expression > _7629_expr,std::shared_ptr< monty::ndarray< double,1 > > _7630_a);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(std::shared_ptr< monty::ndarray< double,1 > > _7631_a,monty::rc_ptr< ::mosek::fusion::Expression > _7632_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Expression > _7633_expr,std::shared_ptr< monty::ndarray< double,2 > > _7634_a);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(std::shared_ptr< monty::ndarray< double,2 > > _7635_a,monty::rc_ptr< ::mosek::fusion::Expression > _7636_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Expression > _7637_expr,monty::rc_ptr< ::mosek::fusion::Matrix > _7638_mx);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Matrix > _7639_mx,monty::rc_ptr< ::mosek::fusion::Expression > _7640_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(bool _7641_left,std::shared_ptr< monty::ndarray< double,1 > > _7642_mx,monty::rc_ptr< ::mosek::fusion::Expression > _7643_e);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(bool _7650_left,std::shared_ptr< monty::ndarray< double,2 > > _7651_mx,monty::rc_ptr< ::mosek::fusion::Expression > _7652_e);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(bool _7668_left,monty::rc_ptr< ::mosek::fusion::Matrix > _7669_mx,monty::rc_ptr< ::mosek::fusion::Expression > _7670_e);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Variable > _7692_v,std::shared_ptr< monty::ndarray< double,2 > > _7693_mx);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(std::shared_ptr< monty::ndarray< double,2 > > _7703_mx,monty::rc_ptr< ::mosek::fusion::Variable > _7704_v);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Variable > _7714_v,monty::rc_ptr< ::mosek::fusion::Matrix > _7715_mx);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Matrix > _7721_mx,monty::rc_ptr< ::mosek::fusion::Variable > _7722_v);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(bool _7728_left,int32_t _7729_mdimi,int32_t _7730_mdimj,std::shared_ptr< monty::ndarray< int32_t,1 > > _7731_msubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _7732_msubj,std::shared_ptr< monty::ndarray< double,1 > > _7733_mcof,monty::rc_ptr< ::mosek::fusion::Variable > _7734_v);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Expression > _7736_expr,monty::rc_ptr< ::mosek::fusion::Parameter > _7737_p);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mul(monty::rc_ptr< ::mosek::fusion::Parameter > _7738_p,monty::rc_ptr< ::mosek::fusion::Expression > _7739_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Expression > _7740_e,monty::rc_ptr< ::mosek::fusion::Matrix > _7741_m);
      static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Expression > _7750_e,std::shared_ptr< monty::ndarray< double,2 > > _7751_c2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Expression > _7756_e,monty::rc_ptr< ::mosek::fusion::NDSparseArray > _7757_nda);
      static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Expression > _7760_e,std::shared_ptr< monty::ndarray< double,1 > > _7761_c1);
      static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Matrix > _7766_m,monty::rc_ptr< ::mosek::fusion::Expression > _7767_e);
      static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _7768_nda,monty::rc_ptr< ::mosek::fusion::Expression > _7769_e);
      static  monty::rc_ptr< ::mosek::fusion::Expression > dot(std::shared_ptr< monty::ndarray< double,2 > > _7770_c2,monty::rc_ptr< ::mosek::fusion::Expression > _7771_e);
      static  monty::rc_ptr< ::mosek::fusion::Expression > dot(std::shared_ptr< monty::ndarray< double,1 > > _7772_c1,monty::rc_ptr< ::mosek::fusion::Expression > _7773_e);
      static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Expression > _7774_e,monty::rc_ptr< ::mosek::fusion::Parameter > _7775_p);
      static  monty::rc_ptr< ::mosek::fusion::Expression > dot(monty::rc_ptr< ::mosek::fusion::Parameter > _7776_p,monty::rc_ptr< ::mosek::fusion::Expression > _7777_e);
      static  monty::rc_ptr< ::mosek::fusion::Expression > outer(monty::rc_ptr< ::mosek::fusion::Parameter > _7778_p,monty::rc_ptr< ::mosek::fusion::Expression > _7779_e);
      static  monty::rc_ptr< ::mosek::fusion::Expression > outer(monty::rc_ptr< ::mosek::fusion::Expression > _7782_e,monty::rc_ptr< ::mosek::fusion::Parameter > _7783_p);
      static  monty::rc_ptr< ::mosek::fusion::Expression > outer(monty::rc_ptr< ::mosek::fusion::Matrix > _7786_m,monty::rc_ptr< ::mosek::fusion::Expression > _7787_e);
      static  monty::rc_ptr< ::mosek::fusion::Expression > outer(monty::rc_ptr< ::mosek::fusion::Expression > _7789_e,monty::rc_ptr< ::mosek::fusion::Matrix > _7790_m);
      static  monty::rc_ptr< ::mosek::fusion::Expression > outer(std::shared_ptr< monty::ndarray< double,1 > > _7792_a,monty::rc_ptr< ::mosek::fusion::Expression > _7793_e);
      static  monty::rc_ptr< ::mosek::fusion::Expression > outer(monty::rc_ptr< ::mosek::fusion::Expression > _7795_e,std::shared_ptr< monty::ndarray< double,1 > > _7796_a);
      static  monty::rc_ptr< ::mosek::fusion::Expression > outer_(int32_t _7798_edim,std::shared_ptr< monty::ndarray< int64_t,1 > > _7799_eptrb,std::shared_ptr< monty::ndarray< int64_t,1 > > _7800_esubj,std::shared_ptr< monty::ndarray< double,1 > > _7801_ecof,std::shared_ptr< monty::ndarray< double,1 > > _7802_ebfix,std::shared_ptr< monty::ndarray< int64_t,1 > > _7803_einst,std::shared_ptr< monty::ndarray< double,1 > > _7804_a,std::shared_ptr< monty::ndarray< int32_t,1 > > _7805_sub,int32_t _7806_dim,bool _7807_transpose);
      static  monty::rc_ptr< ::mosek::fusion::Expression > outer_(monty::rc_ptr< ::mosek::fusion::Variable > _7837_v,int32_t _7838_vdim,std::shared_ptr< monty::ndarray< double,1 > > _7839_a,std::shared_ptr< monty::ndarray< int32_t,1 > > _7840_sub,int32_t _7841_dim,bool _7842_transpose);
      static  monty::rc_ptr< ::mosek::fusion::Expression > stack(std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > >,1 > > _7859_exprs);
      static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(double _7865_a1,double _7866_a2,double _7867_a3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(double _7868_a1,double _7869_a2,monty::rc_ptr< ::mosek::fusion::Expression > _7870_e3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(double _7871_a1,monty::rc_ptr< ::mosek::fusion::Expression > _7872_e2,double _7873_a3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(double _7874_a1,monty::rc_ptr< ::mosek::fusion::Expression > _7875_e2,monty::rc_ptr< ::mosek::fusion::Expression > _7876_e3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _7877_e1,double _7878_a2,double _7879_a3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _7880_e1,double _7881_a2,monty::rc_ptr< ::mosek::fusion::Expression > _7882_e3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _7883_e1,monty::rc_ptr< ::mosek::fusion::Expression > _7884_e2,double _7885_a3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _7886_e1,monty::rc_ptr< ::mosek::fusion::Expression > _7887_e2,monty::rc_ptr< ::mosek::fusion::Expression > _7888_e3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(double _7889_a1,monty::rc_ptr< ::mosek::fusion::Expression > _7890_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _7891_e1,double _7892_a2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(monty::rc_ptr< ::mosek::fusion::Expression > _7893_e1,monty::rc_ptr< ::mosek::fusion::Expression > _7894_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > vstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _7895_exprs);
      static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _7897_e1,monty::rc_ptr< ::mosek::fusion::Expression > _7898_e2,monty::rc_ptr< ::mosek::fusion::Expression > _7899_e3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _7900_e1,monty::rc_ptr< ::mosek::fusion::Expression > _7901_e2,double _7902_a3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _7903_e1,double _7904_a2,monty::rc_ptr< ::mosek::fusion::Expression > _7905_e3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _7906_e1,double _7907_a2,double _7908_a3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(double _7909_a1,monty::rc_ptr< ::mosek::fusion::Expression > _7910_e2,monty::rc_ptr< ::mosek::fusion::Expression > _7911_e3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(double _7912_a1,monty::rc_ptr< ::mosek::fusion::Expression > _7913_e2,double _7914_a3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(double _7915_a1,double _7916_a2,monty::rc_ptr< ::mosek::fusion::Expression > _7917_e3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(double _7918_a1,monty::rc_ptr< ::mosek::fusion::Expression > _7919_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _7920_e1,double _7921_a2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(monty::rc_ptr< ::mosek::fusion::Expression > _7922_e1,monty::rc_ptr< ::mosek::fusion::Expression > _7923_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > hstack(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _7924_exprs);
      static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int32_t _7926_dim,monty::rc_ptr< ::mosek::fusion::Expression > _7927_e1,monty::rc_ptr< ::mosek::fusion::Expression > _7928_e2,monty::rc_ptr< ::mosek::fusion::Expression > _7929_e3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int32_t _7930_dim,monty::rc_ptr< ::mosek::fusion::Expression > _7931_e1,monty::rc_ptr< ::mosek::fusion::Expression > _7932_e2,double _7933_a3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int32_t _7934_dim,monty::rc_ptr< ::mosek::fusion::Expression > _7935_e1,double _7936_a2,monty::rc_ptr< ::mosek::fusion::Expression > _7937_e3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int32_t _7938_dim,monty::rc_ptr< ::mosek::fusion::Expression > _7939_e1,double _7940_a2,double _7941_a3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int32_t _7942_dim,double _7943_a1,monty::rc_ptr< ::mosek::fusion::Expression > _7944_e2,monty::rc_ptr< ::mosek::fusion::Expression > _7945_e3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int32_t _7946_dim,double _7947_a1,monty::rc_ptr< ::mosek::fusion::Expression > _7948_e2,double _7949_a3);
      static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int32_t _7950_dim,double _7951_a1,double _7952_a2,monty::rc_ptr< ::mosek::fusion::Expression > _7953_e1);
      static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int32_t _7954_dim,double _7955_a1,monty::rc_ptr< ::mosek::fusion::Expression > _7956_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int32_t _7957_dim,monty::rc_ptr< ::mosek::fusion::Expression > _7958_e1,double _7959_a2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int32_t _7960_dim,monty::rc_ptr< ::mosek::fusion::Expression > _7961_e1,monty::rc_ptr< ::mosek::fusion::Expression > _7962_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > stack(int32_t _7963_dim,std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _7964_exprs);
      static  monty::rc_ptr< ::mosek::fusion::Expression > stack_(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _7965_exprs,int32_t _7966_dim);
      static  std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > promote(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _7967_exprs,int32_t _7968_dim);
      static  monty::rc_ptr< ::mosek::fusion::Expression > repeat(monty::rc_ptr< ::mosek::fusion::Variable > _7981_x,int32_t _7982_n,int32_t _7983_d);
      static  monty::rc_ptr< ::mosek::fusion::Expression > repeat(monty::rc_ptr< ::mosek::fusion::Expression > _7984_e,int32_t _7985_n,int32_t _7986_d);
      static  monty::rc_ptr< ::mosek::fusion::Expression > add(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Expression >,1 > > _7989_exps);
      static  monty::rc_ptr< ::mosek::fusion::Expression > add(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _7991_vs);
      static  monty::rc_ptr< ::mosek::fusion::Expression > add_(monty::rc_ptr< ::mosek::fusion::Expression > _8024_e1,double _8025_m1,monty::rc_ptr< ::mosek::fusion::Expression > _8026_e2,double _8027_m2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > transpose(monty::rc_ptr< ::mosek::fusion::Expression > _8038_e);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Matrix > _8039_m,monty::rc_ptr< ::mosek::fusion::Expression > _8040_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _8041_spm,monty::rc_ptr< ::mosek::fusion::Expression > _8042_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(std::shared_ptr< monty::ndarray< double,2 > > _8043_a2,monty::rc_ptr< ::mosek::fusion::Expression > _8044_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(std::shared_ptr< monty::ndarray< double,1 > > _8045_a1,monty::rc_ptr< ::mosek::fusion::Expression > _8046_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Expression > _8047_expr,monty::rc_ptr< ::mosek::fusion::Matrix > _8048_m);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Expression > _8049_expr,std::shared_ptr< monty::ndarray< double,2 > > _8050_a2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Expression > _8051_expr,std::shared_ptr< monty::ndarray< double,1 > > _8052_a1);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Expression > _8053_expr,monty::rc_ptr< ::mosek::fusion::NDSparseArray > _8054_spm);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Parameter > _8055_p,monty::rc_ptr< ::mosek::fusion::Expression > _8056_expr);
      static  monty::rc_ptr< ::mosek::fusion::Expression > mulElm(monty::rc_ptr< ::mosek::fusion::Expression > _8057_expr,monty::rc_ptr< ::mosek::fusion::Parameter > _8058_p);
      static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _8059_n,monty::rc_ptr< ::mosek::fusion::Expression > _8060_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Expression > _8061_e1,monty::rc_ptr< ::mosek::fusion::NDSparseArray > _8062_n);
      static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Matrix > _8063_m,monty::rc_ptr< ::mosek::fusion::Expression > _8064_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Expression > _8065_e1,monty::rc_ptr< ::mosek::fusion::Matrix > _8066_m);
      static  monty::rc_ptr< ::mosek::fusion::Expression > sub(double _8067_c,monty::rc_ptr< ::mosek::fusion::Expression > _8068_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Expression > _8069_e1,double _8070_c);
      static  monty::rc_ptr< ::mosek::fusion::Expression > sub(std::shared_ptr< monty::ndarray< double,2 > > _8071_a2,monty::rc_ptr< ::mosek::fusion::Expression > _8072_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > sub(std::shared_ptr< monty::ndarray< double,1 > > _8073_a1,monty::rc_ptr< ::mosek::fusion::Expression > _8074_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Expression > _8075_e1,std::shared_ptr< monty::ndarray< double,2 > > _8076_a2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Expression > _8077_e1,std::shared_ptr< monty::ndarray< double,1 > > _8078_a1);
      static  monty::rc_ptr< ::mosek::fusion::Expression > sub(monty::rc_ptr< ::mosek::fusion::Expression > _8079_e1,monty::rc_ptr< ::mosek::fusion::Expression > _8080_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::NDSparseArray > _8081_n,monty::rc_ptr< ::mosek::fusion::Expression > _8082_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Expression > _8083_e1,monty::rc_ptr< ::mosek::fusion::NDSparseArray > _8084_n);
      static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Matrix > _8085_m,monty::rc_ptr< ::mosek::fusion::Expression > _8086_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Expression > _8087_e1,monty::rc_ptr< ::mosek::fusion::Matrix > _8088_m);
      static  monty::rc_ptr< ::mosek::fusion::Expression > add(double _8089_c,monty::rc_ptr< ::mosek::fusion::Expression > _8090_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Expression > _8091_e1,double _8092_c);
      static  monty::rc_ptr< ::mosek::fusion::Expression > add(std::shared_ptr< monty::ndarray< double,2 > > _8093_a2,monty::rc_ptr< ::mosek::fusion::Expression > _8094_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > add(std::shared_ptr< monty::ndarray< double,1 > > _8095_a1,monty::rc_ptr< ::mosek::fusion::Expression > _8096_e2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Expression > _8097_e1,std::shared_ptr< monty::ndarray< double,2 > > _8098_a2);
      static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Expression > _8099_e1,std::shared_ptr< monty::ndarray< double,1 > > _8100_a1);
      static  monty::rc_ptr< ::mosek::fusion::Expression > add(monty::rc_ptr< ::mosek::fusion::Expression > _8101_e1,monty::rc_ptr< ::mosek::fusion::Expression > _8102_e2);
      virtual /* override */ void eval(monty::rc_ptr< ::mosek::fusion::WorkStack > _8103_rs,monty::rc_ptr< ::mosek::fusion::WorkStack > _8104_ws,monty::rc_ptr< ::mosek::fusion::WorkStack > _8105_xs,bool _8106_cache_eval) ;
      static  void validateData(std::shared_ptr< monty::ndarray< int64_t,1 > > _8124_ptrb,std::shared_ptr< monty::ndarray< int64_t,1 > > _8125_subj,std::shared_ptr< monty::ndarray< double,1 > > _8126_cof,std::shared_ptr< monty::ndarray< double,1 > > _8127_bfix,std::shared_ptr< monty::ndarray< int32_t,1 > > _8128_shape,std::shared_ptr< monty::ndarray< int64_t,1 > > _8129_inst);
      static  monty::rc_ptr< ::mosek::fusion::Model > extractModel(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Variable >,1 > > _8142_v);
    }; // struct Expr;

    struct p_WorkStack
    {
      WorkStack * _pubthis;
      static mosek::fusion::p_WorkStack* _get_impl(mosek::fusion::WorkStack * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_WorkStack * _get_impl(mosek::fusion::WorkStack::t _inst) { return _get_impl(_inst.get()); }
      p_WorkStack(WorkStack * _pubthis);
      virtual ~p_WorkStack() { /* std::cout << "~p_WorkStack" << std::endl;*/ };
      int32_t code_base{};
      int32_t cconst_base{};
      int32_t codeptr_base{};
      int32_t cof_base{};
      int32_t nidxs_base{};
      int32_t sp_base{};
      int32_t shape_base{};
      int32_t ptr_base{};
      bool hassp{};
      int32_t ncodeatom{};
      int32_t nelem{};
      int32_t nnz{};
      int32_t nd{};
      int32_t pf64{};
      int32_t pi64{};
      int32_t pi32{};
      std::shared_ptr< monty::ndarray< double,1 > > f64{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > i64{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > i32{};

      virtual void destroy();

      static WorkStack::t _new_WorkStack();
      void _initialize();
      virtual void validate() ;
      virtual void validate_all() ;
      virtual void validate_from(int32_t _7345_fi32,int32_t _7346_fi64,int32_t _7347_ff64,bool _7348_rec) ;
      virtual std::string formatCurrent() ;
      virtual bool peek_hassp() ;
      virtual int32_t peek_nnz() ;
      virtual int32_t peek_nelem() ;
      virtual int32_t peek_dim(int32_t _7382_i) ;
      virtual int32_t peek_nd() ;
      virtual void alloc_expr(int32_t _7383_nd,int32_t _7384_nelem,int32_t _7385_nnz,bool _7386_hassp) ;
      virtual void alloc_expr(int32_t _7387_nd,int32_t _7388_nelem,int32_t _7389_nnz,bool _7390_hassp,int32_t _7391_ncodeatom) ;
      virtual void pop_expr() ;
      virtual void copy_expr(monty::rc_ptr< ::mosek::fusion::WorkStack > _7392_to) ;
      virtual void move_expr(monty::rc_ptr< ::mosek::fusion::WorkStack > _7399_to) ;
      virtual void peek_expr() ;
      virtual void ensure_sparsity() ;
      virtual void clear() ;
      virtual int32_t allocf64(int32_t _7414_n) ;
      virtual int32_t alloci64(int32_t _7416_n) ;
      virtual int32_t alloci32(int32_t _7418_n) ;
      virtual void pushf64(double _7420_v) ;
      virtual void pushi64(int64_t _7421_v) ;
      virtual void pushi32(int32_t _7422_v) ;
      virtual void ensuref64(int32_t _7423_n) ;
      virtual void ensurei64(int32_t _7426_n) ;
      virtual void ensurei32(int32_t _7429_n) ;
      virtual int32_t popf64(int32_t _7432_n) ;
      virtual int32_t popi64(int32_t _7433_n) ;
      virtual int32_t popi32(int32_t _7434_n) ;
      virtual void popf64(int32_t _7435_n,std::shared_ptr< monty::ndarray< double,1 > > _7436_r,int32_t _7437_ofs) ;
      virtual void popi64(int32_t _7438_n,std::shared_ptr< monty::ndarray< int64_t,1 > > _7439_r,int32_t _7440_ofs) ;
      virtual void popi32(int32_t _7441_n,std::shared_ptr< monty::ndarray< int32_t,1 > > _7442_r,int32_t _7443_ofs) ;
      virtual double popf64() ;
      virtual int64_t popi64() ;
      virtual int32_t popi32() ;
      virtual double peekf64() ;
      virtual int64_t peeki64() ;
      virtual int32_t peeki32() ;
      virtual double peekf64(int32_t _7444_i) ;
      virtual int64_t peeki64(int32_t _7445_i) ;
      virtual int32_t peeki32(int32_t _7446_i) ;
    }; // struct WorkStack;

    struct p_SymmetricMatrix
    {
      SymmetricMatrix * _pubthis;
      static mosek::fusion::p_SymmetricMatrix* _get_impl(mosek::fusion::SymmetricMatrix * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_SymmetricMatrix * _get_impl(mosek::fusion::SymmetricMatrix::t _inst) { return _get_impl(_inst.get()); }
      p_SymmetricMatrix(SymmetricMatrix * _pubthis);
      virtual ~p_SymmetricMatrix() { /* std::cout << "~p_SymmetricMatrix" << std::endl;*/ };
      int32_t nnz{};
      double scale{};
      std::shared_ptr< monty::ndarray< double,1 > > vval{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > vsubj{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > vsubi{};
      std::shared_ptr< monty::ndarray< double,1 > > uval{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > usubj{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > usubi{};
      int32_t d1{};
      int32_t d0{};

      virtual void destroy();

      static SymmetricMatrix::t _new_SymmetricMatrix(int32_t _8163_dim0,int32_t _8164_dim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _8165_usubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _8166_usubj,std::shared_ptr< monty::ndarray< double,1 > > _8167_uval,std::shared_ptr< monty::ndarray< int32_t,1 > > _8168_vsubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _8169_vsubj,std::shared_ptr< monty::ndarray< double,1 > > _8170_vval,double _8171_scale);
      void _initialize(int32_t _8163_dim0,int32_t _8164_dim1,std::shared_ptr< monty::ndarray< int32_t,1 > > _8165_usubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _8166_usubj,std::shared_ptr< monty::ndarray< double,1 > > _8167_uval,std::shared_ptr< monty::ndarray< int32_t,1 > > _8168_vsubi,std::shared_ptr< monty::ndarray< int32_t,1 > > _8169_vsubj,std::shared_ptr< monty::ndarray< double,1 > > _8170_vval,double _8171_scale);
      static  monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > rankOne(int32_t _8172_n,std::shared_ptr< monty::ndarray< int32_t,1 > > _8173_sub,std::shared_ptr< monty::ndarray< double,1 > > _8174_v);
      static  monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > rankOne(std::shared_ptr< monty::ndarray< double,1 > > _8182_v);
      static  monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > antiDiag(std::shared_ptr< monty::ndarray< double,1 > > _8190_vals);
      static  monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > diag(std::shared_ptr< monty::ndarray< double,1 > > _8197_vals);
      virtual monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > __mosek_2fusion_2SymmetricMatrix__add(monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > _8203_m) ;
      virtual monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > __mosek_2fusion_2SymmetricMatrix__sub(monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > _8223_m) ;
      virtual monty::rc_ptr< ::mosek::fusion::SymmetricMatrix > __mosek_2fusion_2SymmetricMatrix__mul(double _8224_v) ;
      virtual int32_t getdim() ;
    }; // struct SymmetricMatrix;

    struct p_NDSparseArray
    {
      NDSparseArray * _pubthis;
      static mosek::fusion::p_NDSparseArray* _get_impl(mosek::fusion::NDSparseArray * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_NDSparseArray * _get_impl(mosek::fusion::NDSparseArray::t _inst) { return _get_impl(_inst.get()); }
      p_NDSparseArray(NDSparseArray * _pubthis);
      virtual ~p_NDSparseArray() { /* std::cout << "~p_NDSparseArray" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< double,1 > > cof{};
      std::shared_ptr< monty::ndarray< int64_t,1 > > inst{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > dims{};
      int64_t size{};

      virtual void destroy();

      static NDSparseArray::t _new_NDSparseArray(std::shared_ptr< monty::ndarray< int32_t,1 > > _8225_dims_,std::shared_ptr< monty::ndarray< int32_t,2 > > _8226_sub,std::shared_ptr< monty::ndarray< double,1 > > _8227_cof_);
      void _initialize(std::shared_ptr< monty::ndarray< int32_t,1 > > _8225_dims_,std::shared_ptr< monty::ndarray< int32_t,2 > > _8226_sub,std::shared_ptr< monty::ndarray< double,1 > > _8227_cof_);
      static NDSparseArray::t _new_NDSparseArray(std::shared_ptr< monty::ndarray< int32_t,1 > > _8248_dims_,std::shared_ptr< monty::ndarray< int64_t,1 > > _8249_inst_,std::shared_ptr< monty::ndarray< double,1 > > _8250_cof_);
      void _initialize(std::shared_ptr< monty::ndarray< int32_t,1 > > _8248_dims_,std::shared_ptr< monty::ndarray< int64_t,1 > > _8249_inst_,std::shared_ptr< monty::ndarray< double,1 > > _8250_cof_);
      static NDSparseArray::t _new_NDSparseArray(monty::rc_ptr< ::mosek::fusion::Matrix > _8266_m);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Matrix > _8266_m);
      static  monty::rc_ptr< ::mosek::fusion::NDSparseArray > make(monty::rc_ptr< ::mosek::fusion::Matrix > _8274_m);
      static  monty::rc_ptr< ::mosek::fusion::NDSparseArray > make(std::shared_ptr< monty::ndarray< int32_t,1 > > _8275_dims,std::shared_ptr< monty::ndarray< int64_t,1 > > _8276_inst,std::shared_ptr< monty::ndarray< double,1 > > _8277_cof);
      static  monty::rc_ptr< ::mosek::fusion::NDSparseArray > make(std::shared_ptr< monty::ndarray< int32_t,1 > > _8278_dims,std::shared_ptr< monty::ndarray< int32_t,2 > > _8279_sub,std::shared_ptr< monty::ndarray< double,1 > > _8280_cof);
    }; // struct NDSparseArray;

    struct p_Matrix
    {
      Matrix * _pubthis;
      static mosek::fusion::p_Matrix* _get_impl(mosek::fusion::Matrix * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_Matrix * _get_impl(mosek::fusion::Matrix::t _inst) { return _get_impl(_inst.get()); }
      p_Matrix(Matrix * _pubthis);
      virtual ~p_Matrix() { /* std::cout << "~p_Matrix" << std::endl;*/ };
      int32_t dimj{};
      int32_t dimi{};

      virtual void destroy();

      static Matrix::t _new_Matrix(int32_t _8350_di,int32_t _8351_dj);
      void _initialize(int32_t _8350_di,int32_t _8351_dj);
      virtual /* override */ std::string toString() ;
      virtual void switchDims() ;
      static  monty::rc_ptr< ::mosek::fusion::Matrix > diag(int32_t _8353_num,monty::rc_ptr< ::mosek::fusion::Matrix > _8354_mv);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > diag(std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Matrix >,1 > > _8356_md);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > antidiag(int32_t _8374_n,double _8375_val,int32_t _8376_k);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > antidiag(int32_t _8377_n,double _8378_val);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > diag(int32_t _8379_n,double _8380_val,int32_t _8381_k);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > diag(int32_t _8382_n,double _8383_val);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > antidiag(std::shared_ptr< monty::ndarray< double,1 > > _8384_d,int32_t _8385_k);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > antidiag(std::shared_ptr< monty::ndarray< double,1 > > _8395_d);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > diag(std::shared_ptr< monty::ndarray< double,1 > > _8396_d,int32_t _8397_k);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > diag(std::shared_ptr< monty::ndarray< double,1 > > _8405_d);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > ones(int32_t _8406_n,int32_t _8407_m);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > eye(int32_t _8408_n);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > dense(monty::rc_ptr< ::mosek::fusion::Matrix > _8410_other);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > dense(int32_t _8411_dimi,int32_t _8412_dimj,double _8413_value);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > dense(int32_t _8414_dimi,int32_t _8415_dimj,std::shared_ptr< monty::ndarray< double,1 > > _8416_data);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > dense(std::shared_ptr< monty::ndarray< double,2 > > _8417_data);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > sparse(monty::rc_ptr< ::mosek::fusion::Matrix > _8418_mx);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > sparse(std::shared_ptr< monty::ndarray< std::shared_ptr< monty::ndarray< monty::rc_ptr< ::mosek::fusion::Matrix >,1 > >,1 > > _8422_blocks);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > sparse(std::shared_ptr< monty::ndarray< double,2 > > _8453_data);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > sparse(int32_t _8463_nrow,int32_t _8464_ncol);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > sparse(int32_t _8465_nrow,int32_t _8466_ncol,std::shared_ptr< monty::ndarray< int32_t,1 > > _8467_subi,std::shared_ptr< monty::ndarray< int32_t,1 > > _8468_subj,double _8469_val);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > sparse(std::shared_ptr< monty::ndarray< int32_t,1 > > _8471_subi,std::shared_ptr< monty::ndarray< int32_t,1 > > _8472_subj,double _8473_val);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > sparse(std::shared_ptr< monty::ndarray< int32_t,1 > > _8478_subi,std::shared_ptr< monty::ndarray< int32_t,1 > > _8479_subj,std::shared_ptr< monty::ndarray< double,1 > > _8480_val);
      static  monty::rc_ptr< ::mosek::fusion::Matrix > sparse(int32_t _8485_nrow,int32_t _8486_ncol,std::shared_ptr< monty::ndarray< int32_t,1 > > _8487_subi,std::shared_ptr< monty::ndarray< int32_t,1 > > _8488_subj,std::shared_ptr< monty::ndarray< double,1 > > _8489_val);
      virtual double get(int32_t _8494_i,int32_t _8495_j) { throw monty::AbstractClassError("Call to abstract method"); }
      virtual bool isSparse() { throw monty::AbstractClassError("Call to abstract method"); }
      virtual std::shared_ptr< monty::ndarray< double,1 > > getDataAsArray() { throw monty::AbstractClassError("Call to abstract method"); }
      virtual void getDataAsTriplets(std::shared_ptr< monty::ndarray< int32_t,1 > > _8496_subi,std::shared_ptr< monty::ndarray< int32_t,1 > > _8497_subj,std::shared_ptr< monty::ndarray< double,1 > > _8498_val) { throw monty::AbstractClassError("Call to abstract method"); }
      virtual monty::rc_ptr< ::mosek::fusion::Matrix > __mosek_2fusion_2Matrix__transpose() { throw monty::AbstractClassError("Call to abstract method"); }
      virtual int64_t numNonzeros() { throw monty::AbstractClassError("Call to abstract method"); }
      virtual int32_t numColumns() ;
      virtual int32_t numRows() ;
    }; // struct Matrix;

    struct p_DenseMatrix : public ::mosek::fusion::p_Matrix
    {
      DenseMatrix * _pubthis;
      static mosek::fusion::p_DenseMatrix* _get_impl(mosek::fusion::DenseMatrix * _inst){ return static_cast< mosek::fusion::p_DenseMatrix* >(mosek::fusion::p_Matrix::_get_impl(_inst)); }
      static mosek::fusion::p_DenseMatrix * _get_impl(mosek::fusion::DenseMatrix::t _inst) { return _get_impl(_inst.get()); }
      p_DenseMatrix(DenseMatrix * _pubthis);
      virtual ~p_DenseMatrix() { /* std::cout << "~p_DenseMatrix" << std::endl;*/ };
      int64_t nnz{};
      std::shared_ptr< monty::ndarray< double,1 > > data{};

      virtual void destroy();

      static DenseMatrix::t _new_DenseMatrix(int32_t _8281_dimi_,int32_t _8282_dimj_,std::shared_ptr< monty::ndarray< double,1 > > _8283_cof);
      void _initialize(int32_t _8281_dimi_,int32_t _8282_dimj_,std::shared_ptr< monty::ndarray< double,1 > > _8283_cof);
      static DenseMatrix::t _new_DenseMatrix(monty::rc_ptr< ::mosek::fusion::Matrix > _8284_m_);
      void _initialize(monty::rc_ptr< ::mosek::fusion::Matrix > _8284_m_);
      static DenseMatrix::t _new_DenseMatrix(std::shared_ptr< monty::ndarray< double,2 > > _8289_d);
      void _initialize(std::shared_ptr< monty::ndarray< double,2 > > _8289_d);
      static DenseMatrix::t _new_DenseMatrix(int32_t _8292_dimi_,int32_t _8293_dimj_,double _8294_value_);
      void _initialize(int32_t _8292_dimi_,int32_t _8293_dimj_,double _8294_value_);
      virtual /* override */ std::string toString() ;
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Matrix > __mosek_2fusion_2DenseMatrix__transpose() ;
      virtual monty::rc_ptr< ::mosek::fusion::Matrix > __mosek_2fusion_2Matrix__transpose() { return __mosek_2fusion_2DenseMatrix__transpose(); }
      virtual /* override */ bool isSparse() ;
      virtual /* override */ std::shared_ptr< monty::ndarray< double,1 > > getDataAsArray() ;
      virtual /* override */ void getDataAsTriplets(std::shared_ptr< monty::ndarray< int32_t,1 > > _8307_subi,std::shared_ptr< monty::ndarray< int32_t,1 > > _8308_subj,std::shared_ptr< monty::ndarray< double,1 > > _8309_cof) ;
      virtual /* override */ double get(int32_t _8313_i,int32_t _8314_j) ;
      virtual /* override */ int64_t numNonzeros() ;
    }; // struct DenseMatrix;

    struct p_SparseMatrix : public ::mosek::fusion::p_Matrix
    {
      SparseMatrix * _pubthis;
      static mosek::fusion::p_SparseMatrix* _get_impl(mosek::fusion::SparseMatrix * _inst){ return static_cast< mosek::fusion::p_SparseMatrix* >(mosek::fusion::p_Matrix::_get_impl(_inst)); }
      static mosek::fusion::p_SparseMatrix * _get_impl(mosek::fusion::SparseMatrix::t _inst) { return _get_impl(_inst.get()); }
      p_SparseMatrix(SparseMatrix * _pubthis);
      virtual ~p_SparseMatrix() { /* std::cout << "~p_SparseMatrix" << std::endl;*/ };
      int64_t nnz{};
      std::shared_ptr< monty::ndarray< double,1 > > val{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > subj{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > subi{};

      virtual void destroy();

      static SparseMatrix::t _new_SparseMatrix(int32_t _8315_dimi_,int32_t _8316_dimj_,std::shared_ptr< monty::ndarray< int32_t,1 > > _8317_subi_,std::shared_ptr< monty::ndarray< int32_t,1 > > _8318_subj_,std::shared_ptr< monty::ndarray< double,1 > > _8319_val_,int64_t _8320_nelm);
      void _initialize(int32_t _8315_dimi_,int32_t _8316_dimj_,std::shared_ptr< monty::ndarray< int32_t,1 > > _8317_subi_,std::shared_ptr< monty::ndarray< int32_t,1 > > _8318_subj_,std::shared_ptr< monty::ndarray< double,1 > > _8319_val_,int64_t _8320_nelm);
      static SparseMatrix::t _new_SparseMatrix(int32_t _8326_dimi_,int32_t _8327_dimj_,std::shared_ptr< monty::ndarray< int32_t,1 > > _8328_subi_,std::shared_ptr< monty::ndarray< int32_t,1 > > _8329_subj_,std::shared_ptr< monty::ndarray< double,1 > > _8330_val_);
      void _initialize(int32_t _8326_dimi_,int32_t _8327_dimj_,std::shared_ptr< monty::ndarray< int32_t,1 > > _8328_subi_,std::shared_ptr< monty::ndarray< int32_t,1 > > _8329_subj_,std::shared_ptr< monty::ndarray< double,1 > > _8330_val_);
      virtual std::shared_ptr< monty::ndarray< int64_t,1 > > formPtrb() ;
      virtual /* override */ std::string toString() ;
      virtual /* override */ int64_t numNonzeros() ;
      virtual /* override */ monty::rc_ptr< ::mosek::fusion::Matrix > __mosek_2fusion_2SparseMatrix__transpose() ;
      virtual monty::rc_ptr< ::mosek::fusion::Matrix > __mosek_2fusion_2Matrix__transpose() { return __mosek_2fusion_2SparseMatrix__transpose(); }
      virtual /* override */ bool isSparse() ;
      virtual /* override */ std::shared_ptr< monty::ndarray< double,1 > > getDataAsArray() ;
      virtual /* override */ void getDataAsTriplets(std::shared_ptr< monty::ndarray< int32_t,1 > > _8342_subi_,std::shared_ptr< monty::ndarray< int32_t,1 > > _8343_subj_,std::shared_ptr< monty::ndarray< double,1 > > _8344_cof_) ;
      virtual /* override */ double get(int32_t _8345_i,int32_t _8346_j) ;
    }; // struct SparseMatrix;

    struct p_LinkedBlocks
    {
      LinkedBlocks * _pubthis;
      static mosek::fusion::p_LinkedBlocks* _get_impl(mosek::fusion::LinkedBlocks * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_LinkedBlocks * _get_impl(mosek::fusion::LinkedBlocks::t _inst) { return _get_impl(_inst.get()); }
      p_LinkedBlocks(LinkedBlocks * _pubthis);
      virtual ~p_LinkedBlocks() { /* std::cout << "~p_LinkedBlocks" << std::endl;*/ };
      std::shared_ptr< monty::ndarray< int32_t,1 > > bfirst{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > bsize{};
      monty::rc_ptr< ::mosek::fusion::LinkedInts > blocks{};
      monty::rc_ptr< ::mosek::fusion::LinkedInts > ints{};

      virtual void destroy();

      static LinkedBlocks::t _new_LinkedBlocks();
      void _initialize();
      static LinkedBlocks::t _new_LinkedBlocks(int32_t _8524_n);
      void _initialize(int32_t _8524_n);
      static LinkedBlocks::t _new_LinkedBlocks(monty::rc_ptr< ::mosek::fusion::LinkedBlocks > _8526_other);
      void _initialize(monty::rc_ptr< ::mosek::fusion::LinkedBlocks > _8526_other);
      virtual void free(int32_t _8527_bkey) ;
      virtual int32_t alloc(int32_t _8529_size) ;
      virtual int32_t maxidx(int32_t _8534_bkey) ;
      virtual int32_t numallocated() ;
      virtual void get(int32_t _8535_bkey,std::shared_ptr< monty::ndarray< int32_t,1 > > _8536_target,int32_t _8537_offset) ;
      virtual int32_t numblocks() ;
      virtual int32_t blocksize(int32_t _8538_bkey) ;
      virtual int32_t block_capacity() ;
      virtual int32_t capacity() ;
      virtual bool validate() ;
    }; // struct LinkedBlocks;

    struct p_LinkedInts
    {
      LinkedInts * _pubthis;
      static mosek::fusion::p_LinkedInts* _get_impl(mosek::fusion::LinkedInts * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_LinkedInts * _get_impl(mosek::fusion::LinkedInts::t _inst) { return _get_impl(_inst.get()); }
      p_LinkedInts(LinkedInts * _pubthis);
      virtual ~p_LinkedInts() { /* std::cout << "~p_LinkedInts" << std::endl;*/ };
      int32_t nfree{};
      int32_t last_free{};
      int32_t first_free{};
      int32_t first_used{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > prev{};
      std::shared_ptr< monty::ndarray< int32_t,1 > > next{};

      virtual void destroy();

      static LinkedInts::t _new_LinkedInts(int32_t _8539_cap_);
      void _initialize(int32_t _8539_cap_);
      static LinkedInts::t _new_LinkedInts();
      void _initialize();
      static LinkedInts::t _new_LinkedInts(monty::rc_ptr< ::mosek::fusion::LinkedInts > _8542_other);
      void _initialize(monty::rc_ptr< ::mosek::fusion::LinkedInts > _8542_other);
      virtual void free(int32_t _8543_i,int32_t _8544_num) ;
      virtual int32_t alloc() ;
      virtual int32_t alloc(int32_t _8550_n) ;
      virtual void alloc(int32_t _8551_num,std::shared_ptr< monty::ndarray< int32_t,1 > > _8552_target,int32_t _8553_offset) ;
      virtual void get(int32_t _8556_i,int32_t _8557_num,std::shared_ptr< monty::ndarray< int32_t,1 > > _8558_target,int32_t _8559_offset) ;
      virtual int32_t numallocated() ;
      virtual int32_t maxidx(int32_t _8562_i,int32_t _8563_num) ;
      virtual int32_t allocblock(int32_t _8567_num) ;
      virtual void recap(int32_t _8573_ncap) ;
      virtual int32_t capacity() ;
      virtual bool validate() ;
    }; // struct LinkedInts;

    struct p_Parameters
    {
      Parameters * _pubthis;
      static mosek::fusion::p_Parameters* _get_impl(mosek::fusion::Parameters * _inst){ assert(_inst); assert(_inst->_impl); return _inst->_impl; }
      static mosek::fusion::p_Parameters * _get_impl(mosek::fusion::Parameters::t _inst) { return _get_impl(_inst.get()); }
      p_Parameters(Parameters * _pubthis);
      virtual ~p_Parameters() { /* std::cout << "~p_Parameters" << std::endl;*/ };

      virtual void destroy();

      static  void setParameter(monty::rc_ptr< ::mosek::fusion::Model > _8582_M,const std::string &  _8583_name,double _8584_value);
      static  void setParameter(monty::rc_ptr< ::mosek::fusion::Model > _8692_M,const std::string &  _8693_name,int32_t _8694_value);
      static  void setParameter(monty::rc_ptr< ::mosek::fusion::Model > _8802_M,const std::string &  _8803_name,const std::string &  _8804_value);
      static  int32_t string_to_variabletype_value(const std::string &  _9086_v);
      static  int32_t string_to_value_value(const std::string &  _9087_v);
      static  int32_t string_to_streamtype_value(const std::string &  _9088_v);
      static  int32_t string_to_startpointtype_value(const std::string &  _9089_v);
      static  int32_t string_to_stakey_value(const std::string &  _9090_v);
      static  int32_t string_to_sparam_value(const std::string &  _9091_v);
      static  int32_t string_to_solveform_value(const std::string &  _9092_v);
      static  int32_t string_to_soltype_value(const std::string &  _9093_v);
      static  int32_t string_to_solsta_value(const std::string &  _9094_v);
      static  int32_t string_to_solitem_value(const std::string &  _9095_v);
      static  int32_t string_to_simseltype_value(const std::string &  _9096_v);
      static  int32_t string_to_sensitivitytype_value(const std::string &  _9097_v);
      static  int32_t string_to_scalingmethod_value(const std::string &  _9098_v);
      static  int32_t string_to_scalingtype_value(const std::string &  _9099_v);
      static  int32_t string_to_rescodetype_value(const std::string &  _9100_v);
      static  int32_t string_to_rescode_value(const std::string &  _9101_v);
      static  int32_t string_to_prosta_value(const std::string &  _9102_v);
      static  int32_t string_to_problemtype_value(const std::string &  _9103_v);
      static  int32_t string_to_problemitem_value(const std::string &  _9104_v);
      static  int32_t string_to_parametertype_value(const std::string &  _9105_v);
      static  int32_t string_to_foldingmode_value(const std::string &  _9106_v);
      static  int32_t string_to_presolvemode_value(const std::string &  _9107_v);
      static  int32_t string_to_orderingtype_value(const std::string &  _9108_v);
      static  int32_t string_to_optimizertype_value(const std::string &  _9109_v);
      static  int32_t string_to_onoffkey_value(const std::string &  _9110_v);
      static  int32_t string_to_objsense_value(const std::string &  _9111_v);
      static  int32_t string_to_mpsformat_value(const std::string &  _9112_v);
      static  int32_t string_to_miovarseltype_value(const std::string &  _9113_v);
      static  int32_t string_to_mionodeseltype_value(const std::string &  _9114_v);
      static  int32_t string_to_miomode_value(const std::string &  _9115_v);
      static  int32_t string_to_miocontsoltype_value(const std::string &  _9116_v);
      static  int32_t string_to_miodatapermmethod_value(const std::string &  _9117_v);
      static  int32_t string_to_miqcqoreformmethod_value(const std::string &  _9118_v);
      static  int32_t string_to_branchdir_value(const std::string &  _9119_v);
      static  int32_t string_to_iparam_value(const std::string &  _9120_v);
      static  int32_t string_to_iomode_value(const std::string &  _9121_v);
      static  int32_t string_to_internal_iinf_value(const std::string &  _9122_v);
      static  int32_t string_to_internal_dinf_value(const std::string &  _9123_v);
      static  int32_t string_to_inftype_value(const std::string &  _9124_v);
      static  int32_t string_to_iinfitem_value(const std::string &  _9125_v);
      static  int32_t string_to_internal_liinf_value(const std::string &  _9126_v);
      static  int32_t string_to_liinfitem_value(const std::string &  _9127_v);
      static  int32_t string_to_dparam_value(const std::string &  _9128_v);
      static  int32_t string_to_feature_value(const std::string &  _9129_v);
      static  int32_t string_to_dinfitem_value(const std::string &  _9130_v);
      static  int32_t string_to_solformat_value(const std::string &  _9131_v);
      static  int32_t string_to_dataformat_value(const std::string &  _9132_v);
      static  int32_t string_to_symmattype_value(const std::string &  _9133_v);
      static  int32_t string_to_nametype_value(const std::string &  _9134_v);
      static  int32_t string_to_domaintype_value(const std::string &  _9135_v);
      static  int32_t string_to_conetype_value(const std::string &  _9136_v);
      static  int32_t string_to_compresstype_value(const std::string &  _9137_v);
      static  int32_t string_to_callbackcode_value(const std::string &  _9138_v);
      static  int32_t string_to_intpnthotstart_value(const std::string &  _9139_v);
      static  int32_t string_to_simhotstart_value(const std::string &  _9140_v);
      static  int32_t string_to_simdupvec_value(const std::string &  _9141_v);
      static  int32_t string_to_simreform_value(const std::string &  _9142_v);
      static  int32_t string_to_uplo_value(const std::string &  _9143_v);
      static  int32_t string_to_transpose_value(const std::string &  _9144_v);
      static  int32_t string_to_simdegen_value(const std::string &  _9145_v);
      static  int32_t string_to_simprecision_value(const std::string &  _9146_v);
      static  int32_t string_to_mark_value(const std::string &  _9147_v);
      static  int32_t string_to_boundkey_value(const std::string &  _9148_v);
      static  int32_t string_to_basindtype_value(const std::string &  _9149_v);
      static  int32_t string_to_language_value(const std::string &  _9150_v);
    }; // struct Parameters;

  }
}
namespace mosek
{
  namespace fusion
  {
    namespace Utils
    {
      // mosek.fusion.Utils.IntMap from file 'src/fusion/cxx/IntMap_p.h'
      struct p_IntMap
      {
        IntMap * _pubself;
      
        static p_IntMap * _get_impl(IntMap * _inst) { return _inst->_impl.get(); }
      
        p_IntMap(IntMap * _pubself) : _pubself(_pubself) {}
      
        static IntMap::t _new_IntMap() { return new IntMap(); }
      
        ::std::unordered_map<int64_t,int> m;
      
        bool hasItem (int64_t key) { return m.find(key) != m.end(); }
        int  getItem (int64_t key) { return m.find(key)->second; } // will probably throw something or crash of no such key
        void setItem (int64_t key, int val) { m[key] = val; }
      
        std::shared_ptr<monty::ndarray<int64_t,1>> keys()
        {
          size_t size = m.size();
          auto res = std::shared_ptr<monty::ndarray<int64_t,1>>(new monty::ndarray<int64_t,1>(monty::shape((int)size)));
      
          ptrdiff_t i = 0;
          for (auto it = m.begin(); it != m.end(); ++it)
            (*res)[i++] = it->first;
      
          return res;
        }
      
        std::shared_ptr<monty::ndarray<int,1>> values()
        {
          size_t size = m.size();
          auto res = std::shared_ptr<monty::ndarray<int,1>>(new monty::ndarray<int,1>(monty::shape((int)size)));
      
          ptrdiff_t i = 0;
          for (auto it = m.begin(); it != m.end(); ++it)
            (*res)[i++] = it->second;
      
          return res;
        }
      
        IntMap::t clone();
        IntMap::t __mosek_2fusion_2Utils_2IntMap__clone();
      };
      
      
      
      struct p_StringIntMap
      {
        StringIntMap * _pubself;
      
        static p_StringIntMap * _get_impl(StringIntMap * _inst) { return _inst->_impl.get(); }
      
        p_StringIntMap(StringIntMap * _pubself) : _pubself(_pubself) {}
      
        static StringIntMap::t _new_StringIntMap() { return new StringIntMap(); }
      
        ::std::unordered_map<std::string,int> m;
      
        bool hasItem (const std::string & key) { return m.find(key) != m.end(); }
        int  getItem (const std::string & key) { return m.find(key)->second; } // will probably throw something or crash of no such key
        void setItem (const std::string & key, int val) { m[key] = val; }
      
        std::shared_ptr<monty::ndarray<std::string,1>> keys()
        {
          size_t size = m.size();
          auto res = std::shared_ptr<monty::ndarray<std::string,1>>(new monty::ndarray<std::string,1>(monty::shape((int)size)));
      
          ptrdiff_t i = 0;
          for (auto it = m.begin(); it != m.end(); ++it)
            (*res)[i++] = it->first;
      
          return res;
        }
      
        std::shared_ptr<monty::ndarray<int,1>> values()
        {
          size_t size = m.size();
          auto res = std::shared_ptr<monty::ndarray<int,1>>(new monty::ndarray<int,1>(monty::shape((int)size)));
      
          ptrdiff_t i = 0;
          for (auto it = m.begin(); it != m.end(); ++it)
            (*res)[i++] = it->second;
      
          return res;
        }
      
        StringIntMap::t clone();
        StringIntMap::t __mosek_2fusion_2Utils_2StringIntMap__clone();
      };
      // End of file 'src/fusion/cxx/IntMap_p.h'
      // mosek.fusion.Utils.StringBuffer from file 'src/fusion/cxx/StringBuffer_p.h'
      // namespace mosek::fusion::Utils
      struct p_StringBuffer
      {
        StringBuffer * _pubthis;
        std::stringstream ss;
      
        p_StringBuffer(StringBuffer * _pubthis) : _pubthis(_pubthis) {}
      
        static p_StringBuffer * _get_impl(StringBuffer::t ptr) { return ptr->_impl.get(); }
        static p_StringBuffer * _get_impl(StringBuffer * ptr) { return ptr->_impl.get(); }
      
        static StringBuffer::t _new_StringBuffer() { return new StringBuffer(); }
      
        StringBuffer::t clear ();
      
        StringBuffer::t a (const monty::ndarray<std::string,1> & val);
        StringBuffer::t a (const monty::ndarray<int,1> & val);
        StringBuffer::t a (const monty::ndarray<int64_t,1> & val);
        StringBuffer::t a (const monty::ndarray<double,1> & val);
      
      
        StringBuffer::t a (const int & val);
        StringBuffer::t a (const int64_t & val);
        StringBuffer::t a (const double & val);
        StringBuffer::t a (const bool & val);
        StringBuffer::t a (const std::string & val);
      
        StringBuffer::t lf ();
        StringBuffer::t __mosek_2fusion_2Utils_2StringBuffer__clear ();
      
        StringBuffer::t __mosek_2fusion_2Utils_2StringBuffer__a (const monty::ndarray<std::string,1> & val);
        StringBuffer::t __mosek_2fusion_2Utils_2StringBuffer__a (const monty::ndarray<int,1> & val);
        StringBuffer::t __mosek_2fusion_2Utils_2StringBuffer__a (const monty::ndarray<int64_t,1> & val);
        StringBuffer::t __mosek_2fusion_2Utils_2StringBuffer__a (const monty::ndarray<double,1> & val);
      
        StringBuffer::t __mosek_2fusion_2Utils_2StringBuffer__a (const int & val);
        StringBuffer::t __mosek_2fusion_2Utils_2StringBuffer__a (const int64_t & val);
        StringBuffer::t __mosek_2fusion_2Utils_2StringBuffer__a (const double & val);
        StringBuffer::t __mosek_2fusion_2Utils_2StringBuffer__a (const bool & val);
        StringBuffer::t __mosek_2fusion_2Utils_2StringBuffer__a (const std::string & val);
      
        StringBuffer::t __mosek_2fusion_2Utils_2StringBuffer__lf ();
      
        std::string toString () const;
      };
      // End of file 'src/fusion/cxx/StringBuffer_p.h'
    }
  }
}
#endif
