/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion.Utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import mosek.boundkey;
import mosek.fusion.LengthError;
import mosek.fusion.Matrix;
import mosek.fusion.SliceError;
import mosek.fusion.SparseFormatError;
import mosek.fusion.UnexpectedError;
import mosek.stakey;
import mosek.variabletype;

public class Tools {
    private static Random randgen = new Random(12L);

    public static boolean equals(String string, String string2) {
        return string == string2 || string != null && string.equals(string2);
    }

    public static int[] arraycopy(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        System.arraycopy(nArray, n, nArray2, n2, n3);
        return nArray2;
    }

    public static long[] arraycopy(long[] lArray, int n, long[] lArray2, int n2, int n3) {
        System.arraycopy(lArray, n, lArray2, n2, n3);
        return lArray2;
    }

    public static double[] arraycopy(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        System.arraycopy(dArray, n, dArray2, n2, n3);
        return dArray2;
    }

    public static int[] arraycopy(int[] nArray, long l, int[] nArray2, long l2, long l3) {
        System.arraycopy(nArray, (int)l, nArray2, (int)l2, (int)l3);
        return nArray2;
    }

    public static long[] arraycopy(long[] lArray, long l, long[] lArray2, long l2, long l3) {
        System.arraycopy(lArray, (int)l, lArray2, (int)l2, (int)l3);
        return lArray2;
    }

    public static double[] arraycopy(double[] dArray, long l, double[] dArray2, long l2, long l3) {
        System.arraycopy(dArray, (int)l, dArray2, (int)l2, (int)l3);
        return dArray2;
    }

    public static double[] arraycopy(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    public static int[] arraycopy(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static long[] arraycopy(long[] lArray) {
        long[] lArray2 = new long[lArray.length];
        System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
        return lArray2;
    }

    public static String[] arraycopy(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    public static int matrixwidth(double[][] dArray) {
        return dArray[0].length;
    }

    public static int matrixheight(double[][] dArray) {
        return dArray.length;
    }

    public static int matrixwidth(Matrix[][] matrixArray) {
        return matrixArray[0].length;
    }

    public static int matrixheight(Matrix[][] matrixArray) {
        return matrixArray.length;
    }

    public static int[] range(int n, int n2) {
        if (n <= n2) {
            int[] nArray = new int[n2 - n];
            int n3 = n;
            int n4 = 0;
            while (n3 < n2) {
                nArray[n4] = n3++;
                ++n4;
            }
            return nArray;
        }
        int[] nArray = new int[n - n2];
        int n5 = n;
        int n6 = 0;
        while (n5 > n2) {
            nArray[n6] = n5--;
            ++n6;
        }
        return nArray;
    }

    public static int[] range(int n) {
        return Tools.range(0, n);
    }

    public static int[] range(int n, int n2, int n3) {
        if (n < n2 && n3 > 0) {
            int[] nArray = new int[(n2 - n - 1) / n3 + 1];
            int n4 = 0;
            for (int i = n; i < n2; i += n3) {
                nArray[n4] = i;
                ++n4;
            }
            return nArray;
        }
        if (n < n2 && n3 < 0) {
            int[] nArray = new int[(n - n2 - 1) / -n3 + 1];
            int n5 = 0;
            for (int i = n; i < n2; i += n3) {
                nArray[n5] = i;
                ++n5;
            }
            return nArray;
        }
        if (n == n2) {
            return new int[0];
        }
        throw new UnexpectedError("invalid integer range specified");
    }

    public static long[] range(long l, long l2) {
        if (l <= l2) {
            long[] lArray = new long[(int)(l2 - l)];
            long l3 = l;
            int n = 0;
            while (l3 < l2) {
                lArray[n] = l3++;
                ++n;
            }
            return lArray;
        }
        long[] lArray = new long[(int)(l - l2)];
        long l4 = l;
        int n = 0;
        while (l4 > l2) {
            lArray[n] = l4--;
            ++n;
        }
        return lArray;
    }

    public static long[] range(long l) {
        return Tools.range(0L, l);
    }

    public static long[] range(long l, long l2, long l3) {
        if (l < l2 && l3 > 0L) {
            long[] lArray = new long[(int)((l2 - l - 1L) / l3) + 1];
            int n = 0;
            for (long i = l; i < l2; i += l3) {
                lArray[n] = i;
                ++n;
            }
            return lArray;
        }
        if (l < l2 && l3 < 0L) {
            long[] lArray = new long[(int)((l - l2 - 1L) / -l3) + 1];
            int n = 0;
            for (long i = l; i < l2; i += l3) {
                lArray[n] = i;
                ++n;
            }
            return lArray;
        }
        if (l == l2) {
            return new long[0];
        }
        throw new UnexpectedError("invalid integer range specified");
    }

    public static int[] repeatrange(int n, int n2, int n3) {
        if (n >= n2) {
            throw new UnexpectedError("invalid integer range specified");
        }
        int[] nArray = new int[(n2 - n) * n3];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = 0;
            int n6 = n;
            while (n6 < n2) {
                nArray[n4] = n6++;
                ++n5;
                ++n4;
            }
        }
        return nArray;
    }

    public static long[] repeatrange(long l, long l2, long l3) {
        if (l >= l2) {
            throw new UnexpectedError("invalid integer range specified");
        }
        long[] lArray = new long[(int)((l2 - l) * l3)];
        int n = 0;
        for (long i = 0L; i < l3; ++i) {
            long l4 = 0L;
            long l5 = l;
            while (l5 < l2) {
                lArray[n] = l5++;
                ++l4;
                ++n;
            }
        }
        return lArray;
    }

    public static int[] repeat(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length * n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            System.arraycopy(nArray, 0, nArray2, n3, nArray.length);
            ++n2;
            n3 += nArray.length;
        }
        return nArray2;
    }

    public static double[] repeat(double[] dArray, int n) {
        double[] dArray2 = new double[dArray.length * n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            System.arraycopy(dArray, 0, dArray2, n3, dArray.length);
            ++n2;
            n3 += dArray.length;
        }
        return dArray2;
    }

    public static String[] copy(String[] stringArray) {
        if (stringArray != null) {
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            return stringArray2;
        }
        return null;
    }

    public static int[] vector(int n, int n2) {
        int[] nArray = new int[n];
        Arrays.fill(nArray, n2);
        return nArray;
    }

    public static double[] vector(int n, double d) {
        double[] dArray = new double[n];
        Arrays.fill(dArray, d);
        return dArray;
    }

    public static boundkey[] vector(int n, boundkey boundkey2) {
        boundkey[] boundkeyArray = new boundkey[n];
        Arrays.fill((Object[])boundkeyArray, (Object)boundkey2);
        return boundkeyArray;
    }

    public static variabletype[] vector(int n, variabletype variabletype2) {
        variabletype[] variabletypeArray = new variabletype[n];
        Arrays.fill((Object[])variabletypeArray, (Object)variabletype2);
        return variabletypeArray;
    }

    public static double[] neg(double[] dArray) {
        if (dArray != null) {
            double[] dArray2 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[i] = -dArray2[i];
            }
            return dArray2;
        }
        return null;
    }

    public static double[] plus(double[] dArray, double[] dArray2) throws LengthError {
        if (dArray.length != dArray2.length) {
            throw new LengthError("Mismathcing lengths of lhs and lhs");
        }
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] + dArray2[i];
        }
        return dArray3;
    }

    public static double[] minus(double[] dArray, double[] dArray2) throws LengthError {
        if (dArray.length != dArray2.length) {
            throw new LengthError("Mismathcing lengths of lhs and lhs");
        }
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] - dArray2[i];
        }
        return dArray3;
    }

    public static double[] ones(int n) {
        double[] dArray = new double[n];
        Arrays.fill(dArray, 1.0);
        return dArray;
    }

    public static double[] unfold(double[][] dArray) {
        double[] dArray2 = new double[dArray.length * dArray[0].length];
        int n = 0;
        int n2 = 0;
        while (n < dArray.length) {
            System.arraycopy(dArray[n], 0, dArray2, n2, dArray[n].length);
            n2 += dArray[++n].length;
        }
        return dArray2;
    }

    public static double[] zeros(int n) {
        return new double[n];
    }

    public static double[] makevector(double d, int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
        return dArray;
    }

    public static long[] makevector(long l, int n) {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = l;
        }
        return lArray;
    }

    public static int[] makevector(int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
        }
        return nArray;
    }

    public static String stringvalue(int n) {
        Integer n2 = n;
        return n2.toString();
    }

    public static String stringvalue(long l) {
        Long l2 = l;
        return l2.toString();
    }

    public static String joinvals(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            stringBuilder.append(',');
            stringBuilder.append(nArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String joinvals(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(',');
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static double[] vectoradd(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] + dArray2[i];
        }
        return dArray3;
    }

    public static double[] vectorsub(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] - dArray2[i];
        }
        return dArray3;
    }

    public static double[] vectorneg(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = -dArray[i];
        }
        return dArray2;
    }

    public static int[] nzindexes(double[] dArray) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            ++n;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            nArray[n2++] = i;
        }
        return nArray;
    }

    public static double[] take(int[] nArray, double[] dArray) {
        double[] dArray2 = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray2[i] = dArray[nArray[i]];
        }
        return dArray2;
    }

    public static int[] take(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = nArray2[nArray[i]];
        }
        return nArray3;
    }

    public static double[][] zeros(int n, int n2) {
        return new double[n][n2];
    }

    public static void take(int[] nArray, double[] dArray, double[] dArray2, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            dArray2[n + i] = dArray[nArray[i]];
        }
    }

    public static stakey[] take(int[] nArray, stakey[] stakeyArray) {
        stakey[] stakeyArray2 = new stakey[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stakeyArray2[i] = stakeyArray[nArray[i]];
        }
        return stakeyArray2;
    }

    public static void take(int[] nArray, stakey[] stakeyArray, stakey[] stakeyArray2, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            stakeyArray2[i] = stakeyArray[nArray[i]];
        }
    }

    public static void putvalues(double[] dArray, double[] dArray2, int[] nArray) {
        for (int i = 0; i < dArray2.length; ++i) {
            dArray[nArray[i]] = dArray2[i];
        }
    }

    public static void putvalues(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i < nArray2.length; ++i) {
            nArray[nArray3[i]] = nArray2[i];
        }
    }

    public static int max(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static double max(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public static int min(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] >= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static double min(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] < d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public static void sort(int[] nArray, int n, int n2) {
        Arrays.sort(nArray, n, n2);
    }

    public static void sort(long[] lArray, int n, int n2) {
        Arrays.sort(lArray, n, n2);
    }

    public static int randInt(int n) {
        return randgen.nextInt(n);
    }

    public static double[] slice(double[] dArray, int n, int n2) throws SliceError {
        if (n < 0 || n >= n2 || n2 > dArray.length) {
            throw new SliceError();
        }
        double[] dArray2 = new double[n2 - n];
        System.arraycopy(dArray, n, dArray2, 0, n2 - n);
        return dArray2;
    }

    public static int[] slice(int[] nArray, int n, int n2) throws SliceError {
        if (n < 0 || n >= n2 || n2 > nArray.length) {
            throw new SliceError();
        }
        int[] nArray2 = new int[n2 - n];
        System.arraycopy(nArray, n, nArray2, 0, n2 - n);
        return nArray2;
    }

    public static double[] flatten(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[] dArray2 = new double[n2 * n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            System.arraycopy(dArray[n3], 0, dArray2, n4, n2);
            ++n3;
            n4 += n2;
        }
        return dArray2;
    }

    public static double[] realloc(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        if (dArray != null) {
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length < n ? dArray.length : n);
        }
        return dArray2;
    }

    public static int[] realloc(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        if (nArray != null) {
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length < n ? nArray.length : n);
        }
        return nArray2;
    }

    public static String join(char c, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(',');
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String join(String[] stringArray) {
        return Tools.join(',', stringArray);
    }

    public static String join(char c, double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(dArray[0]);
        for (int i = 1; i < dArray.length; ++i) {
            stringBuilder.append(',');
            stringBuilder.append(dArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String join(double[] dArray) {
        return Tools.join(',', dArray);
    }

    public static String join(char c, int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            stringBuilder.append(',');
            stringBuilder.append(nArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String join(int[] nArray) {
        return Tools.join(',', nArray);
    }

    public static int[] concatenate(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray2.length + nArray.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    public static double[] concatenate(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray2.length + dArray.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray3, dArray.length, dArray2.length);
        return dArray3;
    }

    public static void __checksparseformat(int[] nArray, int[] nArray2, double[] dArray) throws SparseFormatError {
        if (nArray2 == null || dArray == null) {
            throw new SparseFormatError("sub or cof is zero");
        }
        if (nArray2.length != dArray.length) {
            throw new SparseFormatError("sub/cof lengths mismatch");
        }
        if (nArray[nArray.length - 1] != dArray.length) {
            throw new SparseFormatError("invalid last index " + nArray[nArray.length - 1] + " in ptrb");
        }
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i - 1] >= dArray.length) {
                throw new SparseFormatError("invalid index in ptrb");
            }
            if (nArray[i - 1] > nArray[i]) {
                throw new SparseFormatError("ptrb not sorted");
            }
            for (int j = nArray[i - 1] + 1; j < nArray[i]; ++j) {
                if (nArray2[j - 1] <= nArray2[j]) continue;
                throw new SparseFormatError("sub not sorted in row " + i);
            }
        }
    }

    public static int toInt(String string) {
        return Integer.parseInt(string);
    }

    public static double toDouble(String string) {
        return Double.parseDouble(string);
    }

    public static double sqrt(double d) {
        return Math.sqrt(d);
    }

    public static void argsort(long[] lArray, final int[] nArray, long l, long l2) {
        if (l2 - l > 1L) {
            int n;
            int n2 = (int)(l2 - l);
            int n3 = (int)l;
            Integer[] integerArray = new Integer[n2];
            for (n = 0; n < n2; ++n) {
                integerArray[n] = (int)lArray[n + n3];
            }
            Arrays.sort(integerArray, new Comparator<Integer>(){

                @Override
                public int compare(Integer n, Integer n2) {
                    return nArray[n] < nArray[n2] ? -1 : (nArray[n] > nArray[n2] ? 1 : 0);
                }
            });
            for (n = 0; n < n2; ++n) {
                lArray[n + n3] = integerArray[n].intValue();
            }
        }
    }

    public static void argsort(long[] lArray, final long[] lArray2, long l, long l2) {
        if (l2 - l > 1L) {
            int n;
            int n2 = (int)(l2 - l);
            int n3 = (int)l;
            Integer[] integerArray = new Integer[n2];
            for (n = 0; n < n2; ++n) {
                integerArray[n] = (int)lArray[n + n3];
            }
            Arrays.sort(integerArray, new Comparator<Integer>(){

                @Override
                public int compare(Integer n, Integer n2) {
                    return lArray2[n] < lArray2[n2] ? -1 : (lArray2[n] > lArray2[n2] ? 1 : 0);
                }
            });
            for (n = 0; n < n2; ++n) {
                lArray[n + n3] = integerArray[n].intValue();
            }
        }
    }

    public static void argsort(long[] lArray, final int[] nArray, final int[] nArray2, long l, long l2) {
        if (l2 - l > 1L) {
            int n;
            int n2 = (int)(l2 - l);
            int n3 = (int)l;
            Integer[] integerArray = new Integer[n2];
            for (n = 0; n < n2; ++n) {
                integerArray[n] = (int)lArray[n + n3];
            }
            Arrays.sort(integerArray, new Comparator<Integer>(){

                @Override
                public int compare(Integer n, Integer n2) {
                    return nArray[n] == nArray[n2] ? (nArray2[n] < nArray2[n2] ? -1 : (nArray2[n] > nArray2[n2] ? 1 : 0)) : (nArray[n] < nArray[n2] ? -1 : 1);
                }
            });
            for (n = 0; n < n2; ++n) {
                lArray[n + n3] = integerArray[n].intValue();
            }
        }
    }

    public static void argsort(long[] lArray, final long[] lArray2, final long[] lArray3, long l, long l2) {
        if (l2 - l > 1L) {
            int n;
            int n2 = (int)(l2 - l);
            int n3 = (int)l;
            Integer[] integerArray = new Integer[n2];
            for (n = 0; n < n2; ++n) {
                integerArray[n] = (int)lArray[n + n3];
            }
            Arrays.sort(integerArray, new Comparator<Integer>(){

                @Override
                public int compare(Integer n, Integer n2) {
                    return lArray2[n] == lArray2[n2] ? (lArray3[n] < lArray3[n2] ? -1 : (lArray3[n] > lArray3[n2] ? 1 : 0)) : (lArray2[n] < lArray2[n2] ? -1 : 1);
                }
            });
            for (n = 0; n < n2; ++n) {
                lArray[n + n3] = integerArray[n].intValue();
            }
        }
    }

    public static void bucketsort(long[] lArray, long l, long l2, int[] nArray, int n, int n2) {
        int n3 = (int)l;
        int n4 = (int)l2;
        if (l2 - l > 1L) {
            int n5 = n2 - n + 1;
            long l3 = l2 - l;
            int[] nArray2 = new int[n5 + 1];
            long[] lArray2 = new long[(int)l3];
            int n6 = 0;
            while ((long)n6 < l3) {
                int n7 = nArray[(int)lArray[n6 + n3]] - n + 1;
                nArray2[n7] = nArray2[n7] + 1;
                ++n6;
            }
            for (n6 = 2; n6 < n5; ++n6) {
                int n8 = n6;
                nArray2[n8] = nArray2[n8] + nArray2[n6 - 1];
            }
            n6 = 0;
            while ((long)n6 < l3) {
                int n9 = nArray[(int)lArray[n6 + n3]] - n;
                int n10 = nArray2[n9];
                nArray2[n9] = n10 + 1;
                lArray2[n10] = lArray[n6 + n3];
                ++n6;
            }
            System.arraycopy(lArray2, 0, lArray, n3, n4 - n3);
        }
    }

    public static void bucketsort(long[] lArray, long l, long l2, long[] lArray2, long l3, long l4) {
        if (l2 - l > 1L) {
            int n = (int)(l4 - l3 + 1L);
            long l5 = l2 - l;
            int[] nArray = new int[n + 1];
            long[] lArray3 = new long[(int)(l2 - l)];
            int n2 = (int)l;
            int n3 = (int)l2;
            int n4 = 0;
            while ((long)n4 < l5) {
                int n5 = (int)(lArray2[(int)lArray[n4 + n2]] - l3 + 1L);
                nArray[n5] = nArray[n5] + 1;
                ++n4;
            }
            for (n4 = 2; n4 < n; ++n4) {
                int n6 = n4;
                nArray[n6] = nArray[n6] + nArray[n4 - 1];
            }
            n4 = 0;
            while ((long)n4 < l5) {
                int n7 = (int)(lArray2[(int)lArray[n4 + n2]] - l3);
                int n8 = nArray[n7];
                nArray[n7] = n8 + 1;
                lArray3[n8] = lArray[n4 + n2];
                ++n4;
            }
            System.arraycopy(lArray3, 0, lArray, n2, n3 - n2);
        }
    }
}

